#include "psiplugin.h"
#include "optionaccessor.h"
#include "optionaccessinghost.h"
#include "shortcutaccessor.h"
#include "shortcutaccessinghost.h"
#include "plugininfoprovider.h"

#include "screenshot.h"
#include <QtGui>

#define constUrl "url"
#define constShortCut "shortCut"
#define constFormat "format"
#define constFileName "fileName"
#define constLogin "login"
#define constPass "pass"

class ScreenshotPlugin : public QObject, public PsiPlugin, public OptionAccessor, public ShortcutAccessor, public PluginInfoProvider
{
	Q_OBJECT
	Q_INTERFACES(PsiPlugin OptionAccessor ShortcutAccessor PluginInfoProvider)

public:
	ScreenshotPlugin();
	~ScreenshotPlugin();

	virtual QString name() const;
	virtual QString shortName() const;
	virtual QString version() const;
	virtual QWidget* options();
	virtual bool enable();
	virtual bool disable();

	// OptionAccessor
	virtual void setOptionAccessingHost(OptionAccessingHost* host);
	virtual void optionChanged(const QString& option);

	// ShortcutsAccessor
	virtual void setShortcutAccessingHost(ShortcutAccessingHost* host);
	virtual void setShortcuts();

	virtual void applyOptions();
	virtual void restoreOptions();

	virtual QString pluginInfo();

private:
	bool enabled_;
	Screenshot *screenshot;
	OptionAccessingHost* psiOptions;
	ShortcutAccessingHost* psiShortcuts;

	QString url;
	QString shortCut;
	QString format;
	QString fileName;

	QLineEdit *editUrl;
	QLineEdit *editShortCut;
	QLineEdit *editFormat;
	QLineEdit *editFileName;

        QLineEdit *editLogin;
        QLineEdit *editPass;
        QString Login;
        QString Pass;

private slots:
        void editPassChanged();

    };

Q_EXPORT_PLUGIN(ScreenshotPlugin);

ScreenshotPlugin::ScreenshotPlugin()
{
	enabled_ = false;
	screenshot = 0;
	psiOptions = 0;

	url = "";
	editUrl = 0;

	shortCut = "Alt+Ctrl+p";
	editShortCut = 0;

	format = "png";
	editFormat = 0;

	fileName = "pic-yyyyMMdd-hhmmss";
	editFileName= 0;

        editLogin = 0;
        editPass = 0;
        Login = "";
        Pass = "";
}

ScreenshotPlugin::~ScreenshotPlugin()
{
	disable();
}

QString ScreenshotPlugin::name() const
{
	return "Screenshot Plugin";
}

QString ScreenshotPlugin::shortName() const
{
	return "Screenshot";
}

QString ScreenshotPlugin::version() const
{
	return "0.2.4";
}

QWidget* ScreenshotPlugin::options()
{
	if (!enabled_) {
		return 0;
	}
	QWidget *optionsWid = new QWidget();

	editUrl= new QLineEdit(optionsWid);
	editShortCut= new QLineEdit(optionsWid);
	editFormat = new QLineEdit(optionsWid);
	editFileName= new QLineEdit(optionsWid);
        editLogin = new QLineEdit(optionsWid);
        editPass = new QLineEdit(optionsWid);

	editUrl->setText(url);
	editShortCut->setText(shortCut);
	editFormat->setText(format);
	editFileName->setText(fileName);
        editLogin->setText(Login);
        editPass->setText(Pass);
        editPassChanged();

	QGridLayout *layout = new QGridLayout(optionsWid);
	layout->addWidget(new QLabel(tr("ShortCut:"), optionsWid), 0, 0);
	layout->addWidget(editShortCut, 0, 1);
	layout->addWidget(new QLabel(tr("Format:"), optionsWid), 1, 0);
	layout->addWidget(editFormat, 1, 1);
	layout->addWidget(new QLabel(tr("File Name:"), optionsWid), 2, 0);
	layout->addWidget(editFileName, 2, 1);
	layout->addWidget(new QLabel("Url:", optionsWid), 3, 0);
	layout->addWidget(editUrl, 3, 1);
        layout->addWidget(new QLabel("Login:", optionsWid), 4, 0);
        layout->addWidget(editLogin, 4, 1);
        layout->addWidget(new QLabel("Password:", optionsWid), 5, 0);
        layout->addWidget(editPass, 5, 1);
        QLabel *wikiLink = new QLabel(tr("<a href=\"http://code.google.com/p/psi-dev/wiki/plugins#Screenshot_Plugin\">Wiki (Online)</a>"));
        wikiLink->setOpenExternalLinks(true);
        layout->addWidget(wikiLink);
       // connect(editPass, SIGNAL(textChanged(QString)), this, SLOT(editPassChanged()));
	return optionsWid;
}

bool ScreenshotPlugin::enable()
{
	if (!screenshot) {

		//Read default values
		QVariant vUrl(url);
		vUrl= psiOptions->getPluginOption(constUrl);
		if (!vUrl.isNull()) {
			url= vUrl.toString();
		}

                QVariant vLogin(Login);
                vLogin= psiOptions->getPluginOption(constLogin);
                if (!vLogin.isNull()) {
                        Login= vLogin.toString();
                }

                QVariant vPass(Pass);
                vPass= psiOptions->getPluginOption(constPass);
                if (!vPass.isNull()) {
                        Pass= vPass.toString();
                }

		QVariant vShortCut(shortCut);
		vShortCut= psiOptions->getPluginOption(constShortCut);
		if (!vShortCut.isNull()) {
			shortCut = vShortCut.toString();
		}

		QVariant vFormat(format);
		vFormat= psiOptions->getPluginOption(constFormat);
		if (!vFormat.isNull()) {
			format = vFormat.toString();
		}

		QVariant vFileName(fileName);
		vFileName= psiOptions->getPluginOption(constFileName);
		if (!vFileName.isNull()) {
			fileName = vFileName.toString();
		}

                QString Url = "";
                if(!Login.isEmpty() && !Pass.isEmpty() && !url.isEmpty()) {
                    if(url.contains("ftp://")) {
                        url=url.remove("ftp://");
                    }
                    Url = "ftp://"+Login+":"+Pass+"@"+url;
                }

                screenshot = new Screenshot(Url, fileName, format);
	}
	psiShortcuts->connectShortcut(QKeySequence(shortCut), screenshot, SLOT(shootScreen()));
	enabled_ = true;
	return true;
}

bool ScreenshotPlugin::disable()
{
	if (screenshot) {
		psiShortcuts->disconnectShortcut(QKeySequence(shortCut), screenshot, SLOT(shootScreen()));
		delete screenshot;
		screenshot = 0;
	}
	enabled_ = false;
	return true;
}

void ScreenshotPlugin::setOptionAccessingHost(OptionAccessingHost* host)
{
	psiOptions = host;
}

void ScreenshotPlugin::optionChanged(const QString& option)
{
	Q_UNUSED(option);
}

void ScreenshotPlugin::setShortcutAccessingHost(ShortcutAccessingHost* host)
{
	psiShortcuts = host;
}

void ScreenshotPlugin::setShortcuts()
{
	if (screenshot) {
		psiShortcuts->connectShortcut(QKeySequence(shortCut), screenshot, SLOT(shootScreen()));
	}
}

void ScreenshotPlugin::applyOptions() {
        if (!editUrl || !editShortCut || !editFormat || !editFileName || !editLogin || !editPass) {
		return;
	}
	QVariant vUrl(editUrl->text());
	psiOptions->setPluginOption(constUrl, vUrl);
	url = vUrl.toString();

        QVariant vLogin(editLogin->text());
        psiOptions->setPluginOption(constLogin, vLogin);
        Login = vLogin.toString();

        QVariant vPass(editPass->text());
        if(vPass.toString().count("*") != vPass.toString().length()) {
            psiOptions->setPluginOption(constPass, vPass);
            Pass = vPass.toString();
            editPassChanged();
        }

	QVariant vShortCut(editShortCut->text());
	psiOptions->setPluginOption(constShortCut, vShortCut);
	psiShortcuts->disconnectShortcut(QKeySequence(shortCut), screenshot, SLOT(shootScreen()));
	shortCut = vShortCut.toString();

	QVariant vFormat(editFormat->text());
	psiOptions->setPluginOption(constFormat, vFormat);
	format = vFormat.toString();

	QVariant vFileName(editFileName->text());
	psiOptions->setPluginOption(constFileName, vFileName);
	fileName = vFileName.toString();

         QString Url = "";         
         if(!Login.isEmpty() && !Pass.isEmpty() && !url.isEmpty()) {
             if(url.contains("ftp://")) {
                        url=url.remove("ftp://");
                    }
             Url = "ftp://"+Login+":"+Pass+"@"+url;
         }

        screenshot->setUrl(Url);
	screenshot->setFormat(format);
	screenshot->setFileNameFormat(fileName);
	setShortcuts();
}

void ScreenshotPlugin::restoreOptions() {
        if (!editUrl || !editShortCut || !editFormat || !editFileName || !editLogin || !editPass) {
		return;
	}
	QVariant vUrl(editUrl->text());
	vUrl = psiOptions->getPluginOption(constUrl);
	editUrl->setText(vUrl.toString());

        QVariant vLogin(editLogin->text());
        vLogin = psiOptions->getPluginOption(constLogin);
        editLogin->setText(vLogin.toString());

        QVariant vPass(editPass->text());
        vPass = psiOptions->getPluginOption(constPass);
        editPass->setText(vPass.toString());
        editPassChanged();

	QVariant vShortCut(editShortCut->text());
	vShortCut = psiOptions->getPluginOption(constShortCut);
	if (!vShortCut.isNull()) {
		editShortCut->setText(vShortCut.toString());
	}

	QVariant vFormat(editFormat->text());
	vFormat= psiOptions->getPluginOption(constFormat);
	if (!vFormat.isNull()) {
		editFormat->setText(vFormat.toString());
	}

	QVariant vFileName(editFileName->text());
	vFileName= psiOptions->getPluginOption(constFileName);
	if (!vFileName.isNull()) {
		editFileName->setText(vFileName.toString());
	}
}

void ScreenshotPlugin::editPassChanged() {
    QString text = editPass->text();
    text.replace(QRegExp("."), "*");
    editPass->setText(text);
}

QString ScreenshotPlugin::pluginInfo() {
	return tr("Author: ") +  "C.H.\n\n"
			+ trUtf8("This plugin allows you to make screenshots and save them to your hard drive or upload them to an FTP server.\n"
			 "The plugin has the following settings:\n"
			 "* Shortcut -- hotkey to make the screenshot (by default, Ctrl+Alt+P)\n"
			 "* Format -- the file format in which the screenshot will be stored (default: .png)\n"
			 "* File Name -- format of the filename (default: pic-yyyyMMdd-hhmmss, where yyyyMMdd=YYYYMMDD, and hhmmss are current date in the format yearmonthday-hourminutesecond)\n"
			 "* Url -- the FTP server address, to which the screenshot will be uploaded\n"
			 "* Login -- FTP server username\n"
			 "* Password -- FTP server password \n\n"
		     "The address of FTP server is specified as ftp://ftp.domain.tld/path1/path2 or as ftp.domain.tld/path1/path2\n\n"
		     "Note: If you do not specify one of the parameters, Url, Login, Password, then the image file will be saved to local disk.");
}

#include "screenshotplugin.moc"
