#ifndef TYPEAHEADFIND_H
#define TYPEAHEADFIND_H

#include <QToolBar>
#include <QTextEdit>

#include "iconfactoryaccessinghost.h"

class TypeAheadFindBar : public QToolBar
{
	Q_OBJECT
public:
        TypeAheadFindBar(IconFactoryAccessingHost *IcoHost, QTextEdit *textedit, const QString &title, QWidget *parent = 0);

	~TypeAheadFindBar();
	void init();

signals:
        void firstPage();
        void lastPage();
        void nextPage();
        void prevPage();

private slots:
	void textChanged(const QString &);
	void findNext();
	void findPrevious();
        void caseToggled();

private:
	class Private;
	Private *d;
        IconFactoryAccessingHost *icoHost_;
};

#endif
