#include "captchadialog.h"

CaptchaDialog::CaptchaDialog(QString id, QWidget *p)
	: QDialog(p)
	, id_(id)
{
	setAttribute(Qt::WA_DeleteOnClose);
	ui_.setupUi(this);
	toggleTEVisible(false);

	connect(ui_.buttonBox, SIGNAL(accepted()), SLOT(okPressed()));
	connect(ui_.buttonBox, SIGNAL(rejected()), SLOT(cancelPressed()));
	connect(ui_.cb_message, SIGNAL(toggled(bool)), SLOT(toggleTEVisible(bool)));
}

void CaptchaDialog::setQuestion(const QString &quest)
{
	ui_.lb_question->setText(quest);
	adjustSize();
}

void CaptchaDialog::toggleTEVisible(bool b)
{
	ui_.textEdit->setVisible(b);
	adjustSize();
}

void CaptchaDialog::setPixmap(const QPixmap &pix)
{
	ui_.lb_image->setText("");
	ui_.lb_image->setFixedSize(pix.size());
	ui_.lb_image->setPixmap(pix);
	adjustSize();
}

void CaptchaDialog::setText(const QString &text)
{
	ui_.lb_image->setText(text);
	adjustSize();
}

void CaptchaDialog::setBody(const QString &body)
{
	ui_.textEdit->setPlainText(body);
}

void CaptchaDialog::okPressed()
{
	QString text = ui_.le_answer->text();
	if(text.isEmpty())
		emit cancel(id_);
	else
		emit ok(id_, text);

	close();
}
void CaptchaDialog::cancelPressed()
{
	emit cancel(id_);
	close();
}
