#include "view.h"

#include <QHeaderView>

void Viewer::init()
{
        setSelectionBehavior(QAbstractItemView::SelectRows);
        resizeColumnsToContents();
        horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
        horizontalHeader()->setStretchLastSection(true);
        verticalHeader()->setDefaultAlignment( Qt::AlignHCenter );
        setMinimumHeight(150);
        setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Preferred);

        connect(this, SIGNAL(clicked(QModelIndex)), this, SLOT(itemClicked(QModelIndex)));
}

void Viewer::itemClicked(QModelIndex index)
{
    if(index.column() == 0)
        model()->setData(currentIndex(), 3); //invert
}
