#include "notesviewdelegate.h"
#include "tagsmodel.h"

NotesViewDelegate::~NotesViewDelegate()
{
}

QSize NotesViewDelegate::sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const
{
    if(index.isValid())  {
        QSize size = QItemDelegate::sizeHint(option, index);
        size.setWidth(size.width()/2);
        return size;
    }

    return QSize(0, 0);
}

void NotesViewDelegate::paint ( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const
{
    QRect rect = option.rect;
    QString text = index.data(NoteModel::NoteRole).toString();
    QString title = index.data(NoteModel::TitleRole).toString();
    QString tags = index.data(NoteModel::TagRole).toString();
    painter->save();

    QPalette palette = option.palette;
    QColor c = (option.state & QStyle::State_Selected) ?
                 palette.color(QPalette::Highlight) : palette.color(QPalette::Base);

    painter->fillRect(rect, c);

    QPalette::ColorGroup cg = option.state & QStyle::State_Enabled
                                  ? QPalette::Normal : QPalette::Disabled;


    if (option.state & QStyle::State_Selected) {
                painter->setPen(palette.color(cg, QPalette::HighlightedText));
    }
    else {
                painter->setPen(palette.color(cg, QPalette::Text));
   }
    QRect r(rect);

    QFontMetrics fm = option.fontMetrics;
    QFont font = option.font;

    if(!title.isEmpty()) {
        r.setHeight(fm.height());
        font.setBold(true);
        painter->setFont(font);
        painter->drawText(r, Qt::AlignLeft, title);        
    }

    if(!tags.isEmpty()) {
        r.moveTo(r.bottomLeft());
        r.setHeight(fm.height());
        font.setBold(false);
        font.setItalic(true);
        font.setUnderline(true);
        painter->setFont(font);
        painter->drawText(r, Qt::AlignLeft, tags);
    }

    if(!title.isEmpty() || !tags.isEmpty()) {
        r.setTop(r.bottom());
        r.setBottom(rect.bottom());
    }

    font.setBold(false);
    font.setItalic(false);
    font.setUnderline(false);
    painter->setFont(font);
    painter->drawText(r, Qt::AlignLeft, text);

    painter->drawLine(rect.topRight(), rect.topLeft());
    painter->drawLine(rect.bottomRight(), rect.bottomLeft());

    painter->restore();
}
