/*
 * mainwin_p.h - classes used privately by the main window.
 * Copyright (C) 2001-2003  Justin Karneges, Michail Pishchagin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef MAINWIN_P_H

#include<qpushbutton.h>
#include<qtoolbutton.h>
#include<qpopupmenu.h>
#include<qlayout.h>
#include<qlabel.h>
#include<qptrvector.h>
#include<qtooltip.h>
#include<qaction.h>
#include"trayicon.h"
#include"common.h"
#include"psicon.h"
#include"iconaction.h"

class SpacerAction : public QAction
{
	Q_OBJECT
public:
	SpacerAction(QObject *parent, const char *name = 0);
	~SpacerAction();

	bool addTo (QWidget *w);

private:
	class Private;
	Private *d;
};

class EventNotifierAction : public QAction
{
	Q_OBJECT
public:
	EventNotifierAction(QObject *parent, const char *name = 0);
	~EventNotifierAction();

	void setText(const QString &);
	bool addTo (QWidget *w);

	void hide();
	void show();

signals:
	void clicked(int);

private slots:
	void objectDestroyed ();

private:
	class Private;
	Private *d;
};

class PopupAction : public QAction
{
	Q_OBJECT
private:
	class Private;
	Private *d;

private slots:
	void objectDestroyed ();

public slots:
	void setEnabled (bool);

public:
	PopupAction (const QString &label, QPopupMenu *_menu, QObject *parent, const char *name);
	void setSizePolicy (const QSizePolicy &p);
	void setAlert (const Icon *);
	void setIcon (const Icon *, bool showText = true, bool alert = false);
	void setText (const QString &text);
	bool addTo (QWidget *w);
};

class MLabel : public QLabel
{
	Q_OBJECT
public:
	MLabel(QWidget *parent=0, const char *name=0);

protected:
	// reimplemented
	void mouseReleaseEvent(QMouseEvent *);
	void mouseDoubleClickEvent(QMouseEvent *);

signals:
	void clicked(int);
	void doubleClicked();
};

class MTray : public QObject
{
	Q_OBJECT
public:
	MTray(const QImage &icon, const QString &tip, QPopupMenu *popup, QObject *parent=0);
	~MTray();

	void setToolTip(const QString &);
	void setIcon(const Icon *, bool alert = false);
	void setAlert(const Icon *);
	bool isAnimating() const;

	bool isWMDock();

signals:
	void clicked(const QPoint &, int);
	void doubleClicked(const QPoint &);
	void closed();

public slots:
	void show();
	void hide();

private slots:
	void animate();

private:
	class Private;
	Private *d;
};

class MAction : public IconAction
{
	Q_OBJECT

public:
	MAction(Icon, const QString &, int id, PsiCon *, QObject *parent);
	MAction(const QString &, int id, PsiCon *, QObject *parent);

	bool addTo(QWidget *w);

signals:
	void activated(PsiAccount *, int);

private slots:
	void numAccountsChanged();
	void itemActivated(int n);

protected:
	void addingToolButton(IconToolButton *);

private:
	class Private;
	Private *d;

	void init (Icon, int id, PsiCon *psi);
};

#endif

