/*
 * psiapplication.cpp - subclass of QApplication to do some workarounds
 * Copyright (C) 2003  Michail Pishchagin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "psiapplication.h"

#ifdef Q_WS_MAC
#include<Carbon/Carbon.h>
#endif

#ifdef Q_WS_X11
#include <time.h>
#include <sys/time.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/SM/SMlib.h>

//static Atom atom_KdeNetUserTime;
static Atom kde_net_wm_user_time = 0;

//#if QT_VERSION > 0x030201
//#warning "Possibly, now it's time to clean up some 'focus stealing prevention' workaround code"
//#endif

Time   qt_x_last_input_time = CurrentTime;
//extern Time qt_x_time;

#ifdef KeyPress
#ifndef FIXX11H_KeyPress
#define FIXX11H_KeyPress
const int XKeyPress = KeyPress;
#undef KeyPress
const int KeyPress = XKeyPress;
#endif
#undef KeyPress
#endif
#endif

// mblsha:
// currently this file contains some Anti-"focus steling prevention" code by
// Lubos Lunak (l.lunak@kde.org)
//
// This should resolve all bugs with KWin3 and old Qt, but maybe it'll be useful for
// other window managers?

#ifdef Q_WS_X11
//#undef Q_WS_X11
#endif

//----------------------------------------------------------------------------
// PsiApplication
//----------------------------------------------------------------------------

PsiApplication::PsiApplication(int &argc, char **argv, bool GUIenabled)
: QApplication(argc, argv, GUIenabled)
{
	init(GUIenabled);
}

PsiApplication::~PsiApplication()
{
}

void PsiApplication::init(bool GUIenabled)
{
	Q_UNUSED(GUIenabled);
#ifdef Q_WS_X11
	if ( GUIenabled ) {
		const int max = 20;
		Atom* atoms[max];
		char* names[max];
		Atom atoms_return[max];
		int n = 0;

		//atoms[n] = &atom_KdeNetUserTime;
		//names[n++] = (char *) "_KDE_NET_USER_TIME";

		atoms[n] = &kde_net_wm_user_time;
		names[n++] = (char *) "_NET_WM_USER_TIME";

		XInternAtoms( qt_xdisplay(), names, n, false, atoms_return );

		for (int i = 0; i < n; i++ )
			*atoms[i] = atoms_return[i];
	}
#endif
}

bool PsiApplication::notify(QObject *receiver, QEvent *event)
{
#ifdef Q_WS_X11
	if( event->type() == QEvent::Show && receiver->isWidgetType())
	{
		QWidget* w = static_cast< QWidget* >( receiver );
		if( w->isTopLevel() && qt_x_last_input_time != CurrentTime ) // CurrentTime means no input event yet
			XChangeProperty( qt_xdisplay(), w->winId(), kde_net_wm_user_time, XA_CARDINAL,
					 32, PropModeReplace, (unsigned char*)&qt_x_last_input_time, 1 );
	}
	if( event->type() == QEvent::Hide && receiver->isWidgetType())
	{
		QWidget* w = static_cast< QWidget* >( receiver );
		if( w->isTopLevel() && w->winId() != 0 )
			XDeleteProperty( qt_xdisplay(), w->winId(), kde_net_wm_user_time );
	}
#endif
	return QApplication::notify(receiver, event);
}

#ifdef Q_WS_X11
bool PsiApplication::x11EventFilter( XEvent *_event )
{
	switch ( _event->type ) {
		case ButtonPress:
	 	case XKeyPress:
		{
			if( _event->type == ButtonPress )
				qt_x_last_input_time = _event->xbutton.time;
			else // KeyPress
				qt_x_last_input_time = _event->xkey.time;
			QWidget *w = activeWindow();
			if( w ) {
				XChangeProperty( qt_xdisplay(), w->winId(), kde_net_wm_user_time, XA_CARDINAL,
						 32, PropModeReplace, (unsigned char*)&qt_x_last_input_time, 1 );
				/*timeval tv;
				gettimeofday( &tv, NULL );
				unsigned long now = tv.tv_sec * 10 + tv.tv_usec / 100000;
				XChangeProperty(qt_xdisplay(), w->winId(),
						atom_KdeNetUserTime, XA_CARDINAL,
						32, PropModeReplace, (unsigned char *)&now, 1);*/
			}
			break;
		}

		default:
			break;
	}

	// process the event normally
	return false;
}
#endif

#ifdef Q_WS_MAC
bool PsiApplication::macEventFilter( EventHandlerCallRef, EventRef inEvent )
{
	UInt32 eclass = GetEventClass(inEvent);
	int etype = GetEventKind(inEvent);
	if(eclass == 'eppc' && etype == kEventAppleEvent) {
		dockActivated();
	}
	return false;
}
#endif

