/*##########################################################################*/
/*! \file bondl.h
  \brief Contains bond length array.  
/*                                                  J. Kenny 12/08/01
##########################################################################*/

/*
      version especially designed by the shameous murdogh mcprsr
      Daten aus Huber/Herzberg, UwS, 1990/08/03                                 
      common /bondle/ b(3486),ib(3486)

      common bondle contains typical bond lengths for single bonds
      most data are taken from Landoldt-Boernstein II/6, II/7, II/15
      zero bond lengths indicate not yet specified bonds
 
      metals : molecular bond lengths have been taken
               which are smaller by about 10% than bulk atomic distances
      metal-c distances for transition metals are from carbonyls
*/

/*!  Used to determine whether two atoms should be considered bonded 
  when automatically generating redundant internal coordinates.
  \note I don't like how this works, lots of zeroes present, need to
  implement some sort of backup procedure using atomic radii */

static float bondl[1485] = {
/* h */
1.42,
/* he*/
 .00, .00,
/* li*/
3.02, .00,5.10,
/* be*/
2.65, .00,4.63,4.16,
/* b */
2.27, .00,4.06,3.69,3.21,
/* c */
2.08, .00,3.69,3.21,3.02,2.93,
/* n */
1.89, .00,3.31,3.12,2.74,2.74,2.74,
/* o */
1.80, .00,3.02,3.02,2.55,2.65,2.74,2.74,
/* f */
1.74, .00,2.93,2.83,2.46,2.55,2.55,2.65,
2.65,
/* ne*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00,
/* na*/
3.40, .00,5.48,5.01,4.63,4.54,4.35,4.16,
3.59, .00,5.86,
/* mg*/
3.21, .00, .00, .00, .00,3.97,3.59, .00,
 .00, .00, .00,5.67,
/* al*/
2.93, .00, .00, .00,4.06,3.59,3.59,3.31,
3.21, .00, .00, .00,5.01,
/* si*/
2.74, .00, .00, .00,3.69,3.50,3.21,3.12,
2.93, .00, .00, .00,4.54,4.35,
/* p */
2.74, .00, .00, .00,3.50,3.40,3.21,3.12,
3.02, .00, .00, .00,4.25,4.25,4.16,
/* s */
2.55, .00, .00, .00,3.40,3.40,3.12,2.83,
2.83, .00, .00, .00,4.16,3.97,3.97,3.87,
/* cl*/
2.36, .00,3.78,3.50,3.31,3.40,3.31,3.21,
3.21, .00,4.44,4.16,3.97,3.78,3.87,3.97,
3.78,
/* ar*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00,
/* k */
 .00, .00, .00, .00, .00, .00, .00,4.63,
4.06, .00, .00, .00, .00, .00, .00, .00,
5.01, .00,7.37,
/* ca*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00,
/* sc*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00,
/* ti*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00,
/* v */
 .00, .00, .00, .00, .00, .00,3.30, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
4.05, .00, .00, .00, .00, .00, .00,
/* cr*/
 .00, .00, .00, .00, .00, .00, .00,3.40,
3.78, .00, .00, .00, .00, .00, .00, .00,
3.97, .00, .00, .00, .00, .00, .00, .00,
/* mn*/
2.83, .00, .00, .00, .00,3.50, .00, .00,
 .00, .00, .00, .00, .00,4.54, .00, .00,
4.16, .00, .00, .00, .00, .00, .00, .00,
 .00,
/* fe*/
2.83, .00, .00, .00, .00,3.40, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
4.06, .00, .00, .00, .00, .00, .00, .00,
 .00, .00,
/* co*/
 .00, .00, .00, .00, .00,3.21, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00,
/* ni*/
 .00, .00, .00, .00, .00,3.50, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00,
/* cu*/
2.74, .00, .00, .00, .00,3.78,3.59,3.40,
3.31, .00, .00, .00, .00, .00, .00, .00,
3.87, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00,4.35,
/* zn*/
 .00, .00, .00, .00, .00, .00,3.40, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00,
/* ga*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
4.06, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00,
/* ge*/
2.83, .00, .00, .00, .00,3.78, .00, .00,
3.31, .00, .00, .00, .00, .00,4.35,4.25,
3.40, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
/* as*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00,
/* se*/
2.76, .00, .00, .00,3.69,3.59,3.50,3.21,
3.12, .00, .00, .00, .00,4.25,4.16,4.16,
4.06, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00,4.44,
/* br*/
2.65, .00,4.06, .00, .00,3.78,3.97,3.50,
3.40, .00,4.72,4.44,4.25,4.16,3.97,4.06,
 .00, .00,5.29, .00, .00, .00, .00, .00,
4.44,4.35, .00, .00, .00, .00,4.35,4.35,
 .00, .00,4.35,
/* kr*/
 .00, .00, .00, .00, .00, .00, .00, .00,
3.59, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00,
/* rb*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00,
/* sr*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00,
/* y */
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00,
/* zr*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
/* nb*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00,
/* mo*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00,
/* tc*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00,
/* ru*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00,
/* rh*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00,
/* pd*/
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00,
/* ag*/
 .00, .00, .00, .00, .00, .00, .00, .00,
3.78, .00, .00, .00, .00, .00, .00, .00,
4.35, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00,4.54, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00,
/* cd*/
 .00, .00, .00, .00, .00,3.97, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
/* in*/
 .00, .00, .00, .00, .00, .00, .00,3.78,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00,
/* sn*/
3.21, .00, .00, .00, .00,3.97,3.97, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
4.44, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00,
/* sb*/
3.21, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00,4.82, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00,
/* te*/
3.12, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00,
/* i */
3.02, .00,4.54, .00, .00,4.06, .00,3.59,
3.59, .00,5.10, .00,4.82, .00,4.72, .00,
4.35, .00,5.76, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00,5.01,
/* xe*/
 .00, .00, .00, .00, .00, .00, .00,3.97,
3.59, .00, .00, .00, .00, .00, .00, .00,
5.01, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00, .00, .00,
 .00, .00, .00, .00, .00, .00 
};
