package HTMLIO::Radio;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Submit.pm,v 1.1 2000/11/23 23:36:16 muaddib Exp $

use strict;

=head1 NAME

HTMLIO::Radio - object for gathering and managing data through HTML radio

=head1 SYNOPSIS

see HTMLIO

=head1 DESCRIPTION

see HTMLIO

=head1 EXAMPLE

Rendering radio buttons in MIC requires use the index attribute of the
<MICinput> tag; otherwise, the buttons appear, but no labels are shown
next to them. To display an each radio button, set the index attribute
to the value associated with that button. The example below illustrates:

...the fieldspace (for FX : Statement)...
  <MICdefine name="exact" type="HTMLIO::Radio" data="AtomicData::AnyThing" >;;
  {
    $field-&gt;set_possible(['closest', 'month']);
    $field-&gt;set_parameters({blank_ok => 1});
    $field-&gt;set_value('closest');
    $field-&gt;alias('Match To Closest Date or Exact Month');
  }
  </MICdefine>

...from an HTML file (FX : Statement)...
Closest Date <MICinput name="exact" index="'closest'">
Exact Month <MICinput name="exact" index="'month'">

=cut

use HTMLIO;
use HTMLIO::Utils;
@HTMLIO::Radio::ISA = qw (HTMLIO);

=head1 METHODS

see HTMLIO for further methods

=head2 html_input

 instance
 (string $html) html_input ([variable \@index, string $join])

DESCRIPTION:

Will return the appropriat HTML necessary to set up user input through
a radio button. C<@index> specifies which possible data keys to set
for default display.

=cut

sub html_input {
  my ($this, $slice, $join) = @_;

  my $data = $this->data();
  my ($possible,$ordering) = $this->possible_hash();

  foreach (@$data) {
    my $value = $_->value();
    if (defined($possible->{$value})) {
      $possible->{$value} = 1;
    }
  }

  return con_html_input($this->{_name}, 'radio', $data, $possible, $slice, $join, $this->attributes());
}

=head2 set_value

 instance
 () set_value (variable @values)

DESCRIPTION:

Will reset the internal data list to correspond with the values passed
in.

=cut

sub set_value {
  my ($this, @values) = @_;

  (push @values, '') unless @values;
  
  $this->SUPER::set_value(@values);
  return ();
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
