#!/usr/bin/perl
use Config;

use lib qw(. ..);
use localutils;

my $vars = parse_makefile_vars();
my ($out_fname,$init) = parse_PL_argv(@ARGV);
my ($use_statements,$perlcheck_args) = get_extra_libs($vars,$init);

open_perl_script($out_fname,"-w");
print($use_statements,
      "my \$perlcheck_args = \"$perlcheck_args\";\n",
      <DATA>);
close_script();

__END__
# line 19 piler.PL

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: piler.PL,v 1.9 2001/02/10 22:21:54 muaddie Exp $

use strict;
use Symbol;
use Cwd;
use Getopt::Mixed;
use PSP::Compiler;

sub show_usage {
  (my $app = $0) =~ s!.*/!!;
  print<<"USAGE";
Usage: $app [options] <directory | file> [...]
Options:
  -h			Display this information
  -v			Verbose.
  -d                    Debug.
  -V			Show version: $PSP::Compiler::VERSION and exit.
  -E			Emulate makedepend-related gcc feature.
  -p			Reuse the seeds from the previous compilation.
  -c			Syntax check generated pile.
  -s <seed>		Use <seed>.
  -n <pile name>	Use <pile name>.
  -e <seed file>	Use <seed file>.
  -I <directory>	Use <directory> as an include directory.
  -o <file>		Place output into <file>
USAGE
}

my %opt_map =
  (I => ['include',  '=s'],
   o => ['output',   '=s'],
   n => ['name',     '=s'],
   e => ['seedfile', '=s'],
   s => ['seed',     '=i'],
   v => ['verbose',  ':i'],
   d => ['debug',    ':i'],
   h => ['help'       ],
   V => ['version'    ],
   M => ['makedepend' ],
   p => ['reuseseeds' ],
   c => ['check'      ]);

# process options
my (%compile_args,@inputs);
$compile_args{includepath} = [];
$compile_args{perlcheck_args} = $perlcheck_args;

my @orig_argv = @ARGV;

# construct the option string.
my $opt_str = "";
for my $opt (keys %opt_map) {
  $opt_str .= " " if $opt_str;
  $opt_str .= $opt;
  $opt_str .= $opt_map{$opt}->[1] if $opt_map{$opt}->[1];
  $opt_str .= " ";
  $opt_str .= $opt_map{$opt}->[0].">".$opt;
}

# initialize the argument parser.
Getopt::Mixed::init($opt_str);

# iterate through each of the options.
while (my ($option,$value) = Getopt::Mixed::nextOption()) {
  my $full = $opt_map{$option}->[0];
  if ($option eq "V") {
    print "Perl Server Pages Compiler version $PSP::Compiler::VERSION\n";
    exit 0;
  } elsif ($option eq "h") {
    show_usage();
    exit 0;
  } elsif ($option eq "I") {
    push @{$compile_args{includepath}}, $value;
  } else {
    $compile_args{$full} = defined $value && $value ne "" ? $value : 1;
  }
}
# clean up the argument parser.
Getopt::Mixed::cleanup();

# the remaining arguments are inputs.
@inputs = @ARGV;
@ARGV = @orig_argv;

# do further validation on inputs.
@inputs or die "$0: No input files nor directories\n";
$compile_args{inputs} = \@inputs;

# insert any input directories into the includepaths list.
map { unshift @{$compile_args{includepath}}, $_ if -d $_ } reverse @inputs;

# determine output file, possibly from input.
if (!$compile_args{output}) {
  if (@inputs==1 and $inputs[0] ne '.') {
    ($compile_args{output} = $inputs[0]) =~ s/^.*?([^\/]+)$/$1/;
    $compile_args{output} =~ s/\.(html|psp|fs)$//;
    $compile_args{output} =~ s/\W+/_/g;
    $compile_args{output} .= ".pm";
  } else {
    my $dir = getcwd();
    $dir =~ s!.*/!!;
    $compile_args{output} = "$dir.pm";
  }
}

# determine pile name, possibly from input dir
my $name_type = (@inputs>1 or -d $inputs[0]) ? "pile_name" : "page_name";
my $name;
if (! ($name = delete $compile_args{name})) {
  ($name = $compile_args{output}) =~ s/^.*?([^\/]+)$/$1/;
  $name =~ s/(\.[^\.]+)?$//;
}
$compile_args{$name_type} = $name;

# determine seed file name, possibly from input dir
if ($compile_args{seedfile}) {
  ($compile_args{seedfile} = $compile_args{output}) =~ s/(\.[^\.]+)?$/.seed/;
}

# do the compile.  exit with number of errors.
exit PSP::Compiler->compile(%compile_args);
