package PSP::Error::Verify;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Verify.pm,v 1.1 2000/11/30 09:20:16 muaddib Exp $

use strict;

=head1 NAME

 PSP::Error::Verify - implements PSP::Error for verification errors

=head1 SYNOPSIS

 #more to come. 

=head1 DESCRIPTION

Implements an error reporting object which wraps errors associated
with psp:verifies.  Not necessary anymore?

=cut

use PSP::Error;
@PSP::Error::Verify::ISA = qw (PSP::Error);

# it is no longer necessary to do this ..
sub add_error_not_ {
  my ($this, $arg, @labels) = @_;

  # find the node in the error tree where the message array will be.
  my $node = $this;
  for my $name (@labels) {
    $node = $node->find_child($name) || $node->add_child($node->new($name));
  }

  # possibly map to a display routine.
  my $name = $node->name();
  my $fs = $node->fieldspace();
  $fs and my $verify = $fs->{verifies}->{$name};
  $verify and my $method = $verify->{disp_method};

  # add error message.
  push @{$node->{_args}}, ($method ? $fs->$method(@$arg) : join("\n",@$arg));
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<PSP::Error>

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
