% PsychDocumentation -- Bits of documentation for Psychtoolbox
%
% This folder contains help files and info on different topics
% related to PTBs use, technical implementation and troubleshooting.
%
% ConserveVRAMSettings   - Explanation of some flags that you can use to
%                          enable special workarounds in Screen() for
%                          broken graphics drivers or hardware.
%
% ECVP2010Poster_VisualTimingPrecision.pdf - Poster about the visual
%                          stimulus onset timing and timestamping precision
%                          of Psychtoolbox tested on different system
%                          configurations. Presented at ECVP 2010. This
%                          version adds multiple pages of comments and
%                          bonus information. It also contains a few more
%                          datapoints collected after ECVP.
%
% ExperimentalStuff      - Read this for a description of features that
%                          are currently in a beta state, i.e., they
%                          are not yet fully mature and polished, so
%                          use of them may require some extra attention.
%
% GStreamer              - Installation instructions for the GStreamer
%                          media framework on Linux.
%
% InstallKinect          - Installation instructions for the Kinect
%                          drivers.
%
% UseTheSource           - How to get access to the Psychtoolbox source code.
%
% ProgrammingTips.html   - A very incomplete programming manual.
%
% Psychtoolbox3-Slides.pdf - Slides of Psychtoolbox presentation from ECVP2007,
%                            converted to PDF.
%
% SyncTrouble            - Problem with synchronization to the vertical
%                          retrace or display timing, and how to resolve
%                          them.
%
% MirrorMode             - Special considerations regarding the use or
%                          non-use of display mirror mode on multi display
%                          setups or Laptops.
%
% MultiDisplaySetups     - Info on how to handle and use multi display setups.
%
% AntiAliasing           - Psychtoolbox facilities for anti-aliased drawing and
%                          how to use them properly.
%
% BeampositionQueries    - Some technical information on how stimulus onset
%                          timing is determined by the Screen('Flip') command,
%                          and how PTB tests your setup for proper timing and
%                          synchronization with vertical retrace.
