# What's this?

A tiny puppet module for setting-up a Debian mirror.
It will setup for you:
- apache
- pure-ftpd
- rsync
- ssh push reciever

# How to use it?

Simply write this in a manifest:

```
class {'::archvsync': }

```
# What if I want more control?

None of the parameters are mandatory, though you can customize a bit your
installation. Here's an exhaustive list:

```
  class {'::archvsync':
    manage_apache    => true,
    manage_pureftpd  => true,
    manage_rsync     => true,
    configure_rsync  => true,
    package_ensure   => 'present',
    mirrorname       => $::fqdn,
    to               => '/home/ftp/debian/',
    mailto           => 'toto@example.com',
    homedir          => '/home/ftp',
    hub              => 'false',
    rsync_host       => 'ftp.fr.debian.org',
    rsync_path       => 'debian',
    info_maintainer  => 'Toor Op <root@localhost>',
    info_sponsor     => 'World Company SA <https://www.example.com>',
    info_country     => 'US',
    info_location    => 'Nowhere city',
    info_throughput  => '10Gb',
    arch_include     => 'amd64 source',
    arch_exclude     => '',
    logdir           => '/home/ftp/log',
    setup_daily_cron => false,
    accept_push      => true,
    push_ssh_key     => 'ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAIEAqpihWIcSk8huNrwn1bEQu2D1OK0ivirdlt+vgZ23ctQfIfbP6VGK9U5OUC29aAwldKhFcVdQN7hUy5I4r03oyH3Vxun6ztKvppKqKgkmgMRh15qgbdn5oKzw+A37qB8Vb36ddeRZq+QAxWLCBa0VUo91aYgYxrDtkLh3/GExZgE= zigo-at-debian.org',

  }
```

Except the last 3 parameters, what you see above are the default values.
Of course, you should change push_ssh_key with the public key given by
the upstream server.

# What's missing in this module?

Currently, it can only install a /etc/cron.daily/ftpsync job, or
recieve a push, but not do a push to another server.
