# == Class: gnocchi
#
# Full description of class gnocchi here.
#
# === Parameters
#
# [*package_ensure*]
#   (optional) The state of gnocchi packages
#   Defaults to 'present'
#
# [*coordination_url*]
#   (optional) The url to use for distributed group membership coordination.
#   Defaults to $::os_service_default.
#
# [*purge_config*]
#   (optional) Whether to set only the specified config options
#   in the gnocchi config.
#   Defaults to false.
#
# DEPRECATED PARAMETERS
#
# [*database_connection*]
#   (optional) Connection url for the gnocchi database.
#   Defaults to undef.
#
class gnocchi (
  $package_ensure      = 'present',
  $coordination_url    = $::os_service_default,
  $purge_config        = false,
  # DEPRECATED PARAMETERS
  $database_connection = undef,
) inherits gnocchi::params {

  include gnocchi::deps
  include gnocchi::db

  if $database_connection {
    warning('The gnocchi::database_connection parameter is deprecated. \
Use gnocchi::db::database_connection instead.')
  }

  package { 'gnocchi':
    ensure => $package_ensure,
    name   => $::gnocchi::params::common_package_name,
    tag    => ['openstack', 'gnocchi-package'],
  }

  resources { 'gnocchi_config':
    purge => $purge_config,
  }

  $coordination_url_real = pick($::gnocchi::storage::coordination_url, $coordination_url)
  $storage_package_ensure = pick($::gnocchi::storage::package_ensure, $package_ensure)

  if $coordination_url_real {

    gnocchi_config {
      'DEFAULT/coordination_url' : value => $coordination_url_real;
    }

    if ($coordination_url_real =~ /^redis/ ) {
      ensure_resource('package', 'python-redis', {
        ensure => $storage_package_ensure,
        name   => $::gnocchi::params::redis_package_name,
        tag    => 'openstack',
      })
    }
  }
}
