/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Debugging functions
 *
 * Copyright (C) 2003-2004 Isak Savo
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <gtk/gtk.h>

#include "debugging.h"
#include "interface.h"
#include "support.h"

gint dbg_handler_id = 0;
GtkWidget *dbg_window = NULL;
GtkTextBuffer *dbg_buffer = NULL;
GtkTextView *dbg_textview = NULL;
GtkTextTag *dbg_tags[NUM_DBGTAGS];

void dbg_print_message (dbg_tags_t tag, const gchar *message);

gboolean init_dbg_console (void)
{
   if (!dbg_window)
   {
      dbg_window = create_dlg_debug ();
      if (!dbg_window)
	return FALSE;
      
      
      dbg_textview = (GtkTextView *) lookup_widget (dbg_window, "dbg_text");
      dbg_buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (dbg_textview));


      dbg_tags[DBG_INFO] = gtk_text_buffer_create_tag (dbg_buffer, "info",
						       "foreground", "#a427a9", NULL);
      dbg_tags[DBG_WARNING] = gtk_text_buffer_create_tag (dbg_buffer, "warning",
							  "foreground", "#2e9344", NULL);
      dbg_tags[DBG_ERROR] = gtk_text_buffer_create_tag (dbg_buffer, "error",
							"foreground", "red", NULL);
      dbg_tags[DBG_DEBUG] = gtk_text_buffer_create_tag (dbg_buffer, "notice",
							"foreground", "#899f22", NULL);
   }
   return TRUE;
}
   
void dbg_present_dbg_console (void)
{
   if (!dbg_window)
     return;
   gtk_widget_show (dbg_window);
   gtk_window_present (GTK_WINDOW (dbg_window));
}

void pur_debug_handler (const gchar *log_domain,
			GLogLevelFlags log_level,
			const gchar *message,
			gpointer user_data)
{
   gchar *dbg_message = NULL;
   dbg_tags_t text_tag = DBG_ERROR;

   if (log_level & G_LOG_LEVEL_CRITICAL)
   {
      dbg_message = g_strdup_printf ("[ERR] %s\n", message);
      text_tag = DBG_ERROR;
   }
   else if (log_level & G_LOG_LEVEL_WARNING)
   {
      dbg_message = g_strdup_printf ("[WRN] %s\n", message);
      text_tag = DBG_WARNING;
   }
   else if (log_level & G_LOG_LEVEL_INFO)
   {
      dbg_message = g_strdup_printf ("[NFO] %s\n", message);
      text_tag = DBG_INFO;
   }
   else if (log_level & G_LOG_LEVEL_DEBUG)
   {
      dbg_message = g_strdup_printf ("[DBG] %s\n", message);
      text_tag = DBG_DEBUG;
   }
   else
     dbg_message = g_strdup_printf ("[%3d] %s\n", log_level & G_LOG_LEVEL_MASK, message);
   
   if (!dbg_window)
     g_print (dbg_message);
   else
     dbg_print_message (text_tag, dbg_message);
}

void dbg_print_message (dbg_tags_t tag, const gchar *message)
{
   GtkTextIter iter;
   static GtkTextMark *mark = NULL;
   gchar *utf8_buf;
   
   gtk_text_buffer_get_end_iter (dbg_buffer, &iter);
   utf8_buf = g_locale_to_utf8 (message, -1, NULL, NULL, NULL);
   if (g_utf8_validate (utf8_buf, -1, NULL))
     gtk_text_buffer_insert_with_tags (dbg_buffer, &iter, utf8_buf, -1, dbg_tags[tag], NULL);
   if (!mark)
     mark = gtk_text_buffer_create_mark (dbg_buffer, "last_line", &iter, FALSE);
   else
     gtk_text_buffer_move_mark (dbg_buffer, mark, &iter);
   gtk_text_view_scroll_to_mark (GTK_TEXT_VIEW (dbg_textview), mark, 
				 0, TRUE, 0, 1);
}
