/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Functions for communication with PureFTPd server
 * Some parts is taken from the pure-ftpwho utility distributed with PureFTPd,
 * copyright is in these cases held by their respective author(s)
 *
 * Copyright (C) 2003 Isak Savo
 */
#ifndef __SRV_COMM_H__
#define __SRV_COMM_H__

#define MAX_USER_LENGTH 32U

/* Taken from src/ftpwho-update.h in PureFTPd sourcetree */
typedef enum {
  FTPWHO_STATE_FREE = 0,                    /* must be first (0) */
  FTPWHO_STATE_IDLE, 
  FTPWHO_STATE_DOWNLOAD,
  FTPWHO_STATE_UPLOAD
} FTPWhoEntryState;

/* End stolen code */

/* This is the structs returned to the GUI */
typedef struct Activity_ {
  FTPWhoEntryState state;
  gchar *remote_addr;
  //  gchar date;
  gint percentage;
  gint online_since;
  gint download_total_size;
  gint download_current_size;
  gchar *username;
  gchar *filename;
  guint pid;		/* The process id of the server handling the specific activity. So that we can SIGTERM it!! */
  gint speed;
  gint32 id;	    /* An Unique ID for the activity */
} PActivity;

typedef struct OnlineUser_ {
  gchar *username;
  gchar *remote_addr;
  gint num_connections;
} POnlineUser;

#define PUREADMIN_SRV_ERROR g_quark_from_static_string ("PUREADMIN_SRV")

typedef enum
{
	PA_SRV_ERROR_COMMAND_NOT_FOUND,
	PA_SRV_ERROR_PERMISSION_DENIED,
	PA_SRV_ERROR_FAILED
} PureadminServerError;


/* srv_comm functions: */
gboolean has_initialized (gboolean set);
PActivity *pactivity_dup (PActivity *a);
void pactivity_free (PActivity *a);
void free_activity_list (GList *l);
void pouser_free (POnlineUser *u);
void free_pouser_list (GList *l);

gpointer srv_activity_thread (gpointer data);
gboolean srv_has_activities (void);
gboolean srv_try_get_activities (GError **err);
GList *srv_get_activities (void);
GList *srv_get_connected_users (GList *activities);
GList *srv_get_pids_for_user_host (const gchar *user, const gchar *host);
PActivity *srv_get_activity_with_id (gint32 id);
void srv_terminate (void);

#endif /* __SRV_COMM_H__ */
