/* 
    Definitions for SIMD functionality
    added by T.Grill
*/

#ifndef __M_SIMD_H
#define __M_SIMD_H


#ifdef DONTUSESIMD

    /* if SIMD shouldn't be used the checks will always return false */
    #define SIMD_CHKCNT(n) ( 0 )
    #define SIMD_CHKALIGN(ptr) ( 0 )

    #undef SIMD_BYTEALIGN

    #include "m_simd_def.h"

#else

    /* how many floats do we calculate in the loop of a SIMD codelet? */
    #define SIMD_BLOCK 16  /* must be a power of 2 */

    #if defined(_MSC_VER) && defined(_M_IX86)  /* Visual C++ on Intel */
        /* alignment for Intel SSE */
        #define SIMD_BYTEALIGN (128/8)   /* align to 128 bits */

        #include "m_simd_sse_vc.h"

    #elif defined(__GNUC__) && (defined(_X86_) || defined(__i386__) || defined(__i586__) || defined(__i686__))
        /* Intel SSE with GNU C */
        #define SIMD_BYTEALIGN (128/8)   /* align to 128 bits */

        #include "m_simd_sse_gcc.h"

    #elif defined(__GNUC__) && defined(__POWERPC__) && defined(__ALTIVEC__)
        /* Altivec with GNU C  ( -faltivec must be given as a compiler option! ) */
        #define SIMD_BYTEALIGN (128/8)   /* align to 128 bits */

        #include "m_simd_ve_gcc.h"  

    #else
        /* default */

        #define SIMD_BYTEALIGN (128/8)   /* assume 128 bits */
        #include "m_simd_def.h"
    #endif

    /* check if n meets the requirements for SIMD codelets */
    #define SIMD_CHKCNT(n) ( ((n)&(SIMD_BLOCK-1)) == 0 )
    /* check if a pointer is correctly aligned for SIMD codelets */
    #define SIMD_CHKALIGN(ptr) ( ((unsigned long)(ptr) & (SIMD_BYTEALIGN-1)) == 0 )

#endif

/* check n and 1 pointer at once */
#define SIMD_CHECK1(n,ptr1) ( SIMD_CHKCNT(n) && SIMD_CHKALIGN(ptr1) )
/* check n and 2 pointers at once */
#define SIMD_CHECK2(n,ptr1,ptr2) ( SIMD_CHKCNT(n) && SIMD_CHKALIGN(ptr1) && SIMD_CHKALIGN(ptr2) )
/* check n and 3 pointers at once */
#define SIMD_CHECK3(n,ptr1,ptr2,ptr3) ( SIMD_CHKCNT(n) && SIMD_CHKALIGN(ptr1) && SIMD_CHKALIGN(ptr2) && SIMD_CHKALIGN(ptr3) )


#endif /* __M_SIMD_H */
