#!/usr/bin/env python
import sys
import os
from pybackpack import version
from distutils.core import setup

version_string = version.VERSION

setup(name="pybackpack",
	version=version_string,
	description="A program to perform backups and restores of user data",
	author="Andy Price",
	author_email="andy@andrewprice.me.uk",
	url="http://andrewprice.me.uk/projects/pybackpack",
	packages = ['pybackpack'],
	package_dir = {'pybackpack': 'pybackpack'},
	package_data = {'pybackpack': ['*.glade']},
	scripts = ['scripts/pybackpack'],
	data_files = [
		('share/applications', ['data/pybackpack.desktop']),
		('share/man/man1', ['docs/pybackpack.1']),
		('share/pixmaps', ['pybackpack/pybackpack_logo.png'])
		]
	)
