#!/usr/bin/python
# -*- coding: utf-8 -*-

#  Copyright © 2012  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import print_function, division, unicode_literals


def convert(salg):
    moves = {
        "": "",
        "F":   "f",    "B":   "b",    "R":   "r",    "L":  "l",    "U":   "u",    "D":   "d",
        "F'":  "f-",   "B'":  "b-",   "R'":  "r-",   "L'": "l-",   "U'":  "u-",   "D'":  "d-",
        "F2":  "ff",   "B2":  "bb",   "R2":  "rr",   "L2": "ll",   "U2":  "uu",   "D2":  "dd",
        "F'2": "ff",   "B'2": "bb",   "R'2": "rr",   "L'2": "ll",  "U'2": "uu",   "D'2": "dd",
        "M":   "r2-",  "E":   "u2-",  "S":   "f2",
        "M'":  "r2",   "E'":  "u2",   "S'":  "f2-",
        "M2":  "r2r2", "E2":  "u2u2", "S2":  "f2f2",
        "M2'": "r2r2", "E2'": "u2u2", "S2'": "f2f2",
        "x":   "R",   "y":   "U",   "z":   "F",
        "x'":  "R-",  "y'":  "U-",  "z'":  "F-",
        "x2":  "RR",  "y2":  "UU",  "z2":  "FF",
        "x2'": "RR",  "y2'": "UU",  "z2'": "FF",
    }
    palg = ''
    for m in salg.split(' '):
        palg += moves[m.strip('()')]
    return palg
    
def main():
    while True:
        try:
            line = raw_input('> ')
        except EOFError:
            return
        print(':', convert(line))
        
        
if __name__ == '__main__':
    main()
    

