##---------------------------------------------------------------------------##
##
## pyChing -- a Python program to cast and interpret I Ching hexagrams
##
## Copyright (C) 1999-2003 Stephen M. Gava
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be of some
## interest to somebody, but WITHOUT ANY WARRANTY; without even the 
## implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
## See the GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING or COPYING.txt. If not, 
##  write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
## The license can also be found at the GNU/FSF website: http://www.gnu.org
##
## Stephen M. Gava
## <elguavas@users.sourceforge.net>
## http://pyching.sourgeforge.net
##
##---------------------------------------------------------------------------##
"""
image data/class module for pyching
"""

from Tkinter import Image

class CoinImages:
    """
    creates coin images
    """
    def __init__(self):
        #graphic for a coin animation frame
        coinFrame0Data = """R0lGODlhSgBKAOcAAAIGBLaGBPrGDN6mDGJGBMaWDIZmBPK2DCoiBP7mFNqeBJ52FMKKBBoW
BP7WDO6qBNKWBPa+DHJWBD4uBK56BAoOBLqOFP7ODJJuBP72FOquDMKSBNaeBIJeBOamBOKi
BO6yDLqGBCYaBP7eDP6+DM6WBI5mBPq2DDYmBKp+BP7KDP7uHNqiBNKaBHpeBOaqBAoGBPau
DPrCDEY2BK6CDBIOBMqSBMqaFMKOBCIWBO6uBHpWBP7SDP7+FLqKDP7iDNKaFLaKFP7GDMqW
DIpqDPa6DDImBP7qFKZ6BP7aDPq+DEYyDJZyDMaSBNKeFIpiBPayDC4eBI5qBPq6DD4qBKqC
FN6iBNaaBOqqBLaCBBISBMaOBAYKBLKGFOKmBGJKBIpmBPa2DC4mBN6eDB4aBEIyDL6ODJZu
BP76HIJiBOqmDOaiDCYeBP7CDM6aDDYqBKZ+FP7KHP7yFAoKBK6CFPKuDHpaBP7SHL6KBP7i
HJJqBAYGBLaGDPrGFMaWFPK2FKJ6FK5+BCIaBLKCBC4iBB4WBHZWBEIuBA4OBPKyDP62DH5e
BEo2BBYOBM6SBKp6BNaeFPqyDP66DBYSBGZKBIZiBCoeBDoqBKp+FA4KBH5aBP7mHNqeDP7W
FO6qDNKWDPa+FP7OFJJuDP72HMKSDNaeDOamDOKiDLqGDP7eFM6WDP7KFNqiDNKaDOaqDPrC
FMKODO6uDP7SFP7+HP7iFP7GFMqWFP7qHP7aFPq+FMaSDN6iDNaaDOqqDMaODOKmDIpmDL6O
FP7CFP7yHL6KDJJqDP//////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
/////////////////////////////////yH+Dk1hZGUgd2l0aCBHSU1QACH5BAEKAP8ALAAA
AABKAEoAAAj+AP8JHEiwoMGDCBMqXMiwocOHECNKRDgCFw8eFy6oyKixxcSPE2mlwiWnx4hQ
oVSsyihERZs6L1QIgQCyJsJNK0bNSpBE1islU6acOBHpBBQoiaAoEtLmgak2JWzavIVm1hFc
odoIK1LMjC5SpMxY8EGWmCoQMXSACKMIyxhHUiXemjVrGK5aRZjoslWFVJgpRYoAPhEmUSIs
pRigsqGjTp0YaqzYiNtwGN1bskLlWtDFD6g2WoXVEgYaNIk2JCQVjuWqVAsNGrB4+jBmC+WE
OkflebXATZAhwlYJF0KcKWoSqSUpV64oDBRTJcxs8ZIohgIptwvqnLXiTp8qN2r+CVe5UZas
VSpSqpApkzgJRZIUGYXi6tevUx48KLhiO3tVNHn0AUcQQKCUmXCyJEFLEp3w4ABGEF50QSJ1
DDVUJJHUgdgnazh23W06dRdHFW6EskooB16wigO0LCGCCILkIGMhNNI4CRsBKGWhc3XEwsIA
a3ixBgQmxFXVCnHAEQwkcXTSiXkmrlKLChEQUkENmSAyRyZzzFHBllw0YkIi8g0VhnNQ1OHB
FW54oQYEYNgUYh90QIJSJ3fccaCUQqxCgi7FAGPCE2BUUokBaSTaARg5mglFJEelqUMsY4zx
ggdEgkQXknQ4cYeTT0KZUi3iaYSaEpJMAZQSSgjGIxT+RBEWKVJ1UOjBLkHCOVGIcdT5KS5O
pjhcGyrIkooDnTyo7EUXqQBCImEMFSmF1E46m5ue2LCERLOgcQccToQCap7mDSdlLReMUEaM
M9LYQCENNDCJCFnAShiaMaTpWGO99NKYBx1EpFMecQQTCrB4QincuUytMoUlW3bJZZdfdlkD
GDqcCelRhhkWS48PfNyLF47E6dAK3NHJ5LiZoaSSEKNpRYIvxRSaqKEd5NzBIpUMEkMkaB7l
WK06eBJLLFiYsoYrWGwxg0OzjBIKIAU6qWfLJtYiBGnCnMYUq2BHAFRQPNYadMeJNLZvL7Go
4UGPHmjSEMqb1GJBHJ/iiZL+iSqRyrUwKvAwArOEY5SRCjroAO1RMcTgWNrWIt1vL56MvMW2
C81yyytVAIG3nihGqTVxWjGlAi5U1OhuvKxPIkgW+SLVMQhDN2a0DrH98oEaXgSs0Fx3LHAD
ipmdF+W5wpAWmhBFQJxJxRV3OQcXF+sw69AgFB1L0ZT3+8sLGuKAOUJoDBMHELWE3vJ4xNVS
mvJtKGKGCWkYWn8aOS/SgSYdBFIHFPmqVdrq4AkC9kIDD+jFA7CghjooIgZjkNtNZoGLVwRh
FXsaD6nclzyuHUc5kIrWUdDUsTooLk36GmDiYpHAyfXiBRqgEBYYQAWEHOEWq1iAKoSDkuFo
jYP+bSBdn9DDFNKVpjTIkURyClPCHsXCE5WLhQb69QK3+csTVyAE+TpRBDoII0oqOVcbgCia
ICYBF7KQUIQ0opGNtEQmJ8DCAxxDuwdoYFKywUK/mOYBU7BtDTs4CC16EAom+GFhfSOdB5VH
goNdYAoHgFathlaHB1jyknXIEAQSpwNLGtCFDFSDKUzhAQ1oiIYGyQMthKELJSRya8lDjVZK
UwsSBC4MEkABAggRBV5G4ZdRsIQILGEJIyyCA6bIgho8tj0WekKPvXDFC6ZJykRIIhFXsIRB
cJGEWrhBGObhQWYM18P1hEIIqRGCLA6AAoiMwRWB8EIMThAUM/UICiL+lNTbTlCHK0TBICvg
wR+qIAQFnRFUynJAGi9QhPgI4QIHQABEpvAACpjiBA4QgAw2GoEPYOECAgBbEaxghRdM6gOG
KEgqeiADUcBCBS0SARte9CJ2yYgMliCGJITAAyj88yER6AUF1rAUI2ihEY2YBBkCIQNC1KAG
WqgBGVLwi17UwRR4qOFAcJEKJZghDEKoUiaeiohMZMmsmYDBHCahh0i0YUI/dUgEsPAID0TC
AzkAwB72WoNKKIAMet0rIjpghQrVAQJx/YcDHgmLKdSSFKIgAhiAMdknGMAAh0qDCXwQiYcm
IrEMCWog1vAAD6TADoYwxA408QgWPGIHqTX+BGupc80r5IAgmZlCY4XBFBIowbepSlVQWlUU
Rbz1sxApghoeYYr/mdCSWJCjCaM7TS9YFwq1FQRBeKCCKfglcCNwgHh50NALJOFBGDlAtN5a
B9AuJAKuoMAHTsCDkMpACW0A23BJMNJdfKAOkujnbQdiojA09nQToFEOCoEAX/AABTQiQwNE
EIIpsFcEEFECPOcrBDHUYBJJhaoWovphLeQgBfIM8BUwPBCNQMECYA0DG2AwsUmcIRaEUOsc
YDAJMMSAWMgFqgZS4IEwDEAEegVAYPe6V70iYhEKsGYiIMBigWAkEj44QfzwYLM0AMMHdfDB
ExTFKCi89QHuVcj+FEzxiP96gQI7iHNsDWEHCcRWEykorCKmrN2ByCQRxEgECZiiqrFNgQSA
CUMReBQGW3qiyg3RMIo5Gd3oCulS+fGAFwbAaWvGAgIDtrIKEuEDKDw0CYVT4+Fo12gVPADS
DNEwHLxAXxn41rcDeAEPhCBSkv53z1fos0CYAgU8JIKnl5gEvNxlo3jNq14kuIAa0pyQKZh2
ACeQgRFE3AhBBEIJTn1qDRqABC80ummh/gcvYpEIVfTimmzYg5ekR+857KEGTwCwq2G9ECV4
4BEDSIQVALsHvdagAxwoxJKfPADQWIESeyjIC/ZcCsKEAFGLwJ/+9reIjvcMBLZUQzv+H6IE
U+T5AR94hCZiu4gUsCAFsE2tHZDgARL0k98CaEMMzFCh+UwrKRQyoWNiIAkV1EGCDuEBPAeg
gfx8wAsfIOkArOAFFljB6gqwAhamEIsVGwSdIAiBDpgj3DLFKp/YbUMYOGAFJWwUbHAfmxJ4
8ANXPELranBFL/LuClLaxxSnWIMpfmEKT5AACzhIt0DcgIVYDEENkRCKhSYvK+ckZShqMkWl
o5vp/EzTA9N8QSkCsQss5McLmf6FdT/AetZboRen2QUBIm4QL0BBBxxIxAkUYfZ7zSpSGoIA
KgJBgeJT4BGBCEQKlg8HJKQA+Y9IASC8MMpR3kf1pzjFLnb+kf01rEEHL0EsQuLXTw/AqigX
wmfQkIKUWPRCaae4zxq6vwbdeWEXA9jFL/yLeiyg3rpeoDtPx3prMAZrgAWnoQFboHgDUQKu
gDstAC0+dyazYhgxQC2PAR/KsXtI8RfCFQmHMUWiRHgkeAofsH/Z9wHeNwZ1QAI6cAWzlxAs
iAV4gAXRQoHT8hgXOEkUglEu0Qb35QUPAFKsIgNFAHWol2nWpWkmCHUr6H0f8ACS4Ao4QG0C
YQMv0Au+8AGxMyuxYxh1QDucNAVCQAgjNgnKNght4GEgplRE9n6DB3gpmIIquAas1wugMQYx
qBBj0HQD4AFJ8XNBRzuUZD14pWT+TmYAf4WIe5AJaVBSmgaAAWgFH2CCdehRgxYLW2CFA9EE
b7MGHPA/QZdCg7hCJvQCKaAJcWYHHXB3cBZnO9ABVKUGJHgfp2AFKeh9BfgBniAEL7iHCxFl
HlACLJgUApQ4zwUylONc0GV6zaUDHoAF1KRpmvZ0XoCLBKiL3vcCoNELm+gQTaAAHmCHHqA4
QUchhKg9uAMF9XVfyKF5F8BrhzYFA/AB1ncf3EeABriCapCJWwCMDGECClAHQzJHtfMAiWM0
DwBFNthUH/ZUOTAISuBhUNUIU/V/rOcFubiCBvgAbdB1BAADEXEFdeAFLcACnKQ2T1Q0U4QF
jeEFgqD+ZIJVCQm3cB2gf9m3kdq4BtzYBljgC/zGEBvACvNnBR4ARdtjNEp5NGyjA17wWrBl
B4vwCArwCKiVWotQbpFIiXVogFewBmoAGjrgCCE5EXrQAlV0Cl5AOQoZG7HRL7LRGJXmNl6w
PZn2AgOgkYCHK3X4hGEpBIngC2X5ESbQAkISjSykAVA0OdBUB/H4WzIwBV7wAkQ4NlaQl61X
gE+IBRoglmQpkjVhAp/gJokQC6agBpzpCS30QmHgkE+lBWQgkYSACFBVAzmABFYAeF1pgAiI
Gonwj6BpE2DAeHXQCx/gCs80OR6gBmqgA1YQk0yWCQhHcAXniCxgh/t4gFj+EETQ+Jm3YQI2
oGnI2Quqx5wv9AKu8JRXaQhZ6VqoZWcugAS7MI67+ACn8ZH8MZi3wQgd4AiJ0wun8AIgkDSk
ZAoYGXWbRnVWR1JZNwYqOEfb6YtYYAMEEAXBmR3/YAKwYAolRSaJ0At91Eej5Aok+gt9VIv1
Z6L+chwk0HWCeaEYKhAz0AG64FGO8URWdRhIqJFcmZEGaZ9iiQVWIJgWGqMIsQQdAAsf8AKc
aU2K8H4f8zhHA0UHgBqH9hJYwAuCaQm0Z6QJMQOawAC8YKO3VyHMwXtk1waNoQYsAAFNQACW
AKNemhATgAI7wABXcAW7AD6yA4aNoQFW0AItsAE2BEAIOdClc/oQE7BLO4AHLZCnVyCoENAC
EEChwiQIiJqoH0EFNUVTbCAInyqnmjqqpFqqtxEQADs="""
        #graphic for a coin animation frame
        coinFrame1Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak
DNSaC/q6D7+KBkYzBf7KEv72MP7aDKB2BHBTBc6aDCQaBLqKBOGqDzkpBr6WQOmqDAoLBvm+
IsuUB/q2EHlaB/7DFf7sLP7UL/7NMK19B++uDf7EJK6GNNejMR4aDv78KLeFCjIqFJZuBPa2
EdmeC+6+DEw7CqR6BOOzQsaeRLiMOP7cM2BKFCYeCN6rOf7kQP7+TRMOBcKOCTwuDC8jBJp2
JH9cBsWWIaJ+JBsVBgwGBNujF+2yJD4yGPbKHI5qHP7sQCoeBF5EBI5mBA4MBlI6BLiLGemr
FcqaJP7iMP70Qf7cI/7+N/7cQOKkDO6yFP68E3ZWBP6+HLJ+CEY2FP7LI///////////////
////////////////////////////////////////////////////////////////////////
/////////////////////////yH+Dk1hZGUgd2l0aCBHSU1QACH5BAEKAH8ALAAAAABKAEoA
AAf+gH+Cg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJmam5ydnp+glgE1pKWkFaGbMxozJBMUsLAJ
sBJcAxogqZOwEy2wMx3BDcMdxDESEl4oIwO6jSQtEwkPCCAOJzUQQNsQGdtAMgPWMV4hD1zO
h0kTEwUjCycuJwMODQ/IEiP5I/wPAxcOuMgIsQDFgwYw0gmKRuFBhRNhIKDwwq+iRX5eKGJ8
0EGGDBcGvTggkOpCixYFgsEA8kDjiFmxYsbMR9FLS4IocobogCKhJwEomQyAAYHLxREFBGRY
ynSpi6UBIITAOMJmCC4gUJhrQKQTNAoggNTQcJQfBSIA0qpdm1aIg6r+cDM+CIFC4IIOqDSd
ZOKigj19+ypSBEHEguHDhnUYjiIjLtwHc1E0QFHQBSYqLUg8iPeAX+CLEijgQ6YPcD+NNava
hEyX8gIQUyxlxgvBC+l8n80y0ZCkN2/evZNcuNBZdUbVkMstWAD5BAZKFCaMcAGi9O2yEnQA
8LCdLXcAB0Acr9hZLuuWXhpEmdQrARAX9/bJL+sCCoEpU+4TuI9/ioXqGR2Hnnk3hbCTT48Y
0IIELoSxAGC34QZaVTFAVmEMC8RgQAwYtmTRcQFCBtkC5oQgQ2yOJJFZDCeEMBpp1l1EQQFM
SMDEjTgiI4AyAY5H0YAiskaQC0I4QgIJeDn+8OJo2BUABVtQAvCEDC71GOJqcxH0AApdMUJB
C0zAMAAyCSz5Ymn8KCDEmmy2uWYEGZQnmHFBZtnZAw6gqAhKI7xV5pJolhVCAx45IIMDiCZq
6EQ1CUgnlh6Wc8IirowQAAgSlPmnmRFyyiRuNGH0Y49BmhNkBxvsSUEMLryUKZlmekYBCQXM
KJNMsySg6wgeqoYcpCJmFIMCifQyAwwNvEqBpq+aWYA7M3gxw7QziLghhxxStIA9GgFJoIHm
2DSAnoW0gwIQzJK5qbMURCEEBkdgAO8R9NZ7BANPKLBti6sRKKSpkOXzAEmH+NIBCLNOcOTC
DD8rWqawkMtIejX+UJSrrvvMkmkCvBb3QJeFACUAAhq8MtzJJxdxgcoBLCNBAQlIvAgFKFTg
ha4ZuKBzPProHIA8ILWEJ8GEoARCBhKQgJYHTEeZVhRe0BIBJDRXcM8AbB0BAgJsCQHCgyOE
AMMPhFwgzQUGLIuABTrYp0Pb9kGRHwEVz5jA1I9Q0AUELXVgwRRiBA6FCwPoELjgEunzQA0A
EGLAKyDMQIsA0z4wgwGQzYBtF53NKEEQkCSwAN82STYMMVsS2oBAWikOARKEMEGCBAggBc1J
DM0YDTskPOw56I+InsFUL9+qK0zTkKiPFyCQPcisFLjwcgsWRBAB4GIMMIEFS0QghvX+jc0q
Qap5xyBVphFssIGbbm4ABPFeyHAEIUcm0IDdG9DLQLwBjPACAwCUAgsqMALxvQASEphBBmLw
DgyoBQkQjCAAkACAH0TBZSPowBOKVgAJ3G9ZDaBCAEYYAA3UYhQ1OEEAZBAaEvgvdA9wwQLK
AQQYROGGCsihDnMYBZDY5h3kW8jsQJAAhjXsSM+q1Z9mNYMiPaIqicvNXKoUNoLYphzAE6IA
ZJCAXuBIADcSABjFSDkTzoIEMXCiI5gwAgh0ACkz4IIG5niBZcxgAHgURwOYIzAo0C8pGoiO
ATwAwEIC0ANSYJoHhMDCWS3gAJCYQRvfSAEhsEUBEogAW77+0IACepBcAoBZ1EigAQIcTgxL
QGXglhCEIBAAAS1EwQ4g0ZkKdCAjOpCXvHbwhQGI4Am6xMB/QjOCCjCgbO1gggB6JwANGMAA
czRAEoCjARlo4AEJKAAJDCAGSAhAAn7hFQpAoDOdZaUD7/EZEBqgqwfAoHGDAEoBWIHEJNrT
YbJYljZHkAFIzK4GDZALqURkoCwZSHEngN0guliAKixTm7S6Z60KkIV82i00z4poEm91JAmc
wCiiClGpwIXNBHAJnoNgAsxeFlGN3jMWMJHAAmSAsguAYGtbQ8A2dMoNgPrIXwQ1UGgk4AA1
DqIA7cjUwiTqMHwuSwIG8EihhnP+06rmFAFYBYEMimMloM7lAbAQyfzKldRs1pOpFKjostaa
K9FgDB+BukhqRDrSqYhmAWMzBBWi48JZLZWp+GxrEnv3VFvF4jOpKc+3SkS8DMpMEEgc5V8n
ulG15opWFYCBZm/YBRKc4IY3JIJ4qDKqgRoUmw2pwVgNAQJaVdSIgE0rTAsgA7YwoFVHYIsI
lkFautbJNrAIwZOK5YqMNqypG5XFLDQgAv0QAAoBeIACpkADGohhCgroJFWM4y9zFJACISCS
IjSA1A4i9bj2zAJFLyaBB2igA1yQYxfKIRCpckGxVVFsnUQ01BBYQKGJWJhZ0bvRWq2Vrwuj
xYw2yrH+OfGKTue5Wa28AAS8jTdhxkVi7+xpWOidogaajcEEMqBZzRKBJYKxUp1CEDUKMI8A
AFaEAVwhGojSilYLrlVFZ1EArq3lthJgAVt08MYqXSlIL5NpFJzHCBW1Y8BnveeOKVC46lqX
ANEVASpZGQEigLRHEIYMUigwAhkM1xEzyILCMixRWCixTAbAI01l0IEHLMABVpUBAz8kUNa8
rIMy+AKTHZE2hblZmwV2ql+Xutbkcgw1Xf3qn0fQAEFPwgBqPpLCXDrRWLyiNyfLgBdIiYAL
YDUADuhVXGxiMc9xgQirlYTkNG1gKauVBEbYzndYgAAK5HYtOtAuiPjrMA/1KoAFl5iBjdGa
zwAE4QVsWsIJBvaEHVgbAzoYLXch1sEtReE5lxiCCY1b6xlZtswZoELOgDAASsvjBPBOHHd5
TOYGOEAB4MaEDpqggSLiGNGyXVaZHLyR31KETEocAQrUJIVOwKALGIWow3Tl1rfCVa4H77AE
JAODfHdCB0NIAo85bKszfYgfSzzsOzqggA0MGhRiCo2tICpwWmhsNB2uVdgWHoGX62IIF3gJ
TJSY4wXH5Fkw2pICeq4QQyiACAgAK8Y6fODj7aMDRLhPrJvudCKIwAUGCJRIR0AYtk1h61xf
BBFgoIAo7HCHNEB72udO97oLIhAAOw=="""
        #graphic for a coin animation frame
        coinFrame2Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak
DNSaC/q6D7+KBkYzBf7KEv72MP7aDKB2BHBTBc6aDCQaBLqKBOGqDzkpBr6WQOmqDAoLBvm+
IsuUB/q2EHlaB/7DFf7sLP7UL/7NMK19B++uDf7EJK6GNNejMR4aDv78KLeFCjIqFJZuBPa2
EdmeC+6+DEw7CqR6BOOzQsaeRLiMOP7cM2BKFCYeCN6rOf7kQP7+TRMOBcKOCTwuDC8jBJp2
JH9cBsWWIaJ+JBsVBgwGBNujF+2yJD4yGPbKHI5qHP7sQCoeBF5EBI5mBA4MBlI6BLiLGemr
FcqaJP7iMP70Qf7cI/7+N/7cQOKkDO6yFP68E3ZWBP6+HLJ+CEY2FP7LI///////////////
////////////////////////////////////////////////////////////////////////
/////////////////////////yH+Dk1hZGUgd2l0aCBHSU1QACH5BAEKAH8ALAAAAABKAEoA
AAf+gH+Cg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJmam5ydnp+goaKjpKWmp6ipqqusra6vsKdG
FCNetrdeDUSxiAkjFBJeBggQQEAQyMgIDQsLXB0dX68GFAVMGggVFR1hEAMDXFzf4AMO4gMy
AygNIGGpRhMUTCBRHSdAzCH6+80hzc0o1pXr0KAgChBQSFEgQaFDhRMnOiwI8SCEFwkzYnTp
YqDZRo4GAwYkWLDgghOgBEwY4cJFBRn7Ynq5AECIzQ02bwoJokMdig4/14mTAaKDDAWcisS7
AMMFCooVK+p78GABCBcBsmYNcyJAVwhAF4wM2qCDuLJALGQiUUADjIj+UKlKpRhihIQLMmQ4
2JtXrwMIDgCKHBywwbN1US5RoIAChgxccuVOHZEBgOXLmC1HCIxCrNixP6H95FKBEpUJCTJU
cPDgVuTXFhc4AGGstm0gIBr4+zwYqO+C0FxsiKR0XoUFXmrZkuvl9QMJIxCAmE59Om4IIDr/
E0zYN0nhj6iQ8AIjDIpbyl03jyxBQeb3ADaA2K69O1ndKE4IcdSCSYMTtig3QnrLSaZPA0C0
pOCCLnTDDH3/2BdQMx3U8AQjDMkAwwADJidgcpCNkIAEEoxIookkpkjiCFVpR193oomkwyIC
kHDBCVwMKGAtPLr2XAEqBhnkgMEUtFtn9fX+5lszIMyIiHgj1MAhess1ZyWIDwADwwY77IDB
l18egYGYYm4QxUFhbOcZb7095cVJHiDCRAIhVPBAAYvlqWeewVCVQAIJPTICCCcs8Bx00D2A
gl2MjrCARFXJQMMhFEzQRRQOSKDBD1J02ikSoIYKwBcd2CXBFJBQIEMFiyIAgAceSIEEFAu4
hwSsSBAhg6GyBWFIASMM4MKACE0xBQ3GJqtsFA38MoIYkEhAWgwhNEmDGFOIoUOCUGQrhhhf
ZFfLAgQUUgEtLoAgIgV//olou8Cw+ICIIwz3SAJcwGCojvzqGGCLyDkaBQCEaECBFxFJUEAA
CkShgAK6UsDwww7+s/bLA/Y6IkEHTono8MMghwwxEdnNMEIILkhByIgPAFHXAztg9gMMBsR8
GRIw1JXAAxhEG4N5D3SAAXyZScHsvCFw0fMgQDZQQ4cDJFNMAw9w4QIEVwPBxUUJoLC0IzOg
rFsMMmAVQBhbcQXR2fgswOICqA5CCwgQeLHQnniz26EEFHDBACSGwrC1F+6WWBXfKira2YAo
SCPIAAl4kQGHFMAAgKeyguoBErICEIQMz1HgwN+PGDBCBQPYDcWrtyJhQQwDwyoFAFPMZxcK
Aw9yXkEDRiHGBsBvEMTwwUewARQgXEQBCEhAokGUrC0AgxjEH38VDcFvMMUJD/jiQMb+fwAT
A/dvo7DRZ9wFNG8CqsbtiAEJ1ABCRQs0QE44SKLTl24SPNAA+LSwWr8GSECuKYpw7Epgu9pV
okpJIAxAkApstsMPi0SuAdAahAwcBToCMgo6BFwAUYxBm9vUBgHGKAYQ5EeXmFSQPiHgG3lI
JwgDQIcLzUoPv0DYqA75by+zASIQQTAb6lxgOjJAQVRcqI+JqClLEghBAFQ2iAHUxQsd7FC/
VkSkLS6GgUQqUYl8oRwDMZEf/ViUL2SwukIoJzD88tAWB2g3AejlAngBQQzaIoMk5IWIcYFK
C5tIyH+QaAEQuFAh6la1unhwRYjqFwWIYBkkWEYKJxAAA17+dRkasAY2Z3TiRPhGgRDooHmF
iIKOQnAef8mxhz18gAt0QIApEIAAOghAY7plLAKEyzlUOaM/6gKMEIQBfIRAwICgMa9+yZGL
O2TRbvpRixhYEyAUWY8EQ0kRvgmMioZwSnKi4soBRtJUCRCAyTLSAC9YYwYPgCdB4gLKMyIu
PxsgGCJINaCyxDGaXbQLBaaQmSMgQAIHyIx8LBIZQTLxFxRoWT4X4UhovDJAYXQmEXCSEzHU
YAE6yIlNppAmYA5SH78AVmN+wIgodLA5HuwiD70Qg3IAUQbtJBsRiegAqlmpoS78BQk2BoMn
6HMRyLsiRZypIx7yzRcpooWIeOj+LKpUCTZU4RuwGqCArzkCBI60C3rmKFALfOtbEYBCAwrw
BbRGIAhQYM1VI6O8aoygA0Q4wiSA4DYSvbKpTY3B0DCDgRrEwKiYOYK+fGTVlALDCwP4Aksp
4YIOXOQiwSDrySAQBSJATAEwcBkQYECE0hKhKRZZTjfzRKeD6ICGlCAADHKYKGhSVYtXsqpr
ptKaqMYrBBCYglE1AYPAeIh9t/2rv+LoGoHi6YsiDEMEjqqJIFggA5b9IJH+xKPuzutKUx1R
NRbDog44IAob+AF1OSEEKLzEIug0kUDHSF/xPjdPteACCCzwBEuWYgpRAIIDlGgqu7CPXchl
34HjNQJQFMzGBQQ4wnpLgQEG6CBdAg4YQP0lAxIqQAidmnAqMMApIRChGCU8Rm1oU4MpMABU
Io6FEDj1gxrXGFRS+IF/ecHjHvv4x0AOspCHTGRBBAIAOw=="""
        #graphic for a coin animation frame
        coinFrame3Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak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"""
        #graphic for a coin animation frame
        coinFrame4Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak
DNSaC/q6D7+KBkYzBf7KEv72MP7aDKB2BHBTBc6aDCQaBLqKBOGqDzkpBr6WQOmqDAoLBvm+
IsuUB/q2EHlaB/7DFf7sLP7UL/7NMK19B++uDf7EJK6GNNejMR4aDv78KLeFCjIqFJZuBPa2
EdmeC+6+DEw7CqR6BOOzQsaeRLiMOP7cM2BKFCYeCN6rOf7kQP7+TRMOBcKOCTwuDC8jBJp2
JH9cBsWWIaJ+JBsVBgwGBNujF+2yJD4yGPbKHI5qHP7sQCoeBF5EBI5mBA4MBlI6BLiLGemr
FcqaJP7iMP70Qf7cI/7+N/7cQOKkDO6yFP68E3ZWBP6+HLJ+CEY2FP7LI///////////////
////////////////////////////////////////////////////////////////////////
/////////////////////////yH+Dk1hZGUgd2l0aCBHSU1QACH5BAEKAH8ALAAAAABKAEoA
AAf+gH+Cg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJmam5ydnp+goaKjpKWmp6ipqqusra6vsLGy
s7S1trerUBYWOry+vcA6QbJQUL1fuzpQU8zLzszQU7q7UARTBDSlETS9vFA0YkHQQRHQ5eXR
UzTRBO0ExTpTG55TIslTEWLgYmLM1u3FAgoMqEOHtWv+/hGEIuQSjWRQ+PHb1oygBXgDFxZ7
pyzgQRrtrr1rNy8SDWTYwG3oJy1jsSlSYv6QguTIFB1PkPyYiUTKhncuQyJsSeOJoyDU5G3A
B9RlwClBNkiVKg7f1KnlnjlV5y4kI2o0pF5z6tICs35i8m1k2S9C06f+zjRWe1rykK5qG7Jm
bKn1JQMPSHpKYbCEAAsPAHrqFNfXaUeB8uxehOr2peWXLfk+TRsBXTUanTmTddnRXbUpDQmJ
uRihKuS+0mILxBA4pk4xUBgIDmxzNMGRBR9jO0LoIpS8r2HHlf05tL51BNJyruhYmUFlACEP
E7ThopilsjNfjmts4GNj5/cGHdl1pMcpgx5CaV3sov27+O9Km7zhCIb/GBwhoH8ABriDNJ0R
FFxHCxY0EAEREPfHTRBGUMwGGDwB4BMacqghBkLwNYWEjiBo4Xwd/ieENR7+90RlL2EgSATK
JLhMZzhilVcEebVkloyPVKPWMuQEYaRb+BT+aSR1ETAwyEt6/TcgBhYKIWCAR2SlTGqOxMMY
FE9c6d+AZGYJmVHFzXciM+dkxeY5mnHZiFnlKMNmkm2eIw5Q+BhS2Yk6YLDToITuJMUT0ihT
15w8vhPBTDNJ0Y8QhZ544w+I2MncegfR5Yhbrf2TzqjUQbXIUNZ4xJ5cvgXVz0ZdVfNPdjGW
+FJ2QAHknqzLCOHrr8AK8cRSXYk0a2xvTYEmJMiOpetcquIllRBTUeurVNCJZOyskMkpSRDL
tCeue9bgaK65CIUbErcbRQBkJiHqyt47Q21g7a/2/lqVqNHKQ+InQuwZq1DnFjwWdrEp+24q
VKVb0aYHdSbsv7gkVGzxxRhnrPHGHHfs8ccghyzyyCSXbPLJKKes8sost+xyy4EAADs="""
        #graphic for a coin animation frame
        coinFrame5Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak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"""
        #graphic for a coin animation frame
        coinFrame6Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak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"""
        #graphic for a coin animation frame
        coinFrame7Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak
DNSaC/q6D7+KBkYzBf7KEv72MP7aDKB2BHBTBc6aDCQaBLqKBOGqDzkpBr6WQOmqDAoLBvm+
IsuUB/q2EHlaB/7DFf7sLP7UL/7NMK19B++uDf7EJK6GNNejMR4aDv78KLeFCjIqFJZuBPa2
EdmeC+6+DEw7CqR6BOOzQsaeRLiMOP7cM2BKFCYeCN6rOf7kQP7+TRMOBcKOCTwuDC8jBJp2
JH9cBsWWIaJ+JBsVBgwGBNujF+2yJD4yGPbKHI5qHP7sQCoeBF5EBI5mBA4MBlI6BLiLGemr
FcqaJP7iMP70Qf7cI/7+N/7cQOKkDO6yFP68E3ZWBP6+HLJ+CEY2FP7LI///////////////
////////////////////////////////////////////////////////////////////////
/////////////////////////yH+Dk1hZGUgd2l0aCBHSU1QACH5BAEKAH8ALAAAAABKAEoA
AAf+gH+Cg4SFhoeIiYqLjI2Oj5CRkpOUlZYCAjMGM5oGnh0XlqKNTKVMFAkSI6sjXg+uCwMa
HSCjtoIkuRNZCWMfMQtdKCgdxR1cDSgPIV0DBrW3k1hYWgUJTDMfPBUqVFQuLgEBJ+JAAzIy
XB0LHTLQ0Y3TTk4lAgYqHEVUCDExXUooqhRr0IALiHAQHMjoMEwGEHiKfMhjIsAGDitWHnzY
6AWMlxDAFogk1qHBgAEgEDgA4YCgg4cQCznx4YOekRUrrHxIwROMR1fL+i0YRpRkShcQFqJo
UCOmIJoSt5jgcCMFkxRjeJoYY4Jnip+rvMAytrQBOhkKkaGECNUJkxv+PHiUmLs1hYkEnTRo
uIBihAFZGgYAWWhsoDsECwm6iAZ1CxMOck3QHZN1zIglLHbsYHGAigAdDI6E3lFjYMmSBVme
bRDGFk0sWzjYkLslRwkTXXmOUfKCAQMpUhhE4ULDg3EPPxQ0KLycoFkEiLkMqCDqdWweW0rU
nkvZMk8vVJooGK8gAJcMRESoF3GieQcNDeBr4MJlpUKzrSm9LnHDRo8tPdhWQi9ZfcVTAiaU
MsIMXayCyQwPoKDOQPFVWFBB6AxA32KSQPWWf//lIGBdXlFmgF4aJAFCFQn8dZIMKi1HYUH0
1XiOhuco0KEPPeDgH4AiDsiVVymMUCRmLCT+eUAGIxDAAAuhYXDCjMfUaOVJ78nQFCQ0ObEF
dgEKKGRWRhY5QhcHACeFB8INIAYAx0mhwADvHSOfdDUSRN+LW8Yj0VQ2aBfkbQX29BUYDyAg
HnkBaICeAukp4IJzyNBYowxm6SmDhg7A4EhUPtYm5laFHuoTGGNgk00MHYwgwAOcdNGBLKdZ
mSdBmKJTkAMZNDJTDybwIJmACFLGk5HIelFkKqr4hUIqAngxgxf0FWRnnrrm6pxJ6Oi4SE1M
qLCCZHSR6NWpPo0AxgZHsCAaBi40+YNvDOwwJTL0zVfttpRmOACHicxkghE3kEtgqUUW6dED
YKAgxA9qHqGADBH+rGncD0TQCR8y6WibKaYm0XmOCIpgQYIJK9h1G6mFGnnqAzD3A8QQUdQM
AwQdABEFeVFMai2+meIadKYlOXBCIgW0UMIHVqRwsGVluuzRwsAMw5Ce1srCxXw/7xk0yEPT
d4wMF3yBSA8FpDDEDSMYS6TL6iIaAsPqvsIwzEGB9MACIRFTLRcgBx70nns6YAEiJJQwAxVg
HPu2gT519AqzqlTOyuWttBLhpkN7rKe++A5wtCEl5PDBEFaUGvWhroAUAhgJjFAlni+ehU5a
qYEdeLaWnqQWCCQXkkUWH1Cxk6GniiVWCL+ABIarJ0Sx3vQifGH9ejXUd4LHguuJo3T+yXBx
QfCE5JDAB0WE0F13WDleZAgieTHCB946omEFLRGTDL8klSQdQ/UhgiGykIIqGOEDCciCBJg1
BglIoIEOLCAKFiC/GRzuEf6ogQwWMLcQwG8BLYmZSLrgAAdoCHB9EoTTYtAEBKCKBpk5wAE0
gwEMuMuGT4BBF+QnALM9wgAoqMAGuTAFKfzgiEeoAAhocEQkwuACAzAJCAQ4iAQkYAEqqEIK
YhCE4ADnN8CB2JoY8IUOyO8BPnQEq4SIAgcEAQBwRALGXPBGOAJACkQAwv4cQEVBZGUBEOjC
A5RABfKQhwiQIoIiFVCDKjxgQWlsxAM0gD/AheELFsgkEZT+eIJMZvILSrzaFAkhgRSgwAUo
kB8YYvCBGfhDCf/oRxeEQYxHohESBuiAEE+jp30dwyyAQwcXFtAAPpJyBFVwgRLAIIET6YUH
CHiWAZKQIhgt5BUziCQj1uiALsRAfCW8gDgvAAKWlNMFIEhHFwzSxz+oAgUBqMIImLCEJyVp
B0yqZ5IyAwMUhGAEMbigI07ERi4QYF6+EQ1CEcoCJXJBQsYcxCoaMKkHVOEFx/GAFKKgAYwa
BwAMsAAXYjCCBwi0EayCgQz2sgQ7uhQASIDpHUWAgPCNchASAEMVprSAKgRAkeopz7/U8wUR
bLIDMYDVSRlB0I7VwJNQzaQOPqn+xP3dVBAlbUA8SUoRAbhqBl5dECe8oL8QuGKpi+DmQ2Ng
NRQMQCFEKQZaMLWUq7rTCw04ARdCQAEXneQkSfjrOYDgAKR6wQBoVcQCDKDSCaKknAdxwAMM
AlkXxKiu7cyqC7jwyCC060migZJo3gWDDpg1oJAYSgX4YtB5HVFKRGziD5IIgr2ipJ0bbAAE
BrAADewAThn96Ed/IFIKIhYS68TfXuoYUzwG4I1IiO4PvgACD8rgBFMoBACBUJIAUG96RTVq
BRpgVgNocxGyquR1MZlJEXASql+AgWTZaQhXcGGzVpuPXvJlpQul8gEBgMQkVyudc8z1LG+9
QAkVIoP+upJvEB/hQhgIE9e2koUsIEGHJwwgq1l6WFYd8MQIKLmpvxb4RQbe1KZGihK0LoQL
SWFOMdShDr1YyhglLvGNbIdidwjRRidGce1G+oBOZdcQy1mJjE5TKz29B18OOUEFalCDKVeZ
ylSugJa3XAEYmFiwgs2QMB8QAxCcVxB8s2aNUTOfGc8OX8E8ywXQoeBxitMBc57zl/9qOxWn
g2+CgQIiCvucKManVlv7W57UMcFZFqUoxtBQYGQB5jD7uQHBMHIiHvovB+gPaHC2ke86ACsy
x8AAp/YmMNiqkD2DWcUp/jMtzjwIEBwjIROSj6VslY6HNkAIGnUtAyA27GH+H6EG37P0jnlM
Zi7UQAyLwJUJKxVqPAGOUiYRwmjpFRrfzIsFREjHq/mM4HQkdQAIoDUhQIArBCCjSqA7obYA
x4UKEOGTUfWkeytdOz+TbVOTBcEJCNCIAbQRAbW1lYaGtq3QXcl3/g7zjWK9YuvaVRG2BlwJ
bXVtoenKtIL0B4c7XJSVjNvASZAzkWkBgyM3ogJ0Wgmm6JOOjzmHrg04gLC57e0neZnPKOfx
QvwBAhhAGxILcUht+fU1oTmABQCIutSnHnU86rjfKSfbScjcAQQkdhFAiHPHGM5wGVRABPmO
qghUSvGs+wtm9amAyyFxgn5vC1MtITvF59pqodf+zu0DODcC5F4JZMfZ5mEz7QxA0o8PrloY
4vR3n6WTVAMgAAYEt0Td3+0SptOVCzo/ohFl28QkitntMkhCUllV9LkXXne8cw6njkD12s90
zqk/S2DgjhbC36IGDL45QU64pwqwN+1U7TM6YrYXBNTA9aP4wgnyvhpeb2rB2AeBgvH87xUb
AGbn6JQFoH8L+eb9atLp9cNzHGsc7Y1vlPW9UwQBynRWe/iSP0ta9hQDL3wTHUX3BeTnFO6l
YKM2DHiCGheiJ/0wQf7wWDUggPOnCJukGsT3UBP0aCiQVBzzWDAggRPICOpRASrRavtCKYDz
WCAQgeMXgpHgSRWQEHgXJk6QVU4s2IIuaAlQNVU7OIA5+IOjEAgAOw=="""
        #graphic for a coin animation frame
        coinFrame8Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak
DNSaC/q6D7+KBkYzBf7KEv72MP7aDKB2BHBTBc6aDCQaBLqKBOGqDzkpBr6WQOmqDAoLBvm+
IsuUB/q2EHlaB/7DFf7sLP7UL/7NMK19B++uDf7EJK6GNNejMR4aDv78KLeFCjIqFJZuBPa2
EdmeC+6+DEw7CqR6BOOzQsaeRLiMOP7cM2BKFCYeCN6rOf7kQP7+TRMOBcKOCTwuDC8jBJp2
JH9cBsWWIaJ+JBsVBgwGBNujF+2yJD4yGPbKHI5qHP7sQCoeBF5EBI5mBA4MBlI6BLiLGemr
FcqaJP7iMP70Qf7cI/7+N/7cQOKkDO6yFP68E3ZWBP6+HLJ+CEY2FP7LI///////////////
////////////////////////////////////////////////////////////////////////
/////////////////////////yH+Dk1hZGUgd2l0aCBHSU1QACH5BAEKAH8ALAAAAABKAEoA
AAf+gH+Cg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJmam5ydnp+glgEwFRWkpzChmwYDBhQFEgkS
sbMJDyAgA0Cqk0wSBSSzXQMDMsXGMskoXiMoXDEgvI3AJM0ZQECkLtvc3LgQQA0xHSjR0oZW
JCQUXh0VJzC4MssPDyH39wvl2A4gDf/lopwT1KIAkw4wYNQI02GBPXwQQyyQmE/fAFxhGqBA
AYSAKgQTJlBoICOKi4n2HoyYxdKLSpYSRlRE0aFDAy7/OsjgouCTgRZMvIAw6SBEvYcUDARY
GqCCDAoZmC5EsaBqVRQNHEDQiMIBkU4UWkiAMMqBy6P1Qkj4AqBt2yj+KNy2FQJEolWqWBvg
IplK0wQSD8LAcLDAi2G0KYF80cHYQo0GMHRAYUwEhNXL+v45+MflBKYALSigqFADRb3DiFWO
MOxS4uoHravavbtRn00uHbhAmGIpNBcYJ2GzdnnWXoIZF5JfcNGAggblCCBQxXx1I02cXdxh
oMSkwIMaEEIwG88a9lEJOuQCgDFDPQYgeO9W30huo4yvkkhMGAGhxoLVAA6XWg1QTGEgATA0
QAQNBk6hAwSX1YaXdfRpNIBAkGhQzQkVNADbaqyBiJp4D3RBk030WFfTdPJNqGID5HQAAg2P
WBEaCqWNN8KOIwhXnkuzzMAaFwtQIMBRC2j+dFWL+lC44j8nCOEIBRTIAAMQzOw4nJblwZYA
AXIhUcMIP8j1BAjTpalPkxTmhcIAXzRCAQkCKOAAj3iCKGKXRAjxxBMHbBBFA1P8+WcEYbC4
Zpsx1odCCOXwtohIt2SZZ5aYovZAV7jgMkAMegEBgqgNRLhkmyc2dE8DFSzyygMVUJEnj+SR
t+dwP6KFD4suohqjPjJsoMgEEnRwgmqzAqjljhJQkIAstMAk7Y4PNLnkVY5ytSJW+B1SQAso
wCBDsitdyoyzIXRhoromnuhuBzGEkFV8FNpmG000QeqApIask4QL5OIZ4o4JjEDEE0ckrPDC
CTNwABFZVdBQhE7+0oevSyjQeAixGhSRQAEgv0LlyCPHdO4I/DbygAwdhnDpPXlualoMKMRp
iAEkxEDFAAYhUEQRPv/sMwIIRCWDSrKIAYkEkP0nQQYuLFVDDSHMsNQJHIbBhXUIpExQFkDg
MEIBRHhgttkAeKAeAAqgMELBESz9W2EyqHcEEC6oJ0QGHRiFQhRSEJJOAkVUkYAJVDDGGAGM
N07AFAj+V/ASS3fA0AID6BDB5hFAEQYIUHDeeUawLVABAITgbEIRM5Rw+AcG2DCDErTXXgUK
Vfw3AjtBQDJCAy5MnJUDxBuzABcOKHfBAB0IuUAYHhDSXQocfJDFtyH9lcAYWagDMiz+zCYg
gLCPFMsQbBRIq34zMKq0ABCBD7IFCQkkYUIBE4hAw/77r0CCBWKgwRIGCIKVJMALL/Cd5Tqw
owgI4YEQ9JMEhbABF3DBZSEAwREIQYICJIAHCbhCCcTAgh2wgAUHCEAKXsACBrDgCDsYghcS
kAUBSOkRI3heA0LQAQysDQBIAGJbfkCEC3ohBDJ4AiF8QAITKCEHUFSCCqY4RR6MYQVGyOIQ
ajAuGj7gho4QAAoysoAOuCAKClAAEdRIhDa6MQqPIVEDwPgHLTjBBCsogTqcoI4Ofg9kWQik
CVLwtix0IYGPqFZGjIIWL1RFOGnBSkN61IG4DcIHTkgBD7b+gAUtlMAETCgBE0bJBAHM4AOy
48EIUkDDLtCRETF43tGcM4AkJEEXMpAAK4ihC3+kKGVYwIIJbOAEHwjgAAdg4QFO2MJmeuAF
47peFQ4AiS7EwIIqOYB6iDCCIKjHAkeTgBdkoDFBmMAJWzBBD3xgAwsoTgeNC+ASBKgDDoxA
mtR8RN9gMACJQGEHGAjoDizgAAvs4AgBPQIUgNCsB8DgB4S4wAQMIoB1CEADBjCABjCaBA3Y
UgMy0MADPlYAJSjtEQbwgrhoNgAXnCAAWMvAALjg0hPU4AQuGFcOFYC6QQigIBqYgff+SNSR
JcBZIEuBCiBBgREMBlJXUReqVNT+AcOYDgmESMBEq1BRahA1ZAXIApWOSoEsDJKGgczCs9a6
1lhQyQs1IAybKlaTujZkFg1gSyG6IwtggMyPXzUqlVKgBCuAAGjYgIBitwGBbnDDKRTzlV29
EBMgKLEQ+INFAvr4VbAWwKhj6IIVRis0xAJBsajtBggmZp251tVds8jgBgsREs16tbOfFauz
nPUsE4zht6vcERjAgJiIRJZR+HpATCATP0JQgQJ/2V0fAdvZsR6OpIE8althckSJ8MpX+Kqr
SpBoyX510Atz4qxnQ6ZbGn4sC0OAwRCa0AQ0pvG+CrAABLowG6jOFV9ccZsETDdbQ4Cgg2Kd
LnX/WFb+KpWgBFlYQdrUBoAKW/jC4JzNqSqGr901Ywo93Zh+/jrd773CxFTKgut4IAICwJMA
/KOBGGYcATEoQAYadlGMsJKvWaDgBJdFhAYy+4u/qPeP11NrDg5nghisYAUyWEESrCADEPSj
Uw54FHWmSpPC2KIDFsCqIvr4MQUH9rMUWHIOhpqDQJaVrTHRMJuaZNeNvG3AECCfIjQwp4lS
w3vrYPBnr7DmBGixBkOILwyisOgoRIEILtAybVClpFksYDdiXgTORPILznbwxLlN8/U44AEp
oO3CqIYCjpmkoiY9gAIPaIACINqIJLRgomU+MlGzQOgIv3h/Mx5gBIJA7CD+fKEox7WYaZ51
CxA/YgZZ+AuJF4zmAkCxBGNQwg2ssG0rmBa1EPAHbRaFL9M4SygWoDVKobuOEwMW1BQg9BVK
nFY4x7ki86GPQxrqgC+oGxIGiLY6jFzUz0JxAhG+wAouYFigIQAbQKBCDeBDMTa57NwOEAED
KjGD9E6USrvOQg/WrIJSm5rCqK4wFJA9aYc8SwIPGAARCkyJGfy5uvFuMxXEMMAX+ByZB9jB
Af6EgYW23GXPOuIAFEBzSgxBA7/wKshfwescYPsGOMABFVVghBMYoRSlIKN8DAjzASCACNvJ
hA6aoIHNftqvZSX0g8ewow+oZrjDPaJ17FKP3RW9LARcIMIGMq0JGHShWSQO2bWf9dsUEFK4
hsGHbJDWEi7IQAFp94QOhpCEoxL1CnL3reNHkHdcvcbvB4SUzDewcV7ws1ki64E61GqCw/12
DI8Hw0qcRQuZvIkIEWj9QIZwgbclIAdX8CBas8t4WawVRBIJfPAHYgg1IiAFVse2e7fHEjxV
a2X6E4PwqX8I+hJBBUogpBfwfo9YegEIRIACFGgwfvIzQgRDUEAT1MhGEfh/CvVnfwI4gAQ4
CIEAADs="""
        #graphic for a coin animation frame
        coinFrame9Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak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"""
        #graphic for a coin animation frame
        coinFrame10Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak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"""
        #graphic for a coin animation frame
        coinFrame11Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak
DNSaC/q6D7+KBkYzBf7KEv72MP7aDKB2BHBTBc6aDCQaBLqKBOGqDzkpBr6WQOmqDAoLBvm+
IsuUB/q2EHlaB/7DFf7sLP7UL/7NMK19B++uDf7EJK6GNNejMR4aDv78KLeFCjIqFJZuBPa2
EdmeC+6+DEw7CqR6BOOzQsaeRLiMOP7cM2BKFCYeCN6rOf7kQP7+TRMOBcKOCTwuDC8jBJp2
JH9cBsWWIaJ+JBsVBgwGBNujF+2yJD4yGPbKHI5qHP7sQCoeBF5EBI5mBA4MBlI6BLiLGemr
FcqaJP7iMP70Qf7cI/7+N/7cQOKkDO6yFP68E3ZWBP6+HLJ+CEY2FP7LI///////////////
////////////////////////////////////////////////////////////////////////
/////////////////////////yH+Dk1hZGUgd2l0aCBHSU1QACH5BAEKAH8ALAAAAABKAEoA
AAf+gH+Cg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJmam5ydnp+goaKjpKWmp6ipqqusra6vsLGy
s7S1tpg6FrlQFry+vRYEG7IENFMiIhbKOlBTzs/QzwTKylMRYkGmERbJulA0YjTGERHR5tDi
NARQ7FA6YkKeNMrJ3+LhYmLQ6+zM/u3tCDxjR0CgOmYCMdHI9UVHMTEvIhibwk9HLmVfqGnc
aBEgFIEUQ66bQiPCE0lLvohwSEDMBn1T+jFrZ2HKkx04n+jcibMnhiAePRr8GDLbI5UOl+Qz
FjToFAwsoB5hMZWFVatHMGDY0DRoQX4Chy3SkYyAUn1dm+qYkk+ixHz+cN+WS9u0IEEaRxJN
s0BjSZCYdJt6wKm1sOHCUoA2BUyXQBAMh8jq6Ms08GK4mDOXm8suJmPGzQACFsigEI2VjiPw
owuanYUIQmLH3iCENm3ZGwCD/uyRN5QNUghlNCtm9eLeATcczso8K4YjTyJ0Dj09tOfqAU8K
mjcZreh2vBnrGk/+IrWLvpBTv9663QYkgnaJka4+cM0IQfDrzx+EP7m/nbGHXX3g/bBdMAD2
Yhl1vbwHCVfktEcdcp8F94cuU+THzg8/7LQTBh4KgQFgFmwAACQx5cbLexgIodMRziABok61
iWbgH0H0Yo1rUMj2RG4lxvZEbSRGAN8j7HD+xo6QsbUj5BPO9NPjiYJ0xtkRP7hY219YCrkB
fcwc6UgzV2r55JBDCvEDV+40I6YgOu42kGfRAFTaIzUB2Aw6AdbJyxRiFRJSTAQ8dwSWhyZ6
BAMMPOGaDpDhSU6SizLKwAGAVsrAmuDlhUiACzoVRGak5kMRFJOmZRxAEUSaiBgf2eXOTG3S
GpAzxgkEFlERtvfVOl8B5GAjQNlFgEX/dNQUXoUdEUShUT0nhKwfxVqttazeCAlMwQbUpkfM
0CDFuPpMRoMHUvyAa6zAskstFEFoO0lupwK0jkPugHXAATttQABOB+ywVbC/BjuTTW9egsES
9bZJ8EcHYLDvDuVS7BBwwAB261GrCXfCwpcNE1RQOsaULE7IAjUTBJas7FBbOVEWXBCdEWyg
3J235Kzzzjz37PPPQAct9NBEF2300UgnrfTSTDft9NNQRy311J0EAgA7"""
        #graphic for a coin animation frame
        coinFrame12Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak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"""
        #graphic for a coin animation frame
        coinFrame13Data = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak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"""
        #graphic for a coin animation frame
        coinFrameYinData = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak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"""
        #graphic for a coin animation frame
        coinFrameYangData = """R0lGODlhSgBKAOcAAAMCBK6CB/rCFNaiDFZCBP7iHCoiBeayFMKSBIZiCP7SEfKyDzgyJBIS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"""
        #graphic for a coin animation frame
        coinFrameBlankData = """R0lGODlhSgBKAMYAAAUFBLCDC+7CDN2jDFdDDP7kIOa1DCkiCsWSCv7UHYhkB/OyEBUSB+ak
DNSaC/q6D7+KBkYzBf7KEv72MP7aDKB2BHBTBc6aDCQaBLqKBOGqDzkpBr6WQOmqDAoLBvm+
IsuUB/q2EHlaB/7DFf7sLP7UL/7NMK19B++uDf7EJK6GNNejMR4aDv78KLeFCjIqFJZuBPa2
EdmeC+6+DEw7CqR6BOOzQsaeRLiMOP7cM2BKFCYeCN6rOf7kQP7+TRMOBcKOCTwuDC8jBJp2
JH9cBsWWIaJ+JBsVBgwGBNujF+2yJD4yGPbKHI5qHP7sQCoeBF5EBI5mBA4MBlI6BLiLGemr
FcqaJP7iMP70Qf7cI/7+N/7cQOKkDO6yFP68E3ZWBP6+HLJ+CEY2FP7LI///////////////
////////////////////////////////////////////////////////////////////////
/////////////////////////yH+Dk1hZGUgd2l0aCBHSU1QACH5BAEKAH8ALAAAAABKAEoA
AAdrgH+Cg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJmam5ydnp+goaKjpKWmp6ipqqusra6vsLGy
s7S1tre4ubq7vL2+v8DBwsPExcbHyMnKy8zNzs/Q0dLT1NXW19jZ2tvc3d7f4OHi4+Tl5ufo
kIEAOw=="""
        
        self.coinFrames = (
            Image('photo',data=coinFrame0Data),Image('photo',data=coinFrame1Data),
            Image('photo',data=coinFrame2Data),Image('photo',data=coinFrame3Data),
            Image('photo',data=coinFrame4Data),Image('photo',data=coinFrame5Data),
            Image('photo',data=coinFrame6Data),Image('photo',data=coinFrame7Data),
            Image('photo',data=coinFrame8Data),Image('photo',data=coinFrame9Data),
            Image('photo',data=coinFrame10Data),Image('photo',data=coinFrame11Data),
            Image('photo',data=coinFrame12Data),Image('photo',data=coinFrame13Data),
            Image('photo',data=coinFrameYinData),Image('photo',data=coinFrameYangData), 
            Image('photo',data=coinFrameBlankData) )
