/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HeaderInputStream
extends FilterInputStream {
    private byte[] lineBuf;
    private int bytesRemaining = 0;
    private int currentOffset = 0;
    private byte[] endSequence = new byte[]{10, 68, 97, 116, 97, 58, 10};
    private boolean endFound = false;

    public HeaderInputStream(InputStream in) {
        super(in);
        this.lineBuf = new byte[4096];
    }

    public int available() {
        return this.bytesRemaining;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.bytesRemaining == 0 && !this.endFound) {
            this.getMoreBytes();
        }
        if (this.bytesRemaining == 0) {
            return -1;
        }
        --this.bytesRemaining;
        return this.lineBuf[this.currentOffset++];
    }

    private void getMoreBytes() throws IOException {
        int c;
        int bytesRead;
        this.currentOffset = 0;
        int lookingFor = 0;
        for (bytesRead = 0; bytesRead < this.lineBuf.length && (c = this.in.read()) != -1; ++bytesRead) {
            this.lineBuf[bytesRead] = (byte)c;
            if (this.lineBuf[bytesRead] == this.endSequence[lookingFor]) {
                if (++lookingFor != this.endSequence.length) continue;
                this.endFound = true;
                break;
            }
            lookingFor = this.lineBuf[bytesRead] == this.endSequence[0] ? 1 : 0;
        }
        this.bytesRemaining = bytesRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (len <= 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return i;
    }

    public long skip(long n) {
        if ((long)this.bytesRemaining >= n) {
            this.bytesRemaining = (int)((long)this.bytesRemaining - n);
            return n;
        }
        int oldBytesRemaining = this.bytesRemaining;
        this.bytesRemaining = 0;
        return oldBytesRemaining;
    }
}

