/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinarySerializedObject
implements BinaryObject {
    public static final int computeBytes(Object obj) {
        byte[] bytes;
        try {
            bytes = BinarySerializedObject.getBytes(obj);
        }
        catch (IOException ioe) {
            return 0;
        }
        return 5 + bytes.length + 1;
    }

    public static byte[] getBytes(Object obj) throws IOException {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outBytes);
        outStream.writeObject(obj);
        outStream.flush();
        outStream.close();
        return outBytes.toByteArray();
    }

    public static final Object read(DataInput file) throws IOException {
        int len = file.readInt();
        return BinarySerializedObject.read(file, len);
    }

    public static final Object read(DataInput file, int len) throws IOException {
        Object obj;
        if (len <= 1) {
            throw new IOException("Corrupted file (bad serialized object length)");
        }
        byte[] bytes = new byte[len - 1];
        file.readFully(bytes);
        byte endByte = file.readByte();
        if (endByte != 80) {
            throw new IOException("Corrupted file (no serialized object end-marker)");
        }
        ByteArrayInputStream inBytes = new ByteArrayInputStream(bytes);
        ObjectInputStream inStream = new ObjectInputStream(inBytes);
        try {
            obj = inStream.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Couldn't read serialized object: " + cnfe.getMessage());
        }
        inStream.close();
        return obj;
    }

    public static final void write(BinaryWriter writer, byte objType, Object obj, Object token) throws IOException {
        byte[] bytes = BinarySerializedObject.getBytes(obj);
        DataOutput file = writer.getOutput();
        file.writeByte(objType);
        file.writeInt(bytes.length + 1);
        file.write(bytes);
        file.writeByte(80);
    }
}

