import unittest
import gsm


class TestGsm(unittest.TestCase):

    def testWrongValues(self):
        self.assertRaises(ValueError, gsm.gsm, 2)
        self.assertRaises(TypeError, gsm.gsm, "abc")

    def testBadEncode(self):
        g = gsm.gsm(gsm.BIG)
        self.assertRaises(TypeError, g.encode, 12)
        self.assertRaises(ValueError, g.encode, "Abc")
        self.assertRaises(ValueError, g.encode, "a" * 321)

    def testBadDecode(self):
        g = gsm.gsm(gsm.BIG)
        self.assertRaises(TypeError, g.decode, 12)
        self.assertRaises(ValueError, g.decode, "Abc")
        self.assertRaises(ValueError, g.decode, "a" * 34)
        self.assertRaises(ValueError, g.decode, "\x00" * 33)
        
    def testEncode(self):
        g = gsm.gsm(gsm.BIG)
        resultBig = g.encode("\x64\x00" * 160)
        g = gsm.gsm(gsm.LITTLE)
        resultLittle = g.encode("\x00\x64" * 160)
        self.assertEquals(len(resultBig), 33)
        self.assertEquals(resultBig, resultLittle)

    def testDecodeEndianess(self):
        g = gsm.gsm(gsm.BIG)
        result = g.encode("\x64\x00" * 160)
        unBig = gsm.gsm(gsm.BIG).decode(result)
        unLittle = gsm.gsm(gsm.LITTLE).decode(result)
        for i in range(160):
            self.assertEquals(unBig[i * 2], unLittle[(i*2)+1])
            self.assertEquals(unLittle[i * 2], unBig[(i*2)+1])


if __name__ == '__main__':
    unittest.main()
