#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
#
# threaded_rec.py -
# Copyright (C) 2006  Sbastien Martini <sebastien.martini@gmail.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# usage: ./threaded_rec.py [path-to-watch]

from rec import PRec
# please read src/examples/README
try:
    # import local build
    import autopath
    from src.pyinotify.pyinotify import ThreadedNotifier, WatchManager, \
         EventsCodes
except ImportError:
    # import global (installed) pyinotify
    from pyinotify import ThreadedNotifier, WatchManager, EventsCodes


if __name__ == '__main__':
    #
    # Full description: see threaded.py
    #
    import sys

    path = '/tmp/'
    if sys.argv[1:]:
        path = sys.argv[1]

    mask = EventsCodes.ALL_EVENTS

    # watch manager instance
    wm = WatchManager()
    # notifier instance and init
    notifier = ThreadedNotifier(wm)
    # start notifier's thread
    notifier.start()

    wm.add_watch(path, mask, proc_fun=PRec(wm))

    print 'start monitoring %s with mask 0x%08x' % (path, mask)

    # keep artificially the main thread alive forever
    while True:
        try:
            import time
            time.sleep(5)
        except KeyboardInterrupt:
            # ...until c^c signal
            print 'stop monitoring...'
            # stop monitoring
            notifier.stop()
            break
        except Exception, err:
            # otherwise keep on looping
            print err
