import struct
#import marshal

# ___________________________________________________________________________
#
# Messages
# ___________________________________________________________________________
# the size of a number on the wire
numsize = struct.calcsize("!i")

class Message:
    """ encapsulates Messages and their wire protocol. """
    _types = {}
    def __init__(self, channelid=0, data=''):
        self.channelid = channelid
        self.data = data

    def writeto(self, io):
        # big XXX and all this
        #     data = marshal.dumps(self.data)
        # doesn't work for exchanging data across Python version :-(((
        data = repr(self.data)  # argh

        header = struct.pack("!iii", self.msgtype, self.channelid, len(data))
        io.write(header)
        io.write(data)

    def readfrom(cls, io):
        header = io.read(numsize*3)
        msgtype, senderid, stringlen = struct.unpack("!iii", header)
        if stringlen:
            string = io.read(stringlen)
            # same big XXX as in writeto()
            #     string = marshal.loads(string)
            string = eval(string, {})
        else:
            string = ''
        msg = cls._types[msgtype](senderid, string)
        return msg
    readfrom = classmethod(readfrom)

    def post_sent(self, gateway, excinfo=None):
        pass

    def __repr__(self):
        r = repr(self.data)
        if len(r) > 50:
            return "<Message.%s channelid=%d len=%d>" %(self.__class__.__name__,
                        self.channelid, len(r))
        else:
            return "<Message.%s channelid=%d %r>" %(self.__class__.__name__,
                        self.channelid, self.data)


def _setupmessages():

    class CHANNEL_OPEN(Message):
        def received(self, gateway):
            channel = gateway.channelfactory.new(self.channelid)
            gateway._local_schedulexec(channel=channel, sourcetask=self.data)

    class CHANNEL_NEW(Message):
        def received(self, gateway):
            """ receive a remotely created new (sub)channel. """
            newid = self.data
            newchannel = gateway.channelfactory.new(newid)
            gateway.channelfactory._local_receive(self.channelid, newchannel)

    class CHANNEL_DATA(Message):
        def received(self, gateway):
            gateway.channelfactory._local_receive(self.channelid, self.data)

    class CHANNEL_CLOSE(Message):
        def received(self, gateway):
            gateway.channelfactory._local_close(self.channelid)

    class CHANNEL_CLOSE_ERROR(Message):
        def received(self, gateway):
            remote_error = gateway.channelfactory.RemoteError(self.data)
            gateway.channelfactory._local_close(self.channelid, remote_error)

    class CHANNEL_LAST_MESSAGE(Message):
        def received(self, gateway):
            gateway.channelfactory._local_last_message(self.channelid)

    classes = [x for x in locals().values() if hasattr(x, '__bases__')]
    classes.sort(lambda x,y : cmp(x.__name__, y.__name__))
    i = 0
    for cls in classes:
        Message._types[i] = cls
        cls.msgtype = i
        setattr(Message, cls.__name__, cls)
        i+=1

_setupmessages()

