/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttrCheck;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Report;

public class AttrCheckImpl {
    private static AttrCheck _checkUrl = new CheckUrl();
    private static AttrCheck _checkScript = new CheckScript();
    private static AttrCheck _checkAlign = new CheckAlign();
    private static AttrCheck _checkValign = new CheckValign();
    private static AttrCheck _checkBool = new CheckBool();
    private static AttrCheck _checkId = new CheckId();
    private static AttrCheck _checkName = new CheckName();

    public static AttrCheck getCheckAlign() {
        return _checkAlign;
    }

    public static AttrCheck getCheckBool() {
        return _checkBool;
    }

    public static AttrCheck getCheckId() {
        return _checkId;
    }

    public static AttrCheck getCheckName() {
        return _checkName;
    }

    public static AttrCheck getCheckScript() {
        return _checkScript;
    }

    public static AttrCheck getCheckUrl() {
        return _checkUrl;
    }

    public static AttrCheck getCheckValign() {
        return _checkValign;
    }

    public static class CheckUrl
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                Report.attrError(lexer, node, attVal.attribute, (short)3);
            } else if (lexer.configuration.FixBackslash) {
                attVal.value = attVal.value.replace('\\', '/');
            }
        }
    }

    public static class CheckScript
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
        }
    }

    public static class CheckAlign
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (node.tag != null && (node.tag.model & 0x10000) != 0) {
                AttrCheckImpl.getCheckValign().check(lexer, node, attVal);
                return;
            }
            String string = attVal.value;
            if (string == null) {
                Report.attrError(lexer, node, attVal.attribute, (short)3);
            } else if (Lexer.wstrcasecmp(string, "left") != 0 && Lexer.wstrcasecmp(string, "center") != 0 && Lexer.wstrcasecmp(string, "right") != 0 && Lexer.wstrcasecmp(string, "justify") != 0) {
                Report.attrError(lexer, node, attVal.value, (short)4);
            }
        }
    }

    public static class CheckValign
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            String string = attVal.value;
            if (string == null) {
                Report.attrError(lexer, node, attVal.attribute, (short)3);
            } else if (Lexer.wstrcasecmp(string, "top") != 0 && Lexer.wstrcasecmp(string, "middle") != 0 && Lexer.wstrcasecmp(string, "bottom") != 0 && Lexer.wstrcasecmp(string, "baseline") != 0) {
                if (Lexer.wstrcasecmp(string, "left") == 0 || Lexer.wstrcasecmp(string, "right") == 0) {
                    if (node.tag == null || (node.tag.model & 0x10000) == 0) {
                        Report.attrError(lexer, node, string, (short)4);
                    }
                } else if (Lexer.wstrcasecmp(string, "texttop") == 0 || Lexer.wstrcasecmp(string, "absmiddle") == 0 || Lexer.wstrcasecmp(string, "absbottom") == 0 || Lexer.wstrcasecmp(string, "textbottom") == 0) {
                    lexer.versions = (short)(lexer.versions & 0x1C0);
                    Report.attrError(lexer, node, string, (short)6);
                } else {
                    Report.attrError(lexer, node, string, (short)4);
                }
            }
        }
    }

    public static class CheckBool
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
        }
    }

    public static class CheckId
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
        }
    }

    public static class CheckName
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
        }
    }
}

