/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jline.Terminal;

public class WindowsTerminal
extends Terminal {
    private static final int ENABLE_LINE_INPUT = 2;
    private static final int ENABLE_ECHO_INPUT = 4;
    private static final int ENABLE_PROCESSED_INPUT = 1;
    private static final int ENABLE_WINDOW_INPUT = 8;
    private static final int ENABLE_MOUSE_INPUT = 16;
    private static final int ENABLE_PROCESSED_OUTPUT = 1;
    private static final int ENABLE_WRAP_AT_EOL_OUTPUT = 2;
    private Boolean directConsole;

    public WindowsTerminal() {
        String string = System.getProperty("jline.WindowsTerminal.directConsole");
        if ("true".equals(string)) {
            this.directConsole = Boolean.TRUE;
        } else if ("false".equals(string)) {
            this.directConsole = Boolean.FALSE;
        }
    }

    private native int getConsoleMode();

    private native void setConsoleMode(int var1);

    private native int readByte();

    private native int getWindowsTerminalWidth();

    private native int getWindowsTerminalHeight();

    public int readCharacter(InputStream inputStream) throws IOException {
        if (this.directConsole == Boolean.FALSE) {
            return super.readCharacter(inputStream);
        }
        if (this.directConsole == Boolean.TRUE || inputStream == System.in || inputStream instanceof FileInputStream && ((FileInputStream)inputStream).getFD() == FileDescriptor.in) {
            return this.readByte();
        }
        return super.readCharacter(inputStream);
    }

    public void initializeTerminal() throws Exception {
        this.loadLibrary("jline");
        final int n = this.getConsoleMode();
        this.setConsoleMode(n & 0xFFFFFFFB);
        int n2 = n & 0xFFFFFFF0;
        this.setConsoleMode(n2);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void start() {
                    WindowsTerminal.this.setConsoleMode(n);
                }
            });
        }
        catch (AbstractMethodError abstractMethodError) {
            this.consumeException(abstractMethodError);
        }
    }

    private void loadLibrary(String string) throws IOException {
        File file;
        block4: {
            String string2 = this.getClass().getPackage().getImplementationVersion();
            if (string2 == null) {
                string2 = "";
            }
            string2 = string2.replace('.', '_');
            file = new File(System.getProperty("java.io.tmpdir"), string + "_" + string2 + ".dll");
            boolean bl = file.isFile();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getClass().getResourceAsStream(string + ".dll"));
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                byte[] byArray = new byte[10240];
                int n = 0;
                while (n != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    n = ((InputStream)bufferedInputStream).read(byArray);
                }
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                if (bl) break block4;
                throw iOException;
            }
        }
        file.deleteOnExit();
        System.load(file.getAbsolutePath());
    }

    public int readVirtualKey(InputStream inputStream) throws IOException {
        int n = this.readCharacter(inputStream);
        if (n == 224) {
            n = this.readCharacter(inputStream);
            if (n == 72) {
                return 16;
            }
            if (n == 80) {
                return 14;
            }
            if (n == 75) {
                return 2;
            }
            if (n == 77) {
                return 6;
            }
        }
        return n;
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isANSISupported() {
        return false;
    }

    public boolean getEcho() {
        return false;
    }

    public int getTerminalWidth() {
        return this.getWindowsTerminalWidth();
    }

    public int getTerminalHeight() {
        return this.getWindowsTerminalHeight();
    }

    private void consumeException(Throwable throwable) {
    }

    public void setDirectConsole(Boolean bl) {
        this.directConsole = bl;
    }

    public Boolean getDirectConsole() {
        return this.directConsole;
    }
}

