import Plugin1DBase
import numpy
try:
    import PyMca.PyMca_Icons as PyMca_Icons
    import PyMca.SGWindow as SGWindow
    import PyMca.SGModule as SGModule
except ImportError:
    #This happens in frozen versions
    import PyMca_Icons
    import SGWindow
    import SGModule


class SG1DPlugins(Plugin1DBase.Plugin1DBase):
    def __init__(self, plotWindow, **kw):
        Plugin1DBase.Plugin1DBase.__init__(self, plotWindow, **kw)
        self.methodDict = {'Configure':[self.configureFilter,
                                       "Configure Savitzky-Golay Filter",
                                       None],
                          'Apply Current':[self.applyFilter,
                                       "Apply current configuration",
                                       None]}
        
    #Methods to be implemented by the plugin
    def getMethods(self, plottype=None):
        """
        A list with the NAMES  associated to the callable methods
        that are applicable to the specified plot.

        Plot type can be "SCAN", "MCA", None, ...        
        """
        names = self.methodDict.keys()
        names.sort()
        return names

    def getMethodToolTip(self, name):
        """
        Returns the help associated to the particular method name or None.
        """
        return self.methodDict[name][1]

    def getMethodPixmap(self, name):
        """
        Returns the pixmap associated to the particular method name or None.
        """
        return self.methodDict[name][2]

    def applyMethod(self, name):
        """
        The plugin is asked to apply the method associated to name.
        """
        apply(self.methodDict[name][0])
        return

    def configureFilter(self):
        activeCurve = self.getActiveCurve()
        if activeCurve is None:
            return
        x, y, legend, info = activeCurve [0:4]
        xlimits=self.getGraphXLimits()
        spectrum = y[(x>=xlimits[0]) and (x<=xlimits[1])]
        dialog = SGWindow.SGDialog(None, spectrum)
        ret = dialog.exec_()
        if ret:
            self.applyFilter(x, y)

    def applyFilter(self, x=None, y=None):
        if y is None:
            activeCurve = self.getActiveCurve()
            if activeCurve is None:
                return
            x, y, legend, info = activeCurve [0:4]
            xlimits=self.getGraphXLimits()
            y = y[(x>=xlimits[0]) and (x<=xlimits[1])]
            x = x[(x>=xlimits[0]) and (x<=xlimits[1])]
        x, y = self.simpleMath.derivate(x, y, xlimits=xlimits)
        info['ylabel'] = info['ylabel'] + "'"
        operations = info.get("operations", [])
        operations.append("derivate")
        info['operations'] = operations
        legend = legend+"'"
        self.addCurve(x, y, legend=legend, info=info, replot=True)
        

MENU_TEXT = "Built-in Math"
def getPlugin1DInstance(plotWindow, **kw):
    ob = MathPlugins(plotWindow)
    return ob

if __name__ == "__main__":
    from PyMca import Plot1D
    x = numpy.arange(100.)
    y = x * x
    plot = Plot1D.Plot1D()
    plot.addCurve(x, y, "dummy")
    plot.addCurve(x+100, -x*x)
    plugin = getPlugin1DInstance(plot)
    for method in plugin.getMethods():
        print method, ":", plugin.getMethodToolTip(method)
    plugin.applyMethod(plugin.getMethods()[0])
    curves = plugin.getAllCurves()
    for curve in curves:
        print curve[2]
    print "LIMITS = ", plugin.getGraphYLimits()
