/*
This Font Software is Copyright (c) 2003-2005, SIL International (http://scripts.sil.org/).
All Rights Reserved.

"Gentium" is a Reserved Font Name for this Font Software.
"SIL" is a Reserved Font Name for this Font Software.

This Font Software is licensed under the SIL Open Font License, Version 1.0.
No modification of the license is permitted, only verbatim copy is allowed.
This license is copied below, and is also available with a FAQ at:
http://scripts.sil.org/OFL


-----------------------------------------------------------
SIL OPEN FONT LICENSE Version 1.0 - 22 November 2005
-----------------------------------------------------------

PREAMBLE
The goals of the Open Font License (OFL) are to stimulate worldwide
development of cooperative font projects, to support the font creation
efforts of academic and linguistic communities, and to provide an open
framework in which fonts may be shared and improved in partnership with
others.

The OFL allows the licensed fonts to be used, studied, modified and
redistributed freely as long as they are not sold by themselves. The
fonts, including any derivative works, can be bundled, embedded, 
redistributed and sold with any software provided that the font
names of derivative works are changed. The fonts and derivatives,
however, cannot be released under any other type of license.

DEFINITIONS
"Font Software" refers to any and all of the following:
	- font files
	- data files
	- source code
	- build scripts
	- documentation

"Reserved Font Name" refers to the Font Software name as seen by
users and any other names as specified after the copyright statement.

"Standard Version" refers to the collection of Font Software
components as distributed by the Copyright Holder.

"Modified Version" refers to any derivative font software made by
adding to, deleting, or substituting -- in part or in whole --
any of the components of the Standard Version, by changing formats
or by porting the Font Software to a new environment.

"Author" refers to any designer, engineer, programmer, technical
writer or other person who contributed to the Font Software.

PERMISSION & CONDITIONS
Permission is hereby granted, free of charge, to any person obtaining
a copy of the Font Software, to use, study, copy, merge, embed, modify,
redistribute, and sell modified and unmodified copies of the Font
Software, subject to the following conditions:

1) Neither the Font Software nor any of its individual components,
in Standard or Modified Versions, may be sold by itself.

2) Standard or Modified Versions of the Font Software may be bundled,
redistributed and sold with any software, provided that each copy
contains the above copyright notice and this license. These can be
included either as stand-alone text files, human-readable headers or
in the appropriate machine-readable metadata fields within text or
binary files as long as those fields can be easily viewed by the user.

3) No Modified Version of the Font Software may use the Reserved Font
Name(s), in part or in whole, unless explicit written permission is
granted by the Copyright Holder. This restriction applies to all 
references stored in the Font Software, such as the font menu name and
other font description fields, which are used to differentiate the
font from others.

4) The name(s) of the Copyright Holder or the Author(s) of the Font
Software shall not be used to promote, endorse or advertise any
Modified Version, except to acknowledge the contribution(s) of the
Copyright Holder and the Author(s) or with their explicit written
permission.

5) The Font Software, modified or unmodified, in part or in whole,
must be distributed using this license, and may not be distributed
under any other license.

TERMINATION
This license becomes null and void if any of the above conditions are
not met.

DISCLAIMER
THE FONT SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
OF COPYRIGHT, PATENT, TRADEMARK, OR OTHER RIGHT. IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
INCLUDING ANY GENERAL, SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF THE USE OR INABILITY TO USE THE FONT SOFTWARE OR FROM
OTHER DEALINGS IN THE FONT SOFTWARE.


list = [
    "GenR102.TTF",
    "GenI102.TTF"]


out = open("FontTTF2.h",'w')
out.write("/"+"*\n")
out.write(open("OFL.txt").read())
out.write(open("FontTTF2.py").read())
out.write("*"+"/\n\n")

for name in list:
    prefix = name[:-4]
    inp = open(name)
    d = inp.read()
    l = len(d)
    out.write("static unsigned int TTF_%s_len = %d;\n"%(prefix,l))
    out.write("static unsigned char TTF_%s_dat[] = {\n"%prefix)
    for a in range(0,l):
        if a:
            out.write(",")
        if (a & 0xF) == 0:
            out.write("\n")
        out.write("%1d"%ord(d[a]))
    out.write("\n")
    out.write("};\n")

out.close()


    

*/

static unsigned int TTF_GenR102_len = 362664;
static unsigned char TTF_GenR102_dat[] = {

0,1,0,0,0,18,1,0,0,4,0,32,76,84,83,72,
248,25,135,209,0,4,159,232,0,0,6,167,79,83,47,50,
113,162,99,85,0,4,159,144,0,0,0,86,86,68,77,88,
103,87,110,218,0,4,166,144,0,0,5,224,99,109,97,112,
92,14,1,215,0,4,154,240,0,0,4,128,99,118,116,32,
1,134,7,71,0,4,33,100,0,0,0,26,102,112,103,109,
50,77,115,102,0,0,27,184,0,0,1,98,103,97,115,112,
0,23,0,8,0,4,172,112,0,0,0,16,103,108,121,102,
249,46,247,148,0,0,56,20,0,3,233,80,104,100,109,120,
198,68,206,208,0,4,172,128,0,0,153,32,104,101,97,100,
222,179,47,181,0,4,33,128,0,0,0,54,104,104,101,97,
13,74,11,169,0,4,33,184,0,0,0,36,104,109,116,120,
240,202,210,157,0,0,1,44,0,0,26,140,107,101,114,110,
20,102,0,124,0,5,69,160,0,0,67,8,108,111,99,97,
14,244,238,118,0,0,29,132,0,0,26,144,109,97,120,112,
8,189,4,114,0,4,159,112,0,0,0,32,110,97,109,101,
249,232,206,194,0,4,97,132,0,0,57,108,112,111,115,116,
227,193,180,240,0,4,33,220,0,0,63,166,112,114,101,112,
139,16,14,45,0,0,29,28,0,0,0,104,1,195,0,0,
0,0,0,0,1,195,0,0,1,195,0,0,3,193,0,88,
5,133,0,76,5,86,0,80,2,0,0,160,2,137,0,121,
2,137,0,41,3,147,0,70,3,72,0,61,1,213,0,88,
2,178,0,61,1,213,0,131,3,193,0,49,3,193,0,76,
3,193,0,139,3,193,0,98,3,193,0,68,3,193,0,55,
3,193,0,78,3,193,0,111,3,193,0,104,3,193,0,94,
3,193,0,100,1,213,0,131,1,213,0,88,3,131,0,61,
3,131,0,61,3,131,0,61,3,119,0,80,6,117,0,70,
4,195,0,0,4,102,0,41,4,74,0,70,4,190,0,41,
3,248,0,50,3,211,0,50,4,170,0,70,5,59,0,50,
2,98,0,70,2,113,255,66,4,160,0,50,3,207,0,50,
6,115,0,60,5,49,0,50,4,205,0,70,4,47,0,41,
4,205,0,70,4,125,0,41,3,207,0,117,4,104,0,10,
5,59,0,50,5,51,0,20,6,205,0,20,4,236,0,31,
4,193,0,0,4,47,0,59,2,119,0,139,3,193,0,55,
2,119,0,41,3,240,0,100,3,193,0,61,2,141,0,30,
3,172,0,80,4,16,0,10,3,127,0,80,4,41,0,80,
3,178,0,80,2,125,0,45,3,231,0,30,4,106,0,55,
2,43,0,70,2,18,255,16,4,0,0,55,2,43,0,60,
6,109,0,55,4,106,0,55,4,6,0,80,4,61,0,55,
4,31,0,80,3,43,0,55,3,23,0,94,2,193,0,20,
4,61,0,41,3,242,0,20,5,166,0,20,4,6,0,20,
3,242,255,209,3,137,0,76,2,176,0,102,1,213,0,180,
2,176,0,39,3,231,0,49,1,195,0,0,2,45,0,154,
3,193,0,104,3,193,0,64,3,193,0,158,3,193,255,189,
3,193,0,119,3,33,0,100,5,180,0,100,2,12,0,49,
3,226,0,80,3,193,0,61,2,218,0,35,3,242,0,167,
2,221,0,140,3,72,0,61,2,141,0,217,4,81,0,61,
4,111,0,49,1,44,0,50,1,213,0,78,2,66,0,49,
3,226,0,140,3,119,0,80,4,195,0,0,4,195,0,0,
4,195,0,0,4,195,0,0,4,195,0,0,4,195,0,0,
6,59,0,0,4,74,0,70,3,248,0,50,3,248,0,50,
3,248,0,50,3,248,0,50,2,98,255,214,2,98,0,70,
2,98,255,234,2,98,255,251,5,49,0,50,4,205,0,70,
4,205,0,70,4,205,0,70,4,205,0,70,4,205,0,70,
4,205,0,70,5,59,0,50,5,59,0,50,5,59,0,50,
5,59,0,50,4,133,0,55,3,172,0,80,3,172,0,80,
3,172,0,80,3,172,0,80,3,172,0,80,3,172,0,80,
5,137,0,80,3,127,0,80,3,178,0,80,3,178,0,80,
3,178,0,80,3,178,0,80,2,43,255,247,2,43,0,70,
2,43,255,224,2,43,255,241,4,106,0,55,4,6,0,80,
4,6,0,80,4,6,0,80,4,6,0,80,4,6,0,80,
3,72,0,61,4,6,0,80,4,61,0,41,4,61,0,41,
4,61,0,41,4,61,0,41,3,242,255,209,2,43,0,70,
6,98,0,70,6,88,0,80,4,193,0,0,2,80,255,6,
2,221,0,49,2,221,0,50,2,218,0,40,1,144,0,100,
2,0,0,70,2,18,0,100,3,54,0,70,3,0,0,80,
4,54,0,20,3,193,0,61,6,33,0,61,1,213,0,92,
1,213,0,88,1,213,0,88,3,125,0,92,3,125,0,88,
3,152,0,88,3,209,0,70,3,209,0,70,2,57,0,70,
5,90,0,131,8,27,0,76,2,112,0,80,2,112,0,140,
4,121,0,59,4,168,0,45,4,168,0,45,3,193,0,87,
2,45,0,154,3,102,0,160,1,213,0,174,2,178,0,61,
2,161,0,59,2,161,0,38,2,161,0,97,4,176,0,80,
4,176,0,80,4,176,0,80,4,190,0,27,3,72,0,93,
4,193,0,0,4,47,0,49,3,252,0,80,3,242,255,209,
4,61,0,55,4,195,0,0,3,172,0,80,4,195,0,0,
3,172,0,80,4,195,0,0,3,172,0,80,4,74,0,70,
3,127,0,80,4,74,0,70,3,127,0,80,4,74,0,70,
3,127,0,80,4,74,0,70,3,127,0,80,4,190,0,41,
5,102,0,80,4,190,0,27,4,41,0,80,3,248,0,50,
3,178,0,80,3,248,0,50,3,178,0,80,3,248,0,50,
3,178,0,80,3,248,0,50,3,178,0,80,3,248,0,50,
3,178,0,80,4,170,0,70,3,231,0,30,4,170,0,70,
3,231,0,30,4,170,0,70,3,231,0,30,4,170,0,70,
3,231,0,30,5,59,0,50,4,106,0,55,5,59,0,50,
4,106,0,33,2,98,255,210,2,43,255,200,2,98,255,223,
2,43,255,213,2,98,255,226,2,43,255,216,2,98,0,70,
2,43,0,70,2,98,0,70,4,211,0,70,4,61,0,70,
2,113,255,66,2,18,255,16,4,160,0,50,4,0,0,55,
4,0,0,55,3,207,0,50,2,43,0,60,3,207,0,50,
2,43,0,60,3,207,0,50,3,105,0,60,3,207,0,50,
3,87,0,60,3,207,0,41,2,43,0,49,5,49,0,50,
4,106,0,55,5,49,0,50,4,106,0,55,5,49,0,50,
4,106,0,55,5,107,0,80,4,211,0,49,4,96,0,55,
4,205,0,70,4,6,0,80,4,205,0,70,4,6,0,80,
4,205,0,70,4,6,0,80,4,125,0,41,3,43,0,55,
4,125,0,41,3,43,0,55,4,125,0,41,3,43,0,55,
3,207,0,117,3,23,0,94,3,207,0,117,3,23,0,80,
3,207,0,117,3,23,0,94,3,207,0,117,3,23,0,80,
4,104,0,10,2,193,0,20,4,104,0,10,2,193,0,20,
4,104,0,9,2,193,0,20,5,59,0,50,4,61,0,41,
5,59,0,50,4,61,0,41,5,59,0,50,4,61,0,41,
5,59,0,50,4,61,0,41,5,59,0,50,4,61,0,41,
5,59,0,50,4,61,0,41,6,205,0,20,5,166,0,20,
4,193,0,0,3,242,255,209,4,47,0,59,3,137,0,76,
4,47,0,59,3,137,0,76,4,47,0,59,3,137,0,76,
2,125,0,45,4,16,255,246,5,76,0,30,4,102,0,49,
4,16,0,100,4,102,0,50,4,36,0,10,4,74,0,61,
4,74,0,70,3,127,0,80,4,190,0,27,5,164,0,30,
4,102,0,110,4,41,0,80,3,227,0,80,3,248,0,65,
4,98,0,80,4,18,0,80,3,211,255,11,4,170,0,70,
4,206,0,20,6,99,0,55,2,201,0,50,2,98,0,48,
4,239,0,50,4,0,0,55,2,142,0,70,4,59,0,20,
7,170,0,50,5,49,255,11,4,96,0,55,4,205,0,70,
4,205,0,70,4,76,0,80,7,62,0,70,6,4,0,80,
5,21,0,30,4,16,0,0,4,99,0,50,3,207,0,115,
3,23,0,88,4,40,0,59,2,0,255,92,2,193,0,20,
4,195,0,30,2,193,0,20,4,104,0,10,5,120,0,50,
4,231,0,41,5,22,0,70,4,234,0,50,5,157,0,30,
3,242,255,209,4,47,0,59,3,137,0,76,4,42,0,94,
4,68,0,90,3,152,0,40,3,152,0,50,3,122,0,76,
4,4,0,50,3,147,0,55,3,89,0,20,4,1,0,55,
1,194,0,150,3,22,0,150,2,118,0,18,2,45,0,154,
8,237,0,41,8,71,0,41,7,178,0,80,6,64,0,50,
5,225,0,50,4,61,0,60,7,162,0,50,7,67,0,50,
6,124,0,55,4,195,0,0,3,172,0,80,2,98,255,234,
2,43,255,224,4,205,0,70,4,6,0,80,5,59,0,50,
4,61,0,41,5,59,0,50,4,61,0,41,5,59,0,50,
4,61,0,41,5,59,0,50,4,61,0,41,5,59,0,50,
4,61,0,41,3,162,0,70,4,195,0,0,3,172,0,80,
4,195,0,0,3,172,0,80,6,59,0,0,5,137,0,80,
4,170,0,70,3,231,255,206,4,170,0,70,3,231,0,30,
4,160,0,50,4,0,0,55,4,205,0,70,4,6,0,80,
4,205,0,70,4,6,0,80,4,42,0,94,3,152,0,38,
2,18,255,16,8,237,0,41,8,71,0,41,7,178,0,80,
4,170,0,70,3,231,0,30,7,89,0,50,4,79,0,55,
5,49,0,50,4,106,0,55,4,195,0,0,3,172,0,80,
6,59,0,0,5,137,0,80,4,205,0,70,4,6,0,80,
4,195,0,0,3,172,0,80,4,195,0,0,3,172,0,80,
3,248,0,50,3,178,0,80,3,248,0,50,3,178,0,80,
2,98,255,171,2,43,255,161,2,98,255,226,2,43,255,216,
4,205,0,70,4,6,0,80,4,205,0,70,4,6,0,80,
4,125,0,41,3,43,0,55,4,125,0,41,3,43,0,55,
5,59,0,50,4,61,0,41,5,59,0,50,4,61,0,41,
3,207,0,117,3,23,0,94,4,104,0,10,2,193,0,20,
4,8,0,113,3,108,0,66,5,59,0,50,4,106,0,55,
4,137,0,90,4,6,0,80,4,47,0,59,3,137,0,76,
4,195,0,0,3,172,0,80,3,248,0,50,3,178,0,80,
4,205,0,70,4,6,0,80,4,205,0,70,4,6,0,80,
4,205,0,70,4,6,0,80,4,205,0,70,4,6,0,80,
4,193,0,0,3,242,255,209,3,200,0,55,3,255,0,80,
4,27,0,55,4,16,0,140,3,157,0,66,3,127,0,80,
4,6,0,80,4,41,0,80,3,178,0,80,3,162,0,70,
4,208,0,78,3,106,0,80,3,106,0,45,4,118,0,45,
3,190,0,80,2,83,255,80,4,10,0,80,4,10,0,80,
3,238,0,80,3,242,0,20,3,242,0,20,4,61,0,39,
4,106,0,55,4,95,0,55,2,43,0,47,2,66,0,49,
2,58,0,70,2,170,0,0,2,227,0,0,2,44,0,60,
4,146,0,60,6,84,0,41,6,84,0,41,6,98,0,55,
4,96,255,16,4,117,0,55,4,151,0,55,4,6,0,80,
5,74,0,80,5,35,0,78,4,86,0,80,3,43,0,56,
3,43,0,56,2,234,0,56,3,43,0,55,3,43,0,55,
2,234,0,40,2,248,0,56,4,5,0,50,3,221,0,50,
3,23,0,95,1,248,254,252,2,83,255,80,2,0,255,41,
1,248,254,248,2,193,0,20,2,174,0,20,4,61,0,41,
3,203,0,59,3,227,0,41,3,242,0,20,5,166,0,20,
3,242,0,20,3,222,0,20,3,137,0,76,3,145,0,76,
3,152,0,38,3,152,0,36,3,122,0,60,3,122,0,40,
3,162,0,60,3,117,0,80,4,245,0,70,3,216,0,50,
3,191,0,80,3,238,0,80,4,161,0,55,2,18,254,236,
4,0,0,40,3,122,0,55,4,31,0,80,3,122,0,60,
3,122,0,40,6,96,0,80,6,224,0,80,6,104,0,80,
5,21,0,20,3,236,0,20,5,115,0,20,6,174,0,45,
4,187,0,60,4,93,0,60,4,1,0,20,4,50,0,160,
3,23,0,39,3,23,0,39,1,115,255,88,2,56,0,39,
2,56,0,39,2,80,0,39,2,180,0,35,3,244,0,9,
2,195,255,223,1,205,0,40,3,23,0,40,1,201,0,113,
1,201,0,80,1,198,0,84,1,134,0,82,1,134,0,79,
2,111,0,32,2,111,0,18,2,229,0,60,2,229,0,60,
2,128,0,40,2,128,0,40,1,164,0,150,3,242,0,167,
2,141,0,217,2,141,0,30,1,164,0,150,3,242,0,167,
2,141,0,70,2,141,0,70,2,20,0,110,2,20,0,110,
1,134,0,82,1,134,0,79,2,48,0,70,2,48,0,70,
2,48,0,70,2,88,0,70,1,12,255,51,2,225,0,70,
2,195,0,9,1,133,0,42,2,42,0,56,2,209,0,14,
2,111,0,18,2,128,0,40,3,242,0,167,3,89,0,80,
0,0,253,41,0,0,253,125,0,0,252,193,0,0,252,168,
0,0,252,171,0,0,251,252,0,0,252,184,0,0,253,153,
0,0,252,209,0,0,253,83,0,0,253,67,0,0,253,48,
0,0,252,193,0,0,253,188,0,0,253,58,0,0,252,104,
0,0,252,184,0,0,252,184,0,0,253,129,0,0,253,95,
0,0,253,112,0,0,255,153,0,0,252,254,0,0,253,48,
0,0,253,83,0,0,253,83,0,0,252,246,0,70,254,188,
0,0,253,118,0,0,253,43,0,0,253,43,0,0,253,43,
0,0,253,23,0,0,255,106,0,0,254,10,0,0,253,153,
0,0,252,209,0,0,253,67,0,0,253,83,0,0,253,90,
0,0,253,64,0,0,253,188,0,0,252,236,0,0,252,191,
0,0,252,193,0,0,252,193,0,0,252,184,0,0,252,184,
0,0,252,168,0,0,252,171,0,0,251,252,0,0,251,252,
0,0,252,168,0,0,252,191,0,0,251,217,0,0,252,146,
0,0,252,72,0,0,253,189,0,0,252,237,0,0,253,78,
0,0,252,141,0,0,252,209,0,0,253,134,0,0,251,252,
0,0,252,58,0,0,254,213,0,0,252,179,0,0,253,91,
0,0,252,145,0,0,253,183,0,0,252,236,0,0,253,23,
0,0,253,58,0,0,253,63,0,0,252,168,0,0,252,168,
0,0,252,208,0,0,252,193,0,0,253,32,0,0,253,198,
0,0,253,150,0,0,253,33,1,205,0,40,1,205,0,40,
0,0,253,183,1,213,0,88,1,205,0,40,3,41,0,41,
5,170,0,40,1,213,0,131,5,197,0,40,7,8,0,40,
4,67,0,40,5,210,0,40,6,219,0,40,6,6,0,40,
2,92,255,189,4,195,0,0,4,102,0,41,3,205,0,49,
4,150,0,59,3,248,0,49,4,47,0,59,5,59,0,49,
4,242,0,70,2,138,0,90,4,160,0,49,4,195,0,0,
6,115,0,59,5,49,0,49,4,34,0,49,4,205,0,70,
5,10,0,49,4,47,0,41,4,40,0,59,4,104,0,10,
4,170,0,0,5,61,0,87,4,236,0,31,5,131,255,233,
5,16,0,80,2,138,0,15,4,170,0,0,4,52,0,80,
3,94,0,70,4,70,0,55,2,92,0,70,4,16,0,55,
4,52,0,80,3,252,0,140,3,206,255,246,3,214,0,100,
3,94,0,70,3,51,0,80,4,70,0,55,3,255,0,91,
2,92,0,70,4,22,0,55,4,59,0,20,4,81,0,61,
4,16,0,10,3,130,0,80,3,252,0,85,3,211,0,140,
3,69,0,80,3,212,0,80,3,113,0,30,4,16,0,55,
5,27,0,80,3,228,0,20,5,72,0,58,5,155,0,90,
2,92,255,252,4,16,0,55,3,252,0,85,4,16,0,55,
5,155,0,90,3,207,0,91,3,253,0,30,4,253,0,0,
7,46,0,40,4,253,0,0,5,115,0,80,4,195,0,0,
3,172,0,80,4,102,0,41,4,16,0,10,4,102,0,41,
4,16,0,10,4,102,0,41,4,16,0,10,4,74,0,70,
3,127,0,80,4,190,0,41,4,41,0,80,4,190,0,41,
4,41,0,80,4,190,0,41,4,41,0,80,4,190,0,41,
4,41,0,80,4,190,0,41,4,41,0,80,3,248,0,50,
3,178,0,80,3,248,0,50,3,178,0,80,3,248,0,50,
3,178,0,80,3,248,0,50,3,178,0,80,3,248,0,50,
3,178,0,80,3,211,0,50,2,125,0,45,4,170,0,70,
3,231,0,30,5,59,0,50,4,106,0,55,5,59,0,50,
4,106,0,55,5,59,0,50,4,106,0,55,5,59,0,50,
4,106,0,55,5,59,0,50,4,106,0,55,2,98,255,210,
2,43,255,200,2,98,255,251,2,43,255,241,4,160,0,50,
4,0,0,55,4,160,0,50,4,0,0,55,4,160,0,50,
4,0,0,55,3,207,0,50,2,43,0,60,3,207,0,50,
2,43,255,213,3,207,0,50,2,43,255,203,3,207,0,50,
2,43,255,224,6,115,0,60,6,109,0,55,6,115,0,60,
6,109,0,55,6,115,0,60,6,109,0,55,5,49,0,50,
4,106,0,55,5,49,0,50,4,106,0,55,5,49,0,50,
4,106,0,55,5,49,0,50,4,106,0,55,4,205,0,70,
4,6,0,80,4,205,0,70,4,6,0,80,4,205,0,70,
4,6,0,80,4,205,0,70,4,6,0,80,4,47,0,41,
4,61,0,55,4,47,0,41,4,61,0,55,4,125,0,41,
3,43,0,55,4,125,0,41,3,43,0,55,4,125,0,41,
3,43,0,55,4,125,0,41,3,43,255,188,3,207,0,117,
3,23,0,94,3,207,0,117,3,23,0,94,3,207,0,117,
3,23,0,94,3,207,0,117,3,23,0,80,3,207,0,117,
3,23,0,94,4,104,0,10,2,193,0,20,4,104,0,10,
2,193,0,20,4,104,0,10,2,193,0,10,4,104,0,10,
2,193,0,20,5,59,0,50,4,61,0,41,5,59,0,50,
4,61,0,41,5,59,0,50,4,61,0,41,5,59,0,50,
4,61,0,41,5,59,0,50,4,61,0,41,5,51,0,20,
3,242,0,20,5,51,0,20,3,242,0,20,6,205,0,20,
5,166,0,20,6,205,0,20,5,166,0,20,6,205,0,20,
5,166,0,20,6,205,0,20,5,166,0,20,6,205,0,20,
5,166,0,20,4,236,0,31,4,6,0,20,4,236,0,31,
4,6,0,20,4,193,0,0,3,242,255,209,4,47,0,59,
3,137,0,76,4,47,0,59,3,137,0,76,4,47,0,59,
3,137,0,76,4,106,0,55,2,193,0,20,5,166,0,20,
3,242,255,209,3,172,0,80,2,125,0,45,4,195,0,0,
3,172,0,80,4,195,0,0,3,172,0,80,4,195,0,0,
3,172,0,80,4,195,0,0,3,172,0,28,4,195,0,0,
3,172,0,80,4,195,0,0,3,172,0,80,4,195,0,0,
3,172,0,80,4,195,0,0,3,172,0,80,4,195,0,0,
3,172,0,80,4,195,0,0,3,172,0,80,4,195,0,0,
3,172,0,80,4,195,0,0,3,172,0,80,3,248,0,50,
3,178,0,80,3,248,0,50,3,178,0,80,3,248,0,50,
3,178,0,80,3,248,0,50,3,178,0,80,3,248,0,0,
3,178,0,58,3,248,0,50,3,178,0,80,3,248,0,50,
3,178,0,80,3,248,0,50,3,178,0,80,2,98,0,70,
2,43,0,70,2,98,0,70,2,43,0,70,4,205,0,70,
4,6,0,80,4,205,0,70,4,6,0,80,4,205,0,70,
4,6,0,80,4,205,0,70,4,6,0,80,4,205,0,70,
4,6,0,80,4,205,0,70,4,6,0,80,4,205,0,70,
4,6,0,80,4,205,0,70,4,76,0,80,4,205,0,70,
4,76,0,80,4,205,0,70,4,76,0,80,4,205,0,70,
4,76,0,80,4,205,0,70,4,76,0,80,5,59,0,50,
4,61,0,41,5,59,0,50,4,61,0,41,5,120,0,50,
4,231,0,41,5,120,0,50,4,231,0,41,5,120,0,50,
4,231,0,41,5,120,0,50,4,231,0,41,5,120,0,50,
4,231,0,41,4,193,0,0,3,242,255,209,4,193,0,0,
3,242,255,209,4,193,0,0,3,242,255,209,4,193,0,0,
3,242,255,209,4,52,0,80,4,52,0,80,4,52,0,80,
4,52,0,80,4,52,0,80,4,52,0,80,4,52,0,80,
4,52,0,80,5,92,0,33,5,92,0,50,6,173,0,33,
6,193,0,49,6,113,0,33,6,113,0,31,5,92,255,101,
5,92,255,101,3,94,0,70,3,94,0,70,3,94,0,70,
3,94,0,70,3,94,0,70,3,94,0,70,5,119,0,33,
5,119,0,50,6,200,0,33,6,220,0,49,6,140,0,33,
6,140,0,31,4,70,0,55,4,70,0,55,4,70,0,55,
4,70,0,55,4,70,0,55,4,70,0,55,4,70,0,55,
4,70,0,55,6,186,0,33,6,186,0,50,8,11,0,33,
8,31,0,49,7,207,0,33,7,207,0,31,6,186,255,101,
6,186,255,101,2,92,0,70,2,92,0,70,2,92,255,226,
2,92,255,202,2,92,0,20,2,92,0,28,2,92,255,206,
2,92,255,206,3,245,0,33,3,245,0,50,5,70,0,33,
5,90,0,49,5,10,0,33,5,10,0,31,3,245,255,101,
3,245,255,101,3,252,0,85,3,252,0,85,3,252,0,85,
3,252,0,85,3,252,0,85,3,252,0,85,6,26,0,33,
6,26,0,50,7,107,0,33,7,127,0,49,6,203,0,33,
6,203,0,31,4,16,0,55,4,16,0,55,4,16,0,55,
4,16,0,55,4,16,0,55,4,16,0,55,4,16,0,55,
4,16,0,55,6,141,0,50,7,242,0,49,7,162,0,31,
6,141,255,101,5,155,0,90,5,155,0,90,5,155,0,90,
5,155,0,90,5,155,0,90,5,155,0,90,5,155,0,90,
5,155,0,90,6,78,0,33,6,78,0,50,7,159,0,33,
7,179,0,49,6,255,0,33,6,255,0,31,6,78,255,101,
6,78,255,101,4,52,0,80,4,52,0,80,3,94,0,70,
3,94,0,70,4,70,0,55,4,70,0,55,2,92,0,70,
2,92,0,70,3,252,0,85,3,252,0,85,4,16,0,55,
4,16,0,55,5,155,0,90,5,155,0,90,4,52,0,80,
4,52,0,80,4,52,0,80,4,52,0,80,4,52,0,80,
4,52,0,80,4,52,0,80,4,52,0,80,7,184,0,33,
7,184,0,50,9,9,0,33,9,29,0,49,8,205,0,33,
8,205,0,31,7,184,255,101,7,184,255,101,4,70,0,55,
4,70,0,55,4,70,0,55,4,70,0,55,4,70,0,55,
4,70,0,55,4,70,0,55,4,70,0,55,9,22,0,33,
9,22,0,50,10,103,0,33,10,123,0,49,10,43,0,33,
10,43,0,31,9,22,255,101,9,22,255,101,5,155,0,90,
5,155,0,90,5,155,0,90,5,155,0,90,5,155,0,90,
5,155,0,90,5,155,0,90,5,155,0,90,8,170,0,33,
8,170,0,50,9,251,0,33,10,15,0,49,9,191,0,33,
9,191,0,31,8,170,255,101,8,170,255,101,4,52,0,80,
4,52,0,80,4,52,0,80,4,52,0,80,4,52,0,80,
4,52,0,80,4,52,0,80,4,195,0,0,4,195,0,0,
5,163,0,111,5,170,0,40,7,31,0,0,1,127,0,33,
2,92,0,70,1,127,0,33,3,54,0,70,3,54,0,70,
4,70,0,55,4,70,0,55,4,70,0,55,4,70,0,55,
4,70,0,55,5,190,0,111,5,197,0,40,7,1,0,111,
7,8,0,40,7,151,0,49,2,208,0,33,2,148,0,33,
1,127,255,101,2,92,255,227,2,92,255,224,2,92,255,189,
2,92,255,189,2,92,255,223,2,92,255,223,2,138,255,246,
2,138,255,243,4,60,0,111,4,67,0,40,2,228,0,49,
2,148,0,31,1,127,255,101,4,16,0,55,4,16,0,55,
4,16,0,55,4,16,0,55,3,211,0,140,3,211,0,140,
4,16,0,55,4,16,0,55,4,170,0,0,4,170,0,0,
6,212,0,111,6,219,0,40,5,174,0,50,3,41,0,41,
3,41,0,41,1,198,0,111,5,155,0,90,5,155,0,90,
5,155,0,90,5,155,0,90,5,155,0,90,6,97,0,111,
5,210,0,40,6,149,0,111,6,6,0,40,7,108,0,80,
1,205,0,40,1,127,0,50,3,193,0,0,6,33,0,0,
3,193,0,0,6,33,0,0,2,13,0,0,1,144,0,0,
1,4,0,0,3,193,0,0,1,213,0,0,1,44,0,0,
0,100,0,0,0,0,0,0,2,178,0,61,2,178,0,61,
3,193,0,61,7,157,0,61,3,61,0,180,3,32,0,61,
1,213,0,87,3,125,0,87,2,11,0,120,1,213,0,131,
3,151,0,131,1,241,0,150,2,161,0,43,2,161,0,29,
2,161,0,55,2,161,0,68,2,161,0,73,2,161,0,56,
2,161,0,60,2,76,0,43,1,227,0,43,2,117,0,43,
1,198,0,75,1,198,0,29,3,23,0,39,2,161,0,43,
2,161,0,97,2,161,0,59,2,161,0,38,2,161,0,29,
2,161,0,55,2,161,0,68,2,161,0,73,2,161,0,56,
2,161,0,60,2,76,0,43,1,227,0,43,2,117,0,43,
1,198,0,75,1,198,0,29,3,193,0,76,3,193,0,76,
3,193,0,50,3,193,0,54,4,67,0,55,3,193,0,37,
6,236,0,41,5,42,0,41,3,193,0,80,3,193,0,24,
3,193,0,44,3,193,0,36,7,48,0,44,3,193,0,37,
3,72,0,61,1,44,0,50,2,18,255,16,0,0,252,193,
0,0,252,58,0,0,252,193,0,0,252,168,0,0,252,184,
0,0,252,184,0,0,252,184,0,0,252,178,4,250,0,45,
7,37,0,45,7,37,0,45,2,141,0,70,2,43,0,70,
2,18,255,16,3,33,0,100,3,242,0,167,2,141,0,70,
2,43,0,47,2,18,254,236,2,221,0,49,2,221,0,50,
2,141,0,70,2,141,0,70,1,144,0,100,3,54,0,70,
0,0,252,254,0,0,253,48,0,0,252,193,0,0,252,168,
0,0,252,171,0,0,253,153,0,0,252,209,0,0,252,193,
0,0,251,224,0,0,254,190,3,172,0,80,3,172,0,80,
3,172,0,80,3,172,0,80,3,172,0,80,3,178,0,80,
3,178,0,80,3,178,0,80,3,178,0,80,2,43,255,204,
2,43,0,70,2,43,255,224,2,43,255,241,4,106,0,55,
4,6,0,80,4,6,0,80,4,6,0,80,4,6,0,80,
4,6,0,80,4,61,0,41,4,61,0,41,4,61,0,41,
4,61,0,41,3,242,255,209,3,242,255,209,3,172,0,80,
3,127,0,80,3,127,0,80,3,127,0,80,3,127,0,80,
3,178,0,80,3,178,0,80,3,178,0,80,3,231,0,30,
3,231,0,30,2,43,255,200,2,43,255,213,2,43,0,70,
4,61,0,70,2,18,255,16,4,106,0,55,4,106,0,55,
4,6,0,80,3,43,0,55,3,43,0,55,3,23,0,94,
3,23,0,80,3,23,0,80,4,61,0,41,4,61,0,41,
5,166,0,20,3,242,255,209,3,137,0,76,3,137,0,76,
3,137,0,76,8,71,0,41,7,178,0,80,5,225,0,50,
4,61,0,60,7,67,0,50,6,124,0,55,3,172,0,80,
2,43,255,224,4,6,0,80,4,61,0,41,4,61,0,41,
4,61,0,41,4,61,0,41,4,61,0,41,3,172,0,80,
3,172,0,80,5,137,0,80,3,231,0,30,4,6,0,80,
3,152,0,38,2,18,255,16,3,231,0,30,4,106,0,55,
5,137,0,80,4,6,0,80,3,172,0,80,4,6,0,80,
4,6,0,80,4,6,0,80,4,6,0,80,3,242,255,209,
4,16,0,10,3,127,0,80,4,41,0,80,3,178,0,80,
3,178,0,80,3,231,0,30,2,43,255,200,2,43,255,241,
6,109,0,55,6,109,0,55,4,106,0,55,4,6,0,80,
4,6,0,80,4,6,0,80,4,6,0,80,4,61,0,55,
4,61,0,55,3,43,0,55,3,43,0,55,3,23,0,94,
3,23,0,94,3,23,0,80,3,23,0,94,4,61,0,41,
4,61,0,41,3,242,0,20,5,166,0,20,5,166,0,20,
5,166,0,20,5,166,0,20,4,6,0,20,4,6,0,20,
3,242,255,209,3,137,0,76,3,172,0,80,3,172,255,234,
3,172,0,80,3,172,0,80,3,172,0,80,3,172,0,80,
3,172,0,80,3,172,0,80,3,178,0,80,3,178,0,80,
3,178,0,8,3,178,0,80,3,178,0,80,3,178,0,80,
2,43,0,70,4,6,0,80,4,6,0,33,4,6,0,80,
4,6,0,80,4,6,0,80,4,76,0,80,4,76,0,80,
4,76,0,80,4,231,0,41,4,231,0,41,4,231,0,41,
3,242,255,209,3,242,255,209,0,0,252,144,3,54,0,36,
3,54,0,66,1,127,255,88,1,127,255,88,4,52,0,80,
4,52,0,80,5,92,255,88,5,92,255,88,4,70,0,55,
4,70,0,55,7,60,255,88,7,60,255,88,2,92,255,193,
2,92,255,193,4,99,255,88,4,99,255,88,4,16,0,55,
4,16,0,55,6,201,255,88,5,155,0,90,5,155,0,90,
6,78,255,88,6,78,255,88,4,52,0,80,4,52,0,80,
7,184,255,88,7,184,255,88,4,70,0,55,4,70,0,55,
9,152,255,88,9,152,255,88,5,155,0,90,5,155,0,90,
8,170,255,88,8,170,255,88,4,52,0,80,4,52,0,80,
4,70,0,55,4,70,0,55,2,92,255,189,2,92,255,219,
4,16,0,55,4,16,0,55,5,155,0,90,5,155,0,90,
0,0,252,193,0,0,252,8,0,0,252,193,0,0,252,168,
0,0,252,184,0,0,252,184,0,0,252,168,4,168,0,45,
7,37,0,45,3,207,0,117,2,98,0,70,2,113,255,66,
4,195,0,0,4,102,0,49,4,102,0,41,3,205,0,49,
5,1,0,51,3,248,0,50,7,24,0,60,4,42,0,94,
5,59,0,50,5,59,0,50,4,217,0,50,5,0,0,20,
6,115,0,60,5,59,0,50,4,205,0,70,5,10,0,50,
4,47,0,41,4,74,0,70,4,104,0,10,5,51,0,20,
5,61,0,87,4,236,0,31,5,10,0,50,4,245,0,50,
6,214,0,50,6,214,0,50,5,183,0,50,6,24,0,50,
4,102,0,50,4,74,0,54,6,243,0,70,4,125,0,10,
3,172,0,80,3,233,0,90,3,185,0,48,3,80,0,55,
4,90,0,36,3,178,0,80,5,188,0,20,3,111,0,80,
4,151,0,55,4,80,0,55,4,0,0,55,4,89,0,10,
5,85,0,40,4,151,0,55,4,6,0,80,4,109,0,55,
4,61,0,55,3,127,0,80,3,236,0,21,3,242,255,209,
5,93,0,80,4,6,0,20,4,126,0,55,4,94,0,55,
6,54,0,55,6,69,0,55,4,178,0,56,5,123,0,55,
3,201,0,55,3,187,0,80,5,231,0,55,3,246,0,20,
3,23,0,94,2,43,0,70,2,18,255,16,2,98,0,70,
4,246,0,10,6,59,0,0,5,137,0,80,4,98,0,80,
3,162,0,70,4,42,0,94,3,152,0,38,4,205,0,70,
4,6,0,80,4,170,0,70,184,0,0,44,75,184,0,9,
80,88,177,1,1,142,89,184,1,255,133,184,0,68,29,185,
0,9,0,3,95,94,45,184,0,1,44,32,32,69,105,68,
176,1,96,45,184,0,2,44,184,0,1,42,33,45,184,0,
3,44,32,70,176,3,37,70,82,88,35,89,32,138,32,138,
73,100,138,32,70,32,104,97,100,176,4,37,70,32,104,97,
100,82,88,35,101,138,89,47,32,176,0,83,88,105,32,176,
0,84,88,33,176,64,89,27,105,32,176,0,84,88,33,176,
64,101,89,89,58,45,184,0,4,44,32,70,176,4,37,70,
82,88,35,138,89,32,70,32,106,97,100,176,4,37,70,32,
106,97,100,82,88,35,138,89,47,253,45,184,0,5,44,75,
32,176,3,38,80,88,81,88,176,128,68,27,176,64,68,89,
27,33,33,32,69,176,192,80,88,176,192,68,27,33,89,89,
45,184,0,6,44,32,32,69,105,68,176,1,96,32,32,69,
125,105,24,68,176,1,96,45,184,0,7,44,184,0,6,42,
45,184,0,8,44,75,32,176,3,38,83,88,176,128,27,176,
64,89,138,138,32,176,3,38,83,88,35,33,176,192,138,138,
27,138,35,89,32,176,3,38,83,88,35,33,184,1,0,138,
138,27,138,35,89,32,176,3,38,83,88,35,33,184,1,64,
138,138,27,138,35,89,32,184,0,3,38,83,88,176,3,37,
69,184,1,128,80,88,35,33,184,1,128,35,33,27,176,3,
37,69,35,33,35,33,89,27,33,89,68,45,184,0,9,44,
75,83,88,69,68,27,33,33,89,45,0,0,184,0,0,43,
0,186,0,1,0,2,0,2,43,1,186,0,3,0,2,0,
2,43,190,0,3,0,76,0,60,0,47,0,34,0,20,0,
8,43,190,0,4,0,71,0,60,0,47,0,34,0,20,0,
8,43,190,0,1,0,128,0,102,0,80,0,57,0,34,0,
8,43,190,0,2,0,120,0,102,0,80,0,57,0,34,0,
8,43,0,186,0,5,0,4,0,7,43,184,0,0,32,69,
125,105,24,68,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,88,0,0,5,50,
0,0,8,98,0,0,8,160,0,0,9,64,0,0,9,222,
0,0,10,188,0,0,11,94,0,0,11,242,0,0,12,52,
0,0,12,186,0,0,12,248,0,0,14,156,0,0,15,32,
0,0,16,40,0,0,18,26,0,0,18,232,0,0,20,142,
0,0,22,112,0,0,22,250,0,0,25,108,0,0,26,188,
0,0,26,212,0,0,26,236,0,0,27,140,0,0,28,0,
0,0,28,134,0,0,30,74,0,0,33,234,0,0,34,156,
0,0,37,118,0,0,39,96,0,0,41,116,0,0,42,108,
0,0,43,56,0,0,45,132,0,0,46,138,0,0,46,254,
0,0,47,174,0,0,48,164,0,0,49,64,0,0,50,100,
0,0,51,104,0,0,53,144,0,0,55,82,0,0,57,236,
0,0,59,242,0,0,62,148,0,0,63,68,0,0,64,152,
0,0,65,60,0,0,66,88,0,0,67,144,0,0,68,114,
0,0,69,64,0,0,69,170,0,0,69,232,0,0,70,82,
0,0,70,186,0,0,70,252,0,0,71,56,0,0,73,166,
0,0,75,226,0,0,77,206,0,0,80,80,0,0,82,120,
0,0,83,132,0,0,87,2,0,0,88,144,0,0,89,124,
0,0,91,22,0,0,92,28,0,0,92,140,0,0,95,12,
0,0,96,166,0,0,98,210,0,0,101,80,0,0,103,192,
0,0,104,172,0,0,107,62,0,0,108,172,0,0,110,80,
0,0,111,2,0,0,112,4,0,0,113,66,0,0,114,34,
0,0,114,232,0,0,116,92,0,0,116,166,0,0,118,38,
0,0,118,158,0,0,118,158,0,0,119,158,0,0,121,30,
0,0,122,32,0,0,123,4,0,0,124,22,0,0,126,232,
0,0,127,214,0,0,130,232,0,0,132,88,0,0,132,230,
0,0,133,66,0,0,135,136,0,0,135,194,0,0,136,230,
0,0,137,140,0,0,137,196,0,0,139,178,0,0,141,30,
0,0,141,82,0,0,141,186,0,0,142,248,0,0,143,132,
0,0,145,156,0,0,145,180,0,0,145,204,0,0,145,228,
0,0,145,252,0,0,146,20,0,0,146,44,0,0,147,152,
0,0,147,176,0,0,147,200,0,0,147,224,0,0,147,248,
0,0,148,16,0,0,148,40,0,0,148,64,0,0,148,88,
0,0,148,112,0,0,148,136,0,0,148,160,0,0,148,184,
0,0,148,208,0,0,148,232,0,0,149,0,0,0,151,250,
0,0,152,18,0,0,152,42,0,0,152,66,0,0,152,90,
0,0,154,212,0,0,154,236,0,0,155,4,0,0,155,28,
0,0,155,52,0,0,155,76,0,0,155,100,0,0,159,10,
0,0,159,34,0,0,159,58,0,0,159,82,0,0,159,106,
0,0,159,130,0,0,159,154,0,0,159,178,0,0,159,202,
0,0,159,226,0,0,159,250,0,0,160,18,0,0,160,42,
0,0,160,66,0,0,160,90,0,0,160,114,0,0,161,2,
0,0,163,250,0,0,164,18,0,0,164,42,0,0,164,66,
0,0,164,90,0,0,164,114,0,0,164,238,0,0,167,160,
0,0,171,68,0,0,171,92,0,0,173,24,0,0,173,98,
0,0,173,170,0,0,174,24,0,0,174,142,0,0,175,162,
0,0,176,66,0,0,176,156,0,0,176,250,0,0,178,230,
0,0,179,40,0,0,179,106,0,0,180,4,0,0,180,152,
0,0,181,44,0,0,182,92,0,0,183,132,0,0,184,172,
0,0,185,246,0,0,187,166,0,0,187,242,0,0,189,124,
0,0,193,102,0,0,193,170,0,0,193,236,0,0,195,170,
0,0,195,194,0,0,195,218,0,0,197,64,0,0,197,234,
0,0,198,88,0,0,198,230,0,0,199,40,0,0,199,166,
0,0,200,92,0,0,200,188,0,0,201,178,0,0,202,178,
0,0,203,228,0,0,206,94,0,0,206,180,0,0,206,204,
0,0,208,192,0,0,211,160,0,0,211,184,0,0,214,36,
0,0,214,60,0,0,214,84,0,0,214,108,0,0,214,132,
0,0,214,156,0,0,214,180,0,0,214,204,0,0,214,228,
0,0,214,252,0,0,215,20,0,0,215,44,0,0,215,68,
0,0,215,92,0,0,215,116,0,0,215,140,0,0,215,164,
0,0,218,30,0,0,221,14,0,0,221,38,0,0,221,62,
0,0,221,86,0,0,221,110,0,0,221,134,0,0,221,158,
0,0,221,182,0,0,224,48,0,0,224,72,0,0,224,96,
0,0,224,120,0,0,224,144,0,0,224,168,0,0,224,192,
0,0,224,216,0,0,224,240,0,0,225,8,0,0,225,32,
0,0,225,56,0,0,225,80,0,0,226,212,0,0,228,182,
0,0,228,206,0,0,228,230,0,0,228,254,0,0,229,22,
0,0,229,46,0,0,229,70,0,0,229,94,0,0,229,118,
0,0,229,142,0,0,229,166,0,0,229,190,0,0,229,214,
0,0,229,238,0,0,230,6,0,0,230,30,0,0,231,66,
0,0,231,90,0,0,231,114,0,0,231,138,0,0,231,162,
0,0,231,186,0,0,231,210,0,0,231,234,0,0,232,2,
0,0,232,246,0,0,233,188,0,0,233,212,0,0,233,236,
0,0,234,4,0,0,234,28,0,0,234,52,0,0,234,76,
0,0,234,100,0,0,236,56,0,0,238,130,0,0,238,154,
0,0,238,178,0,0,238,202,0,0,238,226,0,0,238,250,
0,0,239,18,0,0,239,42,0,0,239,66,0,0,239,90,
0,0,239,114,0,0,239,138,0,0,239,162,0,0,239,186,
0,0,239,210,0,0,239,234,0,0,240,2,0,0,240,26,
0,0,240,50,0,0,240,74,0,0,240,98,0,0,240,122,
0,0,240,146,0,0,240,170,0,0,240,194,0,0,241,196,
0,0,243,124,0,0,243,148,0,0,243,172,0,0,243,196,
0,0,243,220,0,0,243,244,0,0,244,12,0,0,244,36,
0,0,244,60,0,0,244,84,0,0,244,108,0,0,244,132,
0,0,244,156,0,0,244,180,0,0,244,204,0,0,244,228,
0,0,244,252,0,0,245,20,0,0,245,44,0,0,245,68,
0,0,245,92,0,0,245,116,0,0,245,140,0,0,246,94,
0,0,248,232,0,0,251,188,0,0,253,202,0,1,0,60,
0,1,2,28,0,1,4,80,0,1,6,176,0,1,8,240,
0,1,11,96,0,1,13,218,0,1,15,230,0,1,17,104,
0,1,20,32,0,1,22,226,0,1,23,246,0,1,26,118,
0,1,28,184,0,1,29,188,0,1,32,142,0,1,33,244,
0,1,36,178,0,1,37,70,0,1,38,12,0,1,40,34,
0,1,41,124,0,1,42,60,0,1,43,94,0,1,45,228,
0,1,47,28,0,1,48,184,0,1,50,160,0,1,50,184,
0,1,50,208,0,1,54,6,0,1,57,54,0,1,58,228,
0,1,61,124,0,1,63,112,0,1,66,16,0,1,68,166,
0,1,69,100,0,1,71,148,0,1,73,246,0,1,75,24,
0,1,76,194,0,1,77,150,0,1,77,174,0,1,77,198,
0,1,79,176,0,1,81,72,0,1,82,176,0,1,85,170,
0,1,86,184,0,1,87,188,0,1,89,168,0,1,91,126,
0,1,93,86,0,1,96,50,0,1,97,128,0,1,98,114,
0,1,99,58,0,1,100,196,0,1,102,162,0,1,102,240,
0,1,103,146,0,1,104,152,0,1,105,66,0,1,105,98,
0,1,105,130,0,1,105,162,0,1,105,186,0,1,105,210,
0,1,105,234,0,1,106,2,0,1,106,26,0,1,106,50,
0,1,106,74,0,1,106,98,0,1,106,122,0,1,106,146,
0,1,106,170,0,1,106,194,0,1,106,218,0,1,106,242,
0,1,107,18,0,1,107,50,0,1,107,82,0,1,107,114,
0,1,107,146,0,1,107,178,0,1,107,210,0,1,107,242,
0,1,110,66,0,1,110,98,0,1,110,130,0,1,110,162,
0,1,110,194,0,1,110,218,0,1,110,242,0,1,113,146,
0,1,117,70,0,1,117,94,0,1,117,118,0,1,117,142,
0,1,117,166,0,1,117,190,0,1,117,214,0,1,117,246,
0,1,118,22,0,1,118,46,0,1,118,70,0,1,118,94,
0,1,118,118,0,1,118,142,0,1,118,166,0,1,118,190,
0,1,118,214,0,1,120,240,0,1,122,204,0,1,122,228,
0,1,122,252,0,1,123,28,0,1,123,60,0,1,123,84,
0,1,123,108,0,1,123,132,0,1,123,156,0,1,123,180,
0,1,123,204,0,1,123,228,0,1,123,252,0,1,124,20,
0,1,124,44,0,1,124,68,0,1,124,92,0,1,124,116,
0,1,124,140,0,1,124,164,0,1,124,188,0,1,124,212,
0,1,124,236,0,1,125,4,0,1,125,28,0,1,125,52,
0,1,125,76,0,1,125,100,0,1,125,124,0,1,125,148,
0,1,125,172,0,1,125,196,0,1,125,220,0,1,125,244,
0,1,126,12,0,1,126,36,0,1,126,60,0,1,128,44,
0,1,130,0,0,1,130,24,0,1,130,48,0,1,132,168,
0,1,135,26,0,1,135,244,0,1,136,210,0,1,136,234,
0,1,137,2,0,1,137,26,0,1,137,50,0,1,137,82,
0,1,137,114,0,1,137,146,0,1,137,178,0,1,137,202,
0,1,137,226,0,1,138,2,0,1,138,34,0,1,138,58,
0,1,138,82,0,1,140,224,0,1,143,90,0,1,145,220,
0,1,148,68,0,1,150,154,0,1,152,244,0,1,155,244,
0,1,158,180,0,1,160,232,0,1,163,56,0,1,165,218,
0,1,168,46,0,1,170,124,0,1,173,72,0,1,175,214,
0,1,177,114,0,1,180,214,0,1,183,188,0,1,186,4,
0,1,187,208,0,1,188,206,0,1,190,60,0,1,191,250,
0,1,193,242,0,1,195,36,0,1,195,198,0,1,196,58,
0,1,197,42,0,1,198,124,0,1,199,140,0,1,201,232,
0,1,204,26,0,1,206,142,0,1,209,86,0,1,211,34,
0,1,213,100,0,1,214,54,0,1,216,36,0,1,218,212,
0,1,221,184,0,1,223,106,0,1,224,66,0,1,225,50,
0,1,226,186,0,1,227,166,0,1,229,56,0,1,230,82,
0,1,231,114,0,1,232,230,0,1,234,232,0,1,238,72,
0,1,240,44,0,1,242,12,0,1,243,234,0,1,245,246,
0,1,247,82,0,1,248,206,0,1,251,16,0,1,252,246,
0,1,254,150,0,1,255,70,0,2,0,70,0,2,1,14,
0,2,1,226,0,2,3,156,0,2,4,208,0,2,6,170,
0,2,9,82,0,2,10,186,0,2,12,12,0,2,13,208,
0,2,15,240,0,2,18,146,0,2,20,240,0,2,23,140,
0,2,26,66,0,2,27,38,0,2,29,90,0,2,30,96,
0,2,31,0,0,2,33,174,0,2,35,100,0,2,37,6,
0,2,39,180,0,2,44,50,0,2,47,76,0,2,51,34,
0,2,54,134,0,2,57,162,0,2,60,248,0,2,63,182,
0,2,64,206,0,2,65,204,0,2,66,78,0,2,66,238,
0,2,67,196,0,2,68,102,0,2,68,238,0,2,69,120,
0,2,70,32,0,2,71,2,0,2,71,136,0,2,72,32,
0,2,72,90,0,2,72,114,0,2,72,132,0,2,72,212,
0,2,72,230,0,2,73,48,0,2,73,128,0,2,74,4,
0,2,74,110,0,2,74,232,0,2,75,66,0,2,75,138,
0,2,75,210,0,2,76,8,0,2,76,66,0,2,76,82,
0,2,76,98,0,2,76,116,0,2,76,134,0,2,76,198,
0,2,77,2,0,2,77,42,0,2,77,68,0,2,77,86,
0,2,77,104,0,2,77,122,0,2,77,140,0,2,77,158,
0,2,77,176,0,2,78,32,0,2,78,50,0,2,78,250,
0,2,79,70,0,2,80,0,0,2,80,158,0,2,81,28,
0,2,81,46,0,2,81,70,0,2,81,96,0,2,81,156,
0,2,81,212,0,2,82,30,0,2,82,118,0,2,82,174,
0,2,82,230,0,2,83,82,0,2,83,200,0,2,84,180,
0,2,85,54,0,2,86,70,0,2,86,164,0,2,86,236,
0,2,87,30,0,2,87,114,0,2,87,210,0,2,88,106,
0,2,88,190,0,2,89,14,0,2,89,94,0,2,89,182,
0,2,90,4,0,2,90,68,0,2,90,128,0,2,90,194,
0,2,91,4,0,2,91,60,0,2,91,144,0,2,91,232,
0,2,92,42,0,2,92,108,0,2,92,192,0,2,92,242,
0,2,93,86,0,2,93,188,0,2,94,50,0,2,95,60,
0,2,96,158,0,2,96,246,0,2,97,94,0,2,97,254,
0,2,98,48,0,2,98,118,0,2,98,232,0,2,99,60,
0,2,99,136,0,2,100,112,0,2,100,196,0,2,101,64,
0,2,101,120,0,2,101,176,0,2,102,18,0,2,102,144,
0,2,102,200,0,2,103,0,0,2,103,58,0,2,103,116,
0,2,103,204,0,2,104,16,0,2,104,80,0,2,104,228,
0,2,105,48,0,2,105,140,0,2,105,240,0,2,106,46,
0,2,106,96,0,2,106,224,0,2,107,118,0,2,108,46,
0,2,108,164,0,2,108,234,0,2,109,62,0,2,109,146,
0,2,109,202,0,2,110,148,0,2,111,40,0,2,111,206,
0,2,112,8,0,2,112,62,0,2,112,178,0,2,113,18,
0,2,113,74,0,2,113,90,0,2,113,108,0,2,113,226,
0,2,113,250,0,2,114,56,0,2,114,240,0,2,115,8,
0,2,115,26,0,2,115,50,0,2,115,74,0,2,115,98,
0,2,115,122,0,2,115,146,0,2,115,170,0,2,115,192,
0,2,116,114,0,2,119,76,0,2,119,248,0,2,120,182,
0,2,121,174,0,2,122,124,0,2,123,130,0,2,126,8,
0,2,126,124,0,2,127,114,0,2,128,16,0,2,129,56,
0,2,130,60,0,2,131,100,0,2,133,144,0,2,134,116,
0,2,136,54,0,2,136,244,0,2,137,160,0,2,138,160,
0,2,140,118,0,2,141,174,0,2,143,118,0,2,145,206,
0,2,145,230,0,2,145,254,0,2,146,22,0,2,146,46,
0,2,146,70,0,2,146,94,0,2,146,118,0,2,148,230,
0,2,150,240,0,2,152,38,0,2,154,64,0,2,156,166,
0,2,158,74,0,2,159,230,0,2,161,240,0,2,162,134,
0,2,164,84,0,2,165,58,0,2,167,40,0,2,167,244,
0,2,169,190,0,2,171,234,0,2,174,28,0,2,176,8,
0,2,178,156,0,2,180,190,0,2,182,122,0,2,185,112,
0,2,186,128,0,2,189,20,0,2,191,154,0,2,191,178,
0,2,191,202,0,2,191,226,0,2,191,250,0,2,192,18,
0,2,194,122,0,2,196,202,0,2,198,58,0,2,198,82,
0,2,198,106,0,2,201,124,0,2,201,148,0,2,201,172,
0,2,201,196,0,2,201,220,0,2,201,244,0,2,202,12,
0,2,202,36,0,2,202,60,0,2,202,92,0,2,202,124,
0,2,202,148,0,2,202,172,0,2,202,196,0,2,202,220,
0,2,202,244,0,2,203,12,0,2,203,36,0,2,203,60,
0,2,203,84,0,2,203,108,0,2,203,140,0,2,203,172,
0,2,203,204,0,2,203,236,0,2,204,4,0,2,204,28,
0,2,204,52,0,2,204,76,0,2,204,108,0,2,204,140,
0,2,204,164,0,2,204,188,0,2,204,212,0,2,204,236,
0,2,205,4,0,2,205,28,0,2,205,52,0,2,205,76,
0,2,205,100,0,2,205,124,0,2,205,148,0,2,205,172,
0,2,205,196,0,2,205,220,0,2,205,244,0,2,206,12,
0,2,206,44,0,2,206,76,0,2,206,100,0,2,206,124,
0,2,206,148,0,2,206,172,0,2,206,196,0,2,206,220,
0,2,206,244,0,2,207,12,0,2,207,44,0,2,207,76,
0,2,207,100,0,2,207,124,0,2,207,148,0,2,207,172,
0,2,207,196,0,2,207,220,0,2,207,244,0,2,208,12,
0,2,208,36,0,2,208,60,0,2,208,84,0,2,208,108,
0,2,208,132,0,2,208,156,0,2,208,180,0,2,208,204,
0,2,208,228,0,2,208,252,0,2,209,28,0,2,209,60,
0,2,209,92,0,2,209,124,0,2,209,156,0,2,209,188,
0,2,209,220,0,2,209,252,0,2,210,20,0,2,210,44,
0,2,210,68,0,2,210,92,0,2,210,116,0,2,210,140,
0,2,210,164,0,2,210,188,0,2,210,220,0,2,210,252,
0,2,211,20,0,2,211,44,0,2,211,68,0,2,211,92,
0,2,211,116,0,2,211,140,0,2,211,172,0,2,211,204,
0,2,211,236,0,2,212,12,0,2,212,44,0,2,212,76,
0,2,212,100,0,2,212,124,0,2,212,148,0,2,212,172,
0,2,212,196,0,2,212,220,0,2,212,244,0,2,213,12,
0,2,213,36,0,2,213,60,0,2,213,84,0,2,213,108,
0,2,213,132,0,2,213,156,0,2,213,188,0,2,213,220,
0,2,213,252,0,2,214,28,0,2,214,52,0,2,214,76,
0,2,214,100,0,2,214,124,0,2,214,148,0,2,214,172,
0,2,214,196,0,2,214,220,0,2,214,244,0,2,215,12,
0,2,215,36,0,2,215,60,0,2,215,84,0,2,215,108,
0,2,215,132,0,2,215,156,0,2,215,180,0,2,215,204,
0,2,215,228,0,2,215,252,0,2,216,20,0,2,216,44,
0,2,216,68,0,2,216,92,0,2,216,116,0,2,216,140,
0,2,216,164,0,2,216,188,0,2,216,212,0,2,216,236,
0,2,217,4,0,2,217,28,0,2,217,52,0,2,217,76,
0,2,217,100,0,2,217,124,0,2,217,148,0,2,217,172,
0,2,217,196,0,2,217,220,0,2,217,244,0,2,218,12,
0,2,218,36,0,2,218,60,0,2,218,92,0,2,218,124,
0,2,218,148,0,2,218,172,0,2,218,196,0,2,218,220,
0,2,218,244,0,2,219,12,0,2,219,36,0,2,219,60,
0,2,219,92,0,2,219,124,0,2,219,148,0,2,219,172,
0,2,219,196,0,2,219,220,0,2,219,244,0,2,220,12,
0,2,220,36,0,2,220,60,0,2,220,84,0,2,220,108,
0,2,220,132,0,2,220,156,0,2,220,180,0,2,220,204,
0,2,220,236,0,2,221,12,0,2,221,36,0,2,221,60,
0,2,221,84,0,2,221,108,0,2,221,132,0,2,221,156,
0,2,221,180,0,2,221,204,0,2,221,228,0,2,221,252,
0,2,222,20,0,2,222,44,0,2,222,68,0,2,222,92,
0,2,222,116,0,2,222,140,0,2,222,172,0,2,222,204,
0,2,222,236,0,2,223,12,0,2,223,44,0,2,223,76,
0,2,223,108,0,2,223,140,0,2,223,172,0,2,223,204,
0,2,223,236,0,2,224,12,0,2,224,36,0,2,224,60,
0,2,224,84,0,2,224,108,0,2,224,140,0,2,224,172,
0,2,224,204,0,2,224,236,0,2,225,12,0,2,225,44,
0,2,225,76,0,2,225,108,0,2,225,140,0,2,225,172,
0,2,225,196,0,2,225,220,0,2,225,244,0,2,226,12,
0,2,226,36,0,2,226,60,0,2,226,84,0,2,226,108,
0,2,226,132,0,2,226,156,0,2,226,180,0,2,226,202,
0,2,226,226,0,2,226,250,0,2,227,18,0,2,227,42,
0,2,227,66,0,2,227,90,0,2,227,114,0,2,227,138,
0,2,227,162,0,2,227,186,0,2,227,210,0,2,227,234,
0,2,228,2,0,2,228,26,0,2,228,48,0,2,228,70,
0,2,228,94,0,2,228,118,0,2,228,142,0,2,228,166,
0,2,228,190,0,2,228,214,0,2,228,238,0,2,229,6,
0,2,229,30,0,2,229,54,0,2,229,78,0,2,229,102,
0,2,229,126,0,2,229,150,0,2,229,174,0,2,229,198,
0,2,229,222,0,2,229,246,0,2,230,14,0,2,230,38,
0,2,230,62,0,2,230,86,0,2,230,110,0,2,230,134,
0,2,230,156,0,2,230,178,0,2,230,200,0,2,230,222,
0,2,230,244,0,2,231,10,0,2,231,32,0,2,231,54,
0,2,231,78,0,2,231,102,0,2,231,126,0,2,231,150,
0,2,231,174,0,2,231,198,0,2,231,222,0,2,231,246,
0,2,232,14,0,2,232,38,0,2,232,62,0,2,232,84,
0,2,232,108,0,2,232,132,0,2,232,156,0,2,232,180,
0,2,232,204,0,2,232,228,0,2,232,252,0,2,233,20,
0,2,233,44,0,2,233,68,0,2,233,92,0,2,233,116,
0,2,233,140,0,2,233,164,0,2,233,188,0,2,233,212,
0,2,233,236,0,2,234,4,0,2,234,28,0,2,234,52,
0,2,234,76,0,2,234,100,0,2,234,124,0,2,234,148,
0,2,234,172,0,2,234,196,0,2,234,220,0,2,234,244,
0,2,235,12,0,2,235,36,0,2,235,60,0,2,235,84,
0,2,235,108,0,2,235,132,0,2,235,156,0,2,235,180,
0,2,235,204,0,2,235,228,0,2,235,252,0,2,236,20,
0,2,236,44,0,2,236,68,0,2,236,90,0,2,236,114,
0,2,236,138,0,2,236,162,0,2,236,186,0,2,236,210,
0,2,236,234,0,2,237,2,0,2,237,34,0,2,237,66,
0,2,237,98,0,2,237,128,0,2,237,160,0,2,237,192,
0,2,237,224,0,2,238,0,0,2,238,32,0,2,238,64,
0,2,238,96,0,2,238,128,0,2,238,160,0,2,238,192,
0,2,238,224,0,2,239,0,0,2,239,32,0,2,239,64,
0,2,239,96,0,2,239,128,0,2,239,160,0,2,239,192,
0,2,239,224,0,2,240,0,0,2,240,32,0,2,240,64,
0,2,240,96,0,2,240,128,0,2,240,160,0,2,240,192,
0,2,240,224,0,2,241,0,0,2,241,32,0,2,241,64,
0,2,241,96,0,2,241,128,0,2,241,160,0,2,241,192,
0,2,241,224,0,2,242,0,0,2,242,32,0,2,242,64,
0,2,242,96,0,2,242,128,0,2,242,160,0,2,242,192,
0,2,242,224,0,2,243,0,0,2,243,24,0,2,243,48,
0,2,243,80,0,2,243,104,0,2,243,136,0,2,243,160,
0,2,243,192,0,2,243,216,0,2,243,240,0,2,244,8,
0,2,244,32,0,2,244,56,0,2,244,206,0,2,245,100,
0,2,245,250,0,2,246,122,0,2,248,112,0,2,248,144,
0,2,248,168,0,2,248,200,0,2,248,224,0,2,249,0,
0,2,249,24,0,2,249,48,0,2,249,72,0,2,249,96,
0,2,249,120,0,2,250,54,0,2,251,0,0,2,251,190,
0,2,251,214,0,2,251,238,0,2,252,4,0,2,252,26,
0,2,252,48,0,2,252,70,0,2,252,94,0,2,252,118,
0,2,252,142,0,2,252,166,0,2,253,100,0,2,254,46,
0,2,255,0,0,2,255,24,0,2,255,48,0,2,255,72,
0,2,255,96,0,2,255,120,0,2,255,144,0,2,255,168,
0,2,255,192,0,2,255,216,0,2,255,240,0,3,0,8,
0,3,0,32,0,3,0,56,0,3,0,242,0,3,1,170,
0,3,1,230,0,3,2,6,0,3,2,30,0,3,2,62,
0,3,2,86,0,3,2,118,0,3,2,142,0,3,2,166,
0,3,2,190,0,3,2,214,0,3,2,238,0,3,3,44,
0,3,3,200,0,3,3,200,0,3,3,200,0,3,3,200,
0,3,3,200,0,3,3,200,0,3,3,200,0,3,3,200,
0,3,3,200,0,3,3,200,0,3,3,200,0,3,3,200,
0,3,3,200,0,3,4,10,0,3,4,76,0,3,4,142,
0,3,4,208,0,3,5,104,0,3,5,240,0,3,6,136,
0,3,7,178,0,3,7,226,0,3,8,104,0,3,9,120,
0,3,9,252,0,3,10,144,0,3,10,252,0,3,11,172,
0,3,12,56,0,3,12,152,0,3,13,92,0,3,13,248,
0,3,14,118,0,3,14,176,0,3,15,20,0,3,15,92,
0,3,15,166,0,3,16,106,0,3,16,124,0,3,16,142,
0,3,16,160,0,3,16,178,0,3,16,196,0,3,16,214,
0,3,16,232,0,3,16,250,0,3,17,12,0,3,17,30,
0,3,17,48,0,3,17,66,0,3,17,84,0,3,17,102,
0,3,17,174,0,3,20,4,0,3,21,136,0,3,22,166,
0,3,24,34,0,3,26,30,0,3,28,18,0,3,32,22,
0,3,34,152,0,3,37,48,0,3,39,44,0,3,40,102,
0,3,41,208,0,3,46,188,0,3,49,48,0,3,49,114,
0,3,49,166,0,3,50,206,0,3,51,50,0,3,51,158,
0,3,52,84,0,3,52,234,0,3,53,118,0,3,54,6,
0,3,54,222,0,3,55,150,0,3,55,174,0,3,55,206,
0,3,55,238,0,3,56,46,0,3,57,26,0,3,58,180,
0,3,60,22,0,3,60,80,0,3,60,140,0,3,62,32,
0,3,64,180,0,3,65,0,0,3,65,72,0,3,65,88,
0,3,65,104,0,3,65,222,0,3,66,118,0,3,66,182,
0,3,66,242,0,3,67,62,0,3,67,214,0,3,68,14,
0,3,68,132,0,3,69,230,0,3,70,46,0,3,70,122,
0,3,70,198,0,3,70,222,0,3,70,246,0,3,71,14,
0,3,71,38,0,3,71,62,0,3,71,86,0,3,71,110,
0,3,71,134,0,3,71,158,0,3,71,182,0,3,71,206,
0,3,71,230,0,3,71,254,0,3,72,22,0,3,72,46,
0,3,72,70,0,3,72,94,0,3,72,118,0,3,72,142,
0,3,72,166,0,3,72,190,0,3,72,214,0,3,72,238,
0,3,73,6,0,3,73,30,0,3,73,54,0,3,73,78,
0,3,73,102,0,3,73,126,0,3,73,150,0,3,73,174,
0,3,73,198,0,3,73,222,0,3,73,246,0,3,74,14,
0,3,74,38,0,3,74,62,0,3,74,86,0,3,74,110,
0,3,74,134,0,3,74,158,0,3,74,182,0,3,74,206,
0,3,74,230,0,3,74,254,0,3,75,22,0,3,75,46,
0,3,75,70,0,3,75,94,0,3,75,118,0,3,75,142,
0,3,75,166,0,3,75,190,0,3,75,214,0,3,75,238,
0,3,76,14,0,3,76,46,0,3,76,70,0,3,76,94,
0,3,76,118,0,3,76,142,0,3,76,166,0,3,76,190,
0,3,76,214,0,3,76,238,0,3,77,14,0,3,77,46,
0,3,77,78,0,3,77,110,0,3,77,142,0,3,77,174,
0,3,77,198,0,3,77,222,0,3,77,254,0,3,78,22,
0,3,78,46,0,3,78,70,0,3,78,94,0,3,78,118,
0,3,78,142,0,3,78,166,0,3,78,198,0,3,78,230,
0,3,78,254,0,3,79,30,0,3,79,54,0,3,79,78,
0,3,79,110,0,3,79,134,0,3,79,166,0,3,79,198,
0,3,79,222,0,3,79,246,0,3,80,22,0,3,80,46,
0,3,80,70,0,3,80,94,0,3,80,126,0,3,80,158,
0,3,80,190,0,3,80,222,0,3,80,246,0,3,81,14,
0,3,81,38,0,3,81,70,0,3,81,94,0,3,81,126,
0,3,81,158,0,3,81,190,0,3,81,222,0,3,81,254,
0,3,82,22,0,3,82,46,0,3,82,70,0,3,82,94,
0,3,82,118,0,3,82,142,0,3,82,166,0,3,82,190,
0,3,82,214,0,3,82,238,0,3,83,6,0,3,83,30,
0,3,83,54,0,3,83,86,0,3,83,110,0,3,83,134,
0,3,83,158,0,3,83,182,0,3,83,206,0,3,83,230,
0,3,83,254,0,3,84,22,0,3,84,54,0,3,84,78,
0,3,84,102,0,3,84,126,0,3,84,150,0,3,84,174,
0,3,84,206,0,3,84,238,0,3,85,14,0,3,85,46,
0,3,85,78,0,3,85,110,0,3,85,142,0,3,85,166,
0,3,85,190,0,3,86,10,0,3,86,86,0,3,88,6,
0,3,88,152,0,3,89,48,0,3,89,72,0,3,89,96,
0,3,89,120,0,3,89,144,0,3,89,168,0,3,89,192,
0,3,89,216,0,3,89,240,0,3,90,6,0,3,90,28,
0,3,90,52,0,3,90,76,0,3,90,100,0,3,90,124,
0,3,90,148,0,3,90,172,0,3,90,196,0,3,90,220,
0,3,90,244,0,3,91,20,0,3,91,52,0,3,91,84,
0,3,91,116,0,3,91,148,0,3,91,180,0,3,91,212,
0,3,91,244,0,3,92,20,0,3,92,52,0,3,92,84,
0,3,92,116,0,3,92,140,0,3,92,172,0,3,92,196,
0,3,92,228,0,3,92,250,0,3,93,16,0,3,93,40,
0,3,93,64,0,3,93,88,0,3,93,120,0,3,93,224,
0,3,94,80,0,3,95,18,0,3,95,170,0,3,96,54,
0,3,96,196,0,3,97,124,0,3,97,148,0,3,97,180,
0,3,100,86,0,3,100,202,0,3,101,122,0,3,102,44,
0,3,104,58,0,3,107,20,0,3,107,192,0,3,109,22,
0,3,110,14,0,3,112,182,0,3,115,84,0,3,116,118,
0,3,118,26,0,3,119,230,0,3,120,192,0,3,121,228,
0,3,122,234,0,3,125,18,0,3,125,248,0,3,127,186,
0,3,129,164,0,3,130,84,0,3,131,28,0,3,132,242,
0,3,134,42,0,3,135,24,0,3,136,6,0,3,137,88,
0,3,138,218,0,3,140,208,0,3,143,0,0,3,144,214,
0,3,146,216,0,3,149,88,0,3,151,162,0,3,154,16,
0,3,156,66,0,3,159,6,0,3,159,148,0,3,161,134,
0,3,163,174,0,3,166,102,0,3,169,10,0,3,169,238,
0,3,171,42,0,3,172,252,0,3,174,8,0,3,174,228,
0,3,175,188,0,3,177,232,0,3,178,158,0,3,181,28,
0,3,183,8,0,3,183,180,0,3,184,148,0,3,188,0,
0,3,189,62,0,3,190,56,0,3,191,42,0,3,192,184,
0,3,194,162,0,3,196,158,0,3,198,202,0,3,200,156,
0,3,202,140,0,3,204,226,0,3,207,28,0,3,209,174,
0,3,210,154,0,3,212,52,0,3,212,168,0,3,213,134,
0,3,214,242,0,3,218,152,0,3,221,24,0,3,223,104,
0,3,225,84,0,3,227,46,0,3,229,22,0,3,231,4,
0,3,233,80,0,3,0,88,255,82,3,94,5,104,0,10,
0,21,0,90,1,82,187,0,0,0,4,0,51,0,4,43,
187,0,79,0,3,0,5,0,4,43,184,0,79,16,187,0,
84,0,4,0,11,0,4,43,184,0,84,16,65,19,0,6,
0,0,0,22,0,0,0,38,0,0,0,54,0,0,0,70,
0,0,0,86,0,0,0,102,0,0,0,118,0,0,0,134,
0,0,0,9,93,65,5,0,149,0,0,0,165,0,0,0,
2,93,65,5,0,154,0,11,0,170,0,11,0,2,93,65,
19,0,9,0,11,0,25,0,11,0,41,0,11,0,57,0,
11,0,73,0,11,0,89,0,11,0,105,0,11,0,121,0,
11,0,137,0,11,0,9,93,184,0,79,16,184,0,16,208,
184,0,79,16,184,0,22,208,184,0,5,16,184,0,28,208,
184,0,51,16,184,0,38,208,184,0,38,47,184,0,5,16,
184,0,45,208,184,0,5,16,184,0,56,208,184,0,79,16,
184,0,63,208,184,0,79,16,184,0,89,208,184,0,84,16,
184,0,92,220,0,184,0,27,47,184,0,62,47,184,0,0,
69,88,184,0,29,47,27,185,0,29,0,5,62,89,184,0,
0,69,88,184,0,32,47,27,185,0,32,0,5,62,89,184,
0,0,69,88,184,0,89,47,27,185,0,89,0,5,62,89,
187,0,64,0,2,0,6,0,4,43,184,0,64,16,184,0,
89,16,185,0,17,0,2,252,184,0,45,208,184,0,45,47,
184,0,64,16,184,0,56,208,184,0,56,47,186,0,78,0,
27,0,62,17,18,57,48,49,19,20,30,2,23,17,14,3,
1,52,46,2,39,17,62,3,3,14,3,7,39,53,34,6,
35,34,38,39,46,1,53,52,54,55,23,30,1,23,17,46,
3,53,52,62,2,55,53,62,3,55,23,21,30,3,23,22,
14,2,7,39,46,1,39,17,30,3,21,20,14,2,7,21,
225,32,56,76,43,58,79,49,21,1,246,32,56,75,42,40,
74,57,34,205,9,13,13,16,12,27,5,10,5,70,149,91,
7,7,6,8,43,48,148,91,62,119,95,58,33,78,128,95,
14,12,10,13,15,26,46,87,76,60,20,6,15,28,34,13,
39,40,84,42,62,122,96,60,39,83,129,89,3,190,38,57,
46,37,17,1,96,2,29,44,55,253,107,47,72,55,42,18,
254,67,5,35,55,73,254,88,8,9,6,5,3,22,143,1,
49,57,5,57,37,38,79,28,4,103,107,12,1,223,23,50,
71,100,74,42,97,85,64,11,146,8,8,5,3,4,22,148,
1,13,24,33,19,7,37,43,42,12,8,46,56,12,254,135,
24,56,81,111,79,59,120,104,78,16,143,0,0,5,0,76,
255,222,5,57,4,213,0,19,0,39,0,51,0,71,0,91,
1,212,187,0,30,0,4,0,82,0,4,43,184,0,30,16,
187,0,72,0,4,0,20,0,4,43,184,0,72,16,187,0,
10,0,4,0,62,0,4,43,184,0,10,16,187,0,52,0,
4,0,0,0,4,43,184,0,52,16,65,5,0,154,0,0,
0,170,0,0,0,2,93,65,19,0,9,0,0,0,25,0,
0,0,41,0,0,0,57,0,0,0,73,0,0,0,89,0,
0,0,105,0,0,0,121,0,0,0,137,0,0,0,9,93,
65,19,0,6,0,30,0,22,0,30,0,38,0,30,0,54,
0,30,0,70,0,30,0,86,0,30,0,102,0,30,0,118,
0,30,0,134,0,30,0,9,93,65,5,0,149,0,30,0,
165,0,30,0,2,93,65,5,0,154,0,62,0,170,0,62,
0,2,93,65,19,0,9,0,62,0,25,0,62,0,41,0,
62,0,57,0,62,0,73,0,62,0,89,0,62,0,105,0,
62,0,121,0,62,0,137,0,62,0,9,93,65,19,0,6,
0,72,0,22,0,72,0,38,0,72,0,54,0,72,0,70,
0,72,0,86,0,72,0,102,0,72,0,118,0,72,0,134,
0,72,0,9,93,65,5,0,149,0,72,0,165,0,72,0,
2,93,184,0,93,220,0,184,0,50,47,184,0,87,47,184,
0,45,47,184,0,57,47,187,0,67,0,2,0,77,0,4,
43,184,0,67,16,184,0,77,16,184,0,5,208,184,0,5,
47,184,0,57,16,185,0,15,0,2,252,65,33,0,7,0,
15,0,23,0,15,0,39,0,15,0,55,0,15,0,71,0,
15,0,87,0,15,0,103,0,15,0,119,0,15,0,135,0,
15,0,151,0,15,0,167,0,15,0,183,0,15,0,199,0,
15,0,215,0,15,0,231,0,15,0,247,0,15,0,16,93,
65,15,0,7,0,15,0,23,0,15,0,39,0,15,0,55,
0,15,0,71,0,15,0,87,0,15,0,103,0,15,0,7,
113,65,5,0,118,0,15,0,134,0,15,0,2,113,184,0,
87,16,185,0,25,0,2,252,184,0,67,16,184,0,35,208,
184,0,35,47,48,49,1,52,46,2,35,34,14,2,21,20,
30,2,51,50,62,2,1,52,46,2,35,34,14,2,21,20,
30,2,51,50,62,2,3,14,3,7,39,1,62,1,55,23,
19,20,14,2,35,34,46,2,53,52,62,2,51,50,30,2,
1,20,14,2,35,34,46,2,53,52,62,2,51,50,30,2,
4,170,25,42,54,29,22,43,34,21,22,39,54,32,25,44,
34,20,253,66,25,42,54,29,22,43,35,21,22,39,55,32,
24,45,34,20,134,9,35,40,39,12,24,3,88,28,74,31,
29,120,48,80,107,58,58,98,70,40,49,81,106,57,60,98,
70,38,253,68,48,81,107,59,59,97,71,39,48,81,106,58,
60,98,71,39,1,33,70,104,69,33,29,58,87,59,72,106,
69,34,30,60,89,2,135,71,104,68,33,29,58,87,59,72,
106,69,34,30,60,89,252,223,7,15,13,12,4,35,4,163,
17,24,8,33,252,129,69,123,93,54,54,93,123,69,69,123,
92,53,53,91,123,2,6,69,123,93,54,54,93,123,69,69,
123,91,54,53,92,122,0,3,0,80,255,226,5,66,5,170,
0,19,0,37,0,115,1,232,187,0,33,0,4,0,74,0,
4,43,184,0,33,16,187,0,0,0,4,0,80,0,4,43,
184,0,0,16,187,0,90,0,4,0,10,0,4,43,184,0,
90,16,187,0,51,0,4,0,104,0,4,43,184,0,51,16,
65,19,0,6,0,0,0,22,0,0,0,38,0,0,0,54,
0,0,0,70,0,0,0,86,0,0,0,102,0,0,0,118,
0,0,0,134,0,0,0,9,93,65,5,0,149,0,0,0,
165,0,0,0,2,93,65,5,0,154,0,10,0,170,0,10,
0,2,93,65,19,0,9,0,10,0,25,0,10,0,41,0,
10,0,57,0,10,0,73,0,10,0,89,0,10,0,105,0,
10,0,121,0,10,0,137,0,10,0,9,93,65,19,0,6,
0,33,0,22,0,33,0,38,0,33,0,54,0,33,0,70,
0,33,0,86,0,33,0,102,0,33,0,118,0,33,0,134,
0,33,0,9,93,65,5,0,149,0,33,0,165,0,33,0,
2,93,65,5,0,154,0,104,0,170,0,104,0,2,93,65,
19,0,9,0,104,0,25,0,104,0,41,0,104,0,57,0,
104,0,73,0,104,0,89,0,104,0,105,0,104,0,121,0,
104,0,137,0,104,0,9,93,186,0,46,0,104,0,51,17,
18,57,184,0,117,220,0,184,0,0,69,88,184,0,63,47,
27,185,0,63,0,5,62,89,184,0,0,69,88,184,0,69,
47,27,185,0,69,0,5,62,89,187,0,85,0,2,0,15,
0,4,43,184,0,85,16,187,0,113,0,2,0,109,0,4,
43,184,0,113,16,184,0,69,16,185,0,20,0,2,252,65,
33,0,7,0,20,0,23,0,20,0,39,0,20,0,55,0,
20,0,71,0,20,0,87,0,20,0,103,0,20,0,119,0,
20,0,135,0,20,0,151,0,20,0,167,0,20,0,183,0,
20,0,199,0,20,0,215,0,20,0,231,0,20,0,247,0,
20,0,16,93,65,15,0,7,0,20,0,23,0,20,0,39,
0,20,0,55,0,20,0,71,0,20,0,87,0,20,0,103,
0,20,0,7,113,65,5,0,118,0,20,0,134,0,20,0,
2,113,184,0,109,16,184,0,46,208,184,0,46,47,48,49,
1,20,22,23,54,55,62,3,53,52,46,2,35,34,14,2,
19,50,54,55,46,3,39,14,3,21,20,30,2,1,14,1,
7,46,3,39,30,3,21,20,6,7,22,23,30,1,55,23,
14,1,35,34,38,39,14,1,35,34,46,2,53,52,54,55,
46,1,53,52,62,2,51,50,30,2,21,20,6,7,14,1,
7,30,3,23,62,1,53,52,46,2,35,39,62,1,55,33,
23,1,188,34,29,3,6,64,83,48,18,18,35,53,35,36,
54,36,18,84,85,142,57,50,106,101,93,37,51,70,43,19,
48,80,103,3,105,25,49,25,18,46,47,44,17,11,13,7,
2,62,57,69,58,38,88,58,9,87,119,22,22,110,72,78,
192,109,93,154,110,61,154,146,29,34,54,90,117,63,64,87,
53,23,131,119,19,34,16,35,87,97,103,51,32,33,28,45,
58,29,22,11,43,20,1,188,23,4,106,58,126,66,1,4,
35,74,73,71,33,35,62,47,28,37,60,77,251,195,54,45,
52,121,133,142,72,44,82,81,81,42,70,108,73,38,2,152,
31,41,17,9,14,11,6,1,18,31,36,43,29,71,158,75,
66,46,32,21,14,43,38,37,80,69,66,83,49,96,143,94,
112,229,106,71,137,66,81,138,101,57,41,68,89,48,105,183,
74,12,23,11,65,130,126,118,52,50,102,45,42,74,55,32,
28,13,30,8,36,0,0,1,0,160,3,45,1,96,5,200,
0,12,0,11,0,184,0,11,47,184,0,5,47,48,49,1,
14,3,35,3,62,3,55,23,1,53,8,23,26,27,12,53,
11,42,45,40,11,43,3,66,4,8,6,3,2,101,6,17,
16,13,2,21,0,1,0,121,254,197,2,98,6,64,0,21,
0,79,187,0,16,0,4,0,5,0,4,43,184,0,16,16,
65,19,0,6,0,16,0,22,0,16,0,38,0,16,0,54,
0,16,0,70,0,16,0,86,0,16,0,102,0,16,0,118,
0,16,0,134,0,16,0,9,93,65,5,0,149,0,16,0,
165,0,16,0,2,93,0,184,0,10,47,184,0,0,47,48,
49,1,46,2,2,53,52,26,1,54,55,23,14,2,2,21,
20,18,30,1,23,2,66,113,171,115,58,65,120,169,103,32,
65,116,87,51,42,82,118,77,254,197,52,187,246,1,38,159,
164,1,50,1,2,195,54,45,54,176,232,254,230,160,146,254,
235,241,194,63,0,1,0,41,254,197,2,18,6,64,0,21,
0,75,187,0,0,0,4,0,11,0,4,43,65,5,0,154,
0,11,0,170,0,11,0,2,93,65,19,0,9,0,11,0,
25,0,11,0,41,0,11,0,57,0,11,0,73,0,11,0,
89,0,11,0,105,0,11,0,121,0,11,0,137,0,11,0,
9,93,0,184,0,17,47,184,0,5,47,48,49,1,20,10,
1,6,7,39,62,2,18,53,52,2,46,1,39,55,30,2,
18,2,18,66,120,169,103,31,64,116,88,51,42,81,119,77,
31,113,171,116,58,2,152,165,254,205,254,254,195,54,45,54,
176,232,1,26,161,145,1,21,242,194,62,45,51,187,246,254,
219,0,0,1,0,70,2,197,3,78,6,25,0,43,0,71,
0,184,0,18,47,184,0,42,47,186,0,0,0,18,0,42,
17,18,57,186,0,6,0,18,0,42,17,18,57,186,0,12,
0,18,0,42,17,18,57,186,0,20,0,18,0,42,17,18,
57,186,0,28,0,18,0,42,17,18,57,186,0,36,0,18,
0,42,17,18,57,48,49,1,37,30,1,31,1,13,1,14,
1,15,1,37,19,14,3,7,39,19,5,46,3,47,1,45,
1,62,3,63,1,5,3,62,3,55,23,1,233,1,5,21,
57,16,2,254,186,1,45,2,2,8,37,254,230,38,11,26,
29,27,11,39,42,254,251,11,27,26,23,7,2,1,70,254,
210,1,1,2,4,4,35,1,29,39,11,28,29,28,11,36,
4,164,196,14,36,17,41,141,129,25,68,22,23,211,254,189,
6,15,13,11,2,18,1,96,196,7,17,18,17,8,43,140,
129,12,31,32,29,10,23,212,1,70,6,14,14,11,3,21,
0,1,0,61,0,205,3,10,3,152,0,24,0,71,187,0,
0,0,3,0,4,0,4,43,184,0,4,16,184,0,11,208,
184,0,0,16,184,0,16,208,184,0,0,16,184,0,23,208,
0,184,0,15,47,184,0,3,47,187,0,11,0,2,0,5,
0,4,43,184,0,11,16,184,0,17,208,184,0,5,16,184,
0,22,208,48,49,37,14,1,7,39,17,33,39,62,1,55,
33,17,62,1,55,23,17,33,23,14,1,7,33,17,1,221,
20,48,22,25,254,236,25,5,17,9,1,14,19,50,22,24,
1,21,24,5,17,8,254,241,236,10,16,5,22,1,23,24,
20,48,20,1,17,6,18,5,23,254,233,24,20,51,17,254,
242,0,0,1,0,88,254,207,1,135,0,230,0,22,0,71,
187,0,0,0,4,0,11,0,4,43,65,5,0,154,0,11,
0,170,0,11,0,2,93,65,19,0,9,0,11,0,25,0,
11,0,41,0,11,0,57,0,11,0,73,0,11,0,89,0,
11,0,105,0,11,0,121,0,11,0,137,0,11,0,9,93,
0,184,0,5,47,48,49,37,20,14,2,7,39,62,3,53,
52,38,7,39,62,3,23,30,1,1,135,31,59,83,52,45,
28,39,24,11,55,64,16,9,58,69,67,18,48,34,70,39,
98,102,97,39,35,32,60,64,71,43,44,52,4,47,12,31,
29,19,1,23,79,0,0,1,0,61,1,199,2,117,2,57,
0,10,0,17,0,187,0,9,0,2,0,3,0,4,43,184,
0,9,16,48,49,1,14,1,7,33,39,62,1,55,33,23,
2,117,6,17,8,254,0,25,5,17,9,2,0,25,2,33,
22,51,17,24,22,48,20,24,0,1,0,131,255,216,1,113,
0,236,0,15,0,79,187,0,0,0,4,0,8,0,4,43,
65,19,0,6,0,0,0,22,0,0,0,38,0,0,0,54,
0,0,0,70,0,0,0,86,0,0,0,102,0,0,0,118,
0,0,0,134,0,0,0,9,93,65,5,0,149,0,0,0,
165,0,0,0,2,93,0,186,0,13,0,5,0,3,43,184,
0,13,16,48,49,37,20,14,2,35,34,38,53,52,62,2,
51,50,22,1,113,21,37,51,29,54,46,22,38,51,28,50,
49,123,35,59,44,25,58,54,34,59,45,26,59,0,0,1,
0,49,254,177,3,141,6,64,0,11,0,11,0,184,0,10,
47,184,0,5,47,48,49,19,14,3,7,39,1,62,1,55,
23,211,10,32,36,35,12,37,2,189,27,66,29,37,254,228,
7,15,13,12,4,25,7,69,17,24,8,22,0,2,0,76,
255,226,3,117,4,211,0,19,0,39,1,47,184,0,40,47,
184,0,41,47,184,0,20,220,185,0,0,0,4,252,65,5,
0,154,0,0,0,170,0,0,0,2,93,65,19,0,9,0,
0,0,25,0,0,0,41,0,0,0,57,0,0,0,73,0,
0,0,89,0,0,0,105,0,0,0,121,0,0,0,137,0,
0,0,9,93,184,0,40,16,184,0,30,208,184,0,30,47,
185,0,10,0,4,252,65,19,0,6,0,10,0,22,0,10,
0,38,0,10,0,54,0,10,0,70,0,10,0,86,0,10,
0,102,0,10,0,118,0,10,0,134,0,10,0,9,93,65,
5,0,149,0,10,0,165,0,10,0,2,93,0,184,0,0,
69,88,184,0,25,47,27,185,0,25,0,5,62,89,187,0,
35,0,2,0,5,0,4,43,184,0,35,16,184,0,25,16,
185,0,15,0,2,252,65,33,0,7,0,15,0,23,0,15,
0,39,0,15,0,55,0,15,0,71,0,15,0,87,0,15,
0,103,0,15,0,119,0,15,0,135,0,15,0,151,0,15,
0,167,0,15,0,183,0,15,0,199,0,15,0,215,0,15,
0,231,0,15,0,247,0,15,0,16,93,65,15,0,7,0,
15,0,23,0,15,0,39,0,15,0,55,0,15,0,71,0,
15,0,87,0,15,0,103,0,15,0,7,113,65,5,0,118,
0,15,0,134,0,15,0,2,113,48,49,1,52,46,2,35,
34,14,2,21,20,30,2,51,50,62,2,55,20,14,2,35,
34,46,2,53,52,62,2,51,50,30,2,2,209,43,72,94,
51,51,82,57,31,40,69,95,56,52,82,57,30,164,61,111,
157,95,95,144,97,49,62,111,156,95,95,144,97,49,2,53,
137,208,139,71,55,115,180,125,137,210,141,72,55,117,181,164,
129,230,172,101,101,172,230,129,129,230,173,101,100,172,231,0,
0,1,0,139,0,0,3,72,4,221,0,29,0,38,187,0,
23,0,4,0,6,0,4,43,184,0,23,16,0,184,0,21,
47,184,0,0,69,88,184,0,0,47,27,185,0,0,0,5,
62,89,48,49,51,53,62,3,53,17,52,38,39,46,1,14,
1,7,39,62,3,55,23,17,20,30,2,23,21,170,78,104,
62,26,6,12,6,34,62,94,66,21,42,115,118,106,33,37,
22,56,97,75,53,9,23,24,23,11,3,29,40,44,14,6,
8,2,12,14,51,12,42,49,49,18,35,251,213,10,23,24,
24,9,53,0,0,1,0,98,0,0,3,68,4,211,0,50,
0,124,187,0,35,0,4,0,9,0,4,43,184,0,35,16,
184,0,0,208,65,5,0,154,0,9,0,170,0,9,0,2,
93,65,19,0,9,0,9,0,25,0,9,0,41,0,9,0,
57,0,9,0,73,0,9,0,89,0,9,0,105,0,9,0,
121,0,9,0,137,0,9,0,9,93,184,0,35,16,184,0,
52,220,0,184,0,0,69,88,184,0,0,47,27,185,0,0,
0,5,62,89,187,0,30,0,2,0,14,0,4,43,184,0,
30,16,184,0,0,16,185,0,42,0,2,252,48,49,41,1,
39,62,5,53,52,46,2,35,34,14,2,21,14,3,7,39,
52,62,2,51,50,30,2,21,20,14,4,7,33,50,62,3,
53,23,3,53,253,74,29,119,177,126,82,48,18,22,48,77,
54,41,68,50,27,17,27,29,33,23,27,70,116,147,77,60,
105,77,44,25,55,87,124,162,102,1,162,27,37,22,12,4,
50,74,138,212,163,123,97,79,38,46,79,59,33,38,60,74,
35,9,16,13,9,2,30,52,113,94,61,34,69,107,73,44,
91,105,124,155,192,120,37,51,54,35,1,12,0,1,0,68,
255,226,3,57,4,211,0,71,1,45,187,0,62,0,4,0,
38,0,4,43,184,0,62,16,65,5,0,154,0,38,0,170,
0,38,0,2,93,65,19,0,9,0,38,0,25,0,38,0,
41,0,38,0,57,0,38,0,73,0,38,0,89,0,38,0,
105,0,38,0,121,0,38,0,137,0,38,0,9,93,186,0,
21,0,38,0,62,17,18,57,184,0,21,47,65,5,0,154,
0,21,0,170,0,21,0,2,93,65,19,0,9,0,21,0,
25,0,21,0,41,0,21,0,57,0,21,0,73,0,21,0,
89,0,21,0,105,0,21,0,121,0,21,0,137,0,21,0,
9,93,185,0,0,0,4,252,0,184,0,0,69,88,184,0,
5,47,27,185,0,5,0,5,62,89,187,0,57,0,2,0,
43,0,4,43,184,0,57,16,184,0,5,16,185,0,16,0,
2,252,65,33,0,7,0,16,0,23,0,16,0,39,0,16,
0,55,0,16,0,71,0,16,0,87,0,16,0,103,0,16,
0,119,0,16,0,135,0,16,0,151,0,16,0,167,0,16,
0,183,0,16,0,199,0,16,0,215,0,16,0,231,0,16,
0,247,0,16,0,16,93,65,15,0,7,0,16,0,23,0,
16,0,39,0,16,0,55,0,16,0,71,0,16,0,87,0,
16,0,103,0,16,0,7,113,65,5,0,118,0,16,0,134,
0,16,0,2,113,48,49,1,20,14,2,35,34,46,2,39,
55,30,3,51,50,62,2,53,52,46,2,35,34,35,34,14,
1,7,39,62,3,53,52,46,2,35,34,14,2,23,14,1,
7,39,52,62,2,51,50,30,2,21,20,14,2,7,30,3,
3,57,54,106,156,103,39,82,85,87,45,34,45,75,67,66,
38,61,100,72,40,47,74,91,44,14,7,6,11,15,15,14,
92,110,59,19,21,45,68,48,40,63,42,17,6,34,62,43,
27,62,104,137,76,75,107,69,32,29,55,78,49,57,99,72,
42,1,125,84,150,112,65,14,35,57,43,67,34,44,26,10,
38,72,102,64,75,105,66,29,2,2,3,60,25,66,71,71,
31,34,72,58,37,27,46,61,34,17,19,3,31,42,95,80,
53,48,79,99,51,38,74,68,58,22,7,55,85,109,0,2,
0,55,0,0,3,106,4,221,0,2,0,32,0,94,187,0,
29,0,4,0,0,0,4,43,184,0,29,16,184,0,7,208,
184,0,0,16,184,0,21,208,184,0,29,16,184,0,34,220,
0,184,0,28,47,184,0,0,69,88,184,0,14,47,27,185,
0,14,0,5,62,89,187,0,31,0,2,0,6,0,4,43,
184,0,31,16,186,0,0,0,14,0,28,17,18,57,184,0,
1,208,184,0,6,16,184,0,22,208,48,49,9,1,33,5,
14,1,7,35,21,20,30,2,23,21,33,53,62,3,61,1,
33,39,1,62,1,55,23,17,51,23,2,74,254,139,1,117,
1,32,21,35,23,70,12,32,54,41,254,23,65,82,47,17,
254,14,33,1,240,42,66,29,37,123,26,4,16,253,189,31,
32,31,17,246,8,13,15,16,9,43,43,11,19,17,16,9,
235,33,3,23,18,38,15,35,253,19,31,0,0,1,0,78,
255,226,3,68,4,199,0,60,0,251,187,0,0,0,4,0,
19,0,4,43,65,5,0,154,0,19,0,170,0,19,0,2,
93,65,19,0,9,0,19,0,25,0,19,0,41,0,19,0,
57,0,19,0,73,0,19,0,89,0,19,0,105,0,19,0,
121,0,19,0,137,0,19,0,9,93,0,184,0,41,47,184,
0,0,69,88,184,0,5,47,27,185,0,5,0,5,62,89,
187,0,38,0,2,0,47,0,4,43,184,0,38,16,187,0,
56,0,2,0,24,0,4,43,184,0,56,16,184,0,5,16,
185,0,14,0,2,252,65,33,0,7,0,14,0,23,0,14,
0,39,0,14,0,55,0,14,0,71,0,14,0,87,0,14,
0,103,0,14,0,119,0,14,0,135,0,14,0,151,0,14,
0,167,0,14,0,183,0,14,0,199,0,14,0,215,0,14,
0,231,0,14,0,247,0,14,0,16,93,65,15,0,7,0,
14,0,23,0,14,0,39,0,14,0,55,0,14,0,71,0,
14,0,87,0,14,0,103,0,14,0,7,113,65,5,0,118,
0,14,0,134,0,14,0,2,113,186,0,53,0,24,0,56,
17,18,57,48,49,1,20,14,2,35,34,38,39,55,30,3,
51,50,62,2,53,52,46,2,35,34,14,2,7,39,62,5,
55,33,50,54,49,23,14,3,7,33,14,3,7,62,1,51,
50,30,2,3,68,53,101,148,94,93,182,87,35,53,87,74,
62,29,65,97,64,32,33,67,103,70,21,54,59,59,26,47,
6,16,17,17,14,10,2,1,180,57,64,29,11,29,30,29,
12,254,125,2,10,13,14,4,40,108,51,91,139,94,49,1,
154,87,159,122,72,68,81,67,37,45,24,8,49,83,106,57,
68,112,79,44,10,20,30,20,33,36,95,106,110,105,94,35,
19,29,16,35,32,27,9,29,91,95,84,22,12,14,61,102,
134,0,0,2,0,111,255,226,3,113,4,225,0,17,0,50,
1,77,184,0,51,47,184,0,52,47,184,0,51,16,184,0,
30,208,184,0,30,47,185,0,3,0,4,252,65,19,0,6,
0,3,0,22,0,3,0,38,0,3,0,54,0,3,0,70,
0,3,0,86,0,3,0,102,0,3,0,118,0,3,0,134,
0,3,0,9,93,65,5,0,149,0,3,0,165,0,3,0,
2,93,184,0,52,16,184,0,18,220,185,0,13,0,4,252,
65,5,0,154,0,13,0,170,0,13,0,2,93,65,19,0,
9,0,13,0,25,0,13,0,41,0,13,0,57,0,13,0,
73,0,13,0,89,0,13,0,105,0,13,0,121,0,13,0,
137,0,13,0,9,93,184,0,3,16,184,0,41,208,184,0,
41,47,0,184,0,35,47,184,0,0,69,88,184,0,25,47,
27,185,0,25,0,5,62,89,187,0,46,0,2,0,0,0,
4,43,184,0,46,16,184,0,25,16,185,0,8,0,2,252,
65,33,0,7,0,8,0,23,0,8,0,39,0,8,0,55,
0,8,0,71,0,8,0,87,0,8,0,103,0,8,0,119,
0,8,0,135,0,8,0,151,0,8,0,167,0,8,0,183,
0,8,0,199,0,8,0,215,0,8,0,231,0,8,0,247,
0,8,0,16,93,65,15,0,7,0,8,0,23,0,8,0,
39,0,8,0,55,0,8,0,71,0,8,0,87,0,8,0,
103,0,8,0,7,113,65,5,0,118,0,8,0,134,0,8,
0,2,113,186,0,41,0,25,0,35,17,18,57,48,49,1,
34,6,7,20,30,2,51,50,62,2,53,52,46,2,5,20,
14,4,35,34,46,2,53,52,18,62,1,55,23,14,3,7,
62,3,51,50,30,2,1,244,51,123,56,39,72,102,62,54,
71,43,18,45,68,81,1,88,21,43,63,83,104,61,82,144,
107,62,81,167,255,174,19,118,183,131,81,15,35,73,69,62,
23,81,126,87,46,2,147,56,67,119,173,113,55,50,79,97,
46,94,120,70,27,247,47,102,98,88,67,40,73,132,185,113,
141,1,3,208,143,25,59,27,109,144,171,89,34,46,28,12,
50,93,133,0,0,1,0,104,255,226,3,117,4,180,0,30,
0,34,0,184,0,0,69,88,184,0,10,47,27,185,0,10,
0,5,62,89,187,0,29,0,2,0,16,0,4,43,184,0,
29,16,48,49,1,14,5,7,14,1,7,39,54,26,1,54,
55,33,34,14,2,7,39,62,3,55,33,23,3,117,46,94,
89,82,69,56,17,35,77,50,41,87,138,118,106,55,254,58,
15,28,30,35,21,46,3,10,12,12,6,2,193,33,4,143,
107,221,214,202,178,148,53,25,36,13,33,153,1,22,1,5,
252,128,2,25,60,58,18,23,69,74,68,22,37,0,0,3,
0,94,255,226,3,96,4,211,0,17,0,37,0,77,1,153,
187,0,28,0,4,0,48,0,4,43,184,0,28,16,187,0,
68,0,4,0,8,0,4,43,184,0,68,16,65,19,0,6,
0,28,0,22,0,28,0,38,0,28,0,54,0,28,0,70,
0,28,0,86,0,28,0,102,0,28,0,118,0,28,0,134,
0,28,0,9,93,65,5,0,149,0,28,0,165,0,28,0,
2,93,184,0,28,16,185,0,58,0,3,252,185,0,0,0,
4,252,65,5,0,154,0,8,0,170,0,8,0,2,93,65,
19,0,9,0,8,0,25,0,8,0,41,0,8,0,57,0,
8,0,73,0,8,0,89,0,8,0,105,0,8,0,121,0,
8,0,137,0,8,0,9,93,186,0,18,0,8,0,68,17,
18,57,184,0,18,47,65,5,0,154,0,18,0,170,0,18,
0,2,93,65,19,0,9,0,18,0,25,0,18,0,41,0,
18,0,57,0,18,0,73,0,18,0,89,0,18,0,105,0,
18,0,121,0,18,0,137,0,18,0,9,93,185,0,38,0,
4,252,186,0,53,0,48,0,38,17,18,57,186,0,73,0,
48,0,38,17,18,57,184,0,79,220,0,184,0,0,69,88,
184,0,43,47,27,185,0,43,0,5,62,89,187,0,63,0,
2,0,13,0,4,43,184,0,63,16,184,0,43,16,185,0,
33,0,2,252,65,33,0,7,0,33,0,23,0,33,0,39,
0,33,0,55,0,33,0,71,0,33,0,87,0,33,0,103,
0,33,0,119,0,33,0,135,0,33,0,151,0,33,0,167,
0,33,0,183,0,33,0,199,0,33,0,215,0,33,0,231,
0,33,0,247,0,33,0,16,93,65,15,0,7,0,33,0,
23,0,33,0,39,0,33,0,55,0,33,0,71,0,33,0,
87,0,33,0,103,0,33,0,7,113,65,5,0,118,0,33,
0,134,0,33,0,2,113,48,49,1,20,30,2,23,62,1,
53,52,46,2,35,34,14,2,1,52,46,2,39,14,3,21,
20,30,2,51,50,62,2,55,20,14,2,35,34,46,2,53,
52,62,2,55,46,3,53,52,62,2,51,50,30,2,21,20,
14,2,7,30,3,1,18,43,72,93,50,74,62,31,57,80,
49,45,66,44,22,1,177,47,76,98,52,48,68,43,21,34,
64,91,57,55,79,50,23,157,65,113,150,85,86,132,92,47,
37,69,97,60,43,77,58,34,55,96,131,75,75,117,79,42,
30,54,75,44,49,92,69,42,3,182,44,65,52,43,22,53,
107,54,52,77,50,24,34,55,68,253,93,66,94,68,50,23,
35,67,70,78,45,52,90,66,37,42,68,85,87,78,138,105,
61,52,88,113,62,54,101,91,80,33,20,48,64,83,56,69,
118,85,48,40,70,98,58,42,75,69,64,31,24,59,80,104,
0,2,0,100,255,213,3,102,4,211,0,17,0,48,0,191,
184,0,49,47,184,0,50,47,184,0,18,220,185,0,3,0,
4,252,65,5,0,154,0,3,0,170,0,3,0,2,93,65,
19,0,9,0,3,0,25,0,3,0,41,0,3,0,57,0,
3,0,73,0,3,0,89,0,3,0,105,0,3,0,121,0,
3,0,137,0,3,0,9,93,184,0,49,16,184,0,37,208,
184,0,37,47,185,0,13,0,4,252,65,19,0,6,0,13,
0,22,0,13,0,38,0,13,0,54,0,13,0,70,0,13,
0,86,0,13,0,102,0,13,0,118,0,13,0,134,0,13,
0,9,93,65,5,0,149,0,13,0,165,0,13,0,2,93,
184,0,3,16,184,0,29,208,184,0,29,47,0,184,0,23,
47,187,0,44,0,2,0,8,0,4,43,184,0,44,16,187,
0,0,0,2,0,32,0,4,43,184,0,0,16,48,49,1,
50,54,55,46,3,35,34,14,2,21,20,30,2,37,20,2,
6,4,7,39,62,3,55,14,1,35,34,46,2,53,52,62,
4,51,50,30,2,1,225,69,117,42,2,47,70,85,40,51,
81,56,29,45,69,82,1,170,82,168,255,0,174,18,133,192,
128,69,10,54,143,69,80,125,87,46,27,51,73,90,106,59,
70,131,102,61,2,43,76,62,126,168,101,42,41,73,101,59,
92,117,67,25,176,152,254,251,201,135,25,59,33,108,143,175,
101,60,72,54,94,128,75,50,105,98,86,64,37,58,123,190,
255,255,0,131,255,216,1,113,3,193,2,38,0,14,0,0,
0,7,0,14,0,0,2,213,255,255,0,88,254,207,1,135,
3,193,2,38,0,12,0,0,0,7,0,14,0,0,2,213,
0,1,0,61,1,0,3,70,3,131,0,42,0,21,0,184,
0,33,47,184,0,5,47,186,0,40,0,5,0,33,17,18,
57,48,49,1,14,3,7,37,39,52,54,53,55,52,55,54,
55,54,55,62,1,55,54,53,52,55,62,1,55,62,1,55,
48,55,1,23,14,3,7,13,1,23,3,70,11,17,19,22,
15,253,100,25,1,3,2,2,1,1,2,1,1,2,1,1,
2,2,2,2,1,2,2,2,209,25,3,7,8,8,3,253,
213,2,55,17,1,66,10,16,15,16,9,250,24,2,2,2,
9,2,6,8,5,2,6,3,7,3,2,2,2,2,5,9,
4,3,6,3,4,1,14,25,11,26,28,26,9,206,210,36,
0,2,0,61,1,98,3,70,3,0,0,10,0,21,0,31,
0,187,0,20,0,2,0,14,0,4,43,184,0,20,16,187,
0,9,0,2,0,3,0,4,43,184,0,9,16,48,49,1,
14,1,7,33,39,62,1,55,33,23,17,14,1,7,33,39,
62,1,55,33,23,3,70,5,18,6,253,45,25,5,17,9,
2,209,25,5,18,6,253,45,25,5,17,9,2,209,25,2,
231,20,51,17,25,20,49,19,25,254,213,21,50,19,27,20,
48,20,25,0,0,1,0,61,1,0,3,70,3,131,0,31,
0,21,0,184,0,29,47,184,0,17,47,186,0,24,0,17,
0,29,17,18,57,48,49,1,6,7,6,21,20,7,6,7,
6,7,14,1,7,14,1,7,1,39,62,3,55,45,1,39,
62,1,55,5,23,3,64,2,2,1,1,2,2,4,1,1,
2,1,2,2,2,253,47,25,3,8,8,8,4,2,39,253,
203,17,23,43,18,2,158,23,2,89,8,6,2,2,2,2,
6,8,9,7,2,6,2,4,8,3,254,244,25,10,26,28,
25,9,206,210,39,18,32,15,250,24,0,2,0,80,255,216,
3,39,5,200,0,15,0,64,1,13,187,0,44,0,4,0,
55,0,4,43,184,0,44,16,187,0,0,0,4,0,8,0,
4,43,184,0,0,16,187,0,16,0,4,0,36,0,4,43,
184,0,16,16,65,19,0,6,0,0,0,22,0,0,0,38,
0,0,0,54,0,0,0,70,0,0,0,86,0,0,0,102,
0,0,0,118,0,0,0,134,0,0,0,9,93,65,5,0,
149,0,0,0,165,0,0,0,2,93,186,0,29,0,8,0,
0,17,18,57,184,0,29,47,185,0,23,0,3,252,65,5,
0,154,0,36,0,170,0,36,0,2,93,65,19,0,9,0,
36,0,25,0,36,0,41,0,36,0,57,0,36,0,73,0,
36,0,89,0,36,0,105,0,36,0,121,0,36,0,137,0,
36,0,9,93,65,19,0,6,0,44,0,22,0,44,0,38,
0,44,0,54,0,44,0,70,0,44,0,86,0,44,0,102,
0,44,0,118,0,44,0,134,0,44,0,9,93,65,5,0,
149,0,44,0,165,0,44,0,2,93,184,0,55,16,184,0,
53,208,184,0,16,16,184,0,66,220,0,186,0,13,0,5,
0,3,43,184,0,13,16,187,0,60,0,2,0,39,0,4,
43,184,0,60,16,48,49,37,20,14,2,35,34,38,53,52,
62,2,51,50,22,1,20,14,4,15,1,14,1,7,47,1,
38,62,4,53,52,38,35,34,14,2,21,20,22,23,14,1,
7,39,38,53,52,53,52,62,2,51,50,30,2,2,27,21,
37,51,29,54,46,22,38,51,28,50,49,1,12,47,72,85,
75,54,5,6,19,29,28,25,8,3,40,64,76,66,44,112,
105,36,65,50,29,7,5,32,70,45,27,2,69,117,152,84,
73,114,78,40,123,35,59,44,25,58,54,34,59,45,26,59,
3,220,75,120,104,95,101,114,71,96,14,19,8,21,116,57,
113,109,107,102,99,48,124,140,33,54,72,39,14,30,14,17,
16,5,30,8,8,9,8,70,120,88,49,46,83,116,0,2,
0,70,254,137,6,47,5,53,0,20,0,117,2,99,187,0,
85,0,4,0,106,0,4,43,184,0,85,16,187,0,10,0,
4,0,43,0,4,43,184,0,10,16,187,0,64,0,4,0,
0,0,4,43,184,0,64,16,187,0,21,0,3,0,73,0,
4,43,184,0,21,16,65,19,0,6,0,10,0,22,0,10,
0,38,0,10,0,54,0,10,0,70,0,10,0,86,0,10,
0,102,0,10,0,118,0,10,0,134,0,10,0,9,93,65,
5,0,149,0,10,0,165,0,10,0,2,93,184,0,0,16,
184,0,33,208,184,0,33,47,65,5,0,154,0,73,0,170,
0,73,0,2,93,65,19,0,9,0,73,0,25,0,73,0,
41,0,73,0,57,0,73,0,73,0,73,0,89,0,73,0,
105,0,73,0,121,0,73,0,137,0,73,0,9,93,65,19,
0,6,0,85,0,22,0,85,0,38,0,85,0,54,0,85,
0,70,0,85,0,86,0,85,0,102,0,85,0,118,0,85,
0,134,0,85,0,9,93,65,5,0,149,0,85,0,165,0,
85,0,2,93,186,0,95,0,106,0,21,17,18,57,184,0,
21,16,184,0,119,220,0,184,0,0,69,88,184,0,50,47,
27,185,0,50,0,9,62,89,184,0,0,69,88,184,0,58,
47,27,185,0,58,0,9,62,89,184,0,0,69,88,184,0,
28,47,27,185,0,28,0,5,62,89,184,0,0,69,88,184,
0,38,47,27,185,0,38,0,5,62,89,187,0,90,0,2,
0,101,0,4,43,184,0,90,16,187,0,113,0,2,0,78,
0,4,43,184,0,113,16,184,0,50,16,185,0,5,0,2,
252,65,5,0,121,0,5,0,137,0,5,0,2,113,65,33,
0,8,0,5,0,24,0,5,0,40,0,5,0,56,0,5,
0,72,0,5,0,88,0,5,0,104,0,5,0,120,0,5,
0,136,0,5,0,152,0,5,0,168,0,5,0,184,0,5,
0,200,0,5,0,216,0,5,0,232,0,5,0,248,0,5,
0,16,93,65,15,0,8,0,5,0,24,0,5,0,40,0,
5,0,56,0,5,0,72,0,5,0,88,0,5,0,104,0,
5,0,7,113,184,0,38,16,185,0,15,0,2,252,65,33,
0,7,0,15,0,23,0,15,0,39,0,15,0,55,0,15,
0,71,0,15,0,87,0,15,0,103,0,15,0,119,0,15,
0,135,0,15,0,151,0,15,0,167,0,15,0,183,0,15,
0,199,0,15,0,215,0,15,0,231,0,15,0,247,0,15,
0,16,93,65,15,0,7,0,15,0,23,0,15,0,39,0,
15,0,55,0,15,0,71,0,15,0,87,0,15,0,103,0,
15,0,7,113,65,5,0,118,0,15,0,134,0,15,0,2,
113,186,0,33,0,28,0,50,17,18,57,184,0,68,208,48,
49,1,46,3,35,34,14,2,21,20,30,2,51,50,62,2,
55,1,20,14,4,35,34,46,2,39,14,3,35,34,46,2,
53,52,62,4,51,50,30,2,23,62,1,55,23,48,14,2,
21,17,20,22,51,50,62,2,53,52,2,46,1,35,34,14,
4,21,20,18,30,1,51,50,62,2,55,23,14,3,35,34,
36,38,2,53,52,62,4,51,50,30,1,18,3,246,14,30,
36,46,30,55,91,66,36,41,63,76,35,19,36,42,54,38,
2,57,40,66,87,94,97,42,24,44,36,26,7,41,63,60,
62,40,51,105,85,54,28,52,75,96,114,65,23,38,37,42,
26,26,54,28,31,10,11,10,61,48,25,66,60,41,86,154,
212,127,102,178,148,116,80,42,112,189,247,136,84,161,138,107,
30,27,36,115,151,186,108,172,254,224,208,116,61,112,156,190,
218,117,149,243,173,94,2,219,28,44,32,17,48,94,141,94,
85,138,97,53,13,33,57,45,1,43,86,154,128,102,71,38,
21,46,73,52,57,74,44,17,65,122,176,111,57,122,114,102,
77,44,7,20,36,29,16,45,31,30,33,57,75,42,254,74,
90,86,63,109,147,84,168,1,6,179,93,52,93,129,153,173,
90,181,254,223,202,108,35,53,60,26,55,38,84,70,46,118,
219,1,55,192,113,217,193,162,117,66,101,198,254,219,0,2,
0,0,0,0,4,174,5,37,0,2,0,28,0,68,0,184,
0,0,69,88,184,0,23,47,27,185,0,23,0,11,62,89,
184,0,0,69,88,184,0,3,47,27,185,0,3,0,5,62,
89,184,0,0,69,88,184,0,14,47,27,185,0,14,0,5,
62,89,187,0,1,0,2,0,8,0,4,43,184,0,1,16,
48,49,1,33,3,19,53,62,1,39,3,33,3,6,22,23,
21,33,53,62,1,55,1,62,1,55,1,30,1,23,21,1,
155,1,91,176,194,78,62,13,114,254,104,111,9,73,82,254,
96,68,79,11,1,116,23,68,26,1,164,9,57,65,2,23,
2,2,251,231,43,5,31,32,1,77,254,179,31,28,9,43,
43,12,27,29,4,102,25,41,14,251,74,28,33,7,43,0,
0,3,0,41,255,242,3,248,5,10,0,14,0,35,0,75,
2,4,187,0,19,0,4,0,53,0,4,43,184,0,19,16,
187,0,68,0,4,0,10,0,4,43,184,0,68,16,184,0,
19,16,184,0,3,208,65,5,0,154,0,10,0,170,0,10,
0,2,93,65,19,0,9,0,10,0,25,0,10,0,41,0,
10,0,57,0,10,0,73,0,10,0,89,0,10,0,105,0,
10,0,121,0,10,0,137,0,10,0,9,93,186,0,31,0,
10,0,68,17,18,57,184,0,31,47,65,5,0,154,0,31,
0,170,0,31,0,2,93,65,19,0,9,0,31,0,25,0,
31,0,41,0,31,0,57,0,31,0,73,0,31,0,89,0,
31,0,105,0,31,0,121,0,31,0,137,0,31,0,9,93,
185,0,36,0,4,252,186,0,71,0,53,0,36,17,18,57,
184,0,77,220,0,184,0,0,69,88,184,0,63,47,27,185,
0,63,0,11,62,89,184,0,0,69,88,184,0,41,47,27,
185,0,41,0,5,62,89,184,0,0,69,88,184,0,48,47,
27,185,0,48,0,5,62,89,187,0,5,0,2,0,15,0,
4,43,184,0,5,16,184,0,63,16,185,0,0,0,2,252,
65,5,0,121,0,0,0,137,0,0,0,2,113,65,33,0,
8,0,0,0,24,0,0,0,40,0,0,0,56,0,0,0,
72,0,0,0,88,0,0,0,104,0,0,0,120,0,0,0,
136,0,0,0,152,0,0,0,168,0,0,0,184,0,0,0,
200,0,0,0,216,0,0,0,232,0,0,0,248,0,0,0,
16,93,65,15,0,8,0,0,0,24,0,0,0,40,0,0,
0,56,0,0,0,72,0,0,0,88,0,0,0,104,0,0,
0,7,113,184,0,3,208,184,0,3,47,184,0,41,16,185,
0,26,0,2,252,65,33,0,7,0,26,0,23,0,26,0,
39,0,26,0,55,0,26,0,71,0,26,0,87,0,26,0,
103,0,26,0,119,0,26,0,135,0,26,0,151,0,26,0,
167,0,26,0,183,0,26,0,199,0,26,0,215,0,26,0,
231,0,26,0,247,0,26,0,16,93,65,15,0,7,0,26,
0,23,0,26,0,39,0,26,0,55,0,26,0,71,0,26,
0,87,0,26,0,103,0,26,0,7,113,65,5,0,118,0,
26,0,134,0,26,0,2,113,184,0,5,16,184,0,71,208,
184,0,71,47,48,49,1,34,6,7,17,51,50,62,2,53,
52,46,2,19,34,6,7,17,20,23,30,3,51,50,62,2,
53,52,46,2,1,20,14,2,35,34,46,4,49,35,53,62,
1,53,17,14,1,7,39,62,3,51,50,30,2,21,20,6,
7,30,3,1,157,14,29,15,34,114,141,78,27,32,78,129,
10,48,81,36,9,17,44,46,46,20,72,116,83,44,39,81,
125,1,153,67,121,168,101,29,88,96,97,78,48,73,68,77,
38,73,34,9,39,103,114,118,54,100,162,113,61,102,88,64,
110,81,46,4,182,1,1,254,33,45,70,88,43,50,86,63,
36,253,211,8,6,253,237,8,7,6,7,4,2,37,66,93,
56,55,116,95,61,254,219,85,137,96,52,2,3,4,3,2,
43,14,33,14,4,62,5,11,6,62,11,21,17,11,37,70,
100,63,108,155,34,12,66,97,123,0,0,1,0,70,255,226,
3,250,5,10,0,46,1,99,187,0,34,0,4,0,10,0,
4,43,184,0,34,16,65,19,0,6,0,34,0,22,0,34,
0,38,0,34,0,54,0,34,0,70,0,34,0,86,0,34,
0,102,0,34,0,118,0,34,0,134,0,34,0,9,93,65,
5,0,149,0,34,0,165,0,34,0,2,93,0,184,0,0,
69,88,184,0,15,47,27,185,0,15,0,11,62,89,184,0,
0,69,88,184,0,5,47,27,185,0,5,0,5,62,89,184,
0,15,16,185,0,27,0,2,252,65,5,0,121,0,27,0,
137,0,27,0,2,113,65,33,0,8,0,27,0,24,0,27,
0,40,0,27,0,56,0,27,0,72,0,27,0,88,0,27,
0,104,0,27,0,120,0,27,0,136,0,27,0,152,0,27,
0,168,0,27,0,184,0,27,0,200,0,27,0,216,0,27,
0,232,0,27,0,248,0,27,0,16,93,65,15,0,8,0,
27,0,24,0,27,0,40,0,27,0,56,0,27,0,72,0,
27,0,88,0,27,0,104,0,27,0,7,113,184,0,5,16,
185,0,39,0,2,252,65,33,0,7,0,39,0,23,0,39,
0,39,0,39,0,55,0,39,0,71,0,39,0,87,0,39,
0,103,0,39,0,119,0,39,0,135,0,39,0,151,0,39,
0,167,0,39,0,183,0,39,0,199,0,39,0,215,0,39,
0,231,0,39,0,247,0,39,0,16,93,65,15,0,7,0,
39,0,23,0,39,0,39,0,39,0,55,0,39,0,71,0,
39,0,87,0,39,0,103,0,39,0,7,113,65,5,0,118,
0,39,0,134,0,39,0,2,113,48,49,37,14,3,35,34,
46,2,53,52,18,62,1,51,50,22,23,22,14,2,7,39,
46,1,35,34,14,4,21,20,30,2,51,50,54,55,30,3,
3,250,64,117,109,105,52,93,179,142,87,97,166,220,123,108,
163,52,6,18,31,35,12,35,51,140,91,34,81,82,76,59,
35,77,121,149,71,54,174,110,5,11,10,8,211,68,93,56,
24,84,158,229,145,160,1,4,184,100,58,42,5,30,38,38,
12,6,47,60,25,54,87,124,163,104,133,200,133,67,74,92,
2,13,14,13,0,2,0,41,0,0,4,100,5,10,0,17,
0,44,1,141,184,0,45,47,184,0,46,47,184,0,45,16,
184,0,30,208,184,0,30,47,185,0,3,0,4,252,184,0,
5,208,184,0,5,47,184,0,46,16,184,0,18,220,185,0,
13,0,4,252,65,5,0,154,0,13,0,170,0,13,0,2,
93,65,19,0,9,0,13,0,25,0,13,0,41,0,13,0,
57,0,13,0,73,0,13,0,89,0,13,0,105,0,13,0,
121,0,13,0,137,0,13,0,9,93,0,184,0,0,69,88,
184,0,40,47,27,185,0,40,0,11,62,89,184,0,0,69,
88,184,0,25,47,27,185,0,25,0,5,62,89,184,0,40,
16,185,0,0,0,2,252,65,5,0,121,0,0,0,137,0,
0,0,2,113,65,33,0,8,0,0,0,24,0,0,0,40,
0,0,0,56,0,0,0,72,0,0,0,88,0,0,0,104,
0,0,0,120,0,0,0,136,0,0,0,152,0,0,0,168,
0,0,0,184,0,0,0,200,0,0,0,216,0,0,0,232,
0,0,0,248,0,0,0,16,93,65,15,0,8,0,0,0,
24,0,0,0,40,0,0,0,56,0,0,0,72,0,0,0,
88,0,0,0,104,0,0,0,7,113,184,0,2,208,184,0,
2,47,184,0,25,16,185,0,8,0,2,252,65,33,0,7,
0,8,0,23,0,8,0,39,0,8,0,55,0,8,0,71,
0,8,0,87,0,8,0,103,0,8,0,119,0,8,0,135,
0,8,0,151,0,8,0,167,0,8,0,183,0,8,0,199,
0,8,0,215,0,8,0,231,0,8,0,247,0,8,0,16,
93,65,15,0,7,0,8,0,23,0,8,0,39,0,8,0,
55,0,8,0,71,0,8,0,87,0,8,0,103,0,8,0,
7,113,65,5,0,118,0,8,0,134,0,8,0,2,113,48,
49,1,34,7,17,20,23,30,1,51,50,62,2,53,52,46,
2,1,20,14,4,35,33,53,62,1,53,17,14,1,7,39,
62,3,51,50,30,2,1,197,50,48,10,14,80,78,69,147,
121,78,66,127,186,2,39,51,86,114,125,130,59,254,3,68,
77,40,72,33,9,44,115,128,131,59,139,224,158,85,4,182,
3,251,231,22,14,17,17,67,137,208,141,133,211,147,78,253,
238,125,197,151,105,67,31,43,14,33,14,4,60,5,10,5,
62,12,22,17,9,83,158,228,0,1,0,50,0,0,3,186,
4,236,0,54,0,89,187,0,42,0,4,0,8,0,4,43,
184,0,42,16,184,0,27,208,0,184,0,0,69,88,184,0,
13,47,27,185,0,13,0,11,62,89,184,0,0,69,88,184,
0,3,47,27,185,0,3,0,5,62,89,187,0,28,0,2,
0,41,0,4,43,184,0,28,16,184,0,13,16,185,0,26,
0,2,252,184,0,3,16,185,0,47,0,2,252,48,49,37,
14,1,7,33,53,62,1,53,17,52,38,39,53,33,23,14,
3,7,35,46,3,35,33,17,33,23,14,3,7,46,3,43,
1,17,20,30,2,59,1,50,62,2,55,23,3,186,8,25,
8,252,161,68,77,73,72,3,38,33,2,8,12,13,6,45,
2,13,20,29,18,254,146,1,149,26,8,23,25,25,11,15,
35,45,61,42,141,14,44,80,66,129,46,65,50,41,21,43,
244,86,129,29,43,14,33,14,4,27,12,36,14,43,25,26,
62,62,56,19,46,62,37,15,254,77,28,14,31,29,25,8,
15,20,14,6,254,11,15,23,17,9,10,35,68,59,18,0,
0,1,0,50,0,0,3,129,4,236,0,42,0,79,187,0,
38,0,4,0,4,0,4,43,184,0,38,16,184,0,23,208,
0,184,0,0,69,88,184,0,9,47,27,185,0,9,0,11,
62,89,184,0,0,69,88,184,0,0,47,27,185,0,0,0,
5,62,89,187,0,24,0,2,0,37,0,4,43,184,0,24,
16,184,0,9,16,185,0,22,0,2,252,48,49,51,53,62,
1,53,17,52,38,39,53,33,23,14,3,7,35,46,3,35,
33,17,33,23,14,3,7,46,3,43,1,17,20,22,23,21,
50,68,77,73,72,3,48,31,1,8,11,13,6,47,2,11,
21,29,19,254,138,1,118,29,9,24,26,25,10,15,34,45,
61,42,112,77,98,43,14,33,14,4,27,12,36,14,43,25,
26,62,62,56,19,46,62,37,15,254,77,28,14,31,29,25,
8,15,20,14,6,253,217,12,30,19,43,0,0,1,0,70,
255,226,4,121,5,10,0,63,1,153,184,0,64,47,184,0,
65,47,184,0,44,220,184,0,0,208,184,0,0,47,184,0,
64,16,184,0,54,208,184,0,54,47,185,0,18,0,4,252,
65,19,0,6,0,18,0,22,0,18,0,38,0,18,0,54,
0,18,0,70,0,18,0,86,0,18,0,102,0,18,0,118,
0,18,0,134,0,18,0,9,93,65,5,0,149,0,18,0,
165,0,18,0,2,93,184,0,44,16,185,0,26,0,4,252,
184,0,44,16,184,0,38,208,184,0,44,16,184,0,42,208,
184,0,42,47,0,184,0,0,69,88,184,0,59,47,27,185,
0,59,0,11,62,89,184,0,0,69,88,184,0,49,47,27,
185,0,49,0,5,62,89,184,0,59,16,185,0,11,0,2,
252,65,5,0,121,0,11,0,137,0,11,0,2,113,65,33,
0,8,0,11,0,24,0,11,0,40,0,11,0,56,0,11,
0,72,0,11,0,88,0,11,0,104,0,11,0,120,0,11,
0,136,0,11,0,152,0,11,0,168,0,11,0,184,0,11,
0,200,0,11,0,216,0,11,0,232,0,11,0,248,0,11,
0,16,93,65,15,0,8,0,11,0,24,0,11,0,40,0,
11,0,56,0,11,0,72,0,11,0,88,0,11,0,104,0,
11,0,7,113,184,0,49,16,185,0,23,0,2,252,65,33,
0,7,0,23,0,23,0,23,0,39,0,23,0,55,0,23,
0,71,0,23,0,87,0,23,0,103,0,23,0,119,0,23,
0,135,0,23,0,151,0,23,0,167,0,23,0,183,0,23,
0,199,0,23,0,215,0,23,0,231,0,23,0,247,0,23,
0,16,93,65,15,0,7,0,23,0,23,0,23,0,39,0,
23,0,55,0,23,0,71,0,23,0,87,0,23,0,103,0,
23,0,7,113,65,5,0,118,0,23,0,134,0,23,0,2,
113,48,49,1,22,14,2,7,39,46,3,35,34,14,4,21,
20,30,2,51,50,54,55,17,52,46,2,39,53,33,21,14,
1,21,17,48,6,7,22,23,14,3,35,34,46,2,53,52,
18,62,1,51,50,30,2,4,18,7,18,33,39,13,33,33,
70,77,86,49,25,75,83,84,66,42,75,120,151,76,73,123,
49,19,47,79,61,1,205,57,48,2,2,2,2,74,117,98,
88,45,101,196,155,96,105,182,243,137,33,79,82,79,4,164,
5,29,36,35,12,6,31,41,22,9,23,51,83,121,161,104,
139,206,135,67,29,27,1,83,11,21,20,20,10,43,43,14,
45,23,254,187,2,1,1,2,61,72,39,12,75,153,229,155,
166,1,7,183,96,14,26,38,0,1,0,50,0,0,4,246,
4,236,0,43,0,133,184,0,44,47,184,0,45,47,184,0,
44,16,184,0,4,208,184,0,4,47,185,0,39,0,4,252,
184,0,14,208,184,0,45,16,184,0,26,220,185,0,17,0,
4,252,184,0,36,208,0,184,0,0,69,88,184,0,9,47,
27,185,0,9,0,11,62,89,184,0,0,69,88,184,0,21,
47,27,185,0,21,0,11,62,89,184,0,0,69,88,184,0,
0,47,27,185,0,0,0,5,62,89,184,0,0,69,88,184,
0,31,47,27,185,0,31,0,5,62,89,187,0,16,0,2,
0,37,0,4,43,184,0,16,16,48,49,51,53,62,1,53,
17,52,38,39,53,33,21,14,1,21,17,33,17,52,38,39,
53,33,21,14,1,21,17,20,22,23,21,33,53,62,1,53,
17,33,17,20,22,23,21,50,68,77,73,72,1,194,68,77,
2,98,73,72,1,194,68,77,73,72,254,62,68,77,253,158,
72,73,43,14,33,14,4,27,12,36,14,43,43,14,34,14,
254,62,1,194,12,36,14,43,43,14,34,14,251,229,12,35,
14,43,43,14,33,14,1,255,254,1,12,35,14,43,0,1,
0,70,0,0,2,8,4,236,0,19,0,51,187,0,15,0,
4,0,4,0,4,43,184,0,15,16,0,184,0,0,69,88,
184,0,9,47,27,185,0,9,0,11,62,89,184,0,0,69,
88,184,0,0,47,27,185,0,0,0,5,62,89,48,49,51,
53,62,1,53,17,52,38,39,53,33,21,14,1,21,17,20,
22,23,21,70,68,77,73,72,1,194,68,77,73,72,43,14,
33,14,4,27,12,36,14,43,43,14,34,14,251,229,12,35,
14,43,0,1,255,66,254,132,2,43,4,236,0,43,0,48,
187,0,4,0,4,0,34,0,4,43,184,0,4,16,0,184,
0,0,69,88,184,0,41,47,27,185,0,41,0,11,62,89,
187,0,29,0,2,0,14,0,4,43,184,0,29,16,48,49,
1,14,1,21,17,20,14,2,7,14,3,35,34,46,2,53,
52,62,2,55,30,3,51,50,62,2,53,17,52,46,2,39,
53,33,21,2,43,68,77,33,55,72,39,27,66,65,59,19,
30,60,46,29,26,36,40,14,28,42,36,33,19,26,59,49,
32,16,43,76,60,1,244,4,193,14,34,14,252,74,119,159,
110,73,32,21,34,24,13,19,25,27,9,8,30,30,27,5,
18,23,12,4,34,87,152,117,3,254,6,14,16,17,9,43,
43,0,0,2,0,50,255,242,4,150,4,236,0,29,0,49,
0,85,187,0,45,0,4,0,34,0,4,43,184,0,45,16,
0,184,0,0,69,88,184,0,14,47,27,185,0,14,0,11,
62,89,184,0,0,69,88,184,0,39,47,27,185,0,39,0,
11,62,89,184,0,0,69,88,184,0,3,47,27,185,0,3,
0,5,62,89,184,0,0,69,88,184,0,30,47,27,185,0,
30,0,5,62,89,48,49,37,14,1,35,34,38,39,9,1,
62,1,46,1,39,53,33,21,14,3,7,9,1,30,2,54,
55,23,5,53,62,1,53,17,52,38,39,53,33,21,14,1,
21,17,20,22,23,21,4,150,59,119,48,29,45,20,254,15,
1,151,23,12,20,50,39,1,164,32,50,40,33,15,254,78,
1,223,18,41,47,50,26,7,251,156,68,77,73,72,1,194,
68,77,72,73,37,19,32,18,25,2,102,1,229,27,32,18,
9,3,43,43,4,8,13,20,17,254,28,253,224,20,22,9,
1,3,43,37,43,14,33,14,4,27,12,36,14,43,43,14,
34,14,251,229,12,35,14,43,0,1,0,50,0,0,3,176,
4,236,0,31,0,57,187,0,19,0,4,0,8,0,4,43,
184,0,19,16,0,184,0,0,69,88,184,0,13,47,27,185,
0,13,0,11,62,89,184,0,0,69,88,184,0,3,47,27,
185,0,3,0,5,62,89,185,0,24,0,2,252,48,49,37,
14,1,7,33,53,62,1,53,17,52,38,39,53,33,21,14,
1,21,17,20,30,2,59,1,50,62,2,55,23,3,176,8,
25,8,252,171,68,77,73,72,1,194,68,77,17,42,72,55,
143,46,63,48,39,21,43,244,87,128,29,43,14,33,14,4,
27,12,36,14,43,43,14,34,14,252,33,18,27,19,10,10,
35,68,59,18,0,1,0,60,0,0,6,34,4,236,0,49,
0,132,0,184,0,0,69,88,184,0,34,47,27,185,0,34,
0,11,62,89,184,0,0,69,88,184,0,47,47,27,185,0,
47,0,11,62,89,184,0,0,69,88,184,0,8,47,27,185,
0,8,0,5,62,89,184,0,0,69,88,184,0,17,47,27,
185,0,17,0,5,62,89,184,0,0,69,88,184,0,24,47,
27,185,0,24,0,5,62,89,184,0,47,16,185,0,0,0,
1,252,186,0,16,0,8,0,34,17,18,57,186,0,19,0,
8,0,34,17,18,57,184,0,33,208,186,0,41,0,8,0,
34,17,18,57,48,49,1,34,6,7,19,20,22,23,21,33,
53,62,1,53,3,6,7,1,35,1,3,20,22,23,21,33,
53,62,1,53,19,46,1,35,53,33,50,30,2,23,9,1,
62,3,51,33,21,6,14,29,70,36,10,73,72,254,59,68,
87,9,1,2,254,75,49,254,64,9,73,72,254,110,69,76,
10,38,77,30,1,30,10,13,13,16,12,1,142,1,126,13,
16,13,13,9,1,30,4,193,18,17,251,202,12,35,14,43,
43,14,33,14,3,175,3,4,251,240,4,15,252,89,12,35,
14,43,43,14,33,14,4,49,23,17,43,6,18,33,27,252,
122,3,134,30,33,17,4,43,0,1,0,50,255,226,5,0,
4,236,0,36,0,143,184,0,37,47,184,0,38,47,184,0,
37,16,184,0,4,208,184,0,4,47,184,0,38,16,184,0,
27,220,185,0,16,0,3,252,184,0,30,208,184,0,30,47,
184,0,4,16,185,0,32,0,3,252,0,184,0,0,69,88,
184,0,9,47,27,185,0,9,0,11,62,89,184,0,0,69,
88,184,0,21,47,27,185,0,21,0,11,62,89,184,0,0,
69,88,184,0,27,47,27,185,0,27,0,5,62,89,184,0,
0,69,88,184,0,0,47,27,185,0,0,0,5,62,89,186,
0,16,0,27,0,9,17,18,57,186,0,31,0,27,0,9,
17,18,57,48,49,51,53,62,1,53,17,46,1,39,53,51,
50,30,2,23,1,17,52,38,39,53,33,21,14,1,21,17,
46,1,39,1,17,20,22,23,21,50,74,71,34,72,39,212,
15,19,19,24,19,2,145,65,80,1,154,72,73,50,57,12,
253,67,67,78,43,9,38,14,4,21,31,30,7,43,5,16,
31,26,252,118,3,111,12,39,11,43,43,10,38,14,251,95,
6,28,17,3,204,252,135,12,38,11,43,0,0,2,0,70,
255,226,4,114,5,10,0,21,0,41,1,175,184,0,42,47,
184,0,43,47,184,0,22,220,185,0,0,0,4,252,65,5,
0,154,0,0,0,170,0,0,0,2,93,65,19,0,9,0,
0,0,25,0,0,0,41,0,0,0,57,0,0,0,73,0,
0,0,89,0,0,0,105,0,0,0,121,0,0,0,137,0,
0,0,9,93,184,0,42,16,184,0,32,208,184,0,32,47,
185,0,12,0,4,252,65,19,0,6,0,12,0,22,0,12,
0,38,0,12,0,54,0,12,0,70,0,12,0,86,0,12,
0,102,0,12,0,118,0,12,0,134,0,12,0,9,93,65,
5,0,149,0,12,0,165,0,12,0,2,93,0,184,0,0,
69,88,184,0,37,47,27,185,0,37,0,11,62,89,184,0,
0,69,88,184,0,27,47,27,185,0,27,0,5,62,89,184,
0,37,16,185,0,7,0,2,252,65,5,0,121,0,7,0,
137,0,7,0,2,113,65,33,0,8,0,7,0,24,0,7,
0,40,0,7,0,56,0,7,0,72,0,7,0,88,0,7,
0,104,0,7,0,120,0,7,0,136,0,7,0,152,0,7,
0,168,0,7,0,184,0,7,0,200,0,7,0,216,0,7,
0,232,0,7,0,248,0,7,0,16,93,65,15,0,8,0,
7,0,24,0,7,0,40,0,7,0,56,0,7,0,72,0,
7,0,88,0,7,0,104,0,7,0,7,113,184,0,27,16,
185,0,17,0,2,252,65,33,0,7,0,17,0,23,0,17,
0,39,0,17,0,55,0,17,0,71,0,17,0,87,0,17,
0,103,0,17,0,119,0,17,0,135,0,17,0,151,0,17,
0,167,0,17,0,183,0,17,0,199,0,17,0,215,0,17,
0,231,0,17,0,247,0,17,0,16,93,65,15,0,7,0,
17,0,23,0,17,0,39,0,17,0,55,0,17,0,71,0,
17,0,87,0,17,0,103,0,17,0,7,113,65,5,0,118,
0,17,0,134,0,17,0,2,113,48,49,1,52,46,4,35,
34,14,2,21,20,30,2,51,50,62,2,55,20,14,2,35,
34,46,2,53,52,62,2,51,50,30,2,3,215,25,46,67,
84,100,57,89,141,97,52,61,103,138,77,83,139,101,56,155,
90,155,204,114,120,188,129,68,88,152,205,118,124,188,128,65,
2,117,69,135,121,104,75,43,76,139,198,122,112,200,151,88,
69,136,202,150,136,245,186,110,106,178,232,126,136,246,186,110,
109,180,232,0,0,1,0,41,0,0,3,214,5,10,0,52,
1,46,184,0,53,47,184,0,54,47,184,0,53,16,184,0,
4,208,184,0,4,47,184,0,54,16,184,0,19,220,186,0,
29,0,4,0,19,17,18,57,185,0,37,0,4,252,65,5,
0,154,0,37,0,170,0,37,0,2,93,65,19,0,9,0,
37,0,25,0,37,0,41,0,37,0,57,0,37,0,73,0,
37,0,89,0,37,0,105,0,37,0,121,0,37,0,137,0,
37,0,9,93,184,0,4,16,185,0,46,0,4,252,0,184,
0,0,69,88,184,0,14,47,27,185,0,14,0,11,62,89,
184,0,0,69,88,184,0,0,47,27,185,0,0,0,5,62,
89,187,0,32,0,2,0,26,0,4,43,184,0,32,16,186,
0,29,0,0,0,14,17,18,57,184,0,14,16,185,0,42,
0,2,252,65,5,0,121,0,42,0,137,0,42,0,2,113,
65,33,0,8,0,42,0,24,0,42,0,40,0,42,0,56,
0,42,0,72,0,42,0,88,0,42,0,104,0,42,0,120,
0,42,0,136,0,42,0,152,0,42,0,168,0,42,0,184,
0,42,0,200,0,42,0,216,0,42,0,232,0,42,0,248,
0,42,0,16,93,65,15,0,8,0,42,0,24,0,42,0,
40,0,42,0,56,0,42,0,72,0,42,0,88,0,42,0,
104,0,42,0,7,113,184,0,45,208,184,0,45,47,48,49,
51,53,62,1,53,17,14,1,7,39,62,3,51,50,30,2,
21,20,14,4,35,34,47,1,30,1,51,50,62,2,53,52,
46,2,35,34,6,7,17,20,30,2,23,21,50,68,77,37,
73,35,9,48,113,122,125,61,108,174,123,67,39,65,84,91,
91,39,94,67,23,42,77,35,46,100,84,54,59,102,136,77,
25,49,24,16,39,68,52,43,14,33,14,4,62,5,11,6,
62,13,22,16,9,46,90,132,86,69,114,89,65,43,21,30,
76,19,11,36,71,106,71,82,118,75,36,1,1,251,180,6,
14,16,16,9,43,0,0,2,0,70,254,207,5,2,5,10,
0,21,0,65,1,226,184,0,66,47,184,0,67,47,184,0,
49,220,185,0,0,0,4,252,65,5,0,154,0,0,0,170,
0,0,0,2,93,65,19,0,9,0,0,0,25,0,0,0,
41,0,0,0,57,0,0,0,73,0,0,0,89,0,0,0,
105,0,0,0,121,0,0,0,137,0,0,0,9,93,184,0,
66,16,184,0,39,208,184,0,39,47,185,0,12,0,4,252,
65,19,0,6,0,12,0,22,0,12,0,38,0,12,0,54,
0,12,0,70,0,12,0,86,0,12,0,102,0,12,0,118,
0,12,0,134,0,12,0,9,93,65,5,0,149,0,12,0,
165,0,12,0,2,93,186,0,54,0,39,0,49,17,18,57,
0,184,0,0,69,88,184,0,44,47,27,185,0,44,0,11,
62,89,184,0,0,69,88,184,0,32,47,27,185,0,32,0,
5,62,89,184,0,0,69,88,184,0,34,47,27,185,0,34,
0,5,62,89,187,0,59,0,2,0,27,0,4,43,184,0,
59,16,184,0,44,16,185,0,7,0,2,252,65,5,0,121,
0,7,0,137,0,7,0,2,113,65,33,0,8,0,7,0,
24,0,7,0,40,0,7,0,56,0,7,0,72,0,7,0,
88,0,7,0,104,0,7,0,120,0,7,0,136,0,7,0,
152,0,7,0,168,0,7,0,184,0,7,0,200,0,7,0,
216,0,7,0,232,0,7,0,248,0,7,0,16,93,65,15,
0,8,0,7,0,24,0,7,0,40,0,7,0,56,0,7,
0,72,0,7,0,88,0,7,0,104,0,7,0,7,113,184,
0,32,16,185,0,17,0,2,252,65,33,0,7,0,17,0,
23,0,17,0,39,0,17,0,55,0,17,0,71,0,17,0,
87,0,17,0,103,0,17,0,119,0,17,0,135,0,17,0,
151,0,17,0,167,0,17,0,183,0,17,0,199,0,17,0,
215,0,17,0,231,0,17,0,247,0,17,0,16,93,65,15,
0,7,0,17,0,23,0,17,0,39,0,17,0,55,0,17,
0,71,0,17,0,87,0,17,0,103,0,17,0,7,113,65,
5,0,118,0,17,0,134,0,17,0,2,113,186,0,54,0,
32,0,17,17,18,57,48,49,1,52,46,4,35,34,14,2,
21,20,30,2,51,50,62,2,1,14,3,35,34,46,2,39,
6,35,34,46,2,53,52,62,2,51,50,30,2,21,20,14,
2,7,30,3,51,50,62,2,55,23,3,215,25,46,67,84,
100,57,89,141,97,52,61,103,138,77,83,139,101,56,1,43,
24,50,48,43,15,62,121,120,119,60,23,22,110,186,134,75,
88,152,205,118,124,188,128,65,56,100,137,80,46,91,87,82,
37,12,27,34,44,30,27,2,117,69,135,121,104,75,43,76,
139,198,122,112,200,151,88,69,136,202,253,154,44,69,49,26,
61,87,95,35,3,102,174,234,132,136,246,186,110,109,180,232,
122,106,198,167,128,36,24,60,52,36,8,18,30,22,35,0,
0,2,0,41,255,242,4,115,5,10,0,13,0,61,1,75,
184,0,62,47,184,0,63,47,184,0,62,16,184,0,18,208,
184,0,18,47,185,0,57,0,4,252,184,0,2,208,184,0,
63,16,184,0,33,220,185,0,9,0,4,252,65,5,0,154,
0,9,0,170,0,9,0,2,93,65,19,0,9,0,9,0,
25,0,9,0,41,0,9,0,57,0,9,0,73,0,9,0,
89,0,9,0,105,0,9,0,121,0,9,0,137,0,9,0,
9,93,184,0,33,16,184,0,39,208,184,0,39,47,186,0,
38,0,18,0,39,17,18,57,0,184,0,0,69,88,184,0,
28,47,27,185,0,28,0,11,62,89,184,0,0,69,88,184,
0,48,47,27,185,0,48,0,5,62,89,184,0,0,69,88,
184,0,14,47,27,185,0,14,0,5,62,89,187,0,6,0,
2,0,53,0,4,43,184,0,6,16,184,0,28,16,185,0,
0,0,2,252,65,5,0,121,0,0,0,137,0,0,0,2,
113,65,33,0,8,0,0,0,24,0,0,0,40,0,0,0,
56,0,0,0,72,0,0,0,88,0,0,0,104,0,0,0,
120,0,0,0,136,0,0,0,152,0,0,0,168,0,0,0,
184,0,0,0,200,0,0,0,216,0,0,0,232,0,0,0,
248,0,0,0,16,93,65,15,0,8,0,0,0,24,0,0,
0,40,0,0,0,56,0,0,0,72,0,0,0,88,0,0,
0,104,0,0,0,7,113,184,0,2,208,184,0,2,47,186,
0,38,0,53,0,6,17,18,57,48,49,1,34,7,17,30,
1,51,50,54,53,52,46,2,1,53,62,1,53,17,14,1,
7,39,62,3,51,50,30,2,21,20,14,2,7,1,30,3,
55,23,14,1,35,34,38,39,1,35,34,38,39,17,20,22,
23,21,1,176,38,39,27,40,22,166,182,43,88,136,254,37,
68,77,35,73,37,9,47,96,104,115,66,120,179,119,59,49,
88,120,72,1,75,15,35,43,53,34,11,66,119,39,29,55,
14,254,172,16,26,52,28,72,73,4,182,3,254,0,5,2,
139,133,55,92,66,37,251,74,43,14,33,14,4,61,5,11,
5,62,12,21,17,10,46,82,111,64,77,123,94,63,16,254,
37,21,26,13,2,3,43,22,29,33,22,2,45,5,6,254,
7,12,35,14,43,0,0,1,0,117,255,226,3,117,5,10,
0,74,1,219,184,0,75,47,184,0,76,47,184,0,0,220,
184,0,75,16,184,0,38,208,184,0,38,47,184,0,12,208,
184,0,12,47,184,0,38,16,184,0,15,208,184,0,15,47,
184,0,38,16,184,0,18,208,184,0,18,47,184,0,0,16,
185,0,29,0,4,252,65,5,0,154,0,29,0,170,0,29,
0,2,93,65,19,0,9,0,29,0,25,0,29,0,41,0,
29,0,57,0,29,0,73,0,29,0,89,0,29,0,105,0,
29,0,121,0,29,0,137,0,29,0,9,93,184,0,55,208,
184,0,55,47,184,0,38,16,185,0,66,0,4,252,65,19,
0,6,0,66,0,22,0,66,0,38,0,66,0,54,0,66,
0,70,0,66,0,86,0,66,0,102,0,66,0,118,0,66,
0,134,0,66,0,9,93,65,5,0,149,0,66,0,165,0,
66,0,2,93,0,184,0,0,69,88,184,0,45,47,27,185,
0,45,0,11,62,89,184,0,0,69,88,184,0,7,47,27,
185,0,7,0,5,62,89,185,0,24,0,2,252,65,33,0,
7,0,24,0,23,0,24,0,39,0,24,0,55,0,24,0,
71,0,24,0,87,0,24,0,103,0,24,0,119,0,24,0,
135,0,24,0,151,0,24,0,167,0,24,0,183,0,24,0,
199,0,24,0,215,0,24,0,231,0,24,0,247,0,24,0,
16,93,65,15,0,7,0,24,0,23,0,24,0,39,0,24,
0,55,0,24,0,71,0,24,0,87,0,24,0,103,0,24,
0,7,113,65,5,0,118,0,24,0,134,0,24,0,2,113,
184,0,45,16,185,0,61,0,2,252,65,5,0,121,0,61,
0,137,0,61,0,2,113,65,33,0,8,0,61,0,24,0,
61,0,40,0,61,0,56,0,61,0,72,0,61,0,88,0,
61,0,104,0,61,0,120,0,61,0,136,0,61,0,152,0,
61,0,168,0,61,0,184,0,61,0,200,0,61,0,216,0,
61,0,232,0,61,0,248,0,61,0,16,93,65,15,0,8,
0,61,0,24,0,61,0,40,0,61,0,56,0,61,0,72,
0,61,0,88,0,61,0,104,0,61,0,7,113,48,49,1,
20,14,4,35,34,46,2,39,46,1,53,52,54,55,23,30,
3,51,50,62,2,53,52,46,6,53,52,62,4,51,50,30,
2,23,22,14,2,7,39,46,3,35,34,14,2,21,20,30,
6,3,117,24,49,73,99,125,75,33,78,82,81,35,7,7,
6,8,41,23,69,84,97,51,45,91,74,46,54,88,112,117,
112,88,54,18,40,63,89,116,73,45,91,79,64,18,7,13,
27,33,12,36,28,61,63,62,28,56,80,52,25,54,89,113,
119,113,89,54,1,121,45,94,91,81,60,36,14,25,36,23,
4,60,40,41,84,27,5,59,86,57,27,37,64,85,48,61,
88,68,54,54,60,80,105,73,31,72,72,67,51,30,14,24,
34,20,6,35,41,40,11,6,33,44,27,11,32,51,61,28,
47,73,61,54,59,68,88,113,0,1,0,10,0,0,4,59,
4,236,0,34,0,69,187,0,30,0,4,0,6,0,4,43,
184,0,30,16,0,184,0,0,69,88,184,0,17,47,27,185,
0,17,0,11,62,89,184,0,0,69,88,184,0,0,47,27,
185,0,0,0,5,62,89,184,0,17,16,185,0,7,0,2,
252,184,0,28,208,184,0,29,208,48,49,33,53,62,3,53,
17,33,34,14,2,7,39,62,1,55,33,23,14,1,7,35,
46,3,35,33,17,20,22,23,21,1,51,46,63,38,17,254,
213,15,25,25,32,22,43,5,17,11,3,242,30,2,16,12,
45,9,15,19,28,22,254,228,72,92,43,9,20,19,17,7,
4,31,11,36,70,58,19,59,134,53,25,51,121,63,42,64,
43,21,251,225,13,40,19,43,0,1,0,50,255,226,4,251,
4,236,0,42,0,215,184,0,43,47,184,0,44,47,184,0,
4,220,184,0,43,16,184,0,14,208,184,0,14,47,185,0,
25,0,4,252,184,0,4,16,185,0,35,0,4,252,0,184,
0,0,69,88,184,0,19,47,27,185,0,19,0,11,62,89,
184,0,0,69,88,184,0,40,47,27,185,0,40,0,11,62,
89,184,0,0,69,88,184,0,9,47,27,185,0,9,0,5,
62,89,185,0,30,0,2,252,65,33,0,7,0,30,0,23,
0,30,0,39,0,30,0,55,0,30,0,71,0,30,0,87,
0,30,0,103,0,30,0,119,0,30,0,135,0,30,0,151,
0,30,0,167,0,30,0,183,0,30,0,199,0,30,0,215,
0,30,0,231,0,30,0,247,0,30,0,16,93,65,15,0,
7,0,30,0,23,0,30,0,39,0,30,0,55,0,30,0,
71,0,30,0,87,0,30,0,103,0,30,0,7,113,65,5,
0,118,0,30,0,134,0,30,0,2,113,48,49,1,14,1,
21,17,20,14,2,35,34,46,2,53,17,52,38,39,53,33,
21,14,1,21,17,20,30,2,51,50,62,2,53,17,52,38,
39,53,33,21,4,251,68,77,64,120,172,108,103,173,125,70,
73,72,1,194,68,77,45,89,130,86,71,110,75,39,73,72,
1,164,4,193,14,34,14,253,137,131,206,142,75,57,117,178,
122,2,199,12,36,14,43,43,14,34,14,253,107,96,152,106,
56,69,112,144,74,2,160,12,36,14,43,43,0,1,0,20,
255,226,5,10,4,236,0,26,0,64,0,184,0,0,69,88,
184,0,13,47,27,185,0,13,0,11,62,89,184,0,0,69,
88,184,0,24,47,27,185,0,24,0,11,62,89,184,0,0,
69,88,184,0,9,47,27,185,0,9,0,5,62,89,186,0,
19,0,9,0,13,17,18,57,48,49,1,14,1,7,1,14,
3,7,1,38,39,53,33,21,14,1,23,9,1,54,38,39,
53,33,21,5,10,68,78,9,254,129,8,39,46,44,13,254,
72,17,125,1,179,78,62,13,1,96,1,80,11,71,82,1,
160,4,193,13,25,28,251,188,22,31,21,12,3,4,157,50,
16,43,43,5,30,31,252,76,3,180,29,27,10,43,43,0,
0,1,0,20,255,226,6,166,4,236,0,43,0,136,0,184,
0,0,69,88,184,0,23,47,27,185,0,23,0,11,62,89,
184,0,0,69,88,184,0,32,47,27,185,0,32,0,11,62,
89,184,0,0,69,88,184,0,41,47,27,185,0,41,0,11,
62,89,184,0,0,69,88,184,0,11,47,27,185,0,11,0,
5,62,89,184,0,0,69,88,184,0,18,47,27,185,0,18,
0,5,62,89,186,0,12,0,11,0,23,17,18,57,184,0,
23,16,185,0,22,0,1,252,184,0,25,208,186,0,31,0,
11,0,23,17,18,57,186,0,34,0,11,0,23,17,18,57,
184,0,40,208,48,49,1,14,3,7,3,14,3,7,9,1,
14,3,7,1,46,1,39,53,33,21,14,3,23,19,1,51,
1,19,54,46,2,39,53,33,21,6,166,31,52,40,26,3,
229,5,35,43,43,13,254,186,254,225,7,39,46,46,13,254,
252,6,61,71,1,173,49,56,28,5,2,199,1,68,55,1,
98,187,2,22,42,58,34,1,168,4,193,7,12,14,17,12,
251,184,22,31,21,12,3,3,206,252,139,23,31,21,11,3,
4,153,25,32,13,43,43,5,15,18,21,11,252,127,3,242,
252,14,3,137,12,18,14,12,6,43,43,0,0,1,0,31,
0,0,4,205,4,236,0,53,0,139,0,184,0,0,69,88,
184,0,25,47,27,185,0,25,0,11,62,89,184,0,0,69,
88,184,0,38,47,27,185,0,38,0,11,62,89,184,0,0,
69,88,184,0,0,47,27,185,0,0,0,5,62,89,184,0,
0,69,88,184,0,12,47,27,185,0,12,0,5,62,89,184,
0,0,16,185,0,1,0,1,252,186,0,7,0,0,0,25,
17,18,57,184,0,11,208,184,0,14,208,184,0,25,16,185,
0,24,0,1,252,184,0,27,208,186,0,31,0,0,0,25,
17,18,57,184,0,37,208,184,0,40,208,184,0,14,16,184,
0,52,208,48,49,33,53,62,2,38,39,1,3,6,22,23,
21,33,53,62,1,55,9,1,46,3,39,53,33,21,14,1,
23,27,1,54,46,2,39,53,33,21,14,3,7,9,1,30,
3,23,21,3,10,44,54,24,3,14,254,233,252,28,65,92,
254,62,65,92,25,1,61,254,179,15,28,35,45,33,1,195,
85,51,29,247,226,14,4,34,62,45,1,197,36,57,44,33,
13,254,221,1,109,15,31,37,46,29,43,4,13,19,28,20,
1,152,254,104,44,34,6,43,43,5,37,42,2,5,1,233,
22,28,18,11,5,43,43,8,32,44,254,149,1,107,23,29,
19,10,3,43,43,4,11,19,29,21,254,41,253,233,21,29,
19,11,4,43,0,1,0,0,0,0,4,152,4,246,0,44,
0,88,187,0,38,0,4,0,4,0,4,43,184,0,38,16,
186,0,26,0,4,0,38,17,18,57,0,184,0,0,69,88,
184,0,19,47,27,185,0,19,0,11,62,89,184,0,0,69,
88,184,0,31,47,27,185,0,31,0,11,62,89,184,0,0,
69,88,184,0,0,47,27,185,0,0,0,5,62,89,186,0,
26,0,0,0,19,17,18,57,48,49,33,53,62,1,53,17,
46,3,39,46,3,35,39,62,1,51,50,23,30,3,23,1,
54,38,39,53,33,21,14,1,7,1,17,20,30,2,23,21,
1,104,91,73,37,94,98,92,35,9,23,36,54,42,4,59,
118,42,46,32,37,86,86,82,35,1,12,15,49,77,1,140,
69,73,14,254,176,17,39,63,47,43,19,39,14,1,166,81,
176,166,143,48,11,20,15,9,43,8,13,39,48,131,146,154,
72,1,215,26,30,10,43,43,13,27,26,253,158,254,86,6,
17,20,20,9,43,0,0,1,0,59,0,0,3,223,4,252,
0,32,0,95,0,184,0,0,69,88,184,0,16,47,27,185,
0,16,0,11,62,89,184,0,0,69,88,184,0,20,47,27,
185,0,20,0,11,62,89,184,0,0,69,88,184,0,22,47,
27,185,0,22,0,11,62,89,184,0,0,69,88,184,0,5,
47,27,185,0,5,0,5,62,89,184,0,22,16,185,0,8,
0,2,252,184,0,9,208,184,0,5,16,185,0,25,0,2,
252,48,49,1,14,3,7,33,39,1,33,34,14,2,7,39,
19,30,2,51,50,51,33,23,1,33,50,62,2,55,23,3,
223,2,3,3,3,1,252,133,29,2,199,254,53,16,38,36,
32,11,57,29,27,45,43,23,23,29,2,104,25,253,63,2,
11,21,34,31,32,19,55,1,37,32,78,79,75,29,45,4,
91,22,48,75,52,12,1,45,6,7,3,43,251,163,19,46,
80,62,14,0,0,1,0,139,254,177,2,78,6,64,0,14,
0,45,187,0,12,0,4,0,4,0,4,43,184,0,12,16,
0,187,0,13,0,2,0,3,0,4,43,184,0,13,16,187,
0,6,0,2,0,10,0,4,43,184,0,6,16,48,49,5,
14,1,7,33,17,33,23,14,1,7,33,17,33,23,2,78,
5,16,8,254,90,1,160,33,5,16,6,254,232,1,18,35,
249,20,49,17,7,143,26,25,49,12,249,84,29,0,0,1,
0,55,254,177,3,137,6,64,0,10,0,11,0,184,0,7,
47,184,0,0,47,48,49,1,46,3,39,1,55,22,23,1,
3,102,12,32,32,29,9,253,67,37,58,55,2,188,254,177,
4,12,13,15,7,7,70,22,15,34,248,187,0,1,0,41,
254,177,1,233,6,64,0,13,0,49,187,0,13,0,4,0,
5,0,4,43,184,0,13,16,184,0,15,220,0,187,0,4,
0,2,0,0,0,4,43,184,0,4,16,187,0,12,0,2,
0,6,0,4,43,184,0,12,16,48,49,19,39,62,1,55,
33,17,33,39,62,1,55,33,17,76,33,3,15,7,1,26,
254,238,35,3,17,7,1,165,254,177,29,23,50,13,6,172,
26,22,47,17,248,113,0,1,0,100,2,53,3,139,6,14,
0,19,0,25,0,184,0,18,47,184,0,3,47,184,0,11,
47,186,0,5,0,3,0,18,17,18,57,48,49,1,14,1,
7,39,1,3,14,3,7,39,1,62,3,55,1,3,139,25,
47,34,37,254,229,250,11,28,30,29,10,23,1,66,12,35,
36,36,14,1,96,2,123,23,31,16,27,2,211,253,88,10,
21,19,15,5,27,3,102,12,25,24,20,7,252,109,0,1,
0,61,255,10,3,129,255,125,0,10,0,17,0,187,0,9,
0,2,0,3,0,4,43,184,0,9,16,48,49,5,14,1,
7,33,39,62,1,55,33,23,3,129,5,16,8,252,242,25,
5,17,9,3,14,23,156,21,50,19,27,20,48,20,25,0,
0,1,0,30,4,23,1,182,5,209,0,11,0,7,0,184,
0,3,47,48,49,1,14,1,7,1,55,62,3,55,19,1,
182,9,30,17,254,160,22,10,39,43,42,12,240,4,54,8,
18,5,1,121,41,2,7,8,6,1,254,101,0,2,0,80,
255,226,3,158,3,192,0,14,0,70,1,164,184,0,71,47,
184,0,72,47,184,0,63,220,185,0,21,0,4,252,184,0,
3,208,184,0,71,16,184,0,31,208,184,0,31,47,185,0,
10,0,4,252,65,19,0,6,0,10,0,22,0,10,0,38,
0,10,0,54,0,10,0,70,0,10,0,86,0,10,0,102,
0,10,0,118,0,10,0,134,0,10,0,9,93,65,5,0,
149,0,10,0,165,0,10,0,2,93,184,0,21,16,184,0,
37,208,0,184,0,0,69,88,184,0,59,47,27,185,0,59,
0,9,62,89,184,0,0,69,88,184,0,18,47,27,185,0,
18,0,5,62,89,184,0,0,69,88,184,0,26,47,27,185,
0,26,0,5,62,89,185,0,0,0,2,252,65,33,0,7,
0,0,0,23,0,0,0,39,0,0,0,55,0,0,0,71,
0,0,0,87,0,0,0,103,0,0,0,119,0,0,0,135,
0,0,0,151,0,0,0,167,0,0,0,183,0,0,0,199,
0,0,0,215,0,0,0,231,0,0,0,247,0,0,0,16,
93,65,15,0,7,0,0,0,23,0,0,0,39,0,0,0,
55,0,0,0,71,0,0,0,87,0,0,0,103,0,0,0,
7,113,65,5,0,118,0,0,0,134,0,0,0,2,113,186,
0,21,0,18,0,59,17,18,57,184,0,59,16,185,0,43,
0,2,252,65,5,0,121,0,43,0,137,0,43,0,2,113,
65,33,0,8,0,43,0,24,0,43,0,40,0,43,0,56,
0,43,0,72,0,43,0,88,0,43,0,104,0,43,0,120,
0,43,0,136,0,43,0,152,0,43,0,168,0,43,0,184,
0,43,0,200,0,43,0,216,0,43,0,232,0,43,0,248,
0,43,0,16,93,65,15,0,8,0,43,0,24,0,43,0,
40,0,43,0,56,0,43,0,72,0,43,0,88,0,43,0,
104,0,43,0,7,113,184,0,0,16,184,0,66,208,48,49,
37,50,54,55,17,7,14,3,21,20,30,2,5,14,1,35,
34,38,39,14,3,35,34,46,2,53,52,62,2,63,1,53,
52,46,2,7,14,3,23,22,14,2,47,1,62,3,51,50,
22,21,17,20,22,51,50,54,55,23,1,96,60,135,76,119,
68,99,64,30,24,35,37,2,75,85,111,28,33,44,2,45,
90,86,77,32,36,76,61,40,43,85,126,84,205,16,38,65,
49,32,62,46,26,3,1,43,59,57,12,14,23,94,121,135,
63,110,119,22,18,14,44,40,15,100,61,66,1,5,23,12,
46,62,75,41,40,50,29,10,18,59,53,92,81,45,66,42,
20,24,52,82,58,59,107,88,65,17,41,139,34,59,43,23,
1,1,20,36,49,30,9,23,18,10,3,39,50,92,70,42,
115,103,253,204,42,36,10,17,45,0,0,2,0,10,255,226,
3,181,6,14,0,20,0,57,1,149,184,0,58,47,184,0,
59,47,184,0,21,220,185,0,0,0,4,252,65,5,0,154,
0,0,0,170,0,0,0,2,93,65,19,0,9,0,0,0,
25,0,0,0,41,0,0,0,57,0,0,0,73,0,0,0,
89,0,0,0,105,0,0,0,121,0,0,0,137,0,0,0,
9,93,184,0,58,16,184,0,33,208,184,0,33,47,185,0,
11,0,4,252,184,0,47,208,186,0,48,0,33,0,21,17,
18,57,0,184,0,43,47,184,0,0,69,88,184,0,53,47,
27,185,0,53,0,9,62,89,184,0,0,69,88,184,0,28,
47,27,185,0,28,0,5,62,89,184,0,53,16,185,0,5,
0,2,252,65,5,0,121,0,5,0,137,0,5,0,2,113,
65,33,0,8,0,5,0,24,0,5,0,40,0,5,0,56,
0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,120,
0,5,0,136,0,5,0,152,0,5,0,168,0,5,0,184,
0,5,0,200,0,5,0,216,0,5,0,232,0,5,0,248,
0,5,0,16,93,65,15,0,8,0,5,0,24,0,5,0,
40,0,5,0,56,0,5,0,72,0,5,0,88,0,5,0,
104,0,5,0,7,113,184,0,28,16,185,0,16,0,2,252,
65,33,0,7,0,16,0,23,0,16,0,39,0,16,0,55,
0,16,0,71,0,16,0,87,0,16,0,103,0,16,0,119,
0,16,0,135,0,16,0,151,0,16,0,167,0,16,0,183,
0,16,0,199,0,16,0,215,0,16,0,231,0,16,0,247,
0,16,0,16,93,65,15,0,7,0,16,0,23,0,16,0,
39,0,16,0,55,0,16,0,71,0,16,0,87,0,16,0,
103,0,16,0,7,113,65,5,0,118,0,16,0,134,0,16,
0,2,113,186,0,48,0,28,0,43,17,18,57,48,49,1,
52,46,2,35,34,14,2,7,17,30,3,51,50,62,2,55,
20,14,4,35,34,46,2,39,17,52,46,2,39,53,62,1,
55,30,2,23,17,62,3,51,50,30,2,3,48,42,69,90,
48,18,59,74,84,42,40,83,75,61,18,61,93,63,32,133,
30,58,83,107,128,74,19,67,87,102,54,10,28,51,41,66,
120,57,5,18,13,1,50,99,91,78,29,68,115,83,46,1,
152,100,155,106,56,21,49,83,62,254,105,30,40,23,10,53,
87,110,142,58,122,116,104,77,45,17,32,47,30,4,176,46,
50,25,8,5,40,16,33,31,5,17,11,1,252,235,60,88,
57,28,64,121,174,0,0,1,0,80,255,226,3,72,3,192,
0,47,1,99,187,0,36,0,4,0,10,0,4,43,184,0,
36,16,65,19,0,6,0,36,0,22,0,36,0,38,0,36,
0,54,0,36,0,70,0,36,0,86,0,36,0,102,0,36,
0,118,0,36,0,134,0,36,0,9,93,65,5,0,149,0,
36,0,165,0,36,0,2,93,0,184,0,0,69,88,184,0,
15,47,27,185,0,15,0,9,62,89,184,0,0,69,88,184,
0,5,47,27,185,0,5,0,5,62,89,184,0,15,16,185,
0,31,0,2,252,65,5,0,121,0,31,0,137,0,31,0,
2,113,65,33,0,8,0,31,0,24,0,31,0,40,0,31,
0,56,0,31,0,72,0,31,0,88,0,31,0,104,0,31,
0,120,0,31,0,136,0,31,0,152,0,31,0,168,0,31,
0,184,0,31,0,200,0,31,0,216,0,31,0,232,0,31,
0,248,0,31,0,16,93,65,15,0,8,0,31,0,24,0,
31,0,40,0,31,0,56,0,31,0,72,0,31,0,88,0,
31,0,104,0,31,0,7,113,184,0,5,16,185,0,41,0,
2,252,65,33,0,7,0,41,0,23,0,41,0,39,0,41,
0,55,0,41,0,71,0,41,0,87,0,41,0,103,0,41,
0,119,0,41,0,135,0,41,0,151,0,41,0,167,0,41,
0,183,0,41,0,199,0,41,0,215,0,41,0,231,0,41,
0,247,0,41,0,16,93,65,15,0,7,0,41,0,23,0,
41,0,39,0,41,0,55,0,41,0,71,0,41,0,87,0,
41,0,103,0,41,0,7,113,65,5,0,118,0,41,0,134,
0,41,0,2,113,48,49,37,14,3,35,34,46,2,53,52,
62,2,51,50,30,2,23,22,14,2,7,39,46,3,35,34,
14,2,21,20,30,2,51,50,62,2,55,23,3,72,65,99,
84,80,47,73,139,108,65,79,137,186,108,33,69,63,53,17,
2,10,18,22,9,37,8,36,57,79,51,53,97,75,45,51,
85,111,60,28,48,57,75,56,39,190,77,87,45,11,65,122,
176,111,108,188,139,81,11,21,29,18,12,44,49,45,14,10,
18,42,38,25,47,94,140,94,85,138,97,53,5,24,52,48,
41,0,0,2,0,80,255,226,4,27,6,14,0,19,0,69,
1,186,184,0,70,47,184,0,71,47,184,0,60,220,185,0,
19,0,4,252,184,0,1,208,184,0,70,16,184,0,38,208,
184,0,38,47,185,0,9,0,4,252,65,19,0,6,0,9,
0,22,0,9,0,38,0,9,0,54,0,9,0,70,0,9,
0,86,0,9,0,102,0,9,0,118,0,9,0,134,0,9,
0,9,93,65,5,0,149,0,9,0,165,0,9,0,2,93,
184,0,19,16,184,0,28,208,184,0,28,47,184,0,19,16,
184,0,48,208,0,184,0,58,47,184,0,0,69,88,184,0,
45,47,27,185,0,45,0,9,62,89,184,0,0,69,88,184,
0,25,47,27,185,0,25,0,5,62,89,184,0,0,69,88,
184,0,33,47,27,185,0,33,0,5,62,89,184,0,45,16,
185,0,4,0,2,252,65,5,0,121,0,4,0,137,0,4,
0,2,113,65,33,0,8,0,4,0,24,0,4,0,40,0,
4,0,56,0,4,0,72,0,4,0,88,0,4,0,104,0,
4,0,120,0,4,0,136,0,4,0,152,0,4,0,168,0,
4,0,184,0,4,0,200,0,4,0,216,0,4,0,232,0,
4,0,248,0,4,0,16,93,65,15,0,8,0,4,0,24,
0,4,0,40,0,4,0,56,0,4,0,72,0,4,0,88,
0,4,0,104,0,4,0,7,113,184,0,33,16,185,0,14,
0,2,252,65,33,0,7,0,14,0,23,0,14,0,39,0,
14,0,55,0,14,0,71,0,14,0,87,0,14,0,103,0,
14,0,119,0,14,0,135,0,14,0,151,0,14,0,167,0,
14,0,183,0,14,0,199,0,14,0,215,0,14,0,231,0,
14,0,247,0,14,0,16,93,65,15,0,7,0,14,0,23,
0,14,0,39,0,14,0,55,0,14,0,71,0,14,0,87,
0,14,0,103,0,14,0,7,113,65,5,0,118,0,14,0,
134,0,14,0,2,113,186,0,28,0,25,0,58,17,18,57,
186,0,48,0,45,0,4,17,18,57,48,49,1,17,46,1,
35,34,14,2,21,20,30,2,51,50,62,2,55,5,14,3,
35,34,38,39,14,3,35,34,46,2,53,52,62,4,51,50,
22,23,17,52,46,2,39,53,62,1,55,23,17,20,30,2,
23,22,54,55,23,2,233,33,120,72,64,106,77,43,49,76,
91,41,34,66,65,62,31,1,50,46,71,53,38,14,33,42,
7,38,75,79,88,51,56,118,99,63,31,58,84,104,124,70,
47,93,54,6,28,58,53,82,130,52,31,3,6,8,6,9,
51,60,13,1,16,1,202,57,63,47,94,140,94,85,138,97,
53,27,45,57,30,177,31,43,27,13,90,109,46,74,51,28,
65,122,176,111,57,122,114,102,77,44,23,40,1,121,55,65,
35,13,4,39,11,37,17,30,251,14,35,50,34,22,7,11,
9,23,43,0,0,2,0,80,255,226,3,98,3,192,0,15,
0,60,1,121,187,0,21,0,4,0,44,0,4,43,184,0,
21,16,65,19,0,6,0,21,0,22,0,21,0,38,0,21,
0,54,0,21,0,70,0,21,0,86,0,21,0,102,0,21,
0,118,0,21,0,134,0,21,0,9,93,65,5,0,149,0,
21,0,165,0,21,0,2,93,184,0,5,208,184,0,5,47,
0,184,0,0,69,88,184,0,54,47,27,185,0,54,0,9,
62,89,184,0,0,69,88,184,0,39,47,27,185,0,39,0,
5,62,89,187,0,6,0,2,0,19,0,4,43,184,0,6,
16,184,0,54,16,185,0,0,0,2,252,65,5,0,121,0,
0,0,137,0,0,0,2,113,65,33,0,8,0,0,0,24,
0,0,0,40,0,0,0,56,0,0,0,72,0,0,0,88,
0,0,0,104,0,0,0,120,0,0,0,136,0,0,0,152,
0,0,0,168,0,0,0,184,0,0,0,200,0,0,0,216,
0,0,0,232,0,0,0,248,0,0,0,16,93,65,15,0,
8,0,0,0,24,0,0,0,40,0,0,0,56,0,0,0,
72,0,0,0,88,0,0,0,104,0,0,0,7,113,184,0,
39,16,185,0,26,0,2,252,65,33,0,7,0,26,0,23,
0,26,0,39,0,26,0,55,0,26,0,71,0,26,0,87,
0,26,0,103,0,26,0,119,0,26,0,135,0,26,0,151,
0,26,0,167,0,26,0,183,0,26,0,199,0,26,0,215,
0,26,0,231,0,26,0,247,0,26,0,16,93,65,15,0,
7,0,26,0,23,0,26,0,39,0,26,0,55,0,26,0,
71,0,26,0,87,0,26,0,103,0,26,0,7,113,65,5,
0,118,0,26,0,134,0,26,0,2,113,48,49,1,34,14,
2,7,33,50,54,53,52,46,4,1,14,1,7,33,21,20,
30,2,51,50,62,2,55,30,1,23,14,3,35,34,46,2,
53,52,62,2,55,62,3,51,50,30,4,1,240,51,86,67,
45,10,1,171,23,15,6,17,29,46,65,1,71,18,60,32,
253,242,41,76,110,69,31,59,68,83,56,13,19,5,67,101,
89,87,51,77,139,106,63,30,57,82,52,22,55,60,59,27,
66,101,76,52,33,14,3,88,40,72,102,62,15,21,18,50,
53,52,41,26,254,213,20,34,13,3,75,139,107,64,7,27,
54,46,7,26,8,73,89,48,15,66,121,171,106,67,130,116,
98,36,15,29,22,13,36,61,81,90,93,0,0,1,0,45,
0,0,3,49,6,14,0,58,0,102,187,0,27,0,4,0,
38,0,4,43,184,0,27,16,184,0,15,208,184,0,38,16,
184,0,43,208,0,184,0,54,47,184,0,0,69,88,184,0,
16,47,27,185,0,16,0,9,62,89,184,0,0,69,88,184,
0,42,47,27,185,0,42,0,9,62,89,184,0,0,69,88,
184,0,33,47,27,185,0,33,0,5,62,89,184,0,16,16,
185,0,26,0,2,252,184,0,39,208,184,0,40,208,48,49,
1,20,14,2,7,46,3,35,34,14,2,29,1,33,23,14,
3,7,46,1,35,17,20,30,2,23,21,33,53,62,1,53,
17,35,39,55,51,53,52,62,2,55,62,3,51,50,30,2,
3,49,29,40,43,15,24,49,45,39,13,26,59,51,34,1,
2,29,9,27,27,26,9,23,86,80,21,50,79,59,254,13,
69,71,134,21,78,77,32,55,72,40,27,64,63,57,19,31,
66,55,36,5,174,8,32,34,30,7,21,31,21,11,36,92,
159,124,86,29,14,31,29,22,4,12,23,253,34,6,12,13,
17,11,43,43,12,35,12,2,222,28,66,31,118,161,111,75,
32,22,34,24,12,24,31,32,0,3,0,30,254,12,3,221,
3,192,0,19,0,42,0,116,2,64,187,0,28,0,4,0,
76,0,4,43,184,0,28,16,187,0,43,0,4,0,0,0,
4,43,184,0,43,16,65,5,0,154,0,0,0,170,0,0,
0,2,93,65,19,0,9,0,0,0,25,0,0,0,41,0,
0,0,57,0,0,0,73,0,0,0,89,0,0,0,105,0,
0,0,121,0,0,0,137,0,0,0,9,93,65,19,0,6,
0,28,0,22,0,28,0,38,0,28,0,54,0,28,0,70,
0,28,0,86,0,28,0,102,0,28,0,118,0,28,0,134,
0,28,0,9,93,65,5,0,149,0,28,0,165,0,28,0,
2,93,186,0,94,0,76,0,28,17,18,57,184,0,94,47,
185,0,10,0,4,252,184,0,43,16,184,0,38,208,184,0,
38,47,184,0,43,16,185,0,62,0,4,252,186,0,81,0,
76,0,62,17,18,57,184,0,28,16,184,0,84,208,184,0,
84,47,186,0,89,0,76,0,62,17,18,57,186,0,114,0,
0,0,43,17,18,57,184,0,43,16,184,0,118,220,0,184,
0,0,69,88,184,0,99,47,27,185,0,99,0,9,62,89,
184,0,0,69,88,184,0,107,47,27,185,0,107,0,9,62,
89,184,0,0,69,88,184,0,69,47,27,185,0,69,0,7,
62,89,187,0,15,0,2,0,48,0,4,43,184,0,15,16,
184,0,99,16,185,0,5,0,2,252,65,5,0,121,0,5,
0,137,0,5,0,2,113,65,33,0,8,0,5,0,24,0,
5,0,40,0,5,0,56,0,5,0,72,0,5,0,88,0,
5,0,104,0,5,0,120,0,5,0,136,0,5,0,152,0,
5,0,168,0,5,0,184,0,5,0,200,0,5,0,216,0,
5,0,232,0,5,0,248,0,5,0,16,93,65,15,0,8,
0,5,0,24,0,5,0,40,0,5,0,56,0,5,0,72,
0,5,0,88,0,5,0,104,0,5,0,7,113,184,0,69,
16,185,0,33,0,2,252,65,33,0,7,0,33,0,23,0,
33,0,39,0,33,0,55,0,33,0,71,0,33,0,87,0,
33,0,103,0,33,0,119,0,33,0,135,0,33,0,151,0,
33,0,167,0,33,0,183,0,33,0,199,0,33,0,215,0,
33,0,231,0,33,0,247,0,33,0,16,93,65,15,0,7,
0,33,0,23,0,33,0,39,0,33,0,55,0,33,0,71,
0,33,0,87,0,33,0,103,0,33,0,7,113,65,5,0,
118,0,33,0,134,0,33,0,2,113,186,0,81,0,69,0,
99,17,18,57,186,0,89,0,48,0,15,17,18,57,186,0,
114,0,69,0,99,17,18,57,48,49,1,52,46,2,35,34,
14,2,21,20,30,2,51,50,62,2,3,46,1,39,14,3,
21,20,30,2,51,50,62,2,53,52,46,2,19,20,14,2,
43,1,14,1,21,20,30,2,23,30,3,21,20,14,4,35,
34,46,4,53,52,62,2,55,46,1,53,52,62,2,55,46,
3,53,52,62,2,51,50,22,23,62,3,55,23,14,1,7,
14,1,7,30,1,2,178,35,69,103,67,25,61,54,36,33,
67,103,71,29,63,51,33,172,38,64,28,72,83,42,11,56,
94,124,68,67,110,78,43,26,68,117,221,69,112,142,73,5,
47,36,21,57,100,78,109,142,84,33,42,72,98,112,120,59,
47,100,98,87,66,39,19,58,104,86,65,50,10,31,56,46,
51,83,59,32,66,108,138,73,60,105,43,52,84,67,52,21,
20,12,22,23,38,73,46,26,29,2,88,53,94,70,41,25,
50,75,49,53,95,71,41,26,50,75,253,214,4,10,6,39,
62,49,40,16,42,75,56,33,36,64,87,52,28,47,38,30,
2,143,77,127,92,51,39,53,6,12,23,21,21,9,12,48,
63,72,35,55,99,84,68,48,26,13,28,43,61,77,49,26,
57,66,76,46,23,58,30,8,27,38,50,32,14,53,76,95,
56,73,131,97,57,34,31,5,16,18,18,8,30,28,47,25,
7,8,2,38,86,0,0,1,0,55,0,0,4,76,6,14,
0,54,0,243,184,0,55,47,184,0,56,47,184,0,50,220,
185,0,4,0,4,252,184,0,55,16,184,0,25,208,184,0,
25,47,185,0,16,0,4,252,184,0,38,208,186,0,39,0,
25,0,50,17,18,57,0,184,0,37,47,184,0,0,69,88,
184,0,44,47,27,185,0,44,0,9,62,89,184,0,0,69,
88,184,0,0,47,27,185,0,0,0,5,62,89,184,0,0,
69,88,184,0,20,47,27,185,0,20,0,5,62,89,184,0,
44,16,185,0,10,0,2,252,65,5,0,121,0,10,0,137,
0,10,0,2,113,65,33,0,8,0,10,0,24,0,10,0,
40,0,10,0,56,0,10,0,72,0,10,0,88,0,10,0,
104,0,10,0,120,0,10,0,136,0,10,0,152,0,10,0,
168,0,10,0,184,0,10,0,200,0,10,0,216,0,10,0,
232,0,10,0,248,0,10,0,16,93,65,15,0,8,0,10,
0,24,0,10,0,40,0,10,0,56,0,10,0,72,0,10,
0,88,0,10,0,104,0,10,0,7,113,186,0,39,0,0,
0,37,17,18,57,48,49,33,53,62,1,53,17,52,46,2,
35,34,14,2,7,17,20,22,23,21,33,53,62,1,53,17,
52,46,2,39,53,62,3,55,23,17,62,3,51,50,30,2,
21,17,20,22,23,21,2,158,72,68,15,32,48,33,35,81,
88,90,43,75,65,254,82,66,74,7,29,56,48,42,69,59,
54,29,37,43,105,106,101,39,43,80,61,37,61,79,43,19,
28,14,2,17,61,76,44,16,36,70,105,70,254,67,15,32,
14,43,43,17,27,17,4,170,42,47,26,11,6,40,8,16,
19,22,15,34,252,192,64,102,72,38,26,54,83,56,253,131,
14,27,20,43,0,2,0,70,0,0,1,244,5,76,0,14,
0,37,0,121,187,0,0,0,4,0,8,0,4,43,65,5,
0,154,0,8,0,170,0,8,0,2,93,65,19,0,9,0,
8,0,25,0,8,0,41,0,8,0,57,0,8,0,73,0,
8,0,89,0,8,0,105,0,8,0,121,0,8,0,137,0,
8,0,9,93,186,0,19,0,8,0,0,17,18,57,184,0,
19,47,185,0,33,0,4,252,0,184,0,0,69,88,184,0,
31,47,27,185,0,31,0,9,62,89,184,0,0,69,88,184,
0,15,47,27,185,0,15,0,5,62,89,48,49,1,20,14,
2,35,34,38,53,52,62,2,51,50,1,53,62,1,53,17,
52,46,2,39,53,62,3,55,51,17,20,22,23,21,1,134,
18,31,42,25,45,39,18,32,41,24,85,254,192,68,72,4,
26,57,53,31,69,68,62,26,34,67,73,4,237,28,50,37,
22,50,46,28,50,37,21,250,180,43,14,33,14,2,54,51,
63,35,16,5,40,6,17,21,24,12,252,168,12,35,14,43,
0,2,255,16,254,12,1,109,5,76,0,14,0,57,0,246,
187,0,0,0,4,0,8,0,4,43,65,5,0,154,0,8,
0,170,0,8,0,2,93,65,19,0,9,0,8,0,25,0,
8,0,41,0,8,0,57,0,8,0,73,0,8,0,89,0,
8,0,105,0,8,0,121,0,8,0,137,0,8,0,9,93,
186,0,43,0,8,0,0,17,18,57,184,0,43,47,185,0,
15,0,4,252,184,0,56,208,0,184,0,0,69,88,184,0,
55,47,27,185,0,55,0,9,62,89,184,0,0,69,88,184,
0,25,47,27,185,0,25,0,7,62,89,185,0,38,0,2,
252,65,33,0,7,0,38,0,23,0,38,0,39,0,38,0,
55,0,38,0,71,0,38,0,87,0,38,0,103,0,38,0,
119,0,38,0,135,0,38,0,151,0,38,0,167,0,38,0,
183,0,38,0,199,0,38,0,215,0,38,0,231,0,38,0,
247,0,38,0,16,93,65,15,0,7,0,38,0,23,0,38,
0,39,0,38,0,55,0,38,0,71,0,38,0,87,0,38,
0,103,0,38,0,7,113,65,5,0,118,0,38,0,134,0,
38,0,2,113,48,49,1,20,14,2,35,34,38,53,52,62,
2,51,50,3,20,14,2,7,14,3,35,34,46,2,53,52,
62,2,55,30,1,51,50,62,2,53,17,52,46,2,39,53,
62,3,55,51,17,1,109,18,31,42,24,45,39,18,31,42,
24,84,30,29,51,70,40,27,60,60,53,19,31,59,47,29,
29,40,43,15,32,68,38,29,57,46,28,5,26,57,52,42,
65,59,55,32,37,4,237,28,50,37,22,50,46,28,50,37,
21,251,23,115,161,113,78,32,21,37,27,15,15,22,24,8,
9,31,34,30,7,28,17,37,92,158,121,2,115,51,62,35,
16,6,40,7,18,19,23,13,252,163,0,1,0,55,255,246,
4,0,6,14,0,53,0,96,187,0,47,0,4,0,4,0,
4,43,184,0,47,16,184,0,15,208,0,184,0,14,47,184,
0,0,69,88,184,0,23,47,27,185,0,23,0,9,62,89,
184,0,0,69,88,184,0,0,47,27,185,0,0,0,5,62,
89,184,0,0,69,88,184,0,41,47,27,185,0,41,0,5,
62,89,186,0,16,0,41,0,14,17,18,57,186,0,46,0,
41,0,14,17,18,57,48,49,51,53,62,1,53,17,52,46,
2,39,53,62,1,55,23,17,1,62,1,46,1,35,53,33,
21,14,1,7,9,1,30,3,55,23,14,3,35,34,38,39,
1,39,17,20,30,2,23,21,55,66,74,11,31,55,43,69,
133,51,37,1,52,33,14,19,45,26,1,123,44,74,42,254,
175,1,116,14,30,36,45,29,6,29,57,49,39,10,42,51,
22,254,135,3,7,22,44,37,43,17,26,18,4,168,46,50,
25,8,5,40,14,37,29,34,252,34,1,17,29,35,18,6,
43,43,5,23,34,254,240,254,70,16,21,12,3,2,43,7,
10,7,4,24,29,1,226,1,254,90,8,12,13,16,12,43,
0,1,0,60,0,0,1,254,6,14,0,22,0,38,187,0,
18,0,4,0,6,0,4,43,184,0,18,16,0,184,0,16,
47,184,0,0,69,88,184,0,0,47,27,185,0,0,0,5,
62,89,48,49,51,53,62,3,53,17,52,46,2,39,53,62,
1,55,23,17,20,22,23,21,60,43,58,34,15,12,32,54,
42,72,120,62,36,68,82,43,7,15,15,16,8,4,168,45,
50,25,9,5,40,14,34,32,34,250,124,15,32,14,43,0,
0,1,0,55,0,0,6,80,3,192,0,84,1,154,184,0,
85,47,184,0,44,208,184,0,44,47,184,0,25,220,65,3,
0,15,0,25,0,1,93,65,3,0,239,0,25,0,1,93,
65,3,0,128,0,25,0,1,93,65,3,0,176,0,25,0,
1,93,184,0,4,220,65,3,0,15,0,4,0,1,93,65,
3,0,239,0,4,0,1,93,65,3,0,176,0,4,0,1,
93,65,3,0,128,0,4,0,1,93,184,0,25,16,185,0,
16,0,4,252,184,0,44,16,185,0,35,0,4,252,184,0,
58,208,184,0,58,47,184,0,16,16,184,0,68,208,186,0,
69,0,25,0,4,17,18,57,184,0,4,16,185,0,80,0,
4,252,184,0,86,220,0,184,0,0,69,88,184,0,56,47,
27,185,0,56,0,9,62,89,184,0,0,69,88,184,0,63,
47,27,185,0,63,0,9,62,89,184,0,0,69,88,184,0,
74,47,27,185,0,74,0,9,62,89,184,0,0,69,88,184,
0,0,47,27,185,0,0,0,5,62,89,184,0,0,69,88,
184,0,20,47,27,185,0,20,0,5,62,89,184,0,0,69,
88,184,0,39,47,27,185,0,39,0,5,62,89,184,0,74,
16,185,0,10,0,2,252,65,5,0,121,0,10,0,137,0,
10,0,2,113,65,33,0,8,0,10,0,24,0,10,0,40,
0,10,0,56,0,10,0,72,0,10,0,88,0,10,0,104,
0,10,0,120,0,10,0,136,0,10,0,152,0,10,0,168,
0,10,0,184,0,10,0,200,0,10,0,216,0,10,0,232,
0,10,0,248,0,10,0,16,93,65,15,0,8,0,10,0,
24,0,10,0,40,0,10,0,56,0,10,0,72,0,10,0,
88,0,10,0,104,0,10,0,7,113,184,0,31,208,184,0,
50,208,186,0,58,0,0,0,56,17,18,57,186,0,69,0,
0,0,56,17,18,57,48,49,33,53,62,1,53,17,52,46,
2,35,34,14,2,7,17,20,22,23,21,33,53,62,1,53,
17,52,46,2,35,34,6,7,17,20,22,23,21,33,53,62,
1,53,17,52,46,2,39,53,62,3,55,31,1,62,3,51,
50,30,2,29,1,62,3,51,50,30,2,21,17,20,22,23,
21,4,162,72,67,13,27,43,30,33,74,78,79,38,62,79,
254,82,72,67,12,27,43,31,68,149,85,75,65,254,82,66,
74,7,29,56,48,38,64,58,53,27,35,11,45,92,90,84,
36,48,81,59,34,42,90,89,85,37,48,81,59,34,62,79,
43,19,28,14,2,17,61,81,46,19,37,69,99,62,254,43,
14,27,20,43,43,19,28,14,2,17,61,81,46,19,140,127,
254,43,15,32,14,43,43,17,27,17,2,95,40,46,25,12,
6,40,6,17,20,24,13,35,229,66,99,66,33,24,56,90,
67,19,63,95,65,33,26,54,83,56,253,131,14,27,20,43,
0,1,0,55,0,0,4,76,3,192,0,52,1,2,184,0,
53,47,184,0,54,47,184,0,48,220,185,0,4,0,4,252,
184,0,53,16,184,0,25,208,184,0,25,47,185,0,16,0,
4,252,184,0,37,208,184,0,37,47,0,184,0,0,69,88,
184,0,35,47,27,185,0,35,0,9,62,89,184,0,0,69,
88,184,0,42,47,27,185,0,42,0,9,62,89,184,0,0,
69,88,184,0,0,47,27,185,0,0,0,5,62,89,184,0,
0,69,88,184,0,20,47,27,185,0,20,0,5,62,89,184,
0,42,16,185,0,10,0,2,252,65,5,0,121,0,10,0,
137,0,10,0,2,113,65,33,0,8,0,10,0,24,0,10,
0,40,0,10,0,56,0,10,0,72,0,10,0,88,0,10,
0,104,0,10,0,120,0,10,0,136,0,10,0,152,0,10,
0,168,0,10,0,184,0,10,0,200,0,10,0,216,0,10,
0,232,0,10,0,248,0,10,0,16,93,65,15,0,8,0,
10,0,24,0,10,0,40,0,10,0,56,0,10,0,72,0,
10,0,88,0,10,0,104,0,10,0,7,113,184,0,31,208,
184,0,31,47,186,0,37,0,0,0,35,17,18,57,48,49,
33,53,62,1,53,17,52,46,2,35,34,14,2,7,17,20,
22,23,21,33,53,62,1,53,17,52,46,2,39,53,62,1,
55,31,1,62,3,51,50,30,2,21,17,20,22,23,21,2,
158,72,68,14,30,49,35,31,76,87,95,48,75,65,254,82,
66,74,6,27,56,51,68,116,56,35,11,44,106,108,101,39,
43,80,61,37,61,79,43,19,28,14,2,17,61,76,44,16,
30,66,107,78,254,67,15,32,14,43,43,17,27,17,2,95,
39,46,26,12,6,40,11,41,28,35,249,67,105,73,39,26,
54,83,56,253,131,14,27,20,43,0,0,2,0,80,255,226,
3,182,3,192,0,19,0,43,1,175,184,0,44,47,184,0,
45,47,184,0,20,220,185,0,0,0,4,252,65,5,0,154,
0,0,0,170,0,0,0,2,93,65,19,0,9,0,0,0,
25,0,0,0,41,0,0,0,57,0,0,0,73,0,0,0,
89,0,0,0,105,0,0,0,121,0,0,0,137,0,0,0,
9,93,184,0,44,16,184,0,32,208,184,0,32,47,185,0,
10,0,4,252,65,19,0,6,0,10,0,22,0,10,0,38,
0,10,0,54,0,10,0,70,0,10,0,86,0,10,0,102,
0,10,0,118,0,10,0,134,0,10,0,9,93,65,5,0,
149,0,10,0,165,0,10,0,2,93,0,184,0,0,69,88,
184,0,39,47,27,185,0,39,0,9,62,89,184,0,0,69,
88,184,0,27,47,27,185,0,27,0,5,62,89,184,0,39,
16,185,0,5,0,2,252,65,5,0,121,0,5,0,137,0,
5,0,2,113,65,33,0,8,0,5,0,24,0,5,0,40,
0,5,0,56,0,5,0,72,0,5,0,88,0,5,0,104,
0,5,0,120,0,5,0,136,0,5,0,152,0,5,0,168,
0,5,0,184,0,5,0,200,0,5,0,216,0,5,0,232,
0,5,0,248,0,5,0,16,93,65,15,0,8,0,5,0,
24,0,5,0,40,0,5,0,56,0,5,0,72,0,5,0,
88,0,5,0,104,0,5,0,7,113,184,0,27,16,185,0,
15,0,2,252,65,33,0,7,0,15,0,23,0,15,0,39,
0,15,0,55,0,15,0,71,0,15,0,87,0,15,0,103,
0,15,0,119,0,15,0,135,0,15,0,151,0,15,0,167,
0,15,0,183,0,15,0,199,0,15,0,215,0,15,0,231,
0,15,0,247,0,15,0,16,93,65,15,0,7,0,15,0,
23,0,15,0,39,0,15,0,55,0,15,0,71,0,15,0,
87,0,15,0,103,0,15,0,7,113,65,5,0,118,0,15,
0,134,0,15,0,2,113,48,49,1,52,46,2,35,34,14,
2,21,20,30,2,51,50,62,2,55,20,14,4,35,34,46,
2,53,52,62,4,51,50,30,2,3,29,52,84,104,51,76,
104,65,28,56,86,103,46,71,103,67,32,153,34,60,84,101,
114,61,95,153,109,59,33,59,83,101,116,63,94,153,109,59,
1,199,79,143,109,64,58,101,138,80,79,143,108,63,53,98,
138,116,66,129,114,97,70,39,72,126,174,102,66,128,115,97,
70,40,72,127,174,0,0,2,0,55,254,32,3,236,3,192,
0,20,0,64,1,199,184,0,65,47,184,0,66,47,184,0,
21,220,185,0,0,0,4,252,65,5,0,154,0,0,0,170,
0,0,0,2,93,65,19,0,9,0,0,0,25,0,0,0,
41,0,0,0,57,0,0,0,73,0,0,0,89,0,0,0,
105,0,0,0,121,0,0,0,137,0,0,0,9,93,184,0,
65,16,184,0,41,208,184,0,41,47,185,0,32,0,4,252,
184,0,10,208,184,0,32,16,184,0,55,208,184,0,55,47,
0,184,0,0,69,88,184,0,53,47,27,185,0,53,0,9,
62,89,184,0,0,69,88,184,0,60,47,27,185,0,60,0,
9,62,89,184,0,0,69,88,184,0,36,47,27,185,0,36,
0,7,62,89,184,0,0,69,88,184,0,28,47,27,185,0,
28,0,5,62,89,184,0,60,16,185,0,5,0,2,252,65,
5,0,121,0,5,0,137,0,5,0,2,113,65,33,0,8,
0,5,0,24,0,5,0,40,0,5,0,56,0,5,0,72,
0,5,0,88,0,5,0,104,0,5,0,120,0,5,0,136,
0,5,0,152,0,5,0,168,0,5,0,184,0,5,0,200,
0,5,0,216,0,5,0,232,0,5,0,248,0,5,0,16,
93,65,15,0,8,0,5,0,24,0,5,0,40,0,5,0,
56,0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,
7,113,184,0,28,16,185,0,16,0,2,252,65,33,0,7,
0,16,0,23,0,16,0,39,0,16,0,55,0,16,0,71,
0,16,0,87,0,16,0,103,0,16,0,119,0,16,0,135,
0,16,0,151,0,16,0,167,0,16,0,183,0,16,0,199,
0,16,0,215,0,16,0,231,0,16,0,247,0,16,0,16,
93,65,15,0,7,0,16,0,23,0,16,0,39,0,16,0,
55,0,16,0,71,0,16,0,87,0,16,0,103,0,16,0,
7,113,65,5,0,118,0,16,0,134,0,16,0,2,113,186,
0,31,0,28,0,16,17,18,57,184,0,5,16,184,0,47,
208,186,0,55,0,36,0,53,17,18,57,48,49,1,52,46,
2,35,34,14,2,7,17,30,3,51,50,62,2,55,20,14,
4,35,34,38,39,17,20,22,23,21,33,53,62,1,53,17,
52,46,2,39,53,62,3,55,31,1,62,3,51,50,30,2,
3,103,41,69,90,48,18,58,74,84,44,45,77,67,60,27,
54,91,67,38,133,29,53,71,85,94,49,59,148,71,75,94,
254,53,66,74,8,29,55,48,34,62,58,57,29,35,9,50,
101,92,79,29,68,115,84,47,1,170,87,150,109,62,22,51,
87,64,254,115,34,44,25,10,42,82,122,146,58,122,116,104,
77,45,66,62,254,39,16,32,14,43,43,16,29,17,4,62,
37,48,29,13,2,40,7,17,19,23,14,35,198,60,88,57,
28,64,121,174,0,2,0,80,254,32,4,10,3,192,0,18,
0,63,1,187,184,0,64,47,184,0,65,47,184,0,58,220,
185,0,6,0,4,252,184,0,64,16,184,0,34,208,184,0,
34,47,185,0,14,0,4,252,65,19,0,6,0,14,0,22,
0,14,0,38,0,14,0,54,0,14,0,70,0,14,0,86,
0,14,0,102,0,14,0,118,0,14,0,134,0,14,0,9,
93,65,5,0,149,0,14,0,165,0,14,0,2,93,184,0,
6,16,184,0,23,208,186,0,24,0,34,0,58,17,18,57,
184,0,58,16,184,0,52,208,0,184,0,0,69,88,184,0,
42,47,27,185,0,42,0,9,62,89,184,0,0,69,88,184,
0,52,47,27,185,0,52,0,9,62,89,184,0,0,69,88,
184,0,19,47,27,185,0,19,0,7,62,89,184,0,0,69,
88,184,0,29,47,27,185,0,29,0,5,62,89,185,0,0,
0,2,252,65,33,0,7,0,0,0,23,0,0,0,39,0,
0,0,55,0,0,0,71,0,0,0,87,0,0,0,103,0,
0,0,119,0,0,0,135,0,0,0,151,0,0,0,167,0,
0,0,183,0,0,0,199,0,0,0,215,0,0,0,231,0,
0,0,247,0,0,0,16,93,65,15,0,7,0,0,0,23,
0,0,0,39,0,0,0,55,0,0,0,71,0,0,0,87,
0,0,0,103,0,0,0,7,113,65,5,0,118,0,0,0,
134,0,0,0,2,113,184,0,42,16,185,0,9,0,2,252,
65,5,0,121,0,9,0,137,0,9,0,2,113,65,33,0,
8,0,9,0,24,0,9,0,40,0,9,0,56,0,9,0,
72,0,9,0,88,0,9,0,104,0,9,0,120,0,9,0,
136,0,9,0,152,0,9,0,168,0,9,0,184,0,9,0,
200,0,9,0,216,0,9,0,232,0,9,0,248,0,9,0,
16,93,65,15,0,8,0,9,0,24,0,9,0,40,0,9,
0,56,0,9,0,72,0,9,0,88,0,9,0,104,0,9,
0,7,113,186,0,24,0,19,0,42,17,18,57,48,49,37,
50,62,2,55,17,46,1,35,34,14,2,21,20,30,2,19,
53,62,1,53,17,14,3,35,34,46,2,53,52,62,2,55,
62,1,51,50,30,2,23,62,3,55,23,48,14,2,21,17,
20,22,23,21,1,231,34,66,65,62,31,33,120,72,56,104,
81,49,49,76,91,129,94,76,38,74,79,87,51,56,118,99,
63,56,81,92,35,57,112,38,27,54,56,60,34,15,32,30,
27,9,31,10,11,10,62,77,102,27,45,57,30,1,213,57,
65,48,94,141,94,85,138,97,53,253,186,43,14,31,17,2,
29,46,72,51,27,65,122,176,111,88,148,115,80,20,31,34,
7,20,36,30,9,25,25,25,9,30,33,57,78,45,251,188,
16,32,14,43,0,1,0,55,0,0,3,11,3,192,0,50,
0,86,187,0,17,0,4,0,26,0,4,43,184,0,17,16,
184,0,43,208,184,0,43,47,0,184,0,0,69,88,184,0,
41,47,27,185,0,41,0,9,62,89,184,0,0,69,88,184,
0,48,47,27,185,0,48,0,9,62,89,184,0,0,69,88,
184,0,21,47,27,185,0,21,0,5,62,89,186,0,43,0,
21,0,41,17,18,57,48,49,1,22,14,2,7,35,46,3,
35,34,14,2,7,17,20,22,23,21,33,53,62,1,53,17,
52,46,2,39,46,3,39,53,62,1,55,31,1,62,3,51,
50,22,3,2,9,1,15,24,12,43,6,22,29,35,19,22,
59,62,61,24,75,94,254,53,66,74,4,6,9,4,7,17,
27,38,28,65,125,50,35,13,27,63,72,79,43,32,74,3,
155,6,58,76,80,27,40,56,33,15,37,79,123,85,254,120,
15,32,14,43,43,15,29,17,2,70,33,45,28,16,5,7,
9,6,3,2,40,17,35,28,35,227,55,96,71,40,16,0,
0,1,0,94,255,226,2,188,3,192,0,69,1,207,184,0,
70,47,184,0,71,47,184,0,0,220,184,0,70,16,184,0,
36,208,184,0,36,47,184,0,10,208,184,0,10,47,184,0,
36,16,184,0,15,208,184,0,15,47,184,0,0,16,185,0,
26,0,4,252,65,5,0,154,0,26,0,170,0,26,0,2,
93,65,19,0,9,0,26,0,25,0,26,0,41,0,26,0,
57,0,26,0,73,0,26,0,89,0,26,0,105,0,26,0,
121,0,26,0,137,0,26,0,9,93,184,0,52,208,184,0,
52,47,184,0,36,16,185,0,60,0,4,252,65,19,0,6,
0,60,0,22,0,60,0,38,0,60,0,54,0,60,0,70,
0,60,0,86,0,60,0,102,0,60,0,118,0,60,0,134,
0,60,0,9,93,65,5,0,149,0,60,0,165,0,60,0,
2,93,0,184,0,0,69,88,184,0,41,47,27,185,0,41,
0,9,62,89,184,0,0,69,88,184,0,7,47,27,185,0,
7,0,5,62,89,185,0,21,0,2,252,65,33,0,7,0,
21,0,23,0,21,0,39,0,21,0,55,0,21,0,71,0,
21,0,87,0,21,0,103,0,21,0,119,0,21,0,135,0,
21,0,151,0,21,0,167,0,21,0,183,0,21,0,199,0,
21,0,215,0,21,0,231,0,21,0,247,0,21,0,16,93,
65,15,0,7,0,21,0,23,0,21,0,39,0,21,0,55,
0,21,0,71,0,21,0,87,0,21,0,103,0,21,0,7,
113,65,5,0,118,0,21,0,134,0,21,0,2,113,184,0,
41,16,185,0,55,0,2,252,65,5,0,121,0,55,0,137,
0,55,0,2,113,65,33,0,8,0,55,0,24,0,55,0,
40,0,55,0,56,0,55,0,72,0,55,0,88,0,55,0,
104,0,55,0,120,0,55,0,136,0,55,0,152,0,55,0,
168,0,55,0,184,0,55,0,200,0,55,0,216,0,55,0,
232,0,55,0,248,0,55,0,16,93,65,15,0,8,0,55,
0,24,0,55,0,40,0,55,0,56,0,55,0,72,0,55,
0,88,0,55,0,104,0,55,0,7,113,48,49,1,20,14,
4,35,34,38,39,46,1,62,1,55,23,30,3,51,50,62,
2,53,52,46,2,39,46,3,53,52,62,2,51,50,30,2,
23,22,14,2,7,39,46,1,35,34,14,2,21,20,30,2,
23,30,3,2,188,40,64,78,76,67,19,48,135,67,7,5,
3,9,7,43,2,40,67,89,52,36,60,44,24,43,70,89,
46,42,78,61,37,50,83,107,57,31,75,73,64,20,6,9,
19,22,6,39,48,103,49,33,52,37,19,38,62,79,42,43,
88,70,44,1,27,71,101,70,42,22,7,36,37,3,59,77,
78,23,11,42,74,56,32,23,42,59,35,40,62,51,45,24,
21,48,60,74,48,62,97,66,35,11,20,28,18,6,42,50,
44,8,8,72,57,22,35,42,21,32,51,45,41,22,22,50,
65,83,0,1,0,20,255,226,2,164,5,0,0,40,0,244,
187,0,31,0,4,0,10,0,4,43,184,0,31,16,184,0,
10,16,184,0,15,208,184,0,31,16,184,0,18,208,0,184,
0,0,69,88,184,0,17,47,27,185,0,17,0,11,62,89,
184,0,0,69,88,184,0,14,47,27,185,0,14,0,9,62,
89,184,0,0,69,88,184,0,19,47,27,185,0,19,0,9,
62,89,184,0,0,69,88,184,0,5,47,27,185,0,5,0,
5,62,89,184,0,14,16,185,0,11,0,2,252,184,0,29,
208,184,0,30,208,184,0,5,16,185,0,36,0,2,252,65,
33,0,7,0,36,0,23,0,36,0,39,0,36,0,55,0,
36,0,71,0,36,0,87,0,36,0,103,0,36,0,119,0,
36,0,135,0,36,0,151,0,36,0,167,0,36,0,183,0,
36,0,199,0,36,0,215,0,36,0,231,0,36,0,247,0,
36,0,16,93,65,15,0,7,0,36,0,23,0,36,0,39,
0,36,0,55,0,36,0,71,0,36,0,87,0,36,0,103,
0,36,0,7,113,65,5,0,118,0,36,0,134,0,36,0,
2,113,48,49,37,14,3,35,34,46,2,53,17,35,39,55,
51,53,55,23,17,33,23,14,3,7,46,1,43,1,17,20,
30,2,51,50,54,55,23,2,164,49,96,87,74,26,35,63,
48,28,129,21,78,72,119,31,1,71,29,9,27,28,27,10,
24,98,81,52,11,26,41,30,35,106,78,29,117,36,55,37,
19,26,59,96,70,2,103,28,66,246,104,25,254,187,29,14,
31,29,22,4,12,23,253,239,60,79,47,19,26,40,51,0,
0,1,0,41,255,226,4,45,3,192,0,61,0,242,184,0,
62,47,184,0,63,47,184,0,54,220,185,0,42,0,4,252,
184,0,8,208,184,0,62,16,184,0,18,208,184,0,18,47,
185,0,32,0,4,252,0,184,0,0,69,88,184,0,30,47,
27,185,0,30,0,9,62,89,184,0,0,69,88,184,0,52,
47,27,185,0,52,0,9,62,89,184,0,0,69,88,184,0,
5,47,27,185,0,5,0,5,62,89,184,0,0,69,88,184,
0,13,47,27,185,0,13,0,5,62,89,186,0,8,0,5,
0,30,17,18,57,185,0,37,0,2,252,65,33,0,7,0,
37,0,23,0,37,0,39,0,37,0,55,0,37,0,71,0,
37,0,87,0,37,0,103,0,37,0,119,0,37,0,135,0,
37,0,151,0,37,0,167,0,37,0,183,0,37,0,199,0,
37,0,215,0,37,0,231,0,37,0,247,0,37,0,16,93,
65,15,0,7,0,37,0,23,0,37,0,39,0,37,0,55,
0,37,0,71,0,37,0,87,0,37,0,103,0,37,0,7,
113,65,5,0,118,0,37,0,134,0,37,0,2,113,48,49,
37,14,3,35,34,38,39,14,3,35,34,46,2,53,17,52,
46,2,39,53,62,3,55,23,17,20,30,2,51,50,62,2,
55,17,52,46,2,39,53,62,1,55,23,17,20,22,23,22,
54,55,23,4,45,37,68,58,44,12,35,44,6,62,103,87,
73,32,47,86,66,39,6,25,52,46,36,63,59,60,33,28,
21,39,57,36,32,67,71,78,44,9,30,55,46,72,132,56,
30,9,14,12,58,51,10,82,24,41,30,17,93,103,62,77,
42,15,26,69,120,94,1,176,48,53,27,10,5,40,4,12,
16,21,13,39,253,181,70,94,56,24,19,41,65,47,1,193,
45,54,30,12,2,40,9,38,19,39,253,101,62,78,10,8,
9,22,45,0,0,1,0,20,255,226,3,221,3,162,0,33,
0,64,0,184,0,0,69,88,184,0,16,47,27,185,0,16,
0,9,62,89,184,0,0,69,88,184,0,31,47,27,185,0,
31,0,9,62,89,184,0,0,69,88,184,0,11,47,27,185,
0,11,0,5,62,89,186,0,24,0,11,0,16,17,18,57,
48,49,1,14,3,7,1,14,3,7,1,46,1,39,53,33,
21,14,3,23,27,1,54,46,2,39,53,33,21,3,221,30,
38,24,13,5,254,229,9,34,40,39,13,254,182,9,52,50,
1,130,39,49,27,4,6,246,231,5,3,24,45,37,1,67,
3,119,7,12,15,19,15,253,8,22,31,21,12,3,3,81,
28,29,11,43,43,5,10,15,22,16,253,127,2,129,15,21,
15,11,6,43,43,0,0,1,0,20,255,226,5,145,3,162,
0,40,0,122,0,184,0,0,69,88,184,0,22,47,27,185,
0,22,0,9,62,89,184,0,0,69,88,184,0,31,47,27,
185,0,31,0,9,62,89,184,0,0,69,88,184,0,38,47,
27,185,0,38,0,9,62,89,184,0,0,69,88,184,0,11,
47,27,185,0,11,0,5,62,89,184,0,0,69,88,184,0,
18,47,27,185,0,18,0,5,62,89,186,0,12,0,11,0,
22,17,18,57,184,0,31,16,185,0,24,0,1,252,186,0,
33,0,11,0,22,17,18,57,184,0,37,208,48,49,1,14,
3,7,3,14,3,7,11,1,14,3,7,1,38,39,53,33,
21,14,3,23,27,1,51,1,19,54,38,39,53,33,21,5,
145,31,36,21,9,3,221,6,35,42,41,13,238,205,8,33,
40,39,13,254,250,9,100,1,130,49,54,24,1,3,188,246,
69,1,4,173,6,54,69,1,69,3,119,7,13,13,17,12,
253,2,22,31,21,12,3,2,166,253,179,23,31,21,11,3,
3,87,39,23,43,43,5,13,17,18,9,253,133,2,228,253,
28,2,123,23,28,11,43,43,0,1,0,20,0,0,3,248,
3,162,0,58,0,139,0,184,0,0,69,88,184,0,30,47,
27,185,0,30,0,9,62,89,184,0,0,69,88,184,0,45,
47,27,185,0,45,0,9,62,89,184,0,0,69,88,184,0,
0,47,27,185,0,0,0,5,62,89,184,0,0,69,88,184,
0,15,47,27,185,0,15,0,5,62,89,184,0,0,16,185,
0,1,0,1,252,186,0,8,0,0,0,30,17,18,57,184,
0,14,208,184,0,17,208,184,0,30,16,185,0,29,0,1,
252,184,0,32,208,186,0,38,0,0,0,30,17,18,57,184,
0,44,208,184,0,47,208,184,0,17,16,184,0,57,208,48,
49,33,53,62,2,53,52,39,11,1,6,30,2,23,21,33,
53,62,3,55,19,3,46,3,39,53,33,21,14,2,22,31,
1,55,62,1,46,1,39,53,33,21,14,1,7,3,1,30,
3,23,21,2,102,25,44,25,20,198,189,19,8,34,51,24,
254,133,40,56,39,27,11,243,235,13,26,37,54,40,1,164,
31,45,23,3,18,161,154,18,4,21,44,31,1,125,81,89,
26,210,1,11,12,28,37,50,33,43,2,8,18,16,17,27,
1,13,254,243,27,33,18,8,2,43,43,6,19,25,29,15,
1,82,1,66,18,31,23,15,3,43,43,3,11,19,31,24,
222,222,24,32,19,10,3,43,43,6,47,37,254,217,254,147,
15,29,26,20,4,43,0,1,255,209,254,12,3,221,3,162,
0,51,0,64,0,184,0,0,69,88,184,0,35,47,27,185,
0,35,0,9,62,89,184,0,0,69,88,184,0,50,47,27,
185,0,50,0,9,62,89,184,0,0,69,88,184,0,11,47,
27,185,0,11,0,7,62,89,186,0,43,0,11,0,35,17,
18,57,48,49,1,14,3,7,1,14,3,35,34,46,2,53,
52,62,2,55,30,1,55,62,3,63,1,1,46,1,39,53,
33,21,14,3,23,27,1,54,46,2,39,53,33,3,221,30,
38,24,13,5,254,178,42,103,111,112,50,38,64,46,26,24,
36,41,16,48,95,37,18,48,49,47,18,29,254,184,9,52,
50,1,130,39,49,27,4,6,246,231,5,7,27,49,37,1,
78,3,119,7,12,15,19,15,252,123,111,158,101,48,10,15,
19,9,6,36,43,40,10,28,4,14,6,44,64,81,43,69,
3,74,28,29,11,43,43,5,10,15,22,16,253,131,2,125,
15,21,15,11,6,43,0,1,0,76,0,0,3,61,3,178,
0,30,0,95,0,184,0,0,69,88,184,0,16,47,27,185,
0,16,0,9,62,89,184,0,0,69,88,184,0,20,47,27,
185,0,20,0,9,62,89,184,0,0,69,88,184,0,22,47,
27,185,0,22,0,9,62,89,184,0,0,69,88,184,0,5,
47,27,185,0,5,0,5,62,89,184,0,22,16,185,0,8,
0,2,252,184,0,9,208,184,0,5,16,185,0,25,0,2,
252,48,49,37,20,14,2,7,33,39,1,33,34,14,2,7,
39,55,30,2,51,50,51,33,23,1,33,50,54,55,23,3,
61,2,3,4,3,253,53,26,2,43,254,166,16,33,31,27,
10,49,18,22,36,39,23,24,32,1,236,22,253,211,1,166,
25,42,23,47,248,32,72,68,58,18,45,3,27,12,33,59,
46,12,244,6,7,3,43,252,227,77,91,10,0,1,0,102,
254,197,2,137,6,64,0,67,0,186,184,0,68,47,184,0,
36,208,184,0,36,47,184,0,41,16,184,0,41,220,184,0,
36,16,184,0,41,220,65,11,0,16,0,41,0,32,0,41,
0,48,0,41,0,64,0,41,0,80,0,41,0,5,93,65,
3,0,208,0,41,0,1,93,65,3,0,240,0,41,0,1,
93,65,7,0,144,0,41,0,160,0,41,0,176,0,41,0,
3,93,65,3,0,112,0,41,0,1,93,185,0,25,0,4,
252,184,0,36,16,185,0,25,0,4,252,184,0,5,208,184,
0,41,16,185,0,20,0,4,252,184,0,10,208,186,0,15,
0,36,0,41,17,18,57,184,0,41,16,184,0,54,208,184,
0,36,16,184,0,61,208,184,0,20,16,184,0,69,220,0,
184,0,66,47,184,0,31,47,186,0,15,0,31,0,66,17,
18,57,48,49,1,14,3,21,20,30,2,21,20,14,2,7,
30,3,21,20,14,2,21,20,30,2,23,7,46,3,53,52,
62,2,53,52,38,35,34,35,34,14,1,7,39,62,1,53,
52,46,4,53,52,62,2,55,23,2,137,39,67,50,28,13,
15,13,25,46,67,42,50,69,42,19,13,15,13,15,39,67,
53,23,84,120,77,36,13,15,13,81,75,14,7,6,10,13,
15,17,118,120,6,9,11,9,6,45,84,120,75,26,6,17,
24,62,75,88,52,58,74,65,74,58,42,81,71,58,18,9,
45,68,91,55,60,84,74,74,50,55,85,69,59,29,61,34,
75,92,114,72,59,77,71,81,62,81,83,1,3,2,53,31,
124,75,40,58,47,41,46,59,41,67,119,101,84,34,47,0,
0,1,0,180,254,107,1,64,6,134,0,10,0,25,187,0,
0,0,4,0,4,0,4,43,184,0,9,208,0,184,0,8,
47,184,0,3,47,48,49,1,14,1,7,39,17,62,1,55,
23,17,1,64,18,62,25,35,28,47,29,36,254,159,16,28,
8,23,7,211,17,24,8,22,248,47,0,1,0,39,254,197,
2,76,6,64,0,67,0,199,184,0,68,47,184,0,26,208,
184,0,26,47,184,0,21,16,184,0,21,220,184,0,26,16,
184,0,21,220,65,5,0,0,0,21,0,16,0,21,0,2,
93,65,3,0,240,0,21,0,1,93,65,3,0,208,0,21,
0,1,93,65,3,0,48,0,21,0,1,93,65,11,0,112,
0,21,0,128,0,21,0,144,0,21,0,160,0,21,0,176,
0,21,0,5,93,65,3,0,80,0,21,0,1,93,185,0,
3,0,4,252,184,0,26,16,185,0,3,0,4,252,184,0,
21,16,185,0,10,0,4,252,186,0,31,0,21,0,10,17,
18,57,184,0,26,16,184,0,36,208,184,0,21,16,184,0,
41,208,184,0,10,16,184,0,52,208,184,0,3,16,184,0,
57,208,184,0,10,16,184,0,69,220,0,184,0,47,47,184,
0,15,47,186,0,31,0,15,0,47,17,18,57,48,49,1,
14,1,21,20,30,4,21,20,14,2,7,39,62,3,53,52,
46,2,53,52,62,2,55,46,3,53,52,62,2,53,52,46,
2,39,55,30,3,21,20,14,2,21,20,22,51,50,51,50,
62,1,55,23,2,76,119,119,6,8,11,8,6,45,84,120,
74,27,39,67,50,28,12,15,12,24,47,67,43,51,69,43,
18,12,15,12,15,39,68,52,23,84,121,76,36,12,15,12,
81,75,13,6,6,10,15,15,17,2,139,31,121,77,40,58,
46,40,47,58,41,68,118,102,85,34,49,24,61,75,89,52,
58,73,65,75,59,41,80,70,57,18,10,45,69,91,56,59,
84,74,74,49,56,86,69,57,29,61,33,75,92,113,72,59,
78,71,81,61,81,84,1,3,3,56,0,1,0,49,1,219,
3,182,3,31,0,28,0,31,0,184,0,5,47,184,0,13,
47,184,0,5,16,184,0,24,220,184,0,10,208,184,0,10,
47,184,0,19,220,48,49,1,14,3,35,34,46,2,35,34,
6,7,39,62,3,51,50,30,2,51,50,54,55,23,3,182,
21,64,79,91,48,42,94,97,95,43,49,83,42,53,21,65,
79,90,48,46,97,95,91,40,48,86,42,53,3,6,49,105,
87,56,50,60,50,78,84,27,49,105,87,56,50,60,50,78,
82,25,0,2,0,154,253,203,1,135,3,193,0,15,0,26,
0,162,187,0,0,0,4,0,8,0,4,43,65,5,0,154,
0,8,0,170,0,8,0,2,93,65,19,0,9,0,8,0,
25,0,8,0,41,0,8,0,57,0,8,0,73,0,8,0,
89,0,8,0,105,0,8,0,121,0,8,0,137,0,8,0,
9,93,0,184,0,19,47,184,0,0,69,88,184,0,13,47,
27,185,0,13,0,9,62,89,184,0,5,220,65,5,0,217,
0,5,0,233,0,5,0,2,93,65,27,0,8,0,5,0,
24,0,5,0,40,0,5,0,56,0,5,0,72,0,5,0,
88,0,5,0,104,0,5,0,120,0,5,0,136,0,5,0,
152,0,5,0,168,0,5,0,184,0,5,0,200,0,5,0,
13,93,48,49,1,20,14,2,35,34,38,53,52,62,2,51,
50,22,3,14,1,7,39,19,62,1,55,23,19,1,135,22,
38,49,28,51,49,21,37,51,30,52,46,20,39,83,34,43,
47,20,30,26,27,49,3,80,34,59,45,26,59,56,34,59,
44,25,59,250,151,25,45,12,22,4,49,16,15,8,18,251,
246,0,0,2,0,104,255,215,3,96,4,221,0,10,0,68,
0,183,187,0,0,0,4,0,23,0,4,43,187,0,56,0,
3,0,5,0,4,43,184,0,56,16,65,19,0,6,0,0,
0,22,0,0,0,38,0,0,0,54,0,0,0,70,0,0,
0,86,0,0,0,102,0,0,0,118,0,0,0,134,0,0,
0,9,93,65,5,0,149,0,0,0,165,0,0,0,2,93,
184,0,11,208,184,0,5,16,184,0,17,208,184,0,5,16,
184,0,28,208,184,0,56,16,184,0,35,208,184,0,56,16,
184,0,67,208,0,184,0,16,47,184,0,34,47,187,0,56,
0,2,0,18,0,4,43,184,0,56,16,187,0,39,0,2,
0,55,0,4,43,184,0,39,16,186,0,5,0,16,0,34,
17,18,57,184,0,36,208,184,0,36,47,184,0,18,16,184,
0,67,208,184,0,67,47,48,49,1,20,30,2,23,17,14,
3,1,14,3,7,39,53,46,3,53,52,62,2,55,53,62,
3,55,23,21,62,1,51,50,30,2,23,22,14,2,7,39,
46,3,39,17,50,62,2,55,23,14,3,7,21,1,0,34,
59,80,46,45,79,60,35,1,53,9,14,13,17,12,25,71,
133,104,63,55,98,137,81,14,12,9,14,15,26,12,24,13,
33,69,64,53,17,2,10,18,22,9,35,9,31,47,64,42,
27,48,57,74,54,39,51,82,71,63,32,2,104,70,114,86,
57,14,2,179,9,50,86,123,253,62,8,9,7,5,4,25,
145,3,62,115,168,109,88,156,123,87,21,153,9,9,5,4,
4,22,146,1,1,11,21,29,19,11,44,48,45,13,10,16,
38,34,27,5,253,62,5,25,52,47,41,60,80,49,24,4,
141,0,0,1,0,64,255,225,3,130,4,211,0,73,0,47,
0,187,0,50,0,2,0,64,0,4,43,184,0,50,16,187,
0,72,0,2,0,0,0,4,43,184,0,72,16,184,0,0,
16,184,0,39,208,184,0,72,16,184,0,44,208,48,49,1,
35,22,14,2,7,62,1,30,3,55,62,3,55,23,14,3,
7,14,1,46,2,6,7,39,62,4,38,39,35,39,62,1,
55,51,38,62,2,51,50,30,2,23,14,3,7,35,46,1,
35,34,14,4,23,51,23,2,103,242,3,16,31,45,26,46,
69,58,50,53,58,37,46,66,51,42,21,43,4,11,11,11,
4,45,121,139,147,142,127,49,23,31,48,34,22,10,2,7,
114,22,5,11,6,108,6,44,103,165,114,26,49,56,69,47,
1,8,11,13,6,47,14,121,100,27,53,47,38,21,2,12,
251,25,2,24,68,126,111,94,36,4,2,1,2,3,1,1,
1,10,34,67,59,18,43,79,67,50,15,25,6,14,23,10,
15,31,49,25,44,51,67,98,137,95,25,15,35,16,142,226,
157,83,4,15,27,24,26,74,77,69,19,124,112,11,35,67,
113,167,116,23,0,2,0,158,1,23,3,36,3,156,0,23,
0,67,0,19,0,184,0,48,47,184,0,56,47,184,0,24,
47,184,0,32,47,48,49,1,14,1,21,20,22,23,30,1,
51,50,54,55,62,1,53,52,38,39,46,1,35,34,6,1,
39,14,1,35,34,38,39,7,39,46,1,39,55,46,1,53,
52,54,55,39,55,62,1,55,23,62,1,51,50,22,23,63,
1,23,7,30,1,21,20,6,7,31,1,1,107,25,25,24,
25,26,62,32,32,62,25,24,25,25,25,25,61,32,32,62,
1,94,105,34,77,40,40,78,34,108,33,8,16,7,107,24,
23,24,24,107,2,14,32,16,107,34,78,40,40,76,34,106,
34,30,106,24,25,24,24,106,1,2,209,25,63,32,32,61,
24,26,24,24,25,25,62,32,32,62,25,25,24,24,254,46,
105,23,23,23,24,107,2,14,32,16,107,33,77,40,40,78,
34,108,33,8,16,7,107,24,25,24,25,106,1,66,106,34,
78,40,40,77,34,105,34,0,0,1,255,189,0,0,3,230,
4,190,0,56,0,104,187,0,50,0,4,0,4,0,4,43,
184,0,50,16,184,0,4,16,184,0,11,208,186,0,33,0,
4,0,50,17,18,57,184,0,50,16,184,0,44,208,0,184,
0,26,47,184,0,38,47,184,0,0,69,88,184,0,0,47,
27,185,0,0,0,5,62,89,187,0,11,0,2,0,5,0,
4,43,184,0,11,16,186,0,33,0,0,0,26,17,18,57,
184,0,45,208,184,0,5,16,184,0,48,208,48,49,51,53,
62,1,53,17,33,39,62,1,55,33,53,46,3,39,46,3,
35,39,62,1,51,50,23,30,3,23,19,54,38,39,53,33,
21,14,1,7,1,21,33,23,7,33,17,20,30,2,23,21,
236,91,73,254,240,22,5,11,6,1,16,35,77,79,76,32,
9,23,36,54,42,4,59,118,42,46,32,37,68,64,65,35,
214,15,49,77,1,140,69,73,14,254,230,1,15,25,25,254,
241,17,39,63,47,43,19,39,14,1,65,25,15,35,16,53,
73,146,134,117,45,11,20,15,9,43,8,13,39,48,102,112,
125,72,1,123,26,30,10,43,43,13,27,26,253,251,51,23,
68,254,191,6,17,20,20,9,43,0,0,2,0,119,255,226,
3,74,5,160,0,23,0,107,1,166,187,0,98,0,4,0,
76,0,4,43,184,0,98,16,187,0,32,0,4,0,58,0,
4,43,184,0,32,16,65,5,0,154,0,58,0,170,0,58,
0,2,93,65,19,0,9,0,58,0,25,0,58,0,41,0,
58,0,57,0,58,0,73,0,58,0,89,0,58,0,105,0,
58,0,121,0,58,0,137,0,58,0,9,93,186,0,6,0,
58,0,32,17,18,57,184,0,6,47,65,5,0,154,0,6,
0,170,0,6,0,2,93,65,19,0,9,0,6,0,25,0,
6,0,41,0,6,0,57,0,6,0,73,0,6,0,89,0,
6,0,105,0,6,0,121,0,6,0,137,0,6,0,9,93,
65,19,0,6,0,98,0,22,0,98,0,38,0,98,0,54,
0,98,0,70,0,98,0,86,0,98,0,102,0,98,0,118,
0,98,0,134,0,98,0,9,93,65,5,0,149,0,98,0,
165,0,98,0,2,93,186,0,19,0,76,0,98,17,18,57,
184,0,19,47,184,0,6,16,185,0,24,0,4,252,184,0,
19,16,185,0,68,0,4,252,184,0,24,16,184,0,109,220,
0,184,0,0,69,88,184,0,14,47,27,185,0,14,0,9,
62,89,184,0,0,69,88,184,0,39,47,27,185,0,39,0,
5,62,89,187,0,81,0,2,0,95,0,4,43,184,0,81,
16,184,0,39,16,185,0,55,0,2,252,65,33,0,7,0,
55,0,23,0,55,0,39,0,55,0,55,0,55,0,71,0,
55,0,87,0,55,0,103,0,55,0,119,0,55,0,135,0,
55,0,151,0,55,0,167,0,55,0,183,0,55,0,199,0,
55,0,215,0,55,0,231,0,55,0,247,0,55,0,16,93,
65,15,0,7,0,55,0,23,0,55,0,39,0,55,0,55,
0,55,0,71,0,55,0,87,0,55,0,103,0,55,0,7,
113,65,5,0,118,0,55,0,134,0,55,0,2,113,48,49,
1,30,1,23,62,1,53,52,46,2,39,46,1,39,14,3,
21,20,30,2,37,20,14,2,7,30,1,21,20,14,4,35,
34,46,2,39,46,1,62,1,55,23,30,3,51,50,54,53,
52,46,2,39,46,3,53,52,62,2,55,46,1,53,52,62,
2,51,50,30,2,23,22,14,2,7,39,46,1,35,34,6,
21,20,30,2,23,30,3,2,26,26,53,25,32,37,37,76,
115,78,23,42,20,18,26,17,9,34,70,109,1,123,19,33,
42,22,26,31,40,64,78,76,67,19,24,59,65,69,33,7,
5,3,9,7,43,2,40,67,89,52,72,92,43,71,89,45,
66,106,74,40,23,39,51,28,35,38,50,83,107,57,31,75,
73,64,20,6,9,19,22,6,39,48,103,49,66,75,28,55,
83,55,67,111,81,45,2,17,14,27,15,20,63,38,46,75,
71,71,42,12,27,14,6,30,38,40,16,46,71,65,68,84,
44,76,63,48,17,28,70,47,71,98,65,37,18,4,12,22,
31,18,3,59,77,78,23,11,42,77,60,35,68,71,40,58,
47,42,25,36,73,83,100,64,37,69,61,49,18,40,94,57,
62,91,59,28,14,24,31,18,6,42,50,44,8,8,72,67,
57,53,35,57,54,54,31,38,69,79,98,0,0,2,0,100,
4,100,2,188,5,76,0,14,0,29,0,146,184,0,30,47,
184,0,31,47,184,0,0,220,185,0,8,0,4,252,65,5,
0,154,0,8,0,170,0,8,0,2,93,65,19,0,9,0,
8,0,25,0,8,0,41,0,8,0,57,0,8,0,73,0,
8,0,89,0,8,0,105,0,8,0,121,0,8,0,137,0,
8,0,9,93,184,0,30,16,184,0,23,208,184,0,23,47,
185,0,15,0,4,252,65,19,0,6,0,15,0,22,0,15,
0,38,0,15,0,54,0,15,0,70,0,15,0,86,0,15,
0,102,0,15,0,118,0,15,0,134,0,15,0,9,93,65,
5,0,149,0,15,0,165,0,15,0,2,93,48,49,1,20,
14,2,35,34,38,53,52,62,2,51,50,5,20,14,2,35,
34,38,53,52,62,2,51,50,2,188,18,31,42,25,45,39,
18,32,41,24,85,254,112,18,31,42,25,45,39,18,32,41,
24,85,4,237,28,50,37,22,50,46,28,50,37,21,95,28,
50,37,22,50,46,28,50,37,21,0,0,3,0,100,255,226,
5,80,5,10,0,44,0,64,0,88,2,31,187,0,55,0,
3,0,77,0,4,43,184,0,55,16,187,0,32,0,4,0,
10,0,4,43,184,0,32,16,187,0,65,0,3,0,45,0,
4,43,184,0,65,16,186,0,0,0,77,0,65,17,18,57,
65,19,0,6,0,32,0,22,0,32,0,38,0,32,0,54,
0,32,0,70,0,32,0,86,0,32,0,102,0,32,0,118,
0,32,0,134,0,32,0,9,93,65,5,0,149,0,32,0,
165,0,32,0,2,93,65,5,0,154,0,45,0,170,0,45,
0,2,93,65,19,0,9,0,45,0,25,0,45,0,41,0,
45,0,57,0,45,0,73,0,45,0,89,0,45,0,105,0,
45,0,121,0,45,0,137,0,45,0,9,93,65,19,0,6,
0,55,0,22,0,55,0,38,0,55,0,54,0,55,0,70,
0,55,0,86,0,55,0,102,0,55,0,118,0,55,0,134,
0,55,0,9,93,65,5,0,149,0,55,0,165,0,55,0,
2,93,184,0,90,220,0,184,0,0,69,88,184,0,82,47,
27,185,0,82,0,11,62,89,184,0,0,69,88,184,0,72,
47,27,185,0,72,0,5,62,89,187,0,37,0,2,0,5,
0,4,43,184,0,37,16,187,0,15,0,2,0,27,0,4,
43,184,0,15,16,186,0,0,0,72,0,82,17,18,57,184,
0,82,16,185,0,50,0,2,252,65,5,0,121,0,50,0,
137,0,50,0,2,113,65,33,0,8,0,50,0,24,0,50,
0,40,0,50,0,56,0,50,0,72,0,50,0,88,0,50,
0,104,0,50,0,120,0,50,0,136,0,50,0,152,0,50,
0,168,0,50,0,184,0,50,0,200,0,50,0,216,0,50,
0,232,0,50,0,248,0,50,0,16,93,65,15,0,8,0,
50,0,24,0,50,0,40,0,50,0,56,0,50,0,72,0,
50,0,88,0,50,0,104,0,50,0,7,113,184,0,72,16,
185,0,60,0,2,252,65,33,0,7,0,60,0,23,0,60,
0,39,0,60,0,55,0,60,0,71,0,60,0,87,0,60,
0,103,0,60,0,119,0,60,0,135,0,60,0,151,0,60,
0,167,0,60,0,183,0,60,0,199,0,60,0,215,0,60,
0,231,0,60,0,247,0,60,0,16,93,65,15,0,7,0,
60,0,23,0,60,0,39,0,60,0,55,0,60,0,71,0,
60,0,87,0,60,0,103,0,60,0,7,113,65,5,0,118,
0,60,0,134,0,60,0,2,113,48,49,1,14,3,35,34,
46,2,53,52,62,2,51,50,22,23,22,14,2,7,39,46,
1,35,34,14,2,21,20,30,2,51,50,62,2,55,30,1,
1,52,46,2,35,34,14,2,21,20,30,2,51,50,62,2,
55,20,14,4,35,34,46,2,53,52,62,2,51,50,30,4,
3,250,45,81,76,73,36,65,125,98,61,67,116,153,86,76,
112,38,4,13,21,25,9,24,36,90,61,32,84,75,51,59,
89,101,42,22,42,50,59,38,8,14,1,5,81,145,200,119,
118,199,145,81,81,145,199,118,119,200,145,81,86,43,79,113,
140,165,91,137,230,168,94,94,168,230,137,91,165,140,113,79,
43,1,113,43,58,36,15,52,99,143,91,100,164,115,63,37,
26,3,26,32,30,7,4,28,48,32,77,130,97,80,120,81,
41,8,20,36,28,3,22,1,3,118,209,156,90,90,156,209,
118,119,210,156,90,90,156,210,119,91,169,147,121,86,47,104,
179,241,137,136,241,178,104,47,86,120,147,168,0,3,0,49,
2,74,2,2,4,211,0,15,0,19,0,73,0,157,184,0,
74,47,184,0,75,47,184,0,66,220,185,0,15,0,3,252,
184,0,1,208,184,0,74,16,184,0,34,208,184,0,34,47,
185,0,7,0,3,252,65,19,0,6,0,7,0,22,0,7,
0,38,0,7,0,54,0,7,0,70,0,7,0,86,0,7,
0,102,0,7,0,118,0,7,0,134,0,7,0,9,93,65,
5,0,149,0,7,0,165,0,7,0,2,93,184,0,34,16,
184,0,16,208,184,0,16,47,184,0,15,16,184,0,26,208,
184,0,26,47,184,0,15,16,184,0,38,208,0,187,0,17,
0,2,0,16,0,4,43,184,0,17,16,187,0,60,0,1,
0,44,0,4,43,184,0,60,16,48,49,1,53,7,14,3,
21,20,30,2,51,50,54,55,5,53,33,21,55,14,1,35,
34,38,39,14,1,35,34,46,2,53,52,54,63,1,53,52,
46,2,35,34,14,2,23,22,14,2,47,1,62,3,51,50,
30,2,29,1,20,22,23,22,54,55,23,1,82,43,44,57,
34,13,11,16,18,7,31,70,38,254,225,1,178,29,46,61,
16,14,29,7,48,93,34,20,41,34,22,95,102,92,7,18,
34,27,15,32,24,11,8,1,27,36,35,7,8,4,55,72,
76,26,36,50,31,14,8,6,5,31,28,6,3,78,146,11,
12,29,33,38,21,21,26,15,6,29,31,254,73,73,182,31,
26,40,43,45,38,12,27,43,32,62,95,28,24,17,31,47,
32,17,14,25,35,21,5,11,9,5,2,20,31,58,45,26,
20,46,76,55,196,28,25,7,3,3,11,25,0,2,0,80,
0,17,3,86,3,145,0,20,0,41,0,19,0,184,0,8,
47,184,0,29,47,184,0,20,47,184,0,41,47,48,49,19,
48,53,52,53,52,54,55,1,23,48,14,6,51,19,7,19,
48,53,52,53,52,54,55,1,23,48,14,6,51,19,7,80,
1,1,1,103,42,20,32,42,44,41,32,20,1,231,43,9,
1,1,1,103,42,20,32,42,44,41,32,20,1,231,43,1,
174,11,11,13,14,23,1,1,154,30,36,59,75,78,75,58,
35,254,92,30,1,157,11,11,13,14,23,1,1,154,30,36,
59,75,78,75,58,35,254,92,30,0,0,1,0,61,0,182,
3,123,2,106,0,13,0,35,187,0,0,0,3,0,4,0,
4,43,184,0,12,208,0,184,0,3,47,187,0,11,0,2,
0,5,0,4,43,184,0,11,16,48,49,37,14,1,7,39,
17,33,39,62,1,55,33,23,17,3,123,20,41,25,25,253,
74,25,5,17,9,3,2,29,233,15,28,8,25,1,43,24,
20,48,20,22,254,149,0,4,0,35,2,226,2,184,5,150,
0,14,0,51,0,71,0,91,1,70,187,0,48,0,3,0,
18,0,4,43,184,0,48,16,187,0,29,0,3,0,12,0,
4,43,184,0,29,16,187,0,62,0,3,0,82,0,4,43,
184,0,62,16,187,0,72,0,3,0,52,0,4,43,184,0,
72,16,184,0,48,16,184,0,4,208,65,5,0,154,0,12,
0,170,0,12,0,2,93,65,19,0,9,0,12,0,25,0,
12,0,41,0,12,0,57,0,12,0,73,0,12,0,89,0,
12,0,105,0,12,0,121,0,12,0,137,0,12,0,9,93,
186,0,32,0,82,0,72,17,18,57,65,5,0,154,0,52,
0,170,0,52,0,2,93,65,19,0,9,0,52,0,25,0,
52,0,41,0,52,0,57,0,52,0,73,0,52,0,89,0,
52,0,105,0,52,0,121,0,52,0,137,0,52,0,9,93,
65,19,0,6,0,62,0,22,0,62,0,38,0,62,0,54,
0,62,0,70,0,62,0,86,0,62,0,102,0,62,0,118,
0,62,0,134,0,62,0,9,93,65,5,0,149,0,62,0,
165,0,62,0,2,93,184,0,72,16,184,0,93,220,0,184,
0,0,69,88,184,0,26,47,27,185,0,26,0,11,62,89,
187,0,67,0,1,0,77,0,4,43,184,0,67,16,187,0,
87,0,1,0,57,0,4,43,184,0,87,16,184,0,0,220,
184,0,2,208,184,0,26,16,184,0,15,220,186,0,32,0,
26,0,15,17,18,57,184,0,40,208,184,0,40,47,48,49,
1,34,35,34,7,21,22,51,50,51,50,54,53,52,38,3,
53,54,53,17,14,1,7,39,62,1,51,50,22,21,20,6,
7,23,30,1,55,23,14,1,35,34,38,47,1,35,34,39,
21,20,23,21,37,52,46,2,35,34,14,2,21,20,30,2,
51,50,62,2,55,20,14,2,35,34,46,2,53,52,62,2,
51,50,30,2,1,80,6,6,5,6,8,5,6,8,51,47,
45,179,44,11,22,11,2,29,64,42,75,77,56,44,103,7,
23,22,2,20,43,11,9,18,4,105,2,15,16,43,1,25,
41,72,100,60,59,99,72,41,41,72,99,59,60,100,72,41,
59,50,88,122,72,72,120,88,49,49,88,120,72,72,122,88,
50,4,232,1,146,2,42,38,29,40,254,143,18,9,10,1,
70,2,2,2,29,7,11,54,41,47,61,11,143,11,6,2,
21,6,11,12,6,171,3,149,10,9,18,197,59,105,78,45,
45,78,105,59,60,104,78,45,45,78,104,60,72,126,94,54,
54,94,126,72,72,126,94,54,54,94,126,0,0,1,0,167,
4,151,3,75,5,25,0,14,0,0,1,14,3,7,33,39,
62,3,55,33,23,3,75,2,10,12,11,4,253,153,22,2,
10,12,12,5,2,101,22,5,1,11,29,29,28,9,25,11,
28,29,27,10,24,0,0,2,0,140,2,247,2,81,4,211,
0,19,0,39,0,175,184,0,40,47,184,0,41,47,184,0,
20,220,185,0,0,0,3,252,65,5,0,154,0,0,0,170,
0,0,0,2,93,65,19,0,9,0,0,0,25,0,0,0,
41,0,0,0,57,0,0,0,73,0,0,0,89,0,0,0,
105,0,0,0,121,0,0,0,137,0,0,0,9,93,184,0,
40,16,184,0,30,208,184,0,30,47,185,0,10,0,3,252,
65,19,0,6,0,10,0,22,0,10,0,38,0,10,0,54,
0,10,0,70,0,10,0,86,0,10,0,102,0,10,0,118,
0,10,0,134,0,10,0,9,93,65,5,0,149,0,10,0,
165,0,10,0,2,93,0,187,0,15,0,2,0,25,0,4,
43,184,0,15,16,187,0,35,0,2,0,5,0,4,43,184,
0,35,16,48,49,1,52,46,2,35,34,14,2,21,20,30,
2,51,50,62,2,55,20,14,2,35,34,46,2,53,52,62,
2,51,50,30,2,1,228,15,27,40,24,25,46,36,21,14,
27,39,25,24,46,37,22,109,48,76,94,46,41,70,50,28,
47,76,94,47,39,69,51,30,3,227,29,53,41,24,20,38,
53,33,28,53,41,25,19,37,53,85,62,104,77,43,30,52,
68,39,62,105,77,43,31,52,69,0,0,2,0,61,0,129,
3,10,4,26,0,10,0,35,0,40,187,0,11,0,3,0,
15,0,4,43,184,0,11,16,184,0,15,16,184,0,22,208,
184,0,11,16,184,0,27,208,184,0,11,16,184,0,34,208,
48,49,37,14,1,7,33,39,62,1,55,33,23,37,14,1,
7,39,17,33,39,62,1,55,33,17,62,1,55,23,17,33,
23,14,1,7,33,17,3,10,5,17,8,253,106,25,5,17,
9,2,150,24,254,211,20,48,22,25,254,236,25,5,17,9,
1,14,19,50,22,24,1,21,24,5,17,8,254,241,217,20,
51,17,24,20,48,20,24,149,10,16,5,22,1,23,24,20,
48,20,1,17,6,18,5,23,254,233,24,20,51,17,254,242,
0,1,0,217,4,23,2,107,5,209,0,10,0,7,0,184,
0,0,47,48,49,1,46,1,39,19,30,3,31,1,1,18,
18,27,12,234,12,40,43,39,11,23,4,23,4,15,9,1,
158,1,5,7,7,3,39,0,0,1,0,61,254,12,4,61,
3,192,0,76,1,20,187,0,17,0,3,0,28,0,4,43,
184,0,17,16,187,0,70,0,4,0,56,0,4,43,184,0,
70,16,184,0,56,16,184,0,10,208,186,0,22,0,28,0,
70,17,18,57,184,0,28,16,185,0,46,0,4,252,186,0,
62,0,28,0,70,17,18,57,184,0,70,16,184,0,78,220,
0,184,0,0,69,88,184,0,40,47,27,185,0,40,0,9,
62,89,184,0,0,69,88,184,0,65,47,27,185,0,65,0,
9,62,89,184,0,0,69,88,184,0,27,47,27,185,0,27,
0,7,62,89,184,0,0,69,88,184,0,5,47,27,185,0,
5,0,5,62,89,184,0,0,69,88,184,0,13,47,27,185,
0,13,0,5,62,89,186,0,10,0,27,0,40,17,18,57,
184,0,51,220,65,27,0,7,0,51,0,23,0,51,0,39,
0,51,0,55,0,51,0,71,0,51,0,87,0,51,0,103,
0,51,0,119,0,51,0,135,0,51,0,151,0,51,0,167,
0,51,0,183,0,51,0,199,0,51,0,13,93,65,5,0,
214,0,51,0,230,0,51,0,2,93,186,0,17,0,13,0,
51,17,18,57,186,0,22,0,27,0,40,17,18,57,186,0,
62,0,27,0,40,17,18,57,48,49,37,14,3,35,34,46,
2,39,14,1,35,34,38,39,21,6,30,2,23,14,3,7,
39,17,52,46,2,39,53,62,3,55,48,30,2,23,17,20,
30,2,51,50,62,2,55,17,52,46,2,39,62,1,55,23,
14,1,7,17,20,22,51,50,54,55,4,61,30,64,60,51,
17,21,30,20,11,1,81,151,58,59,114,44,1,23,39,51,
26,15,51,55,49,12,39,5,25,52,47,39,65,58,53,26,
9,12,13,4,26,47,68,42,27,57,63,70,40,7,11,13,
7,44,91,41,28,4,10,2,18,21,22,51,33,82,19,40,
33,21,34,58,76,43,105,106,81,72,6,111,174,134,95,31,
5,19,21,20,6,29,4,178,39,44,24,11,5,40,7,12,
15,18,14,10,13,15,5,253,217,35,82,70,48,10,33,61,
52,1,205,16,45,44,38,9,12,31,17,39,26,73,63,254,
21,93,76,15,13,0,0,3,0,49,255,6,4,31,5,10,
0,10,0,24,0,60,0,185,187,0,19,0,4,0,38,0,
4,43,184,0,19,16,187,0,3,0,3,0,11,0,4,43,
184,0,3,16,187,0,55,0,3,0,0,0,4,43,184,0,
55,16,65,19,0,6,0,19,0,22,0,19,0,38,0,19,
0,54,0,19,0,70,0,19,0,86,0,19,0,102,0,19,
0,118,0,19,0,134,0,19,0,9,93,65,5,0,149,0,
19,0,165,0,19,0,2,93,184,0,11,16,184,0,29,208,
184,0,29,47,184,0,55,16,184,0,62,220,0,184,0,25,
47,184,0,0,69,88,184,0,43,47,27,185,0,43,0,11,
62,89,184,0,0,69,88,184,0,50,47,27,185,0,50,0,
11,62,89,187,0,24,0,2,0,33,0,4,43,184,0,24,
16,184,0,43,16,185,0,12,0,2,252,184,0,14,208,48,
49,1,46,1,39,17,20,22,23,62,1,53,3,19,38,35,
34,14,2,21,20,30,2,51,3,53,62,1,53,19,14,1,
35,34,46,2,53,52,62,2,51,50,30,4,49,51,21,14,
1,21,17,20,22,23,21,3,23,20,40,20,29,10,12,29,
200,1,62,41,60,100,73,41,38,81,125,88,103,69,77,1,
18,42,27,93,165,125,72,67,122,169,101,29,93,106,107,86,
54,72,68,78,73,73,4,135,7,10,5,250,210,11,17,3,
3,17,11,2,243,2,78,6,42,72,98,56,54,116,96,62,
252,164,43,14,34,14,2,165,3,3,47,95,141,94,85,142,
103,57,4,7,8,7,4,43,14,34,14,250,236,13,35,14,
43,0,0,1,0,50,2,72,0,250,3,48,0,14,0,0,
19,20,14,2,35,34,38,53,52,62,2,51,50,250,18,31,
42,25,45,39,18,32,41,24,85,2,209,28,50,37,22,50,
46,28,50,37,21,0,0,1,0,78,254,68,1,152,0,14,
0,25,0,21,0,184,0,5,47,184,0,19,47,186,0,20,
0,5,0,19,17,18,57,48,49,5,20,14,2,7,39,62,
3,53,52,38,39,48,62,2,55,23,7,30,3,1,152,35,
74,117,82,22,52,73,46,21,52,62,3,14,29,27,78,39,
26,51,39,24,229,37,68,56,42,12,49,9,27,32,35,16,
34,27,6,7,42,90,84,2,116,6,19,30,42,0,0,3,
0,49,2,74,2,16,4,211,0,3,0,23,0,43,0,189,
184,0,44,47,184,0,45,47,184,0,24,220,185,0,4,0,
3,252,65,5,0,154,0,4,0,170,0,4,0,2,93,65,
19,0,9,0,4,0,25,0,4,0,41,0,4,0,57,0,
4,0,73,0,4,0,89,0,4,0,105,0,4,0,121,0,
4,0,137,0,4,0,9,93,184,0,44,16,184,0,34,208,
184,0,34,47,185,0,14,0,3,252,65,19,0,6,0,14,
0,22,0,14,0,38,0,14,0,54,0,14,0,70,0,14,
0,86,0,14,0,102,0,14,0,118,0,14,0,134,0,14,
0,9,93,65,5,0,149,0,14,0,165,0,14,0,2,93,
0,187,0,1,0,2,0,0,0,4,43,184,0,1,16,187,
0,39,0,1,0,9,0,4,43,184,0,39,16,187,0,19,
0,1,0,29,0,4,43,184,0,19,16,48,49,19,53,33,
21,3,52,46,2,35,34,14,2,21,20,30,2,51,50,62,
2,55,20,14,2,35,34,46,2,53,52,62,2,51,50,30,
2,61,1,199,82,26,44,59,33,30,47,34,18,28,45,58,
31,27,47,35,20,94,45,72,92,47,50,82,59,32,40,70,
93,53,48,82,60,33,2,74,73,73,1,125,42,76,57,34,
30,54,73,42,42,76,57,34,30,54,73,58,51,98,77,46,
38,67,92,55,52,98,76,46,38,67,93,0,0,2,0,140,
0,17,3,146,3,145,0,20,0,41,0,19,0,184,0,0,
47,184,0,21,47,184,0,12,47,184,0,33,47,48,49,55,
39,19,50,46,6,49,55,1,30,1,21,20,21,20,49,19,
39,19,50,46,6,49,55,1,30,1,21,20,21,20,49,183,
43,231,1,20,32,42,43,42,32,20,42,1,103,1,1,9,
43,231,1,20,32,42,43,42,32,20,42,1,103,1,1,17,
30,1,164,35,58,75,78,75,59,36,30,254,102,1,23,14,
13,11,11,254,99,30,1,164,35,58,75,78,75,59,36,30,
254,102,1,23,14,13,11,11,0,2,0,80,253,209,3,39,
3,192,0,15,0,64,1,96,187,0,46,0,4,0,26,0,
4,43,184,0,46,16,187,0,0,0,4,0,8,0,4,43,
184,0,0,16,187,0,16,0,4,0,54,0,4,43,184,0,
16,16,65,5,0,154,0,8,0,170,0,8,0,2,93,65,
19,0,9,0,8,0,25,0,8,0,41,0,8,0,57,0,
8,0,73,0,8,0,89,0,8,0,105,0,8,0,121,0,
8,0,137,0,8,0,9,93,186,0,33,0,8,0,0,17,
18,57,184,0,33,47,185,0,39,0,3,252,65,19,0,6,
0,46,0,22,0,46,0,38,0,46,0,54,0,46,0,70,
0,46,0,86,0,46,0,102,0,46,0,118,0,46,0,134,
0,46,0,9,93,65,5,0,149,0,46,0,165,0,46,0,
2,93,65,5,0,154,0,54,0,170,0,54,0,2,93,65,
19,0,9,0,54,0,25,0,54,0,41,0,54,0,57,0,
54,0,73,0,54,0,89,0,54,0,105,0,54,0,121,0,
54,0,137,0,54,0,9,93,184,0,16,16,184,0,63,208,
184,0,16,16,184,0,66,220,0,184,0,0,69,88,184,0,
13,47,27,185,0,13,0,9,62,89,187,0,49,0,2,0,
21,0,4,43,184,0,49,16,184,0,13,16,184,0,5,220,
65,5,0,217,0,5,0,233,0,5,0,2,93,65,27,0,
8,0,5,0,24,0,5,0,40,0,5,0,56,0,5,0,
72,0,5,0,88,0,5,0,104,0,5,0,120,0,5,0,
136,0,5,0,152,0,5,0,168,0,5,0,184,0,5,0,
200,0,5,0,13,93,48,49,1,20,14,2,35,34,38,53,
52,62,2,51,50,22,19,20,14,2,35,34,46,2,53,52,
62,4,63,1,62,1,55,31,1,22,14,4,21,20,22,51,
50,62,2,53,52,38,39,62,1,55,23,22,21,20,2,74,
22,39,51,28,51,47,21,37,50,29,53,48,221,69,117,152,
84,74,114,77,40,47,72,84,76,54,5,6,17,31,26,26,
6,4,39,64,75,66,44,112,105,36,65,50,29,8,6,34,
70,45,27,2,3,80,34,59,45,26,59,56,34,58,44,25,
58,251,145,71,119,87,49,46,83,115,69,75,121,104,96,101,
113,70,96,16,17,8,20,117,57,112,110,106,103,99,48,124,
140,33,55,72,39,15,28,14,19,17,3,31,8,8,8,0,
255,255,0,0,0,0,4,174,6,193,2,38,0,33,0,0,
0,7,5,125,4,8,1,64,255,255,0,0,0,0,4,174,
6,193,2,38,0,33,0,0,0,7,5,126,4,118,1,64,
255,255,0,0,0,0,4,174,6,185,2,38,0,33,0,0,
0,7,5,127,4,89,1,64,255,255,0,0,0,0,4,174,
6,113,2,38,0,33,0,0,0,7,5,128,4,90,1,64,
255,255,0,0,0,0,4,174,6,100,2,38,0,33,0,0,
0,7,5,131,4,90,1,64,255,255,0,0,0,0,4,174,
6,224,2,38,0,33,0,0,0,7,2,167,4,90,1,64,
0,2,0,0,0,0,6,0,4,236,0,7,0,76,0,134,
187,0,49,0,4,0,0,0,4,43,184,0,49,16,184,0,
0,16,184,0,16,208,184,0,49,16,184,0,63,208,0,184,
0,0,69,88,184,0,35,47,27,185,0,35,0,11,62,89,
184,0,0,69,88,184,0,11,47,27,185,0,11,0,5,62,
89,184,0,0,69,88,184,0,23,47,27,185,0,23,0,5,
62,89,187,0,7,0,2,0,17,0,4,43,184,0,7,16,
184,0,35,16,185,0,48,0,2,252,184,0,7,16,184,0,
50,208,184,0,17,16,184,0,62,208,184,0,11,16,185,0,
69,0,2,252,48,49,1,52,38,14,1,7,3,51,1,14,
1,7,33,53,62,1,53,17,33,3,6,22,23,21,33,53,
62,1,55,1,54,46,2,39,53,33,23,14,3,7,35,46,
3,35,33,17,33,23,14,3,7,46,3,43,1,17,20,30,
2,59,1,50,62,2,55,23,3,6,19,26,26,7,157,235,
2,250,9,26,8,252,162,68,75,254,244,221,13,62,82,254,
96,68,77,13,1,157,7,21,50,77,49,4,33,30,2,7,
11,14,7,45,2,12,20,29,19,254,146,1,149,27,9,22,
25,25,11,15,34,46,62,42,141,15,45,81,66,129,46,65,
49,40,21,45,4,123,11,10,3,18,17,254,117,254,21,87,
128,29,43,14,33,14,2,39,253,224,29,30,9,43,43,12,
27,29,3,254,17,23,19,16,9,43,25,26,62,62,56,19,
46,61,37,15,254,78,28,14,31,29,25,8,15,20,14,6,
254,11,15,23,17,9,10,35,68,59,18,0,255,255,0,70,
254,68,3,250,5,10,2,38,0,35,0,0,0,7,2,196,
4,73,0,0,255,255,0,50,0,0,3,186,6,193,2,38,
0,37,0,0,0,7,5,125,3,167,1,64,255,255,0,50,
0,0,3,186,6,193,2,38,0,37,0,0,0,7,5,126,
4,21,1,64,255,255,0,50,0,0,3,186,6,185,2,38,
0,37,0,0,0,7,5,127,3,248,1,64,255,255,0,50,
0,0,3,186,6,100,2,38,0,37,0,0,0,7,5,131,
3,249,1,64,255,255,255,214,0,0,2,8,6,193,2,38,
0,41,0,0,0,7,5,125,2,216,1,64,255,255,0,70,
0,0,2,120,6,193,2,38,0,41,0,0,0,7,5,126,
3,70,1,64,255,255,255,234,0,0,2,99,6,185,2,38,
0,41,0,0,0,7,5,127,3,41,1,64,255,255,255,251,
0,0,2,83,6,100,2,38,0,41,0,0,0,7,5,131,
3,42,1,64,255,255,0,50,255,226,5,0,6,113,2,38,
0,46,0,0,0,7,5,128,4,156,1,64,255,255,0,70,
255,226,4,114,6,193,2,38,0,47,0,0,0,7,5,125,
4,24,1,64,255,255,0,70,255,226,4,114,6,193,2,38,
0,47,0,0,0,7,5,126,4,134,1,64,255,255,0,70,
255,226,4,114,6,185,2,38,0,47,0,0,0,7,5,127,
4,105,1,64,255,255,0,70,255,226,4,114,6,113,2,38,
0,47,0,0,0,7,5,128,4,106,1,64,255,255,0,70,
255,226,4,114,6,100,2,38,0,47,0,0,0,7,5,131,
4,106,1,64,0,3,0,70,255,203,4,115,5,33,0,11,
0,23,0,61,2,58,184,0,62,47,184,0,63,47,184,0,
27,220,185,0,0,0,4,252,65,5,0,154,0,0,0,170,
0,0,0,2,93,65,19,0,9,0,0,0,25,0,0,0,
41,0,0,0,57,0,0,0,73,0,0,0,89,0,0,0,
105,0,0,0,121,0,0,0,137,0,0,0,9,93,184,0,
62,16,184,0,48,208,184,0,48,47,186,0,3,0,48,0,
27,17,18,57,185,0,12,0,4,252,65,19,0,6,0,12,
0,22,0,12,0,38,0,12,0,54,0,12,0,70,0,12,
0,86,0,12,0,102,0,12,0,118,0,12,0,134,0,12,
0,9,93,65,5,0,149,0,12,0,165,0,12,0,2,93,
186,0,15,0,48,0,27,17,18,57,184,0,38,208,184,0,
38,47,184,0,48,16,184,0,44,208,184,0,44,47,184,0,
0,16,184,0,57,208,184,0,57,47,184,0,27,16,184,0,
61,208,184,0,61,47,0,184,0,43,47,184,0,0,69,88,
184,0,60,47,27,185,0,60,0,11,62,89,184,0,0,69,
88,184,0,53,47,27,185,0,53,0,11,62,89,184,0,0,
69,88,184,0,61,47,27,185,0,61,0,11,62,89,184,0,
0,69,88,184,0,34,47,27,185,0,34,0,5,62,89,184,
0,0,69,88,184,0,44,47,27,185,0,44,0,5,62,89,
186,0,3,0,43,0,60,17,18,57,184,0,34,16,185,0,
7,0,2,252,65,33,0,7,0,7,0,23,0,7,0,39,
0,7,0,55,0,7,0,71,0,7,0,87,0,7,0,103,
0,7,0,119,0,7,0,135,0,7,0,151,0,7,0,167,
0,7,0,183,0,7,0,199,0,7,0,215,0,7,0,231,
0,7,0,247,0,7,0,16,93,65,15,0,7,0,7,0,
23,0,7,0,39,0,7,0,55,0,7,0,71,0,7,0,
87,0,7,0,103,0,7,0,7,113,65,5,0,118,0,7,
0,134,0,7,0,2,113,186,0,15,0,43,0,60,17,18,
57,184,0,53,16,185,0,19,0,2,252,65,5,0,121,0,
19,0,137,0,19,0,2,113,65,33,0,8,0,19,0,24,
0,19,0,40,0,19,0,56,0,19,0,72,0,19,0,88,
0,19,0,104,0,19,0,120,0,19,0,136,0,19,0,152,
0,19,0,168,0,19,0,184,0,19,0,200,0,19,0,216,
0,19,0,232,0,19,0,248,0,19,0,16,93,65,15,0,
8,0,19,0,24,0,19,0,40,0,19,0,56,0,19,0,
72,0,19,0,88,0,19,0,104,0,19,0,7,113,48,49,
1,52,38,39,1,30,1,51,50,62,2,37,20,22,23,1,
46,1,35,34,14,2,1,30,1,21,20,14,4,35,34,38,
39,7,14,3,7,39,55,46,1,53,52,62,2,51,50,22,
23,55,62,1,55,23,3,215,40,38,253,240,48,116,63,83,
139,101,56,253,10,42,38,2,18,47,116,68,89,141,97,52,
3,10,68,68,41,75,104,125,143,76,87,143,59,53,9,33,
38,37,12,28,128,66,68,88,152,205,118,87,144,57,54,28,
68,31,28,2,117,89,169,72,253,12,54,59,69,136,202,144,
94,170,70,2,244,53,60,76,139,198,1,80,91,235,126,90,
171,151,125,90,50,55,49,76,8,15,13,11,4,33,182,90,
232,128,136,246,186,110,55,48,77,17,24,8,33,0,255,255,
0,50,255,226,4,251,6,193,2,38,0,53,0,0,0,7,
5,125,4,86,1,64,255,255,0,50,255,226,4,251,6,193,
2,38,0,53,0,0,0,7,5,126,4,196,1,64,255,255,
0,50,255,226,4,251,6,185,2,38,0,53,0,0,0,7,
5,127,4,167,1,64,255,255,0,50,255,226,4,251,6,100,
2,38,0,53,0,0,0,7,5,131,4,168,1,64,0,1,
0,55,255,226,4,43,6,14,0,88,1,144,187,0,54,0,
4,0,59,0,4,43,184,0,54,16,187,0,80,0,4,0,
36,0,4,43,184,0,80,16,187,0,73,0,4,0,43,0,
4,43,184,0,73,16,65,5,0,154,0,43,0,170,0,43,
0,2,93,65,19,0,9,0,43,0,25,0,43,0,41,0,
43,0,57,0,43,0,73,0,43,0,89,0,43,0,105,0,
43,0,121,0,43,0,137,0,43,0,9,93,186,0,29,0,
43,0,73,17,18,57,184,0,29,47,65,5,0,154,0,29,
0,170,0,29,0,2,93,65,19,0,9,0,29,0,25,0,
29,0,41,0,29,0,57,0,29,0,73,0,29,0,89,0,
29,0,105,0,29,0,121,0,29,0,137,0,29,0,9,93,
185,0,0,0,4,252,65,19,0,6,0,80,0,22,0,80,
0,38,0,80,0,54,0,80,0,70,0,80,0,86,0,80,
0,102,0,80,0,118,0,80,0,134,0,80,0,9,93,65,
5,0,149,0,80,0,165,0,80,0,2,93,0,184,0,0,
69,88,184,0,54,47,27,185,0,54,0,5,62,89,184,0,
0,69,88,184,0,5,47,27,185,0,5,0,5,62,89,187,
0,68,0,2,0,48,0,4,43,184,0,68,16,184,0,5,
16,185,0,24,0,2,252,65,33,0,7,0,24,0,23,0,
24,0,39,0,24,0,55,0,24,0,71,0,24,0,87,0,
24,0,103,0,24,0,119,0,24,0,135,0,24,0,151,0,
24,0,167,0,24,0,183,0,24,0,199,0,24,0,215,0,
24,0,231,0,24,0,247,0,24,0,16,93,65,15,0,7,
0,24,0,23,0,24,0,39,0,24,0,55,0,24,0,71,
0,24,0,87,0,24,0,103,0,24,0,7,113,65,5,0,
118,0,24,0,134,0,24,0,2,113,48,49,1,20,14,2,
35,34,46,2,39,46,1,53,52,62,2,55,23,30,3,51,
50,62,2,53,52,46,4,53,52,62,4,53,52,46,2,35,
34,14,2,21,17,33,53,62,1,53,17,52,62,2,55,62,
1,51,50,30,2,21,20,14,4,21,20,30,6,4,43,38,
82,128,90,28,82,80,63,7,3,3,2,5,8,5,39,7,
50,70,81,38,35,62,45,26,67,101,117,101,67,49,74,86,
74,49,28,60,95,67,48,82,58,33,254,223,68,72,33,54,
72,39,54,134,72,86,120,75,33,51,76,90,76,51,38,63,
79,84,79,63,38,1,27,59,112,88,54,15,22,28,12,5,
35,24,24,54,50,37,7,13,54,76,49,23,22,39,55,33,
69,92,69,56,68,90,68,67,85,55,38,42,58,48,51,108,
89,57,36,92,159,124,252,8,43,12,35,12,3,91,120,162,
110,73,32,44,48,71,108,126,55,82,104,66,42,38,48,40,
33,49,42,39,44,53,71,94,255,255,0,80,255,226,3,158,
5,209,2,38,0,65,0,0,0,7,2,157,3,145,0,0,
255,255,0,80,255,226,3,158,5,209,2,38,0,65,0,0,
0,7,2,158,3,255,0,0,255,255,0,80,255,226,3,158,
5,191,2,38,0,65,0,0,0,7,2,159,3,226,0,0,
255,255,0,80,255,226,3,158,5,89,2,38,0,65,0,0,
0,7,2,160,3,227,0,0,255,255,0,80,255,226,3,158,
5,76,2,38,0,65,0,0,0,7,2,165,3,227,0,0,
255,255,0,80,255,226,3,158,5,160,2,38,0,65,0,0,
0,7,2,167,3,227,0,0,0,3,0,80,255,226,5,57,
3,192,0,13,0,35,0,123,2,85,187,0,26,0,4,0,
77,0,4,43,184,0,26,16,187,0,44,0,4,0,19,0,
4,43,184,0,44,16,187,0,36,0,4,0,9,0,4,43,
184,0,36,16,65,5,0,154,0,9,0,170,0,9,0,2,
93,65,19,0,9,0,9,0,25,0,9,0,41,0,9,0,
57,0,9,0,73,0,9,0,89,0,9,0,105,0,9,0,
121,0,9,0,137,0,9,0,9,93,184,0,19,16,184,0,
17,208,65,19,0,6,0,26,0,22,0,26,0,38,0,26,
0,54,0,26,0,70,0,26,0,86,0,26,0,102,0,26,
0,118,0,26,0,134,0,26,0,9,93,65,5,0,149,0,
26,0,165,0,26,0,2,93,184,0,44,16,184,0,42,208,
186,0,67,0,19,0,44,17,18,57,184,0,19,16,184,0,
85,208,186,0,112,0,19,0,44,17,18,57,184,0,36,16,
184,0,125,220,0,184,0,0,69,88,184,0,109,47,27,185,
0,109,0,9,62,89,184,0,0,69,88,184,0,117,47,27,
185,0,117,0,9,62,89,184,0,0,69,88,184,0,62,47,
27,185,0,62,0,5,62,89,184,0,0,69,88,184,0,72,
47,27,185,0,72,0,5,62,89,187,0,6,0,2,0,39,
0,4,43,184,0,6,16,184,0,117,16,185,0,0,0,2,
252,65,5,0,121,0,0,0,137,0,0,0,2,113,65,33,
0,8,0,0,0,24,0,0,0,40,0,0,0,56,0,0,
0,72,0,0,0,88,0,0,0,104,0,0,0,120,0,0,
0,136,0,0,0,152,0,0,0,168,0,0,0,184,0,0,
0,200,0,0,0,216,0,0,0,232,0,0,0,248,0,0,
0,16,93,65,15,0,8,0,0,0,24,0,0,0,40,0,
0,0,56,0,0,0,72,0,0,0,88,0,0,0,104,0,
0,0,7,113,184,0,39,16,184,0,20,208,184,0,20,47,
184,0,72,16,185,0,31,0,2,252,65,33,0,7,0,31,
0,23,0,31,0,39,0,31,0,55,0,31,0,71,0,31,
0,87,0,31,0,103,0,31,0,119,0,31,0,135,0,31,
0,151,0,31,0,167,0,31,0,183,0,31,0,199,0,31,
0,215,0,31,0,231,0,31,0,247,0,31,0,16,93,65,
15,0,7,0,31,0,23,0,31,0,39,0,31,0,55,0,
31,0,71,0,31,0,87,0,31,0,103,0,31,0,7,113,
65,5,0,118,0,31,0,134,0,31,0,2,113,184,0,49,
208,186,0,67,0,62,0,109,17,18,57,184,0,6,16,184,
0,85,208,184,0,85,47,184,0,0,16,184,0,91,208,184,
0,91,47,186,0,112,0,62,0,109,17,18,57,48,49,1,
34,14,2,7,33,50,54,53,52,46,2,1,46,1,61,3,
14,1,7,14,1,21,20,30,2,51,50,62,2,1,14,1,
7,33,6,21,20,21,20,30,2,51,50,62,2,55,30,1,
23,14,3,35,34,46,2,39,14,3,35,34,46,2,53,52,
62,2,55,62,1,55,53,52,46,2,35,34,14,2,23,22,
14,2,47,1,62,5,51,50,22,23,62,3,51,50,30,4,
3,227,23,61,60,53,13,1,92,21,17,20,42,67,254,107,
7,7,33,52,12,150,134,25,34,38,13,27,68,75,78,2,
225,20,60,32,254,63,2,31,60,87,56,31,57,65,78,53,
13,19,5,60,100,91,87,47,44,85,75,61,21,43,101,100,
90,31,36,76,61,40,47,94,144,98,33,83,44,12,34,61,
49,32,72,56,27,15,3,43,59,59,12,14,5,48,71,88,
91,86,35,88,103,23,32,72,73,69,29,61,94,69,48,29,
12,3,88,21,60,108,87,15,21,48,87,66,39,253,155,29,
60,33,7,3,110,2,6,4,37,125,82,40,50,29,10,18,
35,54,1,94,20,35,13,17,18,17,19,58,113,90,55,7,
27,54,46,7,26,8,72,88,48,17,28,54,77,50,52,78,
53,26,24,52,82,58,59,109,94,77,28,9,11,3,86,39,
72,54,33,29,51,67,37,9,22,18,9,3,36,39,76,67,
57,41,23,72,72,40,56,33,15,35,59,80,89,95,255,255,
0,80,254,68,3,72,3,192,2,38,0,67,0,0,0,7,
2,196,3,235,0,0,255,255,0,80,255,226,3,98,5,209,
2,38,0,69,0,0,0,7,2,157,3,175,0,0,255,255,
0,80,255,226,3,98,5,209,2,38,0,69,0,0,0,7,
2,158,4,29,0,0,255,255,0,80,255,226,3,98,5,191,
2,38,0,69,0,0,0,7,2,159,4,0,0,0,255,255,
0,80,255,226,3,98,5,76,2,38,0,69,0,0,0,7,
2,165,4,1,0,0,255,255,255,247,0,0,1,244,5,209,
2,38,0,176,0,0,0,7,2,157,2,206,0,0,255,255,
0,70,0,0,2,75,5,209,2,38,0,176,0,0,0,7,
2,158,3,60,0,0,255,255,255,224,0,0,2,89,5,191,
2,38,0,176,0,0,0,7,2,159,3,31,0,0,255,255,
255,241,0,0,2,73,5,76,2,38,0,176,0,0,0,7,
2,165,3,32,0,0,255,255,0,55,0,0,4,76,5,89,
2,38,0,78,0,0,0,7,2,160,4,68,0,0,255,255,
0,80,255,226,3,182,5,209,2,38,0,79,0,0,0,7,
2,157,3,200,0,0,255,255,0,80,255,226,3,182,5,209,
2,38,0,79,0,0,0,7,2,158,4,54,0,0,255,255,
0,80,255,226,3,182,5,191,2,38,0,79,0,0,0,7,
2,159,4,25,0,0,255,255,0,80,255,226,3,182,5,89,
2,38,0,79,0,0,0,7,2,160,4,26,0,0,255,255,
0,80,255,226,3,182,5,76,2,38,0,79,0,0,0,7,
2,165,4,26,0,0,0,3,0,61,0,231,3,10,3,128,
0,14,0,29,0,40,0,17,0,187,0,39,0,2,0,33,
0,4,43,184,0,39,16,48,49,1,20,14,2,35,34,38,
53,52,62,2,51,50,17,20,14,2,35,34,38,53,52,62,
2,51,50,37,14,1,7,33,39,62,1,55,33,23,1,243,
14,25,34,19,35,32,14,25,34,19,67,14,25,34,19,35,
32,14,25,34,19,67,1,23,5,17,8,253,106,25,5,17,
9,2,150,24,3,52,22,40,30,17,40,37,22,40,29,17,
253,212,22,40,30,17,40,37,22,40,29,17,178,20,51,17,
24,20,48,20,24,0,0,3,0,80,255,203,3,182,3,215,
0,11,0,23,0,65,2,49,184,0,66,47,184,0,67,47,
184,0,28,220,185,0,0,0,4,252,65,5,0,154,0,0,
0,170,0,0,0,2,93,65,19,0,9,0,0,0,25,0,
0,0,41,0,0,0,57,0,0,0,73,0,0,0,89,0,
0,0,105,0,0,0,121,0,0,0,137,0,0,0,9,93,
184,0,66,16,184,0,49,208,184,0,49,47,186,0,3,0,
49,0,28,17,18,57,185,0,12,0,4,252,65,19,0,6,
0,12,0,22,0,12,0,38,0,12,0,54,0,12,0,70,
0,12,0,86,0,12,0,102,0,12,0,118,0,12,0,134,
0,12,0,9,93,65,5,0,149,0,12,0,165,0,12,0,
2,93,186,0,15,0,49,0,28,17,18,57,184,0,28,16,
184,0,24,208,184,0,24,47,184,0,12,16,184,0,39,208,
184,0,39,47,184,0,49,16,184,0,45,208,184,0,45,47,
184,0,0,16,184,0,60,208,184,0,60,47,0,184,0,44,
47,184,0,65,47,184,0,0,69,88,184,0,24,47,27,185,
0,24,0,9,62,89,184,0,0,69,88,184,0,56,47,27,
185,0,56,0,9,62,89,184,0,0,69,88,184,0,35,47,
27,185,0,35,0,5,62,89,184,0,0,69,88,184,0,45,
47,27,185,0,45,0,5,62,89,186,0,3,0,44,0,65,
17,18,57,184,0,35,16,185,0,7,0,2,252,65,33,0,
7,0,7,0,23,0,7,0,39,0,7,0,55,0,7,0,
71,0,7,0,87,0,7,0,103,0,7,0,119,0,7,0,
135,0,7,0,151,0,7,0,167,0,7,0,183,0,7,0,
199,0,7,0,215,0,7,0,231,0,7,0,247,0,7,0,
16,93,65,15,0,7,0,7,0,23,0,7,0,39,0,7,
0,55,0,7,0,71,0,7,0,87,0,7,0,103,0,7,
0,7,113,65,5,0,118,0,7,0,134,0,7,0,2,113,
186,0,15,0,44,0,65,17,18,57,184,0,56,16,185,0,
19,0,2,252,65,5,0,121,0,19,0,137,0,19,0,2,
113,65,33,0,8,0,19,0,24,0,19,0,40,0,19,0,
56,0,19,0,72,0,19,0,88,0,19,0,104,0,19,0,
120,0,19,0,136,0,19,0,152,0,19,0,168,0,19,0,
184,0,19,0,200,0,19,0,216,0,19,0,232,0,19,0,
248,0,19,0,16,93,65,15,0,8,0,19,0,24,0,19,
0,40,0,19,0,56,0,19,0,72,0,19,0,88,0,19,
0,104,0,19,0,7,113,48,49,1,52,38,39,1,30,1,
51,50,62,2,37,20,22,23,1,46,1,35,34,14,2,1,
7,30,1,21,20,14,4,35,34,38,39,7,14,3,7,39,
55,46,1,53,52,62,4,51,50,22,23,55,62,3,55,3,
29,32,26,254,129,40,88,40,71,103,67,32,253,204,33,28,
1,128,39,89,44,76,104,65,28,2,201,102,51,55,34,60,
84,101,114,61,69,118,48,19,9,33,36,35,12,29,100,52,
56,33,59,83,101,116,63,69,119,49,21,13,31,32,32,14,
1,199,60,113,48,254,5,42,47,53,98,138,104,61,111,48,
1,252,42,47,58,101,138,1,141,135,63,168,99,66,129,114,
97,70,39,38,35,25,8,21,21,17,4,33,132,63,169,100,
66,128,115,97,70,40,39,36,28,9,21,20,16,4,255,255,
0,41,255,226,4,45,5,209,2,38,0,85,0,0,0,7,
2,157,3,210,0,0,255,255,0,41,255,226,4,45,5,209,
2,38,0,85,0,0,0,7,2,158,4,64,0,0,255,255,
0,41,255,226,4,45,5,191,2,38,0,85,0,0,0,7,
2,159,4,35,0,0,255,255,0,41,255,226,4,45,5,76,
2,38,0,85,0,0,0,7,2,165,4,36,0,0,255,255,
255,209,254,12,3,221,5,76,2,38,0,89,0,0,0,7,
2,165,4,21,0,0,0,1,0,70,0,0,1,244,3,192,
0,22,0,51,187,0,18,0,4,0,4,0,4,43,184,0,
18,16,0,184,0,0,69,88,184,0,16,47,27,185,0,16,
0,9,62,89,184,0,0,69,88,184,0,0,47,27,185,0,
0,0,5,62,89,48,49,51,53,62,1,53,17,52,46,2,
39,53,62,3,55,51,17,20,22,23,21,70,68,72,4,26,
57,53,31,69,68,62,26,34,67,73,43,14,33,14,2,54,
51,63,35,16,5,40,6,17,21,24,12,252,168,12,35,14,
43,0,0,2,0,70,255,226,6,39,5,10,0,18,0,84,
1,197,184,0,85,47,184,0,86,47,184,0,72,220,185,0,
5,0,4,252,184,0,85,16,184,0,33,208,184,0,33,47,
185,0,14,0,4,252,65,19,0,6,0,14,0,22,0,14,
0,38,0,14,0,54,0,14,0,70,0,14,0,86,0,14,
0,102,0,14,0,118,0,14,0,134,0,14,0,9,93,65,
5,0,149,0,14,0,165,0,14,0,2,93,184,0,72,16,
184,0,57,208,0,184,0,0,69,88,184,0,43,47,27,185,
0,43,0,11,62,89,184,0,0,69,88,184,0,38,47,27,
185,0,38,0,11,62,89,184,0,0,69,88,184,0,28,47,
27,185,0,28,0,5,62,89,184,0,0,69,88,184,0,22,
47,27,185,0,22,0,5,62,89,187,0,58,0,2,0,71,
0,4,43,184,0,58,16,184,0,28,16,185,0,0,0,2,
252,65,33,0,7,0,0,0,23,0,0,0,39,0,0,0,
55,0,0,0,71,0,0,0,87,0,0,0,103,0,0,0,
119,0,0,0,135,0,0,0,151,0,0,0,167,0,0,0,
183,0,0,0,199,0,0,0,215,0,0,0,231,0,0,0,
247,0,0,0,16,93,65,15,0,7,0,0,0,23,0,0,
0,39,0,0,0,55,0,0,0,71,0,0,0,87,0,0,
0,103,0,0,0,7,113,65,5,0,118,0,0,0,134,0,
0,0,2,113,184,0,43,16,185,0,9,0,2,252,65,5,
0,121,0,9,0,137,0,9,0,2,113,65,33,0,8,0,
9,0,24,0,9,0,40,0,9,0,56,0,9,0,72,0,
9,0,88,0,9,0,104,0,9,0,120,0,9,0,136,0,
9,0,152,0,9,0,168,0,9,0,184,0,9,0,200,0,
9,0,216,0,9,0,232,0,9,0,248,0,9,0,16,93,
65,15,0,8,0,9,0,24,0,9,0,40,0,9,0,56,
0,9,0,72,0,9,0,88,0,9,0,104,0,9,0,7,
113,184,0,56,208,184,0,57,208,184,0,0,16,184,0,77,
208,184,0,78,208,48,49,37,50,62,2,55,17,46,1,35,
34,14,2,21,20,30,2,37,14,1,7,33,14,3,35,34,
46,2,53,52,62,2,51,50,30,2,23,33,23,14,3,7,
35,46,3,35,33,17,33,23,14,3,7,46,3,43,1,17,
20,30,2,59,1,50,62,2,55,23,2,92,40,70,61,54,
25,53,126,71,89,141,97,52,61,103,138,4,24,8,25,8,
253,114,53,76,66,66,44,120,188,129,68,88,152,205,118,40,
59,54,59,40,2,80,30,2,7,11,13,6,47,2,12,20,
29,19,254,189,1,106,29,9,24,25,24,10,15,35,45,62,
42,100,2,28,68,66,129,46,65,49,41,22,43,90,3,10,
19,17,3,192,41,36,76,139,198,122,112,200,151,88,154,87,
128,29,1,9,11,9,106,178,232,126,136,246,186,110,9,11,
9,1,25,26,62,62,56,19,46,61,37,15,254,78,28,14,
31,29,25,8,15,20,14,6,254,11,15,23,17,9,10,35,
68,59,18,0,0,3,0,80,255,226,6,8,3,192,0,13,
0,33,0,96,2,152,184,0,97,47,184,0,98,47,184,0,
39,220,184,0,5,208,184,0,5,47,184,0,39,16,185,0,
14,0,4,252,65,5,0,154,0,14,0,170,0,14,0,2,
93,65,19,0,9,0,14,0,25,0,14,0,41,0,14,0,
57,0,14,0,73,0,14,0,89,0,14,0,105,0,14,0,
121,0,14,0,137,0,14,0,9,93,184,0,97,16,184,0,
72,208,184,0,72,47,185,0,24,0,4,252,65,19,0,6,
0,24,0,22,0,24,0,38,0,24,0,54,0,24,0,70,
0,24,0,86,0,24,0,102,0,24,0,118,0,24,0,134,
0,24,0,9,93,65,5,0,149,0,24,0,165,0,24,0,
2,93,186,0,62,0,39,0,14,17,18,57,186,0,82,0,
39,0,14,17,18,57,0,184,0,0,69,88,184,0,79,47,
27,185,0,79,0,9,62,89,184,0,0,69,88,184,0,90,
47,27,185,0,90,0,9,62,89,184,0,0,69,88,184,0,
57,47,27,185,0,57,0,5,62,89,184,0,0,69,88,184,
0,67,47,27,185,0,67,0,5,62,89,187,0,6,0,2,
0,37,0,4,43,184,0,6,16,184,0,90,16,185,0,0,
0,2,252,65,5,0,121,0,0,0,137,0,0,0,2,113,
65,33,0,8,0,0,0,24,0,0,0,40,0,0,0,56,
0,0,0,72,0,0,0,88,0,0,0,104,0,0,0,120,
0,0,0,136,0,0,0,152,0,0,0,168,0,0,0,184,
0,0,0,200,0,0,0,216,0,0,0,232,0,0,0,248,
0,0,0,16,93,65,15,0,8,0,0,0,24,0,0,0,
40,0,0,0,56,0,0,0,72,0,0,0,88,0,0,0,
104,0,0,0,7,113,184,0,19,208,184,0,19,47,184,0,
67,16,185,0,29,0,2,252,65,33,0,7,0,29,0,23,
0,29,0,39,0,29,0,55,0,29,0,71,0,29,0,87,
0,29,0,103,0,29,0,119,0,29,0,135,0,29,0,151,
0,29,0,167,0,29,0,183,0,29,0,199,0,29,0,215,
0,29,0,231,0,29,0,247,0,29,0,16,93,65,15,0,
7,0,29,0,23,0,29,0,39,0,29,0,55,0,29,0,
71,0,29,0,87,0,29,0,103,0,29,0,7,113,65,5,
0,118,0,29,0,134,0,29,0,2,113,184,0,57,16,185,
0,44,0,2,252,65,33,0,7,0,44,0,23,0,44,0,
39,0,44,0,55,0,44,0,71,0,44,0,87,0,44,0,
103,0,44,0,119,0,44,0,135,0,44,0,151,0,44,0,
167,0,44,0,183,0,44,0,199,0,44,0,215,0,44,0,
231,0,44,0,247,0,44,0,16,93,65,15,0,7,0,44,
0,23,0,44,0,39,0,44,0,55,0,44,0,71,0,44,
0,87,0,44,0,103,0,44,0,7,113,65,5,0,118,0,
44,0,134,0,44,0,2,113,186,0,62,0,57,0,79,17,
18,57,186,0,82,0,57,0,79,17,18,57,48,49,1,34,
14,2,7,33,50,54,53,52,46,2,1,52,46,2,35,34,
14,2,21,20,30,2,51,50,62,2,37,14,1,7,33,21,
20,30,2,51,50,62,2,55,30,1,23,14,3,35,34,46,
2,39,14,3,35,34,46,2,53,52,62,4,51,50,22,23,
62,1,55,62,3,51,50,30,4,4,160,48,82,64,44,9,
1,146,22,17,15,42,76,254,43,51,85,108,57,54,89,64,
35,54,86,108,54,54,88,64,35,3,0,20,60,32,254,10,
40,74,105,65,28,54,65,82,56,13,19,5,66,101,87,82,
47,49,94,83,70,25,32,81,92,100,52,85,145,105,60,34,
61,84,101,114,61,109,173,51,26,63,38,22,57,58,57,23,
62,97,74,52,32,15,3,88,40,72,102,62,15,21,27,82,
76,55,254,111,80,143,108,64,58,101,138,80,79,143,108,63,
57,101,137,182,20,35,13,2,75,139,107,64,7,27,54,46,
7,26,8,73,89,48,15,29,55,79,50,47,78,57,31,72,
126,174,102,66,128,115,97,70,40,113,97,38,66,26,15,29,
23,13,36,61,81,90,93,0,255,255,0,0,0,0,4,152,
6,100,2,38,0,57,0,0,0,7,5,131,4,95,1,64,
0,1,255,6,254,12,3,25,6,14,0,77,0,231,187,0,
27,0,4,0,57,0,4,43,184,0,27,16,184,0,15,208,
184,0,57,16,184,0,62,208,0,184,0,73,47,184,0,0,
69,88,184,0,16,47,27,185,0,16,0,9,62,89,184,0,
0,69,88,184,0,61,47,27,185,0,61,0,9,62,89,184,
0,0,69,88,184,0,37,47,27,185,0,37,0,7,62,89,
184,0,16,16,185,0,26,0,2,252,184,0,37,16,185,0,
52,0,2,252,65,33,0,7,0,52,0,23,0,52,0,39,
0,52,0,55,0,52,0,71,0,52,0,87,0,52,0,103,
0,52,0,119,0,52,0,135,0,52,0,151,0,52,0,167,
0,52,0,183,0,52,0,199,0,52,0,215,0,52,0,231,
0,52,0,247,0,52,0,16,93,65,15,0,7,0,52,0,
23,0,52,0,39,0,52,0,55,0,52,0,71,0,52,0,
87,0,52,0,103,0,52,0,7,113,65,5,0,118,0,52,
0,134,0,52,0,2,113,184,0,26,16,184,0,58,208,184,
0,59,208,48,49,1,20,14,2,7,46,3,35,34,14,2,
29,1,33,23,14,3,7,46,1,35,17,20,14,2,7,14,
3,35,34,46,2,53,52,62,2,55,30,3,51,50,62,2,
53,17,35,39,55,51,53,52,62,2,55,62,3,51,50,30,
2,3,25,29,40,43,15,25,50,45,38,12,26,60,51,33,
1,2,28,9,26,28,27,10,23,85,78,32,54,73,40,28,
60,57,51,19,30,58,46,28,28,40,43,15,20,34,32,33,
19,28,57,46,29,133,21,78,76,33,55,73,40,27,63,62,
56,19,31,67,56,37,5,174,8,32,34,30,7,21,31,21,
11,36,92,159,124,86,29,14,31,29,22,4,12,23,253,30,
117,164,115,78,31,21,35,24,13,16,23,23,7,8,32,34,
30,7,15,18,9,3,35,92,159,124,3,23,28,66,31,118,
161,111,75,32,22,34,24,12,24,31,32,0,0,1,0,49,
4,23,2,170,5,191,0,13,0,11,0,184,0,3,47,184,
0,5,47,48,49,1,14,1,7,9,1,46,3,39,1,51,
1,2,170,12,14,17,254,238,254,241,8,11,9,10,7,1,
8,107,1,6,4,68,19,18,8,1,12,254,244,4,8,10,
14,9,1,123,254,133,0,1,0,50,4,47,2,171,5,195,
0,12,0,15,0,184,0,0,47,184,0,2,47,184,0,12,
47,48,49,1,35,1,62,3,55,5,37,30,1,23,1,165,
107,254,248,7,10,9,11,8,1,19,1,14,17,14,12,4,
47,1,101,10,14,10,8,5,251,251,9,18,20,0,0,1,
0,40,4,46,2,178,5,125,0,25,0,25,0,184,0,13,
47,184,0,23,47,187,0,18,0,2,0,5,0,4,43,184,
0,18,16,48,49,1,14,3,35,34,46,2,39,62,1,55,
30,3,51,50,62,2,55,30,1,2,178,30,75,83,90,45,
49,92,83,73,30,12,24,17,25,65,72,75,33,35,77,73,
65,24,17,24,5,80,81,110,69,30,30,69,110,81,18,19,
8,57,78,47,21,21,47,78,57,8,19,0,0,1,0,100,
4,100,1,44,5,76,0,14,0,66,187,0,0,0,4,0,
8,0,4,43,65,19,0,6,0,0,0,22,0,0,0,38,
0,0,0,54,0,0,0,70,0,0,0,86,0,0,0,102,
0,0,0,118,0,0,0,134,0,0,0,9,93,65,5,0,
149,0,0,0,165,0,0,0,2,93,48,49,1,20,14,2,
35,34,38,53,52,62,2,51,50,1,44,18,31,42,25,45,
39,18,32,41,24,85,4,237,28,50,37,22,50,46,28,50,
37,21,0,2,0,70,4,26,1,186,5,160,0,19,0,39,
0,159,184,0,40,47,184,0,41,47,184,0,20,220,185,0,
0,0,3,252,65,5,0,154,0,0,0,170,0,0,0,2,
93,65,19,0,9,0,0,0,25,0,0,0,41,0,0,0,
57,0,0,0,73,0,0,0,89,0,0,0,105,0,0,0,
121,0,0,0,137,0,0,0,9,93,184,0,40,16,184,0,
30,208,184,0,30,47,185,0,10,0,3,252,65,19,0,6,
0,10,0,22,0,10,0,38,0,10,0,54,0,10,0,70,
0,10,0,86,0,10,0,102,0,10,0,118,0,10,0,134,
0,10,0,9,93,65,5,0,149,0,10,0,165,0,10,0,
2,93,0,186,0,35,0,25,0,3,43,184,0,35,16,48,
49,1,52,46,2,35,34,14,2,21,20,30,2,51,50,62,
2,55,20,14,2,35,34,46,2,53,52,62,2,51,50,30,
2,1,96,12,22,32,20,21,38,29,18,12,22,32,20,20,
38,30,18,90,39,63,77,38,34,57,41,23,39,62,77,39,
32,57,42,24,4,219,24,44,33,20,17,31,44,27,23,43,
33,20,15,30,43,70,51,85,63,35,24,42,56,32,51,87,
63,35,25,43,57,0,0,1,0,100,254,68,1,223,0,43,
0,26,0,75,187,0,19,0,4,0,10,0,4,43,184,0,
19,16,65,19,0,6,0,19,0,22,0,19,0,38,0,19,
0,54,0,19,0,70,0,19,0,86,0,19,0,102,0,19,
0,118,0,19,0,134,0,19,0,9,93,65,5,0,149,0,
19,0,165,0,19,0,2,93,0,184,0,5,47,48,49,1,
14,3,35,34,46,2,53,52,54,55,23,14,3,21,20,22,
51,50,54,55,23,1,223,21,57,60,60,25,29,56,44,27,
157,151,45,72,88,48,16,48,38,25,73,42,24,254,213,27,
52,41,25,12,32,56,45,90,171,81,19,44,84,74,62,24,
37,35,36,38,37,0,0,1,0,70,4,89,2,240,5,89,
0,28,0,0,1,14,3,35,34,46,2,35,34,6,7,39,
62,3,51,50,30,2,51,50,54,55,23,2,240,18,50,61,
72,39,35,63,60,59,29,40,66,37,53,18,49,62,71,39,
38,68,60,54,24,38,73,34,54,5,66,41,80,64,40,35,
43,35,65,56,20,41,81,64,40,35,43,35,64,59,23,0,
0,2,0,80,4,23,2,176,5,209,0,10,0,21,0,11,
0,184,0,0,47,184,0,11,47,48,49,19,46,1,39,19,
30,3,31,1,19,46,1,39,19,30,3,31,1,137,17,20,
20,176,12,33,33,31,10,22,31,19,20,18,176,12,32,33,
31,11,22,4,23,4,11,12,1,159,2,5,7,7,4,41,
254,136,4,11,12,1,159,2,5,7,7,4,41,0,0,1,
0,20,255,224,4,34,3,192,0,75,1,24,187,0,64,0,
4,0,10,0,4,43,184,0,64,16,65,5,0,154,0,10,
0,170,0,10,0,2,93,65,19,0,9,0,10,0,25,0,
10,0,41,0,10,0,57,0,10,0,73,0,10,0,89,0,
10,0,105,0,10,0,121,0,10,0,137,0,10,0,9,93,
0,184,0,0,69,88,184,0,52,47,27,185,0,52,0,9,
62,89,184,0,0,69,88,184,0,57,47,27,185,0,57,0,
9,62,89,184,0,0,69,88,184,0,5,47,27,185,0,5,
0,5,62,89,184,0,0,69,88,184,0,29,47,27,185,0,
29,0,5,62,89,184,0,57,16,185,0,15,0,2,252,65,
5,0,121,0,15,0,137,0,15,0,2,113,65,33,0,8,
0,15,0,24,0,15,0,40,0,15,0,56,0,15,0,72,
0,15,0,88,0,15,0,104,0,15,0,120,0,15,0,136,
0,15,0,152,0,15,0,168,0,15,0,184,0,15,0,200,
0,15,0,216,0,15,0,232,0,15,0,248,0,15,0,16,
93,65,15,0,8,0,15,0,24,0,15,0,40,0,15,0,
56,0,15,0,72,0,15,0,88,0,15,0,104,0,15,0,
7,113,184,0,18,208,184,0,18,47,184,0,40,208,184,0,
41,208,48,49,37,14,3,35,34,46,2,53,52,62,2,55,
46,1,39,14,1,21,20,22,23,14,3,7,46,2,39,62,
5,55,35,34,14,2,7,39,62,3,51,33,50,54,55,23,
14,1,43,1,14,1,21,20,30,2,51,50,62,2,55,23,
4,22,51,76,59,47,22,35,52,35,17,4,8,13,9,71,
137,82,9,10,5,5,14,57,68,67,22,3,15,10,1,27,
40,30,22,20,18,11,51,32,50,47,47,28,23,29,56,57,
58,32,2,121,42,72,31,28,52,105,48,65,8,6,10,21,
34,23,15,29,36,48,34,22,110,43,55,31,12,42,77,110,
69,32,91,126,163,105,1,5,2,114,250,128,72,123,55,9,
23,23,21,6,4,18,13,1,38,68,80,105,149,207,142,5,
13,25,20,36,35,60,44,25,8,22,29,72,77,81,166,78,
91,130,84,39,3,9,16,13,44,0,0,1,0,61,1,199,
3,132,2,57,0,10,0,17,0,187,0,9,0,2,0,3,
0,4,43,184,0,9,16,48,49,1,14,1,7,33,39,62,
1,55,33,23,3,132,5,16,8,252,239,25,5,17,9,3,
17,23,2,33,22,51,17,24,22,48,20,24,0,1,0,61,
1,199,5,228,2,57,0,10,0,17,0,187,0,9,0,2,
0,3,0,4,43,184,0,9,16,48,49,1,14,1,7,33,
39,62,1,55,33,23,5,228,5,17,8,250,144,25,5,17,
9,5,112,24,2,33,22,51,17,24,22,48,20,24,0,1,
0,92,3,191,1,127,5,170,0,23,0,75,187,0,19,0,
4,0,8,0,4,43,184,0,19,16,65,19,0,6,0,19,
0,22,0,19,0,38,0,19,0,54,0,19,0,70,0,19,
0,86,0,19,0,102,0,19,0,118,0,19,0,134,0,19,
0,9,93,65,5,0,149,0,19,0,165,0,19,0,2,93,
0,184,0,13,47,48,49,1,14,3,39,46,1,53,52,62,
2,55,23,14,3,21,20,22,31,1,1,127,9,59,69,66,
18,34,36,27,52,76,48,43,21,32,21,10,54,59,16,4,
27,12,33,29,18,2,29,69,59,39,90,90,82,31,35,22,
55,56,53,21,45,65,2,45,0,1,0,88,3,195,1,121,
5,175,0,22,0,71,187,0,0,0,4,0,11,0,4,43,
65,5,0,154,0,11,0,170,0,11,0,2,93,65,19,0,
9,0,11,0,25,0,11,0,41,0,11,0,57,0,11,0,
73,0,11,0,89,0,11,0,105,0,11,0,121,0,11,0,
137,0,11,0,9,93,0,184,0,5,47,48,49,1,20,14,
2,7,39,62,3,53,52,38,47,1,62,3,23,30,1,1,
121,27,52,74,48,45,21,32,21,10,54,57,16,9,58,69,
67,18,32,36,5,16,39,91,90,83,30,34,22,56,56,53,
20,45,67,3,45,12,31,29,19,1,31,70,0,1,0,88,
254,240,1,121,0,220,0,22,0,71,187,0,0,0,4,0,
11,0,4,43,65,5,0,154,0,11,0,170,0,11,0,2,
93,65,19,0,9,0,11,0,25,0,11,0,41,0,11,0,
57,0,11,0,73,0,11,0,89,0,11,0,105,0,11,0,
121,0,11,0,137,0,11,0,9,93,0,184,0,5,47,48,
49,37,20,14,2,7,39,62,3,53,52,38,47,1,62,3,
23,30,1,1,121,27,52,74,48,45,21,32,21,10,54,57,
16,9,58,69,67,18,32,36,61,39,91,90,82,31,34,22,
56,56,53,20,45,67,3,45,12,31,29,19,1,31,70,0,
0,2,0,92,3,191,3,37,5,170,0,25,0,49,0,155,
184,0,50,47,184,0,51,47,184,0,21,220,185,0,10,0,
4,252,65,5,0,154,0,10,0,170,0,10,0,2,93,65,
19,0,9,0,10,0,25,0,10,0,41,0,10,0,57,0,
10,0,73,0,10,0,89,0,10,0,105,0,10,0,121,0,
10,0,137,0,10,0,9,93,184,0,50,16,184,0,34,208,
184,0,34,47,185,0,45,0,4,252,65,19,0,6,0,45,
0,22,0,45,0,38,0,45,0,54,0,45,0,70,0,45,
0,86,0,45,0,102,0,45,0,118,0,45,0,134,0,45,
0,9,93,65,5,0,149,0,45,0,165,0,45,0,2,93,
0,184,0,15,47,184,0,39,47,48,49,1,14,3,39,46,
3,53,52,62,2,55,23,14,3,21,20,22,31,1,33,14,
3,39,46,1,53,52,62,2,55,23,14,3,21,20,22,31,
1,3,37,9,59,69,66,18,16,26,18,10,27,52,76,48,
43,22,31,21,10,54,58,17,254,90,9,59,69,66,18,34,
36,27,52,76,48,43,21,32,21,10,54,59,16,4,27,12,
33,29,18,2,14,31,37,46,29,39,90,90,82,31,35,22,
55,56,53,21,45,65,2,45,12,33,29,18,2,29,69,59,
39,90,90,82,31,35,22,55,56,53,21,45,65,2,45,0,
0,2,0,88,3,195,3,31,5,175,0,22,0,45,0,155,
184,0,46,47,184,0,47,47,184,0,0,220,185,0,11,0,
4,252,65,5,0,154,0,11,0,170,0,11,0,2,93,65,
19,0,9,0,11,0,25,0,11,0,41,0,11,0,57,0,
11,0,73,0,11,0,89,0,11,0,105,0,11,0,121,0,
11,0,137,0,11,0,9,93,184,0,46,16,184,0,34,208,
184,0,34,47,185,0,23,0,4,252,65,19,0,6,0,23,
0,22,0,23,0,38,0,23,0,54,0,23,0,70,0,23,
0,86,0,23,0,102,0,23,0,118,0,23,0,134,0,23,
0,9,93,65,5,0,149,0,23,0,165,0,23,0,2,93,
0,184,0,5,47,184,0,28,47,48,49,1,20,14,2,7,
39,62,3,53,52,38,47,1,62,3,23,30,1,5,20,14,
2,7,39,62,3,53,52,38,47,1,62,3,23,30,1,3,
31,27,52,74,48,43,21,31,21,11,56,57,16,8,58,70,
67,18,32,36,254,90,27,52,74,48,45,21,32,21,10,54,
57,16,9,58,69,67,18,32,36,5,16,39,91,90,83,30,
34,22,56,56,53,20,45,67,3,45,12,31,29,19,1,31,
70,57,39,91,90,83,30,34,22,56,56,53,20,45,67,3,
45,12,31,29,19,1,31,70,0,2,0,88,254,240,3,31,
0,220,0,22,0,45,0,155,184,0,46,47,184,0,47,47,
184,0,0,220,185,0,11,0,4,252,65,5,0,154,0,11,
0,170,0,11,0,2,93,65,19,0,9,0,11,0,25,0,
11,0,41,0,11,0,57,0,11,0,73,0,11,0,89,0,
11,0,105,0,11,0,121,0,11,0,137,0,11,0,9,93,
184,0,46,16,184,0,34,208,184,0,34,47,185,0,23,0,
4,252,65,19,0,6,0,23,0,22,0,23,0,38,0,23,
0,54,0,23,0,70,0,23,0,86,0,23,0,102,0,23,
0,118,0,23,0,134,0,23,0,9,93,65,5,0,149,0,
23,0,165,0,23,0,2,93,0,184,0,5,47,184,0,28,
47,48,49,37,20,14,2,7,39,62,3,53,52,38,47,1,
62,3,23,30,1,5,20,14,2,7,39,62,3,53,52,38,
47,1,62,3,23,30,1,3,31,27,52,74,48,43,21,31,
21,11,56,57,16,8,58,70,67,18,32,36,254,90,27,52,
74,48,45,21,32,21,10,54,57,16,9,58,69,67,18,32,
36,61,39,91,90,82,31,34,22,56,56,53,20,45,67,3,
45,12,31,29,19,1,31,70,57,39,91,90,82,31,34,22,
56,56,53,20,45,67,3,45,12,31,29,19,1,31,70,0,
0,1,0,70,255,216,3,139,5,200,0,55,0,149,187,0,
12,0,3,0,22,0,4,43,184,0,12,16,65,19,0,6,
0,12,0,22,0,12,0,38,0,12,0,54,0,12,0,70,
0,12,0,86,0,12,0,102,0,12,0,118,0,12,0,134,
0,12,0,9,93,65,5,0,149,0,12,0,165,0,12,0,
2,93,184,0,6,208,184,0,22,16,184,0,28,208,184,0,
28,47,184,0,22,16,184,0,40,208,184,0,40,47,184,0,
12,16,184,0,50,208,184,0,50,47,0,184,0,46,47,187,
0,40,0,2,0,6,0,4,43,184,0,40,16,184,0,6,
16,184,0,28,208,184,0,40,16,184,0,50,208,184,0,50,
47,48,49,1,14,1,7,46,1,39,30,1,23,14,1,7,
6,22,23,14,1,7,39,62,1,39,46,1,39,62,1,55,
14,3,7,39,62,1,55,30,1,23,46,1,39,62,1,55,
23,14,1,7,62,3,55,3,139,14,43,25,68,139,84,1,
17,19,20,15,2,1,9,5,19,50,25,29,6,9,1,2,
15,20,19,15,2,46,85,83,83,45,25,14,43,25,67,136,
82,2,23,26,38,85,34,43,23,24,4,46,87,84,85,45,
4,50,34,85,38,24,21,5,70,148,69,111,223,96,58,132,
61,14,17,8,21,67,141,61,99,221,110,69,149,69,2,8,
12,17,11,43,34,85,38,24,22,4,91,166,74,25,43,14,
25,94,198,95,2,7,12,17,11,0,0,1,0,70,255,216,
3,139,5,200,0,75,0,191,187,0,24,0,3,0,34,0,
4,43,184,0,24,16,65,19,0,6,0,24,0,22,0,24,
0,38,0,24,0,54,0,24,0,70,0,24,0,86,0,24,
0,102,0,24,0,118,0,24,0,134,0,24,0,9,93,65,
5,0,149,0,24,0,165,0,24,0,2,93,184,0,6,208,
184,0,24,16,184,0,12,208,184,0,12,47,184,0,34,16,
184,0,46,208,184,0,34,16,184,0,52,208,184,0,34,16,
184,0,62,208,184,0,24,16,184,0,72,208,184,0,72,47,
0,184,0,68,47,187,0,12,0,2,0,24,0,4,43,184,
0,12,16,187,0,62,0,2,0,6,0,4,43,184,0,62,
16,184,0,24,16,184,0,34,208,184,0,12,16,184,0,46,
208,184,0,6,16,184,0,52,208,184,0,62,16,184,0,72,
208,184,0,72,47,48,49,1,14,1,7,46,1,39,30,1,
23,14,1,7,62,3,55,23,14,1,7,46,1,39,30,1,
23,14,1,7,39,62,1,55,14,3,7,39,62,1,55,30,
1,23,46,1,39,62,1,55,14,1,7,39,62,1,55,30,
1,23,46,1,39,62,1,55,23,14,1,7,62,1,55,3,
139,14,43,25,69,136,84,1,17,19,18,16,2,46,85,84,
85,45,25,14,43,25,67,138,84,1,24,27,38,85,34,43,
24,25,2,46,85,84,84,45,25,14,43,25,67,137,83,2,
17,17,19,15,2,92,162,90,25,14,43,25,67,137,83,2,
26,23,38,85,34,43,20,26,5,92,163,90,4,50,34,85,
38,22,23,5,62,117,68,66,123,58,2,8,12,17,11,43,
34,85,38,18,26,5,96,158,76,25,43,14,25,96,190,101,
2,9,12,16,10,43,34,85,38,24,22,4,58,124,65,69,
116,62,5,25,20,43,34,85,38,24,22,4,95,161,75,25,
43,14,25,94,193,100,4,22,23,0,0,1,0,70,1,133,
1,242,3,117,0,19,0,11,0,184,0,5,47,184,0,15,
47,48,49,1,20,14,2,35,34,46,2,53,52,62,2,51,
50,30,2,1,242,35,63,87,53,48,71,47,24,37,64,87,
51,45,71,48,25,2,150,61,100,72,40,33,60,82,48,60,
100,73,40,33,59,82,0,3,0,131,255,215,4,246,0,236,
0,15,0,31,0,47,0,255,187,0,16,0,4,0,24,0,
4,43,184,0,16,16,187,0,0,0,4,0,8,0,4,43,
184,0,0,16,187,0,32,0,4,0,40,0,4,43,184,0,
32,16,65,5,0,154,0,8,0,170,0,8,0,2,93,65,
19,0,9,0,8,0,25,0,8,0,41,0,8,0,57,0,
8,0,73,0,8,0,89,0,8,0,105,0,8,0,121,0,
8,0,137,0,8,0,9,93,65,19,0,6,0,16,0,22,
0,16,0,38,0,16,0,54,0,16,0,70,0,16,0,86,
0,16,0,102,0,16,0,118,0,16,0,134,0,16,0,9,
93,65,5,0,149,0,16,0,165,0,16,0,2,93,65,5,
0,154,0,40,0,170,0,40,0,2,93,65,19,0,9,0,
40,0,25,0,40,0,41,0,40,0,57,0,40,0,73,0,
40,0,89,0,40,0,105,0,40,0,121,0,40,0,137,0,
40,0,9,93,184,0,49,220,0,186,0,13,0,5,0,3,
43,184,0,13,16,184,0,5,16,184,0,21,208,184,0,13,
16,184,0,29,208,184,0,5,16,184,0,37,208,184,0,13,
16,184,0,45,208,48,49,37,20,14,2,35,34,38,53,52,
62,2,51,50,22,5,20,14,2,35,34,38,53,52,62,2,
51,50,22,5,20,14,2,35,34,38,53,52,62,2,51,50,
22,3,51,21,37,50,29,54,46,22,38,50,29,49,49,254,
62,21,37,51,29,54,46,22,38,51,28,50,49,3,133,22,
38,51,29,52,48,22,38,51,28,51,50,123,35,59,45,25,
59,54,34,59,45,26,59,54,35,59,45,25,59,54,34,59,
45,26,59,54,35,59,45,25,59,54,34,59,45,26,59,0,
0,7,0,76,255,221,7,207,4,213,0,19,0,39,0,59,
0,71,0,91,0,111,0,131,2,124,187,0,50,0,4,0,
122,0,4,43,184,0,50,16,187,0,112,0,4,0,40,0,
4,43,184,0,112,16,187,0,30,0,4,0,82,0,4,43,
184,0,30,16,187,0,72,0,4,0,20,0,4,43,184,0,
72,16,187,0,10,0,4,0,102,0,4,43,184,0,10,16,
187,0,92,0,4,0,0,0,4,43,184,0,92,16,65,5,
0,154,0,0,0,170,0,0,0,2,93,65,19,0,9,0,
0,0,25,0,0,0,41,0,0,0,57,0,0,0,73,0,
0,0,89,0,0,0,105,0,0,0,121,0,0,0,137,0,
0,0,9,93,65,5,0,154,0,20,0,170,0,20,0,2,
93,65,19,0,9,0,20,0,25,0,20,0,41,0,20,0,
57,0,20,0,73,0,20,0,89,0,20,0,105,0,20,0,
121,0,20,0,137,0,20,0,9,93,65,19,0,6,0,30,
0,22,0,30,0,38,0,30,0,54,0,30,0,70,0,30,
0,86,0,30,0,102,0,30,0,118,0,30,0,134,0,30,
0,9,93,65,5,0,149,0,30,0,165,0,30,0,2,93,
65,19,0,6,0,50,0,22,0,50,0,38,0,50,0,54,
0,50,0,70,0,50,0,86,0,50,0,102,0,50,0,118,
0,50,0,134,0,50,0,9,93,65,5,0,149,0,50,0,
165,0,50,0,2,93,65,5,0,154,0,102,0,170,0,102,
0,2,93,65,19,0,9,0,102,0,25,0,102,0,41,0,
102,0,57,0,102,0,73,0,102,0,89,0,102,0,105,0,
102,0,121,0,102,0,137,0,102,0,9,93,65,19,0,6,
0,112,0,22,0,112,0,38,0,112,0,54,0,112,0,70,
0,112,0,86,0,112,0,102,0,112,0,118,0,112,0,134,
0,112,0,9,93,65,5,0,149,0,112,0,165,0,112,0,
2,93,184,0,133,220,0,184,0,65,47,184,0,77,47,184,
0,97,47,184,0,70,47,184,0,127,47,187,0,87,0,2,
0,117,0,4,43,184,0,87,16,184,0,117,16,184,0,5,
208,184,0,5,47,184,0,77,16,185,0,15,0,2,252,65,
33,0,7,0,15,0,23,0,15,0,39,0,15,0,55,0,
15,0,71,0,15,0,87,0,15,0,103,0,15,0,119,0,
15,0,135,0,15,0,151,0,15,0,167,0,15,0,183,0,
15,0,199,0,15,0,215,0,15,0,231,0,15,0,247,0,
15,0,16,93,65,15,0,7,0,15,0,23,0,15,0,39,
0,15,0,55,0,15,0,71,0,15,0,87,0,15,0,103,
0,15,0,7,113,65,5,0,118,0,15,0,134,0,15,0,
2,113,184,0,117,16,184,0,25,208,184,0,25,47,184,0,
15,16,184,0,35,208,184,0,127,16,185,0,45,0,2,252,
184,0,87,16,184,0,55,208,184,0,55,47,184,0,87,16,
184,0,107,208,48,49,1,52,46,2,35,34,14,2,21,20,
30,2,51,50,62,2,37,52,46,2,35,34,14,2,21,20,
30,2,51,50,62,2,1,52,46,2,35,34,14,2,21,20,
30,2,51,50,62,2,3,14,3,7,39,1,62,1,55,23,
19,20,14,2,35,34,46,2,53,52,62,2,51,50,30,2,
5,20,14,2,35,34,46,2,53,52,62,2,51,50,30,2,
1,20,14,2,35,34,46,2,53,52,62,2,51,50,30,2,
7,61,25,40,54,28,23,44,35,21,22,39,55,32,24,45,
33,20,253,109,25,42,54,29,22,43,34,21,22,39,54,32,
25,44,34,20,253,66,25,42,54,29,22,43,35,21,22,39,
55,32,24,45,34,20,134,9,35,40,39,12,24,3,88,28,
74,31,29,120,48,80,107,58,58,98,70,40,49,81,106,57,
60,98,70,38,2,150,48,80,107,58,59,99,71,39,49,81,
106,57,60,98,71,39,250,174,48,81,107,59,59,97,71,39,
48,81,106,58,60,98,71,39,1,33,70,104,69,33,29,58,
87,59,72,106,69,34,30,60,89,59,70,104,69,33,29,58,
87,59,72,106,69,34,30,60,89,2,135,71,104,68,33,29,
58,87,59,72,106,69,34,30,60,89,252,222,7,15,13,12,
4,35,4,164,17,24,8,33,252,129,69,124,93,54,54,93,
124,69,69,123,92,54,53,92,123,70,69,124,93,54,54,93,
124,69,69,123,92,54,53,92,123,2,6,69,124,93,54,54,
93,124,69,69,123,92,54,53,92,123,0,1,0,80,0,17,
1,228,3,145,0,20,0,0,19,48,53,52,53,52,54,55,
1,23,48,14,6,51,19,7,80,1,1,1,103,42,20,32,
42,44,41,32,20,1,231,43,1,174,11,11,13,14,23,1,
1,154,30,36,59,75,78,75,58,35,254,92,30,0,0,1,
0,140,0,17,2,32,3,145,0,20,0,0,55,39,19,50,
46,6,49,55,1,30,1,21,20,21,20,49,183,43,231,1,
20,32,42,43,42,32,20,42,1,103,1,1,17,30,1,164,
35,58,75,78,75,59,36,30,254,102,1,23,14,13,11,11,
0,2,0,59,3,39,4,61,4,236,0,34,0,77,0,217,
187,0,30,0,3,0,4,0,4,43,184,0,30,16,187,0,
51,0,3,0,61,0,4,43,184,0,51,16,187,0,37,0,
3,0,75,0,4,43,184,0,37,16,184,0,75,16,184,0,
47,208,184,0,47,47,186,0,48,0,4,0,37,17,18,57,
186,0,71,0,4,0,37,17,18,57,184,0,37,16,184,0,
79,220,0,184,0,0,47,184,0,42,47,184,0,49,47,184,
0,56,47,184,0,0,69,88,184,0,17,47,27,185,0,17,
0,11,62,89,184,0,0,69,88,184,0,19,47,27,185,0,
19,0,11,62,89,184,0,0,69,88,184,0,66,47,27,185,
0,66,0,11,62,89,184,0,0,69,88,184,0,75,47,27,
185,0,75,0,11,62,89,184,0,17,16,185,0,5,0,1,
252,184,0,28,208,184,0,29,208,186,0,48,0,0,0,17,
17,18,57,186,0,51,0,0,0,17,17,18,57,186,0,71,
0,0,0,17,17,18,57,48,49,19,53,62,1,53,17,35,
34,14,2,7,39,52,62,2,55,33,23,14,3,7,35,46,
1,43,1,17,20,22,23,21,1,34,7,19,20,22,23,21,
35,53,62,1,53,11,1,35,11,1,20,22,23,21,35,53,
62,1,53,19,46,1,35,53,51,50,22,23,27,1,62,1,
59,1,21,174,35,24,110,6,10,9,12,8,19,2,4,5,
2,1,135,12,1,1,3,4,3,17,8,11,17,105,22,38,
2,200,21,26,4,24,27,176,26,30,4,160,29,163,3,24,
27,155,26,25,4,14,26,11,115,8,7,9,150,143,9,8,
8,114,3,39,24,8,13,6,1,105,5,13,25,21,6,8,
27,30,27,7,9,9,26,28,25,8,31,33,254,151,5,14,
8,24,1,172,8,254,139,5,13,5,24,24,5,13,5,1,
51,254,158,1,96,254,207,5,13,5,24,24,5,13,5,1,
116,6,3,25,11,20,254,200,1,56,21,10,25,0,255,255,
0,45,0,0,4,113,6,14,0,38,0,70,0,0,0,7,
0,73,2,125,0,0,255,255,0,45,0,0,4,123,6,14,
0,38,0,70,0,0,0,7,0,76,2,125,0,0,0,2,
0,87,0,127,3,214,5,12,0,3,0,55,0,172,0,184,
0,21,47,184,0,28,47,184,0,0,69,88,184,0,47,47,
27,185,0,47,0,11,62,89,184,0,0,69,88,184,0,54,
47,27,185,0,54,0,11,62,89,184,0,0,69,88,184,0,
4,47,27,185,0,4,0,9,62,89,184,0,0,69,88,184,
0,42,47,27,185,0,42,0,9,62,89,184,0,0,69,88,
184,0,49,47,27,185,0,49,0,9,62,89,187,0,12,0,
2,0,16,0,4,43,184,0,12,16,184,0,0,208,184,0,
4,16,185,0,2,0,2,252,184,0,3,208,184,0,9,208,
184,0,10,208,184,0,16,16,184,0,23,208,184,0,16,16,
184,0,30,208,184,0,12,16,184,0,35,208,184,0,10,16,
184,0,37,208,184,0,38,208,48,49,1,51,19,35,37,51,
23,14,1,7,35,3,51,23,14,1,7,35,3,14,1,7,
39,19,35,3,14,1,7,39,19,35,39,62,1,55,51,19,
35,39,62,1,55,51,19,62,1,55,23,3,51,19,62,1,
55,23,1,143,189,73,188,1,77,151,25,5,18,8,178,73,
151,22,5,15,8,178,87,18,48,26,26,93,189,87,18,46,
26,26,93,147,22,5,16,9,172,73,144,25,5,18,8,171,
83,22,44,22,29,89,188,83,22,45,23,27,2,78,1,0,
115,25,22,51,17,255,0,27,20,51,17,254,207,14,20,9,
20,1,72,254,207,14,20,9,20,1,72,25,20,50,20,1,
0,24,22,49,20,1,34,16,16,9,22,254,203,1,34,16,
16,9,22,0,0,2,0,154,255,216,1,135,5,200,0,15,
0,25,0,83,187,0,0,0,4,0,8,0,4,43,65,5,
0,154,0,8,0,170,0,8,0,2,93,65,19,0,9,0,
8,0,25,0,8,0,41,0,8,0,57,0,8,0,73,0,
8,0,89,0,8,0,105,0,8,0,121,0,8,0,137,0,
8,0,9,93,0,184,0,24,47,186,0,13,0,5,0,3,
43,184,0,13,16,48,49,37,20,14,2,35,34,38,53,52,
62,2,51,50,22,39,14,1,7,39,3,62,1,55,23,1,
135,21,37,50,29,53,47,22,38,50,29,51,47,65,19,30,
25,29,47,38,84,34,43,123,35,59,44,25,58,54,34,59,
45,26,59,212,14,17,8,21,4,3,25,43,14,25,0,2,
0,160,3,45,2,199,5,200,0,12,0,25,0,19,0,184,
0,11,47,184,0,24,47,184,0,5,47,184,0,18,47,48,
49,1,14,3,35,3,62,3,55,23,1,14,3,35,3,62,
3,55,23,1,53,8,23,26,27,12,53,11,42,45,40,11,
43,1,60,8,23,27,27,12,53,11,41,46,41,11,43,3,
66,4,8,6,3,2,101,6,17,16,13,2,21,253,143,4,
8,6,3,2,101,6,17,16,13,2,21,0,0,2,0,174,
254,106,1,70,6,134,0,12,0,25,0,49,187,0,0,0,
4,0,6,0,4,43,184,0,11,208,184,0,0,16,184,0,
13,208,184,0,6,16,184,0,19,208,184,0,0,16,184,0,
24,208,0,184,0,5,47,184,0,23,47,48,49,1,14,3,
7,39,17,62,1,55,23,25,1,14,3,7,39,17,62,1,
55,23,17,1,70,10,29,32,32,12,37,29,55,31,37,10,
29,32,32,12,37,29,55,31,37,254,158,8,15,14,11,4,
23,3,104,17,25,10,25,252,154,4,97,8,15,13,11,4,
22,3,115,17,24,8,22,252,143,0,0,1,0,61,1,199,
2,117,2,57,0,10,0,17,0,187,0,9,0,2,0,3,
0,4,43,184,0,9,16,48,49,1,14,1,7,33,39,62,
1,55,33,23,2,117,6,17,8,254,0,25,5,17,9,2,
0,25,2,33,22,51,17,24,22,48,20,24,0,1,0,59,
2,108,2,83,5,81,0,43,0,0,1,33,39,62,5,53,
52,38,35,34,14,2,21,14,1,7,39,52,62,2,51,50,
30,2,21,20,14,2,7,33,50,62,2,49,23,2,73,254,
6,20,83,124,88,58,33,13,59,72,27,44,31,18,24,55,
32,18,49,83,107,58,46,77,56,31,38,88,145,108,1,17,
24,28,15,4,45,2,108,44,83,127,98,74,58,47,23,56,
65,20,32,42,21,11,15,3,18,31,68,56,37,20,42,64,
44,40,82,109,149,108,30,36,30,7,0,1,0,38,2,90,
2,75,5,81,0,65,0,0,1,20,14,2,35,34,38,39,
55,30,3,51,50,54,53,52,46,2,35,34,35,34,14,1,
7,39,62,3,53,52,46,2,35,34,6,23,14,1,7,39,
52,62,2,51,50,30,2,21,20,14,2,7,30,3,2,75,
40,76,109,68,63,130,63,23,32,55,51,50,26,82,99,31,
49,60,29,10,5,4,8,10,11,9,62,74,39,11,13,28,
45,32,53,54,8,23,64,30,19,45,76,99,55,54,78,51,
25,20,38,55,34,40,69,50,29,3,81,51,89,68,39,47,
52,41,20,27,16,6,79,77,45,61,38,16,1,2,1,46,
15,38,40,42,18,21,39,32,19,50,41,11,11,2,19,25,
57,48,32,29,47,60,30,23,46,42,35,10,4,33,51,66,
0,1,0,97,2,108,2,76,5,87,0,29,0,0,19,53,
62,3,53,17,52,38,39,46,1,14,1,7,39,62,3,55,
23,17,20,30,2,23,21,119,55,69,40,15,4,9,4,21,
39,63,46,15,29,84,87,77,23,26,12,35,65,53,2,108,
42,6,13,14,15,6,1,202,24,27,8,4,4,1,7,9,
41,7,26,29,29,11,21,253,138,6,14,15,13,6,42,0,
0,4,0,80,255,226,4,96,4,211,0,2,0,32,0,62,
0,72,0,17,0,187,0,24,0,2,0,18,0,4,43,184,
0,24,16,48,49,1,3,51,1,53,62,3,53,17,52,38,
39,46,1,14,1,7,39,62,3,55,23,17,20,30,2,23,
21,1,14,1,7,35,21,20,30,2,23,21,33,53,62,3,
61,1,33,39,1,62,1,55,23,17,51,23,5,14,1,7,
39,1,62,1,55,23,3,182,201,201,252,171,44,56,31,12,
2,8,3,17,31,50,37,12,23,67,69,63,18,20,10,28,
52,42,2,136,12,20,13,31,4,15,28,23,254,238,36,44,
23,7,254,234,19,1,24,23,51,17,20,61,15,252,220,23,
43,27,25,2,250,20,47,22,25,1,235,254,247,1,155,34,
4,11,11,12,5,1,110,20,21,6,3,4,1,6,7,33,
6,20,23,24,9,17,254,8,5,11,12,11,4,34,254,85,
15,23,8,106,4,6,7,8,4,29,29,5,9,8,8,4,
101,16,1,127,9,18,8,17,254,157,16,207,11,15,7,30,
4,179,8,19,5,28,0,3,0,80,255,226,4,96,4,211,
0,29,0,71,0,81,0,17,0,187,0,21,0,2,0,15,
0,4,43,184,0,21,16,48,49,19,53,62,3,53,17,52,
38,39,46,1,14,1,7,39,62,3,55,23,17,20,30,2,
23,21,1,33,39,62,3,53,52,38,35,34,14,2,21,14,
1,7,39,52,62,2,51,50,30,2,21,20,14,2,7,51,
50,62,2,49,23,5,14,1,7,39,1,62,1,55,23,97,
44,56,31,12,2,8,3,17,31,50,37,12,23,67,69,63,
18,20,10,28,52,42,2,128,254,107,16,100,124,70,25,47,
57,21,36,25,14,20,43,26,15,40,66,86,46,37,61,45,
25,30,71,116,86,218,19,23,12,3,36,252,220,23,43,27,
25,2,250,20,47,22,25,2,125,34,4,11,11,12,5,1,
110,20,21,6,3,4,1,6,7,33,6,20,23,24,9,17,
254,8,5,11,12,11,4,34,253,131,35,99,132,90,60,27,
45,52,16,26,33,17,9,12,2,14,25,55,45,29,16,34,
51,35,32,66,87,119,87,24,29,24,5,135,11,15,7,30,
4,179,8,19,5,28,0,4,0,80,255,226,4,96,4,211,
0,2,0,64,0,94,0,104,0,0,1,3,51,1,20,14,
2,35,34,38,39,55,30,1,51,50,54,53,52,46,2,35,
34,35,34,14,1,7,39,62,3,53,52,46,2,35,34,6,
23,14,1,7,39,52,62,2,51,50,30,2,21,20,6,7,
30,3,1,14,1,7,35,21,20,30,2,23,21,33,53,62,
3,61,1,33,39,1,62,1,55,23,17,51,23,5,14,1,
7,39,1,62,1,55,23,3,182,201,201,254,82,32,61,87,
55,50,104,51,19,51,78,42,66,79,25,39,48,23,8,4,
4,6,8,9,7,50,59,31,9,11,22,37,25,42,44,7,
19,50,24,16,36,61,79,44,43,64,40,20,63,55,32,55,
41,23,2,88,12,20,13,31,4,15,28,23,254,238,36,44,
23,7,254,234,19,1,24,23,51,17,20,61,15,252,220,23,
43,27,25,2,250,20,47,22,25,1,235,254,247,2,87,41,
71,54,31,37,42,33,33,23,64,61,36,49,30,13,1,1,
1,37,12,30,33,32,15,16,32,26,15,41,32,8,9,2,
15,20,46,39,25,23,38,48,24,36,72,17,3,27,40,53,
253,124,15,23,8,106,4,6,7,8,4,29,29,5,9,8,
8,4,101,16,1,127,9,18,8,17,254,157,16,207,11,15,
7,30,4,179,8,19,5,28,0,2,0,27,0,0,4,100,
5,10,0,22,0,58,1,204,184,0,59,47,184,0,60,47,
184,0,59,16,184,0,37,208,184,0,37,47,185,0,2,0,
4,252,184,0,4,208,184,0,4,47,184,0,60,16,184,0,
23,220,185,0,12,0,4,252,65,5,0,154,0,12,0,170,
0,12,0,2,93,65,19,0,9,0,12,0,25,0,12,0,
41,0,12,0,57,0,12,0,73,0,12,0,89,0,12,0,
105,0,12,0,121,0,12,0,137,0,12,0,9,93,184,0,
2,16,184,0,19,208,184,0,37,16,184,0,44,208,0,184,
0,0,69,88,184,0,54,47,27,185,0,54,0,11,62,89,
184,0,0,69,88,184,0,30,47,27,185,0,30,0,5,62,
89,184,0,0,69,88,184,0,32,47,27,185,0,32,0,5,
62,89,187,0,21,0,2,0,0,0,4,43,184,0,21,16,
184,0,30,16,185,0,7,0,2,252,65,33,0,7,0,7,
0,23,0,7,0,39,0,7,0,55,0,7,0,71,0,7,
0,87,0,7,0,103,0,7,0,119,0,7,0,135,0,7,
0,151,0,7,0,167,0,7,0,183,0,7,0,199,0,7,
0,215,0,7,0,231,0,7,0,247,0,7,0,16,93,65,
15,0,7,0,7,0,23,0,7,0,39,0,7,0,55,0,
7,0,71,0,7,0,87,0,7,0,103,0,7,0,7,113,
65,5,0,118,0,7,0,134,0,7,0,2,113,184,0,54,
16,185,0,17,0,2,252,65,5,0,121,0,17,0,137,0,
17,0,2,113,65,33,0,8,0,17,0,24,0,17,0,40,
0,17,0,56,0,17,0,72,0,17,0,88,0,17,0,104,
0,17,0,120,0,17,0,136,0,17,0,152,0,17,0,168,
0,17,0,184,0,17,0,200,0,17,0,216,0,17,0,232,
0,17,0,248,0,17,0,16,93,65,15,0,8,0,17,0,
24,0,17,0,40,0,17,0,56,0,17,0,72,0,17,0,
88,0,17,0,104,0,17,0,7,113,184,0,19,208,184,0,
19,47,184,0,0,16,184,0,38,208,184,0,21,16,184,0,
43,208,48,49,1,33,17,20,23,30,1,51,50,62,2,53,
52,46,2,35,34,7,17,33,23,5,20,14,4,35,33,55,
7,53,62,1,53,17,35,39,62,1,55,51,17,14,1,7,
39,62,3,51,50,30,2,2,102,254,252,10,14,81,78,69,
147,121,78,66,127,186,120,51,48,1,4,25,1,229,48,82,
109,121,126,58,254,14,2,35,68,78,146,22,5,11,6,146,
40,73,33,8,44,115,128,131,59,139,224,158,85,2,103,254,
51,22,14,17,17,68,134,199,131,143,220,150,77,3,254,14,
23,6,127,199,150,105,65,30,1,1,43,14,33,14,1,255,
25,15,34,16,1,227,5,10,5,62,12,22,17,9,80,155,
229,0,0,1,0,93,0,249,2,234,3,105,0,23,0,0,
19,55,47,1,62,1,55,23,55,30,1,23,21,7,23,21,
14,1,7,39,7,46,1,39,93,248,246,1,20,51,22,232,
233,22,51,20,247,248,20,54,18,234,234,19,54,20,1,58,
248,246,34,9,17,5,233,233,5,17,9,34,247,247,34,8,
18,5,234,234,5,18,8,0,255,255,0,0,0,0,4,152,
6,193,2,38,0,57,0,0,0,7,5,126,4,123,1,64,
0,1,0,49,0,0,3,213,4,236,0,57,1,87,184,0,
58,47,184,0,59,47,184,0,58,16,184,0,4,208,184,0,
4,47,185,0,51,0,4,252,184,0,16,208,184,0,59,16,
184,0,24,220,186,0,35,0,4,0,24,17,18,57,185,0,
43,0,4,252,65,5,0,154,0,43,0,170,0,43,0,2,
93,65,19,0,9,0,43,0,25,0,43,0,41,0,43,0,
57,0,43,0,73,0,43,0,89,0,43,0,105,0,43,0,
121,0,43,0,137,0,43,0,9,93,0,184,0,0,69,88,
184,0,9,47,27,185,0,9,0,11,62,89,184,0,0,69,
88,184,0,0,47,27,185,0,0,0,5,62,89,184,0,9,
16,184,0,48,220,65,5,0,217,0,48,0,233,0,48,0,
2,93,65,27,0,8,0,48,0,24,0,48,0,40,0,48,
0,56,0,48,0,72,0,48,0,88,0,48,0,104,0,48,
0,120,0,48,0,136,0,48,0,152,0,48,0,168,0,48,
0,184,0,48,0,200,0,48,0,13,93,185,0,19,0,2,
252,184,0,17,208,184,0,17,47,184,0,0,16,184,0,38,
220,65,27,0,7,0,38,0,23,0,38,0,39,0,38,0,
55,0,38,0,71,0,38,0,87,0,38,0,103,0,38,0,
119,0,38,0,135,0,38,0,151,0,38,0,167,0,38,0,
183,0,38,0,199,0,38,0,13,93,65,5,0,214,0,38,
0,230,0,38,0,2,93,185,0,31,0,2,252,186,0,35,
0,0,0,9,17,18,57,184,0,48,16,184,0,50,208,184,
0,50,47,48,49,51,53,62,1,53,17,52,38,39,53,33,
21,14,3,29,1,54,51,50,30,2,21,20,14,4,35,34,
38,47,1,30,1,51,50,62,2,53,52,46,2,35,34,7,
17,20,30,2,23,21,49,68,78,74,72,1,225,51,68,41,
16,64,92,108,174,123,66,39,64,85,90,91,39,46,81,34,
23,42,77,35,46,101,84,55,60,102,137,77,50,49,16,40,
68,52,43,14,33,14,4,27,12,36,14,43,43,9,16,15,
15,7,141,6,46,90,132,86,69,114,89,66,43,21,16,17,
74,19,10,35,71,106,71,83,118,76,36,3,252,193,6,14,
16,16,9,43,0,2,0,80,255,226,3,166,5,160,0,23,
0,78,2,3,184,0,79,47,184,0,80,47,184,0,24,220,
185,0,2,0,4,252,65,5,0,154,0,2,0,170,0,2,
0,2,93,65,19,0,9,0,2,0,25,0,2,0,41,0,
2,0,57,0,2,0,73,0,2,0,89,0,2,0,105,0,
2,0,121,0,2,0,137,0,2,0,9,93,184,0,0,208,
184,0,2,16,184,0,4,208,184,0,4,47,184,0,79,16,
184,0,36,208,184,0,36,47,185,0,14,0,4,252,65,19,
0,6,0,14,0,22,0,14,0,38,0,14,0,54,0,14,
0,70,0,14,0,86,0,14,0,102,0,14,0,118,0,14,
0,134,0,14,0,9,93,65,5,0,149,0,14,0,165,0,
14,0,2,93,186,0,46,0,36,0,24,17,18,57,184,0,
55,208,186,0,57,0,36,0,24,17,18,57,186,0,74,0,
36,0,24,17,18,57,0,184,0,64,47,184,0,0,69,88,
184,0,41,47,27,185,0,41,0,9,62,89,184,0,0,69,
88,184,0,31,47,27,185,0,31,0,5,62,89,184,0,41,
16,185,0,9,0,2,252,65,5,0,121,0,9,0,137,0,
9,0,2,113,65,33,0,8,0,9,0,24,0,9,0,40,
0,9,0,56,0,9,0,72,0,9,0,88,0,9,0,104,
0,9,0,120,0,9,0,136,0,9,0,152,0,9,0,168,
0,9,0,184,0,9,0,200,0,9,0,216,0,9,0,232,
0,9,0,248,0,9,0,16,93,65,15,0,8,0,9,0,
24,0,9,0,40,0,9,0,56,0,9,0,72,0,9,0,
88,0,9,0,104,0,9,0,7,113,184,0,31,16,185,0,
19,0,2,252,65,33,0,7,0,19,0,23,0,19,0,39,
0,19,0,55,0,19,0,71,0,19,0,87,0,19,0,103,
0,19,0,119,0,19,0,135,0,19,0,151,0,19,0,167,
0,19,0,183,0,19,0,199,0,19,0,215,0,19,0,231,
0,19,0,247,0,19,0,16,93,65,15,0,7,0,19,0,
23,0,19,0,39,0,19,0,55,0,19,0,71,0,19,0,
87,0,19,0,103,0,19,0,7,113,65,5,0,118,0,19,
0,134,0,19,0,2,113,186,0,46,0,31,0,64,17,18,
57,186,0,57,0,31,0,64,17,18,57,186,0,74,0,31,
0,64,17,18,57,48,49,1,52,53,52,39,46,3,35,34,
14,2,21,20,30,2,51,50,62,2,55,20,14,4,35,34,
46,2,53,52,62,2,51,50,30,2,23,46,1,39,7,46,
3,47,1,55,46,3,7,39,55,22,23,55,30,3,31,1,
7,30,3,3,18,1,19,69,85,94,43,59,91,61,31,53,
81,96,43,55,101,78,46,148,44,72,93,97,94,38,98,154,
107,57,72,119,154,81,30,64,64,60,26,29,100,71,226,19,
20,16,19,17,10,255,27,59,66,73,42,6,201,113,84,208,
24,25,17,15,13,6,238,69,99,63,30,2,39,9,9,9,
8,57,97,71,39,58,101,138,80,79,143,108,63,55,115,178,
164,116,182,138,97,61,28,72,126,174,102,99,187,144,87,21,
36,48,27,101,163,72,98,2,2,3,6,5,37,111,24,39,
27,10,6,41,72,75,78,91,4,4,4,6,4,35,103,75,
155,158,160,0,255,255,255,209,254,12,3,221,5,209,2,38,
0,89,0,0,0,7,2,158,4,49,0,0,0,2,0,55,
254,32,3,238,6,14,0,18,0,62,1,184,184,0,63,47,
184,0,64,47,184,0,19,220,185,0,0,0,4,252,65,5,
0,154,0,0,0,170,0,0,0,2,93,65,19,0,9,0,
0,0,25,0,0,0,41,0,0,0,57,0,0,0,73,0,
0,0,89,0,0,0,105,0,0,0,121,0,0,0,137,0,
0,0,9,93,184,0,63,16,184,0,41,208,184,0,41,47,
185,0,32,0,4,252,184,0,10,208,184,0,32,16,184,0,
52,208,186,0,53,0,41,0,19,17,18,57,0,184,0,51,
47,184,0,0,69,88,184,0,58,47,27,185,0,58,0,9,
62,89,184,0,0,69,88,184,0,36,47,27,185,0,36,0,
7,62,89,184,0,0,69,88,184,0,26,47,27,185,0,26,
0,5,62,89,184,0,58,16,185,0,5,0,2,252,65,5,
0,121,0,5,0,137,0,5,0,2,113,65,33,0,8,0,
5,0,24,0,5,0,40,0,5,0,56,0,5,0,72,0,
5,0,88,0,5,0,104,0,5,0,120,0,5,0,136,0,
5,0,152,0,5,0,168,0,5,0,184,0,5,0,200,0,
5,0,216,0,5,0,232,0,5,0,248,0,5,0,16,93,
65,15,0,8,0,5,0,24,0,5,0,40,0,5,0,56,
0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,7,
113,184,0,26,16,185,0,14,0,2,252,65,33,0,7,0,
14,0,23,0,14,0,39,0,14,0,55,0,14,0,71,0,
14,0,87,0,14,0,103,0,14,0,119,0,14,0,135,0,
14,0,151,0,14,0,167,0,14,0,183,0,14,0,199,0,
14,0,215,0,14,0,231,0,14,0,247,0,14,0,16,93,
65,15,0,7,0,14,0,23,0,14,0,39,0,14,0,55,
0,14,0,71,0,14,0,87,0,14,0,103,0,14,0,7,
113,65,5,0,118,0,14,0,134,0,14,0,2,113,186,0,
31,0,26,0,14,17,18,57,186,0,53,0,36,0,51,17,
18,57,48,49,1,52,46,2,35,34,14,2,7,17,30,1,
51,50,62,2,55,20,14,4,35,34,46,2,39,17,20,22,
23,21,33,53,62,1,53,17,52,46,2,39,53,62,1,55,
23,17,62,3,51,50,30,2,3,102,41,68,90,48,18,59,
73,85,44,77,141,69,57,88,62,32,136,31,56,79,96,111,
60,16,49,60,69,35,76,94,254,53,66,74,12,31,55,42,
72,120,60,37,51,100,90,76,29,68,116,84,48,1,152,99,
158,110,59,22,51,87,64,254,115,60,63,54,90,114,144,58,
123,116,103,78,45,11,26,39,29,254,63,16,32,14,43,43,
16,29,17,6,135,45,50,25,9,5,40,14,34,32,34,252,
241,61,86,55,26,64,122,174,255,255,0,0,0,0,4,174,
6,49,2,38,0,33,0,0,0,7,5,129,4,100,1,64,
255,255,0,80,255,226,3,158,5,25,2,38,0,65,0,0,
0,7,2,161,3,237,0,0,255,255,0,0,0,0,4,174,
6,189,2,38,0,33,0,0,0,7,2,163,4,90,1,64,
255,255,0,80,255,226,3,158,5,125,2,38,0,65,0,0,
0,7,2,163,3,227,0,0,255,255,0,0,254,68,4,174,
5,37,2,38,0,33,0,0,0,7,2,197,5,144,0,0,
255,255,0,80,254,68,3,158,3,192,2,38,0,65,0,0,
0,7,2,197,4,155,0,0,255,255,0,70,255,226,3,250,
6,193,2,38,0,35,0,0,0,7,5,126,4,133,1,64,
255,255,0,80,255,226,3,72,5,209,2,38,0,67,0,0,
0,7,2,158,4,9,0,0,255,255,0,70,255,226,3,250,
6,185,2,38,0,35,0,0,0,7,5,127,4,104,1,64,
255,255,0,80,255,226,3,72,5,191,2,38,0,67,0,0,
0,7,2,159,3,236,0,0,255,255,0,70,255,226,3,250,
6,100,2,38,0,35,0,0,0,7,5,130,4,105,1,64,
255,255,0,80,255,226,3,72,5,76,2,38,0,67,0,0,
0,7,2,164,3,237,0,0,255,255,0,70,255,226,3,250,
6,209,2,38,0,35,0,0,0,7,5,132,4,104,1,64,
255,255,0,80,255,226,3,72,5,195,2,38,0,67,0,0,
0,7,2,169,3,236,0,0,255,255,0,41,0,0,4,100,
6,209,2,38,0,36,0,0,0,7,5,132,4,40,1,64,
255,255,0,80,255,226,5,76,6,14,0,38,0,68,0,0,
0,7,2,178,4,141,0,0,0,2,0,27,0,0,4,100,
5,10,0,22,0,58,1,204,184,0,59,47,184,0,60,47,
184,0,59,16,184,0,37,208,184,0,37,47,185,0,2,0,
4,252,184,0,4,208,184,0,4,47,184,0,60,16,184,0,
23,220,185,0,12,0,4,252,65,5,0,154,0,12,0,170,
0,12,0,2,93,65,19,0,9,0,12,0,25,0,12,0,
41,0,12,0,57,0,12,0,73,0,12,0,89,0,12,0,
105,0,12,0,121,0,12,0,137,0,12,0,9,93,184,0,
2,16,184,0,19,208,184,0,37,16,184,0,44,208,0,184,
0,0,69,88,184,0,54,47,27,185,0,54,0,11,62,89,
184,0,0,69,88,184,0,30,47,27,185,0,30,0,5,62,
89,184,0,0,69,88,184,0,32,47,27,185,0,32,0,5,
62,89,187,0,21,0,2,0,0,0,4,43,184,0,21,16,
184,0,30,16,185,0,7,0,2,252,65,33,0,7,0,7,
0,23,0,7,0,39,0,7,0,55,0,7,0,71,0,7,
0,87,0,7,0,103,0,7,0,119,0,7,0,135,0,7,
0,151,0,7,0,167,0,7,0,183,0,7,0,199,0,7,
0,215,0,7,0,231,0,7,0,247,0,7,0,16,93,65,
15,0,7,0,7,0,23,0,7,0,39,0,7,0,55,0,
7,0,71,0,7,0,87,0,7,0,103,0,7,0,7,113,
65,5,0,118,0,7,0,134,0,7,0,2,113,184,0,54,
16,185,0,17,0,2,252,65,5,0,121,0,17,0,137,0,
17,0,2,113,65,33,0,8,0,17,0,24,0,17,0,40,
0,17,0,56,0,17,0,72,0,17,0,88,0,17,0,104,
0,17,0,120,0,17,0,136,0,17,0,152,0,17,0,168,
0,17,0,184,0,17,0,200,0,17,0,216,0,17,0,232,
0,17,0,248,0,17,0,16,93,65,15,0,8,0,17,0,
24,0,17,0,40,0,17,0,56,0,17,0,72,0,17,0,
88,0,17,0,104,0,17,0,7,113,184,0,19,208,184,0,
19,47,184,0,0,16,184,0,38,208,184,0,21,16,184,0,
43,208,48,49,1,33,17,20,23,30,1,51,50,62,2,53,
52,46,2,35,34,7,17,33,23,5,20,14,4,35,33,55,
7,53,62,1,53,17,35,39,62,1,55,51,17,14,1,7,
39,62,3,51,50,30,2,2,102,254,253,10,14,80,78,69,
147,121,78,66,127,186,120,50,48,1,3,25,1,229,51,86,
114,125,130,59,254,35,2,34,68,77,146,22,5,11,6,146,
40,72,33,9,44,115,128,131,59,139,224,158,85,2,103,254,
51,22,14,17,17,67,137,208,141,133,211,147,78,3,254,14,
23,6,125,197,151,105,67,31,1,1,43,14,33,14,1,255,
25,15,34,16,1,227,5,10,5,62,12,22,17,9,83,158,
228,0,0,2,0,80,255,225,4,39,6,14,0,19,0,81,
2,8,184,0,82,47,184,0,83,47,184,0,72,220,185,0,
19,0,4,252,184,0,1,208,184,0,82,16,184,0,38,208,
184,0,38,47,185,0,9,0,4,252,65,19,0,6,0,9,
0,22,0,9,0,38,0,9,0,54,0,9,0,70,0,9,
0,86,0,9,0,102,0,9,0,118,0,9,0,134,0,9,
0,9,93,65,5,0,149,0,9,0,165,0,9,0,2,93,
184,0,19,16,184,0,28,208,184,0,28,47,184,0,19,16,
184,0,48,208,184,0,19,16,184,0,55,208,184,0,72,16,
184,0,66,208,0,184,0,65,47,184,0,0,69,88,184,0,
45,47,27,185,0,45,0,9,62,89,184,0,0,69,88,184,
0,25,47,27,185,0,25,0,5,62,89,184,0,0,69,88,
184,0,33,47,27,185,0,33,0,5,62,89,186,0,61,0,
54,0,3,43,184,0,61,16,184,0,45,16,185,0,4,0,
2,252,65,5,0,121,0,4,0,137,0,4,0,2,113,65,
33,0,8,0,4,0,24,0,4,0,40,0,4,0,56,0,
4,0,72,0,4,0,88,0,4,0,104,0,4,0,120,0,
4,0,136,0,4,0,152,0,4,0,168,0,4,0,184,0,
4,0,200,0,4,0,216,0,4,0,232,0,4,0,248,0,
4,0,16,93,65,15,0,8,0,4,0,24,0,4,0,40,
0,4,0,56,0,4,0,72,0,4,0,88,0,4,0,104,
0,4,0,7,113,184,0,33,16,185,0,14,0,2,252,65,
33,0,7,0,14,0,23,0,14,0,39,0,14,0,55,0,
14,0,71,0,14,0,87,0,14,0,103,0,14,0,119,0,
14,0,135,0,14,0,151,0,14,0,167,0,14,0,183,0,
14,0,199,0,14,0,215,0,14,0,231,0,14,0,247,0,
14,0,16,93,65,15,0,7,0,14,0,23,0,14,0,39,
0,14,0,55,0,14,0,71,0,14,0,87,0,14,0,103,
0,14,0,7,113,65,5,0,118,0,14,0,134,0,14,0,
2,113,186,0,28,0,25,0,65,17,18,57,186,0,48,0,
45,0,4,17,18,57,184,0,54,16,185,0,49,0,2,252,
184,0,45,16,184,0,50,220,184,0,54,16,184,0,67,208,
184,0,55,16,184,0,68,208,184,0,49,16,184,0,70,208,
184,0,50,16,184,0,71,208,48,49,1,17,46,1,35,34,
14,2,21,20,30,2,51,50,62,2,55,5,14,3,35,34,
38,39,14,3,35,34,46,2,53,52,62,4,51,50,22,23,
53,33,39,62,1,55,33,53,52,46,2,39,53,62,1,55,
23,17,51,23,7,35,17,20,30,2,23,22,54,55,23,2,
233,33,120,72,64,106,77,43,49,76,91,41,34,66,65,62,
31,1,50,46,71,53,38,14,33,42,7,38,75,79,88,51,
56,118,99,63,31,58,84,104,124,70,47,93,54,254,232,23,
5,10,8,1,24,6,28,58,53,82,130,52,31,145,23,23,
145,3,6,8,6,9,51,60,13,1,16,1,202,57,63,47,
94,140,94,85,138,97,53,27,45,57,30,177,31,43,28,13,
91,109,46,74,51,28,65,122,176,111,57,122,114,102,77,44,
23,40,243,22,16,36,16,44,55,65,35,13,4,39,11,37,
17,30,254,222,25,65,252,138,35,50,34,22,7,11,9,23,
43,0,255,255,0,50,0,0,3,186,6,49,2,38,0,37,
0,0,0,7,5,129,4,3,1,64,255,255,0,80,255,226,
3,98,5,25,2,38,0,69,0,0,0,7,2,161,4,11,
0,0,255,255,0,50,0,0,3,186,6,189,2,38,0,37,
0,0,0,7,2,163,3,249,1,64,255,255,0,80,255,226,
3,98,5,125,2,38,0,69,0,0,0,7,2,163,4,1,
0,0,255,255,0,50,0,0,3,186,6,100,2,38,0,37,
0,0,0,7,5,130,3,249,1,64,255,255,0,80,255,226,
3,98,5,76,2,38,0,69,0,0,0,7,2,164,4,1,
0,0,255,255,0,50,254,68,3,186,4,236,2,38,0,37,
0,0,0,7,2,197,4,190,0,0,0,2,0,80,254,68,
3,98,3,192,0,15,0,88,1,135,187,0,59,0,4,0,
37,0,4,43,184,0,59,16,65,19,0,6,0,59,0,22,
0,59,0,38,0,59,0,54,0,59,0,70,0,59,0,86,
0,59,0,102,0,59,0,118,0,59,0,134,0,59,0,9,
93,65,5,0,149,0,59,0,165,0,59,0,2,93,184,0,
5,208,184,0,5,47,0,184,0,21,47,184,0,0,69,88,
184,0,47,47,27,185,0,47,0,9,62,89,184,0,0,69,
88,184,0,32,47,27,185,0,32,0,5,62,89,187,0,6,
0,2,0,57,0,4,43,184,0,6,16,184,0,47,16,185,
0,0,0,2,252,65,5,0,121,0,0,0,137,0,0,0,
2,113,65,33,0,8,0,0,0,24,0,0,0,40,0,0,
0,56,0,0,0,72,0,0,0,88,0,0,0,104,0,0,
0,120,0,0,0,136,0,0,0,152,0,0,0,168,0,0,
0,184,0,0,0,200,0,0,0,216,0,0,0,232,0,0,
0,248,0,0,0,16,93,65,15,0,8,0,0,0,24,0,
0,0,40,0,0,0,56,0,0,0,72,0,0,0,88,0,
0,0,104,0,0,0,7,113,184,0,32,16,185,0,64,0,
2,252,65,33,0,7,0,64,0,23,0,64,0,39,0,64,
0,55,0,64,0,71,0,64,0,87,0,64,0,103,0,64,
0,119,0,64,0,135,0,64,0,151,0,64,0,167,0,64,
0,183,0,64,0,199,0,64,0,215,0,64,0,231,0,64,
0,247,0,64,0,16,93,65,15,0,7,0,64,0,23,0,
64,0,39,0,64,0,55,0,64,0,71,0,64,0,87,0,
64,0,103,0,64,0,7,113,65,5,0,118,0,64,0,134,
0,64,0,2,113,186,0,29,0,32,0,64,17,18,57,48,
49,1,34,14,2,7,33,50,54,53,52,46,4,1,14,3,
35,34,46,2,53,52,54,55,14,1,35,34,46,2,53,52,
62,2,55,62,3,51,50,30,4,21,14,1,7,33,21,20,
30,2,51,50,62,2,55,30,1,23,14,5,21,20,30,2,
51,50,54,55,23,1,240,51,86,67,45,10,1,171,23,15,
6,17,29,46,65,1,44,21,57,60,60,25,29,59,48,30,
59,64,22,61,25,77,139,106,63,30,57,82,52,22,55,60,
59,27,66,101,76,52,33,14,18,60,32,253,242,41,76,110,
69,31,59,68,83,56,13,19,5,67,94,62,36,18,4,16,
26,35,19,25,73,42,24,3,88,40,72,102,62,15,21,18,
50,53,52,41,26,251,125,27,52,41,25,21,44,65,45,55,
134,61,4,7,66,121,171,106,67,130,116,98,36,15,29,22,
13,36,61,81,90,93,42,20,34,13,3,75,139,107,64,7,
27,54,46,7,26,8,67,104,81,61,49,39,18,26,41,29,
16,36,38,37,255,255,0,50,0,0,3,186,6,209,2,38,
0,37,0,0,0,7,5,132,3,248,1,64,255,255,0,80,
255,226,3,98,5,195,2,38,0,69,0,0,0,7,2,169,
4,0,0,0,255,255,0,70,255,226,4,121,6,185,2,38,
0,39,0,0,0,7,5,127,4,130,1,64,255,255,0,30,
254,12,3,221,5,191,2,38,0,71,0,0,0,7,2,159,
3,246,0,0,255,255,0,70,255,226,4,121,6,189,2,38,
0,39,0,0,0,7,2,163,4,131,1,64,255,255,0,30,
254,12,3,221,5,125,2,38,0,71,0,0,0,7,2,163,
3,247,0,0,255,255,0,70,255,226,4,121,6,100,2,38,
0,39,0,0,0,7,5,130,4,131,1,64,255,255,0,30,
254,12,3,221,5,76,2,38,0,71,0,0,0,7,2,164,
3,247,0,0,255,255,0,70,254,5,4,121,5,10,2,38,
0,39,0,0,0,7,2,195,4,136,0,0,255,255,0,30,
254,12,3,221,5,227,2,38,0,71,0,0,0,7,2,175,
3,223,0,0,255,255,0,50,0,0,4,246,6,185,2,38,
0,40,0,0,0,7,5,127,4,150,1,64,255,255,0,55,
0,0,4,76,7,179,2,38,0,72,0,0,0,7,5,127,
4,67,2,58,0,2,0,50,0,0,4,246,4,236,0,3,
0,59,0,215,184,0,60,47,184,0,61,47,184,0,60,16,
184,0,27,208,184,0,27,47,185,0,18,0,4,252,184,0,
0,208,184,0,61,16,184,0,5,220,185,0,2,0,4,252,
184,0,15,208,184,0,27,16,184,0,34,208,184,0,18,16,
184,0,44,208,184,0,2,16,184,0,46,208,184,0,5,16,
184,0,56,208,0,184,0,0,69,88,184,0,39,47,27,185,
0,39,0,11,62,89,184,0,0,69,88,184,0,51,47,27,
185,0,51,0,11,62,89,184,0,0,69,88,184,0,10,47,
27,185,0,10,0,5,62,89,184,0,0,69,88,184,0,22,
47,27,185,0,22,0,5,62,89,187,0,1,0,2,0,16,
0,4,43,184,0,1,16,184,0,51,16,184,0,2,220,184,
0,3,208,184,0,4,208,184,0,5,208,184,0,28,208,184,
0,29,208,184,0,2,16,185,0,46,0,2,252,184,0,33,
208,184,0,46,16,184,0,57,208,48,49,1,33,53,41,1,
35,17,20,22,23,21,33,53,62,1,53,17,33,17,20,22,
23,21,33,53,62,1,53,17,35,39,62,1,55,51,53,52,
38,39,53,33,21,14,1,29,1,33,53,52,38,39,53,33,
21,14,1,29,1,51,23,1,99,2,98,253,158,3,122,120,
73,72,254,62,68,77,253,158,72,73,254,62,68,77,123,22,
5,11,6,123,73,72,1,194,68,77,2,98,73,72,1,194,
68,77,120,25,2,193,185,252,238,12,35,14,43,43,14,33,
14,1,255,254,1,12,35,14,43,43,14,33,14,3,18,25,
15,34,16,175,12,36,14,43,43,14,34,14,175,175,12,36,
14,43,43,14,34,14,175,23,0,1,0,33,0,0,4,76,
6,14,0,66,1,37,184,0,67,47,184,0,68,47,184,0,
62,220,185,0,4,0,4,252,184,0,67,16,184,0,25,208,
184,0,25,47,185,0,16,0,4,252,184,0,25,16,184,0,
32,208,184,0,16,16,184,0,45,208,184,0,16,16,184,0,
50,208,186,0,51,0,25,0,62,17,18,57,0,184,0,44,
47,184,0,0,69,88,184,0,56,47,27,185,0,56,0,9,
62,89,184,0,0,69,88,184,0,0,47,27,185,0,0,0,
5,62,89,184,0,0,69,88,184,0,20,47,27,185,0,20,
0,5,62,89,187,0,32,0,2,0,26,0,4,43,184,0,
32,16,184,0,56,16,185,0,10,0,2,252,65,5,0,121,
0,10,0,137,0,10,0,2,113,65,33,0,8,0,10,0,
24,0,10,0,40,0,10,0,56,0,10,0,72,0,10,0,
88,0,10,0,104,0,10,0,120,0,10,0,136,0,10,0,
152,0,10,0,168,0,10,0,184,0,10,0,200,0,10,0,
216,0,10,0,232,0,10,0,248,0,10,0,16,93,65,15,
0,8,0,10,0,24,0,10,0,40,0,10,0,56,0,10,
0,72,0,10,0,88,0,10,0,104,0,10,0,7,113,184,
0,32,16,184,0,46,208,184,0,26,16,184,0,49,208,186,
0,51,0,0,0,44,17,18,57,48,49,33,53,62,1,53,
17,52,46,2,35,34,14,2,7,17,20,22,23,21,33,53,
62,1,53,17,35,39,62,1,55,51,53,52,46,2,39,53,
62,3,55,23,17,33,23,7,33,17,62,3,51,50,30,2,
21,17,20,22,23,21,2,158,72,68,15,32,48,33,35,81,
88,90,43,75,65,254,82,66,74,140,22,5,9,8,140,7,
29,56,48,42,69,59,54,29,37,1,30,22,22,254,226,43,
105,106,101,39,43,80,61,37,61,79,43,19,28,14,2,17,
61,76,44,16,36,70,105,70,254,67,15,32,14,43,43,17,
27,17,4,12,22,16,36,16,68,42,47,26,11,6,40,8,
16,19,22,15,34,254,226,25,65,254,56,64,102,72,38,26,
54,83,56,253,131,14,27,20,43,0,255,255,255,210,0,0,
2,124,6,113,2,38,0,41,0,0,0,7,5,128,3,42,
1,64,255,255,255,200,0,0,2,114,5,89,2,38,0,176,
0,0,0,7,2,160,3,32,0,0,255,255,255,223,0,0,
2,131,6,49,2,38,0,41,0,0,0,7,5,129,3,52,
1,64,255,255,255,213,0,0,2,121,5,25,2,38,0,176,
0,0,0,7,2,161,3,42,0,0,255,255,255,226,0,0,
2,108,6,189,2,38,0,41,0,0,0,7,2,163,3,42,
1,64,255,255,255,216,0,0,2,98,5,125,2,38,0,176,
0,0,0,7,2,163,3,32,0,0,255,255,0,70,254,68,
2,8,4,236,2,38,0,41,0,0,0,7,2,197,3,41,
0,0,255,255,0,70,254,68,1,244,5,76,2,38,0,73,
0,0,0,7,2,197,3,31,0,0,255,255,0,70,0,0,
2,8,6,100,2,38,0,41,0,0,0,7,5,130,3,42,
1,64,255,255,0,70,254,132,4,141,4,236,0,38,0,41,
0,0,0,7,0,42,2,98,0,0,255,255,0,70,254,12,
3,152,5,76,0,38,0,73,0,0,0,7,0,74,2,43,
0,0,255,255,255,66,254,132,2,134,6,185,2,38,0,42,
0,0,0,7,5,127,3,76,1,64,255,255,255,16,254,12,
2,64,5,191,2,38,5,99,0,0,0,7,2,159,3,6,
0,0,255,255,0,50,254,5,4,150,4,236,2,38,0,43,
0,0,0,7,2,195,4,108,0,0,255,255,0,55,254,5,
4,0,6,14,2,38,0,75,0,0,0,7,2,195,4,35,
0,0,0,1,0,55,255,246,4,0,3,192,0,53,0,126,
187,0,47,0,4,0,4,0,4,43,184,0,47,16,184,0,
15,208,0,184,0,0,69,88,184,0,14,47,27,185,0,14,
0,9,62,89,184,0,0,69,88,184,0,15,47,27,185,0,
15,0,9,62,89,184,0,0,69,88,184,0,23,47,27,185,
0,23,0,9,62,89,184,0,0,69,88,184,0,0,47,27,
185,0,0,0,5,62,89,184,0,0,69,88,184,0,41,47,
27,185,0,41,0,5,62,89,186,0,16,0,41,0,14,17,
18,57,186,0,46,0,41,0,14,17,18,57,48,49,51,53,
62,1,53,17,52,46,2,39,53,62,1,55,23,17,1,62,
1,46,1,35,53,33,21,14,1,7,9,1,30,3,55,23,
14,3,35,34,38,39,1,39,17,20,30,2,23,21,55,66,
74,11,31,55,43,69,133,51,37,1,52,33,14,19,45,26,
1,123,44,74,42,254,174,1,117,14,30,36,45,29,6,29,
57,49,39,10,42,51,22,254,135,3,7,22,44,37,43,17,
26,18,2,90,46,50,25,8,5,40,14,37,29,34,254,82,
1,47,29,35,18,6,43,43,5,23,34,254,214,254,96,16,
21,12,3,2,43,7,10,7,4,24,29,1,196,1,254,120,
8,12,13,16,12,43,255,255,0,50,0,0,3,176,6,193,
2,38,0,44,0,0,0,7,5,126,3,242,1,64,255,255,
0,60,0,0,2,110,7,187,2,38,0,76,0,0,0,7,
5,126,3,60,2,58,255,255,0,50,254,5,3,176,4,236,
2,38,0,44,0,0,0,7,2,195,3,249,0,0,255,255,
0,60,254,5,1,254,6,14,2,38,0,76,0,0,0,7,
2,195,3,37,0,0,255,255,0,50,0,0,3,176,5,219,
2,38,0,44,0,0,0,7,2,178,2,238,0,0,255,255,
0,60,0,0,3,78,6,14,0,38,0,76,0,0,0,7,
2,178,2,143,0,0,255,255,0,50,0,0,3,176,4,236,
2,38,0,44,0,0,0,7,0,114,2,88,0,0,255,255,
0,60,0,0,3,37,6,14,0,38,0,76,0,0,0,7,
0,114,2,43,0,0,0,1,0,41,0,0,3,176,4,236,
0,49,0,93,187,0,37,0,4,0,8,0,4,43,184,0,
37,16,184,0,8,16,184,0,17,208,184,0,37,16,184,0,
27,208,0,184,0,0,69,88,184,0,22,47,27,185,0,22,
0,11,62,89,184,0,0,69,88,184,0,3,47,27,185,0,
3,0,5,62,89,186,0,9,0,3,0,22,17,18,57,186,
0,28,0,3,0,22,17,18,57,185,0,42,0,2,252,48,
49,37,14,1,7,33,53,62,1,53,17,7,39,62,3,63,
1,17,52,38,39,53,33,21,14,1,21,17,37,23,14,3,
15,1,17,20,30,2,59,1,50,62,2,55,23,3,176,8,
25,8,252,171,68,77,127,27,1,10,12,13,5,113,73,72,
1,194,68,77,1,12,26,2,9,12,14,6,251,17,42,72,
55,143,46,63,48,39,21,43,244,87,128,29,43,14,33,14,
1,165,64,22,9,27,27,23,6,57,2,11,12,36,14,43,
43,14,34,14,254,69,136,25,9,24,26,23,8,127,254,70,
18,27,19,10,10,35,68,59,18,0,0,1,0,49,0,0,
2,8,6,14,0,40,0,74,187,0,36,0,4,0,6,0,
4,43,184,0,36,16,184,0,6,16,184,0,15,208,184,0,
36,16,184,0,26,208,0,184,0,25,47,184,0,0,69,88,
184,0,0,47,27,185,0,0,0,5,62,89,186,0,7,0,
0,0,25,17,18,57,186,0,27,0,0,0,25,17,18,57,
48,49,51,53,62,3,53,17,7,39,62,3,63,1,17,52,
46,2,39,53,62,1,55,23,17,55,23,14,3,15,1,17,
20,22,23,21,60,43,58,34,15,132,29,2,2,4,7,8,
138,12,32,54,42,72,120,62,36,132,28,3,3,4,7,7,
136,68,82,43,7,15,15,16,8,2,49,96,25,13,15,17,
24,21,99,2,1,45,50,25,9,5,40,14,34,32,34,253,
143,96,24,17,19,16,20,17,99,253,97,15,32,14,43,0,
255,255,0,50,255,226,5,0,6,193,2,38,0,46,0,0,
0,7,5,126,4,184,1,64,255,255,0,55,0,0,4,76,
5,209,2,38,0,78,0,0,0,7,2,158,4,96,0,0,
255,255,0,50,254,5,5,0,4,236,2,38,0,46,0,0,
0,7,2,195,4,161,0,0,255,255,0,55,254,5,4,76,
3,192,2,38,0,78,0,0,0,7,2,195,4,73,0,0,
255,255,0,50,255,226,5,0,6,209,2,38,0,46,0,0,
0,7,5,132,4,155,1,64,255,255,0,55,0,0,4,76,
5,195,2,38,0,78,0,0,0,7,2,169,4,67,0,0,
255,255,0,80,0,0,5,77,5,219,0,38,2,121,0,0,
0,7,0,78,1,1,0,0,0,1,0,49,254,132,4,100,
5,10,0,74,1,5,184,0,75,47,184,0,76,47,184,0,
0,220,185,0,30,0,4,252,184,0,75,16,184,0,51,208,
184,0,51,47,185,0,42,0,4,252,184,0,62,208,186,0,
63,0,51,0,0,17,18,57,184,0,0,16,184,0,73,208,
0,184,0,0,69,88,184,0,61,47,27,185,0,61,0,11,
62,89,184,0,0,69,88,184,0,68,47,27,185,0,68,0,
11,62,89,184,0,0,69,88,184,0,46,47,27,185,0,46,
0,5,62,89,187,0,25,0,2,0,10,0,4,43,184,0,
25,16,184,0,68,16,185,0,36,0,2,252,65,5,0,121,
0,36,0,137,0,36,0,2,113,65,33,0,8,0,36,0,
24,0,36,0,40,0,36,0,56,0,36,0,72,0,36,0,
88,0,36,0,104,0,36,0,120,0,36,0,136,0,36,0,
152,0,36,0,168,0,36,0,184,0,36,0,200,0,36,0,
216,0,36,0,232,0,36,0,248,0,36,0,16,93,65,15,
0,8,0,36,0,24,0,36,0,40,0,36,0,56,0,36,
0,72,0,36,0,88,0,36,0,104,0,36,0,7,113,186,
0,63,0,46,0,61,17,18,57,48,49,1,20,14,2,7,
14,3,35,34,46,2,53,52,62,2,55,30,3,51,50,62,
2,53,17,52,46,2,35,34,14,2,7,17,20,22,23,21,
33,53,62,1,53,17,52,46,2,39,53,62,1,55,23,17,
62,3,51,50,30,2,21,17,4,100,43,71,93,51,27,70,
77,78,36,44,88,71,45,32,44,46,15,27,62,62,60,26,
47,94,74,46,24,45,62,37,40,91,108,127,77,73,73,254,
61,68,78,6,27,56,51,68,142,54,35,77,138,126,115,54,
43,92,76,49,1,21,104,173,140,109,39,21,34,24,13,22,
33,37,16,9,32,34,30,6,27,39,25,12,60,121,183,124,
2,136,82,107,64,26,35,90,156,122,253,124,12,35,14,43,
43,14,33,14,3,158,39,49,29,15,5,43,13,39,28,35,
254,185,106,139,83,34,26,69,120,94,253,64,0,1,0,55,
254,12,3,193,3,193,0,74,1,123,184,0,75,47,184,0,
76,47,184,0,0,220,185,0,30,0,4,252,184,0,75,16,
184,0,51,208,184,0,51,47,185,0,42,0,4,252,184,0,
63,208,184,0,63,47,184,0,0,16,184,0,73,208,0,184,
0,0,69,88,184,0,61,47,27,185,0,61,0,9,62,89,
184,0,0,69,88,184,0,68,47,27,185,0,68,0,9,62,
89,184,0,0,69,88,184,0,46,47,27,185,0,46,0,5,
62,89,184,0,0,69,88,184,0,10,47,27,185,0,10,0,
7,62,89,185,0,25,0,2,252,65,33,0,7,0,25,0,
23,0,25,0,39,0,25,0,55,0,25,0,71,0,25,0,
87,0,25,0,103,0,25,0,119,0,25,0,135,0,25,0,
151,0,25,0,167,0,25,0,183,0,25,0,199,0,25,0,
215,0,25,0,231,0,25,0,247,0,25,0,16,93,65,15,
0,7,0,25,0,23,0,25,0,39,0,25,0,55,0,25,
0,71,0,25,0,87,0,25,0,103,0,25,0,7,113,65,
5,0,118,0,25,0,134,0,25,0,2,113,184,0,68,16,
185,0,36,0,2,252,65,5,0,121,0,36,0,137,0,36,
0,2,113,65,33,0,8,0,36,0,24,0,36,0,40,0,
36,0,56,0,36,0,72,0,36,0,88,0,36,0,104,0,
36,0,120,0,36,0,136,0,36,0,152,0,36,0,168,0,
36,0,184,0,36,0,200,0,36,0,216,0,36,0,232,0,
36,0,248,0,36,0,16,93,65,15,0,8,0,36,0,24,
0,36,0,40,0,36,0,56,0,36,0,72,0,36,0,88,
0,36,0,104,0,36,0,7,113,186,0,63,0,10,0,61,
17,18,57,48,49,37,20,14,2,7,14,3,35,34,46,2,
53,52,62,2,55,30,3,51,50,62,2,53,17,52,46,2,
35,34,14,2,7,17,20,22,23,21,33,53,62,1,53,17,
52,46,2,39,53,62,1,55,31,1,62,3,51,50,30,2,
21,17,3,193,37,61,78,40,27,68,68,61,19,34,79,69,
46,30,41,44,14,29,61,57,48,15,28,69,60,41,14,31,
49,35,31,77,87,95,48,76,65,254,82,66,74,6,27,56,
51,68,116,56,35,10,44,106,108,102,39,43,80,62,37,88,
117,160,111,75,32,23,34,24,12,20,30,34,15,9,31,34,
30,7,27,34,21,8,37,94,160,124,2,86,61,76,43,16,
29,66,107,78,254,67,15,32,14,43,43,17,27,17,2,95,
39,46,26,12,6,41,11,41,28,35,250,67,105,73,39,26,
54,83,56,253,115,0,255,255,0,70,255,226,4,114,6,49,
2,38,0,47,0,0,0,7,5,129,4,116,1,64,255,255,
0,80,255,226,3,182,5,25,2,38,0,79,0,0,0,7,
2,161,4,36,0,0,255,255,0,70,255,226,4,114,6,189,
2,38,0,47,0,0,0,7,2,163,4,106,1,64,255,255,
0,80,255,226,3,182,5,125,2,38,0,79,0,0,0,7,
2,163,4,26,0,0,255,255,0,70,255,226,4,114,7,17,
2,38,0,47,0,0,0,7,2,168,4,91,1,64,255,255,
0,80,255,226,3,182,5,209,2,38,0,79,0,0,0,7,
2,168,4,11,0,0,255,255,0,41,255,242,4,115,6,193,
2,38,0,50,0,0,0,7,5,126,4,39,1,64,255,255,
0,55,0,0,3,11,5,209,2,38,0,82,0,0,0,7,
2,158,3,225,0,0,255,255,0,41,254,5,4,115,5,10,
2,38,0,50,0,0,0,7,2,195,4,16,0,0,255,255,
0,55,254,5,3,11,3,192,2,38,0,82,0,0,0,7,
2,195,3,22,0,0,255,255,0,41,255,242,4,115,6,209,
2,38,0,50,0,0,0,7,5,132,4,10,1,64,255,255,
0,55,0,0,3,11,5,195,2,38,0,82,0,0,0,7,
2,169,3,196,0,0,255,255,0,117,255,226,3,117,6,193,
2,38,0,51,0,0,0,7,5,126,4,19,1,64,255,255,
0,94,255,226,2,188,5,209,2,38,0,83,0,0,0,7,
2,158,3,172,0,0,255,255,0,117,255,226,3,117,6,185,
2,38,0,51,0,0,0,7,5,127,3,246,1,64,255,255,
0,80,255,226,2,201,5,191,2,38,0,83,0,0,0,7,
2,159,3,143,0,0,255,255,0,117,254,68,3,117,5,10,
2,38,0,51,0,0,0,7,2,196,3,225,0,0,255,255,
0,94,254,68,2,188,3,192,2,38,0,83,0,0,0,7,
2,196,3,130,0,0,255,255,0,117,255,226,3,117,6,209,
2,38,0,51,0,0,0,7,5,132,3,246,1,64,255,255,
0,80,255,226,2,201,5,195,2,38,0,83,0,0,0,7,
2,169,3,143,0,0,255,255,0,10,254,68,4,59,4,236,
2,38,0,52,0,0,0,7,2,196,4,40,0,0,255,255,
0,20,254,68,2,164,5,0,2,38,0,84,0,0,0,7,
2,196,3,93,0,0,255,255,0,10,0,0,4,59,6,209,
2,38,0,52,0,0,0,7,5,132,4,36,1,64,255,255,
0,20,255,226,2,229,5,219,2,38,0,84,0,0,0,7,
2,178,2,38,0,0,0,1,0,9,0,0,4,58,4,236,
0,46,0,115,187,0,42,0,4,0,6,0,4,43,184,0,
42,16,184,0,6,16,184,0,13,208,184,0,42,16,184,0,
36,208,0,184,0,0,69,88,184,0,24,47,27,185,0,24,
0,11,62,89,184,0,0,69,88,184,0,0,47,27,185,0,
0,0,5,62,89,187,0,13,0,2,0,7,0,4,43,184,
0,13,16,184,0,24,16,185,0,14,0,2,252,184,0,35,
208,184,0,36,208,184,0,13,16,184,0,37,208,184,0,7,
16,184,0,40,208,48,49,33,53,62,3,53,17,33,39,62,
1,55,33,17,33,34,14,2,7,39,62,1,55,33,23,14,
1,7,35,46,3,35,33,17,33,23,7,33,17,20,22,23,
21,1,50,46,63,38,17,254,234,22,5,11,6,1,22,254,
213,15,25,25,32,22,43,5,17,11,3,242,30,2,16,12,
45,9,15,19,28,22,254,228,1,19,25,25,254,237,72,92,
43,9,20,19,17,7,1,244,25,15,34,16,1,209,11,36,
70,58,19,59,134,53,25,51,121,63,42,64,43,21,254,47,
22,68,254,12,13,40,19,43,0,1,0,20,255,226,2,164,
5,0,0,51,1,34,187,0,2,0,4,0,21,0,4,43,
184,0,2,16,184,0,21,16,184,0,28,208,184,0,21,16,
184,0,33,208,184,0,2,16,184,0,36,208,184,0,2,16,
184,0,48,208,0,184,0,0,69,88,184,0,35,47,27,185,
0,35,0,11,62,89,184,0,0,69,88,184,0,32,47,27,
185,0,32,0,9,62,89,184,0,0,69,88,184,0,37,47,
27,185,0,37,0,9,62,89,184,0,0,69,88,184,0,16,
47,27,185,0,16,0,5,62,89,187,0,50,0,2,0,0,
0,4,43,184,0,50,16,184,0,16,16,185,0,7,0,2,
252,65,33,0,7,0,7,0,23,0,7,0,39,0,7,0,
55,0,7,0,71,0,7,0,87,0,7,0,103,0,7,0,
119,0,7,0,135,0,7,0,151,0,7,0,167,0,7,0,
183,0,7,0,199,0,7,0,215,0,7,0,231,0,7,0,
247,0,7,0,16,93,65,15,0,7,0,7,0,23,0,7,
0,39,0,7,0,55,0,7,0,71,0,7,0,87,0,7,
0,103,0,7,0,7,113,65,5,0,118,0,7,0,134,0,
7,0,2,113,184,0,0,16,184,0,22,208,184,0,50,16,
184,0,27,208,184,0,32,16,185,0,29,0,2,252,184,0,
47,208,184,0,48,208,48,49,1,35,21,20,30,2,51,50,
54,55,23,14,3,35,34,46,2,61,1,35,39,62,1,55,
51,17,35,39,55,51,53,55,23,17,33,23,14,3,7,46,
1,43,1,17,51,23,1,254,190,11,26,41,30,35,106,78,
29,49,96,87,74,26,35,63,48,28,117,23,5,10,8,117,
129,21,78,72,119,31,1,71,29,9,27,28,27,10,24,98,
81,52,190,22,1,159,108,60,79,47,19,26,40,51,36,55,
37,19,26,59,96,70,194,22,16,36,16,1,75,28,66,246,
104,25,254,187,29,14,31,29,22,4,12,23,254,181,25,0,
255,255,0,50,255,226,4,251,6,113,2,38,0,53,0,0,
0,7,5,128,4,168,1,64,255,255,0,41,255,226,4,45,
5,89,2,38,0,85,0,0,0,7,2,160,4,36,0,0,
255,255,0,50,255,226,4,251,6,49,2,38,0,53,0,0,
0,7,5,129,4,178,1,64,255,255,0,41,255,226,4,45,
5,25,2,38,0,85,0,0,0,7,2,161,4,46,0,0,
255,255,0,50,255,226,4,251,6,189,2,38,0,53,0,0,
0,7,2,163,4,168,1,64,255,255,0,41,255,226,4,45,
5,125,2,38,0,85,0,0,0,7,2,163,4,36,0,0,
255,255,0,50,255,226,4,251,6,224,2,38,0,53,0,0,
0,7,2,167,4,168,1,64,255,255,0,41,255,226,4,45,
5,160,2,38,0,85,0,0,0,7,2,167,4,36,0,0,
255,255,0,50,255,226,4,251,7,17,2,38,0,53,0,0,
0,7,2,168,4,153,1,64,255,255,0,41,255,226,4,45,
5,209,2,38,0,85,0,0,0,7,2,168,4,21,0,0,
255,255,0,50,254,68,4,251,4,236,2,38,0,53,0,0,
0,7,2,197,4,200,0,0,255,255,0,41,254,68,4,45,
3,192,2,38,0,85,0,0,0,7,2,197,5,44,0,0,
255,255,0,20,255,226,6,166,6,185,2,38,0,55,0,0,
0,7,5,127,5,95,1,64,255,255,0,20,255,226,5,145,
5,191,2,38,0,87,0,0,0,7,2,159,4,240,0,0,
255,255,0,0,0,0,4,152,6,185,2,38,0,57,0,0,
0,7,5,127,4,94,1,64,255,255,255,209,254,12,3,221,
5,191,2,38,0,89,0,0,0,7,2,159,4,20,0,0,
255,255,0,59,0,0,3,223,6,193,2,38,0,58,0,0,
0,7,5,126,4,74,1,64,255,255,0,76,0,0,3,61,
5,209,2,38,0,90,0,0,0,7,2,158,3,255,0,0,
255,255,0,59,0,0,3,223,6,100,2,38,0,58,0,0,
0,7,5,130,4,46,1,64,255,255,0,76,0,0,3,61,
5,76,2,38,0,90,0,0,0,7,2,164,3,227,0,0,
255,255,0,59,0,0,3,223,6,209,2,38,0,58,0,0,
0,7,5,132,4,45,1,64,255,255,0,76,0,0,3,61,
5,195,2,38,0,90,0,0,0,7,2,169,3,226,0,0,
0,1,0,45,0,0,3,49,6,14,0,47,0,73,187,0,
16,0,4,0,27,0,4,43,184,0,16,16,184,0,27,16,
184,0,32,208,0,184,0,43,47,184,0,0,69,88,184,0,
31,47,27,185,0,31,0,9,62,89,184,0,0,69,88,184,
0,22,47,27,185,0,22,0,5,62,89,184,0,31,16,185,
0,28,0,2,252,48,49,1,20,14,2,7,46,3,35,34,
14,2,21,17,20,30,2,23,21,33,53,62,1,53,17,35,
39,55,51,53,52,62,2,55,62,3,51,50,30,2,3,49,
29,40,43,15,24,49,45,39,13,26,59,51,34,21,50,79,
59,254,13,69,71,134,21,78,77,32,55,72,40,27,64,63,
57,19,31,66,55,36,5,174,8,32,34,30,7,21,31,21,
11,36,92,159,124,252,110,6,12,13,17,11,43,43,12,35,
12,2,222,28,66,31,118,161,111,75,32,22,34,24,12,24,
31,32,0,2,255,246,255,226,3,181,6,14,0,20,0,69,
1,195,184,0,70,47,184,0,71,47,184,0,33,220,185,0,
0,0,4,252,65,5,0,154,0,0,0,170,0,0,0,2,
93,65,19,0,9,0,0,0,25,0,0,0,41,0,0,0,
57,0,0,0,73,0,0,0,89,0,0,0,105,0,0,0,
121,0,0,0,137,0,0,0,9,93,184,0,70,16,184,0,
45,208,184,0,45,47,185,0,11,0,4,252,184,0,22,208,
186,0,23,0,45,0,33,17,18,57,184,0,45,16,184,0,
52,208,184,0,11,16,184,0,66,208,0,184,0,62,47,184,
0,0,69,88,184,0,28,47,27,185,0,28,0,9,62,89,
184,0,0,69,88,184,0,40,47,27,185,0,40,0,5,62,
89,187,0,68,0,2,0,21,0,4,43,184,0,68,16,184,
0,28,16,185,0,5,0,2,252,65,5,0,121,0,5,0,
137,0,5,0,2,113,65,33,0,8,0,5,0,24,0,5,
0,40,0,5,0,56,0,5,0,72,0,5,0,88,0,5,
0,104,0,5,0,120,0,5,0,136,0,5,0,152,0,5,
0,168,0,5,0,184,0,5,0,200,0,5,0,216,0,5,
0,232,0,5,0,248,0,5,0,16,93,65,15,0,8,0,
5,0,24,0,5,0,40,0,5,0,56,0,5,0,72,0,
5,0,88,0,5,0,104,0,5,0,7,113,184,0,40,16,
185,0,16,0,2,252,65,33,0,7,0,16,0,23,0,16,
0,39,0,16,0,55,0,16,0,71,0,16,0,87,0,16,
0,103,0,16,0,119,0,16,0,135,0,16,0,151,0,16,
0,167,0,16,0,183,0,16,0,199,0,16,0,215,0,16,
0,231,0,16,0,247,0,16,0,16,93,65,15,0,7,0,
16,0,23,0,16,0,39,0,16,0,55,0,16,0,71,0,
16,0,87,0,16,0,103,0,16,0,7,113,65,5,0,118,
0,16,0,134,0,16,0,2,113,186,0,23,0,40,0,62,
17,18,57,184,0,21,16,184,0,46,208,184,0,68,16,184,
0,51,208,48,49,1,52,46,2,35,34,14,2,7,17,30,
3,51,50,62,2,3,33,17,62,3,51,50,30,2,21,20,
14,4,35,34,46,2,39,17,35,39,62,1,55,51,53,52,
46,2,39,53,62,1,55,30,2,23,17,33,23,3,48,42,
69,90,48,18,59,74,84,42,40,83,75,61,18,61,93,63,
32,218,254,204,50,99,91,78,29,68,115,83,46,30,58,83,
107,128,74,19,67,87,102,54,128,22,5,9,8,128,10,28,
51,41,66,120,57,5,18,13,1,1,52,22,1,152,100,155,
106,56,21,49,83,62,254,105,30,40,23,10,53,87,110,3,
22,254,99,60,88,57,28,64,121,174,109,58,122,116,104,77,
45,17,32,47,30,4,20,22,16,36,16,66,46,50,25,8,
5,40,16,33,31,5,17,11,1,254,226,25,0,3,0,30,
255,242,4,222,5,10,0,14,0,35,0,90,1,217,187,0,
19,0,4,0,74,0,4,43,184,0,19,16,187,0,49,0,
4,0,12,0,4,43,184,0,49,16,187,0,80,0,4,0,
36,0,4,43,184,0,80,16,184,0,19,16,184,0,5,208,
65,5,0,154,0,12,0,170,0,12,0,2,93,65,19,0,
9,0,12,0,25,0,12,0,41,0,12,0,57,0,12,0,
73,0,12,0,89,0,12,0,105,0,12,0,121,0,12,0,
137,0,12,0,9,93,186,0,31,0,12,0,49,17,18,57,
184,0,31,47,65,5,0,154,0,31,0,170,0,31,0,2,
93,65,19,0,9,0,31,0,25,0,31,0,41,0,31,0,
57,0,31,0,73,0,31,0,89,0,31,0,105,0,31,0,
121,0,31,0,137,0,31,0,9,93,185,0,57,0,4,252,
186,0,52,0,36,0,57,17,18,57,65,19,0,6,0,80,
0,22,0,80,0,38,0,80,0,54,0,80,0,70,0,80,
0,86,0,80,0,102,0,80,0,118,0,80,0,134,0,80,
0,9,93,65,5,0,149,0,80,0,165,0,80,0,2,93,
184,0,92,220,0,184,0,0,69,88,184,0,41,47,27,185,
0,41,0,11,62,89,184,0,0,69,88,184,0,62,47,27,
185,0,62,0,5,62,89,184,0,0,69,88,184,0,69,47,
27,185,0,69,0,5,62,89,187,0,7,0,2,0,15,0,
4,43,184,0,7,16,184,0,41,16,185,0,5,0,2,252,
184,0,62,16,185,0,26,0,2,252,65,33,0,7,0,26,
0,23,0,26,0,39,0,26,0,55,0,26,0,71,0,26,
0,87,0,26,0,103,0,26,0,119,0,26,0,135,0,26,
0,151,0,26,0,167,0,26,0,183,0,26,0,199,0,26,
0,215,0,26,0,231,0,26,0,247,0,26,0,16,93,65,
15,0,7,0,26,0,23,0,26,0,39,0,26,0,55,0,
26,0,71,0,26,0,87,0,26,0,103,0,26,0,7,113,
65,5,0,118,0,26,0,134,0,26,0,2,113,184,0,7,
16,184,0,52,208,184,0,52,47,184,0,5,16,184,0,75,
208,184,0,75,47,48,49,1,46,3,39,17,51,50,62,2,
53,52,38,3,34,6,7,17,20,23,30,3,51,50,62,2,
53,52,46,2,1,52,62,2,51,50,30,2,23,30,1,21,
20,6,7,30,3,21,20,14,2,35,34,46,4,49,35,53,
62,1,53,17,14,3,21,20,22,23,14,3,7,46,1,3,
136,24,56,74,98,67,34,114,141,78,27,39,190,48,81,36,
9,17,44,46,46,20,72,116,83,44,39,81,125,252,217,77,
145,207,130,85,135,108,84,36,45,53,102,88,64,110,81,46,
67,121,168,101,29,88,96,97,78,48,73,68,77,52,85,61,
33,38,31,3,31,44,49,21,37,48,4,112,19,26,17,7,
1,254,31,45,70,88,43,49,87,254,54,8,6,253,237,8,
7,6,7,4,2,37,66,93,56,55,116,95,61,1,98,65,
106,75,41,9,21,33,24,30,96,57,108,155,34,12,66,97,
123,69,85,137,96,52,2,3,4,3,2,43,14,33,14,4,
71,7,26,40,55,35,36,56,14,6,22,22,20,4,16,76,
0,2,0,49,255,242,3,248,4,236,0,20,0,66,1,82,
184,0,67,47,184,0,68,47,184,0,67,16,184,0,59,208,
184,0,59,47,185,0,4,0,4,252,184,0,6,208,184,0,
6,47,184,0,68,16,184,0,42,220,185,0,16,0,4,252,
65,5,0,154,0,16,0,170,0,16,0,2,93,65,19,0,
9,0,16,0,25,0,16,0,41,0,16,0,57,0,16,0,
73,0,16,0,89,0,16,0,105,0,16,0,121,0,16,0,
137,0,16,0,9,93,184,0,27,208,184,0,27,47,184,0,
4,16,184,0,33,208,0,184,0,0,69,88,184,0,26,47,
27,185,0,26,0,9,62,89,184,0,0,69,88,184,0,64,
47,27,185,0,64,0,11,62,89,184,0,0,69,88,184,0,
47,47,27,185,0,47,0,5,62,89,184,0,0,69,88,184,
0,54,47,27,185,0,54,0,5,62,89,187,0,37,0,2,
0,0,0,4,43,184,0,37,16,184,0,47,16,185,0,11,
0,2,252,65,33,0,7,0,11,0,23,0,11,0,39,0,
11,0,55,0,11,0,71,0,11,0,87,0,11,0,103,0,
11,0,119,0,11,0,135,0,11,0,151,0,11,0,167,0,
11,0,183,0,11,0,199,0,11,0,215,0,11,0,231,0,
11,0,247,0,11,0,16,93,65,15,0,7,0,11,0,23,
0,11,0,39,0,11,0,55,0,11,0,71,0,11,0,87,
0,11,0,103,0,11,0,7,113,65,5,0,118,0,11,0,
134,0,11,0,2,113,184,0,64,16,185,0,32,0,2,252,
48,49,1,34,6,7,17,20,23,30,3,51,50,62,2,53,
52,46,2,1,14,3,7,35,46,3,35,33,17,62,1,51,
50,30,2,21,20,14,2,35,34,46,4,49,35,53,62,1,
53,17,52,38,39,53,33,23,2,8,48,81,36,8,17,44,
47,46,20,72,116,83,44,39,81,125,1,85,2,10,15,17,
7,48,3,8,15,24,19,254,87,45,104,55,109,171,116,61,
67,121,168,101,29,88,96,97,78,48,74,68,78,74,72,3,
100,31,2,137,8,6,253,237,9,5,6,8,4,2,37,66,
93,56,55,116,95,61,2,74,26,80,87,84,28,64,91,58,
27,254,62,9,10,56,102,141,84,85,137,96,52,2,3,4,
3,2,43,14,33,14,4,27,12,36,14,43,25,0,0,2,
0,100,255,226,3,181,5,240,0,20,0,70,1,169,184,0,
71,47,184,0,72,47,184,0,47,220,185,0,0,0,4,252,
65,5,0,154,0,0,0,170,0,0,0,2,93,65,19,0,
9,0,0,0,25,0,0,0,41,0,0,0,57,0,0,0,
73,0,0,0,89,0,0,0,105,0,0,0,121,0,0,0,
137,0,0,0,9,93,184,0,71,16,184,0,59,208,184,0,
59,47,185,0,11,0,4,252,184,0,33,208,184,0,33,47,
184,0,11,16,184,0,36,208,186,0,37,0,59,0,47,17,
18,57,184,0,0,16,184,0,69,208,184,0,69,47,0,184,
0,0,69,88,184,0,42,47,27,185,0,42,0,9,62,89,
184,0,0,69,88,184,0,54,47,27,185,0,54,0,5,62,
89,184,0,42,16,185,0,5,0,2,252,65,5,0,121,0,
5,0,137,0,5,0,2,113,65,33,0,8,0,5,0,24,
0,5,0,40,0,5,0,56,0,5,0,72,0,5,0,88,
0,5,0,104,0,5,0,120,0,5,0,136,0,5,0,152,
0,5,0,168,0,5,0,184,0,5,0,200,0,5,0,216,
0,5,0,232,0,5,0,248,0,5,0,16,93,65,15,0,
8,0,5,0,24,0,5,0,40,0,5,0,56,0,5,0,
72,0,5,0,88,0,5,0,104,0,5,0,7,113,184,0,
54,16,185,0,16,0,2,252,65,33,0,7,0,16,0,23,
0,16,0,39,0,16,0,55,0,16,0,71,0,16,0,87,
0,16,0,103,0,16,0,119,0,16,0,135,0,16,0,151,
0,16,0,167,0,16,0,183,0,16,0,199,0,16,0,215,
0,16,0,231,0,16,0,247,0,16,0,16,93,65,15,0,
7,0,16,0,23,0,16,0,39,0,16,0,55,0,16,0,
71,0,16,0,87,0,16,0,103,0,16,0,7,113,65,5,
0,118,0,16,0,134,0,16,0,2,113,186,0,37,0,54,
0,42,17,18,57,48,49,1,52,46,2,35,34,14,2,7,
17,30,3,51,50,62,2,19,14,3,7,35,46,3,35,33,
30,1,21,17,62,3,51,50,30,2,21,20,14,4,35,34,
46,2,39,17,52,46,2,39,62,1,55,33,23,3,48,42,
69,90,48,18,59,74,84,42,40,83,75,61,18,61,93,63,
32,22,2,10,15,17,7,48,3,8,15,24,19,254,122,7,
3,50,99,91,78,29,68,115,83,46,30,58,83,107,128,74,
19,67,87,102,54,9,13,14,4,49,72,39,2,35,31,1,
152,100,155,106,56,21,49,83,62,254,105,30,40,23,10,53,
87,110,4,121,26,80,87,84,28,64,91,58,27,56,119,62,
254,46,60,88,57,28,64,121,174,109,58,122,116,104,77,45,
17,32,47,30,4,27,58,103,81,53,8,16,36,18,25,0,
0,2,0,50,255,242,3,248,5,10,0,20,0,57,1,57,
184,0,58,47,184,0,59,47,184,0,58,16,184,0,38,208,
184,0,38,47,185,0,4,0,4,252,184,0,6,208,184,0,
6,47,184,0,59,16,184,0,21,220,185,0,16,0,4,252,
65,5,0,154,0,16,0,170,0,16,0,2,93,65,19,0,
9,0,16,0,25,0,16,0,41,0,16,0,57,0,16,0,
73,0,16,0,89,0,16,0,105,0,16,0,121,0,16,0,
137,0,16,0,9,93,184,0,4,16,184,0,49,208,0,184,
0,0,69,88,184,0,49,47,27,185,0,49,0,11,62,89,
184,0,0,69,88,184,0,26,47,27,185,0,26,0,5,62,
89,184,0,0,69,88,184,0,33,47,27,185,0,33,0,5,
62,89,187,0,53,0,2,0,0,0,4,43,184,0,53,16,
184,0,26,16,185,0,11,0,2,252,65,33,0,7,0,11,
0,23,0,11,0,39,0,11,0,55,0,11,0,71,0,11,
0,87,0,11,0,103,0,11,0,119,0,11,0,135,0,11,
0,151,0,11,0,167,0,11,0,183,0,11,0,199,0,11,
0,215,0,11,0,231,0,11,0,247,0,11,0,16,93,65,
15,0,7,0,11,0,23,0,11,0,39,0,11,0,55,0,
11,0,71,0,11,0,87,0,11,0,103,0,11,0,7,113,
65,5,0,118,0,11,0,134,0,11,0,2,113,184,0,0,
16,185,0,39,0,2,252,48,49,1,34,6,7,17,20,23,
30,3,51,50,62,2,53,52,46,2,1,20,14,2,35,34,
46,4,49,35,53,62,1,53,17,52,46,2,39,53,62,1,
55,23,17,62,1,51,50,30,2,2,8,48,81,36,9,17,
44,46,46,20,72,116,83,44,39,81,125,1,153,67,121,168,
101,29,88,96,97,78,48,73,68,77,14,34,55,42,80,133,
56,36,45,104,55,109,171,116,61,2,137,8,6,253,237,8,
7,6,7,4,2,37,66,93,56,55,116,95,61,254,219,85,
137,96,52,2,3,4,3,2,43,14,33,14,2,110,23,48,
43,36,11,43,79,187,94,30,253,228,9,10,56,102,141,0,
0,2,0,10,255,226,3,201,6,14,0,20,0,54,1,149,
184,0,55,47,184,0,56,47,184,0,21,220,185,0,0,0,
4,252,65,5,0,154,0,0,0,170,0,0,0,2,93,65,
19,0,9,0,0,0,25,0,0,0,41,0,0,0,57,0,
0,0,73,0,0,0,89,0,0,0,105,0,0,0,121,0,
0,0,137,0,0,0,9,93,184,0,55,16,184,0,33,208,
184,0,33,47,185,0,11,0,4,252,184,0,44,208,186,0,
45,0,33,0,21,17,18,57,0,184,0,43,47,184,0,0,
69,88,184,0,50,47,27,185,0,50,0,9,62,89,184,0,
0,69,88,184,0,28,47,27,185,0,28,0,5,62,89,184,
0,50,16,185,0,5,0,2,252,65,5,0,121,0,5,0,
137,0,5,0,2,113,65,33,0,8,0,5,0,24,0,5,
0,40,0,5,0,56,0,5,0,72,0,5,0,88,0,5,
0,104,0,5,0,120,0,5,0,136,0,5,0,152,0,5,
0,168,0,5,0,184,0,5,0,200,0,5,0,216,0,5,
0,232,0,5,0,248,0,5,0,16,93,65,15,0,8,0,
5,0,24,0,5,0,40,0,5,0,56,0,5,0,72,0,
5,0,88,0,5,0,104,0,5,0,7,113,184,0,28,16,
185,0,16,0,2,252,65,33,0,7,0,16,0,23,0,16,
0,39,0,16,0,55,0,16,0,71,0,16,0,87,0,16,
0,103,0,16,0,119,0,16,0,135,0,16,0,151,0,16,
0,167,0,16,0,183,0,16,0,199,0,16,0,215,0,16,
0,231,0,16,0,247,0,16,0,16,93,65,15,0,7,0,
16,0,23,0,16,0,39,0,16,0,55,0,16,0,71,0,
16,0,87,0,16,0,103,0,16,0,7,113,65,5,0,118,
0,16,0,134,0,16,0,2,113,186,0,45,0,28,0,43,
17,18,57,48,49,1,52,46,2,35,34,14,2,7,17,30,
3,51,50,62,2,55,20,14,4,35,34,46,2,39,17,52,
46,2,39,53,62,1,55,23,17,62,3,51,50,30,2,3,
68,42,69,90,48,18,59,74,84,42,40,83,75,61,18,61,
93,63,32,133,30,58,83,107,128,74,19,67,87,102,54,16,
35,57,42,80,128,56,36,50,99,91,78,29,68,115,83,46,
1,152,100,155,106,56,21,49,83,62,254,105,30,40,23,10,
53,87,110,142,58,122,116,104,77,45,17,32,47,30,3,122,
23,48,43,36,11,43,79,187,94,30,252,231,60,88,57,28,
64,121,174,0,0,1,0,61,255,226,3,250,5,10,0,58,
1,187,184,0,59,47,184,0,60,47,184,0,0,220,184,0,
59,16,184,0,10,208,184,0,10,47,185,0,24,0,4,252,
65,19,0,6,0,24,0,22,0,24,0,38,0,24,0,54,
0,24,0,70,0,24,0,86,0,24,0,102,0,24,0,118,
0,24,0,134,0,24,0,9,93,65,5,0,149,0,24,0,
165,0,24,0,2,93,184,0,0,16,185,0,34,0,4,252,
65,5,0,154,0,34,0,170,0,34,0,2,93,65,19,0,
9,0,34,0,25,0,34,0,41,0,34,0,57,0,34,0,
73,0,34,0,89,0,34,0,105,0,34,0,121,0,34,0,
137,0,34,0,9,93,184,0,10,16,184,0,49,208,184,0,
49,47,0,184,0,0,69,88,184,0,54,47,27,185,0,54,
0,11,62,89,184,0,0,69,88,184,0,5,47,27,185,0,
5,0,5,62,89,185,0,29,0,2,252,65,33,0,7,0,
29,0,23,0,29,0,39,0,29,0,55,0,29,0,71,0,
29,0,87,0,29,0,103,0,29,0,119,0,29,0,135,0,
29,0,151,0,29,0,167,0,29,0,183,0,29,0,199,0,
29,0,215,0,29,0,231,0,29,0,247,0,29,0,16,93,
65,15,0,7,0,29,0,23,0,29,0,39,0,29,0,55,
0,29,0,71,0,29,0,87,0,29,0,103,0,29,0,7,
113,65,5,0,118,0,29,0,134,0,29,0,2,113,184,0,
54,16,185,0,39,0,2,252,65,5,0,121,0,39,0,137,
0,39,0,2,113,65,33,0,8,0,39,0,24,0,39,0,
40,0,39,0,56,0,39,0,72,0,39,0,88,0,39,0,
104,0,39,0,120,0,39,0,136,0,39,0,152,0,39,0,
168,0,39,0,184,0,39,0,200,0,39,0,216,0,39,0,
232,0,39,0,248,0,39,0,16,93,65,15,0,8,0,39,
0,24,0,39,0,40,0,39,0,56,0,39,0,72,0,39,
0,88,0,39,0,104,0,39,0,7,113,48,49,1,20,2,
14,1,35,34,46,2,53,52,54,55,62,3,55,23,14,3,
21,20,30,2,51,50,62,2,53,52,46,2,35,34,14,2,
7,46,3,39,62,3,51,50,30,2,3,250,85,152,207,123,
98,146,98,48,26,34,22,49,49,44,18,23,29,36,20,8,
38,69,97,59,70,132,102,62,77,121,148,72,27,67,83,101,
60,5,11,10,8,2,67,118,108,100,51,94,181,142,87,2,
166,158,254,252,187,103,56,89,108,51,42,78,38,12,21,19,
16,6,49,17,33,37,43,28,36,76,63,40,57,131,213,156,
133,199,134,67,11,31,54,42,2,13,14,13,3,67,82,45,
15,82,157,228,0,1,0,70,255,226,5,115,6,54,0,74,
1,113,187,0,31,0,4,0,54,0,4,43,184,0,31,16,
65,19,0,6,0,31,0,22,0,31,0,38,0,31,0,54,
0,31,0,70,0,31,0,86,0,31,0,102,0,31,0,118,
0,31,0,134,0,31,0,9,93,65,5,0,149,0,31,0,
165,0,31,0,2,93,0,184,0,0,69,88,184,0,59,47,
27,185,0,59,0,11,62,89,184,0,0,69,88,184,0,49,
47,27,185,0,49,0,5,62,89,187,0,70,0,2,0,10,
0,4,43,184,0,70,16,184,0,59,16,185,0,24,0,2,
252,65,5,0,121,0,24,0,137,0,24,0,2,113,65,33,
0,8,0,24,0,24,0,24,0,40,0,24,0,56,0,24,
0,72,0,24,0,88,0,24,0,104,0,24,0,120,0,24,
0,136,0,24,0,152,0,24,0,168,0,24,0,184,0,24,
0,200,0,24,0,216,0,24,0,232,0,24,0,248,0,24,
0,16,93,65,15,0,8,0,24,0,24,0,24,0,40,0,
24,0,56,0,24,0,72,0,24,0,88,0,24,0,104,0,
24,0,7,113,184,0,49,16,185,0,36,0,2,252,65,33,
0,7,0,36,0,23,0,36,0,39,0,36,0,55,0,36,
0,71,0,36,0,87,0,36,0,103,0,36,0,119,0,36,
0,135,0,36,0,151,0,36,0,167,0,36,0,183,0,36,
0,199,0,36,0,215,0,36,0,231,0,36,0,247,0,36,
0,16,93,65,15,0,7,0,36,0,23,0,36,0,39,0,
36,0,55,0,36,0,71,0,36,0,87,0,36,0,103,0,
36,0,7,113,65,5,0,118,0,36,0,134,0,36,0,2,
113,48,49,1,20,14,2,7,46,3,35,34,6,21,20,51,
22,14,2,7,39,46,1,35,34,14,4,21,20,30,2,51,
50,54,55,30,3,23,14,3,35,34,46,2,53,52,18,62,
1,51,50,22,23,62,3,55,62,1,51,50,30,2,5,115,
29,40,43,15,21,41,39,34,14,63,58,1,6,18,31,35,
12,35,51,140,91,34,81,82,76,59,35,77,121,149,71,54,
174,110,5,11,10,8,3,64,117,109,105,52,93,179,142,87,
97,166,220,123,52,91,40,7,23,33,45,29,51,111,39,43,
73,53,29,5,183,8,31,33,29,7,34,44,25,9,135,141,
1,5,30,38,38,12,6,47,60,25,54,87,124,163,104,133,
200,133,67,74,92,2,13,14,13,3,68,93,56,24,84,158,
229,145,160,1,4,184,100,15,13,39,65,57,50,25,45,47,
33,43,42,0,0,1,0,80,255,226,4,198,6,14,0,73,
1,168,184,0,74,47,184,0,75,47,184,0,16,220,184,0,
74,16,184,0,53,208,184,0,53,47,185,0,32,0,4,252,
65,19,0,6,0,32,0,22,0,32,0,38,0,32,0,54,
0,32,0,70,0,32,0,86,0,32,0,102,0,32,0,118,
0,32,0,134,0,32,0,9,93,65,5,0,149,0,32,0,
165,0,32,0,2,93,184,0,16,16,185,0,60,0,4,252,
184,0,16,16,184,0,66,208,184,0,66,47,0,184,0,0,
69,88,184,0,58,47,27,185,0,58,0,9,62,89,184,0,
0,69,88,184,0,60,47,27,185,0,60,0,9,62,89,184,
0,0,69,88,184,0,48,47,27,185,0,48,0,5,62,89,
187,0,69,0,2,0,10,0,4,43,184,0,69,16,184,0,
58,16,185,0,27,0,2,252,65,5,0,121,0,27,0,137,
0,27,0,2,113,65,33,0,8,0,27,0,24,0,27,0,
40,0,27,0,56,0,27,0,72,0,27,0,88,0,27,0,
104,0,27,0,120,0,27,0,136,0,27,0,152,0,27,0,
168,0,27,0,184,0,27,0,200,0,27,0,216,0,27,0,
232,0,27,0,248,0,27,0,16,93,65,15,0,8,0,27,
0,24,0,27,0,40,0,27,0,56,0,27,0,72,0,27,
0,88,0,27,0,104,0,27,0,7,113,184,0,48,16,185,
0,37,0,2,252,65,33,0,7,0,37,0,23,0,37,0,
39,0,37,0,55,0,37,0,71,0,37,0,87,0,37,0,
103,0,37,0,119,0,37,0,135,0,37,0,151,0,37,0,
167,0,37,0,183,0,37,0,199,0,37,0,215,0,37,0,
231,0,37,0,247,0,37,0,16,93,65,15,0,7,0,37,
0,23,0,37,0,39,0,37,0,55,0,37,0,71,0,37,
0,87,0,37,0,103,0,37,0,7,113,65,5,0,118,0,
37,0,134,0,37,0,2,113,48,49,1,20,14,2,7,46,
3,35,34,14,2,29,1,20,14,2,7,39,46,3,35,34,
14,2,21,20,30,2,51,50,62,2,55,23,14,3,35,34,
46,2,53,52,62,2,51,50,23,53,52,62,2,55,62,1,
51,50,30,2,4,198,29,40,43,15,21,41,39,34,14,32,
45,30,14,11,17,20,9,37,8,36,57,79,51,53,97,75,
45,51,85,111,60,28,48,57,75,56,39,65,99,84,80,47,
73,139,108,65,79,137,186,108,43,42,17,36,56,39,51,111,
39,43,73,53,29,5,143,8,31,33,29,7,34,44,25,9,
32,75,123,91,225,19,46,45,40,14,10,18,42,38,25,47,
94,140,94,85,138,97,53,5,24,52,48,41,77,87,45,11,
65,122,176,111,108,188,139,81,9,100,85,123,93,72,34,45,
47,33,43,42,0,2,0,27,0,0,4,100,5,10,0,22,
0,58,1,204,184,0,59,47,184,0,60,47,184,0,59,16,
184,0,37,208,184,0,37,47,185,0,2,0,4,252,184,0,
4,208,184,0,4,47,184,0,60,16,184,0,23,220,185,0,
12,0,4,252,65,5,0,154,0,12,0,170,0,12,0,2,
93,65,19,0,9,0,12,0,25,0,12,0,41,0,12,0,
57,0,12,0,73,0,12,0,89,0,12,0,105,0,12,0,
121,0,12,0,137,0,12,0,9,93,184,0,2,16,184,0,
19,208,184,0,37,16,184,0,44,208,0,184,0,0,69,88,
184,0,54,47,27,185,0,54,0,11,62,89,184,0,0,69,
88,184,0,30,47,27,185,0,30,0,5,62,89,184,0,0,
69,88,184,0,32,47,27,185,0,32,0,5,62,89,187,0,
21,0,2,0,0,0,4,43,184,0,21,16,184,0,30,16,
185,0,7,0,2,252,65,33,0,7,0,7,0,23,0,7,
0,39,0,7,0,55,0,7,0,71,0,7,0,87,0,7,
0,103,0,7,0,119,0,7,0,135,0,7,0,151,0,7,
0,167,0,7,0,183,0,7,0,199,0,7,0,215,0,7,
0,231,0,7,0,247,0,7,0,16,93,65,15,0,7,0,
7,0,23,0,7,0,39,0,7,0,55,0,7,0,71,0,
7,0,87,0,7,0,103,0,7,0,7,113,65,5,0,118,
0,7,0,134,0,7,0,2,113,184,0,54,16,185,0,17,
0,2,252,65,5,0,121,0,17,0,137,0,17,0,2,113,
65,33,0,8,0,17,0,24,0,17,0,40,0,17,0,56,
0,17,0,72,0,17,0,88,0,17,0,104,0,17,0,120,
0,17,0,136,0,17,0,152,0,17,0,168,0,17,0,184,
0,17,0,200,0,17,0,216,0,17,0,232,0,17,0,248,
0,17,0,16,93,65,15,0,8,0,17,0,24,0,17,0,
40,0,17,0,56,0,17,0,72,0,17,0,88,0,17,0,
104,0,17,0,7,113,184,0,19,208,184,0,19,47,184,0,
0,16,184,0,38,208,184,0,21,16,184,0,43,208,48,49,
1,33,17,20,23,30,1,51,50,62,2,53,52,46,2,35,
34,7,17,33,23,5,20,14,4,35,33,55,7,53,62,1,
53,17,35,39,62,1,55,51,17,14,1,7,39,62,3,51,
50,30,2,2,102,254,252,10,14,81,78,69,147,121,78,66,
127,186,120,51,48,1,4,25,1,229,48,82,109,121,126,58,
254,14,2,35,68,78,146,22,5,11,6,146,40,73,33,8,
44,115,128,131,59,139,224,158,85,2,103,254,51,22,14,17,
17,68,134,199,131,143,220,150,77,3,254,14,23,6,127,199,
150,105,65,30,1,1,43,14,33,14,1,255,25,15,34,16,
1,227,5,10,5,62,12,22,17,9,80,155,229,0,0,2,
0,30,0,0,5,74,5,10,0,21,0,63,1,86,187,0,
1,0,4,0,49,0,4,43,184,0,1,16,187,0,37,0,
4,0,11,0,4,43,184,0,37,16,187,0,53,0,4,0,
22,0,4,43,184,0,53,16,65,5,0,154,0,11,0,170,
0,11,0,2,93,65,19,0,9,0,11,0,25,0,11,0,
41,0,11,0,57,0,11,0,73,0,11,0,89,0,11,0,
105,0,11,0,121,0,11,0,137,0,11,0,9,93,65,19,
0,6,0,53,0,22,0,53,0,38,0,53,0,54,0,53,
0,70,0,53,0,86,0,53,0,102,0,53,0,118,0,53,
0,134,0,53,0,9,93,65,5,0,149,0,53,0,165,0,
53,0,2,93,184,0,37,16,184,0,65,220,0,184,0,0,
69,88,184,0,27,47,27,185,0,27,0,11,62,89,184,0,
0,69,88,184,0,44,47,27,185,0,44,0,5,62,89,184,
0,27,16,185,0,0,0,2,252,184,0,44,16,185,0,6,
0,2,252,65,33,0,7,0,6,0,23,0,6,0,39,0,
6,0,55,0,6,0,71,0,6,0,87,0,6,0,103,0,
6,0,119,0,6,0,135,0,6,0,151,0,6,0,167,0,
6,0,183,0,6,0,199,0,6,0,215,0,6,0,231,0,
6,0,247,0,6,0,16,93,65,15,0,7,0,6,0,23,
0,6,0,39,0,6,0,55,0,6,0,71,0,6,0,87,
0,6,0,103,0,6,0,7,113,65,5,0,118,0,6,0,
134,0,6,0,2,113,184,0,0,16,184,0,50,208,184,0,
50,47,48,49,1,17,20,23,30,1,51,50,62,2,53,52,
46,2,39,46,3,35,5,52,62,2,51,50,30,2,23,30,
3,21,20,14,4,35,33,53,62,1,53,17,14,1,21,20,
22,23,14,3,7,46,1,2,73,10,14,80,78,69,147,121,
78,20,43,68,48,37,78,96,120,79,253,205,92,166,231,139,
81,129,105,85,38,71,98,62,27,51,86,114,125,130,59,254,
3,68,77,121,110,38,31,3,31,44,49,21,37,48,4,182,
251,228,22,14,17,17,67,137,208,141,68,133,121,105,39,30,
40,23,10,203,76,109,69,33,10,21,33,24,45,116,134,151,
80,125,197,151,105,67,31,43,14,33,14,4,68,16,81,63,
36,56,14,6,22,22,20,4,16,76,0,2,0,110,255,242,
4,53,4,236,0,20,0,64,0,203,0,184,0,0,69,88,
184,0,54,47,27,185,0,54,0,11,62,89,184,0,0,69,
88,184,0,28,47,27,185,0,28,0,5,62,89,184,0,0,
69,88,184,0,21,47,27,185,0,21,0,5,62,89,187,0,
38,0,2,0,11,0,4,43,184,0,38,16,184,0,28,16,
185,0,0,0,2,252,65,33,0,7,0,0,0,23,0,0,
0,39,0,0,0,55,0,0,0,71,0,0,0,87,0,0,
0,103,0,0,0,119,0,0,0,135,0,0,0,151,0,0,
0,167,0,0,0,183,0,0,0,199,0,0,0,215,0,0,
0,231,0,0,0,247,0,0,0,16,93,65,15,0,7,0,
0,0,23,0,0,0,39,0,0,0,55,0,0,0,71,0,
0,0,87,0,0,0,103,0,0,0,7,113,65,5,0,118,
0,0,0,134,0,0,0,2,113,184,0,54,16,185,0,42,
0,2,252,48,49,37,50,62,2,55,54,53,17,46,1,35,
34,14,2,21,20,30,2,5,48,14,4,35,34,46,2,53,
52,62,2,51,50,22,23,17,33,34,14,2,7,39,52,62,
2,55,33,21,14,1,21,17,20,22,23,21,2,77,19,46,
47,44,17,9,37,80,48,87,126,81,38,44,83,116,1,230,
48,78,97,96,88,29,101,168,121,67,61,116,170,110,55,104,
45,254,105,15,28,29,35,22,43,6,10,12,5,3,84,72,
74,78,68,70,2,4,8,6,6,8,2,19,6,8,45,77,
100,55,64,110,81,47,70,2,3,4,3,2,43,89,135,93,
77,142,109,65,10,9,1,194,33,62,92,58,19,29,87,90,
84,26,43,14,36,12,251,229,14,33,14,43,0,2,0,80,
255,226,4,27,6,4,0,19,0,82,1,206,184,0,83,47,
184,0,84,47,184,0,73,220,185,0,19,0,4,252,184,0,
1,208,184,0,83,16,184,0,38,208,184,0,38,47,185,0,
9,0,4,252,65,19,0,6,0,9,0,22,0,9,0,38,
0,9,0,54,0,9,0,70,0,9,0,86,0,9,0,102,
0,9,0,118,0,9,0,134,0,9,0,9,93,65,5,0,
149,0,9,0,165,0,9,0,2,93,184,0,19,16,184,0,
28,208,184,0,28,47,184,0,19,16,184,0,48,208,184,0,
19,16,184,0,52,208,184,0,52,47,184,0,9,16,184,0,
64,208,184,0,64,47,0,184,0,0,69,88,184,0,45,47,
27,185,0,45,0,9,62,89,184,0,0,69,88,184,0,25,
47,27,185,0,25,0,5,62,89,184,0,0,69,88,184,0,
33,47,27,185,0,33,0,5,62,89,184,0,45,16,185,0,
4,0,2,252,65,5,0,121,0,4,0,137,0,4,0,2,
113,65,33,0,8,0,4,0,24,0,4,0,40,0,4,0,
56,0,4,0,72,0,4,0,88,0,4,0,104,0,4,0,
120,0,4,0,136,0,4,0,152,0,4,0,168,0,4,0,
184,0,4,0,200,0,4,0,216,0,4,0,232,0,4,0,
248,0,4,0,16,93,65,15,0,8,0,4,0,24,0,4,
0,40,0,4,0,56,0,4,0,72,0,4,0,88,0,4,
0,104,0,4,0,7,113,184,0,33,16,185,0,14,0,2,
252,65,33,0,7,0,14,0,23,0,14,0,39,0,14,0,
55,0,14,0,71,0,14,0,87,0,14,0,103,0,14,0,
119,0,14,0,135,0,14,0,151,0,14,0,167,0,14,0,
183,0,14,0,199,0,14,0,215,0,14,0,231,0,14,0,
247,0,14,0,16,93,65,15,0,7,0,14,0,23,0,14,
0,39,0,14,0,55,0,14,0,71,0,14,0,87,0,14,
0,103,0,14,0,7,113,65,5,0,118,0,14,0,134,0,
14,0,2,113,186,0,28,0,25,0,45,17,18,57,186,0,
48,0,45,0,4,17,18,57,48,49,1,17,46,1,35,34,
14,2,21,20,30,2,51,50,62,2,55,5,14,3,35,34,
38,39,14,3,35,34,46,2,53,52,62,4,51,50,22,23,
53,52,54,55,33,34,14,2,7,39,52,62,2,55,33,50,
54,55,23,14,1,21,17,20,30,2,23,22,54,55,23,2,
233,33,120,72,64,106,77,43,49,76,91,41,34,66,65,62,
31,1,50,46,71,53,38,14,33,42,7,38,75,79,88,51,
56,118,99,63,31,58,84,104,124,70,47,93,54,1,4,254,
134,15,28,29,35,22,43,6,10,12,5,1,199,57,101,38,
31,17,3,3,6,8,6,9,51,60,13,1,16,1,202,57,
63,47,94,140,94,85,138,97,53,27,45,57,30,177,31,43,
27,13,90,109,46,74,51,28,65,122,176,111,57,122,114,102,
77,44,23,40,238,74,147,74,33,62,92,58,19,29,87,90,
84,26,14,6,30,85,177,86,252,116,35,50,34,22,7,11,
9,23,43,0,0,2,0,80,254,12,3,147,3,192,0,17,
0,81,1,230,187,0,0,0,4,0,42,0,4,43,187,0,
64,0,4,0,8,0,4,43,184,0,64,16,65,19,0,6,
0,0,0,22,0,0,0,38,0,0,0,54,0,0,0,70,
0,0,0,86,0,0,0,102,0,0,0,118,0,0,0,134,
0,0,0,9,93,65,5,0,149,0,0,0,165,0,0,0,
2,93,65,5,0,154,0,8,0,170,0,8,0,2,93,65,
19,0,9,0,8,0,25,0,8,0,41,0,8,0,57,0,
8,0,73,0,8,0,89,0,8,0,105,0,8,0,121,0,
8,0,137,0,8,0,9,93,184,0,8,16,184,0,33,208,
184,0,33,47,184,0,8,16,185,0,54,0,4,252,186,0,
59,0,42,0,54,17,18,57,184,0,64,16,184,0,83,220,
0,184,0,0,69,88,184,0,49,47,27,185,0,49,0,9,
62,89,184,0,0,69,88,184,0,69,47,27,185,0,69,0,
7,62,89,184,0,0,69,88,184,0,79,47,27,185,0,79,
0,7,62,89,184,0,49,16,185,0,13,0,2,252,65,5,
0,121,0,13,0,137,0,13,0,2,113,65,33,0,8,0,
13,0,24,0,13,0,40,0,13,0,56,0,13,0,72,0,
13,0,88,0,13,0,104,0,13,0,120,0,13,0,136,0,
13,0,152,0,13,0,168,0,13,0,184,0,13,0,200,0,
13,0,216,0,13,0,232,0,13,0,248,0,13,0,16,93,
65,15,0,8,0,13,0,24,0,13,0,40,0,13,0,56,
0,13,0,72,0,13,0,88,0,13,0,104,0,13,0,7,
113,184,0,69,16,185,0,28,0,2,252,65,33,0,7,0,
28,0,23,0,28,0,39,0,28,0,55,0,28,0,71,0,
28,0,87,0,28,0,103,0,28,0,119,0,28,0,135,0,
28,0,151,0,28,0,167,0,28,0,183,0,28,0,199,0,
28,0,215,0,28,0,231,0,28,0,247,0,28,0,16,93,
65,15,0,7,0,28,0,23,0,28,0,39,0,28,0,55,
0,28,0,71,0,28,0,87,0,28,0,103,0,28,0,7,
113,65,5,0,118,0,28,0,134,0,28,0,2,113,186,0,
59,0,69,0,49,17,18,57,48,49,19,20,30,2,23,62,
1,53,52,46,2,35,34,14,2,3,62,3,51,50,30,2,
51,50,62,2,53,52,46,6,53,52,62,4,51,50,30,2,
21,20,14,2,7,30,3,21,20,14,2,35,34,46,2,35,
34,14,2,7,46,1,235,58,95,120,63,94,95,45,81,112,
66,44,80,61,36,140,33,64,55,41,10,18,83,104,109,45,
18,39,32,21,59,97,123,129,123,97,59,34,59,81,96,106,
54,102,152,101,50,37,67,95,57,47,83,63,36,44,72,92,
49,68,107,92,84,43,13,32,31,30,10,7,9,2,31,101,
146,108,80,34,63,189,117,75,142,109,67,43,77,108,251,213,
36,62,46,26,38,45,38,16,28,40,24,49,76,67,63,72,
88,115,149,97,61,120,108,92,67,38,77,129,167,89,79,138,
118,98,39,26,54,66,82,52,46,89,69,42,13,17,13,6,
11,14,7,5,17,0,0,1,0,65,0,0,3,186,4,236,
0,60,0,105,187,0,28,0,4,0,13,0,4,43,184,0,
28,16,184,0,13,16,184,0,52,208,184,0,28,16,184,0,
62,220,0,184,0,0,69,88,184,0,23,47,27,185,0,23,
0,11,62,89,184,0,0,69,88,184,0,33,47,27,185,0,
33,0,5,62,89,187,0,12,0,2,0,53,0,4,43,184,
0,12,16,184,0,9,208,184,0,23,16,185,0,13,0,2,
252,184,0,33,16,185,0,46,0,2,252,48,49,19,62,3,
55,30,2,51,50,59,1,17,35,34,14,2,7,39,62,1,
55,33,21,14,1,21,17,20,22,23,21,33,39,62,3,55,
51,30,3,59,1,50,62,2,53,17,35,34,14,2,7,39,
218,8,23,25,25,11,15,35,45,30,31,42,141,243,46,65,
50,41,21,43,7,26,8,3,5,68,77,73,72,252,168,33,
1,12,16,16,6,45,2,10,16,26,18,215,64,79,44,14,
210,23,55,53,48,16,26,2,151,14,31,29,25,8,15,14,
6,1,179,10,35,69,58,18,86,129,29,43,14,33,14,251,
229,12,36,14,43,25,25,84,87,77,19,46,83,62,36,8,
17,28,20,1,236,3,6,7,4,28,0,2,0,80,255,226,
4,18,5,10,0,13,0,60,1,209,184,0,61,47,184,0,
62,47,184,0,14,220,185,0,36,0,4,252,65,5,0,154,
0,36,0,170,0,36,0,2,93,65,19,0,9,0,36,0,
25,0,36,0,41,0,36,0,57,0,36,0,73,0,36,0,
89,0,36,0,105,0,36,0,121,0,36,0,137,0,36,0,
9,93,184,0,5,208,184,0,5,47,184,0,61,16,184,0,
24,208,184,0,24,47,185,0,9,0,4,252,65,19,0,6,
0,9,0,22,0,9,0,38,0,9,0,54,0,9,0,70,
0,9,0,86,0,9,0,102,0,9,0,118,0,9,0,134,
0,9,0,9,93,65,5,0,149,0,9,0,165,0,9,0,
2,93,184,0,36,16,184,0,33,208,184,0,33,47,0,184,
0,0,69,88,184,0,56,47,27,185,0,56,0,11,62,89,
184,0,0,69,88,184,0,19,47,27,185,0,19,0,5,62,
89,187,0,33,0,2,0,5,0,4,43,184,0,33,16,184,
0,19,16,185,0,0,0,2,252,65,33,0,7,0,0,0,
23,0,0,0,39,0,0,0,55,0,0,0,71,0,0,0,
87,0,0,0,103,0,0,0,119,0,0,0,135,0,0,0,
151,0,0,0,167,0,0,0,183,0,0,0,199,0,0,0,
215,0,0,0,231,0,0,0,247,0,0,0,16,93,65,15,
0,7,0,0,0,23,0,0,0,39,0,0,0,55,0,0,
0,71,0,0,0,87,0,0,0,103,0,0,0,7,113,65,
5,0,118,0,0,0,134,0,0,0,2,113,184,0,56,16,
185,0,41,0,2,252,65,5,0,121,0,41,0,137,0,41,
0,2,113,65,33,0,8,0,41,0,24,0,41,0,40,0,
41,0,56,0,41,0,72,0,41,0,88,0,41,0,104,0,
41,0,120,0,41,0,136,0,41,0,152,0,41,0,168,0,
41,0,184,0,41,0,200,0,41,0,216,0,41,0,232,0,
41,0,248,0,41,0,16,93,65,15,0,8,0,41,0,24,
0,41,0,40,0,41,0,56,0,41,0,72,0,41,0,88,
0,41,0,104,0,41,0,7,113,48,49,37,50,62,2,55,
33,34,6,21,20,30,2,1,20,2,14,1,35,34,46,2,
53,52,54,55,62,3,51,33,52,54,53,52,46,2,35,34,
14,2,7,46,3,39,62,3,51,50,30,2,2,28,62,112,
90,63,12,253,209,29,39,46,78,105,2,49,79,144,201,123,
98,154,107,56,13,22,23,61,56,44,7,2,67,1,77,121,
148,72,27,67,83,101,60,5,11,10,8,2,67,118,108,100,
51,94,181,142,87,84,43,99,158,116,65,56,54,106,84,51,
2,82,158,254,252,187,103,70,111,137,66,35,82,31,14,31,
26,17,12,25,14,133,199,134,67,11,31,54,42,2,13,14,
13,3,67,82,45,15,82,157,228,0,0,1,0,80,255,226,
3,195,5,10,0,63,1,143,187,0,52,0,4,0,10,0,
4,43,184,0,52,16,65,19,0,6,0,52,0,22,0,52,
0,38,0,52,0,54,0,52,0,70,0,52,0,86,0,52,
0,102,0,52,0,118,0,52,0,134,0,52,0,9,93,65,
5,0,149,0,52,0,165,0,52,0,2,93,186,0,18,0,
10,0,52,17,18,57,184,0,18,47,185,0,41,0,4,252,
0,184,0,0,69,88,184,0,24,47,27,185,0,24,0,11,
62,89,184,0,0,69,88,184,0,5,47,27,185,0,5,0,
5,62,89,187,0,46,0,2,0,47,0,4,43,184,0,46,
16,186,0,15,0,47,0,46,17,18,57,184,0,24,16,185,
0,36,0,2,252,65,5,0,121,0,36,0,137,0,36,0,
2,113,65,33,0,8,0,36,0,24,0,36,0,40,0,36,
0,56,0,36,0,72,0,36,0,88,0,36,0,104,0,36,
0,120,0,36,0,136,0,36,0,152,0,36,0,168,0,36,
0,184,0,36,0,200,0,36,0,216,0,36,0,232,0,36,
0,248,0,36,0,16,93,65,15,0,8,0,36,0,24,0,
36,0,40,0,36,0,56,0,36,0,72,0,36,0,88,0,
36,0,104,0,36,0,7,113,184,0,5,16,185,0,57,0,
2,252,65,33,0,7,0,57,0,23,0,57,0,39,0,57,
0,55,0,57,0,71,0,57,0,87,0,57,0,103,0,57,
0,119,0,57,0,135,0,57,0,151,0,57,0,167,0,57,
0,183,0,57,0,199,0,57,0,215,0,57,0,231,0,57,
0,247,0,57,0,16,93,65,15,0,7,0,57,0,23,0,
57,0,39,0,57,0,55,0,57,0,71,0,57,0,87,0,
57,0,103,0,57,0,7,113,65,5,0,118,0,57,0,134,
0,57,0,2,113,48,49,37,14,3,35,34,46,2,53,52,
62,2,55,46,1,53,52,54,55,62,1,51,50,22,23,14,
1,7,39,46,3,35,34,14,2,21,20,30,2,23,21,14,
3,21,20,30,2,51,50,62,2,55,23,3,195,61,116,122,
131,76,92,141,95,49,39,66,85,47,96,108,96,90,65,136,
88,108,183,65,17,47,26,43,32,60,66,74,44,55,102,79,
47,33,85,147,114,103,149,96,45,47,83,111,64,49,82,84,
97,65,43,213,68,93,57,25,60,93,110,50,58,109,93,71,
21,34,137,99,87,156,54,40,48,50,54,34,58,29,8,27,
41,27,14,37,66,89,52,41,80,66,44,5,71,7,58,81,
96,45,54,91,66,37,11,34,64,53,45,0,0,1,255,11,
254,132,3,129,4,236,0,64,0,80,187,0,0,0,4,0,
30,0,4,43,184,0,49,208,184,0,0,16,184,0,63,208,
0,184,0,0,69,88,184,0,35,47,27,185,0,35,0,11,
62,89,187,0,25,0,2,0,10,0,4,43,184,0,25,16,
187,0,50,0,2,0,63,0,4,43,184,0,50,16,184,0,
35,16,185,0,48,0,2,252,48,49,37,20,14,2,7,14,
3,35,34,46,2,53,52,62,2,55,30,3,51,50,62,2,
53,17,52,38,39,53,33,23,14,3,7,35,46,3,35,33,
17,33,23,14,3,7,46,3,43,1,17,1,99,34,55,72,
38,27,66,65,59,19,30,60,46,29,26,36,40,14,28,42,
36,33,19,25,59,49,33,73,72,3,48,31,1,8,11,13,
6,47,2,11,21,29,19,254,138,1,118,29,9,24,26,25,
10,15,34,45,61,42,112,178,110,150,104,71,31,21,34,24,
13,19,25,27,9,8,30,30,27,5,18,23,12,4,32,81,
140,108,4,27,12,36,14,43,25,26,62,62,56,19,46,62,
37,15,254,77,28,14,31,29,25,8,15,20,14,6,254,35,
0,1,0,70,255,226,5,160,6,54,0,93,1,215,184,0,
94,47,184,0,95,47,184,0,44,220,184,0,0,208,184,0,
0,47,184,0,94,16,184,0,54,208,184,0,54,47,185,0,
18,0,4,252,65,19,0,6,0,18,0,22,0,18,0,38,
0,18,0,54,0,18,0,70,0,18,0,86,0,18,0,102,
0,18,0,118,0,18,0,134,0,18,0,9,93,65,5,0,
149,0,18,0,165,0,18,0,2,93,184,0,44,16,185,0,
26,0,4,252,184,0,44,16,184,0,38,208,184,0,44,16,
184,0,42,208,184,0,42,47,184,0,44,16,184,0,67,208,
184,0,67,47,184,0,44,16,184,0,88,208,184,0,88,47,
184,0,44,16,184,0,90,208,184,0,90,47,184,0,44,16,
184,0,92,208,184,0,92,47,0,184,0,0,69,88,184,0,
59,47,27,185,0,59,0,11,62,89,184,0,0,69,88,184,
0,49,47,27,185,0,49,0,5,62,89,187,0,70,0,2,
0,85,0,4,43,184,0,70,16,184,0,59,16,185,0,11,
0,2,252,65,5,0,121,0,11,0,137,0,11,0,2,113,
65,33,0,8,0,11,0,24,0,11,0,40,0,11,0,56,
0,11,0,72,0,11,0,88,0,11,0,104,0,11,0,120,
0,11,0,136,0,11,0,152,0,11,0,168,0,11,0,184,
0,11,0,200,0,11,0,216,0,11,0,232,0,11,0,248,
0,11,0,16,93,65,15,0,8,0,11,0,24,0,11,0,
40,0,11,0,56,0,11,0,72,0,11,0,88,0,11,0,
104,0,11,0,7,113,184,0,49,16,185,0,23,0,2,252,
65,33,0,7,0,23,0,23,0,23,0,39,0,23,0,55,
0,23,0,71,0,23,0,87,0,23,0,103,0,23,0,119,
0,23,0,135,0,23,0,151,0,23,0,167,0,23,0,183,
0,23,0,199,0,23,0,215,0,23,0,231,0,23,0,247,
0,23,0,16,93,65,15,0,7,0,23,0,23,0,23,0,
39,0,23,0,55,0,23,0,71,0,23,0,87,0,23,0,
103,0,23,0,7,113,65,5,0,118,0,23,0,134,0,23,
0,2,113,48,49,1,22,14,2,7,39,46,3,35,34,14,
4,21,20,30,2,51,50,54,55,17,52,46,2,39,53,33,
21,14,1,21,17,48,6,7,22,23,14,3,35,34,46,2,
53,52,18,62,1,51,50,22,23,62,3,55,62,1,51,50,
30,2,21,20,14,2,7,46,3,35,34,6,21,34,21,48,
35,51,4,18,7,18,33,39,13,33,33,70,77,86,49,25,
75,83,84,66,42,75,120,151,76,73,123,49,19,47,79,61,
1,205,57,48,2,2,2,2,74,117,98,88,45,101,196,155,
96,105,182,243,137,35,87,45,7,22,34,45,29,51,111,39,
43,73,53,29,29,40,43,15,21,41,39,34,14,63,58,1,
1,1,4,164,5,29,36,35,12,6,31,41,22,9,23,51,
83,121,161,104,139,206,135,67,29,27,1,83,11,21,20,20,
10,43,43,14,45,23,254,187,2,1,1,2,61,72,39,12,
75,153,229,155,166,1,7,183,96,16,15,39,66,57,52,25,
45,47,33,43,42,9,8,31,33,29,7,34,44,25,9,135,
143,1,0,2,0,20,255,226,4,169,4,236,0,14,0,67,
0,154,187,0,7,0,3,0,37,0,4,43,184,0,7,16,
65,19,0,6,0,7,0,22,0,7,0,38,0,7,0,54,
0,7,0,70,0,7,0,86,0,7,0,102,0,7,0,118,
0,7,0,134,0,7,0,9,93,65,5,0,149,0,7,0,
165,0,7,0,2,93,184,0,37,16,184,0,51,208,184,0,
51,47,0,184,0,0,69,88,184,0,50,47,27,185,0,50,
0,11,62,89,184,0,0,69,88,184,0,65,47,27,185,0,
65,0,11,62,89,184,0,0,69,88,184,0,32,47,27,185,
0,32,0,5,62,89,186,0,5,0,32,0,50,17,18,57,
186,0,58,0,32,0,50,17,18,57,48,49,37,52,46,2,
39,6,21,20,30,2,51,50,54,1,14,3,7,1,23,30,
3,21,20,14,2,35,34,46,2,53,52,62,2,63,1,1,
46,3,39,53,33,21,14,2,22,23,9,1,62,1,46,1,
39,53,33,21,2,182,9,20,33,25,79,15,24,32,17,31,
47,1,243,33,39,29,25,19,254,163,16,34,45,27,11,27,
56,86,60,37,70,55,33,9,21,33,23,50,254,134,16,27,
31,42,30,1,135,39,42,13,13,16,1,31,1,31,18,12,
15,43,37,1,82,168,16,37,49,64,44,124,55,35,46,29,
12,45,4,71,6,10,21,36,31,253,179,27,56,83,65,52,
26,41,86,72,46,28,53,76,49,25,47,51,61,39,84,2,
120,27,36,23,13,3,43,43,5,13,22,35,27,254,30,1,
224,30,36,21,11,6,43,43,0,1,0,55,255,226,6,19,
6,14,0,87,1,213,187,0,26,0,4,0,35,0,4,43,
184,0,26,16,187,0,60,0,4,0,13,0,4,43,184,0,
60,16,187,0,0,0,4,0,72,0,4,43,184,0,0,16,
184,0,13,16,184,0,15,208,184,0,26,16,184,0,48,208,
186,0,49,0,35,0,0,17,18,57,184,0,60,16,184,0,
62,208,184,0,62,47,65,5,0,154,0,72,0,170,0,72,
0,2,93,65,19,0,9,0,72,0,25,0,72,0,41,0,
72,0,57,0,72,0,73,0,72,0,89,0,72,0,105,0,
72,0,121,0,72,0,137,0,72,0,9,93,0,184,0,47,
47,184,0,0,69,88,184,0,54,47,27,185,0,54,0,9,
62,89,184,0,0,69,88,184,0,83,47,27,185,0,83,0,
9,62,89,184,0,0,69,88,184,0,30,47,27,185,0,30,
0,5,62,89,184,0,0,69,88,184,0,7,47,27,185,0,
7,0,5,62,89,184,0,54,16,185,0,20,0,2,252,65,
5,0,121,0,20,0,137,0,20,0,2,113,65,33,0,8,
0,20,0,24,0,20,0,40,0,20,0,56,0,20,0,72,
0,20,0,88,0,20,0,104,0,20,0,120,0,20,0,136,
0,20,0,152,0,20,0,168,0,20,0,184,0,20,0,200,
0,20,0,216,0,20,0,232,0,20,0,248,0,20,0,16,
93,65,15,0,8,0,20,0,24,0,20,0,40,0,20,0,
56,0,20,0,72,0,20,0,88,0,20,0,104,0,20,0,
7,113,186,0,49,0,7,0,47,17,18,57,184,0,7,16,
185,0,67,0,2,252,65,33,0,7,0,67,0,23,0,67,
0,39,0,67,0,55,0,67,0,71,0,67,0,87,0,67,
0,103,0,67,0,119,0,67,0,135,0,67,0,151,0,67,
0,167,0,67,0,183,0,67,0,199,0,67,0,215,0,67,
0,231,0,67,0,247,0,67,0,16,93,65,15,0,7,0,
67,0,23,0,67,0,39,0,67,0,55,0,67,0,71,0,
67,0,87,0,67,0,103,0,67,0,7,113,65,5,0,118,
0,67,0,134,0,67,0,2,113,48,49,1,20,14,4,35,
34,46,2,61,3,52,46,2,35,34,14,2,7,17,20,22,
23,21,33,53,62,1,53,17,52,46,2,39,53,62,3,55,
23,17,62,3,51,50,30,2,21,17,35,21,20,30,2,51,
50,62,2,53,52,46,2,47,1,62,3,55,30,3,6,19,
35,63,87,102,113,58,57,104,79,47,15,32,48,33,35,81,
88,90,43,75,65,254,82,66,74,7,29,56,48,42,69,59,
54,29,37,43,105,106,101,39,43,80,61,37,1,30,51,67,
37,73,100,62,27,29,62,96,67,16,16,52,56,53,17,43,
81,63,38,1,248,70,133,119,99,73,40,29,73,123,94,232,
9,103,61,76,44,16,36,70,105,70,254,67,15,32,14,43,
43,17,27,17,4,170,42,47,26,11,6,40,8,16,19,22,
15,34,252,192,64,102,72,38,26,54,83,56,254,225,112,69,
97,60,28,65,104,129,65,77,144,113,69,2,41,7,18,17,
16,5,14,72,114,156,0,1,0,50,255,226,2,161,5,10,
0,31,0,51,187,0,20,0,4,0,8,0,4,43,184,0,
20,16,0,184,0,0,69,88,184,0,18,47,27,185,0,18,
0,11,62,89,184,0,0,69,88,184,0,5,47,27,185,0,
5,0,5,62,89,48,49,37,14,3,35,34,38,53,17,52,
46,2,39,53,62,1,55,51,17,20,30,2,51,50,62,2,
55,23,2,161,68,95,70,54,26,63,62,4,33,76,72,85,
158,66,37,6,15,28,22,7,28,45,65,43,18,178,65,81,
45,17,151,160,2,142,69,82,47,21,6,43,17,37,33,252,
149,90,113,62,22,6,19,37,31,43,0,1,0,48,0,0,
2,33,4,236,0,31,0,97,187,0,2,0,4,0,11,0,
4,43,184,0,2,16,184,0,11,16,184,0,18,208,184,0,
2,16,184,0,28,208,0,184,0,0,69,88,184,0,23,47,
27,185,0,23,0,11,62,89,184,0,0,69,88,184,0,6,
47,27,185,0,6,0,5,62,89,187,0,30,0,2,0,0,
0,4,43,184,0,30,16,184,0,0,16,184,0,12,208,184,
0,30,16,184,0,17,208,48,49,1,35,17,20,22,23,21,
33,53,62,1,53,17,35,39,62,1,55,51,17,52,38,39,
53,33,21,14,1,21,17,51,23,2,8,145,73,72,254,62,
68,77,145,22,5,11,6,145,73,72,1,194,68,77,145,25,
2,103,254,1,12,35,14,43,43,14,33,14,1,255,24,15,
35,16,1,194,12,36,14,43,43,14,34,14,254,62,23,0,
0,2,0,50,255,242,4,209,4,246,0,19,0,60,1,90,
184,0,61,47,184,0,62,47,184,0,61,16,184,0,4,208,
184,0,4,47,185,0,15,0,4,252,184,0,62,16,184,0,
43,220,186,0,20,0,4,0,43,17,18,57,184,0,15,16,
184,0,35,208,184,0,35,47,184,0,43,16,185,0,54,0,
4,252,65,5,0,154,0,54,0,170,0,54,0,2,93,65,
19,0,9,0,54,0,25,0,54,0,41,0,54,0,57,0,
54,0,73,0,54,0,89,0,54,0,105,0,54,0,121,0,
54,0,137,0,54,0,9,93,186,0,60,0,4,0,43,17,
18,57,0,184,0,0,69,88,184,0,9,47,27,185,0,9,
0,11,62,89,184,0,0,69,88,184,0,38,47,27,185,0,
38,0,11,62,89,184,0,0,69,88,184,0,31,47,27,185,
0,31,0,5,62,89,184,0,0,69,88,184,0,0,47,27,
185,0,0,0,5,62,89,186,0,20,0,31,0,38,17,18,
57,184,0,38,16,185,0,57,0,2,252,65,5,0,121,0,
57,0,137,0,57,0,2,113,65,33,0,8,0,57,0,24,
0,57,0,40,0,57,0,56,0,57,0,72,0,57,0,88,
0,57,0,104,0,57,0,120,0,57,0,136,0,57,0,152,
0,57,0,168,0,57,0,184,0,57,0,200,0,57,0,216,
0,57,0,232,0,57,0,248,0,57,0,16,93,65,15,0,
8,0,57,0,24,0,57,0,40,0,57,0,56,0,57,0,
72,0,57,0,88,0,57,0,104,0,57,0,7,113,186,0,
60,0,31,0,38,17,18,57,48,49,51,53,62,1,53,17,
52,38,39,53,33,21,14,1,21,17,20,22,23,21,9,2,
30,2,54,55,23,14,1,35,34,38,39,9,1,54,51,50,
30,2,21,20,7,14,3,7,39,62,1,39,46,1,35,34,
6,7,50,68,77,73,72,1,194,68,77,72,73,1,48,254,
213,1,224,18,41,47,50,26,7,59,119,48,29,45,20,254,
15,1,104,128,155,47,84,64,38,12,3,39,54,59,24,18,
19,16,1,2,55,42,42,82,37,43,14,33,14,4,27,12,
36,14,43,43,14,34,14,251,229,12,35,14,43,4,18,254,
143,253,222,20,22,9,1,3,43,19,32,18,25,2,102,1,
204,167,25,54,85,60,46,57,8,25,25,23,6,29,43,70,
29,61,63,66,54,0,0,1,0,55,255,246,4,0,6,14,
0,72,0,131,187,0,31,0,4,0,42,0,4,43,184,0,
31,16,184,0,0,208,184,0,42,16,184,0,44,208,0,184,
0,54,47,184,0,0,69,88,184,0,7,47,27,185,0,7,
0,9,62,89,184,0,0,69,88,184,0,72,47,27,185,0,
72,0,9,62,89,184,0,0,69,88,184,0,25,47,27,185,
0,25,0,5,62,89,184,0,0,69,88,184,0,37,47,27,
185,0,37,0,5,62,89,186,0,0,0,25,0,54,17,18,
57,186,0,30,0,25,0,54,17,18,57,184,0,54,16,185,
0,67,0,2,252,48,49,9,1,62,1,46,1,35,53,33,
21,14,1,7,9,1,30,3,55,23,14,3,35,34,38,39,
1,39,17,20,30,2,23,21,33,53,62,1,53,17,53,62,
3,55,62,3,51,50,30,2,21,20,14,2,7,46,1,35,
34,14,2,21,1,89,1,52,33,14,19,45,26,1,123,44,
74,42,254,175,1,116,14,30,36,45,29,6,29,57,49,39,
10,42,51,22,254,135,3,7,22,44,37,254,112,66,74,1,
35,63,88,54,29,68,65,59,20,41,83,66,42,29,40,43,
15,46,107,62,32,77,68,45,2,14,1,17,29,35,18,6,
43,43,5,23,34,254,240,254,70,16,21,12,3,2,43,7,
10,7,4,24,29,1,226,1,254,90,8,12,13,16,12,43,
43,17,26,18,3,24,9,117,170,128,96,43,23,34,23,11,
33,44,43,9,8,31,35,30,6,52,64,46,113,189,143,0,
0,1,0,70,0,0,2,72,6,14,0,34,0,84,187,0,
2,0,4,0,13,0,4,43,184,0,2,16,184,0,13,16,
184,0,20,208,184,0,2,16,184,0,31,208,0,184,0,30,
47,184,0,0,69,88,184,0,6,47,27,185,0,6,0,5,
62,89,187,0,33,0,2,0,0,0,4,43,184,0,33,16,
184,0,0,16,184,0,14,208,184,0,33,16,184,0,19,208,
48,49,1,35,17,20,22,23,21,33,53,62,3,53,17,35,
39,62,1,55,51,17,52,46,2,39,53,62,1,55,23,17,
51,23,2,50,160,68,82,254,62,43,58,34,15,160,22,5,
9,8,160,12,32,54,42,72,120,62,36,160,22,2,228,253,
132,15,32,14,43,43,7,15,15,16,8,2,124,22,16,36,
16,1,210,45,50,25,9,5,40,14,34,32,34,253,82,25,
0,1,0,20,255,225,4,69,5,230,0,83,0,51,0,184,
0,0,69,88,184,0,23,47,27,185,0,23,0,5,62,89,
184,0,0,69,88,184,0,43,47,27,185,0,43,0,5,62,
89,187,0,76,0,2,0,67,0,4,43,184,0,76,16,48,
49,1,14,3,15,1,30,1,23,30,3,51,50,62,2,55,
23,14,1,35,34,46,4,39,46,1,39,14,3,7,14,3,
7,39,62,5,55,46,1,39,5,39,62,3,63,1,46,3,
35,34,6,7,39,62,3,51,50,30,2,23,37,23,3,87,
3,3,4,7,7,241,23,55,34,40,72,66,60,28,12,20,
25,33,25,10,75,97,34,26,44,41,42,53,66,43,2,1,
2,44,84,80,75,35,20,53,56,52,18,30,52,102,95,88,
75,61,22,11,21,10,254,244,29,2,2,4,7,8,241,23,
38,35,33,17,35,73,49,24,50,81,65,51,21,24,40,41,
45,29,1,11,28,5,143,17,19,16,20,17,173,75,194,124,
148,246,176,97,3,8,14,11,45,57,66,25,64,110,172,241,
162,4,7,5,87,167,176,192,111,5,15,17,15,5,33,66,
154,165,170,166,155,68,37,65,29,193,25,13,15,17,24,21,
172,58,70,39,13,34,38,51,51,69,42,18,15,53,101,85,
191,24,0,1,0,50,255,226,7,128,4,236,0,83,1,158,
184,0,84,47,184,0,78,208,184,0,78,47,185,0,5,0,
4,252,184,0,78,16,184,0,15,220,65,3,0,111,0,15,
0,1,93,65,3,0,31,0,15,0,1,93,65,3,0,255,
0,15,0,1,93,65,3,0,160,0,15,0,1,93,65,3,
0,112,0,15,0,1,93,185,0,26,0,4,252,184,0,15,
16,184,0,58,220,65,3,0,111,0,58,0,1,93,65,3,
0,255,0,58,0,1,93,65,3,0,31,0,58,0,1,93,
65,3,0,160,0,58,0,1,93,65,3,0,112,0,58,0,
1,93,184,0,34,208,184,0,58,16,185,0,45,0,4,252,
184,0,15,16,184,0,68,208,184,0,68,47,184,0,45,16,
184,0,85,220,0,184,0,0,69,88,184,0,0,47,27,185,
0,0,0,11,62,89,184,0,0,69,88,184,0,20,47,27,
185,0,20,0,11,62,89,184,0,0,69,88,184,0,39,47,
27,185,0,39,0,11,62,89,184,0,0,69,88,184,0,56,
47,27,185,0,56,0,5,62,89,184,0,0,69,88,184,0,
63,47,27,185,0,63,0,5,62,89,184,0,0,69,88,184,
0,73,47,27,185,0,73,0,5,62,89,185,0,10,0,2,
252,65,33,0,7,0,10,0,23,0,10,0,39,0,10,0,
55,0,10,0,71,0,10,0,87,0,10,0,103,0,10,0,
119,0,10,0,135,0,10,0,151,0,10,0,167,0,10,0,
183,0,10,0,199,0,10,0,215,0,10,0,231,0,10,0,
247,0,10,0,16,93,65,15,0,7,0,10,0,23,0,10,
0,39,0,10,0,55,0,10,0,71,0,10,0,87,0,10,
0,103,0,10,0,7,113,65,5,0,118,0,10,0,134,0,
10,0,2,113,184,0,31,208,186,0,58,0,56,0,0,17,
18,57,186,0,68,0,56,0,0,17,18,57,48,49,1,21,
14,1,21,17,20,30,2,51,50,62,2,55,17,52,38,39,
53,33,21,14,1,21,17,20,30,2,51,50,54,55,17,52,
38,39,53,33,21,14,1,21,17,20,30,2,23,21,14,3,
7,39,17,14,3,35,34,46,2,39,14,3,35,34,46,2,
53,17,52,38,39,53,1,244,76,69,21,42,61,40,40,93,
99,103,51,78,67,1,194,72,73,20,40,61,41,84,190,114,
76,69,1,194,72,73,10,31,57,47,51,69,57,55,36,37,
60,117,110,101,45,79,102,61,26,3,56,117,112,106,46,64,
103,73,39,72,73,4,236,43,17,31,14,253,42,94,123,73,
29,47,89,130,83,2,184,14,34,14,43,43,15,33,14,253,
32,83,117,74,35,179,170,2,184,14,34,14,43,43,15,33,
14,252,103,44,52,28,12,5,43,11,15,17,21,16,36,1,
32,89,123,77,35,57,92,116,58,84,122,79,38,40,86,134,
94,3,63,14,33,15,43,0,0,1,255,11,254,132,5,0,
4,236,0,58,0,140,184,0,59,47,184,0,60,47,184,0,
0,220,185,0,47,0,3,252,184,0,3,208,184,0,3,47,
184,0,59,16,184,0,35,208,184,0,35,47,185,0,5,0,
3,252,184,0,0,16,184,0,57,208,0,184,0,0,69,88,
184,0,40,47,27,185,0,40,0,11,62,89,184,0,0,69,
88,184,0,52,47,27,185,0,52,0,11,62,89,184,0,0,
69,88,184,0,0,47,27,185,0,0,0,5,62,89,187,0,
30,0,2,0,15,0,4,43,184,0,30,16,186,0,4,0,
0,0,40,17,18,57,186,0,47,0,0,0,40,17,18,57,
48,49,5,46,1,39,1,17,20,14,2,7,14,3,35,34,
46,2,53,52,62,2,55,30,3,51,50,62,2,53,17,46,
1,39,53,51,50,30,2,23,1,17,52,38,39,53,33,21,
14,1,21,17,4,111,50,57,12,253,67,20,41,59,39,27,
66,65,59,19,30,60,46,29,26,36,40,14,28,42,36,33,
19,26,59,49,32,34,72,39,212,15,19,19,24,19,2,145,
65,80,1,154,72,73,30,6,28,17,3,204,252,236,119,159,
110,73,32,21,34,24,13,19,25,27,9,8,30,30,27,5,
18,23,12,4,34,87,152,117,3,248,31,30,7,43,5,16,
31,26,252,118,3,111,12,39,11,43,43,10,38,14,251,95,
0,1,0,55,254,32,4,76,3,192,0,52,1,2,184,0,
53,47,184,0,54,47,184,0,48,220,185,0,4,0,4,252,
184,0,53,16,184,0,25,208,184,0,25,47,185,0,16,0,
4,252,184,0,37,208,184,0,37,47,0,184,0,0,69,88,
184,0,35,47,27,185,0,35,0,9,62,89,184,0,0,69,
88,184,0,42,47,27,185,0,42,0,9,62,89,184,0,0,
69,88,184,0,0,47,27,185,0,0,0,7,62,89,184,0,
0,69,88,184,0,20,47,27,185,0,20,0,5,62,89,184,
0,42,16,185,0,10,0,2,252,65,5,0,121,0,10,0,
137,0,10,0,2,113,65,33,0,8,0,10,0,24,0,10,
0,40,0,10,0,56,0,10,0,72,0,10,0,88,0,10,
0,104,0,10,0,120,0,10,0,136,0,10,0,152,0,10,
0,168,0,10,0,184,0,10,0,200,0,10,0,216,0,10,
0,232,0,10,0,248,0,10,0,16,93,65,15,0,8,0,
10,0,24,0,10,0,40,0,10,0,56,0,10,0,72,0,
10,0,88,0,10,0,104,0,10,0,7,113,184,0,31,208,
184,0,31,47,186,0,37,0,0,0,35,17,18,57,48,49,
1,53,62,1,53,17,52,46,2,35,34,14,2,7,17,20,
22,23,21,33,53,62,1,53,17,52,46,2,39,53,62,1,
55,31,1,62,3,51,50,30,2,21,17,20,22,23,21,2,
158,72,68,14,30,49,35,31,76,87,95,48,75,65,254,82,
66,74,6,27,56,51,68,116,56,35,11,44,106,108,101,39,
43,80,61,37,61,79,254,32,43,19,28,14,3,241,61,76,
44,16,30,66,107,78,254,67,15,32,14,43,43,17,27,17,
2,95,39,46,26,12,6,40,11,41,28,35,249,67,105,73,
39,26,54,83,56,251,163,14,27,20,43,0,0,3,0,70,
255,226,4,114,5,10,0,10,0,21,0,41,1,101,184,0,
42,47,184,0,43,47,184,0,42,16,184,0,32,208,184,0,
32,47,185,0,17,0,4,252,184,0,5,208,184,0,5,47,
184,0,43,16,184,0,22,220,185,0,16,0,4,252,184,0,
6,208,184,0,6,47,0,184,0,0,69,88,184,0,37,47,
27,185,0,37,0,11,62,89,184,0,0,69,88,184,0,27,
47,27,185,0,27,0,5,62,89,187,0,6,0,2,0,16,
0,4,43,184,0,6,16,184,0,37,16,185,0,0,0,2,
252,65,5,0,121,0,0,0,137,0,0,0,2,113,65,33,
0,8,0,0,0,24,0,0,0,40,0,0,0,56,0,0,
0,72,0,0,0,88,0,0,0,104,0,0,0,120,0,0,
0,136,0,0,0,152,0,0,0,168,0,0,0,184,0,0,
0,200,0,0,0,216,0,0,0,232,0,0,0,248,0,0,
0,16,93,65,15,0,8,0,0,0,24,0,0,0,40,0,
0,0,56,0,0,0,72,0,0,0,88,0,0,0,104,0,
0,0,7,113,184,0,27,16,185,0,11,0,2,252,65,33,
0,7,0,11,0,23,0,11,0,39,0,11,0,55,0,11,
0,71,0,11,0,87,0,11,0,103,0,11,0,119,0,11,
0,135,0,11,0,151,0,11,0,167,0,11,0,183,0,11,
0,199,0,11,0,215,0,11,0,231,0,11,0,247,0,11,
0,16,93,65,15,0,7,0,11,0,23,0,11,0,39,0,
11,0,55,0,11,0,71,0,11,0,87,0,11,0,103,0,
11,0,7,113,65,5,0,118,0,11,0,134,0,11,0,2,
113,48,49,1,34,14,2,7,33,46,3,3,50,62,2,55,
33,30,3,1,20,14,2,35,34,46,2,53,52,62,2,51,
50,30,2,2,92,83,134,96,58,6,2,240,9,62,97,130,
77,82,137,100,57,2,253,11,4,63,103,134,2,97,90,155,
204,114,120,188,129,68,88,152,205,118,124,188,128,65,4,152,
66,122,175,108,93,170,130,78,251,194,67,133,196,129,108,191,
143,83,2,45,136,245,186,110,106,178,232,126,136,246,186,110,
109,180,232,0,255,255,0,70,255,226,4,196,5,215,2,38,
0,47,0,0,0,7,2,184,4,126,1,94,255,255,0,80,
255,226,4,76,4,121,0,38,0,79,0,0,0,7,2,184,
4,6,0,0,0,2,0,70,254,162,6,249,5,10,0,21,
0,76,2,99,187,0,12,0,4,0,52,0,4,43,184,0,
12,16,187,0,42,0,4,0,0,0,4,43,184,0,42,16,
187,0,72,0,4,0,26,0,4,43,184,0,72,16,65,5,
0,154,0,0,0,170,0,0,0,2,93,65,19,0,9,0,
0,0,25,0,0,0,41,0,0,0,57,0,0,0,73,0,
0,0,89,0,0,0,105,0,0,0,121,0,0,0,137,0,
0,0,9,93,65,19,0,6,0,12,0,22,0,12,0,38,
0,12,0,54,0,12,0,70,0,12,0,86,0,12,0,102,
0,12,0,118,0,12,0,134,0,12,0,9,93,65,5,0,
149,0,12,0,165,0,12,0,2,93,184,0,26,16,184,0,
28,208,184,0,72,16,184,0,68,208,184,0,68,47,184,0,
72,16,184,0,78,220,0,184,0,22,47,184,0,0,69,88,
184,0,57,47,27,185,0,57,0,11,62,89,184,0,0,69,
88,184,0,63,47,27,185,0,63,0,11,62,89,184,0,0,
69,88,184,0,47,47,27,185,0,47,0,5,62,89,184,0,
57,16,185,0,7,0,2,252,65,5,0,121,0,7,0,137,
0,7,0,2,113,65,33,0,8,0,7,0,24,0,7,0,
40,0,7,0,56,0,7,0,72,0,7,0,88,0,7,0,
104,0,7,0,120,0,7,0,136,0,7,0,152,0,7,0,
168,0,7,0,184,0,7,0,200,0,7,0,216,0,7,0,
232,0,7,0,248,0,7,0,16,93,65,15,0,8,0,7,
0,24,0,7,0,40,0,7,0,56,0,7,0,72,0,7,
0,88,0,7,0,104,0,7,0,7,113,184,0,47,16,185,
0,17,0,2,252,65,33,0,7,0,17,0,23,0,17,0,
39,0,17,0,55,0,17,0,71,0,17,0,87,0,17,0,
103,0,17,0,119,0,17,0,135,0,17,0,151,0,17,0,
167,0,17,0,183,0,17,0,199,0,17,0,215,0,17,0,
231,0,17,0,247,0,17,0,16,93,65,15,0,7,0,17,
0,23,0,17,0,39,0,17,0,55,0,17,0,71,0,17,
0,87,0,17,0,103,0,17,0,7,113,65,5,0,118,0,
17,0,134,0,17,0,2,113,184,0,63,16,185,0,34,0,
2,252,65,5,0,121,0,34,0,137,0,34,0,2,113,65,
33,0,8,0,34,0,24,0,34,0,40,0,34,0,56,0,
34,0,72,0,34,0,88,0,34,0,104,0,34,0,120,0,
34,0,136,0,34,0,152,0,34,0,168,0,34,0,184,0,
34,0,200,0,34,0,216,0,34,0,232,0,34,0,248,0,
34,0,16,93,65,15,0,8,0,34,0,24,0,34,0,40,
0,34,0,56,0,34,0,72,0,34,0,88,0,34,0,104,
0,34,0,7,113,48,49,1,52,46,4,35,34,14,2,21,
20,30,2,51,50,62,2,1,53,62,1,53,17,53,17,52,
46,2,35,34,14,2,7,30,1,21,20,14,2,35,34,46,
2,53,52,62,2,51,50,22,23,62,1,51,50,30,2,29,
1,22,21,17,20,22,23,21,3,215,25,46,67,84,100,57,
89,141,97,52,61,103,138,77,83,139,101,56,1,96,68,77,
25,46,63,37,26,54,61,69,42,41,40,90,155,204,114,120,
188,129,68,88,152,205,118,121,186,64,99,186,87,43,93,77,
50,1,73,72,2,117,69,135,121,104,75,43,76,139,198,122,
112,200,151,88,69,136,202,252,177,43,14,33,14,1,210,4,
2,136,82,107,64,26,10,30,56,46,81,184,97,136,245,186,
110,106,178,232,126,136,246,186,110,104,88,104,88,26,69,120,
94,172,1,3,251,229,12,35,14,43,0,2,0,80,254,32,
5,240,3,192,0,19,0,70,2,108,187,0,10,0,4,0,
47,0,4,43,184,0,10,16,187,0,35,0,4,0,0,0,
4,43,184,0,35,16,187,0,66,0,4,0,24,0,4,43,
184,0,66,16,65,5,0,154,0,0,0,170,0,0,0,2,
93,65,19,0,9,0,0,0,25,0,0,0,41,0,0,0,
57,0,0,0,73,0,0,0,89,0,0,0,105,0,0,0,
121,0,0,0,137,0,0,0,9,93,65,19,0,6,0,10,
0,22,0,10,0,38,0,10,0,54,0,10,0,70,0,10,
0,86,0,10,0,102,0,10,0,118,0,10,0,134,0,10,
0,9,93,65,5,0,149,0,10,0,165,0,10,0,2,93,
186,0,57,0,0,0,35,17,18,57,184,0,72,220,0,184,
0,0,69,88,184,0,54,47,27,185,0,54,0,9,62,89,
184,0,0,69,88,184,0,60,47,27,185,0,60,0,9,62,
89,184,0,0,69,88,184,0,20,47,27,185,0,20,0,7,
62,89,184,0,0,69,88,184,0,42,47,27,185,0,42,0,
5,62,89,184,0,54,16,185,0,5,0,2,252,65,5,0,
121,0,5,0,137,0,5,0,2,113,65,33,0,8,0,5,
0,24,0,5,0,40,0,5,0,56,0,5,0,72,0,5,
0,88,0,5,0,104,0,5,0,120,0,5,0,136,0,5,
0,152,0,5,0,168,0,5,0,184,0,5,0,200,0,5,
0,216,0,5,0,232,0,5,0,248,0,5,0,16,93,65,
15,0,8,0,5,0,24,0,5,0,40,0,5,0,56,0,
5,0,72,0,5,0,88,0,5,0,104,0,5,0,7,113,
184,0,42,16,185,0,15,0,2,252,65,33,0,7,0,15,
0,23,0,15,0,39,0,15,0,55,0,15,0,71,0,15,
0,87,0,15,0,103,0,15,0,119,0,15,0,135,0,15,
0,151,0,15,0,167,0,15,0,183,0,15,0,199,0,15,
0,215,0,15,0,231,0,15,0,247,0,15,0,16,93,65,
15,0,7,0,15,0,23,0,15,0,39,0,15,0,55,0,
15,0,71,0,15,0,87,0,15,0,103,0,15,0,7,113,
65,5,0,118,0,15,0,134,0,15,0,2,113,184,0,60,
16,185,0,30,0,2,252,65,5,0,121,0,30,0,137,0,
30,0,2,113,65,33,0,8,0,30,0,24,0,30,0,40,
0,30,0,56,0,30,0,72,0,30,0,88,0,30,0,104,
0,30,0,120,0,30,0,136,0,30,0,152,0,30,0,168,
0,30,0,184,0,30,0,200,0,30,0,216,0,30,0,232,
0,30,0,248,0,30,0,16,93,65,15,0,8,0,30,0,
24,0,30,0,40,0,30,0,56,0,30,0,72,0,30,0,
88,0,30,0,104,0,30,0,7,113,186,0,57,0,20,0,
54,17,18,57,48,49,1,52,46,2,35,34,14,2,21,20,
30,2,51,50,62,2,1,53,62,1,53,17,52,46,2,35,
34,6,7,22,21,20,14,4,35,34,46,2,53,52,62,4,
51,50,22,23,62,1,51,50,30,2,21,17,20,22,23,21,
3,29,52,84,104,51,76,104,65,28,56,86,103,46,71,103,
67,32,1,37,72,68,14,30,49,35,44,94,57,43,34,60,
84,101,114,61,95,153,109,59,33,59,83,101,116,63,109,170,
54,75,153,63,43,80,61,37,61,79,1,199,79,143,109,64,
58,101,138,80,79,143,108,63,53,98,138,252,175,43,19,28,
14,3,241,61,76,44,16,53,68,101,123,66,129,114,97,70,
39,72,126,174,102,66,128,115,97,70,40,95,83,88,90,26,
54,83,56,251,163,14,27,20,43,0,0,1,0,30,0,0,
4,188,5,10,0,67,0,243,187,0,61,0,4,0,4,0,
4,43,184,0,61,16,187,0,34,0,4,0,52,0,4,43,
184,0,34,16,187,0,8,0,4,0,19,0,4,43,184,0,
8,16,65,19,0,6,0,8,0,22,0,8,0,38,0,8,
0,54,0,8,0,70,0,8,0,86,0,8,0,102,0,8,
0,118,0,8,0,134,0,8,0,9,93,65,5,0,149,0,
8,0,165,0,8,0,2,93,186,0,44,0,19,0,34,17,
18,57,65,5,0,154,0,52,0,170,0,52,0,2,93,65,
19,0,9,0,52,0,25,0,52,0,41,0,52,0,57,0,
52,0,73,0,52,0,89,0,52,0,105,0,52,0,121,0,
52,0,137,0,52,0,9,93,184,0,34,16,184,0,69,220,
0,184,0,0,69,88,184,0,24,47,27,185,0,24,0,11,
62,89,184,0,0,69,88,184,0,0,47,27,185,0,0,0,
5,62,89,187,0,47,0,2,0,41,0,4,43,184,0,47,
16,184,0,24,16,185,0,5,0,2,252,186,0,44,0,0,
0,24,17,18,57,184,0,60,208,48,49,33,53,62,1,53,
17,14,1,21,20,22,23,14,3,7,46,1,53,52,62,2,
51,50,30,2,23,30,3,21,20,14,4,35,34,47,1,30,
1,51,50,62,2,53,52,38,39,46,3,35,17,20,30,2,
23,21,1,24,68,77,118,113,38,31,3,31,44,49,21,37,
48,73,148,226,152,70,100,74,54,25,61,96,67,36,39,65,
84,91,91,39,94,67,23,42,77,35,46,100,84,54,97,84,
29,49,62,86,65,16,39,68,52,43,14,33,14,4,69,15,
82,64,36,56,14,6,22,22,20,4,16,76,55,65,106,75,
41,4,8,10,7,17,56,81,105,66,69,114,89,65,43,21,
30,76,19,11,36,71,106,71,106,143,28,9,13,8,4,251,
178,6,14,16,16,9,43,0,0,2,0,0,254,32,3,181,
6,14,0,20,0,80,1,184,184,0,81,47,184,0,82,47,
184,0,31,220,185,0,0,0,4,252,65,5,0,154,0,0,
0,170,0,0,0,2,93,65,19,0,9,0,0,0,25,0,
0,0,41,0,0,0,57,0,0,0,73,0,0,0,89,0,
0,0,105,0,0,0,121,0,0,0,137,0,0,0,9,93,
184,0,81,16,184,0,51,208,184,0,51,47,185,0,42,0,
4,252,184,0,10,208,184,0,42,16,184,0,21,208,0,184,
0,0,69,88,184,0,26,47,27,185,0,26,0,9,62,89,
184,0,0,69,88,184,0,46,47,27,185,0,46,0,7,62,
89,184,0,0,69,88,184,0,38,47,27,185,0,38,0,5,
62,89,187,0,62,0,2,0,75,0,4,43,184,0,62,16,
184,0,26,16,185,0,5,0,2,252,65,5,0,121,0,5,
0,137,0,5,0,2,113,65,33,0,8,0,5,0,24,0,
5,0,40,0,5,0,56,0,5,0,72,0,5,0,88,0,
5,0,104,0,5,0,120,0,5,0,136,0,5,0,152,0,
5,0,168,0,5,0,184,0,5,0,200,0,5,0,216,0,
5,0,232,0,5,0,248,0,5,0,16,93,65,15,0,8,
0,5,0,24,0,5,0,40,0,5,0,56,0,5,0,72,
0,5,0,88,0,5,0,104,0,5,0,7,113,184,0,38,
16,185,0,16,0,2,252,65,33,0,7,0,16,0,23,0,
16,0,39,0,16,0,55,0,16,0,71,0,16,0,87,0,
16,0,103,0,16,0,119,0,16,0,135,0,16,0,151,0,
16,0,167,0,16,0,183,0,16,0,199,0,16,0,215,0,
16,0,231,0,16,0,247,0,16,0,16,93,65,15,0,7,
0,16,0,23,0,16,0,39,0,16,0,55,0,16,0,71,
0,16,0,87,0,16,0,103,0,16,0,7,113,65,5,0,
118,0,16,0,134,0,16,0,2,113,186,0,21,0,46,0,
26,17,18,57,186,0,41,0,38,0,16,17,18,57,48,49,
1,52,46,2,35,34,14,2,7,17,30,3,51,50,62,2,
1,62,3,51,50,30,2,21,20,14,4,35,34,38,39,17,
20,22,23,21,33,53,62,1,53,17,62,3,55,62,3,51,
50,30,2,21,20,14,2,7,46,1,35,34,14,2,21,3,
48,41,69,90,48,18,58,74,84,44,45,77,67,60,27,54,
91,67,38,253,242,50,99,90,77,29,68,115,84,47,29,53,
71,85,94,49,59,148,71,75,94,254,53,66,74,1,35,63,
87,53,27,67,67,59,19,45,85,66,40,29,40,43,15,42,
114,59,32,78,67,45,1,170,87,150,109,62,22,51,87,64,
254,115,34,44,25,10,42,82,122,1,132,60,86,54,26,64,
121,174,109,58,122,116,104,77,45,66,62,254,39,16,32,14,
43,43,16,29,17,4,249,119,173,129,97,42,22,34,24,12,
33,44,43,9,8,32,33,30,7,52,64,46,113,189,143,0,
0,2,0,50,255,9,4,149,4,236,0,14,0,67,1,41,
184,0,68,47,184,0,69,47,184,0,68,16,184,0,36,208,
184,0,36,47,185,0,27,0,4,252,184,0,3,208,184,0,
69,16,184,0,55,220,185,0,10,0,4,252,65,5,0,154,
0,10,0,170,0,10,0,2,93,65,19,0,9,0,10,0,
25,0,10,0,41,0,10,0,57,0,10,0,73,0,10,0,
89,0,10,0,105,0,10,0,121,0,10,0,137,0,10,0,
9,93,184,0,55,16,184,0,18,208,184,0,18,47,184,0,
27,16,184,0,46,208,186,0,60,0,36,0,18,17,18,57,
0,184,0,18,47,184,0,0,69,88,184,0,41,47,27,185,
0,41,0,11,62,89,184,0,0,69,88,184,0,31,47,27,
185,0,31,0,5,62,89,187,0,7,0,2,0,23,0,4,
43,184,0,7,16,184,0,41,16,184,0,0,220,65,5,0,
217,0,0,0,233,0,0,0,2,93,65,27,0,8,0,0,
0,24,0,0,0,40,0,0,0,56,0,0,0,72,0,0,
0,88,0,0,0,104,0,0,0,120,0,0,0,136,0,0,
0,152,0,0,0,168,0,0,0,184,0,0,0,200,0,0,
0,13,93,184,0,3,208,184,0,3,47,184,0,0,16,185,
0,50,0,2,252,184,0,47,208,184,0,47,47,186,0,60,
0,23,0,7,17,18,57,48,49,1,34,6,7,17,30,1,
51,50,54,39,46,3,1,14,1,35,34,38,39,1,35,34,
38,39,17,20,22,23,21,33,53,62,1,53,17,52,38,39,
53,33,21,14,1,29,1,62,1,51,50,30,2,21,20,14,
2,7,1,30,3,55,23,1,176,20,37,20,27,40,22,180,
170,2,1,34,83,138,2,125,66,119,39,29,55,14,254,144,
22,26,52,28,73,72,254,62,68,77,73,72,1,194,68,77,
26,57,31,131,182,113,51,46,84,119,73,1,102,15,35,43,
53,34,11,3,168,1,1,254,89,5,2,120,102,38,75,60,
37,251,148,22,29,33,22,2,98,5,6,254,187,12,35,14,
43,43,14,33,14,4,27,12,36,14,43,43,14,34,14,140,
2,3,45,74,95,49,65,106,82,56,15,253,241,21,26,13,
2,3,43,0,0,1,0,115,255,226,3,115,5,10,0,70,
1,227,184,0,71,47,184,0,72,47,184,0,71,16,184,0,
0,208,184,0,0,47,184,0,72,16,184,0,35,220,185,0,
9,0,4,252,65,5,0,154,0,9,0,170,0,9,0,2,
93,65,19,0,9,0,9,0,25,0,9,0,41,0,9,0,
57,0,9,0,73,0,9,0,89,0,9,0,105,0,9,0,
121,0,9,0,137,0,9,0,9,93,184,0,0,16,185,0,
44,0,4,252,65,19,0,6,0,44,0,22,0,44,0,38,
0,44,0,54,0,44,0,70,0,44,0,86,0,44,0,102,
0,44,0,118,0,44,0,134,0,44,0,9,93,65,5,0,
149,0,44,0,165,0,44,0,2,93,184,0,20,208,184,0,
20,47,184,0,35,16,184,0,55,208,184,0,55,47,184,0,
35,16,184,0,58,208,184,0,58,47,184,0,35,16,184,0,
61,208,184,0,61,47,0,184,0,0,69,88,184,0,30,47,
27,185,0,30,0,11,62,89,184,0,0,69,88,184,0,66,
47,27,185,0,66,0,5,62,89,184,0,30,16,185,0,14,
0,2,252,65,5,0,121,0,14,0,137,0,14,0,2,113,
65,33,0,8,0,14,0,24,0,14,0,40,0,14,0,56,
0,14,0,72,0,14,0,88,0,14,0,104,0,14,0,120,
0,14,0,136,0,14,0,152,0,14,0,168,0,14,0,184,
0,14,0,200,0,14,0,216,0,14,0,232,0,14,0,248,
0,14,0,16,93,65,15,0,8,0,14,0,24,0,14,0,
40,0,14,0,56,0,14,0,72,0,14,0,88,0,14,0,
104,0,14,0,7,113,184,0,66,16,185,0,49,0,2,252,
65,33,0,7,0,49,0,23,0,49,0,39,0,49,0,55,
0,49,0,71,0,49,0,87,0,49,0,103,0,49,0,119,
0,49,0,135,0,49,0,151,0,49,0,167,0,49,0,183,
0,49,0,199,0,49,0,215,0,49,0,231,0,49,0,247,
0,49,0,16,93,65,15,0,7,0,49,0,23,0,49,0,
39,0,49,0,55,0,49,0,71,0,49,0,87,0,49,0,
103,0,49,0,7,113,65,5,0,118,0,49,0,134,0,49,
0,2,113,48,49,19,52,62,6,53,52,46,2,35,34,14,
2,15,1,46,3,55,62,3,51,50,30,2,21,20,14,6,
21,20,30,2,51,50,62,2,63,1,30,1,21,20,6,7,
14,3,35,34,46,2,115,54,89,113,119,113,89,54,25,52,
81,55,47,81,65,46,13,36,12,30,23,10,7,18,79,99,
106,45,110,136,76,27,54,88,112,117,112,88,54,43,72,92,
49,51,97,84,69,23,41,7,7,7,7,35,86,97,106,55,
98,142,91,44,1,81,85,128,98,73,61,54,60,71,47,28,
61,51,32,24,41,57,33,6,11,46,49,41,6,20,40,32,
20,56,87,103,47,80,116,87,64,56,54,68,87,61,51,86,
62,35,34,64,92,59,5,27,84,41,40,60,4,23,42,33,
20,65,104,131,0,1,0,88,255,226,2,182,3,192,0,69,
1,215,184,0,70,47,184,0,71,47,184,0,70,16,184,0,
0,208,184,0,0,47,184,0,71,16,184,0,34,220,185,0,
10,0,4,252,65,5,0,154,0,10,0,170,0,10,0,2,
93,65,19,0,9,0,10,0,25,0,10,0,41,0,10,0,
57,0,10,0,73,0,10,0,89,0,10,0,105,0,10,0,
121,0,10,0,137,0,10,0,9,93,184,0,0,16,185,0,
44,0,4,252,65,19,0,6,0,44,0,22,0,44,0,38,
0,44,0,54,0,44,0,70,0,44,0,86,0,44,0,102,
0,44,0,118,0,44,0,134,0,44,0,9,93,65,5,0,
149,0,44,0,165,0,44,0,2,93,184,0,18,208,184,0,
18,47,184,0,34,16,184,0,55,208,184,0,55,47,184,0,
34,16,184,0,60,208,184,0,60,47,0,184,0,0,69,88,
184,0,29,47,27,185,0,29,0,9,62,89,184,0,0,69,
88,184,0,65,47,27,185,0,65,0,5,62,89,184,0,29,
16,185,0,15,0,2,252,65,5,0,121,0,15,0,137,0,
15,0,2,113,65,33,0,8,0,15,0,24,0,15,0,40,
0,15,0,56,0,15,0,72,0,15,0,88,0,15,0,104,
0,15,0,120,0,15,0,136,0,15,0,152,0,15,0,168,
0,15,0,184,0,15,0,200,0,15,0,216,0,15,0,232,
0,15,0,248,0,15,0,16,93,65,15,0,8,0,15,0,
24,0,15,0,40,0,15,0,56,0,15,0,72,0,15,0,
88,0,15,0,104,0,15,0,7,113,184,0,65,16,185,0,
49,0,2,252,65,33,0,7,0,49,0,23,0,49,0,39,
0,49,0,55,0,49,0,71,0,49,0,87,0,49,0,103,
0,49,0,119,0,49,0,135,0,49,0,151,0,49,0,167,
0,49,0,183,0,49,0,199,0,49,0,215,0,49,0,231,
0,49,0,247,0,49,0,16,93,65,15,0,7,0,49,0,
23,0,49,0,39,0,49,0,55,0,49,0,71,0,49,0,
87,0,49,0,103,0,49,0,7,113,65,5,0,118,0,49,
0,134,0,49,0,2,113,48,49,55,52,62,2,55,62,3,
53,52,46,2,35,34,6,15,1,46,3,55,62,3,51,50,
30,2,21,20,14,2,7,14,3,21,20,30,2,51,50,62,
2,63,1,30,2,6,7,14,3,35,34,46,2,88,44,70,
87,44,42,79,62,38,19,37,52,33,87,103,15,39,6,21,
16,8,6,20,73,84,84,32,57,97,72,41,37,61,78,42,
46,89,70,43,24,44,60,36,52,89,67,40,2,43,7,9,
3,5,7,33,76,79,77,35,56,106,82,50,243,63,98,76,
57,22,22,41,45,51,32,24,44,33,19,81,88,8,8,51,
57,48,6,18,34,28,17,25,55,88,62,59,86,66,49,21,
24,45,51,62,40,35,59,42,23,38,63,81,42,11,23,78,
77,59,3,22,35,24,12,31,66,104,0,1,0,59,0,0,
3,241,4,252,0,31,0,78,0,184,0,0,69,88,184,0,
14,47,27,185,0,14,0,11,62,89,184,0,0,69,88,184,
0,10,47,27,185,0,10,0,11,62,89,184,0,0,69,88,
184,0,5,47,27,185,0,5,0,5,62,89,184,0,14,16,
185,0,21,0,2,252,184,0,22,208,184,0,5,16,185,0,
24,0,2,252,48,49,1,14,3,7,33,39,9,1,53,33,
50,54,55,19,7,46,3,35,33,9,1,33,50,62,2,55,
23,3,241,2,7,8,7,2,252,131,31,1,181,254,96,2,
162,56,97,60,4,56,18,36,34,32,15,254,43,1,86,254,
115,2,40,31,41,30,28,18,53,1,89,40,98,96,84,27,
43,2,80,2,70,43,4,12,254,211,12,74,80,36,6,254,
27,253,233,19,49,84,66,12,0,2,255,92,254,12,3,19,
6,14,0,16,0,73,1,95,187,0,12,0,4,0,17,0,
4,43,184,0,12,16,187,0,32,0,4,0,58,0,4,43,
184,0,32,16,65,19,0,6,0,12,0,22,0,12,0,38,
0,12,0,54,0,12,0,70,0,12,0,86,0,12,0,102,
0,12,0,118,0,12,0,134,0,12,0,9,93,65,5,0,
149,0,12,0,165,0,12,0,2,93,65,19,0,6,0,32,
0,22,0,32,0,38,0,32,0,54,0,32,0,70,0,32,
0,86,0,32,0,102,0,32,0,118,0,32,0,134,0,32,
0,9,93,65,5,0,149,0,32,0,165,0,32,0,2,93,
186,0,63,0,58,0,32,17,18,57,184,0,63,47,185,0,
27,0,4,252,184,0,63,16,184,0,66,208,184,0,66,47,
0,184,0,22,47,184,0,0,69,88,184,0,53,47,27,185,
0,53,0,7,62,89,187,0,0,0,2,0,69,0,4,43,
184,0,0,16,184,0,22,16,185,0,7,0,2,252,184,0,
53,16,185,0,37,0,2,252,65,33,0,7,0,37,0,23,
0,37,0,39,0,37,0,55,0,37,0,71,0,37,0,87,
0,37,0,103,0,37,0,119,0,37,0,135,0,37,0,151,
0,37,0,167,0,37,0,183,0,37,0,199,0,37,0,215,
0,37,0,231,0,37,0,247,0,37,0,16,93,65,15,0,
7,0,37,0,23,0,37,0,39,0,37,0,55,0,37,0,
71,0,37,0,87,0,37,0,103,0,37,0,7,113,65,5,
0,118,0,37,0,134,0,37,0,2,113,186,0,66,0,69,
0,0,17,18,57,48,49,19,50,62,2,55,38,35,34,14,
2,21,20,30,2,39,52,62,2,51,50,30,2,21,20,10,
2,21,20,30,2,51,50,62,2,39,38,62,2,31,1,22,
14,2,35,34,46,2,53,52,26,2,53,52,38,53,14,1,
35,34,46,2,75,23,39,32,26,9,30,105,22,39,30,17,
19,32,41,217,47,82,112,66,61,88,57,27,14,17,14,24,
45,63,40,29,47,28,5,13,3,40,56,58,15,19,3,55,
96,128,69,68,101,66,33,14,17,14,1,45,100,51,43,68,
47,25,4,189,15,22,28,13,164,20,34,44,23,27,45,31,
18,69,44,95,78,51,58,96,124,65,152,254,197,254,206,254,
224,125,120,163,100,43,28,42,50,21,4,25,24,17,2,39,
38,92,81,54,64,119,170,107,148,1,53,1,48,1,37,132,
10,19,10,49,44,29,51,70,0,1,0,20,254,12,2,164,
5,0,0,67,1,162,187,0,48,0,4,0,27,0,4,43,
184,0,48,16,187,0,58,0,3,0,18,0,4,43,184,0,
58,16,184,0,27,16,184,0,32,208,184,0,48,16,184,0,
35,208,184,0,58,16,184,0,69,220,0,184,0,0,69,88,
184,0,34,47,27,185,0,34,0,11,62,89,184,0,0,69,
88,184,0,31,47,27,185,0,31,0,9,62,89,184,0,0,
69,88,184,0,36,47,27,185,0,36,0,9,62,89,184,0,
0,69,88,184,0,63,47,27,185,0,63,0,7,62,89,184,
0,0,69,88,184,0,22,47,27,185,0,22,0,5,62,89,
184,0,63,16,185,0,13,0,2,252,65,33,0,7,0,13,
0,23,0,13,0,39,0,13,0,55,0,13,0,71,0,13,
0,87,0,13,0,103,0,13,0,119,0,13,0,135,0,13,
0,151,0,13,0,167,0,13,0,183,0,13,0,199,0,13,
0,215,0,13,0,231,0,13,0,247,0,13,0,16,93,65,
15,0,7,0,13,0,23,0,13,0,39,0,13,0,55,0,
13,0,71,0,13,0,87,0,13,0,103,0,13,0,7,113,
65,5,0,118,0,13,0,134,0,13,0,2,113,184,0,22,
16,185,0,53,0,2,252,65,33,0,7,0,53,0,23,0,
53,0,39,0,53,0,55,0,53,0,71,0,53,0,87,0,
53,0,103,0,53,0,119,0,53,0,135,0,53,0,151,0,
53,0,167,0,53,0,183,0,53,0,199,0,53,0,215,0,
53,0,231,0,53,0,247,0,53,0,16,93,65,15,0,7,
0,53,0,23,0,53,0,39,0,53,0,55,0,53,0,71,
0,53,0,87,0,53,0,103,0,53,0,7,113,65,5,0,
118,0,53,0,134,0,53,0,2,113,186,0,19,0,22,0,
53,17,18,57,184,0,31,16,185,0,28,0,2,252,184,0,
46,208,184,0,47,208,48,49,19,62,3,55,30,1,23,6,
30,2,51,50,62,2,61,1,14,1,35,34,46,2,53,17,
35,39,55,51,53,55,23,17,33,23,14,3,7,46,1,43,
1,17,20,30,2,51,50,54,55,23,17,20,14,2,35,34,
46,2,239,9,33,39,40,16,4,14,5,17,6,29,42,20,
25,39,28,15,74,127,41,35,63,48,28,129,21,78,72,119,
31,1,71,29,9,27,28,27,10,24,98,81,52,11,26,41,
30,35,106,78,29,47,72,86,38,43,75,53,28,254,225,10,
28,26,23,6,5,14,8,45,69,46,24,19,48,81,61,253,
43,44,26,59,96,70,2,103,28,66,246,104,25,254,187,29,
14,31,29,22,4,12,23,253,239,60,79,47,19,26,40,51,
254,228,107,131,71,24,35,58,78,0,0,1,0,30,0,0,
4,150,4,236,0,46,0,153,184,0,47,47,184,0,48,47,
184,0,47,16,184,0,0,208,184,0,0,47,184,0,48,16,
184,0,18,220,185,0,29,0,4,252,184,0,0,16,185,0,
36,0,4,252,65,19,0,6,0,36,0,22,0,36,0,38,
0,36,0,54,0,36,0,70,0,36,0,86,0,36,0,102,
0,36,0,118,0,36,0,134,0,36,0,9,93,65,5,0,
149,0,36,0,165,0,36,0,2,93,0,184,0,0,69,88,
184,0,5,47,27,185,0,5,0,11,62,89,184,0,0,69,
88,184,0,22,47,27,185,0,22,0,5,62,89,184,0,5,
16,185,0,16,0,2,252,184,0,30,208,184,0,31,208,48,
49,19,52,62,2,51,33,23,14,1,7,35,46,3,35,33,
17,20,22,23,21,33,53,62,3,53,17,35,34,14,2,21,
20,22,23,14,3,7,46,1,30,53,91,119,66,3,17,30,
2,16,12,45,9,15,19,28,22,254,228,72,92,254,24,46,
63,38,17,169,41,72,54,32,38,31,3,31,44,49,21,37,
48,3,235,65,97,64,31,25,51,121,63,42,64,43,21,251,
225,13,40,19,43,43,9,20,19,17,7,4,31,11,30,52,
41,36,56,14,6,22,22,20,4,16,76,0,0,1,0,20,
255,226,2,205,6,14,0,65,0,241,187,0,28,0,4,0,
47,0,4,43,184,0,28,16,184,0,15,208,184,0,47,16,
184,0,52,208,0,184,0,0,69,88,184,0,16,47,27,185,
0,16,0,9,62,89,184,0,0,69,88,184,0,51,47,27,
185,0,51,0,9,62,89,184,0,0,69,88,184,0,42,47,
27,185,0,42,0,5,62,89,187,0,61,0,2,0,10,0,
4,43,184,0,61,16,184,0,16,16,185,0,26,0,2,252,
184,0,42,16,185,0,33,0,2,252,65,33,0,7,0,33,
0,23,0,33,0,39,0,33,0,55,0,33,0,71,0,33,
0,87,0,33,0,103,0,33,0,119,0,33,0,135,0,33,
0,151,0,33,0,167,0,33,0,183,0,33,0,199,0,33,
0,215,0,33,0,231,0,33,0,247,0,33,0,16,93,65,
15,0,7,0,33,0,23,0,33,0,39,0,33,0,55,0,
33,0,71,0,33,0,87,0,33,0,103,0,33,0,7,113,
65,5,0,118,0,33,0,134,0,33,0,2,113,184,0,26,
16,184,0,48,208,184,0,49,208,48,49,1,20,14,2,7,
46,3,35,34,14,2,7,21,33,23,14,3,7,46,1,43,
1,17,20,30,2,51,50,54,55,23,14,3,35,34,46,2,
53,17,35,39,55,51,53,52,62,2,55,62,1,51,50,30,
2,2,205,29,40,43,15,21,41,39,34,14,30,45,30,15,
1,1,71,29,9,27,28,27,10,24,98,81,52,11,26,41,
30,35,106,78,29,49,96,87,74,26,35,63,48,28,129,21,
78,72,17,36,56,39,51,111,39,43,73,53,29,5,143,8,
31,33,29,7,34,44,25,9,30,68,112,82,205,29,14,31,
29,22,4,12,23,253,239,60,79,47,19,26,40,51,36,55,
37,19,26,59,96,70,2,103,28,66,126,84,121,92,71,34,
45,47,33,43,42,0,0,1,0,10,254,132,4,59,4,236,
0,48,0,66,187,0,32,0,4,0,8,0,4,43,184,0,
32,16,0,184,0,0,69,88,184,0,19,47,27,185,0,19,
0,11,62,89,187,0,37,0,2,0,5,0,4,43,184,0,
37,16,184,0,19,16,185,0,9,0,2,252,184,0,30,208,
184,0,31,208,48,49,5,22,14,2,35,34,38,53,17,33,
34,14,2,7,39,62,1,55,33,23,14,1,7,35,46,3,
35,33,17,20,30,2,51,50,62,2,39,38,62,2,31,1,
4,55,3,58,102,135,73,122,121,254,213,15,25,25,32,22,
43,5,17,11,3,242,30,2,16,12,45,9,15,19,28,22,
254,228,22,41,58,36,29,51,31,8,13,3,40,56,58,15,
19,115,38,92,81,54,164,169,4,193,11,36,70,58,19,59,
134,53,25,51,121,63,42,64,43,21,251,124,84,114,70,31,
28,42,50,21,4,25,24,17,2,39,255,255,0,50,255,226,
5,120,5,215,0,38,0,53,0,0,0,7,2,184,5,50,
1,94,255,255,0,41,255,226,4,231,4,121,0,38,0,85,
0,0,0,7,2,184,4,161,0,0,0,1,0,70,255,226,
4,188,4,236,0,60,1,67,184,0,61,47,184,0,62,47,
184,0,11,220,184,0,61,16,184,0,23,208,184,0,23,47,
185,0,42,0,4,252,65,19,0,6,0,42,0,22,0,42,
0,38,0,42,0,54,0,42,0,70,0,42,0,86,0,42,
0,102,0,42,0,118,0,42,0,134,0,42,0,9,93,65,
5,0,149,0,42,0,165,0,42,0,2,93,184,0,11,16,
185,0,52,0,4,252,65,5,0,154,0,52,0,170,0,52,
0,2,93,65,19,0,9,0,52,0,25,0,52,0,41,0,
52,0,57,0,52,0,73,0,52,0,89,0,52,0,105,0,
52,0,121,0,52,0,137,0,52,0,9,93,0,184,0,0,
69,88,184,0,35,47,27,185,0,35,0,11,62,89,184,0,
0,69,88,184,0,58,47,27,185,0,58,0,11,62,89,184,
0,0,69,88,184,0,18,47,27,185,0,18,0,5,62,89,
185,0,47,0,2,252,65,33,0,7,0,47,0,23,0,47,
0,39,0,47,0,55,0,47,0,71,0,47,0,87,0,47,
0,103,0,47,0,119,0,47,0,135,0,47,0,151,0,47,
0,167,0,47,0,183,0,47,0,199,0,47,0,215,0,47,
0,231,0,47,0,247,0,47,0,16,93,65,15,0,7,0,
47,0,23,0,47,0,39,0,47,0,55,0,47,0,71,0,
47,0,87,0,47,0,103,0,47,0,7,113,65,5,0,118,
0,47,0,134,0,47,0,2,113,48,49,1,34,14,3,23,
30,3,21,20,14,4,35,34,46,2,53,52,62,2,55,54,
46,3,35,53,33,23,14,3,21,20,30,2,51,50,62,2,
53,52,46,2,39,55,33,21,4,188,2,51,77,66,35,16,
37,62,46,26,35,66,95,120,145,82,116,193,139,77,28,49,
67,39,16,34,66,76,51,2,1,180,24,75,104,65,30,62,
108,144,81,82,135,96,52,34,67,98,64,27,1,176,4,193,
10,20,25,33,18,41,103,123,142,79,73,154,145,128,97,56,
93,163,222,128,83,154,137,116,45,19,33,25,19,10,43,59,
47,120,146,173,100,108,192,144,83,79,137,185,106,101,186,158,
123,38,59,43,0,1,0,50,255,226,4,144,5,10,0,49,
1,13,184,0,50,47,184,0,51,47,184,0,7,220,184,0,
50,16,184,0,19,208,184,0,19,47,185,0,30,0,4,252,
184,0,7,16,185,0,40,0,4,252,65,5,0,154,0,40,
0,170,0,40,0,2,93,65,19,0,9,0,40,0,25,0,
40,0,41,0,40,0,57,0,40,0,73,0,40,0,89,0,
40,0,105,0,40,0,121,0,40,0,137,0,40,0,9,93,
0,184,0,0,69,88,184,0,0,47,27,185,0,0,0,11,
62,89,184,0,0,69,88,184,0,24,47,27,185,0,24,0,
11,62,89,184,0,0,69,88,184,0,14,47,27,185,0,14,
0,5,62,89,185,0,35,0,2,252,65,33,0,7,0,35,
0,23,0,35,0,39,0,35,0,55,0,35,0,71,0,35,
0,87,0,35,0,103,0,35,0,119,0,35,0,135,0,35,
0,151,0,35,0,167,0,35,0,183,0,35,0,199,0,35,
0,215,0,35,0,231,0,35,0,247,0,35,0,16,93,65,
15,0,7,0,35,0,23,0,35,0,39,0,35,0,55,0,
35,0,71,0,35,0,87,0,35,0,103,0,35,0,7,113,
65,5,0,118,0,35,0,134,0,35,0,2,113,48,49,1,
30,5,21,20,14,4,35,34,46,2,53,17,52,38,39,53,
33,21,14,1,21,17,20,30,2,51,50,62,2,53,52,46,
4,7,39,55,3,109,45,79,65,50,34,18,42,74,104,122,
138,72,88,154,114,65,73,72,1,194,68,77,41,77,111,71,
64,129,104,66,16,35,55,78,101,64,22,230,5,10,8,53,
80,103,114,120,58,110,202,174,142,101,55,57,117,178,122,2,
199,12,36,14,43,43,14,34,14,253,107,96,152,106,56,85,
156,223,138,49,110,109,100,75,44,1,61,57,0,1,0,30,
0,0,5,116,4,246,0,63,0,172,184,0,64,47,184,0,
65,47,184,0,64,16,184,0,0,208,184,0,0,47,184,0,
65,16,184,0,26,220,185,0,37,0,4,252,186,0,14,0,
26,0,37,17,18,57,184,0,0,16,185,0,53,0,4,252,
65,19,0,6,0,53,0,22,0,53,0,38,0,53,0,54,
0,53,0,70,0,53,0,86,0,53,0,102,0,53,0,118,
0,53,0,134,0,53,0,9,93,65,5,0,149,0,53,0,
165,0,53,0,2,93,0,184,0,0,69,88,184,0,5,47,
27,185,0,5,0,11,62,89,184,0,0,69,88,184,0,19,
47,27,185,0,19,0,11,62,89,184,0,0,69,88,184,0,
32,47,27,185,0,32,0,5,62,89,186,0,14,0,32,0,
5,17,18,57,48,49,19,52,62,2,59,1,50,30,2,23,
30,1,23,1,54,38,39,53,33,21,14,1,7,1,17,20,
30,2,23,21,33,53,62,1,53,17,46,3,39,46,3,35,
34,14,2,21,20,22,23,14,3,7,46,1,30,58,89,104,
46,2,55,73,51,35,15,72,143,70,1,12,15,49,77,1,
140,69,73,14,254,176,17,39,63,47,254,22,91,73,36,77,
78,76,34,20,37,34,34,18,20,38,30,18,38,31,3,31,
44,49,21,37,48,3,235,68,100,66,33,16,27,37,20,95,
250,145,1,215,26,30,10,43,43,13,27,26,253,158,254,86,
6,17,20,20,9,43,43,19,39,14,1,166,78,151,141,125,
51,31,36,20,5,17,34,52,36,36,56,14,6,22,22,20,
4,16,76,0,0,1,255,209,254,12,5,101,5,10,0,158,
1,47,0,184,0,0,69,88,184,0,119,47,27,185,0,119,
0,9,62,89,184,0,0,69,88,184,0,135,47,27,185,0,
135,0,11,62,89,184,0,0,69,88,184,0,30,47,27,185,
0,30,0,7,62,89,184,0,0,69,88,184,0,33,47,27,
185,0,33,0,7,62,89,184,0,0,69,88,184,0,35,47,
27,185,0,35,0,7,62,89,184,0,0,69,88,184,0,37,
47,27,185,0,37,0,7,62,89,184,0,0,69,88,184,0,
39,47,27,185,0,39,0,7,62,89,184,0,35,16,185,0,
76,0,2,252,184,0,79,208,184,0,79,47,184,0,81,208,
184,0,83,208,184,0,85,208,184,0,85,47,184,0,87,208,
184,0,87,47,186,0,127,0,37,0,135,17,18,57,184,0,
135,16,185,0,149,0,2,252,65,5,0,121,0,149,0,137,
0,149,0,2,113,65,33,0,8,0,149,0,24,0,149,0,
40,0,149,0,56,0,149,0,72,0,149,0,88,0,149,0,
104,0,149,0,120,0,149,0,136,0,149,0,152,0,149,0,
168,0,149,0,184,0,149,0,200,0,149,0,216,0,149,0,
232,0,149,0,248,0,149,0,16,93,65,15,0,8,0,149,
0,24,0,149,0,40,0,149,0,56,0,149,0,72,0,149,
0,88,0,149,0,104,0,149,0,7,113,184,0,151,208,48,
49,5,14,1,7,14,1,7,14,1,7,14,1,7,14,1,
7,14,1,7,14,1,7,14,1,7,14,1,7,14,1,7,
14,1,35,6,7,6,35,34,35,34,46,2,39,52,38,49,
38,53,39,53,52,54,53,54,55,62,1,55,62,1,55,54,
55,22,23,30,1,23,30,1,23,30,1,31,1,50,22,51,
22,51,50,51,50,55,50,55,54,55,62,1,55,54,55,54,
55,62,1,55,54,55,62,1,55,62,1,55,62,1,55,62,
1,63,1,1,46,1,39,53,33,21,14,3,23,27,1,53,
19,62,3,51,50,30,2,21,20,14,2,7,46,2,35,34,
35,34,14,2,15,1,3,2,29,7,13,8,7,14,8,15,
31,16,3,6,2,8,17,8,6,11,6,17,34,17,14,28,
14,6,11,5,6,11,5,3,5,3,21,20,5,5,5,5,
26,50,42,32,7,1,3,1,1,5,15,2,1,2,10,23,
14,20,24,9,10,4,6,4,2,4,2,5,7,5,15,4,
7,4,11,8,9,8,8,4,4,2,12,8,3,6,4,8,
5,7,6,2,3,2,11,8,4,6,4,20,37,17,14,22,
11,2,1,2,23,254,183,9,52,50,1,130,39,49,27,4,
6,246,156,98,44,107,114,112,49,30,59,45,28,22,34,42,
19,20,35,31,14,13,11,31,65,62,57,22,43,221,93,18,
33,16,17,30,14,29,49,22,4,7,3,11,18,9,6,12,
5,16,25,11,9,14,6,2,4,2,2,2,2,1,1,4,
2,1,7,11,15,8,1,1,3,3,1,2,2,2,2,12,
21,2,3,2,13,27,13,22,14,6,5,2,2,2,1,1,
1,2,1,2,3,1,1,1,1,2,2,2,1,2,4,2,
3,5,1,1,2,7,7,3,5,3,18,45,29,21,47,26,
3,6,3,62,3,80,28,29,11,43,43,5,10,15,22,16,
253,131,1,175,2,1,13,119,157,93,37,10,15,18,9,7,
35,41,40,12,12,13,5,34,64,93,60,113,253,175,0,1,
0,59,0,0,3,223,4,252,0,43,0,125,0,184,0,0,
69,88,184,0,32,47,27,185,0,32,0,11,62,89,184,0,
0,69,88,184,0,36,47,27,185,0,36,0,11,62,89,184,
0,0,69,88,184,0,38,47,27,185,0,38,0,11,62,89,
184,0,0,69,88,184,0,14,47,27,185,0,14,0,5,62,
89,187,0,42,0,2,0,0,0,4,43,184,0,42,16,184,
0,14,16,185,0,2,0,2,252,184,0,0,16,184,0,17,
208,184,0,42,16,184,0,22,208,184,0,38,16,185,0,24,
0,2,252,184,0,25,208,48,49,1,33,1,33,50,62,2,
55,23,14,3,7,33,39,1,35,39,62,1,55,33,1,33,
34,14,2,7,39,19,30,2,51,50,51,33,23,1,51,23,
3,98,254,247,254,187,2,11,21,34,31,32,19,55,2,3,
3,3,1,252,133,29,1,107,212,22,5,11,6,1,14,1,
34,254,53,16,38,36,32,11,57,29,27,45,43,23,23,29,
2,104,25,254,189,208,25,2,103,253,253,19,46,80,62,14,
32,78,79,75,29,45,2,58,25,15,34,16,1,199,22,48,
75,52,12,1,45,6,7,3,43,254,0,23,0,1,0,76,
0,0,3,61,3,178,0,41,0,125,0,184,0,0,69,88,
184,0,30,47,27,185,0,30,0,9,62,89,184,0,0,69,
88,184,0,34,47,27,185,0,34,0,9,62,89,184,0,0,
69,88,184,0,36,47,27,185,0,36,0,9,62,89,184,0,
0,69,88,184,0,12,47,27,185,0,12,0,5,62,89,187,
0,40,0,2,0,0,0,4,43,184,0,40,16,184,0,12,
16,185,0,2,0,2,252,184,0,0,16,184,0,15,208,184,
0,40,16,184,0,20,208,184,0,36,16,185,0,22,0,2,
252,184,0,23,208,48,49,1,35,3,33,50,54,55,23,20,
14,2,7,33,39,1,35,39,62,1,55,51,19,33,34,14,
2,7,39,55,30,2,51,50,51,33,23,1,51,23,2,219,
234,227,1,166,25,42,23,47,2,3,4,3,253,53,26,1,
2,150,23,5,10,8,213,234,254,166,16,33,31,27,10,49,
18,22,36,39,23,24,32,1,236,22,254,245,171,22,1,159,
254,187,77,91,10,32,72,68,58,18,45,1,114,22,16,36,
16,1,79,12,33,59,46,12,244,6,7,3,43,254,130,25,
0,1,0,94,255,226,3,208,4,252,0,69,1,38,187,0,
0,0,4,0,25,0,4,43,65,5,0,154,0,25,0,170,
0,25,0,2,93,65,19,0,9,0,25,0,25,0,25,0,
41,0,25,0,57,0,25,0,73,0,25,0,89,0,25,0,
105,0,25,0,121,0,25,0,137,0,25,0,9,93,0,184,
0,0,69,88,184,0,53,47,27,185,0,53,0,11,62,89,
184,0,0,69,88,184,0,57,47,27,185,0,57,0,11,62,
89,184,0,0,69,88,184,0,59,47,27,185,0,59,0,11,
62,89,184,0,0,69,88,184,0,5,47,27,185,0,5,0,
5,62,89,187,0,65,0,2,0,30,0,4,43,184,0,65,
16,184,0,5,16,185,0,20,0,2,252,65,33,0,7,0,
20,0,23,0,20,0,39,0,20,0,55,0,20,0,71,0,
20,0,87,0,20,0,103,0,20,0,119,0,20,0,135,0,
20,0,151,0,20,0,167,0,20,0,183,0,20,0,199,0,
20,0,215,0,20,0,231,0,20,0,247,0,20,0,16,93,
65,15,0,7,0,20,0,23,0,20,0,39,0,20,0,55,
0,20,0,71,0,20,0,87,0,20,0,103,0,20,0,7,
113,65,5,0,118,0,20,0,134,0,20,0,2,113,184,0,
59,16,185,0,45,0,2,252,186,0,62,0,30,0,65,17,
18,57,48,49,1,20,14,2,35,34,46,2,53,52,62,2,
55,30,3,51,50,62,2,53,52,46,2,35,34,6,15,1,
39,46,1,47,1,53,48,49,50,53,1,33,34,14,2,7,
39,19,30,2,51,50,51,33,23,1,62,1,51,50,30,2,
3,208,81,135,177,95,86,145,105,58,28,42,48,21,21,66,
79,86,42,63,110,80,46,40,76,108,68,45,80,48,49,2,
7,20,5,1,1,1,156,254,130,16,37,36,31,10,57,30,
21,37,39,23,24,32,2,57,25,254,164,17,32,16,65,122,
94,57,1,178,106,171,121,66,45,60,61,17,6,34,37,32,
3,37,64,47,27,34,72,111,76,60,112,85,52,27,23,25,
2,6,26,8,2,1,1,1,241,27,51,73,46,12,1,45,
6,7,3,43,254,81,3,4,46,91,134,0,0,1,0,90,
255,226,3,222,4,252,0,62,1,32,187,0,35,0,4,0,
0,0,4,43,184,0,35,16,65,19,0,6,0,35,0,22,
0,35,0,38,0,35,0,54,0,35,0,70,0,35,0,86,
0,35,0,102,0,35,0,118,0,35,0,134,0,35,0,9,
93,65,5,0,149,0,35,0,165,0,35,0,2,93,0,184,
0,0,69,88,184,0,14,47,27,185,0,14,0,11,62,89,
184,0,0,69,88,184,0,7,47,27,185,0,7,0,11,62,
89,184,0,0,69,88,184,0,10,47,27,185,0,10,0,11,
62,89,184,0,0,69,88,184,0,58,47,27,185,0,58,0,
5,62,89,186,0,5,0,58,0,14,17,18,57,184,0,10,
16,185,0,21,0,2,252,184,0,22,208,184,0,58,16,185,
0,40,0,2,252,65,33,0,7,0,40,0,23,0,40,0,
39,0,40,0,55,0,40,0,71,0,40,0,87,0,40,0,
103,0,40,0,119,0,40,0,135,0,40,0,151,0,40,0,
167,0,40,0,183,0,40,0,199,0,40,0,215,0,40,0,
231,0,40,0,247,0,40,0,16,93,65,15,0,7,0,40,
0,23,0,40,0,39,0,40,0,55,0,40,0,71,0,40,
0,87,0,40,0,103,0,40,0,7,113,65,5,0,118,0,
40,0,134,0,40,0,2,113,48,49,19,52,62,2,55,1,
55,33,50,51,50,62,1,55,19,7,46,3,35,33,1,7,
51,6,7,46,1,35,34,14,2,21,20,30,2,51,50,62,
2,39,62,3,55,23,20,14,4,35,34,46,2,90,60,105,
145,87,254,166,25,2,57,32,23,24,39,37,21,30,57,10,
31,36,37,16,254,130,1,80,1,1,17,41,26,69,23,56,
106,81,49,66,98,110,45,52,91,64,30,10,17,47,49,46,
18,27,34,64,87,106,119,62,73,152,124,79,1,98,93,145,
107,71,18,1,173,43,3,7,6,254,211,12,46,73,51,27,
254,105,1,43,45,14,9,38,73,106,67,87,120,74,32,28,
56,83,55,8,16,13,10,1,30,33,79,80,75,58,35,46,
95,145,0,1,0,40,254,12,3,116,3,178,0,63,1,32,
187,0,36,0,4,0,0,0,4,43,184,0,36,16,65,19,
0,6,0,36,0,22,0,36,0,38,0,36,0,54,0,36,
0,70,0,36,0,86,0,36,0,102,0,36,0,118,0,36,
0,134,0,36,0,9,93,65,5,0,149,0,36,0,165,0,
36,0,2,93,0,184,0,0,69,88,184,0,14,47,27,185,
0,14,0,9,62,89,184,0,0,69,88,184,0,7,47,27,
185,0,7,0,9,62,89,184,0,0,69,88,184,0,10,47,
27,185,0,10,0,9,62,89,184,0,0,69,88,184,0,59,
47,27,185,0,59,0,7,62,89,186,0,5,0,59,0,14,
17,18,57,184,0,10,16,185,0,21,0,2,252,184,0,22,
208,184,0,59,16,185,0,41,0,2,252,65,33,0,7,0,
41,0,23,0,41,0,39,0,41,0,55,0,41,0,71,0,
41,0,87,0,41,0,103,0,41,0,119,0,41,0,135,0,
41,0,151,0,41,0,167,0,41,0,183,0,41,0,199,0,
41,0,215,0,41,0,231,0,41,0,247,0,41,0,16,93,
65,15,0,7,0,41,0,23,0,41,0,39,0,41,0,55,
0,41,0,71,0,41,0,87,0,41,0,103,0,41,0,7,
113,65,5,0,118,0,41,0,134,0,41,0,2,113,48,49,
23,52,62,2,55,1,55,33,50,51,50,62,1,55,23,7,
46,3,35,33,1,14,3,7,46,1,35,34,14,2,21,20,
30,2,51,50,62,2,39,62,3,55,23,22,14,4,35,34,
46,2,40,55,107,160,106,254,129,25,1,233,32,23,24,39,
37,21,19,49,10,27,31,33,16,254,192,1,102,6,23,28,
29,13,16,46,23,64,107,78,43,54,86,107,52,45,87,63,
28,16,17,40,42,40,18,27,4,31,58,83,96,106,52,84,
152,114,68,96,89,161,129,89,17,1,242,43,3,7,6,244,
12,46,59,33,12,254,40,12,31,29,24,7,8,10,53,90,
120,67,87,131,87,43,28,53,77,49,8,16,13,10,1,30,
35,77,73,66,50,29,53,102,151,0,0,1,0,50,254,11,
3,68,3,178,0,93,1,212,184,0,94,47,184,0,95,47,
184,0,0,220,184,0,94,16,184,0,38,208,184,0,38,47,
185,0,12,0,4,252,65,19,0,6,0,12,0,22,0,12,
0,38,0,12,0,54,0,12,0,70,0,12,0,86,0,12,
0,102,0,12,0,118,0,12,0,134,0,12,0,9,93,65,
5,0,149,0,12,0,165,0,12,0,2,93,184,0,0,16,
185,0,48,0,4,252,65,5,0,154,0,48,0,170,0,48,
0,2,93,65,19,0,9,0,48,0,25,0,48,0,41,0,
48,0,57,0,48,0,73,0,48,0,89,0,48,0,105,0,
48,0,121,0,48,0,137,0,48,0,9,93,184,0,22,208,
184,0,22,47,184,0,0,16,184,0,25,208,184,0,25,47,
184,0,12,16,184,0,56,208,184,0,56,47,186,0,62,0,
38,0,25,17,18,57,184,0,12,16,184,0,65,208,184,0,
65,47,186,0,69,0,38,0,25,17,18,57,184,0,0,16,
184,0,85,208,184,0,85,47,0,184,0,0,69,88,184,0,
77,47,27,185,0,77,0,9,62,89,184,0,0,69,88,184,
0,81,47,27,185,0,81,0,9,62,89,184,0,0,69,88,
184,0,83,47,27,185,0,83,0,9,62,89,184,0,0,69,
88,184,0,33,47,27,185,0,33,0,7,62,89,187,0,89,
0,2,0,53,0,4,43,184,0,89,16,184,0,33,16,185,
0,17,0,2,252,65,33,0,7,0,17,0,23,0,17,0,
39,0,17,0,55,0,17,0,71,0,17,0,87,0,17,0,
103,0,17,0,119,0,17,0,135,0,17,0,151,0,17,0,
167,0,17,0,183,0,17,0,199,0,17,0,215,0,17,0,
231,0,17,0,247,0,17,0,16,93,65,15,0,7,0,17,
0,23,0,17,0,39,0,17,0,55,0,17,0,71,0,17,
0,87,0,17,0,103,0,17,0,7,113,65,5,0,118,0,
17,0,134,0,17,0,2,113,186,0,62,0,53,0,89,17,
18,57,184,0,83,16,185,0,69,0,2,252,184,0,70,208,
186,0,86,0,53,0,89,17,18,57,48,49,1,20,14,2,
7,14,5,21,20,30,2,51,50,62,2,39,62,1,55,23,
22,14,4,7,6,46,2,53,52,62,2,55,62,3,53,52,
46,2,35,34,6,7,39,62,3,55,15,2,46,1,39,1,
33,34,14,2,7,39,55,30,2,51,50,51,33,23,1,62,
1,51,50,30,2,3,32,30,70,117,88,69,97,66,38,20,
5,42,66,82,40,69,95,54,14,13,44,72,41,27,3,27,
56,81,99,115,62,81,128,90,47,36,85,140,103,77,93,50,
16,18,44,74,57,71,122,54,35,28,68,74,79,40,13,216,
25,7,23,5,1,159,254,184,16,33,31,27,10,49,19,21,
37,39,23,24,32,1,233,25,254,171,25,48,24,42,86,68,
43,1,24,50,85,70,55,21,16,35,35,36,37,36,17,41,
67,48,26,40,62,72,33,20,22,6,30,31,73,73,67,53,
32,1,1,41,70,92,50,54,95,81,67,26,19,36,38,44,
27,26,54,44,28,55,38,44,20,41,37,31,9,16,149,17,
5,31,8,1,242,12,33,59,46,12,244,6,7,3,43,254,
105,5,7,23,51,80,0,1,0,76,0,0,3,46,4,211,
0,62,0,154,187,0,55,0,4,0,29,0,4,43,184,0,
55,16,184,0,13,208,65,5,0,154,0,29,0,170,0,29,
0,2,93,65,19,0,9,0,29,0,25,0,29,0,41,0,
29,0,57,0,29,0,73,0,29,0,89,0,29,0,105,0,
29,0,121,0,29,0,137,0,29,0,9,93,184,0,55,16,
184,0,64,220,0,184,0,0,69,88,184,0,13,47,27,185,
0,13,0,5,62,89,187,0,50,0,2,0,34,0,4,43,
184,0,50,16,187,0,61,0,2,0,0,0,4,43,184,0,
61,16,184,0,13,16,185,0,4,0,2,252,184,0,0,16,
184,0,18,208,184,0,61,16,184,0,23,208,48,49,1,35,
14,1,7,33,50,62,3,53,23,3,33,39,62,1,55,35,
39,62,1,55,33,62,3,53,52,46,2,35,34,14,2,21,
14,3,7,39,52,62,2,51,50,30,2,21,20,14,2,7,
51,23,3,23,238,60,152,97,1,162,27,37,22,12,4,50,
15,253,74,29,114,170,63,199,23,5,10,8,1,11,46,60,
35,14,22,48,77,54,41,68,50,27,17,27,29,33,23,27,
70,116,147,77,60,105,77,44,20,42,67,46,167,22,1,234,
75,181,113,37,51,54,35,1,12,254,225,74,132,203,81,22,
16,36,16,63,98,81,69,33,46,79,59,33,38,60,74,35,
9,16,13,9,2,30,52,113,94,61,34,69,107,73,39,80,
89,103,61,25,0,1,0,50,255,226,3,149,4,236,0,65,
0,57,187,0,58,0,4,0,38,0,4,43,184,0,58,16,
0,184,0,0,69,88,184,0,50,47,27,185,0,50,0,9,
62,89,184,0,0,69,88,184,0,43,47,27,185,0,43,0,
11,62,89,185,0,56,0,2,252,48,49,1,20,14,2,35,
34,46,2,53,52,62,2,55,30,3,51,50,62,2,53,52,
46,2,35,34,6,7,46,1,39,55,7,17,52,38,39,53,
33,23,14,3,7,35,46,3,35,33,17,62,1,51,50,30,
2,3,149,65,115,157,91,86,136,93,49,28,42,48,21,21,
57,67,77,42,60,89,60,30,42,75,101,59,60,131,66,7,
23,5,1,3,74,72,3,50,31,2,10,15,17,7,48,3,
8,15,24,19,254,137,45,95,48,72,135,103,63,1,148,93,
159,116,66,45,60,61,17,6,34,37,32,3,37,64,47,27,
41,72,96,54,73,114,79,42,33,40,5,31,8,1,1,2,
11,12,36,14,43,25,26,80,87,84,28,64,91,58,27,254,
76,17,17,43,90,137,0,1,0,55,255,226,3,67,3,162,
0,65,0,16,187,0,58,0,4,0,38,0,4,43,184,0,
58,16,48,49,1,20,14,2,35,34,46,2,53,52,62,2,
55,30,3,51,50,62,2,53,52,46,2,35,34,6,7,46,
1,39,53,7,17,52,38,39,53,33,23,14,3,7,35,46,
3,35,33,17,62,1,51,50,30,2,3,67,56,102,142,85,
81,119,80,39,26,39,45,20,17,46,57,67,39,55,77,46,
21,36,65,88,52,56,99,61,6,22,4,2,72,68,2,217,
29,1,10,14,15,7,45,3,8,13,23,18,254,201,43,70,
46,63,119,93,56,1,37,66,117,89,51,36,48,49,13,4,
32,35,30,2,30,58,45,27,34,55,70,37,55,85,58,30,
26,29,5,22,6,1,1,1,124,9,26,11,43,18,19,67,
74,69,21,47,68,43,20,254,217,13,12,34,69,104,0,1,
0,20,255,226,2,254,5,0,0,67,0,205,187,0,0,0,
4,0,26,0,4,43,65,5,0,154,0,26,0,170,0,26,
0,2,93,65,19,0,9,0,26,0,25,0,26,0,41,0,
26,0,57,0,26,0,73,0,26,0,89,0,26,0,105,0,
26,0,121,0,26,0,137,0,26,0,9,93,0,184,0,0,
69,88,184,0,7,47,27,185,0,7,0,5,62,89,185,0,
21,0,2,252,65,33,0,7,0,21,0,23,0,21,0,39,
0,21,0,55,0,21,0,71,0,21,0,87,0,21,0,103,
0,21,0,119,0,21,0,135,0,21,0,151,0,21,0,167,
0,21,0,183,0,21,0,199,0,21,0,215,0,21,0,231,
0,21,0,247,0,21,0,16,93,65,15,0,7,0,21,0,
23,0,21,0,39,0,21,0,55,0,21,0,71,0,21,0,
87,0,21,0,103,0,21,0,7,113,65,5,0,118,0,21,
0,134,0,21,0,2,113,48,49,1,20,14,4,35,34,38,
39,46,1,62,1,55,23,30,3,51,50,62,2,53,52,46,
2,39,46,3,61,2,35,39,55,51,53,55,23,17,33,23,
14,3,7,46,1,43,1,21,30,3,23,30,3,2,254,40,
64,78,76,67,19,48,135,67,7,5,3,9,7,43,2,40,
67,89,52,36,60,44,24,43,70,89,46,42,78,61,37,129,
21,78,72,119,31,1,71,29,9,27,28,27,10,24,98,81,
52,1,33,55,71,41,43,88,70,44,1,27,71,101,70,42,
22,7,36,37,3,59,77,78,23,11,42,74,56,32,23,42,
59,35,40,62,51,45,24,21,48,60,74,48,1,135,28,66,
246,104,25,254,187,29,14,31,29,22,4,12,23,93,31,49,
43,40,21,22,50,65,83,0,0,2,0,55,254,32,3,176,
3,192,0,15,0,54,1,63,184,0,55,47,184,0,56,47,
184,0,16,220,185,0,0,0,4,252,65,5,0,154,0,0,
0,170,0,0,0,2,93,65,19,0,9,0,0,0,25,0,
0,0,41,0,0,0,57,0,0,0,73,0,0,0,89,0,
0,0,105,0,0,0,121,0,0,0,137,0,0,0,9,93,
184,0,55,16,184,0,31,208,184,0,31,47,185,0,22,0,
4,252,184,0,10,208,186,0,11,0,31,0,16,17,18,57,
184,0,22,16,184,0,45,208,184,0,45,47,0,184,0,0,
69,88,184,0,43,47,27,185,0,43,0,9,62,89,184,0,
0,69,88,184,0,50,47,27,185,0,50,0,9,62,89,184,
0,0,69,88,184,0,26,47,27,185,0,26,0,7,62,89,
184,0,50,16,185,0,5,0,2,252,65,5,0,121,0,5,
0,137,0,5,0,2,113,65,33,0,8,0,5,0,24,0,
5,0,40,0,5,0,56,0,5,0,72,0,5,0,88,0,
5,0,104,0,5,0,120,0,5,0,136,0,5,0,152,0,
5,0,168,0,5,0,184,0,5,0,200,0,5,0,216,0,
5,0,232,0,5,0,248,0,5,0,16,93,65,15,0,8,
0,5,0,24,0,5,0,40,0,5,0,56,0,5,0,72,
0,5,0,88,0,5,0,104,0,5,0,7,113,186,0,11,
0,26,0,43,17,18,57,184,0,37,208,186,0,45,0,26,
0,43,17,18,57,48,49,1,52,46,2,35,34,14,2,7,
17,62,3,55,20,14,2,7,21,20,22,23,21,33,53,62,
1,53,17,52,46,2,39,53,62,3,55,31,1,62,3,51,
50,30,2,3,33,24,43,58,33,26,66,77,85,44,123,174,
109,50,143,63,142,228,166,75,94,254,53,66,74,8,29,55,
48,34,62,58,57,29,35,9,50,101,96,88,36,53,87,61,
33,2,84,57,89,61,31,22,51,87,64,253,141,83,156,150,
149,141,102,192,191,194,105,253,16,32,14,43,43,16,29,17,
4,62,37,48,29,13,2,40,7,17,19,23,14,35,198,60,
88,57,28,34,72,113,0,1,0,150,255,216,1,44,6,14,
0,12,0,25,187,0,0,0,4,0,6,0,4,43,184,0,
11,208,0,184,0,5,47,184,0,10,47,48,49,37,14,3,
7,39,17,62,1,55,23,17,1,44,9,29,32,33,12,35,
28,57,29,36,12,8,15,14,11,4,23,5,238,17,24,8,
22,250,20,0,0,2,0,150,255,216,2,128,6,14,0,12,
0,25,0,71,184,0,26,47,184,0,27,47,184,0,26,16,
184,0,6,208,184,0,6,47,185,0,0,0,4,252,184,0,
11,208,184,0,27,16,184,0,13,220,185,0,19,0,4,252,
184,0,13,16,184,0,24,208,0,184,0,5,47,184,0,18,
47,184,0,10,47,184,0,23,47,48,49,37,14,3,7,39,
17,62,1,55,23,17,33,14,3,7,39,17,62,1,55,23,
17,1,44,9,29,32,33,12,35,28,57,29,36,1,84,9,
29,32,33,12,35,28,57,29,36,12,8,15,14,11,4,23,
5,238,17,24,8,22,250,20,8,15,14,11,4,23,5,238,
17,24,8,22,250,20,0,1,0,18,255,216,2,100,6,14,
0,36,0,147,187,0,0,0,4,0,6,0,4,43,184,0,
6,16,184,0,13,208,184,0,6,16,184,0,20,208,184,0,
0,16,184,0,25,208,184,0,0,16,184,0,30,208,184,0,
0,16,184,0,35,208,0,184,0,24,47,184,0,5,47,184,
0,0,69,88,184,0,19,47,27,185,0,19,0,9,62,89,
184,0,0,69,88,184,0,26,47,27,185,0,26,0,9,62,
89,187,0,13,0,2,0,7,0,4,43,184,0,13,16,184,
0,26,16,185,0,14,0,2,252,184,0,15,208,184,0,29,
208,184,0,30,208,184,0,13,16,184,0,31,208,184,0,7,
16,184,0,34,208,48,49,37,14,3,7,39,17,35,39,62,
1,55,51,53,35,39,62,1,55,51,17,62,1,55,23,17,
51,23,7,35,21,51,23,7,35,17,1,134,9,29,32,33,
12,35,200,22,5,9,8,200,200,22,5,9,8,200,28,57,
29,36,200,22,22,200,200,22,22,200,12,8,15,14,11,4,
23,2,145,22,16,36,16,110,22,16,36,16,2,59,17,24,
8,22,253,170,25,65,110,25,65,253,140,0,0,2,0,154,
255,216,1,135,6,14,0,15,0,25,0,83,187,0,0,0,
4,0,8,0,4,43,65,5,0,154,0,8,0,170,0,8,
0,2,93,65,19,0,9,0,8,0,25,0,8,0,41,0,
8,0,57,0,8,0,73,0,8,0,89,0,8,0,105,0,
8,0,121,0,8,0,137,0,8,0,9,93,0,184,0,24,
47,186,0,13,0,5,0,3,43,184,0,13,16,48,49,37,
20,14,2,35,34,38,53,52,62,2,51,50,22,39,14,1,
7,39,3,62,1,55,23,1,135,21,37,50,29,53,47,22,
38,50,29,51,47,65,19,30,25,29,47,38,84,34,43,123,
35,59,44,25,58,54,34,59,45,26,59,212,14,17,8,21,
4,73,25,43,14,25,255,255,0,41,0,0,8,157,6,209,
0,38,0,36,0,0,0,39,0,58,4,190,0,0,0,7,
5,132,8,235,1,64,255,255,0,41,0,0,7,251,5,195,
0,38,0,36,0,0,0,39,0,90,4,190,0,0,0,7,
2,169,8,160,0,0,255,255,0,80,255,226,7,102,6,14,
0,38,0,68,0,0,0,39,0,90,4,41,0,0,0,7,
2,169,8,11,0,0,255,255,0,50,254,132,5,250,4,236,
0,38,0,44,0,0,0,7,0,42,3,207,0,0,255,255,
0,50,254,12,5,60,5,76,0,38,0,44,0,0,0,7,
0,74,3,207,0,0,255,255,0,60,254,12,3,152,6,14,
0,38,0,76,0,0,0,7,0,74,2,43,0,0,255,255,
0,50,254,132,7,92,4,236,0,38,0,46,0,0,0,7,
0,42,5,49,0,0,255,255,0,50,254,12,6,158,5,76,
0,38,0,46,0,0,0,7,0,74,5,49,0,0,255,255,
0,55,254,12,5,215,5,76,0,38,0,78,0,0,0,7,
0,74,4,106,0,0,255,255,0,0,0,0,4,174,6,209,
2,38,0,33,0,0,0,7,5,132,4,89,1,64,255,255,
0,80,255,226,3,158,5,195,2,38,0,65,0,0,0,7,
2,169,3,226,0,0,255,255,255,234,0,0,2,99,6,209,
2,38,0,41,0,0,0,7,5,132,3,41,1,64,255,255,
255,224,0,0,2,89,5,195,2,38,0,176,0,0,0,7,
2,169,3,31,0,0,255,255,0,70,255,226,4,114,6,209,
2,38,0,47,0,0,0,7,5,132,4,105,1,64,255,255,
0,80,255,226,3,182,5,195,2,38,0,79,0,0,0,7,
2,169,4,25,0,0,255,255,0,50,255,226,4,251,6,209,
2,38,0,53,0,0,0,7,5,132,4,167,1,64,255,255,
0,41,255,226,4,45,5,195,2,38,0,85,0,0,0,7,
2,169,4,35,0,0,255,255,0,50,255,226,4,251,7,113,
2,38,0,53,0,0,0,39,5,131,4,168,1,64,0,7,
5,129,4,178,2,128,255,255,0,41,255,226,4,45,6,129,
2,38,0,85,0,0,0,39,2,165,4,36,0,0,0,7,
2,161,4,46,1,104,255,255,0,50,255,226,4,251,8,1,
2,38,0,53,0,0,0,39,5,131,4,168,1,64,0,7,
5,126,4,196,2,128,255,255,0,41,255,226,4,45,7,57,
2,38,0,85,0,0,0,39,2,165,4,36,0,0,0,7,
2,158,4,64,1,104,255,255,0,50,255,226,4,251,8,17,
2,38,0,53,0,0,0,39,5,131,4,168,1,64,0,7,
5,132,4,167,2,128,255,255,0,41,255,226,4,45,7,43,
2,38,0,85,0,0,0,39,2,165,4,36,0,0,0,7,
2,169,4,35,1,104,255,255,0,50,255,226,4,251,8,1,
2,38,0,53,0,0,0,39,5,131,4,168,1,64,0,7,
5,125,4,86,2,128,255,255,0,41,255,226,4,45,7,57,
2,38,0,85,0,0,0,39,2,165,4,36,0,0,0,7,
2,157,3,210,1,104,0,2,0,70,255,226,3,82,3,192,
0,11,0,52,1,179,184,0,53,47,184,0,54,47,184,0,
12,220,185,0,30,0,4,252,184,0,3,208,184,0,3,47,
184,0,53,16,184,0,23,208,184,0,23,47,185,0,7,0,
4,252,65,19,0,6,0,7,0,22,0,7,0,38,0,7,
0,54,0,7,0,70,0,7,0,86,0,7,0,102,0,7,
0,118,0,7,0,134,0,7,0,9,93,65,5,0,149,0,
7,0,165,0,7,0,2,93,184,0,30,16,184,0,15,208,
184,0,15,47,184,0,7,16,184,0,29,208,184,0,29,47,
184,0,23,16,184,0,43,208,184,0,43,47,0,184,0,0,
69,88,184,0,48,47,27,185,0,48,0,9,62,89,184,0,
0,69,88,184,0,18,47,27,185,0,18,0,5,62,89,187,
0,30,0,2,0,3,0,4,43,184,0,30,16,184,0,18,
16,185,0,0,0,2,252,65,33,0,7,0,0,0,23,0,
0,0,39,0,0,0,55,0,0,0,71,0,0,0,87,0,
0,0,103,0,0,0,119,0,0,0,135,0,0,0,151,0,
0,0,167,0,0,0,183,0,0,0,199,0,0,0,215,0,
0,0,231,0,0,0,247,0,0,0,16,93,65,15,0,7,
0,0,0,23,0,0,0,39,0,0,0,55,0,0,0,71,
0,0,0,87,0,0,0,103,0,0,0,7,113,65,5,0,
118,0,0,0,134,0,0,0,2,113,184,0,48,16,185,0,
35,0,2,252,65,5,0,121,0,35,0,137,0,35,0,2,
113,65,33,0,8,0,35,0,24,0,35,0,40,0,35,0,
56,0,35,0,72,0,35,0,88,0,35,0,104,0,35,0,
120,0,35,0,136,0,35,0,152,0,35,0,168,0,35,0,
184,0,35,0,200,0,35,0,216,0,35,0,232,0,35,0,
248,0,35,0,16,93,65,15,0,8,0,35,0,24,0,35,
0,40,0,35,0,56,0,35,0,72,0,35,0,88,0,35,
0,104,0,35,0,7,113,48,49,37,50,54,55,33,34,6,
21,20,30,2,1,20,6,7,14,1,35,34,46,2,53,52,
54,55,62,1,55,33,46,3,35,34,14,2,7,46,1,39,
62,3,51,50,30,2,1,188,115,126,12,254,112,31,35,38,
61,76,1,188,79,69,57,139,90,72,126,94,54,19,17,29,
70,35,1,203,2,49,81,109,61,27,56,66,80,51,13,20,
6,61,103,93,88,46,73,137,107,64,74,155,152,48,40,47,
80,59,33,1,155,118,203,74,62,58,47,83,113,66,40,66,
23,15,32,14,82,132,93,49,8,24,45,37,6,29,8,64,
81,45,16,65,122,177,255,255,0,0,0,0,4,174,7,113,
2,38,0,33,0,0,0,39,5,131,4,90,1,64,0,7,
5,129,4,100,2,128,255,255,0,80,255,226,3,158,6,129,
2,38,0,65,0,0,0,39,2,165,3,227,0,0,0,7,
2,161,3,237,1,104,255,255,0,0,0,0,4,174,7,113,
2,38,0,33,0,0,0,39,5,130,4,90,1,64,0,7,
5,129,4,100,2,128,255,255,0,80,255,226,3,158,6,129,
2,38,0,65,0,0,0,39,2,164,3,227,0,0,0,7,
2,161,3,237,1,104,255,255,0,0,0,0,6,0,6,49,
2,38,0,125,0,0,0,7,5,129,5,169,1,64,255,255,
0,80,255,226,5,57,5,25,2,38,0,153,0,0,0,7,
2,161,4,239,0,0,0,1,0,70,255,226,4,146,5,10,
0,75,1,207,184,0,76,47,184,0,77,47,184,0,56,220,
184,0,0,208,184,0,0,47,184,0,76,16,184,0,66,208,
184,0,66,47,185,0,18,0,4,252,65,19,0,6,0,18,
0,22,0,18,0,38,0,18,0,54,0,18,0,70,0,18,
0,86,0,18,0,102,0,18,0,118,0,18,0,134,0,18,
0,9,93,65,5,0,149,0,18,0,165,0,18,0,2,93,
184,0,56,16,185,0,26,0,4,252,184,0,33,208,184,0,
56,16,184,0,45,208,184,0,56,16,184,0,50,208,184,0,
56,16,184,0,54,208,184,0,54,47,0,184,0,0,69,88,
184,0,71,47,27,185,0,71,0,11,62,89,184,0,0,69,
88,184,0,61,47,27,185,0,61,0,5,62,89,186,0,40,
0,28,0,3,43,184,0,40,16,184,0,71,16,185,0,11,
0,2,252,65,5,0,121,0,11,0,137,0,11,0,2,113,
65,33,0,8,0,11,0,24,0,11,0,40,0,11,0,56,
0,11,0,72,0,11,0,88,0,11,0,104,0,11,0,120,
0,11,0,136,0,11,0,152,0,11,0,168,0,11,0,184,
0,11,0,200,0,11,0,216,0,11,0,232,0,11,0,248,
0,11,0,16,93,65,15,0,8,0,11,0,24,0,11,0,
40,0,11,0,56,0,11,0,72,0,11,0,88,0,11,0,
104,0,11,0,7,113,184,0,61,16,185,0,23,0,2,252,
65,33,0,7,0,23,0,23,0,23,0,39,0,23,0,55,
0,23,0,71,0,23,0,87,0,23,0,103,0,23,0,119,
0,23,0,135,0,23,0,151,0,23,0,167,0,23,0,183,
0,23,0,199,0,23,0,215,0,23,0,231,0,23,0,247,
0,23,0,16,93,65,15,0,7,0,23,0,23,0,23,0,
39,0,23,0,55,0,23,0,71,0,23,0,87,0,23,0,
103,0,23,0,7,113,65,5,0,118,0,23,0,134,0,23,
0,2,113,184,0,28,16,185,0,33,0,2,252,184,0,46,
208,184,0,28,16,184,0,49,208,184,0,27,16,184,0,50,
208,48,49,1,22,14,2,7,39,46,3,35,34,14,4,21,
20,30,2,51,50,54,55,53,33,39,62,1,55,33,53,52,
46,2,39,53,33,21,14,1,29,1,51,23,7,35,21,48,
6,7,22,23,14,3,35,34,46,2,53,52,18,62,1,51,
50,30,2,4,18,7,18,33,39,13,33,33,70,77,86,49,
25,75,83,84,66,42,75,120,151,76,73,123,49,254,186,22,
5,11,6,1,70,19,47,79,61,1,205,57,48,105,25,25,
105,2,2,2,2,74,117,98,88,45,101,196,155,96,105,182,
243,137,33,79,82,79,4,164,5,29,36,35,12,6,31,41,
22,9,23,51,83,121,161,104,139,206,135,67,29,27,159,24,
15,35,16,110,11,21,20,20,10,43,43,14,45,23,110,23,
67,145,2,1,1,2,61,72,39,12,75,153,229,155,166,1,
7,183,96,14,26,38,0,4,255,206,254,12,4,26,3,192,
0,8,0,22,0,42,0,127,2,82,187,0,95,0,4,0,
81,0,4,43,184,0,95,16,187,0,43,0,4,0,23,0,
4,43,184,0,43,16,65,5,0,154,0,23,0,170,0,23,
0,2,93,65,19,0,9,0,23,0,25,0,23,0,41,0,
23,0,57,0,23,0,73,0,23,0,89,0,23,0,105,0,
23,0,121,0,23,0,137,0,23,0,9,93,186,0,3,0,
23,0,43,17,18,57,186,0,105,0,81,0,95,17,18,57,
184,0,105,47,185,0,33,0,4,252,186,0,4,0,105,0,
33,17,18,57,186,0,17,0,105,0,33,17,18,57,184,0,
43,16,184,0,18,208,184,0,18,47,184,0,43,16,185,0,
62,0,4,252,184,0,65,208,184,0,65,47,186,0,92,0,
81,0,62,17,18,57,186,0,100,0,81,0,62,17,18,57,
186,0,125,0,23,0,43,17,18,57,184,0,43,16,184,0,
129,220,0,184,0,0,69,88,184,0,110,47,27,185,0,110,
0,9,62,89,184,0,0,69,88,184,0,118,47,27,185,0,
118,0,9,62,89,184,0,0,69,88,184,0,74,47,27,185,
0,74,0,7,62,89,187,0,18,0,2,0,3,0,4,43,
184,0,18,16,187,0,38,0,2,0,48,0,4,43,184,0,
38,16,184,0,74,16,185,0,0,0,2,252,65,33,0,7,
0,0,0,23,0,0,0,39,0,0,0,55,0,0,0,71,
0,0,0,87,0,0,0,103,0,0,0,119,0,0,0,135,
0,0,0,151,0,0,0,167,0,0,0,183,0,0,0,199,
0,0,0,215,0,0,0,231,0,0,0,247,0,0,0,16,
93,65,15,0,7,0,0,0,23,0,0,0,39,0,0,0,
55,0,0,0,71,0,0,0,87,0,0,0,103,0,0,0,
7,113,65,5,0,118,0,0,0,134,0,0,0,2,113,184,
0,110,16,185,0,28,0,2,252,65,5,0,121,0,28,0,
137,0,28,0,2,113,65,33,0,8,0,28,0,24,0,28,
0,40,0,28,0,56,0,28,0,72,0,28,0,88,0,28,
0,104,0,28,0,120,0,28,0,136,0,28,0,152,0,28,
0,168,0,28,0,184,0,28,0,200,0,28,0,216,0,28,
0,232,0,28,0,248,0,28,0,16,93,65,15,0,8,0,
28,0,24,0,28,0,40,0,28,0,56,0,28,0,72,0,
28,0,88,0,28,0,104,0,28,0,7,113,184,0,18,16,
184,0,65,208,184,0,3,16,184,0,68,208,184,0,3,16,
184,0,81,208,184,0,18,16,184,0,86,208,186,0,92,0,
74,0,110,17,18,57,186,0,100,0,48,0,38,17,18,57,
186,0,125,0,74,0,110,17,18,57,48,49,1,50,54,55,
33,30,3,19,46,1,39,14,3,7,33,46,3,19,52,46,
2,35,34,14,2,21,20,30,2,51,50,62,2,55,20,14,
2,43,1,14,1,21,20,30,2,23,30,3,21,20,6,7,
51,23,7,35,14,3,35,34,46,4,39,35,39,62,1,55,
51,62,3,55,46,1,53,52,62,2,55,46,3,53,52,62,
2,51,50,22,23,62,3,55,23,14,1,7,14,1,7,30,
1,2,10,106,148,28,253,155,15,63,88,107,54,38,64,28,
52,71,47,25,6,2,121,2,28,69,115,84,35,69,103,67,
25,61,54,36,33,67,103,71,29,63,51,33,140,69,112,142,
73,5,47,36,21,57,100,78,109,142,84,33,1,1,60,22,
22,87,28,102,128,145,71,46,99,95,87,67,41,2,57,23,
5,10,8,78,11,38,59,82,56,65,50,10,31,56,46,51,
83,59,32,66,108,138,73,60,105,43,52,84,67,52,21,20,
12,22,23,38,73,46,26,29,254,116,86,70,33,57,42,24,
1,136,4,10,6,28,47,41,35,15,27,45,36,28,2,102,
53,94,70,41,25,50,75,49,53,95,71,41,26,50,75,91,
77,127,92,51,39,53,6,12,23,21,21,9,12,48,63,72,
35,8,14,8,25,65,58,96,68,38,13,26,42,58,74,47,
22,16,36,16,19,43,48,52,30,23,58,30,8,27,38,50,
32,14,53,76,95,56,73,131,97,57,34,31,5,16,18,18,
8,30,28,47,25,7,8,2,38,86,255,255,0,70,255,226,
4,121,6,209,2,38,0,39,0,0,0,7,5,132,4,130,
1,64,255,255,0,30,254,12,3,221,5,195,2,38,0,71,
0,0,0,7,2,169,3,246,0,0,255,255,0,50,255,242,
4,150,6,209,2,38,0,43,0,0,0,7,5,132,4,80,
1,64,255,255,0,55,255,246,4,0,7,203,2,38,0,75,
0,0,0,7,5,132,4,29,2,58,255,255,0,70,254,68,
4,114,5,10,2,38,0,47,0,0,0,7,2,197,4,116,
0,0,255,255,0,80,254,68,3,182,3,192,2,38,0,79,
0,0,0,7,2,197,4,15,0,0,255,255,0,70,254,68,
4,114,6,49,2,38,0,47,0,0,0,39,2,197,4,116,
0,0,0,7,5,129,4,116,1,64,255,255,0,80,254,68,
3,182,5,25,2,38,0,79,0,0,0,39,2,197,4,15,
0,0,0,7,2,161,4,36,0,0,255,255,0,94,255,226,
3,208,6,209,2,38,1,148,0,0,0,7,5,132,4,25,
1,64,255,255,0,38,254,12,3,82,5,195,2,38,2,81,
0,0,0,7,2,169,3,190,0,0,255,255,255,16,254,12,
2,64,5,195,2,38,5,99,0,0,0,7,2,169,3,6,
0,0,255,255,0,41,0,0,8,157,5,10,0,38,0,36,
0,0,0,7,0,58,4,190,0,0,255,255,0,41,0,0,
7,251,5,10,0,38,0,36,0,0,0,7,0,90,4,190,
0,0,255,255,0,80,255,226,7,102,6,14,0,38,0,68,
0,0,0,7,0,90,4,41,0,0,255,255,0,70,255,226,
4,121,6,193,2,38,0,39,0,0,0,7,5,126,4,159,
1,64,255,255,0,30,254,12,3,221,5,209,2,38,0,71,
0,0,0,7,2,158,4,19,0,0,0,1,0,50,255,226,
6,255,4,236,0,74,1,82,187,0,70,0,4,0,4,0,
4,43,184,0,70,16,187,0,27,0,4,0,65,0,4,43,
184,0,27,16,187,0,53,0,4,0,37,0,4,43,184,0,
53,16,184,0,70,16,184,0,14,208,184,0,65,16,184,0,
16,208,65,5,0,154,0,37,0,170,0,37,0,2,93,65,
19,0,9,0,37,0,25,0,37,0,41,0,37,0,57,0,
37,0,73,0,37,0,89,0,37,0,105,0,37,0,121,0,
37,0,137,0,37,0,9,93,184,0,65,16,184,0,67,208,
184,0,53,16,184,0,76,220,0,184,0,0,69,88,184,0,
9,47,27,185,0,9,0,11,62,89,184,0,0,69,88,184,
0,21,47,27,185,0,21,0,11,62,89,184,0,0,69,88,
184,0,0,47,27,185,0,0,0,5,62,89,184,0,0,69,
88,184,0,60,47,27,185,0,60,0,5,62,89,187,0,16,
0,2,0,68,0,4,43,184,0,16,16,184,0,60,16,185,
0,32,0,2,252,65,33,0,7,0,32,0,23,0,32,0,
39,0,32,0,55,0,32,0,71,0,32,0,87,0,32,0,
103,0,32,0,119,0,32,0,135,0,32,0,151,0,32,0,
167,0,32,0,183,0,32,0,199,0,32,0,215,0,32,0,
231,0,32,0,247,0,32,0,16,93,65,15,0,7,0,32,
0,23,0,32,0,39,0,32,0,55,0,32,0,71,0,32,
0,87,0,32,0,103,0,32,0,7,113,65,5,0,118,0,
32,0,134,0,32,0,2,113,48,49,51,53,62,1,53,17,
52,38,39,53,33,21,14,1,21,17,33,17,52,38,39,53,
33,21,14,1,21,17,20,30,2,51,50,62,2,53,52,46,
2,47,1,62,3,55,30,3,21,20,14,4,35,34,46,2,
61,3,33,17,20,22,23,21,50,68,77,73,72,1,194,68,
77,2,98,73,72,1,194,68,77,43,66,79,37,73,109,73,
37,29,62,96,67,16,16,52,56,53,17,43,81,63,38,40,
70,94,108,118,58,57,120,98,63,253,158,72,73,43,14,33,
14,4,27,12,36,14,43,43,14,34,14,254,62,1,194,12,
36,14,43,43,14,34,14,252,241,84,110,64,26,65,104,129,
65,77,144,113,69,2,41,7,18,17,16,5,14,72,114,156,
100,70,133,119,99,73,40,28,78,140,113,192,9,85,254,1,
12,35,14,43,0,2,0,55,254,32,3,246,5,10,0,11,
0,46,1,73,184,0,47,47,184,0,48,47,184,0,12,220,
185,0,0,0,4,252,65,5,0,154,0,0,0,170,0,0,
0,2,93,65,19,0,9,0,0,0,25,0,0,0,41,0,
0,0,57,0,0,0,73,0,0,0,89,0,0,0,105,0,
0,0,121,0,0,0,137,0,0,0,9,93,184,0,47,16,
184,0,25,208,184,0,25,47,185,0,16,0,4,252,184,0,
8,208,186,0,9,0,25,0,12,17,18,57,184,0,16,16,
184,0,36,208,186,0,37,0,25,0,12,17,18,57,0,184,
0,0,69,88,184,0,35,47,27,185,0,35,0,11,62,89,
184,0,0,69,88,184,0,42,47,27,185,0,42,0,11,62,
89,184,0,0,69,88,184,0,20,47,27,185,0,20,0,7,
62,89,184,0,42,16,185,0,3,0,2,252,65,5,0,121,
0,3,0,137,0,3,0,2,113,65,33,0,8,0,3,0,
24,0,3,0,40,0,3,0,56,0,3,0,72,0,3,0,
88,0,3,0,104,0,3,0,120,0,3,0,136,0,3,0,
152,0,3,0,168,0,3,0,184,0,3,0,200,0,3,0,
216,0,3,0,232,0,3,0,248,0,3,0,16,93,65,15,
0,8,0,3,0,24,0,3,0,40,0,3,0,56,0,3,
0,72,0,3,0,88,0,3,0,104,0,3,0,7,113,186,
0,9,0,20,0,35,17,18,57,184,0,31,208,184,0,31,
47,186,0,37,0,20,0,35,17,18,57,48,49,1,52,38,
35,34,14,2,7,17,54,0,55,20,0,5,17,20,22,23,
21,33,53,62,1,53,17,52,46,2,39,53,62,1,55,23,
21,62,3,51,50,30,2,3,93,98,90,22,69,84,95,48,
248,1,2,153,254,184,254,181,75,94,254,43,66,74,8,29,
55,48,69,137,59,35,54,109,102,88,32,64,102,71,37,3,
128,131,137,22,51,87,64,253,71,167,1,78,218,204,254,86,
209,254,14,16,32,14,43,43,16,29,17,5,133,37,47,27,
13,5,43,14,37,29,35,188,60,85,53,25,37,80,124,0,
255,255,0,50,255,226,5,0,6,193,2,38,0,46,0,0,
0,7,5,125,4,74,1,64,255,255,0,55,0,0,4,76,
5,209,2,38,0,78,0,0,0,7,2,157,3,242,0,0,
255,255,0,0,0,0,4,174,8,121,2,38,0,33,0,0,
0,39,2,167,4,90,1,64,0,7,5,126,4,118,2,248,
255,255,0,80,255,226,3,158,7,57,2,38,0,65,0,0,
0,39,2,167,3,227,0,0,0,7,5,126,3,255,1,184,
255,255,0,0,0,0,6,0,6,193,2,38,0,125,0,0,
0,7,5,126,5,187,1,64,255,255,0,80,255,226,5,57,
5,209,2,38,0,153,0,0,0,7,2,158,5,1,0,0,
255,255,0,70,255,203,4,115,6,193,2,38,0,141,0,0,
0,7,5,126,4,123,1,64,255,255,0,80,255,203,3,182,
5,209,2,38,0,170,0,0,0,7,2,158,4,44,0,0,
255,255,0,0,0,0,4,174,7,17,2,38,0,33,0,0,
0,7,2,172,4,115,1,64,255,255,0,80,255,226,3,158,
5,209,2,38,0,65,0,0,0,7,2,172,3,252,0,0,
255,255,0,0,0,0,4,174,6,179,2,38,0,33,0,0,
0,7,2,174,4,90,1,64,255,255,0,80,255,226,3,158,
5,115,2,38,0,65,0,0,0,7,2,174,3,227,0,0,
255,255,0,50,0,0,3,186,7,17,2,38,0,37,0,0,
0,7,2,172,4,18,1,64,255,255,0,80,255,226,3,98,
5,209,2,38,0,69,0,0,0,7,2,172,4,26,0,0,
255,255,0,50,0,0,3,186,6,179,2,38,0,37,0,0,
0,7,2,174,3,249,1,64,255,255,0,80,255,226,3,98,
5,115,2,38,0,69,0,0,0,7,2,174,4,1,0,0,
255,255,255,171,0,0,2,11,7,17,2,38,0,41,0,0,
0,7,2,172,3,67,1,64,255,255,255,161,0,0,2,1,
5,209,2,38,0,176,0,0,0,7,2,172,3,57,0,0,
255,255,255,226,0,0,2,108,6,179,2,38,0,41,0,0,
0,7,2,174,3,42,1,64,255,255,255,216,0,0,2,98,
5,115,2,38,0,176,0,0,0,7,2,174,3,32,0,0,
255,255,0,70,255,226,4,114,7,17,2,38,0,47,0,0,
0,7,2,172,4,131,1,64,255,255,0,80,255,226,3,182,
5,209,2,38,0,79,0,0,0,7,2,172,4,51,0,0,
255,255,0,70,255,226,4,114,6,179,2,38,0,47,0,0,
0,7,2,174,4,106,1,64,255,255,0,80,255,226,3,182,
5,115,2,38,0,79,0,0,0,7,2,174,4,26,0,0,
255,255,0,41,255,242,4,115,7,17,2,38,0,50,0,0,
0,7,2,172,4,36,1,64,255,255,0,55,0,0,3,11,
5,209,2,38,0,82,0,0,0,7,2,172,3,222,0,0,
255,255,0,41,255,242,4,115,6,179,2,38,0,50,0,0,
0,7,2,174,4,11,1,64,255,255,0,55,0,0,3,11,
5,115,2,38,0,82,0,0,0,7,2,174,3,197,0,0,
255,255,0,50,255,226,4,251,7,17,2,38,0,53,0,0,
0,7,2,172,4,193,1,64,255,255,0,41,255,226,4,45,
5,209,2,38,0,85,0,0,0,7,2,172,4,61,0,0,
255,255,0,50,255,226,4,251,6,179,2,38,0,53,0,0,
0,7,2,174,4,168,1,64,255,255,0,41,255,226,4,45,
5,115,2,38,0,85,0,0,0,7,2,174,4,36,0,0,
255,255,0,117,254,5,3,117,5,10,2,38,0,51,0,0,
0,7,2,195,3,252,0,0,255,255,0,94,254,5,2,188,
3,192,2,38,0,83,0,0,0,7,2,195,3,149,0,0,
255,255,0,10,254,5,4,59,4,236,2,38,0,52,0,0,
0,7,2,195,4,42,0,0,255,255,0,20,254,5,2,164,
5,0,2,38,0,84,0,0,0,7,2,195,3,100,0,0,
0,1,0,113,255,2,3,174,5,10,0,72,1,37,187,0,
0,0,4,0,15,0,4,43,65,5,0,154,0,15,0,170,
0,15,0,2,93,65,19,0,9,0,15,0,25,0,15,0,
41,0,15,0,57,0,15,0,73,0,15,0,89,0,15,0,
105,0,15,0,121,0,15,0,137,0,15,0,9,93,186,0,
63,0,15,0,0,17,18,57,184,0,63,47,185,0,38,0,
4,252,65,5,0,154,0,38,0,170,0,38,0,2,93,65,
19,0,9,0,38,0,25,0,38,0,41,0,38,0,57,0,
38,0,73,0,38,0,89,0,38,0,105,0,38,0,121,0,
38,0,137,0,38,0,9,93,0,184,0,7,47,184,0,0,
69,88,184,0,58,47,27,185,0,58,0,11,62,89,185,0,
43,0,2,252,65,5,0,121,0,43,0,137,0,43,0,2,
113,65,33,0,8,0,43,0,24,0,43,0,40,0,43,0,
56,0,43,0,72,0,43,0,88,0,43,0,104,0,43,0,
120,0,43,0,136,0,43,0,152,0,43,0,168,0,43,0,
184,0,43,0,200,0,43,0,216,0,43,0,232,0,43,0,
248,0,43,0,16,93,65,15,0,8,0,43,0,24,0,43,
0,40,0,43,0,56,0,43,0,72,0,43,0,88,0,43,
0,104,0,43,0,7,113,186,0,68,0,7,0,58,17,18,
57,48,49,1,20,14,3,4,7,46,1,39,62,3,53,52,
46,2,35,34,6,7,48,49,52,51,14,1,7,46,1,39,
62,3,53,52,46,2,7,14,1,15,1,46,2,53,52,55,
62,3,51,50,30,2,21,20,14,2,7,50,30,2,3,174,
13,51,99,172,254,255,183,10,15,6,184,249,150,64,51,78,
92,42,29,56,26,1,30,63,35,4,17,5,115,186,132,71,
47,77,100,52,134,139,12,45,11,19,11,8,65,103,97,104,
66,72,130,97,57,23,57,97,74,64,103,74,40,1,134,39,
91,103,111,118,121,61,24,38,20,66,131,126,122,57,57,75,
43,18,5,6,1,14,26,14,12,47,21,50,102,108,116,64,
51,78,53,26,1,2,122,121,8,33,84,75,27,27,4,31,
41,25,10,34,68,104,69,44,90,91,94,49,39,68,94,0,
0,1,0,66,254,12,3,28,3,192,0,67,1,23,187,0,
0,0,4,0,15,0,4,43,65,5,0,154,0,15,0,170,
0,15,0,2,93,65,19,0,9,0,15,0,25,0,15,0,
41,0,15,0,57,0,15,0,73,0,15,0,89,0,15,0,
105,0,15,0,121,0,15,0,137,0,15,0,9,93,186,0,
60,0,15,0,0,17,18,57,184,0,60,47,185,0,38,0,
4,252,65,5,0,154,0,38,0,170,0,38,0,2,93,65,
19,0,9,0,38,0,25,0,38,0,41,0,38,0,57,0,
38,0,73,0,38,0,89,0,38,0,105,0,38,0,121,0,
38,0,137,0,38,0,9,93,0,184,0,0,69,88,184,0,
55,47,27,185,0,55,0,9,62,89,185,0,41,0,2,252,
65,5,0,121,0,41,0,137,0,41,0,2,113,65,33,0,
8,0,41,0,24,0,41,0,40,0,41,0,56,0,41,0,
72,0,41,0,88,0,41,0,104,0,41,0,120,0,41,0,
136,0,41,0,152,0,41,0,168,0,41,0,184,0,41,0,
200,0,41,0,216,0,41,0,232,0,41,0,248,0,41,0,
16,93,65,15,0,8,0,41,0,24,0,41,0,40,0,41,
0,56,0,41,0,72,0,41,0,88,0,41,0,104,0,41,
0,7,113,48,49,37,20,14,4,7,46,1,39,62,3,53,
52,46,2,35,34,6,7,48,49,52,51,14,1,7,46,1,
39,62,3,53,52,38,7,14,3,15,1,46,3,55,62,1,
51,50,30,2,21,20,14,2,7,30,1,3,28,19,53,91,
145,205,139,14,17,8,118,194,137,75,30,49,64,33,23,46,
21,1,26,55,30,3,13,5,97,143,94,45,103,84,54,91,
67,42,5,39,17,27,15,1,9,105,204,114,46,100,83,54,
19,47,78,59,103,115,125,47,98,101,105,108,110,56,12,33,
15,54,122,129,132,65,50,68,42,18,5,6,1,14,28,14,
11,39,20,63,106,101,102,57,90,98,1,1,32,61,88,57,
8,32,74,65,47,5,60,64,22,56,95,73,46,87,86,86,
45,17,119,0,255,255,0,50,0,0,4,246,6,209,2,38,
0,40,0,0,0,7,5,132,4,150,1,64,255,255,0,55,
0,0,4,76,7,203,2,38,0,72,0,0,0,7,5,132,
4,67,2,58,0,2,0,90,255,226,4,26,5,11,0,17,
0,79,1,153,187,0,8,0,4,0,64,0,4,43,184,0,
8,16,187,0,44,0,4,0,33,0,4,43,184,0,44,16,
65,5,0,154,0,33,0,170,0,33,0,2,93,65,19,0,
9,0,33,0,25,0,33,0,41,0,33,0,57,0,33,0,
73,0,33,0,89,0,33,0,105,0,33,0,121,0,33,0,
137,0,33,0,9,93,186,0,0,0,33,0,44,17,18,57,
184,0,0,47,65,5,0,154,0,0,0,170,0,0,0,2,
93,65,19,0,9,0,0,0,25,0,0,0,41,0,0,0,
57,0,0,0,73,0,0,0,89,0,0,0,105,0,0,0,
121,0,0,0,137,0,0,0,9,93,65,19,0,6,0,8,
0,22,0,8,0,38,0,8,0,54,0,8,0,70,0,8,
0,86,0,8,0,102,0,8,0,118,0,8,0,134,0,8,
0,9,93,65,5,0,149,0,8,0,165,0,8,0,2,93,
185,0,54,0,4,252,186,0,18,0,64,0,54,17,18,57,
186,0,74,0,64,0,8,17,18,57,184,0,74,47,185,0,
23,0,4,252,186,0,49,0,64,0,54,17,18,57,186,0,
69,0,64,0,54,17,18,57,184,0,54,16,184,0,81,220,
0,184,0,0,69,88,184,0,59,47,27,185,0,59,0,5,
62,89,185,0,13,0,2,252,65,33,0,7,0,13,0,23,
0,13,0,39,0,13,0,55,0,13,0,71,0,13,0,87,
0,13,0,103,0,13,0,119,0,13,0,135,0,13,0,151,
0,13,0,167,0,13,0,183,0,13,0,199,0,13,0,215,
0,13,0,231,0,13,0,247,0,13,0,16,93,65,15,0,
7,0,13,0,23,0,13,0,39,0,13,0,55,0,13,0,
71,0,13,0,87,0,13,0,103,0,13,0,7,113,65,5,
0,118,0,13,0,134,0,13,0,2,113,48,49,1,52,46,
2,39,14,1,21,20,30,2,51,50,62,2,1,14,3,21,
20,30,2,23,62,3,53,52,46,2,39,55,54,30,2,21,
20,14,2,7,30,3,21,20,14,2,35,34,46,2,53,52,
62,2,55,46,3,53,52,62,2,55,3,127,74,118,148,74,
110,126,55,95,128,73,71,111,77,40,254,51,38,50,30,12,
50,84,110,60,56,76,46,19,12,47,91,79,16,66,130,102,
63,25,57,93,67,65,122,95,57,80,139,189,109,110,165,112,
56,39,74,107,69,45,77,57,33,27,57,88,61,1,107,73,
100,72,53,26,72,162,84,65,104,75,40,45,77,100,3,88,
15,33,37,40,21,35,53,44,38,21,29,61,62,64,32,15,
49,51,45,12,44,1,26,54,80,53,38,74,74,70,33,25,
64,88,117,77,92,162,123,71,59,100,134,75,54,107,101,90,
36,19,44,56,70,44,30,69,66,57,19,0,0,2,0,80,
255,226,3,182,5,244,0,17,0,77,1,153,187,0,8,0,
4,0,62,0,4,43,184,0,8,16,187,0,52,0,4,0,
0,0,4,43,184,0,52,16,65,5,0,154,0,0,0,170,
0,0,0,2,93,65,19,0,9,0,0,0,25,0,0,0,
41,0,0,0,57,0,0,0,73,0,0,0,89,0,0,0,
105,0,0,0,121,0,0,0,137,0,0,0,9,93,65,19,
0,6,0,8,0,22,0,8,0,38,0,8,0,54,0,8,
0,70,0,8,0,86,0,8,0,102,0,8,0,118,0,8,
0,134,0,8,0,9,93,65,5,0,149,0,8,0,165,0,
8,0,2,93,186,0,18,0,62,0,52,17,18,57,186,0,
72,0,62,0,8,17,18,57,184,0,72,47,185,0,23,0,
3,252,186,0,44,0,0,0,52,17,18,57,184,0,44,47,
185,0,33,0,4,252,65,5,0,154,0,33,0,170,0,33,
0,2,93,65,19,0,9,0,33,0,25,0,33,0,41,0,
33,0,57,0,33,0,73,0,33,0,89,0,33,0,105,0,
33,0,121,0,33,0,137,0,33,0,9,93,186,0,47,0,
62,0,52,17,18,57,186,0,67,0,62,0,52,17,18,57,
184,0,52,16,184,0,79,220,0,184,0,0,69,88,184,0,
57,47,27,185,0,57,0,5,62,89,185,0,13,0,2,252,
65,33,0,7,0,13,0,23,0,13,0,39,0,13,0,55,
0,13,0,71,0,13,0,87,0,13,0,103,0,13,0,119,
0,13,0,135,0,13,0,151,0,13,0,167,0,13,0,183,
0,13,0,199,0,13,0,215,0,13,0,231,0,13,0,247,
0,13,0,16,93,65,15,0,7,0,13,0,23,0,13,0,
39,0,13,0,55,0,13,0,71,0,13,0,87,0,13,0,
103,0,13,0,7,113,65,5,0,118,0,13,0,134,0,13,
0,2,113,48,49,1,52,46,2,39,14,1,21,20,30,2,
51,50,62,2,1,14,3,21,20,30,2,23,62,3,53,52,
46,2,39,55,54,30,2,21,20,6,7,30,3,21,20,14,
2,35,34,46,2,53,52,62,2,55,46,3,53,52,62,2,
55,3,29,59,95,120,62,109,119,47,82,111,65,63,97,65,
34,254,109,34,45,27,12,42,70,94,52,54,73,45,20,12,
42,82,70,14,59,117,94,59,109,127,61,117,90,55,74,127,
170,97,97,150,102,53,41,75,107,67,44,77,58,33,24,50,
78,54,1,178,93,129,91,63,27,88,194,114,76,132,97,56,
61,100,127,3,225,17,37,42,46,25,42,63,51,44,22,34,
74,77,78,39,18,60,62,55,14,40,1,29,61,93,63,91,
178,79,30,74,104,140,95,108,189,139,81,70,118,158,88,67,
133,123,109,43,21,49,64,82,55,31,67,65,57,23,0,1,
0,59,254,157,3,241,4,252,0,37,0,99,0,184,0,27,
47,184,0,0,69,88,184,0,9,47,27,185,0,9,0,11,
62,89,184,0,0,69,88,184,0,13,47,27,185,0,13,0,
11,62,89,184,0,0,69,88,184,0,15,47,27,185,0,15,
0,11,62,89,184,0,0,69,88,184,0,36,47,27,185,0,
36,0,5,62,89,184,0,15,16,185,0,1,0,2,252,184,
0,2,208,184,0,36,16,185,0,18,0,2,252,48,49,55,
1,33,34,14,2,7,39,19,30,2,51,50,51,33,23,1,
33,50,22,7,14,3,7,39,62,3,53,52,38,35,33,59,
2,199,254,53,16,38,36,32,11,57,29,27,45,43,23,23,
29,2,104,25,253,63,2,54,85,82,2,1,33,75,124,92,
34,60,72,39,13,50,60,253,134,45,4,91,22,48,75,52,
12,1,45,6,7,3,43,251,163,63,66,30,71,82,92,51,
41,38,66,56,43,15,42,54,0,1,0,76,254,192,3,81,
3,178,0,39,0,95,0,184,0,8,47,184,0,0,69,88,
184,0,30,47,27,185,0,30,0,9,62,89,184,0,0,69,
88,184,0,34,47,27,185,0,34,0,9,62,89,184,0,0,
69,88,184,0,36,47,27,185,0,36,0,9,62,89,184,0,
0,69,88,184,0,19,47,27,185,0,19,0,5,62,89,185,
0,0,0,2,252,184,0,36,16,185,0,22,0,2,252,184,
0,23,208,48,49,37,50,22,7,14,3,7,39,62,3,55,
54,46,2,35,33,39,1,33,34,14,2,7,39,55,30,2,
51,50,51,33,23,1,2,180,77,80,2,1,29,65,105,77,
34,52,65,35,13,1,1,8,20,33,24,253,252,26,2,43,
254,166,16,33,31,27,10,49,18,22,36,39,23,24,32,1,
236,22,253,211,90,53,66,30,66,72,80,43,41,33,57,48,
40,15,14,30,26,16,45,3,27,12,33,59,46,12,244,6,
7,3,43,252,227,0,255,255,0,0,0,0,4,174,6,100,
2,38,0,33,0,0,0,7,5,130,4,90,1,64,255,255,
0,80,255,226,3,158,5,76,2,38,0,65,0,0,0,7,
2,164,3,227,0,0,255,255,0,50,254,68,3,186,4,236,
2,38,0,37,0,0,0,7,2,196,3,247,0,0,255,255,
0,80,254,68,3,98,3,192,2,38,0,69,0,0,0,7,
2,196,3,245,0,0,255,255,0,70,255,226,4,114,7,113,
2,38,0,47,0,0,0,39,5,131,4,106,1,64,0,7,
5,129,4,116,2,128,255,255,0,80,255,226,3,182,6,129,
2,38,0,79,0,0,0,39,2,165,4,26,0,0,0,7,
2,161,4,36,1,104,255,255,0,70,255,226,4,114,7,113,
2,38,0,47,0,0,0,39,5,128,4,106,1,64,0,7,
5,129,4,116,2,128,255,255,0,80,255,226,3,182,6,129,
2,38,0,79,0,0,0,39,2,160,4,26,0,0,0,7,
2,161,4,36,1,104,255,255,0,70,255,226,4,114,6,100,
2,38,0,47,0,0,0,7,5,130,4,106,1,64,255,255,
0,80,255,226,3,182,5,76,2,38,0,79,0,0,0,7,
2,164,4,26,0,0,255,255,0,70,255,226,4,114,7,113,
2,38,0,47,0,0,0,39,5,130,4,106,1,64,0,7,
5,129,4,116,2,128,255,255,0,80,255,226,3,182,6,129,
2,38,0,79,0,0,0,39,2,164,4,26,0,0,0,7,
2,161,4,36,1,104,255,255,0,0,0,0,4,152,6,49,
2,38,0,57,0,0,0,7,5,129,4,105,1,64,255,255,
255,209,254,12,3,221,5,25,2,38,0,89,0,0,0,7,
2,161,4,31,0,0,0,2,0,55,255,226,3,120,3,192,
0,16,0,74,1,188,184,0,75,47,184,0,76,47,184,0,
75,16,184,0,67,208,184,0,67,47,185,0,43,0,4,252,
184,0,5,208,184,0,76,16,184,0,36,220,185,0,12,0,
4,252,65,5,0,154,0,12,0,170,0,12,0,2,93,65,
19,0,9,0,12,0,25,0,12,0,41,0,12,0,57,0,
12,0,73,0,12,0,89,0,12,0,105,0,12,0,121,0,
12,0,137,0,12,0,9,93,184,0,43,16,184,0,26,208,
184,0,26,47,184,0,36,16,184,0,59,208,184,0,59,47,
0,184,0,0,69,88,184,0,20,47,27,185,0,20,0,9,
62,89,184,0,0,69,88,184,0,31,47,27,185,0,31,0,
9,62,89,184,0,0,69,88,184,0,64,47,27,185,0,64,
0,5,62,89,184,0,31,16,185,0,0,0,2,252,65,5,
0,121,0,0,0,137,0,0,0,2,113,65,33,0,8,0,
0,0,24,0,0,0,40,0,0,0,56,0,0,0,72,0,
0,0,88,0,0,0,104,0,0,0,120,0,0,0,136,0,
0,0,152,0,0,0,168,0,0,0,184,0,0,0,200,0,
0,0,216,0,0,0,232,0,0,0,248,0,0,0,16,93,
65,15,0,8,0,0,0,24,0,0,0,40,0,0,0,56,
0,0,0,72,0,0,0,88,0,0,0,104,0,0,0,7,
113,186,0,26,0,64,0,20,17,18,57,184,0,64,16,185,
0,48,0,2,252,65,33,0,7,0,48,0,23,0,48,0,
39,0,48,0,55,0,48,0,71,0,48,0,87,0,48,0,
103,0,48,0,119,0,48,0,135,0,48,0,151,0,48,0,
167,0,48,0,183,0,48,0,199,0,48,0,215,0,48,0,
231,0,48,0,247,0,48,0,16,93,65,15,0,7,0,48,
0,23,0,48,0,39,0,48,0,55,0,48,0,71,0,48,
0,87,0,48,0,103,0,48,0,7,113,65,5,0,118,0,
48,0,134,0,48,0,2,113,184,0,0,16,184,0,73,208,
48,49,1,34,14,2,7,21,55,62,3,53,52,46,2,37,
62,1,55,23,48,30,2,23,62,3,51,50,30,2,21,20,
14,2,15,1,21,20,30,2,55,62,3,55,62,3,31,1,
14,3,35,34,38,53,17,52,46,2,39,53,2,104,30,64,
67,72,38,119,68,99,64,30,24,35,37,253,194,64,119,57,
35,1,3,4,2,45,92,87,78,33,36,76,61,40,43,85,
126,84,205,16,38,65,49,32,63,51,33,2,1,44,57,56,
12,14,24,97,123,141,69,110,119,19,36,52,33,3,62,24,
43,57,33,232,24,12,46,62,75,41,40,50,28,11,50,14,
39,27,35,36,52,61,25,48,77,54,30,24,52,82,58,59,
107,88,65,17,42,138,34,59,43,24,2,1,14,30,47,34,
9,23,18,10,3,39,56,90,64,34,115,103,2,41,31,38,
21,8,1,40,0,2,0,80,255,226,3,241,3,192,0,17,
0,65,1,189,187,0,9,0,4,0,34,0,4,43,184,0,
9,16,187,0,49,0,4,0,0,0,4,43,184,0,49,16,
65,19,0,6,0,9,0,22,0,9,0,38,0,9,0,54,
0,9,0,70,0,9,0,86,0,9,0,102,0,9,0,118,
0,9,0,134,0,9,0,9,93,65,5,0,149,0,9,0,
165,0,9,0,2,93,184,0,0,16,184,0,24,208,184,0,
24,47,184,0,49,16,184,0,55,208,184,0,55,47,184,0,
49,16,184,0,67,220,0,184,0,0,69,88,184,0,41,47,
27,185,0,41,0,9,62,89,184,0,0,69,88,184,0,49,
47,27,185,0,49,0,9,62,89,184,0,0,69,88,184,0,
21,47,27,185,0,21,0,5,62,89,184,0,0,69,88,184,
0,29,47,27,185,0,29,0,5,62,89,184,0,41,16,185,
0,4,0,2,252,65,5,0,121,0,4,0,137,0,4,0,
2,113,65,33,0,8,0,4,0,24,0,4,0,40,0,4,
0,56,0,4,0,72,0,4,0,88,0,4,0,104,0,4,
0,120,0,4,0,136,0,4,0,152,0,4,0,168,0,4,
0,184,0,4,0,200,0,4,0,216,0,4,0,232,0,4,
0,248,0,4,0,16,93,65,15,0,8,0,4,0,24,0,
4,0,40,0,4,0,56,0,4,0,72,0,4,0,88,0,
4,0,104,0,4,0,7,113,184,0,29,16,185,0,14,0,
2,252,65,33,0,7,0,14,0,23,0,14,0,39,0,14,
0,55,0,14,0,71,0,14,0,87,0,14,0,103,0,14,
0,119,0,14,0,135,0,14,0,151,0,14,0,167,0,14,
0,183,0,14,0,199,0,14,0,215,0,14,0,231,0,14,
0,247,0,14,0,16,93,65,15,0,7,0,14,0,23,0,
14,0,39,0,14,0,55,0,14,0,71,0,14,0,87,0,
14,0,103,0,14,0,7,113,65,5,0,118,0,14,0,134,
0,14,0,2,113,186,0,24,0,21,0,41,17,18,57,48,
49,1,17,46,1,35,34,14,2,21,20,30,2,51,50,54,
55,5,14,1,35,34,38,39,14,3,35,34,46,2,53,52,
62,4,51,50,30,2,23,62,1,55,23,48,14,2,21,17,
20,22,23,22,54,55,52,30,1,2,193,32,92,71,64,103,
73,40,46,72,87,42,48,104,76,1,48,87,120,14,42,36,
4,42,71,71,74,43,55,115,95,60,30,56,81,102,122,69,
27,46,46,51,32,28,56,30,28,9,11,9,9,8,9,65,
51,6,6,1,16,1,202,57,63,47,94,140,94,85,139,98,
53,76,80,172,59,55,87,105,53,74,45,20,65,122,176,111,
57,122,114,102,77,44,7,20,37,30,16,45,33,30,33,57,
75,42,254,43,60,76,9,13,10,23,1,24,20,0,0,2,
0,55,255,226,3,203,3,192,0,18,0,61,1,209,184,0,
62,47,184,0,63,47,184,0,62,16,184,0,51,208,184,0,
51,47,185,0,4,0,4,252,184,0,63,16,184,0,32,220,
185,0,14,0,4,252,65,5,0,154,0,14,0,170,0,14,
0,2,93,65,19,0,9,0,14,0,25,0,14,0,41,0,
14,0,57,0,14,0,73,0,14,0,89,0,14,0,105,0,
14,0,121,0,14,0,137,0,14,0,9,93,184,0,4,16,
184,0,24,208,184,0,24,47,184,0,4,16,184,0,42,208,
184,0,51,16,184,0,45,208,184,0,45,47,0,184,0,0,
69,88,184,0,27,47,27,185,0,27,0,9,62,89,184,0,
0,69,88,184,0,61,47,27,185,0,61,0,9,62,89,184,
0,0,69,88,184,0,39,47,27,185,0,39,0,5,62,89,
184,0,0,69,88,184,0,45,47,27,185,0,45,0,5,62,
89,184,0,27,16,185,0,0,0,2,252,65,5,0,121,0,
0,0,137,0,0,0,2,113,65,33,0,8,0,0,0,24,
0,0,0,40,0,0,0,56,0,0,0,72,0,0,0,88,
0,0,0,104,0,0,0,120,0,0,0,136,0,0,0,152,
0,0,0,168,0,0,0,184,0,0,0,200,0,0,0,216,
0,0,0,232,0,0,0,248,0,0,0,16,93,65,15,0,
8,0,0,0,24,0,0,0,40,0,0,0,56,0,0,0,
72,0,0,0,88,0,0,0,104,0,0,0,7,113,184,0,
39,16,185,0,9,0,2,252,65,33,0,7,0,9,0,23,
0,9,0,39,0,9,0,55,0,9,0,71,0,9,0,87,
0,9,0,103,0,9,0,119,0,9,0,135,0,9,0,151,
0,9,0,167,0,9,0,183,0,9,0,199,0,9,0,215,
0,9,0,231,0,9,0,247,0,9,0,16,93,65,15,0,
7,0,9,0,23,0,9,0,39,0,9,0,55,0,9,0,
71,0,9,0,87,0,9,0,103,0,9,0,7,113,65,5,
0,118,0,9,0,134,0,9,0,2,113,186,0,24,0,39,
0,27,17,18,57,184,0,0,16,184,0,57,208,48,49,1,
34,6,7,17,30,3,51,50,62,2,53,52,46,2,37,48,
30,2,23,62,1,51,50,30,2,21,20,14,4,35,34,38,
39,14,1,7,39,48,62,2,53,17,52,46,2,39,53,62,
1,55,2,81,55,118,75,22,61,65,66,27,47,85,65,38,
40,65,81,254,207,1,3,3,2,88,162,76,55,110,87,54,
31,55,76,89,98,51,44,119,63,37,74,40,28,9,11,9,
10,30,55,45,56,128,56,3,62,102,89,254,87,24,41,31,
18,41,86,134,94,96,141,93,45,95,37,55,63,27,111,106,
56,116,179,123,57,122,114,102,77,44,68,55,17,62,44,30,
33,57,75,42,1,250,38,48,28,11,2,40,14,38,28,0,
0,2,0,140,255,226,3,181,6,14,0,20,0,72,1,159,
184,0,73,47,184,0,74,47,184,0,21,220,185,0,0,0,
4,252,65,5,0,154,0,0,0,170,0,0,0,2,93,65,
19,0,9,0,0,0,25,0,0,0,41,0,0,0,57,0,
0,0,73,0,0,0,89,0,0,0,105,0,0,0,121,0,
0,0,137,0,0,0,9,93,184,0,73,16,184,0,33,208,
184,0,33,47,185,0,11,0,4,252,184,0,62,208,186,0,
63,0,33,0,21,17,18,57,0,184,0,0,69,88,184,0,
68,47,27,185,0,68,0,9,62,89,184,0,0,69,88,184,
0,28,47,27,185,0,28,0,5,62,89,187,0,44,0,2,
0,57,0,4,43,184,0,44,16,184,0,68,16,185,0,5,
0,2,252,65,5,0,121,0,5,0,137,0,5,0,2,113,
65,33,0,8,0,5,0,24,0,5,0,40,0,5,0,56,
0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,120,
0,5,0,136,0,5,0,152,0,5,0,168,0,5,0,184,
0,5,0,200,0,5,0,216,0,5,0,232,0,5,0,248,
0,5,0,16,93,65,15,0,8,0,5,0,24,0,5,0,
40,0,5,0,56,0,5,0,72,0,5,0,88,0,5,0,
104,0,5,0,7,113,184,0,28,16,185,0,16,0,2,252,
65,33,0,7,0,16,0,23,0,16,0,39,0,16,0,55,
0,16,0,71,0,16,0,87,0,16,0,103,0,16,0,119,
0,16,0,135,0,16,0,151,0,16,0,167,0,16,0,183,
0,16,0,199,0,16,0,215,0,16,0,231,0,16,0,247,
0,16,0,16,93,65,15,0,7,0,16,0,23,0,16,0,
39,0,16,0,55,0,16,0,71,0,16,0,87,0,16,0,
103,0,16,0,7,113,65,5,0,118,0,16,0,134,0,16,
0,2,113,186,0,63,0,28,0,68,17,18,57,48,49,1,
52,46,2,35,34,14,2,7,17,30,3,51,50,62,2,55,
20,14,4,35,34,46,2,39,17,52,62,2,55,62,3,51,
50,30,2,21,20,14,2,7,46,1,35,34,14,2,29,1,
62,3,51,50,30,2,3,48,42,69,90,48,18,59,74,84,
42,40,83,75,61,18,61,93,63,32,133,30,58,83,107,128,
74,19,67,87,102,54,34,63,88,54,27,67,67,59,19,45,
85,66,40,29,40,43,15,42,114,59,32,78,67,45,50,99,
91,78,29,68,115,83,46,1,152,100,155,106,56,21,49,83,
62,254,105,30,40,23,10,53,87,110,142,58,122,116,104,77,
45,17,32,47,30,3,17,124,179,133,98,43,22,34,24,12,
33,44,43,9,8,32,33,30,7,52,64,46,113,189,143,209,
60,88,57,28,64,121,174,0,0,1,0,66,255,226,3,77,
3,192,0,54,1,187,184,0,55,47,184,0,56,47,184,0,
0,220,184,0,55,16,184,0,10,208,184,0,10,47,185,0,
22,0,4,252,65,19,0,6,0,22,0,22,0,22,0,38,
0,22,0,54,0,22,0,70,0,22,0,86,0,22,0,102,
0,22,0,118,0,22,0,134,0,22,0,9,93,65,5,0,
149,0,22,0,165,0,22,0,2,93,184,0,0,16,185,0,
32,0,4,252,65,5,0,154,0,32,0,170,0,32,0,2,
93,65,19,0,9,0,32,0,25,0,32,0,41,0,32,0,
57,0,32,0,73,0,32,0,89,0,32,0,105,0,32,0,
121,0,32,0,137,0,32,0,9,93,184,0,10,16,184,0,
45,208,184,0,45,47,0,184,0,0,69,88,184,0,50,47,
27,185,0,50,0,9,62,89,184,0,0,69,88,184,0,5,
47,27,185,0,5,0,5,62,89,185,0,27,0,2,252,65,
33,0,7,0,27,0,23,0,27,0,39,0,27,0,55,0,
27,0,71,0,27,0,87,0,27,0,103,0,27,0,119,0,
27,0,135,0,27,0,151,0,27,0,167,0,27,0,183,0,
27,0,199,0,27,0,215,0,27,0,231,0,27,0,247,0,
27,0,16,93,65,15,0,7,0,27,0,23,0,27,0,39,
0,27,0,55,0,27,0,71,0,27,0,87,0,27,0,103,
0,27,0,7,113,65,5,0,118,0,27,0,134,0,27,0,
2,113,184,0,50,16,185,0,37,0,2,252,65,5,0,121,
0,37,0,137,0,37,0,2,113,65,33,0,8,0,37,0,
24,0,37,0,40,0,37,0,56,0,37,0,72,0,37,0,
88,0,37,0,104,0,37,0,120,0,37,0,136,0,37,0,
152,0,37,0,168,0,37,0,184,0,37,0,200,0,37,0,
216,0,37,0,232,0,37,0,248,0,37,0,16,93,65,15,
0,8,0,37,0,24,0,37,0,40,0,37,0,56,0,37,
0,72,0,37,0,88,0,37,0,104,0,37,0,7,113,48,
49,1,20,14,2,35,34,46,2,53,52,54,55,62,1,55,
23,14,3,21,20,30,2,51,50,62,2,53,52,46,2,35,
34,14,2,7,46,1,39,62,3,51,50,30,2,3,77,70,
120,163,93,71,122,89,51,19,21,38,86,38,21,14,20,13,
6,34,57,74,39,56,94,67,38,49,84,109,60,29,56,65,
79,51,13,21,5,61,103,93,88,46,73,137,106,64,1,229,
107,188,140,80,44,79,110,65,32,57,22,12,27,8,47,13,
24,27,32,21,35,67,53,33,49,96,142,94,85,137,96,52,
8,24,45,37,6,29,8,64,81,45,16,65,122,177,0,2,
0,80,255,183,3,69,3,192,0,15,0,69,1,144,187,0,
65,0,4,0,39,0,4,43,184,0,65,16,65,19,0,6,
0,65,0,22,0,65,0,38,0,65,0,54,0,65,0,70,
0,65,0,86,0,65,0,102,0,65,0,118,0,65,0,134,
0,65,0,9,93,65,5,0,149,0,65,0,165,0,65,0,
2,93,0,184,0,32,47,184,0,0,69,88,184,0,44,47,
27,185,0,44,0,9,62,89,184,0,0,69,88,184,0,26,
47,27,185,0,26,0,5,62,89,184,0,0,69,88,184,0,
33,47,27,185,0,33,0,5,62,89,187,0,16,0,2,0,
0,0,4,43,184,0,16,16,184,0,26,16,185,0,6,0,
2,252,65,33,0,7,0,6,0,23,0,6,0,39,0,6,
0,55,0,6,0,71,0,6,0,87,0,6,0,103,0,6,
0,119,0,6,0,135,0,6,0,151,0,6,0,167,0,6,
0,183,0,6,0,199,0,6,0,215,0,6,0,231,0,6,
0,247,0,6,0,16,93,65,15,0,7,0,6,0,23,0,
6,0,39,0,6,0,55,0,6,0,71,0,6,0,87,0,
6,0,103,0,6,0,7,113,65,5,0,118,0,6,0,134,
0,6,0,2,113,184,0,44,16,185,0,60,0,2,252,65,
5,0,121,0,60,0,137,0,60,0,2,113,65,33,0,8,
0,60,0,24,0,60,0,40,0,60,0,56,0,60,0,72,
0,60,0,88,0,60,0,104,0,60,0,120,0,60,0,136,
0,60,0,152,0,60,0,168,0,60,0,184,0,60,0,200,
0,60,0,216,0,60,0,232,0,60,0,248,0,60,0,16,
93,65,15,0,8,0,60,0,24,0,60,0,40,0,60,0,
56,0,60,0,72,0,60,0,88,0,60,0,104,0,60,0,
7,113,186,0,67,0,32,0,44,17,18,57,48,49,1,34,
6,7,30,1,51,50,62,2,53,52,46,2,55,50,30,2,
7,14,3,35,34,38,39,14,1,7,39,62,1,55,46,1,
53,52,62,2,51,50,30,2,23,22,14,2,7,39,46,3,
35,34,14,2,21,20,23,62,1,2,70,75,126,57,43,117,
73,47,65,39,17,16,35,54,17,39,72,56,33,1,1,60,
99,125,66,75,132,53,21,42,22,54,20,45,24,45,50,79,
137,186,108,33,69,63,53,17,2,10,18,22,9,37,8,36,
57,79,51,53,97,75,45,49,76,178,1,73,69,63,46,49,
19,30,38,19,20,43,35,23,116,25,50,73,48,57,101,77,
44,50,48,32,71,38,43,40,77,36,60,161,100,108,188,139,
81,11,21,29,18,12,44,49,45,14,10,18,42,38,25,47,
94,140,94,126,89,84,101,0,0,2,0,80,254,12,5,26,
6,14,0,18,0,76,2,39,184,0,77,47,184,0,78,47,
184,0,62,220,185,0,29,0,4,252,184,0,5,208,184,0,
77,16,184,0,40,208,184,0,40,47,185,0,14,0,4,252,
65,19,0,6,0,14,0,22,0,14,0,38,0,14,0,54,
0,14,0,70,0,14,0,86,0,14,0,102,0,14,0,118,
0,14,0,134,0,14,0,9,93,65,5,0,149,0,14,0,
165,0,14,0,2,93,184,0,29,16,184,0,50,208,0,184,
0,60,47,184,0,0,69,88,184,0,47,47,27,185,0,47,
0,9,62,89,184,0,0,69,88,184,0,24,47,27,185,0,
24,0,7,62,89,184,0,0,69,88,184,0,35,47,27,185,
0,35,0,5,62,89,185,0,0,0,2,252,65,33,0,7,
0,0,0,23,0,0,0,39,0,0,0,55,0,0,0,71,
0,0,0,87,0,0,0,103,0,0,0,119,0,0,0,135,
0,0,0,151,0,0,0,167,0,0,0,183,0,0,0,199,
0,0,0,215,0,0,0,231,0,0,0,247,0,0,0,16,
93,65,15,0,7,0,0,0,23,0,0,0,39,0,0,0,
55,0,0,0,71,0,0,0,87,0,0,0,103,0,0,0,
7,113,65,5,0,118,0,0,0,134,0,0,0,2,113,184,
0,47,16,185,0,9,0,2,252,65,5,0,121,0,9,0,
137,0,9,0,2,113,65,33,0,8,0,9,0,24,0,9,
0,40,0,9,0,56,0,9,0,72,0,9,0,88,0,9,
0,104,0,9,0,120,0,9,0,136,0,9,0,152,0,9,
0,168,0,9,0,184,0,9,0,200,0,9,0,216,0,9,
0,232,0,9,0,248,0,9,0,16,93,65,15,0,8,0,
9,0,24,0,9,0,40,0,9,0,56,0,9,0,72,0,
9,0,88,0,9,0,104,0,9,0,7,113,186,0,30,0,
24,0,60,17,18,57,186,0,50,0,47,0,9,17,18,57,
184,0,24,16,185,0,65,0,2,252,65,33,0,7,0,65,
0,23,0,65,0,39,0,65,0,55,0,65,0,71,0,65,
0,87,0,65,0,103,0,65,0,119,0,65,0,135,0,65,
0,151,0,65,0,167,0,65,0,183,0,65,0,199,0,65,
0,215,0,65,0,231,0,65,0,247,0,65,0,16,93,65,
15,0,7,0,65,0,23,0,65,0,39,0,65,0,55,0,
65,0,71,0,65,0,87,0,65,0,103,0,65,0,7,113,
65,5,0,118,0,65,0,134,0,65,0,2,113,48,49,37,
50,62,2,55,17,46,1,35,34,14,2,21,20,30,2,1,
22,14,2,35,34,46,2,53,17,14,3,35,34,46,2,53,
52,62,4,51,50,22,23,17,52,46,2,39,53,62,1,55,
23,17,20,22,51,50,62,2,39,38,62,2,31,1,1,231,
34,66,64,63,31,33,120,72,64,106,77,43,49,76,91,3,
89,3,55,98,132,73,61,78,46,18,38,74,79,87,51,56,
118,99,63,31,58,84,104,124,70,47,93,54,5,27,58,53,
82,128,52,31,55,72,29,47,28,5,13,3,40,56,58,15,
19,100,28,45,58,30,1,213,57,63,47,94,140,94,85,139,
98,53,254,177,38,92,81,54,45,75,99,54,1,137,46,72,
51,27,65,122,176,111,57,122,114,102,77,44,23,40,1,121,
55,65,35,13,4,39,11,37,17,30,249,106,115,124,28,42,
50,21,4,25,24,17,2,39,0,2,0,80,255,225,5,12,
6,14,0,19,0,86,1,208,184,0,87,47,184,0,88,47,
184,0,36,220,185,0,19,0,4,252,184,0,1,208,184,0,
87,16,184,0,63,208,184,0,63,47,185,0,9,0,4,252,
65,19,0,6,0,9,0,22,0,9,0,38,0,9,0,54,
0,9,0,70,0,9,0,86,0,9,0,102,0,9,0,118,
0,9,0,134,0,9,0,9,93,65,5,0,149,0,9,0,
165,0,9,0,2,93,184,0,19,16,184,0,53,208,184,0,
53,47,184,0,19,16,184,0,73,208,184,0,36,16,184,0,
79,208,184,0,79,47,0,184,0,0,69,88,184,0,70,47,
27,185,0,70,0,9,62,89,184,0,0,69,88,184,0,50,
47,27,185,0,50,0,5,62,89,184,0,0,69,88,184,0,
58,47,27,185,0,58,0,5,62,89,187,0,82,0,2,0,
30,0,4,43,184,0,82,16,184,0,70,16,185,0,4,0,
2,252,65,5,0,121,0,4,0,137,0,4,0,2,113,65,
33,0,8,0,4,0,24,0,4,0,40,0,4,0,56,0,
4,0,72,0,4,0,88,0,4,0,104,0,4,0,120,0,
4,0,136,0,4,0,152,0,4,0,168,0,4,0,184,0,
4,0,200,0,4,0,216,0,4,0,232,0,4,0,248,0,
4,0,16,93,65,15,0,8,0,4,0,24,0,4,0,40,
0,4,0,56,0,4,0,72,0,4,0,88,0,4,0,104,
0,4,0,7,113,184,0,58,16,185,0,14,0,2,252,65,
33,0,7,0,14,0,23,0,14,0,39,0,14,0,55,0,
14,0,71,0,14,0,87,0,14,0,103,0,14,0,119,0,
14,0,135,0,14,0,151,0,14,0,167,0,14,0,183,0,
14,0,199,0,14,0,215,0,14,0,231,0,14,0,247,0,
14,0,16,93,65,15,0,7,0,14,0,23,0,14,0,39,
0,14,0,55,0,14,0,71,0,14,0,87,0,14,0,103,
0,14,0,7,113,65,5,0,118,0,14,0,134,0,14,0,
2,113,186,0,53,0,50,0,70,17,18,57,186,0,73,0,
70,0,4,17,18,57,48,49,1,17,46,1,35,34,14,2,
21,20,30,2,51,50,62,2,55,1,20,14,2,7,46,3,
35,34,14,2,21,17,20,30,2,23,22,54,55,23,14,3,
35,34,38,39,14,3,35,34,46,2,53,52,62,4,51,50,
22,23,53,52,62,2,55,62,1,51,50,30,2,2,233,33,
120,72,64,106,77,43,49,76,91,41,34,66,64,63,31,2,
35,29,40,43,15,21,41,39,34,14,32,45,30,14,3,6,
8,6,9,51,60,13,46,71,53,38,14,33,42,7,38,75,
79,88,51,56,118,99,63,31,58,84,104,124,70,47,93,54,
17,36,56,39,51,111,39,43,73,53,29,1,16,1,202,57,
63,47,94,140,94,85,139,98,53,28,45,58,30,4,138,8,
31,33,29,7,34,44,25,9,32,75,123,91,252,172,35,50,
34,22,7,11,9,23,43,31,43,28,13,91,109,46,74,51,
28,65,122,176,111,57,122,114,102,77,44,23,40,154,85,123,
93,72,34,45,47,33,43,42,0,2,0,80,255,226,3,98,
3,192,0,45,0,61,1,133,187,0,12,0,4,0,40,0,
4,43,184,0,12,16,65,5,0,154,0,40,0,170,0,40,
0,2,93,65,19,0,9,0,40,0,25,0,40,0,41,0,
40,0,57,0,40,0,73,0,40,0,89,0,40,0,105,0,
40,0,121,0,40,0,137,0,40,0,9,93,184,0,40,16,
184,0,42,208,184,0,42,47,184,0,12,16,184,0,63,220,
0,184,0,0,69,88,184,0,7,47,27,185,0,7,0,9,
62,89,184,0,0,69,88,184,0,22,47,27,185,0,22,0,
5,62,89,187,0,57,0,2,0,42,0,4,43,184,0,57,
16,184,0,22,16,185,0,35,0,2,252,65,33,0,7,0,
35,0,23,0,35,0,39,0,35,0,55,0,35,0,71,0,
35,0,87,0,35,0,103,0,35,0,119,0,35,0,135,0,
35,0,151,0,35,0,167,0,35,0,183,0,35,0,199,0,
35,0,215,0,35,0,231,0,35,0,247,0,35,0,16,93,
65,15,0,7,0,35,0,23,0,35,0,39,0,35,0,55,
0,35,0,71,0,35,0,87,0,35,0,103,0,35,0,7,
113,65,5,0,118,0,35,0,134,0,35,0,2,113,184,0,
7,16,185,0,46,0,2,252,65,5,0,121,0,46,0,137,
0,46,0,2,113,65,33,0,8,0,46,0,24,0,46,0,
40,0,46,0,56,0,46,0,72,0,46,0,88,0,46,0,
104,0,46,0,120,0,46,0,136,0,46,0,152,0,46,0,
168,0,46,0,184,0,46,0,200,0,46,0,216,0,46,0,
232,0,46,0,248,0,46,0,16,93,65,15,0,8,0,46,
0,24,0,46,0,40,0,46,0,56,0,46,0,72,0,46,
0,88,0,46,0,104,0,46,0,7,113,48,49,19,52,62,
4,51,50,30,2,21,20,14,2,7,14,3,35,34,46,2,
39,62,1,55,30,3,51,50,62,2,53,52,39,33,46,1,
1,34,14,4,21,20,22,51,33,46,3,80,26,50,73,94,
114,65,93,137,90,44,9,21,36,27,26,70,82,89,45,48,
99,98,91,39,5,19,13,42,88,83,70,24,80,110,67,29,
3,253,245,32,60,1,96,44,64,46,29,17,6,15,23,1,
160,14,47,63,79,2,45,42,93,90,81,61,36,84,134,166,
82,53,89,81,77,40,38,67,50,29,19,49,88,69,8,26,
7,44,52,29,9,58,94,120,63,26,27,13,34,1,63,26,
41,52,53,50,18,21,15,55,100,76,45,0,0,2,0,70,
255,226,3,82,3,192,0,11,0,52,1,179,184,0,53,47,
184,0,54,47,184,0,12,220,185,0,30,0,4,252,184,0,
3,208,184,0,3,47,184,0,53,16,184,0,23,208,184,0,
23,47,185,0,7,0,4,252,65,19,0,6,0,7,0,22,
0,7,0,38,0,7,0,54,0,7,0,70,0,7,0,86,
0,7,0,102,0,7,0,118,0,7,0,134,0,7,0,9,
93,65,5,0,149,0,7,0,165,0,7,0,2,93,184,0,
30,16,184,0,15,208,184,0,15,47,184,0,7,16,184,0,
29,208,184,0,29,47,184,0,23,16,184,0,43,208,184,0,
43,47,0,184,0,0,69,88,184,0,48,47,27,185,0,48,
0,9,62,89,184,0,0,69,88,184,0,18,47,27,185,0,
18,0,5,62,89,187,0,30,0,2,0,3,0,4,43,184,
0,30,16,184,0,18,16,185,0,0,0,2,252,65,33,0,
7,0,0,0,23,0,0,0,39,0,0,0,55,0,0,0,
71,0,0,0,87,0,0,0,103,0,0,0,119,0,0,0,
135,0,0,0,151,0,0,0,167,0,0,0,183,0,0,0,
199,0,0,0,215,0,0,0,231,0,0,0,247,0,0,0,
16,93,65,15,0,7,0,0,0,23,0,0,0,39,0,0,
0,55,0,0,0,71,0,0,0,87,0,0,0,103,0,0,
0,7,113,65,5,0,118,0,0,0,134,0,0,0,2,113,
184,0,48,16,185,0,35,0,2,252,65,5,0,121,0,35,
0,137,0,35,0,2,113,65,33,0,8,0,35,0,24,0,
35,0,40,0,35,0,56,0,35,0,72,0,35,0,88,0,
35,0,104,0,35,0,120,0,35,0,136,0,35,0,152,0,
35,0,168,0,35,0,184,0,35,0,200,0,35,0,216,0,
35,0,232,0,35,0,248,0,35,0,16,93,65,15,0,8,
0,35,0,24,0,35,0,40,0,35,0,56,0,35,0,72,
0,35,0,88,0,35,0,104,0,35,0,7,113,48,49,37,
50,54,55,33,34,6,21,20,30,2,1,20,6,7,14,1,
35,34,46,2,53,52,54,55,62,1,55,33,46,3,35,34,
14,2,7,46,1,39,62,3,51,50,30,2,1,188,115,126,
12,254,112,31,35,38,61,76,1,188,79,69,57,139,90,72,
126,94,54,19,17,29,70,35,1,203,2,49,81,109,61,27,
56,66,80,51,13,20,6,61,103,93,88,46,73,137,107,64,
74,155,152,48,40,47,80,59,33,1,155,118,203,74,62,58,
47,83,113,66,40,66,23,15,32,14,82,132,93,49,8,24,
45,37,6,29,8,64,81,45,16,65,122,177,0,2,0,78,
255,226,4,228,3,192,0,20,0,96,1,144,187,0,27,0,
4,0,0,0,4,43,184,0,27,16,65,5,0,154,0,0,
0,170,0,0,0,2,93,65,19,0,9,0,0,0,25,0,
0,0,41,0,0,0,57,0,0,0,73,0,0,0,89,0,
0,0,105,0,0,0,121,0,0,0,137,0,0,0,9,93,
184,0,0,16,184,0,3,208,184,0,3,47,0,184,0,0,
69,88,184,0,65,47,27,185,0,65,0,9,62,89,184,0,
0,69,88,184,0,73,47,27,185,0,73,0,9,62,89,184,
0,0,69,88,184,0,33,47,27,185,0,33,0,5,62,89,
186,0,3,0,33,0,65,17,18,57,185,0,18,0,2,252,
65,33,0,7,0,18,0,23,0,18,0,39,0,18,0,55,
0,18,0,71,0,18,0,87,0,18,0,103,0,18,0,119,
0,18,0,135,0,18,0,151,0,18,0,167,0,18,0,183,
0,18,0,199,0,18,0,215,0,18,0,231,0,18,0,247,
0,18,0,16,93,65,15,0,7,0,18,0,23,0,18,0,
39,0,18,0,55,0,18,0,71,0,18,0,87,0,18,0,
103,0,18,0,7,113,65,5,0,118,0,18,0,134,0,18,
0,2,113,186,0,21,0,33,0,65,17,18,57,184,0,65,
16,185,0,52,0,2,252,65,5,0,121,0,52,0,137,0,
52,0,2,113,65,33,0,8,0,52,0,24,0,52,0,40,
0,52,0,56,0,52,0,72,0,52,0,88,0,52,0,104,
0,52,0,120,0,52,0,136,0,52,0,152,0,52,0,168,
0,52,0,184,0,52,0,200,0,52,0,216,0,52,0,232,
0,52,0,248,0,52,0,16,93,65,15,0,8,0,52,0,
24,0,52,0,40,0,52,0,56,0,52,0,72,0,52,0,
88,0,52,0,104,0,52,0,7,113,48,49,1,52,38,39,
14,1,7,14,5,21,20,30,2,51,50,54,1,14,1,7,
30,1,21,20,6,7,14,1,35,34,46,2,53,52,62,4,
55,54,55,46,3,35,34,14,2,7,46,1,39,62,3,51,
50,30,2,23,62,1,55,23,14,1,7,6,22,55,62,1,
55,23,14,3,35,34,46,2,53,52,54,2,188,5,5,35,
72,36,76,104,69,38,17,4,29,54,75,47,128,128,1,25,
35,76,41,10,11,79,69,57,139,90,75,123,89,49,4,24,
52,97,148,109,80,68,19,56,68,79,43,27,56,66,80,51,
13,20,6,61,103,93,88,46,49,97,85,72,26,86,150,72,
28,40,25,1,1,27,27,20,53,46,12,36,56,47,40,19,
13,28,23,15,2,1,198,27,51,24,22,44,22,46,64,44,
28,22,18,11,19,55,51,36,193,1,230,26,53,27,37,80,
45,118,203,74,62,58,45,73,92,47,18,29,31,40,60,87,
63,46,43,43,67,46,25,8,24,45,37,6,29,8,64,81,
45,16,31,58,85,55,57,112,60,22,55,88,28,37,40,1,
1,14,22,43,27,38,24,10,12,27,45,34,11,21,0,1,
0,80,255,226,3,61,3,192,0,71,1,141,187,0,60,0,
4,0,10,0,4,43,184,0,60,16,65,19,0,6,0,60,
0,22,0,60,0,38,0,60,0,54,0,60,0,70,0,60,
0,86,0,60,0,102,0,60,0,118,0,60,0,134,0,60,
0,9,93,65,5,0,149,0,60,0,165,0,60,0,2,93,
185,0,18,0,4,252,184,0,60,16,184,0,49,208,184,0,
49,47,0,184,0,0,69,88,184,0,28,47,27,185,0,28,
0,9,62,89,184,0,0,69,88,184,0,5,47,27,185,0,
5,0,5,62,89,187,0,54,0,1,0,55,0,4,43,184,
0,54,16,186,0,15,0,5,0,28,17,18,57,184,0,28,
16,185,0,44,0,2,252,65,5,0,121,0,44,0,137,0,
44,0,2,113,65,33,0,8,0,44,0,24,0,44,0,40,
0,44,0,56,0,44,0,72,0,44,0,88,0,44,0,104,
0,44,0,120,0,44,0,136,0,44,0,152,0,44,0,168,
0,44,0,184,0,44,0,200,0,44,0,216,0,44,0,232,
0,44,0,248,0,44,0,16,93,65,15,0,8,0,44,0,
24,0,44,0,40,0,44,0,56,0,44,0,72,0,44,0,
88,0,44,0,104,0,44,0,7,113,184,0,5,16,185,0,
65,0,2,252,65,33,0,7,0,65,0,23,0,65,0,39,
0,65,0,55,0,65,0,71,0,65,0,87,0,65,0,103,
0,65,0,119,0,65,0,135,0,65,0,151,0,65,0,167,
0,65,0,183,0,65,0,199,0,65,0,215,0,65,0,231,
0,65,0,247,0,65,0,16,93,65,15,0,7,0,65,0,
23,0,65,0,39,0,65,0,55,0,65,0,71,0,65,0,
87,0,65,0,103,0,65,0,7,113,65,5,0,118,0,65,
0,134,0,65,0,2,113,48,49,37,14,3,35,34,46,2,
53,52,62,2,55,46,1,53,52,62,2,55,62,3,51,50,
30,2,23,22,14,2,7,39,46,3,35,34,14,2,21,20,
30,2,31,1,14,3,23,30,3,51,50,62,2,55,23,3,
61,65,110,97,88,43,84,129,88,45,33,54,68,35,75,82,
24,41,57,33,24,60,66,69,33,35,74,67,58,20,2,10,
18,21,8,37,9,37,60,83,53,43,69,49,27,19,60,110,
91,11,78,115,74,35,1,1,33,60,87,54,28,61,73,92,
60,38,190,77,87,45,11,38,68,91,54,44,76,63,48,15,
29,98,82,31,62,56,50,20,15,25,16,9,11,20,30,18,
12,44,49,45,14,10,21,45,38,25,24,41,54,30,31,60,
51,37,6,53,5,40,58,68,34,32,60,47,29,6,26,55,
48,41,0,1,0,45,255,226,3,26,3,192,0,65,1,153,
187,0,48,0,4,0,22,0,4,43,184,0,48,16,65,5,
0,154,0,22,0,170,0,22,0,2,93,65,19,0,9,0,
22,0,25,0,22,0,41,0,22,0,57,0,22,0,73,0,
22,0,89,0,22,0,105,0,22,0,121,0,22,0,137,0,
22,0,9,93,184,0,22,16,184,0,11,208,184,0,11,47,
184,0,22,16,185,0,56,0,4,252,184,0,48,16,184,0,
67,220,0,184,0,0,69,88,184,0,43,47,27,185,0,43,
0,9,62,89,184,0,0,69,88,184,0,61,47,27,185,0,
61,0,5,62,89,187,0,17,0,1,0,16,0,4,43,184,
0,17,16,184,0,61,16,185,0,6,0,2,252,65,33,0,
7,0,6,0,23,0,6,0,39,0,6,0,55,0,6,0,
71,0,6,0,87,0,6,0,103,0,6,0,119,0,6,0,
135,0,6,0,151,0,6,0,167,0,6,0,183,0,6,0,
199,0,6,0,215,0,6,0,231,0,6,0,247,0,6,0,
16,93,65,15,0,7,0,6,0,23,0,6,0,39,0,6,
0,55,0,6,0,71,0,6,0,87,0,6,0,103,0,6,
0,7,113,65,5,0,118,0,6,0,134,0,6,0,2,113,
184,0,43,16,185,0,27,0,2,252,65,5,0,121,0,27,
0,137,0,27,0,2,113,65,33,0,8,0,27,0,24,0,
27,0,40,0,27,0,56,0,27,0,72,0,27,0,88,0,
27,0,104,0,27,0,120,0,27,0,136,0,27,0,152,0,
27,0,168,0,27,0,184,0,27,0,200,0,27,0,216,0,
27,0,232,0,27,0,248,0,27,0,16,93,65,15,0,8,
0,27,0,24,0,27,0,40,0,27,0,56,0,27,0,72,
0,27,0,88,0,27,0,104,0,27,0,7,113,186,0,51,
0,16,0,17,17,18,57,48,49,63,1,30,3,51,50,62,
2,55,54,46,2,39,55,62,3,53,52,46,2,35,34,14,
2,15,1,46,3,55,62,3,51,50,30,2,21,20,6,7,
30,3,21,20,14,2,35,34,46,2,45,38,49,89,79,68,
29,62,88,57,27,1,1,33,72,115,82,11,91,110,60,19,
29,51,68,40,53,85,61,37,6,37,8,21,18,10,2,25,
76,93,106,54,51,108,90,58,82,75,47,71,48,24,49,96,
140,91,43,99,99,94,190,41,48,55,26,6,29,47,60,32,
34,70,59,39,3,53,6,37,51,60,31,30,54,41,24,25,
45,62,37,10,14,45,49,44,12,25,43,32,19,25,54,85,
60,82,118,29,9,43,62,78,44,54,107,86,54,21,51,85,
0,1,0,45,255,226,4,138,3,192,0,95,1,192,184,0,
96,47,184,0,97,47,184,0,20,220,184,0,96,16,184,0,
66,208,184,0,66,47,184,0,20,16,185,0,26,0,4,252,
184,0,66,16,185,0,26,0,4,252,65,19,0,6,0,26,
0,22,0,26,0,38,0,26,0,54,0,26,0,70,0,26,
0,86,0,26,0,102,0,26,0,118,0,26,0,134,0,26,
0,9,93,65,5,0,149,0,26,0,165,0,26,0,2,93,
184,0,66,16,184,0,55,208,184,0,55,47,0,184,0,0,
69,88,184,0,87,47,27,185,0,87,0,9,62,89,184,0,
0,69,88,184,0,95,47,27,185,0,95,0,9,62,89,184,
0,0,69,88,184,0,39,47,27,185,0,39,0,5,62,89,
187,0,61,0,1,0,60,0,4,43,184,0,61,16,186,0,
23,0,39,0,87,17,18,57,186,0,29,0,60,0,61,17,
18,57,184,0,39,16,185,0,50,0,2,252,65,33,0,7,
0,50,0,23,0,50,0,39,0,50,0,55,0,50,0,71,
0,50,0,87,0,50,0,103,0,50,0,119,0,50,0,135,
0,50,0,151,0,50,0,167,0,50,0,183,0,50,0,199,
0,50,0,215,0,50,0,231,0,50,0,247,0,50,0,16,
93,65,15,0,7,0,50,0,23,0,50,0,39,0,50,0,
55,0,50,0,71,0,50,0,87,0,50,0,103,0,50,0,
7,113,65,5,0,118,0,50,0,134,0,50,0,2,113,184,
0,87,16,185,0,71,0,2,252,65,5,0,121,0,71,0,
137,0,71,0,2,113,65,33,0,8,0,71,0,24,0,71,
0,40,0,71,0,56,0,71,0,72,0,71,0,88,0,71,
0,104,0,71,0,120,0,71,0,136,0,71,0,152,0,71,
0,168,0,71,0,184,0,71,0,200,0,71,0,216,0,71,
0,232,0,71,0,248,0,71,0,16,93,65,15,0,8,0,
71,0,24,0,71,0,40,0,71,0,56,0,71,0,72,0,
71,0,88,0,71,0,104,0,71,0,7,113,48,49,1,14,
1,7,6,22,55,62,1,55,23,14,3,35,34,46,2,53,
52,54,55,14,1,7,20,6,7,30,3,21,20,14,2,35,
34,46,2,39,55,30,3,51,50,62,2,55,54,46,2,39,
55,62,3,53,52,46,2,35,34,14,2,15,1,46,3,55,
62,3,51,50,30,2,23,62,1,55,4,20,40,25,1,1,
27,27,20,53,46,12,36,56,47,40,19,13,28,23,15,9,
8,25,74,42,82,75,47,71,48,24,49,96,140,91,43,99,
99,94,38,38,49,89,79,68,29,62,88,57,27,1,1,33,
72,115,82,11,91,110,60,19,29,51,68,40,53,85,61,37,
6,37,8,21,18,10,2,25,76,93,106,54,42,89,81,64,
17,89,131,49,3,170,55,88,28,37,40,1,1,14,22,43,
27,38,24,10,13,28,46,33,23,40,17,5,26,20,81,118,
29,9,43,62,78,44,54,107,86,54,21,51,85,63,41,48,
55,26,6,29,47,60,32,34,70,59,39,3,53,6,37,51,
60,31,30,54,41,24,25,45,62,37,10,14,45,49,44,12,
25,43,32,19,17,36,57,40,37,74,39,0,0,2,0,80,
255,226,3,110,3,192,0,27,0,58,1,231,187,0,54,0,
4,0,23,0,4,43,184,0,54,16,187,0,5,0,4,0,
44,0,4,43,184,0,5,16,65,5,0,154,0,44,0,170,
0,44,0,2,93,65,19,0,9,0,44,0,25,0,44,0,
41,0,44,0,57,0,44,0,73,0,44,0,89,0,44,0,
105,0,44,0,121,0,44,0,137,0,44,0,9,93,184,0,
44,16,185,0,13,0,4,252,186,0,8,0,23,0,13,17,
18,57,184,0,44,16,184,0,33,208,184,0,33,47,65,19,
0,6,0,54,0,22,0,54,0,38,0,54,0,54,0,54,
0,70,0,54,0,86,0,54,0,102,0,54,0,118,0,54,
0,134,0,54,0,9,93,65,5,0,149,0,54,0,165,0,
54,0,2,93,184,0,5,16,184,0,60,220,0,184,0,0,
69,88,184,0,0,47,27,185,0,0,0,9,62,89,184,0,
0,69,88,184,0,18,47,27,185,0,18,0,5,62,89,187,
0,39,0,1,0,38,0,4,43,184,0,39,16,186,0,8,
0,38,0,39,17,18,57,184,0,18,16,185,0,28,0,2,
252,65,33,0,7,0,28,0,23,0,28,0,39,0,28,0,
55,0,28,0,71,0,28,0,87,0,28,0,103,0,28,0,
119,0,28,0,135,0,28,0,151,0,28,0,167,0,28,0,
183,0,28,0,199,0,28,0,215,0,28,0,231,0,28,0,
247,0,28,0,16,93,65,15,0,7,0,28,0,23,0,28,
0,39,0,28,0,55,0,28,0,71,0,28,0,87,0,28,
0,103,0,28,0,7,113,65,5,0,118,0,28,0,134,0,
28,0,2,113,184,0,0,16,185,0,49,0,2,252,65,5,
0,121,0,49,0,137,0,49,0,2,113,65,33,0,8,0,
49,0,24,0,49,0,40,0,49,0,56,0,49,0,72,0,
49,0,88,0,49,0,104,0,49,0,120,0,49,0,136,0,
49,0,152,0,49,0,168,0,49,0,184,0,49,0,200,0,
49,0,216,0,49,0,232,0,49,0,248,0,49,0,16,93,
65,15,0,8,0,49,0,24,0,49,0,40,0,49,0,56,
0,49,0,72,0,49,0,88,0,49,0,104,0,49,0,7,
113,48,49,1,50,30,2,21,20,6,7,30,3,21,20,14,
2,35,34,46,2,53,52,62,2,19,50,62,2,55,54,46,
2,39,55,62,3,53,52,46,2,35,34,14,2,21,20,30,
2,2,26,51,108,90,58,82,75,47,71,48,24,61,107,144,
84,87,148,107,60,76,128,165,72,54,74,46,20,1,1,33,
72,115,82,11,91,110,60,19,30,54,77,47,62,98,69,37,
46,79,105,3,192,25,54,85,60,82,118,29,9,43,62,78,
44,54,107,86,54,71,125,170,99,117,193,138,77,252,150,29,
47,60,32,37,75,61,39,3,53,6,37,51,60,31,30,54,
41,24,56,101,139,82,78,142,108,64,0,1,255,80,254,12,
2,43,3,192,0,53,1,0,187,0,53,0,4,0,41,0,
4,43,184,0,53,16,184,0,3,208,184,0,3,47,184,0,
41,16,184,0,31,208,184,0,31,47,0,184,0,0,69,88,
184,0,51,47,27,185,0,51,0,9,62,89,184,0,0,69,
88,184,0,2,47,27,185,0,2,0,5,62,89,184,0,0,
69,88,184,0,31,47,27,185,0,31,0,5,62,89,184,0,
0,69,88,184,0,13,47,27,185,0,13,0,7,62,89,184,
0,2,16,185,0,0,0,2,252,184,0,13,16,185,0,26,
0,2,252,65,33,0,7,0,26,0,23,0,26,0,39,0,
26,0,55,0,26,0,71,0,26,0,87,0,26,0,103,0,
26,0,119,0,26,0,135,0,26,0,151,0,26,0,167,0,
26,0,183,0,26,0,199,0,26,0,215,0,26,0,231,0,
26,0,247,0,26,0,16,93,65,15,0,7,0,26,0,23,
0,26,0,39,0,26,0,55,0,26,0,71,0,26,0,87,
0,26,0,103,0,26,0,7,113,65,5,0,118,0,26,0,
134,0,26,0,2,113,184,0,32,220,184,0,3,208,184,0,
0,16,184,0,41,208,48,49,37,23,7,35,14,3,7,14,
3,35,34,46,2,53,52,62,2,55,30,1,51,50,62,2,
55,35,39,62,3,55,30,1,51,17,52,46,2,39,53,62,
1,55,51,17,2,22,21,78,81,6,33,49,63,35,27,61,
59,54,19,31,59,47,29,29,40,43,15,32,68,38,27,55,
45,30,3,200,29,9,27,27,26,9,30,70,32,6,28,56,
51,69,117,67,38,94,28,66,87,125,93,67,28,21,37,27,
15,15,22,24,8,9,31,34,30,7,28,17,33,83,141,108,
29,14,31,29,21,5,22,13,2,82,43,55,33,16,5,40,
13,38,29,252,158,0,0,2,0,80,254,12,4,248,6,14,
0,16,0,97,2,87,184,0,98,47,184,0,99,47,184,0,
33,220,185,0,3,0,4,252,184,0,98,16,184,0,72,208,
184,0,72,47,185,0,12,0,4,252,65,19,0,6,0,12,
0,22,0,12,0,38,0,12,0,54,0,12,0,70,0,12,
0,86,0,12,0,102,0,12,0,118,0,12,0,134,0,12,
0,9,93,65,5,0,149,0,12,0,165,0,12,0,2,93,
184,0,3,16,184,0,61,208,184,0,61,47,186,0,62,0,
33,0,3,17,18,57,184,0,3,16,184,0,84,208,184,0,
84,47,184,0,33,16,184,0,90,208,184,0,90,47,0,184,
0,0,69,88,184,0,79,47,27,185,0,79,0,9,62,89,
184,0,0,69,88,184,0,41,47,27,185,0,41,0,7,62,
89,184,0,0,69,88,184,0,67,47,27,185,0,67,0,5,
62,89,187,0,93,0,2,0,27,0,4,43,184,0,93,16,
184,0,67,16,185,0,0,0,2,252,65,33,0,7,0,0,
0,23,0,0,0,39,0,0,0,55,0,0,0,71,0,0,
0,87,0,0,0,103,0,0,0,119,0,0,0,135,0,0,
0,151,0,0,0,167,0,0,0,183,0,0,0,199,0,0,
0,215,0,0,0,231,0,0,0,247,0,0,0,16,93,65,
15,0,7,0,0,0,23,0,0,0,39,0,0,0,55,0,
0,0,71,0,0,0,87,0,0,0,103,0,0,0,7,113,
65,5,0,118,0,0,0,134,0,0,0,2,113,184,0,79,
16,185,0,7,0,2,252,65,5,0,121,0,7,0,137,0,
7,0,2,113,65,33,0,8,0,7,0,24,0,7,0,40,
0,7,0,56,0,7,0,72,0,7,0,88,0,7,0,104,
0,7,0,120,0,7,0,136,0,7,0,152,0,7,0,168,
0,7,0,184,0,7,0,200,0,7,0,216,0,7,0,232,
0,7,0,248,0,7,0,16,93,65,15,0,8,0,7,0,
24,0,7,0,40,0,7,0,56,0,7,0,72,0,7,0,
88,0,7,0,104,0,7,0,7,113,184,0,41,16,185,0,
56,0,2,252,65,33,0,7,0,56,0,23,0,56,0,39,
0,56,0,55,0,56,0,71,0,56,0,87,0,56,0,103,
0,56,0,119,0,56,0,135,0,56,0,151,0,56,0,167,
0,56,0,183,0,56,0,199,0,56,0,215,0,56,0,231,
0,56,0,247,0,56,0,16,93,65,15,0,7,0,56,0,
23,0,56,0,39,0,56,0,55,0,56,0,71,0,56,0,
87,0,56,0,103,0,56,0,7,113,65,5,0,118,0,56,
0,134,0,56,0,2,113,186,0,62,0,41,0,79,17,18,
57,186,0,84,0,79,0,7,17,18,57,48,49,37,50,54,
55,3,46,1,35,34,14,2,21,20,30,2,1,20,14,2,
7,46,3,35,34,14,2,21,27,1,22,14,4,35,34,46,
2,53,52,62,2,55,30,3,51,50,62,2,47,1,14,3,
35,34,46,2,53,52,62,4,51,50,30,2,23,39,52,62,
2,55,62,1,51,50,30,2,1,231,49,117,79,6,31,102,
73,64,106,77,43,49,76,91,3,58,29,40,43,15,21,41,
39,34,14,32,45,30,14,6,8,3,49,80,103,105,96,33,
64,118,90,54,34,48,50,16,36,70,63,54,21,49,90,67,
38,1,2,44,77,75,77,44,56,118,99,63,31,59,83,105,
124,69,23,42,42,43,25,1,17,36,56,39,51,111,39,43,
73,53,29,100,78,84,1,208,59,65,60,108,153,93,80,125,
86,45,5,43,8,31,33,29,7,34,44,25,9,32,75,123,
91,253,50,254,204,114,175,128,88,52,23,28,41,47,20,10,
32,31,26,4,42,51,28,9,45,103,167,123,123,56,76,47,
21,58,112,162,104,57,127,123,112,85,50,5,13,25,19,153,
85,123,93,72,34,45,47,33,43,42,0,2,0,80,254,12,
3,137,3,193,0,16,0,79,2,8,187,0,12,0,4,0,
61,0,4,43,184,0,12,16,65,19,0,6,0,12,0,22,
0,12,0,38,0,12,0,54,0,12,0,70,0,12,0,86,
0,12,0,102,0,12,0,118,0,12,0,134,0,12,0,9,
93,65,5,0,149,0,12,0,165,0,12,0,2,93,0,184,
0,0,69,88,184,0,68,47,27,185,0,68,0,9,62,89,
184,0,0,69,88,184,0,78,47,27,185,0,78,0,9,62,
89,184,0,0,69,88,184,0,30,47,27,185,0,30,0,7,
62,89,184,0,0,69,88,184,0,56,47,27,185,0,56,0,
5,62,89,185,0,0,0,2,252,65,33,0,7,0,0,0,
23,0,0,0,39,0,0,0,55,0,0,0,71,0,0,0,
87,0,0,0,103,0,0,0,119,0,0,0,135,0,0,0,
151,0,0,0,167,0,0,0,183,0,0,0,199,0,0,0,
215,0,0,0,231,0,0,0,247,0,0,0,16,93,65,15,
0,7,0,0,0,23,0,0,0,39,0,0,0,55,0,0,
0,71,0,0,0,87,0,0,0,103,0,0,0,7,113,65,
5,0,118,0,0,0,134,0,0,0,2,113,184,0,68,16,
185,0,7,0,2,252,65,5,0,121,0,7,0,137,0,7,
0,2,113,65,33,0,8,0,7,0,24,0,7,0,40,0,
7,0,56,0,7,0,72,0,7,0,88,0,7,0,104,0,
7,0,120,0,7,0,136,0,7,0,152,0,7,0,168,0,
7,0,184,0,7,0,200,0,7,0,216,0,7,0,232,0,
7,0,248,0,7,0,16,93,65,15,0,8,0,7,0,24,
0,7,0,40,0,7,0,56,0,7,0,72,0,7,0,88,
0,7,0,104,0,7,0,7,113,184,0,30,16,185,0,45,
0,2,252,65,33,0,7,0,45,0,23,0,45,0,39,0,
45,0,55,0,45,0,71,0,45,0,87,0,45,0,103,0,
45,0,119,0,45,0,135,0,45,0,151,0,45,0,167,0,
45,0,183,0,45,0,199,0,45,0,215,0,45,0,231,0,
45,0,247,0,45,0,16,93,65,15,0,7,0,45,0,23,
0,45,0,39,0,45,0,55,0,45,0,71,0,45,0,87,
0,45,0,103,0,45,0,7,113,65,5,0,118,0,45,0,
134,0,45,0,2,113,186,0,51,0,30,0,78,17,18,57,
48,49,37,50,54,55,3,46,1,35,34,14,2,21,20,30,
2,1,48,14,2,23,19,22,14,4,35,34,46,2,53,52,
62,2,55,30,3,51,50,62,2,47,1,14,3,35,34,46,
2,53,52,62,4,51,50,30,2,23,62,3,55,23,1,231,
49,117,79,6,31,102,73,64,106,77,43,49,76,91,1,203,
10,12,10,1,15,3,49,80,103,105,96,33,64,118,90,54,
34,48,50,16,36,70,63,54,21,49,90,67,38,1,2,44,
77,75,77,44,56,118,99,63,31,59,83,105,124,69,27,48,
50,53,33,15,32,30,26,9,31,100,78,84,1,208,59,65,
60,108,153,93,80,125,86,45,3,62,33,57,78,45,253,131,
114,175,128,88,52,23,28,41,47,20,10,32,31,26,4,42,
51,28,9,45,103,167,123,123,56,76,47,21,58,112,162,104,
57,127,123,112,85,50,7,20,36,30,10,25,25,25,9,31,
0,1,0,80,255,234,3,198,3,192,0,64,1,153,184,0,
65,47,184,0,66,47,184,0,45,220,184,0,0,208,184,0,
0,47,184,0,65,16,184,0,55,208,184,0,55,47,185,0,
18,0,4,252,65,19,0,6,0,18,0,22,0,18,0,38,
0,18,0,54,0,18,0,70,0,18,0,86,0,18,0,102,
0,18,0,118,0,18,0,134,0,18,0,9,93,65,5,0,
149,0,18,0,165,0,18,0,2,93,184,0,45,16,185,0,
25,0,4,252,184,0,45,16,184,0,39,208,184,0,45,16,
184,0,43,208,184,0,43,47,0,184,0,0,69,88,184,0,
60,47,27,185,0,60,0,9,62,89,184,0,0,69,88,184,
0,50,47,27,185,0,50,0,5,62,89,184,0,60,16,185,
0,11,0,2,252,65,5,0,121,0,11,0,137,0,11,0,
2,113,65,33,0,8,0,11,0,24,0,11,0,40,0,11,
0,56,0,11,0,72,0,11,0,88,0,11,0,104,0,11,
0,120,0,11,0,136,0,11,0,152,0,11,0,168,0,11,
0,184,0,11,0,200,0,11,0,216,0,11,0,232,0,11,
0,248,0,11,0,16,93,65,15,0,8,0,11,0,24,0,
11,0,40,0,11,0,56,0,11,0,72,0,11,0,88,0,
11,0,104,0,11,0,7,113,184,0,50,16,185,0,23,0,
2,252,65,33,0,7,0,23,0,23,0,23,0,39,0,23,
0,55,0,23,0,71,0,23,0,87,0,23,0,103,0,23,
0,119,0,23,0,135,0,23,0,151,0,23,0,167,0,23,
0,183,0,23,0,199,0,23,0,215,0,23,0,231,0,23,
0,247,0,23,0,16,93,65,15,0,7,0,23,0,23,0,
23,0,39,0,23,0,55,0,23,0,71,0,23,0,87,0,
23,0,103,0,23,0,7,113,65,5,0,118,0,23,0,134,
0,23,0,2,113,48,49,1,22,14,2,7,39,46,3,35,
34,14,4,21,20,30,2,51,50,55,53,52,46,2,39,53,
33,21,14,3,29,1,48,6,7,22,51,14,3,35,34,46,
2,53,52,62,2,51,50,30,2,3,113,6,15,27,32,11,
28,27,54,60,68,40,19,59,65,66,53,33,59,94,120,61,
99,73,12,35,63,50,1,134,23,31,18,8,2,1,2,1,
61,98,84,74,37,83,162,128,79,84,148,201,117,27,65,68,
64,3,116,4,28,34,32,9,4,24,33,21,9,15,37,59,
87,119,77,104,149,98,46,29,220,12,26,24,22,7,43,43,
5,21,25,28,12,207,1,1,2,45,55,28,9,56,113,171,
115,124,195,136,72,10,20,28,0,2,0,20,254,12,3,221,
3,162,0,20,0,71,0,250,184,0,72,47,184,0,73,47,
184,0,72,16,184,0,43,208,184,0,43,47,184,0,73,16,
184,0,33,220,186,0,0,0,43,0,33,17,18,57,184,0,
43,16,185,0,5,0,3,252,65,19,0,6,0,5,0,22,
0,5,0,38,0,5,0,54,0,5,0,70,0,5,0,86,
0,5,0,102,0,5,0,118,0,5,0,134,0,5,0,9,
93,65,5,0,149,0,5,0,165,0,5,0,2,93,184,0,
33,16,185,0,15,0,4,252,65,5,0,154,0,15,0,170,
0,15,0,2,93,65,19,0,9,0,15,0,25,0,15,0,
41,0,15,0,57,0,15,0,73,0,15,0,89,0,15,0,
105,0,15,0,121,0,15,0,137,0,15,0,9,93,186,0,
62,0,43,0,33,17,18,57,0,184,0,0,69,88,184,0,
54,47,27,185,0,54,0,9,62,89,184,0,0,69,88,184,
0,69,47,27,185,0,69,0,9,62,89,184,0,0,69,88,
184,0,38,47,27,185,0,38,0,7,62,89,186,0,0,0,
38,0,54,17,18,57,186,0,62,0,38,0,54,17,18,57,
48,49,37,14,3,21,20,30,2,51,50,62,2,53,52,46,
2,39,1,14,3,7,1,23,30,3,21,20,14,2,35,34,
46,2,53,52,62,2,63,1,1,46,1,39,53,33,21,14,
3,23,27,1,54,46,2,39,53,33,21,1,237,34,44,26,
10,22,34,41,20,19,38,30,19,7,19,33,26,1,216,30,
37,23,13,7,254,214,54,28,40,26,11,30,63,97,67,44,
79,58,34,8,22,37,29,74,254,205,11,50,50,1,130,39,
47,24,2,7,224,235,7,4,24,47,37,1,78,42,68,97,
67,45,16,42,55,32,13,18,30,40,23,28,48,59,79,59,
3,128,7,13,15,19,14,253,169,113,60,92,77,72,41,37,
92,81,55,31,57,79,49,25,54,67,88,59,151,2,147,26,
31,11,43,43,5,11,15,22,15,254,33,1,223,15,20,16,
11,6,43,43,0,2,0,20,255,226,3,221,3,162,0,17,
0,62,0,64,0,184,0,0,69,88,184,0,49,47,27,185,
0,49,0,9,62,89,184,0,0,69,88,184,0,60,47,27,
185,0,60,0,9,62,89,184,0,0,69,88,184,0,35,47,
27,185,0,35,0,5,62,89,186,0,1,0,35,0,49,17,
18,57,48,49,1,7,14,3,21,20,30,2,51,50,54,53,
52,38,39,1,14,3,7,1,23,30,3,21,20,14,2,35,
34,46,2,53,52,54,63,1,1,46,1,39,53,33,21,14,
1,23,27,1,54,38,39,53,33,21,2,0,1,15,33,27,
17,18,29,37,20,38,54,18,24,1,160,30,38,25,18,9,
254,248,73,22,30,16,7,26,57,93,67,44,74,54,30,33,
33,76,254,203,16,55,50,1,130,77,38,20,230,209,19,40,
74,1,78,1,74,2,21,42,41,38,17,23,35,23,11,43,
32,21,43,35,2,124,7,14,16,19,12,254,150,90,32,49,
45,46,30,29,69,58,39,30,49,63,34,43,77,43,103,1,
151,23,34,11,43,43,10,31,27,254,229,1,27,25,32,11,
43,43,0,1,0,39,254,12,4,29,3,192,0,55,0,202,
184,0,56,47,184,0,57,47,184,0,49,220,185,0,4,0,
4,252,184,0,56,16,184,0,15,208,184,0,15,47,185,0,
29,0,4,252,184,0,4,16,184,0,37,208,0,184,0,0,
69,88,184,0,3,47,27,185,0,3,0,7,62,89,184,0,
0,69,88,184,0,10,47,27,185,0,10,0,5,62,89,185,
0,34,0,2,252,65,33,0,7,0,34,0,23,0,34,0,
39,0,34,0,55,0,34,0,71,0,34,0,87,0,34,0,
103,0,34,0,119,0,34,0,135,0,34,0,151,0,34,0,
167,0,34,0,183,0,34,0,199,0,34,0,215,0,34,0,
231,0,34,0,247,0,34,0,16,93,65,15,0,7,0,34,
0,23,0,34,0,39,0,34,0,55,0,34,0,71,0,34,
0,87,0,34,0,103,0,34,0,7,113,65,5,0,118,0,
34,0,134,0,34,0,2,113,48,49,1,14,1,7,39,17,
14,3,35,34,46,2,53,17,52,46,2,39,53,62,3,55,
23,17,20,30,2,51,50,54,55,17,52,46,2,39,53,62,
1,55,23,17,20,30,2,23,21,4,29,71,128,54,37,55,
105,94,81,32,47,82,63,36,6,25,52,46,36,63,59,60,
33,28,17,34,50,32,65,165,82,9,30,55,46,72,132,56,
30,3,26,57,54,254,92,12,38,30,34,2,170,69,94,58,
25,26,69,120,94,1,176,48,53,27,10,5,40,4,12,16,
21,13,39,253,181,70,91,52,21,115,107,1,133,45,54,30,
12,2,40,9,38,19,39,251,126,43,52,30,16,6,40,0,
0,1,0,55,0,0,4,76,6,14,0,70,0,253,184,0,
71,47,184,0,72,47,184,0,66,220,185,0,4,0,4,252,
184,0,71,16,184,0,25,208,184,0,25,47,185,0,16,0,
4,252,184,0,54,208,186,0,55,0,25,0,66,17,18,57,
0,184,0,36,47,184,0,0,69,88,184,0,60,47,27,185,
0,60,0,9,62,89,184,0,0,69,88,184,0,0,47,27,
185,0,0,0,5,62,89,184,0,0,69,88,184,0,20,47,
27,185,0,20,0,5,62,89,184,0,60,16,185,0,10,0,
2,252,65,5,0,121,0,10,0,137,0,10,0,2,113,65,
33,0,8,0,10,0,24,0,10,0,40,0,10,0,56,0,
10,0,72,0,10,0,88,0,10,0,104,0,10,0,120,0,
10,0,136,0,10,0,152,0,10,0,168,0,10,0,184,0,
10,0,200,0,10,0,216,0,10,0,232,0,10,0,248,0,
10,0,16,93,65,15,0,8,0,10,0,24,0,10,0,40,
0,10,0,56,0,10,0,72,0,10,0,88,0,10,0,104,
0,10,0,7,113,184,0,36,16,185,0,49,0,2,252,186,
0,55,0,0,0,36,17,18,57,48,49,33,53,62,1,53,
17,52,46,2,35,34,14,2,7,17,20,22,23,21,33,53,
62,1,53,17,52,62,2,55,62,3,51,50,30,2,21,20,
14,2,7,46,1,35,34,14,2,29,1,62,3,51,50,30,
2,21,17,20,22,23,21,2,158,72,68,15,32,48,33,35,
81,88,90,43,75,65,254,82,66,74,34,62,89,56,29,68,
65,59,20,41,83,66,42,29,40,43,15,46,107,62,32,77,
68,45,43,105,106,101,39,43,80,61,37,61,79,43,19,28,
14,2,17,61,76,44,16,36,70,105,70,254,67,15,32,14,
43,43,17,27,17,3,9,124,179,132,99,44,23,34,23,11,
33,44,43,9,8,31,35,30,6,52,64,46,113,189,143,252,
64,102,72,38,26,54,83,56,253,131,14,27,20,43,0,1,
0,55,254,12,3,192,6,14,0,93,0,253,184,0,94,47,
184,0,95,47,184,0,77,220,185,0,15,0,4,252,184,0,
94,16,184,0,36,208,184,0,36,47,185,0,27,0,4,252,
184,0,65,208,186,0,66,0,36,0,77,17,18,57,0,184,
0,47,47,184,0,0,69,88,184,0,71,47,27,185,0,71,
0,9,62,89,184,0,0,69,88,184,0,89,47,27,185,0,
89,0,7,62,89,184,0,0,69,88,184,0,31,47,27,185,
0,31,0,5,62,89,184,0,71,16,185,0,21,0,2,252,
65,5,0,121,0,21,0,137,0,21,0,2,113,65,33,0,
8,0,21,0,24,0,21,0,40,0,21,0,56,0,21,0,
72,0,21,0,88,0,21,0,104,0,21,0,120,0,21,0,
136,0,21,0,152,0,21,0,168,0,21,0,184,0,21,0,
200,0,21,0,216,0,21,0,232,0,21,0,248,0,21,0,
16,93,65,15,0,8,0,21,0,24,0,21,0,40,0,21,
0,56,0,21,0,72,0,21,0,88,0,21,0,104,0,21,
0,7,113,184,0,47,16,185,0,60,0,2,252,186,0,66,
0,89,0,47,17,18,57,48,49,1,52,62,2,55,30,3,
51,50,62,2,53,17,52,46,2,35,34,14,2,7,17,20,
22,23,21,33,53,62,1,53,17,52,62,2,55,62,3,51,
50,30,2,21,20,14,2,7,46,1,35,34,14,2,29,1,
62,3,51,50,30,2,21,17,20,14,4,7,14,3,35,34,
46,2,1,18,27,39,45,18,28,60,54,44,12,35,74,61,
39,15,32,48,33,35,81,88,90,43,75,65,254,82,66,74,
34,62,89,56,29,68,65,59,20,41,83,66,42,29,40,43,
15,46,107,62,32,77,68,45,43,105,106,101,39,43,80,61,
37,16,28,40,48,55,29,25,68,69,61,19,34,79,69,46,
254,111,8,30,32,31,10,26,34,21,9,37,94,160,124,2,
86,61,76,44,16,36,70,105,70,254,67,15,32,14,43,43,
17,27,17,3,9,124,179,132,99,44,23,34,23,11,33,44,
43,9,8,31,35,30,6,52,64,46,113,189,143,252,64,102,
72,38,26,54,83,56,253,115,78,121,94,72,57,49,24,21,
34,24,14,20,30,34,0,2,0,47,0,0,2,10,5,65,
0,14,0,49,0,159,187,0,0,0,4,0,8,0,4,43,
65,5,0,154,0,8,0,170,0,8,0,2,93,65,19,0,
9,0,8,0,25,0,8,0,41,0,8,0,57,0,8,0,
73,0,8,0,89,0,8,0,105,0,8,0,121,0,8,0,
137,0,8,0,9,93,186,0,19,0,8,0,0,17,18,57,
184,0,19,47,184,0,26,208,184,0,19,16,185,0,45,0,
4,252,184,0,39,208,0,184,0,0,69,88,184,0,38,47,
27,185,0,38,0,9,62,89,184,0,0,69,88,184,0,15,
47,27,185,0,15,0,5,62,89,187,0,26,0,2,0,20,
0,4,43,184,0,26,16,184,0,40,208,184,0,20,16,184,
0,43,208,48,49,1,20,14,2,35,34,38,53,52,62,2,
51,50,1,53,62,1,53,17,35,39,62,1,55,51,53,52,
46,2,39,53,62,3,55,51,17,51,23,7,35,17,20,22,
23,21,1,134,18,31,42,25,45,39,18,32,41,24,85,254,
192,68,72,140,23,5,10,8,140,4,26,57,53,31,69,68,
62,26,34,140,22,22,140,67,73,4,226,28,50,37,22,50,
46,28,50,37,21,250,191,43,14,33,14,1,55,22,16,36,
16,165,51,63,35,16,5,40,6,17,21,24,12,254,57,25,
65,254,201,12,35,14,43,0,0,1,0,49,255,226,2,86,
3,192,0,33,0,61,187,0,24,0,4,0,10,0,4,43,
184,0,24,16,0,184,0,0,69,88,184,0,22,47,27,185,
0,22,0,9,62,89,184,0,0,69,88,184,0,5,47,27,
185,0,5,0,5,62,89,186,0,32,0,5,0,22,17,18,
57,48,49,37,14,3,35,34,46,2,53,17,52,46,2,39,
53,62,3,55,51,17,20,30,2,51,50,54,55,23,2,86,
51,87,72,56,19,38,47,28,10,4,25,58,54,31,70,68,
63,24,35,6,17,28,23,11,92,65,16,135,48,64,38,15,
28,57,88,60,1,211,51,63,35,16,5,40,6,17,21,24,
12,253,111,68,78,40,11,34,46,51,0,1,0,70,0,0,
1,244,3,162,0,19,0,51,187,0,15,0,4,0,4,0,
4,43,184,0,15,16,0,184,0,0,69,88,184,0,9,47,
27,185,0,9,0,9,62,89,184,0,0,69,88,184,0,0,
47,27,185,0,0,0,5,62,89,48,49,51,53,62,1,53,
17,52,38,39,53,33,21,14,1,21,17,20,22,23,21,70,
68,72,67,73,1,174,68,72,67,73,43,14,33,14,2,210,
12,35,14,43,43,14,33,14,253,46,12,35,14,43,0,1,
0,0,0,0,2,170,6,14,0,53,0,82,187,0,8,0,
4,0,19,0,4,43,184,0,8,16,184,0,19,16,184,0,
34,208,184,0,8,16,184,0,45,208,0,184,0,44,47,184,
0,0,69,88,184,0,12,47,27,185,0,12,0,5,62,89,
187,0,49,0,2,0,5,0,4,43,184,0,49,16,187,0,
32,0,2,0,23,0,4,43,184,0,32,16,48,49,1,14,
3,35,34,39,17,20,22,23,21,33,53,62,3,53,17,46,
1,35,34,6,7,39,62,3,51,50,23,17,52,46,2,39,
53,62,1,55,23,17,30,1,51,50,54,55,23,2,170,18,
50,61,72,39,14,12,68,82,254,62,43,58,34,15,18,35,
17,40,66,37,53,18,49,62,71,39,13,14,12,32,54,42,
72,120,62,36,18,33,16,38,73,34,54,3,123,41,80,64,
40,3,253,203,15,32,14,43,43,7,15,15,16,8,2,138,
11,14,65,56,20,41,81,64,40,3,1,139,45,50,25,9,
5,40,14,34,32,34,253,70,12,15,64,59,23,0,0,2,
0,0,0,0,2,247,6,14,0,13,0,58,0,165,184,0,
59,47,184,0,60,47,184,0,59,16,184,0,54,208,184,0,
54,47,185,0,0,0,4,252,65,19,0,6,0,0,0,22,
0,0,0,38,0,0,0,54,0,0,0,70,0,0,0,86,
0,0,0,102,0,0,0,118,0,0,0,134,0,0,0,9,
93,65,5,0,149,0,0,0,165,0,0,0,2,93,184,0,
60,16,184,0,29,220,185,0,5,0,4,252,184,0,17,208,
184,0,29,16,184,0,36,208,184,0,5,16,184,0,48,208,
0,184,0,27,47,184,0,0,69,88,184,0,11,47,27,185,
0,11,0,9,62,89,184,0,0,69,88,184,0,41,47,27,
185,0,41,0,5,62,89,186,0,17,0,41,0,27,17,18,
57,48,49,19,20,30,2,23,53,46,3,35,34,6,55,50,
22,23,17,52,46,2,39,53,62,1,55,23,17,62,1,55,
23,14,1,7,17,20,22,23,21,33,53,62,3,53,17,46,
3,53,52,62,2,123,28,48,66,39,1,22,32,37,16,33,
40,97,23,43,18,12,32,54,42,72,120,62,36,69,124,68,
44,63,152,90,68,82,254,62,43,58,34,15,67,111,81,45,
38,63,78,3,85,37,60,45,30,8,107,46,62,37,15,39,
125,8,11,1,33,45,50,25,9,5,40,14,34,32,34,252,
179,12,80,72,46,77,106,20,254,30,15,32,14,43,43,7,
15,15,16,8,1,218,5,36,60,82,51,50,80,55,29,0,
0,1,0,60,254,12,2,249,6,14,0,36,0,159,187,0,
22,0,4,0,10,0,4,43,184,0,22,16,0,184,0,20,
47,184,0,0,69,88,184,0,5,47,27,185,0,5,0,7,
62,89,185,0,25,0,2,252,65,33,0,7,0,25,0,23,
0,25,0,39,0,25,0,55,0,25,0,71,0,25,0,87,
0,25,0,103,0,25,0,119,0,25,0,135,0,25,0,151,
0,25,0,167,0,25,0,183,0,25,0,199,0,25,0,215,
0,25,0,231,0,25,0,247,0,25,0,16,93,65,15,0,
7,0,25,0,23,0,25,0,39,0,25,0,55,0,25,0,
71,0,25,0,87,0,25,0,103,0,25,0,7,113,65,5,
0,118,0,25,0,134,0,25,0,2,113,48,49,5,22,14,
2,35,34,46,2,53,17,52,46,2,39,53,62,1,55,23,
17,20,22,51,50,62,2,39,38,62,2,31,1,2,246,3,
55,98,132,73,61,78,46,18,6,28,56,50,75,131,52,32,
55,72,29,47,28,5,13,3,40,56,58,15,19,235,38,92,
81,54,45,75,99,54,5,205,55,64,36,13,4,40,12,42,
26,31,249,107,115,124,28,42,50,21,4,25,24,17,2,39,
0,1,0,60,254,12,4,76,6,14,0,83,1,113,184,0,
84,47,184,0,85,47,184,0,0,220,185,0,23,0,4,252,
65,5,0,154,0,23,0,170,0,23,0,2,93,65,19,0,
9,0,23,0,25,0,23,0,41,0,23,0,57,0,23,0,
73,0,23,0,89,0,23,0,105,0,23,0,121,0,23,0,
137,0,23,0,9,93,184,0,84,16,184,0,55,208,184,0,
55,47,186,0,37,0,55,0,0,17,18,57,185,0,44,0,
4,252,184,0,66,208,186,0,76,0,55,0,0,17,18,57,
0,184,0,65,47,184,0,0,69,88,184,0,67,47,27,185,
0,67,0,9,62,89,184,0,0,69,88,184,0,71,47,27,
185,0,71,0,9,62,89,184,0,0,69,88,184,0,73,47,
27,185,0,73,0,9,62,89,184,0,0,69,88,184,0,48,
47,27,185,0,48,0,5,62,89,184,0,0,69,88,184,0,
5,47,27,185,0,5,0,7,62,89,187,0,79,0,2,0,
28,0,4,43,184,0,79,16,184,0,5,16,185,0,18,0,
2,252,65,33,0,7,0,18,0,23,0,18,0,39,0,18,
0,55,0,18,0,71,0,18,0,87,0,18,0,103,0,18,
0,119,0,18,0,135,0,18,0,151,0,18,0,167,0,18,
0,183,0,18,0,199,0,18,0,215,0,18,0,231,0,18,
0,247,0,18,0,16,93,65,15,0,7,0,18,0,23,0,
18,0,39,0,18,0,55,0,18,0,71,0,18,0,87,0,
18,0,103,0,18,0,7,113,65,5,0,118,0,18,0,134,
0,18,0,2,113,184,0,73,16,185,0,37,0,2,252,184,
0,38,208,186,0,76,0,28,0,79,17,18,57,48,49,5,
20,14,2,35,34,46,2,53,52,62,2,55,30,1,51,50,
62,2,53,52,46,2,7,34,6,51,46,3,39,1,33,34,
14,2,7,17,20,22,23,21,33,53,62,3,53,17,52,46,
2,39,53,62,1,55,23,17,30,2,51,50,51,33,23,1,
62,1,51,30,3,4,76,83,134,167,84,71,126,93,54,28,
42,48,21,58,119,67,60,102,75,42,38,78,118,79,41,48,
1,7,12,9,6,1,1,82,254,136,16,33,30,27,10,68,
82,254,62,43,58,34,15,12,32,54,42,72,120,62,36,15,
30,33,20,21,26,2,13,25,254,128,17,36,17,80,132,95,
52,26,106,174,125,69,38,53,55,17,6,29,32,27,3,75,
80,42,81,119,76,67,135,106,65,2,16,12,33,34,34,14,
1,179,12,33,56,45,253,178,15,32,14,43,43,7,15,15,
16,8,4,168,45,50,25,9,5,40,14,34,32,34,253,190,
3,4,1,43,254,13,3,4,2,60,110,154,0,1,0,41,
255,226,6,68,3,192,0,97,1,39,184,0,98,47,184,0,
90,208,184,0,90,47,185,0,5,0,4,252,184,0,90,16,
184,0,15,220,65,3,0,127,0,15,0,1,93,65,3,0,
176,0,15,0,1,93,185,0,29,0,4,252,184,0,15,16,
184,0,71,220,65,3,0,127,0,71,0,1,93,65,3,0,
176,0,71,0,1,93,184,0,39,208,184,0,71,16,185,0,
54,0,4,252,184,0,15,16,184,0,81,208,186,0,82,0,
90,0,54,17,18,57,184,0,54,16,184,0,99,220,0,184,
0,0,69,88,184,0,66,47,27,185,0,66,0,5,62,89,
184,0,0,69,88,184,0,76,47,27,185,0,76,0,5,62,
89,184,0,0,69,88,184,0,85,47,27,185,0,85,0,5,
62,89,185,0,10,0,2,252,65,33,0,7,0,10,0,23,
0,10,0,39,0,10,0,55,0,10,0,71,0,10,0,87,
0,10,0,103,0,10,0,119,0,10,0,135,0,10,0,151,
0,10,0,167,0,10,0,183,0,10,0,199,0,10,0,215,
0,10,0,231,0,10,0,247,0,10,0,16,93,65,15,0,
7,0,10,0,23,0,10,0,39,0,10,0,55,0,10,0,
71,0,10,0,87,0,10,0,103,0,10,0,7,113,65,5,
0,118,0,10,0,134,0,10,0,2,113,184,0,34,208,48,
49,19,62,1,55,23,17,20,30,2,51,50,62,2,55,17,
52,46,2,39,53,62,3,55,23,17,20,30,2,51,50,62,
2,55,17,52,46,2,39,53,62,1,55,30,2,49,17,20,
22,23,22,54,55,23,14,3,35,34,46,2,53,14,3,35,
34,46,2,61,1,14,1,35,34,46,2,53,17,52,46,2,
39,53,41,69,123,59,28,14,27,41,26,33,70,76,82,46,
8,26,52,43,36,64,60,59,32,28,13,27,41,27,34,68,
75,82,48,16,34,53,37,68,132,60,1,13,16,12,14,14,
61,41,12,34,67,59,47,15,12,29,24,17,44,94,93,86,
36,57,81,51,23,92,187,74,48,78,55,31,10,29,50,40,
3,126,8,34,24,39,253,144,58,76,45,18,25,57,90,65,
1,143,37,43,24,10,4,40,5,12,16,20,13,39,253,144,
58,76,45,18,25,57,90,65,1,143,40,45,23,7,3,40,
9,36,21,1,18,21,253,67,44,66,7,7,14,17,44,22,
41,31,18,29,61,96,67,61,94,65,33,45,69,85,41,11,
121,130,30,61,94,64,2,5,39,44,23,8,4,40,0,1,
0,41,254,12,6,54,3,192,0,104,1,95,184,0,105,47,
184,0,97,208,184,0,97,47,185,0,5,0,4,252,184,0,
97,16,184,0,15,220,65,3,0,127,0,15,0,1,93,65,
3,0,176,0,15,0,1,93,185,0,29,0,4,252,184,0,
15,16,184,0,40,220,65,3,0,127,0,40,0,1,93,65,
3,0,176,0,40,0,1,93,185,0,53,0,4,252,184,0,
40,16,184,0,64,208,184,0,40,16,184,0,66,208,184,0,
40,16,184,0,68,208,184,0,40,16,184,0,70,208,184,0,
40,16,184,0,72,208,184,0,40,16,184,0,74,208,184,0,
40,16,184,0,76,208,184,0,40,16,184,0,78,208,184,0,
15,16,184,0,88,208,186,0,89,0,97,0,53,17,18,57,
184,0,53,16,184,0,106,220,0,184,0,0,69,88,184,0,
63,47,27,185,0,63,0,7,62,89,184,0,0,69,88,184,
0,83,47,27,185,0,83,0,5,62,89,184,0,0,69,88,
184,0,92,47,27,185,0,92,0,5,62,89,185,0,10,0,
2,252,65,33,0,7,0,10,0,23,0,10,0,39,0,10,
0,55,0,10,0,71,0,10,0,87,0,10,0,103,0,10,
0,119,0,10,0,135,0,10,0,151,0,10,0,167,0,10,
0,183,0,10,0,199,0,10,0,215,0,10,0,231,0,10,
0,247,0,10,0,16,93,65,15,0,7,0,10,0,23,0,
10,0,39,0,10,0,55,0,10,0,71,0,10,0,87,0,
10,0,103,0,10,0,7,113,65,5,0,118,0,10,0,134,
0,10,0,2,113,184,0,34,208,48,49,19,62,1,55,23,
17,20,30,2,51,50,62,2,55,17,52,46,2,39,53,62,
3,55,23,17,20,30,2,51,50,62,2,55,17,52,46,2,
39,53,62,1,55,30,2,49,17,20,30,2,23,21,14,1,
7,39,52,53,52,53,52,53,52,53,52,53,52,53,52,49,
14,3,35,34,46,2,61,1,14,1,35,34,46,2,53,17,
52,46,2,39,53,41,69,123,59,28,14,27,41,26,33,70,
76,82,46,8,26,52,43,36,64,60,59,32,28,13,27,41,
27,34,68,75,82,48,16,34,53,37,68,132,60,1,13,16,
11,30,55,44,66,126,61,37,44,94,93,86,36,57,81,51,
23,92,187,74,48,78,55,31,10,29,50,40,3,126,8,34,
24,39,253,144,58,76,45,18,25,57,90,65,1,143,37,43,
24,10,4,40,5,12,16,20,13,39,253,144,58,76,45,18,
25,57,90,65,1,143,40,45,23,7,3,40,9,36,21,1,
18,21,251,89,33,38,22,10,6,40,10,38,32,34,2,36,
36,63,62,72,72,75,74,60,60,38,39,61,94,65,33,45,
69,85,41,11,121,130,30,61,94,64,2,5,39,44,23,8,
4,40,0,1,0,55,254,12,5,195,3,192,0,106,1,170,
184,0,107,47,184,0,70,208,184,0,70,47,184,0,51,220,
65,3,0,15,0,51,0,1,93,65,3,0,239,0,51,0,
1,93,65,3,0,176,0,51,0,1,93,65,3,0,128,0,
51,0,1,93,184,0,30,220,65,3,0,15,0,30,0,1,
93,65,3,0,239,0,30,0,1,93,65,3,0,128,0,30,
0,1,93,65,3,0,176,0,30,0,1,93,185,0,0,0,
4,252,184,0,51,16,185,0,42,0,4,252,184,0,20,208,
184,0,20,47,184,0,70,16,185,0,61,0,4,252,184,0,
84,208,184,0,84,47,184,0,42,16,184,0,94,208,186,0,
95,0,51,0,30,17,18,57,184,0,0,16,184,0,105,208,
184,0,0,16,184,0,108,220,0,184,0,0,69,88,184,0,
82,47,27,185,0,82,0,9,62,89,184,0,0,69,88,184,
0,89,47,27,185,0,89,0,9,62,89,184,0,0,69,88,
184,0,100,47,27,185,0,100,0,9,62,89,184,0,0,69,
88,184,0,10,47,27,185,0,10,0,7,62,89,184,0,0,
69,88,184,0,46,47,27,185,0,46,0,5,62,89,184,0,
0,69,88,184,0,65,47,27,185,0,65,0,5,62,89,184,
0,100,16,185,0,36,0,2,252,65,5,0,121,0,36,0,
137,0,36,0,2,113,65,33,0,8,0,36,0,24,0,36,
0,40,0,36,0,56,0,36,0,72,0,36,0,88,0,36,
0,104,0,36,0,120,0,36,0,136,0,36,0,152,0,36,
0,168,0,36,0,184,0,36,0,200,0,36,0,216,0,36,
0,232,0,36,0,248,0,36,0,16,93,65,15,0,8,0,
36,0,24,0,36,0,40,0,36,0,56,0,36,0,72,0,
36,0,88,0,36,0,104,0,36,0,7,113,184,0,57,208,
184,0,76,208,186,0,84,0,10,0,82,17,18,57,186,0,
95,0,10,0,82,17,18,57,48,49,37,20,14,2,7,14,
3,35,34,46,2,53,52,62,2,55,30,3,51,50,62,2,
53,17,52,46,2,35,34,14,2,7,17,20,22,23,21,33,
53,62,1,53,17,52,46,2,35,34,6,7,17,20,22,23,
21,33,53,62,1,53,17,52,46,2,39,53,62,3,55,31,
1,62,3,51,50,30,2,29,1,62,3,51,50,30,2,21,
17,5,195,38,61,77,40,27,68,68,61,19,34,79,69,46,
30,41,44,14,29,61,57,48,15,28,69,60,41,13,27,43,
30,33,74,78,79,38,62,79,254,82,72,67,12,27,43,31,
68,149,85,75,65,254,82,66,74,7,29,56,48,38,64,58,
53,27,35,11,45,92,90,84,36,48,81,59,34,42,90,89,
85,37,48,81,59,34,84,116,159,109,75,32,23,34,24,12,
20,30,34,15,9,31,34,30,7,27,34,21,8,37,94,160,
124,2,86,61,81,46,19,37,69,99,62,254,43,14,27,20,
43,43,19,28,14,2,17,61,81,46,19,140,127,254,43,15,
32,14,43,43,17,27,17,2,95,40,46,25,12,6,40,6,
17,20,24,13,35,229,66,99,66,33,24,56,90,67,19,63,
95,65,33,26,54,83,56,253,111,0,0,1,255,16,254,12,
4,66,3,192,0,73,1,2,184,0,74,47,184,0,75,47,
184,0,69,220,185,0,4,0,4,252,184,0,74,16,184,0,
46,208,184,0,46,47,185,0,16,0,4,252,184,0,58,208,
184,0,58,47,0,184,0,0,69,88,184,0,56,47,27,185,
0,56,0,9,62,89,184,0,0,69,88,184,0,63,47,27,
185,0,63,0,9,62,89,184,0,0,69,88,184,0,26,47,
27,185,0,26,0,7,62,89,184,0,0,69,88,184,0,0,
47,27,185,0,0,0,5,62,89,184,0,63,16,185,0,10,
0,2,252,65,5,0,121,0,10,0,137,0,10,0,2,113,
65,33,0,8,0,10,0,24,0,10,0,40,0,10,0,56,
0,10,0,72,0,10,0,88,0,10,0,104,0,10,0,120,
0,10,0,136,0,10,0,152,0,10,0,168,0,10,0,184,
0,10,0,200,0,10,0,216,0,10,0,232,0,10,0,248,
0,10,0,16,93,65,15,0,8,0,10,0,24,0,10,0,
40,0,10,0,56,0,10,0,72,0,10,0,88,0,10,0,
104,0,10,0,7,113,184,0,52,208,184,0,52,47,186,0,
58,0,26,0,56,17,18,57,48,49,33,53,62,1,53,17,
52,46,2,35,34,14,2,7,17,20,14,2,7,14,3,35,
34,46,2,53,52,62,2,55,30,3,51,50,62,2,53,17,
52,46,2,39,53,62,1,55,31,1,62,3,51,50,30,2,
21,17,20,22,23,21,2,148,73,67,13,30,49,36,30,77,
88,94,48,32,55,73,40,26,63,63,56,19,21,51,45,31,
29,40,44,14,19,38,33,30,12,29,59,48,30,6,27,56,
51,68,118,54,34,10,43,107,109,102,39,43,80,61,37,61,
79,43,19,28,14,2,17,61,76,44,16,30,66,107,78,254,
51,117,160,111,75,32,23,34,24,12,14,21,24,10,8,32,
34,30,7,17,18,9,1,32,88,156,124,2,164,39,46,26,
12,6,40,11,41,28,35,249,67,105,73,39,26,54,83,56,
253,131,14,27,20,43,0,1,0,55,254,12,5,91,3,192,
0,68,1,127,184,0,69,47,184,0,70,47,184,0,54,220,
185,0,10,0,4,252,184,0,69,16,184,0,31,208,184,0,
31,47,185,0,22,0,4,252,184,0,43,208,184,0,43,47,
0,184,0,0,69,88,184,0,41,47,27,185,0,41,0,9,
62,89,184,0,0,69,88,184,0,48,47,27,185,0,48,0,
9,62,89,184,0,0,69,88,184,0,26,47,27,185,0,26,
0,5,62,89,184,0,0,69,88,184,0,5,47,27,185,0,
5,0,7,62,89,184,0,48,16,185,0,16,0,2,252,65,
5,0,121,0,16,0,137,0,16,0,2,113,65,33,0,8,
0,16,0,24,0,16,0,40,0,16,0,56,0,16,0,72,
0,16,0,88,0,16,0,104,0,16,0,120,0,16,0,136,
0,16,0,152,0,16,0,168,0,16,0,184,0,16,0,200,
0,16,0,216,0,16,0,232,0,16,0,248,0,16,0,16,
93,65,15,0,8,0,16,0,24,0,16,0,40,0,16,0,
56,0,16,0,72,0,16,0,88,0,16,0,104,0,16,0,
7,113,184,0,37,208,184,0,37,47,186,0,43,0,5,0,
41,17,18,57,184,0,5,16,185,0,57,0,2,252,65,33,
0,7,0,57,0,23,0,57,0,39,0,57,0,55,0,57,
0,71,0,57,0,87,0,57,0,103,0,57,0,119,0,57,
0,135,0,57,0,151,0,57,0,167,0,57,0,183,0,57,
0,199,0,57,0,215,0,57,0,231,0,57,0,247,0,57,
0,16,93,65,15,0,7,0,57,0,23,0,57,0,39,0,
57,0,55,0,57,0,71,0,57,0,87,0,57,0,103,0,
57,0,7,113,65,5,0,118,0,57,0,134,0,57,0,2,
113,48,49,5,22,14,2,35,34,46,2,53,17,52,46,2,
35,34,14,2,7,17,20,22,23,21,33,53,62,1,53,17,
52,46,2,39,53,62,1,55,31,1,62,3,51,50,30,2,
21,17,20,22,51,50,62,2,39,38,62,2,31,1,5,88,
3,55,98,132,73,61,78,46,18,14,30,49,35,31,76,87,
95,48,75,65,254,82,66,74,6,27,56,51,68,116,56,35,
11,44,106,108,101,39,43,80,61,37,55,72,29,47,28,5,
13,3,40,56,58,15,19,235,38,92,81,54,45,75,99,54,
3,92,61,76,44,16,30,66,107,78,254,67,15,32,14,43,
43,17,27,17,2,95,39,46,26,12,6,40,11,41,28,35,
249,67,105,73,39,26,54,83,56,252,117,115,124,28,42,50,
21,4,25,24,17,2,39,0,0,1,0,55,255,234,4,96,
3,162,0,42,0,81,184,0,43,47,184,0,44,47,184,0,
43,16,184,0,6,208,184,0,6,47,184,0,44,16,184,0,
31,220,185,0,18,0,3,252,184,0,6,16,185,0,38,0,
3,252,0,184,0,0,69,88,184,0,11,47,27,185,0,11,
0,9,62,89,184,0,0,69,88,184,0,23,47,27,185,0,
23,0,9,62,89,48,49,51,53,62,3,53,17,46,1,39,
53,51,50,30,2,23,1,17,52,38,39,53,33,21,14,3,
21,17,46,3,39,1,17,20,22,23,21,55,30,52,37,21,
32,73,35,210,12,16,16,20,16,2,11,74,66,1,136,30,
51,37,22,20,40,33,25,5,253,216,76,63,43,6,17,17,
16,5,2,203,29,34,5,43,4,12,23,19,253,124,2,85,
9,39,14,43,43,6,17,18,16,5,252,177,2,5,6,9,
6,2,170,253,184,9,39,13,43,0,0,3,0,80,255,226,
3,182,3,192,0,10,0,21,0,45,1,101,184,0,46,47,
184,0,47,47,184,0,22,220,185,0,5,0,4,252,184,0,
46,16,184,0,34,208,184,0,34,47,185,0,16,0,4,252,
184,0,6,208,184,0,6,47,184,0,5,16,184,0,17,208,
184,0,17,47,0,184,0,0,69,88,184,0,41,47,27,185,
0,41,0,9,62,89,184,0,0,69,88,184,0,29,47,27,
185,0,29,0,5,62,89,187,0,17,0,2,0,5,0,4,
43,184,0,17,16,184,0,29,16,185,0,0,0,2,252,65,
33,0,7,0,0,0,23,0,0,0,39,0,0,0,55,0,
0,0,71,0,0,0,87,0,0,0,103,0,0,0,119,0,
0,0,135,0,0,0,151,0,0,0,167,0,0,0,183,0,
0,0,199,0,0,0,215,0,0,0,231,0,0,0,247,0,
0,0,16,93,65,15,0,7,0,0,0,23,0,0,0,39,
0,0,0,55,0,0,0,71,0,0,0,87,0,0,0,103,
0,0,0,7,113,65,5,0,118,0,0,0,134,0,0,0,
2,113,184,0,41,16,185,0,11,0,2,252,65,5,0,121,
0,11,0,137,0,11,0,2,113,65,33,0,8,0,11,0,
24,0,11,0,40,0,11,0,56,0,11,0,72,0,11,0,
88,0,11,0,104,0,11,0,120,0,11,0,136,0,11,0,
152,0,11,0,168,0,11,0,184,0,11,0,200,0,11,0,
216,0,11,0,232,0,11,0,248,0,11,0,16,93,65,15,
0,8,0,11,0,24,0,11,0,40,0,11,0,56,0,11,
0,72,0,11,0,88,0,11,0,104,0,11,0,7,113,48,
49,37,50,62,2,55,33,30,3,19,34,14,2,7,33,46,
3,1,20,14,4,35,34,46,2,53,52,62,4,51,50,30,
2,2,12,66,99,67,36,4,253,209,10,61,81,93,24,72,
102,65,31,3,2,49,8,57,80,96,1,141,34,60,84,101,
114,61,95,153,109,59,33,59,83,101,116,63,94,153,109,59,
80,47,87,124,77,70,122,91,52,3,2,52,93,126,74,71,
125,94,55,254,147,66,129,114,97,70,39,72,126,174,102,66,
128,115,97,70,40,72,127,174,0,2,0,80,255,231,5,41,
3,186,0,18,0,84,1,197,184,0,85,47,184,0,86,47,
184,0,72,220,185,0,5,0,4,252,184,0,85,16,184,0,
35,208,184,0,35,47,185,0,14,0,4,252,65,19,0,6,
0,14,0,22,0,14,0,38,0,14,0,54,0,14,0,70,
0,14,0,86,0,14,0,102,0,14,0,118,0,14,0,134,
0,14,0,9,93,65,5,0,149,0,14,0,165,0,14,0,
2,93,184,0,72,16,184,0,57,208,0,184,0,0,69,88,
184,0,45,47,27,185,0,45,0,9,62,89,184,0,0,69,
88,184,0,40,47,27,185,0,40,0,9,62,89,184,0,0,
69,88,184,0,30,47,27,185,0,30,0,5,62,89,184,0,
0,69,88,184,0,24,47,27,185,0,24,0,5,62,89,187,
0,58,0,2,0,71,0,4,43,184,0,58,16,184,0,30,
16,185,0,0,0,2,252,65,33,0,7,0,0,0,23,0,
0,0,39,0,0,0,55,0,0,0,71,0,0,0,87,0,
0,0,103,0,0,0,119,0,0,0,135,0,0,0,151,0,
0,0,167,0,0,0,183,0,0,0,199,0,0,0,215,0,
0,0,231,0,0,0,247,0,0,0,16,93,65,15,0,7,
0,0,0,23,0,0,0,39,0,0,0,55,0,0,0,71,
0,0,0,87,0,0,0,103,0,0,0,7,113,65,5,0,
118,0,0,0,134,0,0,0,2,113,184,0,45,16,185,0,
9,0,1,252,65,5,0,121,0,9,0,137,0,9,0,2,
113,65,33,0,8,0,9,0,24,0,9,0,40,0,9,0,
56,0,9,0,72,0,9,0,88,0,9,0,104,0,9,0,
120,0,9,0,136,0,9,0,152,0,9,0,168,0,9,0,
184,0,9,0,200,0,9,0,216,0,9,0,232,0,9,0,
248,0,9,0,16,93,65,15,0,8,0,9,0,24,0,9,
0,40,0,9,0,56,0,9,0,72,0,9,0,88,0,9,
0,104,0,9,0,7,113,184,0,45,16,185,0,56,0,2,
252,184,0,24,16,185,0,77,0,2,252,48,49,37,50,62,
2,55,17,46,1,35,34,14,2,21,20,30,2,37,14,3,
7,33,14,3,35,34,46,2,53,52,62,2,51,50,30,2,
23,33,23,14,3,7,35,46,1,43,1,17,33,23,14,3,
7,46,3,43,1,17,20,30,2,59,1,50,62,2,55,23,
2,23,31,51,43,38,18,38,89,54,71,113,79,42,49,84,
110,3,80,3,10,9,9,3,253,228,44,61,52,54,36,99,
156,108,57,74,127,171,97,33,47,44,47,32,1,232,25,2,
6,9,10,5,45,3,32,32,255,1,36,24,8,19,21,20,
8,12,26,36,49,35,82,4,26,54,51,96,38,53,40,34,
18,41,74,2,8,13,11,2,199,26,24,54,102,145,91,84,
146,110,63,131,32,64,56,42,11,1,8,9,7,80,133,173,
94,101,181,137,80,7,9,7,1,18,19,56,58,51,14,69,
50,254,226,21,11,29,29,25,6,11,15,10,5,254,183,11,
18,12,7,7,27,50,44,13,0,2,0,78,255,225,4,209,
3,192,0,43,0,73,2,24,187,0,34,0,4,0,20,0,
4,43,184,0,34,16,187,0,10,0,4,0,44,0,4,43,
184,0,10,16,187,0,54,0,4,0,0,0,4,43,184,0,
54,16,65,5,0,154,0,0,0,170,0,0,0,2,93,65,
19,0,9,0,0,0,25,0,0,0,41,0,0,0,57,0,
0,0,73,0,0,0,89,0,0,0,105,0,0,0,121,0,
0,0,137,0,0,0,9,93,65,19,0,6,0,10,0,22,
0,10,0,38,0,10,0,54,0,10,0,70,0,10,0,86,
0,10,0,102,0,10,0,118,0,10,0,134,0,10,0,9,
93,65,5,0,149,0,10,0,165,0,10,0,2,93,65,5,
0,154,0,20,0,170,0,20,0,2,93,65,19,0,9,0,
20,0,25,0,20,0,41,0,20,0,57,0,20,0,73,0,
20,0,89,0,20,0,105,0,20,0,121,0,20,0,137,0,
20,0,9,93,186,0,64,0,20,0,34,17,18,57,184,0,
75,220,0,184,0,0,69,88,184,0,49,47,27,185,0,49,
0,9,62,89,184,0,0,69,88,184,0,59,47,27,185,0,
59,0,5,62,89,184,0,0,69,88,184,0,69,47,27,185,
0,69,0,5,62,89,184,0,49,16,185,0,5,0,2,252,
65,5,0,121,0,5,0,137,0,5,0,2,113,65,33,0,
8,0,5,0,24,0,5,0,40,0,5,0,56,0,5,0,
72,0,5,0,88,0,5,0,104,0,5,0,120,0,5,0,
136,0,5,0,152,0,5,0,168,0,5,0,184,0,5,0,
200,0,5,0,216,0,5,0,232,0,5,0,248,0,5,0,
16,93,65,15,0,8,0,5,0,24,0,5,0,40,0,5,
0,56,0,5,0,72,0,5,0,88,0,5,0,104,0,5,
0,7,113,184,0,69,16,185,0,15,0,2,252,65,33,0,
7,0,15,0,23,0,15,0,39,0,15,0,55,0,15,0,
71,0,15,0,87,0,15,0,103,0,15,0,119,0,15,0,
135,0,15,0,151,0,15,0,167,0,15,0,183,0,15,0,
199,0,15,0,215,0,15,0,231,0,15,0,247,0,15,0,
16,93,65,15,0,7,0,15,0,23,0,15,0,39,0,15,
0,55,0,15,0,71,0,15,0,87,0,15,0,103,0,15,
0,7,113,65,5,0,118,0,15,0,134,0,15,0,2,113,
184,0,39,208,186,0,64,0,59,0,49,17,18,57,48,49,
1,52,46,2,35,34,14,2,21,20,30,2,51,50,62,2,
53,52,46,2,39,62,1,55,30,1,49,14,1,21,20,30,
2,51,50,62,2,37,52,62,2,51,50,30,2,21,20,14,
2,35,34,46,2,39,14,3,35,34,46,2,4,49,65,112,
151,86,93,154,111,62,21,47,73,51,32,61,48,29,5,7,
9,4,43,71,32,8,21,12,15,18,43,69,51,45,63,41,
19,252,29,77,149,216,139,124,210,153,87,61,97,120,58,53,
79,57,38,11,16,45,66,91,62,61,109,83,48,1,155,111,
171,117,60,68,119,161,94,71,124,91,52,44,78,105,60,33,
62,52,42,13,16,28,13,10,22,38,102,81,59,107,80,47,
49,87,117,50,107,205,159,96,72,135,193,121,116,176,118,60,
40,66,85,46,44,85,67,41,55,107,158,0,0,3,0,80,
254,32,4,6,6,14,0,10,0,22,0,65,0,238,184,0,
66,47,184,0,44,208,184,0,44,47,185,0,0,0,4,252,
184,0,44,16,184,0,5,220,65,3,0,63,0,5,0,1,
93,65,5,0,64,0,5,0,80,0,5,0,2,93,65,3,
0,160,0,5,0,1,93,185,0,11,0,4,252,184,0,5,
16,184,0,16,220,65,3,0,63,0,16,0,1,93,65,5,
0,64,0,16,0,80,0,16,0,2,93,65,3,0,160,0,
16,0,1,93,184,0,11,16,184,0,21,208,184,0,16,16,
185,0,23,0,4,252,184,0,11,16,184,0,28,208,184,0,
5,16,184,0,38,208,184,0,5,16,184,0,49,208,184,0,
11,16,184,0,60,208,184,0,23,16,184,0,67,220,0,184,
0,59,47,184,0,0,69,88,184,0,49,47,27,185,0,49,
0,9,62,89,184,0,0,69,88,184,0,61,47,27,185,0,
61,0,9,62,89,184,0,0,69,88,184,0,33,47,27,185,
0,33,0,7,62,89,186,0,5,0,33,0,59,17,18,57,
186,0,21,0,33,0,59,17,18,57,48,49,19,20,30,2,
23,17,14,3,1,62,3,53,52,46,2,39,17,1,20,14,
2,7,17,20,22,23,21,33,53,62,1,53,17,46,3,53,
52,62,2,55,17,46,3,39,53,62,1,55,23,17,30,3,
233,41,69,89,48,69,94,58,26,1,141,64,94,60,29,40,
67,90,50,1,144,61,107,147,85,67,73,254,82,68,72,93,
149,103,55,60,106,147,87,1,14,32,53,40,72,120,62,36,
93,148,104,55,1,217,65,120,99,74,18,2,236,11,65,98,
126,254,52,10,61,95,127,77,66,121,101,74,18,253,18,1,
144,88,166,136,97,18,254,156,12,35,14,43,43,14,33,14,
1,93,9,78,125,164,95,88,166,137,97,18,1,107,39,43,
22,8,5,40,14,34,32,34,253,209,9,79,124,165,0,1,
0,56,255,226,3,12,3,192,0,51,0,64,0,184,0,0,
69,88,184,0,26,47,27,185,0,26,0,9,62,89,184,0,
0,69,88,184,0,42,47,27,185,0,42,0,5,62,89,184,
0,0,69,88,184,0,49,47,27,185,0,49,0,5,62,89,
186,0,44,0,42,0,26,17,18,57,48,49,55,38,62,2,
55,51,30,3,51,50,62,2,55,17,52,46,2,39,53,62,
1,55,23,17,20,30,2,23,30,3,23,21,14,1,7,47,
1,14,3,35,34,38,65,9,1,15,24,12,43,6,22,29,
35,19,22,59,62,61,24,16,41,67,51,72,149,73,31,4,
6,8,5,7,17,27,38,28,65,125,50,35,13,27,63,72,
79,43,32,74,7,6,58,76,80,27,41,55,33,15,37,79,
123,85,1,16,45,56,32,14,3,39,10,31,24,30,253,82,
33,45,28,17,4,7,9,6,4,1,40,17,35,28,35,227,
56,95,71,40,16,0,0,1,0,56,255,226,3,12,6,14,
0,53,0,85,187,0,30,0,4,0,16,0,4,43,184,0,
30,16,184,0,16,16,184,0,46,208,184,0,46,47,184,0,
30,16,184,0,55,220,0,184,0,28,47,184,0,0,69,88,
184,0,44,47,27,185,0,44,0,5,62,89,184,0,0,69,
88,184,0,51,47,27,185,0,51,0,5,62,89,186,0,46,
0,44,0,28,17,18,57,48,49,55,38,62,2,55,51,30,
3,51,50,62,2,55,17,52,46,2,39,53,62,3,55,23,
17,20,30,2,23,30,3,23,21,14,1,7,47,1,14,3,
35,34,38,65,9,1,15,24,12,43,6,22,29,35,19,22,
59,62,61,24,7,29,58,51,36,64,63,65,36,31,4,6,
8,5,7,17,27,38,28,65,125,50,35,13,27,63,72,79,
43,32,74,7,6,58,76,80,27,41,55,33,15,37,79,123,
85,3,94,45,56,32,14,3,39,5,12,16,20,12,30,251,
4,33,45,28,17,4,7,9,6,4,1,40,17,35,28,35,
227,56,95,71,40,16,0,1,0,56,254,12,4,27,3,192,
0,61,0,215,187,0,47,0,4,0,10,0,4,43,184,0,
47,16,184,0,10,16,184,0,35,208,184,0,47,16,184,0,
63,220,0,184,0,0,69,88,184,0,45,47,27,185,0,45,
0,9,62,89,184,0,0,69,88,184,0,16,47,27,185,0,
16,0,5,62,89,184,0,0,69,88,184,0,5,47,27,185,
0,5,0,7,62,89,186,0,11,0,5,0,45,17,18,57,
185,0,50,0,2,252,65,33,0,7,0,50,0,23,0,50,
0,39,0,50,0,55,0,50,0,71,0,50,0,87,0,50,
0,103,0,50,0,119,0,50,0,135,0,50,0,151,0,50,
0,167,0,50,0,183,0,50,0,199,0,50,0,215,0,50,
0,231,0,50,0,247,0,50,0,16,93,65,15,0,7,0,
50,0,23,0,50,0,39,0,50,0,55,0,50,0,71,0,
50,0,87,0,50,0,103,0,50,0,7,113,65,5,0,118,
0,50,0,134,0,50,0,2,113,48,49,5,22,14,2,35,
34,46,2,53,17,14,3,35,34,38,39,38,62,2,55,51,
30,3,51,50,62,2,55,17,52,46,2,39,53,62,1,55,
23,17,20,22,51,50,62,2,39,38,62,2,31,1,4,24,
3,55,98,132,73,61,78,46,18,27,63,71,78,43,32,74,
37,9,1,15,24,12,43,6,22,29,35,19,22,59,62,61,
24,13,37,69,57,79,147,69,31,55,72,29,47,28,5,13,
3,40,56,58,15,19,235,38,92,81,54,45,75,99,54,1,
199,55,94,69,40,16,21,6,58,76,80,27,41,55,33,15,
37,79,123,85,1,16,42,54,33,16,5,39,11,31,23,30,
251,184,115,124,28,42,50,21,4,25,24,17,2,39,0,1,
0,55,254,32,3,11,3,192,0,50,0,86,187,0,17,0,
4,0,26,0,4,43,184,0,17,16,184,0,43,208,184,0,
43,47,0,184,0,0,69,88,184,0,41,47,27,185,0,41,
0,9,62,89,184,0,0,69,88,184,0,48,47,27,185,0,
48,0,9,62,89,184,0,0,69,88,184,0,21,47,27,185,
0,21,0,7,62,89,186,0,43,0,21,0,41,17,18,57,
48,49,1,22,14,2,7,35,46,3,35,34,14,2,7,17,
20,22,23,21,33,53,62,1,53,17,52,46,2,39,46,3,
39,53,62,1,55,31,1,62,3,51,50,22,3,2,9,1,
15,24,12,43,6,22,29,35,19,22,59,62,61,24,75,94,
254,53,66,74,4,6,9,4,7,17,27,38,28,65,125,50,
35,13,27,63,72,79,43,32,74,3,155,6,58,76,80,27,
40,56,33,15,37,79,123,85,252,152,15,32,14,43,43,15,
29,17,4,38,33,45,28,16,5,7,9,6,3,2,40,17,
35,28,35,227,55,96,71,40,16,0,0,1,0,55,254,12,
3,15,3,192,0,68,0,207,187,0,52,0,4,0,10,0,
4,43,184,0,52,16,184,0,27,208,184,0,27,47,0,184,
0,0,69,88,184,0,25,47,27,185,0,25,0,9,62,89,
184,0,0,69,88,184,0,32,47,27,185,0,32,0,9,62,
89,184,0,0,69,88,184,0,5,47,27,185,0,5,0,7,
62,89,186,0,27,0,5,0,25,17,18,57,185,0,57,0,
2,252,65,33,0,7,0,57,0,23,0,57,0,39,0,57,
0,55,0,57,0,71,0,57,0,87,0,57,0,103,0,57,
0,119,0,57,0,135,0,57,0,151,0,57,0,167,0,57,
0,183,0,57,0,199,0,57,0,215,0,57,0,231,0,57,
0,247,0,57,0,16,93,65,15,0,7,0,57,0,23,0,
57,0,39,0,57,0,55,0,57,0,71,0,57,0,87,0,
57,0,103,0,57,0,7,113,65,5,0,118,0,57,0,134,
0,57,0,2,113,48,49,5,22,14,2,35,34,46,2,53,
17,52,46,2,39,46,3,39,53,62,1,55,31,1,62,3,
51,50,22,23,22,14,2,7,35,46,3,35,34,14,2,7,
17,20,30,2,51,50,62,2,39,38,62,2,31,1,3,12,
3,58,102,135,73,68,86,48,18,4,6,9,4,7,17,27,
38,28,65,125,50,35,13,27,63,72,79,43,32,74,37,9,
1,15,24,12,43,6,22,29,35,19,22,59,62,61,24,12,
32,56,44,29,51,31,8,13,3,40,56,58,15,19,235,38,
92,81,54,45,75,99,54,3,145,33,45,28,16,5,7,9,
6,3,2,40,17,35,28,35,227,55,96,71,40,16,21,6,
58,76,80,27,40,56,33,15,37,79,123,85,253,106,57,89,
61,32,28,42,50,21,4,25,24,17,2,39,0,1,0,40,
0,0,2,202,3,192,0,34,0,176,187,0,15,0,4,0,
24,0,4,43,184,0,15,16,0,184,0,0,69,88,184,0,
32,47,27,185,0,32,0,9,62,89,184,0,0,69,88,184,
0,19,47,27,185,0,19,0,5,62,89,184,0,32,16,185,
0,9,0,2,252,65,5,0,121,0,9,0,137,0,9,0,
2,113,65,33,0,8,0,9,0,24,0,9,0,40,0,9,
0,56,0,9,0,72,0,9,0,88,0,9,0,104,0,9,
0,120,0,9,0,136,0,9,0,152,0,9,0,168,0,9,
0,184,0,9,0,200,0,9,0,216,0,9,0,232,0,9,
0,248,0,9,0,16,93,65,15,0,8,0,9,0,24,0,
9,0,40,0,9,0,56,0,9,0,72,0,9,0,88,0,
9,0,104,0,9,0,7,113,48,49,1,22,14,2,7,35,
46,1,35,34,14,2,21,17,20,22,23,21,33,53,62,1,
53,17,52,62,4,51,50,22,2,193,9,1,15,24,12,43,
10,67,44,26,58,51,33,75,94,254,53,66,74,38,63,81,
85,82,33,32,74,3,155,6,58,76,80,27,72,72,14,59,
118,103,254,90,15,32,14,43,43,15,29,17,1,96,95,148,
112,78,49,22,16,0,0,1,0,56,0,0,2,218,3,192,
0,36,0,180,187,0,11,0,4,0,20,0,4,43,184,0,
11,16,184,0,38,220,0,184,0,0,69,88,184,0,5,47,
27,185,0,5,0,9,62,89,184,0,0,69,88,184,0,15,
47,27,185,0,15,0,5,62,89,184,0,5,16,185,0,26,
0,2,252,65,5,0,121,0,26,0,137,0,26,0,2,113,
65,33,0,8,0,26,0,24,0,26,0,40,0,26,0,56,
0,26,0,72,0,26,0,88,0,26,0,104,0,26,0,120,
0,26,0,136,0,26,0,152,0,26,0,168,0,26,0,184,
0,26,0,200,0,26,0,216,0,26,0,232,0,26,0,248,
0,26,0,16,93,65,15,0,8,0,26,0,24,0,26,0,
40,0,26,0,56,0,26,0,72,0,26,0,88,0,26,0,
104,0,26,0,7,113,48,49,19,62,3,51,50,30,2,21,
17,20,22,23,21,33,53,62,1,53,17,52,46,2,35,34,
14,2,7,35,46,3,65,31,80,84,83,35,27,73,66,46,
74,66,254,53,94,75,22,38,48,26,38,54,37,21,5,43,
12,24,15,1,3,35,38,58,40,21,12,46,94,82,253,146,
17,29,15,43,43,14,32,15,2,50,51,67,39,16,46,70,
81,36,27,64,58,42,0,2,0,50,255,246,4,5,3,192,
0,15,0,62,0,184,184,0,63,47,184,0,64,47,184,0,
63,16,184,0,20,208,184,0,20,47,185,0,58,0,4,252,
184,0,0,208,184,0,64,16,184,0,35,220,185,0,10,0,
4,252,65,5,0,154,0,10,0,170,0,10,0,2,93,65,
19,0,9,0,10,0,25,0,10,0,41,0,10,0,57,0,
10,0,73,0,10,0,89,0,10,0,105,0,10,0,121,0,
10,0,137,0,10,0,9,93,184,0,35,16,184,0,41,208,
184,0,41,47,0,184,0,0,69,88,184,0,30,47,27,185,
0,30,0,9,62,89,187,0,7,0,2,0,54,0,4,43,
184,0,7,16,184,0,30,16,185,0,0,0,2,252,184,0,
7,16,184,0,5,208,184,0,0,16,184,0,21,208,184,0,
21,47,186,0,40,0,54,0,7,17,18,57,48,49,1,17,
30,2,51,50,51,50,54,53,52,46,2,35,1,53,62,1,
53,17,14,1,7,39,62,3,51,50,30,2,21,20,14,2,
7,1,30,3,55,23,14,1,35,34,38,39,1,34,38,39,
17,20,22,23,21,1,89,10,11,10,6,6,10,149,157,36,
76,120,85,254,180,63,77,32,66,38,9,44,81,86,98,62,
110,164,109,54,47,82,113,66,1,44,15,32,41,49,32,10,
62,111,37,26,52,13,254,190,19,25,17,67,68,3,109,254,
164,2,1,2,88,99,39,62,42,23,252,147,43,13,38,10,
2,254,2,6,3,56,9,16,12,8,35,60,83,48,59,94,
71,47,12,254,174,16,19,9,1,2,42,17,21,24,17,1,
153,3,4,254,169,9,39,13,43,0,0,2,0,50,255,226,
3,221,3,192,0,47,0,64,1,63,184,0,65,47,184,0,
66,47,184,0,65,16,184,0,38,208,184,0,38,47,185,0,
61,0,4,252,184,0,1,208,184,0,66,16,184,0,24,220,
186,0,19,0,38,0,24,17,18,57,185,0,51,0,4,252,
65,5,0,154,0,51,0,170,0,51,0,2,93,65,19,0,
9,0,51,0,25,0,51,0,41,0,51,0,57,0,51,0,
73,0,51,0,89,0,51,0,105,0,51,0,121,0,51,0,
137,0,51,0,9,93,0,184,0,0,69,88,184,0,9,47,
27,185,0,9,0,9,62,89,184,0,0,69,88,184,0,0,
47,27,185,0,0,0,9,62,89,184,0,0,69,88,184,0,
29,47,27,185,0,29,0,5,62,89,186,0,19,0,29,0,
0,17,18,57,184,0,0,16,185,0,45,0,1,252,184,0,
29,16,185,0,48,0,2,252,65,33,0,7,0,48,0,23,
0,48,0,39,0,48,0,55,0,48,0,71,0,48,0,87,
0,48,0,103,0,48,0,119,0,48,0,135,0,48,0,151,
0,48,0,167,0,48,0,183,0,48,0,199,0,48,0,215,
0,48,0,231,0,48,0,247,0,48,0,16,93,65,15,0,
7,0,48,0,23,0,48,0,39,0,48,0,55,0,48,0,
71,0,48,0,87,0,48,0,103,0,48,0,7,113,65,5,
0,118,0,48,0,134,0,48,0,2,113,184,0,61,208,184,
0,61,47,184,0,63,208,48,49,1,23,17,62,1,55,1,
62,1,51,50,22,23,7,38,14,2,7,1,30,3,21,20,
14,2,35,34,46,2,39,55,30,1,23,17,52,46,2,39,
53,62,1,19,50,54,53,52,38,35,34,35,34,14,1,7,
17,22,51,50,1,61,28,20,28,12,1,27,13,52,26,37,
111,62,10,32,49,41,32,15,254,249,67,114,83,47,55,110,
164,108,54,96,90,87,44,9,35,68,33,8,29,56,47,71,
134,147,152,145,159,147,10,6,6,10,11,10,15,15,16,3,
192,39,254,73,3,4,1,1,153,17,24,21,17,42,2,1,
9,19,16,254,178,8,35,59,86,59,52,96,74,44,8,12,
16,9,66,5,8,3,2,129,48,55,29,11,5,40,8,34,
252,141,84,82,98,89,2,2,1,254,165,1,0,1,0,95,
254,12,2,188,3,192,0,96,2,89,187,0,59,0,4,0,
35,0,4,43,184,0,59,16,187,0,69,0,4,0,25,0,
4,43,184,0,69,16,184,0,35,16,184,0,8,208,184,0,
8,47,65,5,0,154,0,25,0,170,0,25,0,2,93,65,
19,0,9,0,25,0,25,0,25,0,41,0,25,0,57,0,
25,0,73,0,25,0,89,0,25,0,105,0,25,0,121,0,
25,0,137,0,25,0,9,93,65,19,0,6,0,59,0,22,
0,59,0,38,0,59,0,54,0,59,0,70,0,59,0,86,
0,59,0,102,0,59,0,118,0,59,0,134,0,59,0,9,
93,65,5,0,149,0,59,0,165,0,59,0,2,93,184,0,
35,16,185,0,79,0,3,252,184,0,69,16,184,0,98,220,
0,184,0,0,69,88,184,0,40,47,27,185,0,40,0,9,
62,89,184,0,0,69,88,184,0,5,47,27,185,0,5,0,
7,62,89,184,0,0,69,88,184,0,76,47,27,185,0,76,
0,5,62,89,185,0,20,0,2,252,65,33,0,7,0,20,
0,23,0,20,0,39,0,20,0,55,0,20,0,71,0,20,
0,87,0,20,0,103,0,20,0,119,0,20,0,135,0,20,
0,151,0,20,0,167,0,20,0,183,0,20,0,199,0,20,
0,215,0,20,0,231,0,20,0,247,0,20,0,16,93,65,
15,0,7,0,20,0,23,0,20,0,39,0,20,0,55,0,
20,0,71,0,20,0,87,0,20,0,103,0,20,0,7,113,
65,5,0,118,0,20,0,134,0,20,0,2,113,184,0,40,
16,185,0,54,0,2,252,65,5,0,121,0,54,0,137,0,
54,0,2,113,65,33,0,8,0,54,0,24,0,54,0,40,
0,54,0,56,0,54,0,72,0,54,0,88,0,54,0,104,
0,54,0,120,0,54,0,136,0,54,0,152,0,54,0,168,
0,54,0,184,0,54,0,200,0,54,0,216,0,54,0,232,
0,54,0,248,0,54,0,16,93,65,15,0,8,0,54,0,
24,0,54,0,40,0,54,0,56,0,54,0,72,0,54,0,
88,0,54,0,104,0,54,0,7,113,186,0,79,0,76,0,
20,17,18,57,184,0,5,16,185,0,85,0,2,252,65,33,
0,7,0,85,0,23,0,85,0,39,0,85,0,55,0,85,
0,71,0,85,0,87,0,85,0,103,0,85,0,119,0,85,
0,135,0,85,0,151,0,85,0,167,0,85,0,183,0,85,
0,199,0,85,0,215,0,85,0,231,0,85,0,247,0,85,
0,16,93,65,15,0,7,0,85,0,23,0,85,0,39,0,
85,0,55,0,85,0,71,0,85,0,87,0,85,0,103,0,
85,0,7,113,65,5,0,118,0,85,0,134,0,85,0,2,
113,48,49,5,22,14,2,35,34,38,53,17,38,62,2,55,
23,30,3,51,50,62,2,53,52,46,2,39,46,3,53,52,
62,2,51,50,30,2,23,22,14,2,7,39,46,1,35,34,
14,2,21,20,30,2,23,30,3,21,20,14,4,35,34,38,
39,21,20,30,2,51,50,62,1,38,39,38,62,2,31,1,
2,12,3,32,65,93,58,84,99,1,1,4,8,5,43,2,
40,67,89,52,36,60,44,24,43,70,89,46,42,78,61,37,
50,83,107,57,31,75,73,64,20,6,9,19,22,6,39,48,
103,49,33,52,37,19,38,62,79,42,43,88,70,44,40,64,
78,76,67,19,34,88,48,12,24,36,25,29,36,14,8,15,
3,39,56,59,15,19,235,38,92,81,54,122,131,1,78,21,
55,55,49,16,11,42,74,56,32,23,42,59,35,40,62,51,
45,24,21,48,60,74,48,62,97,66,35,11,20,28,18,6,
42,50,44,8,8,72,57,22,35,42,21,32,51,45,41,22,
22,50,65,83,56,71,101,70,42,22,7,18,18,202,61,81,
48,19,31,43,49,18,4,24,25,17,2,39,0,1,254,252,
254,12,2,202,6,14,0,73,1,31,187,0,67,0,4,0,
37,0,4,43,184,0,67,16,65,19,0,6,0,67,0,22,
0,67,0,38,0,67,0,54,0,67,0,70,0,67,0,86,
0,67,0,102,0,67,0,118,0,67,0,134,0,67,0,9,
93,65,5,0,149,0,67,0,165,0,67,0,2,93,186,0,
30,0,37,0,67,17,18,57,184,0,30,47,65,5,0,154,
0,30,0,170,0,30,0,2,93,65,19,0,9,0,30,0,
25,0,30,0,41,0,30,0,57,0,30,0,73,0,30,0,
89,0,30,0,105,0,30,0,121,0,30,0,137,0,30,0,
9,93,185,0,0,0,4,252,0,184,0,47,47,184,0,0,
69,88,184,0,10,47,27,185,0,10,0,7,62,89,185,0,
25,0,2,252,65,33,0,7,0,25,0,23,0,25,0,39,
0,25,0,55,0,25,0,71,0,25,0,87,0,25,0,103,
0,25,0,119,0,25,0,135,0,25,0,151,0,25,0,167,
0,25,0,183,0,25,0,199,0,25,0,215,0,25,0,231,
0,25,0,247,0,25,0,16,93,65,15,0,7,0,25,0,
23,0,25,0,39,0,25,0,55,0,25,0,71,0,25,0,
87,0,25,0,103,0,25,0,7,113,65,5,0,118,0,25,
0,134,0,25,0,2,113,48,49,37,20,14,2,7,14,3,
35,34,46,2,53,52,62,2,55,30,3,51,50,62,2,53,
52,46,4,53,52,62,2,55,62,3,51,50,30,2,21,20,
14,2,7,46,3,35,34,14,2,21,20,30,4,1,134,32,
54,72,40,27,65,71,70,31,31,66,55,36,29,40,43,15,
16,40,43,42,19,44,74,54,31,16,24,28,24,16,25,45,
64,40,27,64,63,57,19,31,66,55,36,29,40,43,15,24,
49,45,39,13,26,49,37,23,16,24,28,24,16,66,97,145,
111,81,32,21,37,27,15,21,28,29,8,9,31,34,30,7,
14,23,16,9,39,79,118,79,79,189,201,204,188,162,58,92,
132,98,73,32,22,34,24,12,24,31,32,9,8,32,34,30,
7,21,31,21,11,37,72,105,67,77,187,201,205,189,163,0,
0,1,255,80,254,12,3,29,6,14,0,81,0,253,187,0,
16,0,4,0,58,0,4,43,184,0,16,16,184,0,20,208,
184,0,20,47,184,0,58,16,184,0,48,208,184,0,48,47,
184,0,58,16,184,0,68,208,0,184,0,77,47,184,0,0,
69,88,184,0,19,47,27,185,0,19,0,5,62,89,184,0,
0,69,88,184,0,48,47,27,185,0,48,0,5,62,89,184,
0,0,69,88,184,0,30,47,27,185,0,30,0,7,62,89,
184,0,77,16,185,0,10,0,2,252,184,0,19,16,185,0,
16,0,2,252,184,0,30,16,185,0,43,0,2,252,65,33,
0,7,0,43,0,23,0,43,0,39,0,43,0,55,0,43,
0,71,0,43,0,87,0,43,0,103,0,43,0,119,0,43,
0,135,0,43,0,151,0,43,0,167,0,43,0,183,0,43,
0,199,0,43,0,215,0,43,0,231,0,43,0,247,0,43,
0,16,93,65,15,0,7,0,43,0,23,0,43,0,39,0,
43,0,55,0,43,0,71,0,43,0,87,0,43,0,103,0,
43,0,7,113,65,5,0,118,0,43,0,134,0,43,0,2,
113,184,0,16,16,184,0,58,208,48,49,1,20,14,2,7,
46,3,35,34,14,2,21,17,51,23,7,35,14,3,7,14,
3,35,34,46,2,53,52,62,2,55,30,1,51,50,62,2,
55,35,39,62,3,55,30,1,51,17,52,46,2,39,53,62,
1,55,53,52,62,2,55,62,1,51,50,30,2,3,29,29,
40,43,15,21,41,39,34,14,32,45,30,14,134,21,78,81,
6,33,49,63,35,27,61,59,54,19,31,59,47,29,29,40,
43,15,32,68,38,27,55,45,30,3,200,29,9,27,27,26,
9,30,70,32,6,27,57,50,36,69,35,17,36,56,39,51,
111,39,43,73,53,29,5,143,8,31,33,29,7,34,44,25,
9,32,75,123,91,252,12,28,66,87,125,93,67,28,21,37,
27,15,15,22,24,8,9,31,34,30,7,28,17,33,83,141,
108,29,14,31,29,21,5,22,13,2,89,39,51,33,18,4,
40,10,24,16,121,85,123,93,72,34,45,47,33,43,42,0,
0,1,255,41,254,12,3,19,6,14,0,62,1,41,187,0,
15,0,4,0,41,0,4,43,184,0,15,16,65,19,0,6,
0,15,0,22,0,15,0,38,0,15,0,54,0,15,0,70,
0,15,0,86,0,15,0,102,0,15,0,118,0,15,0,134,
0,15,0,9,93,65,5,0,149,0,15,0,165,0,15,0,
2,93,186,0,46,0,41,0,15,17,18,57,184,0,46,47,
65,5,0,154,0,46,0,170,0,46,0,2,93,65,19,0,
9,0,46,0,25,0,46,0,41,0,46,0,57,0,46,0,
73,0,46,0,89,0,46,0,105,0,46,0,121,0,46,0,
137,0,46,0,9,93,185,0,10,0,4,252,0,184,0,5,
47,184,0,0,69,88,184,0,36,47,27,185,0,36,0,7,
62,89,185,0,20,0,2,252,65,33,0,7,0,20,0,23,
0,20,0,39,0,20,0,55,0,20,0,71,0,20,0,87,
0,20,0,103,0,20,0,119,0,20,0,135,0,20,0,151,
0,20,0,167,0,20,0,183,0,20,0,199,0,20,0,215,
0,20,0,231,0,20,0,247,0,20,0,16,93,65,15,0,
7,0,20,0,23,0,20,0,39,0,20,0,55,0,20,0,
71,0,20,0,87,0,20,0,103,0,20,0,7,113,65,5,
0,118,0,20,0,134,0,20,0,2,113,184,0,5,16,185,
0,49,0,2,252,48,49,3,38,62,2,51,50,30,2,21,
20,10,2,21,20,30,2,51,50,62,2,39,38,62,2,31,
1,22,14,2,35,34,46,2,53,52,26,2,53,52,38,35,
34,14,2,23,22,14,4,47,1,212,3,55,98,132,73,61,
88,57,27,14,17,14,24,45,63,40,29,47,28,5,13,3,
40,56,58,15,19,3,55,96,128,69,68,101,66,33,14,17,
14,75,72,29,47,28,5,13,2,17,30,39,38,34,10,19,
5,5,38,92,81,54,58,96,124,65,152,254,197,254,206,254,
224,125,120,163,100,43,28,42,50,21,4,25,24,17,2,39,
38,92,81,54,64,119,170,107,148,1,53,1,48,1,37,132,
153,156,28,42,50,21,3,13,16,17,13,8,2,39,0,2,
254,248,254,2,2,202,6,14,0,17,0,92,1,14,187,0,
18,0,4,0,49,0,4,43,184,0,18,16,65,5,0,154,
0,49,0,170,0,49,0,2,93,65,19,0,9,0,49,0,
25,0,49,0,41,0,49,0,57,0,49,0,73,0,49,0,
89,0,49,0,105,0,49,0,121,0,49,0,137,0,49,0,
9,93,186,0,86,0,49,0,18,17,18,57,184,0,86,47,
185,0,56,0,4,252,186,0,46,0,86,0,56,17,18,57,
184,0,18,16,184,0,94,220,0,184,0,24,47,184,0,33,
47,184,0,66,47,187,0,43,0,2,0,8,0,4,43,184,
0,43,16,184,0,33,16,185,0,0,0,2,252,65,33,0,
7,0,0,0,23,0,0,0,39,0,0,0,55,0,0,0,
71,0,0,0,87,0,0,0,103,0,0,0,119,0,0,0,
135,0,0,0,151,0,0,0,167,0,0,0,183,0,0,0,
199,0,0,0,215,0,0,0,231,0,0,0,247,0,0,0,
16,93,65,15,0,7,0,0,0,23,0,0,0,39,0,0,
0,55,0,0,0,71,0,0,0,87,0,0,0,103,0,0,
0,7,113,65,5,0,118,0,0,0,134,0,0,0,2,113,
186,0,46,0,8,0,43,17,18,57,48,49,19,50,54,55,
46,3,35,34,14,2,21,20,30,2,1,20,6,7,22,23,
7,46,1,39,14,1,7,14,1,35,34,46,2,53,52,62,
2,51,50,22,23,62,1,53,52,46,4,53,52,62,2,55,
62,3,51,50,30,2,21,20,14,2,7,46,3,35,34,14,
2,21,20,30,4,27,54,87,27,32,52,45,41,19,33,52,
36,19,24,43,59,1,142,33,31,95,116,46,63,103,42,8,
14,8,69,143,73,53,86,60,33,36,69,97,62,53,107,60,
5,5,16,24,28,24,16,25,45,64,40,27,64,63,57,19,
31,66,55,36,29,40,43,15,24,49,45,39,13,26,49,37,
23,16,24,28,24,16,254,137,64,63,20,24,13,4,16,26,
32,15,21,36,27,15,1,185,86,157,64,80,143,46,66,95,
35,9,18,8,72,79,33,54,70,37,33,72,60,39,28,35,
26,57,32,79,189,201,204,188,162,58,92,132,98,73,32,22,
34,24,12,24,31,32,9,8,32,34,30,7,21,31,21,11,
37,72,105,67,77,187,201,205,189,163,0,1,0,20,254,162,
2,164,3,192,0,40,0,227,187,0,16,0,4,0,18,0,
4,43,184,0,16,16,184,0,10,208,184,0,18,16,184,0,
30,208,0,184,0,17,47,184,0,0,69,88,184,0,5,47,
27,185,0,5,0,9,62,89,184,0,0,69,88,184,0,14,
47,27,185,0,14,0,5,62,89,184,0,0,69,88,184,0,
19,47,27,185,0,19,0,5,62,89,184,0,14,16,185,0,
11,0,2,252,184,0,29,208,184,0,30,208,184,0,5,16,
185,0,36,0,2,252,65,5,0,121,0,36,0,137,0,36,
0,2,113,65,33,0,8,0,36,0,24,0,36,0,40,0,
36,0,56,0,36,0,72,0,36,0,88,0,36,0,104,0,
36,0,120,0,36,0,136,0,36,0,152,0,36,0,168,0,
36,0,184,0,36,0,200,0,36,0,216,0,36,0,232,0,
36,0,248,0,36,0,16,93,65,15,0,8,0,36,0,24,
0,36,0,40,0,36,0,56,0,36,0,72,0,36,0,88,
0,36,0,104,0,36,0,7,113,48,49,19,62,3,51,50,
30,2,21,17,51,23,7,35,21,7,39,17,33,39,62,3,
55,30,1,59,1,17,52,46,2,35,34,6,7,39,20,49,
96,87,74,26,34,63,48,29,129,21,78,72,119,31,254,185,
29,9,27,28,27,10,24,98,81,52,11,26,41,30,35,106,
78,29,3,45,36,55,37,19,26,59,96,70,253,153,28,66,
246,104,25,1,69,29,14,31,29,21,5,12,23,2,17,60,
79,47,19,26,40,51,0,1,0,20,254,12,2,219,5,0,
0,45,0,244,187,0,31,0,4,0,10,0,4,43,184,0,
31,16,184,0,10,16,184,0,15,208,184,0,31,16,184,0,
18,208,0,184,0,0,69,88,184,0,17,47,27,185,0,17,
0,11,62,89,184,0,0,69,88,184,0,14,47,27,185,0,
14,0,9,62,89,184,0,0,69,88,184,0,19,47,27,185,
0,19,0,9,62,89,184,0,0,69,88,184,0,5,47,27,
185,0,5,0,7,62,89,184,0,14,16,185,0,11,0,2,
252,184,0,29,208,184,0,30,208,184,0,5,16,185,0,34,
0,2,252,65,33,0,7,0,34,0,23,0,34,0,39,0,
34,0,55,0,34,0,71,0,34,0,87,0,34,0,103,0,
34,0,119,0,34,0,135,0,34,0,151,0,34,0,167,0,
34,0,183,0,34,0,199,0,34,0,215,0,34,0,231,0,
34,0,247,0,34,0,16,93,65,15,0,7,0,34,0,23,
0,34,0,39,0,34,0,55,0,34,0,71,0,34,0,87,
0,34,0,103,0,34,0,7,113,65,5,0,118,0,34,0,
134,0,34,0,2,113,48,49,5,22,14,2,35,34,46,2,
53,17,35,39,55,51,53,55,23,17,33,23,14,3,7,46,
1,43,1,17,20,22,51,50,62,2,39,38,62,2,31,1,
2,216,3,55,98,132,73,61,78,46,18,129,21,78,72,119,
31,1,71,29,9,27,28,27,10,24,98,81,52,55,72,29,
47,28,5,13,3,40,56,58,15,19,235,38,92,81,54,45,
75,99,54,4,39,28,66,246,104,25,254,187,29,14,31,29,
22,4,12,23,252,22,115,124,28,42,50,21,4,25,24,17,
2,39,0,2,0,41,255,226,4,45,3,192,0,12,0,76,
1,104,184,0,77,47,184,0,78,47,184,0,15,220,185,0,
5,0,4,252,184,0,77,16,184,0,40,208,184,0,40,47,
185,0,8,0,4,252,184,0,5,16,184,0,30,208,184,0,
40,16,184,0,47,208,184,0,8,16,184,0,60,208,184,0,
5,16,184,0,62,208,184,0,15,16,184,0,73,208,0,184,
0,0,69,88,184,0,59,47,27,185,0,59,0,9,62,89,
184,0,0,69,88,184,0,72,47,27,185,0,72,0,9,62,
89,184,0,0,69,88,184,0,27,47,27,185,0,27,0,5,
62,89,184,0,0,69,88,184,0,35,47,27,185,0,35,0,
5,62,89,187,0,62,0,2,0,6,0,4,43,184,0,62,
16,184,0,35,16,185,0,0,0,2,252,65,33,0,7,0,
0,0,23,0,0,0,39,0,0,0,55,0,0,0,71,0,
0,0,87,0,0,0,103,0,0,0,119,0,0,0,135,0,
0,0,151,0,0,0,167,0,0,0,183,0,0,0,199,0,
0,0,215,0,0,0,231,0,0,0,247,0,0,0,16,93,
65,15,0,7,0,0,0,23,0,0,0,39,0,0,0,55,
0,0,0,71,0,0,0,87,0,0,0,103,0,0,0,7,
113,65,5,0,118,0,0,0,134,0,0,0,2,113,184,0,
7,220,184,0,13,208,184,0,6,16,184,0,14,208,186,0,
30,0,0,0,7,17,18,57,184,0,7,16,184,0,41,208,
184,0,6,16,184,0,42,208,184,0,62,16,184,0,46,208,
184,0,53,220,184,0,68,208,184,0,62,16,184,0,74,208,
184,0,46,16,184,0,75,208,48,49,37,50,62,2,55,53,
33,21,20,30,2,1,35,21,20,22,23,22,54,55,23,14,
3,35,34,38,39,14,3,35,34,46,2,61,1,35,39,62,
1,55,51,53,52,46,2,39,53,62,3,55,23,17,33,53,
52,46,2,39,53,62,1,55,23,17,51,23,1,217,32,67,
71,78,44,254,67,21,39,57,2,72,106,9,14,12,58,51,
10,37,68,58,44,12,35,44,6,62,103,87,73,32,47,86,
66,39,106,23,5,10,8,106,6,25,52,46,36,63,59,60,
33,28,1,189,9,30,55,46,72,132,56,30,106,22,90,19,
41,65,47,153,81,70,94,56,24,1,69,161,62,78,10,8,
9,22,45,24,41,30,17,93,103,62,77,42,15,26,69,120,
94,136,22,16,36,16,206,48,53,27,10,5,40,4,12,16,
21,13,39,254,96,206,45,54,30,12,2,40,9,38,19,39,
254,96,25,0,0,1,0,59,255,226,3,141,3,162,0,58,
1,67,184,0,59,47,184,0,60,47,184,0,11,220,184,0,
59,16,184,0,23,208,184,0,23,47,185,0,40,0,4,252,
65,19,0,6,0,40,0,22,0,40,0,38,0,40,0,54,
0,40,0,70,0,40,0,86,0,40,0,102,0,40,0,118,
0,40,0,134,0,40,0,9,93,65,5,0,149,0,40,0,
165,0,40,0,2,93,184,0,11,16,185,0,50,0,4,252,
65,5,0,154,0,50,0,170,0,50,0,2,93,65,19,0,
9,0,50,0,25,0,50,0,41,0,50,0,57,0,50,0,
73,0,50,0,89,0,50,0,105,0,50,0,121,0,50,0,
137,0,50,0,9,93,0,184,0,0,69,88,184,0,33,47,
27,185,0,33,0,9,62,89,184,0,0,69,88,184,0,56,
47,27,185,0,56,0,9,62,89,184,0,0,69,88,184,0,
18,47,27,185,0,18,0,5,62,89,185,0,45,0,2,252,
65,33,0,7,0,45,0,23,0,45,0,39,0,45,0,55,
0,45,0,71,0,45,0,87,0,45,0,103,0,45,0,119,
0,45,0,135,0,45,0,151,0,45,0,167,0,45,0,183,
0,45,0,199,0,45,0,215,0,45,0,231,0,45,0,247,
0,45,0,16,93,65,15,0,7,0,45,0,23,0,45,0,
39,0,45,0,55,0,45,0,71,0,45,0,87,0,45,0,
103,0,45,0,7,113,65,5,0,118,0,45,0,134,0,45,
0,2,113,48,49,1,34,14,3,23,30,3,21,20,14,4,
35,34,46,2,53,52,54,55,54,46,3,35,53,33,23,14,
3,21,20,30,2,51,50,62,2,53,52,46,2,39,55,33,
21,3,141,2,43,64,56,30,13,44,60,36,16,24,47,70,
93,116,68,103,148,95,45,74,92,14,29,56,65,43,2,1,
91,18,48,73,50,26,46,79,104,58,58,88,59,29,28,52,
75,48,20,1,88,3,119,11,20,24,27,12,39,84,90,95,
51,47,105,103,95,71,43,71,118,156,84,112,199,83,13,27,
23,20,11,43,92,36,82,98,119,75,67,125,97,59,57,88,
107,51,75,140,119,92,29,92,43,0,0,1,0,41,255,226,
3,147,3,192,0,51,1,13,184,0,52,47,184,0,53,47,
184,0,0,220,184,0,52,16,184,0,12,208,184,0,12,47,
185,0,26,0,4,252,184,0,0,16,185,0,36,0,4,252,
65,5,0,154,0,36,0,170,0,36,0,2,93,65,19,0,
9,0,36,0,25,0,36,0,41,0,36,0,57,0,36,0,
73,0,36,0,89,0,36,0,105,0,36,0,121,0,36,0,
137,0,36,0,9,93,0,184,0,0,69,88,184,0,24,47,
27,185,0,24,0,9,62,89,184,0,0,69,88,184,0,47,
47,27,185,0,47,0,9,62,89,184,0,0,69,88,184,0,
7,47,27,185,0,7,0,5,62,89,185,0,31,0,2,252,
65,33,0,7,0,31,0,23,0,31,0,39,0,31,0,55,
0,31,0,71,0,31,0,87,0,31,0,103,0,31,0,119,
0,31,0,135,0,31,0,151,0,31,0,167,0,31,0,183,
0,31,0,199,0,31,0,215,0,31,0,231,0,31,0,247,
0,31,0,16,93,65,15,0,7,0,31,0,23,0,31,0,
39,0,31,0,55,0,31,0,71,0,31,0,87,0,31,0,
103,0,31,0,7,113,65,5,0,118,0,31,0,134,0,31,
0,2,113,48,49,1,20,14,4,35,34,46,2,53,17,52,
46,2,39,53,62,3,55,23,17,20,30,2,51,50,62,2,
53,52,46,2,47,1,62,3,55,30,3,3,147,35,63,87,
102,113,58,57,104,79,47,6,25,52,46,36,62,60,59,33,
28,30,51,67,37,73,100,62,27,29,62,96,67,16,16,52,
56,53,17,43,81,63,38,1,248,70,133,119,99,73,40,29,
73,123,94,1,166,48,53,27,10,5,40,4,12,16,21,13,
39,253,189,69,97,60,28,65,104,129,65,77,144,113,69,2,
41,7,18,17,16,5,14,72,114,156,0,1,0,20,0,0,
3,221,3,192,0,33,0,64,0,184,0,0,69,88,184,0,
11,47,27,185,0,11,0,9,62,89,184,0,0,69,88,184,
0,16,47,27,185,0,16,0,5,62,89,184,0,0,69,88,
184,0,31,47,27,185,0,31,0,5,62,89,186,0,24,0,
16,0,11,17,18,57,48,49,55,62,3,55,1,62,3,55,
1,30,1,23,21,33,53,62,3,39,11,1,6,30,2,23,
21,33,53,20,30,38,24,13,5,1,27,9,34,40,39,13,
1,74,9,52,50,254,126,39,49,27,4,6,246,231,5,3,
24,45,37,254,189,43,7,12,15,19,15,2,248,22,31,21,
12,3,252,175,28,29,11,43,43,5,10,15,22,16,2,129,
253,127,15,21,15,11,6,43,43,0,0,1,0,20,0,0,
5,145,3,192,0,40,0,122,0,184,0,0,69,88,184,0,
11,47,27,185,0,11,0,9,62,89,184,0,0,69,88,184,
0,18,47,27,185,0,18,0,9,62,89,184,0,0,69,88,
184,0,22,47,27,185,0,22,0,5,62,89,184,0,0,69,
88,184,0,31,47,27,185,0,31,0,5,62,89,184,0,0,
69,88,184,0,38,47,27,185,0,38,0,5,62,89,186,0,
12,0,22,0,11,17,18,57,184,0,31,16,185,0,24,0,
1,252,186,0,33,0,22,0,11,17,18,57,184,0,37,208,
48,49,55,62,3,55,19,62,3,55,27,1,62,3,55,1,
22,23,21,33,53,62,3,39,11,1,35,1,3,6,22,23,
21,33,53,20,31,36,21,9,3,221,6,35,42,41,13,237,
206,7,34,40,39,13,1,6,9,100,254,126,49,54,24,1,
3,188,246,69,254,252,173,6,54,69,254,187,43,7,13,13,
17,12,2,254,22,31,21,12,3,253,89,2,78,23,31,21,
11,3,252,169,39,23,43,43,5,13,17,18,9,2,123,253,
28,2,228,253,133,23,28,11,43,43,0,1,0,20,0,0,
4,66,6,14,0,47,0,51,0,184,0,0,69,88,184,0,
33,47,27,185,0,33,0,5,62,89,184,0,0,69,88,184,
0,46,47,27,185,0,46,0,5,62,89,187,0,9,0,2,
0,22,0,4,43,184,0,9,16,48,49,55,62,3,55,1,
62,1,51,50,30,2,21,20,14,2,7,46,1,35,34,14,
2,15,1,1,30,1,23,21,33,53,62,3,39,11,1,6,
22,23,21,33,20,30,38,24,13,5,1,126,76,202,126,38,
64,46,26,24,36,41,16,23,58,30,39,71,65,58,26,53,
1,72,9,52,50,254,126,39,49,27,4,6,246,231,11,52,
74,254,178,43,7,12,15,19,15,4,11,206,198,10,15,19,
9,6,36,43,40,10,14,17,47,81,112,64,136,252,182,28,
29,11,43,43,5,10,15,22,16,2,125,253,131,31,26,11,
43,0,0,1,0,20,0,0,3,212,3,170,0,43,0,77,
187,0,39,0,4,0,4,0,4,43,184,0,39,16,186,0,
27,0,4,0,39,17,18,57,0,184,0,0,69,88,184,0,
19,47,27,185,0,19,0,9,62,89,184,0,0,69,88,184,
0,32,47,27,185,0,32,0,9,62,89,184,0,19,16,184,
0,16,220,184,0,33,208,184,0,33,47,48,49,33,53,62,
1,53,17,46,3,39,46,3,35,39,62,1,51,50,22,23,
30,3,23,19,54,38,39,53,33,21,14,1,7,1,17,20,
22,23,21,1,37,77,63,31,78,81,76,29,8,15,24,38,
29,4,48,100,33,18,34,13,31,71,73,69,29,207,12,55,
64,1,85,56,52,11,254,234,64,77,43,20,30,11,1,32,
60,127,120,103,36,8,15,11,7,43,6,10,15,14,36,94,
106,112,54,1,75,20,22,7,43,43,9,21,19,254,68,254,
222,10,32,19,43,0,0,1,0,76,254,12,4,127,3,178,
0,56,1,16,187,0,40,0,3,0,8,0,4,43,184,0,
40,16,184,0,58,220,0,184,0,0,69,88,184,0,20,47,
27,185,0,20,0,9,62,89,184,0,0,69,88,184,0,24,
47,27,185,0,24,0,9,62,89,184,0,0,69,88,184,0,
26,47,27,185,0,26,0,9,62,89,184,0,0,69,88,184,
0,5,47,27,185,0,5,0,7,62,89,184,0,0,69,88,
184,0,9,47,27,185,0,9,0,5,62,89,184,0,0,69,
88,184,0,39,47,27,185,0,39,0,5,62,89,184,0,26,
16,185,0,12,0,2,252,184,0,13,208,184,0,9,16,185,
0,29,0,2,252,184,0,5,16,185,0,45,0,2,252,65,
33,0,7,0,45,0,23,0,45,0,39,0,45,0,55,0,
45,0,71,0,45,0,87,0,45,0,103,0,45,0,119,0,
45,0,135,0,45,0,151,0,45,0,167,0,45,0,183,0,
45,0,199,0,45,0,215,0,45,0,231,0,45,0,247,0,
45,0,16,93,65,15,0,7,0,45,0,23,0,45,0,39,
0,45,0,55,0,45,0,71,0,45,0,87,0,45,0,103,
0,45,0,7,113,65,5,0,118,0,45,0,134,0,45,0,
2,113,48,49,5,22,14,2,35,34,38,61,1,33,39,1,
33,34,14,2,7,39,55,30,2,51,50,51,33,23,1,33,
50,54,55,23,14,3,7,21,20,30,2,51,50,62,1,38,
39,38,62,2,31,1,4,124,3,32,65,93,58,84,99,253,
150,26,2,43,254,166,16,33,31,27,10,49,18,22,36,39,
23,24,32,1,236,22,253,211,1,166,25,42,23,47,2,6,
6,4,1,12,24,36,25,29,36,14,8,15,3,39,56,59,
15,19,235,38,92,81,54,122,131,247,45,3,27,12,33,59,
46,12,244,6,7,3,43,252,227,77,91,10,26,51,57,66,
40,204,61,81,48,19,31,43,49,18,4,24,25,17,2,39,
0,2,0,76,255,42,3,145,3,178,0,10,0,52,0,146,
0,184,0,25,47,184,0,0,69,88,184,0,40,47,27,185,
0,40,0,9,62,89,184,0,0,69,88,184,0,44,47,27,
185,0,44,0,9,62,89,184,0,0,69,88,184,0,46,47,
27,185,0,46,0,9,62,89,184,0,0,69,88,184,0,21,
47,27,185,0,21,0,5,62,89,184,0,0,69,88,184,0,
29,47,27,185,0,29,0,5,62,89,187,0,11,0,2,0,
0,0,4,43,184,0,11,16,184,0,29,16,185,0,2,0,
2,252,184,0,3,208,184,0,46,16,185,0,32,0,2,252,
184,0,33,208,184,0,3,16,184,0,49,208,184,0,50,208,
48,49,1,34,7,51,50,62,2,53,52,38,39,50,30,2,
21,20,14,2,7,35,14,1,7,39,62,1,55,33,39,1,
33,34,14,2,7,39,55,30,2,51,50,51,33,23,1,51,
62,1,2,207,112,69,94,52,68,39,15,49,4,33,58,43,
26,31,63,97,65,148,12,20,8,65,4,15,11,254,180,26,
2,43,254,166,16,33,31,27,10,49,18,22,36,39,23,24,
32,1,236,22,253,211,189,50,156,1,9,175,14,25,33,18,
37,48,118,18,38,58,40,42,82,64,40,1,45,107,62,8,
58,102,46,45,3,27,12,33,59,46,12,244,6,7,3,43,
252,227,149,144,0,1,0,38,254,12,3,82,3,178,0,59,
1,42,187,0,0,0,4,0,23,0,4,43,65,5,0,154,
0,23,0,170,0,23,0,2,93,65,19,0,9,0,23,0,
25,0,23,0,41,0,23,0,57,0,23,0,73,0,23,0,
89,0,23,0,105,0,23,0,121,0,23,0,137,0,23,0,
9,93,0,184,0,0,69,88,184,0,43,47,27,185,0,43,
0,9,62,89,184,0,0,69,88,184,0,47,47,27,185,0,
47,0,9,62,89,184,0,0,69,88,184,0,49,47,27,185,
0,49,0,9,62,89,184,0,0,69,88,184,0,5,47,27,
185,0,5,0,7,62,89,187,0,55,0,2,0,28,0,4,
43,184,0,55,16,184,0,5,16,185,0,18,0,2,252,65,
33,0,7,0,18,0,23,0,18,0,39,0,18,0,55,0,
18,0,71,0,18,0,87,0,18,0,103,0,18,0,119,0,
18,0,135,0,18,0,151,0,18,0,167,0,18,0,183,0,
18,0,199,0,18,0,215,0,18,0,231,0,18,0,247,0,
18,0,16,93,65,15,0,7,0,18,0,23,0,18,0,39,
0,18,0,55,0,18,0,71,0,18,0,87,0,18,0,103,
0,18,0,7,113,65,5,0,118,0,18,0,134,0,18,0,
2,113,184,0,49,16,185,0,35,0,2,252,184,0,36,208,
186,0,52,0,28,0,55,17,18,57,48,49,5,20,14,2,
35,34,46,2,53,52,62,2,55,30,1,51,50,62,2,53,
52,46,2,7,34,6,7,46,1,39,1,33,34,14,2,7,
39,55,30,2,51,50,51,33,23,1,62,1,51,30,3,3,
82,83,134,167,84,71,126,93,54,28,42,48,21,58,119,67,
60,102,75,42,44,85,123,79,41,79,40,7,23,5,1,172,
254,172,16,33,31,27,10,49,19,21,37,39,23,24,32,1,
233,25,254,115,17,32,16,80,138,101,58,26,106,174,125,69,
38,53,55,17,6,29,32,27,3,75,80,42,81,119,76,67,
128,99,59,2,14,14,5,31,8,2,38,12,33,59,46,12,
244,6,7,3,43,253,252,2,2,2,54,102,148,0,0,2,
0,36,254,2,3,101,3,178,0,17,0,85,1,173,184,0,
86,47,184,0,87,47,184,0,86,16,184,0,36,208,184,0,
36,47,185,0,13,0,4,252,65,19,0,6,0,13,0,22,
0,13,0,38,0,13,0,54,0,13,0,70,0,13,0,86,
0,13,0,102,0,13,0,118,0,13,0,134,0,13,0,9,
93,65,5,0,149,0,13,0,165,0,13,0,2,93,184,0,
87,16,184,0,18,220,186,0,46,0,36,0,18,17,18,57,
185,0,49,0,4,252,65,5,0,154,0,49,0,170,0,49,
0,2,93,65,19,0,9,0,49,0,25,0,49,0,41,0,
49,0,57,0,49,0,73,0,49,0,89,0,49,0,105,0,
49,0,121,0,49,0,137,0,49,0,9,93,184,0,13,16,
184,0,60,208,184,0,60,47,186,0,78,0,36,0,18,17,
18,57,0,184,0,25,47,184,0,31,47,184,0,0,69,88,
184,0,69,47,27,185,0,69,0,9,62,89,184,0,0,69,
88,184,0,73,47,27,185,0,73,0,9,62,89,184,0,0,
69,88,184,0,75,47,27,185,0,75,0,9,62,89,187,0,
41,0,2,0,8,0,4,43,184,0,41,16,187,0,81,0,
2,0,54,0,4,43,184,0,81,16,184,0,31,16,185,0,
0,0,2,252,65,33,0,7,0,0,0,23,0,0,0,39,
0,0,0,55,0,0,0,71,0,0,0,87,0,0,0,103,
0,0,0,119,0,0,0,135,0,0,0,151,0,0,0,167,
0,0,0,183,0,0,0,199,0,0,0,215,0,0,0,231,
0,0,0,247,0,0,0,16,93,65,15,0,7,0,0,0,
23,0,0,0,39,0,0,0,55,0,0,0,71,0,0,0,
87,0,0,0,103,0,0,0,7,113,65,5,0,118,0,0,
0,134,0,0,0,2,113,186,0,46,0,25,0,69,17,18,
57,184,0,75,16,185,0,61,0,2,252,184,0,62,208,186,
0,78,0,54,0,81,17,18,57,48,49,1,50,54,55,46,
3,35,34,14,2,21,20,30,2,1,20,6,7,30,1,23,
7,46,1,39,14,1,35,34,46,2,53,52,62,2,51,50,
30,2,23,62,1,53,52,46,2,7,34,6,7,46,1,39,
1,33,34,14,2,7,39,55,30,2,51,50,51,33,23,1,
62,1,51,30,3,1,172,71,113,36,52,87,81,78,43,28,
51,38,23,37,69,96,1,225,47,40,25,52,29,58,27,50,
23,66,169,87,74,128,96,55,52,89,119,67,48,83,78,75,
40,6,7,44,85,123,79,41,79,40,7,23,5,1,172,254,
172,16,33,31,27,10,49,19,21,37,39,23,24,32,1,233,
25,254,115,17,32,16,80,138,101,58,254,117,59,57,64,76,
40,13,15,30,42,27,36,69,56,34,1,113,79,137,57,39,
90,51,31,43,74,32,66,73,35,67,99,63,46,91,72,45,
22,48,77,56,25,54,29,67,128,99,59,2,14,14,5,31,
8,2,38,12,33,59,46,12,244,6,7,3,43,253,252,2,
2,2,54,102,148,0,0,1,0,60,0,0,3,82,6,14,
0,54,0,212,187,0,21,0,4,0,32,0,4,43,184,0,
21,16,187,0,50,0,4,0,3,0,4,43,184,0,50,16,
187,0,42,0,4,0,11,0,4,43,184,0,42,16,65,5,
0,154,0,11,0,170,0,11,0,2,93,65,19,0,9,0,
11,0,25,0,11,0,41,0,11,0,57,0,11,0,73,0,
11,0,89,0,11,0,105,0,11,0,121,0,11,0,137,0,
11,0,9,93,65,19,0,6,0,21,0,22,0,21,0,38,
0,21,0,54,0,21,0,70,0,21,0,86,0,21,0,102,
0,21,0,118,0,21,0,134,0,21,0,9,93,65,5,0,
149,0,21,0,165,0,21,0,2,93,184,0,32,16,184,0,
30,208,184,0,11,16,184,0,53,208,184,0,53,47,184,0,
42,16,184,0,56,220,0,184,0,0,69,88,184,0,0,47,
27,185,0,0,0,5,62,89,187,0,37,0,2,0,16,0,
4,43,184,0,37,16,48,49,51,53,54,53,17,52,62,4,
53,52,46,2,35,34,14,2,21,20,22,23,14,1,7,39,
38,53,52,53,52,62,2,51,50,30,2,21,20,14,4,21,
17,20,22,23,21,200,170,49,73,86,73,49,41,72,97,56,
40,75,59,36,7,5,32,70,45,27,2,76,126,163,87,77,
125,88,48,49,73,86,73,49,88,82,43,30,31,1,136,77,
128,112,100,98,101,58,61,105,75,43,39,62,78,39,14,30,
14,17,16,5,30,8,8,9,8,70,127,94,56,52,91,122,
70,74,118,100,92,97,110,69,254,61,15,32,14,43,0,1,
0,40,0,0,3,62,6,14,0,48,0,204,187,0,37,0,
4,0,12,0,4,43,184,0,37,16,187,0,45,0,4,0,
4,0,4,43,184,0,45,16,187,0,22,0,4,0,27,0,
4,43,184,0,22,16,65,19,0,6,0,37,0,22,0,37,
0,38,0,37,0,54,0,37,0,70,0,37,0,86,0,37,
0,102,0,37,0,118,0,37,0,134,0,37,0,9,93,65,
5,0,149,0,37,0,165,0,37,0,2,93,184,0,37,16,
184,0,0,208,184,0,0,47,65,5,0,154,0,27,0,170,
0,27,0,2,93,65,19,0,9,0,27,0,25,0,27,0,
41,0,27,0,57,0,27,0,73,0,27,0,89,0,27,0,
105,0,27,0,121,0,27,0,137,0,27,0,9,93,184,0,
22,16,184,0,50,220,0,184,0,0,69,88,184,0,0,47,
27,185,0,0,0,5,62,89,187,0,17,0,2,0,32,0,
4,43,184,0,17,16,48,49,51,53,62,1,53,17,52,46,
4,53,52,62,2,51,50,30,2,23,14,3,39,46,3,35,
34,14,2,21,20,30,4,21,17,20,23,21,200,82,88,49,
73,86,73,49,73,118,150,77,82,132,95,56,7,3,31,45,
54,24,2,38,69,98,61,45,78,58,34,49,73,86,73,49,
170,43,14,32,15,1,103,69,117,108,103,108,118,69,93,146,
102,54,46,84,118,72,8,23,19,14,1,64,105,76,42,40,
72,101,61,58,103,100,103,113,130,77,254,120,31,30,43,0,
0,1,0,60,255,226,3,82,5,240,0,48,1,59,187,0,
27,0,4,0,22,0,4,43,184,0,27,16,187,0,5,0,
4,0,44,0,4,43,184,0,5,16,187,0,12,0,4,0,
37,0,4,43,184,0,12,16,65,5,0,154,0,37,0,170,
0,37,0,2,93,65,19,0,9,0,37,0,25,0,37,0,
41,0,37,0,57,0,37,0,73,0,37,0,89,0,37,0,
105,0,37,0,121,0,37,0,137,0,37,0,9,93,184,0,
37,16,184,0,0,208,184,0,0,47,65,19,0,6,0,27,
0,22,0,27,0,38,0,27,0,54,0,27,0,70,0,27,
0,86,0,27,0,102,0,27,0,118,0,27,0,134,0,27,
0,9,93,65,5,0,149,0,27,0,165,0,27,0,2,93,
184,0,12,16,184,0,50,220,0,184,0,0,47,184,0,0,
69,88,184,0,17,47,27,185,0,17,0,5,62,89,185,0,
32,0,2,252,65,33,0,7,0,32,0,23,0,32,0,39,
0,32,0,55,0,32,0,71,0,32,0,87,0,32,0,103,
0,32,0,119,0,32,0,135,0,32,0,151,0,32,0,167,
0,32,0,183,0,32,0,199,0,32,0,215,0,32,0,231,
0,32,0,247,0,32,0,16,93,65,15,0,7,0,32,0,
23,0,32,0,39,0,32,0,55,0,32,0,71,0,32,0,
87,0,32,0,103,0,32,0,7,113,65,5,0,118,0,32,
0,134,0,32,0,2,113,48,49,1,21,14,1,21,17,20,
30,4,21,20,14,2,35,34,46,2,39,62,3,23,30,3,
51,50,62,2,53,52,46,4,53,17,52,39,53,2,178,82,
88,49,73,86,73,49,73,118,150,77,83,131,95,56,7,3,
31,45,54,24,2,38,69,98,61,45,78,58,34,49,73,86,
73,49,170,5,240,43,14,32,15,254,153,69,117,108,103,108,
118,69,93,146,102,54,46,84,118,72,8,23,19,14,1,64,
105,76,42,39,72,101,62,57,104,100,103,113,130,77,1,136,
31,30,43,0,0,1,0,80,254,12,3,102,3,192,0,67,
1,99,187,0,51,0,4,0,15,0,4,43,184,0,51,16,
65,19,0,6,0,51,0,22,0,51,0,38,0,51,0,54,
0,51,0,70,0,51,0,86,0,51,0,102,0,51,0,118,
0,51,0,134,0,51,0,9,93,65,5,0,149,0,51,0,
165,0,51,0,2,93,0,184,0,0,69,88,184,0,25,47,
27,185,0,25,0,9,62,89,184,0,0,69,88,184,0,5,
47,27,185,0,5,0,7,62,89,184,0,25,16,185,0,41,
0,2,252,65,5,0,121,0,41,0,137,0,41,0,2,113,
65,33,0,8,0,41,0,24,0,41,0,40,0,41,0,56,
0,41,0,72,0,41,0,88,0,41,0,104,0,41,0,120,
0,41,0,136,0,41,0,152,0,41,0,168,0,41,0,184,
0,41,0,200,0,41,0,216,0,41,0,232,0,41,0,248,
0,41,0,16,93,65,15,0,8,0,41,0,24,0,41,0,
40,0,41,0,56,0,41,0,72,0,41,0,88,0,41,0,
104,0,41,0,7,113,184,0,5,16,185,0,61,0,2,252,
65,33,0,7,0,61,0,23,0,61,0,39,0,61,0,55,
0,61,0,71,0,61,0,87,0,61,0,103,0,61,0,119,
0,61,0,135,0,61,0,151,0,61,0,167,0,61,0,183,
0,61,0,199,0,61,0,215,0,61,0,231,0,61,0,247,
0,61,0,16,93,65,15,0,7,0,61,0,23,0,61,0,
39,0,61,0,55,0,61,0,71,0,61,0,87,0,61,0,
103,0,61,0,7,113,65,5,0,118,0,61,0,134,0,61,
0,2,113,48,49,1,14,3,35,34,46,2,39,46,3,53,
52,62,2,55,62,3,51,50,30,2,23,22,14,2,7,39,
46,3,35,34,14,2,7,14,3,21,20,30,2,23,30,3,
51,50,62,2,55,23,3,102,65,102,88,83,47,55,112,99,
80,24,8,13,9,5,7,13,20,12,27,92,120,142,77,33,
69,63,53,17,2,10,18,22,9,37,8,36,57,79,51,37,
72,64,51,16,7,11,8,4,4,8,11,7,19,65,79,89,
45,28,51,61,78,56,39,254,232,77,87,45,11,43,90,138,
95,33,81,88,92,44,53,108,103,93,39,83,133,94,50,11,
21,29,18,12,44,49,45,14,10,18,42,38,25,37,73,107,
70,32,78,86,89,43,39,82,79,72,29,79,114,74,35,5,
24,52,48,41,0,3,0,70,255,226,4,154,5,10,0,14,
0,36,0,60,1,251,187,0,27,0,4,0,49,0,4,43,
184,0,27,16,187,0,0,0,4,0,8,0,4,43,184,0,
0,16,187,0,37,0,4,0,15,0,4,43,184,0,37,16,
65,5,0,154,0,8,0,170,0,8,0,2,93,65,19,0,
9,0,8,0,25,0,8,0,41,0,8,0,57,0,8,0,
73,0,8,0,89,0,8,0,105,0,8,0,121,0,8,0,
137,0,8,0,9,93,65,5,0,154,0,15,0,170,0,15,
0,2,93,65,19,0,9,0,15,0,25,0,15,0,41,0,
15,0,57,0,15,0,73,0,15,0,89,0,15,0,105,0,
15,0,121,0,15,0,137,0,15,0,9,93,65,19,0,6,
0,27,0,22,0,27,0,38,0,27,0,54,0,27,0,70,
0,27,0,86,0,27,0,102,0,27,0,118,0,27,0,134,
0,27,0,9,93,65,5,0,149,0,27,0,165,0,27,0,
2,93,184,0,62,220,0,184,0,0,69,88,184,0,56,47,
27,185,0,56,0,11,62,89,184,0,0,69,88,184,0,44,
47,27,185,0,44,0,5,62,89,186,0,13,0,5,0,3,
43,184,0,13,16,184,0,56,16,185,0,22,0,2,252,65,
5,0,121,0,22,0,137,0,22,0,2,113,65,33,0,8,
0,22,0,24,0,22,0,40,0,22,0,56,0,22,0,72,
0,22,0,88,0,22,0,104,0,22,0,120,0,22,0,136,
0,22,0,152,0,22,0,168,0,22,0,184,0,22,0,200,
0,22,0,216,0,22,0,232,0,22,0,248,0,22,0,16,
93,65,15,0,8,0,22,0,24,0,22,0,40,0,22,0,
56,0,22,0,72,0,22,0,88,0,22,0,104,0,22,0,
7,113,184,0,44,16,185,0,32,0,2,252,65,33,0,7,
0,32,0,23,0,32,0,39,0,32,0,55,0,32,0,71,
0,32,0,87,0,32,0,103,0,32,0,119,0,32,0,135,
0,32,0,151,0,32,0,167,0,32,0,183,0,32,0,199,
0,32,0,215,0,32,0,231,0,32,0,247,0,32,0,16,
93,65,15,0,7,0,32,0,23,0,32,0,39,0,32,0,
55,0,32,0,71,0,32,0,87,0,32,0,103,0,32,0,
7,113,65,5,0,118,0,32,0,134,0,32,0,2,113,48,
49,1,20,14,2,35,34,38,53,52,62,2,51,50,5,52,
46,4,35,34,14,2,21,20,30,2,51,50,62,2,55,20,
14,4,35,34,46,2,53,52,62,4,51,50,30,2,2,231,
21,37,50,29,53,47,22,38,50,29,98,1,24,25,49,70,
88,107,60,95,148,102,54,63,108,145,83,88,147,106,58,155,
42,76,107,130,148,80,126,196,133,70,41,74,106,129,151,82,
129,197,132,67,2,137,34,59,44,25,57,54,34,59,45,26,
133,69,135,121,104,75,43,76,139,198,122,112,200,151,88,69,
136,202,150,90,171,151,125,90,50,106,178,232,126,91,171,150,
126,90,50,109,180,232,0,3,0,50,255,246,3,136,3,192,
0,12,0,33,0,71,1,147,187,0,19,0,4,0,50,0,
4,43,184,0,19,16,187,0,64,0,4,0,7,0,4,43,
184,0,64,16,184,0,19,16,184,0,0,208,65,5,0,154,
0,7,0,170,0,7,0,2,93,65,19,0,9,0,7,0,
25,0,7,0,41,0,7,0,57,0,7,0,73,0,7,0,
89,0,7,0,105,0,7,0,121,0,7,0,137,0,7,0,
9,93,186,0,29,0,7,0,64,17,18,57,184,0,29,47,
65,5,0,154,0,29,0,170,0,29,0,2,93,65,19,0,
9,0,29,0,25,0,29,0,41,0,29,0,57,0,29,0,
73,0,29,0,89,0,29,0,105,0,29,0,121,0,29,0,
137,0,29,0,9,93,185,0,34,0,4,252,186,0,67,0,
50,0,34,17,18,57,184,0,73,220,0,184,0,0,69,88,
184,0,59,47,27,185,0,59,0,9,62,89,184,0,0,69,
88,184,0,39,47,27,185,0,39,0,5,62,89,184,0,0,
69,88,184,0,45,47,27,185,0,45,0,5,62,89,187,0,
2,0,2,0,13,0,4,43,184,0,2,16,184,0,59,16,
185,0,0,0,2,252,184,0,39,16,185,0,24,0,2,252,
65,33,0,7,0,24,0,23,0,24,0,39,0,24,0,55,
0,24,0,71,0,24,0,87,0,24,0,103,0,24,0,119,
0,24,0,135,0,24,0,151,0,24,0,167,0,24,0,183,
0,24,0,199,0,24,0,215,0,24,0,231,0,24,0,247,
0,24,0,16,93,65,15,0,7,0,24,0,23,0,24,0,
39,0,24,0,55,0,24,0,71,0,24,0,87,0,24,0,
103,0,24,0,7,113,65,5,0,118,0,24,0,134,0,24,
0,2,113,184,0,0,16,184,0,51,208,184,0,51,47,186,
0,67,0,13,0,2,17,18,57,48,49,1,17,51,50,62,
2,53,52,46,2,35,19,34,14,2,7,17,20,23,30,1,
51,50,62,2,53,52,46,2,5,20,14,2,35,34,46,3,
43,1,53,62,1,53,17,6,7,39,62,3,51,50,30,2,
21,20,6,7,30,3,1,89,31,95,114,60,19,24,63,111,
87,100,25,37,30,27,15,2,28,69,51,64,95,64,32,26,
63,104,1,91,53,100,144,91,33,100,103,95,56,2,72,63,
77,71,65,9,37,90,99,104,51,91,141,97,50,74,88,56,
94,68,38,3,109,254,184,33,51,61,28,31,57,42,25,254,
108,2,4,4,3,254,155,1,8,11,11,27,46,64,36,37,
81,67,43,208,63,102,72,38,2,3,3,2,43,13,37,10,
3,0,5,7,56,8,16,13,8,28,52,74,47,76,109,37,
9,49,71,91,0,2,0,80,255,226,3,111,3,192,0,30,
0,63,1,231,187,0,21,0,4,0,48,0,4,43,184,0,
21,16,187,0,36,0,4,0,0,0,4,43,184,0,36,16,
65,5,0,154,0,0,0,170,0,0,0,2,93,65,19,0,
9,0,0,0,25,0,0,0,41,0,0,0,57,0,0,0,
73,0,0,0,89,0,0,0,105,0,0,0,121,0,0,0,
137,0,0,0,9,93,65,19,0,6,0,21,0,22,0,21,
0,38,0,21,0,54,0,21,0,70,0,21,0,86,0,21,
0,102,0,21,0,118,0,21,0,134,0,21,0,9,93,65,
5,0,149,0,21,0,165,0,21,0,2,93,184,0,21,16,
184,0,10,208,184,0,10,47,186,0,53,0,48,0,36,17,
18,57,184,0,21,16,185,0,56,0,4,252,184,0,36,16,
184,0,65,220,0,184,0,0,69,88,184,0,31,47,27,185,
0,31,0,9,62,89,184,0,0,69,88,184,0,43,47,27,
185,0,43,0,5,62,89,187,0,15,0,1,0,16,0,4,
43,184,0,15,16,184,0,31,16,185,0,5,0,2,252,65,
5,0,121,0,5,0,137,0,5,0,2,113,65,33,0,8,
0,5,0,24,0,5,0,40,0,5,0,56,0,5,0,72,
0,5,0,88,0,5,0,104,0,5,0,120,0,5,0,136,
0,5,0,152,0,5,0,168,0,5,0,184,0,5,0,200,
0,5,0,216,0,5,0,232,0,5,0,248,0,5,0,16,
93,65,15,0,8,0,5,0,24,0,5,0,40,0,5,0,
56,0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,
7,113,184,0,43,16,185,0,26,0,2,252,65,33,0,7,
0,26,0,23,0,26,0,39,0,26,0,55,0,26,0,71,
0,26,0,87,0,26,0,103,0,26,0,119,0,26,0,135,
0,26,0,151,0,26,0,167,0,26,0,183,0,26,0,199,
0,26,0,215,0,26,0,231,0,26,0,247,0,26,0,16,
93,65,15,0,7,0,26,0,23,0,26,0,39,0,26,0,
55,0,26,0,71,0,26,0,87,0,26,0,103,0,26,0,
7,113,65,5,0,118,0,26,0,134,0,26,0,2,113,186,
0,53,0,43,0,31,17,18,57,48,49,1,52,46,2,35,
34,14,2,21,20,30,2,31,1,14,3,23,30,3,51,50,
62,2,3,50,30,2,21,20,14,4,35,34,46,2,53,52,
62,2,55,46,1,53,52,62,2,55,62,1,2,215,49,81,
103,54,47,70,47,24,19,60,110,91,11,78,115,74,35,1,
1,29,57,84,54,60,97,67,36,232,87,141,101,55,38,66,
88,101,108,52,84,129,88,45,33,54,68,35,75,82,22,40,
55,33,48,125,1,183,109,158,102,48,24,41,54,30,31,60,
51,37,6,53,5,40,58,68,34,32,60,47,29,51,92,126,
2,83,76,126,162,87,85,146,120,92,63,33,38,68,91,54,
44,76,63,48,15,29,98,82,31,62,56,50,20,31,34,0,
0,1,0,80,255,234,5,3,6,14,0,92,1,193,184,0,
93,47,184,0,94,47,184,0,61,220,184,0,15,208,184,0,
93,16,184,0,71,208,184,0,71,47,185,0,34,0,4,252,
65,19,0,6,0,34,0,22,0,34,0,38,0,34,0,54,
0,34,0,70,0,34,0,86,0,34,0,102,0,34,0,118,
0,34,0,134,0,34,0,9,93,65,5,0,149,0,34,0,
165,0,34,0,2,93,184,0,61,16,185,0,41,0,4,252,
184,0,61,16,184,0,55,208,184,0,61,16,184,0,59,208,
184,0,59,47,184,0,41,16,184,0,79,208,184,0,61,16,
184,0,85,208,184,0,85,47,0,184,0,0,69,88,184,0,
76,47,27,185,0,76,0,9,62,89,184,0,0,69,88,184,
0,66,47,27,185,0,66,0,5,62,89,187,0,88,0,2,
0,10,0,4,43,184,0,88,16,184,0,76,16,185,0,27,
0,2,252,65,5,0,121,0,27,0,137,0,27,0,2,113,
65,33,0,8,0,27,0,24,0,27,0,40,0,27,0,56,
0,27,0,72,0,27,0,88,0,27,0,104,0,27,0,120,
0,27,0,136,0,27,0,152,0,27,0,168,0,27,0,184,
0,27,0,200,0,27,0,216,0,27,0,232,0,27,0,248,
0,27,0,16,93,65,15,0,8,0,27,0,24,0,27,0,
40,0,27,0,56,0,27,0,72,0,27,0,88,0,27,0,
104,0,27,0,7,113,184,0,66,16,185,0,39,0,2,252,
65,33,0,7,0,39,0,23,0,39,0,39,0,39,0,55,
0,39,0,71,0,39,0,87,0,39,0,103,0,39,0,119,
0,39,0,135,0,39,0,151,0,39,0,167,0,39,0,183,
0,39,0,199,0,39,0,215,0,39,0,231,0,39,0,247,
0,39,0,16,93,65,15,0,7,0,39,0,23,0,39,0,
39,0,39,0,55,0,39,0,71,0,39,0,87,0,39,0,
103,0,39,0,7,113,65,5,0,118,0,39,0,134,0,39,
0,2,113,186,0,79,0,76,0,27,17,18,57,48,49,1,
20,14,2,7,46,3,35,34,14,2,29,1,20,14,2,7,
39,46,3,35,34,14,4,21,20,30,2,51,50,55,53,52,
46,2,39,53,33,21,14,3,29,1,48,6,7,22,51,14,
3,35,34,46,2,53,52,62,2,51,50,22,23,53,52,62,
2,55,62,1,51,50,30,2,5,3,29,40,43,15,21,41,
39,34,14,32,45,30,14,19,26,29,10,28,27,54,60,68,
40,19,59,65,66,53,33,59,94,120,61,99,73,12,35,63,
50,1,134,23,31,18,8,2,1,2,1,61,98,84,74,37,
83,162,128,79,84,148,201,117,23,54,29,17,36,56,39,51,
111,39,43,73,53,29,5,143,8,31,33,29,7,34,44,25,
9,32,75,123,91,222,10,29,31,28,9,4,24,33,21,9,
15,37,59,87,119,77,104,149,98,46,29,220,12,26,24,22,
7,43,43,5,21,25,28,12,207,1,1,2,45,55,28,9,
56,113,171,115,124,195,136,72,7,8,106,85,123,93,72,34,
45,47,33,43,42,0,0,1,0,55,0,0,4,106,3,162,
0,43,0,99,184,0,44,47,184,0,45,47,184,0,44,16,
184,0,4,208,184,0,4,47,185,0,39,0,4,252,184,0,
14,208,184,0,45,16,184,0,26,220,185,0,17,0,4,252,
184,0,36,208,0,184,0,0,69,88,184,0,9,47,27,185,
0,9,0,9,62,89,184,0,0,69,88,184,0,21,47,27,
185,0,21,0,9,62,89,187,0,16,0,2,0,37,0,4,
43,184,0,16,16,48,49,51,53,62,1,53,17,52,38,39,
53,33,21,14,1,21,17,33,17,52,38,39,53,33,21,14,
1,21,17,20,22,23,21,33,53,62,1,53,17,33,17,20,
22,23,21,55,63,77,72,68,1,173,63,76,1,239,72,68,
1,174,63,77,72,68,254,82,64,76,254,17,71,68,43,14,
37,10,2,209,9,38,15,43,43,15,36,11,254,217,1,39,
9,38,15,43,43,15,36,11,253,47,9,38,14,43,43,14,
37,10,1,80,254,176,9,38,14,43,0,3,254,236,254,2,
1,219,5,65,0,14,0,27,0,73,1,93,187,0,0,0,
4,0,8,0,4,43,187,0,23,0,4,0,49,0,4,43,
184,0,23,16,65,5,0,154,0,8,0,170,0,8,0,2,
93,65,19,0,9,0,8,0,25,0,8,0,41,0,8,0,
57,0,8,0,73,0,8,0,89,0,8,0,105,0,8,0,
121,0,8,0,137,0,8,0,9,93,65,19,0,6,0,23,
0,22,0,23,0,38,0,23,0,54,0,23,0,70,0,23,
0,86,0,23,0,102,0,23,0,118,0,23,0,134,0,23,
0,9,93,65,5,0,149,0,23,0,165,0,23,0,2,93,
186,0,59,0,8,0,0,17,18,57,184,0,59,47,185,0,
28,0,4,252,184,0,8,16,184,0,57,208,184,0,57,47,
184,0,28,16,184,0,72,208,0,184,0,35,47,184,0,44,
47,184,0,0,69,88,184,0,71,47,27,185,0,71,0,9,
62,89,187,0,54,0,2,0,20,0,4,43,184,0,54,16,
184,0,44,16,185,0,15,0,2,252,65,33,0,7,0,15,
0,23,0,15,0,39,0,15,0,55,0,15,0,71,0,15,
0,87,0,15,0,103,0,15,0,119,0,15,0,135,0,15,
0,151,0,15,0,167,0,15,0,183,0,15,0,199,0,15,
0,215,0,15,0,231,0,15,0,247,0,15,0,16,93,65,
15,0,7,0,15,0,23,0,15,0,39,0,15,0,55,0,
15,0,71,0,15,0,87,0,15,0,103,0,15,0,7,113,
65,5,0,118,0,15,0,134,0,15,0,2,113,186,0,57,
0,20,0,54,17,18,57,48,49,1,20,14,2,35,34,38,
53,52,62,2,51,50,1,50,54,55,38,35,34,6,21,20,
30,2,1,20,6,7,30,1,23,7,46,1,39,14,1,7,
14,1,35,34,46,2,53,52,62,2,51,50,22,23,54,53,
17,52,46,2,39,53,62,3,55,51,17,1,109,18,31,42,
24,45,39,18,31,42,24,84,254,138,59,82,23,76,86,63,
76,28,41,48,1,108,30,24,48,96,50,46,56,90,40,16,
33,17,51,113,69,38,78,64,40,31,67,104,72,47,86,42,
12,5,26,57,52,42,65,59,55,32,37,4,226,28,50,37,
22,50,46,28,50,37,21,249,72,61,77,50,53,40,24,36,
23,12,1,218,115,161,57,45,116,69,46,65,100,38,25,40,
18,54,56,26,50,72,46,27,70,63,44,25,25,79,116,2,
115,51,62,35,16,6,40,7,18,19,23,13,252,163,0,2,
0,40,254,12,3,235,3,192,0,31,0,54,0,89,187,0,
36,0,4,0,48,0,4,43,184,0,36,16,184,0,56,220,
0,184,0,0,69,88,184,0,2,47,27,185,0,2,0,9,
62,89,184,0,0,69,88,184,0,32,47,27,185,0,32,0,
9,62,89,184,0,0,69,88,184,0,46,47,27,185,0,46,
0,7,62,89,184,0,0,69,88,184,0,16,47,27,185,0,
16,0,5,62,89,48,49,19,54,55,30,3,23,1,23,1,
14,1,30,1,51,21,33,53,62,3,55,9,1,46,3,7,
53,37,21,14,1,21,17,20,30,2,23,21,14,1,7,39,
17,52,46,2,39,53,40,127,125,7,18,25,34,23,1,55,
3,254,204,33,15,20,45,26,254,133,22,40,38,39,21,1,
80,254,141,14,30,36,45,29,3,195,66,74,11,31,55,43,
69,133,51,37,7,22,44,37,3,126,15,51,18,36,40,46,
29,254,126,1,254,239,29,35,18,6,43,43,2,8,13,22,
17,1,15,1,172,16,21,12,3,2,40,36,43,17,26,18,
251,208,46,50,25,8,5,40,14,37,29,34,5,12,7,13,
13,16,12,43,0,1,0,55,0,0,3,89,3,162,0,33,
0,57,187,0,21,0,4,0,10,0,4,43,184,0,21,16,
0,184,0,0,69,88,184,0,15,47,27,185,0,15,0,9,
62,89,184,0,0,69,88,184,0,5,47,27,185,0,5,0,
5,62,89,185,0,26,0,2,252,48,49,37,14,3,7,33,
53,62,1,53,17,52,38,39,53,33,21,14,1,21,17,20,
30,2,59,1,50,62,2,55,23,3,89,4,10,11,11,3,
253,5,63,77,72,68,1,173,63,76,16,39,68,51,94,43,
59,45,36,20,41,205,32,64,56,42,11,43,10,25,10,2,
241,9,26,11,43,43,11,24,11,253,72,13,21,14,7,7,
27,50,44,13,0,2,0,80,254,32,5,12,6,14,0,18,
0,79,1,206,184,0,80,47,184,0,81,47,184,0,34,220,
185,0,67,0,4,252,184,0,0,208,184,0,80,16,184,0,
55,208,184,0,55,47,185,0,8,0,4,252,65,19,0,6,
0,8,0,22,0,8,0,38,0,8,0,54,0,8,0,70,
0,8,0,86,0,8,0,102,0,8,0,118,0,8,0,134,
0,8,0,9,93,65,5,0,149,0,8,0,165,0,8,0,
2,93,184,0,67,16,184,0,44,208,186,0,45,0,55,0,
34,17,18,57,184,0,34,16,184,0,72,208,184,0,72,47,
0,184,0,0,69,88,184,0,63,47,27,185,0,63,0,9,
62,89,184,0,0,69,88,184,0,39,47,27,185,0,39,0,
7,62,89,184,0,0,69,88,184,0,50,47,27,185,0,50,
0,5,62,89,187,0,75,0,2,0,29,0,4,43,184,0,
75,16,184,0,63,16,185,0,3,0,2,252,65,5,0,121,
0,3,0,137,0,3,0,2,113,65,33,0,8,0,3,0,
24,0,3,0,40,0,3,0,56,0,3,0,72,0,3,0,
88,0,3,0,104,0,3,0,120,0,3,0,136,0,3,0,
152,0,3,0,168,0,3,0,184,0,3,0,200,0,3,0,
216,0,3,0,232,0,3,0,248,0,3,0,16,93,65,15,
0,8,0,3,0,24,0,3,0,40,0,3,0,56,0,3,
0,72,0,3,0,88,0,3,0,104,0,3,0,7,113,184,
0,50,16,185,0,13,0,2,252,65,33,0,7,0,13,0,
23,0,13,0,39,0,13,0,55,0,13,0,71,0,13,0,
87,0,13,0,103,0,13,0,119,0,13,0,135,0,13,0,
151,0,13,0,167,0,13,0,183,0,13,0,199,0,13,0,
215,0,13,0,231,0,13,0,247,0,13,0,16,93,65,15,
0,7,0,13,0,23,0,13,0,39,0,13,0,55,0,13,
0,71,0,13,0,87,0,13,0,103,0,13,0,7,113,65,
5,0,118,0,13,0,134,0,13,0,2,113,186,0,45,0,
39,0,63,17,18,57,186,0,66,0,63,0,3,17,18,57,
48,49,1,46,1,35,34,14,2,21,20,30,2,51,50,62,
2,55,1,20,14,2,7,46,3,35,34,14,2,21,17,20,
22,23,21,33,53,62,1,53,17,14,3,35,34,46,2,53,
52,62,2,55,62,1,51,50,22,23,53,52,62,2,55,62,
1,51,50,30,2,2,233,33,120,72,56,104,81,49,49,76,
91,41,34,66,65,62,31,2,35,29,40,43,15,21,41,39,
34,14,32,45,30,14,62,77,254,53,94,76,38,74,79,87,
51,56,118,99,63,56,81,92,35,57,112,38,47,93,54,17,
36,56,39,51,111,39,43,73,53,29,2,218,57,65,48,94,
141,94,85,138,97,53,27,45,57,30,4,138,8,31,33,29,
7,34,44,25,9,32,75,123,91,250,55,16,32,14,43,43,
14,31,17,2,29,46,72,51,27,65,122,176,111,88,148,115,
80,20,31,34,23,40,154,85,123,93,72,34,45,47,33,43,
42,0,0,1,0,60,0,0,3,82,6,14,0,65,1,2,
187,0,34,0,4,0,45,0,4,43,184,0,34,16,187,0,
2,0,4,0,10,0,4,43,184,0,2,16,187,0,55,0,
4,0,24,0,4,43,184,0,55,16,65,5,0,154,0,24,
0,170,0,24,0,2,93,65,19,0,9,0,24,0,25,0,
24,0,41,0,24,0,57,0,24,0,73,0,24,0,89,0,
24,0,105,0,24,0,121,0,24,0,137,0,24,0,9,93,
184,0,24,16,184,0,5,208,184,0,5,47,184,0,10,16,
184,0,17,208,65,19,0,6,0,34,0,22,0,34,0,38,
0,34,0,54,0,34,0,70,0,34,0,86,0,34,0,102,
0,34,0,118,0,34,0,134,0,34,0,9,93,65,5,0,
149,0,34,0,165,0,34,0,2,93,184,0,45,16,184,0,
43,208,184,0,2,16,184,0,62,208,184,0,55,16,184,0,
67,220,0,184,0,0,69,88,184,0,6,47,27,185,0,6,
0,5,62,89,187,0,50,0,2,0,29,0,4,43,184,0,
50,16,187,0,64,0,2,0,0,0,4,43,184,0,64,16,
184,0,0,16,184,0,11,208,184,0,64,16,184,0,16,208,
48,49,1,35,17,20,22,23,21,33,53,54,53,17,35,39,
62,1,55,51,62,5,53,52,46,2,35,34,14,2,21,20,
22,23,14,1,7,39,38,53,52,53,52,62,2,51,50,30,
2,21,20,14,4,29,1,51,23,2,228,220,88,82,254,22,
170,220,22,5,9,8,220,1,51,73,85,72,48,41,72,97,
56,40,75,59,36,7,5,32,70,45,27,2,76,126,163,87,
77,125,88,48,49,73,86,73,49,220,22,1,159,254,201,15,
32,14,43,43,30,31,1,55,22,16,36,16,75,126,110,99,
97,101,57,61,105,75,43,39,62,78,39,14,30,14,17,16,
5,30,8,8,9,8,70,127,94,56,52,91,122,70,74,118,
100,92,97,110,69,50,25,0,0,1,0,40,0,0,3,62,
6,14,0,58,0,254,187,0,49,0,4,0,24,0,4,43,
184,0,49,16,187,0,2,0,4,0,10,0,4,43,184,0,
2,16,187,0,34,0,4,0,39,0,4,43,184,0,34,16,
65,19,0,6,0,49,0,22,0,49,0,38,0,49,0,54,
0,49,0,70,0,49,0,86,0,49,0,102,0,49,0,118,
0,49,0,134,0,49,0,9,93,65,5,0,149,0,49,0,
165,0,49,0,2,93,184,0,49,16,184,0,6,208,184,0,
6,47,184,0,10,16,184,0,17,208,184,0,17,47,65,5,
0,154,0,39,0,170,0,39,0,2,93,65,19,0,9,0,
39,0,25,0,39,0,41,0,39,0,57,0,39,0,73,0,
39,0,89,0,39,0,105,0,39,0,121,0,39,0,137,0,
39,0,9,93,184,0,2,16,184,0,56,208,184,0,34,16,
184,0,60,220,0,184,0,0,69,88,184,0,5,47,27,185,
0,5,0,5,62,89,187,0,29,0,2,0,44,0,4,43,
184,0,29,16,187,0,57,0,2,0,0,0,4,43,184,0,
57,16,184,0,0,16,184,0,11,208,184,0,57,16,184,0,
16,208,48,49,1,35,17,20,23,21,33,53,62,1,53,17,
35,39,62,1,55,51,46,5,53,52,62,2,51,50,30,2,
23,14,3,39,46,3,35,34,14,2,21,20,30,4,23,51,
23,2,228,220,170,254,22,82,88,220,22,5,9,8,217,8,
54,73,80,68,44,73,118,150,77,82,132,95,56,7,3,31,
45,54,24,2,38,69,98,61,45,78,58,34,48,72,85,73,
50,2,220,22,1,159,254,201,31,30,43,43,14,32,15,1,
55,22,16,36,16,62,108,101,97,103,113,66,93,146,102,54,
46,84,118,72,8,23,19,14,1,64,105,76,42,40,72,101,
61,57,102,100,101,112,127,76,25,0,0,3,0,80,255,226,
6,20,6,14,0,11,0,31,0,89,1,172,184,0,90,47,
184,0,91,47,184,0,0,220,184,0,3,208,184,0,3,47,
184,0,0,16,184,0,10,208,184,0,0,16,185,0,31,0,
4,252,184,0,13,208,184,0,90,16,184,0,53,208,184,0,
53,47,185,0,21,0,4,252,65,19,0,6,0,21,0,22,
0,21,0,38,0,21,0,54,0,21,0,70,0,21,0,86,
0,21,0,102,0,21,0,118,0,21,0,134,0,21,0,9,
93,65,5,0,149,0,21,0,165,0,21,0,2,93,184,0,
31,16,184,0,43,208,184,0,43,47,184,0,31,16,184,0,
63,208,184,0,0,16,184,0,74,208,0,184,0,73,47,184,
0,0,69,88,184,0,75,47,27,185,0,75,0,9,62,89,
184,0,0,69,88,184,0,79,47,27,185,0,79,0,9,62,
89,184,0,0,69,88,184,0,81,47,27,185,0,81,0,9,
62,89,184,0,0,69,88,184,0,60,47,27,185,0,60,0,
9,62,89,184,0,0,69,88,184,0,48,47,27,185,0,48,
0,5,62,89,184,0,0,69,88,184,0,37,47,27,185,0,
37,0,5,62,89,184,0,81,16,185,0,4,0,2,252,184,
0,5,208,184,0,5,47,184,0,16,208,184,0,48,16,185,
0,26,0,2,252,65,33,0,7,0,26,0,23,0,26,0,
39,0,26,0,55,0,26,0,71,0,26,0,87,0,26,0,
103,0,26,0,119,0,26,0,135,0,26,0,151,0,26,0,
167,0,26,0,183,0,26,0,199,0,26,0,215,0,26,0,
231,0,26,0,247,0,26,0,16,93,65,15,0,7,0,26,
0,23,0,26,0,39,0,26,0,55,0,26,0,71,0,26,
0,87,0,26,0,103,0,26,0,7,113,65,5,0,118,0,
26,0,134,0,26,0,2,113,186,0,43,0,48,0,73,17,
18,57,186,0,63,0,81,0,4,17,18,57,184,0,37,16,
185,0,84,0,2,252,48,49,37,20,22,23,1,33,34,14,
2,7,17,39,17,46,1,35,34,14,2,21,20,30,2,51,
50,62,2,55,5,20,14,2,7,33,34,46,2,39,14,3,
35,34,46,2,53,52,62,4,51,50,22,23,17,52,46,2,
39,53,62,1,55,23,17,30,2,51,50,51,33,23,1,33,
50,54,55,23,3,127,1,1,1,205,254,166,16,33,31,27,
10,150,33,120,72,64,106,77,43,49,76,91,41,34,66,65,
62,31,3,43,2,3,4,3,253,93,17,36,33,26,7,39,
75,80,88,52,56,118,99,63,31,58,84,104,124,70,47,93,
54,6,28,58,53,82,130,52,31,15,30,33,20,21,26,1,
236,22,253,211,1,166,25,42,23,47,254,23,37,14,2,148,
12,33,59,46,254,76,18,1,202,57,63,47,94,140,94,85,
138,97,53,27,45,57,30,13,32,72,68,58,18,15,38,67,
53,47,76,52,28,65,122,176,111,57,122,114,102,77,44,23,
40,1,121,55,65,35,13,4,39,11,37,17,30,253,186,3,
3,2,43,252,227,77,91,10,0,2,0,80,254,12,6,154,
6,14,0,19,0,127,3,28,187,0,9,0,4,0,89,0,
4,43,184,0,9,16,187,0,62,0,4,0,19,0,4,43,
184,0,62,16,187,0,20,0,4,0,43,0,4,43,184,0,
20,16,184,0,19,16,184,0,1,208,65,19,0,6,0,9,
0,22,0,9,0,38,0,9,0,54,0,9,0,70,0,9,
0,86,0,9,0,102,0,9,0,118,0,9,0,134,0,9,
0,9,93,65,5,0,149,0,9,0,165,0,9,0,2,93,
65,5,0,154,0,43,0,170,0,43,0,2,93,65,19,0,
9,0,43,0,25,0,43,0,41,0,43,0,57,0,43,0,
73,0,43,0,89,0,43,0,105,0,43,0,121,0,43,0,
137,0,43,0,9,93,186,0,55,0,89,0,20,17,18,57,
184,0,19,16,184,0,79,208,184,0,79,47,184,0,19,16,
184,0,99,208,184,0,62,16,184,0,110,208,186,0,120,0,
89,0,20,17,18,57,184,0,20,16,184,0,129,220,0,184,
0,109,47,184,0,0,69,88,184,0,96,47,27,185,0,96,
0,9,62,89,184,0,0,69,88,184,0,111,47,27,185,0,
111,0,9,62,89,184,0,0,69,88,184,0,115,47,27,185,
0,115,0,9,62,89,184,0,0,69,88,184,0,117,47,27,
185,0,117,0,9,62,89,184,0,0,69,88,184,0,20,47,
27,185,0,20,0,5,62,89,184,0,0,69,88,184,0,76,
47,27,185,0,76,0,5,62,89,184,0,0,69,88,184,0,
84,47,27,185,0,84,0,5,62,89,184,0,0,69,88,184,
0,25,47,27,185,0,25,0,7,62,89,187,0,123,0,2,
0,48,0,4,43,184,0,123,16,184,0,96,16,185,0,4,
0,2,252,65,5,0,121,0,4,0,137,0,4,0,2,113,
65,33,0,8,0,4,0,24,0,4,0,40,0,4,0,56,
0,4,0,72,0,4,0,88,0,4,0,104,0,4,0,120,
0,4,0,136,0,4,0,152,0,4,0,168,0,4,0,184,
0,4,0,200,0,4,0,216,0,4,0,232,0,4,0,248,
0,4,0,16,93,65,15,0,8,0,4,0,24,0,4,0,
40,0,4,0,56,0,4,0,72,0,4,0,88,0,4,0,
104,0,4,0,7,113,184,0,84,16,185,0,14,0,2,252,
65,33,0,7,0,14,0,23,0,14,0,39,0,14,0,55,
0,14,0,71,0,14,0,87,0,14,0,103,0,14,0,119,
0,14,0,135,0,14,0,151,0,14,0,167,0,14,0,183,
0,14,0,199,0,14,0,215,0,14,0,231,0,14,0,247,
0,14,0,16,93,65,15,0,7,0,14,0,23,0,14,0,
39,0,14,0,55,0,14,0,71,0,14,0,87,0,14,0,
103,0,14,0,7,113,65,5,0,118,0,14,0,134,0,14,
0,2,113,184,0,25,16,185,0,38,0,2,252,65,33,0,
7,0,38,0,23,0,38,0,39,0,38,0,55,0,38,0,
71,0,38,0,87,0,38,0,103,0,38,0,119,0,38,0,
135,0,38,0,151,0,38,0,167,0,38,0,183,0,38,0,
199,0,38,0,215,0,38,0,231,0,38,0,247,0,38,0,
16,93,65,15,0,7,0,38,0,23,0,38,0,39,0,38,
0,55,0,38,0,71,0,38,0,87,0,38,0,103,0,38,
0,7,113,65,5,0,118,0,38,0,134,0,38,0,2,113,
184,0,4,16,184,0,55,208,184,0,55,47,184,0,56,208,
184,0,56,47,186,0,79,0,25,0,109,17,18,57,186,0,
99,0,96,0,4,17,18,57,186,0,120,0,48,0,123,17,
18,57,48,49,1,17,46,1,35,34,14,2,21,20,30,2,
51,50,62,2,55,1,20,14,2,35,34,46,2,53,52,62,
2,55,30,1,51,50,62,2,53,52,46,2,7,34,6,7,
46,1,39,1,33,34,14,2,7,17,20,30,2,23,22,54,
55,23,14,3,35,34,38,39,14,3,35,34,46,2,53,52,
62,4,51,50,22,23,17,52,46,2,39,53,62,1,55,23,
17,30,2,51,50,51,33,23,1,62,1,51,30,3,2,233,
33,120,72,64,106,77,43,49,76,91,41,34,66,65,62,31,
3,177,83,134,167,84,71,126,93,54,28,42,48,21,58,119,
67,60,102,75,42,44,85,123,79,41,79,40,7,23,5,1,
172,254,82,16,33,31,27,10,3,6,8,6,9,51,60,13,
46,71,53,38,14,33,42,7,38,75,79,88,51,56,118,99,
63,31,58,84,104,124,70,47,93,54,6,28,58,53,82,130,
52,31,15,30,34,20,21,26,2,67,25,254,115,17,32,16,
80,138,101,58,1,16,1,202,57,63,47,94,140,94,85,138,
97,53,27,45,57,30,254,225,106,174,125,69,38,53,55,17,
6,29,32,27,3,75,80,42,81,119,76,67,128,99,59,2,
14,14,5,31,8,2,38,12,33,59,46,254,76,35,50,34,
22,7,11,9,23,43,31,43,27,13,90,109,46,74,51,28,
65,122,176,111,57,122,114,102,77,44,23,40,1,121,55,65,
35,13,4,39,11,37,17,30,253,186,3,3,2,43,253,252,
2,2,2,54,102,148,0,4,0,80,255,42,6,104,6,14,
0,10,0,22,0,42,0,111,1,219,184,0,112,47,184,0,
113,47,184,0,11,220,184,0,14,208,184,0,14,47,184,0,
11,16,184,0,21,208,184,0,11,16,185,0,42,0,4,252,
184,0,24,208,184,0,112,16,184,0,77,208,184,0,77,47,
185,0,32,0,4,252,65,19,0,6,0,32,0,22,0,32,
0,38,0,32,0,54,0,32,0,70,0,32,0,86,0,32,
0,102,0,32,0,118,0,32,0,134,0,32,0,9,93,65,
5,0,149,0,32,0,165,0,32,0,2,93,184,0,42,16,
184,0,67,208,184,0,67,47,184,0,42,16,184,0,87,208,
184,0,11,16,184,0,98,208,0,184,0,57,47,184,0,97,
47,184,0,0,69,88,184,0,99,47,27,185,0,99,0,9,
62,89,184,0,0,69,88,184,0,103,47,27,185,0,103,0,
9,62,89,184,0,0,69,88,184,0,105,47,27,185,0,105,
0,9,62,89,184,0,0,69,88,184,0,84,47,27,185,0,
84,0,9,62,89,184,0,0,69,88,184,0,72,47,27,185,
0,72,0,5,62,89,184,0,0,69,88,184,0,53,47,27,
185,0,53,0,5,62,89,184,0,0,69,88,184,0,61,47,
27,185,0,61,0,5,62,89,185,0,2,0,2,252,184,0,
3,208,184,0,0,220,184,0,105,16,185,0,15,0,2,252,
184,0,16,208,184,0,16,47,184,0,27,208,184,0,72,16,
185,0,37,0,2,252,65,33,0,7,0,37,0,23,0,37,
0,39,0,37,0,55,0,37,0,71,0,37,0,87,0,37,
0,103,0,37,0,119,0,37,0,135,0,37,0,151,0,37,
0,167,0,37,0,183,0,37,0,199,0,37,0,215,0,37,
0,231,0,37,0,247,0,37,0,16,93,65,15,0,7,0,
37,0,23,0,37,0,39,0,37,0,55,0,37,0,71,0,
37,0,87,0,37,0,103,0,37,0,7,113,65,5,0,118,
0,37,0,134,0,37,0,2,113,184,0,0,16,185,0,43,
0,2,252,186,0,67,0,3,0,0,17,18,57,186,0,87,
0,105,0,15,17,18,57,184,0,3,16,184,0,108,208,184,
0,109,208,48,49,1,34,7,51,50,62,2,53,52,38,5,
20,22,23,1,33,34,14,2,7,17,39,17,46,1,35,34,
14,2,21,20,30,2,51,50,62,2,55,37,50,30,2,21,
20,14,2,7,35,14,1,7,39,62,1,55,33,34,46,2,
39,14,3,35,34,46,2,53,52,62,4,51,50,22,23,17,
52,46,2,39,53,62,1,55,23,17,30,2,51,50,51,33,
23,1,51,62,1,5,166,112,69,94,52,68,39,15,49,253,
179,1,1,1,205,254,166,16,33,31,27,10,150,33,120,72,
64,106,77,43,49,76,91,41,34,66,65,62,31,2,223,33,
58,43,26,31,63,97,65,148,12,20,8,65,4,15,11,254,
220,17,36,33,26,7,39,75,80,88,52,56,118,99,63,31,
58,84,104,124,70,47,93,54,6,28,58,53,82,130,52,31,
15,30,33,20,21,26,1,236,22,253,211,189,50,156,1,9,
175,14,25,33,18,37,48,11,23,37,14,2,148,12,33,59,
46,254,76,18,1,202,57,63,47,94,140,94,85,138,97,53,
27,45,57,30,122,18,38,58,40,42,82,64,40,1,45,107,
62,8,58,102,46,15,38,67,53,47,76,52,28,65,122,176,
111,57,122,114,102,77,44,23,40,1,121,55,65,35,13,4,
39,11,37,17,30,253,186,3,3,2,43,252,227,149,144,0,
0,2,0,20,255,226,4,186,5,0,0,38,0,100,2,190,
187,0,34,0,4,0,59,0,4,43,184,0,34,16,187,0,
91,0,4,0,27,0,4,43,184,0,91,16,187,0,39,0,
4,0,17,0,4,43,184,0,39,16,65,5,0,154,0,27,
0,170,0,27,0,2,93,65,19,0,9,0,27,0,25,0,
27,0,41,0,27,0,57,0,27,0,73,0,27,0,89,0,
27,0,105,0,27,0,121,0,27,0,137,0,27,0,9,93,
184,0,27,16,184,0,3,208,184,0,3,47,65,5,0,154,
0,17,0,170,0,17,0,2,93,65,19,0,9,0,17,0,
25,0,17,0,41,0,17,0,57,0,17,0,73,0,17,0,
89,0,17,0,105,0,17,0,121,0,17,0,137,0,17,0,
9,93,184,0,27,16,184,0,51,208,184,0,51,47,184,0,
59,16,184,0,64,208,184,0,34,16,184,0,67,208,184,0,
39,16,184,0,102,220,0,184,0,0,69,88,184,0,66,47,
27,185,0,66,0,11,62,89,184,0,0,69,88,184,0,63,
47,27,185,0,63,0,9,62,89,184,0,0,69,88,184,0,
68,47,27,185,0,68,0,9,62,89,184,0,0,69,88,184,
0,72,47,27,185,0,72,0,9,62,89,184,0,0,69,88,
184,0,46,47,27,185,0,46,0,5,62,89,184,0,0,69,
88,184,0,54,47,27,185,0,54,0,5,62,89,185,0,0,
0,2,252,65,33,0,7,0,0,0,23,0,0,0,39,0,
0,0,55,0,0,0,71,0,0,0,87,0,0,0,103,0,
0,0,119,0,0,0,135,0,0,0,151,0,0,0,167,0,
0,0,183,0,0,0,199,0,0,0,215,0,0,0,231,0,
0,0,247,0,0,0,16,93,65,15,0,7,0,0,0,23,
0,0,0,39,0,0,0,55,0,0,0,71,0,0,0,87,
0,0,0,103,0,0,0,7,113,65,5,0,118,0,0,0,
134,0,0,0,2,113,184,0,46,16,185,0,12,0,2,252,
65,33,0,7,0,12,0,23,0,12,0,39,0,12,0,55,
0,12,0,71,0,12,0,87,0,12,0,103,0,12,0,119,
0,12,0,135,0,12,0,151,0,12,0,167,0,12,0,183,
0,12,0,199,0,12,0,215,0,12,0,231,0,12,0,247,
0,12,0,16,93,65,15,0,7,0,12,0,23,0,12,0,
39,0,12,0,55,0,12,0,71,0,12,0,87,0,12,0,
103,0,12,0,7,113,65,5,0,118,0,12,0,134,0,12,
0,2,113,184,0,68,16,185,0,32,0,2,252,186,0,51,
0,54,0,0,17,18,57,184,0,60,208,184,0,61,208,184,
0,68,16,185,0,86,0,1,252,65,5,0,121,0,86,0,
137,0,86,0,2,113,65,33,0,8,0,86,0,24,0,86,
0,40,0,86,0,56,0,86,0,72,0,86,0,88,0,86,
0,104,0,86,0,120,0,86,0,136,0,86,0,152,0,86,
0,168,0,86,0,184,0,86,0,200,0,86,0,216,0,86,
0,232,0,86,0,248,0,86,0,16,93,65,15,0,8,0,
86,0,24,0,86,0,40,0,86,0,56,0,86,0,72,0,
86,0,88,0,86,0,104,0,86,0,7,113,48,49,37,50,
54,55,62,1,55,23,30,3,51,50,62,2,53,52,46,2,
39,46,3,53,52,55,46,1,43,1,17,20,30,2,37,20,
14,4,35,34,38,39,38,39,14,1,35,34,46,2,53,17,
35,39,55,51,53,55,23,17,33,62,1,51,50,30,2,23,
22,14,2,7,39,46,1,35,34,14,2,21,20,30,2,23,
30,3,1,172,30,86,61,2,9,7,43,2,40,67,89,52,
36,60,44,24,43,70,89,46,42,78,61,37,21,25,96,80,
114,11,26,41,3,44,40,64,78,76,67,19,48,135,67,6,
3,80,140,43,35,63,48,28,129,21,78,72,119,31,1,192,
32,73,38,31,75,73,64,20,6,9,19,22,6,39,48,103,
49,33,52,37,19,38,62,79,42,43,88,70,44,102,18,28,
38,75,22,11,42,74,56,32,23,42,59,35,40,62,51,45,
24,21,48,60,74,48,57,45,12,22,253,239,60,79,47,19,
181,71,101,70,42,22,7,36,37,3,24,50,50,26,59,96,
70,2,103,28,66,246,104,25,254,187,14,16,11,20,28,18,
6,42,50,44,8,8,72,57,22,35,42,21,32,51,45,41,
22,22,50,65,83,0,0,2,0,20,254,12,4,190,6,14,
0,17,0,109,2,62,187,0,13,0,4,0,60,0,4,43,
184,0,13,16,187,0,103,0,4,0,73,0,4,43,184,0,
103,16,65,5,0,154,0,73,0,170,0,73,0,2,93,65,
19,0,9,0,73,0,25,0,73,0,41,0,73,0,57,0,
73,0,73,0,73,0,89,0,73,0,105,0,73,0,121,0,
73,0,137,0,73,0,9,93,186,0,48,0,73,0,103,17,
18,57,184,0,48,47,65,5,0,154,0,48,0,170,0,48,
0,2,93,65,19,0,9,0,48,0,25,0,48,0,41,0,
48,0,57,0,48,0,73,0,48,0,89,0,48,0,105,0,
48,0,121,0,48,0,137,0,48,0,9,93,185,0,18,0,
4,252,184,0,48,16,184,0,50,208,184,0,50,47,184,0,
60,16,184,0,65,208,184,0,13,16,184,0,68,208,184,0,
73,16,184,0,70,208,184,0,70,47,184,0,18,16,184,0,
111,220,0,184,0,83,47,184,0,0,69,88,184,0,67,47,
27,185,0,67,0,11,62,89,184,0,0,69,88,184,0,64,
47,27,185,0,64,0,9,62,89,184,0,0,69,88,184,0,
69,47,27,185,0,69,0,9,62,89,184,0,0,69,88,184,
0,28,47,27,185,0,28,0,7,62,89,184,0,0,69,88,
184,0,55,47,27,185,0,55,0,5,62,89,185,0,0,0,
2,252,65,33,0,7,0,0,0,23,0,0,0,39,0,0,
0,55,0,0,0,71,0,0,0,87,0,0,0,103,0,0,
0,119,0,0,0,135,0,0,0,151,0,0,0,167,0,0,
0,183,0,0,0,199,0,0,0,215,0,0,0,231,0,0,
0,247,0,0,0,16,93,65,15,0,7,0,0,0,23,0,
0,0,39,0,0,0,55,0,0,0,71,0,0,0,87,0,
0,0,103,0,0,0,7,113,65,5,0,118,0,0,0,134,
0,0,0,2,113,184,0,69,16,185,0,11,0,2,252,184,
0,28,16,185,0,43,0,2,252,65,33,0,7,0,43,0,
23,0,43,0,39,0,43,0,55,0,43,0,71,0,43,0,
87,0,43,0,103,0,43,0,119,0,43,0,135,0,43,0,
151,0,43,0,167,0,43,0,183,0,43,0,199,0,43,0,
215,0,43,0,231,0,43,0,247,0,43,0,16,93,65,15,
0,7,0,43,0,23,0,43,0,39,0,43,0,55,0,43,
0,71,0,43,0,87,0,43,0,103,0,43,0,7,113,65,
5,0,118,0,43,0,134,0,43,0,2,113,186,0,50,0,
28,0,83,17,18,57,184,0,11,16,184,0,61,208,184,0,
62,208,48,49,37,50,54,55,46,3,39,46,1,43,1,17,
20,30,2,5,20,14,2,7,14,3,35,34,46,2,53,52,
62,2,55,30,3,51,50,62,2,53,52,39,14,3,35,34,
46,2,53,17,35,39,55,51,53,55,23,17,33,46,1,53,
52,62,2,55,62,3,51,50,30,2,21,20,14,2,7,46,
3,35,34,14,2,21,20,30,4,1,192,48,143,75,8,19,
20,20,8,25,95,78,121,17,33,48,1,216,32,54,72,40,
27,65,71,70,31,31,66,55,36,29,40,43,15,16,40,43,
42,19,44,74,54,31,9,65,105,85,71,31,35,69,55,35,
129,21,78,72,119,31,1,50,2,2,25,45,64,40,27,64,
63,57,19,31,66,55,36,29,40,43,15,24,49,45,39,13,
26,49,37,23,16,24,28,24,16,102,47,60,74,154,153,147,
66,12,21,253,239,60,79,47,19,36,97,145,111,81,32,21,
37,27,15,21,28,29,8,9,31,34,30,7,14,23,16,9,
39,79,118,79,84,98,50,63,36,13,26,59,96,70,2,103,
28,66,246,104,25,254,187,28,50,23,92,132,98,73,32,22,
34,24,12,24,31,32,9,8,32,34,30,7,21,31,21,11,
37,72,105,67,77,187,201,205,189,163,0,2,0,20,255,226,
5,57,5,0,0,17,0,103,1,253,184,0,104,47,184,0,
105,47,184,0,18,220,184,0,104,16,184,0,46,208,184,0,
46,47,184,0,51,208,184,0,46,16,185,0,67,0,4,252,
184,0,54,208,184,0,18,16,185,0,78,0,4,252,65,5,
0,154,0,78,0,170,0,78,0,2,93,65,19,0,9,0,
78,0,25,0,78,0,41,0,78,0,57,0,78,0,73,0,
78,0,89,0,78,0,105,0,78,0,121,0,78,0,137,0,
78,0,9,93,184,0,62,208,184,0,62,47,0,184,0,0,
69,88,184,0,53,47,27,185,0,53,0,11,62,89,184,0,
0,69,88,184,0,83,47,27,185,0,83,0,9,62,89,184,
0,0,69,88,184,0,50,47,27,185,0,50,0,9,62,89,
184,0,0,69,88,184,0,55,47,27,185,0,55,0,9,62,
89,184,0,0,69,88,184,0,35,47,27,185,0,35,0,5,
62,89,184,0,0,69,88,184,0,41,47,27,185,0,41,0,
5,62,89,187,0,25,0,2,0,0,0,4,43,184,0,25,
16,184,0,35,16,185,0,8,0,2,252,65,33,0,7,0,
8,0,23,0,8,0,39,0,8,0,55,0,8,0,71,0,
8,0,87,0,8,0,103,0,8,0,119,0,8,0,135,0,
8,0,151,0,8,0,167,0,8,0,183,0,8,0,199,0,
8,0,215,0,8,0,231,0,8,0,247,0,8,0,16,93,
65,15,0,7,0,8,0,23,0,8,0,39,0,8,0,55,
0,8,0,71,0,8,0,87,0,8,0,103,0,8,0,7,
113,65,5,0,118,0,8,0,134,0,8,0,2,113,184,0,
50,16,185,0,47,0,2,252,184,0,65,208,184,0,66,208,
184,0,8,16,184,0,72,208,184,0,83,16,185,0,99,0,
2,252,65,5,0,121,0,99,0,137,0,99,0,2,113,65,
33,0,8,0,99,0,24,0,99,0,40,0,99,0,56,0,
99,0,72,0,99,0,88,0,99,0,104,0,99,0,120,0,
99,0,136,0,99,0,152,0,99,0,168,0,99,0,184,0,
99,0,200,0,99,0,216,0,99,0,232,0,99,0,248,0,
99,0,16,93,65,15,0,8,0,99,0,24,0,99,0,40,
0,99,0,56,0,99,0,72,0,99,0,88,0,99,0,104,
0,99,0,7,113,48,49,1,34,14,2,7,30,1,51,50,
62,2,53,52,46,2,37,20,23,62,3,51,50,30,2,7,
14,3,35,34,38,39,14,1,35,34,46,2,53,17,35,39,
55,51,53,55,23,17,33,23,14,3,7,46,1,43,1,17,
20,30,2,51,50,54,55,46,1,53,52,62,2,51,50,30,
2,23,22,14,2,7,39,46,3,35,34,14,2,4,58,32,
58,63,72,46,43,125,78,47,65,39,17,16,35,54,254,122,
40,64,102,86,76,39,39,72,56,33,1,1,60,99,125,66,
91,155,56,83,169,87,35,63,48,28,129,21,78,72,119,31,
1,71,29,9,27,28,27,10,24,98,81,52,11,26,41,30,
53,103,57,29,32,79,137,186,108,33,69,63,53,17,2,10,
18,22,9,37,8,36,57,79,51,53,97,75,45,1,73,11,
26,45,34,54,57,19,30,38,19,20,43,35,23,146,113,85,
49,65,39,15,25,50,73,48,57,101,77,44,73,70,63,80,
26,59,96,70,2,103,28,66,246,104,25,254,187,29,14,31,
29,22,4,12,23,253,239,60,79,47,19,36,38,55,134,79,
108,188,139,81,11,21,29,18,12,44,49,45,14,10,18,42,
38,25,47,94,140,0,0,1,0,45,254,12,6,15,6,14,
0,129,1,254,187,0,62,0,4,0,73,0,4,43,184,0,
62,16,187,0,42,0,4,0,51,0,4,43,184,0,42,16,
187,0,0,0,4,0,30,0,4,43,184,0,0,16,184,0,
73,16,184,0,78,208,184,0,62,16,184,0,109,208,184,0,
42,16,184,0,118,208,184,0,118,47,184,0,0,16,184,0,
128,208,0,184,0,89,47,184,0,0,69,88,184,0,79,47,
27,185,0,79,0,9,62,89,184,0,0,69,88,184,0,116,
47,27,185,0,116,0,9,62,89,184,0,0,69,88,184,0,
123,47,27,185,0,123,0,9,62,89,184,0,0,69,88,184,
0,77,47,27,185,0,77,0,9,62,89,184,0,0,69,88,
184,0,110,47,27,185,0,110,0,9,62,89,184,0,0,69,
88,184,0,117,47,27,185,0,117,0,9,62,89,184,0,0,
69,88,184,0,46,47,27,185,0,46,0,5,62,89,184,0,
0,69,88,184,0,68,47,27,185,0,68,0,5,62,89,184,
0,0,69,88,184,0,10,47,27,185,0,10,0,7,62,89,
185,0,25,0,2,252,65,33,0,7,0,25,0,23,0,25,
0,39,0,25,0,55,0,25,0,71,0,25,0,87,0,25,
0,103,0,25,0,119,0,25,0,135,0,25,0,151,0,25,
0,167,0,25,0,183,0,25,0,199,0,25,0,215,0,25,
0,231,0,25,0,247,0,25,0,16,93,65,15,0,7,0,
25,0,23,0,25,0,39,0,25,0,55,0,25,0,71,0,
25,0,87,0,25,0,103,0,25,0,7,113,65,5,0,118,
0,25,0,134,0,25,0,2,113,184,0,123,16,185,0,36,
0,2,252,65,5,0,121,0,36,0,137,0,36,0,2,113,
65,33,0,8,0,36,0,24,0,36,0,40,0,36,0,56,
0,36,0,72,0,36,0,88,0,36,0,104,0,36,0,120,
0,36,0,136,0,36,0,152,0,36,0,168,0,36,0,184,
0,36,0,200,0,36,0,216,0,36,0,232,0,36,0,248,
0,36,0,16,93,65,15,0,8,0,36,0,24,0,36,0,
40,0,36,0,56,0,36,0,72,0,36,0,88,0,36,0,
104,0,36,0,7,113,184,0,60,208,184,0,61,208,184,0,
74,208,184,0,75,208,186,0,118,0,10,0,89,17,18,57,
48,49,37,20,14,2,7,14,3,35,34,46,2,53,52,62,
2,55,30,3,51,50,62,2,53,17,52,46,2,35,34,14,
2,7,17,20,22,23,21,33,53,62,1,53,17,52,38,39,
46,3,35,33,17,20,30,2,23,21,33,53,62,1,53,17,
35,39,55,51,53,52,62,2,55,62,3,51,50,30,2,21,
20,14,2,7,46,3,35,34,14,2,29,1,33,50,62,2,
55,31,1,62,3,51,50,30,2,21,17,6,15,37,61,78,
40,27,68,68,61,19,34,79,69,46,30,41,44,14,29,61,
57,48,15,28,69,60,41,14,31,49,35,31,77,87,95,48,
76,65,254,82,66,74,3,8,8,31,41,48,25,254,241,21,
50,79,59,254,13,69,71,134,21,78,77,32,55,72,40,27,
64,63,57,19,31,66,55,36,29,40,43,15,24,49,45,39,
13,26,59,51,34,1,138,20,34,33,34,20,35,10,44,106,
108,102,39,43,80,62,37,88,117,160,111,75,32,23,34,24,
12,20,30,34,15,9,31,34,30,7,27,34,21,8,37,94,
160,124,2,86,61,76,43,16,29,66,107,78,254,67,15,32,
14,43,43,17,27,17,2,95,31,41,14,9,14,10,6,253,
34,6,12,13,17,11,43,43,12,35,12,2,222,28,66,31,
118,161,111,75,32,22,34,24,12,24,31,32,9,8,32,34,
30,7,21,31,21,11,36,92,159,124,86,3,7,12,9,35,
250,67,105,73,39,26,54,83,56,253,115,0,0,1,0,60,
255,226,4,70,6,14,0,83,1,216,187,0,12,0,4,0,
20,0,4,43,184,0,12,16,187,0,74,0,4,0,50,0,
4,43,184,0,74,16,187,0,0,0,4,0,40,0,4,43,
184,0,0,16,184,0,12,16,184,0,31,208,65,5,0,154,
0,40,0,170,0,40,0,2,93,65,19,0,9,0,40,0,
25,0,40,0,41,0,40,0,57,0,40,0,73,0,40,0,
89,0,40,0,105,0,40,0,121,0,40,0,137,0,40,0,
9,93,65,19,0,6,0,74,0,22,0,74,0,38,0,74,
0,54,0,74,0,70,0,74,0,86,0,74,0,102,0,74,
0,118,0,74,0,134,0,74,0,9,93,65,5,0,149,0,
74,0,165,0,74,0,2,93,0,184,0,30,47,184,0,0,
69,88,184,0,55,47,27,185,0,55,0,9,62,89,184,0,
0,69,88,184,0,13,47,27,185,0,13,0,5,62,89,184,
0,0,69,88,184,0,7,47,27,185,0,7,0,5,62,89,
186,0,12,0,7,0,30,17,18,57,185,0,37,0,2,252,
65,33,0,7,0,37,0,23,0,37,0,39,0,37,0,55,
0,37,0,71,0,37,0,87,0,37,0,103,0,37,0,119,
0,37,0,135,0,37,0,151,0,37,0,167,0,37,0,183,
0,37,0,199,0,37,0,215,0,37,0,231,0,37,0,247,
0,37,0,16,93,65,15,0,7,0,37,0,23,0,37,0,
39,0,37,0,55,0,37,0,71,0,37,0,87,0,37,0,
103,0,37,0,7,113,65,5,0,118,0,37,0,134,0,37,
0,2,113,184,0,55,16,185,0,69,0,2,252,65,5,0,
121,0,69,0,137,0,69,0,2,113,65,33,0,8,0,69,
0,24,0,69,0,40,0,69,0,56,0,69,0,72,0,69,
0,88,0,69,0,104,0,69,0,120,0,69,0,136,0,69,
0,152,0,69,0,168,0,69,0,184,0,69,0,200,0,69,
0,216,0,69,0,232,0,69,0,248,0,69,0,16,93,65,
15,0,8,0,69,0,24,0,69,0,40,0,69,0,56,0,
69,0,72,0,69,0,88,0,69,0,104,0,69,0,7,113,
48,49,1,20,14,4,35,34,46,2,39,21,33,53,62,3,
53,17,52,46,2,39,53,62,1,55,23,17,30,3,51,50,
54,53,52,46,2,39,46,3,53,52,62,2,51,50,30,2,
23,22,14,2,7,39,46,1,35,34,14,2,21,20,30,2,
23,30,3,4,70,39,62,78,79,72,24,47,98,97,95,43,
254,212,43,58,34,15,12,32,54,42,72,120,62,36,37,93,
106,115,59,102,92,43,70,89,46,42,78,61,37,50,83,107,
57,31,75,73,64,20,6,9,19,22,6,39,48,103,49,33,
52,37,19,38,62,79,42,43,88,70,44,1,27,71,101,70,
42,22,7,17,37,58,41,123,43,7,15,15,16,8,4,168,
45,50,25,9,5,40,14,34,32,34,251,111,75,106,67,31,
88,71,40,62,51,45,24,21,48,60,74,48,62,97,66,35,
11,20,28,18,6,42,50,44,8,8,72,57,22,35,42,21,
32,51,45,41,22,22,50,65,83,0,0,2,0,60,0,0,
4,17,6,14,0,8,0,47,0,127,187,0,6,0,4,0,
21,0,4,43,184,0,6,16,184,0,32,208,0,184,0,31,
47,184,0,0,69,88,184,0,33,47,27,185,0,33,0,9,
62,89,184,0,0,69,88,184,0,37,47,27,185,0,37,0,
9,62,89,184,0,0,69,88,184,0,39,47,27,185,0,39,
0,9,62,89,184,0,0,69,88,184,0,14,47,27,185,0,
14,0,5,62,89,184,0,37,16,185,0,0,0,2,252,186,
0,6,0,14,0,31,17,18,57,184,0,7,208,184,0,14,
16,185,0,42,0,2,252,48,49,1,34,14,2,7,17,1,
33,1,20,14,2,7,33,53,62,3,53,17,52,46,2,39,
53,62,1,55,23,17,30,2,51,50,51,33,23,1,33,50,
54,55,23,1,221,16,33,31,27,10,1,227,254,146,2,52,
2,3,4,3,252,55,43,58,34,15,12,32,54,42,72,120,
62,36,15,30,33,20,21,26,2,0,22,253,211,1,166,25,
42,23,47,3,72,12,33,59,46,253,226,2,180,253,176,32,
72,68,58,18,43,7,15,15,16,8,4,168,45,50,25,9,
5,40,14,34,32,34,253,190,3,3,2,43,252,227,77,91,
10,0,0,2,0,20,255,226,3,236,4,214,0,40,0,81,
0,0,1,14,3,7,3,14,3,7,11,1,14,3,7,3,
38,39,53,33,21,14,2,22,23,27,1,51,27,1,54,38,
39,53,51,21,17,14,3,7,3,14,3,7,11,1,14,3,
7,3,38,39,53,33,21,14,2,22,23,27,1,51,27,1,
54,38,39,53,51,21,3,236,22,26,14,6,2,145,5,30,
37,35,9,156,134,5,30,35,34,9,174,6,70,1,14,34,
35,13,2,3,121,163,68,172,111,5,29,48,228,22,26,14,
6,2,145,5,30,37,35,9,156,134,5,30,35,34,9,174,
6,70,1,14,34,35,13,2,3,121,163,68,172,111,5,29,
48,228,1,254,4,7,9,10,7,254,62,13,19,12,7,2,
1,138,254,171,14,18,12,7,2,1,247,23,14,36,36,3,
8,10,10,6,254,151,1,178,254,78,1,105,14,16,7,36,
36,2,180,4,7,9,10,7,254,62,13,19,12,7,2,1,
138,254,171,14,18,12,7,2,1,247,23,14,36,36,3,8,
10,10,6,254,151,1,178,254,78,1,105,14,16,7,36,36,
0,2,0,160,255,226,3,146,3,162,0,18,0,37,0,0,
1,14,1,7,39,17,62,1,55,33,23,17,14,1,7,39,
17,33,21,17,14,1,7,39,17,62,1,55,33,23,17,14,
1,7,39,17,33,21,1,32,18,48,26,36,20,42,27,2,
122,31,19,44,29,36,254,14,18,48,26,36,20,42,27,2,
122,31,19,44,29,36,254,14,2,69,18,40,14,31,1,63,
19,37,15,34,254,197,21,43,8,31,1,6,221,253,229,18,
40,14,31,1,63,19,37,15,34,254,197,21,43,8,31,1,
6,221,0,1,0,39,2,108,3,2,6,14,0,48,0,17,
0,187,0,38,0,2,0,8,0,4,43,184,0,38,16,48,
49,1,53,62,1,53,17,52,38,35,34,6,7,17,20,22,
23,21,33,53,62,1,53,17,52,46,2,39,53,62,1,55,
23,17,62,3,51,50,22,21,17,20,30,2,23,21,1,213,
51,37,43,47,41,114,60,42,46,254,211,46,41,2,16,35,
34,60,86,41,26,30,70,71,67,27,76,89,7,19,35,27,
2,108,36,11,17,8,1,42,73,55,84,85,254,255,9,19,
8,36,36,11,15,10,2,185,25,28,16,7,3,34,10,21,
17,20,254,22,38,59,39,20,73,68,254,149,4,7,9,10,
6,36,0,1,0,39,2,108,3,2,6,14,0,66,0,29,
0,187,0,34,0,2,0,39,0,4,43,184,0,34,16,184,
0,39,16,184,0,47,208,184,0,47,47,48,49,1,53,62,
1,53,17,52,46,2,35,34,6,7,17,20,22,23,21,33,
53,62,1,53,17,52,62,2,55,62,3,51,50,30,2,21,
20,14,2,7,46,1,35,34,14,2,29,1,62,3,51,50,
22,21,17,20,22,23,21,1,213,51,37,14,24,33,19,41,
114,60,42,46,254,211,46,41,24,44,62,39,21,47,48,45,
18,28,61,51,32,23,32,34,10,32,75,43,23,50,44,28,
30,70,71,67,27,69,86,43,55,2,108,36,11,17,8,1,
42,36,46,26,10,75,84,254,255,9,19,8,36,36,11,15,
10,1,201,74,107,80,59,26,14,21,13,7,20,26,25,6,
5,22,24,21,4,31,38,25,63,111,85,142,38,59,39,20,
73,68,254,149,8,16,12,36,0,2,255,88,1,64,1,10,
5,160,0,15,0,55,0,0,1,20,14,2,35,34,38,53,
52,62,2,51,50,22,3,20,14,2,7,14,1,35,34,46,
2,53,52,62,2,55,30,1,51,50,62,2,53,17,52,53,
52,46,1,39,53,62,1,55,51,17,1,10,14,25,33,19,
35,34,14,25,33,19,34,35,21,21,36,48,28,38,91,35,
21,42,33,20,20,29,30,10,23,47,26,20,37,28,17,14,
37,36,58,85,44,26,5,93,19,34,25,15,36,32,19,34,
25,14,35,253,42,69,96,68,47,19,26,34,9,13,14,5,
5,23,24,21,4,17,10,22,53,91,69,1,110,31,18,19,
21,10,3,34,9,23,16,253,251,0,0,1,0,39,2,108,
2,33,4,172,0,44,0,0,1,22,14,2,7,35,46,1,
35,34,14,2,7,21,20,30,2,23,21,33,53,62,1,53,
17,52,54,39,46,1,39,53,62,1,55,31,1,62,1,51,
50,22,2,27,6,1,10,16,9,40,8,34,26,15,38,40,
40,16,9,24,42,33,254,191,46,41,1,7,9,34,38,45,
98,35,24,9,38,90,61,23,51,4,150,3,39,49,51,16,
48,38,19,44,70,51,226,5,9,9,9,4,36,36,9,17,
10,1,74,39,32,5,8,6,2,34,10,21,17,21,126,67,
80,9,0,1,0,39,2,90,2,34,4,172,0,45,0,0,
19,38,62,2,55,51,30,1,51,50,62,2,55,53,52,46,
2,39,53,62,1,55,23,17,20,22,23,30,3,23,21,14,
1,7,47,1,14,1,35,34,38,46,7,1,11,16,9,30,
8,43,26,16,38,40,39,17,8,24,44,36,50,114,51,22,
10,6,5,9,15,23,20,45,98,35,24,10,38,90,60,23,
51,2,112,3,38,50,51,16,48,38,19,44,70,51,154,27,
33,20,8,2,33,6,19,14,18,254,110,39,32,5,4,6,
3,2,1,34,10,21,17,21,126,67,80,9,0,1,0,39,
1,64,2,234,4,172,0,57,0,0,1,22,14,2,35,34,
46,2,61,1,14,1,35,34,38,39,38,62,2,55,51,30,
1,51,50,62,2,55,53,52,46,2,39,53,62,1,55,23,
17,20,22,51,50,62,2,39,38,62,2,31,1,2,232,2,
39,71,96,55,46,59,34,13,38,89,60,23,51,26,7,1,
11,16,9,30,8,43,26,16,38,40,39,17,6,22,45,40,
55,113,48,22,36,43,16,29,18,3,9,2,34,47,46,11,
14,1,223,23,55,48,33,30,49,62,33,253,66,79,9,13,
3,38,50,51,16,48,38,19,44,70,51,154,25,32,20,10,
3,33,6,19,14,18,253,120,69,74,14,21,27,13,3,14,
14,10,1,23,0,2,0,35,2,90,2,180,4,172,0,46,
0,58,0,51,187,0,0,0,3,0,37,0,4,43,0,186,
0,9,0,1,0,3,43,184,0,9,16,187,0,0,0,1,
0,6,0,4,43,184,0,0,16,184,0,6,16,184,0,44,
208,184,0,44,47,48,49,19,23,17,62,1,51,55,62,1,
51,50,30,2,23,7,46,1,14,1,15,1,30,3,21,20,
14,2,35,34,38,39,55,22,23,17,52,46,2,39,53,62,
1,19,62,1,53,52,38,35,34,35,34,7,21,232,20,8,
12,5,195,9,36,18,13,36,42,45,21,7,22,33,26,22,
10,181,48,81,59,32,39,79,119,79,76,122,62,6,44,41,
2,17,35,33,49,104,93,100,98,109,95,11,5,5,6,4,
172,23,254,255,1,1,241,11,14,4,6,8,5,35,1,3,
2,9,9,196,5,23,37,52,35,31,58,44,27,16,11,50,
6,3,1,108,29,33,17,6,3,34,5,21,253,248,2,45,
42,59,49,2,195,0,0,1,0,9,2,90,3,235,4,154,
0,40,0,0,1,14,3,7,3,14,3,7,11,1,14,3,
7,3,38,39,53,33,21,14,2,22,23,27,1,51,27,1,
54,38,39,53,51,21,3,235,22,26,14,6,2,145,5,32,
38,37,9,156,134,5,32,37,35,9,174,6,70,1,19,34,
35,13,2,3,121,163,73,172,111,5,29,48,228,4,118,4,
7,9,10,7,254,62,13,19,12,7,2,1,138,254,171,14,
18,12,7,2,1,247,23,14,36,36,3,8,10,10,6,254,
151,1,178,254,78,1,105,14,16,7,36,36,0,1,255,223,
1,64,2,180,4,154,0,49,0,0,1,14,3,7,3,14,
3,35,34,38,53,52,62,2,55,30,1,55,62,3,63,1,
3,46,1,39,53,33,21,14,3,23,27,1,54,46,2,39,
53,51,2,180,21,27,16,9,4,228,29,73,78,81,37,54,
68,17,25,29,11,33,67,26,13,34,36,32,11,14,228,7,
36,35,1,19,27,32,14,1,5,162,152,4,2,15,31,26,
233,4,118,4,7,9,12,9,253,238,66,95,61,29,21,11,
3,25,30,27,6,17,2,8,4,22,35,45,27,34,1,246,
17,17,7,36,36,3,6,9,13,10,254,150,1,106,9,13,
9,7,3,36,0,1,0,40,3,206,1,125,6,5,0,12,
0,7,0,184,0,11,47,48,49,19,46,3,39,19,62,3,
55,23,93,8,12,12,12,9,136,16,44,48,47,19,31,3,
206,2,5,8,10,8,1,229,6,13,14,11,5,35,255,255,
0,40,3,206,2,199,6,5,0,39,2,118,1,74,0,0,
0,6,2,118,0,0,255,255,0,113,4,44,1,151,5,227,
0,7,2,175,2,240,0,0,0,1,0,80,4,36,1,118,
5,219,0,22,0,0,1,14,1,7,39,62,1,55,54,46,
2,35,39,62,3,23,30,3,1,116,5,89,97,39,42,44,
3,2,14,34,55,39,11,8,53,65,61,16,27,36,21,7,
5,48,69,138,61,33,38,80,46,27,48,36,22,42,10,24,
20,13,2,12,36,45,51,0,255,255,0,84,4,36,1,118,
5,217,0,7,2,177,2,228,0,0,0,1,0,82,4,40,
1,53,5,184,0,17,0,11,0,186,0,0,0,10,0,3,
43,48,49,19,54,30,2,21,20,14,2,39,55,22,54,53,
52,38,7,86,48,81,60,34,36,61,83,47,6,66,73,73,
72,5,178,6,27,53,76,43,44,76,54,27,4,84,5,64,
54,54,64,5,0,1,0,79,4,42,1,50,5,186,0,17,
0,15,0,186,0,10,0,0,0,3,43,184,0,10,16,48,
49,1,6,46,2,53,52,62,2,23,7,38,6,21,20,22,
55,1,46,48,81,60,34,35,62,83,47,6,66,73,73,72,
4,48,6,27,53,75,44,44,76,54,27,4,84,5,64,54,
54,64,5,0,0,1,0,32,3,44,2,93,6,14,0,47,
0,0,19,53,52,62,4,53,52,46,2,35,34,14,2,21,
20,22,23,14,1,7,39,38,53,52,53,52,62,2,51,50,
30,2,21,20,14,4,29,1,249,34,52,59,52,34,29,48,
64,35,24,49,39,25,5,3,23,68,32,19,1,53,90,118,
65,58,92,63,34,34,52,59,52,34,3,44,106,46,77,67,
60,59,60,35,37,59,42,22,20,33,44,23,9,18,8,10,
10,3,18,5,5,5,5,42,76,57,33,31,55,73,42,44,
71,60,55,59,66,41,141,0,0,1,0,18,3,44,2,79,
6,14,0,37,0,0,19,53,52,46,4,53,52,62,2,51,
50,22,23,14,3,35,46,1,35,34,14,2,21,20,30,4,
29,1,249,34,52,59,52,34,51,85,109,58,123,137,10,2,
28,39,44,17,2,97,79,27,51,39,23,34,52,59,52,34,
3,44,86,41,71,64,62,65,71,41,55,88,62,32,105,87,
5,13,12,8,77,85,21,39,57,37,35,61,61,61,68,78,
46,106,0,1,0,60,3,137,2,169,5,140,0,35,0,0,
1,14,1,7,37,39,52,55,62,1,55,52,55,54,55,52,
55,52,55,52,55,62,1,55,54,53,52,55,37,23,14,1,
7,13,1,23,2,169,17,25,25,253,234,20,1,2,3,2,
1,2,2,2,2,2,1,1,1,1,1,2,65,20,4,14,
5,254,69,1,197,13,3,190,17,21,15,200,19,3,2,6,
13,7,3,1,8,5,3,4,2,4,2,4,3,4,2,1,
1,1,1,216,20,17,48,15,165,168,29,0,0,1,0,60,
3,137,2,169,5,140,0,23,0,0,1,14,1,7,6,7,
14,1,7,5,39,62,3,55,45,1,39,62,1,55,5,23,
2,169,3,7,5,2,1,2,3,2,253,192,20,3,6,6,
6,3,1,185,254,60,13,18,35,14,2,24,18,4,176,11,
29,14,6,2,5,9,4,215,20,8,21,22,21,7,164,168,
32,14,26,12,200,20,0,1,0,40,3,118,2,88,5,156,
0,18,0,0,1,14,1,7,39,11,1,14,3,7,39,19,
62,3,55,2,88,15,45,22,23,191,160,7,24,27,25,6,
15,226,8,22,24,23,9,3,163,12,25,8,17,1,117,254,
167,6,14,12,10,3,17,1,221,7,17,15,13,4,0,1,
0,40,3,118,2,88,5,156,0,18,0,0,19,62,1,55,
23,27,1,62,3,55,23,3,14,3,7,40,15,45,22,23,
191,160,7,24,27,25,6,15,226,8,22,24,23,9,5,111,
12,25,8,17,254,139,1,89,6,14,12,10,3,17,254,35,
8,16,15,13,4,0,0,1,0,150,4,66,1,14,6,114,
0,12,0,0,1,14,1,7,39,17,62,3,55,23,17,1,
14,20,55,20,25,9,24,25,25,10,27,4,97,10,16,5,
22,1,252,4,8,9,7,2,24,254,7,0,0,1,0,167,
4,151,3,75,5,25,0,14,0,0,1,14,3,7,33,39,
62,3,55,33,23,3,75,2,10,12,11,4,253,153,22,2,
10,12,12,5,2,101,22,5,1,11,29,29,28,9,25,11,
28,29,27,10,24,0,255,255,0,217,4,23,2,107,5,209,
2,6,0,111,0,0,255,255,0,30,4,23,1,182,5,209,
2,6,0,64,0,0,255,255,0,150,255,47,1,14,1,95,
2,7,2,131,0,0,250,237,255,255,0,167,255,52,3,75,
255,182,2,7,0,108,0,0,250,157,0,1,0,70,254,99,
2,72,255,205,0,11,0,11,0,184,0,3,47,184,0,10,
47,48,49,1,14,1,7,37,55,62,3,55,1,2,72,14,
15,16,254,43,8,7,31,36,34,11,1,131,254,144,19,19,
7,243,45,8,20,21,19,6,254,195,0,1,0,70,254,99,
2,72,255,205,0,10,0,11,0,184,0,0,47,184,0,4,
47,48,49,19,46,1,39,1,30,3,31,1,115,17,15,13,
1,131,10,34,36,30,8,9,254,99,7,19,19,1,61,6,
19,21,20,8,45,0,0,2,0,110,0,0,1,166,3,162,
0,2,0,5,0,0,1,19,33,19,3,33,1,10,156,254,
200,156,156,1,56,1,55,254,201,2,107,1,55,0,0,1,
0,110,2,107,1,166,3,162,0,2,0,0,1,3,33,1,
10,156,1,56,2,107,1,55,255,255,0,82,255,55,1,53,
0,199,0,7,2,214,2,149,1,49,255,255,0,79,255,57,
1,50,0,201,0,7,2,185,2,217,1,49,255,255,0,70,
255,76,1,234,0,170,0,7,2,186,3,27,1,44,255,255,
0,70,255,56,1,234,0,150,0,7,2,187,3,27,1,44,
255,255,0,70,255,56,1,234,0,200,0,7,2,188,3,27,
1,44,255,255,0,70,255,211,2,18,0,45,0,7,2,189,
3,47,1,44,0,1,255,51,2,74,1,32,3,192,0,32,
0,7,0,184,0,15,47,48,49,19,14,1,7,6,22,55,
62,1,55,23,14,3,35,34,46,2,53,52,54,55,14,3,
7,39,62,1,55,170,40,25,1,1,27,27,20,53,46,12,
36,56,47,40,19,13,28,23,15,9,8,17,47,54,59,28,
28,121,167,59,3,170,55,88,28,37,40,1,1,14,22,43,
27,38,24,10,13,28,46,33,23,40,17,3,15,22,28,16,
78,45,87,48,255,255,0,70,4,33,2,155,5,162,0,7,
2,218,3,117,0,0,0,2,0,9,1,64,2,180,4,154,
0,16,0,67,0,0,1,14,3,21,20,22,51,50,54,53,
52,46,2,39,1,14,3,7,3,23,30,3,21,20,14,2,
35,34,46,2,53,52,62,2,63,1,3,46,1,39,53,33,
21,14,2,22,23,27,1,62,1,46,1,39,53,51,21,1,
88,22,27,15,5,45,27,27,32,2,9,20,18,1,79,21,
26,16,9,5,201,41,20,28,17,8,21,46,72,51,35,58,
43,24,6,15,26,20,54,212,8,35,35,1,19,27,30,13,
2,5,148,153,5,1,13,30,26,233,2,125,39,55,39,26,
9,43,32,39,28,14,28,34,46,32,2,15,4,8,9,11,
9,254,167,72,36,55,46,44,24,22,55,49,33,19,34,48,
29,15,32,40,53,35,93,1,127,16,18,7,36,36,3,7,
9,13,9,254,248,1,8,9,13,9,7,3,36,36,0,1,
0,42,2,108,1,101,6,14,0,22,0,0,19,53,62,3,
53,17,52,46,2,39,53,62,1,55,23,17,20,22,23,21,
42,30,38,20,7,6,18,35,29,51,93,44,25,38,57,2,
108,36,4,9,9,9,5,2,184,27,29,15,6,3,34,8,
20,20,20,252,186,9,19,8,36,0,0,1,0,56,2,90,
1,244,4,172,0,65,0,0,1,20,14,4,35,34,38,39,
46,1,62,1,55,23,30,3,51,50,54,53,52,46,2,39,
46,3,53,52,62,2,51,50,30,2,23,22,14,2,7,39,
46,1,35,34,6,21,20,30,2,23,30,3,1,244,28,45,
56,56,50,16,41,97,47,5,3,2,6,5,40,1,31,49,
62,32,43,57,26,43,58,32,29,58,46,29,35,60,79,44,
26,56,53,45,14,4,6,13,16,4,37,34,72,35,38,50,
23,40,53,29,30,65,52,34,3,22,43,60,42,25,14,4,
21,23,2,35,47,46,14,7,25,41,30,16,43,42,24,34,
27,24,14,13,31,39,48,30,37,59,39,21,7,12,17,10,
3,26,30,27,4,5,43,24,37,25,20,29,24,24,13,13,
32,40,52,0,0,1,0,14,2,108,2,199,4,154,0,51,
0,0,1,53,62,2,38,47,1,7,6,30,2,23,21,33,
53,62,3,63,1,39,46,3,39,53,33,21,14,1,31,1,
55,54,38,39,53,33,21,14,1,15,1,23,30,1,23,21,
1,169,17,28,14,3,14,128,118,14,3,20,32,17,254,247,
28,39,28,18,8,160,159,9,19,26,37,28,1,43,44,26,
25,104,97,24,23,43,1,11,57,62,19,140,180,17,49,46,
2,108,36,1,5,11,19,17,146,146,17,19,11,5,1,36,
36,3,12,15,17,9,193,183,11,19,13,9,2,36,36,4,
20,29,120,120,29,20,4,36,36,4,27,23,170,206,17,34,
5,36,0,1,0,18,2,108,2,79,6,14,0,45,0,0,
19,53,62,1,61,1,52,46,4,53,52,62,2,51,50,22,
23,14,3,35,46,1,35,34,14,2,21,20,30,4,29,1,
20,22,23,21,140,57,52,34,52,59,52,34,51,85,109,58,
123,137,10,2,28,39,44,17,2,97,79,27,51,39,23,34,
52,59,52,34,49,60,2,108,36,8,19,9,206,41,71,64,
62,65,71,41,55,88,62,32,105,87,5,13,12,8,77,85,
21,39,57,37,35,61,61,61,68,78,46,226,10,17,9,36,
255,255,0,40,254,239,2,88,1,21,2,7,2,130,0,0,
251,121,255,255,0,167,4,112,3,75,6,9,2,39,0,108,
0,0,0,240,0,6,0,108,0,217,255,255,0,80,4,36,
3,6,5,219,0,39,2,176,2,241,0,0,0,7,2,176,
4,129,0,0,0,1,253,41,4,23,254,193,5,209,0,11,
0,7,0,184,0,3,47,48,49,1,14,1,7,1,55,62,
3,55,19,254,193,13,26,17,254,160,22,10,39,43,42,12,
240,4,54,12,14,5,1,121,41,3,7,8,5,1,254,101,
0,1,253,125,4,23,255,15,5,209,0,10,0,7,0,184,
0,0,47,48,49,1,46,1,39,19,30,3,31,1,253,182,
18,28,11,234,12,39,43,40,11,23,4,23,3,16,9,1,
158,1,5,6,8,3,39,0,0,1,252,193,4,23,255,58,
5,191,0,13,0,11,0,184,0,3,47,184,0,5,47,48,
49,3,14,1,7,9,1,46,3,39,1,51,1,198,12,14,
17,254,238,254,241,8,11,9,10,7,1,8,107,1,6,4,
68,19,18,8,1,12,254,244,4,8,10,14,9,1,123,254,
133,0,0,1,252,168,4,89,255,82,5,89,0,28,0,0,
3,14,3,35,34,46,2,35,34,6,7,39,62,3,51,50,
30,2,51,50,54,55,23,174,18,50,61,72,39,35,63,60,
59,29,40,66,37,53,18,49,62,71,39,38,68,60,54,24,
38,73,34,54,5,66,41,80,64,40,35,43,35,65,56,20,
41,81,64,40,35,43,35,64,59,23,0,1,252,171,4,151,
255,79,5,25,0,14,0,0,3,14,3,7,33,39,62,3,
55,33,23,177,2,10,12,11,4,253,153,22,2,10,12,12,
5,2,101,22,5,1,11,29,29,28,9,25,11,28,29,27,
10,24,0,1,251,252,4,151,0,64,5,25,0,14,0,0,
19,14,3,7,33,39,62,3,55,33,23,64,2,10,12,11,
4,251,249,22,2,10,12,12,5,4,5,22,5,1,11,29,
29,28,9,25,11,28,29,27,10,24,0,1,252,184,4,46,
255,66,5,125,0,25,0,25,0,184,0,13,47,184,0,23,
47,187,0,18,0,2,0,5,0,4,43,184,0,18,16,48,
49,3,14,3,35,34,46,2,39,62,1,55,30,3,51,50,
62,2,55,30,1,190,30,75,83,90,45,49,92,83,73,30,
12,24,17,25,65,72,75,33,35,77,73,65,24,17,24,5,
80,81,110,69,30,30,69,110,81,18,19,8,57,78,47,21,
21,47,78,57,8,19,0,1,253,153,4,100,254,97,5,76,
0,14,0,66,187,0,0,0,4,0,8,0,4,43,65,19,
0,6,0,0,0,22,0,0,0,38,0,0,0,54,0,0,
0,70,0,0,0,86,0,0,0,102,0,0,0,118,0,0,
0,134,0,0,0,9,93,65,5,0,149,0,0,0,165,0,
0,0,2,93,48,49,1,20,14,2,35,34,38,53,52,62,
2,51,50,254,97,18,31,42,25,45,39,18,32,41,24,85,
4,237,28,50,37,22,50,46,28,50,37,21,0,2,252,209,
4,100,255,41,5,76,0,14,0,29,0,146,184,0,30,47,
184,0,31,47,184,0,0,220,185,0,8,0,4,252,65,5,
0,154,0,8,0,170,0,8,0,2,93,65,19,0,9,0,
8,0,25,0,8,0,41,0,8,0,57,0,8,0,73,0,
8,0,89,0,8,0,105,0,8,0,121,0,8,0,137,0,
8,0,9,93,184,0,30,16,184,0,23,208,184,0,23,47,
185,0,15,0,4,252,65,19,0,6,0,15,0,22,0,15,
0,38,0,15,0,54,0,15,0,70,0,15,0,86,0,15,
0,102,0,15,0,118,0,15,0,134,0,15,0,9,93,65,
5,0,149,0,15,0,165,0,15,0,2,93,48,49,3,20,
14,2,35,34,38,53,52,62,2,51,50,5,20,14,2,35,
34,38,53,52,62,2,51,50,215,18,31,42,25,45,39,18,
32,41,24,85,254,112,18,31,42,25,45,39,18,32,41,24,
85,4,237,28,50,37,22,50,46,28,50,37,21,95,28,50,
37,22,50,46,28,50,37,21,0,1,253,83,4,46,254,162,
5,163,0,44,0,0,1,20,14,3,22,23,14,1,7,46,
2,62,4,53,52,38,35,34,14,2,21,20,22,23,14,3,
7,39,53,52,62,2,51,50,22,254,162,37,50,47,22,19,
42,14,32,15,45,43,9,19,34,42,36,25,38,29,15,25,
18,10,5,3,8,25,29,28,10,11,38,59,72,35,63,68,
5,53,27,44,39,35,37,40,25,10,4,2,22,37,32,28,
27,26,28,31,18,38,38,11,18,22,11,5,11,5,3,7,
6,5,1,11,13,24,46,36,23,60,0,2,253,67,4,26,
254,183,5,160,0,19,0,39,0,155,184,0,40,47,184,0,
41,47,184,0,20,220,185,0,0,0,3,252,65,5,0,154,
0,0,0,170,0,0,0,2,93,65,19,0,9,0,0,0,
25,0,0,0,41,0,0,0,57,0,0,0,73,0,0,0,
89,0,0,0,105,0,0,0,121,0,0,0,137,0,0,0,
9,93,184,0,40,16,184,0,30,208,184,0,30,47,185,0,
10,0,3,252,65,19,0,6,0,10,0,22,0,10,0,38,
0,10,0,54,0,10,0,70,0,10,0,86,0,10,0,102,
0,10,0,118,0,10,0,134,0,10,0,9,93,65,5,0,
149,0,10,0,165,0,10,0,2,93,0,184,0,25,47,184,
0,35,220,48,49,1,52,46,2,35,34,14,2,21,20,30,
2,51,50,62,2,55,20,14,2,35,34,46,2,53,52,62,
2,51,50,30,2,254,93,12,22,32,20,21,38,29,18,12,
22,32,20,20,38,30,18,90,39,63,77,38,34,57,41,23,
39,62,77,39,32,57,42,24,4,219,24,44,33,20,17,31,
44,27,23,43,33,20,15,30,43,70,51,85,63,35,24,42,
56,32,51,87,63,35,25,43,57,0,0,2,253,48,4,23,
255,144,5,209,0,10,0,21,0,11,0,184,0,0,47,184,
0,11,47,48,49,1,46,1,39,19,30,3,31,1,19,46,
1,39,19,30,3,31,1,253,105,17,20,20,176,12,33,33,
31,10,22,31,19,20,18,176,12,32,33,31,11,22,4,23,
4,11,12,1,159,2,5,7,7,4,41,254,136,4,11,12,
1,159,2,5,7,7,4,41,0,1,252,193,4,47,255,58,
5,195,0,12,0,15,0,184,0,0,47,184,0,2,47,184,
0,12,47,48,49,1,35,1,62,3,55,5,37,30,1,23,
254,52,107,254,248,7,10,9,11,8,1,19,1,14,17,14,
12,4,47,1,101,10,14,10,8,5,251,251,9,18,20,0,
0,1,253,188,4,36,254,42,5,200,0,10,0,0,1,14,
1,7,39,17,62,1,55,23,17,254,42,20,45,20,25,17,
46,20,27,4,67,10,16,5,22,1,112,8,17,5,24,254,
147,0,0,2,253,58,4,36,254,172,5,200,0,10,0,21,
0,0,1,14,1,7,39,17,62,1,55,23,17,33,14,1,
7,39,17,62,1,55,23,17,254,172,20,45,20,25,17,46,
20,27,254,252,20,45,20,25,17,46,20,27,4,67,10,16,
5,22,1,112,8,17,5,24,254,147,10,16,5,22,1,112,
8,17,5,24,254,147,0,2,252,104,4,23,254,200,5,209,
0,10,0,21,0,11,0,184,0,10,47,184,0,21,47,48,
49,1,55,62,3,55,19,14,1,7,1,55,62,3,55,19,
14,1,7,253,139,22,10,31,33,33,12,176,20,20,17,253,
217,22,11,30,33,33,12,176,18,20,19,5,143,41,4,7,
7,5,2,254,97,12,11,4,1,120,41,4,7,7,5,2,
254,97,12,11,4,0,0,2,252,184,4,46,255,66,5,246,
0,14,0,40,0,29,0,184,0,8,47,184,0,28,47,184,
0,38,47,187,0,33,0,2,0,20,0,4,43,184,0,33,
16,48,49,1,20,14,2,35,34,38,53,52,62,2,51,50,
23,14,3,35,34,46,2,39,62,1,55,30,3,51,50,62,
2,55,30,1,254,84,15,27,37,22,38,35,16,27,36,21,
74,238,30,75,83,90,45,49,92,83,73,30,12,24,17,25,
65,72,75,33,35,77,73,65,24,17,24,5,163,24,44,32,
19,43,41,25,43,32,18,166,81,110,69,30,30,69,110,81,
18,19,8,57,78,47,21,21,47,78,57,8,19,0,0,1,
252,184,4,36,255,66,5,115,0,25,0,0,1,62,3,51,
50,30,2,23,14,1,7,46,3,35,34,14,2,7,46,1,
252,184,30,75,83,90,45,49,92,83,73,30,12,24,17,25,
65,72,75,33,35,77,73,65,24,17,24,4,81,81,110,69,
30,30,69,110,81,18,19,8,57,78,47,21,21,47,78,57,
8,19,0,1,253,129,4,44,254,167,5,227,0,22,0,0,
1,62,1,55,23,14,1,7,6,30,2,51,23,14,3,39,
46,3,253,131,5,89,97,39,42,44,3,2,14,34,55,39,
11,8,53,65,61,16,27,36,21,7,4,215,69,138,61,33,
38,80,46,27,48,36,22,42,10,24,20,13,2,12,36,45,
50,0,0,1,253,95,4,36,254,133,5,219,0,22,0,0,
1,14,1,7,39,62,1,55,54,46,2,35,39,62,3,23,
30,3,254,131,5,89,97,39,42,44,3,2,14,34,55,39,
11,8,53,65,61,16,27,36,21,7,5,48,69,138,61,33,
38,80,46,27,48,36,22,42,10,24,20,13,2,12,36,45,
51,0,0,1,253,112,4,36,254,146,5,217,0,22,0,7,
0,184,0,11,47,48,49,1,38,62,2,55,54,30,2,23,
7,14,3,23,30,1,23,7,46,1,253,114,2,7,20,35,
26,17,51,55,56,23,12,47,55,29,8,2,3,47,48,39,
98,93,5,17,27,56,52,46,18,1,7,13,18,9,41,9,
37,47,49,21,46,70,37,33,40,114,0,1,255,153,4,36,
0,191,5,219,0,22,0,0,19,14,1,7,39,62,1,55,
54,46,2,35,39,62,3,23,30,3,189,5,89,97,39,42,
44,3,2,14,34,55,39,11,8,53,65,61,16,27,36,21,
7,5,48,69,138,61,33,38,80,46,27,48,36,22,42,10,
24,20,13,2,12,36,45,51,0,1,252,254,254,9,255,0,
255,115,0,11,0,11,0,184,0,3,47,184,0,10,47,48,
49,1,14,1,7,37,55,62,3,55,1,255,0,14,15,16,
254,43,8,7,31,36,34,11,1,131,254,54,19,19,7,243,
45,8,20,21,19,6,254,195,0,1,253,48,254,9,255,50,
255,115,0,10,0,11,0,184,0,0,47,184,0,4,47,48,
49,1,46,1,39,1,30,3,31,1,253,93,17,15,13,1,
131,10,34,36,30,8,9,254,9,7,19,19,1,61,6,19,
21,20,8,45,0,1,253,83,254,12,254,167,255,156,0,17,
0,0,1,14,1,7,39,53,35,39,62,1,55,51,53,62,
1,55,23,17,254,167,20,25,20,25,227,23,6,12,11,221,
17,26,20,27,254,43,12,13,6,22,133,24,20,26,20,125,
10,14,6,24,254,167,0,1,253,83,254,12,254,168,255,156,
0,17,0,0,1,14,1,7,39,17,62,1,55,23,21,51,
23,14,1,7,35,21,253,173,20,25,20,25,17,26,20,27,
226,25,5,13,9,224,254,43,12,13,6,22,1,92,10,14,
6,24,131,27,20,26,17,124,0,1,252,246,4,36,255,9,
5,165,0,13,0,0,3,14,1,7,39,53,33,39,62,1,
55,33,23,17,247,20,45,20,25,254,113,22,9,30,17,1,
197,22,4,87,17,28,6,22,253,25,20,45,20,24,254,202,
0,1,254,188,2,198,0,70,4,121,0,17,0,21,0,184,
0,15,47,184,0,6,47,186,0,14,0,6,0,15,17,18,
57,48,49,19,20,14,2,7,39,62,3,53,52,38,39,55,
30,1,70,34,85,145,112,18,59,84,54,25,30,28,178,23,
29,4,18,29,80,89,92,42,62,22,51,51,47,18,29,52,
23,80,22,52,0,1,253,118,254,8,254,89,255,152,0,17,
0,24,0,184,0,0,69,88,184,0,0,47,27,185,0,0,
0,7,62,89,184,0,10,220,48,49,1,6,46,2,53,52,
62,2,23,7,38,6,21,20,22,55,254,85,48,81,60,34,
35,62,83,47,6,66,73,73,72,254,14,6,27,53,75,44,
44,76,54,27,4,84,5,64,54,54,64,5,0,1,253,43,
254,32,254,207,255,126,0,17,0,0,1,14,1,7,33,39,
62,1,55,51,53,62,1,55,23,21,51,23,254,207,5,13,
9,254,142,23,6,12,11,136,17,26,20,27,140,25,254,95,
20,26,17,24,20,26,20,230,10,14,6,24,236,27,0,1,
253,43,254,12,254,207,255,106,0,17,0,0,1,14,1,7,
39,53,35,39,62,1,55,33,23,14,1,7,35,21,254,42,
20,25,20,25,142,23,6,12,11,1,110,25,5,13,9,138,
254,43,12,13,6,22,238,24,20,26,20,27,20,26,17,229,
0,1,253,43,254,12,254,207,255,156,0,24,0,0,1,14,
1,7,39,53,35,39,62,1,55,51,53,62,1,55,23,21,
51,23,14,1,7,35,21,254,42,20,25,20,25,142,23,6,
12,11,136,17,26,20,27,140,25,5,13,9,138,254,43,12,
13,6,22,133,24,20,26,20,125,10,14,6,24,131,27,20,
26,17,124,0,0,1,253,23,254,167,254,227,255,1,0,10,
0,0,1,14,1,7,33,39,62,1,55,33,23,254,227,5,
13,9,254,102,23,6,12,11,1,150,25,254,230,20,26,17,
24,20,26,20,27,0,0,1,255,106,254,12,1,25,0,56,
0,31,0,0,5,22,14,2,35,34,38,53,17,50,62,2,
55,21,20,30,2,51,50,62,1,38,39,38,62,2,31,1,
1,22,3,32,65,93,58,84,99,1,27,33,27,2,12,24,
36,25,29,36,14,8,15,3,39,56,59,15,19,235,38,92,
81,54,122,131,1,15,8,11,11,2,252,61,81,48,19,31,
43,49,18,4,24,25,17,2,39,0,0,1,254,10,254,12,
255,196,0,50,0,32,0,0,1,62,3,55,30,1,23,6,
30,2,51,50,62,2,61,1,62,1,55,21,20,14,2,35,
34,46,2,254,15,9,33,39,40,16,4,14,5,17,6,29,
42,20,25,39,28,15,27,40,23,47,72,86,38,43,75,53,
28,254,225,10,28,26,23,6,5,14,8,45,69,46,24,19,
48,81,61,212,9,14,11,217,107,131,71,24,35,58,78,0,
0,1,253,153,254,96,254,97,255,72,0,14,0,66,187,0,
0,0,4,0,8,0,4,43,65,19,0,6,0,0,0,22,
0,0,0,38,0,0,0,54,0,0,0,70,0,0,0,86,
0,0,0,102,0,0,0,118,0,0,0,134,0,0,0,9,
93,65,5,0,149,0,0,0,165,0,0,0,2,93,48,49,
1,20,14,2,35,34,38,53,52,62,2,51,50,254,97,18,
31,42,25,45,39,18,32,41,24,85,254,233,28,50,37,22,
50,46,28,50,37,21,0,2,252,209,254,96,255,41,255,72,
0,14,0,29,0,175,184,0,30,47,184,0,31,47,184,0,
0,220,185,0,8,0,4,252,65,5,0,154,0,8,0,170,
0,8,0,2,93,65,19,0,9,0,8,0,25,0,8,0,
41,0,8,0,57,0,8,0,73,0,8,0,89,0,8,0,
105,0,8,0,121,0,8,0,137,0,8,0,9,93,184,0,
30,16,184,0,23,208,184,0,23,47,185,0,15,0,4,252,
65,19,0,6,0,15,0,22,0,15,0,38,0,15,0,54,
0,15,0,70,0,15,0,86,0,15,0,102,0,15,0,118,
0,15,0,134,0,15,0,9,93,65,5,0,149,0,15,0,
165,0,15,0,2,93,0,186,0,13,0,5,0,3,43,184,
0,13,16,184,0,5,16,184,0,20,208,184,0,13,16,184,
0,28,208,48,49,3,20,14,2,35,34,38,53,52,62,2,
51,50,5,20,14,2,35,34,38,53,52,62,2,51,50,215,
18,31,42,25,45,39,18,32,41,24,85,254,112,18,31,42,
25,45,39,18,32,41,24,85,254,233,28,50,37,22,50,46,
28,50,37,21,95,28,50,37,22,50,46,28,50,37,21,0,
0,2,253,67,254,12,254,183,255,146,0,19,0,39,0,238,
184,0,40,47,184,0,41,47,184,0,20,220,185,0,0,0,
3,252,65,5,0,154,0,0,0,170,0,0,0,2,93,65,
19,0,9,0,0,0,25,0,0,0,41,0,0,0,57,0,
0,0,73,0,0,0,89,0,0,0,105,0,0,0,121,0,
0,0,137,0,0,0,9,93,184,0,40,16,184,0,30,208,
184,0,30,47,185,0,10,0,3,252,65,19,0,6,0,10,
0,22,0,10,0,38,0,10,0,54,0,10,0,70,0,10,
0,86,0,10,0,102,0,10,0,118,0,10,0,134,0,10,
0,9,93,65,5,0,149,0,10,0,165,0,10,0,2,93,
0,184,0,0,69,88,184,0,25,47,27,185,0,25,0,7,
62,89,184,0,35,220,65,27,0,7,0,35,0,23,0,35,
0,39,0,35,0,55,0,35,0,71,0,35,0,87,0,35,
0,103,0,35,0,119,0,35,0,135,0,35,0,151,0,35,
0,167,0,35,0,183,0,35,0,199,0,35,0,13,93,65,
5,0,214,0,35,0,230,0,35,0,2,93,48,49,1,52,
46,2,35,34,14,2,21,20,30,2,51,50,62,2,55,20,
14,2,35,34,46,2,53,52,62,2,51,50,30,2,254,93,
12,22,32,20,21,38,29,18,12,22,32,20,20,38,30,18,
90,39,63,77,38,34,57,41,23,39,62,77,39,32,57,42,
24,254,205,24,44,33,20,17,31,44,27,23,43,33,20,15,
30,43,70,51,85,63,35,24,42,56,32,51,87,63,35,25,
43,57,0,1,253,83,254,5,254,117,255,149,0,26,0,0,
1,14,3,7,39,62,3,55,54,46,2,47,1,62,3,23,
30,3,254,113,5,27,43,62,40,35,13,27,21,14,1,1,
14,34,55,39,9,9,56,66,62,16,25,34,18,4,254,224,
28,62,58,52,19,37,8,33,39,41,17,22,42,35,23,3,
43,8,21,18,10,3,12,44,50,51,0,1,253,90,254,68,
254,164,0,14,0,25,0,21,0,184,0,5,47,184,0,19,
47,186,0,20,0,5,0,19,17,18,57,48,49,5,20,14,
2,7,39,62,3,53,52,38,39,48,62,2,55,23,7,30,
3,254,164,35,74,117,82,22,52,73,46,21,52,62,3,14,
29,27,78,39,26,51,39,24,229,37,68,56,42,12,49,9,
27,32,35,16,34,27,6,7,42,90,84,2,116,6,19,30,
42,0,0,1,253,64,254,68,254,187,0,43,0,26,0,75,
187,0,19,0,4,0,10,0,4,43,184,0,19,16,65,19,
0,6,0,19,0,22,0,19,0,38,0,19,0,54,0,19,
0,70,0,19,0,86,0,19,0,102,0,19,0,118,0,19,
0,134,0,19,0,9,93,65,5,0,149,0,19,0,165,0,
19,0,2,93,0,184,0,5,47,48,49,1,14,3,35,34,
46,2,53,52,54,55,23,14,3,21,20,22,51,50,54,55,
23,254,187,21,57,60,60,25,29,56,44,27,157,151,45,72,
88,48,16,48,38,25,73,42,24,254,213,27,52,41,25,12,
32,56,45,90,171,81,19,44,84,74,62,24,37,35,36,38,
37,0,0,1,253,188,254,12,254,42,255,146,0,10,0,0,
1,14,1,7,39,17,62,1,55,23,17,254,42,20,45,20,
25,17,46,20,27,254,43,10,16,5,22,1,82,8,17,5,
24,254,177,0,0,1,252,236,254,57,254,255,255,76,0,18,
0,0,1,14,1,7,39,53,62,1,55,33,23,21,14,1,
7,39,53,33,21,253,70,13,33,19,25,14,29,20,1,190,
22,14,31,20,25,254,161,254,108,13,28,10,22,203,14,25,
11,24,200,15,30,6,22,163,134,0,0,1,252,191,254,52,
255,59,255,107,0,36,0,0,7,14,1,35,34,38,39,14,
1,35,34,38,39,62,3,55,30,1,51,50,54,55,54,22,
23,30,3,51,50,54,55,30,1,197,31,89,47,41,79,31,
32,79,38,51,87,31,3,12,14,14,4,26,59,35,36,70,
25,7,24,8,13,31,33,36,17,36,60,25,9,33,193,134,
133,80,85,85,80,133,134,4,11,10,10,2,95,79,81,98,
2,1,1,49,68,43,19,79,95,5,24,0,0,1,252,193,
254,32,255,58,255,130,0,12,0,28,0,184,0,7,47,184,
0,9,47,184,0,0,69,88,184,0,0,47,27,185,0,0,
0,7,62,89,48,49,1,35,1,62,3,55,5,37,30,1,
23,254,52,107,254,248,7,10,9,11,8,1,19,1,14,17,
14,12,254,32,1,51,10,14,10,8,5,211,211,9,18,20,
0,1,252,193,254,9,255,58,255,107,0,13,0,15,0,184,
0,3,47,184,0,5,47,184,0,11,47,48,49,3,14,1,
7,37,5,46,3,39,1,51,1,198,12,14,17,254,238,254,
241,8,11,9,10,7,1,8,107,1,6,254,54,19,18,8,
208,208,4,8,10,14,9,1,53,254,203,0,0,1,252,184,
254,32,255,66,255,111,0,25,0,149,0,184,0,13,47,184,
0,23,47,184,0,0,69,88,184,0,5,47,27,185,0,5,
0,7,62,89,185,0,18,0,2,252,65,33,0,7,0,18,
0,23,0,18,0,39,0,18,0,55,0,18,0,71,0,18,
0,87,0,18,0,103,0,18,0,119,0,18,0,135,0,18,
0,151,0,18,0,167,0,18,0,183,0,18,0,199,0,18,
0,215,0,18,0,231,0,18,0,247,0,18,0,16,93,65,
15,0,7,0,18,0,23,0,18,0,39,0,18,0,55,0,
18,0,71,0,18,0,87,0,18,0,103,0,18,0,7,113,
65,5,0,118,0,18,0,134,0,18,0,2,113,48,49,7,
14,3,35,34,46,2,39,62,1,55,30,3,51,50,62,2,
55,30,1,190,30,75,83,90,45,49,92,83,73,30,12,24,
17,25,65,72,75,33,35,77,73,65,24,17,24,190,81,110,
69,30,30,69,110,81,18,19,8,57,78,47,21,21,47,78,
57,8,19,0,0,1,252,184,254,22,255,66,255,101,0,25,
0,0,1,62,3,51,50,30,2,23,14,1,7,46,3,35,
34,14,2,7,46,1,252,184,30,75,83,90,45,49,92,83,
73,30,12,24,17,25,65,72,75,33,35,77,73,65,24,17,
24,254,67,81,110,69,30,30,69,110,81,18,19,8,57,78,
47,21,21,47,78,57,8,19,0,1,252,168,254,85,255,82,
255,85,0,28,0,37,0,184,0,19,47,184,0,27,47,187,
0,10,0,2,0,13,0,4,43,184,0,10,16,184,0,13,
16,184,0,5,208,184,0,5,47,48,49,7,14,3,35,34,
46,2,35,34,6,7,39,62,3,51,50,30,2,51,50,54,
55,23,174,18,50,61,72,39,35,63,60,59,29,40,66,37,
53,18,49,62,71,39,38,68,60,54,24,38,73,34,54,194,
41,80,64,40,35,43,35,65,56,20,41,81,64,40,35,43,
35,64,59,23,0,1,252,171,254,177,255,79,255,51,0,14,
0,0,7,14,3,7,33,39,62,3,55,33,23,177,2,10,
12,11,4,253,153,22,2,10,12,12,5,2,101,22,229,11,
29,29,28,9,25,11,28,29,27,10,24,0,0,1,251,252,
254,172,0,64,255,46,0,14,0,0,23,14,3,7,33,39,
62,3,55,33,23,64,2,10,12,11,4,251,249,22,2,10,
12,12,5,4,5,22,234,11,29,29,28,9,25,11,28,29,
27,10,24,0,0,2,251,252,253,158,0,64,255,46,0,14,
0,29,0,0,23,14,3,7,33,39,62,3,55,33,23,17,
14,3,7,33,39,62,3,55,33,23,64,2,10,12,11,4,
251,249,22,2,10,12,12,5,4,5,22,2,10,12,11,4,
251,249,22,2,10,12,12,5,4,5,22,234,11,29,29,28,
9,25,11,28,29,27,10,24,254,242,11,29,29,28,9,25,
11,28,29,27,10,24,0,1,252,168,1,77,255,82,2,77,
0,28,0,37,0,184,0,19,47,184,0,27,47,187,0,10,
0,2,0,13,0,4,43,184,0,10,16,184,0,13,16,184,
0,5,208,184,0,5,47,48,49,3,14,3,35,34,46,2,
35,34,6,7,39,62,3,51,50,30,2,51,50,54,55,23,
174,18,50,61,72,39,35,63,60,59,29,40,66,37,53,18,
49,62,71,39,38,68,60,54,24,38,73,34,54,2,54,41,
80,64,40,35,43,35,65,56,20,41,81,64,40,35,43,35,
64,59,23,0,0,1,252,191,1,159,255,58,1,249,0,7,
0,17,0,187,0,6,0,2,0,0,0,4,43,184,0,6,
16,48,49,3,33,39,62,1,55,33,23,220,253,178,23,5,
10,8,2,78,22,1,159,22,16,36,16,25,0,1,251,217,
1,159,0,42,1,249,0,7,0,17,0,187,0,6,0,2,
0,0,0,4,43,184,0,6,16,48,49,19,33,39,62,1,
55,33,23,20,251,220,23,5,10,8,4,36,22,1,159,22,
16,36,16,25,0,1,252,146,0,146,255,107,3,14,0,13,
0,0,3,1,14,3,7,39,1,62,3,55,149,253,197,11,
34,39,38,13,23,2,60,15,34,34,34,15,2,233,253,219,
6,15,15,12,2,37,2,38,6,16,15,11,1,0,0,1,
252,72,254,165,255,180,4,251,0,13,0,0,3,1,14,3,
7,39,1,62,3,55,76,253,36,8,27,32,31,11,35,2,
221,12,26,28,27,13,4,225,250,33,9,26,27,25,6,27,
5,224,11,27,25,22,6,0,0,1,253,189,254,6,254,160,
255,150,0,17,0,24,0,184,0,0,69,88,184,0,10,47,
27,185,0,10,0,7,62,89,184,0,0,220,48,49,5,54,
30,2,21,20,14,2,39,55,22,54,53,52,38,7,253,193,
48,81,60,34,36,61,83,47,6,66,73,73,72,112,6,27,
53,76,43,44,76,54,27,4,84,5,64,54,54,64,5,0,
0,1,252,237,254,78,255,0,255,97,0,18,0,0,5,62,
1,55,23,21,14,1,7,33,39,53,62,1,55,23,21,33,
53,254,166,13,33,19,25,14,29,20,254,66,22,14,31,20,
25,1,95,210,13,28,10,22,203,14,25,11,24,200,15,30,
6,22,163,134,0,2,253,78,254,32,254,172,255,106,0,3,
0,15,0,0,5,21,51,53,37,62,1,55,33,23,17,14,
1,7,33,39,253,158,190,254,242,14,29,20,1,9,22,14,
29,20,254,247,22,230,170,170,30,14,25,11,24,255,0,14,
25,11,24,0,0,1,252,141,254,65,255,109,255,101,0,50,
0,0,1,62,3,51,50,30,2,23,62,3,51,50,30,2,
23,14,3,7,46,3,35,34,14,2,7,6,38,39,46,3,
35,34,14,2,7,46,1,252,141,32,50,48,52,35,16,39,
40,39,17,18,39,40,37,15,37,53,48,49,32,3,12,14,
14,4,24,39,36,38,23,18,39,38,34,12,7,24,8,13,
34,37,39,17,24,39,36,38,24,9,33,254,160,24,68,61,
44,14,33,56,42,42,56,33,14,46,64,67,20,4,11,10,
10,2,12,35,33,24,13,36,62,49,2,1,1,49,62,36,
13,24,33,35,12,5,24,0,0,1,252,209,4,33,255,38,
5,162,0,19,0,0,1,23,14,1,7,39,7,46,1,39,
55,39,62,1,55,23,55,30,1,23,254,107,187,8,20,15,
254,251,14,21,10,185,189,8,25,12,255,250,13,22,8,4,
226,138,17,26,12,128,128,11,28,16,136,137,14,32,11,131,
131,10,30,17,0,1,253,134,4,23,254,113,6,14,0,26,
0,7,0,184,0,26,47,48,49,1,54,53,52,46,2,53,
52,62,2,55,23,14,1,21,20,30,2,21,20,14,2,7,
253,134,104,30,35,30,38,60,74,36,18,50,51,30,35,30,
38,60,75,36,4,63,50,57,18,40,44,50,28,28,53,45,
37,13,39,27,49,30,22,42,44,46,25,30,53,45,38,13,
0,2,251,252,4,151,0,64,6,39,0,14,0,29,0,0,
19,14,3,7,33,39,62,3,55,33,23,17,14,3,7,33,
39,62,3,55,33,23,64,2,10,12,11,4,251,249,22,2,
10,12,12,5,4,5,22,2,10,12,11,4,251,249,22,2,
10,12,12,5,4,5,22,6,15,11,29,29,28,9,25,11,
28,29,27,10,24,254,242,11,29,29,28,9,25,11,28,29,
27,10,24,0,0,1,252,58,5,70,253,51,6,98,0,9,
0,15,0,184,0,3,47,184,0,5,47,184,0,8,47,48,
49,1,14,1,7,39,55,62,1,51,19,253,51,12,19,14,
204,25,26,46,26,126,5,90,8,9,3,234,41,5,4,254,
248,0,0,1,254,213,5,70,255,192,6,98,0,8,0,7,
0,184,0,6,47,48,49,1,19,54,22,31,1,7,34,38,
254,213,110,23,50,26,26,190,13,19,5,89,1,7,2,6,
4,40,234,11,0,1,252,179,4,76,255,93,5,56,0,28,
0,39,0,184,0,5,47,184,0,13,47,184,0,19,47,184,
0,27,47,184,0,19,16,185,0,10,0,2,252,184,0,5,
16,185,0,24,0,2,252,48,49,3,14,3,35,34,46,2,
35,34,6,7,39,62,3,51,50,30,2,51,50,54,55,23,
163,18,50,61,72,39,35,63,60,59,29,40,66,37,53,18,
49,62,71,39,38,68,60,54,24,38,73,34,54,5,33,41,
74,56,34,29,35,29,45,56,20,41,74,57,34,29,35,29,
44,59,23,0,0,1,253,91,4,68,254,129,5,251,0,22,
0,71,187,0,0,0,4,0,7,0,4,43,65,5,0,154,
0,7,0,170,0,7,0,2,93,65,19,0,9,0,7,0,
25,0,7,0,41,0,7,0,57,0,7,0,73,0,7,0,
89,0,7,0,105,0,7,0,121,0,7,0,137,0,7,0,
9,93,0,184,0,3,47,48,49,1,14,1,7,39,62,1,
55,54,46,2,35,39,62,3,23,30,3,254,127,5,89,97,
39,42,44,3,2,14,34,55,39,11,8,53,65,61,16,27,
36,21,7,5,80,69,138,61,33,38,80,46,27,48,36,22,
42,10,24,20,13,2,12,36,45,51,0,3,252,145,4,60,
255,104,6,5,0,14,0,29,0,40,0,53,0,184,0,39,
47,184,0,5,47,184,0,20,47,184,0,30,47,184,0,0,
69,88,184,0,12,47,27,185,0,12,0,11,62,89,184,0,
0,69,88,184,0,28,47,27,185,0,28,0,11,62,89,48,
49,3,22,14,2,35,34,39,38,62,2,51,50,22,5,22,
14,2,35,34,38,39,38,62,2,51,50,23,46,1,39,19,
62,3,55,23,156,4,11,28,45,31,66,14,4,11,29,45,
30,32,43,253,245,4,12,28,45,30,34,41,5,4,11,28,
45,31,66,127,17,20,18,178,15,44,48,48,19,31,4,217,
27,56,45,29,69,28,57,46,29,36,36,27,56,45,29,35,
34,28,57,46,29,229,4,14,15,1,119,6,13,14,11,5,
35,0,0,1,253,183,254,32,254,159,255,143,0,23,0,38,
187,0,14,0,4,0,6,0,4,43,184,0,14,16,0,184,
0,12,47,184,0,0,69,88,184,0,3,47,27,185,0,3,
0,7,62,89,48,49,1,14,1,35,34,38,53,52,38,39,
62,1,55,23,21,20,30,2,51,22,54,55,23,254,159,59,
81,18,30,29,5,10,31,74,29,21,1,5,9,6,11,21,
17,7,254,104,43,29,53,71,82,89,23,8,25,16,26,124,
38,47,27,11,1,5,5,31,0,1,252,236,4,46,254,255,
5,65,0,18,0,0,1,14,1,7,39,53,62,1,55,33,
23,21,14,1,7,39,53,33,21,253,70,13,33,19,25,14,
29,20,1,190,22,14,31,20,25,254,161,4,97,13,28,10,
22,203,14,25,11,24,200,15,30,6,22,163,134,0,0,2,
253,23,254,67,254,227,255,101,0,10,0,21,0,0,1,14,
1,7,33,39,62,1,55,33,23,53,14,1,7,33,39,62,
1,55,33,23,254,227,5,13,9,254,102,23,6,12,11,1,
150,25,5,13,9,254,102,23,6,12,11,1,150,25,254,130,
20,26,17,24,20,26,20,27,200,20,26,17,24,20,26,20,
27,0,0,2,253,58,254,12,254,172,255,146,0,10,0,21,
0,0,1,14,1,7,39,17,62,1,55,23,17,33,14,1,
7,39,17,62,1,55,23,17,254,172,20,45,20,25,17,46,
20,27,254,252,20,45,20,25,17,46,20,27,254,43,10,16,
5,22,1,82,8,17,5,24,254,177,10,16,5,22,1,82,
8,17,5,24,254,177,0,1,253,63,254,22,254,152,255,86,
0,13,0,0,1,14,1,7,39,53,35,39,62,1,55,33,
23,17,254,152,20,25,20,25,232,23,6,12,11,1,33,27,
254,53,12,13,6,22,208,24,20,26,20,24,254,247,0,1,
252,168,4,11,255,82,5,90,0,45,0,63,0,184,0,0,
69,88,184,0,6,47,27,185,0,6,0,11,62,89,184,0,
0,69,88,184,0,35,47,27,185,0,35,0,11,62,89,187,
0,26,0,2,0,29,0,4,43,184,0,26,16,184,0,29,
16,184,0,12,208,184,0,12,47,48,49,1,30,1,51,50,
54,55,23,14,3,35,34,38,39,7,14,3,7,39,55,46,
1,35,34,6,7,39,62,3,51,50,22,23,55,62,3,55,
23,254,67,20,35,17,38,73,34,54,18,50,61,72,39,30,
56,27,39,17,14,11,15,17,20,78,20,38,20,40,66,37,
53,18,49,62,71,39,32,58,26,41,21,21,12,12,13,16,
4,213,14,17,64,59,23,41,80,64,40,27,19,53,9,11,
7,6,6,24,106,12,17,65,56,20,41,81,64,40,26,17,
57,11,11,6,5,4,24,0,0,3,252,168,4,46,255,82,
6,52,0,10,0,21,0,50,0,0,1,20,6,35,34,38,
53,52,54,51,50,3,20,6,35,34,38,53,52,54,51,50,
37,14,3,35,34,46,2,35,34,6,7,39,62,3,51,50,
30,2,51,50,54,55,23,254,160,43,32,29,25,44,30,55,
197,43,32,29,25,44,30,55,1,119,18,50,61,72,39,35,
63,60,59,29,40,66,37,53,18,49,62,71,39,38,68,60,
54,24,38,73,34,54,5,247,37,52,33,29,37,51,254,83,
37,52,33,29,37,51,215,41,80,64,40,35,43,35,65,56,
20,41,81,64,40,35,43,35,64,59,23,0,0,2,252,208,
4,56,255,42,5,158,0,28,0,57,0,0,3,14,1,35,
34,46,2,35,34,14,2,7,39,62,1,51,50,30,2,51,
50,62,2,55,23,21,14,1,35,34,46,2,35,34,14,2,
7,39,62,1,51,50,30,2,51,50,62,2,55,23,214,43,
111,56,31,53,51,52,29,20,30,31,36,26,33,43,110,56,
34,58,51,47,24,19,32,33,37,24,34,43,111,56,31,53,
51,52,29,20,30,31,36,26,33,43,110,56,34,58,51,47,
24,19,32,33,37,24,34,5,125,59,66,23,27,23,3,15,
29,26,30,60,68,23,27,23,4,14,29,26,33,200,59,66,
23,27,23,3,15,29,26,30,60,68,23,27,23,4,14,29,
26,33,0,1,252,193,254,12,255,57,255,156,0,13,0,0,
1,55,33,23,7,39,55,23,7,33,39,55,23,7,254,104,
80,254,139,79,56,153,153,56,79,1,117,80,56,153,153,254,
37,130,130,25,200,200,25,130,130,25,200,200,0,1,253,32,
254,12,254,214,255,156,0,12,0,0,1,14,1,7,39,53,
7,39,55,23,7,39,21,254,42,20,25,20,25,150,26,221,
217,26,146,254,43,12,13,6,22,238,89,56,173,173,56,89,
229,0,0,1,253,198,4,49,2,58,5,61,0,32,0,17,
0,187,0,28,0,2,0,5,0,4,43,184,0,28,16,48,
49,1,14,3,35,34,46,4,35,34,14,2,7,39,62,3,
51,50,30,2,51,50,54,55,23,2,58,31,82,102,119,69,
41,75,71,67,66,67,34,39,64,59,58,33,63,31,82,100,
120,69,67,115,102,91,42,75,121,60,65,5,18,44,82,62,
37,21,32,37,32,21,18,36,54,35,40,45,82,63,38,45,
53,45,69,74,43,0,0,1,253,150,4,36,2,106,5,125,
0,25,0,11,0,184,0,13,47,184,0,23,47,48,49,1,
62,3,51,50,30,2,23,14,1,7,46,3,35,34,14,2,
7,46,1,253,150,66,148,157,163,81,88,166,156,145,66,20,
33,28,57,130,137,141,68,72,145,139,129,56,29,32,4,81,
81,114,72,33,33,72,114,81,18,20,7,57,78,47,21,21,
47,78,57,8,19,0,0,1,253,33,254,12,3,65,255,156,
0,12,0,0,1,62,1,55,33,39,55,23,7,39,55,33,
39,253,33,6,12,11,5,129,79,56,153,153,56,79,250,121,
23,254,191,20,26,20,130,25,200,200,25,130,24,0,255,255,
0,40,4,60,1,165,6,5,2,6,2,243,0,0,255,255,
0,40,254,7,1,165,255,208,2,7,2,243,0,0,249,203,
0,1,253,183,254,32,254,159,255,143,0,23,0,38,187,0,
14,0,4,0,6,0,4,43,184,0,14,16,0,184,0,12,
47,184,0,0,69,88,184,0,3,47,27,185,0,3,0,7,
62,89,48,49,1,14,1,35,34,38,53,52,38,39,62,1,
55,23,21,20,30,2,51,22,54,55,23,254,159,59,81,18,
30,29,5,10,31,74,29,21,1,5,9,6,11,21,17,7,
254,104,43,29,53,71,82,89,23,8,25,16,26,124,38,47,
27,11,1,5,5,31,255,255,0,88,254,207,1,135,3,193,
2,38,0,12,0,0,0,7,0,14,0,0,2,213,0,1,
0,40,4,60,1,165,6,5,0,12,0,11,0,184,0,11,
47,184,0,0,47,48,49,19,46,3,39,19,62,3,55,23,
93,8,12,12,12,9,176,16,44,48,47,19,31,4,60,2,
5,8,10,8,1,119,6,13,14,11,5,35,0,3,0,41,
4,60,3,0,6,5,0,14,0,29,0,40,0,53,0,184,
0,39,47,184,0,5,47,184,0,20,47,184,0,30,47,184,
0,0,69,88,184,0,12,47,27,185,0,12,0,11,62,89,
184,0,0,69,88,184,0,28,47,27,185,0,28,0,11,62,
89,48,49,1,22,14,2,35,34,39,38,62,2,51,50,22,
5,22,14,2,35,34,38,39,38,62,2,51,50,23,46,1,
39,19,62,3,55,23,2,252,4,11,28,45,31,66,14,4,
11,29,45,30,32,43,253,245,4,12,28,45,30,34,41,5,
4,11,28,45,31,66,127,17,20,18,178,15,44,48,48,19,
31,4,217,27,56,45,29,69,28,57,46,29,36,36,27,56,
45,29,35,34,28,57,46,29,229,4,14,15,1,119,6,13,
14,11,5,35,255,255,0,40,0,0,5,149,5,162,0,39,
2,254,0,231,0,0,0,6,2,243,0,157,255,255,0,131,
2,173,1,113,3,193,2,7,0,14,0,0,2,213,255,255,
0,40,0,0,5,135,5,162,0,39,3,2,1,205,0,0,
0,6,2,243,0,157,255,255,0,40,0,0,6,195,5,162,
0,39,3,4,1,205,0,0,0,6,2,243,0,157,255,255,
0,40,0,0,3,213,5,162,0,39,3,6,1,185,0,0,
0,6,2,243,0,157,255,255,0,40,255,226,5,120,5,162,
0,39,3,12,1,5,0,0,0,6,2,243,0,157,255,255,
0,40,0,0,6,199,5,162,0,39,3,17,2,49,0,0,
0,6,2,243,0,157,255,255,0,40,0,0,5,142,5,162,
0,39,3,21,0,246,0,0,0,6,2,243,0,157,255,255,
255,189,255,225,2,148,6,5,2,38,3,37,0,0,0,6,
2,244,148,0,0,2,0,0,0,0,4,174,5,37,0,2,
0,28,0,68,0,184,0,0,69,88,184,0,23,47,27,185,
0,23,0,11,62,89,184,0,0,69,88,184,0,3,47,27,
185,0,3,0,5,62,89,184,0,0,69,88,184,0,14,47,
27,185,0,14,0,5,62,89,187,0,1,0,2,0,8,0,
4,43,184,0,1,16,48,49,1,33,3,19,53,62,1,39,
3,33,3,6,22,23,21,33,53,62,1,55,1,62,1,55,
1,30,1,23,21,1,155,1,91,176,194,78,62,13,114,254,
104,111,9,73,82,254,96,68,79,11,1,116,23,68,26,1,
164,9,57,65,2,23,2,2,251,231,43,5,31,32,1,77,
254,179,31,28,9,43,43,12,27,29,4,102,25,41,14,251,
74,28,33,7,43,0,0,3,0,41,255,242,3,248,5,10,
0,14,0,35,0,75,2,4,187,0,19,0,4,0,53,0,
4,43,184,0,19,16,187,0,68,0,4,0,10,0,4,43,
184,0,68,16,184,0,19,16,184,0,3,208,65,5,0,154,
0,10,0,170,0,10,0,2,93,65,19,0,9,0,10,0,
25,0,10,0,41,0,10,0,57,0,10,0,73,0,10,0,
89,0,10,0,105,0,10,0,121,0,10,0,137,0,10,0,
9,93,186,0,31,0,10,0,68,17,18,57,184,0,31,47,
65,5,0,154,0,31,0,170,0,31,0,2,93,65,19,0,
9,0,31,0,25,0,31,0,41,0,31,0,57,0,31,0,
73,0,31,0,89,0,31,0,105,0,31,0,121,0,31,0,
137,0,31,0,9,93,185,0,36,0,4,252,186,0,71,0,
53,0,36,17,18,57,184,0,77,220,0,184,0,0,69,88,
184,0,63,47,27,185,0,63,0,11,62,89,184,0,0,69,
88,184,0,41,47,27,185,0,41,0,5,62,89,184,0,0,
69,88,184,0,48,47,27,185,0,48,0,5,62,89,187,0,
5,0,2,0,15,0,4,43,184,0,5,16,184,0,63,16,
185,0,0,0,2,252,65,5,0,121,0,0,0,137,0,0,
0,2,113,65,33,0,8,0,0,0,24,0,0,0,40,0,
0,0,56,0,0,0,72,0,0,0,88,0,0,0,104,0,
0,0,120,0,0,0,136,0,0,0,152,0,0,0,168,0,
0,0,184,0,0,0,200,0,0,0,216,0,0,0,232,0,
0,0,248,0,0,0,16,93,65,15,0,8,0,0,0,24,
0,0,0,40,0,0,0,56,0,0,0,72,0,0,0,88,
0,0,0,104,0,0,0,7,113,184,0,3,208,184,0,3,
47,184,0,41,16,185,0,26,0,2,252,65,33,0,7,0,
26,0,23,0,26,0,39,0,26,0,55,0,26,0,71,0,
26,0,87,0,26,0,103,0,26,0,119,0,26,0,135,0,
26,0,151,0,26,0,167,0,26,0,183,0,26,0,199,0,
26,0,215,0,26,0,231,0,26,0,247,0,26,0,16,93,
65,15,0,7,0,26,0,23,0,26,0,39,0,26,0,55,
0,26,0,71,0,26,0,87,0,26,0,103,0,26,0,7,
113,65,5,0,118,0,26,0,134,0,26,0,2,113,184,0,
5,16,184,0,71,208,184,0,71,47,48,49,1,34,6,7,
17,51,50,62,2,53,52,46,2,19,34,6,7,17,20,23,
30,3,51,50,62,2,53,52,46,2,1,20,14,2,35,34,
46,4,49,35,53,62,1,53,17,14,1,7,39,62,3,51,
50,30,2,21,20,6,7,30,3,1,157,14,29,15,34,114,
141,78,28,33,78,129,10,48,81,36,9,17,44,46,46,20,
72,116,83,44,39,81,125,1,153,67,121,168,101,29,88,96,
97,78,48,74,68,78,38,74,34,8,39,103,114,118,54,100,
161,113,60,100,88,64,110,81,46,4,182,1,1,254,33,45,
70,88,43,50,86,63,36,253,211,8,6,253,237,8,7,6,
7,4,2,37,66,93,56,55,116,95,61,254,219,85,137,96,
52,2,3,4,3,2,43,14,33,14,4,62,5,11,6,62,
11,21,17,11,37,70,100,63,108,155,34,12,66,97,123,0,
0,1,0,49,0,0,3,160,4,236,0,30,0,78,187,0,
24,0,4,0,4,0,4,43,184,0,24,16,0,184,0,0,
69,88,184,0,16,47,27,185,0,16,0,9,62,89,184,0,
0,69,88,184,0,9,47,27,185,0,9,0,11,62,89,184,
0,0,69,88,184,0,0,47,27,185,0,0,0,5,62,89,
184,0,9,16,185,0,22,0,2,252,48,49,51,53,62,1,
53,17,52,38,39,53,33,23,14,3,7,35,46,3,35,33,
17,20,30,2,23,21,49,68,78,74,72,3,80,31,2,10,
15,17,7,48,3,8,15,24,19,254,107,16,44,76,60,43,
14,33,14,4,27,12,36,14,43,25,26,80,87,84,28,64,
90,58,27,251,215,7,13,14,17,10,43,0,0,2,0,59,
0,0,4,70,5,37,0,24,0,48,0,53,0,184,0,0,
69,88,184,0,39,47,27,185,0,39,0,11,62,89,184,0,
0,69,88,184,0,25,47,27,185,0,25,0,5,62,89,186,
0,7,0,25,0,39,17,18,57,185,0,19,0,2,252,48,
49,37,48,46,4,39,14,5,49,14,1,30,1,51,33,50,
62,1,38,23,33,39,48,62,6,55,62,1,55,30,7,49,
3,113,34,56,71,75,71,27,30,72,72,67,52,31,7,3,
20,51,48,1,182,49,52,21,4,185,252,25,15,28,47,63,
70,75,70,61,23,23,67,26,26,70,77,82,77,69,51,30,
166,89,146,187,196,190,75,84,197,196,182,140,84,19,21,11,
2,2,11,21,147,51,73,126,169,189,201,191,172,65,25,41,
14,74,187,205,214,201,176,132,77,0,0,1,0,49,0,0,
3,186,4,236,0,54,0,89,187,0,42,0,4,0,8,0,
4,43,184,0,42,16,184,0,27,208,0,184,0,0,69,88,
184,0,13,47,27,185,0,13,0,11,62,89,184,0,0,69,
88,184,0,3,47,27,185,0,3,0,5,62,89,187,0,28,
0,2,0,41,0,4,43,184,0,28,16,184,0,13,16,185,
0,26,0,2,252,184,0,3,16,185,0,47,0,2,252,48,
49,37,14,1,7,33,53,62,1,53,17,52,38,39,53,33,
23,14,3,7,35,46,3,35,33,17,33,23,14,3,7,46,
3,43,1,17,20,30,2,59,1,50,62,2,55,23,3,186,
8,25,8,252,160,68,78,74,72,3,39,33,2,8,12,13,
6,45,2,13,20,29,18,254,146,1,149,26,8,23,25,25,
11,15,35,45,61,42,141,14,44,80,66,129,46,65,50,41,
21,43,244,86,129,29,43,14,33,14,4,27,12,36,14,43,
25,26,62,62,56,19,46,61,37,15,254,78,28,14,31,29,
25,8,15,20,14,6,254,11,15,23,17,9,10,35,68,59,
18,0,0,1,0,59,0,0,3,223,4,252,0,32,0,95,
0,184,0,0,69,88,184,0,16,47,27,185,0,16,0,11,
62,89,184,0,0,69,88,184,0,20,47,27,185,0,20,0,
11,62,89,184,0,0,69,88,184,0,22,47,27,185,0,22,
0,11,62,89,184,0,0,69,88,184,0,5,47,27,185,0,
5,0,5,62,89,184,0,22,16,185,0,8,0,2,252,184,
0,9,208,184,0,5,16,185,0,25,0,2,252,48,49,1,
14,3,7,33,39,1,33,34,14,2,7,39,19,30,2,51,
50,51,33,23,1,33,50,62,2,55,23,3,223,2,3,3,
3,1,252,133,29,2,199,254,53,16,38,36,32,11,57,29,
27,45,43,23,23,29,2,104,25,253,63,2,11,21,34,31,
32,19,55,1,37,32,78,79,75,29,45,4,90,22,48,74,
52,12,1,45,6,7,3,43,251,163,19,46,80,62,14,0,
0,1,0,49,0,0,4,246,4,236,0,43,0,133,184,0,
44,47,184,0,45,47,184,0,44,16,184,0,4,208,184,0,
4,47,185,0,39,0,4,252,184,0,14,208,184,0,45,16,
184,0,26,220,185,0,17,0,4,252,184,0,36,208,0,184,
0,0,69,88,184,0,9,47,27,185,0,9,0,11,62,89,
184,0,0,69,88,184,0,21,47,27,185,0,21,0,11,62,
89,184,0,0,69,88,184,0,0,47,27,185,0,0,0,5,
62,89,184,0,0,69,88,184,0,31,47,27,185,0,31,0,
5,62,89,187,0,16,0,2,0,37,0,4,43,184,0,16,
16,48,49,51,53,62,1,53,17,52,38,39,53,33,21,14,
1,21,17,33,17,52,38,39,53,33,21,14,1,21,17,20,
22,23,21,33,53,62,1,53,17,33,17,20,22,23,21,49,
68,78,74,72,1,195,68,77,2,98,74,72,1,195,68,77,
73,72,254,61,68,78,253,158,72,73,43,14,33,14,4,27,
12,36,14,43,43,14,34,14,254,62,1,194,12,36,14,43,
43,14,34,14,251,229,12,35,14,43,43,14,33,14,1,254,
254,2,12,35,14,43,0,3,0,70,255,226,4,152,5,10,
0,27,0,49,0,73,1,189,184,0,74,47,184,0,75,47,
184,0,50,220,185,0,28,0,4,252,65,5,0,154,0,28,
0,170,0,28,0,2,93,65,19,0,9,0,28,0,25,0,
28,0,41,0,28,0,57,0,28,0,73,0,28,0,89,0,
28,0,105,0,28,0,121,0,28,0,137,0,28,0,9,93,
184,0,74,16,184,0,62,208,184,0,62,47,185,0,40,0,
4,252,65,19,0,6,0,40,0,22,0,40,0,38,0,40,
0,54,0,40,0,70,0,40,0,86,0,40,0,102,0,40,
0,118,0,40,0,134,0,40,0,9,93,65,5,0,149,0,
40,0,165,0,40,0,2,93,0,184,0,0,69,88,184,0,
69,47,27,185,0,69,0,11,62,89,184,0,0,69,88,184,
0,57,47,27,185,0,57,0,5,62,89,187,0,21,0,2,
0,6,0,4,43,184,0,21,16,184,0,69,16,185,0,35,
0,2,252,65,5,0,121,0,35,0,137,0,35,0,2,113,
65,33,0,8,0,35,0,24,0,35,0,40,0,35,0,56,
0,35,0,72,0,35,0,88,0,35,0,104,0,35,0,120,
0,35,0,136,0,35,0,152,0,35,0,168,0,35,0,184,
0,35,0,200,0,35,0,216,0,35,0,232,0,35,0,248,
0,35,0,16,93,65,15,0,8,0,35,0,24,0,35,0,
40,0,35,0,56,0,35,0,72,0,35,0,88,0,35,0,
104,0,35,0,7,113,184,0,57,16,185,0,45,0,2,252,
65,33,0,7,0,45,0,23,0,45,0,39,0,45,0,55,
0,45,0,71,0,45,0,87,0,45,0,103,0,45,0,119,
0,45,0,135,0,45,0,151,0,45,0,167,0,45,0,183,
0,45,0,199,0,45,0,215,0,45,0,231,0,45,0,247,
0,45,0,16,93,65,15,0,7,0,45,0,23,0,45,0,
39,0,45,0,55,0,45,0,71,0,45,0,87,0,45,0,
103,0,45,0,7,113,65,5,0,118,0,45,0,134,0,45,
0,2,113,48,49,1,35,46,3,35,33,34,14,2,7,35,
19,51,30,3,51,33,50,62,2,55,51,23,52,46,4,35,
34,14,2,21,20,30,2,51,50,62,2,55,20,14,4,35,
34,46,2,53,52,62,4,51,50,30,2,3,111,43,7,19,
20,19,7,254,201,6,19,21,19,7,43,31,43,7,15,15,
15,7,1,57,6,22,23,22,7,43,115,26,49,70,88,105,
59,95,148,103,54,65,109,145,81,87,145,106,59,154,43,78,
107,130,146,78,123,195,135,71,42,76,107,130,148,80,127,196,
132,68,1,213,34,45,27,11,10,25,46,36,1,104,34,44,
26,10,9,24,45,36,200,69,135,121,104,75,43,76,139,198,
122,112,200,151,88,69,136,202,150,90,171,151,125,90,50,106,
178,232,126,91,171,150,126,90,50,109,180,232,0,1,0,90,
0,0,2,28,4,236,0,19,0,51,187,0,15,0,4,0,
4,0,4,43,184,0,15,16,0,184,0,0,69,88,184,0,
9,47,27,185,0,9,0,11,62,89,184,0,0,69,88,184,
0,0,47,27,185,0,0,0,5,62,89,48,49,51,53,62,
1,53,17,52,38,39,53,33,21,14,1,21,17,20,22,23,
21,90,68,77,73,72,1,194,68,77,73,72,43,14,33,14,
4,27,12,36,14,43,43,14,34,14,251,229,12,35,14,43,
0,2,0,49,255,242,4,150,4,236,0,29,0,49,0,85,
187,0,45,0,4,0,34,0,4,43,184,0,45,16,0,184,
0,0,69,88,184,0,14,47,27,185,0,14,0,11,62,89,
184,0,0,69,88,184,0,39,47,27,185,0,39,0,11,62,
89,184,0,0,69,88,184,0,3,47,27,185,0,3,0,5,
62,89,184,0,0,69,88,184,0,30,47,27,185,0,30,0,
5,62,89,48,49,37,14,1,35,34,38,39,9,1,62,1,
46,1,39,53,33,21,14,3,7,9,1,30,2,54,55,23,
5,53,62,1,53,17,52,38,39,53,33,21,14,1,21,17,
20,22,23,21,4,150,59,119,48,29,45,20,254,15,1,151,
23,12,20,50,39,1,164,32,50,40,33,15,254,78,1,223,
18,41,47,50,26,7,251,155,68,78,74,72,1,195,68,77,
72,73,37,19,32,18,25,2,102,1,229,27,32,18,9,3,
43,43,4,8,13,20,17,254,28,253,224,20,22,9,1,3,
43,37,43,14,33,14,4,27,12,36,14,43,43,14,34,14,
251,229,12,35,14,43,0,1,0,0,0,0,4,174,5,37,
0,24,0,64,0,184,0,0,69,88,184,0,19,47,27,185,
0,19,0,11,62,89,184,0,0,69,88,184,0,0,47,27,
185,0,0,0,5,62,89,184,0,0,69,88,184,0,10,47,
27,185,0,10,0,5,62,89,186,0,5,0,0,0,19,17,
18,57,48,49,33,53,62,1,39,9,1,6,22,23,21,33,
53,62,1,55,1,62,1,55,1,30,1,23,21,3,8,78,
62,13,254,191,254,200,9,73,82,254,96,68,79,11,1,116,
23,68,26,1,164,9,57,65,43,5,31,32,3,170,252,86,
31,28,9,43,43,12,27,29,4,102,25,41,14,251,74,28,
33,7,43,0,0,1,0,59,0,0,6,35,4,236,0,51,
0,132,0,184,0,0,69,88,184,0,36,47,27,185,0,36,
0,11,62,89,184,0,0,69,88,184,0,49,47,27,185,0,
49,0,11,62,89,184,0,0,69,88,184,0,8,47,27,185,
0,8,0,5,62,89,184,0,0,69,88,184,0,19,47,27,
185,0,19,0,5,62,89,184,0,0,69,88,184,0,26,47,
27,185,0,26,0,5,62,89,184,0,49,16,185,0,0,0,
1,252,186,0,18,0,8,0,36,17,18,57,186,0,21,0,
8,0,36,17,18,57,184,0,35,208,186,0,43,0,8,0,
36,17,18,57,48,49,1,34,6,7,19,20,22,23,21,33,
53,62,3,53,3,6,7,1,35,1,3,20,22,23,21,33,
53,62,1,53,19,46,1,35,53,33,50,30,2,23,9,1,
62,3,51,33,21,6,14,29,70,36,10,74,72,254,57,34,
57,42,23,9,1,2,254,75,49,254,64,9,74,72,254,108,
69,77,10,38,77,30,1,30,10,13,13,16,12,1,142,1,
126,13,16,13,13,9,1,30,4,193,18,17,251,202,12,35,
14,43,43,7,15,17,15,7,3,175,3,4,251,240,4,15,
252,89,12,35,14,43,43,14,33,14,4,49,23,17,43,6,
18,33,27,252,122,3,134,30,33,17,4,43,0,1,0,49,
255,225,5,0,4,236,0,36,0,143,184,0,37,47,184,0,
38,47,184,0,37,16,184,0,4,208,184,0,4,47,184,0,
38,16,184,0,27,220,185,0,16,0,4,252,184,0,30,208,
184,0,30,47,184,0,4,16,185,0,32,0,3,252,0,184,
0,0,69,88,184,0,9,47,27,185,0,9,0,11,62,89,
184,0,0,69,88,184,0,21,47,27,185,0,21,0,11,62,
89,184,0,0,69,88,184,0,27,47,27,185,0,27,0,5,
62,89,184,0,0,69,88,184,0,0,47,27,185,0,0,0,
5,62,89,186,0,16,0,27,0,9,17,18,57,186,0,31,
0,27,0,9,17,18,57,48,49,51,53,62,1,53,17,46,
1,39,53,51,50,30,2,23,1,17,52,38,39,53,33,21,
14,1,21,17,46,1,39,1,17,20,22,23,21,49,74,72,
34,73,39,213,15,19,19,24,19,2,144,66,80,1,156,72,
73,50,57,12,253,67,68,78,43,9,38,14,4,20,32,30,
7,43,5,16,31,26,252,117,3,112,12,39,11,43,43,10,
38,14,251,94,6,28,17,3,205,252,135,12,38,11,43,0,
0,3,0,49,0,0,3,215,4,236,0,27,0,53,0,77,
0,71,0,184,0,0,69,88,184,0,51,47,27,185,0,51,
0,11,62,89,184,0,0,69,88,184,0,59,47,27,185,0,
59,0,5,62,89,187,0,21,0,2,0,6,0,4,43,184,
0,21,16,184,0,51,16,185,0,39,0,2,252,184,0,59,
16,185,0,70,0,2,252,48,49,1,35,46,3,35,33,34,
14,2,7,35,19,51,30,3,51,33,50,62,2,55,51,19,
14,3,7,35,46,3,35,33,34,14,2,7,39,62,3,55,
33,23,19,14,3,7,33,39,62,1,55,51,30,3,51,33,
50,62,2,55,23,2,239,43,7,19,19,19,7,254,250,6,
19,19,19,7,43,29,43,7,15,17,15,7,1,6,6,22,
23,22,7,43,187,1,3,5,8,4,45,9,19,24,32,22,
253,225,21,26,21,21,16,43,1,7,8,10,5,3,33,31,
16,2,5,6,6,4,252,146,33,1,5,5,47,11,23,27,
33,22,2,102,20,24,20,21,18,43,1,213,34,45,27,11,
10,25,46,36,1,104,34,44,26,10,9,24,45,36,1,150,
26,62,67,69,32,42,58,36,15,14,36,60,45,18,29,71,
73,68,26,25,252,55,29,71,72,68,26,27,49,135,70,42,
54,33,13,10,31,57,48,19,0,2,0,70,255,226,4,115,
5,10,0,21,0,43,1,175,184,0,44,47,184,0,45,47,
184,0,22,220,185,0,0,0,4,252,65,5,0,154,0,0,
0,170,0,0,0,2,93,65,19,0,9,0,0,0,25,0,
0,0,41,0,0,0,57,0,0,0,73,0,0,0,89,0,
0,0,105,0,0,0,121,0,0,0,137,0,0,0,9,93,
184,0,44,16,184,0,34,208,184,0,34,47,185,0,12,0,
4,252,65,19,0,6,0,12,0,22,0,12,0,38,0,12,
0,54,0,12,0,70,0,12,0,86,0,12,0,102,0,12,
0,118,0,12,0,134,0,12,0,9,93,65,5,0,149,0,
12,0,165,0,12,0,2,93,0,184,0,0,69,88,184,0,
39,47,27,185,0,39,0,11,62,89,184,0,0,69,88,184,
0,29,47,27,185,0,29,0,5,62,89,184,0,39,16,185,
0,7,0,2,252,65,5,0,121,0,7,0,137,0,7,0,
2,113,65,33,0,8,0,7,0,24,0,7,0,40,0,7,
0,56,0,7,0,72,0,7,0,88,0,7,0,104,0,7,
0,120,0,7,0,136,0,7,0,152,0,7,0,168,0,7,
0,184,0,7,0,200,0,7,0,216,0,7,0,232,0,7,
0,248,0,7,0,16,93,65,15,0,8,0,7,0,24,0,
7,0,40,0,7,0,56,0,7,0,72,0,7,0,88,0,
7,0,104,0,7,0,7,113,184,0,29,16,185,0,17,0,
2,252,65,33,0,7,0,17,0,23,0,17,0,39,0,17,
0,55,0,17,0,71,0,17,0,87,0,17,0,103,0,17,
0,119,0,17,0,135,0,17,0,151,0,17,0,167,0,17,
0,183,0,17,0,199,0,17,0,215,0,17,0,231,0,17,
0,247,0,17,0,16,93,65,15,0,7,0,17,0,23,0,
17,0,39,0,17,0,55,0,17,0,71,0,17,0,87,0,
17,0,103,0,17,0,7,113,65,5,0,118,0,17,0,134,
0,17,0,2,113,48,49,1,52,46,4,35,34,14,2,21,
20,30,2,51,50,62,2,55,20,14,4,35,34,46,2,53,
52,62,2,51,50,30,2,3,215,25,46,67,84,100,57,89,
141,97,52,61,103,138,77,83,139,101,56,156,41,75,104,125,
143,76,120,188,129,68,88,152,205,118,124,189,128,65,2,117,
69,135,121,104,75,43,76,139,198,122,112,200,151,88,69,136,
202,150,90,171,151,125,90,50,106,178,232,126,136,246,186,110,
109,180,232,0,0,1,0,49,0,0,4,197,4,236,0,41,
0,108,184,0,42,47,184,0,43,47,184,0,42,16,184,0,
4,208,184,0,4,47,184,0,43,16,184,0,15,220,185,0,
24,0,4,252,184,0,4,16,185,0,37,0,4,252,0,184,
0,0,69,88,184,0,9,47,27,185,0,9,0,11,62,89,
184,0,0,69,88,184,0,0,47,27,185,0,0,0,5,62,
89,184,0,0,69,88,184,0,19,47,27,185,0,19,0,5,
62,89,184,0,9,16,185,0,30,0,2,252,48,49,51,53,
62,1,53,17,52,38,39,53,33,21,14,1,21,17,20,22,
23,21,33,53,62,1,53,17,52,46,2,43,1,14,3,21,
17,20,22,23,21,49,68,78,74,72,4,148,69,77,73,73,
254,61,68,77,27,52,77,49,166,47,71,47,24,72,73,43,
14,33,14,4,27,12,36,14,43,43,14,34,14,251,229,12,
35,14,43,43,14,33,14,3,238,12,24,20,13,1,13,19,
24,12,252,18,12,35,14,43,0,1,0,41,0,0,3,213,
5,10,0,52,1,46,184,0,53,47,184,0,54,47,184,0,
53,16,184,0,4,208,184,0,4,47,184,0,54,16,184,0,
19,220,186,0,29,0,4,0,19,17,18,57,185,0,37,0,
4,252,65,5,0,154,0,37,0,170,0,37,0,2,93,65,
19,0,9,0,37,0,25,0,37,0,41,0,37,0,57,0,
37,0,73,0,37,0,89,0,37,0,105,0,37,0,121,0,
37,0,137,0,37,0,9,93,184,0,4,16,185,0,46,0,
4,252,0,184,0,0,69,88,184,0,14,47,27,185,0,14,
0,11,62,89,184,0,0,69,88,184,0,0,47,27,185,0,
0,0,5,62,89,187,0,32,0,2,0,26,0,4,43,184,
0,32,16,186,0,29,0,0,0,14,17,18,57,184,0,14,
16,185,0,42,0,2,252,65,5,0,121,0,42,0,137,0,
42,0,2,113,65,33,0,8,0,42,0,24,0,42,0,40,
0,42,0,56,0,42,0,72,0,42,0,88,0,42,0,104,
0,42,0,120,0,42,0,136,0,42,0,152,0,42,0,168,
0,42,0,184,0,42,0,200,0,42,0,216,0,42,0,232,
0,42,0,248,0,42,0,16,93,65,15,0,8,0,42,0,
24,0,42,0,40,0,42,0,56,0,42,0,72,0,42,0,
88,0,42,0,104,0,42,0,7,113,184,0,45,208,184,0,
45,47,48,49,51,53,62,1,53,17,14,1,7,39,62,3,
51,50,30,2,21,20,14,4,35,34,47,1,30,1,51,50,
62,2,53,52,46,2,35,34,6,7,17,20,30,2,23,21,
49,68,78,38,72,36,8,48,113,122,125,61,108,174,123,66,
39,64,85,90,91,39,94,67,23,42,77,35,46,101,84,55,
60,102,137,77,25,49,24,16,39,68,52,43,14,33,14,4,
62,5,11,6,62,13,22,16,9,46,90,132,86,69,114,89,
65,43,21,30,76,19,10,36,70,106,71,82,118,75,36,1,
1,251,180,6,14,16,16,9,43,0,0,1,0,59,0,0,
3,241,4,252,0,31,0,78,0,184,0,0,69,88,184,0,
14,47,27,185,0,14,0,11,62,89,184,0,0,69,88,184,
0,10,47,27,185,0,10,0,11,62,89,184,0,0,69,88,
184,0,5,47,27,185,0,5,0,5,62,89,184,0,14,16,
185,0,21,0,2,252,184,0,22,208,184,0,5,16,185,0,
24,0,2,252,48,49,1,14,3,7,33,39,9,1,53,33,
50,54,55,19,7,46,3,35,33,9,1,33,50,62,2,55,
23,3,241,2,7,8,7,2,252,131,31,1,181,254,96,2,
162,56,97,60,4,56,18,36,34,32,15,254,43,1,86,254,
115,2,40,31,41,30,28,18,53,1,89,40,98,96,84,27,
43,2,80,2,70,43,4,12,254,211,12,74,80,36,6,254,
27,253,233,19,49,84,66,12,0,1,0,10,0,0,4,59,
4,236,0,32,0,69,187,0,28,0,4,0,4,0,4,43,
184,0,28,16,0,184,0,0,69,88,184,0,15,47,27,185,
0,15,0,11,62,89,184,0,0,69,88,184,0,0,47,27,
185,0,0,0,5,62,89,184,0,15,16,185,0,5,0,2,
252,184,0,26,208,184,0,27,208,48,49,33,53,62,1,53,
17,33,34,14,2,7,39,62,1,55,33,23,14,1,7,35,
46,3,35,33,17,20,22,23,21,1,49,92,74,254,213,15,
25,25,32,22,43,5,17,11,3,242,30,2,16,12,45,9,
15,19,28,22,254,228,72,92,43,19,39,14,4,30,11,36,
69,58,19,59,134,53,25,51,122,63,42,64,43,21,251,226,
13,40,19,43,0,1,0,0,0,0,4,150,5,24,0,58,
0,88,187,0,11,0,4,0,22,0,4,43,184,0,11,16,
186,0,49,0,22,0,11,17,18,57,0,184,0,0,69,88,
184,0,39,47,27,185,0,39,0,11,62,89,184,0,0,69,
88,184,0,57,47,27,185,0,57,0,11,62,89,184,0,0,
69,88,184,0,17,47,27,185,0,17,0,5,62,89,186,0,
49,0,17,0,39,17,18,57,48,49,1,38,14,2,7,14,
3,29,1,20,30,2,23,21,33,53,62,1,61,1,52,46,
4,39,46,3,35,39,62,1,51,50,30,2,23,30,3,23,
62,3,55,62,1,31,1,4,74,28,56,58,61,31,24,62,
55,39,17,39,63,47,254,22,91,73,25,42,55,58,59,25,
20,54,65,75,42,4,59,118,42,21,37,33,30,12,57,88,
69,51,20,16,47,53,57,26,69,162,88,19,4,92,4,7,
33,67,57,44,143,176,200,102,176,6,17,20,20,9,43,43,
19,39,14,176,77,149,142,131,115,99,38,31,66,54,34,43,
8,12,20,30,37,17,75,151,154,156,79,63,149,146,130,45,
114,86,20,35,0,3,0,87,0,0,4,209,4,236,0,10,
0,21,0,63,1,27,187,0,0,0,4,0,32,0,4,43,
187,0,17,0,4,0,5,0,4,43,184,0,17,16,187,0,
53,0,4,0,11,0,4,43,184,0,53,16,65,19,0,6,
0,0,0,22,0,0,0,38,0,0,0,54,0,0,0,70,
0,0,0,86,0,0,0,102,0,0,0,118,0,0,0,134,
0,0,0,9,93,65,5,0,149,0,0,0,165,0,0,0,
2,93,65,5,0,154,0,11,0,170,0,11,0,2,93,65,
19,0,9,0,11,0,25,0,11,0,41,0,11,0,57,0,
11,0,73,0,11,0,89,0,11,0,105,0,11,0,121,0,
11,0,137,0,11,0,9,93,184,0,5,16,184,0,26,208,
184,0,5,16,184,0,37,208,184,0,17,16,184,0,47,208,
184,0,17,16,184,0,58,208,184,0,53,16,184,0,65,220,
0,184,0,0,69,88,184,0,42,47,27,185,0,42,0,11,
62,89,184,0,0,69,88,184,0,22,47,27,185,0,22,0,
5,62,89,184,0,5,220,184,0,42,16,184,0,6,220,184,
0,16,208,184,0,16,47,184,0,5,16,184,0,17,208,185,
0,27,0,2,252,184,0,6,16,185,0,48,0,2,252,184,
0,37,208,184,0,37,47,184,0,27,16,184,0,58,208,48,
49,19,20,30,2,23,17,14,3,5,52,46,2,39,17,62,
3,1,53,62,1,61,1,46,3,53,52,62,2,55,53,52,
38,39,53,33,21,14,1,29,1,30,3,23,22,14,2,7,
21,20,22,23,21,245,56,94,121,65,90,128,81,37,3,65,
52,92,123,70,88,127,82,40,253,126,68,77,93,177,139,85,
69,129,182,114,73,72,1,195,68,78,97,178,135,80,1,1,
78,133,180,101,74,72,2,129,87,130,91,55,12,2,229,8,
71,102,124,76,79,127,94,61,13,253,26,7,65,99,127,253,
212,43,14,33,14,67,8,54,107,165,118,89,158,123,82,13,
67,12,36,14,43,43,14,34,14,63,7,59,109,162,110,102,
166,122,74,10,67,12,35,14,43,0,0,1,0,31,0,0,
4,205,4,236,0,53,0,139,0,184,0,0,69,88,184,0,
25,47,27,185,0,25,0,11,62,89,184,0,0,69,88,184,
0,38,47,27,185,0,38,0,11,62,89,184,0,0,69,88,
184,0,0,47,27,185,0,0,0,5,62,89,184,0,0,69,
88,184,0,12,47,27,185,0,12,0,5,62,89,184,0,0,
16,185,0,1,0,1,252,186,0,7,0,0,0,25,17,18,
57,184,0,11,208,184,0,14,208,184,0,25,16,185,0,24,
0,1,252,184,0,27,208,186,0,31,0,0,0,25,17,18,
57,184,0,37,208,184,0,40,208,184,0,14,16,184,0,52,
208,48,49,33,53,62,2,38,39,1,3,6,22,23,21,33,
53,62,1,55,9,1,46,3,39,53,33,21,14,1,23,27,
1,54,46,2,39,53,33,21,14,3,7,9,1,30,3,23,
21,3,10,44,54,24,3,14,254,233,252,28,65,92,254,62,
65,92,25,1,61,254,179,15,28,35,45,33,1,195,85,51,
29,247,226,14,4,34,62,45,1,197,36,57,44,33,13,254,
221,1,109,15,31,37,46,29,43,4,13,19,28,20,1,152,
254,104,44,34,6,43,43,5,37,42,2,5,1,233,22,28,
18,11,5,43,43,8,32,44,254,149,1,107,23,29,19,10,
3,43,43,4,11,19,29,21,254,41,253,233,21,29,19,11,
4,43,0,1,255,233,0,0,5,131,5,10,0,75,0,245,
187,0,27,0,4,0,10,0,4,43,184,0,27,16,187,0,
71,0,4,0,4,0,4,43,184,0,71,16,187,0,65,0,
4,0,48,0,4,43,184,0,65,16,65,19,0,6,0,27,
0,22,0,27,0,38,0,27,0,54,0,27,0,70,0,27,
0,86,0,27,0,102,0,27,0,118,0,27,0,134,0,27,
0,9,93,65,5,0,149,0,27,0,165,0,27,0,2,93,
184,0,4,16,184,0,32,208,184,0,71,16,184,0,42,208,
65,5,0,154,0,48,0,170,0,48,0,2,93,65,19,0,
9,0,48,0,25,0,48,0,41,0,48,0,57,0,48,0,
73,0,48,0,89,0,48,0,105,0,48,0,121,0,48,0,
137,0,48,0,9,93,184,0,65,16,184,0,77,220,0,184,
0,0,69,88,184,0,17,47,27,185,0,17,0,11,62,89,
184,0,0,69,88,184,0,37,47,27,185,0,37,0,11,62,
89,184,0,0,69,88,184,0,58,47,27,185,0,58,0,11,
62,89,184,0,0,69,88,184,0,0,47,27,185,0,0,0,
5,62,89,48,49,33,53,62,1,53,17,46,3,39,46,3,
47,2,62,3,51,50,30,2,23,30,3,23,17,52,38,39,
53,33,21,14,1,21,17,62,3,55,62,3,51,50,30,2,
23,15,1,14,3,7,14,3,7,17,20,22,23,21,1,213,
68,77,112,162,107,54,3,5,12,21,32,23,102,4,28,65,
62,53,15,33,50,33,18,2,2,40,72,101,63,73,72,1,
195,69,77,77,104,64,31,5,7,16,28,44,35,13,55,65,
67,26,4,111,18,26,19,15,6,3,59,109,161,106,73,73,
43,14,33,14,1,127,7,55,94,133,84,110,138,79,30,2,
8,43,3,7,6,4,30,80,140,110,89,123,81,42,7,2,
55,12,36,14,43,43,14,34,14,253,201,10,57,89,117,69,
104,139,83,34,4,6,7,3,43,9,2,24,73,133,109,68,
130,107,73,10,254,127,12,35,14,43,0,1,0,80,0,0,
4,152,5,10,0,76,1,143,184,0,77,47,184,0,78,47,
184,0,77,16,184,0,18,208,184,0,18,47,184,0,0,208,
184,0,0,47,184,0,18,16,184,0,6,208,184,0,6,47,
184,0,78,16,184,0,30,220,184,0,42,208,184,0,42,47,
186,0,13,0,18,0,42,17,18,57,184,0,30,16,185,0,
56,0,4,252,65,5,0,154,0,56,0,170,0,56,0,2,
93,65,19,0,9,0,56,0,25,0,56,0,41,0,56,0,
57,0,56,0,73,0,56,0,89,0,56,0,105,0,56,0,
121,0,56,0,137,0,56,0,9,93,184,0,36,208,184,0,
36,47,184,0,18,16,185,0,68,0,4,252,65,19,0,6,
0,68,0,22,0,68,0,38,0,68,0,54,0,68,0,70,
0,68,0,86,0,68,0,102,0,68,0,118,0,68,0,134,
0,68,0,9,93,65,5,0,149,0,68,0,165,0,68,0,
2,93,0,184,0,0,69,88,184,0,25,47,27,185,0,25,
0,11,62,89,184,0,0,69,88,184,0,0,47,27,185,0,
0,0,5,62,89,184,0,0,69,88,184,0,47,47,27,185,
0,47,0,5,62,89,184,0,0,16,185,0,12,0,2,252,
184,0,35,208,184,0,36,208,184,0,25,16,185,0,61,0,
2,252,65,5,0,121,0,61,0,137,0,61,0,2,113,65,
33,0,8,0,61,0,24,0,61,0,40,0,61,0,56,0,
61,0,72,0,61,0,88,0,61,0,104,0,61,0,120,0,
61,0,136,0,61,0,152,0,61,0,168,0,61,0,184,0,
61,0,200,0,61,0,216,0,61,0,232,0,61,0,248,0,
61,0,16,93,65,15,0,8,0,61,0,24,0,61,0,40,
0,61,0,56,0,61,0,72,0,61,0,88,0,61,0,104,
0,61,0,7,113,48,49,51,39,62,3,55,51,30,3,59,
1,46,3,53,52,62,4,51,50,30,2,21,20,14,2,7,
51,50,62,2,55,23,14,3,7,33,53,62,5,53,52,46,
2,35,34,14,4,21,20,30,4,23,21,111,31,1,4,8,
11,7,45,8,16,21,30,21,220,107,140,83,33,33,65,96,
125,153,90,110,183,132,73,48,95,143,95,230,21,27,23,24,
18,45,2,7,9,10,5,254,70,58,91,69,48,30,13,47,
94,139,92,68,108,82,58,37,17,9,23,43,69,97,67,27,
24,62,68,68,32,42,64,43,21,84,157,153,153,81,65,133,
123,106,79,45,74,137,195,122,89,160,156,158,88,19,41,66,
48,19,29,71,72,68,26,111,76,120,102,89,89,95,57,91,
166,128,76,46,75,96,100,96,37,59,99,92,90,103,120,76,
111,0,255,255,0,15,0,0,2,103,6,100,2,38,3,6,
0,0,0,7,5,131,3,62,1,64,255,255,0,0,0,0,
4,150,6,100,2,38,3,17,0,0,0,7,5,131,4,95,
1,64,255,255,0,80,255,225,4,2,6,5,2,38,3,29,
0,0,0,7,2,243,1,164,0,0,255,255,0,70,255,225,
3,57,6,5,2,38,3,33,0,0,0,7,2,243,1,99,
0,0,255,255,0,55,254,72,3,216,6,5,2,38,3,35,
0,0,0,7,2,243,1,204,0,0,255,255,0,70,255,225,
2,75,6,5,2,38,3,37,0,0,0,7,2,243,0,166,
0,0,255,255,0,55,255,225,3,191,6,5,2,38,3,48,
0,0,0,7,2,244,0,150,0,0,0,2,0,80,255,225,
4,2,3,192,0,17,0,71,1,161,187,0,13,0,4,0,
52,0,4,43,184,0,13,16,65,19,0,6,0,13,0,22,
0,13,0,38,0,13,0,54,0,13,0,70,0,13,0,86,
0,13,0,102,0,13,0,118,0,13,0,134,0,13,0,9,
93,65,5,0,149,0,13,0,165,0,13,0,2,93,0,184,
0,0,69,88,184,0,57,47,27,185,0,57,0,9,62,89,
184,0,0,69,88,184,0,69,47,27,185,0,69,0,9,62,
89,184,0,0,69,88,184,0,39,47,27,185,0,39,0,5,
62,89,184,0,0,69,88,184,0,47,47,27,185,0,47,0,
5,62,89,185,0,0,0,2,252,65,33,0,7,0,0,0,
23,0,0,0,39,0,0,0,55,0,0,0,71,0,0,0,
87,0,0,0,103,0,0,0,119,0,0,0,135,0,0,0,
151,0,0,0,167,0,0,0,183,0,0,0,199,0,0,0,
215,0,0,0,231,0,0,0,247,0,0,0,16,93,65,15,
0,7,0,0,0,23,0,0,0,39,0,0,0,55,0,0,
0,71,0,0,0,87,0,0,0,103,0,0,0,7,113,65,
5,0,118,0,0,0,134,0,0,0,2,113,184,0,57,16,
185,0,8,0,2,252,65,5,0,121,0,8,0,137,0,8,
0,2,113,65,33,0,8,0,8,0,24,0,8,0,40,0,
8,0,56,0,8,0,72,0,8,0,88,0,8,0,104,0,
8,0,120,0,8,0,136,0,8,0,152,0,8,0,168,0,
8,0,184,0,8,0,200,0,8,0,216,0,8,0,232,0,
8,0,248,0,8,0,16,93,65,15,0,8,0,8,0,24,
0,8,0,40,0,8,0,56,0,8,0,72,0,8,0,88,
0,8,0,104,0,8,0,7,113,184,0,0,16,184,0,30,
208,184,0,30,47,186,0,44,0,39,0,57,17,18,57,186,
0,60,0,39,0,57,17,18,57,48,49,37,50,62,2,55,
46,1,35,34,14,2,21,20,30,2,1,14,3,7,30,5,
51,50,54,55,30,1,23,14,1,35,34,46,2,39,14,1,
35,34,46,2,53,52,62,2,51,50,22,23,55,62,1,39,
62,3,55,30,1,1,162,39,74,66,56,22,27,131,89,38,
74,58,36,26,50,73,2,138,38,62,55,51,26,13,21,19,
17,16,16,8,16,63,36,2,6,4,69,116,42,21,30,24,
20,10,76,167,70,60,109,83,49,61,107,146,86,91,147,38,
2,17,23,4,22,52,56,54,24,8,6,118,52,85,107,54,
226,212,44,89,136,92,71,135,105,64,3,38,22,62,104,154,
114,84,118,79,47,23,7,13,14,9,20,16,59,64,30,68,
112,81,149,142,57,111,166,109,108,199,151,90,166,165,9,73,
147,58,4,10,11,12,7,11,18,0,0,2,0,140,254,12,
3,172,6,14,0,33,0,81,1,44,187,0,45,0,4,0,
58,0,4,43,184,0,45,16,187,0,72,0,4,0,23,0,
4,43,184,0,72,16,184,0,45,16,184,0,0,208,186,0,
10,0,23,0,72,17,18,57,184,0,10,47,65,5,0,154,
0,10,0,170,0,10,0,2,93,65,19,0,9,0,10,0,
25,0,10,0,41,0,10,0,57,0,10,0,73,0,10,0,
89,0,10,0,105,0,10,0,121,0,10,0,137,0,10,0,
9,93,185,0,34,0,4,252,186,0,77,0,58,0,34,17,
18,57,184,0,83,220,0,184,0,0,69,88,184,0,57,47,
27,185,0,57,0,7,62,89,184,0,0,69,88,184,0,41,
47,27,185,0,41,0,5,62,89,187,0,66,0,2,0,28,
0,4,43,184,0,66,16,184,0,41,16,185,0,5,0,2,
252,65,33,0,7,0,5,0,23,0,5,0,39,0,5,0,
55,0,5,0,71,0,5,0,87,0,5,0,103,0,5,0,
119,0,5,0,135,0,5,0,151,0,5,0,167,0,5,0,
183,0,5,0,199,0,5,0,215,0,5,0,231,0,5,0,
247,0,5,0,16,93,65,15,0,7,0,5,0,23,0,5,
0,39,0,5,0,55,0,5,0,71,0,5,0,87,0,5,
0,103,0,5,0,7,113,65,5,0,118,0,5,0,134,0,
5,0,2,113,48,49,1,30,3,51,50,62,2,53,52,46,
2,43,1,39,62,3,61,1,52,46,2,35,34,14,2,21,
1,20,14,4,35,34,38,39,21,20,30,4,23,14,3,7,
39,17,52,62,4,51,50,30,2,23,21,20,14,2,7,30,
3,1,34,24,62,70,75,36,55,87,62,33,45,93,142,96,
24,7,63,105,76,42,32,53,68,36,60,76,42,16,2,138,
42,67,83,81,70,21,80,146,60,3,5,7,10,13,7,15,
42,44,41,12,41,10,31,55,91,131,90,48,92,74,47,2,
18,48,83,64,73,126,91,52,1,32,36,66,51,30,58,91,
113,54,82,137,100,56,79,13,47,68,91,58,4,75,105,67,
31,80,148,211,131,254,118,96,149,111,77,47,21,101,83,144,
79,119,89,64,48,36,17,4,14,17,16,6,29,4,194,89,
188,178,159,119,70,45,79,111,66,25,44,95,92,82,30,12,
63,102,142,0,0,1,255,246,254,12,3,186,3,192,0,53,
0,150,187,0,10,0,4,0,21,0,4,43,184,0,10,16,
184,0,5,208,184,0,5,47,65,5,0,154,0,21,0,170,
0,21,0,2,93,65,19,0,9,0,21,0,25,0,21,0,
41,0,21,0,57,0,21,0,73,0,21,0,89,0,21,0,
105,0,21,0,121,0,21,0,137,0,21,0,9,93,186,0,
44,0,21,0,10,17,18,57,0,184,0,0,69,88,184,0,
37,47,27,185,0,37,0,9,62,89,184,0,0,69,88,184,
0,52,47,27,185,0,52,0,9,62,89,184,0,0,69,88,
184,0,13,47,27,185,0,13,0,7,62,89,186,0,44,0,
13,0,37,17,18,57,48,49,1,14,3,7,30,2,6,7,
14,1,7,46,1,39,62,3,39,46,5,39,46,2,6,49,
39,62,1,55,50,30,4,23,62,3,55,62,1,55,23,3,
186,49,105,101,91,35,2,4,3,1,2,37,89,33,7,17,
14,13,21,16,8,1,3,34,54,67,73,72,31,17,39,35,
23,1,58,117,46,18,52,61,64,61,54,20,38,70,55,39,
6,42,93,38,32,3,161,107,233,242,245,117,37,112,122,115,
40,14,32,13,6,13,10,65,145,126,92,13,49,160,186,191,
159,106,9,4,4,2,1,40,11,44,26,63,109,147,169,182,
90,90,173,174,180,96,13,26,8,31,0,2,0,100,255,225,
3,134,6,15,0,20,0,75,1,77,187,0,32,0,4,0,
61,0,4,43,184,0,32,16,187,0,39,0,4,0,0,0,
4,43,184,0,39,16,65,5,0,154,0,0,0,170,0,0,
0,2,93,65,19,0,9,0,0,0,25,0,0,0,41,0,
0,0,57,0,0,0,73,0,0,0,89,0,0,0,105,0,
0,0,121,0,0,0,137,0,0,0,9,93,65,19,0,6,
0,32,0,22,0,32,0,38,0,32,0,54,0,32,0,70,
0,32,0,86,0,32,0,102,0,32,0,118,0,32,0,134,
0,32,0,9,93,65,5,0,149,0,32,0,165,0,32,0,
2,93,186,0,11,0,61,0,32,17,18,57,184,0,11,47,
185,0,51,0,4,252,186,0,56,0,51,0,39,17,18,57,
184,0,39,16,184,0,77,220,0,184,0,0,69,88,184,0,
46,47,27,185,0,46,0,5,62,89,187,0,66,0,2,0,
29,0,4,43,184,0,66,16,184,0,46,16,185,0,16,0,
2,252,65,33,0,7,0,16,0,23,0,16,0,39,0,16,
0,55,0,16,0,71,0,16,0,87,0,16,0,103,0,16,
0,119,0,16,0,135,0,16,0,151,0,16,0,167,0,16,
0,183,0,16,0,199,0,16,0,215,0,16,0,231,0,16,
0,247,0,16,0,16,93,65,15,0,7,0,16,0,23,0,
16,0,39,0,16,0,55,0,16,0,71,0,16,0,87,0,
16,0,103,0,16,0,7,113,65,5,0,118,0,16,0,134,
0,16,0,2,113,48,49,1,52,46,2,39,21,14,3,21,
20,30,2,51,50,62,2,19,14,1,35,34,46,2,35,34,
6,21,20,30,4,21,20,14,4,35,34,46,2,53,52,62,
2,55,46,3,53,52,62,2,51,50,30,2,51,50,55,30,
1,2,226,37,62,82,44,69,98,63,29,48,81,106,59,36,
69,53,32,164,73,78,20,18,83,104,109,45,22,26,85,128,
149,128,85,33,57,77,90,99,49,94,147,100,53,50,93,131,
81,48,91,71,42,30,52,72,41,68,117,103,92,44,31,23,
7,9,1,121,81,141,125,110,51,1,28,84,105,123,67,71,
138,108,67,43,76,104,4,147,71,74,37,45,37,26,33,60,
121,131,146,173,203,122,59,117,106,90,67,38,77,128,162,86,
92,161,135,104,35,52,100,100,105,58,39,68,51,29,12,15,
12,11,5,17,0,1,0,70,255,225,3,57,3,192,0,79,
1,143,187,0,31,0,4,0,52,0,4,43,184,0,31,16,
65,19,0,6,0,31,0,22,0,31,0,38,0,31,0,54,
0,31,0,70,0,31,0,86,0,31,0,102,0,31,0,118,
0,31,0,134,0,31,0,9,93,65,5,0,149,0,31,0,
165,0,31,0,2,93,186,0,60,0,52,0,31,17,18,57,
184,0,60,47,185,0,13,0,4,252,0,184,0,0,69,88,
184,0,67,47,27,185,0,67,0,9,62,89,184,0,0,69,
88,184,0,47,47,27,185,0,47,0,5,62,89,187,0,18,
0,2,0,26,0,4,43,184,0,18,16,184,0,67,16,185,
0,10,0,2,252,65,5,0,121,0,10,0,137,0,10,0,
2,113,65,33,0,8,0,10,0,24,0,10,0,40,0,10,
0,56,0,10,0,72,0,10,0,88,0,10,0,104,0,10,
0,120,0,10,0,136,0,10,0,152,0,10,0,168,0,10,
0,184,0,10,0,200,0,10,0,216,0,10,0,232,0,10,
0,248,0,10,0,16,93,65,15,0,8,0,10,0,24,0,
10,0,40,0,10,0,56,0,10,0,72,0,10,0,88,0,
10,0,104,0,10,0,7,113,184,0,47,16,185,0,36,0,
2,252,65,33,0,7,0,36,0,23,0,36,0,39,0,36,
0,55,0,36,0,71,0,36,0,87,0,36,0,103,0,36,
0,119,0,36,0,135,0,36,0,151,0,36,0,167,0,36,
0,183,0,36,0,199,0,36,0,215,0,36,0,231,0,36,
0,247,0,36,0,16,93,65,15,0,7,0,36,0,23,0,
36,0,39,0,36,0,55,0,36,0,71,0,36,0,87,0,
36,0,103,0,36,0,7,113,65,5,0,118,0,36,0,134,
0,36,0,2,113,186,0,57,0,26,0,18,17,18,57,48,
49,1,14,3,35,34,46,2,35,34,6,21,20,30,2,51,
50,54,55,23,7,46,1,35,34,14,2,21,20,30,2,51,
50,62,2,55,23,14,3,35,34,46,2,53,52,62,2,55,
46,1,53,52,62,4,51,50,30,2,51,50,62,2,51,30,
1,3,44,19,41,36,28,7,11,54,72,85,40,88,91,34,
69,104,70,27,68,30,20,52,29,44,24,72,109,73,37,40,
71,97,57,35,71,76,85,48,23,51,92,98,108,66,76,125,
90,49,30,54,73,42,75,86,34,56,73,79,77,33,44,72,
63,55,28,3,16,19,17,3,11,13,3,131,33,52,36,18,
31,37,31,83,65,31,60,48,30,8,7,21,96,8,7,36,
54,62,26,35,63,48,29,8,20,35,27,53,45,64,42,19,
39,68,93,55,43,77,65,51,18,28,97,74,43,74,63,50,
35,18,12,15,12,3,3,3,5,16,0,1,0,80,254,38,
3,41,6,12,0,70,0,228,184,0,71,47,184,0,72,47,
184,0,71,16,184,0,35,208,184,0,35,47,185,0,7,0,
4,252,65,19,0,6,0,7,0,22,0,7,0,38,0,7,
0,54,0,7,0,70,0,7,0,86,0,7,0,102,0,7,
0,118,0,7,0,134,0,7,0,9,93,65,5,0,149,0,
7,0,165,0,7,0,2,93,184,0,72,16,184,0,16,220,
185,0,26,0,4,252,65,5,0,154,0,26,0,170,0,26,
0,2,93,65,19,0,9,0,26,0,25,0,26,0,41,0,
26,0,57,0,26,0,73,0,26,0,89,0,26,0,105,0,
26,0,121,0,26,0,137,0,26,0,9,93,184,0,16,16,
184,0,68,208,184,0,68,47,186,0,40,0,35,0,68,17,
18,57,184,0,7,16,184,0,60,208,184,0,60,47,0,184,
0,21,47,184,0,55,47,184,0,58,47,184,0,60,47,184,
0,0,69,88,184,0,45,47,27,185,0,45,0,11,62,89,
186,0,40,0,21,0,58,17,18,57,48,49,1,14,5,21,
20,30,6,21,20,14,2,7,38,39,62,1,53,52,46,6,
53,52,62,2,55,14,3,35,34,46,2,39,48,46,2,39,
62,1,51,50,23,30,3,51,50,54,55,30,1,3,41,74,
142,127,107,77,44,47,77,99,103,99,77,47,24,59,96,72,
27,17,75,65,47,78,99,104,99,78,47,76,139,196,120,53,
97,82,62,17,13,31,29,20,2,6,9,8,3,10,20,11,
7,10,3,15,27,43,32,52,220,165,2,11,5,118,55,140,
161,177,182,183,87,70,91,61,37,29,30,46,71,56,37,78,
94,114,73,11,25,99,133,51,43,52,33,23,30,45,77,118,
88,129,255,249,244,119,16,21,12,4,6,12,20,14,47,63,
64,17,3,5,2,10,40,39,29,7,23,12,34,0,0,1,
0,55,254,72,3,216,3,192,0,65,0,224,187,0,4,0,
4,0,18,0,4,43,184,0,4,16,184,0,18,16,184,0,
13,208,184,0,13,47,184,0,4,16,184,0,67,220,0,184,
0,12,47,184,0,0,69,88,184,0,0,47,27,185,0,0,
0,9,62,89,184,0,0,69,88,184,0,56,47,27,185,0,
56,0,9,62,89,186,0,9,0,12,0,0,17,18,57,184,
0,0,16,185,0,24,0,2,252,65,5,0,121,0,24,0,
137,0,24,0,2,113,65,33,0,8,0,24,0,24,0,24,
0,40,0,24,0,56,0,24,0,72,0,24,0,88,0,24,
0,104,0,24,0,120,0,24,0,136,0,24,0,152,0,24,
0,168,0,24,0,184,0,24,0,200,0,24,0,216,0,24,
0,232,0,24,0,248,0,24,0,16,93,65,15,0,8,0,
24,0,24,0,24,0,40,0,24,0,56,0,24,0,72,0,
24,0,88,0,24,0,104,0,24,0,7,113,184,0,50,208,
186,0,63,0,12,0,0,17,18,57,48,49,1,50,22,21,
17,20,30,2,23,14,1,7,39,62,3,53,17,52,46,2,
35,34,14,2,7,17,20,30,2,23,14,1,7,39,62,3,
53,17,52,46,2,39,53,62,3,55,23,20,30,3,49,62,
1,2,214,113,98,3,10,18,16,43,86,35,39,1,2,2,
1,7,25,46,39,29,65,77,92,55,2,6,7,4,34,71,
36,39,2,4,3,2,6,28,59,54,36,61,58,59,33,35,
2,3,3,1,98,188,3,192,138,132,253,127,92,142,105,70,
19,14,31,16,29,20,73,84,83,29,2,210,49,84,62,35,
23,62,110,86,254,199,35,56,50,48,25,13,24,16,31,20,
57,61,59,23,1,205,52,59,31,12,5,40,5,16,20,24,
15,35,2,48,75,72,52,142,142,0,0,3,0,91,255,225,
3,164,5,171,0,12,0,27,0,49,1,105,184,0,50,47,
184,0,51,47,184,0,50,16,184,0,38,208,184,0,38,47,
185,0,5,0,4,252,65,19,0,6,0,5,0,22,0,5,
0,38,0,5,0,54,0,5,0,70,0,5,0,86,0,5,
0,102,0,5,0,118,0,5,0,134,0,5,0,9,93,65,
5,0,149,0,5,0,165,0,5,0,2,93,184,0,51,16,
184,0,28,220,185,0,18,0,4,252,65,5,0,154,0,18,
0,170,0,18,0,2,93,65,19,0,9,0,18,0,25,0,
18,0,41,0,18,0,57,0,18,0,73,0,18,0,89,0,
18,0,105,0,18,0,121,0,18,0,137,0,18,0,9,93,
184,0,8,208,184,0,8,47,184,0,5,16,184,0,23,208,
184,0,23,47,0,184,0,0,69,88,184,0,33,47,27,185,
0,33,0,5,62,89,187,0,45,0,2,0,0,0,4,43,
184,0,45,16,187,0,5,0,2,0,18,0,4,43,184,0,
5,16,184,0,8,208,184,0,8,47,184,0,33,16,185,0,
13,0,2,252,65,33,0,7,0,13,0,23,0,13,0,39,
0,13,0,55,0,13,0,71,0,13,0,87,0,13,0,103,
0,13,0,119,0,13,0,135,0,13,0,151,0,13,0,167,
0,13,0,183,0,13,0,199,0,13,0,215,0,13,0,231,
0,13,0,247,0,13,0,16,93,65,15,0,7,0,13,0,
23,0,13,0,39,0,13,0,55,0,13,0,71,0,13,0,
87,0,13,0,103,0,13,0,7,113,65,5,0,118,0,13,
0,134,0,13,0,2,113,184,0,18,16,184,0,23,208,184,
0,23,47,48,49,1,34,14,2,7,22,54,55,46,3,3,
50,62,2,39,46,1,14,1,7,30,3,1,22,2,14,1,
35,34,46,1,2,53,38,62,4,51,50,30,1,18,1,244,
68,94,59,27,1,140,254,121,9,41,66,92,32,72,98,58,
21,3,65,135,133,129,57,5,39,68,97,1,213,1,64,116,
163,98,98,150,100,51,1,29,55,77,96,111,62,102,153,102,
52,5,49,69,138,206,136,12,3,8,114,201,149,86,251,42,
75,147,217,142,4,4,1,5,4,119,211,157,92,2,108,154,
254,242,201,117,110,193,1,8,154,102,193,169,140,101,56,116,
201,254,243,0,0,1,0,70,255,225,2,67,3,192,0,29,
0,51,187,0,20,0,4,0,8,0,4,43,184,0,20,16,
0,184,0,0,69,88,184,0,18,47,27,185,0,18,0,9,
62,89,184,0,0,69,88,184,0,3,47,27,185,0,3,0,
5,62,89,48,49,37,14,1,35,34,46,2,55,19,54,46,
2,35,53,62,1,55,23,3,6,30,2,51,50,54,55,23,
2,67,92,126,33,35,45,26,10,1,8,1,6,29,62,55,
65,148,66,32,10,1,6,12,17,11,15,75,63,10,109,72,
68,28,57,89,60,1,210,52,66,38,14,40,11,41,29,40,
253,151,69,80,41,10,19,32,45,0,0,1,0,55,255,225,
4,19,3,192,0,81,0,238,187,0,17,0,4,0,33,0,
4,43,184,0,17,16,184,0,46,208,0,184,0,0,69,88,
184,0,45,47,27,185,0,45,0,9,62,89,184,0,0,69,
88,184,0,54,47,27,185,0,54,0,9,62,89,184,0,0,
69,88,184,0,5,47,27,185,0,5,0,5,62,89,184,0,
0,69,88,184,0,27,47,27,185,0,27,0,5,62,89,187,
0,66,0,2,0,12,0,4,43,184,0,66,16,186,0,47,
0,5,0,45,17,18,57,184,0,5,16,185,0,74,0,2,
252,65,33,0,7,0,74,0,23,0,74,0,39,0,74,0,
55,0,74,0,71,0,74,0,87,0,74,0,103,0,74,0,
119,0,74,0,135,0,74,0,151,0,74,0,167,0,74,0,
183,0,74,0,199,0,74,0,215,0,74,0,231,0,74,0,
247,0,74,0,16,93,65,15,0,7,0,74,0,23,0,74,
0,39,0,74,0,55,0,74,0,71,0,74,0,87,0,74,
0,103,0,74,0,7,113,65,5,0,118,0,74,0,134,0,
74,0,2,113,48,49,37,14,3,35,34,46,4,35,34,6,
7,6,7,20,30,2,23,14,3,7,39,62,3,53,17,52,
46,2,39,53,62,3,55,23,17,62,5,51,30,2,39,14,
1,7,14,3,7,51,50,30,4,51,50,62,2,55,30,1,
4,19,41,73,62,46,13,27,49,46,44,45,47,26,18,46,
24,39,45,3,4,6,3,13,36,39,38,15,38,3,5,3,
2,5,27,60,55,37,75,70,62,25,28,100,153,115,85,66,
53,26,1,9,11,1,20,47,23,33,56,65,82,58,9,32,
57,52,50,49,49,26,17,28,28,30,20,2,6,82,26,41,
30,16,69,104,121,104,69,25,21,47,52,29,75,76,66,20,
5,14,15,16,6,31,16,53,66,77,40,1,165,55,62,32,
13,5,40,6,18,23,23,10,34,254,2,128,180,121,70,36,
9,1,14,15,1,50,87,24,5,18,44,77,64,69,102,121,
102,69,3,7,11,7,11,24,0,1,0,20,255,225,4,69,
5,230,0,63,0,51,0,184,0,0,69,88,184,0,3,47,
27,185,0,3,0,5,62,89,184,0,0,69,88,184,0,23,
47,27,185,0,23,0,5,62,89,187,0,45,0,2,0,36,
0,4,43,184,0,45,16,48,49,37,14,1,35,34,46,4,
39,46,1,39,14,3,7,14,3,7,39,62,5,55,46,3,
35,34,6,7,39,62,3,51,50,30,4,23,30,3,51,50,
62,2,55,23,4,69,75,97,34,26,44,41,42,53,66,43,
8,15,8,38,72,72,73,37,20,53,56,52,18,30,49,94,
89,82,71,60,22,33,53,45,41,21,35,73,49,24,50,81,
65,51,21,23,40,41,44,56,71,46,40,72,66,60,28,12,
20,25,33,25,10,92,57,66,25,64,110,172,241,162,29,56,
26,100,196,202,213,117,5,15,17,15,5,33,62,160,180,193,
188,176,74,103,125,67,21,34,38,51,51,69,42,18,15,51,
97,165,243,171,148,246,176,97,3,8,14,11,45,0,0,1,
0,61,254,12,4,61,3,192,0,76,1,20,187,0,17,0,
3,0,28,0,4,43,184,0,17,16,187,0,70,0,4,0,
56,0,4,43,184,0,70,16,184,0,56,16,184,0,10,208,
186,0,22,0,28,0,70,17,18,57,184,0,28,16,185,0,
46,0,4,252,186,0,62,0,28,0,70,17,18,57,184,0,
70,16,184,0,78,220,0,184,0,0,69,88,184,0,40,47,
27,185,0,40,0,9,62,89,184,0,0,69,88,184,0,65,
47,27,185,0,65,0,9,62,89,184,0,0,69,88,184,0,
27,47,27,185,0,27,0,7,62,89,184,0,0,69,88,184,
0,5,47,27,185,0,5,0,5,62,89,184,0,0,69,88,
184,0,13,47,27,185,0,13,0,5,62,89,186,0,10,0,
27,0,40,17,18,57,184,0,51,220,65,27,0,7,0,51,
0,23,0,51,0,39,0,51,0,55,0,51,0,71,0,51,
0,87,0,51,0,103,0,51,0,119,0,51,0,135,0,51,
0,151,0,51,0,167,0,51,0,183,0,51,0,199,0,51,
0,13,93,65,5,0,214,0,51,0,230,0,51,0,2,93,
186,0,17,0,13,0,51,17,18,57,186,0,22,0,27,0,
40,17,18,57,186,0,62,0,27,0,40,17,18,57,48,49,
37,14,3,35,34,46,2,39,14,1,35,34,38,39,21,6,
30,2,23,14,3,7,39,17,52,46,2,39,53,62,3,55,
48,30,2,23,17,20,30,2,51,50,62,2,55,17,52,46,
2,39,62,1,55,23,14,1,7,17,20,22,51,50,54,55,
4,61,30,64,60,51,17,21,30,20,11,1,81,151,58,59,
114,44,1,23,39,51,26,15,51,55,49,12,39,5,25,52,
47,39,65,58,53,26,9,12,13,4,26,47,68,42,27,57,
63,70,40,7,11,13,7,44,91,41,28,4,10,2,18,21,
22,51,33,82,19,40,33,21,34,58,76,43,105,106,81,72,
6,111,174,134,95,31,5,19,21,20,6,29,4,178,39,44,
24,11,5,40,7,12,15,18,14,10,13,15,5,253,217,35,
82,70,48,10,33,61,52,1,205,16,45,44,38,9,12,31,
17,39,26,73,63,254,21,93,76,15,13,0,0,1,0,10,
255,225,3,192,3,192,0,45,0,64,0,184,0,0,69,88,
184,0,27,47,27,185,0,27,0,9,62,89,184,0,0,69,
88,184,0,43,47,27,185,0,43,0,9,62,89,184,0,0,
69,88,184,0,8,47,27,185,0,8,0,5,62,89,186,0,
35,0,8,0,27,17,18,57,48,49,1,14,3,7,14,1,
7,39,46,3,39,46,1,39,46,2,35,34,49,53,62,1,
55,50,22,23,30,3,23,62,3,39,62,1,55,30,1,3,
192,18,51,84,128,94,16,57,19,40,30,70,67,60,20,15,
46,18,11,40,38,14,14,63,106,44,23,60,32,16,56,64,
64,25,69,91,47,3,18,46,87,40,8,19,3,161,102,194,
214,249,158,9,25,9,31,124,229,193,150,47,35,42,8,5,
5,1,38,14,45,24,57,72,39,137,177,207,109,97,209,200,
178,67,14,23,10,5,21,0,0,1,0,80,254,38,3,108,
6,47,0,88,0,219,187,0,19,0,4,0,50,0,4,43,
184,0,19,16,187,0,28,0,4,0,41,0,4,43,184,0,
28,16,65,19,0,6,0,19,0,22,0,19,0,38,0,19,
0,54,0,19,0,70,0,19,0,86,0,19,0,102,0,19,
0,118,0,19,0,134,0,19,0,9,93,65,5,0,149,0,
19,0,165,0,19,0,2,93,186,0,60,0,50,0,19,17,
18,57,184,0,60,47,185,0,3,0,4,252,65,5,0,154,
0,41,0,170,0,41,0,2,93,65,19,0,9,0,41,0,
25,0,41,0,41,0,41,0,57,0,41,0,73,0,41,0,
89,0,41,0,105,0,41,0,121,0,41,0,137,0,41,0,
9,93,186,0,55,0,50,0,28,17,18,57,186,0,63,0,
50,0,28,17,18,57,184,0,28,16,184,0,90,220,0,184,
0,73,47,184,0,76,47,184,0,33,47,186,0,55,0,33,
0,76,17,18,57,186,0,63,0,33,0,76,17,18,57,48,
49,1,14,1,21,20,30,2,51,50,54,55,30,1,23,14,
3,21,20,30,6,21,20,14,2,7,46,1,39,62,3,53,
52,46,6,53,52,62,2,55,46,3,53,52,54,55,14,3,
35,34,46,2,39,62,1,51,30,3,51,50,62,2,55,30,
1,3,87,251,246,58,93,115,58,21,39,17,2,2,2,132,
201,135,68,56,91,116,121,116,91,56,20,51,87,67,16,20,
10,31,43,26,11,55,89,114,120,114,89,55,51,96,135,84,
75,95,53,19,177,183,24,69,66,53,9,20,26,21,23,16,
14,25,14,12,23,27,36,26,40,83,99,121,78,8,10,5,
140,69,173,103,52,69,42,18,3,2,20,40,20,17,93,127,
147,70,63,86,58,38,32,32,48,69,53,29,72,88,107,64,
6,18,12,38,61,52,44,22,55,67,42,27,31,43,74,115,
87,74,151,135,108,31,15,50,61,66,30,103,171,75,6,11,
10,6,13,45,87,73,5,3,33,41,23,8,2,5,9,6,
16,47,0,2,0,85,255,226,3,167,3,192,0,19,0,43,
1,175,184,0,44,47,184,0,45,47,184,0,20,220,185,0,
0,0,4,252,65,5,0,154,0,0,0,170,0,0,0,2,
93,65,19,0,9,0,0,0,25,0,0,0,41,0,0,0,
57,0,0,0,73,0,0,0,89,0,0,0,105,0,0,0,
121,0,0,0,137,0,0,0,9,93,184,0,44,16,184,0,
32,208,184,0,32,47,185,0,10,0,4,252,65,19,0,6,
0,10,0,22,0,10,0,38,0,10,0,54,0,10,0,70,
0,10,0,86,0,10,0,102,0,10,0,118,0,10,0,134,
0,10,0,9,93,65,5,0,149,0,10,0,165,0,10,0,
2,93,0,184,0,0,69,88,184,0,39,47,27,185,0,39,
0,9,62,89,184,0,0,69,88,184,0,27,47,27,185,0,
27,0,5,62,89,184,0,39,16,185,0,5,0,2,252,65,
5,0,121,0,5,0,137,0,5,0,2,113,65,33,0,8,
0,5,0,24,0,5,0,40,0,5,0,56,0,5,0,72,
0,5,0,88,0,5,0,104,0,5,0,120,0,5,0,136,
0,5,0,152,0,5,0,168,0,5,0,184,0,5,0,200,
0,5,0,216,0,5,0,232,0,5,0,248,0,5,0,16,
93,65,15,0,8,0,5,0,24,0,5,0,40,0,5,0,
56,0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,
7,113,184,0,27,16,185,0,15,0,2,252,65,33,0,7,
0,15,0,23,0,15,0,39,0,15,0,55,0,15,0,71,
0,15,0,87,0,15,0,103,0,15,0,119,0,15,0,135,
0,15,0,151,0,15,0,167,0,15,0,183,0,15,0,199,
0,15,0,215,0,15,0,231,0,15,0,247,0,15,0,16,
93,65,15,0,7,0,15,0,23,0,15,0,39,0,15,0,
55,0,15,0,71,0,15,0,87,0,15,0,103,0,15,0,
7,113,65,5,0,118,0,15,0,134,0,15,0,2,113,48,
49,1,52,46,2,35,34,14,2,21,20,30,2,51,50,62,
2,55,20,14,4,35,34,46,2,53,52,62,4,51,50,30,
2,3,14,49,80,101,51,69,99,65,30,52,83,104,52,63,
95,63,32,153,33,59,83,98,112,59,90,150,107,59,32,59,
81,99,113,61,91,150,106,58,1,199,79,143,109,64,58,101,
138,80,79,143,108,63,53,98,138,116,66,129,114,97,70,39,
72,126,174,102,66,128,115,97,70,40,72,127,174,0,0,2,
0,140,254,12,3,121,3,192,0,18,0,53,1,152,184,0,
54,47,184,0,55,47,184,0,54,16,184,0,44,208,184,0,
44,47,185,0,32,0,4,252,184,0,0,208,184,0,55,16,
184,0,19,220,185,0,8,0,4,252,65,5,0,154,0,8,
0,170,0,8,0,2,93,65,19,0,9,0,8,0,25,0,
8,0,41,0,8,0,57,0,8,0,73,0,8,0,89,0,
8,0,105,0,8,0,121,0,8,0,137,0,8,0,9,93,
0,184,0,0,69,88,184,0,49,47,27,185,0,49,0,9,
62,89,184,0,0,69,88,184,0,40,47,27,185,0,40,0,
7,62,89,184,0,0,69,88,184,0,26,47,27,185,0,26,
0,5,62,89,185,0,5,0,2,252,65,33,0,7,0,5,
0,23,0,5,0,39,0,5,0,55,0,5,0,71,0,5,
0,87,0,5,0,103,0,5,0,119,0,5,0,135,0,5,
0,151,0,5,0,167,0,5,0,183,0,5,0,199,0,5,
0,215,0,5,0,231,0,5,0,247,0,5,0,16,93,65,
15,0,7,0,5,0,23,0,5,0,39,0,5,0,55,0,
5,0,71,0,5,0,87,0,5,0,103,0,5,0,7,113,
65,5,0,118,0,5,0,134,0,5,0,2,113,184,0,49,
16,185,0,13,0,2,252,65,5,0,121,0,13,0,137,0,
13,0,2,113,65,33,0,8,0,13,0,24,0,13,0,40,
0,13,0,56,0,13,0,72,0,13,0,88,0,13,0,104,
0,13,0,120,0,13,0,136,0,13,0,152,0,13,0,168,
0,13,0,184,0,13,0,200,0,13,0,216,0,13,0,232,
0,13,0,248,0,13,0,16,93,65,15,0,8,0,13,0,
24,0,13,0,40,0,13,0,56,0,13,0,72,0,13,0,
88,0,13,0,104,0,13,0,7,113,186,0,31,0,26,0,
5,17,18,57,48,49,37,30,3,51,50,54,53,52,46,2,
35,34,14,2,21,37,20,14,4,35,34,46,2,39,21,20,
30,2,23,14,1,7,46,1,39,17,52,62,2,51,50,30,
2,1,34,44,65,54,47,26,104,112,42,71,93,52,37,70,
54,33,2,87,31,54,71,80,85,40,18,45,58,72,45,2,
7,17,15,46,75,42,11,9,8,67,112,144,77,86,130,88,
45,208,32,41,24,10,177,167,96,152,107,56,45,103,169,123,
107,71,138,123,104,76,42,10,28,50,40,26,76,158,140,109,
27,15,28,18,5,10,9,3,113,135,207,141,72,74,122,158,
0,1,0,80,254,36,3,49,3,192,0,68,1,47,184,0,
69,47,184,0,70,47,184,0,69,16,184,0,50,208,184,0,
50,47,185,0,17,0,4,252,65,19,0,6,0,17,0,22,
0,17,0,38,0,17,0,54,0,17,0,70,0,17,0,86,
0,17,0,102,0,17,0,118,0,17,0,134,0,17,0,9,
93,65,5,0,149,0,17,0,165,0,17,0,2,93,184,0,
70,16,184,0,27,220,185,0,38,0,4,252,65,5,0,154,
0,38,0,170,0,38,0,2,93,65,19,0,9,0,38,0,
25,0,38,0,41,0,38,0,57,0,38,0,73,0,38,0,
89,0,38,0,105,0,38,0,121,0,38,0,137,0,38,0,
9,93,0,184,0,32,47,184,0,0,69,88,184,0,58,47,
27,185,0,58,0,9,62,89,185,0,10,0,2,252,65,5,
0,121,0,10,0,137,0,10,0,2,113,65,33,0,8,0,
10,0,24,0,10,0,40,0,10,0,56,0,10,0,72,0,
10,0,88,0,10,0,104,0,10,0,120,0,10,0,136,0,
10,0,152,0,10,0,168,0,10,0,184,0,10,0,200,0,
10,0,216,0,10,0,232,0,10,0,248,0,10,0,16,93,
65,15,0,8,0,10,0,24,0,10,0,40,0,10,0,56,
0,10,0,72,0,10,0,88,0,10,0,104,0,10,0,7,
113,186,0,0,0,58,0,10,17,18,57,48,49,1,14,3,
35,34,46,2,35,34,14,4,21,20,30,2,23,30,3,21,
20,14,2,7,46,1,39,62,1,53,52,46,2,39,46,5,
53,52,62,2,55,62,1,51,50,30,2,51,50,54,51,30,
1,3,49,15,37,38,35,13,14,41,57,72,43,42,67,51,
37,23,11,30,62,96,66,60,103,75,43,25,53,80,55,16,
21,10,55,48,41,67,84,43,21,58,63,62,49,31,22,49,
77,55,54,124,64,32,58,59,60,34,5,9,5,11,10,3,
125,20,46,40,27,27,33,28,42,69,89,94,91,36,56,87,
70,57,25,23,45,56,72,49,29,80,95,105,54,8,18,12,
67,130,46,38,55,42,31,14,7,26,40,58,78,100,63,71,
141,131,118,47,45,50,12,14,12,1,10,17,0,2,0,80,
255,225,3,212,3,192,0,22,0,62,1,226,184,0,63,47,
184,0,64,47,184,0,36,220,185,0,0,0,4,252,65,5,
0,154,0,0,0,170,0,0,0,2,93,65,19,0,9,0,
0,0,25,0,0,0,41,0,0,0,57,0,0,0,73,0,
0,0,89,0,0,0,105,0,0,0,121,0,0,0,137,0,
0,0,9,93,184,0,63,16,184,0,48,208,184,0,48,47,
185,0,13,0,4,252,65,19,0,6,0,13,0,22,0,13,
0,38,0,13,0,54,0,13,0,70,0,13,0,86,0,13,
0,102,0,13,0,118,0,13,0,134,0,13,0,9,93,65,
5,0,149,0,13,0,165,0,13,0,2,93,186,0,31,0,
48,0,36,17,18,57,0,184,0,0,69,88,184,0,23,47,
27,185,0,23,0,9,62,89,184,0,0,69,88,184,0,55,
47,27,185,0,55,0,9,62,89,184,0,0,69,88,184,0,
43,47,27,185,0,43,0,5,62,89,184,0,55,16,185,0,
5,0,2,252,65,5,0,121,0,5,0,137,0,5,0,2,
113,65,33,0,8,0,5,0,24,0,5,0,40,0,5,0,
56,0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,
120,0,5,0,136,0,5,0,152,0,5,0,168,0,5,0,
184,0,5,0,200,0,5,0,216,0,5,0,232,0,5,0,
248,0,5,0,16,93,65,15,0,8,0,5,0,24,0,5,
0,40,0,5,0,56,0,5,0,72,0,5,0,88,0,5,
0,104,0,5,0,7,113,184,0,8,208,184,0,43,16,185,
0,18,0,2,252,65,33,0,7,0,18,0,23,0,18,0,
39,0,18,0,55,0,18,0,71,0,18,0,87,0,18,0,
103,0,18,0,119,0,18,0,135,0,18,0,151,0,18,0,
167,0,18,0,183,0,18,0,199,0,18,0,215,0,18,0,
231,0,18,0,247,0,18,0,16,93,65,15,0,7,0,18,
0,23,0,18,0,39,0,18,0,55,0,18,0,71,0,18,
0,87,0,18,0,103,0,18,0,7,113,65,5,0,118,0,
18,0,134,0,18,0,2,113,184,0,8,16,184,0,28,208,
184,0,28,47,184,0,31,208,184,0,31,47,48,49,1,52,
46,2,39,46,1,35,34,14,2,21,20,30,2,51,50,62,
2,1,14,3,35,34,38,39,22,23,30,1,21,20,14,4,
35,34,46,2,53,52,62,4,51,33,50,62,2,55,23,2,
207,29,45,56,26,40,64,17,57,83,54,26,41,74,105,63,
64,83,48,19,1,5,30,43,37,38,26,32,87,47,9,6,
111,99,24,47,69,90,110,65,82,139,102,57,30,57,79,99,
114,63,1,50,30,36,25,21,15,25,1,124,70,126,105,84,
28,1,1,47,79,102,55,74,152,124,79,55,85,106,2,90,
48,56,30,8,1,1,3,3,80,171,110,40,98,101,96,75,
45,76,127,166,91,61,122,111,96,71,40,1,6,12,11,29,
0,1,0,30,255,225,3,113,3,192,0,51,1,140,187,0,
40,0,4,0,10,0,4,43,184,0,40,16,65,19,0,6,
0,40,0,22,0,40,0,38,0,40,0,54,0,40,0,70,
0,40,0,86,0,40,0,102,0,40,0,118,0,40,0,134,
0,40,0,9,93,65,5,0,149,0,40,0,165,0,40,0,
2,93,0,184,0,0,69,88,184,0,26,47,27,185,0,26,
0,9,62,89,184,0,0,69,88,184,0,31,47,27,185,0,
31,0,9,62,89,184,0,0,69,88,184,0,5,47,27,185,
0,5,0,5,62,89,184,0,26,16,185,0,13,0,2,252,
65,5,0,121,0,13,0,137,0,13,0,2,113,65,33,0,
8,0,13,0,24,0,13,0,40,0,13,0,56,0,13,0,
72,0,13,0,88,0,13,0,104,0,13,0,120,0,13,0,
136,0,13,0,152,0,13,0,168,0,13,0,184,0,13,0,
200,0,13,0,216,0,13,0,232,0,13,0,248,0,13,0,
16,93,65,15,0,8,0,13,0,24,0,13,0,40,0,13,
0,56,0,13,0,72,0,13,0,88,0,13,0,104,0,13,
0,7,113,184,0,16,208,184,0,17,208,184,0,34,208,184,
0,34,47,184,0,37,208,184,0,37,47,184,0,5,16,185,
0,45,0,2,252,65,33,0,7,0,45,0,23,0,45,0,
39,0,45,0,55,0,45,0,71,0,45,0,87,0,45,0,
103,0,45,0,119,0,45,0,135,0,45,0,151,0,45,0,
167,0,45,0,183,0,45,0,199,0,45,0,215,0,45,0,
231,0,45,0,247,0,45,0,16,93,65,15,0,7,0,45,
0,23,0,45,0,39,0,45,0,55,0,45,0,71,0,45,
0,87,0,45,0,103,0,45,0,7,113,65,5,0,118,0,
45,0,134,0,45,0,2,113,48,49,37,14,3,35,34,46,
2,53,52,18,55,34,38,43,1,34,6,7,39,62,3,51,
33,50,54,55,23,14,1,35,34,38,39,14,1,21,20,30,
2,51,50,62,2,55,23,3,8,57,91,77,67,32,42,58,
38,17,30,14,25,44,18,41,41,71,50,21,24,54,58,62,
32,1,192,50,73,23,27,51,91,52,43,127,66,8,4,6,
20,40,35,19,41,50,62,40,24,127,38,59,40,21,47,74,
93,45,115,1,31,162,1,25,31,35,29,56,45,28,11,19,
30,65,79,2,2,132,214,85,32,86,76,53,6,14,23,17,
45,0,0,1,0,55,255,225,3,191,3,192,0,59,1,21,
187,0,27,0,4,0,17,0,4,43,184,0,27,16,187,0,
0,0,4,0,44,0,4,43,184,0,0,16,186,0,32,0,
17,0,27,17,18,57,184,0,32,47,185,0,12,0,4,252,
65,5,0,154,0,44,0,170,0,44,0,2,93,65,19,0,
9,0,44,0,25,0,44,0,41,0,44,0,57,0,44,0,
73,0,44,0,89,0,44,0,105,0,44,0,121,0,44,0,
137,0,44,0,9,93,0,184,0,0,69,88,184,0,26,47,
27,185,0,26,0,9,62,89,184,0,0,69,88,184,0,55,
47,27,185,0,55,0,9,62,89,184,0,0,69,88,184,0,
7,47,27,185,0,7,0,5,62,89,185,0,37,0,2,252,
65,33,0,7,0,37,0,23,0,37,0,39,0,37,0,55,
0,37,0,71,0,37,0,87,0,37,0,103,0,37,0,119,
0,37,0,135,0,37,0,151,0,37,0,167,0,37,0,183,
0,37,0,199,0,37,0,215,0,37,0,231,0,37,0,247,
0,37,0,16,93,65,15,0,7,0,37,0,23,0,37,0,
39,0,37,0,55,0,37,0,71,0,37,0,87,0,37,0,
103,0,37,0,7,113,65,5,0,118,0,37,0,134,0,37,
0,2,113,48,49,1,20,14,4,35,34,46,2,53,52,62,
2,53,52,46,2,39,53,62,1,55,23,22,14,2,21,20,
30,2,51,50,62,4,53,54,46,2,47,1,62,3,55,30,
3,3,191,34,61,87,109,129,72,48,102,82,53,4,5,4,
8,29,55,48,69,124,68,29,6,3,7,9,33,55,71,39,
45,78,64,49,34,18,1,21,42,66,44,18,19,49,53,50,
19,32,52,37,20,2,95,70,149,141,127,95,56,40,94,153,
113,53,91,90,94,55,27,37,24,12,2,40,6,31,29,39,
26,98,131,156,82,89,127,82,39,45,74,95,103,102,43,61,
104,80,53,10,38,8,18,16,14,5,10,57,90,121,0,2,
0,80,254,28,4,203,3,196,0,21,0,84,2,10,187,0,
70,0,4,0,55,0,4,43,184,0,70,16,187,0,27,0,
4,0,10,0,4,43,184,0,27,16,187,0,0,0,4,0,
80,0,4,43,184,0,0,16,184,0,5,208,184,0,5,47,
65,5,0,154,0,10,0,170,0,10,0,2,93,65,19,0,
9,0,10,0,25,0,10,0,41,0,10,0,57,0,10,0,
73,0,10,0,89,0,10,0,105,0,10,0,121,0,10,0,
137,0,10,0,9,93,184,0,0,16,184,0,20,208,184,0,
0,16,184,0,32,208,184,0,32,47,65,19,0,6,0,70,
0,22,0,70,0,38,0,70,0,54,0,70,0,70,0,70,
0,86,0,70,0,102,0,70,0,118,0,70,0,134,0,70,
0,9,93,65,5,0,149,0,70,0,165,0,70,0,2,93,
184,0,80,16,184,0,75,208,184,0,75,47,184,0,27,16,
184,0,86,220,0,184,0,22,47,184,0,62,47,184,0,0,
69,88,184,0,40,47,27,185,0,40,0,7,62,89,184,0,
0,69,88,184,0,32,47,27,185,0,32,0,5,62,89,184,
0,0,69,88,184,0,48,47,27,185,0,48,0,5,62,89,
184,0,32,16,185,0,5,0,2,252,65,33,0,7,0,5,
0,23,0,5,0,39,0,5,0,55,0,5,0,71,0,5,
0,87,0,5,0,103,0,5,0,119,0,5,0,135,0,5,
0,151,0,5,0,167,0,5,0,183,0,5,0,199,0,5,
0,215,0,5,0,231,0,5,0,247,0,5,0,16,93,65,
15,0,7,0,5,0,23,0,5,0,39,0,5,0,55,0,
5,0,71,0,5,0,87,0,5,0,103,0,5,0,7,113,
65,5,0,118,0,5,0,134,0,5,0,2,113,184,0,22,
16,185,0,15,0,2,252,65,5,0,121,0,15,0,137,0,
15,0,2,113,65,33,0,8,0,15,0,24,0,15,0,40,
0,15,0,56,0,15,0,72,0,15,0,88,0,15,0,104,
0,15,0,120,0,15,0,136,0,15,0,152,0,15,0,168,
0,15,0,184,0,15,0,200,0,15,0,216,0,15,0,232,
0,15,0,248,0,15,0,16,93,65,15,0,8,0,15,0,
24,0,15,0,40,0,15,0,56,0,15,0,72,0,15,0,
88,0,15,0,104,0,15,0,7,113,184,0,5,16,184,0,
75,208,184,0,75,47,48,49,1,20,30,2,23,62,3,53,
52,46,2,35,34,14,2,29,1,19,50,30,2,21,20,14,
2,7,30,3,23,14,1,7,46,1,39,62,3,55,46,5,
53,52,62,4,55,30,1,23,14,3,21,20,30,2,23,62,
3,55,52,62,2,2,208,1,1,1,1,88,138,96,50,40,
69,90,50,29,46,34,18,181,73,120,86,47,76,133,184,108,
1,3,5,6,3,37,81,39,11,10,10,3,6,5,5,2,
93,146,110,78,48,22,13,34,60,94,132,90,8,10,3,83,
110,66,27,44,86,128,84,1,3,2,2,1,47,82,115,1,
220,32,88,105,119,61,9,61,105,149,96,66,126,99,61,16,
63,126,111,51,1,228,73,117,146,74,123,201,147,90,14,60,
116,104,89,32,13,28,17,6,11,11,27,89,112,131,68,5,
46,70,91,103,109,53,39,92,95,97,88,77,28,12,32,10,
37,101,112,118,54,71,137,114,80,13,58,112,99,83,30,127,
190,126,62,0,0,1,0,20,254,132,3,228,3,192,0,71,
0,65,0,184,0,5,47,184,0,20,47,184,0,0,69,88,
184,0,41,47,27,185,0,41,0,9,62,89,184,0,0,69,
88,184,0,56,47,27,185,0,56,0,9,62,89,186,0,10,
0,5,0,41,17,18,57,186,0,48,0,5,0,41,17,18,
57,48,49,1,14,3,35,34,46,2,39,14,3,7,14,3,
7,39,54,18,55,46,3,39,46,1,35,34,6,49,53,62,
3,55,30,5,23,54,18,55,62,3,55,23,6,2,7,30,
3,51,50,62,2,55,23,3,228,47,65,46,33,14,36,65,
71,83,53,23,57,60,58,24,20,49,51,49,18,29,119,195,
78,57,90,74,63,30,12,35,17,16,23,36,56,52,52,33,
12,27,33,43,55,69,44,64,107,38,19,47,49,47,18,28,
106,184,84,49,88,75,61,23,8,19,27,36,25,10,254,254,
37,47,27,11,59,127,199,140,50,121,127,126,55,2,11,13,
14,6,34,149,1,53,156,156,210,130,61,9,3,3,1,40,
7,17,19,24,14,8,21,42,72,116,169,119,131,1,10,119,
2,7,7,10,5,33,154,254,202,168,132,203,138,71,2,8,
14,12,45,0,0,1,0,58,254,28,4,228,5,87,0,97,
1,128,187,0,48,0,4,0,34,0,4,43,184,0,48,16,
187,0,77,0,3,0,61,0,4,43,184,0,77,16,187,0,
5,0,4,0,85,0,4,43,184,0,5,16,184,0,77,16,
184,0,12,208,184,0,12,47,65,19,0,6,0,48,0,22,
0,48,0,38,0,48,0,54,0,48,0,70,0,48,0,86,
0,48,0,102,0,48,0,118,0,48,0,134,0,48,0,9,
93,65,5,0,149,0,48,0,165,0,48,0,2,93,186,0,
53,0,34,0,48,17,18,57,184,0,53,47,185,0,29,0,
4,252,65,5,0,154,0,61,0,170,0,61,0,2,93,65,
19,0,9,0,61,0,25,0,61,0,41,0,61,0,57,0,
61,0,73,0,61,0,89,0,61,0,105,0,61,0,121,0,
61,0,137,0,61,0,9,93,184,0,61,16,184,0,58,208,
184,0,58,47,184,0,77,16,184,0,80,208,184,0,80,47,
65,5,0,154,0,85,0,170,0,85,0,2,93,65,19,0,
9,0,85,0,25,0,85,0,41,0,85,0,57,0,85,0,
73,0,85,0,89,0,85,0,105,0,85,0,121,0,85,0,
137,0,85,0,9,93,186,0,90,0,29,0,5,17,18,57,
184,0,5,16,184,0,99,220,0,184,0,69,47,184,0,0,
69,88,184,0,43,47,27,185,0,43,0,9,62,89,184,0,
0,69,88,184,0,95,47,27,185,0,95,0,9,62,89,184,
0,0,69,88,184,0,18,47,27,185,0,18,0,7,62,89,
187,0,80,0,2,0,24,0,4,43,184,0,80,16,184,0,
24,16,184,0,12,208,184,0,12,47,184,0,80,16,184,0,
58,208,184,0,58,47,186,0,90,0,18,0,69,17,18,57,
48,49,1,30,3,21,20,14,4,7,30,1,23,14,1,7,
46,1,39,62,1,55,46,3,53,52,62,2,53,52,46,2,
39,53,62,1,55,30,3,21,20,14,2,21,20,30,2,23,
62,1,53,52,46,2,39,62,1,55,30,1,23,14,1,10,
1,21,20,22,23,62,3,53,52,46,2,39,62,3,55,30,
1,4,167,15,22,16,8,25,51,79,107,136,83,4,13,9,
32,86,35,11,11,10,12,19,7,129,171,102,43,4,6,4,
12,35,63,51,87,127,45,12,19,14,7,5,5,5,28,69,
116,88,4,5,5,11,14,9,49,81,35,7,17,2,12,19,
13,7,1,2,80,129,91,49,13,27,45,31,16,38,40,38,
17,14,13,3,180,30,73,78,78,36,69,149,146,135,107,72,
10,120,208,65,11,31,14,6,11,11,85,213,120,9,88,133,
164,83,34,76,78,78,36,23,39,29,19,3,40,10,33,23,
5,18,33,55,42,38,83,84,81,37,76,137,109,73,13,102,
207,104,103,221,216,198,79,21,29,11,6,21,7,99,250,254,
237,254,226,134,52,110,56,5,81,129,165,90,41,94,88,77,
24,12,26,25,24,10,6,3,0,1,0,90,255,225,5,65,
3,198,0,85,1,158,187,0,35,0,4,0,20,0,4,43,
184,0,35,16,187,0,61,0,4,0,45,0,4,43,184,0,
61,16,187,0,0,0,4,0,71,0,4,43,184,0,0,16,
65,5,0,154,0,45,0,170,0,45,0,2,93,65,19,0,
9,0,45,0,25,0,45,0,41,0,45,0,57,0,45,0,
73,0,45,0,89,0,45,0,105,0,45,0,121,0,45,0,
137,0,45,0,9,93,186,0,10,0,45,0,61,17,18,57,
186,0,30,0,20,0,0,17,18,57,65,19,0,6,0,35,
0,22,0,35,0,38,0,35,0,54,0,35,0,70,0,35,
0,86,0,35,0,102,0,35,0,118,0,35,0,134,0,35,
0,9,93,65,5,0,149,0,35,0,165,0,35,0,2,93,
65,5,0,154,0,71,0,170,0,71,0,2,93,65,19,0,
9,0,71,0,25,0,71,0,41,0,71,0,57,0,71,0,
73,0,71,0,89,0,71,0,105,0,71,0,121,0,71,0,
137,0,71,0,9,93,0,184,0,25,47,184,0,81,47,184,
0,0,69,88,184,0,5,47,27,185,0,5,0,5,62,89,
184,0,0,69,88,184,0,15,47,27,185,0,15,0,5,62,
89,186,0,10,0,5,0,25,17,18,57,186,0,30,0,5,
0,25,17,18,57,185,0,40,0,2,252,65,33,0,7,0,
40,0,23,0,40,0,39,0,40,0,55,0,40,0,71,0,
40,0,87,0,40,0,103,0,40,0,119,0,40,0,135,0,
40,0,151,0,40,0,167,0,40,0,183,0,40,0,199,0,
40,0,215,0,40,0,231,0,40,0,247,0,40,0,16,93,
65,15,0,7,0,40,0,23,0,40,0,39,0,40,0,55,
0,40,0,71,0,40,0,87,0,40,0,103,0,40,0,7,
113,65,5,0,118,0,40,0,134,0,40,0,2,113,184,0,
66,208,48,49,1,20,14,2,35,34,46,2,39,14,3,35,
34,46,2,53,52,62,2,55,30,3,23,14,3,21,20,30,
2,51,50,62,2,55,52,46,2,39,62,1,55,30,1,49,
48,14,2,23,30,3,51,50,62,2,53,52,46,2,39,62,
3,55,30,3,5,65,68,106,130,62,56,87,63,41,11,16,
48,72,98,66,69,120,90,52,43,78,107,65,4,18,19,18,
4,56,75,45,19,31,60,86,55,36,65,49,29,1,5,7,
9,4,43,71,32,8,21,9,11,8,1,1,19,44,72,55,
48,77,54,29,22,43,66,45,4,18,19,17,5,55,99,75,
44,1,213,116,186,129,69,40,66,85,46,44,85,67,41,61,
117,168,108,81,160,144,119,39,2,7,8,8,3,60,120,120,
120,60,71,133,102,62,47,75,96,49,37,76,69,55,15,16,
28,13,10,22,41,73,99,58,50,98,77,48,59,97,127,68,
72,127,120,116,62,3,9,7,7,2,35,106,130,149,255,255,
255,252,255,225,2,84,5,36,2,38,3,37,0,0,0,7,
5,131,3,43,0,0,255,255,0,55,255,225,3,191,5,36,
2,38,3,48,0,0,0,7,5,131,4,46,0,0,255,255,
0,85,255,226,3,167,6,5,2,38,3,43,0,0,0,7,
2,243,1,139,0,0,255,255,0,55,255,225,3,191,6,5,
2,38,3,48,0,0,0,7,2,243,1,169,0,0,255,255,
0,90,255,225,5,65,6,5,2,38,3,52,0,0,0,7,
2,243,2,106,0,0,0,3,0,91,255,225,3,116,6,17,
0,16,0,35,0,71,1,155,187,0,24,0,4,0,58,0,
4,43,184,0,24,16,187,0,36,0,4,0,0,0,4,43,
184,0,36,16,65,5,0,154,0,0,0,170,0,0,0,2,
93,65,19,0,9,0,0,0,25,0,0,0,41,0,0,0,
57,0,0,0,73,0,0,0,89,0,0,0,105,0,0,0,
121,0,0,0,137,0,0,0,9,93,65,19,0,6,0,24,
0,22,0,24,0,38,0,24,0,54,0,24,0,70,0,24,
0,86,0,24,0,102,0,24,0,118,0,24,0,134,0,24,
0,9,93,65,5,0,149,0,24,0,165,0,24,0,2,93,
184,0,24,16,184,0,12,208,184,0,12,47,186,0,17,0,
0,0,36,17,18,57,184,0,17,47,65,5,0,154,0,17,
0,170,0,17,0,2,93,65,19,0,9,0,17,0,25,0,
17,0,41,0,17,0,57,0,17,0,73,0,17,0,89,0,
17,0,105,0,17,0,121,0,17,0,137,0,17,0,9,93,
184,0,24,16,184,0,22,208,184,0,22,47,184,0,17,16,
185,0,46,0,4,252,186,0,41,0,58,0,46,17,18,57,
184,0,73,220,0,184,0,0,69,88,184,0,53,47,27,185,
0,53,0,5,62,89,187,0,67,0,2,0,5,0,4,43,
184,0,67,16,184,0,53,16,185,0,31,0,2,252,65,33,
0,7,0,31,0,23,0,31,0,39,0,31,0,55,0,31,
0,71,0,31,0,87,0,31,0,103,0,31,0,119,0,31,
0,135,0,31,0,151,0,31,0,167,0,31,0,183,0,31,
0,199,0,31,0,215,0,31,0,231,0,31,0,247,0,31,
0,16,93,65,15,0,7,0,31,0,23,0,31,0,39,0,
31,0,55,0,31,0,71,0,31,0,87,0,31,0,103,0,
31,0,7,113,65,5,0,118,0,31,0,134,0,31,0,2,
113,48,49,1,46,3,35,34,14,4,7,62,3,19,46,2,
6,7,6,23,30,5,51,50,62,2,19,22,14,2,7,54,
30,2,23,22,14,4,35,34,46,2,39,38,62,6,51,50,
30,2,2,166,5,32,45,56,30,33,60,53,46,36,27,7,
98,163,115,60,56,9,77,129,176,109,3,6,4,18,31,45,
61,76,47,66,87,50,17,61,4,16,51,91,72,53,102,82,
56,7,4,17,43,69,95,123,76,95,135,89,45,3,3,7,
23,39,58,80,103,129,78,43,70,51,30,4,211,60,78,46,
18,48,85,116,135,149,75,21,85,111,127,253,52,138,160,54,
47,68,75,68,46,106,104,96,72,44,70,109,132,3,165,62,
110,106,106,58,5,32,82,136,100,57,129,127,116,89,53,96,
154,190,95,65,159,172,177,164,143,107,62,39,64,81,0,2,
0,30,255,225,3,243,5,240,0,16,0,91,1,83,187,0,
66,0,4,0,46,0,4,43,184,0,66,16,187,0,33,0,
4,0,76,0,4,43,184,0,33,16,65,5,0,154,0,76,
0,170,0,76,0,2,93,65,19,0,9,0,76,0,25,0,
76,0,41,0,76,0,57,0,76,0,73,0,76,0,89,0,
76,0,105,0,76,0,121,0,76,0,137,0,76,0,9,93,
184,0,76,16,184,0,2,208,184,0,2,47,186,0,87,0,
46,0,66,17,18,57,184,0,87,47,185,0,12,0,4,252,
186,0,22,0,76,0,33,17,18,57,184,0,33,16,184,0,
31,208,184,0,31,47,184,0,76,16,184,0,79,208,184,0,
79,47,184,0,33,16,184,0,93,220,0,184,0,0,69,88,
184,0,40,47,27,185,0,40,0,5,62,89,187,0,17,0,
2,0,7,0,4,43,184,0,17,16,187,0,0,0,2,0,
82,0,4,43,184,0,0,16,184,0,40,16,185,0,71,0,
2,252,65,33,0,7,0,71,0,23,0,71,0,39,0,71,
0,55,0,71,0,71,0,71,0,87,0,71,0,103,0,71,
0,119,0,71,0,135,0,71,0,151,0,71,0,167,0,71,
0,183,0,71,0,199,0,71,0,215,0,71,0,231,0,71,
0,247,0,71,0,16,93,65,15,0,7,0,71,0,23,0,
71,0,39,0,71,0,55,0,71,0,71,0,71,0,87,0,
71,0,103,0,71,0,7,113,65,5,0,118,0,71,0,134,
0,71,0,2,113,186,0,79,0,82,0,0,17,18,57,48,
49,1,50,55,46,3,35,34,14,2,21,20,30,2,19,50,
30,2,23,62,1,55,30,1,23,14,1,7,22,21,20,14,
4,35,34,46,2,61,1,52,46,2,39,53,62,3,55,30,
3,23,30,1,29,1,20,30,2,51,50,62,2,53,52,38,
39,14,1,35,34,46,2,53,52,62,2,2,48,102,112,8,
36,58,85,58,44,74,54,30,28,58,87,54,89,126,85,49,
11,18,36,19,7,12,5,23,45,22,6,24,47,70,93,114,
68,75,129,96,55,6,24,51,45,30,63,60,55,21,7,8,
7,8,7,5,5,33,62,89,56,70,92,54,21,2,2,81,
140,54,87,122,76,35,69,108,131,3,107,47,107,189,142,83,
46,81,109,62,57,99,73,41,2,133,83,143,191,108,11,23,
13,5,34,14,19,33,15,90,94,95,189,171,146,107,61,50,
112,179,129,64,32,42,25,11,2,44,5,17,20,22,12,5,
5,7,9,7,16,72,41,65,120,161,96,40,101,167,215,115,
40,79,39,34,23,59,93,114,56,92,151,107,58,0,0,1,
0,0,0,0,4,252,5,10,0,72,0,166,187,0,20,0,
4,0,31,0,4,43,184,0,20,16,186,0,58,0,31,0,
20,17,18,57,0,184,0,0,69,88,184,0,48,47,27,185,
0,48,0,11,62,89,184,0,0,69,88,184,0,68,47,27,
185,0,68,0,11,62,89,184,0,0,69,88,184,0,26,47,
27,185,0,26,0,5,62,89,184,0,68,16,184,0,9,220,
65,5,0,217,0,9,0,233,0,9,0,2,93,65,27,0,
8,0,9,0,24,0,9,0,40,0,9,0,56,0,9,0,
72,0,9,0,88,0,9,0,104,0,9,0,120,0,9,0,
136,0,9,0,152,0,9,0,168,0,9,0,184,0,9,0,
200,0,9,0,13,93,186,0,58,0,26,0,48,17,18,57,
48,49,1,14,1,7,39,62,1,46,1,35,34,6,7,14,
5,29,1,20,30,2,23,21,33,53,62,1,61,1,52,46,
4,39,46,3,35,39,62,1,51,50,30,2,23,30,3,23,
62,3,55,62,3,51,50,30,2,4,241,41,84,48,20,8,
3,14,31,27,40,71,36,13,38,40,39,31,19,17,39,63,
47,254,22,91,73,25,42,55,58,59,25,20,54,65,75,42,
4,59,118,42,21,37,33,30,12,57,88,69,51,20,16,47,
54,56,26,19,48,63,83,54,28,65,53,27,4,11,29,40,
23,30,30,54,42,25,87,81,30,85,102,118,128,134,68,176,
6,17,20,20,9,43,43,19,39,14,176,77,149,142,131,115,
99,38,31,66,54,34,43,8,12,20,30,37,17,75,151,154,
156,79,63,149,146,130,45,33,66,54,33,28,61,97,255,255,
0,40,0,0,7,45,5,162,0,39,3,60,2,49,0,0,
0,6,2,243,0,157,255,255,0,0,0,0,4,252,6,100,
2,38,3,60,0,0,0,7,5,131,4,95,1,64,0,3,
0,80,254,28,5,33,5,87,0,15,0,31,0,81,2,29,
187,0,5,0,4,0,61,0,4,43,184,0,5,16,187,0,
37,0,4,0,16,0,4,43,184,0,37,16,187,0,24,0,
4,0,56,0,4,43,184,0,24,16,184,0,56,16,184,0,
0,208,184,0,0,47,65,19,0,6,0,5,0,22,0,5,
0,38,0,5,0,54,0,5,0,70,0,5,0,86,0,5,
0,102,0,5,0,118,0,5,0,134,0,5,0,9,93,65,
5,0,149,0,5,0,165,0,5,0,2,93,184,0,56,16,
184,0,10,208,184,0,10,47,65,19,0,6,0,24,0,22,
0,24,0,38,0,24,0,54,0,24,0,70,0,24,0,86,
0,24,0,102,0,24,0,118,0,24,0,134,0,24,0,9,
93,65,5,0,149,0,24,0,165,0,24,0,2,93,184,0,
24,16,185,0,13,0,3,252,65,5,0,154,0,16,0,170,
0,16,0,2,93,65,19,0,9,0,16,0,25,0,16,0,
41,0,16,0,57,0,16,0,73,0,16,0,89,0,16,0,
105,0,16,0,121,0,16,0,137,0,16,0,9,93,184,0,
0,16,185,0,32,0,4,252,184,0,21,208,184,0,21,47,
184,0,24,16,184,0,27,208,184,0,27,47,184,0,24,16,
184,0,42,208,184,0,42,47,184,0,32,16,184,0,47,208,
184,0,47,47,184,0,56,16,184,0,66,208,184,0,66,47,
184,0,37,16,184,0,83,220,0,184,0,74,47,184,0,0,
69,88,184,0,50,47,27,185,0,50,0,7,62,89,184,0,
0,69,88,184,0,42,47,27,185,0,42,0,5,62,89,184,
0,0,69,88,184,0,56,47,27,185,0,56,0,5,62,89,
187,0,32,0,2,0,0,0,4,43,184,0,32,16,184,0,
56,16,185,0,10,0,2,252,65,33,0,7,0,10,0,23,
0,10,0,39,0,10,0,55,0,10,0,71,0,10,0,87,
0,10,0,103,0,10,0,119,0,10,0,135,0,10,0,151,
0,10,0,167,0,10,0,183,0,10,0,199,0,10,0,215,
0,10,0,231,0,10,0,247,0,10,0,16,93,65,15,0,
7,0,10,0,23,0,10,0,39,0,10,0,55,0,10,0,
71,0,10,0,87,0,10,0,103,0,10,0,7,113,65,5,
0,118,0,10,0,134,0,10,0,2,113,184,0,0,16,184,
0,21,208,184,0,21,47,184,0,10,16,184,0,27,208,184,
0,32,16,184,0,66,208,184,0,66,47,48,49,1,14,3,
21,20,30,2,23,62,1,53,52,38,1,52,46,2,39,6,
2,21,20,22,23,62,3,1,30,3,23,22,14,2,7,30,
3,23,14,1,7,46,1,39,62,1,55,46,3,53,52,62,
2,55,46,3,39,62,1,55,30,1,23,14,3,2,112,102,
147,95,44,53,99,144,91,5,6,5,2,9,60,105,143,82,
7,8,3,1,99,150,101,51,254,125,141,206,135,66,1,1,
92,156,204,109,1,4,6,6,3,38,79,38,11,10,10,11,
15,7,114,197,145,83,74,139,201,126,2,5,5,7,3,44,
88,36,8,16,2,5,8,6,7,3,123,5,77,115,140,69,
77,143,115,80,15,107,218,111,102,200,254,162,94,154,114,70,
10,148,254,210,147,62,119,58,3,65,108,140,2,90,8,85,
135,174,97,115,181,128,71,5,45,112,110,97,30,14,27,17,
6,11,11,84,224,118,7,74,127,179,112,98,172,132,84,10,
36,92,94,87,30,22,30,11,6,21,7,36,88,97,99,0,
255,255,0,0,254,12,4,174,5,37,2,38,0,33,0,0,
0,7,2,194,4,90,0,0,255,255,0,80,254,12,3,158,
3,192,2,38,0,65,0,0,0,7,2,194,3,207,0,0,
255,255,0,41,255,242,3,248,6,100,2,38,0,34,0,0,
0,7,5,130,4,19,1,64,255,255,0,10,255,226,3,181,
6,14,2,38,0,66,0,0,0,7,2,164,4,81,0,0,
255,255,0,41,254,96,3,248,5,10,2,38,0,34,0,0,
0,7,2,192,4,19,0,0,255,255,0,10,254,96,3,181,
6,14,2,38,0,66,0,0,0,7,2,192,3,226,0,0,
255,255,0,41,254,177,3,248,5,10,2,38,0,34,0,0,
0,7,2,206,4,19,0,0,255,255,0,10,254,177,3,181,
6,14,2,38,0,66,0,0,0,7,2,206,3,226,0,0,
255,255,0,70,254,68,3,250,6,193,2,38,0,35,0,0,
0,39,2,196,4,73,0,0,0,7,5,126,4,133,1,64,
255,255,0,80,254,68,3,72,5,209,2,38,0,67,0,0,
0,39,2,196,3,235,0,0,0,7,2,158,4,9,0,0,
255,255,0,41,0,0,4,100,6,100,2,38,0,36,0,0,
0,7,5,130,4,41,1,64,255,255,0,80,255,226,4,27,
6,14,2,38,0,68,0,0,0,7,2,164,3,82,0,0,
255,255,0,41,254,96,4,100,5,10,2,38,0,36,0,0,
0,7,2,192,4,41,0,0,255,255,0,80,254,96,4,27,
6,14,2,38,0,68,0,0,0,7,2,192,4,16,0,0,
255,255,0,41,254,177,4,100,5,10,2,38,0,36,0,0,
0,7,2,206,4,41,0,0,255,255,0,80,254,177,4,27,
6,14,2,38,0,68,0,0,0,7,2,206,4,16,0,0,
255,255,0,41,254,5,4,100,5,10,2,38,0,36,0,0,
0,7,2,195,4,46,0,0,255,255,0,80,254,5,4,27,
6,14,2,38,0,68,0,0,0,7,2,195,4,21,0,0,
255,255,0,41,254,9,4,100,5,10,2,38,0,36,0,0,
0,7,2,202,4,40,0,0,255,255,0,80,254,9,4,27,
6,14,2,38,0,68,0,0,0,7,2,202,4,15,0,0,
255,255,0,50,0,0,3,186,8,1,2,38,0,37,0,0,
0,39,5,129,4,3,1,64,0,7,5,125,3,167,2,128,
255,255,0,80,255,226,3,98,7,57,2,38,0,69,0,0,
0,39,2,161,4,11,0,0,0,7,2,157,3,175,1,104,
255,255,0,50,0,0,3,186,8,1,2,38,0,37,0,0,
0,39,5,129,4,3,1,64,0,7,5,126,4,21,2,128,
255,255,0,80,255,226,3,98,7,57,2,38,0,69,0,0,
0,39,2,161,4,11,0,0,0,7,2,158,4,29,1,104,
255,255,0,50,254,9,3,186,4,236,2,38,0,37,0,0,
0,7,2,202,3,248,0,0,255,255,0,80,254,9,3,98,
3,192,2,38,0,69,0,0,0,7,2,202,3,246,0,0,
255,255,0,50,254,85,3,186,4,236,2,38,0,37,0,0,
0,7,2,205,3,249,0,0,255,255,0,80,254,85,3,98,
3,192,2,38,0,69,0,0,0,7,2,205,3,247,0,0,
255,255,0,50,254,68,3,186,6,189,2,38,0,37,0,0,
0,39,2,196,3,247,0,0,0,7,2,163,3,249,1,64,
255,255,0,80,254,68,3,98,5,125,2,38,0,69,0,0,
0,39,2,196,3,245,0,0,0,7,2,163,4,1,0,0,
255,255,0,50,0,0,3,129,6,100,2,38,0,38,0,0,
0,7,5,130,3,220,1,64,255,255,0,45,0,0,3,49,
7,94,2,38,0,70,0,0,0,7,5,130,3,72,2,58,
255,255,0,70,255,226,4,121,6,49,2,38,0,39,0,0,
0,7,5,129,4,141,1,64,255,255,0,30,254,12,3,221,
5,25,2,38,0,71,0,0,0,7,2,161,4,1,0,0,
255,255,0,50,0,0,4,246,6,100,2,38,0,40,0,0,
0,7,5,130,4,151,1,64,255,255,0,55,0,0,4,76,
7,94,2,38,0,72,0,0,0,7,5,130,4,68,2,58,
255,255,0,50,254,96,4,246,4,236,2,38,0,40,0,0,
0,7,2,192,4,151,0,0,255,255,0,55,254,96,4,76,
6,14,2,38,0,72,0,0,0,7,2,192,4,68,0,0,
255,255,0,50,0,0,4,246,6,100,2,38,0,40,0,0,
0,7,5,131,4,151,1,64,255,255,0,55,0,0,4,76,
7,94,2,38,0,72,0,0,0,7,5,131,4,68,2,58,
255,255,0,50,254,68,4,246,4,236,2,38,0,40,0,0,
0,7,2,196,3,15,0,0,255,255,0,55,254,68,4,76,
6,14,2,38,0,72,0,0,0,7,2,196,3,2,0,0,
255,255,0,50,254,32,4,246,4,236,2,38,0,40,0,0,
0,7,2,203,4,151,0,0,255,255,0,55,254,32,4,76,
6,14,2,38,0,72,0,0,0,7,2,203,4,68,0,0,
255,255,255,210,254,85,2,124,4,236,2,38,0,41,0,0,
0,7,2,205,3,42,0,0,255,255,255,200,254,85,2,114,
5,76,2,38,0,73,0,0,0,7,2,205,3,32,0,0,
255,255,255,251,0,0,2,120,8,1,2,38,0,41,0,0,
0,39,5,131,3,42,1,64,0,7,5,126,3,70,2,128,
255,255,255,241,0,0,2,75,7,57,2,38,0,176,0,0,
0,39,2,165,3,32,0,0,0,7,2,158,3,60,1,104,
255,255,0,50,255,242,4,150,6,193,2,38,0,43,0,0,
0,7,5,126,4,109,1,64,255,255,0,55,255,246,4,0,
7,187,2,38,0,75,0,0,0,7,5,126,4,58,2,58,
255,255,0,50,254,96,4,150,4,236,2,38,0,43,0,0,
0,7,2,192,4,103,0,0,255,255,0,55,254,96,4,0,
6,14,2,38,0,75,0,0,0,7,2,192,4,30,0,0,
255,255,0,50,254,177,4,150,4,236,2,38,0,43,0,0,
0,7,2,206,4,103,0,0,255,255,0,55,254,177,4,0,
6,14,2,38,0,75,0,0,0,7,2,206,4,30,0,0,
255,255,0,50,254,96,3,176,4,236,2,38,0,44,0,0,
0,7,2,192,3,244,0,0,255,255,0,60,254,96,1,254,
6,14,2,38,0,76,0,0,0,7,2,192,3,32,0,0,
255,255,0,50,254,96,3,176,6,49,2,38,0,44,0,0,
0,39,2,192,3,244,0,0,0,7,5,129,3,224,1,64,
255,255,255,213,254,96,2,121,7,43,2,38,0,76,0,0,
0,39,2,192,3,32,0,0,0,7,5,129,3,42,2,58,
255,255,0,50,254,177,3,176,4,236,2,38,0,44,0,0,
0,7,2,206,3,244,0,0,255,255,255,203,254,177,2,111,
6,14,2,38,0,76,0,0,0,7,2,206,3,32,0,0,
255,255,0,50,254,9,3,176,4,236,2,38,0,44,0,0,
0,7,2,202,3,243,0,0,255,255,255,224,254,9,2,89,
6,14,2,38,0,76,0,0,0,7,2,202,3,31,0,0,
255,255,0,60,0,0,6,34,6,193,2,38,0,45,0,0,
0,7,5,126,5,78,1,64,255,255,0,55,0,0,6,80,
5,209,2,38,0,77,0,0,0,7,2,158,5,98,0,0,
255,255,0,60,0,0,6,34,6,100,2,38,0,45,0,0,
0,7,5,130,5,50,1,64,255,255,0,55,0,0,6,80,
5,76,2,38,0,77,0,0,0,7,2,164,5,70,0,0,
255,255,0,60,254,96,6,34,4,236,2,38,0,45,0,0,
0,7,2,192,5,50,0,0,255,255,0,55,254,96,6,80,
3,192,2,38,0,77,0,0,0,7,2,192,5,70,0,0,
255,255,0,50,255,226,5,0,6,100,2,38,0,46,0,0,
0,7,5,130,4,156,1,64,255,255,0,55,0,0,4,76,
5,76,2,38,0,78,0,0,0,7,2,164,4,68,0,0,
255,255,0,50,254,96,5,0,4,236,2,38,0,46,0,0,
0,7,2,192,4,156,0,0,255,255,0,55,254,96,4,76,
3,192,2,38,0,78,0,0,0,7,2,192,4,68,0,0,
255,255,0,50,254,177,5,0,4,236,2,38,0,46,0,0,
0,7,2,206,4,156,0,0,255,255,0,55,254,177,4,76,
3,192,2,38,0,78,0,0,0,7,2,206,4,68,0,0,
255,255,0,50,254,9,5,0,4,236,2,38,0,46,0,0,
0,7,2,202,4,155,0,0,255,255,0,55,254,9,4,76,
3,192,2,38,0,78,0,0,0,7,2,202,4,67,0,0,
255,255,0,70,255,226,4,114,8,1,2,38,0,47,0,0,
0,39,5,128,4,106,1,64,0,7,5,126,4,134,2,128,
255,255,0,80,255,226,3,182,7,57,2,38,0,79,0,0,
0,39,2,160,4,26,0,0,0,7,2,158,4,54,1,104,
255,255,0,70,255,226,4,114,7,164,2,38,0,47,0,0,
0,39,5,128,4,106,1,64,0,7,5,131,4,106,2,128,
255,255,0,80,255,226,3,182,6,180,2,38,0,79,0,0,
0,39,2,160,4,26,0,0,0,7,2,165,4,26,1,104,
255,255,0,70,255,226,4,114,8,1,2,38,0,47,0,0,
0,39,5,129,4,116,1,64,0,7,5,125,4,24,2,128,
255,255,0,80,255,226,3,182,7,57,2,38,0,79,0,0,
0,39,2,161,4,36,0,0,0,7,2,157,3,200,1,104,
255,255,0,70,255,226,4,114,8,1,2,38,0,47,0,0,
0,39,5,129,4,116,1,64,0,7,5,126,4,134,2,128,
255,255,0,80,255,226,3,182,7,57,2,38,0,79,0,0,
0,39,2,161,4,36,0,0,0,7,2,158,4,54,1,104,
255,255,0,41,0,0,3,214,6,193,2,38,0,48,0,0,
0,7,5,126,4,30,1,64,255,255,0,55,254,32,3,236,
5,209,2,38,0,80,0,0,0,7,2,158,4,48,0,0,
255,255,0,41,0,0,3,214,6,100,2,38,0,48,0,0,
0,7,5,130,4,2,1,64,255,255,0,55,254,32,3,236,
5,76,2,38,0,80,0,0,0,7,2,164,4,20,0,0,
255,255,0,41,255,242,4,115,6,100,2,38,0,50,0,0,
0,7,5,130,4,11,1,64,255,255,0,55,0,0,3,11,
5,76,2,38,0,82,0,0,0,7,2,164,3,197,0,0,
255,255,0,41,254,96,4,115,5,10,2,38,0,50,0,0,
0,7,2,192,4,11,0,0,255,255,0,55,254,96,3,11,
3,192,2,38,0,82,0,0,0,7,2,192,3,17,0,0,
255,255,0,41,254,96,4,115,6,49,2,38,0,50,0,0,
0,39,2,192,4,11,0,0,0,7,5,129,4,21,1,64,
255,255,0,55,254,96,3,30,5,25,2,38,0,82,0,0,
0,39,2,192,3,17,0,0,0,7,2,161,3,207,0,0,
255,255,0,41,254,177,4,115,5,10,2,38,0,50,0,0,
0,7,2,206,4,11,0,0,255,255,255,188,254,177,3,11,
3,192,2,38,0,82,0,0,0,7,2,206,3,17,0,0,
255,255,0,117,255,226,3,117,6,100,2,38,0,51,0,0,
0,7,5,130,3,247,1,64,255,255,0,94,255,226,2,188,
5,76,2,38,0,83,0,0,0,7,2,164,3,144,0,0,
255,255,0,117,254,96,3,117,5,10,2,38,0,51,0,0,
0,7,2,192,3,247,0,0,255,255,0,94,254,96,2,188,
3,192,2,38,0,83,0,0,0,7,2,192,3,144,0,0,
255,255,0,117,255,226,3,117,7,164,2,38,0,51,0,0,
0,39,5,126,4,19,1,64,0,7,5,130,3,247,2,128,
255,255,0,94,255,226,2,188,6,180,2,38,0,83,0,0,
0,39,2,158,3,172,0,0,0,7,2,164,3,144,1,104,
255,255,0,117,255,226,3,117,7,164,2,38,0,51,0,0,
0,39,5,132,3,246,1,64,0,7,5,130,3,247,2,128,
255,255,0,80,255,226,2,201,6,140,2,38,0,83,0,0,
0,39,2,169,3,143,0,0,0,7,2,164,3,144,1,64,
255,255,0,117,254,96,3,117,6,100,2,38,0,51,0,0,
0,39,2,192,3,247,0,0,0,7,5,130,3,247,1,64,
255,255,0,94,254,96,2,188,5,76,2,38,0,83,0,0,
0,39,2,192,3,144,0,0,0,7,2,164,3,144,0,0,
255,255,0,10,0,0,4,59,6,100,2,38,0,52,0,0,
0,7,5,130,4,37,1,64,255,255,0,20,255,226,2,164,
6,50,2,38,0,84,0,0,0,7,5,130,3,95,1,14,
255,255,0,10,254,96,4,59,4,236,2,38,0,52,0,0,
0,7,2,192,4,37,0,0,255,255,0,20,254,96,2,164,
5,0,2,38,0,84,0,0,0,7,2,192,3,95,0,0,
255,255,0,10,254,177,4,59,4,236,2,38,0,52,0,0,
0,7,2,206,4,37,0,0,255,255,0,10,254,177,2,174,
5,0,2,38,0,84,0,0,0,7,2,206,3,95,0,0,
255,255,0,10,254,9,4,59,4,236,2,38,0,52,0,0,
0,7,2,202,4,36,0,0,255,255,0,20,254,9,2,164,
5,0,2,38,0,84,0,0,0,7,2,202,3,94,0,0,
255,255,0,50,254,96,4,251,4,236,2,38,0,53,0,0,
0,7,2,193,4,168,0,0,255,255,0,41,254,96,4,45,
3,192,2,38,0,85,0,0,0,7,2,193,4,36,0,0,
255,255,0,50,254,85,4,251,4,236,2,38,0,53,0,0,
0,7,2,205,4,168,0,0,255,255,0,41,254,85,4,45,
3,192,2,38,0,85,0,0,0,7,2,205,4,36,0,0,
255,255,0,50,254,9,4,251,4,236,2,38,0,53,0,0,
0,7,2,202,4,167,0,0,255,255,0,41,254,9,4,45,
3,192,2,38,0,85,0,0,0,7,2,202,4,35,0,0,
255,255,0,50,255,226,4,251,8,1,2,38,0,53,0,0,
0,39,5,128,4,168,1,64,0,7,5,126,4,196,2,128,
255,255,0,41,255,226,4,45,7,57,2,38,0,85,0,0,
0,39,2,160,4,36,0,0,0,7,2,158,4,64,1,104,
255,255,0,50,255,226,4,251,7,164,2,38,0,53,0,0,
0,39,5,129,4,178,1,64,0,7,5,131,4,168,2,128,
255,255,0,41,255,226,4,45,6,180,2,38,0,85,0,0,
0,39,2,161,4,46,0,0,0,7,2,165,4,36,1,104,
255,255,0,20,255,226,5,10,6,113,2,38,0,54,0,0,
0,7,5,128,4,156,1,64,255,255,0,20,255,226,3,221,
5,89,2,38,0,86,0,0,0,7,2,160,4,27,0,0,
255,255,0,20,254,96,5,10,4,236,2,38,0,54,0,0,
0,7,2,192,4,146,0,0,255,255,0,20,254,96,3,221,
3,162,2,38,0,86,0,0,0,7,2,192,4,7,0,0,
255,255,0,20,255,226,6,166,6,193,2,38,0,55,0,0,
0,7,5,125,5,14,1,64,255,255,0,20,255,226,5,145,
5,209,2,38,0,87,0,0,0,7,2,157,4,159,0,0,
255,255,0,20,255,226,6,166,6,193,2,38,0,55,0,0,
0,7,5,126,5,124,1,64,255,255,0,20,255,226,5,145,
5,209,2,38,0,87,0,0,0,7,2,158,5,13,0,0,
255,255,0,20,255,226,6,166,6,100,2,38,0,55,0,0,
0,7,5,131,5,96,1,64,255,255,0,20,255,226,5,145,
5,76,2,38,0,87,0,0,0,7,2,165,4,241,0,0,
255,255,0,20,255,226,6,166,6,100,2,38,0,55,0,0,
0,7,5,130,5,96,1,64,255,255,0,20,255,226,5,145,
5,76,2,38,0,87,0,0,0,7,2,164,4,241,0,0,
255,255,0,20,254,96,6,166,4,236,2,38,0,55,0,0,
0,7,2,192,5,96,0,0,255,255,0,20,254,96,5,145,
3,162,2,38,0,87,0,0,0,7,2,192,4,221,0,0,
255,255,0,31,0,0,4,205,6,100,2,38,0,56,0,0,
0,7,5,130,4,121,1,64,255,255,0,20,0,0,3,248,
5,76,2,38,0,88,0,0,0,7,2,164,4,9,0,0,
255,255,0,31,0,0,4,205,6,100,2,38,0,56,0,0,
0,7,5,131,4,121,1,64,255,255,0,20,0,0,3,248,
5,76,2,38,0,88,0,0,0,7,2,165,4,9,0,0,
255,255,0,0,0,0,4,152,6,100,2,38,0,57,0,0,
0,7,5,130,4,95,1,64,255,255,255,209,254,12,3,221,
5,76,2,38,0,89,0,0,0,7,2,164,4,21,0,0,
255,255,0,59,0,0,3,223,6,185,2,38,0,58,0,0,
0,7,5,127,4,45,1,64,255,255,0,76,0,0,3,61,
5,191,2,38,0,90,0,0,0,7,2,159,3,226,0,0,
255,255,0,59,254,96,3,223,4,252,2,38,0,58,0,0,
0,7,2,192,4,26,0,0,255,255,0,76,254,96,3,61,
3,178,2,38,0,90,0,0,0,7,2,192,3,199,0,0,
255,255,0,59,254,177,3,223,4,252,2,38,0,58,0,0,
0,7,2,206,4,26,0,0,255,255,0,76,254,177,3,61,
3,178,2,38,0,90,0,0,0,7,2,206,3,199,0,0,
255,255,0,55,254,177,4,76,6,14,2,38,0,72,0,0,
0,7,2,206,4,68,0,0,255,255,0,20,255,226,2,164,
6,50,2,38,0,84,0,0,0,7,5,131,3,95,1,14,
255,255,0,20,255,226,5,145,5,160,2,38,0,87,0,0,
0,7,2,167,4,241,0,0,255,255,255,209,254,12,3,221,
5,160,2,38,0,89,0,0,0,7,2,167,4,21,0,0,
255,255,0,80,255,226,3,158,5,184,2,38,0,65,0,0,
0,7,2,123,1,44,0,0,255,255,0,45,0,0,3,49,
7,164,2,38,1,93,0,0,0,7,5,130,3,178,2,128,
255,255,0,0,254,96,4,174,5,37,2,38,0,33,0,0,
0,7,2,192,4,90,0,0,255,255,0,80,254,96,3,158,
3,192,2,38,0,65,0,0,0,7,2,192,3,207,0,0,
255,255,0,0,0,0,4,174,6,227,2,38,0,33,0,0,
0,7,2,166,4,93,1,64,255,255,0,80,255,226,3,158,
5,163,2,38,0,65,0,0,0,7,2,166,3,230,0,0,
255,255,0,0,0,0,4,174,7,84,2,38,0,33,0,0,
0,7,6,73,4,89,1,64,255,255,0,80,255,226,3,162,
6,98,2,38,0,65,0,0,0,7,5,100,3,226,0,0,
255,255,0,0,0,0,4,174,7,84,2,38,0,33,0,0,
0,7,6,74,4,89,1,64,255,255,0,28,255,226,3,158,
6,98,2,38,0,65,0,0,0,7,5,101,3,226,0,0,
255,255,0,0,0,0,4,174,7,134,2,38,0,33,0,0,
0,7,6,75,4,89,1,64,255,255,0,80,255,226,3,158,
6,130,2,38,0,65,0,0,0,7,5,102,3,226,0,0,
255,255,0,0,0,0,4,174,8,1,2,38,0,33,0,0,
0,7,6,76,4,89,1,64,255,255,0,80,255,226,3,158,
6,243,2,38,0,65,0,0,0,7,5,103,3,226,0,0,
255,255,0,0,254,96,4,174,6,185,2,38,0,33,0,0,
0,39,2,192,4,90,0,0,0,7,5,127,4,89,1,64,
255,255,0,80,254,96,3,158,5,191,2,38,0,65,0,0,
0,39,2,192,3,207,0,0,0,7,2,159,3,226,0,0,
255,255,0,0,0,0,4,174,7,104,2,38,0,33,0,0,
0,7,6,77,4,90,1,64,255,255,0,80,255,226,3,158,
6,129,2,38,0,65,0,0,0,7,5,104,3,227,0,0,
255,255,0,0,0,0,4,174,7,104,2,38,0,33,0,0,
0,7,6,78,4,90,1,64,255,255,0,80,255,226,3,158,
6,127,2,38,0,65,0,0,0,7,5,105,3,227,0,0,
255,255,0,0,0,0,4,174,7,194,2,38,0,33,0,0,
0,7,5,106,4,90,1,64,255,255,0,80,255,226,3,158,
6,130,2,38,0,65,0,0,0,7,5,106,3,227,0,0,
255,255,0,0,0,0,4,174,7,247,2,38,0,33,0,0,
0,7,6,79,4,90,1,64,255,255,0,80,255,226,3,158,
6,203,2,38,0,65,0,0,0,7,5,107,3,227,0,0,
255,255,0,0,254,96,4,174,6,189,2,38,0,33,0,0,
0,39,2,192,4,90,0,0,0,7,2,163,4,90,1,64,
255,255,0,80,254,96,3,158,5,125,2,38,0,65,0,0,
0,39,2,192,3,207,0,0,0,7,2,163,3,227,0,0,
255,255,0,50,254,96,3,186,4,236,2,38,0,37,0,0,
0,7,2,192,3,249,0,0,255,255,0,80,254,96,3,98,
3,192,2,38,0,69,0,0,0,7,2,192,3,247,0,0,
255,255,0,50,0,0,3,186,6,227,2,38,0,37,0,0,
0,7,2,166,3,252,1,64,255,255,0,80,255,226,3,98,
5,163,2,38,0,69,0,0,0,7,2,166,4,4,0,0,
255,255,0,50,0,0,3,186,6,113,2,38,0,37,0,0,
0,7,5,128,3,249,1,64,255,255,0,80,255,226,3,98,
5,89,2,38,0,69,0,0,0,7,2,160,4,1,0,0,
255,255,0,50,0,0,3,235,7,84,2,38,0,37,0,0,
0,7,6,73,3,248,1,64,255,255,0,80,255,226,3,192,
6,98,2,38,0,69,0,0,0,7,5,100,4,0,0,0,
255,255,0,0,0,0,3,186,7,84,2,38,0,37,0,0,
0,7,6,74,3,248,1,64,255,255,0,58,255,226,3,98,
6,98,2,38,0,69,0,0,0,7,5,101,4,0,0,0,
255,255,0,50,0,0,3,186,7,134,2,38,0,37,0,0,
0,7,6,75,3,248,1,64,255,255,0,80,255,226,3,132,
6,130,2,38,0,69,0,0,0,7,5,102,4,0,0,0,
255,255,0,50,0,0,3,186,8,1,2,38,0,37,0,0,
0,7,6,76,3,248,1,64,255,255,0,80,255,226,3,98,
6,243,2,38,0,69,0,0,0,7,5,103,4,0,0,0,
255,255,0,50,254,96,3,186,6,185,2,38,0,37,0,0,
0,39,2,192,3,249,0,0,0,7,5,127,3,248,1,64,
255,255,0,80,254,96,3,98,5,191,2,38,0,69,0,0,
0,39,2,192,3,247,0,0,0,7,2,159,4,0,0,0,
255,255,0,70,0,0,2,8,6,227,2,38,0,41,0,0,
0,7,2,166,3,45,1,64,255,255,0,70,0,0,1,244,
5,163,2,38,0,176,0,0,0,7,2,166,3,35,0,0,
255,255,0,70,254,96,2,8,4,236,2,38,0,41,0,0,
0,7,2,192,3,42,0,0,255,255,0,70,254,96,1,244,
5,76,2,38,0,73,0,0,0,7,2,192,3,32,0,0,
255,255,0,70,254,96,4,114,5,10,2,38,0,47,0,0,
0,7,2,192,4,106,0,0,255,255,0,80,254,96,3,182,
3,192,2,38,0,79,0,0,0,7,2,192,4,26,0,0,
255,255,0,70,255,226,4,114,6,227,2,38,0,47,0,0,
0,7,2,166,4,109,1,64,255,255,0,80,255,226,3,182,
5,163,2,38,0,79,0,0,0,7,2,166,4,29,0,0,
255,255,0,70,255,226,4,114,7,84,2,38,0,47,0,0,
0,7,6,73,4,105,1,64,255,255,0,80,255,226,3,217,
6,98,2,38,0,79,0,0,0,7,5,100,4,25,0,0,
255,255,0,70,255,226,4,114,7,84,2,38,0,47,0,0,
0,7,6,74,4,105,1,64,255,255,0,80,255,226,3,182,
6,98,2,38,0,79,0,0,0,7,5,101,4,25,0,0,
255,255,0,70,255,226,4,114,7,134,2,38,0,47,0,0,
0,7,6,75,4,105,1,64,255,255,0,80,255,226,3,182,
6,130,2,38,0,79,0,0,0,7,5,102,4,25,0,0,
255,255,0,70,255,226,4,114,8,1,2,38,0,47,0,0,
0,7,6,76,4,105,1,64,255,255,0,80,255,226,3,182,
6,243,2,38,0,79,0,0,0,7,5,103,4,25,0,0,
255,255,0,70,254,96,4,114,6,185,2,38,0,47,0,0,
0,39,2,192,4,106,0,0,0,7,5,127,4,105,1,64,
255,255,0,80,254,96,3,182,5,191,2,38,0,79,0,0,
0,39,2,192,4,26,0,0,0,7,2,159,4,25,0,0,
255,255,0,70,255,226,4,196,6,193,2,38,0,47,0,0,
0,39,2,184,4,126,1,94,0,7,5,126,4,134,1,64,
255,255,0,80,255,226,4,76,5,209,0,38,0,79,0,0,
0,39,2,184,4,6,0,0,0,7,2,158,4,54,0,0,
255,255,0,70,255,226,4,196,6,193,2,38,0,47,0,0,
0,39,2,184,4,126,1,94,0,7,5,125,4,24,1,64,
255,255,0,80,255,226,4,76,5,209,0,38,0,79,0,0,
0,39,2,184,4,6,0,0,0,7,2,157,3,200,0,0,
255,255,0,70,255,226,4,196,6,227,2,38,0,47,0,0,
0,39,2,184,4,126,1,94,0,7,2,166,4,109,1,64,
255,255,0,80,255,226,4,76,5,163,0,38,0,79,0,0,
0,39,2,184,4,6,0,0,0,7,2,166,4,29,0,0,
255,255,0,70,255,226,4,196,6,113,2,38,0,47,0,0,
0,39,2,184,4,126,1,94,0,7,5,128,4,106,1,64,
255,255,0,80,255,226,4,76,5,89,0,38,0,79,0,0,
0,39,2,184,4,6,0,0,0,7,2,160,4,26,0,0,
255,255,0,70,254,96,4,196,5,215,2,38,0,47,0,0,
0,39,2,184,4,126,1,94,0,7,2,192,4,106,0,0,
255,255,0,80,254,96,4,76,4,121,0,38,0,79,0,0,
0,39,2,184,4,6,0,0,0,7,2,192,4,26,0,0,
255,255,0,50,254,96,4,251,4,236,2,38,0,53,0,0,
0,7,2,192,4,168,0,0,255,255,0,41,254,96,4,45,
3,192,2,38,0,85,0,0,0,7,2,192,4,36,0,0,
255,255,0,50,255,226,4,251,6,227,2,38,0,53,0,0,
0,7,2,166,4,171,1,64,255,255,0,41,255,226,4,45,
5,163,2,38,0,85,0,0,0,7,2,166,4,39,0,0,
255,255,0,50,255,226,5,120,6,193,0,38,0,53,0,0,
0,39,2,184,5,50,1,94,0,7,5,126,4,196,1,64,
255,255,0,41,255,226,4,231,5,209,0,38,0,85,0,0,
0,39,2,184,4,161,0,0,0,7,2,158,4,64,0,0,
255,255,0,50,255,226,5,120,6,193,0,38,0,53,0,0,
0,39,2,184,5,50,1,94,0,7,5,125,4,86,1,64,
255,255,0,41,255,226,4,231,5,209,0,38,0,85,0,0,
0,39,2,184,4,161,0,0,0,7,2,157,3,210,0,0,
255,255,0,50,255,226,5,120,6,227,0,38,0,53,0,0,
0,39,2,184,5,50,1,94,0,7,2,166,4,171,1,64,
255,255,0,41,255,226,4,231,5,163,0,38,0,85,0,0,
0,39,2,184,4,161,0,0,0,7,2,166,4,39,0,0,
255,255,0,50,255,226,5,120,6,113,0,38,0,53,0,0,
0,39,2,184,5,50,1,94,0,7,5,128,4,168,1,64,
255,255,0,41,255,226,4,231,5,89,0,38,0,85,0,0,
0,39,2,184,4,161,0,0,0,7,2,160,4,36,0,0,
255,255,0,50,254,96,5,120,5,215,0,38,0,53,0,0,
0,39,2,184,5,50,1,94,0,7,2,192,4,168,0,0,
255,255,0,41,254,96,4,231,4,121,0,38,0,85,0,0,
0,39,2,184,4,161,0,0,0,7,2,192,4,36,0,0,
255,255,0,0,0,0,4,152,6,193,2,38,0,57,0,0,
0,7,5,125,4,13,1,64,255,255,255,209,254,12,3,221,
5,209,2,38,0,89,0,0,0,7,2,157,3,195,0,0,
255,255,0,0,254,96,4,152,4,246,2,38,0,57,0,0,
0,7,2,192,4,95,0,0,255,255,255,209,254,12,3,221,
3,162,2,38,0,89,0,0,0,7,2,192,5,5,0,0,
255,255,0,0,0,0,4,152,6,227,2,38,0,57,0,0,
0,7,2,166,4,98,1,64,255,255,255,209,254,12,3,221,
5,163,2,38,0,89,0,0,0,7,2,166,4,24,0,0,
255,255,0,0,0,0,4,152,6,113,2,38,0,57,0,0,
0,7,5,128,4,95,1,64,255,255,255,209,254,12,3,221,
5,89,2,38,0,89,0,0,0,7,2,160,4,21,0,0,
255,255,0,80,255,225,4,2,5,251,2,38,3,29,0,0,
0,7,4,230,1,103,0,0,255,255,0,80,255,225,4,2,
5,249,2,38,3,29,0,0,0,7,5,30,1,103,0,0,
255,255,0,80,255,225,4,2,6,4,2,38,3,29,0,0,
0,7,4,243,0,150,0,0,255,255,0,80,255,225,4,2,
6,4,2,38,3,29,0,0,0,6,5,0,110,0,255,255,
0,80,255,225,4,2,6,5,2,38,3,29,0,0,0,7,
4,244,0,240,0,0,255,255,0,80,255,225,4,2,6,5,
2,38,3,29,0,0,0,7,5,1,0,250,0,0,255,255,
0,80,255,225,4,2,6,200,2,38,3,29,0,0,0,7,
4,245,1,103,0,0,255,255,0,80,255,225,4,2,6,200,
2,38,3,29,0,0,0,7,5,2,1,103,0,0,255,255,
0,33,0,0,5,71,5,152,0,39,2,254,0,153,0,0,
0,6,4,230,0,157,255,255,0,50,0,0,5,71,5,150,
0,39,2,254,0,153,0,0,0,6,5,30,0,157,255,255,
0,33,0,0,6,152,5,161,0,39,2,254,1,234,0,0,
0,6,4,243,0,157,255,255,0,49,0,0,6,172,5,161,
0,39,2,254,1,254,0,0,0,6,5,0,0,157,255,255,
0,33,0,0,6,92,5,162,0,39,2,254,1,174,0,0,
0,6,4,244,0,157,255,255,0,31,0,0,6,92,5,162,
0,39,2,254,1,174,0,0,0,6,5,1,0,157,255,255,
255,101,0,0,5,71,6,101,0,39,2,254,0,153,0,0,
0,6,4,245,0,157,255,255,255,101,0,0,5,71,6,101,
0,39,2,254,0,153,0,0,0,6,5,2,0,157,255,255,
0,70,255,225,3,57,5,251,2,38,3,33,0,0,0,7,
4,230,1,38,0,0,255,255,0,70,255,225,3,57,5,249,
2,38,3,33,0,0,0,7,5,30,1,38,0,0,255,255,
0,70,255,225,3,57,6,4,2,38,3,33,0,0,0,6,
4,243,125,0,255,255,0,70,255,225,3,57,6,4,2,38,
3,33,0,0,0,6,5,0,85,0,255,255,0,70,255,225,
3,134,6,5,2,38,3,33,0,0,0,7,4,244,0,175,
0,0,255,255,0,70,255,225,3,144,6,5,2,38,3,33,
0,0,0,7,5,1,0,185,0,0,255,255,0,33,0,0,
5,57,5,152,0,39,3,2,1,127,0,0,0,6,4,230,
0,157,255,255,0,50,0,0,5,57,5,150,0,39,3,2,
1,127,0,0,0,6,5,30,0,157,255,255,0,33,0,0,
6,138,5,161,0,39,3,2,2,208,0,0,0,6,4,243,
0,157,255,255,0,49,0,0,6,158,5,161,0,39,3,2,
2,228,0,0,0,6,5,0,0,157,255,255,0,33,0,0,
6,78,5,162,0,39,3,2,2,148,0,0,0,6,4,244,
0,157,255,255,0,31,0,0,6,78,5,162,0,39,3,2,
2,148,0,0,0,6,5,1,0,157,255,255,0,55,254,72,
3,216,5,251,2,38,3,35,0,0,0,7,4,230,1,143,
0,0,255,255,0,55,254,72,3,216,5,249,2,38,3,35,
0,0,0,7,5,30,1,143,0,0,255,255,0,55,254,72,
3,216,6,4,2,38,3,35,0,0,0,7,4,243,0,230,
0,0,255,255,0,55,254,72,3,216,6,4,2,38,3,35,
0,0,0,7,5,0,0,190,0,0,255,255,0,55,254,72,
3,239,6,5,2,38,3,35,0,0,0,7,4,244,1,24,
0,0,255,255,0,55,254,72,3,249,6,5,2,38,3,35,
0,0,0,7,5,1,1,34,0,0,255,255,0,55,254,72,
3,216,6,200,2,38,3,35,0,0,0,7,4,245,1,143,
0,0,255,255,0,55,254,72,3,216,6,200,2,38,3,35,
0,0,0,7,5,2,1,143,0,0,255,255,0,33,0,0,
6,117,5,152,0,39,3,4,1,127,0,0,0,6,4,230,
0,157,255,255,0,50,0,0,6,117,5,150,0,39,3,4,
1,127,0,0,0,6,5,30,0,157,255,255,0,33,0,0,
7,198,5,161,0,39,3,4,2,208,0,0,0,6,4,243,
0,157,255,255,0,49,0,0,7,218,5,161,0,39,3,4,
2,228,0,0,0,6,5,0,0,157,255,255,0,33,0,0,
7,138,5,162,0,39,3,4,2,148,0,0,0,6,4,244,
0,157,255,255,0,31,0,0,7,138,5,162,0,39,3,4,
2,148,0,0,0,6,5,1,0,157,255,255,255,101,0,0,
6,117,6,101,0,39,3,4,1,127,0,0,0,6,4,245,
0,157,255,255,255,101,0,0,6,117,6,101,0,39,3,4,
1,127,0,0,0,6,5,2,0,157,255,255,0,70,255,225,
2,67,5,251,2,38,3,37,0,0,0,6,4,230,105,0,
255,255,0,70,255,225,2,67,5,249,2,38,3,37,0,0,
0,6,5,30,105,0,255,255,255,226,255,225,2,105,6,4,
2,38,3,37,0,0,0,6,4,243,193,0,255,255,255,202,
255,225,2,85,6,4,2,38,3,37,0,0,0,6,5,0,
153,0,255,255,0,20,255,225,2,202,6,5,2,38,3,37,
0,0,0,6,4,244,243,0,255,255,0,28,255,225,2,212,
6,5,2,38,3,37,0,0,0,6,5,1,253,0,255,255,
255,206,255,225,2,120,6,200,2,38,3,37,0,0,0,6,
4,245,105,0,255,255,255,206,255,225,2,120,6,200,2,38,
3,37,0,0,0,6,5,2,105,0,255,255,0,33,0,0,
3,135,5,152,0,39,3,6,1,107,0,0,0,6,4,230,
0,157,255,255,0,50,0,0,3,135,5,150,0,39,3,6,
1,107,0,0,0,6,5,30,0,157,255,255,0,33,0,0,
4,216,5,161,0,39,3,6,2,188,0,0,0,6,4,243,
0,157,255,255,0,49,0,0,4,236,5,161,0,39,3,6,
2,208,0,0,0,6,5,0,0,157,255,255,0,33,0,0,
4,156,5,162,0,39,3,6,2,128,0,0,0,6,4,244,
0,157,255,255,0,31,0,0,4,156,5,162,0,39,3,6,
2,128,0,0,0,6,5,1,0,157,255,255,255,101,0,0,
3,135,6,101,0,39,3,6,1,107,0,0,0,6,4,245,
0,157,255,255,255,101,0,0,3,135,6,101,0,39,3,6,
1,107,0,0,0,6,5,2,0,157,255,255,0,85,255,226,
3,167,5,251,2,38,3,43,0,0,0,7,4,230,1,78,
0,0,255,255,0,85,255,226,3,167,5,249,2,38,3,43,
0,0,0,7,5,30,1,78,0,0,255,255,0,85,255,226,
3,167,6,4,2,38,3,43,0,0,0,7,4,243,0,165,
0,0,255,255,0,85,255,226,3,167,6,4,2,38,3,43,
0,0,0,6,5,0,125,0,255,255,0,85,255,226,3,174,
6,5,2,38,3,43,0,0,0,7,4,244,0,215,0,0,
255,255,0,85,255,226,3,184,6,5,2,38,3,43,0,0,
0,7,5,1,0,225,0,0,255,255,0,33,255,226,5,192,
5,152,0,39,3,12,1,77,0,0,0,6,4,230,0,157,
255,255,0,50,255,226,5,192,5,150,0,39,3,12,1,77,
0,0,0,6,5,30,0,157,255,255,0,33,255,226,7,17,
5,161,0,39,3,12,2,158,0,0,0,6,4,243,0,157,
255,255,0,49,255,226,7,37,5,161,0,39,3,12,2,178,
0,0,0,6,5,0,0,157,255,255,0,33,255,226,6,113,
5,162,0,39,3,12,1,254,0,0,0,6,4,244,0,157,
255,255,0,31,255,226,6,113,5,162,0,39,3,12,1,254,
0,0,0,6,5,1,0,157,255,255,0,55,255,225,3,191,
5,251,2,38,3,48,0,0,0,7,4,230,1,108,0,0,
255,255,0,55,255,225,3,191,5,249,2,38,3,48,0,0,
0,7,5,30,1,108,0,0,255,255,0,55,255,225,3,191,
6,4,2,38,3,48,0,0,0,7,4,243,0,195,0,0,
255,255,0,55,255,225,3,191,6,4,2,38,3,48,0,0,
0,7,5,0,0,155,0,0,255,255,0,55,255,225,3,204,
6,5,2,38,3,48,0,0,0,7,4,244,0,245,0,0,
255,255,0,55,255,225,3,214,6,5,2,38,3,48,0,0,
0,7,5,1,0,255,0,0,255,255,0,55,255,225,3,191,
6,200,2,38,3,48,0,0,0,7,4,245,1,108,0,0,
255,255,0,55,255,225,3,191,6,200,2,38,3,48,0,0,
0,7,5,2,1,108,0,0,255,255,0,50,0,0,6,121,
5,150,0,39,3,17,1,227,0,0,0,6,5,30,0,157,
255,255,0,49,0,0,7,222,5,161,0,39,3,17,3,72,
0,0,0,6,5,0,0,157,255,255,0,31,0,0,7,142,
5,162,0,39,3,17,2,248,0,0,0,6,5,1,0,157,
255,255,255,101,0,0,6,121,6,101,0,39,3,17,1,227,
0,0,0,6,5,2,0,157,255,255,0,90,255,225,5,65,
5,251,2,38,3,52,0,0,0,7,4,230,2,45,0,0,
255,255,0,90,255,225,5,65,5,249,2,38,3,52,0,0,
0,7,5,30,2,45,0,0,255,255,0,90,255,225,5,65,
6,4,2,38,3,52,0,0,0,7,4,243,1,132,0,0,
255,255,0,90,255,225,5,65,6,4,2,38,3,52,0,0,
0,7,5,0,1,92,0,0,255,255,0,90,255,225,5,65,
6,5,2,38,3,52,0,0,0,7,4,244,1,182,0,0,
255,255,0,90,255,225,5,65,6,5,2,38,3,52,0,0,
0,7,5,1,1,192,0,0,255,255,0,90,255,225,5,65,
6,200,2,38,3,52,0,0,0,7,4,245,2,45,0,0,
255,255,0,90,255,225,5,65,6,200,2,38,3,52,0,0,
0,7,5,2,2,45,0,0,255,255,0,33,0,0,5,214,
5,152,0,39,3,21,1,62,0,0,0,6,4,230,0,157,
255,255,0,50,0,0,5,214,5,150,0,39,3,21,1,62,
0,0,0,6,5,30,0,157,255,255,0,33,0,0,7,39,
5,161,0,39,3,21,2,143,0,0,0,6,4,243,0,157,
255,255,0,49,0,0,7,59,5,161,0,39,3,21,2,163,
0,0,0,6,5,0,0,157,255,255,0,33,0,0,6,135,
5,162,0,39,3,21,1,239,0,0,0,6,4,244,0,157,
255,255,0,31,0,0,6,135,5,162,0,39,3,21,1,239,
0,0,0,6,5,1,0,157,255,255,255,101,0,0,5,214,
6,101,0,39,3,21,1,62,0,0,0,6,4,245,0,157,
255,255,255,101,0,0,5,214,6,101,0,39,3,21,1,62,
0,0,0,6,5,2,0,157,255,255,0,80,255,225,4,2,
6,4,2,38,3,29,0,0,0,7,5,18,0,230,0,0,
255,255,0,80,255,225,4,2,6,5,2,38,3,29,0,0,
0,7,5,29,1,164,0,0,255,255,0,70,255,225,3,57,
6,4,2,38,3,33,0,0,0,7,5,18,0,165,0,0,
255,255,0,70,255,225,3,57,6,5,2,38,3,33,0,0,
0,7,5,29,1,99,0,0,255,255,0,55,254,72,3,216,
6,4,2,38,3,35,0,0,0,7,5,18,1,14,0,0,
255,255,0,55,254,72,3,216,6,5,2,38,3,35,0,0,
0,7,5,29,1,204,0,0,255,255,0,70,255,225,2,67,
6,4,2,38,3,37,0,0,0,6,5,18,233,0,255,255,
0,70,255,225,2,75,6,5,2,38,3,37,0,0,0,7,
5,29,0,166,0,0,255,255,0,85,255,226,3,167,6,4,
2,38,3,43,0,0,0,7,5,18,0,205,0,0,255,255,
0,85,255,226,3,167,6,5,2,38,3,43,0,0,0,7,
5,29,1,139,0,0,255,255,0,55,255,225,3,191,6,4,
2,38,3,48,0,0,0,7,5,18,0,235,0,0,255,255,
0,55,255,225,3,191,6,5,2,38,3,48,0,0,0,7,
5,29,1,169,0,0,255,255,0,90,255,225,5,65,6,4,
2,38,3,52,0,0,0,7,5,18,1,172,0,0,255,255,
0,90,255,225,5,65,6,5,2,38,3,52,0,0,0,7,
5,29,2,106,0,0,255,255,0,80,254,32,4,2,5,251,
2,38,3,29,0,0,0,39,4,230,1,103,0,0,0,7,
2,241,3,232,0,0,255,255,0,80,254,32,4,2,5,249,
2,38,3,29,0,0,0,39,5,30,1,103,0,0,0,7,
2,241,3,232,0,0,255,255,0,80,254,32,4,2,6,4,
2,38,3,29,0,0,0,39,4,243,0,150,0,0,0,7,
2,241,3,232,0,0,255,255,0,80,254,32,4,2,6,4,
2,38,3,29,0,0,0,38,5,0,110,0,0,7,2,241,
3,232,0,0,255,255,0,80,254,32,4,2,6,5,2,38,
3,29,0,0,0,39,4,244,0,240,0,0,0,7,2,241,
3,232,0,0,255,255,0,80,254,32,4,2,6,5,2,38,
3,29,0,0,0,39,5,1,0,250,0,0,0,7,2,241,
3,232,0,0,255,255,0,80,254,32,4,2,6,200,2,38,
3,29,0,0,0,39,4,245,1,103,0,0,0,7,2,241,
3,232,0,0,255,255,0,80,254,32,4,2,6,200,2,38,
3,29,0,0,0,39,5,2,1,103,0,0,0,7,2,241,
3,232,0,0,255,255,0,33,255,225,7,159,5,152,0,39,
2,254,0,153,0,0,0,38,4,230,0,157,0,7,4,229,
5,92,0,0,255,255,0,50,255,225,7,159,5,150,0,39,
2,254,0,153,0,0,0,38,5,30,0,157,0,7,4,229,
5,92,0,0,255,255,0,33,255,225,8,240,5,161,0,39,
2,254,1,234,0,0,0,38,4,243,0,157,0,7,4,229,
6,173,0,0,255,255,0,49,255,225,9,4,5,161,0,39,
2,254,1,254,0,0,0,38,5,0,0,157,0,7,4,229,
6,193,0,0,255,255,0,33,255,225,8,180,5,162,0,39,
2,254,1,174,0,0,0,38,4,244,0,157,0,7,4,229,
6,113,0,0,255,255,0,31,255,225,8,180,5,162,0,39,
2,254,1,174,0,0,0,38,5,1,0,157,0,7,4,229,
6,113,0,0,255,255,255,101,255,225,7,159,6,101,0,39,
2,254,0,153,0,0,0,38,4,245,0,157,0,7,4,229,
5,92,0,0,255,255,255,101,255,225,7,159,6,101,0,39,
2,254,0,153,0,0,0,38,5,2,0,157,0,7,4,229,
5,92,0,0,255,255,0,55,254,32,3,216,5,251,2,38,
3,35,0,0,0,39,4,230,1,143,0,0,0,7,2,241,
3,9,0,0,255,255,0,55,254,32,3,216,5,249,2,38,
3,35,0,0,0,39,5,30,1,143,0,0,0,7,2,241,
3,9,0,0,255,255,0,55,254,32,3,216,6,4,2,38,
3,35,0,0,0,39,4,243,0,230,0,0,0,7,2,241,
3,9,0,0,255,255,0,55,254,32,3,216,6,4,2,38,
3,35,0,0,0,39,5,0,0,190,0,0,0,7,2,241,
3,9,0,0,255,255,0,55,254,32,3,239,6,5,2,38,
3,35,0,0,0,39,4,244,1,24,0,0,0,7,2,241,
3,9,0,0,255,255,0,55,254,32,3,249,6,5,2,38,
3,35,0,0,0,39,5,1,1,34,0,0,0,7,2,241,
3,9,0,0,255,255,0,55,254,32,3,216,6,200,2,38,
3,35,0,0,0,39,4,245,1,143,0,0,0,7,2,241,
3,9,0,0,255,255,0,55,254,32,3,216,6,200,2,38,
3,35,0,0,0,39,5,2,1,143,0,0,0,7,2,241,
3,9,0,0,255,255,0,33,255,225,8,253,5,152,0,39,
3,4,1,127,0,0,0,38,4,230,0,157,0,7,4,229,
6,186,0,0,255,255,0,50,255,225,8,253,5,150,0,39,
3,4,1,127,0,0,0,38,5,30,0,157,0,7,4,229,
6,186,0,0,255,255,0,33,255,225,10,78,5,161,0,39,
3,4,2,208,0,0,0,38,4,243,0,157,0,7,4,229,
8,11,0,0,255,255,0,49,255,225,10,98,5,161,0,39,
3,4,2,228,0,0,0,38,5,0,0,157,0,7,4,229,
8,31,0,0,255,255,0,33,255,225,10,18,5,162,0,39,
3,4,2,148,0,0,0,38,4,244,0,157,0,7,4,229,
7,207,0,0,255,255,0,31,255,225,10,18,5,162,0,39,
3,4,2,148,0,0,0,38,5,1,0,157,0,7,4,229,
7,207,0,0,255,255,255,101,255,225,8,253,6,101,0,39,
3,4,1,127,0,0,0,38,4,245,0,157,0,7,4,229,
6,186,0,0,255,255,255,101,255,225,8,253,6,101,0,39,
3,4,1,127,0,0,0,38,5,2,0,157,0,7,4,229,
6,186,0,0,255,255,0,90,254,32,5,65,5,251,2,38,
3,52,0,0,0,39,4,230,2,45,0,0,0,7,2,241,
4,194,0,0,255,255,0,90,254,32,5,65,5,249,2,38,
3,52,0,0,0,39,5,30,2,45,0,0,0,7,2,241,
4,194,0,0,255,255,0,90,254,32,5,65,6,4,2,38,
3,52,0,0,0,39,4,243,1,132,0,0,0,7,2,241,
4,194,0,0,255,255,0,90,254,32,5,65,6,4,2,38,
3,52,0,0,0,39,5,0,1,92,0,0,0,7,2,241,
4,194,0,0,255,255,0,90,254,32,5,65,6,5,2,38,
3,52,0,0,0,39,4,244,1,182,0,0,0,7,2,241,
4,194,0,0,255,255,0,90,254,32,5,65,6,5,2,38,
3,52,0,0,0,39,5,1,1,192,0,0,0,7,2,241,
4,194,0,0,255,255,0,90,254,32,5,65,6,200,2,38,
3,52,0,0,0,39,4,245,2,45,0,0,0,7,2,241,
4,194,0,0,255,255,0,90,254,32,5,65,6,200,2,38,
3,52,0,0,0,39,5,2,2,45,0,0,0,7,2,241,
4,194,0,0,255,255,0,33,255,225,8,145,5,152,0,39,
3,21,1,62,0,0,0,38,4,230,0,157,0,7,4,229,
6,78,0,0,255,255,0,50,255,225,8,145,5,150,0,39,
3,21,1,62,0,0,0,38,5,30,0,157,0,7,4,229,
6,78,0,0,255,255,0,33,255,225,9,226,5,161,0,39,
3,21,2,143,0,0,0,38,4,243,0,157,0,7,4,229,
7,159,0,0,255,255,0,49,255,225,9,246,5,161,0,39,
3,21,2,163,0,0,0,38,5,0,0,157,0,7,4,229,
7,179,0,0,255,255,0,33,255,225,9,166,5,162,0,39,
3,21,2,83,0,0,0,38,4,244,0,157,0,7,4,229,
7,99,0,0,255,255,0,31,255,225,9,166,5,162,0,39,
3,21,2,83,0,0,0,38,5,1,0,157,0,7,4,229,
7,99,0,0,255,255,255,101,255,225,8,145,6,101,0,39,
3,21,1,62,0,0,0,38,4,245,0,157,0,7,4,229,
6,78,0,0,255,255,255,101,255,225,8,145,6,101,0,39,
3,21,1,62,0,0,0,38,5,2,0,157,0,7,4,229,
6,78,0,0,255,255,0,80,255,225,4,2,5,150,2,38,
3,29,0,0,0,7,2,163,4,41,0,25,255,255,0,80,
255,225,4,2,5,10,2,38,3,29,0,0,0,7,5,129,
4,51,0,25,255,255,0,80,254,32,4,2,6,4,2,38,
3,29,0,0,0,39,5,18,0,230,0,0,0,7,2,241,
3,232,0,0,255,255,0,80,254,32,4,2,3,192,2,38,
3,29,0,0,0,7,2,241,3,232,0,0,255,255,0,80,
254,32,4,2,6,5,2,38,3,29,0,0,0,39,5,29,
1,164,0,0,0,7,2,241,3,232,0,0,255,255,0,80,
255,225,4,2,5,81,2,38,3,29,0,0,0,7,4,231,
0,150,0,25,255,255,0,80,254,32,4,2,5,81,2,38,
3,29,0,0,0,39,4,231,0,150,0,25,0,7,2,241,
3,232,0,0,255,255,0,0,0,0,4,174,6,189,2,38,
2,254,0,0,0,7,2,163,4,81,1,64,255,255,0,0,
0,0,4,174,6,49,2,38,2,254,0,0,0,7,5,129,
4,91,1,64,255,255,0,111,0,0,5,142,5,161,0,39,
2,254,0,224,0,0,0,6,5,18,0,157,255,255,0,40,
0,0,5,149,5,162,0,39,2,254,0,231,0,0,0,6,
5,29,0,157,255,255,0,0,255,225,7,6,5,37,0,38,
2,254,0,0,0,7,4,229,4,195,0,0,0,1,0,33,
4,68,1,71,5,251,0,22,0,71,187,0,0,0,4,0,
7,0,4,43,65,5,0,154,0,7,0,170,0,7,0,2,
93,65,19,0,9,0,7,0,25,0,7,0,41,0,7,0,
57,0,7,0,73,0,7,0,89,0,7,0,105,0,7,0,
121,0,7,0,137,0,7,0,9,93,0,184,0,3,47,48,
49,1,14,1,7,39,62,1,55,54,46,2,35,39,62,3,
23,30,3,1,69,5,89,97,39,42,44,3,2,14,34,55,
39,11,8,53,65,61,16,27,36,21,7,5,80,69,138,61,
33,38,80,46,27,48,36,22,42,10,24,20,13,2,12,36,
45,51,0,1,0,70,255,225,2,67,3,192,0,29,0,51,
187,0,20,0,4,0,8,0,4,43,184,0,20,16,0,184,
0,0,69,88,184,0,18,47,27,185,0,18,0,9,62,89,
184,0,0,69,88,184,0,3,47,27,185,0,3,0,5,62,
89,48,49,37,14,1,35,34,46,2,55,19,54,46,2,35,
53,62,1,55,23,3,6,30,2,51,50,54,55,23,2,67,
92,126,33,35,45,26,10,1,8,1,6,29,62,55,65,148,
66,32,10,1,6,12,17,11,15,75,63,10,109,72,68,28,
57,89,60,1,210,52,66,38,14,40,11,41,29,40,253,151,
69,80,41,10,19,32,45,0,0,1,0,33,4,68,1,71,
5,251,0,22,0,71,187,0,0,0,4,0,7,0,4,43,
65,5,0,154,0,7,0,170,0,7,0,2,93,65,19,0,
9,0,7,0,25,0,7,0,41,0,7,0,57,0,7,0,
73,0,7,0,89,0,7,0,105,0,7,0,121,0,7,0,
137,0,7,0,9,93,0,184,0,3,47,48,49,1,14,1,
7,39,62,1,55,54,46,2,35,39,62,3,23,30,3,1,
69,5,89,97,39,42,44,3,2,14,34,55,39,11,8,53,
65,61,16,27,36,21,7,5,80,69,138,61,33,38,80,46,
27,48,36,22,42,10,24,20,13,2,12,36,45,51,0,1,
0,70,4,76,2,240,5,56,0,28,0,39,0,184,0,5,
47,184,0,13,47,184,0,19,47,184,0,27,47,184,0,19,
16,185,0,10,0,2,252,184,0,5,16,185,0,24,0,2,
252,48,49,1,14,3,35,34,46,2,35,34,6,7,39,62,
3,51,50,30,2,51,50,54,55,23,2,240,18,50,61,72,
39,35,63,60,59,29,40,66,37,53,18,49,62,71,39,38,
68,60,54,24,38,73,34,54,5,33,41,74,56,34,29,35,
29,45,56,20,41,74,57,34,29,35,29,44,59,23,0,3,
0,70,4,60,2,240,6,97,0,15,0,30,0,59,1,75,
184,0,60,47,184,0,61,47,184,0,0,220,185,0,8,0,
4,252,65,5,0,154,0,8,0,170,0,8,0,2,93,65,
19,0,9,0,8,0,25,0,8,0,41,0,8,0,57,0,
8,0,73,0,8,0,89,0,8,0,105,0,8,0,121,0,
8,0,137,0,8,0,9,93,184,0,60,16,184,0,24,208,
184,0,24,47,185,0,16,0,4,252,65,19,0,6,0,16,
0,22,0,16,0,38,0,16,0,54,0,16,0,70,0,16,
0,86,0,16,0,102,0,16,0,118,0,16,0,134,0,16,
0,9,93,65,5,0,149,0,16,0,165,0,16,0,2,93,
184,0,8,16,184,0,36,208,184,0,36,47,184,0,16,16,
184,0,50,208,184,0,50,47,184,0,0,16,184,0,58,208,
184,0,58,47,0,184,0,50,47,184,0,58,47,184,0,0,
69,88,184,0,13,47,27,185,0,13,0,11,62,89,184,0,
0,69,88,184,0,29,47,27,185,0,29,0,11,62,89,187,
0,55,0,2,0,36,0,4,43,184,0,55,16,184,0,13,
16,184,0,5,220,65,5,0,217,0,5,0,233,0,5,0,
2,93,65,27,0,8,0,5,0,24,0,5,0,40,0,5,
0,56,0,5,0,72,0,5,0,88,0,5,0,104,0,5,
0,120,0,5,0,136,0,5,0,152,0,5,0,168,0,5,
0,184,0,5,0,200,0,5,0,13,93,184,0,21,208,184,
0,50,16,185,0,41,0,2,252,48,49,1,20,14,2,35,
34,38,53,52,62,2,51,50,22,5,20,14,2,35,34,38,
53,52,62,2,51,50,1,14,3,35,34,46,2,35,34,6,
7,39,62,3,51,50,30,2,51,50,54,55,23,2,189,17,
31,42,24,45,39,18,31,41,24,44,40,254,111,17,31,42,
25,45,39,18,32,41,24,84,1,196,18,50,61,72,39,35,
63,60,59,29,40,66,37,53,18,49,62,71,39,38,68,60,
54,24,38,73,34,54,4,197,28,50,37,22,50,46,28,50,
37,21,48,47,28,50,37,22,50,46,28,50,37,21,1,38,
41,74,56,34,29,35,29,45,56,20,41,74,57,34,29,35,
29,44,59,23,255,255,0,55,254,32,3,216,6,4,2,38,
3,35,0,0,0,39,5,18,1,14,0,0,0,7,2,241,
3,9,0,0,255,255,0,55,254,32,3,216,3,192,2,38,
3,35,0,0,0,7,2,241,3,9,0,0,255,255,0,55,
254,32,3,216,6,5,2,38,3,35,0,0,0,39,5,29,
1,204,0,0,0,7,2,241,3,9,0,0,255,255,0,55,
254,72,3,216,5,81,2,38,3,35,0,0,0,7,4,231,
0,190,0,25,255,255,0,55,254,32,3,216,5,81,2,38,
3,35,0,0,0,39,4,231,0,190,0,25,0,7,2,241,
3,9,0,0,255,255,0,111,0,0,5,128,5,161,0,39,
3,2,1,198,0,0,0,6,5,18,0,157,255,255,0,40,
0,0,5,135,5,162,0,39,3,2,1,205,0,0,0,6,
5,29,0,157,255,255,0,111,0,0,6,188,5,161,0,39,
3,4,1,198,0,0,0,6,5,18,0,157,255,255,0,40,
0,0,6,195,5,162,0,39,3,4,1,205,0,0,0,6,
5,29,0,157,255,255,0,49,255,225,7,126,4,236,0,38,
3,4,0,0,0,7,4,229,5,59,0,0,0,2,0,33,
4,58,2,168,6,4,0,11,0,34,0,70,187,0,12,0,
4,0,19,0,4,43,184,0,12,16,65,19,0,6,0,12,
0,22,0,12,0,38,0,12,0,54,0,12,0,70,0,12,
0,86,0,12,0,102,0,12,0,118,0,12,0,134,0,12,
0,9,93,65,5,0,149,0,12,0,165,0,12,0,2,93,
48,49,1,14,1,39,3,55,62,2,22,51,19,1,14,1,
7,39,62,1,55,54,46,2,35,39,62,3,23,30,3,2,
168,20,23,18,229,29,10,36,40,38,12,125,254,157,5,89,
97,39,42,44,3,2,14,34,55,39,11,8,53,65,61,16,
27,36,21,7,4,76,9,9,2,1,157,36,3,3,1,1,
254,73,1,4,69,138,61,33,38,80,46,27,48,36,22,42,
10,24,20,13,2,12,36,45,51,0,0,2,0,33,4,60,
2,215,6,5,0,12,0,35,0,83,187,0,13,0,4,0,
20,0,4,43,184,0,13,16,65,19,0,6,0,13,0,22,
0,13,0,38,0,13,0,54,0,13,0,70,0,13,0,86,
0,13,0,102,0,13,0,118,0,13,0,134,0,13,0,9,
93,65,5,0,149,0,13,0,165,0,13,0,2,93,0,184,
0,11,47,184,0,0,47,184,0,16,47,48,49,1,46,3,
39,19,62,3,55,23,5,14,1,7,39,62,1,55,54,46,
2,35,39,62,3,23,30,3,1,143,8,12,12,12,9,176,
16,44,48,47,19,31,254,110,5,89,97,39,42,44,3,2,
14,34,55,39,11,8,53,65,61,16,27,36,21,7,4,60,
2,5,8,10,8,1,119,6,13,14,11,5,35,146,69,138,
61,33,38,80,46,27,48,36,22,42,10,24,20,13,2,12,
36,45,51,0,0,2,255,101,4,50,2,15,6,200,0,20,
0,49,0,39,0,184,0,40,47,184,0,48,47,184,0,3,
47,187,0,45,0,2,0,26,0,4,43,184,0,45,16,184,
0,40,16,185,0,31,0,2,252,48,49,1,14,1,7,39,
62,3,55,54,38,47,1,62,3,23,30,1,19,14,3,35,
34,46,2,35,34,6,7,39,62,3,51,50,30,2,51,50,
54,55,23,1,71,11,85,81,35,13,27,21,14,1,2,65,
78,9,9,56,66,62,16,51,34,192,18,50,61,72,39,35,
63,60,59,29,40,66,37,53,18,49,62,71,39,38,68,60,
54,24,38,73,34,54,5,3,57,114,38,37,8,27,32,34,
17,45,56,6,43,8,18,14,7,3,25,73,1,132,41,74,
56,34,29,35,29,45,56,20,41,74,57,34,29,35,29,44,
59,23,255,255,255,227,255,225,2,109,5,150,2,38,3,37,
0,0,0,7,2,163,3,43,0,25,255,255,255,224,255,225,
2,132,5,10,2,38,3,37,0,0,0,7,5,129,3,53,
0,25,255,255,255,189,255,225,2,148,6,4,2,38,3,37,
0,0,0,6,5,16,148,0,255,255,255,189,255,225,2,148,
6,5,2,38,3,37,0,0,0,6,5,17,148,0,255,255,
255,223,255,225,2,137,5,81,2,38,3,37,0,0,0,6,
4,231,153,25,255,255,255,223,255,225,2,137,6,97,2,38,
3,37,0,0,0,6,4,232,153,0,255,255,255,246,0,0,
2,128,6,189,2,38,3,6,0,0,0,7,2,163,3,62,
1,64,255,255,255,243,0,0,2,151,6,49,2,38,3,6,
0,0,0,7,5,129,3,72,1,64,255,255,0,111,0,0,
3,206,5,161,0,39,3,6,1,178,0,0,0,6,5,18,
0,157,255,255,0,40,0,0,3,213,5,162,0,39,3,6,
1,185,0,0,0,6,5,29,0,157,0,2,0,49,4,58,
2,188,6,4,0,11,0,34,0,70,187,0,19,0,4,0,
12,0,4,43,184,0,19,16,65,19,0,6,0,19,0,22,
0,19,0,38,0,19,0,54,0,19,0,70,0,19,0,86,
0,19,0,102,0,19,0,118,0,19,0,134,0,19,0,9,
93,65,5,0,149,0,19,0,165,0,19,0,2,93,48,49,
1,14,1,39,3,55,62,2,22,51,19,37,30,1,23,55,
46,1,39,38,62,2,63,1,46,3,7,14,3,2,188,20,
23,18,229,29,10,36,40,38,12,125,253,119,7,93,98,39,
48,47,3,2,8,29,55,47,12,23,56,55,51,17,26,35,
20,7,4,76,9,9,2,1,157,36,3,3,1,1,254,73,
229,83,114,40,33,37,70,46,21,49,47,37,9,41,9,18,
13,7,1,18,46,52,56,0,0,2,0,31,4,60,2,215,
6,5,0,12,0,35,0,83,187,0,20,0,4,0,13,0,
4,43,184,0,20,16,65,19,0,6,0,20,0,22,0,20,
0,38,0,20,0,54,0,20,0,70,0,20,0,86,0,20,
0,102,0,20,0,118,0,20,0,134,0,20,0,9,93,65,
5,0,149,0,20,0,165,0,20,0,2,93,0,184,0,11,
47,184,0,0,47,184,0,16,47,48,49,1,46,3,39,19,
62,3,55,23,5,30,1,23,55,46,1,39,38,62,2,63,
1,46,3,7,14,3,1,143,8,12,12,12,9,176,16,44,
48,47,19,31,253,74,7,93,98,39,48,47,3,2,8,29,
55,47,12,23,56,55,51,17,26,35,20,7,4,60,2,5,
8,10,8,1,119,6,13,14,11,5,35,177,83,114,40,33,
37,70,46,21,49,47,37,9,41,9,18,13,7,1,18,46,
52,56,0,2,255,101,4,50,2,15,6,200,0,24,0,53,
0,49,0,184,0,44,47,184,0,52,47,184,0,3,47,187,
0,49,0,2,0,30,0,4,43,184,0,49,16,186,0,4,
0,3,0,52,17,18,57,184,0,44,16,185,0,35,0,2,
252,48,49,19,30,1,23,55,46,3,39,38,62,2,63,1,
46,3,7,14,3,1,14,3,35,34,46,2,35,34,6,7,
39,62,3,51,50,30,2,51,50,54,55,23,58,11,83,86,
36,16,29,22,16,2,3,7,30,56,45,7,23,57,56,51,
17,24,30,16,3,1,217,18,50,61,72,39,35,63,60,59,
29,40,66,37,53,18,49,62,71,39,38,68,60,54,24,38,
73,34,54,4,221,59,92,20,36,6,24,29,31,14,19,40,
38,33,12,42,7,11,8,2,3,18,45,47,47,1,191,41,
74,56,34,29,35,29,45,56,20,41,74,57,34,29,35,29,
44,59,23,0,255,255,0,55,255,225,3,191,5,150,2,38,
3,48,0,0,0,7,2,163,4,46,0,25,255,255,0,55,
255,225,3,191,5,10,2,38,3,48,0,0,0,7,5,129,
4,56,0,25,255,255,0,55,255,225,3,191,6,4,2,38,
3,48,0,0,0,7,5,16,0,150,0,0,255,255,0,55,
255,225,3,191,6,5,2,38,3,48,0,0,0,7,5,17,
0,150,0,0,255,255,0,140,254,12,3,121,5,251,2,38,
3,44,0,0,0,7,4,230,1,69,0,0,255,255,0,140,
254,12,3,121,5,249,2,38,3,44,0,0,0,7,5,30,
1,69,0,0,255,255,0,55,255,225,3,191,5,81,2,38,
3,48,0,0,0,7,4,231,0,155,0,25,255,255,0,55,
255,225,3,191,6,97,2,38,3,48,0,0,0,7,4,232,
0,155,0,0,255,255,0,0,0,0,4,150,6,189,2,38,
3,17,0,0,0,7,2,163,4,95,1,64,255,255,0,0,
0,0,4,150,6,49,2,38,3,17,0,0,0,7,5,129,
4,105,1,64,255,255,0,111,0,0,6,192,5,161,0,39,
3,17,2,42,0,0,0,6,5,18,0,157,255,255,0,40,
0,0,6,199,5,162,0,39,3,17,2,49,0,0,0,6,
5,29,0,157,255,255,0,50,0,0,5,84,5,150,0,39,
3,14,1,127,0,0,0,6,5,30,0,157,0,3,0,41,
4,58,3,0,6,4,0,14,0,29,0,41,0,49,0,184,
0,5,47,184,0,20,47,184,0,33,47,184,0,0,69,88,
184,0,12,47,27,185,0,12,0,11,62,89,184,0,0,69,
88,184,0,28,47,27,185,0,28,0,11,62,89,48,49,1,
22,14,2,35,34,39,38,62,2,51,50,22,5,22,14,2,
35,34,38,39,38,62,2,51,50,5,14,1,39,3,55,62,
2,22,51,19,2,252,4,11,28,45,31,66,14,4,11,29,
45,30,32,43,253,245,4,12,28,45,30,34,41,5,4,11,
28,45,31,66,1,17,20,23,18,229,29,10,36,40,38,12,
125,4,217,27,56,45,29,69,28,57,46,29,36,36,27,56,
45,29,35,34,28,57,46,29,213,9,9,2,1,157,36,3,
3,1,1,254,73,0,0,3,0,41,4,60,3,0,6,5,
0,14,0,29,0,40,0,53,0,184,0,39,47,184,0,5,
47,184,0,20,47,184,0,30,47,184,0,0,69,88,184,0,
12,47,27,185,0,12,0,11,62,89,184,0,0,69,88,184,
0,28,47,27,185,0,28,0,11,62,89,48,49,1,22,14,
2,35,34,39,38,62,2,51,50,22,5,22,14,2,35,34,
38,39,38,62,2,51,50,23,46,1,39,19,62,3,55,23,
2,252,4,11,28,45,31,66,14,4,11,29,45,30,32,43,
253,245,4,12,28,45,30,34,41,5,4,11,28,45,31,66,
127,17,20,18,178,15,44,48,48,19,31,4,217,27,56,45,
29,69,28,57,46,29,36,36,27,56,45,29,35,34,28,57,
46,29,229,4,14,15,1,119,6,13,14,11,5,35,0,1,
0,111,4,58,1,145,6,4,0,11,0,7,0,184,0,3,
47,48,49,1,14,1,39,3,55,62,2,22,51,19,1,145,
20,23,18,229,29,10,36,40,38,12,125,4,76,9,9,2,
1,157,36,3,3,1,1,254,73,0,255,255,0,90,254,32,
5,65,6,4,2,38,3,52,0,0,0,39,5,18,1,172,
0,0,0,7,2,241,4,194,0,0,255,255,0,90,254,32,
5,65,3,198,2,38,3,52,0,0,0,7,2,241,4,194,
0,0,255,255,0,90,254,32,5,65,6,5,2,38,3,52,
0,0,0,39,5,29,2,106,0,0,0,7,2,241,4,194,
0,0,255,255,0,90,255,225,5,65,5,81,2,38,3,52,
0,0,0,7,4,231,1,92,0,25,255,255,0,90,254,32,
5,65,5,81,2,38,3,52,0,0,0,39,4,231,1,92,
0,25,0,7,2,241,4,194,0,0,255,255,0,111,255,226,
6,7,5,161,0,39,3,12,1,148,0,0,0,6,5,18,
0,157,255,255,0,40,255,226,5,120,5,162,0,39,3,12,
1,5,0,0,0,6,5,29,0,157,255,255,0,111,0,0,
6,29,5,161,0,39,3,21,1,133,0,0,0,6,5,18,
0,157,255,255,0,40,0,0,5,142,5,162,0,39,3,21,
0,246,0,0,0,6,5,29,0,157,255,255,0,80,255,225,
7,83,5,10,0,38,3,21,0,0,0,7,4,229,5,16,
0,0,0,1,0,40,4,60,1,165,6,5,0,12,0,11,
0,184,0,11,47,184,0,0,47,48,49,19,46,3,39,19,
62,3,55,23,93,8,12,12,12,9,176,16,44,48,47,19,
31,4,60,2,5,8,10,8,1,119,6,13,14,11,5,35,
0,1,0,50,4,68,1,84,5,249,0,22,0,75,187,0,
16,0,4,0,0,0,4,43,184,0,16,16,65,19,0,6,
0,16,0,22,0,16,0,38,0,16,0,54,0,16,0,70,
0,16,0,86,0,16,0,102,0,16,0,118,0,16,0,134,
0,16,0,9,93,65,5,0,149,0,16,0,165,0,16,0,
2,93,0,184,0,20,47,48,49,19,38,62,2,55,54,30,
2,23,7,14,3,23,30,1,23,7,46,1,52,2,7,20,
35,26,17,51,55,56,23,12,47,55,29,8,2,3,47,48,
39,98,93,5,49,27,56,52,46,18,1,7,13,18,9,41,
9,37,47,49,21,46,70,37,33,40,114,0,0,1,0,61,
1,199,2,117,2,57,0,10,0,17,0,187,0,9,0,2,
0,3,0,4,43,184,0,9,16,48,49,1,14,1,7,33,
39,62,1,55,33,23,2,117,6,17,8,254,0,25,5,17,
9,2,0,25,2,33,22,51,17,24,22,48,20,24,0,1,
0,61,1,199,2,117,2,57,0,10,0,17,0,187,0,9,
0,2,0,3,0,4,43,184,0,9,16,48,49,1,14,1,
7,33,39,62,1,55,33,23,2,117,6,17,8,254,0,25,
5,17,9,2,0,25,2,33,22,51,17,24,22,48,20,24,
0,1,0,61,1,199,3,132,2,57,0,10,0,17,0,187,
0,9,0,2,0,3,0,4,43,184,0,9,16,48,49,1,
14,1,7,33,39,62,1,55,33,23,3,132,5,16,8,252,
239,25,5,17,9,3,17,23,2,33,22,51,17,24,22,48,
20,24,0,1,0,61,1,199,7,96,2,57,0,10,0,17,
0,187,0,9,0,2,0,3,0,4,43,184,0,9,16,48,
49,1,14,1,7,33,39,62,1,55,33,23,7,96,5,17,
8,249,20,25,5,17,9,6,236,24,2,33,22,51,17,24,
22,48,20,24,0,2,0,180,254,107,2,137,6,134,0,10,
0,21,0,67,184,0,22,47,184,0,23,47,184,0,0,220,
185,0,4,0,4,252,184,0,0,16,184,0,9,208,184,0,
22,16,184,0,15,208,184,0,15,47,185,0,11,0,4,252,
184,0,20,208,0,184,0,8,47,184,0,19,47,184,0,3,
47,184,0,14,47,48,49,1,14,1,7,39,17,62,1,55,
23,17,33,14,1,7,39,17,62,1,55,23,17,2,137,18,
61,25,35,28,46,29,36,254,182,18,61,25,35,28,46,29,
36,254,159,16,28,8,23,7,211,17,24,8,22,248,47,16,
28,8,23,7,211,17,24,8,22,248,47,0,0,2,0,61,
254,12,2,227,255,109,0,12,0,25,0,44,0,184,0,0,
69,88,184,0,5,47,27,185,0,5,0,7,62,89,187,0,
24,0,2,0,18,0,4,43,184,0,24,16,184,0,5,16,
185,0,10,0,2,252,48,49,1,14,3,7,33,39,62,1,
55,33,23,53,14,3,7,33,39,62,1,55,33,23,2,227,
2,10,12,11,4,253,151,22,5,26,10,2,103,22,2,10,
12,11,4,253,151,22,5,26,10,2,103,22,254,115,11,28,
28,27,9,25,22,60,20,24,226,11,28,28,27,9,25,22,
60,20,24,0,0,1,0,87,3,195,1,120,5,175,0,22,
0,75,187,0,12,0,4,0,0,0,4,43,184,0,12,16,
65,19,0,6,0,12,0,22,0,12,0,38,0,12,0,54,
0,12,0,70,0,12,0,86,0,12,0,102,0,12,0,118,
0,12,0,134,0,12,0,9,93,65,5,0,149,0,12,0,
165,0,12,0,2,93,0,184,0,18,47,48,49,19,52,54,
55,54,30,2,23,7,14,1,21,20,30,2,23,7,46,3,
87,36,32,18,67,69,58,9,16,57,54,10,21,32,21,45,
48,74,52,27,5,16,57,70,31,1,19,29,31,12,45,3,
67,45,20,53,56,56,22,34,30,83,90,91,0,2,0,87,
3,195,3,30,5,175,0,22,0,45,0,155,184,0,46,47,
184,0,47,47,184,0,12,220,185,0,0,0,4,252,65,5,
0,154,0,0,0,170,0,0,0,2,93,65,19,0,9,0,
0,0,25,0,0,0,41,0,0,0,57,0,0,0,73,0,
0,0,89,0,0,0,105,0,0,0,121,0,0,0,137,0,
0,0,9,93,184,0,46,16,184,0,23,208,184,0,23,47,
185,0,35,0,4,252,65,19,0,6,0,35,0,22,0,35,
0,38,0,35,0,54,0,35,0,70,0,35,0,86,0,35,
0,102,0,35,0,118,0,35,0,134,0,35,0,9,93,65,
5,0,149,0,35,0,165,0,35,0,2,93,0,184,0,18,
47,184,0,41,47,48,49,1,52,54,55,54,30,2,23,7,
14,1,21,20,30,2,23,7,46,3,37,52,54,55,54,30,
2,23,7,14,1,21,20,30,2,23,7,46,3,1,253,36,
32,18,67,69,58,9,16,57,54,10,21,32,21,45,48,74,
52,27,254,90,36,32,18,67,70,58,8,16,57,56,11,21,
31,21,43,48,74,52,27,5,16,57,70,31,1,19,29,31,
12,45,3,67,45,20,53,56,56,22,34,30,83,90,91,39,
57,70,31,1,19,29,31,12,45,3,67,45,20,53,56,56,
22,34,30,83,90,91,0,1,0,120,1,184,1,187,3,52,
0,2,0,21,0,184,0,1,47,184,0,2,47,186,0,0,
0,1,0,2,17,18,57,48,49,1,5,17,1,187,254,189,
2,118,190,1,124,0,0,1,0,131,255,216,1,113,0,236,
0,15,0,79,187,0,0,0,4,0,8,0,4,43,65,19,
0,6,0,0,0,22,0,0,0,38,0,0,0,54,0,0,
0,70,0,0,0,86,0,0,0,102,0,0,0,118,0,0,
0,134,0,0,0,9,93,65,5,0,149,0,0,0,165,0,
0,0,2,93,0,186,0,13,0,5,0,3,43,184,0,13,
16,48,49,37,20,14,2,35,34,38,53,52,62,2,51,50,
22,1,113,21,37,51,29,54,46,22,38,51,28,50,49,123,
35,59,44,25,58,54,34,59,45,26,59,0,0,2,0,131,
255,215,3,51,0,236,0,15,0,31,0,175,184,0,32,47,
184,0,33,47,184,0,0,220,185,0,8,0,4,252,65,5,
0,154,0,8,0,170,0,8,0,2,93,65,19,0,9,0,
8,0,25,0,8,0,41,0,8,0,57,0,8,0,73,0,
8,0,89,0,8,0,105,0,8,0,121,0,8,0,137,0,
8,0,9,93,184,0,32,16,184,0,24,208,184,0,24,47,
185,0,16,0,4,252,65,19,0,6,0,16,0,22,0,16,
0,38,0,16,0,54,0,16,0,70,0,16,0,86,0,16,
0,102,0,16,0,118,0,16,0,134,0,16,0,9,93,65,
5,0,149,0,16,0,165,0,16,0,2,93,0,186,0,13,
0,5,0,3,43,184,0,13,16,184,0,5,16,184,0,21,
208,184,0,13,16,184,0,29,208,48,49,37,20,14,2,35,
34,38,53,52,62,2,51,50,22,5,20,14,2,35,34,38,
53,52,62,2,51,50,22,3,51,21,37,50,29,54,46,22,
38,50,29,49,49,254,62,21,37,51,29,54,46,22,38,51,
28,50,49,123,35,59,45,25,59,54,34,59,45,26,59,54,
35,59,45,25,59,54,34,59,45,26,59,0,0,1,0,150,
1,231,1,131,2,250,0,14,0,79,187,0,0,0,4,0,
8,0,4,43,65,5,0,154,0,8,0,170,0,8,0,2,
93,65,19,0,9,0,8,0,25,0,8,0,41,0,8,0,
57,0,8,0,73,0,8,0,89,0,8,0,105,0,8,0,
121,0,8,0,137,0,8,0,9,93,0,186,0,13,0,5,
0,3,43,184,0,13,16,48,49,1,20,14,2,35,34,38,
53,52,62,2,51,50,1,131,21,37,50,29,53,47,22,38,
50,29,98,2,137,34,59,44,25,57,54,34,59,45,26,0,
0,2,0,43,2,90,2,118,5,81,0,19,0,39,0,31,
0,187,0,15,0,2,0,25,0,4,43,184,0,15,16,187,
0,35,0,2,0,5,0,4,43,184,0,35,16,48,49,1,
52,46,2,35,34,14,2,21,20,30,2,51,50,62,2,55,
20,14,2,35,34,46,2,53,52,62,2,51,50,30,2,1,
239,30,49,62,31,32,54,38,21,27,47,63,35,33,53,38,
21,135,43,80,114,70,71,105,69,35,44,80,113,70,70,106,
69,35,3,191,82,125,84,42,33,69,108,75,83,125,85,43,
33,70,109,98,77,138,104,60,60,104,138,77,78,138,103,61,
60,103,139,0,0,2,0,29,2,108,2,100,5,87,0,2,
0,32,0,0,1,3,51,23,14,1,7,35,21,20,30,2,
23,21,33,53,62,3,61,1,33,39,1,62,1,55,23,17,
51,23,1,144,251,251,212,15,25,16,38,6,18,34,29,254,
169,46,54,29,9,254,164,23,1,94,29,63,21,26,76,18,
4,210,254,180,19,20,27,11,133,5,8,8,9,6,36,36,
6,11,11,10,5,126,20,1,223,11,23,9,21,254,68,19,
0,1,0,55,2,90,2,83,5,74,0,56,0,15,0,186,
0,37,0,34,0,3,43,184,0,37,16,48,49,1,20,14,
2,35,34,38,39,55,30,3,51,50,62,2,53,52,38,35,
34,14,2,7,39,62,3,55,33,50,54,49,23,14,3,7,
33,14,3,7,62,1,51,50,30,2,2,83,37,73,107,70,
72,121,60,24,33,57,52,48,24,45,65,41,19,90,91,15,
41,44,45,18,33,6,18,18,13,2,1,70,40,44,20,8,
19,21,21,8,254,241,1,8,9,9,3,28,65,36,67,102,
68,34,3,98,52,96,73,43,41,48,51,22,27,15,5,29,
48,60,30,82,95,6,12,18,12,20,33,94,101,93,32,12,
18,9,24,23,20,5,18,49,50,46,13,8,6,38,63,82,
0,2,0,68,2,90,2,115,5,89,0,18,0,47,0,0,
1,34,6,7,21,20,30,2,51,50,62,2,53,52,46,2,
23,20,14,2,35,34,46,2,53,52,62,2,55,23,14,3,
7,62,1,51,50,30,2,1,94,34,80,37,27,49,67,40,
34,46,28,12,28,44,54,251,34,68,103,68,61,105,76,44,
57,119,182,126,13,78,122,90,56,12,48,93,31,56,92,65,
35,3,237,22,33,8,67,100,66,33,30,45,54,24,52,69,
39,16,138,42,93,79,51,43,80,111,68,85,155,124,86,15,
35,16,63,84,100,52,35,28,30,56,80,0,0,1,0,73,
2,90,2,118,5,62,0,28,0,0,1,14,3,7,14,1,
7,39,62,3,55,33,34,38,14,1,7,39,62,3,55,33,
23,2,118,49,98,85,68,18,25,73,35,29,61,95,81,72,
39,254,219,10,20,21,24,15,42,2,7,8,9,4,1,247,
24,5,40,97,199,180,150,48,14,22,8,20,92,163,153,148,
77,2,11,33,35,11,14,41,44,41,13,22,0,3,0,56,
2,90,2,103,5,81,0,15,0,35,0,69,0,0,19,20,
30,2,23,62,1,53,52,38,35,34,14,2,1,52,46,2,
39,14,3,21,20,30,2,51,50,62,2,55,20,14,2,35,
34,46,2,53,52,54,55,46,3,53,52,62,2,51,50,22,
21,20,6,7,30,3,202,29,50,64,35,47,31,81,61,28,
42,29,15,1,27,32,53,67,36,32,41,26,10,24,42,60,
36,35,51,33,16,130,46,80,110,63,64,97,66,33,97,87,
30,54,40,24,39,69,95,56,113,116,76,66,34,64,50,29,
4,166,26,37,30,25,13,31,62,31,55,57,20,32,37,254,
111,39,54,40,29,14,20,39,41,45,27,27,50,38,22,25,
38,47,49,47,83,62,37,31,53,68,37,64,107,41,12,29,
39,51,35,42,70,51,29,90,70,49,79,36,15,36,49,64,
0,2,0,60,2,82,2,107,5,81,0,17,0,46,0,17,
0,187,0,42,0,2,0,8,0,4,43,184,0,42,16,48,
49,1,50,54,55,52,46,2,35,34,14,2,21,20,30,2,
37,20,14,2,7,39,62,3,55,14,1,35,34,46,2,53,
52,62,2,51,50,30,2,1,81,49,73,27,32,47,56,25,
32,53,37,20,31,47,53,1,48,61,123,186,126,13,87,131,
91,53,9,35,90,49,60,92,63,32,43,77,108,66,52,96,
74,43,3,190,35,30,79,106,63,27,25,44,60,35,56,68,
39,13,101,91,159,123,80,12,36,19,62,82,101,58,32,39,
34,59,78,45,45,94,77,48,35,73,115,0,0,1,0,43,
2,231,2,33,4,148,0,32,0,27,0,186,0,6,0,5,
0,3,43,184,0,6,16,186,0,21,0,22,0,3,43,184,
0,21,16,48,49,1,14,3,7,39,53,35,39,62,3,55,
51,53,62,3,55,23,21,51,23,14,3,7,35,21,1,88,
7,22,24,23,7,18,183,17,2,5,5,6,3,179,7,22,
24,23,8,17,184,17,2,5,6,5,3,180,2,250,3,6,
4,5,1,13,158,14,6,20,21,20,6,154,1,5,5,4,
2,14,157,15,6,20,22,19,5,152,0,1,0,43,3,115,
1,184,3,203,0,14,0,0,1,14,3,7,33,39,62,3,
55,33,23,1,184,2,5,6,5,3,254,153,17,2,5,5,
6,3,1,103,17,3,189,6,21,23,19,5,14,7,20,22,
19,6,14,0,0,2,0,43,3,54,2,75,4,67,0,14,
0,29,0,0,1,14,3,7,33,39,62,3,55,33,23,21,
14,3,7,33,39,62,3,55,33,23,2,75,2,5,6,6,
2,254,6,17,2,5,5,6,3,1,249,18,2,5,6,6,
2,254,6,17,2,5,5,6,3,1,249,18,4,52,6,20,
22,20,5,15,6,20,22,19,6,15,180,6,20,22,20,6,
17,6,19,21,20,6,15,0,0,1,0,75,1,175,1,171,
6,44,0,21,0,0,1,46,3,53,52,62,2,55,23,14,
3,21,20,30,2,23,1,149,80,123,84,43,49,87,122,72,
22,46,78,57,32,26,53,80,54,1,175,31,112,148,176,96,
99,183,155,117,32,27,33,105,139,169,96,88,166,145,116,38,
0,1,0,29,1,175,1,125,6,44,0,21,0,0,1,20,
14,2,7,39,62,3,53,52,46,2,39,55,30,3,1,125,
49,89,121,72,21,45,78,57,33,26,53,80,54,21,79,123,
85,44,3,250,99,184,154,118,32,27,33,105,139,170,96,87,
166,145,117,37,27,31,112,147,177,0,0,1,0,39,2,108,
3,2,4,172,0,54,0,37,0,187,0,35,0,2,0,31,
0,4,43,184,0,35,16,184,0,31,16,184,0,10,208,184,
0,10,47,184,0,35,16,184,0,42,208,48,49,1,53,62,
1,53,17,52,46,2,35,34,14,2,7,17,20,22,23,21,
33,53,62,1,53,17,52,46,2,39,53,62,1,55,31,1,
62,3,51,50,30,2,21,17,20,30,2,23,21,1,213,51,
37,12,24,33,21,21,48,53,59,34,42,46,254,211,46,41,
1,15,36,35,48,91,39,24,8,31,71,72,67,27,34,60,
45,26,7,19,35,27,2,108,36,11,17,8,1,42,36,46,
26,10,15,36,61,47,254,255,9,19,8,36,36,11,15,10,
1,89,23,28,15,8,3,34,6,25,17,21,139,40,60,40,
20,19,36,52,34,254,149,4,7,9,10,6,36,0,255,255,
0,43,255,29,2,118,2,20,2,7,5,55,0,0,252,195,
255,255,0,97,255,47,2,76,2,26,2,7,0,215,0,0,
252,195,255,255,0,59,255,47,2,83,2,20,2,7,0,213,
0,0,252,195,255,255,0,38,255,29,2,75,2,20,2,7,
0,214,0,0,252,195,255,255,0,29,255,47,2,100,2,26,
2,7,5,56,0,0,252,195,255,255,0,55,255,29,2,83,
2,13,2,7,5,57,0,0,252,195,255,255,0,68,255,29,
2,115,2,28,2,7,5,58,0,0,252,195,255,255,0,73,
255,29,2,118,2,1,2,7,5,59,0,0,252,195,255,255,
0,56,255,29,2,103,2,20,2,7,5,60,0,0,252,195,
255,255,0,60,255,21,2,107,2,20,2,7,5,61,0,0,
252,195,255,255,0,43,255,170,2,33,1,87,2,7,5,62,
0,0,252,195,255,255,0,43,0,54,1,184,0,142,2,7,
5,63,0,0,252,195,255,255,0,43,255,249,2,75,1,6,
2,7,5,64,0,0,252,195,255,255,0,75,254,114,1,171,
2,239,2,7,5,65,0,0,252,195,0,1,0,29,254,113,
1,125,2,238,0,21,0,0,37,20,14,2,7,39,62,3,
53,52,46,2,39,55,30,3,1,125,49,89,121,72,21,45,
78,57,33,26,53,80,54,21,79,123,85,44,188,99,184,154,
118,32,27,33,105,139,170,96,87,166,145,117,37,27,31,112,
147,177,0,3,0,76,255,156,3,147,5,34,0,12,0,21,
0,90,1,63,187,0,0,0,4,0,72,0,4,43,65,19,
0,6,0,0,0,22,0,0,0,38,0,0,0,54,0,0,
0,70,0,0,0,86,0,0,0,102,0,0,0,118,0,0,
0,134,0,0,0,9,93,65,5,0,149,0,0,0,165,0,
0,0,2,93,0,184,0,56,47,184,0,67,47,184,0,0,
69,88,184,0,81,47,27,185,0,81,0,11,62,89,184,0,
0,69,88,184,0,89,47,27,185,0,89,0,11,62,89,184,
0,0,69,88,184,0,48,47,27,185,0,48,0,5,62,89,
187,0,77,0,2,0,6,0,4,43,184,0,77,16,186,0,
2,0,56,0,81,17,18,57,184,0,6,16,184,0,3,208,
184,0,3,47,186,0,16,0,56,0,81,17,18,57,184,0,
48,16,185,0,35,0,2,252,65,33,0,7,0,35,0,23,
0,35,0,39,0,35,0,55,0,35,0,71,0,35,0,87,
0,35,0,103,0,35,0,119,0,35,0,135,0,35,0,151,
0,35,0,167,0,35,0,183,0,35,0,199,0,35,0,215,
0,35,0,231,0,35,0,247,0,35,0,16,93,65,15,0,
7,0,35,0,23,0,35,0,39,0,35,0,55,0,35,0,
71,0,35,0,87,0,35,0,103,0,35,0,7,113,65,5,
0,118,0,35,0,134,0,35,0,2,113,186,0,61,0,56,
0,81,17,18,57,184,0,77,16,184,0,83,208,184,0,83,
47,48,49,19,20,23,1,34,38,35,34,14,4,19,30,1,
23,1,46,1,39,9,1,30,1,23,22,14,2,7,39,35,
1,22,51,50,54,55,30,3,23,14,3,35,34,39,7,14,
3,7,39,55,46,1,39,7,14,3,7,39,55,46,1,53,
52,62,2,63,1,62,1,55,23,7,22,23,55,62,1,55,
23,231,29,1,24,4,8,4,27,64,65,61,47,29,72,15,
36,20,1,79,21,46,26,254,199,2,15,18,33,15,6,18,
31,35,12,35,1,254,180,66,71,46,147,110,5,11,10,8,
3,64,108,99,93,48,60,57,24,10,14,12,15,12,20,38,
22,41,19,63,10,14,12,15,12,20,90,48,55,78,136,185,
107,21,15,24,20,21,23,53,49,31,15,24,20,21,2,86,
123,95,2,232,1,22,50,81,117,156,254,88,29,47,20,3,
121,14,23,8,252,186,3,136,10,23,11,5,30,38,38,12,
6,252,135,39,74,92,2,13,14,13,3,68,93,56,24,21,
66,6,7,5,4,3,25,100,14,34,20,168,6,7,5,4,
3,25,239,74,198,125,150,244,174,99,6,56,8,13,3,22,
60,6,17,81,8,13,3,22,0,1,0,76,255,226,3,147,
4,211,0,84,0,150,184,0,85,47,184,0,86,47,184,0,
15,220,184,0,85,16,184,0,33,208,184,0,33,47,185,0,
59,0,4,252,65,19,0,6,0,59,0,22,0,59,0,38,
0,59,0,54,0,59,0,70,0,59,0,86,0,59,0,102,
0,59,0,118,0,59,0,134,0,59,0,9,93,65,5,0,
149,0,59,0,165,0,59,0,2,93,184,0,15,16,185,0,
64,0,3,252,184,0,15,16,184,0,77,208,184,0,77,47,
0,184,0,0,69,88,184,0,28,47,27,185,0,28,0,5,
62,89,187,0,38,0,2,0,52,0,4,43,184,0,38,16,
184,0,28,16,185,0,15,0,2,252,48,49,1,22,14,2,
7,35,46,1,35,34,14,2,7,17,62,1,55,30,3,23,
14,3,35,34,46,2,53,52,62,2,51,50,22,23,22,14,
2,7,39,46,3,35,34,14,4,21,20,30,2,23,17,52,
38,39,46,1,39,53,62,1,55,31,1,62,3,51,50,22,
3,128,7,1,12,18,10,33,10,38,29,15,40,45,47,21,
46,143,105,5,11,10,8,3,64,108,99,93,48,81,154,120,
72,82,144,194,112,93,143,52,6,18,31,35,12,35,25,52,
60,68,42,27,64,65,61,47,29,38,65,85,47,10,8,11,
36,44,51,98,39,27,10,22,48,53,58,31,26,47,2,209,
4,45,60,63,21,64,49,29,62,96,66,254,214,3,75,88,
2,13,14,13,3,68,93,56,24,79,151,220,141,154,250,175,
95,58,42,5,30,38,38,12,6,23,39,29,16,22,50,81,
117,156,101,101,160,120,81,21,1,165,52,40,7,11,8,3,
31,13,27,22,27,177,43,75,55,31,12,0,0,1,0,50,
0,0,3,129,4,180,0,54,0,133,187,0,50,0,4,0,
4,0,4,43,184,0,50,16,184,0,4,16,184,0,11,208,
184,0,50,16,184,0,30,208,184,0,50,16,184,0,44,208,
0,184,0,0,69,88,184,0,23,47,27,185,0,23,0,9,
62,89,184,0,0,69,88,184,0,0,47,27,185,0,0,0,
5,62,89,187,0,17,0,2,0,29,0,4,43,184,0,17,
16,187,0,11,0,2,0,5,0,4,43,184,0,11,16,187,
0,31,0,2,0,44,0,4,43,184,0,31,16,184,0,11,
16,184,0,45,208,184,0,5,16,184,0,48,208,48,49,51,
53,62,1,61,1,35,39,62,1,55,51,17,52,38,39,53,
33,23,14,3,7,35,46,3,35,33,17,33,23,14,3,7,
46,3,43,1,21,51,23,7,35,21,20,22,23,21,50,68,
77,109,22,5,7,6,113,73,72,3,48,31,1,8,11,13,
6,47,2,11,21,29,19,254,138,1,118,29,9,24,26,25,
10,15,34,45,61,42,112,190,25,21,194,77,98,43,14,33,
14,233,25,15,24,16,2,170,12,36,14,43,25,26,62,62,
56,19,46,62,37,15,254,108,28,14,31,29,25,8,15,20,
14,6,213,23,57,233,12,30,19,43,0,1,0,54,255,225,
3,130,4,211,0,89,0,123,0,187,0,58,0,2,0,72,
0,4,43,184,0,58,16,186,0,35,0,4,0,3,43,184,
0,35,16,187,0,53,0,2,0,47,0,4,43,184,0,53,
16,184,0,35,16,184,0,0,208,184,0,4,16,184,0,11,
208,184,0,0,16,185,0,88,0,2,252,184,0,40,208,185,
0,48,0,2,252,184,0,72,16,184,0,80,220,184,0,52,
208,184,0,53,16,184,0,79,208,184,0,48,16,184,0,82,
208,184,0,47,16,184,0,83,208,184,0,40,16,184,0,87,
208,48,49,1,35,14,1,7,62,1,30,3,55,62,3,55,
23,14,3,7,14,1,46,2,6,7,39,62,3,39,35,39,
62,1,55,51,46,1,39,46,1,39,35,39,62,1,55,51,
62,3,51,50,30,2,23,14,3,7,35,46,1,35,34,14,
4,23,33,23,7,35,23,30,1,21,51,23,2,103,245,9,
61,42,46,69,58,50,53,58,37,46,66,51,42,21,43,4,
11,11,11,4,45,121,139,147,142,127,49,23,41,58,35,12,
4,130,22,5,11,6,125,1,2,1,2,1,1,117,22,5,
11,6,117,4,56,104,154,103,26,49,56,69,47,1,8,11,
13,6,47,14,121,100,24,49,45,37,25,10,5,1,4,25,
25,253,6,2,3,242,25,1,170,102,166,57,4,2,1,2,
3,1,1,1,10,34,67,59,18,43,79,67,50,15,25,6,
14,23,10,15,31,49,34,57,84,128,104,25,15,35,16,14,
30,17,17,34,17,25,15,35,16,117,185,128,68,4,15,27,
24,26,74,77,69,19,124,112,9,28,53,89,130,90,23,68,
51,20,39,19,23,0,0,2,0,55,255,36,4,42,4,10,
0,5,0,91,0,242,187,0,57,0,3,0,66,0,4,43,
184,0,57,16,187,0,32,0,3,0,3,0,4,43,184,0,
32,16,187,0,12,0,3,0,21,0,4,43,184,0,12,16,
186,0,6,0,66,0,12,17,18,57,184,0,3,16,184,0,
45,208,184,0,57,16,184,0,77,208,184,0,77,47,186,0,
78,0,66,0,57,17,18,57,184,0,32,16,184,0,86,208,
184,0,86,47,184,0,12,16,184,0,93,220,0,184,0,90,
47,184,0,43,47,184,0,0,69,88,184,0,16,47,27,185,
0,16,0,5,62,89,184,0,0,69,88,184,0,38,47,27,
185,0,38,0,5,62,89,184,0,0,69,88,184,0,61,47,
27,185,0,61,0,5,62,89,187,0,8,0,2,0,27,0,
4,43,184,0,8,16,186,0,4,0,43,0,90,17,18,57,
186,0,6,0,27,0,8,17,18,57,184,0,27,16,184,0,
51,208,184,0,27,16,184,0,72,208,186,0,78,0,43,0,
90,17,18,57,184,0,8,16,184,0,81,208,186,0,86,0,
43,0,90,17,18,57,48,49,37,62,1,61,1,7,1,54,
51,50,22,21,17,20,22,23,21,33,53,62,1,53,17,52,
46,2,35,34,6,15,1,17,20,30,2,23,21,33,7,14,
1,7,39,19,53,52,46,2,35,34,14,2,7,17,20,22,
23,21,33,53,62,1,53,17,52,46,2,39,53,62,1,55,
31,1,62,1,51,50,30,2,23,19,62,1,55,23,1,195,
29,21,50,1,57,35,32,69,74,41,51,254,233,47,33,8,
16,23,16,26,57,29,73,6,18,31,26,254,243,89,20,30,
23,20,252,8,15,24,16,22,39,41,46,27,28,42,254,234,
43,48,5,18,37,31,49,91,35,23,7,58,103,54,31,51,
36,22,3,185,15,34,20,21,43,11,18,9,72,110,2,175,
20,83,88,254,14,11,20,16,34,34,14,22,11,1,157,48,
63,36,15,43,41,161,254,182,5,10,11,13,8,34,195,11,
8,6,25,2,36,141,48,63,36,15,28,54,78,49,254,146,
11,25,11,34,34,14,20,13,1,218,31,36,20,9,5,31,
10,32,21,28,169,104,93,13,32,56,42,1,147,8,13,3,
22,0,0,5,0,37,255,226,3,156,4,180,0,2,0,5,
0,9,0,13,0,78,1,9,184,0,79,47,184,0,80,47,
184,0,79,16,184,0,18,208,184,0,18,47,185,0,74,0,
3,252,184,0,0,208,184,0,80,16,184,0,67,220,186,0,
2,0,18,0,67,17,18,57,185,0,4,0,3,252,184,0,
74,16,184,0,6,208,186,0,7,0,18,0,67,17,18,57,
184,0,4,16,184,0,11,208,186,0,13,0,18,0,67,17,
18,57,184,0,18,16,184,0,25,208,184,0,18,16,184,0,
32,208,184,0,4,16,184,0,45,208,184,0,67,16,184,0,
57,208,184,0,67,16,184,0,62,208,0,184,0,37,47,184,
0,52,47,187,0,11,0,2,0,4,0,4,43,184,0,11,
16,187,0,2,0,2,0,8,0,4,43,184,0,2,16,184,
0,11,16,184,0,6,208,184,0,8,16,184,0,12,208,184,
0,4,16,184,0,19,208,184,0,11,16,184,0,24,208,184,
0,8,16,184,0,26,208,184,0,2,16,184,0,31,208,184,
0,2,16,184,0,44,208,184,0,2,16,184,0,58,208,184,
0,8,16,184,0,61,208,184,0,11,16,184,0,63,208,184,
0,4,16,184,0,66,208,184,0,4,16,184,0,72,208,48,
49,19,21,51,1,53,35,37,51,39,35,5,51,53,35,1,
53,62,1,53,17,35,39,62,1,55,51,53,35,39,62,1,
55,51,17,46,1,39,53,51,50,30,2,23,19,51,17,52,
46,2,39,53,33,21,14,1,21,17,51,23,7,35,21,51,
23,7,35,17,46,1,39,3,35,17,20,22,23,21,248,80,
1,129,86,254,133,178,48,130,1,73,136,185,254,21,54,51,
83,22,5,11,6,83,83,22,5,11,6,83,25,49,31,163,
10,14,14,17,14,209,235,11,24,40,29,1,59,52,52,79,
25,25,79,79,25,25,79,36,52,8,248,228,48,57,3,127,
148,254,83,158,91,89,89,89,253,111,41,8,37,13,1,122,
25,15,35,16,89,25,15,35,16,1,82,35,35,7,42,5,
16,29,25,254,130,1,100,6,16,16,16,5,42,42,9,36,
14,254,156,23,68,89,23,68,254,6,6,27,16,1,201,254,
134,11,37,10,40,0,0,2,0,41,255,226,6,176,4,211,
0,38,0,154,2,105,187,0,148,0,4,0,43,0,4,43,
184,0,148,16,187,0,56,0,4,0,139,0,4,43,184,0,
56,16,187,0,64,0,3,0,60,0,4,43,184,0,64,16,
187,0,86,0,3,0,27,0,4,43,184,0,86,16,187,0,
96,0,3,0,17,0,4,43,184,0,96,16,65,5,0,154,
0,27,0,170,0,27,0,2,93,65,19,0,9,0,27,0,
25,0,27,0,41,0,27,0,57,0,27,0,73,0,27,0,
89,0,27,0,105,0,27,0,121,0,27,0,137,0,27,0,
9,93,184,0,27,16,184,0,3,208,184,0,3,47,65,5,
0,154,0,17,0,170,0,17,0,2,93,65,19,0,9,0,
17,0,25,0,17,0,41,0,17,0,57,0,17,0,73,0,
17,0,89,0,17,0,105,0,17,0,121,0,17,0,137,0,
17,0,9,93,186,0,29,0,27,0,86,17,18,57,184,0,
64,16,184,0,33,208,65,19,0,6,0,56,0,22,0,56,
0,38,0,56,0,54,0,56,0,70,0,56,0,86,0,56,
0,102,0,56,0,118,0,56,0,134,0,56,0,9,93,65,
5,0,149,0,56,0,165,0,56,0,2,93,186,0,59,0,
139,0,56,17,18,57,184,0,60,16,184,0,116,208,186,0,
129,0,43,0,96,17,18,57,184,0,96,16,184,0,156,220,
0,184,0,0,69,88,184,0,39,47,27,185,0,39,0,5,
62,89,184,0,0,69,88,184,0,103,47,27,185,0,103,0,
5,62,89,184,0,0,69,88,184,0,111,47,27,185,0,111,
0,5,62,89,187,0,51,0,2,0,144,0,4,43,184,0,
51,16,187,0,134,0,2,0,123,0,4,43,184,0,134,16,
187,0,67,0,2,0,81,0,4,43,184,0,67,16,187,0,
64,0,2,0,33,0,4,43,184,0,64,16,184,0,103,16,
185,0,14,0,2,252,65,33,0,7,0,14,0,23,0,14,
0,39,0,14,0,55,0,14,0,71,0,14,0,87,0,14,
0,103,0,14,0,119,0,14,0,135,0,14,0,151,0,14,
0,167,0,14,0,183,0,14,0,199,0,14,0,215,0,14,
0,231,0,14,0,247,0,14,0,16,93,65,15,0,7,0,
14,0,23,0,14,0,39,0,14,0,55,0,14,0,71,0,
14,0,87,0,14,0,103,0,14,0,7,113,65,5,0,118,
0,14,0,134,0,14,0,2,113,184,0,40,208,184,0,40,
47,184,0,51,16,185,0,47,0,2,252,184,0,81,16,185,
0,65,0,1,252,184,0,59,208,184,0,64,16,184,0,60,
208,184,0,134,16,184,0,78,208,184,0,78,47,184,0,33,
16,184,0,117,208,184,0,144,16,184,0,147,208,184,0,147,
47,184,0,40,16,184,0,153,208,184,0,153,47,48,49,37,
50,54,55,52,62,2,55,23,30,3,51,50,54,53,52,46,
2,39,46,3,53,52,55,46,1,43,1,17,20,30,2,5,
53,62,1,53,17,14,1,7,39,62,1,51,50,30,2,21,
20,6,7,51,53,55,23,17,33,54,51,50,30,2,23,22,
14,2,7,39,46,1,35,34,14,2,21,20,30,2,23,30,
3,21,20,14,4,35,34,38,39,34,53,14,1,35,34,46,
2,53,17,35,14,3,35,34,46,2,47,1,30,3,51,50,
62,2,53,52,46,2,35,34,6,35,17,20,30,2,23,21,
4,119,19,43,31,2,3,6,3,34,2,31,53,70,41,57,
72,34,55,70,36,33,62,48,29,25,24,60,35,91,9,20,
32,251,210,61,69,32,63,35,8,87,195,109,93,148,105,56,
18,15,139,94,24,1,50,51,62,25,59,57,50,16,5,7,
15,17,5,31,38,81,39,26,41,29,15,30,49,62,33,34,
69,56,34,32,49,62,60,52,15,38,106,53,2,51,86,29,
27,50,37,23,182,27,66,69,68,30,20,33,29,27,15,21,
19,29,27,27,16,37,80,64,42,49,85,114,65,15,29,14,
14,35,61,47,74,8,12,16,35,33,28,10,8,33,59,43,
26,69,56,32,48,41,35,19,17,38,47,58,38,54,42,5,
6,254,95,47,62,37,15,74,41,14,32,13,4,16,5,10,
7,60,25,32,44,86,127,82,50,84,36,194,81,19,255,0,
24,9,16,22,14,5,33,39,35,6,6,57,45,18,27,34,
16,26,40,35,32,17,18,39,51,66,44,55,80,55,33,17,
6,28,29,2,29,30,21,46,76,55,1,228,36,53,35,17,
3,7,11,7,73,9,11,6,2,34,69,101,68,79,113,73,
34,1,251,226,6,14,15,16,8,41,0,2,0,41,255,226,
4,238,4,211,0,14,0,116,1,64,187,0,112,0,4,0,
19,0,4,43,184,0,112,16,187,0,34,0,4,0,10,0,
4,43,184,0,34,16,187,0,92,0,3,0,48,0,4,43,
184,0,92,16,184,0,112,16,184,0,3,208,65,5,0,154,
0,10,0,170,0,10,0,2,93,65,19,0,9,0,10,0,
25,0,10,0,41,0,10,0,57,0,10,0,73,0,10,0,
89,0,10,0,105,0,10,0,121,0,10,0,137,0,10,0,
9,93,186,0,39,0,19,0,92,17,18,57,65,5,0,154,
0,48,0,170,0,48,0,2,93,65,19,0,9,0,48,0,
25,0,48,0,41,0,48,0,57,0,48,0,73,0,48,0,
89,0,48,0,105,0,48,0,121,0,48,0,137,0,48,0,
9,93,186,0,58,0,10,0,34,17,18,57,184,0,58,47,
65,5,0,154,0,58,0,170,0,58,0,2,93,65,19,0,
9,0,58,0,25,0,58,0,41,0,58,0,57,0,58,0,
73,0,58,0,89,0,58,0,105,0,58,0,121,0,58,0,
137,0,58,0,9,93,185,0,82,0,3,252,184,0,92,16,
184,0,118,220,0,184,0,0,69,88,184,0,15,47,27,185,
0,15,0,5,62,89,187,0,29,0,2,0,0,0,4,43,
184,0,29,16,187,0,63,0,2,0,77,0,4,43,184,0,
63,16,184,0,0,16,184,0,3,208,184,0,3,47,184,0,
29,16,185,0,23,0,2,252,48,49,1,34,6,7,17,30,
1,51,50,54,53,52,46,2,1,53,62,1,53,17,14,1,
7,39,62,3,51,50,30,2,21,20,14,2,7,1,30,3,
51,50,54,53,52,46,2,39,46,3,53,52,62,2,51,50,
30,2,23,22,14,2,7,39,46,1,35,34,14,2,21,20,
30,2,23,30,3,21,20,14,4,35,34,46,4,39,1,35,
34,38,39,17,20,22,23,21,1,122,16,32,16,23,33,19,
143,158,37,77,117,254,101,60,66,31,63,32,7,40,83,90,
100,57,103,155,103,51,43,76,104,62,1,31,16,44,48,52,
26,73,76,34,55,70,36,33,62,48,29,40,65,84,45,25,
59,57,50,16,5,7,15,17,5,31,38,81,39,26,41,29,
15,30,49,62,33,34,69,56,34,34,55,66,65,55,15,5,
39,53,60,55,41,8,254,219,14,22,45,23,62,63,4,130,
1,1,254,22,4,2,132,128,52,88,63,35,251,126,40,14,
32,13,4,14,4,10,5,59,11,21,16,10,45,78,106,61,
73,118,89,61,15,254,55,26,33,19,7,69,56,32,48,41,
35,19,17,38,47,58,38,49,76,52,28,9,16,22,14,5,
33,39,35,6,6,57,45,18,27,34,16,26,40,35,32,17,
18,39,51,66,44,55,80,55,33,17,6,2,6,11,15,21,
14,2,23,4,5,254,28,12,33,14,40,0,0,3,0,80,
255,36,3,142,4,211,0,7,0,27,0,84,1,164,184,0,
85,47,184,0,86,47,184,0,77,220,184,0,0,208,184,0,
0,47,184,0,77,16,184,0,6,208,184,0,6,47,184,0,
77,16,185,0,27,0,4,252,184,0,9,208,184,0,85,16,
184,0,44,208,184,0,44,47,185,0,17,0,4,252,65,19,
0,6,0,17,0,22,0,17,0,38,0,17,0,54,0,17,
0,70,0,17,0,86,0,17,0,102,0,17,0,118,0,17,
0,134,0,17,0,9,93,65,5,0,149,0,17,0,165,0,
17,0,2,93,184,0,27,16,184,0,34,208,184,0,34,47,
184,0,27,16,184,0,54,208,184,0,27,16,184,0,61,208,
184,0,77,16,184,0,71,208,0,184,0,0,69,88,184,0,
31,47,27,185,0,31,0,5,62,89,184,0,0,69,88,184,
0,39,47,27,185,0,39,0,5,62,89,187,0,6,0,2,
0,0,0,4,43,184,0,6,16,187,0,66,0,2,0,60,
0,4,43,184,0,66,16,187,0,56,0,2,0,51,0,4,
43,184,0,56,16,184,0,39,16,185,0,5,0,2,252,184,
0,51,16,185,0,12,0,2,252,184,0,39,16,185,0,22,
0,2,252,65,33,0,7,0,22,0,23,0,22,0,39,0,
22,0,55,0,22,0,71,0,22,0,87,0,22,0,103,0,
22,0,119,0,22,0,135,0,22,0,151,0,22,0,167,0,
22,0,183,0,22,0,199,0,22,0,215,0,22,0,231,0,
22,0,247,0,22,0,16,93,65,15,0,7,0,22,0,23,
0,22,0,39,0,22,0,55,0,22,0,71,0,22,0,87,
0,22,0,103,0,22,0,7,113,65,5,0,118,0,22,0,
134,0,22,0,2,113,184,0,60,16,185,0,55,0,2,252,
184,0,60,16,184,0,72,208,184,0,61,16,184,0,73,208,
184,0,55,16,184,0,75,208,184,0,56,16,184,0,76,208,
48,49,5,33,39,62,1,55,33,23,3,17,46,1,35,34,
14,2,21,20,30,2,51,50,62,2,55,5,14,1,35,34,
38,39,14,3,35,34,46,2,53,52,62,4,51,50,22,23,
53,35,39,62,1,55,51,52,46,2,39,53,62,1,55,23,
21,51,23,7,35,17,20,22,23,22,54,55,23,2,252,253,
182,19,5,13,7,2,74,19,147,27,102,61,54,90,65,36,
42,64,76,35,28,56,54,54,26,1,2,78,86,23,29,35,
5,33,63,67,74,43,47,100,83,54,26,49,71,88,105,59,
39,79,46,243,19,5,13,7,237,7,24,48,43,69,109,44,
26,123,19,25,117,10,10,7,44,51,10,220,18,14,45,14,
22,1,120,1,129,49,54,40,79,118,79,72,116,83,44,23,
37,48,26,149,53,45,78,92,39,63,44,23,54,103,149,94,
48,103,97,86,64,38,19,34,171,18,14,45,14,42,49,27,
11,3,33,9,32,14,25,195,22,69,253,53,59,53,12,9,
6,20,35,0,0,1,0,24,255,226,3,157,4,211,0,77,
1,33,187,0,75,0,4,0,32,0,4,43,184,0,75,16,
184,0,1,208,184,0,1,47,184,0,32,16,184,0,26,208,
184,0,26,47,184,0,32,16,184,0,35,208,184,0,35,47,
184,0,75,16,184,0,67,208,184,0,67,47,184,0,75,16,
184,0,71,208,184,0,71,47,0,184,0,0,69,88,184,0,
21,47,27,185,0,21,0,5,62,89,187,0,46,0,2,0,
62,0,4,43,184,0,46,16,187,0,76,0,2,0,0,0,
4,43,184,0,76,16,187,0,41,0,2,0,35,0,4,43,
184,0,41,16,184,0,21,16,185,0,6,0,2,252,65,33,
0,7,0,6,0,23,0,6,0,39,0,6,0,55,0,6,
0,71,0,6,0,87,0,6,0,103,0,6,0,119,0,6,
0,135,0,6,0,151,0,6,0,167,0,6,0,183,0,6,
0,199,0,6,0,215,0,6,0,231,0,6,0,247,0,6,
0,16,93,65,15,0,7,0,6,0,23,0,6,0,39,0,
6,0,55,0,6,0,71,0,6,0,87,0,6,0,103,0,
6,0,7,113,65,5,0,118,0,6,0,134,0,6,0,2,
113,184,0,0,16,184,0,26,208,184,0,76,16,184,0,31,
208,184,0,41,16,184,0,67,208,184,0,35,16,184,0,70,
208,48,49,1,33,30,3,51,50,62,2,55,30,3,23,14,
3,35,34,46,2,39,35,39,62,1,55,51,53,52,55,35,
39,62,1,55,51,62,3,51,50,30,2,23,22,14,2,7,
39,46,3,35,34,14,2,7,33,23,7,33,14,1,29,1,
33,23,2,113,254,185,12,58,81,98,53,31,59,67,80,51,
5,11,10,8,3,60,97,92,93,55,75,133,104,67,10,93,
22,5,11,6,90,6,66,22,5,11,6,78,21,86,123,157,
92,50,78,65,54,26,6,18,31,35,12,35,25,45,52,65,
45,34,76,69,56,13,1,98,25,25,254,150,1,1,1,78,
25,1,210,104,143,89,40,17,39,64,46,2,13,14,13,3,
68,93,56,24,59,122,187,128,25,15,35,16,4,65,60,25,
15,35,16,113,171,116,58,16,27,36,21,5,30,38,38,12,
6,23,39,29,16,30,78,135,105,23,68,21,44,23,41,23,
0,1,0,44,255,242,3,236,4,180,0,60,0,127,187,0,
56,0,4,0,4,0,4,43,184,0,56,16,184,0,4,16,
184,0,11,208,184,0,56,16,184,0,21,208,0,184,0,16,
47,184,0,30,47,184,0,0,69,88,184,0,50,47,27,185,
0,50,0,5,62,89,184,0,0,69,88,184,0,0,47,27,
185,0,0,0,5,62,89,187,0,11,0,2,0,5,0,4,
43,184,0,11,16,184,0,22,208,184,0,11,16,184,0,38,
208,184,0,5,16,184,0,41,208,186,0,42,0,50,0,16,
17,18,57,184,0,5,16,184,0,54,208,48,49,23,53,62,
1,53,17,35,39,62,1,55,51,17,52,38,39,53,33,21,
14,1,21,17,51,1,62,1,46,1,39,53,33,21,14,3,
7,1,33,23,7,33,1,30,1,55,23,14,1,35,34,38,
39,1,35,17,20,22,23,21,50,57,66,107,22,5,11,6,
107,62,61,1,125,57,66,41,1,51,19,11,17,42,34,1,
101,27,42,34,29,13,254,166,1,54,25,25,254,230,1,101,
30,80,44,6,50,100,41,26,37,17,254,115,28,61,62,1,
41,14,31,14,1,221,25,15,35,16,1,180,12,33,14,42,
42,14,31,14,254,76,1,154,26,31,17,8,3,42,42,4,
7,12,20,16,254,76,23,68,254,57,38,13,6,41,18,31,
18,23,2,37,254,35,12,33,14,41,0,1,0,36,0,0,
3,150,4,180,0,68,0,162,187,0,64,0,4,0,4,0,
4,43,184,0,64,16,184,0,4,16,184,0,13,208,184,0,
4,16,184,0,22,208,184,0,64,16,184,0,45,208,184,0,
64,16,184,0,54,208,0,184,0,0,69,88,184,0,29,47,
27,185,0,29,0,9,62,89,184,0,0,69,88,184,0,38,
47,27,185,0,38,0,9,62,89,184,0,0,69,88,184,0,
0,47,27,185,0,0,0,5,62,89,187,0,33,0,2,0,
24,0,4,43,184,0,33,16,186,0,5,0,0,0,38,17,
18,57,186,0,14,0,0,0,38,17,18,57,184,0,24,16,
184,0,44,208,186,0,46,0,0,0,38,17,18,57,186,0,
55,0,0,0,38,17,18,57,48,49,33,53,62,1,53,17,
7,39,62,3,63,1,53,7,39,62,3,63,1,17,35,34,
14,2,7,39,62,1,55,33,23,14,1,7,35,46,3,43,
1,17,55,23,14,3,15,1,21,55,23,14,3,15,1,17,
20,22,23,21,1,20,77,60,171,21,2,2,4,7,8,169,
171,21,2,2,4,7,8,169,241,13,20,21,27,19,36,4,
15,9,3,61,25,2,13,10,38,8,12,16,23,19,229,173,
20,3,3,4,7,7,169,173,20,3,3,4,7,7,169,60,
78,41,18,37,14,1,18,120,15,13,15,17,24,21,117,118,
120,15,13,15,17,24,21,117,1,156,10,35,66,56,18,57,
128,50,23,49,116,60,40,61,41,20,254,194,121,14,17,19,
16,20,17,119,119,121,14,17,19,16,20,17,119,254,143,12,
39,18,41,0,0,5,0,44,254,72,7,11,5,35,0,13,
0,36,0,66,0,114,0,175,3,5,187,0,42,0,4,0,
161,0,4,43,184,0,42,16,187,0,126,0,4,0,61,0,
4,43,184,0,126,16,187,0,81,0,3,0,105,0,4,43,
184,0,81,16,187,0,67,0,4,0,27,0,4,43,184,0,
67,16,184,0,161,16,184,0,3,208,184,0,3,47,65,5,
0,154,0,105,0,170,0,105,0,2,93,65,19,0,9,0,
105,0,25,0,105,0,41,0,105,0,57,0,105,0,73,0,
105,0,89,0,105,0,105,0,105,0,121,0,105,0,137,0,
105,0,9,93,184,0,105,16,185,0,14,0,3,252,184,0,
17,208,184,0,17,47,65,5,0,154,0,27,0,170,0,27,
0,2,93,65,19,0,9,0,27,0,25,0,27,0,41,0,
27,0,57,0,27,0,73,0,27,0,89,0,27,0,105,0,
27,0,121,0,27,0,137,0,27,0,9,93,65,19,0,6,
0,42,0,22,0,42,0,38,0,42,0,54,0,42,0,70,
0,42,0,86,0,42,0,102,0,42,0,118,0,42,0,134,
0,42,0,9,93,65,5,0,149,0,42,0,165,0,42,0,
2,93,65,5,0,154,0,61,0,170,0,61,0,2,93,65,
19,0,9,0,61,0,25,0,61,0,41,0,61,0,57,0,
61,0,73,0,61,0,89,0,61,0,105,0,61,0,121,0,
61,0,137,0,61,0,9,93,184,0,81,16,184,0,79,208,
184,0,79,47,184,0,81,16,184,0,83,208,186,0,118,0,
3,0,67,17,18,57,186,0,141,0,161,0,42,17,18,57,
184,0,161,16,184,0,157,208,184,0,157,47,184,0,161,16,
184,0,159,208,184,0,159,47,186,0,164,0,161,0,42,17,
18,57,184,0,67,16,184,0,177,220,0,184,0,95,47,184,
0,0,69,88,184,0,175,47,27,185,0,175,0,11,62,89,
184,0,0,69,88,184,0,74,47,27,185,0,74,0,5,62,
89,184,0,0,69,88,184,0,133,47,27,185,0,133,0,5,
62,89,184,0,0,69,88,184,0,136,47,27,185,0,136,0,
5,62,89,184,0,0,69,88,184,0,144,47,27,185,0,144,
0,5,62,89,187,0,121,0,2,0,66,0,4,43,184,0,
121,16,187,0,110,0,2,0,32,0,4,43,184,0,110,16,
184,0,133,16,185,0,52,0,2,252,65,33,0,7,0,52,
0,23,0,52,0,39,0,52,0,55,0,52,0,71,0,52,
0,87,0,52,0,103,0,52,0,119,0,52,0,135,0,52,
0,151,0,52,0,167,0,52,0,183,0,52,0,199,0,52,
0,215,0,52,0,231,0,52,0,247,0,52,0,16,93,65,
15,0,7,0,52,0,23,0,52,0,39,0,52,0,55,0,
52,0,71,0,52,0,87,0,52,0,103,0,52,0,7,113,
65,5,0,118,0,52,0,134,0,52,0,2,113,184,0,54,
208,184,0,144,16,184,0,154,220,65,27,0,7,0,154,0,
23,0,154,0,39,0,154,0,55,0,154,0,71,0,154,0,
87,0,154,0,103,0,154,0,119,0,154,0,135,0,154,0,
151,0,154,0,167,0,154,0,183,0,154,0,199,0,154,0,
13,93,65,5,0,214,0,154,0,230,0,154,0,2,93,186,
0,79,0,144,0,154,17,18,57,184,0,121,16,184,0,118,
208,184,0,118,47,186,0,141,0,144,0,154,17,18,57,186,
0,157,0,144,0,154,17,18,57,186,0,164,0,95,0,175,
17,18,57,186,0,167,0,95,0,175,17,18,57,48,49,55,
50,54,55,46,1,35,34,6,7,6,30,2,1,14,1,7,
30,3,51,50,62,2,55,54,46,2,35,34,14,2,1,14,
2,22,23,22,14,2,7,30,3,51,54,51,50,62,4,39,
46,3,35,1,14,5,35,34,46,2,39,6,21,20,21,6,
30,4,23,14,3,7,46,1,39,62,5,55,62,3,51,50,
30,2,1,14,1,7,50,54,51,50,30,2,23,22,14,4,
35,34,38,39,46,3,39,14,1,35,34,46,2,55,62,3,
51,50,22,23,54,53,52,39,38,54,55,14,1,7,39,62,
3,55,54,55,227,32,39,11,19,39,20,47,41,2,1,14,
24,32,4,44,1,2,2,47,81,68,54,20,16,45,43,31,
3,5,26,55,81,50,26,66,60,42,252,248,21,23,9,1,
2,1,2,8,14,11,30,57,56,57,31,3,8,44,75,59,
44,26,8,5,9,59,101,140,90,5,8,2,24,40,56,66,
76,40,17,48,62,77,45,1,1,1,5,7,9,9,5,17,
38,40,38,16,8,7,8,3,9,11,12,10,7,2,6,66,
99,125,65,77,106,66,28,251,138,34,53,21,8,13,7,105,
168,121,73,10,7,12,39,66,95,126,78,7,11,5,32,59,
57,55,28,28,92,70,31,59,45,26,2,1,22,45,68,48,
23,44,20,4,5,5,33,57,63,133,71,5,34,79,84,84,
41,63,100,64,58,72,10,11,32,28,21,33,24,13,1,103,
23,65,31,73,80,38,8,22,55,92,69,91,150,107,59,20,
67,130,2,50,42,89,106,130,82,56,113,111,105,47,23,48,
41,26,1,52,88,117,131,136,63,96,159,114,62,253,84,48,
103,97,87,65,38,26,58,93,68,12,14,14,17,45,103,105,
101,83,59,12,10,24,24,24,11,4,9,8,30,120,153,171,
161,137,42,117,172,113,55,78,126,158,3,25,31,56,26,1,
70,128,182,111,79,166,158,140,104,62,2,2,5,32,45,51,
24,72,87,28,47,63,35,29,53,40,23,9,8,68,93,94,
127,114,212,100,13,45,26,57,16,30,27,21,8,83,75,0,
0,3,0,37,0,0,3,156,4,211,0,8,0,17,0,89,
1,114,184,0,90,47,184,0,91,47,184,0,23,220,185,0,
0,0,4,252,65,5,0,154,0,0,0,170,0,0,0,2,
93,65,19,0,9,0,0,0,25,0,0,0,41,0,0,0,
57,0,0,0,73,0,0,0,89,0,0,0,105,0,0,0,
121,0,0,0,137,0,0,0,9,93,184,0,3,208,184,0,
3,47,184,0,90,16,184,0,60,208,184,0,60,47,185,0,
49,0,4,252,184,0,4,208,184,0,0,16,184,0,6,208,
184,0,6,47,184,0,49,16,184,0,13,208,186,0,15,0,
60,0,23,17,18,57,184,0,23,16,184,0,19,208,184,0,
19,47,184,0,23,16,184,0,21,208,184,0,23,16,184,0,
26,208,184,0,26,47,186,0,39,0,60,0,23,17,18,57,
186,0,47,0,60,0,23,17,18,57,184,0,60,16,184,0,
67,208,184,0,60,16,184,0,74,208,0,184,0,0,69,88,
184,0,55,47,27,185,0,55,0,5,62,89,187,0,82,0,
2,0,9,0,4,43,184,0,82,16,187,0,15,0,2,0,
3,0,4,43,184,0,15,16,187,0,27,0,2,0,29,0,
4,43,184,0,27,16,187,0,42,0,2,0,35,0,4,43,
184,0,42,16,184,0,27,16,184,0,5,208,184,0,9,16,
184,0,11,208,184,0,9,16,184,0,13,208,184,0,13,47,
184,0,3,16,184,0,18,208,184,0,29,16,184,0,47,208,
184,0,29,16,184,0,61,208,184,0,27,16,184,0,66,208,
184,0,3,16,184,0,68,208,184,0,15,16,184,0,73,208,
184,0,82,16,185,0,78,0,2,252,184,0,15,16,184,0,
87,208,48,49,1,52,38,39,33,21,33,52,54,1,34,35,
34,7,21,33,46,1,5,35,22,21,20,21,20,6,7,51,
23,7,35,14,3,35,34,38,47,1,30,1,51,50,62,2,
55,33,17,20,30,2,23,21,33,53,62,1,53,17,35,39,
62,1,55,51,53,35,39,62,1,55,51,53,14,1,7,39,
62,1,51,50,30,2,23,51,23,2,172,2,2,254,155,1,
104,1,254,209,15,15,14,14,1,73,38,145,1,174,76,1,
3,2,80,25,25,104,23,74,85,88,37,33,51,30,21,38,
46,24,28,59,54,45,15,254,173,14,35,61,47,254,81,61,
69,120,22,5,11,6,120,120,22,5,11,6,120,32,64,34,
8,87,202,102,69,122,97,70,18,91,25,3,88,16,30,14,
89,7,14,1,51,1,147,77,71,239,5,5,5,5,18,34,
17,23,68,58,85,55,27,14,14,73,18,10,19,38,57,38,
253,132,6,14,15,16,8,41,41,14,32,13,2,124,25,15,
35,16,89,25,15,35,16,133,5,11,6,60,25,32,30,57,
86,55,23,0,0,1,0,61,1,250,3,10,2,106,0,10,
0,17,0,187,0,9,0,2,0,3,0,4,43,184,0,9,
16,48,49,1,14,1,7,33,39,62,1,55,33,23,3,10,
5,17,8,253,106,25,5,17,9,2,150,24,2,82,20,51,
17,24,20,48,20,24,0,1,0,50,2,72,0,250,3,48,
0,14,0,0,19,20,14,2,35,34,38,53,52,62,2,51,
50,250,18,31,42,25,45,39,18,32,41,24,85,2,209,28,
50,37,22,50,46,28,50,37,21,0,0,1,255,16,254,12,
1,79,3,192,0,42,0,172,187,0,0,0,4,0,28,0,
4,43,184,0,41,208,0,184,0,0,69,88,184,0,40,47,
27,185,0,40,0,9,62,89,184,0,0,69,88,184,0,10,
47,27,185,0,10,0,7,62,89,185,0,23,0,2,252,65,
33,0,7,0,23,0,23,0,23,0,39,0,23,0,55,0,
23,0,71,0,23,0,87,0,23,0,103,0,23,0,119,0,
23,0,135,0,23,0,151,0,23,0,167,0,23,0,183,0,
23,0,199,0,23,0,215,0,23,0,231,0,23,0,247,0,
23,0,16,93,65,15,0,7,0,23,0,23,0,23,0,39,
0,23,0,55,0,23,0,71,0,23,0,87,0,23,0,103,
0,23,0,7,113,65,5,0,118,0,23,0,134,0,23,0,
2,113,48,49,37,20,14,2,7,14,3,35,34,46,2,53,
52,62,2,55,30,1,51,50,62,2,53,17,52,46,2,39,
53,62,3,55,51,17,1,79,29,51,70,40,27,60,60,53,
19,31,59,47,29,29,40,43,15,32,68,38,29,57,46,28,
5,26,57,52,42,65,59,55,32,37,99,115,161,113,78,32,
21,37,27,15,15,22,24,8,9,31,34,30,7,28,17,37,
92,158,121,2,115,51,62,35,16,6,40,7,18,19,23,13,
252,163,0,2,252,193,4,23,255,192,6,98,0,12,0,21,
0,11,0,184,0,8,47,184,0,10,47,48,49,3,1,35,
1,30,3,23,9,1,62,1,3,19,54,22,31,1,7,34,
38,198,254,250,107,254,248,7,10,9,11,8,1,15,1,18,
17,14,89,110,23,50,26,26,190,13,19,4,68,1,123,254,
133,9,14,10,8,4,1,12,254,244,8,18,1,40,1,7,
2,6,4,40,234,11,0,2,252,58,4,23,255,58,6,98,
0,9,0,23,0,11,0,184,0,13,47,184,0,15,47,48,
49,1,14,1,7,39,55,62,1,51,19,1,14,1,7,9,
1,46,3,39,1,51,1,253,51,12,19,14,204,25,26,46,
26,126,2,7,12,14,17,254,238,254,241,8,11,9,10,7,
1,8,107,1,6,5,90,8,9,3,234,41,5,4,254,248,
254,234,19,18,8,1,12,254,244,4,8,10,14,9,1,123,
254,133,0,2,252,193,4,23,255,132,6,130,0,40,0,54,
0,11,0,184,0,44,47,184,0,46,47,48,49,3,20,14,
3,22,23,14,1,7,46,1,62,3,53,52,38,35,34,6,
21,20,22,23,14,3,7,39,53,52,62,2,51,50,22,3,
14,1,7,9,1,46,3,39,1,51,1,124,28,38,37,18,
10,29,11,25,12,47,30,10,38,42,33,30,23,23,30,5,
2,6,22,25,24,8,10,30,48,60,30,54,56,74,12,14,
17,254,238,254,241,8,11,9,10,7,1,8,107,1,6,6,
36,21,35,32,30,33,37,22,8,2,2,23,39,34,32,32,
33,19,33,26,29,20,4,7,5,2,7,6,4,1,11,10,
20,39,31,19,52,253,246,19,18,8,1,12,254,244,4,8,
10,14,9,1,123,254,133,0,0,2,252,168,4,23,255,82,
6,243,0,28,0,42,0,11,0,184,0,32,47,184,0,34,
47,48,49,3,14,3,35,34,46,2,35,34,6,7,39,62,
3,51,50,30,2,51,50,54,55,23,3,14,1,7,9,1,
46,3,39,1,51,1,174,18,50,61,72,39,35,63,60,59,
29,40,66,37,53,18,49,62,71,39,38,68,60,54,24,38,
73,34,54,24,12,14,17,254,238,254,241,8,11,9,10,7,
1,8,107,1,6,6,220,41,80,64,40,35,43,35,65,56,
20,41,81,64,40,35,43,35,64,59,23,253,104,19,18,8,
1,12,254,244,4,8,10,14,9,1,123,254,133,0,0,2,
252,184,4,46,255,66,6,129,0,25,0,34,0,25,0,184,
0,3,47,184,0,13,47,187,0,8,0,2,0,21,0,4,
43,184,0,8,16,48,49,3,46,1,39,14,3,35,34,46,
2,39,14,1,7,30,3,51,50,62,2,37,19,54,22,31,
1,3,6,38,190,12,24,17,24,65,73,77,35,33,75,72,
65,25,17,24,12,30,73,83,92,49,45,90,83,75,254,167,
126,23,50,26,26,205,13,20,5,80,18,19,8,57,78,47,
21,21,47,78,57,8,19,18,81,110,69,30,30,69,110,90,
1,38,2,5,3,40,254,245,1,12,0,2,252,184,4,46,
255,66,6,127,0,9,0,35,0,25,0,184,0,23,47,184,
0,33,47,187,0,28,0,2,0,15,0,4,43,184,0,28,
16,48,49,1,14,1,7,3,55,62,1,51,19,5,14,3,
35,34,46,2,39,62,1,55,30,3,51,50,62,2,55,30,
1,254,46,12,19,14,226,25,26,46,26,148,1,20,30,75,
83,90,45,49,92,83,73,30,12,24,17,25,65,72,75,33,
35,77,73,65,24,17,24,5,90,8,10,2,1,6,41,5,
5,254,219,10,81,110,69,30,30,69,110,81,18,19,8,57,
78,47,21,21,47,78,57,8,19,0,0,2,252,184,4,46,
255,66,6,130,0,40,0,66,0,25,0,184,0,54,47,184,
0,64,47,187,0,59,0,2,0,46,0,4,43,184,0,59,
16,48,49,1,20,14,3,22,23,14,1,7,46,1,62,3,
53,52,38,35,34,6,21,20,22,23,14,3,7,39,53,52,
62,2,51,50,22,23,14,3,35,34,46,2,39,62,1,55,
30,3,51,50,62,2,55,30,1,254,138,28,38,37,18,10,
29,11,25,12,47,30,10,38,42,33,30,23,23,30,5,2,
6,22,25,24,8,10,30,48,60,30,54,56,184,30,75,83,
90,45,49,92,83,73,30,12,24,17,25,65,72,75,33,35,
77,73,65,24,17,24,6,36,21,35,32,30,33,37,22,8,
2,2,23,39,34,32,32,33,19,33,26,29,20,4,7,5,
2,7,6,4,1,11,10,20,39,31,19,52,254,81,110,69,
30,30,69,110,81,18,19,8,57,78,47,21,21,47,78,57,
8,19,0,2,252,178,4,46,255,92,6,203,0,28,0,54,
0,25,0,184,0,42,47,184,0,52,47,187,0,47,0,2,
0,34,0,4,43,184,0,47,16,48,49,3,14,3,35,34,
46,2,35,34,6,7,39,62,3,51,50,30,2,51,50,54,
55,23,3,14,3,35,34,46,2,39,62,1,55,30,3,51,
50,62,2,55,30,1,164,18,50,61,72,39,35,63,60,59,
29,40,66,37,53,18,49,62,71,39,38,68,60,54,24,38,
73,34,54,26,30,75,83,90,45,49,92,83,73,30,12,24,
17,25,65,72,75,33,35,77,73,65,24,17,24,6,180,41,
80,64,40,35,43,35,65,56,20,41,81,64,40,35,43,35,
64,59,23,254,156,81,110,69,30,30,69,110,81,18,19,8,
57,78,47,21,21,47,78,57,8,19,255,255,0,45,0,0,
5,174,6,14,0,38,0,70,0,0,0,7,0,70,2,125,
0,0,255,255,0,45,0,0,6,238,6,14,0,38,0,70,
0,0,0,39,0,70,2,125,0,0,0,7,0,73,4,250,
0,0,255,255,0,45,0,0,6,248,6,14,0,38,0,70,
0,0,0,39,0,70,2,125,0,0,0,7,0,76,4,250,
0,0,0,1,0,70,4,23,2,72,5,129,0,11,0,11,
0,184,0,3,47,184,0,10,47,48,49,1,14,1,7,37,
55,62,3,55,1,2,72,14,15,16,254,43,8,7,31,36,
34,11,1,131,4,68,19,19,7,243,45,8,20,21,19,6,
254,195,0,2,0,70,0,0,1,244,5,36,0,14,0,37,
0,121,187,0,0,0,4,0,8,0,4,43,65,5,0,154,
0,8,0,170,0,8,0,2,93,65,19,0,9,0,8,0,
25,0,8,0,41,0,8,0,57,0,8,0,73,0,8,0,
89,0,8,0,105,0,8,0,121,0,8,0,137,0,8,0,
9,93,186,0,19,0,8,0,0,17,18,57,184,0,19,47,
185,0,33,0,4,252,0,184,0,0,69,88,184,0,31,47,
27,185,0,31,0,9,62,89,184,0,0,69,88,184,0,15,
47,27,185,0,15,0,5,62,89,48,49,1,20,14,2,35,
34,38,53,52,62,2,51,50,1,53,62,1,53,17,52,46,
2,39,53,62,3,55,51,17,20,22,23,21,1,134,18,31,
42,25,45,39,18,32,41,24,85,254,192,68,72,4,26,57,
53,31,69,68,62,26,34,67,73,4,197,28,50,37,22,50,
46,28,50,37,21,250,220,43,14,33,14,2,54,51,63,35,
16,5,40,6,17,21,24,12,252,168,12,35,14,43,0,2,
255,16,254,12,1,109,5,36,0,14,0,57,0,246,187,0,
0,0,4,0,8,0,4,43,65,5,0,154,0,8,0,170,
0,8,0,2,93,65,19,0,9,0,8,0,25,0,8,0,
41,0,8,0,57,0,8,0,73,0,8,0,89,0,8,0,
105,0,8,0,121,0,8,0,137,0,8,0,9,93,186,0,
43,0,8,0,0,17,18,57,184,0,43,47,185,0,15,0,
4,252,184,0,56,208,0,184,0,0,69,88,184,0,55,47,
27,185,0,55,0,9,62,89,184,0,0,69,88,184,0,25,
47,27,185,0,25,0,7,62,89,185,0,38,0,2,252,65,
33,0,7,0,38,0,23,0,38,0,39,0,38,0,55,0,
38,0,71,0,38,0,87,0,38,0,103,0,38,0,119,0,
38,0,135,0,38,0,151,0,38,0,167,0,38,0,183,0,
38,0,199,0,38,0,215,0,38,0,231,0,38,0,247,0,
38,0,16,93,65,15,0,7,0,38,0,23,0,38,0,39,
0,38,0,55,0,38,0,71,0,38,0,87,0,38,0,103,
0,38,0,7,113,65,5,0,118,0,38,0,134,0,38,0,
2,113,48,49,1,20,14,2,35,34,38,53,52,62,2,51,
50,3,20,14,2,7,14,3,35,34,46,2,53,52,62,2,
55,30,1,51,50,62,2,53,17,52,46,2,39,53,62,3,
55,51,17,1,109,18,31,42,24,45,39,18,31,42,24,84,
30,29,51,70,40,27,60,60,53,19,31,59,47,29,29,40,
43,15,32,68,38,29,57,46,28,5,26,57,52,42,65,59,
55,32,37,4,197,28,50,37,22,50,46,28,50,37,21,251,
63,115,161,113,78,32,21,37,27,15,15,22,24,8,9,31,
34,30,7,28,17,37,92,158,121,2,115,51,62,35,16,6,
40,7,18,19,23,13,252,163,0,2,0,100,4,60,2,188,
5,36,0,14,0,29,1,7,184,0,30,47,184,0,31,47,
184,0,0,220,185,0,8,0,4,252,65,5,0,154,0,8,
0,170,0,8,0,2,93,65,19,0,9,0,8,0,25,0,
8,0,41,0,8,0,57,0,8,0,73,0,8,0,89,0,
8,0,105,0,8,0,121,0,8,0,137,0,8,0,9,93,
184,0,30,16,184,0,23,208,184,0,23,47,185,0,15,0,
4,252,65,19,0,6,0,15,0,22,0,15,0,38,0,15,
0,54,0,15,0,70,0,15,0,86,0,15,0,102,0,15,
0,118,0,15,0,134,0,15,0,9,93,65,5,0,149,0,
15,0,165,0,15,0,2,93,0,184,0,0,69,88,184,0,
13,47,27,185,0,13,0,11,62,89,184,0,0,69,88,184,
0,28,47,27,185,0,28,0,11,62,89,184,0,13,16,184,
0,5,220,65,5,0,217,0,5,0,233,0,5,0,2,93,
65,27,0,8,0,5,0,24,0,5,0,40,0,5,0,56,
0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,120,
0,5,0,136,0,5,0,152,0,5,0,168,0,5,0,184,
0,5,0,200,0,5,0,13,93,184,0,20,208,48,49,1,
20,14,2,35,34,38,53,52,62,2,51,50,5,20,14,2,
35,34,38,53,52,62,2,51,50,2,188,18,31,42,25,45,
39,18,32,41,24,85,254,112,18,31,42,25,45,39,18,32,
41,24,85,4,197,28,50,37,22,50,46,28,50,37,21,95,
28,50,37,22,50,46,28,50,37,21,0,1,0,167,4,111,
3,75,4,241,0,14,0,0,1,14,3,7,33,39,62,3,
55,33,23,3,75,2,10,12,11,4,253,153,22,2,10,12,
12,5,2,101,22,4,217,11,29,29,28,9,25,11,28,29,
27,10,24,0,0,1,0,70,4,23,2,72,5,129,0,10,
0,11,0,184,0,0,47,184,0,4,47,48,49,19,46,1,
39,1,30,3,31,1,115,17,15,13,1,131,10,34,36,30,
8,9,4,23,7,19,19,1,61,6,19,21,20,8,45,0,
0,2,0,47,0,0,2,10,5,25,0,14,0,49,1,2,
187,0,0,0,4,0,8,0,4,43,65,5,0,154,0,8,
0,170,0,8,0,2,93,65,19,0,9,0,8,0,25,0,
8,0,41,0,8,0,57,0,8,0,73,0,8,0,89,0,
8,0,105,0,8,0,121,0,8,0,137,0,8,0,9,93,
186,0,19,0,8,0,0,17,18,57,184,0,19,47,184,0,
26,208,184,0,19,16,185,0,45,0,4,252,184,0,39,208,
0,184,0,0,69,88,184,0,38,47,27,185,0,38,0,9,
62,89,184,0,0,69,88,184,0,13,47,27,185,0,13,0,
11,62,89,184,0,0,69,88,184,0,15,47,27,185,0,15,
0,5,62,89,187,0,26,0,2,0,20,0,4,43,184,0,
26,16,184,0,13,16,184,0,5,220,65,5,0,217,0,5,
0,233,0,5,0,2,93,65,27,0,8,0,5,0,24,0,
5,0,40,0,5,0,56,0,5,0,72,0,5,0,88,0,
5,0,104,0,5,0,120,0,5,0,136,0,5,0,152,0,
5,0,168,0,5,0,184,0,5,0,200,0,5,0,13,93,
184,0,26,16,184,0,40,208,184,0,20,16,184,0,43,208,
48,49,1,20,14,2,35,34,38,53,52,62,2,51,50,1,
53,62,1,53,17,35,39,62,1,55,51,53,52,46,2,39,
53,62,3,55,51,17,51,23,7,35,17,20,22,23,21,1,
134,18,31,42,25,45,39,18,32,41,24,85,254,192,68,72,
140,23,5,10,8,140,4,26,57,53,31,69,68,62,26,34,
140,22,22,140,67,73,4,186,28,50,37,22,50,46,28,50,
37,21,250,231,43,14,33,14,1,55,22,16,36,16,165,51,
63,35,16,5,40,6,17,21,24,12,254,57,25,65,254,201,
12,35,14,43,0,3,254,236,254,2,1,219,5,25,0,14,
0,27,0,73,1,188,187,0,0,0,4,0,8,0,4,43,
187,0,23,0,4,0,49,0,4,43,184,0,23,16,65,5,
0,154,0,8,0,170,0,8,0,2,93,65,19,0,9,0,
8,0,25,0,8,0,41,0,8,0,57,0,8,0,73,0,
8,0,89,0,8,0,105,0,8,0,121,0,8,0,137,0,
8,0,9,93,65,19,0,6,0,23,0,22,0,23,0,38,
0,23,0,54,0,23,0,70,0,23,0,86,0,23,0,102,
0,23,0,118,0,23,0,134,0,23,0,9,93,65,5,0,
149,0,23,0,165,0,23,0,2,93,186,0,59,0,8,0,
0,17,18,57,184,0,59,47,185,0,28,0,4,252,184,0,
8,16,184,0,57,208,184,0,57,47,184,0,28,16,184,0,
72,208,0,184,0,35,47,184,0,44,47,184,0,0,69,88,
184,0,71,47,27,185,0,71,0,9,62,89,184,0,0,69,
88,184,0,13,47,27,185,0,13,0,11,62,89,187,0,54,
0,2,0,20,0,4,43,184,0,54,16,184,0,13,16,184,
0,5,220,65,5,0,217,0,5,0,233,0,5,0,2,93,
65,27,0,8,0,5,0,24,0,5,0,40,0,5,0,56,
0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,120,
0,5,0,136,0,5,0,152,0,5,0,168,0,5,0,184,
0,5,0,200,0,5,0,13,93,184,0,44,16,185,0,15,
0,2,252,65,33,0,7,0,15,0,23,0,15,0,39,0,
15,0,55,0,15,0,71,0,15,0,87,0,15,0,103,0,
15,0,119,0,15,0,135,0,15,0,151,0,15,0,167,0,
15,0,183,0,15,0,199,0,15,0,215,0,15,0,231,0,
15,0,247,0,15,0,16,93,65,15,0,7,0,15,0,23,
0,15,0,39,0,15,0,55,0,15,0,71,0,15,0,87,
0,15,0,103,0,15,0,7,113,65,5,0,118,0,15,0,
134,0,15,0,2,113,186,0,57,0,20,0,54,17,18,57,
48,49,1,20,14,2,35,34,38,53,52,62,2,51,50,1,
50,54,55,38,35,34,6,21,20,30,2,1,20,6,7,30,
1,23,7,46,1,39,14,1,7,14,1,35,34,46,2,53,
52,62,2,51,50,22,23,54,53,17,52,46,2,39,53,62,
3,55,51,17,1,109,18,31,42,24,45,39,18,31,42,24,
84,254,138,59,82,23,76,86,63,76,28,41,48,1,108,30,
24,48,96,50,46,56,90,40,16,33,17,51,113,69,38,78,
64,40,31,67,104,72,47,86,42,12,5,26,57,52,42,65,
59,55,32,37,4,186,28,50,37,22,50,46,28,50,37,21,
249,112,61,77,50,53,40,24,36,23,12,1,218,115,161,57,
45,116,69,46,65,100,38,25,40,18,54,56,26,50,72,46,
27,70,63,44,25,25,79,116,2,115,51,62,35,16,6,40,
7,18,19,23,13,252,163,0,0,1,0,49,4,23,2,170,
5,121,0,13,0,15,0,184,0,3,47,184,0,5,47,184,
0,11,47,48,49,1,14,1,7,37,5,46,3,39,1,51,
1,2,170,12,14,17,254,238,254,241,8,11,9,10,7,1,
8,107,1,6,4,68,19,18,8,208,208,4,8,10,14,9,
1,53,254,203,0,1,0,50,4,47,2,171,5,145,0,12,
0,15,0,184,0,0,47,184,0,7,47,184,0,9,47,48,
49,1,35,1,62,3,55,5,37,30,1,23,1,165,107,254,
248,7,10,9,11,8,1,19,1,14,17,14,12,4,47,1,
51,10,14,10,8,5,211,211,9,18,20,0,255,255,0,70,
4,23,2,72,5,129,2,6,5,116,0,0,255,255,0,70,
4,23,2,72,5,129,2,6,5,111,0,0,0,1,0,100,
4,60,1,44,5,36,0,14,0,66,187,0,0,0,4,0,
8,0,4,43,65,19,0,6,0,0,0,22,0,0,0,38,
0,0,0,54,0,0,0,70,0,0,0,86,0,0,0,102,
0,0,0,118,0,0,0,134,0,0,0,9,93,65,5,0,
149,0,0,0,165,0,0,0,2,93,48,49,1,20,14,2,
35,34,38,53,52,62,2,51,50,1,44,18,31,42,25,45,
39,18,32,41,24,85,4,197,28,50,37,22,50,46,28,50,
37,21,0,1,0,70,4,49,2,240,5,49,0,28,0,63,
0,184,0,0,69,88,184,0,19,47,27,185,0,19,0,11,
62,89,184,0,0,69,88,184,0,27,47,27,185,0,27,0,
11,62,89,187,0,10,0,2,0,13,0,4,43,184,0,10,
16,184,0,13,16,184,0,5,208,184,0,5,47,48,49,1,
14,3,35,34,46,2,35,34,6,7,39,62,3,51,50,30,
2,51,50,54,55,23,2,240,18,50,61,72,39,35,63,60,
59,29,40,66,37,53,18,49,62,71,39,38,68,60,54,24,
38,73,34,54,5,26,41,80,64,40,35,43,35,65,56,20,
41,81,64,40,35,43,35,64,59,23,0,1,252,254,4,23,
255,0,5,129,0,11,0,11,0,184,0,3,47,184,0,10,
47,48,49,1,14,1,7,37,55,62,3,55,1,255,0,14,
15,16,254,43,8,7,31,36,34,11,1,131,4,68,19,19,
7,243,45,8,20,21,19,6,254,195,0,1,253,48,4,23,
255,50,5,129,0,10,0,11,0,184,0,0,47,184,0,4,
47,48,49,1,46,1,39,1,30,3,31,1,253,93,17,15,
13,1,131,10,34,36,30,8,9,4,23,7,19,19,1,61,
6,19,21,20,8,45,0,1,252,193,4,23,255,58,5,121,
0,13,0,15,0,184,0,11,47,184,0,3,47,184,0,5,
47,48,49,3,14,1,7,37,5,46,3,39,1,51,1,198,
12,14,17,254,238,254,241,8,11,9,10,7,1,8,107,1,
6,4,68,19,18,8,208,208,4,8,10,14,9,1,53,254,
203,0,0,1,252,168,4,49,255,82,5,49,0,28,0,63,
0,184,0,0,69,88,184,0,19,47,27,185,0,19,0,11,
62,89,184,0,0,69,88,184,0,27,47,27,185,0,27,0,
11,62,89,187,0,10,0,2,0,13,0,4,43,184,0,10,
16,184,0,13,16,184,0,5,208,184,0,5,47,48,49,3,
14,3,35,34,46,2,35,34,6,7,39,62,3,51,50,30,
2,51,50,54,55,23,174,18,50,61,72,39,35,63,60,59,
29,40,66,37,53,18,49,62,71,39,38,68,60,54,24,38,
73,34,54,5,26,41,80,64,40,35,43,35,65,56,20,41,
81,64,40,35,43,35,64,59,23,0,0,1,252,171,4,111,
255,79,4,241,0,14,0,0,3,14,3,7,33,39,62,3,
55,33,23,177,2,10,12,11,4,253,153,22,2,10,12,12,
5,2,101,22,4,217,11,29,29,28,9,25,11,28,29,27,
10,24,0,1,253,153,4,60,254,97,5,36,0,14,0,66,
187,0,0,0,4,0,8,0,4,43,65,19,0,6,0,0,
0,22,0,0,0,38,0,0,0,54,0,0,0,70,0,0,
0,86,0,0,0,102,0,0,0,118,0,0,0,134,0,0,
0,9,93,65,5,0,149,0,0,0,165,0,0,0,2,93,
48,49,1,20,14,2,35,34,38,53,52,62,2,51,50,254,
97,18,31,42,25,45,39,18,32,41,24,85,4,197,28,50,
37,22,50,46,28,50,37,21,0,2,252,209,4,60,255,41,
5,36,0,14,0,29,1,7,184,0,30,47,184,0,31,47,
184,0,0,220,185,0,8,0,4,252,65,5,0,154,0,8,
0,170,0,8,0,2,93,65,19,0,9,0,8,0,25,0,
8,0,41,0,8,0,57,0,8,0,73,0,8,0,89,0,
8,0,105,0,8,0,121,0,8,0,137,0,8,0,9,93,
184,0,30,16,184,0,23,208,184,0,23,47,185,0,15,0,
4,252,65,19,0,6,0,15,0,22,0,15,0,38,0,15,
0,54,0,15,0,70,0,15,0,86,0,15,0,102,0,15,
0,118,0,15,0,134,0,15,0,9,93,65,5,0,149,0,
15,0,165,0,15,0,2,93,0,184,0,0,69,88,184,0,
13,47,27,185,0,13,0,11,62,89,184,0,0,69,88,184,
0,28,47,27,185,0,28,0,11,62,89,184,0,13,16,184,
0,5,220,65,5,0,217,0,5,0,233,0,5,0,2,93,
65,27,0,8,0,5,0,24,0,5,0,40,0,5,0,56,
0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,120,
0,5,0,136,0,5,0,152,0,5,0,168,0,5,0,184,
0,5,0,200,0,5,0,13,93,184,0,20,208,48,49,3,
20,14,2,35,34,38,53,52,62,2,51,50,5,20,14,2,
35,34,38,53,52,62,2,51,50,215,18,31,42,25,45,39,
18,32,41,24,85,254,112,18,31,42,25,45,39,18,32,41,
24,85,4,197,28,50,37,22,50,46,28,50,37,21,95,28,
50,37,22,50,46,28,50,37,21,0,0,1,252,193,4,47,
255,58,5,145,0,12,0,15,0,184,0,0,47,184,0,7,
47,184,0,9,47,48,49,1,35,1,62,3,55,5,37,30,
1,23,254,52,107,254,248,7,10,9,11,8,1,19,1,14,
17,14,12,4,47,1,51,10,14,10,8,5,211,211,9,18,
20,0,0,1,251,224,5,0,253,71,6,0,0,11,0,24,
0,184,0,10,47,184,0,0,69,88,184,0,3,47,27,185,
0,3,0,11,62,89,48,49,1,14,1,7,37,55,62,3,
55,23,253,71,14,15,16,254,198,9,7,31,36,33,11,232,
5,45,19,19,7,135,47,8,20,21,19,6,211,0,0,1,
254,190,5,0,0,37,6,0,0,12,0,24,0,184,0,1,
47,184,0,0,69,88,184,0,8,47,27,185,0,8,0,11,
62,89,48,49,1,55,30,3,31,1,5,46,3,254,190,232,
10,34,36,30,8,9,254,198,8,11,9,10,5,45,211,6,
19,21,20,8,47,135,4,8,10,14,255,255,0,80,255,226,
3,158,5,129,2,38,0,65,0,0,0,7,5,125,3,145,
0,0,255,255,0,80,255,226,3,158,5,129,2,38,0,65,
0,0,0,7,5,126,3,255,0,0,255,255,0,80,255,226,
3,158,5,121,2,38,0,65,0,0,0,7,5,127,3,226,
0,0,255,255,0,80,255,226,3,158,5,49,2,38,0,65,
0,0,0,7,5,128,3,227,0,0,255,255,0,80,255,226,
3,158,5,36,2,38,0,65,0,0,0,7,5,131,3,227,
0,0,255,255,0,80,255,226,3,98,5,129,2,38,0,69,
0,0,0,7,5,125,3,175,0,0,255,255,0,80,255,226,
3,98,5,129,2,38,0,69,0,0,0,7,5,126,4,29,
0,0,255,255,0,80,255,226,3,98,5,121,2,38,0,69,
0,0,0,7,5,127,4,0,0,0,255,255,0,80,255,226,
3,98,5,36,2,38,0,69,0,0,0,7,5,131,4,1,
0,0,255,255,255,204,0,0,1,244,5,129,2,38,0,176,
0,0,0,7,5,125,2,206,0,0,255,255,0,70,0,0,
2,110,5,129,2,38,0,176,0,0,0,7,5,126,3,60,
0,0,255,255,255,224,0,0,2,89,5,121,2,38,0,176,
0,0,0,7,5,127,3,31,0,0,255,255,255,241,0,0,
2,73,5,36,2,38,0,176,0,0,0,7,5,131,3,32,
0,0,255,255,0,55,0,0,4,76,5,49,2,38,0,78,
0,0,0,7,5,128,4,68,0,0,255,255,0,80,255,226,
3,182,5,129,2,38,0,79,0,0,0,7,5,125,3,200,
0,0,255,255,0,80,255,226,3,182,5,129,2,38,0,79,
0,0,0,7,5,126,4,54,0,0,255,255,0,80,255,226,
3,182,5,121,2,38,0,79,0,0,0,7,5,127,4,25,
0,0,255,255,0,80,255,226,3,182,5,49,2,38,0,79,
0,0,0,7,5,128,4,26,0,0,255,255,0,80,255,226,
3,182,5,36,2,38,0,79,0,0,0,7,5,131,4,26,
0,0,255,255,0,41,255,226,4,45,5,129,2,38,0,85,
0,0,0,7,5,125,3,210,0,0,255,255,0,41,255,226,
4,45,5,129,2,38,0,85,0,0,0,7,5,126,4,64,
0,0,255,255,0,41,255,226,4,45,5,121,2,38,0,85,
0,0,0,7,5,127,4,35,0,0,255,255,0,41,255,226,
4,45,5,36,2,38,0,85,0,0,0,7,5,131,4,36,
0,0,255,255,255,209,254,12,3,221,5,129,2,38,0,89,
0,0,0,7,5,126,4,49,0,0,255,255,255,209,254,12,
3,221,5,36,2,38,0,89,0,0,0,7,5,131,4,21,
0,0,255,255,0,80,255,226,3,158,4,241,2,38,0,65,
0,0,0,7,5,129,3,237,0,0,255,255,0,80,255,226,
3,72,5,129,2,38,0,67,0,0,0,7,5,126,4,9,
0,0,255,255,0,80,255,226,3,72,5,121,2,38,0,67,
0,0,0,7,5,127,3,236,0,0,255,255,0,80,255,226,
3,72,5,36,2,38,0,67,0,0,0,7,5,130,3,237,
0,0,255,255,0,80,255,226,3,72,5,145,2,38,0,67,
0,0,0,7,5,132,3,236,0,0,255,255,0,80,255,226,
3,98,4,241,2,38,0,69,0,0,0,7,5,129,4,11,
0,0,255,255,0,80,255,226,3,98,5,36,2,38,0,69,
0,0,0,7,5,130,4,1,0,0,255,255,0,80,255,226,
3,98,5,145,2,38,0,69,0,0,0,7,5,132,4,0,
0,0,255,255,0,30,254,12,3,221,5,121,2,38,0,71,
0,0,0,7,5,127,3,246,0,0,255,255,0,30,254,12,
3,221,5,36,2,38,0,71,0,0,0,7,5,130,3,247,
0,0,255,255,255,200,0,0,2,114,5,49,2,38,0,176,
0,0,0,7,5,128,3,32,0,0,255,255,255,213,0,0,
2,121,4,241,2,38,0,176,0,0,0,7,5,129,3,42,
0,0,255,255,0,70,254,68,1,244,5,36,2,38,5,112,
0,0,0,7,2,197,3,31,0,0,255,255,0,70,254,12,
3,152,5,36,0,38,5,112,0,0,0,7,5,113,2,43,
0,0,255,255,255,16,254,12,2,64,5,121,2,38,5,99,
0,0,0,7,5,127,3,6,0,0,255,255,0,55,0,0,
4,76,5,129,2,38,0,78,0,0,0,7,5,126,4,96,
0,0,255,255,0,55,0,0,4,76,5,145,2,38,0,78,
0,0,0,7,5,132,4,67,0,0,255,255,0,80,255,226,
3,182,4,241,2,38,0,79,0,0,0,7,5,129,4,36,
0,0,255,255,0,55,0,0,3,19,5,129,2,38,0,82,
0,0,0,7,5,126,3,225,0,0,255,255,0,55,0,0,
3,11,5,145,2,38,0,82,0,0,0,7,5,132,3,196,
0,0,255,255,0,94,255,226,2,222,5,129,2,38,0,83,
0,0,0,7,5,126,3,172,0,0,255,255,0,80,255,226,
2,201,5,121,2,38,0,83,0,0,0,7,5,127,3,143,
0,0,255,255,0,80,255,226,2,201,5,145,2,38,0,83,
0,0,0,7,5,132,3,143,0,0,255,255,0,41,255,226,
4,45,5,49,2,38,0,85,0,0,0,7,5,128,4,36,
0,0,255,255,0,41,255,226,4,45,4,241,2,38,0,85,
0,0,0,7,5,129,4,46,0,0,255,255,0,20,255,226,
5,145,5,121,2,38,0,87,0,0,0,7,5,127,4,240,
0,0,255,255,255,209,254,12,3,221,5,121,2,38,0,89,
0,0,0,7,5,127,4,20,0,0,255,255,0,76,0,0,
3,61,5,129,2,38,0,90,0,0,0,7,5,126,3,255,
0,0,255,255,0,76,0,0,3,61,5,36,2,38,0,90,
0,0,0,7,5,130,3,227,0,0,255,255,0,76,0,0,
3,61,5,145,2,38,0,90,0,0,0,7,5,132,3,226,
0,0,255,255,0,41,0,0,7,251,5,145,0,38,0,36,
0,0,0,39,0,90,4,190,0,0,0,7,5,132,8,160,
0,0,255,255,0,80,255,226,7,102,6,14,0,38,0,68,
0,0,0,39,0,90,4,41,0,0,0,7,5,132,8,11,
0,0,255,255,0,50,254,12,5,60,5,36,0,38,0,44,
0,0,0,7,5,113,3,207,0,0,255,255,0,60,254,12,
3,152,6,14,0,38,0,76,0,0,0,7,5,113,2,43,
0,0,255,255,0,50,254,12,6,158,5,36,0,38,0,46,
0,0,0,7,5,113,5,49,0,0,255,255,0,55,254,12,
5,215,5,36,0,38,0,78,0,0,0,7,5,113,4,106,
0,0,255,255,0,80,255,226,3,158,5,145,2,38,0,65,
0,0,0,7,5,132,3,226,0,0,255,255,255,224,0,0,
2,89,5,145,2,38,0,176,0,0,0,7,5,132,3,31,
0,0,255,255,0,80,255,226,3,182,5,145,2,38,0,79,
0,0,0,7,5,132,4,25,0,0,255,255,0,41,255,226,
4,45,5,145,2,38,0,85,0,0,0,7,5,132,4,35,
0,0,255,255,0,41,255,226,4,45,6,49,2,38,0,85,
0,0,0,39,5,131,4,36,0,0,0,7,5,129,4,46,
1,64,255,255,0,41,255,226,4,45,6,193,2,38,0,85,
0,0,0,39,5,131,4,36,0,0,0,7,5,126,4,64,
1,64,255,255,0,41,255,226,4,45,6,209,2,38,0,85,
0,0,0,39,5,131,4,36,0,0,0,7,5,132,4,35,
1,64,255,255,0,41,255,226,4,45,6,193,2,38,0,85,
0,0,0,39,5,131,4,36,0,0,0,7,5,125,3,210,
1,64,255,255,0,80,255,226,3,158,6,49,2,38,0,65,
0,0,0,39,5,131,3,227,0,0,0,7,5,129,3,237,
1,64,255,255,0,80,255,226,3,158,6,49,2,38,0,65,
0,0,0,39,5,130,3,227,0,0,0,7,5,129,3,237,
1,64,255,255,0,80,255,226,5,57,4,241,2,38,0,153,
0,0,0,7,5,129,4,239,0,0,255,255,0,30,254,12,
3,221,5,145,2,38,0,71,0,0,0,7,5,132,3,246,
0,0,255,255,0,80,254,68,3,182,4,241,2,38,0,79,
0,0,0,39,2,197,4,15,0,0,0,7,5,129,4,36,
0,0,255,255,0,38,254,12,3,82,5,145,2,38,2,81,
0,0,0,7,5,132,3,190,0,0,255,255,255,16,254,12,
2,64,5,145,2,38,5,99,0,0,0,7,5,132,3,6,
0,0,255,255,0,30,254,12,3,221,5,129,2,38,0,71,
0,0,0,7,5,126,4,19,0,0,255,255,0,55,0,0,
4,76,5,129,2,38,0,78,0,0,0,7,5,125,3,242,
0,0,255,255,0,80,255,226,5,57,5,129,2,38,0,153,
0,0,0,7,5,126,5,1,0,0,255,255,0,80,255,203,
3,182,5,129,2,38,0,170,0,0,0,7,5,126,4,44,
0,0,255,255,0,80,255,226,3,158,5,36,2,38,0,65,
0,0,0,7,5,130,3,227,0,0,255,255,0,80,255,226,
3,182,6,49,2,38,0,79,0,0,0,39,5,131,4,26,
0,0,0,7,5,129,4,36,1,64,255,255,0,80,255,226,
3,182,6,49,2,38,0,79,0,0,0,39,5,128,4,26,
0,0,0,7,5,129,4,36,1,64,255,255,0,80,255,226,
3,182,5,36,2,38,0,79,0,0,0,7,5,130,4,26,
0,0,255,255,0,80,255,226,3,182,6,49,2,38,0,79,
0,0,0,39,5,130,4,26,0,0,0,7,5,129,4,36,
1,64,255,255,255,209,254,12,3,221,4,241,2,38,0,89,
0,0,0,7,5,129,4,31,0,0,255,255,0,10,255,226,
3,181,6,14,2,38,0,66,0,0,0,7,5,130,4,81,
0,0,255,255,0,80,254,68,3,72,5,129,2,38,0,67,
0,0,0,39,2,196,3,235,0,0,0,7,5,126,4,9,
0,0,255,255,0,80,255,226,4,27,6,14,2,38,0,68,
0,0,0,7,5,130,3,82,0,0,255,255,0,80,255,226,
3,98,6,193,2,38,0,69,0,0,0,39,5,129,4,11,
0,0,0,7,5,125,3,175,1,64,255,255,0,80,255,226,
3,98,6,193,2,38,0,69,0,0,0,39,5,129,4,11,
0,0,0,7,5,126,4,29,1,64,255,255,0,30,254,12,
3,221,4,241,2,38,0,71,0,0,0,7,5,129,4,1,
0,0,255,255,255,200,254,85,2,114,5,36,2,38,5,112,
0,0,0,7,2,205,3,32,0,0,255,255,255,241,0,0,
2,110,6,193,2,38,0,176,0,0,0,39,5,131,3,32,
0,0,0,7,5,126,3,60,1,64,255,255,0,55,0,0,
6,80,5,129,2,38,0,77,0,0,0,7,5,126,5,98,
0,0,255,255,0,55,0,0,6,80,5,36,2,38,0,77,
0,0,0,7,5,130,5,70,0,0,255,255,0,55,0,0,
4,76,5,36,2,38,0,78,0,0,0,7,5,130,4,68,
0,0,255,255,0,80,255,226,3,182,6,193,2,38,0,79,
0,0,0,39,5,128,4,26,0,0,0,7,5,126,4,54,
1,64,255,255,0,80,255,226,3,182,6,100,2,38,0,79,
0,0,0,39,5,128,4,26,0,0,0,7,5,131,4,26,
1,64,255,255,0,80,255,226,3,182,6,193,2,38,0,79,
0,0,0,39,5,129,4,36,0,0,0,7,5,125,3,200,
1,64,255,255,0,80,255,226,3,182,6,193,2,38,0,79,
0,0,0,39,5,129,4,36,0,0,0,7,5,126,4,54,
1,64,255,255,0,55,254,32,3,236,5,129,2,38,0,80,
0,0,0,7,5,126,4,48,0,0,255,255,0,55,254,32,
3,236,5,36,2,38,0,80,0,0,0,7,5,130,4,20,
0,0,255,255,0,55,0,0,3,11,5,36,2,38,0,82,
0,0,0,7,5,130,3,197,0,0,255,255,0,55,254,96,
3,30,4,241,2,38,0,82,0,0,0,39,2,192,3,17,
0,0,0,7,5,129,3,207,0,0,255,255,0,94,255,226,
2,188,5,36,2,38,0,83,0,0,0,7,5,130,3,144,
0,0,255,255,0,94,255,226,2,222,6,100,2,38,0,83,
0,0,0,39,5,126,3,172,0,0,0,7,5,130,3,144,
1,64,255,255,0,80,255,226,2,201,6,100,2,38,0,83,
0,0,0,39,5,132,3,143,0,0,0,7,5,130,3,144,
1,64,255,255,0,94,254,96,2,188,5,36,2,38,0,83,
0,0,0,39,2,192,3,144,0,0,0,7,5,130,3,144,
0,0,255,255,0,41,255,226,4,45,6,193,2,38,0,85,
0,0,0,39,5,128,4,36,0,0,0,7,5,126,4,64,
1,64,255,255,0,41,255,226,4,45,6,100,2,38,0,85,
0,0,0,39,5,129,4,46,0,0,0,7,5,131,4,36,
1,64,255,255,0,20,255,226,3,221,5,49,2,38,0,86,
0,0,0,7,5,128,4,27,0,0,255,255,0,20,255,226,
5,145,5,129,2,38,0,87,0,0,0,7,5,125,4,159,
0,0,255,255,0,20,255,226,5,145,5,129,2,38,0,87,
0,0,0,7,5,126,5,13,0,0,255,255,0,20,255,226,
5,145,5,36,2,38,0,87,0,0,0,7,5,131,4,241,
0,0,255,255,0,20,255,226,5,145,5,36,2,38,0,87,
0,0,0,7,5,130,4,241,0,0,255,255,0,20,0,0,
3,248,5,36,2,38,0,88,0,0,0,7,5,130,4,9,
0,0,255,255,0,20,0,0,3,248,5,36,2,38,0,88,
0,0,0,7,5,131,4,9,0,0,255,255,255,209,254,12,
3,221,5,36,2,38,0,89,0,0,0,7,5,130,4,21,
0,0,255,255,0,76,0,0,3,61,5,121,2,38,0,90,
0,0,0,7,5,127,3,226,0,0,255,255,0,80,255,226,
3,213,6,20,2,38,0,65,0,0,0,7,6,73,3,226,
0,0,255,255,255,234,255,226,3,158,6,20,2,38,0,65,
0,0,0,7,6,74,3,226,0,0,255,255,0,80,255,226,
3,158,6,70,2,38,0,65,0,0,0,7,6,75,3,226,
0,0,255,255,0,80,255,226,3,158,6,193,2,38,0,65,
0,0,0,7,6,76,3,226,0,0,255,255,0,80,254,96,
3,158,5,121,2,38,0,65,0,0,0,39,2,192,3,207,
0,0,0,7,5,127,3,226,0,0,255,255,0,80,255,226,
3,158,6,40,2,38,0,65,0,0,0,7,6,77,3,227,
0,0,255,255,0,80,255,226,3,158,6,40,2,38,0,65,
0,0,0,7,6,78,3,227,0,0,255,255,0,80,255,226,
3,158,6,183,2,38,0,65,0,0,0,7,6,79,3,227,
0,0,255,255,0,80,255,226,3,98,5,49,2,38,0,69,
0,0,0,7,5,128,4,1,0,0,255,255,0,80,255,226,
3,243,6,20,2,38,0,69,0,0,0,7,6,73,4,0,
0,0,255,255,0,8,255,226,3,98,6,20,2,38,0,69,
0,0,0,7,6,74,4,0,0,0,255,255,0,80,255,226,
3,132,6,70,2,38,0,69,0,0,0,7,6,75,4,0,
0,0,255,255,0,80,255,226,3,98,6,193,2,38,0,69,
0,0,0,7,6,76,4,0,0,0,255,255,0,80,254,96,
3,98,5,121,2,38,0,69,0,0,0,39,2,192,3,247,
0,0,0,7,5,127,4,0,0,0,255,255,0,70,254,96,
1,244,5,36,2,38,5,112,0,0,0,7,2,192,3,32,
0,0,255,255,0,80,255,226,4,12,6,20,2,38,0,79,
0,0,0,7,6,73,4,25,0,0,255,255,0,33,255,226,
3,182,6,20,2,38,0,79,0,0,0,7,6,74,4,25,
0,0,255,255,0,80,255,226,3,182,6,70,2,38,0,79,
0,0,0,7,6,75,4,25,0,0,255,255,0,80,255,226,
3,182,6,193,2,38,0,79,0,0,0,7,6,76,4,25,
0,0,255,255,0,80,254,96,3,182,5,121,2,38,0,79,
0,0,0,39,2,192,4,26,0,0,0,7,5,127,4,25,
0,0,255,255,0,80,255,226,4,76,5,129,0,38,0,79,
0,0,0,39,2,184,4,6,0,0,0,7,5,126,4,54,
0,0,255,255,0,80,255,226,4,76,5,129,0,38,0,79,
0,0,0,39,2,184,4,6,0,0,0,7,5,125,3,200,
0,0,255,255,0,80,255,226,4,76,5,49,0,38,0,79,
0,0,0,39,2,184,4,6,0,0,0,7,5,128,4,26,
0,0,255,255,0,41,255,226,4,231,5,129,0,38,0,85,
0,0,0,39,2,184,4,161,0,0,0,7,5,126,4,64,
0,0,255,255,0,41,255,226,4,231,5,129,0,38,0,85,
0,0,0,39,2,184,4,161,0,0,0,7,5,125,3,210,
0,0,255,255,0,41,255,226,4,231,5,49,0,38,0,85,
0,0,0,39,2,184,4,161,0,0,0,7,5,128,4,36,
0,0,255,255,255,209,254,12,3,221,5,129,2,38,0,89,
0,0,0,7,5,125,3,195,0,0,255,255,255,209,254,12,
3,221,5,49,2,38,0,89,0,0,0,7,5,128,4,21,
0,0,0,1,252,144,4,69,255,66,5,103,0,21,0,0,
1,62,1,51,50,30,2,23,14,1,7,46,1,35,34,14,
2,7,46,1,252,144,68,177,106,57,94,82,72,34,9,27,
12,72,141,82,43,77,74,70,35,14,26,4,109,117,133,35,
65,92,58,14,21,5,84,74,18,38,60,42,6,21,0,1,
0,36,4,69,2,214,5,103,0,21,0,0,19,62,1,51,
50,30,2,23,14,1,7,46,1,35,34,14,2,7,46,1,
36,68,177,106,57,94,82,72,34,9,27,12,72,141,82,43,
77,74,70,35,14,26,4,109,117,133,35,65,92,58,14,21,
5,84,74,18,38,60,42,6,21,0,0,3,0,66,4,60,
2,244,6,147,0,15,0,30,0,52,1,19,184,0,53,47,
184,0,54,47,184,0,0,220,185,0,8,0,4,252,65,5,
0,154,0,8,0,170,0,8,0,2,93,65,19,0,9,0,
8,0,25,0,8,0,41,0,8,0,57,0,8,0,73,0,
8,0,89,0,8,0,105,0,8,0,121,0,8,0,137,0,
8,0,9,93,184,0,53,16,184,0,24,208,184,0,24,47,
185,0,16,0,4,252,65,19,0,6,0,16,0,22,0,16,
0,38,0,16,0,54,0,16,0,70,0,16,0,86,0,16,
0,102,0,16,0,118,0,16,0,134,0,16,0,9,93,65,
5,0,149,0,16,0,165,0,16,0,2,93,184,0,0,16,
184,0,42,208,184,0,42,47,0,184,0,0,69,88,184,0,
13,47,27,185,0,13,0,11,62,89,184,0,0,69,88,184,
0,29,47,27,185,0,29,0,11,62,89,184,0,13,16,184,
0,5,220,65,5,0,217,0,5,0,233,0,5,0,2,93,
65,27,0,8,0,5,0,24,0,5,0,40,0,5,0,56,
0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,120,
0,5,0,136,0,5,0,152,0,5,0,168,0,5,0,184,
0,5,0,200,0,5,0,13,93,184,0,21,208,48,49,1,
20,14,2,35,34,38,53,52,62,2,51,50,22,5,20,14,
2,35,34,38,53,52,62,2,51,50,39,62,1,51,50,30,
2,23,14,1,7,46,1,35,34,14,2,7,46,1,2,189,
17,31,42,24,45,39,18,31,41,24,44,40,254,111,17,31,
42,25,45,39,18,32,41,24,84,234,68,177,106,57,94,82,
72,34,9,27,12,72,141,82,43,77,74,70,35,14,26,4,
197,28,50,37,22,50,46,28,50,37,21,48,47,28,50,37,
22,50,46,28,50,37,21,117,117,133,35,65,92,58,14,21,
5,84,74,18,38,60,42,6,21,0,0,2,255,88,4,50,
2,10,6,147,0,20,0,42,0,7,0,184,0,3,47,48,
49,1,14,1,7,39,62,3,55,54,38,47,1,62,3,23,
30,1,37,62,1,51,50,30,2,23,14,1,7,46,1,35,
34,14,2,7,46,1,1,71,11,85,81,35,13,27,21,14,
1,2,65,78,9,9,56,66,62,16,51,34,254,9,68,177,
106,57,94,82,72,34,8,27,13,72,141,82,43,77,74,70,
35,14,25,5,3,57,114,38,37,8,27,32,34,17,45,56,
6,43,8,18,14,7,3,25,73,108,117,133,35,65,92,58,
13,22,5,84,74,18,38,60,42,5,21,0,0,2,255,88,
4,50,2,10,6,147,0,24,0,46,0,7,0,184,0,3,
47,48,49,19,30,1,23,55,46,3,39,38,62,2,63,1,
46,3,7,14,3,39,62,1,51,50,30,2,23,14,1,7,
46,1,35,34,14,2,7,46,1,48,11,83,86,36,16,29,
22,16,2,3,7,30,56,45,7,23,57,56,51,17,24,30,
16,3,212,68,177,106,57,94,82,72,34,6,29,13,72,141,
82,43,77,74,70,35,14,26,4,221,59,92,20,36,6,24,
29,31,14,19,40,38,33,12,42,7,11,8,2,3,18,45,
47,47,167,117,133,35,65,92,58,12,23,5,84,74,18,38,
60,42,7,21,255,255,0,80,255,225,4,2,6,147,2,38,
3,29,0,0,0,7,6,30,1,103,0,0,255,255,0,80,
255,225,4,2,6,147,2,38,3,29,0,0,0,7,6,31,
1,103,0,0,255,255,255,88,0,0,5,71,6,68,0,39,
2,254,0,153,0,0,0,6,6,30,0,177,255,255,255,88,
0,0,5,71,6,68,0,39,2,254,0,153,0,0,0,6,
6,31,0,177,255,255,0,55,254,72,3,216,6,147,2,38,
3,35,0,0,0,7,6,30,1,143,0,0,255,255,0,55,
254,72,3,216,6,147,2,38,3,35,0,0,0,7,6,31,
1,143,0,0,255,255,255,88,0,0,6,247,6,68,0,39,
3,4,2,1,0,0,0,6,6,30,0,177,255,255,255,88,
0,0,6,247,6,68,0,39,3,4,2,1,0,0,0,6,
6,31,0,177,255,255,255,193,255,225,2,115,6,147,2,38,
3,37,0,0,0,6,6,30,105,0,255,255,255,193,255,225,
2,115,6,147,2,38,3,37,0,0,0,6,6,31,105,0,
255,255,255,88,0,0,3,245,6,68,0,39,3,6,1,217,
0,0,0,6,6,30,0,177,255,255,255,88,0,0,3,245,
6,68,0,39,3,6,1,217,0,0,0,6,6,31,0,177,
255,255,0,55,255,225,3,191,6,147,2,38,3,48,0,0,
0,7,6,30,1,108,0,0,255,255,0,55,255,225,3,191,
6,147,2,38,3,48,0,0,0,7,6,31,1,108,0,0,
255,255,255,88,0,0,6,181,6,68,0,39,3,17,2,31,
0,0,0,6,6,31,0,177,255,255,0,90,255,225,5,65,
6,147,2,38,3,52,0,0,0,7,6,30,2,45,0,0,
255,255,0,90,255,225,5,65,6,147,2,38,3,52,0,0,
0,7,6,31,2,45,0,0,255,255,255,88,0,0,5,214,
6,68,0,39,3,21,1,62,0,0,0,6,6,30,0,177,
255,255,255,88,0,0,5,214,6,68,0,39,3,21,1,62,
0,0,0,6,6,31,0,177,255,255,0,80,254,32,4,2,
6,147,2,38,3,29,0,0,0,39,6,30,1,103,0,0,
0,7,2,241,3,232,0,0,255,255,0,80,254,32,4,2,
6,147,2,38,3,29,0,0,0,39,6,31,1,103,0,0,
0,7,2,241,3,232,0,0,255,255,255,88,255,225,7,159,
6,68,0,39,2,254,0,153,0,0,0,38,6,30,0,177,
0,7,4,229,5,92,0,0,255,255,255,88,255,225,7,159,
6,68,0,39,2,254,0,153,0,0,0,38,6,31,0,177,
0,7,4,229,5,92,0,0,255,255,0,55,254,32,3,216,
6,147,2,38,3,35,0,0,0,39,6,30,1,143,0,0,
0,7,2,241,3,9,0,0,255,255,0,55,254,32,3,216,
6,147,2,38,3,35,0,0,0,39,6,31,1,143,0,0,
0,7,2,241,3,9,0,0,255,255,255,88,255,225,9,127,
6,68,0,39,3,4,2,1,0,0,0,38,6,30,0,177,
0,7,4,229,7,60,0,0,255,255,255,88,255,225,9,127,
6,68,0,39,3,4,2,1,0,0,0,38,6,31,0,177,
0,7,4,229,7,60,0,0,255,255,0,90,254,32,5,65,
6,147,2,38,3,52,0,0,0,39,6,30,2,45,0,0,
0,7,2,241,4,194,0,0,255,255,0,90,254,32,5,65,
6,147,2,38,3,52,0,0,0,39,6,31,2,45,0,0,
0,7,2,241,4,194,0,0,255,255,255,88,255,225,8,145,
6,68,0,39,3,21,1,62,0,0,0,38,6,30,0,177,
0,7,4,229,6,78,0,0,255,255,255,88,255,225,8,145,
6,68,0,39,3,21,1,62,0,0,0,38,6,31,0,177,
0,7,4,229,6,78,0,0,255,255,0,80,255,225,4,2,
5,128,2,38,3,29,0,0,0,7,6,28,0,150,0,25,
255,255,0,80,254,32,4,2,5,128,2,38,3,29,0,0,
0,39,6,28,0,150,0,25,0,7,2,241,3,232,0,0,
255,255,0,55,254,72,3,216,5,128,2,38,3,35,0,0,
0,7,6,28,0,190,0,25,255,255,0,55,254,32,3,216,
5,128,2,38,3,35,0,0,0,39,6,28,0,190,0,25,
0,7,2,241,3,9,0,0,255,255,255,189,255,225,2,111,
5,128,2,38,3,37,0,0,0,6,6,28,153,25,255,255,
255,219,255,225,2,141,6,147,2,38,3,37,0,0,0,6,
6,29,153,0,255,255,0,55,255,225,3,191,5,128,2,38,
3,48,0,0,0,7,6,28,0,155,0,25,255,255,0,55,
255,225,3,191,6,147,2,38,3,48,0,0,0,7,6,29,
0,155,0,0,255,255,0,90,255,225,5,65,5,128,2,38,
3,52,0,0,0,7,6,28,1,92,0,25,255,255,0,90,
254,32,5,65,5,128,2,38,3,52,0,0,0,39,6,28,
1,92,0,25,0,7,2,241,4,194,0,0,0,2,252,193,
4,23,255,243,6,20,0,12,0,21,0,15,0,184,0,8,
47,184,0,10,47,184,0,1,47,48,49,3,1,35,1,30,
3,23,37,5,62,1,3,55,30,1,31,1,5,46,1,198,
254,250,107,254,248,7,10,9,11,8,1,15,1,18,17,14,
102,202,21,45,22,9,254,248,12,14,4,68,1,53,254,203,
9,14,10,8,4,208,208,8,18,1,26,201,7,24,13,47,
145,5,18,0,0,2,252,8,4,23,255,58,6,20,0,9,
0,23,0,15,0,184,0,13,47,184,0,15,47,184,0,21,
47,48,49,1,14,1,7,37,55,62,1,55,23,1,14,1,
7,37,5,46,3,39,1,51,1,253,61,8,15,12,254,238,
9,22,42,24,212,1,253,12,14,17,254,238,254,241,8,11,
9,10,7,1,8,107,1,6,5,75,11,16,8,145,47,14,
21,9,201,254,249,19,18,8,208,208,4,8,10,14,9,1,
53,254,203,0,0,2,252,193,4,23,255,132,6,70,0,40,
0,54,0,25,0,184,0,44,47,184,0,46,47,184,0,52,
47,186,0,7,0,44,0,52,17,18,57,48,49,3,20,14,
3,22,23,14,1,7,46,1,62,3,53,52,38,35,34,6,
21,20,22,23,14,3,7,39,53,52,62,2,51,50,22,3,
14,1,7,37,5,46,3,39,1,51,1,124,28,38,37,18,
10,29,11,25,12,47,30,10,38,42,33,30,23,23,30,5,
2,6,22,25,24,8,10,30,48,60,30,54,56,74,12,14,
17,254,238,254,241,8,11,9,10,7,1,8,107,1,6,5,
232,21,35,32,30,33,37,22,8,2,2,23,39,34,32,32,
33,19,33,26,29,20,4,7,5,2,7,6,4,1,11,10,
20,39,31,19,52,254,50,19,18,8,208,208,4,8,10,14,
9,1,53,254,203,0,0,2,252,168,4,23,255,82,6,193,
0,28,0,42,0,15,0,184,0,32,47,184,0,34,47,184,
0,40,47,48,49,3,14,3,35,34,46,2,35,34,6,7,
39,62,3,51,50,30,2,51,50,54,55,23,3,14,1,7,
37,5,46,3,39,1,51,1,174,18,50,61,72,39,35,63,
60,59,29,40,66,37,53,18,49,62,71,39,38,68,60,54,
24,38,73,34,54,24,12,14,17,254,238,254,241,8,11,9,
10,7,1,8,107,1,6,6,170,41,80,64,40,35,43,35,
65,56,20,41,81,64,40,35,43,35,64,59,23,253,154,19,
18,8,208,208,4,8,10,14,9,1,53,254,203,0,0,2,
252,184,4,46,255,66,6,40,0,25,0,34,0,25,0,184,
0,3,47,184,0,13,47,187,0,8,0,2,0,21,0,4,
43,184,0,8,16,48,49,3,46,1,39,14,3,35,34,46,
2,39,14,1,7,30,3,51,50,62,2,37,55,30,1,31,
1,5,46,1,190,12,24,17,24,65,73,77,35,33,75,72,
65,25,17,24,12,30,73,83,92,49,45,90,83,75,254,120,
232,21,45,22,9,254,218,12,14,5,80,18,19,8,57,78,
47,21,21,47,78,57,8,19,18,81,110,69,30,30,69,110,
76,221,7,24,13,47,165,5,18,0,0,2,252,184,4,46,
255,66,6,40,0,9,0,35,0,25,0,184,0,23,47,184,
0,33,47,187,0,28,0,2,0,15,0,4,43,184,0,28,
16,48,49,1,14,1,7,37,55,62,1,55,23,55,14,3,
35,34,46,2,39,62,1,55,30,3,51,50,62,2,55,30,
1,254,95,8,15,12,254,208,9,22,42,24,242,227,30,75,
83,90,45,49,92,83,73,30,12,24,17,25,65,72,75,33,
35,77,73,65,24,17,24,5,75,11,16,8,165,47,14,21,
9,221,5,81,110,69,30,30,69,110,81,18,19,8,57,78,
47,21,21,47,78,57,8,19,0,2,252,168,4,46,255,82,
6,183,0,28,0,54,0,25,0,184,0,42,47,184,0,52,
47,187,0,47,0,2,0,34,0,4,43,184,0,47,16,48,
49,3,14,3,35,34,46,2,35,34,6,7,39,62,3,51,
50,30,2,51,50,54,55,23,3,14,3,35,34,46,2,39,
62,1,55,30,3,51,50,62,2,55,30,1,174,18,50,61,
72,39,35,63,60,59,29,40,66,37,53,18,49,62,71,39,
38,68,60,54,24,38,73,34,54,16,30,75,83,90,45,49,
92,83,73,30,12,24,17,25,65,72,75,33,35,77,73,65,
24,17,24,6,160,41,80,64,40,35,43,35,65,56,20,41,
81,64,40,35,43,35,64,59,23,254,176,81,110,69,30,30,
69,110,81,18,19,8,57,78,47,21,21,47,78,57,8,19,
255,255,0,45,0,0,4,113,6,14,0,38,0,70,0,0,
0,7,5,112,2,125,0,0,255,255,0,45,0,0,6,238,
6,14,0,38,0,70,0,0,0,39,0,70,2,125,0,0,
0,7,5,112,4,250,0,0,0,1,0,117,255,226,3,117,
5,10,0,74,1,219,184,0,75,47,184,0,76,47,184,0,
0,220,184,0,75,16,184,0,38,208,184,0,38,47,184,0,
12,208,184,0,12,47,184,0,38,16,184,0,15,208,184,0,
15,47,184,0,38,16,184,0,18,208,184,0,18,47,184,0,
0,16,185,0,29,0,4,252,65,5,0,154,0,29,0,170,
0,29,0,2,93,65,19,0,9,0,29,0,25,0,29,0,
41,0,29,0,57,0,29,0,73,0,29,0,89,0,29,0,
105,0,29,0,121,0,29,0,137,0,29,0,9,93,184,0,
55,208,184,0,55,47,184,0,38,16,185,0,66,0,4,252,
65,19,0,6,0,66,0,22,0,66,0,38,0,66,0,54,
0,66,0,70,0,66,0,86,0,66,0,102,0,66,0,118,
0,66,0,134,0,66,0,9,93,65,5,0,149,0,66,0,
165,0,66,0,2,93,0,184,0,0,69,88,184,0,45,47,
27,185,0,45,0,11,62,89,184,0,0,69,88,184,0,7,
47,27,185,0,7,0,5,62,89,185,0,24,0,2,252,65,
33,0,7,0,24,0,23,0,24,0,39,0,24,0,55,0,
24,0,71,0,24,0,87,0,24,0,103,0,24,0,119,0,
24,0,135,0,24,0,151,0,24,0,167,0,24,0,183,0,
24,0,199,0,24,0,215,0,24,0,231,0,24,0,247,0,
24,0,16,93,65,15,0,7,0,24,0,23,0,24,0,39,
0,24,0,55,0,24,0,71,0,24,0,87,0,24,0,103,
0,24,0,7,113,65,5,0,118,0,24,0,134,0,24,0,
2,113,184,0,45,16,185,0,61,0,2,252,65,5,0,121,
0,61,0,137,0,61,0,2,113,65,33,0,8,0,61,0,
24,0,61,0,40,0,61,0,56,0,61,0,72,0,61,0,
88,0,61,0,104,0,61,0,120,0,61,0,136,0,61,0,
152,0,61,0,168,0,61,0,184,0,61,0,200,0,61,0,
216,0,61,0,232,0,61,0,248,0,61,0,16,93,65,15,
0,8,0,61,0,24,0,61,0,40,0,61,0,56,0,61,
0,72,0,61,0,88,0,61,0,104,0,61,0,7,113,48,
49,1,20,14,4,35,34,46,2,39,46,1,53,52,54,55,
23,30,3,51,50,62,2,53,52,46,6,53,52,62,4,51,
50,30,2,23,22,14,2,7,39,46,3,35,34,14,2,21,
20,30,6,3,117,24,49,73,99,125,75,33,78,82,81,35,
7,7,6,8,41,23,69,84,97,51,45,91,74,46,54,88,
112,117,112,88,54,18,40,63,89,116,73,45,91,79,64,18,
7,13,27,33,12,36,28,61,63,62,28,56,80,52,25,54,
89,113,119,113,89,54,1,121,45,94,91,81,60,36,14,25,
36,23,4,60,40,41,84,27,5,59,86,57,27,37,64,85,
48,61,88,68,54,54,60,80,105,73,31,72,72,67,51,30,
14,24,34,20,6,35,41,40,11,6,33,44,27,11,32,51,
61,28,47,73,61,54,59,68,88,113,0,1,0,70,0,0,
2,8,4,236,0,19,0,51,187,0,15,0,4,0,4,0,
4,43,184,0,15,16,0,184,0,0,69,88,184,0,9,47,
27,185,0,9,0,11,62,89,184,0,0,69,88,184,0,0,
47,27,185,0,0,0,5,62,89,48,49,51,53,62,1,53,
17,52,38,39,53,33,21,14,1,21,17,20,22,23,21,70,
68,77,73,72,1,194,68,77,73,72,43,14,33,14,4,27,
12,36,14,43,43,14,34,14,251,229,12,35,14,43,0,1,
255,66,254,132,2,43,4,236,0,43,0,48,187,0,4,0,
4,0,34,0,4,43,184,0,4,16,0,184,0,0,69,88,
184,0,41,47,27,185,0,41,0,11,62,89,187,0,29,0,
2,0,14,0,4,43,184,0,29,16,48,49,1,14,1,21,
17,20,14,2,7,14,3,35,34,46,2,53,52,62,2,55,
30,3,51,50,62,2,53,17,52,46,2,39,53,33,21,2,
43,68,77,33,55,72,39,27,66,65,59,19,30,60,46,29,
26,36,40,14,28,42,36,33,19,26,59,49,32,16,43,76,
60,1,244,4,193,14,34,14,252,74,119,159,110,73,32,21,
34,24,13,19,25,27,9,8,30,30,27,5,18,23,12,4,
34,87,152,117,3,254,6,14,16,17,9,43,43,0,0,2,
0,0,0,0,4,174,5,37,0,2,0,28,0,68,0,184,
0,0,69,88,184,0,23,47,27,185,0,23,0,11,62,89,
184,0,0,69,88,184,0,3,47,27,185,0,3,0,5,62,
89,184,0,0,69,88,184,0,14,47,27,185,0,14,0,5,
62,89,187,0,1,0,2,0,8,0,4,43,184,0,1,16,
48,49,1,33,3,19,53,62,1,39,3,33,3,6,22,23,
21,33,53,62,1,55,1,62,1,55,1,30,1,23,21,1,
155,1,91,176,194,78,62,13,114,254,104,111,9,73,82,254,
96,68,79,11,1,116,23,68,26,1,164,9,57,65,2,23,
2,2,251,231,43,5,31,32,1,77,254,179,31,28,9,43,
43,12,27,29,4,102,25,41,14,251,74,28,33,7,43,0,
0,2,0,49,255,242,3,248,4,236,0,20,0,66,1,82,
184,0,67,47,184,0,68,47,184,0,67,16,184,0,59,208,
184,0,59,47,185,0,4,0,4,252,184,0,6,208,184,0,
6,47,184,0,68,16,184,0,42,220,185,0,16,0,4,252,
65,5,0,154,0,16,0,170,0,16,0,2,93,65,19,0,
9,0,16,0,25,0,16,0,41,0,16,0,57,0,16,0,
73,0,16,0,89,0,16,0,105,0,16,0,121,0,16,0,
137,0,16,0,9,93,184,0,27,208,184,0,27,47,184,0,
4,16,184,0,33,208,0,184,0,0,69,88,184,0,26,47,
27,185,0,26,0,9,62,89,184,0,0,69,88,184,0,64,
47,27,185,0,64,0,11,62,89,184,0,0,69,88,184,0,
47,47,27,185,0,47,0,5,62,89,184,0,0,69,88,184,
0,54,47,27,185,0,54,0,5,62,89,187,0,37,0,2,
0,0,0,4,43,184,0,37,16,184,0,47,16,185,0,11,
0,2,252,65,33,0,7,0,11,0,23,0,11,0,39,0,
11,0,55,0,11,0,71,0,11,0,87,0,11,0,103,0,
11,0,119,0,11,0,135,0,11,0,151,0,11,0,167,0,
11,0,183,0,11,0,199,0,11,0,215,0,11,0,231,0,
11,0,247,0,11,0,16,93,65,15,0,7,0,11,0,23,
0,11,0,39,0,11,0,55,0,11,0,71,0,11,0,87,
0,11,0,103,0,11,0,7,113,65,5,0,118,0,11,0,
134,0,11,0,2,113,184,0,64,16,185,0,32,0,2,252,
48,49,1,34,6,7,17,20,23,30,3,51,50,62,2,53,
52,46,2,1,14,3,7,35,46,3,35,33,17,62,1,51,
50,30,2,21,20,14,2,35,34,46,4,49,35,53,62,1,
53,17,52,38,39,53,33,23,2,8,48,81,36,8,17,44,
47,46,20,72,116,83,44,39,81,125,1,85,2,10,15,17,
7,48,3,8,15,24,19,254,87,45,104,55,109,171,116,61,
67,121,168,101,29,88,96,97,78,48,74,68,78,74,72,3,
100,31,2,137,8,6,253,237,9,5,6,8,4,2,37,66,
93,56,55,116,95,61,2,74,26,80,87,84,28,64,91,58,
27,254,62,9,10,56,102,141,84,85,137,96,52,2,3,4,
3,2,43,14,33,14,4,27,12,36,14,43,25,0,0,3,
0,41,255,242,3,248,5,10,0,14,0,35,0,75,2,4,
187,0,19,0,4,0,53,0,4,43,184,0,19,16,187,0,
68,0,4,0,10,0,4,43,184,0,68,16,184,0,19,16,
184,0,3,208,65,5,0,154,0,10,0,170,0,10,0,2,
93,65,19,0,9,0,10,0,25,0,10,0,41,0,10,0,
57,0,10,0,73,0,10,0,89,0,10,0,105,0,10,0,
121,0,10,0,137,0,10,0,9,93,186,0,31,0,10,0,
68,17,18,57,184,0,31,47,65,5,0,154,0,31,0,170,
0,31,0,2,93,65,19,0,9,0,31,0,25,0,31,0,
41,0,31,0,57,0,31,0,73,0,31,0,89,0,31,0,
105,0,31,0,121,0,31,0,137,0,31,0,9,93,185,0,
36,0,4,252,186,0,71,0,53,0,36,17,18,57,184,0,
77,220,0,184,0,0,69,88,184,0,63,47,27,185,0,63,
0,11,62,89,184,0,0,69,88,184,0,41,47,27,185,0,
41,0,5,62,89,184,0,0,69,88,184,0,48,47,27,185,
0,48,0,5,62,89,187,0,5,0,2,0,15,0,4,43,
184,0,5,16,184,0,63,16,185,0,0,0,2,252,65,5,
0,121,0,0,0,137,0,0,0,2,113,65,33,0,8,0,
0,0,24,0,0,0,40,0,0,0,56,0,0,0,72,0,
0,0,88,0,0,0,104,0,0,0,120,0,0,0,136,0,
0,0,152,0,0,0,168,0,0,0,184,0,0,0,200,0,
0,0,216,0,0,0,232,0,0,0,248,0,0,0,16,93,
65,15,0,8,0,0,0,24,0,0,0,40,0,0,0,56,
0,0,0,72,0,0,0,88,0,0,0,104,0,0,0,7,
113,184,0,3,208,184,0,3,47,184,0,41,16,185,0,26,
0,2,252,65,33,0,7,0,26,0,23,0,26,0,39,0,
26,0,55,0,26,0,71,0,26,0,87,0,26,0,103,0,
26,0,119,0,26,0,135,0,26,0,151,0,26,0,167,0,
26,0,183,0,26,0,199,0,26,0,215,0,26,0,231,0,
26,0,247,0,26,0,16,93,65,15,0,7,0,26,0,23,
0,26,0,39,0,26,0,55,0,26,0,71,0,26,0,87,
0,26,0,103,0,26,0,7,113,65,5,0,118,0,26,0,
134,0,26,0,2,113,184,0,5,16,184,0,71,208,184,0,
71,47,48,49,1,34,6,7,17,51,50,62,2,53,52,46,
2,19,34,6,7,17,20,23,30,3,51,50,62,2,53,52,
46,2,1,20,14,2,35,34,46,4,49,35,53,62,1,53,
17,14,1,7,39,62,3,51,50,30,2,21,20,6,7,30,
3,1,157,14,29,15,34,114,141,78,27,32,78,129,10,48,
81,36,9,17,44,46,46,20,72,116,83,44,39,81,125,1,
153,67,121,168,101,29,88,96,97,78,48,73,68,77,38,73,
34,9,39,103,114,118,54,100,162,113,61,102,88,64,110,81,
46,4,182,1,1,254,33,45,70,88,43,50,86,63,36,253,
211,8,6,253,237,8,7,6,7,4,2,37,66,93,56,55,
116,95,61,254,219,85,137,96,52,2,3,4,3,2,43,14,
33,14,4,62,5,11,6,62,11,21,17,11,37,70,100,63,
108,155,34,12,66,97,123,0,0,1,0,49,0,0,3,160,
4,236,0,30,0,78,187,0,24,0,4,0,4,0,4,43,
184,0,24,16,0,184,0,0,69,88,184,0,16,47,27,185,
0,16,0,9,62,89,184,0,0,69,88,184,0,9,47,27,
185,0,9,0,11,62,89,184,0,0,69,88,184,0,0,47,
27,185,0,0,0,5,62,89,184,0,9,16,185,0,22,0,
2,252,48,49,51,53,62,1,53,17,52,38,39,53,33,23,
14,3,7,35,46,3,35,33,17,20,30,2,23,21,49,68,
78,74,72,3,80,31,2,10,15,17,7,48,3,8,15,24,
19,254,107,16,44,76,60,43,14,33,14,4,27,12,36,14,
43,25,26,80,87,84,28,64,91,58,27,251,214,7,13,14,
17,10,43,0,0,2,0,51,254,232,4,207,4,236,0,27,
0,78,0,112,187,0,72,0,4,0,20,0,4,43,184,0,
72,16,184,0,80,220,0,184,0,33,47,184,0,46,47,184,
0,0,69,88,184,0,66,47,27,185,0,66,0,11,62,89,
184,0,0,69,88,184,0,39,47,27,185,0,39,0,5,62,
89,184,0,0,69,88,184,0,41,47,27,185,0,41,0,5,
62,89,184,0,66,16,185,0,0,0,2,252,184,0,41,16,
185,0,14,0,2,252,184,0,15,208,184,0,0,16,184,0,
26,208,48,49,1,38,6,7,14,3,7,14,1,7,30,1,
51,33,62,3,55,17,52,46,2,43,1,1,14,3,7,35,
46,3,39,35,5,14,3,7,35,52,62,2,55,62,1,55,
62,3,55,46,3,39,53,33,21,14,1,21,17,20,30,2,
31,1,2,93,50,36,5,8,17,22,31,22,14,25,13,4,
41,54,1,60,43,50,26,8,2,7,24,46,38,186,2,114,
2,10,15,17,7,48,3,8,14,23,18,3,252,192,17,26,
27,32,23,55,4,8,12,6,77,131,40,16,28,23,16,3,
5,32,49,62,36,3,212,69,76,10,28,53,43,31,4,146,
1,16,17,135,239,212,189,84,55,80,29,12,13,1,7,12,
18,12,3,212,12,18,13,7,251,144,26,83,90,87,28,62,
102,73,41,2,1,3,33,67,103,73,29,90,96,87,26,29,
166,138,57,165,202,230,120,7,16,16,16,7,43,43,14,34,
14,251,229,4,10,12,13,6,25,0,0,1,0,50,0,0,
3,186,4,236,0,54,0,89,187,0,42,0,4,0,8,0,
4,43,184,0,42,16,184,0,27,208,0,184,0,0,69,88,
184,0,13,47,27,185,0,13,0,11,62,89,184,0,0,69,
88,184,0,3,47,27,185,0,3,0,5,62,89,187,0,28,
0,2,0,41,0,4,43,184,0,28,16,184,0,13,16,185,
0,26,0,2,252,184,0,3,16,185,0,47,0,2,252,48,
49,37,14,1,7,33,53,62,1,53,17,52,38,39,53,33,
23,14,3,7,35,46,3,35,33,17,33,23,14,3,7,46,
3,43,1,17,20,30,2,59,1,50,62,2,55,23,3,186,
8,25,8,252,161,68,77,73,72,3,38,33,2,8,12,13,
6,45,2,13,20,29,18,254,146,1,149,26,8,23,25,25,
11,15,35,45,61,42,141,14,44,80,66,129,46,65,50,41,
21,43,244,86,129,29,43,14,33,14,4,27,12,36,14,43,
25,26,62,62,56,19,46,62,37,15,254,77,28,14,31,29,
25,8,15,20,14,6,254,11,15,23,17,9,10,35,68,59,
18,0,0,1,0,60,255,241,6,220,4,252,0,136,1,62,
187,0,17,0,4,0,26,0,4,43,184,0,17,16,184,0,
26,16,184,0,84,208,184,0,17,16,184,0,94,208,0,184,
0,0,69,88,184,0,89,47,27,185,0,89,0,11,62,89,
184,0,0,69,88,184,0,75,47,27,185,0,75,0,11,62,
89,184,0,0,69,88,184,0,104,47,27,185,0,104,0,11,
62,89,184,0,0,69,88,184,0,3,47,27,185,0,3,0,
5,62,89,184,0,0,69,88,184,0,40,47,27,185,0,40,
0,5,62,89,184,0,0,69,88,184,0,21,47,27,185,0,
21,0,5,62,89,187,0,95,0,2,0,16,0,4,43,184,
0,95,16,184,0,16,16,184,0,27,208,186,0,56,0,16,
0,95,17,18,57,184,0,75,16,185,0,63,0,2,252,65,
5,0,121,0,63,0,137,0,63,0,2,113,65,33,0,8,
0,63,0,24,0,63,0,40,0,63,0,56,0,63,0,72,
0,63,0,88,0,63,0,104,0,63,0,120,0,63,0,136,
0,63,0,152,0,63,0,168,0,63,0,184,0,63,0,200,
0,63,0,216,0,63,0,232,0,63,0,248,0,63,0,16,
93,65,15,0,8,0,63,0,24,0,63,0,40,0,63,0,
56,0,63,0,72,0,63,0,88,0,63,0,104,0,63,0,
7,113,184,0,95,16,184,0,84,208,184,0,63,16,184,0,
116,208,186,0,123,0,16,0,95,17,18,57,48,49,37,14,
1,35,34,46,2,39,46,5,7,35,17,20,22,23,21,33,
53,62,1,53,17,35,38,14,4,7,14,3,35,34,38,39,
55,22,62,2,55,62,5,55,46,5,35,34,14,2,15,1,
46,1,55,62,1,51,50,30,6,23,17,52,38,39,53,33,
21,14,1,21,17,62,7,51,50,22,23,22,6,7,39,46,
3,35,34,14,4,7,30,5,23,30,3,55,23,6,220,79,
115,14,24,36,30,26,14,26,47,49,56,70,87,56,39,72,
73,254,62,68,77,39,56,87,70,56,49,47,26,14,26,30,
36,24,14,115,79,8,41,55,41,33,18,23,41,46,54,70,
90,58,45,64,51,41,43,52,35,15,23,20,20,13,50,44,
29,20,40,68,44,58,83,63,48,46,50,66,88,61,73,72,
1,194,68,77,61,87,66,50,46,49,63,83,58,44,68,40,
20,29,44,50,13,20,20,23,15,35,52,44,41,50,65,45,
58,88,69,54,46,44,24,18,33,41,55,41,8,23,17,21,
7,16,27,21,37,114,126,126,99,60,3,254,1,12,35,14,
43,43,14,33,14,1,255,3,60,99,126,126,114,37,21,27,
16,7,21,17,58,4,3,16,29,23,28,88,104,109,100,81,
23,34,91,97,94,74,46,6,15,27,20,14,91,110,9,19,
12,48,78,100,105,102,82,52,4,1,194,12,36,14,43,43,
14,34,14,254,62,4,52,82,102,105,100,78,48,12,19,9,
110,91,14,20,27,15,6,46,74,94,97,91,34,23,81,99,
109,103,89,29,22,29,16,4,4,58,0,1,0,94,255,226,
3,208,5,10,0,78,1,201,187,0,36,0,4,0,8,0,
4,43,184,0,36,16,65,5,0,154,0,8,0,170,0,8,
0,2,93,65,19,0,9,0,8,0,25,0,8,0,41,0,
8,0,57,0,8,0,73,0,8,0,89,0,8,0,105,0,
8,0,121,0,8,0,137,0,8,0,9,93,186,0,69,0,
8,0,36,17,18,57,184,0,69,47,65,5,0,154,0,69,
0,170,0,69,0,2,93,65,19,0,9,0,69,0,25,0,
69,0,41,0,69,0,57,0,69,0,73,0,69,0,89,0,
69,0,105,0,69,0,121,0,69,0,137,0,69,0,9,93,
185,0,44,0,4,252,184,0,80,220,0,184,0,0,69,88,
184,0,31,47,27,185,0,31,0,11,62,89,184,0,0,69,
88,184,0,49,47,27,185,0,49,0,5,62,89,187,0,3,
0,2,0,74,0,4,43,184,0,3,16,184,0,31,16,185,
0,13,0,2,252,65,5,0,121,0,13,0,137,0,13,0,
2,113,65,33,0,8,0,13,0,24,0,13,0,40,0,13,
0,56,0,13,0,72,0,13,0,88,0,13,0,104,0,13,
0,120,0,13,0,136,0,13,0,152,0,13,0,168,0,13,
0,184,0,13,0,200,0,13,0,216,0,13,0,232,0,13,
0,248,0,13,0,16,93,65,15,0,8,0,13,0,24,0,
13,0,40,0,13,0,56,0,13,0,72,0,13,0,88,0,
13,0,104,0,13,0,7,113,186,0,39,0,74,0,3,17,
18,57,184,0,49,16,185,0,64,0,2,252,65,33,0,7,
0,64,0,23,0,64,0,39,0,64,0,55,0,64,0,71,
0,64,0,87,0,64,0,103,0,64,0,119,0,64,0,135,
0,64,0,151,0,64,0,167,0,64,0,183,0,64,0,199,
0,64,0,215,0,64,0,231,0,64,0,247,0,64,0,16,
93,65,15,0,7,0,64,0,23,0,64,0,39,0,64,0,
55,0,64,0,71,0,64,0,87,0,64,0,103,0,64,0,
7,113,65,5,0,118,0,64,0,134,0,64,0,2,113,48,
49,1,30,1,51,62,3,53,52,46,2,35,34,14,2,15,
1,46,4,54,55,62,3,51,50,30,2,21,20,6,7,30,
3,21,20,14,2,35,34,46,2,53,52,62,2,55,30,3,
51,50,62,2,53,52,46,2,35,34,6,7,39,1,95,33,
59,26,95,118,65,22,37,66,90,53,71,105,71,39,6,44,
6,9,7,3,1,3,3,52,110,108,101,42,60,119,96,59,
78,91,48,84,63,36,81,135,177,95,86,145,105,58,28,42,
48,21,21,66,79,86,42,71,109,75,39,59,92,110,51,60,
91,22,22,2,224,8,6,1,60,82,88,29,51,78,53,27,
40,69,96,55,8,14,48,56,57,48,31,2,29,42,27,13,
34,69,105,71,90,149,57,16,58,80,100,57,95,159,115,65,
45,60,61,17,6,34,37,32,3,37,64,47,27,37,69,99,
61,69,104,68,34,17,11,27,0,1,0,50,0,0,4,246,
4,236,0,43,0,159,184,0,44,47,184,0,45,47,184,0,
44,16,184,0,4,208,184,0,4,47,185,0,39,0,4,252,
184,0,14,208,184,0,45,16,184,0,26,220,186,0,15,0,
4,0,26,17,18,57,185,0,17,0,4,252,184,0,36,208,
186,0,37,0,4,0,26,17,18,57,0,184,0,0,69,88,
184,0,9,47,27,185,0,9,0,11,62,89,184,0,0,69,
88,184,0,21,47,27,185,0,21,0,11,62,89,184,0,0,
69,88,184,0,0,47,27,185,0,0,0,5,62,89,184,0,
0,69,88,184,0,31,47,27,185,0,31,0,5,62,89,186,
0,15,0,0,0,9,17,18,57,186,0,37,0,0,0,9,
17,18,57,48,49,51,53,62,1,53,17,52,38,39,53,33,
21,14,1,21,17,1,53,52,38,39,53,33,21,14,1,21,
17,20,22,23,21,33,53,62,1,53,17,1,21,20,22,23,
21,50,68,77,73,72,1,194,68,77,2,98,73,72,1,194,
68,77,73,72,254,62,68,77,253,158,72,73,43,14,33,14,
4,27,12,36,14,43,43,14,34,14,252,184,3,13,59,12,
36,14,43,43,14,34,14,251,229,12,35,14,43,43,14,33,
14,3,74,252,243,61,12,35,14,43,0,2,0,50,0,0,
4,246,6,125,0,31,0,75,0,197,184,0,76,47,184,0,
77,47,184,0,76,16,184,0,36,208,184,0,36,47,185,0,
71,0,4,252,184,0,5,208,184,0,77,16,184,0,58,220,
185,0,49,0,4,252,184,0,27,208,184,0,71,16,184,0,
46,208,186,0,47,0,36,0,58,17,18,57,184,0,49,16,
184,0,68,208,186,0,69,0,36,0,58,17,18,57,0,184,
0,10,47,184,0,22,47,184,0,0,69,88,184,0,41,47,
27,185,0,41,0,11,62,89,184,0,0,69,88,184,0,53,
47,27,185,0,53,0,11,62,89,184,0,0,69,88,184,0,
32,47,27,185,0,32,0,5,62,89,184,0,0,69,88,184,
0,63,47,27,185,0,63,0,5,62,89,187,0,16,0,2,
0,0,0,4,43,184,0,16,16,186,0,47,0,32,0,10,
17,18,57,186,0,69,0,32,0,10,17,18,57,48,49,1,
34,46,2,39,38,62,2,55,23,30,3,51,50,62,2,63,
1,30,3,7,14,3,1,53,62,1,53,17,52,38,39,53,
33,21,14,1,21,17,1,53,52,38,39,53,33,21,14,1,
21,17,20,22,23,21,33,53,62,1,53,17,1,21,20,22,
23,21,2,148,60,100,77,54,14,2,6,12,17,10,37,4,
36,59,79,47,47,79,59,36,4,37,10,17,12,6,2,14,
54,77,100,253,98,68,77,73,72,1,194,68,77,2,98,73,
72,1,194,68,77,73,72,254,62,68,77,253,158,72,73,5,
115,17,27,34,17,12,47,51,48,13,11,39,64,47,25,25,
47,64,39,11,13,48,51,47,12,17,34,27,17,250,141,43,
14,33,14,4,27,12,36,14,43,43,14,34,14,252,184,3,
13,59,12,36,14,43,43,14,34,14,251,229,12,35,14,43,
43,14,33,14,3,74,252,243,61,12,35,14,43,0,0,1,
0,50,255,241,4,207,4,252,0,81,0,238,187,0,19,0,
4,0,28,0,4,43,184,0,19,16,184,0,38,208,0,184,
0,0,69,88,184,0,33,47,27,185,0,33,0,11,62,89,
184,0,0,69,88,184,0,49,47,27,185,0,49,0,11,62,
89,184,0,0,69,88,184,0,5,47,27,185,0,5,0,5,
62,89,184,0,0,69,88,184,0,23,47,27,185,0,23,0,
5,62,89,187,0,40,0,2,0,18,0,4,43,184,0,40,
16,184,0,49,16,185,0,61,0,2,252,65,5,0,121,0,
61,0,137,0,61,0,2,113,65,33,0,8,0,61,0,24,
0,61,0,40,0,61,0,56,0,61,0,72,0,61,0,88,
0,61,0,104,0,61,0,120,0,61,0,136,0,61,0,152,
0,61,0,168,0,61,0,184,0,61,0,200,0,61,0,216,
0,61,0,232,0,61,0,248,0,61,0,16,93,65,15,0,
8,0,61,0,24,0,61,0,40,0,61,0,56,0,61,0,
72,0,61,0,88,0,61,0,104,0,61,0,7,113,186,0,
68,0,18,0,40,17,18,57,48,49,37,14,3,35,34,46,
2,39,46,5,7,35,17,20,22,23,21,33,53,62,1,53,
17,52,38,39,53,33,21,14,1,21,17,51,50,62,6,51,
50,22,23,22,6,7,39,46,3,35,34,14,4,7,30,5,
23,30,3,55,23,4,207,39,73,59,40,7,24,37,32,30,
17,36,65,65,68,79,92,56,57,72,73,254,62,68,77,73,
72,1,194,68,77,1,64,101,81,68,64,65,76,92,59,44,
68,40,20,29,44,50,13,23,26,30,19,40,62,55,54,62,
75,49,59,95,78,65,60,58,33,22,40,46,59,41,8,23,
8,14,10,6,9,17,27,18,37,114,126,126,99,60,3,254,
1,12,35,14,43,43,14,33,14,4,27,12,36,14,43,43,
14,34,14,254,62,49,80,103,107,103,80,49,12,19,9,110,
91,14,20,27,15,6,46,74,95,97,91,34,23,81,99,109,
103,88,29,19,29,17,6,4,58,0,0,1,0,20,255,228,
4,186,4,236,0,52,0,65,187,0,22,0,4,0,31,0,
4,43,184,0,22,16,184,0,54,220,0,184,0,0,69,88,
184,0,16,47,27,185,0,16,0,11,62,89,184,0,0,69,
88,184,0,26,47,27,185,0,26,0,5,62,89,184,0,16,
16,185,0,37,0,2,252,48,49,55,62,3,55,62,3,55,
46,3,39,53,33,21,14,1,21,17,20,22,23,21,33,53,
62,1,53,17,52,46,2,43,1,38,6,7,14,3,7,14,
3,47,1,28,36,76,74,72,32,18,32,25,17,4,5,32,
49,62,36,3,212,69,76,72,73,254,62,68,77,7,24,46,
38,186,50,37,4,9,20,26,33,22,21,40,43,52,34,193,
71,3,29,72,126,100,56,160,195,223,120,7,16,16,16,7,
43,43,14,34,14,251,229,12,35,14,43,43,14,33,14,3,
248,12,18,13,7,1,17,17,134,231,206,183,84,83,125,81,
38,5,36,0,0,1,0,60,0,0,6,34,4,236,0,49,
0,132,0,184,0,0,69,88,184,0,34,47,27,185,0,34,
0,11,62,89,184,0,0,69,88,184,0,47,47,27,185,0,
47,0,11,62,89,184,0,0,69,88,184,0,8,47,27,185,
0,8,0,5,62,89,184,0,0,69,88,184,0,17,47,27,
185,0,17,0,5,62,89,184,0,0,69,88,184,0,24,47,
27,185,0,24,0,5,62,89,184,0,47,16,185,0,0,0,
1,252,186,0,16,0,8,0,34,17,18,57,186,0,19,0,
8,0,34,17,18,57,184,0,33,208,186,0,41,0,8,0,
34,17,18,57,48,49,1,34,6,7,19,20,22,23,21,33,
53,62,1,53,3,6,7,1,35,1,3,20,22,23,21,33,
53,62,1,53,19,46,1,35,53,33,50,30,2,23,9,1,
62,3,51,33,21,6,14,29,70,36,10,73,72,254,59,68,
87,9,1,2,254,75,49,254,64,9,73,72,254,110,69,76,
10,38,77,30,1,30,10,13,13,16,12,1,142,1,126,13,
16,13,13,9,1,30,4,193,18,17,251,202,12,35,14,43,
43,14,33,14,3,175,3,4,251,240,4,15,252,89,12,35,
14,43,43,14,33,14,4,49,23,17,43,6,18,33,27,252,
122,3,134,30,33,17,4,43,0,1,0,50,0,0,4,246,
4,236,0,43,0,133,184,0,44,47,184,0,45,47,184,0,
44,16,184,0,4,208,184,0,4,47,185,0,39,0,4,252,
184,0,14,208,184,0,45,16,184,0,26,220,185,0,17,0,
4,252,184,0,36,208,0,184,0,0,69,88,184,0,9,47,
27,185,0,9,0,11,62,89,184,0,0,69,88,184,0,21,
47,27,185,0,21,0,11,62,89,184,0,0,69,88,184,0,
0,47,27,185,0,0,0,5,62,89,184,0,0,69,88,184,
0,31,47,27,185,0,31,0,5,62,89,187,0,16,0,2,
0,37,0,4,43,184,0,16,16,48,49,51,53,62,1,53,
17,52,38,39,53,33,21,14,1,21,17,33,17,52,38,39,
53,33,21,14,1,21,17,20,22,23,21,33,53,62,1,53,
17,33,17,20,22,23,21,50,68,77,73,72,1,194,68,77,
2,98,73,72,1,194,68,77,73,72,254,62,68,77,253,158,
72,73,43,14,33,14,4,27,12,36,14,43,43,14,34,14,
254,62,1,194,12,36,14,43,43,14,34,14,251,229,12,35,
14,43,43,14,33,14,1,255,254,1,12,35,14,43,0,2,
0,70,255,226,4,114,5,10,0,21,0,41,1,175,184,0,
42,47,184,0,43,47,184,0,22,220,185,0,0,0,4,252,
65,5,0,154,0,0,0,170,0,0,0,2,93,65,19,0,
9,0,0,0,25,0,0,0,41,0,0,0,57,0,0,0,
73,0,0,0,89,0,0,0,105,0,0,0,121,0,0,0,
137,0,0,0,9,93,184,0,42,16,184,0,32,208,184,0,
32,47,185,0,12,0,4,252,65,19,0,6,0,12,0,22,
0,12,0,38,0,12,0,54,0,12,0,70,0,12,0,86,
0,12,0,102,0,12,0,118,0,12,0,134,0,12,0,9,
93,65,5,0,149,0,12,0,165,0,12,0,2,93,0,184,
0,0,69,88,184,0,37,47,27,185,0,37,0,11,62,89,
184,0,0,69,88,184,0,27,47,27,185,0,27,0,5,62,
89,184,0,37,16,185,0,7,0,2,252,65,5,0,121,0,
7,0,137,0,7,0,2,113,65,33,0,8,0,7,0,24,
0,7,0,40,0,7,0,56,0,7,0,72,0,7,0,88,
0,7,0,104,0,7,0,120,0,7,0,136,0,7,0,152,
0,7,0,168,0,7,0,184,0,7,0,200,0,7,0,216,
0,7,0,232,0,7,0,248,0,7,0,16,93,65,15,0,
8,0,7,0,24,0,7,0,40,0,7,0,56,0,7,0,
72,0,7,0,88,0,7,0,104,0,7,0,7,113,184,0,
27,16,185,0,17,0,2,252,65,33,0,7,0,17,0,23,
0,17,0,39,0,17,0,55,0,17,0,71,0,17,0,87,
0,17,0,103,0,17,0,119,0,17,0,135,0,17,0,151,
0,17,0,167,0,17,0,183,0,17,0,199,0,17,0,215,
0,17,0,231,0,17,0,247,0,17,0,16,93,65,15,0,
7,0,17,0,23,0,17,0,39,0,17,0,55,0,17,0,
71,0,17,0,87,0,17,0,103,0,17,0,7,113,65,5,
0,118,0,17,0,134,0,17,0,2,113,48,49,1,52,46,
4,35,34,14,2,21,20,30,2,51,50,62,2,55,20,14,
2,35,34,46,2,53,52,62,2,51,50,30,2,3,215,25,
46,67,84,100,57,89,141,97,52,61,103,138,77,83,139,101,
56,155,90,155,204,114,120,188,129,68,88,152,205,118,124,188,
128,65,2,117,69,135,121,104,75,43,76,139,198,122,112,200,
151,88,69,136,202,150,136,245,186,110,106,178,232,126,136,246,
186,110,109,180,232,0,0,1,0,50,0,0,4,196,4,236,
0,41,0,108,184,0,42,47,184,0,43,47,184,0,42,16,
184,0,4,208,184,0,4,47,184,0,43,16,184,0,15,220,
185,0,24,0,4,252,184,0,4,16,185,0,37,0,4,252,
0,184,0,0,69,88,184,0,9,47,27,185,0,9,0,11,
62,89,184,0,0,69,88,184,0,0,47,27,185,0,0,0,
5,62,89,184,0,0,69,88,184,0,19,47,27,185,0,19,
0,5,62,89,184,0,9,16,185,0,30,0,2,252,48,49,
51,53,62,1,53,17,52,38,39,53,33,21,14,1,21,17,
20,22,23,21,33,53,62,1,53,17,52,46,2,35,33,14,
3,21,17,20,22,23,21,50,68,77,73,72,4,146,69,76,
72,73,254,62,68,77,11,31,56,46,254,225,43,51,27,8,
72,73,43,14,33,14,4,27,12,36,14,43,43,14,34,14,
251,229,12,35,14,43,43,14,33,14,3,248,12,18,13,7,
1,7,12,18,12,252,8,12,35,14,43,0,0,1,0,41,
0,0,3,214,5,10,0,52,1,46,184,0,53,47,184,0,
54,47,184,0,53,16,184,0,4,208,184,0,4,47,184,0,
54,16,184,0,19,220,186,0,29,0,4,0,19,17,18,57,
185,0,37,0,4,252,65,5,0,154,0,37,0,170,0,37,
0,2,93,65,19,0,9,0,37,0,25,0,37,0,41,0,
37,0,57,0,37,0,73,0,37,0,89,0,37,0,105,0,
37,0,121,0,37,0,137,0,37,0,9,93,184,0,4,16,
185,0,46,0,4,252,0,184,0,0,69,88,184,0,14,47,
27,185,0,14,0,11,62,89,184,0,0,69,88,184,0,0,
47,27,185,0,0,0,5,62,89,187,0,32,0,2,0,26,
0,4,43,184,0,32,16,186,0,29,0,0,0,14,17,18,
57,184,0,14,16,185,0,42,0,2,252,65,5,0,121,0,
42,0,137,0,42,0,2,113,65,33,0,8,0,42,0,24,
0,42,0,40,0,42,0,56,0,42,0,72,0,42,0,88,
0,42,0,104,0,42,0,120,0,42,0,136,0,42,0,152,
0,42,0,168,0,42,0,184,0,42,0,200,0,42,0,216,
0,42,0,232,0,42,0,248,0,42,0,16,93,65,15,0,
8,0,42,0,24,0,42,0,40,0,42,0,56,0,42,0,
72,0,42,0,88,0,42,0,104,0,42,0,7,113,184,0,
45,208,184,0,45,47,48,49,51,53,62,1,53,17,14,1,
7,39,62,3,51,50,30,2,21,20,14,4,35,34,47,1,
30,1,51,50,62,2,53,52,46,2,35,34,6,7,17,20,
30,2,23,21,50,68,77,37,73,35,9,48,113,122,125,61,
108,174,123,67,39,65,84,91,91,39,94,67,23,42,77,35,
46,100,84,54,59,102,136,77,25,49,24,16,39,68,52,43,
14,33,14,4,62,5,11,6,62,13,22,16,9,46,90,132,
86,69,114,89,65,43,21,30,76,19,11,36,71,106,71,82,
118,75,36,1,1,251,180,6,14,16,16,9,43,0,0,1,
0,70,255,226,3,250,5,10,0,46,1,99,187,0,34,0,
4,0,10,0,4,43,184,0,34,16,65,19,0,6,0,34,
0,22,0,34,0,38,0,34,0,54,0,34,0,70,0,34,
0,86,0,34,0,102,0,34,0,118,0,34,0,134,0,34,
0,9,93,65,5,0,149,0,34,0,165,0,34,0,2,93,
0,184,0,0,69,88,184,0,15,47,27,185,0,15,0,11,
62,89,184,0,0,69,88,184,0,5,47,27,185,0,5,0,
5,62,89,184,0,15,16,185,0,27,0,2,252,65,5,0,
121,0,27,0,137,0,27,0,2,113,65,33,0,8,0,27,
0,24,0,27,0,40,0,27,0,56,0,27,0,72,0,27,
0,88,0,27,0,104,0,27,0,120,0,27,0,136,0,27,
0,152,0,27,0,168,0,27,0,184,0,27,0,200,0,27,
0,216,0,27,0,232,0,27,0,248,0,27,0,16,93,65,
15,0,8,0,27,0,24,0,27,0,40,0,27,0,56,0,
27,0,72,0,27,0,88,0,27,0,104,0,27,0,7,113,
184,0,5,16,185,0,39,0,2,252,65,33,0,7,0,39,
0,23,0,39,0,39,0,39,0,55,0,39,0,71,0,39,
0,87,0,39,0,103,0,39,0,119,0,39,0,135,0,39,
0,151,0,39,0,167,0,39,0,183,0,39,0,199,0,39,
0,215,0,39,0,231,0,39,0,247,0,39,0,16,93,65,
15,0,7,0,39,0,23,0,39,0,39,0,39,0,55,0,
39,0,71,0,39,0,87,0,39,0,103,0,39,0,7,113,
65,5,0,118,0,39,0,134,0,39,0,2,113,48,49,37,
14,3,35,34,46,2,53,52,18,62,1,51,50,22,23,22,
14,2,7,39,46,1,35,34,14,4,21,20,30,2,51,50,
54,55,30,3,3,250,64,117,109,105,52,93,179,142,87,97,
166,220,123,108,163,52,6,18,31,35,12,35,51,140,91,34,
81,82,76,59,35,77,121,149,71,54,174,110,5,11,10,8,
211,68,93,56,24,84,158,229,145,160,1,4,184,100,58,42,
5,30,38,38,12,6,47,60,25,54,87,124,163,104,133,200,
133,67,74,92,2,13,14,13,0,1,0,10,0,0,4,59,
4,236,0,34,0,69,187,0,30,0,4,0,6,0,4,43,
184,0,30,16,0,184,0,0,69,88,184,0,17,47,27,185,
0,17,0,11,62,89,184,0,0,69,88,184,0,0,47,27,
185,0,0,0,5,62,89,184,0,17,16,185,0,7,0,2,
252,184,0,28,208,184,0,29,208,48,49,33,53,62,3,53,
17,33,34,14,2,7,39,62,1,55,33,23,14,1,7,35,
46,3,35,33,17,20,22,23,21,1,51,46,63,38,17,254,
213,15,25,25,32,22,43,5,17,11,3,242,30,2,16,12,
45,9,15,19,28,22,254,228,72,92,43,9,20,19,17,7,
4,31,11,36,70,58,19,59,134,53,25,51,121,63,42,64,
43,21,251,225,13,40,19,43,0,1,0,20,254,232,5,10,
4,236,0,45,0,51,0,184,0,10,47,184,0,0,69,88,
184,0,32,47,27,185,0,32,0,11,62,89,184,0,0,69,
88,184,0,43,47,27,185,0,43,0,11,62,89,186,0,38,
0,10,0,32,17,18,57,48,49,1,14,1,15,1,1,14,
3,35,34,46,2,53,52,62,2,55,22,54,55,62,3,55,
1,38,39,53,33,21,14,1,23,9,1,54,38,39,53,33,
21,5,10,68,78,9,44,254,157,44,110,117,116,50,38,64,
46,26,24,36,41,16,48,95,37,17,45,47,45,18,254,80,
17,125,1,179,78,62,13,1,96,1,80,11,71,82,1,160,
4,193,13,25,28,112,252,123,110,158,102,48,10,15,19,9,
6,39,47,43,10,28,3,14,6,34,53,69,40,4,18,50,
16,43,43,5,30,31,252,196,3,60,29,27,10,43,43,0,
0,3,0,87,0,0,4,209,4,236,0,10,0,21,0,63,
1,27,187,0,0,0,4,0,32,0,4,43,187,0,17,0,
4,0,5,0,4,43,184,0,17,16,187,0,53,0,4,0,
11,0,4,43,184,0,53,16,65,19,0,6,0,0,0,22,
0,0,0,38,0,0,0,54,0,0,0,70,0,0,0,86,
0,0,0,102,0,0,0,118,0,0,0,134,0,0,0,9,
93,65,5,0,149,0,0,0,165,0,0,0,2,93,65,5,
0,154,0,11,0,170,0,11,0,2,93,65,19,0,9,0,
11,0,25,0,11,0,41,0,11,0,57,0,11,0,73,0,
11,0,89,0,11,0,105,0,11,0,121,0,11,0,137,0,
11,0,9,93,184,0,5,16,184,0,26,208,184,0,5,16,
184,0,37,208,184,0,17,16,184,0,47,208,184,0,17,16,
184,0,58,208,184,0,53,16,184,0,65,220,0,184,0,0,
69,88,184,0,42,47,27,185,0,42,0,11,62,89,184,0,
0,69,88,184,0,22,47,27,185,0,22,0,5,62,89,184,
0,5,220,184,0,42,16,184,0,6,220,184,0,16,208,184,
0,16,47,184,0,5,16,184,0,17,208,185,0,27,0,2,
252,184,0,6,16,185,0,48,0,2,252,184,0,37,208,184,
0,37,47,184,0,27,16,184,0,58,208,48,49,19,20,30,
2,23,17,14,3,5,52,46,2,39,17,62,3,1,53,62,
1,61,1,46,3,53,52,62,2,55,53,52,38,39,53,33,
21,14,1,29,1,30,3,23,22,14,2,7,21,20,22,23,
21,245,56,94,121,65,90,128,81,37,3,65,52,92,123,70,
88,127,82,40,253,126,68,77,93,177,139,85,69,129,182,114,
73,72,1,195,68,78,97,178,135,80,1,1,78,133,180,101,
74,72,2,129,87,130,91,55,12,2,229,8,71,102,124,76,
79,127,94,61,13,253,26,7,65,99,127,253,212,43,14,33,
14,67,8,54,107,165,118,89,158,123,82,13,67,12,36,14,
43,43,14,34,14,63,7,59,109,162,110,102,166,122,74,10,
67,12,35,14,43,0,0,1,0,31,0,0,4,205,4,236,
0,53,0,139,0,184,0,0,69,88,184,0,25,47,27,185,
0,25,0,11,62,89,184,0,0,69,88,184,0,38,47,27,
185,0,38,0,11,62,89,184,0,0,69,88,184,0,0,47,
27,185,0,0,0,5,62,89,184,0,0,69,88,184,0,12,
47,27,185,0,12,0,5,62,89,184,0,0,16,185,0,1,
0,1,252,186,0,7,0,0,0,25,17,18,57,184,0,11,
208,184,0,14,208,184,0,25,16,185,0,24,0,1,252,184,
0,27,208,186,0,31,0,0,0,25,17,18,57,184,0,37,
208,184,0,40,208,184,0,14,16,184,0,52,208,48,49,33,
53,62,2,38,39,1,3,6,22,23,21,33,53,62,1,55,
9,1,46,3,39,53,33,21,14,1,23,27,1,54,46,2,
39,53,33,21,14,3,7,9,1,30,3,23,21,3,10,44,
54,24,3,14,254,233,252,28,65,92,254,62,65,92,25,1,
61,254,179,15,28,35,45,33,1,195,85,51,29,247,226,14,
4,34,62,45,1,197,36,57,44,33,13,254,221,1,109,15,
31,37,46,29,43,4,13,19,28,20,1,152,254,104,44,34,
6,43,43,5,37,42,2,5,1,233,22,28,18,11,5,43,
43,8,32,44,254,149,1,107,23,29,19,10,3,43,43,4,
11,19,29,21,254,41,253,233,21,29,19,11,4,43,0,1,
0,50,254,231,4,216,4,236,0,55,0,78,184,0,56,47,
184,0,57,47,184,0,49,220,184,0,11,208,184,0,11,47,
184,0,56,16,184,0,16,208,184,0,16,47,185,0,27,0,
4,252,184,0,49,16,185,0,38,0,4,252,0,184,0,5,
47,184,0,0,69,88,184,0,11,47,27,185,0,11,0,5,
62,89,185,0,32,0,2,252,48,49,37,14,3,7,35,46,
3,35,33,53,62,1,53,17,52,38,39,53,33,21,14,1,
21,17,20,30,2,51,33,62,3,53,17,52,38,39,53,33,
21,14,1,21,17,20,30,2,31,1,4,216,2,10,15,17,
7,48,3,8,15,24,19,252,2,69,76,72,73,1,194,68,
77,7,24,46,38,1,60,43,51,27,8,72,73,1,194,68,
77,8,28,53,45,31,34,26,83,91,87,28,64,103,74,40,
43,14,34,14,4,27,12,35,14,43,43,14,33,14,252,8,
12,18,13,7,1,7,12,18,12,3,248,12,35,14,43,43,
14,33,14,251,229,4,10,12,13,7,25,0,0,1,0,50,
0,0,4,176,4,236,0,51,0,88,184,0,52,47,184,0,
53,47,184,0,52,16,184,0,46,208,184,0,46,47,185,0,
5,0,4,252,184,0,53,16,184,0,25,220,185,0,16,0,
4,252,184,0,35,208,186,0,36,0,46,0,25,17,18,57,
0,184,0,0,69,88,184,0,30,47,27,185,0,30,0,5,
62,89,187,0,10,0,2,0,41,0,4,43,184,0,10,16,
48,49,1,21,14,1,21,17,30,3,51,50,62,2,55,17,
52,38,39,53,33,21,14,1,21,17,20,22,23,21,33,53,
62,1,53,17,14,3,35,34,46,2,39,17,52,38,39,53,
1,244,68,77,1,36,57,74,40,25,64,81,100,62,72,73,
1,194,68,77,73,72,254,62,68,77,62,108,99,93,47,43,
101,87,59,1,73,72,4,236,43,14,33,14,254,198,77,101,
60,25,9,33,65,57,1,157,12,35,14,43,43,14,33,14,
251,229,12,36,14,43,43,14,34,14,2,8,55,72,42,16,
26,68,119,92,1,155,12,35,14,43,0,1,0,50,0,0,
6,144,4,236,0,63,0,160,184,0,64,47,184,0,14,208,
184,0,14,47,184,0,36,220,65,3,0,63,0,36,0,1,
93,65,3,0,111,0,36,0,1,93,65,3,0,112,0,36,
0,1,93,65,3,0,0,0,36,0,1,93,184,0,58,220,
65,3,0,63,0,58,0,1,93,65,3,0,111,0,58,0,
1,93,65,3,0,0,0,58,0,1,93,65,3,0,112,0,
58,0,1,93,185,0,5,0,4,252,184,0,14,16,185,0,
25,0,4,252,184,0,36,16,185,0,47,0,4,252,184,0,
5,16,184,0,65,220,0,184,0,0,69,88,184,0,9,47,
27,185,0,9,0,5,62,89,185,0,30,0,2,252,184,0,
52,208,184,0,53,208,48,49,1,21,14,1,21,17,20,22,
23,21,33,53,62,1,53,17,52,38,39,53,33,21,14,1,
21,17,20,30,2,59,1,62,3,53,17,52,38,39,53,33,
21,14,1,21,17,20,30,2,59,1,62,3,53,17,52,38,
39,53,6,144,68,77,73,72,249,162,69,76,72,73,1,194,
68,77,8,30,57,50,146,47,55,29,8,72,73,1,194,68,
77,8,30,57,50,146,47,55,29,8,72,73,4,236,43,14,
33,14,251,229,12,36,14,43,43,14,34,14,4,27,12,35,
14,43,43,14,33,14,252,8,12,18,13,7,1,7,12,18,
12,3,248,12,35,14,43,43,14,33,14,252,8,12,18,13,
7,1,7,12,18,12,3,248,12,35,14,43,0,1,0,50,
254,231,6,164,4,236,0,77,0,172,184,0,78,47,184,0,
16,208,184,0,16,47,184,0,38,220,65,3,0,63,0,38,
0,1,93,65,3,0,111,0,38,0,1,93,65,3,0,112,
0,38,0,1,93,65,3,0,0,0,38,0,1,93,184,0,
60,220,65,3,0,63,0,60,0,1,93,65,3,0,111,0,
60,0,1,93,65,3,0,0,0,60,0,1,93,65,3,0,
112,0,60,0,1,93,185,0,71,0,4,252,184,0,11,208,
184,0,11,47,184,0,16,16,185,0,27,0,4,252,184,0,
38,16,185,0,49,0,4,252,184,0,71,16,184,0,79,220,
0,184,0,5,47,184,0,0,69,88,184,0,11,47,27,185,
0,11,0,5,62,89,185,0,32,0,2,252,184,0,54,208,
184,0,55,208,48,49,37,14,3,7,35,46,3,35,33,53,
62,1,53,17,52,38,39,53,33,21,14,1,21,17,20,30,
2,59,1,62,3,53,17,52,38,39,53,33,21,14,1,21,
17,30,3,59,1,62,3,53,17,52,38,39,53,33,21,14,
1,21,17,20,30,2,31,1,6,164,2,10,15,17,7,48,
3,8,15,24,19,250,54,69,76,72,73,1,194,68,77,8,
30,57,50,146,47,55,29,8,72,73,1,195,68,78,1,9,
30,57,48,146,47,55,29,8,72,73,1,194,68,77,4,26,
54,50,31,34,26,83,91,87,28,64,103,74,40,43,14,34,
14,4,27,12,35,14,43,43,14,33,14,252,8,12,18,13,
7,1,7,12,18,12,3,248,12,35,14,43,43,14,33,14,
252,8,11,19,13,7,1,7,12,18,12,3,248,12,35,14,
43,43,14,33,14,251,229,3,10,12,14,7,25,0,0,2,
0,50,255,242,5,73,4,236,0,20,0,66,1,57,184,0,
67,47,184,0,68,47,184,0,67,16,184,0,38,208,184,0,
38,47,185,0,4,0,4,252,184,0,6,208,184,0,6,47,
184,0,68,16,184,0,21,220,185,0,16,0,4,252,65,5,
0,154,0,16,0,170,0,16,0,2,93,65,19,0,9,0,
16,0,25,0,16,0,41,0,16,0,57,0,16,0,73,0,
16,0,89,0,16,0,105,0,16,0,121,0,16,0,137,0,
16,0,9,93,184,0,4,16,184,0,58,208,0,184,0,0,
69,88,184,0,51,47,27,185,0,51,0,11,62,89,184,0,
0,69,88,184,0,26,47,27,185,0,26,0,5,62,89,184,
0,0,69,88,184,0,33,47,27,185,0,33,0,5,62,89,
187,0,62,0,2,0,0,0,4,43,184,0,62,16,184,0,
26,16,185,0,11,0,2,252,65,33,0,7,0,11,0,23,
0,11,0,39,0,11,0,55,0,11,0,71,0,11,0,87,
0,11,0,103,0,11,0,119,0,11,0,135,0,11,0,151,
0,11,0,167,0,11,0,183,0,11,0,199,0,11,0,215,
0,11,0,231,0,11,0,247,0,11,0,16,93,65,15,0,
7,0,11,0,23,0,11,0,39,0,11,0,55,0,11,0,
71,0,11,0,87,0,11,0,103,0,11,0,7,113,65,5,
0,118,0,11,0,134,0,11,0,2,113,184,0,51,16,185,
0,39,0,2,252,48,49,1,34,6,7,17,20,23,30,3,
51,50,62,2,53,52,46,2,1,20,14,2,35,34,46,4,
49,35,53,62,1,53,17,33,34,14,2,7,39,62,3,55,
33,21,14,3,21,17,62,1,51,50,30,2,3,89,48,81,
36,9,17,44,46,46,20,72,116,83,44,39,81,125,1,153,
67,121,168,101,29,88,96,97,78,48,73,68,77,254,219,19,
32,33,37,25,43,1,8,11,14,6,3,9,34,63,49,29,
45,104,55,109,171,116,61,2,137,8,6,253,237,8,7,6,
7,4,2,37,66,93,56,55,116,95,61,254,219,85,137,96,
52,2,3,4,3,2,43,14,33,14,4,42,19,54,96,78,
19,29,87,92,84,26,43,7,16,16,16,7,254,77,9,10,
56,102,141,0,0,3,0,50,255,242,5,210,4,236,0,19,
0,40,0,78,1,83,187,0,24,0,4,0,58,0,4,43,
184,0,24,16,187,0,41,0,4,0,36,0,4,43,184,0,
41,16,187,0,15,0,4,0,4,0,4,43,184,0,15,16,
65,5,0,154,0,36,0,170,0,36,0,2,93,65,19,0,
9,0,36,0,25,0,36,0,41,0,36,0,57,0,36,0,
73,0,36,0,89,0,36,0,105,0,36,0,121,0,36,0,
137,0,36,0,9,93,184,0,24,16,184,0,70,208,184,0,
15,16,184,0,80,220,0,184,0,0,69,88,184,0,9,47,
27,185,0,9,0,11,62,89,184,0,0,69,88,184,0,63,
47,27,185,0,63,0,11,62,89,184,0,0,69,88,184,0,
46,47,27,185,0,46,0,5,62,89,184,0,0,69,88,184,
0,0,47,27,185,0,0,0,5,62,89,184,0,0,69,88,
184,0,53,47,27,185,0,53,0,5,62,89,187,0,74,0,
2,0,20,0,4,43,184,0,74,16,184,0,46,16,185,0,
31,0,2,252,65,33,0,7,0,31,0,23,0,31,0,39,
0,31,0,55,0,31,0,71,0,31,0,87,0,31,0,103,
0,31,0,119,0,31,0,135,0,31,0,151,0,31,0,167,
0,31,0,183,0,31,0,199,0,31,0,215,0,31,0,231,
0,31,0,247,0,31,0,16,93,65,15,0,7,0,31,0,
23,0,31,0,39,0,31,0,55,0,31,0,71,0,31,0,
87,0,31,0,103,0,31,0,7,113,65,5,0,118,0,31,
0,134,0,31,0,2,113,48,49,33,53,62,1,53,17,52,
38,39,53,33,21,14,1,21,17,20,22,23,21,1,34,6,
7,17,20,23,30,3,51,50,62,2,53,52,46,2,1,20,
14,2,35,34,46,4,49,35,53,62,1,53,17,52,38,39,
53,33,21,14,3,21,17,62,1,51,50,30,2,4,16,68,
77,73,72,1,194,68,77,73,72,252,54,48,81,36,9,17,
44,46,46,20,72,116,83,44,39,81,125,1,153,67,121,168,
101,29,88,96,97,78,48,73,68,77,73,72,1,224,34,63,
49,29,45,104,55,109,171,116,61,43,14,33,14,4,27,12,
36,14,43,43,14,34,14,251,229,12,35,14,43,2,137,8,
6,253,237,8,7,6,7,4,2,37,66,93,56,55,116,95,
61,254,219,85,137,96,52,2,3,4,3,2,43,14,33,14,
4,27,12,36,14,43,43,7,16,16,16,7,254,77,9,10,
56,102,141,0,0,2,0,50,255,242,3,248,4,236,0,20,
0,58,1,47,184,0,59,47,184,0,60,47,184,0,59,16,
184,0,38,208,184,0,38,47,185,0,4,0,4,252,184,0,
6,208,184,0,6,47,184,0,60,16,184,0,21,220,185,0,
16,0,4,252,65,5,0,154,0,16,0,170,0,16,0,2,
93,65,19,0,9,0,16,0,25,0,16,0,41,0,16,0,
57,0,16,0,73,0,16,0,89,0,16,0,105,0,16,0,
121,0,16,0,137,0,16,0,9,93,184,0,4,16,184,0,
50,208,0,184,0,0,69,88,184,0,43,47,27,185,0,43,
0,11,62,89,184,0,0,69,88,184,0,26,47,27,185,0,
26,0,5,62,89,184,0,0,69,88,184,0,33,47,27,185,
0,33,0,5,62,89,187,0,54,0,2,0,0,0,4,43,
184,0,54,16,184,0,26,16,185,0,11,0,2,252,65,33,
0,7,0,11,0,23,0,11,0,39,0,11,0,55,0,11,
0,71,0,11,0,87,0,11,0,103,0,11,0,119,0,11,
0,135,0,11,0,151,0,11,0,167,0,11,0,183,0,11,
0,199,0,11,0,215,0,11,0,231,0,11,0,247,0,11,
0,16,93,65,15,0,7,0,11,0,23,0,11,0,39,0,
11,0,55,0,11,0,71,0,11,0,87,0,11,0,103,0,
11,0,7,113,65,5,0,118,0,11,0,134,0,11,0,2,
113,48,49,1,34,6,7,17,20,23,30,3,51,50,62,2,
53,52,46,2,1,20,14,2,35,34,46,4,49,35,53,62,
1,53,17,52,38,39,53,33,21,14,3,21,17,62,1,51,
50,30,2,2,8,48,81,36,9,17,44,46,46,20,72,116,
83,44,39,81,125,1,153,67,121,168,101,29,88,96,97,78,
48,73,68,77,73,72,1,224,34,63,49,29,45,104,55,109,
171,116,61,2,137,8,6,253,237,8,7,6,7,4,2,37,
66,93,56,55,116,95,61,254,219,85,137,96,52,2,3,4,
3,2,43,14,33,14,4,27,12,36,14,43,43,7,16,16,
16,7,254,77,9,10,56,102,141,0,0,1,0,54,255,226,
3,250,5,10,0,68,1,67,187,0,0,0,4,0,24,0,
4,43,184,0,24,16,184,0,40,208,184,0,40,47,0,184,
0,0,69,88,184,0,64,47,27,185,0,64,0,11,62,89,
184,0,0,69,88,184,0,5,47,27,185,0,5,0,5,62,
89,187,0,40,0,2,0,24,0,4,43,184,0,40,16,184,
0,5,16,185,0,18,0,2,252,65,33,0,7,0,18,0,
23,0,18,0,39,0,18,0,55,0,18,0,71,0,18,0,
87,0,18,0,103,0,18,0,119,0,18,0,135,0,18,0,
151,0,18,0,167,0,18,0,183,0,18,0,199,0,18,0,
215,0,18,0,231,0,18,0,247,0,18,0,16,93,65,15,
0,7,0,18,0,23,0,18,0,39,0,18,0,55,0,18,
0,71,0,18,0,87,0,18,0,103,0,18,0,7,113,65,
5,0,118,0,18,0,134,0,18,0,2,113,184,0,64,16,
185,0,45,0,2,252,65,5,0,121,0,45,0,137,0,45,
0,2,113,65,33,0,8,0,45,0,24,0,45,0,40,0,
45,0,56,0,45,0,72,0,45,0,88,0,45,0,104,0,
45,0,120,0,45,0,136,0,45,0,152,0,45,0,168,0,
45,0,184,0,45,0,200,0,45,0,216,0,45,0,232,0,
45,0,248,0,45,0,16,93,65,15,0,8,0,45,0,24,
0,45,0,40,0,45,0,56,0,45,0,72,0,45,0,88,
0,45,0,104,0,45,0,7,113,48,49,1,20,14,2,35,
34,46,2,53,52,62,2,55,30,1,51,50,62,2,61,1,
33,34,14,2,7,39,62,3,55,30,1,51,33,46,3,35,
34,14,2,15,1,46,4,53,52,55,62,3,51,50,30,2,
3,250,85,152,207,123,101,150,98,48,30,44,47,18,45,156,
102,70,132,102,62,254,234,41,81,75,66,25,22,2,13,16,
16,5,54,124,62,1,35,11,70,108,142,82,22,83,88,76,
15,43,3,8,7,6,3,2,45,105,111,110,51,112,186,133,
73,2,146,158,254,179,97,45,65,69,24,10,34,34,29,5,
101,100,51,123,207,156,4,4,8,14,9,25,7,34,37,34,
8,12,8,112,176,123,65,19,54,98,79,8,1,38,56,64,
55,19,19,1,25,38,27,14,89,164,234,0,0,2,0,70,
255,226,6,152,5,10,0,21,0,65,1,203,187,0,35,0,
4,0,44,0,4,43,184,0,35,16,187,0,12,0,4,0,
33,0,4,43,184,0,12,16,187,0,22,0,4,0,0,0,
4,43,184,0,22,16,65,5,0,154,0,0,0,170,0,0,
0,2,93,65,19,0,9,0,0,0,25,0,0,0,41,0,
0,0,57,0,0,0,73,0,0,0,89,0,0,0,105,0,
0,0,121,0,0,0,137,0,0,0,9,93,184,0,35,16,
184,0,54,208,184,0,33,16,184,0,56,208,184,0,56,47,
184,0,22,16,184,0,67,220,0,184,0,0,69,88,184,0,
49,47,27,185,0,49,0,11,62,89,184,0,0,69,88,184,
0,61,47,27,185,0,61,0,11,62,89,184,0,0,69,88,
184,0,39,47,27,185,0,39,0,5,62,89,184,0,0,69,
88,184,0,27,47,27,185,0,27,0,5,62,89,187,0,56,
0,2,0,33,0,4,43,184,0,56,16,184,0,61,16,185,
0,7,0,2,252,65,5,0,121,0,7,0,137,0,7,0,
2,113,65,33,0,8,0,7,0,24,0,7,0,40,0,7,
0,56,0,7,0,72,0,7,0,88,0,7,0,104,0,7,
0,120,0,7,0,136,0,7,0,152,0,7,0,168,0,7,
0,184,0,7,0,200,0,7,0,216,0,7,0,232,0,7,
0,248,0,7,0,16,93,65,15,0,8,0,7,0,24,0,
7,0,40,0,7,0,56,0,7,0,72,0,7,0,88,0,
7,0,104,0,7,0,7,113,184,0,27,16,185,0,17,0,
2,252,65,33,0,7,0,17,0,23,0,17,0,39,0,17,
0,55,0,17,0,71,0,17,0,87,0,17,0,103,0,17,
0,119,0,17,0,135,0,17,0,151,0,17,0,167,0,17,
0,183,0,17,0,199,0,17,0,215,0,17,0,231,0,17,
0,247,0,17,0,16,93,65,15,0,7,0,17,0,23,0,
17,0,39,0,17,0,55,0,17,0,71,0,17,0,87,0,
17,0,103,0,17,0,7,113,65,5,0,118,0,17,0,134,
0,17,0,2,113,48,49,1,52,46,4,35,34,14,2,21,
20,30,2,51,50,62,2,55,20,14,2,35,34,46,2,61,
1,35,17,20,22,23,21,33,53,62,1,53,17,52,38,39,
53,33,21,14,1,21,17,51,62,3,51,50,30,2,5,253,
25,46,67,84,100,57,89,141,97,52,61,103,138,77,83,139,
101,56,155,90,155,204,114,120,188,129,68,245,73,72,254,62,
68,77,73,72,1,194,68,77,250,14,97,149,190,108,124,188,
128,65,2,117,69,135,121,104,75,43,76,139,198,122,112,200,
151,88,69,136,202,150,136,245,186,110,106,178,232,126,3,254,
1,12,35,14,43,43,14,33,14,4,27,12,36,14,43,43,
14,34,14,254,62,121,213,159,92,109,180,232,0,2,0,10,
255,241,4,84,5,10,0,56,0,74,1,119,184,0,75,47,
184,0,76,47,184,0,52,220,185,0,4,0,4,252,184,0,
75,16,184,0,39,208,184,0,39,47,185,0,62,0,4,252,
65,19,0,6,0,62,0,22,0,62,0,38,0,62,0,54,
0,62,0,70,0,62,0,86,0,62,0,102,0,62,0,118,
0,62,0,134,0,62,0,9,93,65,5,0,149,0,62,0,
165,0,62,0,2,93,184,0,13,208,184,0,13,47,184,0,
39,16,184,0,27,208,184,0,27,47,186,0,34,0,39,0,
52,17,18,57,184,0,4,16,184,0,72,208,0,184,0,0,
69,88,184,0,44,47,27,185,0,44,0,11,62,89,184,0,
0,69,88,184,0,18,47,27,185,0,18,0,5,62,89,184,
0,0,69,88,184,0,0,47,27,185,0,0,0,5,62,89,
187,0,70,0,2,0,6,0,4,43,184,0,70,16,186,0,
34,0,6,0,70,17,18,57,184,0,44,16,185,0,57,0,
2,252,65,5,0,121,0,57,0,137,0,57,0,2,113,65,
33,0,8,0,57,0,24,0,57,0,40,0,57,0,56,0,
57,0,72,0,57,0,88,0,57,0,104,0,57,0,120,0,
57,0,136,0,57,0,152,0,57,0,168,0,57,0,184,0,
57,0,200,0,57,0,216,0,57,0,232,0,57,0,248,0,
57,0,16,93,65,15,0,8,0,57,0,24,0,57,0,40,
0,57,0,56,0,57,0,72,0,57,0,88,0,57,0,104,
0,57,0,7,113,184,0,70,16,184,0,65,208,184,0,65,
47,184,0,70,16,184,0,67,208,184,0,70,16,184,0,72,
208,184,0,72,47,184,0,57,16,184,0,73,208,184,0,73,
47,48,49,33,53,62,1,53,17,35,38,14,4,7,14,3,
35,34,38,39,55,22,62,2,55,62,5,55,46,3,53,52,
62,2,51,50,22,23,7,46,1,39,17,20,22,23,21,1,
34,14,2,21,20,22,23,54,51,50,59,1,54,55,17,38,
2,137,73,72,95,54,82,64,49,43,38,21,12,26,30,38,
24,14,115,79,8,41,57,42,32,16,16,31,34,40,51,64,
42,62,104,74,41,60,125,191,131,110,194,94,9,38,72,35,
77,68,254,130,93,136,88,43,166,153,7,6,6,8,41,21,
29,39,43,14,35,12,1,235,3,57,94,121,122,111,37,22,
27,16,6,21,17,58,4,2,15,30,24,25,72,85,91,88,
79,30,14,50,78,107,70,64,127,100,62,37,23,62,5,11,
5,251,195,14,33,14,43,4,182,37,66,92,55,127,139,6,
1,1,5,2,0,3,0,2,0,80,255,226,3,158,3,192,
0,14,0,70,1,164,184,0,71,47,184,0,72,47,184,0,
63,220,185,0,21,0,4,252,184,0,3,208,184,0,71,16,
184,0,31,208,184,0,31,47,185,0,10,0,4,252,65,19,
0,6,0,10,0,22,0,10,0,38,0,10,0,54,0,10,
0,70,0,10,0,86,0,10,0,102,0,10,0,118,0,10,
0,134,0,10,0,9,93,65,5,0,149,0,10,0,165,0,
10,0,2,93,184,0,21,16,184,0,37,208,0,184,0,0,
69,88,184,0,59,47,27,185,0,59,0,9,62,89,184,0,
0,69,88,184,0,18,47,27,185,0,18,0,5,62,89,184,
0,0,69,88,184,0,26,47,27,185,0,26,0,5,62,89,
185,0,0,0,2,252,65,33,0,7,0,0,0,23,0,0,
0,39,0,0,0,55,0,0,0,71,0,0,0,87,0,0,
0,103,0,0,0,119,0,0,0,135,0,0,0,151,0,0,
0,167,0,0,0,183,0,0,0,199,0,0,0,215,0,0,
0,231,0,0,0,247,0,0,0,16,93,65,15,0,7,0,
0,0,23,0,0,0,39,0,0,0,55,0,0,0,71,0,
0,0,87,0,0,0,103,0,0,0,7,113,65,5,0,118,
0,0,0,134,0,0,0,2,113,186,0,21,0,18,0,59,
17,18,57,184,0,59,16,185,0,43,0,2,252,65,5,0,
121,0,43,0,137,0,43,0,2,113,65,33,0,8,0,43,
0,24,0,43,0,40,0,43,0,56,0,43,0,72,0,43,
0,88,0,43,0,104,0,43,0,120,0,43,0,136,0,43,
0,152,0,43,0,168,0,43,0,184,0,43,0,200,0,43,
0,216,0,43,0,232,0,43,0,248,0,43,0,16,93,65,
15,0,8,0,43,0,24,0,43,0,40,0,43,0,56,0,
43,0,72,0,43,0,88,0,43,0,104,0,43,0,7,113,
184,0,0,16,184,0,66,208,48,49,37,50,54,55,17,7,
14,3,21,20,30,2,5,14,1,35,34,38,39,14,3,35,
34,46,2,53,52,62,2,63,1,53,52,46,2,7,14,3,
23,22,14,2,47,1,62,3,51,50,22,21,17,20,22,51,
50,54,55,23,1,96,60,135,76,119,68,99,64,30,24,35,
37,2,75,85,111,28,33,44,2,45,90,86,77,32,36,76,
61,40,43,85,126,84,205,16,38,65,49,32,62,46,26,3,
1,43,59,57,12,14,23,94,121,135,63,110,119,22,18,14,
44,40,15,100,61,66,1,5,23,12,46,62,75,41,40,50,
29,10,18,59,53,92,81,45,66,42,20,24,52,82,58,59,
107,88,65,17,41,139,34,59,43,23,1,1,20,36,49,30,
9,23,18,10,3,39,50,92,70,42,115,103,253,204,42,36,
10,17,45,0,0,2,0,90,255,226,3,153,6,13,0,19,
0,66,1,121,187,0,5,0,4,0,47,0,4,43,184,0,
5,16,65,19,0,6,0,5,0,22,0,5,0,38,0,5,
0,54,0,5,0,70,0,5,0,86,0,5,0,102,0,5,
0,118,0,5,0,134,0,5,0,9,93,65,5,0,149,0,
5,0,165,0,5,0,2,93,184,0,27,208,184,0,27,47,
0,184,0,59,47,184,0,0,69,88,184,0,32,47,27,185,
0,32,0,9,62,89,184,0,0,69,88,184,0,42,47,27,
185,0,42,0,5,62,89,184,0,32,16,185,0,0,0,2,
252,65,5,0,121,0,0,0,137,0,0,0,2,113,65,33,
0,8,0,0,0,24,0,0,0,40,0,0,0,56,0,0,
0,72,0,0,0,88,0,0,0,104,0,0,0,120,0,0,
0,136,0,0,0,152,0,0,0,168,0,0,0,184,0,0,
0,200,0,0,0,216,0,0,0,232,0,0,0,248,0,0,
0,16,93,65,15,0,8,0,0,0,24,0,0,0,40,0,
0,0,56,0,0,0,72,0,0,0,88,0,0,0,104,0,
0,0,7,113,184,0,42,16,185,0,10,0,2,252,65,33,
0,7,0,10,0,23,0,10,0,39,0,10,0,55,0,10,
0,71,0,10,0,87,0,10,0,103,0,10,0,119,0,10,
0,135,0,10,0,151,0,10,0,167,0,10,0,183,0,10,
0,199,0,10,0,215,0,10,0,231,0,10,0,247,0,10,
0,16,93,65,15,0,7,0,10,0,23,0,10,0,39,0,
10,0,55,0,10,0,71,0,10,0,87,0,10,0,103,0,
10,0,7,113,65,5,0,118,0,10,0,134,0,10,0,2,
113,186,0,27,0,42,0,59,17,18,57,48,49,1,34,14,
2,21,20,30,2,51,50,62,2,53,52,46,2,19,14,5,
7,62,3,51,50,30,2,21,20,14,2,35,34,46,2,53,
52,62,4,55,62,3,55,30,1,23,14,3,1,250,62,98,
67,35,53,82,99,47,71,93,56,22,43,72,94,29,66,98,
73,50,34,23,9,34,79,80,77,32,94,143,98,50,64,114,
156,91,94,151,105,56,41,70,93,105,111,53,64,89,60,35,
10,10,22,8,9,24,55,101,3,67,54,88,115,62,92,159,
117,68,55,98,135,80,77,140,107,63,1,74,17,36,44,57,
76,98,63,44,65,42,21,72,126,171,99,96,183,143,86,76,
147,215,140,116,198,165,131,97,63,14,17,41,52,65,42,3,
10,5,64,113,95,72,0,3,0,48,255,246,3,131,3,192,
0,15,0,34,0,71,1,248,187,0,20,0,4,0,51,0,
4,43,184,0,20,16,187,0,64,0,4,0,11,0,4,43,
184,0,64,16,184,0,20,16,184,0,4,208,65,5,0,154,
0,11,0,170,0,11,0,2,93,65,19,0,9,0,11,0,
25,0,11,0,41,0,11,0,57,0,11,0,73,0,11,0,
89,0,11,0,105,0,11,0,121,0,11,0,137,0,11,0,
9,93,186,0,30,0,11,0,64,17,18,57,184,0,30,47,
65,5,0,154,0,30,0,170,0,30,0,2,93,65,19,0,
9,0,30,0,25,0,30,0,41,0,30,0,57,0,30,0,
73,0,30,0,89,0,30,0,105,0,30,0,121,0,30,0,
137,0,30,0,9,93,185,0,35,0,4,252,186,0,67,0,
51,0,35,17,18,57,184,0,73,220,0,184,0,0,69,88,
184,0,61,47,27,185,0,61,0,9,62,89,184,0,0,69,
88,184,0,40,47,27,185,0,40,0,5,62,89,184,0,0,
69,88,184,0,46,47,27,185,0,46,0,5,62,89,184,0,
61,16,185,0,0,0,2,252,65,5,0,121,0,0,0,137,
0,0,0,2,113,65,33,0,8,0,0,0,24,0,0,0,
40,0,0,0,56,0,0,0,72,0,0,0,88,0,0,0,
104,0,0,0,120,0,0,0,136,0,0,0,152,0,0,0,
168,0,0,0,184,0,0,0,200,0,0,0,216,0,0,0,
232,0,0,0,248,0,0,0,16,93,65,15,0,8,0,0,
0,24,0,0,0,40,0,0,0,56,0,0,0,72,0,0,
0,88,0,0,0,104,0,0,0,7,113,184,0,2,208,184,
0,4,208,184,0,4,47,184,0,40,16,185,0,25,0,2,
252,65,33,0,7,0,25,0,23,0,25,0,39,0,25,0,
55,0,25,0,71,0,25,0,87,0,25,0,103,0,25,0,
119,0,25,0,135,0,25,0,151,0,25,0,167,0,25,0,
183,0,25,0,199,0,25,0,215,0,25,0,231,0,25,0,
247,0,25,0,16,93,65,15,0,7,0,25,0,23,0,25,
0,39,0,25,0,55,0,25,0,71,0,25,0,87,0,25,
0,103,0,25,0,7,113,65,5,0,118,0,25,0,134,0,
25,0,2,113,186,0,67,0,40,0,61,17,18,57,48,49,
1,34,35,34,7,17,51,50,62,2,53,52,46,2,19,34,
6,7,17,20,23,30,1,51,50,62,2,53,52,46,2,5,
20,14,2,35,34,46,3,43,1,53,62,1,53,17,14,1,
7,39,62,3,51,50,22,21,20,6,7,30,3,1,120,8,
8,7,8,10,94,116,65,23,27,64,106,8,37,57,25,2,
25,71,35,59,96,67,37,32,66,103,1,107,52,102,150,99,
29,92,96,89,52,2,81,68,72,38,71,30,8,33,91,102,
103,44,190,196,80,92,63,99,67,35,3,112,1,254,189,28,
46,60,32,37,59,40,22,254,105,5,5,254,153,2,6,14,
12,22,42,64,42,41,83,67,42,208,63,102,72,38,2,3,
3,2,43,14,33,14,2,251,5,10,5,68,8,16,13,8,
107,94,81,105,36,11,49,70,90,0,0,1,0,55,0,0,
3,60,3,162,0,34,0,40,187,0,28,0,4,0,6,0,
4,43,184,0,28,16,0,184,0,0,69,88,184,0,13,47,
27,185,0,13,0,9,62,89,185,0,26,0,2,252,48,49,
51,53,62,3,53,17,52,46,2,39,53,33,23,14,3,7,
35,46,3,35,33,17,20,30,2,23,21,55,28,50,39,23,
21,38,51,30,2,234,27,2,9,12,14,6,47,3,13,19,
26,16,254,196,16,40,65,50,43,5,14,16,19,11,2,211,
4,15,16,16,5,43,18,19,80,88,82,21,47,80,58,33,
253,36,10,17,16,15,7,43,0,2,0,36,255,7,4,35,
3,162,0,24,0,99,0,211,184,0,100,47,184,0,101,47,
184,0,100,16,184,0,42,208,184,0,42,47,184,0,3,208,
184,0,3,47,184,0,42,16,185,0,20,0,3,252,65,19,
0,6,0,20,0,22,0,20,0,38,0,20,0,54,0,20,
0,70,0,20,0,86,0,20,0,102,0,20,0,118,0,20,
0,134,0,20,0,9,93,65,5,0,149,0,20,0,165,0,
20,0,2,93,184,0,6,208,184,0,6,47,184,0,101,16,
184,0,75,220,185,0,10,0,4,252,184,0,75,16,184,0,
67,208,184,0,67,47,184,0,75,16,184,0,70,208,184,0,
70,47,184,0,75,16,184,0,72,208,184,0,75,16,184,0,
77,208,184,0,77,47,0,184,0,0,69,88,184,0,48,47,
27,185,0,48,0,9,62,89,184,0,0,69,88,184,0,92,
47,27,185,0,92,0,5,62,89,185,0,6,0,2,252,184,
0,48,16,185,0,16,0,2,252,48,49,37,14,1,7,30,
1,59,1,62,1,55,17,52,46,2,43,1,14,1,7,14,
3,1,52,62,4,55,62,3,55,62,3,55,46,3,39,53,
33,21,6,7,6,35,34,7,6,7,6,7,6,15,1,6,
7,6,7,14,1,7,6,7,29,1,17,20,23,30,1,31,
1,14,3,7,35,46,3,39,33,34,14,2,7,35,1,106,
11,20,11,6,48,54,237,51,36,2,10,26,47,36,116,36,
39,8,6,13,17,22,254,170,1,2,4,5,6,4,16,49,
53,51,20,13,26,22,17,4,5,33,47,60,32,3,124,8,
12,2,1,1,2,17,17,4,6,7,7,9,22,10,2,4,
2,1,2,2,2,4,9,62,54,26,2,9,12,14,6,47,
2,13,20,27,15,253,100,16,38,39,36,12,47,222,40,60,
23,9,10,1,16,15,2,192,8,12,9,5,1,8,8,97,
168,150,134,253,236,14,48,58,61,56,46,13,8,36,60,87,
59,40,114,137,158,84,6,14,15,15,6,43,43,2,2,1,
1,4,5,1,2,1,4,3,8,8,1,4,1,2,1,3,
4,2,1,253,46,5,5,11,22,8,19,19,77,86,80,21,
47,88,68,43,3,37,66,91,54,0,0,2,0,80,255,226,
3,98,3,192,0,15,0,60,1,121,187,0,21,0,4,0,
44,0,4,43,184,0,21,16,65,19,0,6,0,21,0,22,
0,21,0,38,0,21,0,54,0,21,0,70,0,21,0,86,
0,21,0,102,0,21,0,118,0,21,0,134,0,21,0,9,
93,65,5,0,149,0,21,0,165,0,21,0,2,93,184,0,
5,208,184,0,5,47,0,184,0,0,69,88,184,0,54,47,
27,185,0,54,0,9,62,89,184,0,0,69,88,184,0,39,
47,27,185,0,39,0,5,62,89,187,0,6,0,2,0,19,
0,4,43,184,0,6,16,184,0,54,16,185,0,0,0,2,
252,65,5,0,121,0,0,0,137,0,0,0,2,113,65,33,
0,8,0,0,0,24,0,0,0,40,0,0,0,56,0,0,
0,72,0,0,0,88,0,0,0,104,0,0,0,120,0,0,
0,136,0,0,0,152,0,0,0,168,0,0,0,184,0,0,
0,200,0,0,0,216,0,0,0,232,0,0,0,248,0,0,
0,16,93,65,15,0,8,0,0,0,24,0,0,0,40,0,
0,0,56,0,0,0,72,0,0,0,88,0,0,0,104,0,
0,0,7,113,184,0,39,16,185,0,26,0,2,252,65,33,
0,7,0,26,0,23,0,26,0,39,0,26,0,55,0,26,
0,71,0,26,0,87,0,26,0,103,0,26,0,119,0,26,
0,135,0,26,0,151,0,26,0,167,0,26,0,183,0,26,
0,199,0,26,0,215,0,26,0,231,0,26,0,247,0,26,
0,16,93,65,15,0,7,0,26,0,23,0,26,0,39,0,
26,0,55,0,26,0,71,0,26,0,87,0,26,0,103,0,
26,0,7,113,65,5,0,118,0,26,0,134,0,26,0,2,
113,48,49,1,34,14,2,7,33,50,54,53,52,46,4,1,
14,1,7,33,21,20,30,2,51,50,62,2,55,30,1,23,
14,3,35,34,46,2,53,52,62,2,55,62,3,51,50,30,
4,1,240,51,86,67,45,10,1,171,23,15,6,17,29,46,
65,1,71,18,60,32,253,242,41,76,110,69,31,59,68,83,
56,13,19,5,67,101,89,87,51,77,139,106,63,30,57,82,
52,22,55,60,59,27,66,101,76,52,33,14,3,88,40,72,
102,62,15,21,18,50,53,52,41,26,254,213,20,34,13,3,
75,139,107,64,7,27,54,46,7,26,8,73,89,48,15,66,
121,171,106,67,130,116,98,36,15,29,22,13,36,61,81,90,
93,0,0,1,0,20,255,241,5,168,3,182,0,139,1,74,
187,0,63,0,4,0,74,0,4,43,184,0,63,16,184,0,
4,208,184,0,63,16,184,0,60,208,184,0,74,16,184,0,
130,208,184,0,74,16,184,0,132,208,0,184,0,0,69,88,
184,0,0,47,27,185,0,0,0,9,62,89,184,0,0,69,
88,184,0,12,47,27,185,0,12,0,9,62,89,184,0,0,
69,88,184,0,121,47,27,185,0,121,0,9,62,89,184,0,
0,69,88,184,0,47,47,27,185,0,47,0,5,62,89,184,
0,0,69,88,184,0,88,47,27,185,0,88,0,5,62,89,
184,0,0,69,88,184,0,69,47,27,185,0,69,0,5,62,
89,187,0,5,0,2,0,60,0,4,43,184,0,5,16,184,
0,12,16,185,0,22,0,2,252,65,5,0,121,0,22,0,
137,0,22,0,2,113,65,33,0,8,0,22,0,24,0,22,
0,40,0,22,0,56,0,22,0,72,0,22,0,88,0,22,
0,104,0,22,0,120,0,22,0,136,0,22,0,152,0,22,
0,168,0,22,0,184,0,22,0,200,0,22,0,216,0,22,
0,232,0,22,0,248,0,22,0,16,93,65,15,0,8,0,
22,0,24,0,22,0,40,0,22,0,56,0,22,0,72,0,
22,0,88,0,22,0,104,0,22,0,7,113,186,0,29,0,
60,0,5,17,18,57,184,0,60,16,184,0,75,208,186,0,
104,0,60,0,5,17,18,57,184,0,22,16,184,0,111,208,
184,0,5,16,184,0,130,208,48,49,1,21,14,1,21,17,
62,5,51,50,22,23,22,6,7,39,46,1,35,34,14,4,
7,30,5,23,30,3,55,23,14,3,35,34,46,2,39,46,
5,7,35,29,2,20,30,2,23,21,33,53,62,1,53,17,
35,38,14,4,7,14,3,35,34,46,2,39,55,22,62,2,
55,62,3,55,46,5,35,34,6,15,1,46,1,55,62,1,
51,50,30,6,23,61,2,52,46,2,39,53,3,171,70,60,
60,85,67,58,69,89,64,33,46,29,13,28,32,37,17,39,
29,27,41,37,34,40,48,32,44,72,60,50,43,39,19,15,
22,28,39,30,6,29,57,49,39,10,17,25,21,20,12,23,
43,44,48,57,70,43,32,11,30,50,39,254,102,66,64,32,
44,69,57,48,44,43,23,12,20,21,25,17,11,38,49,57,
29,6,30,39,28,22,15,29,59,75,97,67,32,48,40,34,
37,41,27,29,39,17,37,32,28,13,29,46,33,48,73,58,
48,46,47,57,69,46,13,30,50,37,3,162,43,15,28,18,
254,216,3,64,93,108,91,61,21,24,11,99,68,10,45,28,
31,50,65,68,66,26,20,63,75,81,75,64,20,16,21,12,
4,3,43,6,10,8,4,6,13,20,14,27,81,91,90,72,
43,2,76,9,251,8,13,13,17,10,43,43,17,26,18,1,
80,2,43,72,90,91,82,26,14,20,13,6,4,8,10,6,
43,3,4,12,21,16,31,109,119,108,30,26,67,68,65,50,
31,28,45,10,68,99,11,24,21,35,58,74,78,75,60,38,
2,76,8,212,7,13,13,16,12,43,0,1,0,80,255,226,
3,27,3,192,0,80,1,201,187,0,36,0,4,0,8,0,
4,43,184,0,36,16,65,5,0,154,0,8,0,170,0,8,
0,2,93,65,19,0,9,0,8,0,25,0,8,0,41,0,
8,0,57,0,8,0,73,0,8,0,89,0,8,0,105,0,
8,0,121,0,8,0,137,0,8,0,9,93,186,0,69,0,
8,0,36,17,18,57,184,0,69,47,65,5,0,154,0,69,
0,170,0,69,0,2,93,65,19,0,9,0,69,0,25,0,
69,0,41,0,69,0,57,0,69,0,73,0,69,0,89,0,
69,0,105,0,69,0,121,0,69,0,137,0,69,0,9,93,
185,0,44,0,4,252,184,0,82,220,0,184,0,0,69,88,
184,0,31,47,27,185,0,31,0,9,62,89,184,0,0,69,
88,184,0,49,47,27,185,0,49,0,5,62,89,187,0,3,
0,2,0,74,0,4,43,184,0,3,16,184,0,31,16,185,
0,13,0,2,252,65,5,0,121,0,13,0,137,0,13,0,
2,113,65,33,0,8,0,13,0,24,0,13,0,40,0,13,
0,56,0,13,0,72,0,13,0,88,0,13,0,104,0,13,
0,120,0,13,0,136,0,13,0,152,0,13,0,168,0,13,
0,184,0,13,0,200,0,13,0,216,0,13,0,232,0,13,
0,248,0,13,0,16,93,65,15,0,8,0,13,0,24,0,
13,0,40,0,13,0,56,0,13,0,72,0,13,0,88,0,
13,0,104,0,13,0,7,113,186,0,39,0,74,0,3,17,
18,57,184,0,49,16,185,0,64,0,2,252,65,33,0,7,
0,64,0,23,0,64,0,39,0,64,0,55,0,64,0,71,
0,64,0,87,0,64,0,103,0,64,0,119,0,64,0,135,
0,64,0,151,0,64,0,167,0,64,0,183,0,64,0,199,
0,64,0,215,0,64,0,231,0,64,0,247,0,64,0,16,
93,65,15,0,7,0,64,0,23,0,64,0,39,0,64,0,
55,0,64,0,71,0,64,0,87,0,64,0,103,0,64,0,
7,113,65,5,0,118,0,64,0,134,0,64,0,2,113,48,
49,1,30,1,51,50,62,2,53,52,46,2,35,34,14,2,
15,1,46,4,54,55,62,3,51,50,30,2,21,20,6,7,
30,3,21,20,14,2,35,34,46,2,53,52,62,2,55,30,
3,51,50,62,2,53,52,46,2,35,34,14,2,7,39,1,
42,27,65,30,52,77,49,24,36,59,76,40,59,80,54,32,
10,42,5,8,6,4,2,2,2,44,99,98,89,35,42,96,
83,54,68,75,40,67,50,28,55,103,145,90,71,118,86,47,
32,46,49,17,8,39,58,74,42,51,75,51,25,43,64,78,
34,25,50,43,34,9,18,2,46,11,11,29,47,59,29,37,
63,45,25,31,56,77,46,6,10,39,45,48,39,26,1,25,
37,24,12,26,55,87,60,66,111,42,12,40,56,72,42,67,
117,87,50,41,57,61,20,4,25,28,24,2,32,60,46,27,
28,49,69,42,52,73,47,22,9,13,14,4,20,0,0,1,
0,55,0,0,4,96,3,162,0,43,0,95,184,0,44,47,
184,0,45,47,184,0,39,220,185,0,4,0,4,252,184,0,
44,16,184,0,16,208,184,0,16,47,185,0,7,0,4,252,
184,0,26,208,186,0,27,0,16,0,39,17,18,57,184,0,
4,16,184,0,28,208,0,184,0,0,69,88,184,0,21,47,
27,185,0,21,0,9,62,89,184,0,0,69,88,184,0,33,
47,27,185,0,33,0,9,62,89,48,49,33,53,62,1,53,
17,1,21,20,22,23,21,33,53,62,1,53,17,52,38,39,
53,33,21,14,1,21,17,1,53,52,38,39,53,33,21,14,
1,21,17,20,22,23,21,2,178,68,72,254,27,67,73,254,
82,68,72,67,73,1,174,68,72,1,229,67,73,1,174,68,
72,67,73,43,14,33,14,2,79,253,209,32,12,35,14,43,
43,14,33,14,2,210,12,35,14,43,43,14,33,14,253,203,
2,48,5,12,35,14,43,43,14,33,14,253,46,12,35,14,
43,0,0,2,0,55,0,0,4,96,5,24,0,31,0,75,
0,95,184,0,76,47,184,0,77,47,184,0,71,220,185,0,
36,0,4,252,184,0,76,16,184,0,48,208,184,0,48,47,
185,0,39,0,4,252,184,0,58,208,186,0,59,0,48,0,
71,17,18,57,184,0,36,16,184,0,60,208,0,184,0,0,
69,88,184,0,53,47,27,185,0,53,0,9,62,89,184,0,
0,69,88,184,0,65,47,27,185,0,65,0,9,62,89,48,
49,1,34,46,2,39,38,62,2,55,23,30,3,51,50,62,
2,63,1,30,3,7,14,3,19,53,62,1,53,17,1,21,
20,22,23,21,33,53,62,1,53,17,52,38,39,53,33,21,
14,1,21,17,1,53,52,38,39,53,33,21,14,1,21,17,
20,22,23,21,2,75,60,100,77,54,14,2,6,12,17,10,
37,4,36,59,79,47,47,79,59,36,4,37,10,17,12,6,
2,14,54,77,100,43,68,72,254,27,67,73,254,82,68,72,
67,73,1,174,68,72,1,229,67,73,1,174,68,72,67,73,
4,14,17,27,34,17,12,47,51,48,13,11,39,64,47,25,
25,47,64,39,11,13,48,51,47,12,17,34,27,17,251,242,
43,14,33,14,2,79,253,209,32,12,35,14,43,43,14,33,
14,2,210,12,35,14,43,43,14,33,14,253,203,2,48,5,
12,35,14,43,43,14,33,14,253,46,12,35,14,43,0,1,
0,55,255,241,4,0,3,182,0,79,0,246,187,0,61,0,
4,0,72,0,4,43,184,0,61,16,184,0,4,208,184,0,
72,16,184,0,74,208,0,184,0,0,69,88,184,0,0,47,
27,185,0,0,0,9,62,89,184,0,0,69,88,184,0,12,
47,27,185,0,12,0,9,62,89,184,0,0,69,88,184,0,
47,47,27,185,0,47,0,5,62,89,184,0,0,69,88,184,
0,67,47,27,185,0,67,0,5,62,89,187,0,5,0,2,
0,60,0,4,43,184,0,5,16,184,0,12,16,185,0,24,
0,2,252,65,5,0,121,0,24,0,137,0,24,0,2,113,
65,33,0,8,0,24,0,24,0,24,0,40,0,24,0,56,
0,24,0,72,0,24,0,88,0,24,0,104,0,24,0,120,
0,24,0,136,0,24,0,152,0,24,0,168,0,24,0,184,
0,24,0,200,0,24,0,216,0,24,0,232,0,24,0,248,
0,24,0,16,93,65,15,0,8,0,24,0,24,0,24,0,
40,0,24,0,56,0,24,0,72,0,24,0,88,0,24,0,
104,0,24,0,7,113,186,0,31,0,60,0,5,17,18,57,
48,49,1,21,14,1,21,17,50,62,4,51,50,22,23,22,
6,7,39,46,3,35,34,14,4,7,30,3,23,30,3,55,
23,14,3,35,34,46,2,39,46,5,7,35,17,20,30,2,
23,21,33,53,62,1,53,17,53,17,52,38,39,53,1,199,
66,44,63,89,71,62,72,90,65,33,66,29,13,28,32,37,
9,24,28,30,14,29,44,39,36,41,49,32,66,96,76,65,
35,16,29,35,44,30,6,29,57,49,39,10,21,31,26,24,
13,29,48,46,47,56,69,43,42,7,22,44,37,254,112,66,
74,65,75,3,162,43,13,30,18,254,216,62,94,108,94,62,
21,24,11,99,68,10,22,29,16,6,31,50,65,68,67,26,
30,108,119,109,31,14,21,13,5,3,43,6,10,8,4,7,
14,20,12,27,81,91,90,72,43,2,254,176,8,13,14,16,
10,43,43,15,28,18,1,76,9,1,125,15,28,18,43,0,
0,1,0,10,255,236,4,34,3,162,0,52,0,116,184,0,
53,47,184,0,54,47,184,0,48,220,185,0,4,0,4,252,
184,0,53,16,184,0,36,208,184,0,36,47,185,0,14,0,
3,252,65,19,0,6,0,14,0,22,0,14,0,38,0,14,
0,54,0,14,0,70,0,14,0,86,0,14,0,102,0,14,
0,118,0,14,0,134,0,14,0,9,93,65,5,0,149,0,
14,0,165,0,14,0,2,93,0,184,0,0,69,88,184,0,
42,47,27,185,0,42,0,9,62,89,185,0,10,0,2,252,
48,49,33,53,62,1,53,17,52,46,2,43,1,14,1,7,
14,3,7,14,3,47,1,55,62,3,55,62,3,55,46,3,
39,53,33,21,14,1,21,17,20,22,23,21,2,116,66,74,
10,26,47,36,116,36,39,8,7,14,18,22,14,14,28,33,
41,28,221,6,30,64,64,60,27,14,27,22,16,4,5,32,
48,60,33,3,124,68,72,67,73,43,13,32,14,2,202,8,
12,9,5,1,8,8,97,168,150,134,62,62,93,60,27,3,
27,43,2,21,54,94,74,40,113,138,157,85,6,14,15,15,
6,43,43,14,33,14,253,46,12,35,14,43,0,1,0,40,
0,0,5,45,3,162,0,49,0,61,187,0,18,0,3,0,
30,0,4,43,184,0,18,16,0,184,0,0,69,88,184,0,
34,47,27,185,0,34,0,9,62,89,184,0,0,69,88,184,
0,47,47,27,185,0,47,0,9,62,89,185,0,0,0,1,
252,184,0,33,208,48,49,1,34,6,7,19,20,22,23,21,
33,53,62,1,53,3,1,35,1,3,20,22,23,21,33,53,
62,3,53,19,46,1,35,53,33,50,30,2,23,9,1,62,
3,51,33,21,5,29,25,66,35,8,74,60,254,109,56,72,
8,254,170,62,254,158,7,65,60,254,150,28,49,37,21,7,
35,73,25,1,10,8,11,10,13,11,1,65,1,50,11,14,
10,10,8,1,5,3,119,15,14,252,254,9,26,10,43,43,
10,25,10,2,139,253,29,2,233,253,111,9,26,10,43,43,
5,11,12,12,5,3,0,17,14,43,4,14,24,20,253,115,
2,141,22,25,12,3,43,0,0,1,0,55,0,0,4,96,
3,162,0,43,0,85,184,0,44,47,184,0,45,47,184,0,
39,220,185,0,4,0,4,252,184,0,44,16,184,0,16,208,
184,0,16,47,185,0,7,0,4,252,184,0,26,208,184,0,
4,16,184,0,28,208,0,184,0,0,69,88,184,0,21,47,
27,185,0,21,0,9,62,89,184,0,0,69,88,184,0,33,
47,27,185,0,33,0,9,62,89,48,49,33,53,62,1,53,
17,33,17,20,22,23,21,33,53,62,1,53,17,52,38,39,
53,33,21,14,1,21,17,33,17,52,38,39,53,33,21,14,
1,21,17,20,22,23,21,2,178,68,72,254,27,67,73,254,
82,68,72,67,73,1,174,68,72,1,229,67,73,1,174,68,
72,67,73,43,14,33,14,1,90,254,166,12,35,14,43,43,
14,33,14,2,210,12,35,14,43,43,14,33,14,254,226,1,
30,12,35,14,43,43,14,33,14,253,46,12,35,14,43,0,
0,2,0,80,255,226,3,182,3,192,0,19,0,43,1,175,
184,0,44,47,184,0,45,47,184,0,20,220,185,0,0,0,
4,252,65,5,0,154,0,0,0,170,0,0,0,2,93,65,
19,0,9,0,0,0,25,0,0,0,41,0,0,0,57,0,
0,0,73,0,0,0,89,0,0,0,105,0,0,0,121,0,
0,0,137,0,0,0,9,93,184,0,44,16,184,0,32,208,
184,0,32,47,185,0,10,0,4,252,65,19,0,6,0,10,
0,22,0,10,0,38,0,10,0,54,0,10,0,70,0,10,
0,86,0,10,0,102,0,10,0,118,0,10,0,134,0,10,
0,9,93,65,5,0,149,0,10,0,165,0,10,0,2,93,
0,184,0,0,69,88,184,0,39,47,27,185,0,39,0,9,
62,89,184,0,0,69,88,184,0,27,47,27,185,0,27,0,
5,62,89,184,0,39,16,185,0,5,0,2,252,65,5,0,
121,0,5,0,137,0,5,0,2,113,65,33,0,8,0,5,
0,24,0,5,0,40,0,5,0,56,0,5,0,72,0,5,
0,88,0,5,0,104,0,5,0,120,0,5,0,136,0,5,
0,152,0,5,0,168,0,5,0,184,0,5,0,200,0,5,
0,216,0,5,0,232,0,5,0,248,0,5,0,16,93,65,
15,0,8,0,5,0,24,0,5,0,40,0,5,0,56,0,
5,0,72,0,5,0,88,0,5,0,104,0,5,0,7,113,
184,0,27,16,185,0,15,0,2,252,65,33,0,7,0,15,
0,23,0,15,0,39,0,15,0,55,0,15,0,71,0,15,
0,87,0,15,0,103,0,15,0,119,0,15,0,135,0,15,
0,151,0,15,0,167,0,15,0,183,0,15,0,199,0,15,
0,215,0,15,0,231,0,15,0,247,0,15,0,16,93,65,
15,0,7,0,15,0,23,0,15,0,39,0,15,0,55,0,
15,0,71,0,15,0,87,0,15,0,103,0,15,0,7,113,
65,5,0,118,0,15,0,134,0,15,0,2,113,48,49,1,
52,46,2,35,34,14,2,21,20,30,2,51,50,62,2,55,
20,14,4,35,34,46,2,53,52,62,4,51,50,30,2,3,
29,52,84,104,51,76,104,65,28,56,86,103,46,71,103,67,
32,153,34,60,84,101,114,61,95,153,109,59,33,59,83,101,
116,63,94,153,109,59,1,199,79,143,109,64,58,101,138,80,
79,143,108,63,53,98,138,116,66,129,114,97,70,39,72,126,
174,102,66,128,115,97,70,40,72,127,174,0,0,1,0,55,
0,0,4,56,3,162,0,39,0,62,184,0,40,47,184,0,
41,47,184,0,35,220,185,0,4,0,4,252,184,0,40,16,
184,0,24,208,184,0,24,47,185,0,15,0,4,252,0,184,
0,0,69,88,184,0,29,47,27,185,0,29,0,9,62,89,
185,0,10,0,2,252,48,49,33,53,62,1,55,17,46,3,
43,1,14,1,7,17,20,22,23,21,33,53,62,1,53,17,
46,1,39,53,33,21,14,1,21,17,20,22,23,21,2,138,
66,72,2,1,10,26,46,36,237,52,36,1,67,73,254,82,
68,72,2,67,71,4,1,68,72,67,73,43,13,32,14,2,
202,8,12,9,5,1,17,16,253,56,12,35,14,43,43,14,
33,14,2,211,12,34,14,43,43,14,33,14,253,46,12,35,
14,43,0,2,0,55,254,32,3,236,3,192,0,20,0,64,
1,199,184,0,65,47,184,0,66,47,184,0,21,220,185,0,
0,0,4,252,65,5,0,154,0,0,0,170,0,0,0,2,
93,65,19,0,9,0,0,0,25,0,0,0,41,0,0,0,
57,0,0,0,73,0,0,0,89,0,0,0,105,0,0,0,
121,0,0,0,137,0,0,0,9,93,184,0,65,16,184,0,
41,208,184,0,41,47,185,0,32,0,4,252,184,0,10,208,
184,0,32,16,184,0,55,208,184,0,55,47,0,184,0,0,
69,88,184,0,53,47,27,185,0,53,0,9,62,89,184,0,
0,69,88,184,0,60,47,27,185,0,60,0,9,62,89,184,
0,0,69,88,184,0,36,47,27,185,0,36,0,7,62,89,
184,0,0,69,88,184,0,28,47,27,185,0,28,0,5,62,
89,184,0,60,16,185,0,5,0,2,252,65,5,0,121,0,
5,0,137,0,5,0,2,113,65,33,0,8,0,5,0,24,
0,5,0,40,0,5,0,56,0,5,0,72,0,5,0,88,
0,5,0,104,0,5,0,120,0,5,0,136,0,5,0,152,
0,5,0,168,0,5,0,184,0,5,0,200,0,5,0,216,
0,5,0,232,0,5,0,248,0,5,0,16,93,65,15,0,
8,0,5,0,24,0,5,0,40,0,5,0,56,0,5,0,
72,0,5,0,88,0,5,0,104,0,5,0,7,113,184,0,
28,16,185,0,16,0,2,252,65,33,0,7,0,16,0,23,
0,16,0,39,0,16,0,55,0,16,0,71,0,16,0,87,
0,16,0,103,0,16,0,119,0,16,0,135,0,16,0,151,
0,16,0,167,0,16,0,183,0,16,0,199,0,16,0,215,
0,16,0,231,0,16,0,247,0,16,0,16,93,65,15,0,
7,0,16,0,23,0,16,0,39,0,16,0,55,0,16,0,
71,0,16,0,87,0,16,0,103,0,16,0,7,113,65,5,
0,118,0,16,0,134,0,16,0,2,113,186,0,31,0,28,
0,16,17,18,57,184,0,5,16,184,0,47,208,186,0,55,
0,36,0,53,17,18,57,48,49,1,52,46,2,35,34,14,
2,7,17,30,3,51,50,62,2,55,20,14,4,35,34,38,
39,17,20,22,23,21,33,53,62,1,53,17,52,46,2,39,
53,62,3,55,31,1,62,3,51,50,30,2,3,103,41,69,
90,48,18,58,74,84,44,45,77,67,60,27,54,91,67,38,
133,29,53,71,85,94,49,59,148,71,75,94,254,53,66,74,
8,29,55,48,34,62,58,57,29,35,9,50,101,92,79,29,
68,115,84,47,1,170,87,150,109,62,22,51,87,64,254,115,
34,44,25,10,42,82,122,146,58,122,116,104,77,45,66,62,
254,39,16,32,14,43,43,16,29,17,4,62,37,48,29,13,
2,40,7,17,19,23,14,35,198,60,88,57,28,64,121,174,
0,1,0,80,255,226,3,72,3,192,0,47,1,99,187,0,
36,0,4,0,10,0,4,43,184,0,36,16,65,19,0,6,
0,36,0,22,0,36,0,38,0,36,0,54,0,36,0,70,
0,36,0,86,0,36,0,102,0,36,0,118,0,36,0,134,
0,36,0,9,93,65,5,0,149,0,36,0,165,0,36,0,
2,93,0,184,0,0,69,88,184,0,15,47,27,185,0,15,
0,9,62,89,184,0,0,69,88,184,0,5,47,27,185,0,
5,0,5,62,89,184,0,15,16,185,0,31,0,2,252,65,
5,0,121,0,31,0,137,0,31,0,2,113,65,33,0,8,
0,31,0,24,0,31,0,40,0,31,0,56,0,31,0,72,
0,31,0,88,0,31,0,104,0,31,0,120,0,31,0,136,
0,31,0,152,0,31,0,168,0,31,0,184,0,31,0,200,
0,31,0,216,0,31,0,232,0,31,0,248,0,31,0,16,
93,65,15,0,8,0,31,0,24,0,31,0,40,0,31,0,
56,0,31,0,72,0,31,0,88,0,31,0,104,0,31,0,
7,113,184,0,5,16,185,0,41,0,2,252,65,33,0,7,
0,41,0,23,0,41,0,39,0,41,0,55,0,41,0,71,
0,41,0,87,0,41,0,103,0,41,0,119,0,41,0,135,
0,41,0,151,0,41,0,167,0,41,0,183,0,41,0,199,
0,41,0,215,0,41,0,231,0,41,0,247,0,41,0,16,
93,65,15,0,7,0,41,0,23,0,41,0,39,0,41,0,
55,0,41,0,71,0,41,0,87,0,41,0,103,0,41,0,
7,113,65,5,0,118,0,41,0,134,0,41,0,2,113,48,
49,37,14,3,35,34,46,2,53,52,62,2,51,50,30,2,
23,22,14,2,7,39,46,3,35,34,14,2,21,20,30,2,
51,50,62,2,55,23,3,72,65,99,84,80,47,73,139,108,
65,79,137,186,108,33,69,63,53,17,2,10,18,22,9,37,
8,36,57,79,51,53,97,75,45,51,85,111,60,28,48,57,
75,56,39,190,77,87,45,11,65,122,176,111,108,188,139,81,
11,21,29,18,12,44,49,45,14,10,18,42,38,25,47,94,
140,94,85,138,97,53,5,24,52,48,41,0,0,1,0,21,
0,0,3,206,3,162,0,42,0,52,187,0,36,0,4,0,
6,0,4,43,184,0,36,16,184,0,29,220,0,184,0,0,
69,88,184,0,21,47,27,185,0,21,0,9,62,89,185,0,
7,0,2,252,184,0,34,208,184,0,35,208,48,49,51,53,
62,3,53,17,35,34,14,2,7,35,52,62,4,55,33,23,
14,3,7,35,46,3,43,1,17,20,30,2,23,21,245,34,
61,47,28,216,16,35,35,33,12,47,2,5,7,7,7,4,
3,126,27,2,9,12,14,6,47,3,9,16,23,16,252,26,
45,63,36,43,7,16,18,19,11,2,214,21,47,76,54,14,
47,56,59,54,45,13,18,19,77,85,78,21,47,77,54,30,
253,42,10,19,19,16,7,43,0,1,255,209,254,12,3,221,
3,162,0,51,0,64,0,184,0,0,69,88,184,0,35,47,
27,185,0,35,0,9,62,89,184,0,0,69,88,184,0,50,
47,27,185,0,50,0,9,62,89,184,0,0,69,88,184,0,
11,47,27,185,0,11,0,7,62,89,186,0,43,0,11,0,
35,17,18,57,48,49,1,14,3,7,1,14,3,35,34,46,
2,53,52,62,2,55,30,1,55,62,3,63,1,1,46,1,
39,53,33,21,14,3,23,27,1,54,46,2,39,53,33,3,
221,30,38,24,13,5,254,178,42,103,111,112,50,38,64,46,
26,24,36,41,16,48,95,37,18,48,49,47,18,29,254,184,
9,52,50,1,130,39,49,27,4,6,246,231,5,7,27,49,
37,1,78,3,119,7,12,15,19,15,252,123,111,158,101,48,
10,15,19,9,6,36,43,40,10,28,4,14,6,44,64,81,
43,69,3,74,28,29,11,43,43,5,10,15,22,16,253,131,
2,125,15,21,15,11,6,43,0,3,0,80,254,32,5,13,
6,14,0,18,0,37,0,100,2,88,187,0,30,0,4,0,
10,0,4,43,184,0,30,16,187,0,0,0,4,0,69,0,
4,43,184,0,0,16,187,0,38,0,4,0,19,0,4,43,
184,0,38,16,65,19,0,6,0,0,0,22,0,0,0,38,
0,0,0,54,0,0,0,70,0,0,0,86,0,0,0,102,
0,0,0,118,0,0,0,134,0,0,0,9,93,65,5,0,
149,0,0,0,165,0,0,0,2,93,65,5,0,154,0,19,
0,170,0,19,0,2,93,65,19,0,9,0,19,0,25,0,
19,0,41,0,19,0,57,0,19,0,73,0,19,0,89,0,
19,0,105,0,19,0,121,0,19,0,137,0,19,0,9,93,
184,0,30,16,184,0,48,208,184,0,10,16,184,0,58,208,
186,0,59,0,69,0,38,17,18,57,184,0,10,16,184,0,
79,208,184,0,30,16,184,0,90,208,186,0,91,0,69,0,
38,17,18,57,184,0,38,16,184,0,102,220,0,184,0,89,
47,184,0,0,69,88,184,0,76,47,27,185,0,76,0,9,
62,89,184,0,0,69,88,184,0,96,47,27,185,0,96,0,
9,62,89,184,0,0,69,88,184,0,53,47,27,185,0,53,
0,7,62,89,184,0,0,69,88,184,0,45,47,27,185,0,
45,0,5,62,89,184,0,0,69,88,184,0,64,47,27,185,
0,64,0,5,62,89,185,0,5,0,2,252,65,33,0,7,
0,5,0,23,0,5,0,39,0,5,0,55,0,5,0,71,
0,5,0,87,0,5,0,103,0,5,0,119,0,5,0,135,
0,5,0,151,0,5,0,167,0,5,0,183,0,5,0,199,
0,5,0,215,0,5,0,231,0,5,0,247,0,5,0,16,
93,65,15,0,7,0,5,0,23,0,5,0,39,0,5,0,
55,0,5,0,71,0,5,0,87,0,5,0,103,0,5,0,
7,113,65,5,0,118,0,5,0,134,0,5,0,2,113,184,
0,76,16,185,0,16,0,2,252,65,5,0,121,0,16,0,
137,0,16,0,2,113,65,33,0,8,0,16,0,24,0,16,
0,40,0,16,0,56,0,16,0,72,0,16,0,88,0,16,
0,104,0,16,0,120,0,16,0,136,0,16,0,152,0,16,
0,168,0,16,0,184,0,16,0,200,0,16,0,216,0,16,
0,232,0,16,0,248,0,16,0,16,93,65,15,0,8,0,
16,0,24,0,16,0,40,0,16,0,56,0,16,0,72,0,
16,0,88,0,16,0,104,0,16,0,7,113,184,0,24,208,
184,0,5,16,184,0,35,208,186,0,48,0,64,0,5,17,
18,57,186,0,59,0,64,0,5,17,18,57,186,0,79,0,
76,0,16,17,18,57,186,0,91,0,76,0,16,17,18,57,
48,49,19,20,30,2,51,50,62,2,55,17,46,3,35,34,
6,5,52,46,2,35,34,14,2,7,17,30,3,51,50,54,
55,20,14,4,35,34,38,39,17,20,22,23,21,33,53,62,
1,53,17,14,3,35,34,46,2,53,52,62,4,51,50,22,
23,17,46,3,39,53,62,1,55,23,17,62,3,51,50,30,
2,213,41,69,90,48,13,31,37,43,25,27,43,39,37,21,
108,122,3,179,41,69,90,48,13,32,37,44,26,27,44,40,
38,21,108,122,133,26,48,67,80,91,49,45,80,47,67,73,
254,82,68,72,33,60,54,48,21,68,115,84,47,26,48,67,
80,91,49,43,80,46,1,14,32,53,40,72,120,62,36,33,
61,54,49,22,68,115,84,47,1,248,87,150,109,62,1,10,
23,23,2,120,16,18,9,2,165,239,87,150,109,62,1,10,
25,24,253,141,17,19,9,2,165,227,58,122,116,104,77,45,
38,35,254,93,12,35,14,43,43,14,33,14,1,167,26,31,
16,4,64,121,173,110,58,122,116,104,77,45,36,35,1,168,
39,43,22,8,5,40,14,34,32,34,253,132,27,32,16,5,
64,121,174,0,0,1,0,20,0,0,3,248,3,162,0,58,
0,139,0,184,0,0,69,88,184,0,30,47,27,185,0,30,
0,9,62,89,184,0,0,69,88,184,0,45,47,27,185,0,
45,0,9,62,89,184,0,0,69,88,184,0,0,47,27,185,
0,0,0,5,62,89,184,0,0,69,88,184,0,15,47,27,
185,0,15,0,5,62,89,184,0,0,16,185,0,1,0,1,
252,186,0,8,0,0,0,30,17,18,57,184,0,14,208,184,
0,17,208,184,0,30,16,185,0,29,0,1,252,184,0,32,
208,186,0,38,0,0,0,30,17,18,57,184,0,44,208,184,
0,47,208,184,0,17,16,184,0,57,208,48,49,33,53,62,
2,53,52,39,11,1,6,30,2,23,21,33,53,62,3,55,
19,3,46,3,39,53,33,21,14,2,22,31,1,55,62,1,
46,1,39,53,33,21,14,1,7,3,1,30,3,23,21,2,
102,25,44,25,20,198,189,19,8,34,51,24,254,133,40,56,
39,27,11,243,235,13,26,37,54,40,1,164,31,45,23,3,
18,161,154,18,4,21,44,31,1,125,81,89,26,210,1,11,
12,28,37,50,33,43,2,8,18,16,17,27,1,13,254,243,
27,33,18,8,2,43,43,6,19,25,29,15,1,82,1,66,
18,31,23,15,3,43,43,3,11,19,31,24,222,222,24,32,
19,10,3,43,43,6,47,37,254,217,254,147,15,29,26,20,
4,43,0,1,0,55,255,7,4,71,3,162,0,50,0,100,
184,0,51,47,184,0,52,47,184,0,51,16,184,0,45,208,
184,0,45,47,185,0,5,0,4,252,184,0,52,16,184,0,
25,220,185,0,14,0,4,252,0,184,0,0,69,88,184,0,
0,47,27,185,0,0,0,9,62,89,184,0,0,69,88,184,
0,19,47,27,185,0,19,0,9,62,89,184,0,0,69,88,
184,0,40,47,27,185,0,40,0,5,62,89,185,0,10,0,
2,252,48,49,1,21,14,1,7,17,30,3,59,1,62,1,
55,17,52,38,39,53,33,21,14,1,21,17,20,22,31,1,
14,3,7,35,46,3,39,33,53,62,1,53,17,52,38,39,
53,1,229,66,72,2,1,10,26,46,36,237,52,36,1,67,
73,1,174,68,72,64,65,26,2,9,12,14,6,47,2,13,
20,27,15,252,151,68,72,67,73,3,162,43,13,32,14,253,
54,8,12,9,5,1,17,16,2,200,12,35,14,43,43,14,
33,14,253,45,11,29,10,19,19,77,86,80,21,47,88,68,
43,3,43,14,33,14,2,210,12,35,14,43,0,1,0,55,
0,0,4,39,3,162,0,51,0,95,184,0,52,47,184,0,
53,47,184,0,47,220,185,0,4,0,4,252,184,0,52,16,
184,0,15,208,184,0,15,47,185,0,26,0,4,252,184,0,
4,16,184,0,36,208,0,184,0,0,69,88,184,0,20,47,
27,185,0,20,0,9,62,89,184,0,0,69,88,184,0,41,
47,27,185,0,41,0,9,62,89,187,0,31,0,2,0,10,
0,4,43,184,0,31,16,48,49,33,53,62,1,53,17,14,
3,35,34,46,2,39,17,52,38,39,53,33,21,14,1,29,
1,30,3,51,50,62,2,55,17,52,38,39,53,33,21,14,
1,21,17,20,22,23,21,2,121,68,72,51,90,81,77,39,
35,83,72,49,1,65,75,1,174,71,69,1,24,41,56,33,
21,52,66,83,51,67,73,1,174,68,72,67,73,43,14,33,
14,1,106,41,54,32,12,19,51,88,69,1,16,12,35,14,
43,43,14,35,12,200,57,75,45,18,6,25,49,42,1,17,
12,35,14,43,43,14,33,14,253,46,12,35,14,43,0,1,
0,55,0,0,5,255,3,162,0,68,0,201,184,0,69,47,
184,0,34,208,184,0,34,47,184,0,54,220,65,3,0,79,
0,54,0,1,93,65,3,0,16,0,54,0,1,93,65,3,
0,144,0,54,0,1,93,185,0,5,0,4,252,184,0,54,
16,184,0,14,220,65,3,0,79,0,14,0,1,93,65,3,
0,16,0,14,0,1,93,65,3,0,144,0,14,0,1,93,
185,0,25,0,4,252,184,0,34,16,185,0,45,0,4,252,
184,0,54,16,184,0,56,208,184,0,25,16,184,0,70,220,
0,184,0,0,69,88,184,0,0,47,27,185,0,0,0,9,
62,89,184,0,0,69,88,184,0,19,47,27,185,0,19,0,
9,62,89,184,0,0,69,88,184,0,39,47,27,185,0,39,
0,9,62,89,184,0,0,69,88,184,0,29,47,27,185,0,
29,0,5,62,89,185,0,10,0,2,252,184,0,50,208,184,
0,51,208,48,49,1,21,14,1,21,17,20,30,2,59,1,
62,1,53,17,52,38,39,53,33,21,14,1,21,17,20,22,
23,21,33,53,62,1,53,17,52,38,39,53,33,21,14,1,
21,17,20,30,2,59,1,62,1,53,17,53,38,39,46,1,
39,38,39,38,39,38,39,53,3,242,68,72,10,26,47,36,
167,52,37,67,73,1,174,68,72,69,71,250,56,68,72,67,
73,1,174,66,74,10,26,47,36,167,52,37,2,12,2,1,
2,3,2,8,5,35,68,3,162,43,14,33,14,253,56,8,
12,9,5,1,17,16,2,200,12,35,14,43,43,14,33,14,
253,45,12,34,14,43,43,14,33,14,2,210,12,35,14,43,
43,13,32,14,253,54,8,12,9,5,1,17,16,2,200,1,
8,9,1,1,1,3,1,4,2,17,13,43,0,1,0,55,
255,7,6,14,3,162,0,92,0,229,184,0,93,47,184,0,
50,208,184,0,50,47,184,0,70,220,65,3,0,79,0,70,
0,1,93,65,3,0,144,0,70,0,1,93,65,3,0,16,
0,70,0,1,93,185,0,10,0,4,252,184,0,70,16,184,
0,19,220,65,3,0,79,0,19,0,1,93,65,3,0,16,
0,19,0,1,93,65,3,0,144,0,19,0,1,93,185,0,
30,0,4,252,184,0,50,16,185,0,61,0,4,252,184,0,
70,16,184,0,73,208,184,0,73,47,184,0,70,16,184,0,
75,208,184,0,75,47,184,0,70,16,184,0,77,208,184,0,
77,47,184,0,30,16,184,0,94,220,0,184,0,0,69,88,
184,0,0,47,27,185,0,0,0,9,62,89,184,0,0,69,
88,184,0,24,47,27,185,0,24,0,9,62,89,184,0,0,
69,88,184,0,55,47,27,185,0,55,0,9,62,89,184,0,
0,69,88,184,0,45,47,27,185,0,45,0,5,62,89,185,
0,15,0,2,252,184,0,66,208,184,0,67,208,48,49,1,
21,14,1,7,14,1,7,6,21,17,30,3,59,1,62,1,
55,17,52,38,39,53,33,21,14,1,21,17,20,22,31,1,
14,3,7,35,46,3,39,33,53,62,1,53,17,52,38,39,
53,33,21,14,1,21,17,20,30,2,59,1,62,1,53,17,
52,39,52,35,48,53,38,39,46,1,39,46,1,39,46,1,
39,46,1,39,53,3,242,16,28,13,4,7,4,68,1,11,
26,45,36,167,52,36,1,67,73,1,174,68,72,64,65,26,
2,9,12,14,6,47,2,13,20,27,15,250,208,68,72,67,
73,1,174,66,74,10,26,47,36,167,52,37,1,1,3,9,
2,1,2,11,34,24,5,8,5,8,17,9,3,162,43,3,
7,4,1,2,1,23,20,253,54,8,11,9,4,1,17,16,
2,200,12,35,14,43,43,14,33,14,253,45,11,29,10,19,
19,77,86,80,21,47,88,68,43,3,43,14,33,14,2,210,
12,35,14,43,43,13,32,14,253,54,8,12,9,5,1,17,
16,2,200,2,2,1,1,6,6,1,1,1,7,14,7,2,
1,2,2,3,2,43,0,2,0,56,255,246,4,108,3,162,
0,14,0,63,1,73,184,0,64,47,184,0,65,47,184,0,
64,16,184,0,33,208,184,0,33,47,185,0,4,0,4,252,
184,0,65,16,184,0,15,220,185,0,12,0,4,252,65,5,
0,154,0,12,0,170,0,12,0,2,93,65,19,0,9,0,
12,0,25,0,12,0,41,0,12,0,57,0,12,0,73,0,
12,0,89,0,12,0,105,0,12,0,121,0,12,0,137,0,
12,0,9,93,184,0,33,16,184,0,36,208,184,0,36,47,
184,0,4,16,184,0,55,208,0,184,0,0,69,88,184,0,
48,47,27,185,0,48,0,9,62,89,184,0,0,69,88,184,
0,20,47,27,185,0,20,0,5,62,89,184,0,0,69,88,
184,0,26,47,27,185,0,26,0,5,62,89,187,0,59,0,
2,0,0,0,4,43,184,0,59,16,184,0,0,16,184,0,
3,208,184,0,3,47,184,0,20,16,185,0,7,0,2,252,
65,33,0,7,0,7,0,23,0,7,0,39,0,7,0,55,
0,7,0,71,0,7,0,87,0,7,0,103,0,7,0,119,
0,7,0,135,0,7,0,151,0,7,0,167,0,7,0,183,
0,7,0,199,0,7,0,215,0,7,0,231,0,7,0,247,
0,7,0,16,93,65,15,0,7,0,7,0,23,0,7,0,
39,0,7,0,55,0,7,0,71,0,7,0,87,0,7,0,
103,0,7,0,7,113,65,5,0,118,0,7,0,134,0,7,
0,2,113,184,0,48,16,185,0,36,0,2,252,48,49,1,
34,6,7,17,30,1,51,50,62,2,53,52,38,5,20,14,
2,35,34,46,3,43,1,53,62,3,53,17,52,39,35,34,
6,7,35,52,62,4,55,33,21,14,3,21,17,62,1,51,
50,30,2,2,185,35,58,26,26,69,38,59,96,67,37,136,
1,42,52,102,150,99,29,92,96,89,52,2,81,30,51,38,
21,9,185,32,74,25,47,2,5,7,7,7,4,2,149,50,
65,40,16,34,77,40,94,149,104,56,1,207,5,3,254,153,
12,14,25,48,71,46,97,106,188,63,105,75,42,2,3,3,
2,43,5,16,16,14,5,2,211,9,9,99,109,14,49,57,
62,57,46,13,43,8,14,16,17,10,254,229,5,6,36,70,
103,0,0,3,0,55,255,246,5,68,3,162,0,14,0,34,
0,75,1,85,184,0,76,47,184,0,77,47,184,0,76,16,
184,0,68,208,184,0,68,47,185,0,4,0,4,252,184,0,
77,16,184,0,50,220,185,0,12,0,4,252,65,5,0,154,
0,12,0,170,0,12,0,2,93,65,19,0,9,0,12,0,
25,0,12,0,41,0,12,0,57,0,12,0,73,0,12,0,
89,0,12,0,105,0,12,0,121,0,12,0,137,0,12,0,
9,93,184,0,4,16,184,0,41,208,0,184,0,0,69,88,
184,0,24,47,27,185,0,24,0,9,62,89,184,0,0,69,
88,184,0,35,47,27,185,0,35,0,9,62,89,184,0,0,
69,88,184,0,15,47,27,185,0,15,0,5,62,89,184,0,
0,69,88,184,0,55,47,27,185,0,55,0,5,62,89,184,
0,0,69,88,184,0,61,47,27,185,0,61,0,5,62,89,
187,0,45,0,2,0,0,0,4,43,184,0,45,16,184,0,
0,16,184,0,3,208,184,0,3,47,184,0,55,16,185,0,
7,0,2,252,65,33,0,7,0,7,0,23,0,7,0,39,
0,7,0,55,0,7,0,71,0,7,0,87,0,7,0,103,
0,7,0,119,0,7,0,135,0,7,0,151,0,7,0,167,
0,7,0,183,0,7,0,199,0,7,0,215,0,7,0,231,
0,7,0,247,0,7,0,16,93,65,15,0,7,0,7,0,
23,0,7,0,39,0,7,0,55,0,7,0,71,0,7,0,
87,0,7,0,103,0,7,0,7,113,65,5,0,118,0,7,
0,134,0,7,0,2,113,48,49,1,34,6,7,17,30,1,
51,50,62,2,53,52,38,1,53,62,1,53,17,52,38,39,
53,33,21,14,1,21,17,20,22,23,21,1,21,14,3,21,
17,62,1,51,50,30,2,21,20,14,2,35,34,46,3,43,
1,53,62,3,53,17,52,46,2,39,53,1,208,35,58,26,
26,69,38,59,96,67,37,136,1,61,68,72,67,73,1,174,
68,72,67,73,252,192,50,65,40,16,34,77,40,94,149,104,
56,52,102,150,99,29,92,96,89,52,2,81,30,51,38,21,
23,39,50,28,1,207,5,3,254,153,12,14,25,48,71,46,
97,106,254,49,43,14,33,14,2,210,12,35,14,43,43,14,
33,14,253,46,12,35,14,43,3,162,43,8,14,16,17,10,
254,229,5,6,36,70,103,66,63,105,75,42,2,3,3,2,
43,5,16,16,14,5,2,211,10,20,16,14,5,43,0,2,
0,55,255,246,3,131,3,162,0,14,0,55,1,51,184,0,
56,47,184,0,57,47,184,0,56,16,184,0,48,208,184,0,
48,47,185,0,4,0,4,252,184,0,57,16,184,0,30,220,
185,0,12,0,4,252,65,5,0,154,0,12,0,170,0,12,
0,2,93,65,19,0,9,0,12,0,25,0,12,0,41,0,
12,0,57,0,12,0,73,0,12,0,89,0,12,0,105,0,
12,0,121,0,12,0,137,0,12,0,9,93,184,0,4,16,
184,0,21,208,0,184,0,0,69,88,184,0,15,47,27,185,
0,15,0,9,62,89,184,0,0,69,88,184,0,35,47,27,
185,0,35,0,5,62,89,184,0,0,69,88,184,0,41,47,
27,185,0,41,0,5,62,89,187,0,25,0,2,0,0,0,
4,43,184,0,25,16,184,0,0,16,184,0,3,208,184,0,
3,47,184,0,35,16,185,0,7,0,2,252,65,33,0,7,
0,7,0,23,0,7,0,39,0,7,0,55,0,7,0,71,
0,7,0,87,0,7,0,103,0,7,0,119,0,7,0,135,
0,7,0,151,0,7,0,167,0,7,0,183,0,7,0,199,
0,7,0,215,0,7,0,231,0,7,0,247,0,7,0,16,
93,65,15,0,7,0,7,0,23,0,7,0,39,0,7,0,
55,0,7,0,71,0,7,0,87,0,7,0,103,0,7,0,
7,113,65,5,0,118,0,7,0,134,0,7,0,2,113,48,
49,1,34,6,7,17,30,1,51,50,62,2,53,52,38,3,
21,14,3,21,17,62,1,51,50,30,2,21,20,14,2,35,
34,46,3,43,1,53,62,3,53,17,52,46,2,39,53,1,
208,35,58,26,26,69,38,59,96,67,37,136,85,50,65,40,
16,34,77,40,94,149,104,56,52,102,150,99,29,92,96,89,
52,2,81,30,51,38,21,23,39,50,28,1,207,5,3,254,
153,12,14,25,48,71,46,97,106,1,211,43,8,14,16,17,
10,254,229,5,6,36,70,103,66,63,105,75,42,2,3,3,
2,43,5,16,16,14,5,2,211,10,20,16,14,5,43,0,
0,1,0,80,255,226,3,107,3,192,0,69,1,49,187,0,
0,0,4,0,25,0,4,43,184,0,25,16,184,0,41,208,
184,0,41,47,0,184,0,0,69,88,184,0,65,47,27,185,
0,65,0,9,62,89,184,0,0,69,88,184,0,5,47,27,
185,0,5,0,5,62,89,185,0,20,0,2,252,65,33,0,
7,0,20,0,23,0,20,0,39,0,20,0,55,0,20,0,
71,0,20,0,87,0,20,0,103,0,20,0,119,0,20,0,
135,0,20,0,151,0,20,0,167,0,20,0,183,0,20,0,
199,0,20,0,215,0,20,0,231,0,20,0,247,0,20,0,
16,93,65,15,0,7,0,20,0,23,0,20,0,39,0,20,
0,55,0,20,0,71,0,20,0,87,0,20,0,103,0,20,
0,7,113,65,5,0,118,0,20,0,134,0,20,0,2,113,
184,0,65,16,185,0,46,0,2,252,65,5,0,121,0,46,
0,137,0,46,0,2,113,65,33,0,8,0,46,0,24,0,
46,0,40,0,46,0,56,0,46,0,72,0,46,0,88,0,
46,0,104,0,46,0,120,0,46,0,136,0,46,0,152,0,
46,0,168,0,46,0,184,0,46,0,200,0,46,0,216,0,
46,0,232,0,46,0,248,0,46,0,16,93,65,15,0,8,
0,46,0,24,0,46,0,40,0,46,0,56,0,46,0,72,
0,46,0,88,0,46,0,104,0,46,0,7,113,48,49,1,
20,14,2,35,34,46,2,53,52,62,2,55,30,3,51,50,
62,2,55,35,34,14,2,7,39,62,3,55,30,1,59,1,
46,3,35,34,14,2,15,1,46,4,53,52,55,62,3,51,
50,30,2,3,107,67,121,169,101,83,126,85,43,34,47,49,
14,11,43,58,70,38,58,102,76,45,1,210,33,67,62,54,
21,28,2,14,16,16,4,45,103,50,220,9,52,83,110,66,
29,71,67,55,12,42,3,6,6,5,3,2,37,89,93,94,
42,93,153,109,61,1,234,114,191,138,77,49,65,67,18,7,
25,26,21,4,38,65,49,28,33,85,146,114,6,10,13,7,
19,5,38,44,39,6,9,16,79,123,84,44,21,50,80,59,
6,1,32,45,53,46,15,15,1,19,35,27,17,66,123,173,
0,2,0,55,255,226,5,151,3,192,0,19,0,65,1,160,
187,0,35,0,4,0,44,0,4,43,184,0,35,16,187,0,
10,0,4,0,33,0,4,43,184,0,10,16,187,0,20,0,
4,0,0,0,4,43,184,0,20,16,65,5,0,154,0,0,
0,170,0,0,0,2,93,65,19,0,9,0,0,0,25,0,
0,0,41,0,0,0,57,0,0,0,73,0,0,0,89,0,
0,0,105,0,0,0,121,0,0,0,137,0,0,0,9,93,
184,0,35,16,184,0,54,208,184,0,20,16,184,0,67,220,
0,184,0,0,69,88,184,0,49,47,27,185,0,49,0,9,
62,89,184,0,0,69,88,184,0,61,47,27,185,0,61,0,
9,62,89,184,0,0,69,88,184,0,27,47,27,185,0,27,
0,5,62,89,184,0,61,16,185,0,5,0,2,252,65,5,
0,121,0,5,0,137,0,5,0,2,113,65,33,0,8,0,
5,0,24,0,5,0,40,0,5,0,56,0,5,0,72,0,
5,0,88,0,5,0,104,0,5,0,120,0,5,0,136,0,
5,0,152,0,5,0,168,0,5,0,184,0,5,0,200,0,
5,0,216,0,5,0,232,0,5,0,248,0,5,0,16,93,
65,15,0,8,0,5,0,24,0,5,0,40,0,5,0,56,
0,5,0,72,0,5,0,88,0,5,0,104,0,5,0,7,
113,184,0,27,16,185,0,15,0,2,252,65,33,0,7,0,
15,0,23,0,15,0,39,0,15,0,55,0,15,0,71,0,
15,0,87,0,15,0,103,0,15,0,119,0,15,0,135,0,
15,0,151,0,15,0,167,0,15,0,183,0,15,0,199,0,
15,0,215,0,15,0,231,0,15,0,247,0,15,0,16,93,
65,15,0,7,0,15,0,23,0,15,0,39,0,15,0,55,
0,15,0,71,0,15,0,87,0,15,0,103,0,15,0,7,
113,65,5,0,118,0,15,0,134,0,15,0,2,113,48,49,
1,52,46,2,35,34,14,2,21,20,30,2,51,50,62,2,
55,20,14,4,35,34,46,2,61,1,35,17,20,22,23,21,
33,53,62,1,53,17,52,38,39,53,33,21,14,1,21,17,
51,62,3,51,50,30,2,4,254,52,84,104,51,76,104,65,
28,56,86,103,46,71,103,67,32,153,34,60,84,101,114,61,
95,153,109,59,216,67,73,254,82,68,72,67,73,1,174,68,
72,225,16,81,118,148,83,94,153,109,59,1,199,79,143,109,
64,58,101,138,80,79,143,108,63,53,98,138,116,66,129,114,
97,70,39,72,126,174,102,6,254,166,12,35,14,43,43,14,
33,14,2,210,12,35,14,43,43,14,33,14,254,226,85,152,
115,68,72,127,174,0,0,2,0,20,255,245,3,191,3,192,
0,60,0,75,1,99,184,0,76,47,184,0,77,47,184,0,
56,220,185,0,6,0,4,252,184,0,76,16,184,0,41,208,
184,0,41,47,184,0,31,208,184,0,31,47,186,0,36,0,
41,0,56,17,18,57,184,0,41,16,185,0,66,0,4,252,
65,19,0,6,0,66,0,22,0,66,0,38,0,66,0,54,
0,66,0,70,0,66,0,86,0,66,0,102,0,66,0,118,
0,66,0,134,0,66,0,9,93,65,5,0,149,0,66,0,
165,0,66,0,2,93,184,0,6,16,184,0,72,208,0,184,
0,0,69,88,184,0,46,47,27,185,0,46,0,9,62,89,
184,0,0,69,88,184,0,20,47,27,185,0,20,0,5,62,
89,184,0,0,69,88,184,0,0,47,27,185,0,0,0,5,
62,89,187,0,69,0,2,0,8,0,4,43,184,0,69,16,
184,0,20,16,184,0,25,220,186,0,36,0,8,0,69,17,
18,57,184,0,46,16,185,0,61,0,2,252,65,5,0,121,
0,61,0,137,0,61,0,2,113,65,33,0,8,0,61,0,
24,0,61,0,40,0,61,0,56,0,61,0,72,0,61,0,
88,0,61,0,104,0,61,0,120,0,61,0,136,0,61,0,
152,0,61,0,168,0,61,0,184,0,61,0,200,0,61,0,
216,0,61,0,232,0,61,0,248,0,61,0,16,93,65,15,
0,8,0,61,0,24,0,61,0,40,0,61,0,56,0,61,
0,72,0,61,0,88,0,61,0,104,0,61,0,7,113,184,
0,69,16,184,0,72,208,184,0,72,47,184,0,61,16,184,
0,73,208,184,0,73,47,48,49,33,53,62,3,53,17,35,
38,14,4,7,14,3,35,34,46,2,39,55,22,62,2,55,
62,3,55,46,3,53,52,62,2,51,50,30,2,23,7,46,
1,39,17,20,22,23,21,1,34,14,2,21,20,22,23,50,
54,55,17,46,1,2,40,37,44,22,7,79,39,66,55,46,
38,32,13,8,18,22,29,20,6,32,47,59,33,7,29,39,
28,22,12,18,40,56,73,51,54,89,63,35,50,107,165,116,
45,97,96,90,39,7,33,71,36,74,66,254,158,81,110,68,
30,133,147,17,33,23,17,33,43,10,16,14,13,8,1,73,
2,41,68,87,88,81,28,17,21,11,4,4,8,10,6,43,
3,1,11,22,19,28,87,97,94,35,12,40,61,81,52,48,
94,75,46,8,12,16,9,68,5,8,5,253,7,18,28,15,
43,3,112,25,45,62,37,91,103,2,1,3,1,103,1,1,
0,1,0,94,255,226,2,188,3,192,0,69,1,207,184,0,
70,47,184,0,71,47,184,0,0,220,184,0,70,16,184,0,
36,208,184,0,36,47,184,0,10,208,184,0,10,47,184,0,
36,16,184,0,15,208,184,0,15,47,184,0,0,16,185,0,
26,0,4,252,65,5,0,154,0,26,0,170,0,26,0,2,
93,65,19,0,9,0,26,0,25,0,26,0,41,0,26,0,
57,0,26,0,73,0,26,0,89,0,26,0,105,0,26,0,
121,0,26,0,137,0,26,0,9,93,184,0,52,208,184,0,
52,47,184,0,36,16,185,0,60,0,4,252,65,19,0,6,
0,60,0,22,0,60,0,38,0,60,0,54,0,60,0,70,
0,60,0,86,0,60,0,102,0,60,0,118,0,60,0,134,
0,60,0,9,93,65,5,0,149,0,60,0,165,0,60,0,
2,93,0,184,0,0,69,88,184,0,41,47,27,185,0,41,
0,9,62,89,184,0,0,69,88,184,0,7,47,27,185,0,
7,0,5,62,89,185,0,21,0,2,252,65,33,0,7,0,
21,0,23,0,21,0,39,0,21,0,55,0,21,0,71,0,
21,0,87,0,21,0,103,0,21,0,119,0,21,0,135,0,
21,0,151,0,21,0,167,0,21,0,183,0,21,0,199,0,
21,0,215,0,21,0,231,0,21,0,247,0,21,0,16,93,
65,15,0,7,0,21,0,23,0,21,0,39,0,21,0,55,
0,21,0,71,0,21,0,87,0,21,0,103,0,21,0,7,
113,65,5,0,118,0,21,0,134,0,21,0,2,113,184,0,
41,16,185,0,55,0,2,252,65,5,0,121,0,55,0,137,
0,55,0,2,113,65,33,0,8,0,55,0,24,0,55,0,
40,0,55,0,56,0,55,0,72,0,55,0,88,0,55,0,
104,0,55,0,120,0,55,0,136,0,55,0,152,0,55,0,
168,0,55,0,184,0,55,0,200,0,55,0,216,0,55,0,
232,0,55,0,248,0,55,0,16,93,65,15,0,8,0,55,
0,24,0,55,0,40,0,55,0,56,0,55,0,72,0,55,
0,88,0,55,0,104,0,55,0,7,113,48,49,1,20,14,
4,35,34,38,39,46,1,62,1,55,23,30,3,51,50,62,
2,53,52,46,2,39,46,3,53,52,62,2,51,50,30,2,
23,22,14,2,7,39,46,1,35,34,14,2,21,20,30,2,
23,30,3,2,188,40,64,78,76,67,19,48,135,67,7,5,
3,9,7,43,2,40,67,89,52,36,60,44,24,43,70,89,
46,42,78,61,37,50,83,107,57,31,75,73,64,20,6,9,
19,22,6,39,48,103,49,33,52,37,19,38,62,79,42,43,
88,70,44,1,27,71,101,70,42,22,7,36,37,3,59,77,
78,23,11,42,74,56,32,23,42,59,35,40,62,51,45,24,
21,48,60,74,48,62,97,66,35,11,20,28,18,6,42,50,
44,8,8,72,57,22,35,42,21,32,51,45,41,22,22,50,
65,83,0,2,0,70,0,0,1,244,5,36,0,14,0,37,
0,121,187,0,0,0,4,0,8,0,4,43,65,5,0,154,
0,8,0,170,0,8,0,2,93,65,19,0,9,0,8,0,
25,0,8,0,41,0,8,0,57,0,8,0,73,0,8,0,
89,0,8,0,105,0,8,0,121,0,8,0,137,0,8,0,
9,93,186,0,19,0,8,0,0,17,18,57,184,0,19,47,
185,0,33,0,4,252,0,184,0,0,69,88,184,0,31,47,
27,185,0,31,0,9,62,89,184,0,0,69,88,184,0,15,
47,27,185,0,15,0,5,62,89,48,49,1,20,14,2,35,
34,38,53,52,62,2,51,50,1,53,62,1,53,17,52,46,
2,39,53,62,3,55,51,17,20,22,23,21,1,134,18,31,
42,25,45,39,18,32,41,24,85,254,192,68,72,4,26,57,
53,31,69,68,62,26,34,67,73,4,197,28,50,37,22,50,
46,28,50,37,21,250,220,43,14,33,14,2,54,51,63,35,
16,5,40,6,17,21,24,12,252,168,12,35,14,43,0,2,
255,16,254,12,1,109,5,36,0,14,0,57,0,246,187,0,
0,0,4,0,8,0,4,43,65,5,0,154,0,8,0,170,
0,8,0,2,93,65,19,0,9,0,8,0,25,0,8,0,
41,0,8,0,57,0,8,0,73,0,8,0,89,0,8,0,
105,0,8,0,121,0,8,0,137,0,8,0,9,93,186,0,
43,0,8,0,0,17,18,57,184,0,43,47,185,0,15,0,
4,252,184,0,56,208,0,184,0,0,69,88,184,0,55,47,
27,185,0,55,0,9,62,89,184,0,0,69,88,184,0,25,
47,27,185,0,25,0,7,62,89,185,0,38,0,2,252,65,
33,0,7,0,38,0,23,0,38,0,39,0,38,0,55,0,
38,0,71,0,38,0,87,0,38,0,103,0,38,0,119,0,
38,0,135,0,38,0,151,0,38,0,167,0,38,0,183,0,
38,0,199,0,38,0,215,0,38,0,231,0,38,0,247,0,
38,0,16,93,65,15,0,7,0,38,0,23,0,38,0,39,
0,38,0,55,0,38,0,71,0,38,0,87,0,38,0,103,
0,38,0,7,113,65,5,0,118,0,38,0,134,0,38,0,
2,113,48,49,1,20,14,2,35,34,38,53,52,62,2,51,
50,3,20,14,2,7,14,3,35,34,46,2,53,52,62,2,
55,30,1,51,50,62,2,53,17,52,46,2,39,53,62,3,
55,51,17,1,109,18,31,42,24,45,39,18,31,42,24,84,
30,29,51,70,40,27,60,60,53,19,31,59,47,29,29,40,
43,15,32,68,38,29,57,46,28,5,26,57,52,42,65,59,
55,32,37,4,197,28,50,37,22,50,46,28,50,37,21,251,
63,115,161,113,78,32,21,37,27,15,15,22,24,8,9,31,
34,30,7,28,17,37,92,158,121,2,115,51,62,35,16,6,
40,7,18,19,23,13,252,163,0,1,0,70,0,0,2,8,
4,236,0,19,0,51,187,0,15,0,4,0,4,0,4,43,
184,0,15,16,0,184,0,0,69,88,184,0,9,47,27,185,
0,9,0,11,62,89,184,0,0,69,88,184,0,0,47,27,
185,0,0,0,5,62,89,48,49,51,53,62,1,53,17,52,
38,39,53,33,21,14,1,21,17,20,22,23,21,70,68,77,
73,72,1,194,68,77,73,72,43,14,33,14,4,27,12,36,
14,43,43,14,34,14,251,229,12,35,14,43,0,1,0,10,
255,228,4,176,4,236,0,54,0,65,187,0,22,0,4,0,
31,0,4,43,184,0,22,16,184,0,56,220,0,184,0,0,
69,88,184,0,16,47,27,185,0,16,0,11,62,89,184,0,
0,69,88,184,0,26,47,27,185,0,26,0,5,62,89,184,
0,16,16,185,0,37,0,2,252,48,49,55,62,3,55,62,
3,55,46,3,39,53,33,21,14,1,21,17,20,22,23,21,
33,53,62,1,53,17,52,46,2,43,1,34,14,2,7,14,
3,7,14,3,47,1,18,36,76,74,72,32,18,32,25,17,
4,5,32,49,62,36,3,212,69,76,72,73,254,62,68,77,
11,29,53,42,126,24,46,37,24,1,9,20,26,33,21,21,
40,43,52,34,193,71,3,29,72,126,100,56,160,195,223,120,
7,16,16,16,7,43,43,14,34,14,251,229,12,35,14,43,
43,14,33,14,3,238,12,24,20,13,5,13,24,18,130,227,
201,179,83,83,125,81,38,5,36,0,0,2,0,0,0,0,
6,0,4,236,0,7,0,76,0,134,187,0,49,0,4,0,
0,0,4,43,184,0,49,16,184,0,0,16,184,0,16,208,
184,0,49,16,184,0,63,208,0,184,0,0,69,88,184,0,
35,47,27,185,0,35,0,11,62,89,184,0,0,69,88,184,
0,11,47,27,185,0,11,0,5,62,89,184,0,0,69,88,
184,0,23,47,27,185,0,23,0,5,62,89,187,0,7,0,
2,0,17,0,4,43,184,0,7,16,184,0,35,16,185,0,
48,0,2,252,184,0,7,16,184,0,50,208,184,0,17,16,
184,0,62,208,184,0,11,16,185,0,69,0,2,252,48,49,
1,52,38,14,1,7,3,51,1,14,1,7,33,53,62,1,
53,17,33,3,6,22,23,21,33,53,62,1,55,1,54,46,
2,39,53,33,23,14,3,7,35,46,3,35,33,17,33,23,
14,3,7,46,3,43,1,17,20,30,2,59,1,50,62,2,
55,23,3,6,19,26,26,7,157,235,2,250,9,26,8,252,
162,68,75,254,244,221,13,62,82,254,96,68,77,13,1,157,
7,21,50,77,49,4,33,30,2,7,11,14,7,45,2,12,
20,29,19,254,148,1,147,27,9,22,25,25,11,15,34,46,
62,42,139,15,43,81,66,129,46,65,49,40,21,45,4,123,
11,10,3,18,17,254,117,254,21,87,128,29,43,14,33,14,
2,39,253,224,29,30,9,43,43,12,27,29,3,254,17,23,
19,16,9,43,25,26,62,62,56,19,46,61,37,15,254,78,
28,14,31,29,25,8,15,20,14,6,254,11,15,23,17,9,
10,35,68,59,18,0,0,3,0,80,255,226,5,57,3,192,
0,13,0,35,0,123,2,85,187,0,26,0,4,0,77,0,
4,43,184,0,26,16,187,0,44,0,4,0,19,0,4,43,
184,0,44,16,187,0,36,0,4,0,9,0,4,43,184,0,
36,16,65,5,0,154,0,9,0,170,0,9,0,2,93,65,
19,0,9,0,9,0,25,0,9,0,41,0,9,0,57,0,
9,0,73,0,9,0,89,0,9,0,105,0,9,0,121,0,
9,0,137,0,9,0,9,93,184,0,19,16,184,0,17,208,
65,19,0,6,0,26,0,22,0,26,0,38,0,26,0,54,
0,26,0,70,0,26,0,86,0,26,0,102,0,26,0,118,
0,26,0,134,0,26,0,9,93,65,5,0,149,0,26,0,
165,0,26,0,2,93,184,0,44,16,184,0,42,208,186,0,
67,0,19,0,44,17,18,57,184,0,19,16,184,0,85,208,
186,0,112,0,19,0,44,17,18,57,184,0,36,16,184,0,
125,220,0,184,0,0,69,88,184,0,109,47,27,185,0,109,
0,9,62,89,184,0,0,69,88,184,0,117,47,27,185,0,
117,0,9,62,89,184,0,0,69,88,184,0,62,47,27,185,
0,62,0,5,62,89,184,0,0,69,88,184,0,72,47,27,
185,0,72,0,5,62,89,187,0,6,0,2,0,39,0,4,
43,184,0,6,16,184,0,117,16,185,0,0,0,2,252,65,
5,0,121,0,0,0,137,0,0,0,2,113,65,33,0,8,
0,0,0,24,0,0,0,40,0,0,0,56,0,0,0,72,
0,0,0,88,0,0,0,104,0,0,0,120,0,0,0,136,
0,0,0,152,0,0,0,168,0,0,0,184,0,0,0,200,
0,0,0,216,0,0,0,232,0,0,0,248,0,0,0,16,
93,65,15,0,8,0,0,0,24,0,0,0,40,0,0,0,
56,0,0,0,72,0,0,0,88,0,0,0,104,0,0,0,
7,113,184,0,39,16,184,0,20,208,184,0,20,47,184,0,
72,16,185,0,31,0,2,252,65,33,0,7,0,31,0,23,
0,31,0,39,0,31,0,55,0,31,0,71,0,31,0,87,
0,31,0,103,0,31,0,119,0,31,0,135,0,31,0,151,
0,31,0,167,0,31,0,183,0,31,0,199,0,31,0,215,
0,31,0,231,0,31,0,247,0,31,0,16,93,65,15,0,
7,0,31,0,23,0,31,0,39,0,31,0,55,0,31,0,
71,0,31,0,87,0,31,0,103,0,31,0,7,113,65,5,
0,118,0,31,0,134,0,31,0,2,113,184,0,49,208,186,
0,67,0,62,0,109,17,18,57,184,0,6,16,184,0,85,
208,184,0,85,47,184,0,0,16,184,0,91,208,184,0,91,
47,186,0,112,0,62,0,109,17,18,57,48,49,1,34,14,
2,7,33,50,54,53,52,46,2,1,46,1,61,3,14,1,
7,14,1,21,20,30,2,51,50,62,2,1,14,1,7,33,
6,21,20,21,20,30,2,51,50,62,2,55,30,1,23,14,
3,35,34,46,2,39,14,3,35,34,46,2,53,52,62,2,
55,62,1,55,53,52,46,2,35,34,14,2,23,22,14,2,
47,1,62,5,51,50,22,23,62,3,51,50,30,4,3,227,
23,61,60,53,13,1,92,21,17,20,42,67,254,107,7,7,
33,52,12,150,134,25,34,38,13,27,68,75,78,2,225,20,
60,32,254,63,2,31,60,87,56,31,57,65,78,53,13,19,
5,60,100,91,87,47,44,85,75,61,21,43,101,100,90,31,
36,76,61,40,47,94,144,98,33,83,44,12,34,61,49,32,
72,56,27,15,3,43,59,59,12,14,5,48,71,88,91,86,
35,88,103,23,32,72,73,69,29,61,94,69,48,29,12,3,
88,21,60,108,87,15,21,48,87,66,39,253,155,29,60,33,
7,3,110,2,6,4,37,125,82,40,50,29,10,18,35,54,
1,94,20,35,13,17,18,17,19,58,113,90,55,7,27,54,
46,7,26,8,72,88,48,17,28,54,77,50,52,78,53,26,
24,52,82,58,59,109,94,77,28,9,11,3,86,39,72,54,
33,29,51,67,37,9,22,18,9,3,36,39,76,67,57,41,
23,72,72,40,56,33,15,35,59,80,89,95,0,2,0,80,
255,226,4,18,5,10,0,13,0,60,1,209,184,0,61,47,
184,0,62,47,184,0,14,220,185,0,36,0,4,252,65,5,
0,154,0,36,0,170,0,36,0,2,93,65,19,0,9,0,
36,0,25,0,36,0,41,0,36,0,57,0,36,0,73,0,
36,0,89,0,36,0,105,0,36,0,121,0,36,0,137,0,
36,0,9,93,184,0,5,208,184,0,5,47,184,0,61,16,
184,0,24,208,184,0,24,47,185,0,9,0,4,252,65,19,
0,6,0,9,0,22,0,9,0,38,0,9,0,54,0,9,
0,70,0,9,0,86,0,9,0,102,0,9,0,118,0,9,
0,134,0,9,0,9,93,65,5,0,149,0,9,0,165,0,
9,0,2,93,184,0,36,16,184,0,33,208,184,0,33,47,
0,184,0,0,69,88,184,0,56,47,27,185,0,56,0,11,
62,89,184,0,0,69,88,184,0,19,47,27,185,0,19,0,
5,62,89,187,0,33,0,2,0,5,0,4,43,184,0,33,
16,184,0,19,16,185,0,0,0,2,252,65,33,0,7,0,
0,0,23,0,0,0,39,0,0,0,55,0,0,0,71,0,
0,0,87,0,0,0,103,0,0,0,119,0,0,0,135,0,
0,0,151,0,0,0,167,0,0,0,183,0,0,0,199,0,
0,0,215,0,0,0,231,0,0,0,247,0,0,0,16,93,
65,15,0,7,0,0,0,23,0,0,0,39,0,0,0,55,
0,0,0,71,0,0,0,87,0,0,0,103,0,0,0,7,
113,65,5,0,118,0,0,0,134,0,0,0,2,113,184,0,
56,16,185,0,41,0,2,252,65,5,0,121,0,41,0,137,
0,41,0,2,113,65,33,0,8,0,41,0,24,0,41,0,
40,0,41,0,56,0,41,0,72,0,41,0,88,0,41,0,
104,0,41,0,120,0,41,0,136,0,41,0,152,0,41,0,
168,0,41,0,184,0,41,0,200,0,41,0,216,0,41,0,
232,0,41,0,248,0,41,0,16,93,65,15,0,8,0,41,
0,24,0,41,0,40,0,41,0,56,0,41,0,72,0,41,
0,88,0,41,0,104,0,41,0,7,113,48,49,37,50,62,
2,55,33,34,6,21,20,30,2,1,20,2,14,1,35,34,
46,2,53,52,54,55,62,3,51,33,52,54,53,52,46,2,
35,34,14,2,7,46,3,39,62,3,51,50,30,2,2,28,
62,112,90,63,12,253,209,29,39,46,78,105,2,49,79,144,
201,123,98,154,107,56,13,22,23,61,56,44,7,2,67,1,
77,121,148,72,27,67,83,101,60,5,11,10,8,2,67,118,
108,100,51,94,181,142,87,84,43,99,158,116,65,56,54,106,
84,51,2,82,158,254,252,187,103,70,111,137,66,35,82,31,
14,31,26,17,12,25,14,133,199,134,67,11,31,54,42,2,
13,14,13,3,67,82,45,15,82,157,228,0,0,2,0,70,
255,226,3,82,3,192,0,11,0,52,1,179,184,0,53,47,
184,0,54,47,184,0,12,220,185,0,30,0,4,252,184,0,
3,208,184,0,3,47,184,0,53,16,184,0,23,208,184,0,
23,47,185,0,7,0,4,252,65,19,0,6,0,7,0,22,
0,7,0,38,0,7,0,54,0,7,0,70,0,7,0,86,
0,7,0,102,0,7,0,118,0,7,0,134,0,7,0,9,
93,65,5,0,149,0,7,0,165,0,7,0,2,93,184,0,
30,16,184,0,15,208,184,0,15,47,184,0,7,16,184,0,
29,208,184,0,29,47,184,0,23,16,184,0,43,208,184,0,
43,47,0,184,0,0,69,88,184,0,48,47,27,185,0,48,
0,9,62,89,184,0,0,69,88,184,0,18,47,27,185,0,
18,0,5,62,89,187,0,30,0,2,0,3,0,4,43,184,
0,30,16,184,0,18,16,185,0,0,0,2,252,65,33,0,
7,0,0,0,23,0,0,0,39,0,0,0,55,0,0,0,
71,0,0,0,87,0,0,0,103,0,0,0,119,0,0,0,
135,0,0,0,151,0,0,0,167,0,0,0,183,0,0,0,
199,0,0,0,215,0,0,0,231,0,0,0,247,0,0,0,
16,93,65,15,0,7,0,0,0,23,0,0,0,39,0,0,
0,55,0,0,0,71,0,0,0,87,0,0,0,103,0,0,
0,7,113,65,5,0,118,0,0,0,134,0,0,0,2,113,
184,0,48,16,185,0,35,0,2,252,65,5,0,121,0,35,
0,137,0,35,0,2,113,65,33,0,8,0,35,0,24,0,
35,0,40,0,35,0,56,0,35,0,72,0,35,0,88,0,
35,0,104,0,35,0,120,0,35,0,136,0,35,0,152,0,
35,0,168,0,35,0,184,0,35,0,200,0,35,0,216,0,
35,0,232,0,35,0,248,0,35,0,16,93,65,15,0,8,
0,35,0,24,0,35,0,40,0,35,0,56,0,35,0,72,
0,35,0,88,0,35,0,104,0,35,0,7,113,48,49,37,
50,54,55,33,34,6,21,20,30,2,1,20,6,7,14,1,
35,34,46,2,53,52,54,55,62,1,55,33,46,3,35,34,
14,2,7,46,1,39,62,3,51,50,30,2,1,188,115,126,
12,254,112,31,35,38,61,76,1,188,79,69,57,139,90,72,
126,94,54,19,17,29,70,35,1,203,2,49,81,109,61,27,
56,66,80,51,13,20,6,61,103,93,88,46,73,137,107,64,
74,155,152,48,40,47,80,59,33,1,155,118,203,74,62,58,
47,83,113,66,40,66,23,15,32,14,82,132,93,49,8,24,
45,37,6,29,8,64,81,45,16,65,122,177,0,1,0,94,
255,226,3,208,4,252,0,69,1,38,187,0,0,0,4,0,
25,0,4,43,65,5,0,154,0,25,0,170,0,25,0,2,
93,65,19,0,9,0,25,0,25,0,25,0,41,0,25,0,
57,0,25,0,73,0,25,0,89,0,25,0,105,0,25,0,
121,0,25,0,137,0,25,0,9,93,0,184,0,0,69,88,
184,0,53,47,27,185,0,53,0,11,62,89,184,0,0,69,
88,184,0,57,47,27,185,0,57,0,11,62,89,184,0,0,
69,88,184,0,59,47,27,185,0,59,0,11,62,89,184,0,
0,69,88,184,0,5,47,27,185,0,5,0,5,62,89,187,
0,65,0,2,0,30,0,4,43,184,0,65,16,184,0,5,
16,185,0,20,0,2,252,65,33,0,7,0,20,0,23,0,
20,0,39,0,20,0,55,0,20,0,71,0,20,0,87,0,
20,0,103,0,20,0,119,0,20,0,135,0,20,0,151,0,
20,0,167,0,20,0,183,0,20,0,199,0,20,0,215,0,
20,0,231,0,20,0,247,0,20,0,16,93,65,15,0,7,
0,20,0,23,0,20,0,39,0,20,0,55,0,20,0,71,
0,20,0,87,0,20,0,103,0,20,0,7,113,65,5,0,
118,0,20,0,134,0,20,0,2,113,184,0,59,16,185,0,
45,0,2,252,186,0,62,0,30,0,65,17,18,57,48,49,
1,20,14,2,35,34,46,2,53,52,62,2,55,30,3,51,
50,62,2,53,52,46,2,35,34,6,15,1,39,46,1,47,
1,53,48,49,50,53,1,33,34,14,2,7,39,19,30,2,
51,50,51,33,23,1,62,1,51,50,30,2,3,208,81,135,
177,95,86,145,105,58,28,42,48,21,21,66,79,86,42,63,
110,80,46,40,76,108,68,45,80,48,49,2,7,20,5,1,
1,1,156,254,130,16,37,36,31,10,57,30,21,37,39,23,
24,32,2,57,25,254,164,17,32,16,65,122,94,57,1,178,
106,171,121,66,45,60,61,17,6,34,37,32,3,37,64,47,
27,34,72,111,76,60,112,85,52,27,23,25,2,6,26,8,
2,1,1,1,241,27,51,73,46,12,1,45,6,7,3,43,
254,81,3,4,46,91,134,0,0,1,0,38,254,12,3,82,
3,178,0,59,1,42,187,0,0,0,4,0,23,0,4,43,
65,5,0,154,0,23,0,170,0,23,0,2,93,65,19,0,
9,0,23,0,25,0,23,0,41,0,23,0,57,0,23,0,
73,0,23,0,89,0,23,0,105,0,23,0,121,0,23,0,
137,0,23,0,9,93,0,184,0,0,69,88,184,0,43,47,
27,185,0,43,0,9,62,89,184,0,0,69,88,184,0,47,
47,27,185,0,47,0,9,62,89,184,0,0,69,88,184,0,
49,47,27,185,0,49,0,9,62,89,184,0,0,69,88,184,
0,5,47,27,185,0,5,0,7,62,89,187,0,55,0,2,
0,28,0,4,43,184,0,55,16,184,0,5,16,185,0,18,
0,2,252,65,33,0,7,0,18,0,23,0,18,0,39,0,
18,0,55,0,18,0,71,0,18,0,87,0,18,0,103,0,
18,0,119,0,18,0,135,0,18,0,151,0,18,0,167,0,
18,0,183,0,18,0,199,0,18,0,215,0,18,0,231,0,
18,0,247,0,18,0,16,93,65,15,0,7,0,18,0,23,
0,18,0,39,0,18,0,55,0,18,0,71,0,18,0,87,
0,18,0,103,0,18,0,7,113,65,5,0,118,0,18,0,
134,0,18,0,2,113,184,0,49,16,185,0,35,0,2,252,
184,0,36,208,186,0,52,0,28,0,55,17,18,57,48,49,
5,20,14,2,35,34,46,2,53,52,62,2,55,30,1,51,
50,62,2,53,52,46,2,7,34,6,7,46,1,39,1,33,
34,14,2,7,39,55,30,2,51,50,51,33,23,1,62,1,
51,30,3,3,82,83,134,167,84,71,126,93,54,28,42,48,
21,58,119,67,60,102,75,42,44,85,123,79,41,79,40,7,
23,5,1,172,254,172,16,33,31,27,10,49,19,21,37,39,
23,24,32,1,233,25,254,115,17,32,16,80,138,101,58,26,
106,174,125,69,38,53,55,17,6,29,32,27,3,75,80,42,
81,119,76,67,128,99,59,2,14,14,5,31,8,2,38,12,
33,59,46,12,244,6,7,3,43,253,252,2,2,2,54,102,
148,0,0,3,0,70,255,226,4,114,5,10,0,10,0,21,
0,41,1,101,184,0,42,47,184,0,43,47,184,0,42,16,
184,0,32,208,184,0,32,47,185,0,17,0,4,252,184,0,
5,208,184,0,5,47,184,0,43,16,184,0,22,220,185,0,
16,0,4,252,184,0,6,208,184,0,6,47,0,184,0,0,
69,88,184,0,37,47,27,185,0,37,0,11,62,89,184,0,
0,69,88,184,0,27,47,27,185,0,27,0,5,62,89,187,
0,6,0,2,0,16,0,4,43,184,0,6,16,184,0,37,
16,185,0,0,0,2,252,65,5,0,121,0,0,0,137,0,
0,0,2,113,65,33,0,8,0,0,0,24,0,0,0,40,
0,0,0,56,0,0,0,72,0,0,0,88,0,0,0,104,
0,0,0,120,0,0,0,136,0,0,0,152,0,0,0,168,
0,0,0,184,0,0,0,200,0,0,0,216,0,0,0,232,
0,0,0,248,0,0,0,16,93,65,15,0,8,0,0,0,
24,0,0,0,40,0,0,0,56,0,0,0,72,0,0,0,
88,0,0,0,104,0,0,0,7,113,184,0,27,16,185,0,
11,0,2,252,65,33,0,7,0,11,0,23,0,11,0,39,
0,11,0,55,0,11,0,71,0,11,0,87,0,11,0,103,
0,11,0,119,0,11,0,135,0,11,0,151,0,11,0,167,
0,11,0,183,0,11,0,199,0,11,0,215,0,11,0,231,
0,11,0,247,0,11,0,16,93,65,15,0,7,0,11,0,
23,0,11,0,39,0,11,0,55,0,11,0,71,0,11,0,
87,0,11,0,103,0,11,0,7,113,65,5,0,118,0,11,
0,134,0,11,0,2,113,48,49,1,34,14,2,7,33,46,
3,3,50,62,2,55,33,30,3,1,20,14,2,35,34,46,
2,53,52,62,2,51,50,30,2,2,92,83,134,96,58,6,
2,240,9,62,97,130,77,82,137,100,57,2,253,11,4,63,
103,134,2,97,90,155,204,114,120,188,129,68,88,152,205,118,
124,188,128,65,4,152,66,122,175,108,93,170,130,78,251,194,
67,133,196,129,108,191,143,83,2,45,136,245,186,110,106,178,
232,126,136,246,186,110,109,180,232,0,0,3,0,80,255,226,
3,182,3,192,0,10,0,21,0,45,1,101,184,0,46,47,
184,0,47,47,184,0,22,220,185,0,5,0,4,252,184,0,
46,16,184,0,34,208,184,0,34,47,185,0,16,0,4,252,
184,0,6,208,184,0,6,47,184,0,5,16,184,0,17,208,
184,0,17,47,0,184,0,0,69,88,184,0,41,47,27,185,
0,41,0,9,62,89,184,0,0,69,88,184,0,29,47,27,
185,0,29,0,5,62,89,187,0,17,0,2,0,5,0,4,
43,184,0,17,16,184,0,29,16,185,0,0,0,2,252,65,
33,0,7,0,0,0,23,0,0,0,39,0,0,0,55,0,
0,0,71,0,0,0,87,0,0,0,103,0,0,0,119,0,
0,0,135,0,0,0,151,0,0,0,167,0,0,0,183,0,
0,0,199,0,0,0,215,0,0,0,231,0,0,0,247,0,
0,0,16,93,65,15,0,7,0,0,0,23,0,0,0,39,
0,0,0,55,0,0,0,71,0,0,0,87,0,0,0,103,
0,0,0,7,113,65,5,0,118,0,0,0,134,0,0,0,
2,113,184,0,41,16,185,0,11,0,2,252,65,5,0,121,
0,11,0,137,0,11,0,2,113,65,33,0,8,0,11,0,
24,0,11,0,40,0,11,0,56,0,11,0,72,0,11,0,
88,0,11,0,104,0,11,0,120,0,11,0,136,0,11,0,
152,0,11,0,168,0,11,0,184,0,11,0,200,0,11,0,
216,0,11,0,232,0,11,0,248,0,11,0,16,93,65,15,
0,8,0,11,0,24,0,11,0,40,0,11,0,56,0,11,
0,72,0,11,0,88,0,11,0,104,0,11,0,7,113,48,
49,37,50,62,2,55,33,30,3,19,34,14,2,7,33,46,
3,1,20,14,4,35,34,46,2,53,52,62,4,51,50,30,
2,2,12,66,99,67,36,4,253,209,10,61,81,93,24,72,
102,65,31,3,2,49,8,57,80,96,1,141,34,60,84,101,
114,61,95,153,109,59,33,59,83,101,116,63,94,153,109,59,
80,47,87,124,77,70,122,91,52,3,2,52,93,126,74,71,
125,94,55,254,147,66,129,114,97,70,39,72,126,174,102,66,
128,115,97,70,40,72,127,174,0,1,0,70,255,226,4,121,
5,10,0,63,1,153,184,0,64,47,184,0,65,47,184,0,
44,220,184,0,0,208,184,0,0,47,184,0,64,16,184,0,
54,208,184,0,54,47,185,0,18,0,4,252,65,19,0,6,
0,18,0,22,0,18,0,38,0,18,0,54,0,18,0,70,
0,18,0,86,0,18,0,102,0,18,0,118,0,18,0,134,
0,18,0,9,93,65,5,0,149,0,18,0,165,0,18,0,
2,93,184,0,44,16,185,0,26,0,4,252,184,0,44,16,
184,0,38,208,184,0,44,16,184,0,42,208,184,0,42,47,
0,184,0,0,69,88,184,0,59,47,27,185,0,59,0,11,
62,89,184,0,0,69,88,184,0,49,47,27,185,0,49,0,
5,62,89,184,0,59,16,185,0,11,0,2,252,65,5,0,
121,0,11,0,137,0,11,0,2,113,65,33,0,8,0,11,
0,24,0,11,0,40,0,11,0,56,0,11,0,72,0,11,
0,88,0,11,0,104,0,11,0,120,0,11,0,136,0,11,
0,152,0,11,0,168,0,11,0,184,0,11,0,200,0,11,
0,216,0,11,0,232,0,11,0,248,0,11,0,16,93,65,
15,0,8,0,11,0,24,0,11,0,40,0,11,0,56,0,
11,0,72,0,11,0,88,0,11,0,104,0,11,0,7,113,
184,0,49,16,185,0,23,0,2,252,65,33,0,7,0,23,
0,23,0,23,0,39,0,23,0,55,0,23,0,71,0,23,
0,87,0,23,0,103,0,23,0,119,0,23,0,135,0,23,
0,151,0,23,0,167,0,23,0,183,0,23,0,199,0,23,
0,215,0,23,0,231,0,23,0,247,0,23,0,16,93,65,
15,0,7,0,23,0,23,0,23,0,39,0,23,0,55,0,
23,0,71,0,23,0,87,0,23,0,103,0,23,0,7,113,
65,5,0,118,0,23,0,134,0,23,0,2,113,48,49,1,
22,14,2,7,39,46,3,35,34,14,4,21,20,30,2,51,
50,54,55,17,52,46,2,39,53,33,21,14,1,21,17,48,
6,7,22,23,14,3,35,34,46,2,53,52,18,62,1,51,
50,30,2,4,18,7,18,33,39,13,33,33,70,77,86,49,
25,75,83,84,66,42,75,120,151,76,73,123,49,19,47,79,
61,1,205,57,48,2,2,2,2,74,117,98,88,45,101,196,
155,96,105,182,243,137,33,79,82,79,4,164,5,29,36,35,
12,6,31,41,22,9,23,51,83,121,161,104,139,206,135,67,
29,27,1,83,11,21,20,20,10,43,43,14,45,23,254,187,
2,1,1,2,61,72,39,12,75,153,229,155,166,1,7,183,
96,14,26,38,0,42,0,43,0,80,0,110,0,130,0,0,
0,30,254,32,0,20,3,162,0,30,4,236,0,57,0,0,
0,1,0,0,0,1,5,31,104,253,89,95,95,15,60,245,
0,17,8,0,0,0,0,0,185,172,33,0,0,0,0,0,
191,166,190,128,251,217,253,158,10,98,8,121,0,0,0,9,
0,2,0,1,0,0,0,0,0,1,0,0,6,223,253,203,
0,45,10,123,251,217,252,191,10,98,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,6,163,0,2,0,0,
0,0,0,0,255,208,0,14,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,6,163,0,0,
0,1,0,2,0,3,0,7,0,8,0,9,0,10,0,11,
0,12,0,13,0,14,0,15,0,16,0,17,0,18,0,19,
0,20,0,21,0,22,0,23,0,24,0,25,0,26,0,27,
0,28,0,29,0,30,0,31,0,32,0,33,0,34,0,35,
0,36,0,37,0,38,0,39,0,40,0,41,0,42,0,43,
0,44,0,45,0,46,0,47,0,48,0,49,0,50,0,51,
0,52,0,53,0,54,0,55,0,56,0,57,0,58,0,59,
0,60,0,61,0,62,0,63,0,64,0,65,0,66,0,67,
0,68,0,69,0,70,0,71,0,72,0,73,0,74,0,75,
0,76,0,77,0,78,0,79,0,80,0,81,0,82,0,83,
0,84,0,85,0,86,0,87,0,88,0,89,0,90,0,91,
0,92,0,93,0,94,0,95,0,96,0,97,1,2,0,163,
0,132,0,133,0,189,0,150,0,134,0,142,0,139,0,157,
0,169,0,164,0,138,0,218,0,131,0,147,0,141,0,151,
0,136,0,195,0,222,0,158,0,170,0,162,0,173,0,201,
0,199,0,174,0,98,0,99,0,144,0,100,0,203,0,101,
0,200,0,202,0,207,0,204,0,205,0,206,0,102,0,211,
0,208,0,209,0,175,0,103,0,145,0,214,0,212,0,213,
0,104,0,137,0,106,0,105,0,107,0,109,0,108,0,110,
0,160,0,111,0,113,0,112,0,114,0,115,0,117,0,116,
0,118,0,119,0,120,0,122,0,121,0,123,0,125,0,124,
0,184,0,161,0,127,0,126,0,128,0,129,0,186,0,215,
0,176,0,177,0,187,0,166,0,216,0,225,0,219,0,220,
0,221,0,224,0,217,0,223,0,155,0,178,0,179,0,182,
0,183,0,196,0,180,0,181,0,197,0,130,0,194,0,135,
0,171,0,198,0,190,0,191,0,140,0,192,0,193,0,6,
0,4,0,5,0,232,1,3,0,242,0,243,0,241,0,245,
0,244,0,246,0,233,0,240,0,235,0,237,0,234,0,236,
0,238,1,4,1,5,1,6,1,7,1,8,1,9,0,253,
0,254,1,10,1,11,1,12,1,13,0,255,1,0,1,14,
1,15,1,16,1,1,1,17,1,18,1,19,1,20,1,21,
1,22,1,23,1,24,1,25,1,26,1,27,1,28,0,248,
0,249,1,29,1,30,1,31,1,32,1,33,1,34,1,35,
1,36,1,37,1,38,1,39,1,40,1,41,1,42,1,43,
1,44,0,250,1,45,1,46,1,47,1,48,1,49,1,50,
1,51,1,52,1,53,1,54,1,55,1,56,1,57,1,58,
1,59,0,226,0,227,1,60,1,61,1,62,1,63,1,64,
1,65,1,66,1,67,1,68,1,69,1,70,1,71,1,72,
1,73,1,74,1,75,1,76,1,77,1,78,1,79,1,80,
1,81,1,82,1,83,1,84,0,251,0,252,0,228,0,229,
1,85,1,86,1,87,1,88,1,89,1,90,1,91,1,92,
1,93,1,94,1,95,1,96,1,97,1,98,1,99,1,100,
1,101,1,102,1,103,1,104,1,105,1,106,1,107,1,108,
1,109,1,110,0,230,0,231,1,111,1,112,1,113,1,114,
1,115,1,116,1,117,1,118,1,119,1,120,1,121,1,122,
1,123,1,124,1,125,1,126,1,127,1,128,1,129,1,130,
1,131,1,132,1,133,1,134,1,135,1,136,1,137,1,138,
1,139,1,140,1,141,1,142,1,143,1,144,1,145,1,146,
1,147,1,148,1,149,1,150,1,151,1,152,1,153,1,154,
1,155,1,156,1,157,1,158,1,159,1,160,1,161,1,162,
1,163,1,164,1,165,1,166,1,167,1,168,1,169,1,170,
1,171,1,172,1,173,1,174,1,175,1,176,1,177,1,178,
1,179,1,180,1,181,1,182,1,183,1,184,1,185,1,186,
1,187,1,188,1,189,1,190,1,191,1,192,1,193,1,194,
1,195,1,196,1,197,1,198,1,199,1,200,1,201,1,202,
1,203,1,204,1,205,1,206,1,207,1,208,1,209,1,210,
1,211,1,212,1,213,1,214,1,215,1,216,1,217,1,218,
1,219,1,220,1,221,1,222,1,223,1,224,1,225,1,226,
1,227,1,228,1,229,1,230,1,231,1,232,1,233,1,234,
1,235,1,236,1,237,1,238,1,239,1,240,1,241,1,242,
1,243,1,244,1,245,1,246,1,247,1,248,1,249,1,250,
1,251,1,252,1,253,1,254,1,255,2,0,2,1,2,2,
2,3,2,4,2,5,2,6,2,7,2,8,2,9,2,10,
2,11,2,12,2,13,2,14,2,15,2,16,2,17,2,18,
2,19,2,20,2,21,2,22,2,23,2,24,2,25,2,26,
2,27,2,28,2,29,2,30,2,31,2,32,2,33,2,34,
2,35,2,36,2,37,2,38,2,39,2,40,2,41,2,42,
2,43,2,44,2,45,2,46,2,47,2,48,2,49,2,50,
2,51,2,52,2,53,2,54,2,55,2,56,2,57,2,58,
2,59,2,60,2,61,2,62,2,63,2,64,2,65,2,66,
2,67,2,68,2,69,2,70,2,71,2,72,2,73,2,74,
2,75,2,76,2,77,2,78,2,79,2,80,2,81,2,82,
2,83,2,84,2,85,2,86,2,87,2,88,2,89,2,90,
2,91,2,92,2,93,2,94,2,95,2,96,2,97,2,98,
2,99,2,100,2,101,2,102,2,103,2,104,2,105,2,106,
2,107,2,108,2,109,2,110,2,111,2,112,2,113,2,114,
2,115,2,116,2,117,2,118,2,119,2,120,2,121,2,122,
2,123,2,124,2,125,2,126,2,127,2,128,2,129,2,130,
2,131,2,132,2,133,2,134,2,135,2,136,2,137,2,138,
2,139,2,140,2,141,2,142,2,143,2,144,2,145,2,146,
2,147,2,148,2,149,2,150,2,151,2,152,2,153,2,154,
2,155,2,156,2,157,2,158,2,159,2,160,2,161,2,162,
2,163,2,164,2,165,2,166,2,167,2,168,2,169,2,170,
2,171,2,172,2,173,2,174,2,175,2,176,2,177,2,178,
2,179,2,180,2,181,2,182,2,183,2,184,2,185,2,186,
2,187,2,188,2,189,2,190,2,191,2,192,2,193,2,194,
2,195,2,196,2,197,2,198,2,199,2,200,2,201,2,202,
2,203,2,204,2,205,2,206,2,207,2,208,2,209,2,210,
2,211,2,212,2,213,2,214,2,215,2,216,2,217,2,218,
2,219,2,220,2,221,2,222,2,223,2,224,2,225,2,226,
2,227,2,228,2,229,2,230,2,231,2,232,2,233,2,234,
2,235,2,236,2,237,2,238,2,239,2,240,2,241,2,242,
2,243,2,244,2,245,2,246,2,247,2,248,2,249,2,250,
2,251,2,252,2,253,2,254,2,255,3,0,3,1,3,2,
3,3,3,4,3,5,3,6,3,7,3,8,3,9,3,10,
3,11,3,12,3,13,3,14,3,15,3,16,3,17,3,18,
0,168,3,19,3,20,3,21,3,22,3,23,3,24,3,25,
3,26,3,27,3,28,3,29,3,30,3,31,3,32,3,33,
3,34,3,35,3,36,3,37,0,159,3,38,3,39,3,40,
3,41,3,42,3,43,3,44,3,45,3,46,3,47,3,48,
3,49,3,50,3,51,3,52,3,53,3,54,3,55,3,56,
3,57,3,58,3,59,3,60,3,61,3,62,3,63,3,64,
3,65,3,66,3,67,3,68,3,69,3,70,3,71,3,72,
3,73,3,74,3,75,3,76,3,77,3,78,3,79,3,80,
3,81,3,82,3,83,3,84,3,85,3,86,3,87,3,88,
3,89,3,90,3,91,3,92,3,93,3,94,3,95,3,96,
3,97,3,98,3,99,3,100,3,101,3,102,3,103,3,104,
3,105,3,106,3,107,3,108,3,109,3,110,3,111,3,112,
3,113,3,114,3,115,3,116,3,117,3,118,3,119,3,120,
3,121,3,122,3,123,3,124,3,125,3,126,3,127,3,128,
3,129,3,130,3,131,3,132,3,133,3,134,3,135,3,136,
3,137,3,138,3,139,3,140,3,141,3,142,3,143,3,144,
3,145,3,146,3,147,3,148,3,149,3,150,3,151,3,152,
3,153,3,154,3,155,3,156,3,157,3,158,3,159,3,160,
3,161,3,162,3,163,3,164,3,165,3,166,3,167,3,168,
3,169,3,170,3,171,3,172,3,173,3,174,3,175,3,176,
3,177,3,178,3,179,3,180,3,181,3,182,3,183,3,184,
3,185,3,186,3,187,3,188,3,189,3,190,3,191,3,192,
3,193,3,194,3,195,3,196,3,197,3,198,3,199,3,200,
3,201,3,202,3,203,3,204,3,205,3,206,3,207,3,208,
3,209,3,210,3,211,3,212,3,213,3,214,3,215,3,216,
3,217,3,218,3,219,3,220,3,221,3,222,3,223,3,224,
3,225,3,226,3,227,3,228,3,229,3,230,3,231,3,232,
3,233,3,234,3,235,3,236,3,237,3,238,3,239,3,240,
3,241,3,242,3,243,3,244,3,245,3,246,3,247,3,248,
3,249,3,250,3,251,3,252,3,253,3,254,3,255,4,0,
4,1,4,2,4,3,4,4,4,5,4,6,4,7,4,8,
4,9,4,10,4,11,4,12,4,13,4,14,4,15,4,16,
4,17,4,18,4,19,4,20,4,21,4,22,4,23,4,24,
4,25,4,26,4,27,4,28,4,29,4,30,4,31,4,32,
4,33,4,34,4,35,4,36,4,37,4,38,4,39,4,40,
4,41,4,42,4,43,4,44,4,45,4,46,4,47,4,48,
4,49,4,50,4,51,4,52,4,53,4,54,4,55,4,56,
4,57,4,58,4,59,4,60,4,61,4,62,4,63,4,64,
4,65,4,66,4,67,4,68,4,69,4,70,4,71,4,72,
4,73,4,74,4,75,4,76,4,77,4,78,4,79,4,80,
4,81,4,82,4,83,4,84,4,85,4,86,4,87,4,88,
4,89,4,90,4,91,4,92,4,93,4,94,4,95,4,96,
4,97,4,98,4,99,4,100,4,101,4,102,4,103,4,104,
4,105,4,106,4,107,4,108,4,109,4,110,4,111,4,112,
4,113,4,114,4,115,4,116,4,117,4,118,4,119,4,120,
4,121,4,122,4,123,4,124,4,125,4,126,4,127,4,128,
4,129,4,130,4,131,4,132,4,133,4,134,4,135,4,136,
4,137,4,138,4,139,4,140,4,141,4,142,4,143,4,144,
4,145,4,146,4,147,4,148,4,149,4,150,4,151,4,152,
4,153,4,154,4,155,4,156,4,157,4,158,4,159,4,160,
4,161,4,162,4,163,4,164,4,165,4,166,4,167,4,168,
4,169,4,170,4,171,4,172,4,173,4,174,4,175,4,176,
4,177,4,178,4,179,4,180,4,181,4,182,4,183,4,184,
4,185,4,186,4,187,4,188,4,189,4,190,4,191,4,192,
4,193,4,194,4,195,4,196,4,197,4,198,4,199,4,200,
4,201,4,202,4,203,4,204,4,205,4,206,4,207,4,208,
4,209,4,210,4,211,4,212,4,213,4,214,4,215,4,216,
4,217,4,218,4,219,4,220,4,221,4,222,4,223,4,224,
4,225,4,226,4,227,4,228,4,229,4,230,4,231,4,232,
4,233,4,234,4,235,4,236,4,237,4,238,4,239,4,240,
4,241,4,242,4,243,4,244,4,245,4,246,4,247,4,248,
4,249,4,250,4,251,4,252,4,253,4,254,4,255,5,0,
5,1,5,2,5,3,5,4,5,5,5,6,5,7,5,8,
5,9,5,10,5,11,5,12,5,13,5,14,5,15,5,16,
5,17,5,18,5,19,5,20,5,21,5,22,5,23,5,24,
5,25,5,26,5,27,5,28,5,29,5,30,5,31,5,32,
5,33,5,34,5,35,5,36,5,37,5,38,5,39,5,40,
5,41,5,42,5,43,5,44,5,45,5,46,5,47,5,48,
5,49,5,50,5,51,5,52,5,53,5,54,5,55,5,56,
5,57,5,58,5,59,5,60,5,61,5,62,5,63,5,64,
5,65,5,66,5,67,5,68,5,69,5,70,5,71,5,72,
5,73,5,74,5,75,5,76,5,77,5,78,5,79,5,80,
5,81,5,82,5,83,5,84,5,85,5,86,5,87,5,88,
5,89,5,90,5,91,5,92,5,93,5,94,5,95,5,96,
5,97,5,98,5,99,5,100,0,247,5,101,5,102,5,103,
5,104,5,105,5,106,5,107,5,108,5,109,5,110,5,111,
0,239,5,112,5,113,5,114,5,115,5,116,5,117,5,118,
5,119,5,120,5,121,5,122,5,123,5,124,5,125,5,126,
5,127,5,128,5,129,5,130,5,131,5,132,5,133,5,134,
5,135,5,136,5,137,5,138,5,139,5,140,5,141,5,142,
5,143,5,144,5,145,5,146,5,147,5,148,5,149,5,150,
5,151,5,152,5,153,5,154,5,155,5,156,5,157,5,158,
5,159,5,160,5,161,5,162,5,163,5,164,5,165,5,166,
5,167,5,168,5,169,5,170,5,171,5,172,5,173,5,174,
5,175,5,176,5,177,5,178,5,179,5,180,5,181,5,182,
5,183,5,184,5,185,5,186,5,187,5,188,5,189,5,190,
5,191,5,192,5,193,5,194,5,195,5,196,5,197,5,198,
5,199,5,200,5,201,5,202,5,203,5,204,5,205,5,206,
5,207,5,208,5,209,5,210,5,211,5,212,5,213,5,214,
5,215,5,216,5,217,5,218,5,219,5,220,5,221,5,222,
5,223,5,224,5,225,5,226,5,227,5,228,5,229,5,230,
5,231,5,232,5,233,5,234,5,235,5,236,5,237,5,238,
5,239,5,240,5,241,5,242,5,243,5,244,5,245,5,246,
5,247,5,248,5,249,5,250,5,251,5,252,5,253,5,254,
5,255,6,0,6,1,6,2,6,3,6,4,6,5,6,6,
6,7,6,8,6,9,6,10,6,11,6,12,6,13,6,14,
6,15,6,16,6,17,6,18,6,19,6,20,6,21,6,22,
6,23,6,24,6,25,6,26,6,27,6,28,6,29,6,30,
6,31,6,32,6,33,6,34,6,35,6,36,6,37,6,38,
6,39,6,40,6,41,6,42,6,43,6,44,6,45,6,46,
6,47,6,48,6,49,6,50,6,51,6,52,6,53,6,54,
6,55,6,56,6,57,6,58,6,59,6,60,6,61,6,62,
6,63,6,64,6,65,6,66,6,67,6,68,6,69,6,70,
6,71,6,72,6,73,6,74,6,75,6,76,6,77,6,78,
6,79,6,80,6,81,6,82,6,83,6,84,6,85,6,86,
6,87,6,88,6,89,6,90,6,91,6,92,6,93,6,94,
6,95,6,96,6,97,6,98,6,99,6,100,6,101,6,102,
6,103,6,104,6,105,6,106,6,107,6,108,6,109,6,110,
6,111,6,112,6,113,6,114,6,115,6,116,6,117,6,118,
6,119,6,120,6,121,6,122,6,123,6,124,6,125,6,126,
6,127,6,128,6,129,6,130,6,131,6,132,6,133,6,134,
6,135,6,136,6,137,6,138,6,139,6,140,6,141,6,142,
6,143,6,144,6,145,6,146,6,147,6,148,6,149,6,150,
6,151,6,152,6,153,6,154,6,155,6,156,6,157,6,158,
6,159,6,160,6,161,6,162,6,163,6,164,6,165,6,166,
6,167,6,168,6,169,6,170,6,171,6,172,6,173,6,174,
6,175,6,176,7,117,110,105,48,48,65,48,7,117,110,105,
48,48,65,68,7,65,109,97,99,114,111,110,7,97,109,97,
99,114,111,110,6,65,98,114,101,118,101,6,97,98,114,101,
118,101,7,65,111,103,111,110,101,107,7,97,111,103,111,110,
101,107,11,67,99,105,114,99,117,109,102,108,101,120,11,99,
99,105,114,99,117,109,102,108,101,120,10,67,100,111,116,97,
99,99,101,110,116,10,99,100,111,116,97,99,99,101,110,116,
6,68,99,97,114,111,110,6,100,99,97,114,111,110,6,68,
99,114,111,97,116,7,69,109,97,99,114,111,110,7,101,109,
97,99,114,111,110,6,69,98,114,101,118,101,6,101,98,114,
101,118,101,10,69,100,111,116,97,99,99,101,110,116,10,101,
100,111,116,97,99,99,101,110,116,7,69,111,103,111,110,101,
107,7,101,111,103,111,110,101,107,6,69,99,97,114,111,110,
6,101,99,97,114,111,110,11,71,99,105,114,99,117,109,102,
108,101,120,11,103,99,105,114,99,117,109,102,108,101,120,10,
71,100,111,116,97,99,99,101,110,116,10,103,100,111,116,97,
99,99,101,110,116,12,71,99,111,109,109,97,97,99,99,101,
110,116,12,103,99,111,109,109,97,97,99,99,101,110,116,11,
72,99,105,114,99,117,109,102,108,101,120,11,104,99,105,114,
99,117,109,102,108,101,120,4,72,98,97,114,4,104,98,97,
114,6,73,116,105,108,100,101,6,105,116,105,108,100,101,7,
73,109,97,99,114,111,110,7,105,109,97,99,114,111,110,6,
73,98,114,101,118,101,6,105,98,114,101,118,101,7,73,111,
103,111,110,101,107,7,105,111,103,111,110,101,107,2,73,74,
2,105,106,11,74,99,105,114,99,117,109,102,108,101,120,11,
106,99,105,114,99,117,109,102,108,101,120,12,75,99,111,109,
109,97,97,99,99,101,110,116,12,107,99,111,109,109,97,97,
99,99,101,110,116,12,107,103,114,101,101,110,108,97,110,100,
105,99,6,76,97,99,117,116,101,6,108,97,99,117,116,101,
12,76,99,111,109,109,97,97,99,99,101,110,116,12,108,99,
111,109,109,97,97,99,99,101,110,116,6,76,99,97,114,111,
110,6,108,99,97,114,111,110,4,76,100,111,116,4,108,100,
111,116,6,78,97,99,117,116,101,6,110,97,99,117,116,101,
12,78,99,111,109,109,97,97,99,99,101,110,116,12,110,99,
111,109,109,97,97,99,99,101,110,116,6,78,99,97,114,111,
110,6,110,99,97,114,111,110,11,110,97,112,111,115,116,114,
111,112,104,101,3,69,110,103,3,101,110,103,7,79,109,97,
99,114,111,110,7,111,109,97,99,114,111,110,6,79,98,114,
101,118,101,6,111,98,114,101,118,101,13,79,104,117,110,103,
97,114,117,109,108,97,117,116,13,111,104,117,110,103,97,114,
117,109,108,97,117,116,6,82,97,99,117,116,101,6,114,97,
99,117,116,101,12,82,99,111,109,109,97,97,99,99,101,110,
116,12,114,99,111,109,109,97,97,99,99,101,110,116,6,82,
99,97,114,111,110,6,114,99,97,114,111,110,6,83,97,99,
117,116,101,6,115,97,99,117,116,101,11,83,99,105,114,99,
117,109,102,108,101,120,11,115,99,105,114,99,117,109,102,108,
101,120,7,117,110,105,48,49,54,50,7,117,110,105,48,49,
54,51,6,84,99,97,114,111,110,6,116,99,97,114,111,110,
4,84,98,97,114,4,116,98,97,114,6,85,116,105,108,100,
101,6,117,116,105,108,100,101,7,85,109,97,99,114,111,110,
7,117,109,97,99,114,111,110,6,85,98,114,101,118,101,6,
117,98,114,101,118,101,5,85,114,105,110,103,5,117,114,105,
110,103,13,85,104,117,110,103,97,114,117,109,108,97,117,116,
13,117,104,117,110,103,97,114,117,109,108,97,117,116,7,85,
111,103,111,110,101,107,7,117,111,103,111,110,101,107,11,87,
99,105,114,99,117,109,102,108,101,120,11,119,99,105,114,99,
117,109,102,108,101,120,11,89,99,105,114,99,117,109,102,108,
101,120,11,121,99,105,114,99,117,109,102,108,101,120,6,90,
97,99,117,116,101,6,122,97,99,117,116,101,10,90,100,111,
116,97,99,99,101,110,116,10,122,100,111,116,97,99,99,101,
110,116,5,108,111,110,103,115,7,117,110,105,48,49,56,48,
7,117,110,105,48,49,56,49,7,117,110,105,48,49,56,50,
7,117,110,105,48,49,56,51,7,117,110,105,48,49,56,52,
7,117,110,105,48,49,56,53,7,117,110,105,48,49,56,54,
7,117,110,105,48,49,56,55,7,117,110,105,48,49,56,56,
7,117,110,105,48,49,56,57,7,117,110,105,48,49,56,65,
7,117,110,105,48,49,56,66,7,117,110,105,48,49,56,67,
7,117,110,105,48,49,56,68,7,117,110,105,48,49,56,69,
7,117,110,105,48,49,56,70,7,117,110,105,48,49,57,48,
7,117,110,105,48,49,57,49,7,117,110,105,48,49,57,51,
7,117,110,105,48,49,57,52,7,117,110,105,48,49,57,53,
7,117,110,105,48,49,57,54,7,117,110,105,48,49,57,55,
7,117,110,105,48,49,57,56,7,117,110,105,48,49,57,57,
7,117,110,105,48,49,57,65,7,117,110,105,48,49,57,66,
7,117,110,105,48,49,57,67,7,117,110,105,48,49,57,68,
7,117,110,105,48,49,57,69,7,117,110,105,48,49,57,70,
5,79,104,111,114,110,5,111,104,111,114,110,7,117,110,105,
48,49,65,50,7,117,110,105,48,49,65,51,7,117,110,105,
48,49,65,52,7,117,110,105,48,49,65,53,7,117,110,105,
48,49,65,54,7,117,110,105,48,49,65,55,7,117,110,105,
48,49,65,56,7,117,110,105,48,49,65,57,7,117,110,105,
48,49,65,65,7,117,110,105,48,49,65,66,7,117,110,105,
48,49,65,67,7,117,110,105,48,49,65,68,7,117,110,105,
48,49,65,69,5,85,104,111,114,110,5,117,104,111,114,110,
7,117,110,105,48,49,66,49,7,117,110,105,48,49,66,50,
7,117,110,105,48,49,66,51,7,117,110,105,48,49,66,52,
7,117,110,105,48,49,66,53,7,117,110,105,48,49,66,54,
7,117,110,105,48,49,66,55,7,117,110,105,48,49,66,56,
7,117,110,105,48,49,66,57,7,117,110,105,48,49,66,65,
7,117,110,105,48,49,66,66,7,117,110,105,48,49,66,67,
7,117,110,105,48,49,66,68,7,117,110,105,48,49,66,69,
7,117,110,105,48,49,66,70,7,117,110,105,48,49,67,48,
7,117,110,105,48,49,67,49,7,117,110,105,48,49,67,50,
7,117,110,105,48,49,67,51,7,117,110,105,48,49,67,52,
7,117,110,105,48,49,67,53,7,117,110,105,48,49,67,54,
7,117,110,105,48,49,67,55,7,117,110,105,48,49,67,56,
7,117,110,105,48,49,67,57,7,117,110,105,48,49,67,65,
7,117,110,105,48,49,67,66,7,117,110,105,48,49,67,67,
7,117,110,105,48,49,67,68,7,117,110,105,48,49,67,69,
7,117,110,105,48,49,67,70,7,117,110,105,48,49,68,48,
7,117,110,105,48,49,68,49,7,117,110,105,48,49,68,50,
7,117,110,105,48,49,68,51,7,117,110,105,48,49,68,52,
7,117,110,105,48,49,68,53,7,117,110,105,48,49,68,54,
7,117,110,105,48,49,68,55,7,117,110,105,48,49,68,56,
7,117,110,105,48,49,68,57,7,117,110,105,48,49,68,65,
7,117,110,105,48,49,68,66,7,117,110,105,48,49,68,67,
7,117,110,105,48,49,68,68,7,117,110,105,48,49,68,69,
7,117,110,105,48,49,68,70,7,117,110,105,48,49,69,48,
7,117,110,105,48,49,69,49,7,117,110,105,48,49,69,50,
7,117,110,105,48,49,69,51,7,117,110,105,48,49,69,52,
7,117,110,105,48,49,69,53,6,71,99,97,114,111,110,6,
103,99,97,114,111,110,7,117,110,105,48,49,69,56,7,117,
110,105,48,49,69,57,7,117,110,105,48,49,69,65,7,117,
110,105,48,49,69,66,7,117,110,105,48,49,69,67,7,117,
110,105,48,49,69,68,7,117,110,105,48,49,69,69,7,117,
110,105,48,49,69,70,7,117,110,105,48,49,70,48,7,117,
110,105,48,49,70,49,7,117,110,105,48,49,70,50,7,117,
110,105,48,49,70,51,7,117,110,105,48,49,70,52,7,117,
110,105,48,49,70,53,7,117,110,105,48,49,70,54,7,117,
110,105,48,49,70,55,7,117,110,105,48,49,70,56,7,117,
110,105,48,49,70,57,10,65,114,105,110,103,97,99,117,116,
101,10,97,114,105,110,103,97,99,117,116,101,7,65,69,97,
99,117,116,101,7,97,101,97,99,117,116,101,11,79,115,108,
97,115,104,97,99,117,116,101,11,111,115,108,97,115,104,97,
99,117,116,101,7,117,110,105,48,50,48,48,7,117,110,105,
48,50,48,49,7,117,110,105,48,50,48,50,7,117,110,105,
48,50,48,51,7,117,110,105,48,50,48,52,7,117,110,105,
48,50,48,53,7,117,110,105,48,50,48,54,7,117,110,105,
48,50,48,55,7,117,110,105,48,50,48,56,7,117,110,105,
48,50,48,57,7,117,110,105,48,50,48,65,7,117,110,105,
48,50,48,66,7,117,110,105,48,50,48,67,7,117,110,105,
48,50,48,68,7,117,110,105,48,50,48,69,7,117,110,105,
48,50,48,70,7,117,110,105,48,50,49,48,7,117,110,105,
48,50,49,49,7,117,110,105,48,50,49,50,7,117,110,105,
48,50,49,51,7,117,110,105,48,50,49,52,7,117,110,105,
48,50,49,53,7,117,110,105,48,50,49,54,7,117,110,105,
48,50,49,55,12,83,99,111,109,109,97,97,99,99,101,110,
116,12,115,99,111,109,109,97,97,99,99,101,110,116,7,117,
110,105,48,50,49,65,7,117,110,105,48,50,49,66,7,117,
110,105,48,50,49,67,7,117,110,105,48,50,49,68,7,117,
110,105,48,50,49,69,7,117,110,105,48,50,49,70,7,117,
110,105,48,50,50,50,7,117,110,105,48,50,50,51,7,117,
110,105,48,50,50,52,7,117,110,105,48,50,50,53,7,117,
110,105,48,50,50,54,7,117,110,105,48,50,50,55,7,117,
110,105,48,50,50,56,7,117,110,105,48,50,50,57,7,117,
110,105,48,50,50,65,7,117,110,105,48,50,50,66,7,117,
110,105,48,50,50,67,7,117,110,105,48,50,50,68,7,117,
110,105,48,50,50,69,7,117,110,105,48,50,50,70,7,117,
110,105,48,50,51,48,7,117,110,105,48,50,51,49,7,117,
110,105,48,50,51,50,7,117,110,105,48,50,51,51,7,117,
110,105,48,50,53,48,7,117,110,105,48,50,53,49,7,117,
110,105,48,50,53,50,7,117,110,105,48,50,53,51,7,117,
110,105,48,50,53,52,7,117,110,105,48,50,53,53,7,117,
110,105,48,50,53,54,7,117,110,105,48,50,53,55,7,117,
110,105,48,50,53,56,7,117,110,105,48,50,53,57,7,117,
110,105,48,50,53,65,7,117,110,105,48,50,53,66,7,117,
110,105,48,50,53,67,7,117,110,105,48,50,53,68,7,117,
110,105,48,50,53,69,7,117,110,105,48,50,53,70,7,117,
110,105,48,50,54,48,7,117,110,105,48,50,54,49,7,117,
110,105,48,50,54,50,7,117,110,105,48,50,54,51,7,117,
110,105,48,50,54,52,7,117,110,105,48,50,54,53,7,117,
110,105,48,50,54,54,7,117,110,105,48,50,54,55,7,117,
110,105,48,50,54,56,7,117,110,105,48,50,54,57,7,117,
110,105,48,50,54,65,7,117,110,105,48,50,54,66,7,117,
110,105,48,50,54,67,7,117,110,105,48,50,54,68,7,117,
110,105,48,50,54,69,7,117,110,105,48,50,54,70,7,117,
110,105,48,50,55,48,7,117,110,105,48,50,55,49,7,117,
110,105,48,50,55,50,7,117,110,105,48,50,55,51,7,117,
110,105,48,50,55,52,7,117,110,105,48,50,55,53,7,117,
110,105,48,50,55,54,7,117,110,105,48,50,55,55,7,117,
110,105,48,50,55,56,7,117,110,105,48,50,55,57,7,117,
110,105,48,50,55,65,7,117,110,105,48,50,55,66,7,117,
110,105,48,50,55,67,7,117,110,105,48,50,55,68,7,117,
110,105,48,50,55,69,7,117,110,105,48,50,55,70,7,117,
110,105,48,50,56,48,7,117,110,105,48,50,56,49,7,117,
110,105,48,50,56,50,7,117,110,105,48,50,56,51,7,117,
110,105,48,50,56,52,7,117,110,105,48,50,56,53,7,117,
110,105,48,50,56,54,7,117,110,105,48,50,56,55,7,117,
110,105,48,50,56,56,7,117,110,105,48,50,56,57,7,117,
110,105,48,50,56,65,7,117,110,105,48,50,56,66,7,117,
110,105,48,50,56,67,7,117,110,105,48,50,56,68,7,117,
110,105,48,50,56,69,7,117,110,105,48,50,56,70,7,117,
110,105,48,50,57,48,7,117,110,105,48,50,57,49,7,117,
110,105,48,50,57,50,7,117,110,105,48,50,57,51,7,117,
110,105,48,50,57,52,7,117,110,105,48,50,57,53,7,117,
110,105,48,50,57,54,7,117,110,105,48,50,57,55,7,117,
110,105,48,50,57,56,7,117,110,105,48,50,57,57,7,117,
110,105,48,50,57,65,7,117,110,105,48,50,57,66,7,117,
110,105,48,50,57,67,7,117,110,105,48,50,57,68,7,117,
110,105,48,50,57,69,7,117,110,105,48,50,57,70,7,117,
110,105,48,50,65,48,7,117,110,105,48,50,65,49,7,117,
110,105,48,50,65,50,7,117,110,105,48,50,65,51,7,117,
110,105,48,50,65,52,7,117,110,105,48,50,65,53,7,117,
110,105,48,50,65,54,7,117,110,105,48,50,65,55,7,117,
110,105,48,50,65,56,7,117,110,105,48,50,65,57,7,117,
110,105,48,50,65,65,7,117,110,105,48,50,65,66,7,117,
110,105,48,50,65,67,7,117,110,105,48,50,65,68,7,117,
110,105,48,50,66,48,7,117,110,105,48,50,66,49,7,117,
110,105,48,50,66,50,7,117,110,105,48,50,66,51,7,117,
110,105,48,50,66,52,7,117,110,105,48,50,66,53,7,117,
110,105,48,50,66,54,7,117,110,105,48,50,66,55,7,117,
110,105,48,50,66,56,7,117,110,105,48,50,66,57,7,117,
110,105,48,50,66,65,7,117,110,105,48,50,66,66,7,117,
110,105,48,50,66,67,7,117,110,105,48,50,66,68,7,117,
110,105,48,50,66,69,7,117,110,105,48,50,66,70,7,117,
110,105,48,50,67,48,7,117,110,105,48,50,67,49,7,117,
110,105,48,50,67,50,7,117,110,105,48,50,67,51,7,117,
110,105,48,50,67,52,7,117,110,105,48,50,67,53,7,117,
110,105,48,50,67,56,7,117,110,105,48,50,67,57,7,117,
110,105,48,50,67,65,7,117,110,105,48,50,67,66,7,117,
110,105,48,50,67,67,7,117,110,105,48,50,67,68,7,117,
110,105,48,50,67,69,7,117,110,105,48,50,67,70,7,117,
110,105,48,50,68,48,7,117,110,105,48,50,68,49,7,117,
110,105,48,50,68,50,7,117,110,105,48,50,68,51,7,117,
110,105,48,50,68,52,7,117,110,105,48,50,68,53,7,117,
110,105,48,50,68,54,7,117,110,105,48,50,68,55,7,117,
110,105,48,50,68,69,7,117,110,105,48,50,68,70,7,117,
110,105,48,50,69,48,7,117,110,105,48,50,69,49,7,117,
110,105,48,50,69,50,7,117,110,105,48,50,69,51,7,117,
110,105,48,50,69,52,7,117,110,105,48,50,69,67,7,117,
110,105,48,50,69,68,7,117,110,105,48,50,69,69,9,103,
114,97,118,101,99,111,109,98,9,97,99,117,116,101,99,111,
109,98,7,117,110,105,48,51,48,50,9,116,105,108,100,101,
99,111,109,98,7,117,110,105,48,51,48,52,7,117,110,105,
48,51,48,53,7,117,110,105,48,51,48,54,7,117,110,105,
48,51,48,55,7,117,110,105,48,51,48,56,13,104,111,111,
107,97,98,111,118,101,99,111,109,98,7,117,110,105,48,51,
48,65,7,117,110,105,48,51,48,66,7,117,110,105,48,51,
48,67,7,117,110,105,48,51,48,68,7,117,110,105,48,51,
48,69,7,117,110,105,48,51,48,70,7,117,110,105,48,51,
49,48,7,117,110,105,48,51,49,49,7,117,110,105,48,51,
49,50,7,117,110,105,48,51,49,51,7,117,110,105,48,51,
49,52,7,117,110,105,48,51,49,53,7,117,110,105,48,51,
49,54,7,117,110,105,48,51,49,55,7,117,110,105,48,51,
49,56,7,117,110,105,48,51,49,57,7,117,110,105,48,51,
49,65,7,117,110,105,48,51,49,66,7,117,110,105,48,51,
49,67,7,117,110,105,48,51,49,68,7,117,110,105,48,51,
49,69,7,117,110,105,48,51,49,70,7,117,110,105,48,51,
50,48,7,117,110,105,48,51,50,49,7,117,110,105,48,51,
50,50,12,100,111,116,98,101,108,111,119,99,111,109,98,7,
117,110,105,48,51,50,52,7,117,110,105,48,51,50,53,7,
117,110,105,48,51,50,54,7,117,110,105,48,51,50,55,7,
117,110,105,48,51,50,56,7,117,110,105,48,51,50,57,7,
117,110,105,48,51,50,65,7,117,110,105,48,51,50,66,7,
117,110,105,48,51,50,67,7,117,110,105,48,51,50,68,7,
117,110,105,48,51,50,69,7,117,110,105,48,51,50,70,7,
117,110,105,48,51,51,48,7,117,110,105,48,51,51,49,7,
117,110,105,48,51,51,50,7,117,110,105,48,51,51,51,7,
117,110,105,48,51,51,52,7,117,110,105,48,51,51,53,7,
117,110,105,48,51,51,54,7,117,110,105,48,51,51,55,7,
117,110,105,48,51,51,56,7,117,110,105,48,51,51,57,7,
117,110,105,48,51,51,65,7,117,110,105,48,51,51,66,7,
117,110,105,48,51,51,67,7,117,110,105,48,51,51,68,7,
117,110,105,48,51,51,69,7,117,110,105,48,51,51,70,7,
117,110,105,48,51,52,48,7,117,110,105,48,51,52,49,7,
117,110,105,48,51,52,50,7,117,110,105,48,51,52,51,7,
117,110,105,48,51,52,52,7,117,110,105,48,51,52,53,7,
117,110,105,48,51,52,54,7,117,110,105,48,51,52,55,7,
117,110,105,48,51,52,56,7,117,110,105,48,51,52,57,7,
117,110,105,48,51,52,65,7,117,110,105,48,51,52,66,7,
117,110,105,48,51,52,67,7,117,110,105,48,51,52,68,7,
117,110,105,48,51,52,69,7,117,110,105,48,51,54,48,7,
117,110,105,48,51,54,49,7,117,110,105,48,51,54,50,7,
117,110,105,48,51,55,52,7,117,110,105,48,51,55,53,7,
117,110,105,48,51,55,65,7,117,110,105,48,51,55,69,5,
116,111,110,111,115,13,100,105,101,114,101,115,105,115,116,111,
110,111,115,10,65,108,112,104,97,116,111,110,111,115,9,97,
110,111,116,101,108,101,105,97,12,69,112,115,105,108,111,110,
116,111,110,111,115,8,69,116,97,116,111,110,111,115,9,73,
111,116,97,116,111,110,111,115,12,79,109,105,99,114,111,110,
116,111,110,111,115,12,85,112,115,105,108,111,110,116,111,110,
111,115,10,79,109,101,103,97,116,111,110,111,115,17,105,111,
116,97,100,105,101,114,101,115,105,115,116,111,110,111,115,5,
65,108,112,104,97,4,66,101,116,97,5,71,97,109,109,97,
7,69,112,115,105,108,111,110,4,90,101,116,97,3,69,116,
97,5,84,104,101,116,97,4,73,111,116,97,5,75,97,112,
112,97,6,76,97,109,98,100,97,2,77,117,2,78,117,2,
88,105,7,79,109,105,99,114,111,110,2,80,105,3,82,104,
111,5,83,105,103,109,97,3,84,97,117,7,85,112,115,105,
108,111,110,3,80,104,105,3,67,104,105,3,80,115,105,12,
73,111,116,97,100,105,101,114,101,115,105,115,15,85,112,115,
105,108,111,110,100,105,101,114,101,115,105,115,10,97,108,112,
104,97,116,111,110,111,115,12,101,112,115,105,108,111,110,116,
111,110,111,115,8,101,116,97,116,111,110,111,115,9,105,111,
116,97,116,111,110,111,115,20,117,112,115,105,108,111,110,100,
105,101,114,101,115,105,115,116,111,110,111,115,5,97,108,112,
104,97,4,98,101,116,97,5,103,97,109,109,97,5,100,101,
108,116,97,7,101,112,115,105,108,111,110,4,122,101,116,97,
3,101,116,97,5,116,104,101,116,97,4,105,111,116,97,5,
107,97,112,112,97,6,108,97,109,98,100,97,7,117,110,105,
48,51,66,67,2,110,117,2,120,105,7,111,109,105,99,114,
111,110,3,114,104,111,6,115,105,103,109,97,49,5,115,105,
103,109,97,3,116,97,117,7,117,112,115,105,108,111,110,3,
112,104,105,3,99,104,105,3,112,115,105,5,111,109,101,103,
97,12,105,111,116,97,100,105,101,114,101,115,105,115,15,117,
112,115,105,108,111,110,100,105,101,114,101,115,105,115,12,111,
109,105,99,114,111,110,116,111,110,111,115,12,117,112,115,105,
108,111,110,116,111,110,111,115,10,111,109,101,103,97,116,111,
110,111,115,7,117,110,105,48,51,68,48,6,116,104,101,116,
97,49,8,85,112,115,105,108,111,110,49,7,117,110,105,48,
51,68,51,7,117,110,105,48,51,68,52,4,112,104,105,49,
7,117,110,105,49,69,48,48,7,117,110,105,49,69,48,49,
7,117,110,105,49,69,48,50,7,117,110,105,49,69,48,51,
7,117,110,105,49,69,48,52,7,117,110,105,49,69,48,53,
7,117,110,105,49,69,48,54,7,117,110,105,49,69,48,55,
7,117,110,105,49,69,48,56,7,117,110,105,49,69,48,57,
7,117,110,105,49,69,48,65,7,117,110,105,49,69,48,66,
7,117,110,105,49,69,48,67,7,117,110,105,49,69,48,68,
7,117,110,105,49,69,48,69,7,117,110,105,49,69,48,70,
7,117,110,105,49,69,49,48,7,117,110,105,49,69,49,49,
7,117,110,105,49,69,49,50,7,117,110,105,49,69,49,51,
7,117,110,105,49,69,49,52,7,117,110,105,49,69,49,53,
7,117,110,105,49,69,49,54,7,117,110,105,49,69,49,55,
7,117,110,105,49,69,49,56,7,117,110,105,49,69,49,57,
7,117,110,105,49,69,49,65,7,117,110,105,49,69,49,66,
7,117,110,105,49,69,49,67,7,117,110,105,49,69,49,68,
7,117,110,105,49,69,49,69,7,117,110,105,49,69,49,70,
7,117,110,105,49,69,50,48,7,117,110,105,49,69,50,49,
7,117,110,105,49,69,50,50,7,117,110,105,49,69,50,51,
7,117,110,105,49,69,50,52,7,117,110,105,49,69,50,53,
7,117,110,105,49,69,50,54,7,117,110,105,49,69,50,55,
7,117,110,105,49,69,50,56,7,117,110,105,49,69,50,57,
7,117,110,105,49,69,50,65,7,117,110,105,49,69,50,66,
7,117,110,105,49,69,50,67,7,117,110,105,49,69,50,68,
7,117,110,105,49,69,50,69,7,117,110,105,49,69,50,70,
7,117,110,105,49,69,51,48,7,117,110,105,49,69,51,49,
7,117,110,105,49,69,51,50,7,117,110,105,49,69,51,51,
7,117,110,105,49,69,51,52,7,117,110,105,49,69,51,53,
7,117,110,105,49,69,51,54,7,117,110,105,49,69,51,55,
7,117,110,105,49,69,51,56,7,117,110,105,49,69,51,57,
7,117,110,105,49,69,51,65,7,117,110,105,49,69,51,66,
7,117,110,105,49,69,51,67,7,117,110,105,49,69,51,68,
7,117,110,105,49,69,51,69,7,117,110,105,49,69,51,70,
7,117,110,105,49,69,52,48,7,117,110,105,49,69,52,49,
7,117,110,105,49,69,52,50,7,117,110,105,49,69,52,51,
7,117,110,105,49,69,52,52,7,117,110,105,49,69,52,53,
7,117,110,105,49,69,52,54,7,117,110,105,49,69,52,55,
7,117,110,105,49,69,52,56,7,117,110,105,49,69,52,57,
7,117,110,105,49,69,52,65,7,117,110,105,49,69,52,66,
7,117,110,105,49,69,52,67,7,117,110,105,49,69,52,68,
7,117,110,105,49,69,52,69,7,117,110,105,49,69,52,70,
7,117,110,105,49,69,53,48,7,117,110,105,49,69,53,49,
7,117,110,105,49,69,53,50,7,117,110,105,49,69,53,51,
7,117,110,105,49,69,53,52,7,117,110,105,49,69,53,53,
7,117,110,105,49,69,53,54,7,117,110,105,49,69,53,55,
7,117,110,105,49,69,53,56,7,117,110,105,49,69,53,57,
7,117,110,105,49,69,53,65,7,117,110,105,49,69,53,66,
7,117,110,105,49,69,53,67,7,117,110,105,49,69,53,68,
7,117,110,105,49,69,53,69,7,117,110,105,49,69,53,70,
7,117,110,105,49,69,54,48,7,117,110,105,49,69,54,49,
7,117,110,105,49,69,54,50,7,117,110,105,49,69,54,51,
7,117,110,105,49,69,54,52,7,117,110,105,49,69,54,53,
7,117,110,105,49,69,54,54,7,117,110,105,49,69,54,55,
7,117,110,105,49,69,54,56,7,117,110,105,49,69,54,57,
7,117,110,105,49,69,54,65,7,117,110,105,49,69,54,66,
7,117,110,105,49,69,54,67,7,117,110,105,49,69,54,68,
7,117,110,105,49,69,54,69,7,117,110,105,49,69,54,70,
7,117,110,105,49,69,55,48,7,117,110,105,49,69,55,49,
7,117,110,105,49,69,55,50,7,117,110,105,49,69,55,51,
7,117,110,105,49,69,55,52,7,117,110,105,49,69,55,53,
7,117,110,105,49,69,55,54,7,117,110,105,49,69,55,55,
7,117,110,105,49,69,55,56,7,117,110,105,49,69,55,57,
7,117,110,105,49,69,55,65,7,117,110,105,49,69,55,66,
7,117,110,105,49,69,55,67,7,117,110,105,49,69,55,68,
7,117,110,105,49,69,55,69,7,117,110,105,49,69,55,70,
6,87,103,114,97,118,101,6,119,103,114,97,118,101,6,87,
97,99,117,116,101,6,119,97,99,117,116,101,9,87,100,105,
101,114,101,115,105,115,9,119,100,105,101,114,101,115,105,115,
7,117,110,105,49,69,56,54,7,117,110,105,49,69,56,55,
7,117,110,105,49,69,56,56,7,117,110,105,49,69,56,57,
7,117,110,105,49,69,56,65,7,117,110,105,49,69,56,66,
7,117,110,105,49,69,56,67,7,117,110,105,49,69,56,68,
7,117,110,105,49,69,56,69,7,117,110,105,49,69,56,70,
7,117,110,105,49,69,57,48,7,117,110,105,49,69,57,49,
7,117,110,105,49,69,57,50,7,117,110,105,49,69,57,51,
7,117,110,105,49,69,57,52,7,117,110,105,49,69,57,53,
7,117,110,105,49,69,57,54,7,117,110,105,49,69,57,55,
7,117,110,105,49,69,57,56,7,117,110,105,49,69,57,57,
7,117,110,105,49,69,57,65,7,117,110,105,49,69,57,66,
7,117,110,105,49,69,65,48,7,117,110,105,49,69,65,49,
7,117,110,105,49,69,65,50,7,117,110,105,49,69,65,51,
7,117,110,105,49,69,65,52,7,117,110,105,49,69,65,53,
7,117,110,105,49,69,65,54,7,117,110,105,49,69,65,55,
7,117,110,105,49,69,65,56,7,117,110,105,49,69,65,57,
7,117,110,105,49,69,65,65,7,117,110,105,49,69,65,66,
7,117,110,105,49,69,65,67,7,117,110,105,49,69,65,68,
7,117,110,105,49,69,65,69,7,117,110,105,49,69,65,70,
7,117,110,105,49,69,66,48,7,117,110,105,49,69,66,49,
7,117,110,105,49,69,66,50,7,117,110,105,49,69,66,51,
7,117,110,105,49,69,66,52,7,117,110,105,49,69,66,53,
7,117,110,105,49,69,66,54,7,117,110,105,49,69,66,55,
7,117,110,105,49,69,66,56,7,117,110,105,49,69,66,57,
7,117,110,105,49,69,66,65,7,117,110,105,49,69,66,66,
7,117,110,105,49,69,66,67,7,117,110,105,49,69,66,68,
7,117,110,105,49,69,66,69,7,117,110,105,49,69,66,70,
7,117,110,105,49,69,67,48,7,117,110,105,49,69,67,49,
7,117,110,105,49,69,67,50,7,117,110,105,49,69,67,51,
7,117,110,105,49,69,67,52,7,117,110,105,49,69,67,53,
7,117,110,105,49,69,67,54,7,117,110,105,49,69,67,55,
7,117,110,105,49,69,67,56,7,117,110,105,49,69,67,57,
7,117,110,105,49,69,67,65,7,117,110,105,49,69,67,66,
7,117,110,105,49,69,67,67,7,117,110,105,49,69,67,68,
7,117,110,105,49,69,67,69,7,117,110,105,49,69,67,70,
7,117,110,105,49,69,68,48,7,117,110,105,49,69,68,49,
7,117,110,105,49,69,68,50,7,117,110,105,49,69,68,51,
7,117,110,105,49,69,68,52,7,117,110,105,49,69,68,53,
7,117,110,105,49,69,68,54,7,117,110,105,49,69,68,55,
7,117,110,105,49,69,68,56,7,117,110,105,49,69,68,57,
7,117,110,105,49,69,68,65,7,117,110,105,49,69,68,66,
7,117,110,105,49,69,68,67,7,117,110,105,49,69,68,68,
7,117,110,105,49,69,68,69,7,117,110,105,49,69,68,70,
7,117,110,105,49,69,69,48,7,117,110,105,49,69,69,49,
7,117,110,105,49,69,69,50,7,117,110,105,49,69,69,51,
7,117,110,105,49,69,69,52,7,117,110,105,49,69,69,53,
7,117,110,105,49,69,69,54,7,117,110,105,49,69,69,55,
7,117,110,105,49,69,69,56,7,117,110,105,49,69,69,57,
7,117,110,105,49,69,69,65,7,117,110,105,49,69,69,66,
7,117,110,105,49,69,69,67,7,117,110,105,49,69,69,68,
7,117,110,105,49,69,69,69,7,117,110,105,49,69,69,70,
7,117,110,105,49,69,70,48,7,117,110,105,49,69,70,49,
6,89,103,114,97,118,101,6,121,103,114,97,118,101,7,117,
110,105,49,69,70,52,7,117,110,105,49,69,70,53,7,117,
110,105,49,69,70,54,7,117,110,105,49,69,70,55,7,117,
110,105,49,69,70,56,7,117,110,105,49,69,70,57,7,117,
110,105,49,70,48,48,7,117,110,105,49,70,48,49,7,117,
110,105,49,70,48,50,7,117,110,105,49,70,48,51,7,117,
110,105,49,70,48,52,7,117,110,105,49,70,48,53,7,117,
110,105,49,70,48,54,7,117,110,105,49,70,48,55,7,117,
110,105,49,70,48,56,7,117,110,105,49,70,48,57,7,117,
110,105,49,70,48,65,7,117,110,105,49,70,48,66,7,117,
110,105,49,70,48,67,7,117,110,105,49,70,48,68,7,117,
110,105,49,70,48,69,7,117,110,105,49,70,48,70,7,117,
110,105,49,70,49,48,7,117,110,105,49,70,49,49,7,117,
110,105,49,70,49,50,7,117,110,105,49,70,49,51,7,117,
110,105,49,70,49,52,7,117,110,105,49,70,49,53,7,117,
110,105,49,70,49,56,7,117,110,105,49,70,49,57,7,117,
110,105,49,70,49,65,7,117,110,105,49,70,49,66,7,117,
110,105,49,70,49,67,7,117,110,105,49,70,49,68,7,117,
110,105,49,70,50,48,7,117,110,105,49,70,50,49,7,117,
110,105,49,70,50,50,7,117,110,105,49,70,50,51,7,117,
110,105,49,70,50,52,7,117,110,105,49,70,50,53,7,117,
110,105,49,70,50,54,7,117,110,105,49,70,50,55,7,117,
110,105,49,70,50,56,7,117,110,105,49,70,50,57,7,117,
110,105,49,70,50,65,7,117,110,105,49,70,50,66,7,117,
110,105,49,70,50,67,7,117,110,105,49,70,50,68,7,117,
110,105,49,70,50,69,7,117,110,105,49,70,50,70,7,117,
110,105,49,70,51,48,7,117,110,105,49,70,51,49,7,117,
110,105,49,70,51,50,7,117,110,105,49,70,51,51,7,117,
110,105,49,70,51,52,7,117,110,105,49,70,51,53,7,117,
110,105,49,70,51,54,7,117,110,105,49,70,51,55,7,117,
110,105,49,70,51,56,7,117,110,105,49,70,51,57,7,117,
110,105,49,70,51,65,7,117,110,105,49,70,51,66,7,117,
110,105,49,70,51,67,7,117,110,105,49,70,51,68,7,117,
110,105,49,70,51,69,7,117,110,105,49,70,51,70,7,117,
110,105,49,70,52,48,7,117,110,105,49,70,52,49,7,117,
110,105,49,70,52,50,7,117,110,105,49,70,52,51,7,117,
110,105,49,70,52,52,7,117,110,105,49,70,52,53,7,117,
110,105,49,70,52,56,7,117,110,105,49,70,52,57,7,117,
110,105,49,70,52,65,7,117,110,105,49,70,52,66,7,117,
110,105,49,70,52,67,7,117,110,105,49,70,52,68,7,117,
110,105,49,70,53,48,7,117,110,105,49,70,53,49,7,117,
110,105,49,70,53,50,7,117,110,105,49,70,53,51,7,117,
110,105,49,70,53,52,7,117,110,105,49,70,53,53,7,117,
110,105,49,70,53,54,7,117,110,105,49,70,53,55,7,117,
110,105,49,70,53,57,7,117,110,105,49,70,53,66,7,117,
110,105,49,70,53,68,7,117,110,105,49,70,53,70,7,117,
110,105,49,70,54,48,7,117,110,105,49,70,54,49,7,117,
110,105,49,70,54,50,7,117,110,105,49,70,54,51,7,117,
110,105,49,70,54,52,7,117,110,105,49,70,54,53,7,117,
110,105,49,70,54,54,7,117,110,105,49,70,54,55,7,117,
110,105,49,70,54,56,7,117,110,105,49,70,54,57,7,117,
110,105,49,70,54,65,7,117,110,105,49,70,54,66,7,117,
110,105,49,70,54,67,7,117,110,105,49,70,54,68,7,117,
110,105,49,70,54,69,7,117,110,105,49,70,54,70,7,117,
110,105,49,70,55,48,7,117,110,105,49,70,55,49,7,117,
110,105,49,70,55,50,7,117,110,105,49,70,55,51,7,117,
110,105,49,70,55,52,7,117,110,105,49,70,55,53,7,117,
110,105,49,70,55,54,7,117,110,105,49,70,55,55,7,117,
110,105,49,70,55,56,7,117,110,105,49,70,55,57,7,117,
110,105,49,70,55,65,7,117,110,105,49,70,55,66,7,117,
110,105,49,70,55,67,7,117,110,105,49,70,55,68,7,117,
110,105,49,70,56,48,7,117,110,105,49,70,56,49,7,117,
110,105,49,70,56,50,7,117,110,105,49,70,56,51,7,117,
110,105,49,70,56,52,7,117,110,105,49,70,56,53,7,117,
110,105,49,70,56,54,7,117,110,105,49,70,56,55,7,117,
110,105,49,70,56,56,7,117,110,105,49,70,56,57,7,117,
110,105,49,70,56,65,7,117,110,105,49,70,56,66,7,117,
110,105,49,70,56,67,7,117,110,105,49,70,56,68,7,117,
110,105,49,70,56,69,7,117,110,105,49,70,56,70,7,117,
110,105,49,70,57,48,7,117,110,105,49,70,57,49,7,117,
110,105,49,70,57,50,7,117,110,105,49,70,57,51,7,117,
110,105,49,70,57,52,7,117,110,105,49,70,57,53,7,117,
110,105,49,70,57,54,7,117,110,105,49,70,57,55,7,117,
110,105,49,70,57,56,7,117,110,105,49,70,57,57,7,117,
110,105,49,70,57,65,7,117,110,105,49,70,57,66,7,117,
110,105,49,70,57,67,7,117,110,105,49,70,57,68,7,117,
110,105,49,70,57,69,7,117,110,105,49,70,57,70,7,117,
110,105,49,70,65,48,7,117,110,105,49,70,65,49,7,117,
110,105,49,70,65,50,7,117,110,105,49,70,65,51,7,117,
110,105,49,70,65,52,7,117,110,105,49,70,65,53,7,117,
110,105,49,70,65,54,7,117,110,105,49,70,65,55,7,117,
110,105,49,70,65,56,7,117,110,105,49,70,65,57,7,117,
110,105,49,70,65,65,7,117,110,105,49,70,65,66,7,117,
110,105,49,70,65,67,7,117,110,105,49,70,65,68,7,117,
110,105,49,70,65,69,7,117,110,105,49,70,65,70,7,117,
110,105,49,70,66,48,7,117,110,105,49,70,66,49,7,117,
110,105,49,70,66,50,7,117,110,105,49,70,66,51,7,117,
110,105,49,70,66,52,7,117,110,105,49,70,66,54,7,117,
110,105,49,70,66,55,7,117,110,105,49,70,66,56,7,117,
110,105,49,70,66,57,7,117,110,105,49,70,66,65,7,117,
110,105,49,70,66,66,7,117,110,105,49,70,66,67,7,117,
110,105,49,70,66,68,7,117,110,105,49,70,66,69,7,117,
110,105,49,70,66,70,7,117,110,105,49,70,67,48,7,117,
110,105,49,70,67,49,7,117,110,105,49,70,67,50,7,117,
110,105,49,70,67,51,7,117,110,105,49,70,67,52,7,117,
110,105,49,70,67,54,7,117,110,105,49,70,67,55,7,117,
110,105,49,70,67,56,7,117,110,105,49,70,67,57,7,117,
110,105,49,70,67,65,7,117,110,105,49,70,67,66,7,117,
110,105,49,70,67,67,7,117,110,105,49,70,67,68,7,117,
110,105,49,70,67,69,7,117,110,105,49,70,67,70,7,117,
110,105,49,70,68,48,7,117,110,105,49,70,68,49,7,117,
110,105,49,70,68,50,7,117,110,105,49,70,68,51,7,117,
110,105,49,70,68,54,7,117,110,105,49,70,68,55,7,117,
110,105,49,70,68,56,7,117,110,105,49,70,68,57,7,117,
110,105,49,70,68,65,7,117,110,105,49,70,68,66,7,117,
110,105,49,70,68,68,7,117,110,105,49,70,68,69,7,117,
110,105,49,70,68,70,7,117,110,105,49,70,69,48,7,117,
110,105,49,70,69,49,7,117,110,105,49,70,69,50,7,117,
110,105,49,70,69,51,7,117,110,105,49,70,69,52,7,117,
110,105,49,70,69,53,7,117,110,105,49,70,69,54,7,117,
110,105,49,70,69,55,7,117,110,105,49,70,69,56,7,117,
110,105,49,70,69,57,7,117,110,105,49,70,69,65,7,117,
110,105,49,70,69,66,7,117,110,105,49,70,69,67,7,117,
110,105,49,70,69,68,7,117,110,105,49,70,69,69,7,117,
110,105,49,70,69,70,7,117,110,105,49,70,70,50,7,117,
110,105,49,70,70,51,7,117,110,105,49,70,70,52,7,117,
110,105,49,70,70,54,7,117,110,105,49,70,70,55,7,117,
110,105,49,70,70,56,7,117,110,105,49,70,70,57,7,117,
110,105,49,70,70,65,7,117,110,105,49,70,70,66,7,117,
110,105,49,70,70,67,7,117,110,105,49,70,70,68,7,117,
110,105,49,70,70,69,7,117,110,105,50,48,48,48,7,117,
110,105,50,48,48,49,7,117,110,105,50,48,48,50,7,117,
110,105,50,48,48,51,7,117,110,105,50,48,48,52,7,117,
110,105,50,48,48,53,7,117,110,105,50,48,48,54,7,117,
110,105,50,48,48,55,7,117,110,105,50,48,48,56,7,117,
110,105,50,48,48,57,7,117,110,105,50,48,48,65,7,117,
110,105,50,48,48,66,7,117,110,105,50,48,49,48,7,117,
110,105,50,48,49,49,10,102,105,103,117,114,101,100,97,115,
104,7,117,110,105,50,48,49,53,7,117,110,105,50,48,49,
54,13,117,110,100,101,114,115,99,111,114,101,100,98,108,13,
113,117,111,116,101,114,101,118,101,114,115,101,100,7,117,110,
105,50,48,49,70,7,117,110,105,50,48,50,51,14,111,110,
101,100,111,116,101,110,108,101,97,100,101,114,14,116,119,111,
100,111,116,101,110,108,101,97,100,101,114,7,117,110,105,50,
48,50,55,12,122,101,114,111,115,117,112,101,114,105,111,114,
12,102,111,117,114,115,117,112,101,114,105,111,114,12,102,105,
118,101,115,117,112,101,114,105,111,114,11,115,105,120,115,117,
112,101,114,105,111,114,13,115,101,118,101,110,115,117,112,101,
114,105,111,114,13,101,105,103,104,116,115,117,112,101,114,105,
111,114,12,110,105,110,101,115,117,112,101,114,105,111,114,7,
117,110,105,50,48,55,65,7,117,110,105,50,48,55,66,7,
117,110,105,50,48,55,67,17,112,97,114,101,110,108,101,102,
116,115,117,112,101,114,105,111,114,18,112,97,114,101,110,114,
105,103,104,116,115,117,112,101,114,105,111,114,9,110,115,117,
112,101,114,105,111,114,12,122,101,114,111,105,110,102,101,114,
105,111,114,11,111,110,101,105,110,102,101,114,105,111,114,11,
116,119,111,105,110,102,101,114,105,111,114,13,116,104,114,101,
101,105,110,102,101,114,105,111,114,12,102,111,117,114,105,110,
102,101,114,105,111,114,12,102,105,118,101,105,110,102,101,114,
105,111,114,11,115,105,120,105,110,102,101,114,105,111,114,13,
115,101,118,101,110,105,110,102,101,114,105,111,114,13,101,105,
103,104,116,105,110,102,101,114,105,111,114,12,110,105,110,101,
105,110,102,101,114,105,111,114,7,117,110,105,50,48,56,65,
7,117,110,105,50,48,56,66,7,117,110,105,50,48,56,67,
17,112,97,114,101,110,108,101,102,116,105,110,102,101,114,105,
111,114,18,112,97,114,101,110,114,105,103,104,116,105,110,102,
101,114,105,111,114,13,99,111,108,111,110,109,111,110,101,116,
97,114,121,7,117,110,105,50,48,65,50,4,108,105,114,97,
7,117,110,105,50,48,65,53,7,117,110,105,50,48,65,54,
6,112,101,115,101,116,97,7,117,110,105,50,48,65,56,4,
100,111,110,103,4,69,117,114,111,7,117,110,105,50,48,65,
68,7,117,110,105,50,48,65,69,7,117,110,105,50,48,65,
70,7,117,110,105,50,48,66,49,7,117,110,105,50,50,49,
57,9,106,46,100,111,116,108,101,115,115,11,117,110,105,48,
51,48,50,48,51,48,49,11,117,110,105,48,51,48,50,48,
51,48,48,11,117,110,105,48,51,48,50,48,51,48,57,11,
117,110,105,48,51,48,50,48,51,48,51,11,117,110,105,48,
51,48,54,48,51,48,49,11,117,110,105,48,51,48,54,48,
51,48,48,11,117,110,105,48,51,48,54,48,51,48,57,11,
117,110,105,48,51,48,54,48,51,48,51,2,102,102,3,102,
102,105,3,102,102,108,9,103,114,97,118,101,46,97,108,116,
5,105,46,97,108,116,5,106,46,97,108,116,12,100,105,101,
114,101,115,105,115,46,97,108,116,10,109,97,99,114,111,110,
46,97,108,116,9,97,99,117,116,101,46,97,108,116,11,117,
110,105,48,50,54,56,46,97,108,116,11,117,110,105,48,50,
57,68,46,97,108,116,14,99,105,114,99,117,109,102,108,101,
120,46,97,108,116,9,99,97,114,111,110,46,97,108,116,11,
117,110,105,48,50,67,65,46,97,108,116,11,117,110,105,48,
50,67,66,46,97,108,116,13,100,111,116,97,99,99,101,110,
116,46,97,108,116,9,116,105,108,100,101,46,97,108,116,13,
103,114,97,118,101,99,111,109,98,46,97,108,116,13,97,99,
117,116,101,99,111,109,98,46,97,108,116,11,117,110,105,48,
51,48,50,46,97,108,116,13,116,105,108,100,101,99,111,109,
98,46,97,108,116,11,117,110,105,48,51,48,52,46,97,108,
116,11,117,110,105,48,51,48,55,46,97,108,116,11,117,110,
105,48,51,48,56,46,97,108,116,11,117,110,105,48,51,48,
67,46,97,108,116,11,117,110,105,48,51,52,48,46,97,108,
116,11,117,110,105,48,51,52,49,46,97,108,116,10,97,103,
114,97,118,101,46,97,108,116,10,97,97,99,117,116,101,46,
97,108,116,15,97,99,105,114,99,117,109,102,108,101,120,46,
97,108,116,10,97,116,105,108,100,101,46,97,108,116,13,97,
100,105,101,114,101,115,105,115,46,97,108,116,10,101,103,114,
97,118,101,46,97,108,116,10,101,97,99,117,116,101,46,97,
108,116,15,101,99,105,114,99,117,109,102,108,101,120,46,97,
108,116,13,101,100,105,101,114,101,115,105,115,46,97,108,116,
10,105,103,114,97,118,101,46,97,108,116,10,105,97,99,117,
116,101,46,97,108,116,15,105,99,105,114,99,117,109,102,108,
101,120,46,97,108,116,13,105,100,105,101,114,101,115,105,115,
46,97,108,116,10,110,116,105,108,100,101,46,97,108,116,10,
111,103,114,97,118,101,46,97,108,116,10,111,97,99,117,116,
101,46,97,108,116,15,111,99,105,114,99,117,109,102,108,101,
120,46,97,108,116,10,111,116,105,108,100,101,46,97,108,116,
13,111,100,105,101,114,101,115,105,115,46,97,108,116,10,117,
103,114,97,118,101,46,97,108,116,10,117,97,99,117,116,101,
46,97,108,116,15,117,99,105,114,99,117,109,102,108,101,120,
46,97,108,116,13,117,100,105,101,114,101,115,105,115,46,97,
108,116,10,121,97,99,117,116,101,46,97,108,116,13,121,100,
105,101,114,101,115,105,115,46,97,108,116,11,97,109,97,99,
114,111,110,46,97,108,116,10,99,97,99,117,116,101,46,97,
108,116,15,99,99,105,114,99,117,109,102,108,101,120,46,97,
108,116,14,99,100,111,116,97,99,99,101,110,116,46,97,108,
116,10,99,99,97,114,111,110,46,97,108,116,11,101,109,97,
99,114,111,110,46,97,108,116,14,101,100,111,116,97,99,99,
101,110,116,46,97,108,116,10,101,99,97,114,111,110,46,97,
108,116,15,103,99,105,114,99,117,109,102,108,101,120,46,97,
108,116,14,103,100,111,116,97,99,99,101,110,116,46,97,108,
116,10,105,116,105,108,100,101,46,97,108,116,11,105,109,97,
99,114,111,110,46,97,108,116,11,105,111,103,111,110,101,107,
46,97,108,116,6,105,106,46,97,108,116,15,106,99,105,114,
99,117,109,102,108,101,120,46,97,108,116,10,110,97,99,117,
116,101,46,97,108,116,10,110,99,97,114,111,110,46,97,108,
116,11,111,109,97,99,114,111,110,46,97,108,116,10,114,97,
99,117,116,101,46,97,108,116,10,114,99,97,114,111,110,46,
97,108,116,10,115,97,99,117,116,101,46,97,108,116,15,115,
99,105,114,99,117,109,102,108,101,120,46,97,108,116,10,115,
99,97,114,111,110,46,97,108,116,10,117,116,105,108,100,101,
46,97,108,116,11,117,109,97,99,114,111,110,46,97,108,116,
15,119,99,105,114,99,117,109,102,108,101,120,46,97,108,116,
15,121,99,105,114,99,117,109,102,108,101,120,46,97,108,116,
10,122,97,99,117,116,101,46,97,108,116,14,122,100,111,116,
97,99,99,101,110,116,46,97,108,116,10,122,99,97,114,111,
110,46,97,108,116,11,117,110,105,48,49,67,53,46,97,108,
116,11,117,110,105,48,49,67,54,46,97,108,116,11,117,110,
105,48,49,67,56,46,97,108,116,11,117,110,105,48,49,67,
57,46,97,108,116,11,117,110,105,48,49,67,66,46,97,108,
116,11,117,110,105,48,49,67,67,46,97,108,116,11,117,110,
105,48,49,67,69,46,97,108,116,11,117,110,105,48,49,68,
48,46,97,108,116,11,117,110,105,48,49,68,50,46,97,108,
116,11,117,110,105,48,49,68,52,46,97,108,116,11,117,110,
105,48,49,68,54,46,97,108,116,11,117,110,105,48,49,68,
56,46,97,108,116,11,117,110,105,48,49,68,65,46,97,108,
116,11,117,110,105,48,49,68,67,46,97,108,116,11,117,110,
105,48,49,68,70,46,97,108,116,11,117,110,105,48,49,69,
49,46,97,108,116,11,117,110,105,48,49,69,51,46,97,108,
116,10,103,99,97,114,111,110,46,97,108,116,11,117,110,105,
48,49,69,68,46,97,108,116,11,117,110,105,48,49,69,70,
46,97,108,116,11,117,110,105,48,49,70,48,46,97,108,116,
11,117,110,105,48,49,70,53,46,97,108,116,11,117,110,105,
48,49,70,57,46,97,108,116,11,97,101,97,99,117,116,101,
46,97,108,116,15,111,115,108,97,115,104,97,99,117,116,101,
46,97,108,116,11,117,110,105,48,50,50,55,46,97,108,116,
11,117,110,105,48,50,50,66,46,97,108,116,11,117,110,105,
48,50,50,68,46,97,108,116,11,117,110,105,48,50,50,70,
46,97,108,116,11,117,110,105,48,50,51,49,46,97,108,116,
11,117,110,105,48,50,51,51,46,97,108,116,11,117,110,105,
49,69,48,51,46,97,108,116,11,117,110,105,49,69,48,57,
46,97,108,116,11,117,110,105,49,69,48,66,46,97,108,116,
11,117,110,105,49,69,49,53,46,97,108,116,11,117,110,105,
49,69,49,55,46,97,108,116,11,117,110,105,49,69,50,49,
46,97,108,116,11,117,110,105,49,69,50,68,46,97,108,116,
11,117,110,105,49,69,50,70,46,97,108,116,11,117,110,105,
49,69,51,70,46,97,108,116,11,117,110,105,49,69,52,49,
46,97,108,116,11,117,110,105,49,69,52,53,46,97,108,116,
11,117,110,105,49,69,52,68,46,97,108,116,11,117,110,105,
49,69,52,70,46,97,108,116,11,117,110,105,49,69,53,49,
46,97,108,116,11,117,110,105,49,69,53,51,46,97,108,116,
11,117,110,105,49,69,53,53,46,97,108,116,11,117,110,105,
49,69,53,55,46,97,108,116,11,117,110,105,49,69,53,57,
46,97,108,116,11,117,110,105,49,69,53,68,46,97,108,116,
11,117,110,105,49,69,54,49,46,97,108,116,11,117,110,105,
49,69,54,53,46,97,108,116,11,117,110,105,49,69,54,55,
46,97,108,116,11,117,110,105,49,69,54,57,46,97,108,116,
11,117,110,105,49,69,55,57,46,97,108,116,11,117,110,105,
49,69,55,66,46,97,108,116,11,117,110,105,49,69,55,68,
46,97,108,116,10,119,103,114,97,118,101,46,97,108,116,10,
119,97,99,117,116,101,46,97,108,116,13,119,100,105,101,114,
101,115,105,115,46,97,108,116,11,117,110,105,49,69,56,55,
46,97,108,116,11,117,110,105,49,69,56,66,46,97,108,116,
11,117,110,105,49,69,56,68,46,97,108,116,11,117,110,105,
49,69,56,70,46,97,108,116,11,117,110,105,49,69,57,49,
46,97,108,116,11,117,110,105,49,69,65,53,46,97,108,116,
11,117,110,105,49,69,65,55,46,97,108,116,11,117,110,105,
49,69,65,57,46,97,108,116,11,117,110,105,49,69,65,66,
46,97,108,116,11,117,110,105,49,69,65,68,46,97,108,116,
11,117,110,105,49,69,65,70,46,97,108,116,11,117,110,105,
49,69,66,49,46,97,108,116,11,117,110,105,49,69,66,53,
46,97,108,116,11,117,110,105,49,69,66,68,46,97,108,116,
11,117,110,105,49,69,66,70,46,97,108,116,11,117,110,105,
49,69,67,49,46,97,108,116,11,117,110,105,49,69,67,51,
46,97,108,116,11,117,110,105,49,69,67,53,46,97,108,116,
11,117,110,105,49,69,67,55,46,97,108,116,11,117,110,105,
49,69,67,66,46,97,108,116,11,117,110,105,49,69,68,49,
46,97,108,116,11,117,110,105,49,69,68,51,46,97,108,116,
11,117,110,105,49,69,68,53,46,97,108,116,11,117,110,105,
49,69,68,55,46,97,108,116,11,117,110,105,49,69,68,57,
46,97,108,116,11,117,110,105,49,69,68,66,46,97,108,116,
11,117,110,105,49,69,68,68,46,97,108,116,11,117,110,105,
49,69,69,49,46,97,108,116,11,117,110,105,49,69,69,57,
46,97,108,116,11,117,110,105,49,69,69,66,46,97,108,116,
11,117,110,105,49,69,69,70,46,97,108,116,10,121,103,114,
97,118,101,46,97,108,116,11,117,110,105,49,69,70,57,46,
97,108,116,11,117,110,105,48,51,52,50,46,97,108,116,11,
117,110,105,49,70,67,48,46,97,108,116,11,117,110,105,49,
70,67,49,46,97,108,116,11,117,110,105,49,70,67,70,46,
97,108,116,11,117,110,105,49,70,68,70,46,97,108,116,11,
117,110,105,49,70,48,54,46,97,108,116,11,117,110,105,49,
70,48,55,46,97,108,116,11,117,110,105,49,70,48,69,46,
97,108,116,11,117,110,105,49,70,48,70,46,97,108,116,11,
117,110,105,49,70,50,54,46,97,108,116,11,117,110,105,49,
70,50,55,46,97,108,116,11,117,110,105,49,70,50,69,46,
97,108,116,11,117,110,105,49,70,50,70,46,97,108,116,11,
117,110,105,49,70,51,54,46,97,108,116,11,117,110,105,49,
70,51,55,46,97,108,116,11,117,110,105,49,70,51,69,46,
97,108,116,11,117,110,105,49,70,51,70,46,97,108,116,11,
117,110,105,49,70,53,54,46,97,108,116,11,117,110,105,49,
70,53,55,46,97,108,116,11,117,110,105,49,70,53,70,46,
97,108,116,11,117,110,105,49,70,54,54,46,97,108,116,11,
117,110,105,49,70,54,55,46,97,108,116,11,117,110,105,49,
70,54,69,46,97,108,116,11,117,110,105,49,70,54,70,46,
97,108,116,11,117,110,105,49,70,56,54,46,97,108,116,11,
117,110,105,49,70,56,55,46,97,108,116,11,117,110,105,49,
70,56,69,46,97,108,116,11,117,110,105,49,70,56,70,46,
97,108,116,11,117,110,105,49,70,57,54,46,97,108,116,11,
117,110,105,49,70,57,55,46,97,108,116,11,117,110,105,49,
70,57,69,46,97,108,116,11,117,110,105,49,70,57,70,46,
97,108,116,11,117,110,105,49,70,65,54,46,97,108,116,11,
117,110,105,49,70,65,55,46,97,108,116,11,117,110,105,49,
70,65,69,46,97,108,116,11,117,110,105,49,70,65,70,46,
97,108,116,11,117,110,105,49,70,66,54,46,97,108,116,11,
117,110,105,49,70,66,55,46,97,108,116,11,117,110,105,49,
70,67,54,46,97,108,116,11,117,110,105,49,70,67,55,46,
97,108,116,11,117,110,105,49,70,68,54,46,97,108,116,11,
117,110,105,49,70,68,55,46,97,108,116,11,117,110,105,49,
70,69,54,46,97,108,116,11,117,110,105,49,70,69,55,46,
97,108,116,11,117,110,105,49,70,70,54,46,97,108,116,11,
117,110,105,49,70,70,55,46,97,108,116,15,117,110,105,48,
51,48,50,48,51,48,49,46,97,108,116,15,117,110,105,48,
51,48,50,48,51,48,48,46,97,108,116,15,117,110,105,48,
51,48,50,48,51,48,57,46,97,108,116,15,117,110,105,48,
51,48,50,48,51,48,51,46,97,108,116,15,117,110,105,48,
51,48,54,48,51,48,49,46,97,108,116,15,117,110,105,48,
51,48,54,48,51,48,48,46,97,108,116,15,117,110,105,48,
51,48,54,48,51,48,51,46,97,108,116,6,102,105,46,97,
108,116,7,102,102,105,46,97,108,116,7,117,110,105,48,52,
48,53,7,117,110,105,48,52,48,54,7,117,110,105,48,52,
48,56,7,117,110,105,48,52,49,48,7,117,110,105,48,52,
49,49,7,117,110,105,48,52,49,50,7,117,110,105,48,52,
49,51,7,117,110,105,48,52,49,52,7,117,110,105,48,52,
49,53,7,117,110,105,48,52,49,54,7,117,110,105,48,52,
49,55,7,117,110,105,48,52,49,56,7,117,110,105,48,52,
49,57,7,117,110,105,48,52,49,65,7,117,110,105,48,52,
49,66,7,117,110,105,48,52,49,67,7,117,110,105,48,52,
49,68,7,117,110,105,48,52,49,69,7,117,110,105,48,52,
49,70,7,117,110,105,48,52,50,48,7,117,110,105,48,52,
50,49,7,117,110,105,48,52,50,50,7,117,110,105,48,52,
50,51,7,117,110,105,48,52,50,52,7,117,110,105,48,52,
50,53,7,117,110,105,48,52,50,54,7,117,110,105,48,52,
50,55,7,117,110,105,48,52,50,56,7,117,110,105,48,52,
50,57,7,117,110,105,48,52,50,65,7,117,110,105,48,52,
50,66,7,117,110,105,48,52,50,67,7,117,110,105,48,52,
50,68,7,117,110,105,48,52,50,69,7,117,110,105,48,52,
50,70,7,117,110,105,48,52,51,48,7,117,110,105,48,52,
51,49,7,117,110,105,48,52,51,50,7,117,110,105,48,52,
51,51,7,117,110,105,48,52,51,52,7,117,110,105,48,52,
51,53,7,117,110,105,48,52,51,54,7,117,110,105,48,52,
51,55,7,117,110,105,48,52,51,56,7,117,110,105,48,52,
51,57,7,117,110,105,48,52,51,65,7,117,110,105,48,52,
51,66,7,117,110,105,48,52,51,67,7,117,110,105,48,52,
51,68,7,117,110,105,48,52,51,69,7,117,110,105,48,52,
51,70,7,117,110,105,48,52,52,48,7,117,110,105,48,52,
52,49,7,117,110,105,48,52,52,50,7,117,110,105,48,52,
52,51,7,117,110,105,48,52,52,52,7,117,110,105,48,52,
52,53,7,117,110,105,48,52,52,54,7,117,110,105,48,52,
52,55,7,117,110,105,48,52,52,56,7,117,110,105,48,52,
52,57,7,117,110,105,48,52,52,65,7,117,110,105,48,52,
52,66,7,117,110,105,48,52,52,67,7,117,110,105,48,52,
52,68,7,117,110,105,48,52,52,69,7,117,110,105,48,52,
52,70,7,117,110,105,48,52,53,53,7,117,110,105,48,52,
53,54,7,117,110,105,48,52,53,56,7,117,110,105,48,52,
67,48,7,117,110,105,48,52,67,53,7,117,110,105,48,52,
68,52,7,117,110,105,48,52,68,53,7,117,110,105,48,52,
68,56,7,117,110,105,48,52,68,57,7,117,110,105,48,52,
69,48,7,117,110,105,48,52,69,49,7,117,110,105,48,52,
69,56,7,117,110,105,48,52,69,57,7,117,110,105,48,53,
48,67,0,0,0,0,0,32,1,134,0,1,0,0,0,0,
0,0,0,63,0,14,0,1,0,0,0,0,0,1,0,7,
0,77,0,1,0,0,0,0,0,2,0,7,0,84,0,1,
0,0,0,0,0,3,0,18,0,91,0,1,0,0,0,0,
0,4,0,7,0,109,0,1,0,0,0,0,0,5,0,31,
0,116,0,1,0,0,0,0,0,6,0,7,0,147,0,1,
0,0,0,0,0,7,0,44,0,154,0,1,0,0,0,0,
0,9,0,18,0,198,0,1,0,0,0,0,0,11,0,19,
0,216,0,1,0,0,0,0,0,12,0,28,0,235,0,1,
0,0,0,0,0,13,17,122,1,7,0,1,0,0,0,0,
0,14,0,26,18,129,0,1,0,0,0,0,0,16,0,7,
18,155,0,1,0,0,0,0,0,17,0,7,18,162,0,1,
0,0,0,0,0,18,0,7,18,169,0,3,0,1,4,9,
0,0,0,126,18,176,0,3,0,1,4,9,0,1,0,14,
19,46,0,3,0,1,4,9,0,2,0,14,19,60,0,3,
0,1,4,9,0,3,0,36,19,74,0,3,0,1,4,9,
0,4,0,14,19,110,0,3,0,1,4,9,0,5,0,62,
19,124,0,3,0,1,4,9,0,6,0,14,19,186,0,3,
0,1,4,9,0,7,0,88,19,200,0,3,0,1,4,9,
0,9,0,36,20,32,0,3,0,1,4,9,0,11,0,38,
20,68,0,3,0,1,4,9,0,12,0,56,20,106,0,3,
0,1,4,9,0,13,34,244,20,162,0,3,0,1,4,9,
0,14,0,52,55,150,0,3,0,1,4,9,0,16,0,14,
55,202,0,3,0,1,4,9,0,17,0,14,55,216,0,3,
0,1,4,9,0,18,0,14,0,0,0,71,0,101,0,110,
0,116,0,105,0,117,0,109,67,111,112,121,114,105,103,104,
116,32,40,99,41,32,83,73,76,32,73,110,116,101,114,110,
97,116,105,111,110,97,108,32,50,48,48,51,45,50,48,48,
53,46,32,65,108,108,32,114,105,103,104,116,115,32,114,101,
115,101,114,118,101,100,46,71,101,110,116,105,117,109,82,101,
103,117,108,97,114,83,73,76,58,32,71,101,110,116,105,117,
109,58,32,50,48,48,53,71,101,110,116,105,117,109,86,101,
114,115,105,111,110,32,49,46,48,50,59,32,50,48,48,53,
59,32,79,70,76,32,114,101,108,101,97,115,101,71,101,110,
116,105,117,109,71,101,110,116,105,117,109,32,105,115,32,97,
32,116,114,97,100,101,109,97,114,107,32,111,102,32,83,73,
76,32,73,110,116,101,114,110,97,116,105,111,110,97,108,46,
74,46,32,86,105,99,116,111,114,32,71,97,117,108,116,110,
101,121,104,116,116,112,58,47,47,119,119,119,46,115,105,108,
46,111,114,103,47,104,116,116,112,58,47,47,119,119,119,46,
115,105,108,46,111,114,103,47,126,103,97,117,108,116,110,101,
121,84,104,105,115,32,70,111,110,116,32,83,111,102,116,119,
97,114,101,32,105,115,32,67,111,112,121,114,105,103,104,116,
32,40,99,41,32,50,48,48,51,45,50,48,48,53,44,32,
83,73,76,32,73,110,116,101,114,110,97,116,105,111,110,97,
108,32,40,104,116,116,112,58,47,47,115,99,114,105,112,116,
115,46,115,105,108,46,111,114,103,47,41,46,32,65,108,108,
32,82,105,103,104,116,115,32,82,101,115,101,114,118,101,100,
46,13,10,13,10,34,71,101,110,116,105,117,109,34,32,105,
115,32,97,32,82,101,115,101,114,118,101,100,32,70,111,110,
116,32,78,97,109,101,32,102,111,114,32,116,104,105,115,32,
70,111,110,116,32,83,111,102,116,119,97,114,101,46,13,10,
34,83,73,76,34,32,105,115,32,97,32,82,101,115,101,114,
118,101,100,32,70,111,110,116,32,78,97,109,101,32,102,111,
114,32,116,104,105,115,32,70,111,110,116,32,83,111,102,116,
119,97,114,101,46,13,10,13,10,84,104,105,115,32,70,111,
110,116,32,83,111,102,116,119,97,114,101,32,105,115,32,108,
105,99,101,110,115,101,100,32,117,110,100,101,114,32,116,104,
101,32,83,73,76,32,79,112,101,110,32,70,111,110,116,32,
76,105,99,101,110,115,101,44,32,86,101,114,115,105,111,110,
32,49,46,48,46,32,78,111,32,109,111,100,105,102,105,99,
97,116,105,111,110,32,111,102,32,116,104,101,32,108,105,99,
101,110,115,101,32,105,115,32,112,101,114,109,105,116,116,101,
100,44,32,111,110,108,121,32,118,101,114,98,97,116,105,109,
32,99,111,112,121,32,105,115,32,97,108,108,111,119,101,100,
46,32,84,104,105,115,32,108,105,99,101,110,115,101,32,105,
115,32,99,111,112,105,101,100,32,98,101,108,111,119,44,32,
97,110,100,32,105,115,32,97,108,115,111,32,97,118,97,105,
108,97,98,108,101,32,119,105,116,104,32,97,32,70,65,81,
32,97,116,58,32,104,116,116,112,58,47,47,115,99,114,105,
112,116,115,46,115,105,108,46,111,114,103,47,79,70,76,13,
10,13,10,13,10,45,45,45,45,45,45,45,45,45,45,45,
45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,
45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,
45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,
13,10,83,73,76,32,79,80,69,78,32,70,79,78,84,32,
76,73,67,69,78,83,69,32,86,101,114,115,105,111,110,32,
49,46,48,32,45,32,50,50,32,78,111,118,101,109,98,101,
114,32,50,48,48,53,13,10,45,45,45,45,45,45,45,45,
45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,
45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,
45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,
45,45,45,13,10,13,10,80,82,69,65,77,66,76,69,13,
10,84,104,101,32,103,111,97,108,115,32,111,102,32,116,104,
101,32,79,112,101,110,32,70,111,110,116,32,76,105,99,101,
110,115,101,32,40,79,70,76,41,32,97,114,101,32,116,111,
32,115,116,105,109,117,108,97,116,101,32,119,111,114,108,100,
119,105,100,101,32,100,101,118,101,108,111,112,109,101,110,116,
32,111,102,32,99,111,111,112,101,114,97,116,105,118,101,32,
102,111,110,116,32,112,114,111,106,101,99,116,115,44,32,116,
111,32,115,117,112,112,111,114,116,32,116,104,101,32,102,111,
110,116,32,99,114,101,97,116,105,111,110,32,101,102,102,111,
114,116,115,32,111,102,32,97,99,97,100,101,109,105,99,32,
97,110,100,32,108,105,110,103,117,105,115,116,105,99,32,99,
111,109,109,117,110,105,116,105,101,115,44,32,97,110,100,32,
116,111,32,112,114,111,118,105,100,101,32,97,110,32,111,112,
101,110,32,102,114,97,109,101,119,111,114,107,32,105,110,32,
119,104,105,99,104,32,102,111,110,116,115,32,109,97,121,32,
98,101,32,115,104,97,114,101,100,32,97,110,100,32,105,109,
112,114,111,118,101,100,32,105,110,32,112,97,114,116,110,101,
114,115,104,105,112,32,119,105,116,104,32,111,116,104,101,114,
115,46,13,10,13,10,84,104,101,32,79,70,76,32,97,108,
108,111,119,115,32,116,104,101,32,108,105,99,101,110,115,101,
100,32,102,111,110,116,115,32,116,111,32,98,101,32,117,115,
101,100,44,32,115,116,117,100,105,101,100,44,32,109,111,100,
105,102,105,101,100,32,97,110,100,32,114,101,100,105,115,116,
114,105,98,117,116,101,100,32,102,114,101,101,108,121,32,97,
115,32,108,111,110,103,32,97,115,32,116,104,101,121,32,97,
114,101,32,110,111,116,32,115,111,108,100,32,98,121,32,116,
104,101,109,115,101,108,118,101,115,46,32,84,104,101,32,102,
111,110,116,115,44,32,105,110,99,108,117,100,105,110,103,32,
97,110,121,32,100,101,114,105,118,97,116,105,118,101,32,119,
111,114,107,115,44,32,99,97,110,32,98,101,32,98,117,110,
100,108,101,100,44,32,101,109,98,101,100,100,101,100,44,32,
114,101,100,105,115,116,114,105,98,117,116,101,100,32,97,110,
100,32,115,111,108,100,32,119,105,116,104,32,97,110,121,32,
115,111,102,116,119,97,114,101,32,112,114,111,118,105,100,101,
100,32,116,104,97,116,32,116,104,101,32,102,111,110,116,32,
110,97,109,101,115,32,111,102,32,100,101,114,105,118,97,116,
105,118,101,32,119,111,114,107,115,32,97,114,101,32,99,104,
97,110,103,101,100,46,32,84,104,101,32,102,111,110,116,115,
32,97,110,100,32,100,101,114,105,118,97,116,105,118,101,115,
44,32,104,111,119,101,118,101,114,44,32,99,97,110,110,111,
116,32,98,101,32,114,101,108,101,97,115,101,100,32,117,110,
100,101,114,32,97,110,121,32,111,116,104,101,114,32,116,121,
112,101,32,111,102,32,108,105,99,101,110,115,101,46,13,10,
13,10,68,69,70,73,78,73,84,73,79,78,83,13,10,34,
70,111,110,116,32,83,111,102,116,119,97,114,101,34,32,114,
101,102,101,114,115,32,116,111,32,97,110,121,32,97,110,100,
32,97,108,108,32,111,102,32,116,104,101,32,102,111,108,108,
111,119,105,110,103,58,13,10,9,45,32,102,111,110,116,32,
102,105,108,101,115,13,10,9,45,32,100,97,116,97,32,102,
105,108,101,115,13,10,9,45,32,115,111,117,114,99,101,32,
99,111,100,101,13,10,9,45,32,98,117,105,108,100,32,115,
99,114,105,112,116,115,13,10,9,45,32,100,111,99,117,109,
101,110,116,97,116,105,111,110,13,10,13,10,34,82,101,115,
101,114,118,101,100,32,70,111,110,116,32,78,97,109,101,34,
32,114,101,102,101,114,115,32,116,111,32,116,104,101,32,70,
111,110,116,32,83,111,102,116,119,97,114,101,32,110,97,109,
101,32,97,115,32,115,101,101,110,32,98,121,32,117,115,101,
114,115,32,97,110,100,32,97,110,121,32,111,116,104,101,114,
32,110,97,109,101,115,32,97,115,32,115,112,101,99,105,102,
105,101,100,32,97,102,116,101,114,32,116,104,101,32,99,111,
112,121,114,105,103,104,116,32,115,116,97,116,101,109,101,110,
116,46,13,10,13,10,34,83,116,97,110,100,97,114,100,32,
86,101,114,115,105,111,110,34,32,114,101,102,101,114,115,32,
116,111,32,116,104,101,32,99,111,108,108,101,99,116,105,111,
110,32,111,102,32,70,111,110,116,32,83,111,102,116,119,97,
114,101,32,99,111,109,112,111,110,101,110,116,115,32,97,115,
32,100,105,115,116,114,105,98,117,116,101,100,32,98,121,32,
116,104,101,32,67,111,112,121,114,105,103,104,116,32,72,111,
108,100,101,114,46,13,10,13,10,34,77,111,100,105,102,105,
101,100,32,86,101,114,115,105,111,110,34,32,114,101,102,101,
114,115,32,116,111,32,97,110,121,32,100,101,114,105,118,97,
116,105,118,101,32,102,111,110,116,32,115,111,102,116,119,97,
114,101,32,109,97,100,101,32,98,121,32,97,100,100,105,110,
103,32,116,111,44,32,100,101,108,101,116,105,110,103,44,32,
111,114,32,115,117,98,115,116,105,116,117,116,105,110,103,32,
45,45,32,105,110,32,112,97,114,116,32,111,114,32,105,110,
32,119,104,111,108,101,32,45,45,32,97,110,121,32,111,102,
32,116,104,101,32,99,111,109,112,111,110,101,110,116,115,32,
111,102,32,116,104,101,32,83,116,97,110,100,97,114,100,32,
86,101,114,115,105,111,110,44,32,98,121,32,99,104,97,110,
103,105,110,103,32,102,111,114,109,97,116,115,32,111,114,32,
98,121,32,112,111,114,116,105,110,103,32,116,104,101,32,70,
111,110,116,32,83,111,102,116,119,97,114,101,32,116,111,32,
97,32,110,101,119,32,101,110,118,105,114,111,110,109,101,110,
116,46,13,10,13,10,34,65,117,116,104,111,114,34,32,114,
101,102,101,114,115,32,116,111,32,97,110,121,32,100,101,115,
105,103,110,101,114,44,32,101,110,103,105,110,101,101,114,44,
32,112,114,111,103,114,97,109,109,101,114,44,32,116,101,99,
104,110,105,99,97,108,32,119,114,105,116,101,114,32,111,114,
32,111,116,104,101,114,32,112,101,114,115,111,110,32,119,104,
111,32,99,111,110,116,114,105,98,117,116,101,100,32,116,111,
32,116,104,101,32,70,111,110,116,32,83,111,102,116,119,97,
114,101,46,13,10,13,10,80,69,82,77,73,83,83,73,79,
78,32,38,32,67,79,78,68,73,84,73,79,78,83,13,10,
80,101,114,109,105,115,115,105,111,110,32,105,115,32,104,101,
114,101,98,121,32,103,114,97,110,116,101,100,44,32,102,114,
101,101,32,111,102,32,99,104,97,114,103,101,44,32,116,111,
32,97,110,121,32,112,101,114,115,111,110,32,111,98,116,97,
105,110,105,110,103,32,97,32,99,111,112,121,32,111,102,32,
116,104,101,32,70,111,110,116,32,83,111,102,116,119,97,114,
101,44,32,116,111,32,117,115,101,44,32,115,116,117,100,121,
44,32,99,111,112,121,44,32,109,101,114,103,101,44,32,101,
109,98,101,100,44,32,109,111,100,105,102,121,44,32,114,101,
100,105,115,116,114,105,98,117,116,101,44,32,97,110,100,32,
115,101,108,108,32,109,111,100,105,102,105,101,100,32,97,110,
100,32,117,110,109,111,100,105,102,105,101,100,32,99,111,112,
105,101,115,32,111,102,32,116,104,101,32,70,111,110,116,83,
111,102,116,119,97,114,101,44,32,115,117,98,106,101,99,116,
32,116,111,32,116,104,101,32,102,111,108,108,111,119,105,110,
103,32,99,111,110,100,105,116,105,111,110,115,58,13,10,13,
10,49,41,32,78,101,105,116,104,101,114,32,116,104,101,32,
70,111,110,116,32,83,111,102,116,119,97,114,101,32,110,111,
114,32,97,110,121,32,111,102,32,105,116,115,32,105,110,100,
105,118,105,100,117,97,108,32,99,111,109,112,111,110,101,110,
116,115,44,32,105,110,32,83,116,97,110,100,97,114,100,32,
111,114,32,77,111,100,105,102,105,101,100,32,86,101,114,115,
105,111,110,115,44,32,109,97,121,32,98,101,32,115,111,108,
100,32,98,121,32,105,116,115,101,108,102,46,13,10,13,10,
50,41,32,83,116,97,110,100,97,114,100,32,111,114,32,77,
111,100,105,102,105,101,100,32,86,101,114,115,105,111,110,115,
32,111,102,32,116,104,101,32,70,111,110,116,32,83,111,102,
116,119,97,114,101,32,109,97,121,32,98,101,32,98,117,110,
100,108,101,100,44,32,114,101,100,105,115,116,114,105,98,117,
116,101,100,32,97,110,100,32,115,111,108,100,32,119,105,116,
104,32,97,110,121,32,115,111,102,116,119,97,114,101,44,32,
112,114,111,118,105,100,101,100,32,116,104,97,116,32,101,97,
99,104,32,99,111,112,121,32,99,111,110,116,97,105,110,115,
32,116,104,101,32,97,98,111,118,101,32,99,111,112,121,114,
105,103,104,116,32,110,111,116,105,99,101,32,97,110,100,32,
116,104,105,115,32,108,105,99,101,110,115,101,46,32,84,104,
101,115,101,32,99,97,110,32,98,101,32,105,110,99,108,117,
100,101,100,32,101,105,116,104,101,114,32,97,115,32,115,116,
97,110,100,45,97,108,111,110,101,32,116,101,120,116,32,102,
105,108,101,115,44,32,104,117,109,97,110,45,114,101,97,100,
97,98,108,101,32,104,101,97,100,101,114,115,32,111,114,32,
105,110,32,116,104,101,32,97,112,112,114,111,112,114,105,97,
116,101,32,109,97,99,104,105,110,101,45,114,101,97,100,97,
98,108,101,32,109,101,116,97,100,97,116,97,32,102,105,101,
108,100,115,32,119,105,116,104,105,110,32,116,101,120,116,32,
111,114,32,98,105,110,97,114,121,32,102,105,108,101,115,32,
97,115,32,108,111,110,103,32,97,115,32,116,104,111,115,101,
32,102,105,101,108,100,115,32,99,97,110,32,98,101,32,101,
97,115,105,108,121,32,118,105,101,119,101,100,32,98,121,32,
116,104,101,32,117,115,101,114,46,13,10,13,10,51,41,32,
78,111,32,77,111,100,105,102,105,101,100,32,86,101,114,115,
105,111,110,32,111,102,32,116,104,101,32,70,111,110,116,32,
83,111,102,116,119,97,114,101,32,109,97,121,32,117,115,101,
32,116,104,101,32,82,101,115,101,114,118,101,100,32,70,111,
110,116,32,78,97,109,101,40,115,41,44,32,105,110,32,112,
97,114,116,32,111,114,32,105,110,32,119,104,111,108,101,44,
32,117,110,108,101,115,115,32,101,120,112,108,105,99,105,116,
32,119,114,105,116,116,101,110,32,112,101,114,109,105,115,115,
105,111,110,32,105,115,32,103,114,97,110,116,101,100,32,98,
121,32,116,104,101,32,67,111,112,121,114,105,103,104,116,32,
72,111,108,100,101,114,46,32,84,104,105,115,32,114,101,115,
116,114,105,99,116,105,111,110,32,97,112,112,108,105,101,115,
32,116,111,32,97,108,108,32,114,101,102,101,114,101,110,99,
101,115,32,115,116,111,114,101,100,32,105,110,32,116,104,101,
32,70,111,110,116,32,83,111,102,116,119,97,114,101,44,32,
115,117,99,104,32,97,115,32,116,104,101,32,102,111,110,116,
32,109,101,110,117,32,110,97,109,101,32,97,110,100,32,111,
116,104,101,114,32,102,111,110,116,32,100,101,115,99,114,105,
112,116,105,111,110,32,102,105,101,108,100,115,44,32,119,104,
105,99,104,32,97,114,101,32,117,115,101,100,32,116,111,32,
100,105,102,102,101,114,101,110,116,105,97,116,101,32,116,104,
101,32,102,111,110,116,32,102,114,111,109,32,111,116,104,101,
114,115,46,13,10,13,10,52,41,32,84,104,101,32,110,97,
109,101,40,115,41,32,111,102,32,116,104,101,32,67,111,112,
121,114,105,103,104,116,32,72,111,108,100,101,114,32,111,114,
32,116,104,101,32,65,117,116,104,111,114,40,115,41,32,111,
102,32,116,104,101,32,70,111,110,116,32,83,111,102,116,119,
97,114,101,32,115,104,97,108,108,32,110,111,116,32,98,101,
32,117,115,101,100,32,116,111,32,112,114,111,109,111,116,101,
44,32,101,110,100,111,114,115,101,32,111,114,32,97,100,118,
101,114,116,105,115,101,32,97,110,121,32,77,111,100,105,102,
105,101,100,32,86,101,114,115,105,111,110,44,32,101,120,99,
101,112,116,32,116,111,32,97,99,107,110,111,119,108,101,100,
103,101,32,116,104,101,32,99,111,110,116,114,105,98,117,116,
105,111,110,40,115,41,32,111,102,32,116,104,101,32,67,111,
112,121,114,105,103,104,116,32,72,111,108,100,101,114,32,97,
110,100,32,116,104,101,32,65,117,116,104,111,114,40,115,41,
32,111,114,32,119,105,116,104,32,116,104,101,105,114,32,101,
120,112,108,105,99,105,116,32,119,114,105,116,116,101,110,32,
112,101,114,109,105,115,115,105,111,110,46,13,10,13,10,53,
41,32,84,104,101,32,70,111,110,116,32,83,111,102,116,119,
97,114,101,44,32,109,111,100,105,102,105,101,100,32,111,114,
32,117,110,109,111,100,105,102,105,101,100,44,32,105,110,32,
112,97,114,116,32,111,114,32,105,110,32,119,104,111,108,101,
44,32,109,117,115,116,32,98,101,32,100,105,115,116,114,105,
98,117,116,101,100,32,117,115,105,110,103,32,116,104,105,115,
32,108,105,99,101,110,115,101,44,32,97,110,100,32,109,97,
121,32,110,111,116,32,98,101,32,100,105,115,116,114,105,98,
117,116,101,100,32,117,110,100,101,114,32,97,110,121,32,111,
116,104,101,114,32,108,105,99,101,110,115,101,46,13,10,13,
10,84,69,82,77,73,78,65,84,73,79,78,13,10,84,104,
105,115,32,108,105,99,101,110,115,101,32,98,101,99,111,109,
101,115,32,110,117,108,108,32,97,110,100,32,118,111,105,100,
32,105,102,32,97,110,121,32,111,102,32,116,104,101,32,97,
98,111,118,101,32,99,111,110,100,105,116,105,111,110,115,32,
97,114,101,32,110,111,116,32,109,101,116,46,13,10,13,10,
68,73,83,67,76,65,73,77,69,82,13,10,84,72,69,32,
70,79,78,84,32,83,79,70,84,87,65,82,69,32,73,83,
32,80,82,79,86,73,68,69,68,32,34,65,83,32,73,83,
34,44,32,87,73,84,72,79,85,84,32,87,65,82,82,65,
78,84,89,32,79,70,32,65,78,89,32,75,73,78,68,44,
32,69,88,80,82,69,83,83,32,79,82,32,73,77,80,76,
73,69,68,44,32,73,78,67,76,85,68,73,78,71,32,66,
85,84,32,78,79,84,32,76,73,77,73,84,69,68,32,84,
79,32,65,78,89,32,87,65,82,82,65,78,84,73,69,83,
32,79,70,32,77,69,82,67,72,65,78,84,65,66,73,76,
73,84,89,44,32,70,73,84,78,69,83,83,32,70,79,82,
32,65,32,80,65,82,84,73,67,85,76,65,82,32,80,85,
82,80,79,83,69,32,65,78,68,32,78,79,78,73,78,70,
82,73,78,71,69,77,69,78,84,32,79,70,32,67,79,80,
89,82,73,71,72,84,44,32,80,65,84,69,78,84,44,32,
84,82,65,68,69,77,65,82,75,44,32,79,82,32,79,84,
72,69,82,32,82,73,71,72,84,46,32,73,78,32,78,79,
32,69,86,69,78,84,32,83,72,65,76,76,32,84,72,69,
32,67,79,80,89,82,73,71,72,84,32,72,79,76,68,69,
82,32,66,69,32,76,73,65,66,76,69,32,70,79,82,32,
65,78,89,32,67,76,65,73,77,44,32,68,65,77,65,71,
69,83,32,79,82,32,79,84,72,69,82,32,76,73,65,66,
73,76,73,84,89,44,32,73,78,67,76,85,68,73,78,71,
32,65,78,89,32,71,69,78,69,82,65,76,44,32,83,80,
69,67,73,65,76,44,32,73,78,68,73,82,69,67,84,44,
32,73,78,67,73,68,69,78,84,65,76,44,32,79,82,32,
67,79,78,83,69,81,85,69,78,84,73,65,76,32,68,65,
77,65,71,69,83,44,32,87,72,69,84,72,69,82,32,73,
78,32,65,78,32,65,67,84,73,79,78,32,79,70,32,67,
79,78,84,82,65,67,84,44,32,84,79,82,84,32,79,82,
32,79,84,72,69,82,87,73,83,69,44,32,65,82,73,83,
73,78,71,32,70,82,79,77,44,32,79,85,84,32,79,70,
32,84,72,69,32,85,83,69,32,79,82,32,73,78,65,66,
73,76,73,84,89,32,84,79,32,85,83,69,32,84,72,69,
32,70,79,78,84,32,83,79,70,84,87,65,82,69,32,79,
82,32,70,82,79,77,32,79,84,72,69,82,32,68,69,65,
76,73,78,71,83,32,73,78,32,84,72,69,32,70,79,78,
84,32,83,79,70,84,87,65,82,69,46,104,116,116,112,58,
47,47,115,99,114,105,112,116,115,46,115,105,108,46,111,114,
103,47,79,70,76,71,101,110,116,105,117,109,82,101,103,117,
108,97,114,71,101,110,116,105,117,109,0,67,0,111,0,112,
0,121,0,114,0,105,0,103,0,104,0,116,0,32,0,40,
0,99,0,41,0,32,0,83,0,73,0,76,0,32,0,73,
0,110,0,116,0,101,0,114,0,110,0,97,0,116,0,105,
0,111,0,110,0,97,0,108,0,32,0,50,0,48,0,48,
0,51,0,45,0,50,0,48,0,48,0,53,0,46,0,32,
0,65,0,108,0,108,0,32,0,114,0,105,0,103,0,104,
0,116,0,115,0,32,0,114,0,101,0,115,0,101,0,114,
0,118,0,101,0,100,0,46,0,71,0,101,0,110,0,116,
0,105,0,117,0,109,0,82,0,101,0,103,0,117,0,108,
0,97,0,114,0,83,0,73,0,76,0,58,0,32,0,71,
0,101,0,110,0,116,0,105,0,117,0,109,0,58,0,32,
0,50,0,48,0,48,0,53,0,71,0,101,0,110,0,116,
0,105,0,117,0,109,0,86,0,101,0,114,0,115,0,105,
0,111,0,110,0,32,0,49,0,46,0,48,0,50,0,59,
0,32,0,50,0,48,0,48,0,53,0,59,0,32,0,79,
0,70,0,76,0,32,0,114,0,101,0,108,0,101,0,97,
0,115,0,101,0,71,0,101,0,110,0,116,0,105,0,117,
0,109,0,71,0,101,0,110,0,116,0,105,0,117,0,109,
0,32,0,105,0,115,0,32,0,97,0,32,0,116,0,114,
0,97,0,100,0,101,0,109,0,97,0,114,0,107,0,32,
0,111,0,102,0,32,0,83,0,73,0,76,0,32,0,73,
0,110,0,116,0,101,0,114,0,110,0,97,0,116,0,105,
0,111,0,110,0,97,0,108,0,46,0,74,0,46,0,32,
0,86,0,105,0,99,0,116,0,111,0,114,0,32,0,71,
0,97,0,117,0,108,0,116,0,110,0,101,0,121,0,104,
0,116,0,116,0,112,0,58,0,47,0,47,0,119,0,119,
0,119,0,46,0,115,0,105,0,108,0,46,0,111,0,114,
0,103,0,47,0,104,0,116,0,116,0,112,0,58,0,47,
0,47,0,119,0,119,0,119,0,46,0,115,0,105,0,108,
0,46,0,111,0,114,0,103,0,47,0,126,0,103,0,97,
0,117,0,108,0,116,0,110,0,101,0,121,0,84,0,104,
0,105,0,115,0,32,0,70,0,111,0,110,0,116,0,32,
0,83,0,111,0,102,0,116,0,119,0,97,0,114,0,101,
0,32,0,105,0,115,0,32,0,67,0,111,0,112,0,121,
0,114,0,105,0,103,0,104,0,116,0,32,0,40,0,99,
0,41,0,32,0,50,0,48,0,48,0,51,0,45,0,50,
0,48,0,48,0,53,0,44,0,32,0,83,0,73,0,76,
0,32,0,73,0,110,0,116,0,101,0,114,0,110,0,97,
0,116,0,105,0,111,0,110,0,97,0,108,0,32,0,40,
0,104,0,116,0,116,0,112,0,58,0,47,0,47,0,115,
0,99,0,114,0,105,0,112,0,116,0,115,0,46,0,115,
0,105,0,108,0,46,0,111,0,114,0,103,0,47,0,41,
0,46,0,32,0,65,0,108,0,108,0,32,0,82,0,105,
0,103,0,104,0,116,0,115,0,32,0,82,0,101,0,115,
0,101,0,114,0,118,0,101,0,100,0,46,0,13,0,10,
0,13,0,10,0,34,0,71,0,101,0,110,0,116,0,105,
0,117,0,109,0,34,0,32,0,105,0,115,0,32,0,97,
0,32,0,82,0,101,0,115,0,101,0,114,0,118,0,101,
0,100,0,32,0,70,0,111,0,110,0,116,0,32,0,78,
0,97,0,109,0,101,0,32,0,102,0,111,0,114,0,32,
0,116,0,104,0,105,0,115,0,32,0,70,0,111,0,110,
0,116,0,32,0,83,0,111,0,102,0,116,0,119,0,97,
0,114,0,101,0,46,0,13,0,10,0,34,0,83,0,73,
0,76,0,34,0,32,0,105,0,115,0,32,0,97,0,32,
0,82,0,101,0,115,0,101,0,114,0,118,0,101,0,100,
0,32,0,70,0,111,0,110,0,116,0,32,0,78,0,97,
0,109,0,101,0,32,0,102,0,111,0,114,0,32,0,116,
0,104,0,105,0,115,0,32,0,70,0,111,0,110,0,116,
0,32,0,83,0,111,0,102,0,116,0,119,0,97,0,114,
0,101,0,46,0,13,0,10,0,13,0,10,0,84,0,104,
0,105,0,115,0,32,0,70,0,111,0,110,0,116,0,32,
0,83,0,111,0,102,0,116,0,119,0,97,0,114,0,101,
0,32,0,105,0,115,0,32,0,108,0,105,0,99,0,101,
0,110,0,115,0,101,0,100,0,32,0,117,0,110,0,100,
0,101,0,114,0,32,0,116,0,104,0,101,0,32,0,83,
0,73,0,76,0,32,0,79,0,112,0,101,0,110,0,32,
0,70,0,111,0,110,0,116,0,32,0,76,0,105,0,99,
0,101,0,110,0,115,0,101,0,44,0,32,0,86,0,101,
0,114,0,115,0,105,0,111,0,110,0,32,0,49,0,46,
0,48,0,46,0,32,0,78,0,111,0,32,0,109,0,111,
0,100,0,105,0,102,0,105,0,99,0,97,0,116,0,105,
0,111,0,110,0,32,0,111,0,102,0,32,0,116,0,104,
0,101,0,32,0,108,0,105,0,99,0,101,0,110,0,115,
0,101,0,32,0,105,0,115,0,32,0,112,0,101,0,114,
0,109,0,105,0,116,0,116,0,101,0,100,0,44,0,32,
0,111,0,110,0,108,0,121,0,32,0,118,0,101,0,114,
0,98,0,97,0,116,0,105,0,109,0,32,0,99,0,111,
0,112,0,121,0,32,0,105,0,115,0,32,0,97,0,108,
0,108,0,111,0,119,0,101,0,100,0,46,0,32,0,84,
0,104,0,105,0,115,0,32,0,108,0,105,0,99,0,101,
0,110,0,115,0,101,0,32,0,105,0,115,0,32,0,99,
0,111,0,112,0,105,0,101,0,100,0,32,0,98,0,101,
0,108,0,111,0,119,0,44,0,32,0,97,0,110,0,100,
0,32,0,105,0,115,0,32,0,97,0,108,0,115,0,111,
0,32,0,97,0,118,0,97,0,105,0,108,0,97,0,98,
0,108,0,101,0,32,0,119,0,105,0,116,0,104,0,32,
0,97,0,32,0,70,0,65,0,81,0,32,0,97,0,116,
0,58,0,32,0,104,0,116,0,116,0,112,0,58,0,47,
0,47,0,115,0,99,0,114,0,105,0,112,0,116,0,115,
0,46,0,115,0,105,0,108,0,46,0,111,0,114,0,103,
0,47,0,79,0,70,0,76,0,13,0,10,0,13,0,10,
0,13,0,10,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,13,0,10,0,83,
0,73,0,76,0,32,0,79,0,80,0,69,0,78,0,32,
0,70,0,79,0,78,0,84,0,32,0,76,0,73,0,67,
0,69,0,78,0,83,0,69,0,32,0,86,0,101,0,114,
0,115,0,105,0,111,0,110,0,32,0,49,0,46,0,48,
0,32,0,45,0,32,0,50,0,50,0,32,0,78,0,111,
0,118,0,101,0,109,0,98,0,101,0,114,0,32,0,50,
0,48,0,48,0,53,0,13,0,10,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,45,0,45,0,45,0,45,0,45,0,45,0,45,0,45,
0,13,0,10,0,13,0,10,0,80,0,82,0,69,0,65,
0,77,0,66,0,76,0,69,0,13,0,10,0,84,0,104,
0,101,0,32,0,103,0,111,0,97,0,108,0,115,0,32,
0,111,0,102,0,32,0,116,0,104,0,101,0,32,0,79,
0,112,0,101,0,110,0,32,0,70,0,111,0,110,0,116,
0,32,0,76,0,105,0,99,0,101,0,110,0,115,0,101,
0,32,0,40,0,79,0,70,0,76,0,41,0,32,0,97,
0,114,0,101,0,32,0,116,0,111,0,32,0,115,0,116,
0,105,0,109,0,117,0,108,0,97,0,116,0,101,0,32,
0,119,0,111,0,114,0,108,0,100,0,119,0,105,0,100,
0,101,0,32,0,100,0,101,0,118,0,101,0,108,0,111,
0,112,0,109,0,101,0,110,0,116,0,32,0,111,0,102,
0,32,0,99,0,111,0,111,0,112,0,101,0,114,0,97,
0,116,0,105,0,118,0,101,0,32,0,102,0,111,0,110,
0,116,0,32,0,112,0,114,0,111,0,106,0,101,0,99,
0,116,0,115,0,44,0,32,0,116,0,111,0,32,0,115,
0,117,0,112,0,112,0,111,0,114,0,116,0,32,0,116,
0,104,0,101,0,32,0,102,0,111,0,110,0,116,0,32,
0,99,0,114,0,101,0,97,0,116,0,105,0,111,0,110,
0,32,0,101,0,102,0,102,0,111,0,114,0,116,0,115,
0,32,0,111,0,102,0,32,0,97,0,99,0,97,0,100,
0,101,0,109,0,105,0,99,0,32,0,97,0,110,0,100,
0,32,0,108,0,105,0,110,0,103,0,117,0,105,0,115,
0,116,0,105,0,99,0,32,0,99,0,111,0,109,0,109,
0,117,0,110,0,105,0,116,0,105,0,101,0,115,0,44,
0,32,0,97,0,110,0,100,0,32,0,116,0,111,0,32,
0,112,0,114,0,111,0,118,0,105,0,100,0,101,0,32,
0,97,0,110,0,32,0,111,0,112,0,101,0,110,0,32,
0,102,0,114,0,97,0,109,0,101,0,119,0,111,0,114,
0,107,0,32,0,105,0,110,0,32,0,119,0,104,0,105,
0,99,0,104,0,32,0,102,0,111,0,110,0,116,0,115,
0,32,0,109,0,97,0,121,0,32,0,98,0,101,0,32,
0,115,0,104,0,97,0,114,0,101,0,100,0,32,0,97,
0,110,0,100,0,32,0,105,0,109,0,112,0,114,0,111,
0,118,0,101,0,100,0,32,0,105,0,110,0,32,0,112,
0,97,0,114,0,116,0,110,0,101,0,114,0,115,0,104,
0,105,0,112,0,32,0,119,0,105,0,116,0,104,0,32,
0,111,0,116,0,104,0,101,0,114,0,115,0,46,0,13,
0,10,0,13,0,10,0,84,0,104,0,101,0,32,0,79,
0,70,0,76,0,32,0,97,0,108,0,108,0,111,0,119,
0,115,0,32,0,116,0,104,0,101,0,32,0,108,0,105,
0,99,0,101,0,110,0,115,0,101,0,100,0,32,0,102,
0,111,0,110,0,116,0,115,0,32,0,116,0,111,0,32,
0,98,0,101,0,32,0,117,0,115,0,101,0,100,0,44,
0,32,0,115,0,116,0,117,0,100,0,105,0,101,0,100,
0,44,0,32,0,109,0,111,0,100,0,105,0,102,0,105,
0,101,0,100,0,32,0,97,0,110,0,100,0,32,0,114,
0,101,0,100,0,105,0,115,0,116,0,114,0,105,0,98,
0,117,0,116,0,101,0,100,0,32,0,102,0,114,0,101,
0,101,0,108,0,121,0,32,0,97,0,115,0,32,0,108,
0,111,0,110,0,103,0,32,0,97,0,115,0,32,0,116,
0,104,0,101,0,121,0,32,0,97,0,114,0,101,0,32,
0,110,0,111,0,116,0,32,0,115,0,111,0,108,0,100,
0,32,0,98,0,121,0,32,0,116,0,104,0,101,0,109,
0,115,0,101,0,108,0,118,0,101,0,115,0,46,0,32,
0,84,0,104,0,101,0,32,0,102,0,111,0,110,0,116,
0,115,0,44,0,32,0,105,0,110,0,99,0,108,0,117,
0,100,0,105,0,110,0,103,0,32,0,97,0,110,0,121,
0,32,0,100,0,101,0,114,0,105,0,118,0,97,0,116,
0,105,0,118,0,101,0,32,0,119,0,111,0,114,0,107,
0,115,0,44,0,32,0,99,0,97,0,110,0,32,0,98,
0,101,0,32,0,98,0,117,0,110,0,100,0,108,0,101,
0,100,0,44,0,32,0,101,0,109,0,98,0,101,0,100,
0,100,0,101,0,100,0,44,0,32,0,114,0,101,0,100,
0,105,0,115,0,116,0,114,0,105,0,98,0,117,0,116,
0,101,0,100,0,32,0,97,0,110,0,100,0,32,0,115,
0,111,0,108,0,100,0,32,0,119,0,105,0,116,0,104,
0,32,0,97,0,110,0,121,0,32,0,115,0,111,0,102,
0,116,0,119,0,97,0,114,0,101,0,32,0,112,0,114,
0,111,0,118,0,105,0,100,0,101,0,100,0,32,0,116,
0,104,0,97,0,116,0,32,0,116,0,104,0,101,0,32,
0,102,0,111,0,110,0,116,0,32,0,110,0,97,0,109,
0,101,0,115,0,32,0,111,0,102,0,32,0,100,0,101,
0,114,0,105,0,118,0,97,0,116,0,105,0,118,0,101,
0,32,0,119,0,111,0,114,0,107,0,115,0,32,0,97,
0,114,0,101,0,32,0,99,0,104,0,97,0,110,0,103,
0,101,0,100,0,46,0,32,0,84,0,104,0,101,0,32,
0,102,0,111,0,110,0,116,0,115,0,32,0,97,0,110,
0,100,0,32,0,100,0,101,0,114,0,105,0,118,0,97,
0,116,0,105,0,118,0,101,0,115,0,44,0,32,0,104,
0,111,0,119,0,101,0,118,0,101,0,114,0,44,0,32,
0,99,0,97,0,110,0,110,0,111,0,116,0,32,0,98,
0,101,0,32,0,114,0,101,0,108,0,101,0,97,0,115,
0,101,0,100,0,32,0,117,0,110,0,100,0,101,0,114,
0,32,0,97,0,110,0,121,0,32,0,111,0,116,0,104,
0,101,0,114,0,32,0,116,0,121,0,112,0,101,0,32,
0,111,0,102,0,32,0,108,0,105,0,99,0,101,0,110,
0,115,0,101,0,46,0,13,0,10,0,13,0,10,0,68,
0,69,0,70,0,73,0,78,0,73,0,84,0,73,0,79,
0,78,0,83,0,13,0,10,0,34,0,70,0,111,0,110,
0,116,0,32,0,83,0,111,0,102,0,116,0,119,0,97,
0,114,0,101,0,34,0,32,0,114,0,101,0,102,0,101,
0,114,0,115,0,32,0,116,0,111,0,32,0,97,0,110,
0,121,0,32,0,97,0,110,0,100,0,32,0,97,0,108,
0,108,0,32,0,111,0,102,0,32,0,116,0,104,0,101,
0,32,0,102,0,111,0,108,0,108,0,111,0,119,0,105,
0,110,0,103,0,58,0,13,0,10,0,9,0,45,0,32,
0,102,0,111,0,110,0,116,0,32,0,102,0,105,0,108,
0,101,0,115,0,13,0,10,0,9,0,45,0,32,0,100,
0,97,0,116,0,97,0,32,0,102,0,105,0,108,0,101,
0,115,0,13,0,10,0,9,0,45,0,32,0,115,0,111,
0,117,0,114,0,99,0,101,0,32,0,99,0,111,0,100,
0,101,0,13,0,10,0,9,0,45,0,32,0,98,0,117,
0,105,0,108,0,100,0,32,0,115,0,99,0,114,0,105,
0,112,0,116,0,115,0,13,0,10,0,9,0,45,0,32,
0,100,0,111,0,99,0,117,0,109,0,101,0,110,0,116,
0,97,0,116,0,105,0,111,0,110,0,13,0,10,0,13,
0,10,0,34,0,82,0,101,0,115,0,101,0,114,0,118,
0,101,0,100,0,32,0,70,0,111,0,110,0,116,0,32,
0,78,0,97,0,109,0,101,0,34,0,32,0,114,0,101,
0,102,0,101,0,114,0,115,0,32,0,116,0,111,0,32,
0,116,0,104,0,101,0,32,0,70,0,111,0,110,0,116,
0,32,0,83,0,111,0,102,0,116,0,119,0,97,0,114,
0,101,0,32,0,110,0,97,0,109,0,101,0,32,0,97,
0,115,0,32,0,115,0,101,0,101,0,110,0,32,0,98,
0,121,0,32,0,117,0,115,0,101,0,114,0,115,0,32,
0,97,0,110,0,100,0,32,0,97,0,110,0,121,0,32,
0,111,0,116,0,104,0,101,0,114,0,32,0,110,0,97,
0,109,0,101,0,115,0,32,0,97,0,115,0,32,0,115,
0,112,0,101,0,99,0,105,0,102,0,105,0,101,0,100,
0,32,0,97,0,102,0,116,0,101,0,114,0,32,0,116,
0,104,0,101,0,32,0,99,0,111,0,112,0,121,0,114,
0,105,0,103,0,104,0,116,0,32,0,115,0,116,0,97,
0,116,0,101,0,109,0,101,0,110,0,116,0,46,0,13,
0,10,0,13,0,10,0,34,0,83,0,116,0,97,0,110,
0,100,0,97,0,114,0,100,0,32,0,86,0,101,0,114,
0,115,0,105,0,111,0,110,0,34,0,32,0,114,0,101,
0,102,0,101,0,114,0,115,0,32,0,116,0,111,0,32,
0,116,0,104,0,101,0,32,0,99,0,111,0,108,0,108,
0,101,0,99,0,116,0,105,0,111,0,110,0,32,0,111,
0,102,0,32,0,70,0,111,0,110,0,116,0,32,0,83,
0,111,0,102,0,116,0,119,0,97,0,114,0,101,0,32,
0,99,0,111,0,109,0,112,0,111,0,110,0,101,0,110,
0,116,0,115,0,32,0,97,0,115,0,32,0,100,0,105,
0,115,0,116,0,114,0,105,0,98,0,117,0,116,0,101,
0,100,0,32,0,98,0,121,0,32,0,116,0,104,0,101,
0,32,0,67,0,111,0,112,0,121,0,114,0,105,0,103,
0,104,0,116,0,32,0,72,0,111,0,108,0,100,0,101,
0,114,0,46,0,13,0,10,0,13,0,10,0,34,0,77,
0,111,0,100,0,105,0,102,0,105,0,101,0,100,0,32,
0,86,0,101,0,114,0,115,0,105,0,111,0,110,0,34,
0,32,0,114,0,101,0,102,0,101,0,114,0,115,0,32,
0,116,0,111,0,32,0,97,0,110,0,121,0,32,0,100,
0,101,0,114,0,105,0,118,0,97,0,116,0,105,0,118,
0,101,0,32,0,102,0,111,0,110,0,116,0,32,0,115,
0,111,0,102,0,116,0,119,0,97,0,114,0,101,0,32,
0,109,0,97,0,100,0,101,0,32,0,98,0,121,0,32,
0,97,0,100,0,100,0,105,0,110,0,103,0,32,0,116,
0,111,0,44,0,32,0,100,0,101,0,108,0,101,0,116,
0,105,0,110,0,103,0,44,0,32,0,111,0,114,0,32,
0,115,0,117,0,98,0,115,0,116,0,105,0,116,0,117,
0,116,0,105,0,110,0,103,0,32,0,45,0,45,0,32,
0,105,0,110,0,32,0,112,0,97,0,114,0,116,0,32,
0,111,0,114,0,32,0,105,0,110,0,32,0,119,0,104,
0,111,0,108,0,101,0,32,0,45,0,45,0,32,0,97,
0,110,0,121,0,32,0,111,0,102,0,32,0,116,0,104,
0,101,0,32,0,99,0,111,0,109,0,112,0,111,0,110,
0,101,0,110,0,116,0,115,0,32,0,111,0,102,0,32,
0,116,0,104,0,101,0,32,0,83,0,116,0,97,0,110,
0,100,0,97,0,114,0,100,0,32,0,86,0,101,0,114,
0,115,0,105,0,111,0,110,0,44,0,32,0,98,0,121,
0,32,0,99,0,104,0,97,0,110,0,103,0,105,0,110,
0,103,0,32,0,102,0,111,0,114,0,109,0,97,0,116,
0,115,0,32,0,111,0,114,0,32,0,98,0,121,0,32,
0,112,0,111,0,114,0,116,0,105,0,110,0,103,0,32,
0,116,0,104,0,101,0,32,0,70,0,111,0,110,0,116,
0,32,0,83,0,111,0,102,0,116,0,119,0,97,0,114,
0,101,0,32,0,116,0,111,0,32,0,97,0,32,0,110,
0,101,0,119,0,32,0,101,0,110,0,118,0,105,0,114,
0,111,0,110,0,109,0,101,0,110,0,116,0,46,0,13,
0,10,0,13,0,10,0,34,0,65,0,117,0,116,0,104,
0,111,0,114,0,34,0,32,0,114,0,101,0,102,0,101,
0,114,0,115,0,32,0,116,0,111,0,32,0,97,0,110,
0,121,0,32,0,100,0,101,0,115,0,105,0,103,0,110,
0,101,0,114,0,44,0,32,0,101,0,110,0,103,0,105,
0,110,0,101,0,101,0,114,0,44,0,32,0,112,0,114,
0,111,0,103,0,114,0,97,0,109,0,109,0,101,0,114,
0,44,0,32,0,116,0,101,0,99,0,104,0,110,0,105,
0,99,0,97,0,108,0,32,0,119,0,114,0,105,0,116,
0,101,0,114,0,32,0,111,0,114,0,32,0,111,0,116,
0,104,0,101,0,114,0,32,0,112,0,101,0,114,0,115,
0,111,0,110,0,32,0,119,0,104,0,111,0,32,0,99,
0,111,0,110,0,116,0,114,0,105,0,98,0,117,0,116,
0,101,0,100,0,32,0,116,0,111,0,32,0,116,0,104,
0,101,0,32,0,70,0,111,0,110,0,116,0,32,0,83,
0,111,0,102,0,116,0,119,0,97,0,114,0,101,0,46,
0,13,0,10,0,13,0,10,0,80,0,69,0,82,0,77,
0,73,0,83,0,83,0,73,0,79,0,78,0,32,0,38,
0,32,0,67,0,79,0,78,0,68,0,73,0,84,0,73,
0,79,0,78,0,83,0,13,0,10,0,80,0,101,0,114,
0,109,0,105,0,115,0,115,0,105,0,111,0,110,0,32,
0,105,0,115,0,32,0,104,0,101,0,114,0,101,0,98,
0,121,0,32,0,103,0,114,0,97,0,110,0,116,0,101,
0,100,0,44,0,32,0,102,0,114,0,101,0,101,0,32,
0,111,0,102,0,32,0,99,0,104,0,97,0,114,0,103,
0,101,0,44,0,32,0,116,0,111,0,32,0,97,0,110,
0,121,0,32,0,112,0,101,0,114,0,115,0,111,0,110,
0,32,0,111,0,98,0,116,0,97,0,105,0,110,0,105,
0,110,0,103,0,32,0,97,0,32,0,99,0,111,0,112,
0,121,0,32,0,111,0,102,0,32,0,116,0,104,0,101,
0,32,0,70,0,111,0,110,0,116,0,32,0,83,0,111,
0,102,0,116,0,119,0,97,0,114,0,101,0,44,0,32,
0,116,0,111,0,32,0,117,0,115,0,101,0,44,0,32,
0,115,0,116,0,117,0,100,0,121,0,44,0,32,0,99,
0,111,0,112,0,121,0,44,0,32,0,109,0,101,0,114,
0,103,0,101,0,44,0,32,0,101,0,109,0,98,0,101,
0,100,0,44,0,32,0,109,0,111,0,100,0,105,0,102,
0,121,0,44,0,32,0,114,0,101,0,100,0,105,0,115,
0,116,0,114,0,105,0,98,0,117,0,116,0,101,0,44,
0,32,0,97,0,110,0,100,0,32,0,115,0,101,0,108,
0,108,0,32,0,109,0,111,0,100,0,105,0,102,0,105,
0,101,0,100,0,32,0,97,0,110,0,100,0,32,0,117,
0,110,0,109,0,111,0,100,0,105,0,102,0,105,0,101,
0,100,0,32,0,99,0,111,0,112,0,105,0,101,0,115,
0,32,0,111,0,102,0,32,0,116,0,104,0,101,0,32,
0,70,0,111,0,110,0,116,0,83,0,111,0,102,0,116,
0,119,0,97,0,114,0,101,0,44,0,32,0,115,0,117,
0,98,0,106,0,101,0,99,0,116,0,32,0,116,0,111,
0,32,0,116,0,104,0,101,0,32,0,102,0,111,0,108,
0,108,0,111,0,119,0,105,0,110,0,103,0,32,0,99,
0,111,0,110,0,100,0,105,0,116,0,105,0,111,0,110,
0,115,0,58,0,13,0,10,0,13,0,10,0,49,0,41,
0,32,0,78,0,101,0,105,0,116,0,104,0,101,0,114,
0,32,0,116,0,104,0,101,0,32,0,70,0,111,0,110,
0,116,0,32,0,83,0,111,0,102,0,116,0,119,0,97,
0,114,0,101,0,32,0,110,0,111,0,114,0,32,0,97,
0,110,0,121,0,32,0,111,0,102,0,32,0,105,0,116,
0,115,0,32,0,105,0,110,0,100,0,105,0,118,0,105,
0,100,0,117,0,97,0,108,0,32,0,99,0,111,0,109,
0,112,0,111,0,110,0,101,0,110,0,116,0,115,0,44,
0,32,0,105,0,110,0,32,0,83,0,116,0,97,0,110,
0,100,0,97,0,114,0,100,0,32,0,111,0,114,0,32,
0,77,0,111,0,100,0,105,0,102,0,105,0,101,0,100,
0,32,0,86,0,101,0,114,0,115,0,105,0,111,0,110,
0,115,0,44,0,32,0,109,0,97,0,121,0,32,0,98,
0,101,0,32,0,115,0,111,0,108,0,100,0,32,0,98,
0,121,0,32,0,105,0,116,0,115,0,101,0,108,0,102,
0,46,0,13,0,10,0,13,0,10,0,50,0,41,0,32,
0,83,0,116,0,97,0,110,0,100,0,97,0,114,0,100,
0,32,0,111,0,114,0,32,0,77,0,111,0,100,0,105,
0,102,0,105,0,101,0,100,0,32,0,86,0,101,0,114,
0,115,0,105,0,111,0,110,0,115,0,32,0,111,0,102,
0,32,0,116,0,104,0,101,0,32,0,70,0,111,0,110,
0,116,0,32,0,83,0,111,0,102,0,116,0,119,0,97,
0,114,0,101,0,32,0,109,0,97,0,121,0,32,0,98,
0,101,0,32,0,98,0,117,0,110,0,100,0,108,0,101,
0,100,0,44,0,32,0,114,0,101,0,100,0,105,0,115,
0,116,0,114,0,105,0,98,0,117,0,116,0,101,0,100,
0,32,0,97,0,110,0,100,0,32,0,115,0,111,0,108,
0,100,0,32,0,119,0,105,0,116,0,104,0,32,0,97,
0,110,0,121,0,32,0,115,0,111,0,102,0,116,0,119,
0,97,0,114,0,101,0,44,0,32,0,112,0,114,0,111,
0,118,0,105,0,100,0,101,0,100,0,32,0,116,0,104,
0,97,0,116,0,32,0,101,0,97,0,99,0,104,0,32,
0,99,0,111,0,112,0,121,0,32,0,99,0,111,0,110,
0,116,0,97,0,105,0,110,0,115,0,32,0,116,0,104,
0,101,0,32,0,97,0,98,0,111,0,118,0,101,0,32,
0,99,0,111,0,112,0,121,0,114,0,105,0,103,0,104,
0,116,0,32,0,110,0,111,0,116,0,105,0,99,0,101,
0,32,0,97,0,110,0,100,0,32,0,116,0,104,0,105,
0,115,0,32,0,108,0,105,0,99,0,101,0,110,0,115,
0,101,0,46,0,32,0,84,0,104,0,101,0,115,0,101,
0,32,0,99,0,97,0,110,0,32,0,98,0,101,0,32,
0,105,0,110,0,99,0,108,0,117,0,100,0,101,0,100,
0,32,0,101,0,105,0,116,0,104,0,101,0,114,0,32,
0,97,0,115,0,32,0,115,0,116,0,97,0,110,0,100,
0,45,0,97,0,108,0,111,0,110,0,101,0,32,0,116,
0,101,0,120,0,116,0,32,0,102,0,105,0,108,0,101,
0,115,0,44,0,32,0,104,0,117,0,109,0,97,0,110,
0,45,0,114,0,101,0,97,0,100,0,97,0,98,0,108,
0,101,0,32,0,104,0,101,0,97,0,100,0,101,0,114,
0,115,0,32,0,111,0,114,0,32,0,105,0,110,0,32,
0,116,0,104,0,101,0,32,0,97,0,112,0,112,0,114,
0,111,0,112,0,114,0,105,0,97,0,116,0,101,0,32,
0,109,0,97,0,99,0,104,0,105,0,110,0,101,0,45,
0,114,0,101,0,97,0,100,0,97,0,98,0,108,0,101,
0,32,0,109,0,101,0,116,0,97,0,100,0,97,0,116,
0,97,0,32,0,102,0,105,0,101,0,108,0,100,0,115,
0,32,0,119,0,105,0,116,0,104,0,105,0,110,0,32,
0,116,0,101,0,120,0,116,0,32,0,111,0,114,0,32,
0,98,0,105,0,110,0,97,0,114,0,121,0,32,0,102,
0,105,0,108,0,101,0,115,0,32,0,97,0,115,0,32,
0,108,0,111,0,110,0,103,0,32,0,97,0,115,0,32,
0,116,0,104,0,111,0,115,0,101,0,32,0,102,0,105,
0,101,0,108,0,100,0,115,0,32,0,99,0,97,0,110,
0,32,0,98,0,101,0,32,0,101,0,97,0,115,0,105,
0,108,0,121,0,32,0,118,0,105,0,101,0,119,0,101,
0,100,0,32,0,98,0,121,0,32,0,116,0,104,0,101,
0,32,0,117,0,115,0,101,0,114,0,46,0,13,0,10,
0,13,0,10,0,51,0,41,0,32,0,78,0,111,0,32,
0,77,0,111,0,100,0,105,0,102,0,105,0,101,0,100,
0,32,0,86,0,101,0,114,0,115,0,105,0,111,0,110,
0,32,0,111,0,102,0,32,0,116,0,104,0,101,0,32,
0,70,0,111,0,110,0,116,0,32,0,83,0,111,0,102,
0,116,0,119,0,97,0,114,0,101,0,32,0,109,0,97,
0,121,0,32,0,117,0,115,0,101,0,32,0,116,0,104,
0,101,0,32,0,82,0,101,0,115,0,101,0,114,0,118,
0,101,0,100,0,32,0,70,0,111,0,110,0,116,0,32,
0,78,0,97,0,109,0,101,0,40,0,115,0,41,0,44,
0,32,0,105,0,110,0,32,0,112,0,97,0,114,0,116,
0,32,0,111,0,114,0,32,0,105,0,110,0,32,0,119,
0,104,0,111,0,108,0,101,0,44,0,32,0,117,0,110,
0,108,0,101,0,115,0,115,0,32,0,101,0,120,0,112,
0,108,0,105,0,99,0,105,0,116,0,32,0,119,0,114,
0,105,0,116,0,116,0,101,0,110,0,32,0,112,0,101,
0,114,0,109,0,105,0,115,0,115,0,105,0,111,0,110,
0,32,0,105,0,115,0,32,0,103,0,114,0,97,0,110,
0,116,0,101,0,100,0,32,0,98,0,121,0,32,0,116,
0,104,0,101,0,32,0,67,0,111,0,112,0,121,0,114,
0,105,0,103,0,104,0,116,0,32,0,72,0,111,0,108,
0,100,0,101,0,114,0,46,0,32,0,84,0,104,0,105,
0,115,0,32,0,114,0,101,0,115,0,116,0,114,0,105,
0,99,0,116,0,105,0,111,0,110,0,32,0,97,0,112,
0,112,0,108,0,105,0,101,0,115,0,32,0,116,0,111,
0,32,0,97,0,108,0,108,0,32,0,114,0,101,0,102,
0,101,0,114,0,101,0,110,0,99,0,101,0,115,0,32,
0,115,0,116,0,111,0,114,0,101,0,100,0,32,0,105,
0,110,0,32,0,116,0,104,0,101,0,32,0,70,0,111,
0,110,0,116,0,32,0,83,0,111,0,102,0,116,0,119,
0,97,0,114,0,101,0,44,0,32,0,115,0,117,0,99,
0,104,0,32,0,97,0,115,0,32,0,116,0,104,0,101,
0,32,0,102,0,111,0,110,0,116,0,32,0,109,0,101,
0,110,0,117,0,32,0,110,0,97,0,109,0,101,0,32,
0,97,0,110,0,100,0,32,0,111,0,116,0,104,0,101,
0,114,0,32,0,102,0,111,0,110,0,116,0,32,0,100,
0,101,0,115,0,99,0,114,0,105,0,112,0,116,0,105,
0,111,0,110,0,32,0,102,0,105,0,101,0,108,0,100,
0,115,0,44,0,32,0,119,0,104,0,105,0,99,0,104,
0,32,0,97,0,114,0,101,0,32,0,117,0,115,0,101,
0,100,0,32,0,116,0,111,0,32,0,100,0,105,0,102,
0,102,0,101,0,114,0,101,0,110,0,116,0,105,0,97,
0,116,0,101,0,32,0,116,0,104,0,101,0,32,0,102,
0,111,0,110,0,116,0,32,0,102,0,114,0,111,0,109,
0,32,0,111,0,116,0,104,0,101,0,114,0,115,0,46,
0,13,0,10,0,13,0,10,0,52,0,41,0,32,0,84,
0,104,0,101,0,32,0,110,0,97,0,109,0,101,0,40,
0,115,0,41,0,32,0,111,0,102,0,32,0,116,0,104,
0,101,0,32,0,67,0,111,0,112,0,121,0,114,0,105,
0,103,0,104,0,116,0,32,0,72,0,111,0,108,0,100,
0,101,0,114,0,32,0,111,0,114,0,32,0,116,0,104,
0,101,0,32,0,65,0,117,0,116,0,104,0,111,0,114,
0,40,0,115,0,41,0,32,0,111,0,102,0,32,0,116,
0,104,0,101,0,32,0,70,0,111,0,110,0,116,0,32,
0,83,0,111,0,102,0,116,0,119,0,97,0,114,0,101,
0,32,0,115,0,104,0,97,0,108,0,108,0,32,0,110,
0,111,0,116,0,32,0,98,0,101,0,32,0,117,0,115,
0,101,0,100,0,32,0,116,0,111,0,32,0,112,0,114,
0,111,0,109,0,111,0,116,0,101,0,44,0,32,0,101,
0,110,0,100,0,111,0,114,0,115,0,101,0,32,0,111,
0,114,0,32,0,97,0,100,0,118,0,101,0,114,0,116,
0,105,0,115,0,101,0,32,0,97,0,110,0,121,0,32,
0,77,0,111,0,100,0,105,0,102,0,105,0,101,0,100,
0,32,0,86,0,101,0,114,0,115,0,105,0,111,0,110,
0,44,0,32,0,101,0,120,0,99,0,101,0,112,0,116,
0,32,0,116,0,111,0,32,0,97,0,99,0,107,0,110,
0,111,0,119,0,108,0,101,0,100,0,103,0,101,0,32,
0,116,0,104,0,101,0,32,0,99,0,111,0,110,0,116,
0,114,0,105,0,98,0,117,0,116,0,105,0,111,0,110,
0,40,0,115,0,41,0,32,0,111,0,102,0,32,0,116,
0,104,0,101,0,32,0,67,0,111,0,112,0,121,0,114,
0,105,0,103,0,104,0,116,0,32,0,72,0,111,0,108,
0,100,0,101,0,114,0,32,0,97,0,110,0,100,0,32,
0,116,0,104,0,101,0,32,0,65,0,117,0,116,0,104,
0,111,0,114,0,40,0,115,0,41,0,32,0,111,0,114,
0,32,0,119,0,105,0,116,0,104,0,32,0,116,0,104,
0,101,0,105,0,114,0,32,0,101,0,120,0,112,0,108,
0,105,0,99,0,105,0,116,0,32,0,119,0,114,0,105,
0,116,0,116,0,101,0,110,0,32,0,112,0,101,0,114,
0,109,0,105,0,115,0,115,0,105,0,111,0,110,0,46,
0,13,0,10,0,13,0,10,0,53,0,41,0,32,0,84,
0,104,0,101,0,32,0,70,0,111,0,110,0,116,0,32,
0,83,0,111,0,102,0,116,0,119,0,97,0,114,0,101,
0,44,0,32,0,109,0,111,0,100,0,105,0,102,0,105,
0,101,0,100,0,32,0,111,0,114,0,32,0,117,0,110,
0,109,0,111,0,100,0,105,0,102,0,105,0,101,0,100,
0,44,0,32,0,105,0,110,0,32,0,112,0,97,0,114,
0,116,0,32,0,111,0,114,0,32,0,105,0,110,0,32,
0,119,0,104,0,111,0,108,0,101,0,44,0,32,0,109,
0,117,0,115,0,116,0,32,0,98,0,101,0,32,0,100,
0,105,0,115,0,116,0,114,0,105,0,98,0,117,0,116,
0,101,0,100,0,32,0,117,0,115,0,105,0,110,0,103,
0,32,0,116,0,104,0,105,0,115,0,32,0,108,0,105,
0,99,0,101,0,110,0,115,0,101,0,44,0,32,0,97,
0,110,0,100,0,32,0,109,0,97,0,121,0,32,0,110,
0,111,0,116,0,32,0,98,0,101,0,32,0,100,0,105,
0,115,0,116,0,114,0,105,0,98,0,117,0,116,0,101,
0,100,0,32,0,117,0,110,0,100,0,101,0,114,0,32,
0,97,0,110,0,121,0,32,0,111,0,116,0,104,0,101,
0,114,0,32,0,108,0,105,0,99,0,101,0,110,0,115,
0,101,0,46,0,13,0,10,0,13,0,10,0,84,0,69,
0,82,0,77,0,73,0,78,0,65,0,84,0,73,0,79,
0,78,0,13,0,10,0,84,0,104,0,105,0,115,0,32,
0,108,0,105,0,99,0,101,0,110,0,115,0,101,0,32,
0,98,0,101,0,99,0,111,0,109,0,101,0,115,0,32,
0,110,0,117,0,108,0,108,0,32,0,97,0,110,0,100,
0,32,0,118,0,111,0,105,0,100,0,32,0,105,0,102,
0,32,0,97,0,110,0,121,0,32,0,111,0,102,0,32,
0,116,0,104,0,101,0,32,0,97,0,98,0,111,0,118,
0,101,0,32,0,99,0,111,0,110,0,100,0,105,0,116,
0,105,0,111,0,110,0,115,0,32,0,97,0,114,0,101,
0,32,0,110,0,111,0,116,0,32,0,109,0,101,0,116,
0,46,0,13,0,10,0,13,0,10,0,68,0,73,0,83,
0,67,0,76,0,65,0,73,0,77,0,69,0,82,0,13,
0,10,0,84,0,72,0,69,0,32,0,70,0,79,0,78,
0,84,0,32,0,83,0,79,0,70,0,84,0,87,0,65,
0,82,0,69,0,32,0,73,0,83,0,32,0,80,0,82,
0,79,0,86,0,73,0,68,0,69,0,68,0,32,0,34,
0,65,0,83,0,32,0,73,0,83,0,34,0,44,0,32,
0,87,0,73,0,84,0,72,0,79,0,85,0,84,0,32,
0,87,0,65,0,82,0,82,0,65,0,78,0,84,0,89,
0,32,0,79,0,70,0,32,0,65,0,78,0,89,0,32,
0,75,0,73,0,78,0,68,0,44,0,32,0,69,0,88,
0,80,0,82,0,69,0,83,0,83,0,32,0,79,0,82,
0,32,0,73,0,77,0,80,0,76,0,73,0,69,0,68,
0,44,0,32,0,73,0,78,0,67,0,76,0,85,0,68,
0,73,0,78,0,71,0,32,0,66,0,85,0,84,0,32,
0,78,0,79,0,84,0,32,0,76,0,73,0,77,0,73,
0,84,0,69,0,68,0,32,0,84,0,79,0,32,0,65,
0,78,0,89,0,32,0,87,0,65,0,82,0,82,0,65,
0,78,0,84,0,73,0,69,0,83,0,32,0,79,0,70,
0,32,0,77,0,69,0,82,0,67,0,72,0,65,0,78,
0,84,0,65,0,66,0,73,0,76,0,73,0,84,0,89,
0,44,0,32,0,70,0,73,0,84,0,78,0,69,0,83,
0,83,0,32,0,70,0,79,0,82,0,32,0,65,0,32,
0,80,0,65,0,82,0,84,0,73,0,67,0,85,0,76,
0,65,0,82,0,32,0,80,0,85,0,82,0,80,0,79,
0,83,0,69,0,32,0,65,0,78,0,68,0,32,0,78,
0,79,0,78,0,73,0,78,0,70,0,82,0,73,0,78,
0,71,0,69,0,77,0,69,0,78,0,84,0,32,0,79,
0,70,0,32,0,67,0,79,0,80,0,89,0,82,0,73,
0,71,0,72,0,84,0,44,0,32,0,80,0,65,0,84,
0,69,0,78,0,84,0,44,0,32,0,84,0,82,0,65,
0,68,0,69,0,77,0,65,0,82,0,75,0,44,0,32,
0,79,0,82,0,32,0,79,0,84,0,72,0,69,0,82,
0,32,0,82,0,73,0,71,0,72,0,84,0,46,0,32,
0,73,0,78,0,32,0,78,0,79,0,32,0,69,0,86,
0,69,0,78,0,84,0,32,0,83,0,72,0,65,0,76,
0,76,0,32,0,84,0,72,0,69,0,32,0,67,0,79,
0,80,0,89,0,82,0,73,0,71,0,72,0,84,0,32,
0,72,0,79,0,76,0,68,0,69,0,82,0,32,0,66,
0,69,0,32,0,76,0,73,0,65,0,66,0,76,0,69,
0,32,0,70,0,79,0,82,0,32,0,65,0,78,0,89,
0,32,0,67,0,76,0,65,0,73,0,77,0,44,0,32,
0,68,0,65,0,77,0,65,0,71,0,69,0,83,0,32,
0,79,0,82,0,32,0,79,0,84,0,72,0,69,0,82,
0,32,0,76,0,73,0,65,0,66,0,73,0,76,0,73,
0,84,0,89,0,44,0,32,0,73,0,78,0,67,0,76,
0,85,0,68,0,73,0,78,0,71,0,32,0,65,0,78,
0,89,0,32,0,71,0,69,0,78,0,69,0,82,0,65,
0,76,0,44,0,32,0,83,0,80,0,69,0,67,0,73,
0,65,0,76,0,44,0,32,0,73,0,78,0,68,0,73,
0,82,0,69,0,67,0,84,0,44,0,32,0,73,0,78,
0,67,0,73,0,68,0,69,0,78,0,84,0,65,0,76,
0,44,0,32,0,79,0,82,0,32,0,67,0,79,0,78,
0,83,0,69,0,81,0,85,0,69,0,78,0,84,0,73,
0,65,0,76,0,32,0,68,0,65,0,77,0,65,0,71,
0,69,0,83,0,44,0,32,0,87,0,72,0,69,0,84,
0,72,0,69,0,82,0,32,0,73,0,78,0,32,0,65,
0,78,0,32,0,65,0,67,0,84,0,73,0,79,0,78,
0,32,0,79,0,70,0,32,0,67,0,79,0,78,0,84,
0,82,0,65,0,67,0,84,0,44,0,32,0,84,0,79,
0,82,0,84,0,32,0,79,0,82,0,32,0,79,0,84,
0,72,0,69,0,82,0,87,0,73,0,83,0,69,0,44,
0,32,0,65,0,82,0,73,0,83,0,73,0,78,0,71,
0,32,0,70,0,82,0,79,0,77,0,44,0,32,0,79,
0,85,0,84,0,32,0,79,0,70,0,32,0,84,0,72,
0,69,0,32,0,85,0,83,0,69,0,32,0,79,0,82,
0,32,0,73,0,78,0,65,0,66,0,73,0,76,0,73,
0,84,0,89,0,32,0,84,0,79,0,32,0,85,0,83,
0,69,0,32,0,84,0,72,0,69,0,32,0,70,0,79,
0,78,0,84,0,32,0,83,0,79,0,70,0,84,0,87,
0,65,0,82,0,69,0,32,0,79,0,82,0,32,0,70,
0,82,0,79,0,77,0,32,0,79,0,84,0,72,0,69,
0,82,0,32,0,68,0,69,0,65,0,76,0,73,0,78,
0,71,0,83,0,32,0,73,0,78,0,32,0,84,0,72,
0,69,0,32,0,70,0,79,0,78,0,84,0,32,0,83,
0,79,0,70,0,84,0,87,0,65,0,82,0,69,0,46,
0,104,0,116,0,116,0,112,0,58,0,47,0,47,0,115,
0,99,0,114,0,105,0,112,0,116,0,115,0,46,0,115,
0,105,0,108,0,46,0,111,0,114,0,103,0,47,0,79,
0,70,0,76,0,71,0,101,0,110,0,116,0,105,0,117,
0,109,0,82,0,101,0,103,0,117,0,108,0,97,0,114,
0,0,0,2,0,1,0,0,0,0,0,20,0,3,0,1,
0,0,1,26,0,0,1,6,0,0,1,0,0,0,0,0,
0,0,1,2,0,0,0,2,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,0,3,209,210,208,4,5,
6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,
54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,
70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,
86,87,88,89,90,91,92,93,94,0,123,124,126,128,135,140,
145,148,147,149,151,150,152,154,156,155,157,158,160,159,161,162,
163,165,164,166,168,167,172,171,173,174,198,109,97,98,101,200,
113,146,107,103,205,111,102,0,125,141,0,110,0,0,100,112,
0,0,0,189,0,104,116,0,153,170,118,96,106,0,180,0,
0,105,117,201,3,119,122,139,177,178,190,191,195,196,192,193,
169,0,175,179,0,99,203,204,206,207,199,114,194,197,202,121,
129,120,130,127,132,133,134,131,137,138,0,136,143,144,142,176,
181,187,108,183,184,185,115,188,186,182,0,4,3,102,0,0,
0,168,0,128,0,6,0,40,0,35,0,126,0,165,0,190,
0,207,0,222,0,239,0,240,0,252,0,255,1,48,1,49,
1,81,1,83,1,119,1,120,1,145,1,146,2,31,2,51,
2,173,2,197,2,199,2,215,2,221,2,228,2,238,3,78,
3,98,3,117,3,122,3,126,3,138,3,140,3,161,3,191,
3,192,3,206,3,213,4,6,4,8,4,79,4,86,4,88,
4,192,4,197,4,213,4,217,4,225,4,233,5,12,30,155,
30,249,31,21,31,29,31,69,31,77,31,87,31,89,31,91,
31,93,31,125,31,180,31,196,31,211,31,219,31,239,31,244,
31,254,32,11,32,39,32,48,32,58,32,112,32,142,32,168,
32,175,32,177,33,34,34,18,34,25,233,8,251,4,255,255,
0,0,0,32,0,36,0,160,0,166,0,191,0,208,0,223,
0,240,0,241,0,253,1,0,1,49,1,50,1,82,1,84,
1,120,1,121,1,146,1,147,2,34,2,80,2,176,2,198,
2,200,2,216,2,222,2,236,3,0,3,96,3,116,3,122,
3,126,3,132,3,140,3,142,3,163,3,192,3,193,3,208,
4,5,4,8,4,16,4,85,4,88,4,192,4,197,4,212,
4,216,4,224,4,232,5,12,30,0,30,160,31,0,31,24,
31,32,31,72,31,80,31,89,31,91,31,93,31,95,31,128,
31,182,31,198,31,214,31,221,31,242,31,246,32,0,32,16,
32,48,32,57,32,112,32,116,32,161,32,171,32,177,33,34,
34,18,34,25,233,0,251,0,255,255,0,0,255,224,255,191,
0,0,255,183,0,0,255,179,0,0,255,178,0,0,255,226,
0,0,255,225,0,0,255,223,0,0,255,222,0,0,255,221,
255,219,255,191,255,189,0,0,255,187,0,0,255,181,255,174,
255,157,255,140,255,123,255,119,255,116,255,111,255,110,255,109,
255,108,0,0,255,107,255,106,2,77,2,76,2,69,2,64,
2,63,1,216,1,212,1,198,1,196,1,190,1,184,1,150,
229,64,229,60,229,54,229,52,229,50,229,48,229,46,229,45,
229,44,229,43,229,42,229,40,229,39,229,38,229,36,229,35,
229,33,229,32,229,31,0,0,224,154,224,146,228,199,228,196,
228,178,228,176,228,175,223,171,227,79,227,73,28,99,0,0,
0,1,0,168,0,0,0,0,0,170,0,0,0,216,0,0,
0,242,0,0,0,240,0,0,0,242,0,0,0,240,0,0,
0,240,0,0,0,238,0,0,0,0,0,0,0,0,0,230,
0,0,0,230,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,218,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,176,0,0,0,3,0,209,0,210,
0,208,0,211,0,101,0,102,0,103,0,104,0,105,0,106,
0,212,0,107,0,108,0,109,0,110,0,213,0,214,0,111,
0,112,0,113,0,114,0,115,0,215,0,116,0,117,0,216,
0,217,0,218,0,219,0,135,0,136,0,137,0,138,0,139,
0,140,0,220,0,141,0,142,0,143,0,144,0,145,0,221,
0,222,0,223,0,224,0,225,0,175,0,176,0,177,0,178,
0,179,0,180,0,181,0,182,0,183,0,184,0,185,0,186,
0,187,0,188,0,189,5,43,5,44,5,45,0,190,0,191,
5,46,5,47,5,48,0,192,0,193,0,194,5,49,0,195,
0,196,0,197,5,50,0,198,0,199,0,200,5,51,5,52,
5,53,0,201,5,54,5,108,0,206,0,207,5,109,5,110,
0,1,0,0,6,163,0,176,0,7,0,164,0,5,0,1,
0,0,0,0,0,10,0,0,2,0,3,28,0,3,0,1,
0,1,3,232,1,144,0,5,0,0,3,88,3,88,0,0,
4,176,3,88,3,88,0,0,4,176,0,102,2,0,0,0,
2,0,5,3,6,0,0,2,0,4,224,0,0,255,0,0,
0,3,0,0,0,0,0,0,0,0,83,73,76,32,0,0,
0,32,251,4,6,14,254,33,0,90,6,223,2,53,32,0,
0,27,0,0,0,0,0,0,0,0,6,163,1,1,1,1,
76,38,68,1,1,1,1,1,1,1,1,1,1,1,68,1,
68,1,1,1,55,1,1,1,1,1,1,76,51,1,76,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,38,1,1,1,1,1,1,
1,1,1,76,1,1,1,1,1,68,1,1,1,1,1,1,
1,1,1,1,1,1,1,76,1,68,1,1,1,1,1,1,
1,68,1,76,1,1,1,76,1,1,1,1,55,43,1,1,
1,1,33,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,68,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,11,1,1,1,76,68,1,1,76,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,76,1,1,1,1,
1,1,1,1,76,1,1,76,55,1,1,1,1,1,1,1,
1,1,1,1,1,76,1,1,1,1,1,59,55,76,1,1,
1,1,1,1,47,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,11,76,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,76,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,76,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,76,76,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,43,1,1,1,
1,1,1,76,1,1,1,51,1,68,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,55,55,68,1,1,1,
1,1,55,68,1,76,51,1,1,1,76,1,1,59,1,1,
1,68,1,1,1,1,1,1,1,1,1,47,1,1,11,76,
76,68,1,68,76,68,1,1,1,76,1,1,76,76,1,76,
1,76,76,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,76,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,47,1,
76,16,1,1,1,1,1,1,1,1,68,1,76,1,1,59,
1,1,1,1,55,1,68,1,1,1,1,1,1,68,1,59,
1,1,1,1,1,1,76,38,1,1,1,59,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,38,1,59,59,1,1,1,1,68,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,76,1,34,1,1,76,1,1,1,34,1,1,1,
1,1,1,1,1,47,1,1,1,68,68,1,43,1,1,76,
1,1,1,76,1,1,1,1,59,1,1,1,1,1,1,1,
1,1,1,1,1,68,1,1,1,76,76,1,1,1,1,68,
1,1,1,1,1,76,1,68,1,1,1,1,1,1,1,0,
0,0,0,1,0,1,1,1,1,1,0,12,0,248,8,255,
0,8,0,7,255,253,0,9,0,8,255,253,0,10,0,9,
255,253,0,11,0,10,255,252,0,12,0,11,255,252,0,13,
0,12,255,252,0,14,0,13,255,252,0,15,0,13,255,251,
0,16,0,14,255,251,0,17,0,15,255,251,0,18,0,16,
255,251,0,19,0,17,255,250,0,20,0,18,255,250,0,21,
0,19,255,250,0,22,0,19,255,249,0,23,0,20,255,249,
0,24,0,21,255,249,0,25,0,22,255,249,0,26,0,23,
255,248,0,27,0,24,255,248,0,28,0,25,255,248,0,29,
0,26,255,247,0,30,0,26,255,247,0,31,0,27,255,247,
0,32,0,28,255,247,0,33,0,29,255,246,0,34,0,30,
255,246,0,35,0,31,255,246,0,36,0,31,255,246,0,37,
0,32,255,245,0,38,0,33,255,245,0,39,0,34,255,245,
0,40,0,35,255,244,0,41,0,36,255,244,0,42,0,37,
255,244,0,43,0,37,255,244,0,44,0,38,255,243,0,45,
0,39,255,243,0,46,0,40,255,243,0,47,0,41,255,243,
0,48,0,42,255,242,0,49,0,43,255,242,0,50,0,44,
255,242,0,51,0,44,255,241,0,52,0,45,255,241,0,53,
0,46,255,241,0,54,0,47,255,241,0,55,0,48,255,240,
0,56,0,49,255,240,0,57,0,49,255,240,0,58,0,50,
255,239,0,59,0,51,255,239,0,60,0,52,255,239,0,61,
0,53,255,239,0,62,0,54,255,238,0,63,0,55,255,238,
0,64,0,55,255,238,0,65,0,56,255,238,0,66,0,57,
255,237,0,67,0,58,255,237,0,68,0,59,255,237,0,69,
0,60,255,236,0,70,0,61,255,236,0,71,0,61,255,236,
0,72,0,62,255,236,0,73,0,63,255,235,0,74,0,64,
255,235,0,75,0,65,255,235,0,76,0,66,255,235,0,77,
0,67,255,234,0,78,0,67,255,234,0,79,0,68,255,234,
0,80,0,69,255,233,0,81,0,70,255,233,0,82,0,71,
255,233,0,83,0,72,255,233,0,84,0,73,255,232,0,85,
0,74,255,232,0,86,0,74,255,232,0,87,0,76,255,231,
0,88,0,76,255,231,0,89,0,77,255,231,0,90,0,78,
255,231,0,91,0,79,255,230,0,92,0,80,255,230,0,93,
0,81,255,230,0,94,0,81,255,230,0,95,0,82,255,229,
0,96,0,83,255,229,0,97,0,84,255,229,0,98,0,85,
255,228,0,99,0,86,255,228,0,100,0,86,255,228,0,101,
0,87,255,228,0,102,0,88,255,227,0,103,0,89,255,227,
0,104,0,90,255,227,0,105,0,91,255,227,0,106,0,92,
255,226,0,107,0,92,255,226,0,108,0,93,255,226,0,109,
0,94,255,225,0,110,0,95,255,225,0,111,0,96,255,225,
0,112,0,97,255,225,0,113,0,98,255,224,0,114,0,98,
255,224,0,115,0,99,255,224,0,116,0,100,255,223,0,117,
0,101,255,223,0,118,0,102,255,223,0,119,0,103,255,223,
0,120,0,104,255,222,0,121,0,104,255,222,0,122,0,105,
255,222,0,123,0,106,255,222,0,124,0,107,255,221,0,125,
0,108,255,221,0,126,0,109,255,221,0,127,0,110,255,220,
0,128,0,110,255,220,0,129,0,111,255,220,0,130,0,112,
255,220,0,131,0,113,255,219,0,132,0,114,255,219,0,133,
0,115,255,219,0,134,0,116,255,219,0,135,0,116,255,218,
0,136,0,117,255,218,0,137,0,118,255,218,0,138,0,119,
255,217,0,139,0,120,255,217,0,140,0,121,255,217,0,141,
0,122,255,217,0,142,0,122,255,216,0,143,0,123,255,216,
0,144,0,124,255,216,0,145,0,125,255,215,0,146,0,126,
255,215,0,147,0,127,255,215,0,148,0,128,255,215,0,149,
0,128,255,214,0,150,0,129,255,214,0,151,0,130,255,214,
0,152,0,131,255,214,0,153,0,132,255,213,0,154,0,133,
255,213,0,155,0,134,255,213,0,156,0,134,255,212,0,157,
0,136,255,212,0,158,0,136,255,212,0,159,0,137,255,212,
0,160,0,138,255,211,0,161,0,139,255,211,0,162,0,140,
255,211,0,163,0,140,255,211,0,164,0,141,255,210,0,165,
0,142,255,210,0,166,0,143,255,210,0,167,0,144,255,209,
0,168,0,145,255,209,0,169,0,146,255,209,0,170,0,147,
255,209,0,171,0,148,255,208,0,172,0,148,255,208,0,173,
0,149,255,208,0,174,0,150,255,207,0,175,0,151,255,207,
0,176,0,152,255,207,0,177,0,153,255,207,0,178,0,153,
255,206,0,179,0,154,255,206,0,180,0,155,255,206,0,181,
0,156,255,206,0,182,0,157,255,205,0,183,0,158,255,205,
0,184,0,159,255,205,0,185,0,159,255,204,0,186,0,160,
255,204,0,187,0,161,255,204,0,188,0,162,255,204,0,189,
0,163,255,203,0,190,0,164,255,203,0,191,0,165,255,203,
0,192,0,165,255,203,0,193,0,166,255,202,0,194,0,167,
255,202,0,195,0,168,255,202,0,196,0,169,255,201,0,197,
0,170,255,201,0,198,0,171,255,201,0,199,0,171,255,201,
0,200,0,172,255,200,0,201,0,173,255,200,0,202,0,174,
255,200,0,203,0,175,255,199,0,204,0,176,255,199,0,205,
0,177,255,199,0,206,0,177,255,199,0,207,0,178,255,198,
0,208,0,180,255,198,0,209,0,180,255,198,0,210,0,181,
255,198,0,211,0,182,255,197,0,212,0,183,255,197,0,213,
0,183,255,197,0,214,0,184,255,196,0,215,0,185,255,196,
0,216,0,186,255,196,0,217,0,187,255,196,0,218,0,188,
255,195,0,219,0,189,255,195,0,220,0,189,255,195,0,221,
0,190,255,195,0,222,0,191,255,194,0,223,0,192,255,194,
0,224,0,193,255,194,0,225,0,194,255,193,0,226,0,195,
255,193,0,227,0,195,255,193,0,228,0,196,255,193,0,229,
0,197,255,192,0,230,0,198,255,192,0,231,0,199,255,192,
0,232,0,200,255,191,0,233,0,201,255,191,0,234,0,202,
255,191,0,235,0,202,255,191,0,236,0,203,255,190,0,237,
0,204,255,190,0,238,0,205,255,190,0,239,0,206,255,190,
0,240,0,207,255,189,0,241,0,208,255,189,0,242,0,208,
255,189,0,243,0,209,255,188,0,244,0,210,255,188,0,245,
0,211,255,188,0,246,0,212,255,188,0,247,0,213,255,187,
0,248,0,214,255,187,0,249,0,214,255,187,0,250,0,215,
255,187,0,251,0,216,255,186,0,252,0,217,255,186,0,253,
0,218,255,186,0,254,0,219,255,185,0,255,0,220,255,185,
0,0,0,3,0,8,0,2,0,16,0,1,255,255,0,2,
0,0,0,23,0,0,6,168,9,12,2,0,2,2,5,7,
6,2,3,3,4,4,2,3,2,4,4,4,5,4,4,4,
4,4,5,4,2,2,4,4,4,5,8,5,6,5,5,4,
4,5,6,3,3,5,4,7,6,5,5,5,5,4,5,6,
6,8,6,5,5,3,4,3,4,4,3,4,5,4,5,4,
3,5,5,2,2,5,2,9,5,5,5,5,4,3,3,5,
4,6,5,4,4,4,2,3,4,2,2,4,4,4,4,6,
4,7,2,4,4,4,4,3,4,3,5,5,1,2,3,4,
5,5,5,5,5,5,5,7,5,4,4,4,4,3,3,3,
3,6,5,5,5,5,5,5,6,6,6,6,5,4,4,4,
4,4,4,7,4,4,4,4,4,2,2,2,2,5,5,5,
5,5,5,4,5,5,5,5,5,4,2,7,7,5,3,3,
3,3,2,2,2,4,3,5,4,7,2,2,2,4,4,4,
4,4,3,7,10,3,3,6,5,5,4,2,4,2,3,3,
3,3,5,5,5,5,4,5,5,4,4,5,5,4,5,4,
5,4,5,4,5,4,5,4,5,4,5,6,5,5,4,4,
4,4,4,4,4,4,4,4,5,4,5,4,5,4,5,4,
6,5,6,5,3,2,3,2,3,2,3,2,3,5,5,3,
2,5,5,5,4,2,4,2,4,4,4,4,4,2,6,5,
6,5,6,5,6,5,5,5,5,5,5,5,5,5,4,5,
4,5,4,4,3,4,3,4,3,4,3,5,3,5,3,5,
3,6,5,6,5,6,5,6,5,6,5,6,5,8,6,5,
4,5,4,5,4,5,4,3,5,7,5,5,5,5,5,5,
4,5,7,5,5,5,5,5,5,4,5,5,7,3,3,6,
5,3,5,9,6,5,5,5,5,8,7,6,5,5,4,3,
5,2,4,5,3,5,6,6,6,6,6,4,5,4,5,5,
4,4,5,5,4,4,5,2,3,3,2,10,9,9,7,7,
5,9,8,7,5,4,3,2,5,5,6,5,6,5,6,5,
6,5,6,5,4,5,4,5,4,7,6,5,5,5,4,5,
5,5,5,5,5,5,4,2,10,9,9,5,4,9,5,6,
5,5,4,7,6,5,5,5,4,5,4,4,4,4,4,3,
2,3,2,5,5,5,5,5,4,5,4,6,5,6,5,4,
3,5,3,5,4,6,5,6,5,5,4,5,4,4,4,5,
5,5,5,5,5,5,5,5,4,4,5,5,5,4,4,5,
5,5,4,5,4,5,5,5,3,5,5,4,4,4,5,5,
5,2,3,3,3,3,2,5,7,7,9,5,5,5,5,6,
7,6,4,4,4,4,4,3,4,5,4,4,2,3,2,3,
3,3,5,4,4,4,6,4,4,5,4,4,4,5,5,5,
4,6,6,5,4,5,2,5,4,5,5,5,7,9,7,7,
6,6,8,5,5,5,5,3,3,2,3,3,3,3,4,3,
2,3,2,2,2,2,2,3,3,3,3,3,3,2,4,3,
3,2,4,3,3,2,2,2,2,2,2,2,3,1,3,3,
2,2,3,3,3,4,4,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,2,2,0,2,2,4,6,
2,6,8,5,7,8,7,3,5,6,4,5,4,5,6,6,
3,5,5,7,6,5,5,6,5,5,5,5,7,6,6,6,
3,5,5,4,5,3,5,5,6,4,5,4,4,5,5,3,
5,5,5,5,5,4,4,4,4,4,5,7,4,7,6,3,
5,4,5,6,6,5,6,8,6,7,5,4,5,5,5,5,
5,5,5,4,5,5,5,5,5,5,5,5,5,5,4,4,
4,4,4,4,4,4,4,4,4,3,5,4,6,5,6,5,
6,5,6,5,6,5,3,2,3,2,5,5,5,5,5,5,
4,2,4,2,4,2,4,2,7,7,7,7,7,7,6,5,
6,5,6,5,6,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,4,5,4,5,4,5,4,4,3,4,3,4,3,
4,3,4,3,5,3,5,3,5,3,5,3,6,5,6,5,
6,5,6,5,6,5,6,4,6,4,8,6,8,6,8,6,
8,6,8,6,6,5,6,5,5,4,5,4,5,4,5,4,
5,3,6,4,4,3,5,4,5,4,5,4,5,4,5,4,
5,4,5,4,5,4,5,4,5,4,5,4,5,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,2,
3,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,6,5,6,5,6,6,
6,6,6,6,6,6,6,6,5,4,5,4,5,4,5,4,
5,5,5,5,5,5,5,5,6,6,8,8,7,7,6,6,
4,4,4,4,4,4,6,6,8,8,7,7,5,5,5,5,
5,5,5,5,8,8,9,9,9,9,8,8,3,3,3,3,
3,3,3,3,4,4,6,6,6,6,4,4,4,4,4,4,
4,4,7,7,8,8,8,8,5,5,5,5,5,5,5,5,
7,9,9,7,6,6,6,6,6,6,6,6,7,7,9,9,
8,8,7,7,5,5,4,4,5,5,3,3,4,4,5,5,
6,6,5,5,5,5,5,5,5,5,9,9,10,10,10,10,
9,9,5,5,5,5,5,5,5,5,10,10,12,12,11,11,
10,10,6,6,6,6,6,6,6,6,10,10,11,11,11,11,
10,10,5,5,5,5,5,5,5,5,5,6,6,8,2,3,
2,4,4,5,5,5,5,5,6,6,8,8,9,3,3,2,
3,3,3,3,3,3,3,3,5,5,3,3,2,5,5,5,
5,4,4,5,5,5,5,8,8,6,4,4,2,6,6,6,
6,6,7,7,7,7,8,2,2,4,7,4,7,2,2,1,
4,2,1,0,0,3,3,4,9,4,4,2,4,2,2,4,
2,3,3,3,3,3,3,3,3,2,3,2,2,3,3,3,
3,3,3,3,3,3,3,3,3,2,3,2,2,4,4,4,
4,6,4,9,7,4,4,4,4,9,4,4,1,2,0,0,
0,0,0,0,0,0,6,8,8,3,2,2,4,4,3,2,
2,3,3,3,3,2,4,0,0,0,0,0,0,0,0,0,
0,4,4,4,4,4,4,4,4,4,2,2,2,2,5,5,
5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,
4,4,4,4,2,2,2,5,2,5,5,5,4,4,3,3,
3,5,5,6,4,4,4,4,9,9,7,5,8,7,4,2,
5,5,5,5,5,5,4,4,6,4,5,4,2,4,5,6,
5,4,5,5,5,5,4,5,4,5,4,4,4,2,2,7,
7,5,5,5,5,5,5,5,4,4,3,3,3,3,5,5,
4,6,6,6,6,5,5,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,2,5,5,5,5,5,5,5,5,
6,6,6,4,4,0,4,4,2,2,5,5,6,6,5,5,
8,8,3,3,5,5,5,5,8,6,6,7,7,5,5,9,
9,5,5,11,11,6,6,10,10,5,5,5,5,3,3,5,
5,6,6,0,0,0,0,0,0,0,5,8,4,3,3,5,
5,6,4,6,4,8,6,6,6,5,6,7,6,5,6,5,
5,5,6,7,6,6,6,7,7,6,7,5,5,9,5,4,
4,6,4,5,4,6,5,5,5,5,5,6,5,5,5,5,
4,4,4,7,5,5,5,7,7,5,6,4,4,7,4,3,
2,2,3,6,7,7,5,4,5,4,5,5,5,0,0,0,
10,13,2,0,2,2,5,8,7,3,3,3,4,4,2,3,
2,5,5,5,5,5,5,5,5,5,5,5,2,2,4,4,
4,5,9,6,7,5,6,5,5,6,7,3,3,6,5,8,
6,6,5,6,6,5,6,7,7,9,6,6,5,3,5,4,
5,5,3,5,5,4,5,5,3,5,6,3,3,5,3,9,
6,5,5,5,4,4,3,5,5,7,5,5,4,3,2,3,
5,2,3,5,5,5,5,6,4,8,3,5,5,5,5,4,
4,3,6,6,1,2,3,5,5,6,6,6,6,6,6,8,
5,5,5,5,5,3,3,3,3,6,6,6,6,6,6,6,
7,7,7,7,6,5,5,5,5,5,5,8,4,5,5,5,
5,3,3,3,3,6,5,5,5,5,5,4,5,5,5,5,
5,5,3,8,8,6,3,4,4,4,2,3,3,4,4,5,
5,8,2,2,2,4,4,4,5,5,3,7,11,3,3,6,
6,6,5,3,4,2,3,3,3,3,6,6,6,6,4,6,
5,5,5,5,6,5,6,5,6,5,5,4,5,4,5,4,
5,4,6,7,6,5,5,5,5,5,5,5,5,5,5,5,
6,5,6,5,6,5,6,5,7,6,7,6,3,3,3,3,
3,3,3,3,3,6,5,3,3,6,5,5,5,3,5,3,
5,4,5,4,5,3,6,6,6,6,6,6,7,6,5,6,
5,6,5,6,5,6,4,6,4,6,4,5,4,5,4,5,
4,5,4,6,3,6,3,6,3,7,5,7,5,7,5,7,
5,7,5,7,5,9,7,6,5,5,4,5,4,5,4,3,
5,8,6,5,6,5,5,5,4,6,8,6,5,6,5,5,
5,5,6,6,8,3,3,6,5,3,5,11,6,5,6,6,
5,9,8,7,5,5,5,4,5,3,5,6,3,6,7,6,
6,6,7,5,5,4,5,5,5,4,5,5,4,4,5,2,
4,3,3,11,10,10,8,7,5,10,9,8,6,5,3,3,
6,5,7,5,7,5,7,5,7,5,7,5,5,6,5,6,
5,8,7,6,5,6,5,6,5,6,5,6,5,5,5,3,
11,10,10,6,5,10,5,6,6,6,5,8,7,6,5,6,
5,6,5,5,5,5,5,3,3,3,3,6,5,6,5,6,
4,6,4,7,5,7,5,5,4,6,3,5,4,7,6,7,
6,5,4,6,5,5,5,6,5,6,5,6,5,6,5,6,
5,5,5,5,5,5,4,5,5,5,5,6,4,5,6,5,
3,5,5,5,5,5,5,6,5,3,3,3,3,4,3,6,
9,9,9,5,6,6,5,7,7,6,4,4,4,4,4,4,
4,5,5,5,2,3,3,3,3,3,5,5,5,5,7,5,
5,5,4,5,4,5,5,5,4,7,6,5,5,6,3,5,
4,5,5,5,8,9,8,7,6,7,8,6,5,5,5,4,
4,2,3,3,3,3,5,3,2,4,2,2,2,2,2,3,
3,4,4,3,3,2,5,3,3,2,5,3,3,3,3,2,
2,3,3,3,3,1,4,3,2,3,4,3,3,5,4,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,2,2,0,2,2,4,7,2,7,9,5,7,9,8,3,
6,7,5,6,5,5,7,6,3,6,6,8,6,5,6,6,
5,5,6,6,7,6,7,6,3,6,5,4,5,3,5,5,
6,5,6,4,4,6,5,3,5,5,6,5,5,5,5,4,
5,4,5,7,5,7,7,3,5,5,5,7,6,6,6,9,
6,8,6,5,6,5,6,5,6,5,5,4,6,5,6,5,
6,5,6,5,6,5,5,5,5,5,5,5,5,5,5,5,
5,3,6,5,7,6,7,6,7,6,7,6,7,6,3,3,
3,3,6,5,6,5,6,5,5,3,5,3,5,3,5,3,
8,8,8,8,8,8,6,6,6,6,6,6,6,6,6,5,
6,5,6,5,6,5,5,5,5,5,6,4,6,4,6,4,
6,4,5,4,5,4,5,4,5,4,5,4,6,3,6,3,
6,3,6,3,7,5,7,5,7,5,7,5,7,5,7,5,
7,5,9,7,9,7,9,7,9,7,9,7,6,5,6,5,
6,5,5,4,5,4,5,4,6,3,7,5,5,3,6,5,
6,5,6,5,6,5,6,5,6,5,6,5,6,5,6,5,
6,5,6,5,6,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,3,3,3,3,6,5,6,5,6,5,
6,5,6,5,6,5,6,5,6,5,6,5,6,5,6,5,
6,5,7,5,7,5,7,6,7,6,7,6,7,6,7,6,
6,5,6,5,6,5,6,5,5,5,5,5,5,5,5,5,
7,7,8,8,8,8,7,7,4,4,4,4,4,4,7,7,
8,9,8,8,5,5,5,5,5,5,5,5,8,8,10,10,
10,10,8,8,3,3,3,3,3,3,3,3,5,5,7,7,
6,6,5,5,5,5,5,5,5,5,8,8,9,9,8,8,
5,5,5,5,5,5,5,5,8,10,10,8,7,7,7,7,
7,7,7,7,8,8,10,10,9,9,8,8,5,5,4,4,
5,5,3,3,5,5,5,5,7,7,5,5,5,5,5,5,
5,5,10,10,11,11,11,11,10,10,5,5,5,5,5,5,
5,5,11,11,13,13,13,13,11,11,7,7,7,7,7,7,
7,7,11,11,12,13,12,12,11,11,5,5,5,5,5,5,
5,6,6,7,7,9,2,3,2,4,4,5,5,5,5,5,
7,7,9,9,9,4,3,2,3,3,3,3,3,3,3,3,
5,5,4,3,2,5,5,5,5,5,5,5,5,6,6,9,
9,7,4,4,2,7,7,7,7,7,8,7,8,8,9,2,
2,5,8,5,8,3,2,1,5,2,1,0,0,3,3,5,
10,4,4,2,4,3,2,4,2,3,3,3,3,3,3,3,
3,2,3,2,2,4,3,3,3,3,3,3,3,3,3,3,
3,2,3,2,2,5,5,5,5,6,5,10,7,5,5,5,
5,10,5,4,1,3,0,0,0,0,0,0,0,0,6,9,
9,3,3,3,4,5,3,3,3,4,4,3,3,2,4,0,
0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,
5,5,3,3,3,3,6,5,5,5,5,5,5,5,5,5,
5,5,5,4,4,4,4,5,5,5,5,5,3,3,3,5,
3,6,6,5,4,4,4,4,4,5,5,7,5,4,4,4,
10,10,7,5,9,8,5,3,5,5,5,5,5,5,5,5,
7,5,5,5,3,5,6,7,5,5,5,5,5,5,5,5,
4,5,5,5,5,3,3,8,8,6,5,5,5,5,5,5,
4,4,4,4,4,4,5,5,5,7,7,7,7,5,5,5,
4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,
5,5,5,5,5,5,5,5,6,6,6,5,5,0,4,4,
2,2,5,5,7,7,5,5,9,9,3,3,5,5,5,5,
8,7,7,8,8,5,5,10,10,5,5,12,12,7,7,11,
11,5,5,5,5,3,3,5,5,7,7,0,0,0,0,0,
0,0,6,9,5,3,3,6,6,7,5,6,5,9,7,7,
7,6,6,8,7,6,6,5,5,6,7,7,6,6,6,9,
9,7,8,6,5,9,6,5,5,6,4,5,5,7,5,6,
5,5,5,7,6,5,6,5,4,5,5,7,5,6,5,7,
7,6,7,5,5,8,5,4,3,3,3,6,8,8,5,5,
5,5,6,5,6,0,0,0,11,14,2,0,2,2,6,8,
7,3,3,3,5,5,3,4,3,5,5,5,6,5,5,5,
5,5,5,5,3,3,5,5,5,5,10,7,7,6,7,5,
5,6,7,3,3,6,5,9,7,7,6,7,6,5,6,7,
7,9,7,7,6,3,5,4,5,5,4,5,6,5,6,5,
3,6,6,3,3,6,3,9,6,6,6,6,4,4,4,6,
5,8,6,5,5,4,3,5,5,2,3,5,5,5,5,6,
4,9,3,5,5,5,5,4,5,4,6,6,2,3,3,5,
5,7,7,7,7,7,7,9,6,5,5,5,5,3,3,3,
3,7,7,7,7,7,7,7,7,7,7,7,6,5,5,5,
5,5,5,8,5,5,5,5,5,3,3,3,3,6,6,6,
6,6,6,5,6,6,6,6,6,5,3,9,9,7,3,4,
4,4,2,3,3,4,4,6,5,8,3,3,3,5,5,5,
5,5,3,8,12,3,3,7,6,6,5,3,5,3,4,4,
4,4,6,6,6,7,5,7,6,5,5,6,7,5,7,5,
7,5,6,5,6,5,6,5,6,5,7,7,7,6,5,5,
5,5,5,5,5,5,5,5,6,5,6,5,6,5,6,5,
7,6,7,6,3,3,3,3,3,3,3,3,3,7,6,3,
3,6,6,6,5,3,5,3,5,5,5,5,5,3,7,6,
7,6,7,6,7,7,6,7,6,7,6,7,6,6,4,6,
4,6,4,5,4,5,4,5,4,5,4,6,4,6,4,6,
4,7,6,7,6,7,6,7,6,7,6,7,6,9,8,7,
5,6,5,6,5,6,5,3,6,8,6,6,6,6,6,6,
5,7,8,6,6,6,5,6,6,5,6,7,9,4,3,7,
6,4,6,11,7,6,7,7,6,10,9,8,6,6,5,4,
6,3,5,7,4,6,8,7,7,7,8,5,6,5,6,6,
5,5,5,6,5,5,6,2,4,3,3,12,11,11,9,8,
6,11,10,9,7,5,3,3,7,6,7,6,7,6,7,6,
7,6,7,6,5,7,5,7,5,9,8,6,6,6,5,6,
6,7,6,7,6,6,5,3,12,11,11,6,5,11,6,7,
6,7,5,9,8,7,6,7,5,7,5,5,5,5,5,3,
3,3,3,7,6,7,6,6,4,6,4,7,6,7,6,5,
4,6,4,6,5,7,6,7,6,6,5,7,5,5,5,7,
6,7,6,7,6,7,6,7,5,5,6,6,6,5,5,6,
6,6,5,7,5,5,6,6,3,6,6,5,5,5,6,6,
6,3,3,3,4,4,3,6,9,9,9,6,6,6,6,7,
8,6,4,5,5,4,4,4,4,6,5,5,3,3,3,3,
4,4,6,5,5,5,8,5,5,6,5,5,5,6,6,6,
5,7,6,6,5,6,3,6,5,6,6,6,9,10,9,8,
6,8,9,7,6,6,6,4,4,2,3,3,3,4,5,4,
2,4,2,2,2,2,2,3,3,4,4,3,3,2,5,4,
4,2,5,4,4,3,3,2,2,3,3,3,3,1,4,4,
2,3,4,3,3,5,5,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,2,2,0,3,2,4,8,
3,8,10,6,8,9,8,3,7,7,5,6,5,6,7,7,
3,6,7,9,7,6,7,7,6,6,6,6,8,7,8,7,
3,6,6,5,6,3,6,6,6,5,6,5,4,6,6,3,
6,6,6,6,6,5,5,5,5,5,6,8,5,8,8,3,
6,5,6,8,6,6,7,10,7,8,7,5,6,6,6,6,
6,6,6,5,7,6,7,6,7,6,7,6,7,6,5,5,
5,5,5,5,5,5,5,5,5,3,6,5,7,6,7,6,
7,6,7,6,7,6,3,3,3,3,6,6,6,6,6,6,
5,3,5,3,5,3,5,3,9,9,9,9,9,9,7,6,
7,6,7,6,7,6,7,6,7,6,7,6,7,6,6,6,
6,6,6,4,6,4,6,4,6,4,5,4,5,4,5,4,
5,4,5,4,6,4,6,4,6,4,6,4,7,6,7,6,
7,6,7,6,7,6,7,5,7,5,9,8,9,8,9,8,
9,8,9,8,7,6,7,6,7,5,6,5,6,5,6,5,
6,4,8,5,5,3,7,5,7,5,7,5,7,5,7,5,
7,5,7,5,7,5,7,5,7,5,7,5,7,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,3,
3,3,7,6,7,6,7,6,7,6,7,6,7,6,7,6,
7,6,7,6,7,6,7,6,7,6,7,6,7,6,8,7,
8,7,8,7,8,7,8,7,7,5,7,5,7,5,7,5,
6,6,6,6,6,6,6,6,7,7,9,9,9,9,7,7,
5,5,5,5,5,5,8,8,9,9,9,9,6,6,6,6,
6,6,6,6,9,9,11,11,11,11,9,9,3,3,3,3,
3,3,3,3,5,5,7,7,7,7,5,5,5,5,5,5,
5,5,8,8,10,10,9,9,6,6,6,6,6,6,6,6,
9,11,11,9,8,8,8,8,8,8,8,8,9,9,10,11,
10,10,9,9,6,6,5,5,6,6,3,3,5,5,6,6,
8,8,6,6,6,6,6,6,6,6,11,11,12,13,12,12,
11,11,6,6,6,6,6,6,6,6,13,13,14,14,14,14,
13,13,8,8,8,8,8,8,8,8,12,12,14,14,13,13,
12,12,6,6,6,6,6,6,6,7,7,8,8,10,2,3,
2,4,4,6,6,6,6,6,8,8,10,10,10,4,4,2,
3,3,3,3,3,3,3,3,6,6,4,4,2,6,6,6,
6,5,5,6,6,6,6,9,9,8,4,4,2,8,8,8,
8,8,9,8,9,8,10,2,2,5,8,5,8,3,2,1,
5,3,2,1,0,4,4,5,10,4,4,3,5,3,3,5,
3,4,4,4,4,4,4,4,3,3,3,2,2,4,4,4,
4,4,4,4,4,4,4,4,3,3,3,2,2,5,5,5,
5,6,5,10,8,5,5,5,5,11,5,5,2,3,0,0,
0,0,0,0,0,0,7,10,10,4,3,3,4,5,4,3,
3,4,4,4,4,2,4,0,0,0,0,0,0,0,0,0,
0,5,5,5,5,5,5,5,5,5,3,3,3,3,6,6,
6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,
5,5,5,5,3,3,3,6,3,6,6,6,4,4,4,4,
4,6,6,8,5,5,5,5,11,11,8,6,10,9,5,3,
6,6,6,6,6,6,5,5,8,5,6,5,3,5,6,8,
6,5,6,6,6,6,5,6,5,6,5,5,5,3,3,9,
9,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,
5,8,8,8,8,6,6,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,3,6,6,6,6,6,6,6,6,
7,7,7,5,5,0,4,4,2,2,6,6,7,7,6,6,
10,10,3,3,6,6,6,6,9,8,8,9,9,6,6,11,
11,6,6,13,13,8,8,12,12,6,6,6,6,3,3,6,
6,8,8,0,0,0,0,0,0,0,6,10,5,3,3,7,
6,7,5,7,5,10,7,7,7,7,7,9,7,7,7,6,
6,6,7,8,7,7,7,9,9,8,8,6,6,10,6,5,
5,6,5,6,5,8,5,6,6,6,6,7,6,6,6,6,
5,5,5,8,6,6,6,9,9,6,8,5,5,9,5,4,
3,3,3,7,9,8,6,5,6,5,7,6,6,0,0,0,
12,16,3,0,3,3,6,9,9,3,4,4,5,5,3,4,
3,6,6,6,6,6,5,6,6,6,6,6,3,3,5,5,
5,6,10,7,7,6,7,6,6,7,8,4,4,7,6,10,
8,7,6,7,7,6,7,8,8,10,7,7,6,4,6,4,
6,6,4,6,6,5,6,6,4,6,7,3,3,6,3,9,
7,6,6,6,5,5,4,6,6,8,6,6,5,4,3,4,
6,3,3,6,6,6,6,7,5,9,3,6,6,5,6,4,
5,4,7,6,2,3,3,6,6,7,7,7,7,7,7,9,
6,6,6,6,6,4,4,4,4,8,7,7,7,7,7,7,
8,8,8,8,7,6,6,6,6,6,6,9,5,6,6,6,
6,3,3,3,3,7,6,6,6,6,6,5,6,6,6,6,
6,6,3,10,10,7,3,4,4,4,2,3,3,5,5,6,
6,9,3,3,3,5,5,5,6,6,3,8,13,4,4,7,
7,7,6,3,5,3,4,4,4,4,7,7,7,7,5,7,
6,6,6,6,7,6,7,6,7,6,6,5,6,5,6,5,
6,5,7,8,7,6,6,6,6,6,6,6,6,6,6,6,
7,6,7,6,7,6,7,6,8,7,8,7,4,3,4,3,
4,3,4,3,4,7,6,4,3,7,6,6,6,3,6,3,
6,5,6,5,6,3,8,7,8,7,8,7,8,7,7,7,
6,7,6,7,6,7,5,7,5,7,5,6,5,6,5,6,
5,6,5,7,4,7,4,7,4,8,6,8,6,8,6,8,
6,8,6,8,6,10,8,7,6,6,5,6,5,6,5,4,
6,9,7,6,7,6,6,6,5,7,9,7,6,6,6,7,
6,6,7,7,10,4,4,7,6,4,6,11,8,7,7,7,
6,11,9,8,6,7,6,5,6,3,5,7,4,7,8,7,
8,7,8,6,6,5,6,6,5,5,6,6,5,5,6,3,
5,4,3,13,12,12,9,9,6,11,11,10,7,6,4,3,
7,6,8,6,8,6,8,6,8,6,8,6,5,7,6,7,
6,9,8,7,6,7,6,7,6,7,6,7,6,6,5,3,
13,12,12,7,6,12,6,8,7,7,6,9,8,7,6,7,
6,7,6,6,6,6,6,4,3,4,3,7,6,7,6,7,
5,7,5,8,6,8,6,6,5,7,4,6,5,8,7,8,
7,6,5,7,6,6,6,7,6,7,6,7,6,7,6,7,
6,6,6,6,6,5,5,6,6,6,5,7,5,6,7,6,
3,6,6,6,6,6,6,7,7,3,3,3,4,4,3,7,
9,9,9,7,7,7,6,8,8,8,5,5,5,5,5,4,
5,6,6,5,3,3,3,3,4,4,6,6,6,6,8,6,
6,6,5,5,5,6,6,6,5,8,7,6,6,7,3,6,
5,6,6,6,10,11,10,8,7,8,10,7,7,6,6,5,
5,2,3,3,3,4,6,4,3,5,3,3,3,2,2,4,
4,4,4,4,4,2,6,4,4,2,6,4,4,3,3,2,
2,3,3,3,4,2,4,4,2,3,4,4,4,6,5,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,3,3,0,3,3,5,9,3,9,11,6,9,10,9,4,
7,7,6,7,6,6,8,7,4,7,7,10,8,6,7,8,
6,6,7,7,8,7,8,8,4,7,6,5,6,4,6,6,
7,6,6,5,5,7,6,4,6,6,7,6,6,6,6,5,
6,5,6,8,6,8,8,4,6,6,6,8,7,7,7,11,
7,9,7,6,7,6,7,6,7,6,6,5,7,6,7,6,
7,6,7,6,7,6,6,6,6,6,6,6,6,6,6,6,
6,4,7,6,8,7,8,7,8,7,8,7,8,7,4,3,
4,3,7,6,7,6,7,6,6,3,6,3,6,3,6,3,
10,10,10,10,10,10,8,7,8,7,8,7,8,7,7,6,
7,6,7,6,7,6,6,6,6,6,7,5,7,5,7,5,
7,5,6,5,6,5,6,5,6,5,6,5,7,4,7,4,
7,4,7,4,8,6,8,6,8,6,8,6,8,6,8,6,
8,6,10,8,10,8,10,8,10,8,10,8,7,6,7,6,
7,6,6,5,6,5,6,5,7,4,8,6,6,4,7,6,
7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,
7,6,7,6,7,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,4,3,4,3,7,6,7,6,7,6,
7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,
7,6,8,6,8,6,8,7,8,7,8,7,8,7,8,7,
7,6,7,6,7,6,7,6,6,6,6,6,6,6,6,6,
8,8,10,10,10,10,8,8,5,5,5,5,5,5,8,8,
10,10,10,10,6,6,6,6,6,6,6,6,10,10,12,12,
12,12,10,10,4,4,4,4,4,4,4,4,6,6,8,8,
8,8,6,6,6,6,6,6,6,6,9,9,11,11,10,10,
6,6,6,6,6,6,6,6,10,12,11,10,8,8,8,8,
8,8,8,8,9,9,11,12,11,11,9,9,6,6,5,5,
6,6,4,4,6,6,6,6,8,8,6,6,6,6,6,6,
6,6,12,12,14,14,13,13,12,12,6,6,6,6,6,6,
6,6,14,14,16,16,15,15,14,14,8,8,8,8,8,8,
8,8,13,13,15,15,15,15,13,13,6,6,6,6,6,6,
6,7,7,8,9,11,2,4,2,5,5,6,6,6,6,6,
9,9,11,11,11,4,4,2,4,4,4,4,4,4,4,4,
6,6,4,4,2,6,6,6,6,6,6,6,6,7,7,10,
10,9,5,5,3,8,8,8,8,8,10,9,10,9,11,3,
2,6,9,6,9,3,2,2,6,3,2,1,0,4,4,6,
11,5,5,3,5,3,3,5,3,4,4,4,4,4,4,4,
3,3,4,3,3,5,4,4,4,4,4,4,4,4,4,4,
3,3,4,3,3,6,6,6,6,7,6,11,9,6,6,6,
6,12,6,5,2,3,0,0,0,0,0,0,0,0,7,11,
11,4,3,3,5,6,4,3,3,4,4,4,4,2,5,0,
0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,
6,6,3,3,3,3,7,6,6,6,6,6,6,6,6,6,
6,6,6,5,5,5,5,6,6,6,6,6,3,3,3,6,
3,7,7,6,5,5,5,5,5,6,6,8,6,5,5,5,
12,12,9,6,11,10,6,3,6,6,6,6,6,6,6,6,
8,6,6,5,3,6,7,8,6,6,6,6,6,6,6,6,
5,6,6,6,6,3,3,10,10,7,6,6,6,6,6,6,
5,5,5,5,5,5,6,6,6,8,8,8,8,6,6,6,
5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,
6,6,6,6,6,6,6,6,7,7,7,6,6,0,5,5,
2,2,6,6,8,8,6,6,11,11,4,4,7,7,6,6,
10,8,8,9,9,6,6,12,12,6,6,14,14,8,8,13,
13,6,6,6,6,4,4,6,6,8,8,0,0,0,0,0,
0,0,7,11,6,4,4,7,7,7,6,7,6,11,7,8,
8,7,7,10,8,7,8,6,6,7,8,8,7,8,7,11,
11,9,9,7,6,11,7,6,6,7,5,7,6,9,6,7,
6,6,7,8,7,6,7,6,5,6,6,9,6,7,7,9,
9,7,8,6,6,9,6,5,3,3,4,7,9,9,7,5,
6,5,7,6,7,0,0,0,13,17,3,0,3,3,7,10,
9,3,4,4,6,5,3,4,3,6,6,6,6,6,6,6,
6,6,6,6,3,3,6,6,6,6,11,8,8,7,8,6,
6,8,9,4,4,8,6,10,8,8,7,8,7,6,7,9,
8,11,8,8,7,4,6,4,6,6,4,6,7,6,7,6,
4,6,7,4,3,7,4,11,7,7,7,7,5,5,4,7,
6,9,7,6,6,4,3,5,6,3,4,6,6,6,6,7,
5,10,3,6,6,6,6,5,5,4,7,7,2,3,4,6,
6,8,8,8,8,8,8,10,7,6,6,6,6,4,4,4,
4,8,8,8,8,8,8,8,9,9,9,9,7,6,6,6,
6,6,6,9,6,6,6,6,6,4,4,4,4,7,7,7,
7,7,7,5,7,7,7,7,7,6,4,10,10,8,4,5,
5,5,3,3,3,5,5,7,6,10,3,3,3,6,6,6,
6,6,4,9,14,4,4,8,8,8,6,4,6,3,4,4,
4,4,8,8,8,8,5,8,7,6,6,7,8,6,8,6,
8,6,7,6,7,6,7,6,7,6,8,9,8,7,6,6,
6,6,6,6,6,6,6,6,8,6,8,6,8,6,8,6,
9,7,9,7,4,4,4,4,4,4,4,4,4,8,7,4,
3,8,7,7,6,4,6,4,6,6,6,5,6,4,8,7,
8,7,8,7,9,8,7,8,7,8,7,8,7,7,5,7,
5,7,5,6,5,6,5,6,5,6,5,7,4,7,4,7,
4,9,7,9,7,9,7,9,7,9,7,9,7,11,9,8,
6,7,6,7,6,7,6,4,7,9,7,7,7,7,7,7,
6,8,10,7,7,7,6,7,7,6,8,8,10,5,4,8,
7,4,7,13,8,7,8,8,7,11,10,9,7,7,6,5,
7,3,6,8,4,7,9,8,8,8,9,6,7,6,7,7,
6,6,6,7,6,5,7,3,5,4,4,15,13,13,10,10,
7,12,12,11,8,6,4,4,8,7,9,7,9,7,9,7,
9,7,9,7,6,8,6,8,6,10,9,8,6,8,6,8,
7,8,7,8,7,7,6,3,15,13,13,8,6,12,7,8,
7,8,6,10,9,8,7,8,6,8,6,6,6,6,6,4,
4,4,4,8,7,8,7,7,5,7,5,9,7,9,7,6,
5,7,4,7,6,9,7,8,7,7,6,8,6,6,6,8,
7,8,7,8,7,8,7,8,6,6,6,7,7,6,6,7,
7,7,6,8,6,6,7,6,4,7,7,6,6,6,7,7,
7,4,4,4,4,5,4,7,11,11,11,7,7,7,7,9,
9,7,5,5,5,5,5,5,5,7,6,6,3,4,3,3,
4,4,7,6,6,6,9,6,6,6,6,6,6,6,6,6,
6,8,7,7,6,8,3,7,6,7,6,6,10,12,10,9,
7,9,11,8,7,7,7,5,5,2,4,4,4,4,6,4,
3,5,3,3,3,2,2,4,4,5,5,4,4,3,6,4,
4,3,6,4,4,3,3,2,2,4,4,4,4,2,5,4,
2,4,5,4,4,6,5,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,3,3,0,3,3,5,9,
3,9,11,7,9,11,10,4,8,8,6,7,6,7,9,8,
4,8,8,10,8,7,8,8,7,7,7,8,9,8,9,8,
4,8,7,5,7,4,7,7,7,6,7,5,5,7,7,4,
7,7,7,7,7,6,6,5,6,6,7,9,6,9,9,4,
7,6,7,9,7,7,8,12,8,9,8,6,7,7,7,7,
7,7,7,6,8,7,8,7,8,7,8,7,8,7,6,6,
6,6,6,6,6,6,6,6,6,4,8,6,9,7,9,7,
9,7,9,7,9,7,4,4,4,4,8,7,8,7,8,7,
6,4,6,4,6,4,6,4,10,10,10,10,10,10,8,7,
8,7,8,7,8,7,8,7,8,7,8,7,8,7,7,7,
7,7,7,5,7,5,7,5,7,5,6,5,6,5,6,5,
6,5,6,5,7,4,7,4,7,4,7,4,9,7,9,7,
9,7,9,7,9,7,8,6,8,6,11,9,11,9,11,9,
11,9,11,9,8,7,8,7,8,6,7,6,7,6,7,6,
7,4,9,6,6,4,8,6,8,6,8,6,8,6,8,6,
8,6,8,6,8,6,8,6,8,6,8,6,8,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,
4,4,8,7,8,7,8,7,8,7,8,7,8,7,8,7,
8,7,8,7,8,7,8,7,8,7,9,7,9,7,9,8,
9,8,9,8,9,8,9,8,8,6,8,6,8,6,8,6,
7,7,7,7,7,7,7,7,9,9,11,11,10,10,9,9,
5,5,5,5,5,5,9,9,11,11,11,11,7,7,7,7,
7,7,7,7,11,11,13,13,13,13,11,11,4,4,4,4,
4,4,4,4,6,6,9,9,8,8,6,6,6,6,6,6,
6,6,10,10,12,12,11,11,7,7,7,7,7,7,7,7,
11,13,12,11,9,9,9,9,9,9,9,9,10,10,12,13,
11,11,10,10,7,7,5,5,7,7,4,4,6,6,7,7,
9,9,7,7,7,7,7,7,7,7,13,13,15,15,14,14,
13,13,7,7,7,7,7,7,7,7,15,15,17,17,17,17,
15,15,9,9,9,9,9,9,9,9,14,14,16,16,16,16,
14,14,7,7,7,7,7,7,7,8,8,9,9,12,2,4,
2,5,5,7,7,7,7,7,9,9,11,11,12,5,4,2,
4,4,4,4,4,4,4,4,7,7,5,4,2,7,7,7,
7,6,6,7,7,8,8,11,11,9,5,5,3,9,9,9,
9,9,10,9,11,10,12,3,2,6,10,6,10,3,3,2,
6,3,2,1,0,4,4,6,12,5,5,3,6,3,3,6,
3,4,4,4,4,4,4,4,4,3,4,3,3,5,4,4,
4,4,4,4,4,4,4,4,4,3,4,3,3,6,6,6,
6,7,6,12,9,6,6,6,6,13,6,5,2,3,0,0,
0,0,0,0,0,0,8,12,12,4,4,3,5,6,4,4,
3,5,5,4,4,3,5,0,0,0,0,0,0,0,0,0,
0,6,6,6,6,6,6,6,6,6,4,4,4,4,7,7,
7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,
6,6,6,6,4,4,4,7,3,7,7,7,5,5,5,5,
5,7,7,9,6,6,6,6,13,13,10,7,12,11,6,4,
7,7,7,7,7,7,6,6,9,6,7,6,3,6,7,9,
7,6,7,7,7,7,6,7,6,7,6,6,6,4,4,10,
10,7,7,7,7,7,7,7,5,5,5,5,5,5,7,7,
6,9,9,9,9,7,7,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,4,7,7,7,7,7,7,7,7,
8,8,8,6,6,0,5,5,2,2,7,7,9,9,7,7,
12,12,4,4,7,7,7,7,11,9,9,10,10,7,7,13,
13,7,7,16,16,9,9,14,14,7,7,7,7,4,4,7,
7,9,9,0,0,0,0,0,0,0,8,12,6,4,4,8,
7,8,6,8,6,12,8,9,9,8,8,10,9,8,8,7,
7,7,8,9,8,8,8,11,11,9,10,7,7,12,7,6,
6,7,5,7,6,9,6,7,7,7,7,9,7,7,7,7,
6,6,6,9,7,7,7,11,11,8,9,6,6,10,6,5,
4,3,4,8,10,9,7,6,7,6,8,7,8,0,0,0,
15,20,3,0,3,3,7,11,10,4,5,5,7,6,3,5,
3,7,7,7,7,7,7,7,7,7,7,7,3,3,7,7,
7,7,13,9,9,8,9,7,7,9,10,4,5,9,7,12,
10,9,8,9,8,7,8,10,10,13,9,9,8,5,7,5,
7,7,5,7,8,7,8,7,5,7,8,4,4,8,4,11,
8,8,8,8,6,6,5,8,7,11,8,7,7,5,3,5,
7,3,4,7,7,7,7,8,6,11,4,7,7,6,7,5,
6,5,8,9,2,3,4,7,7,9,9,9,9,9,9,12,
8,7,7,7,7,4,4,4,4,10,9,9,9,9,9,9,
10,10,10,10,8,7,7,7,7,7,7,11,7,7,7,7,
7,4,4,4,4,8,8,8,8,8,8,6,8,8,8,8,
8,7,4,12,12,9,4,5,5,5,3,4,4,6,6,8,
7,11,3,3,3,7,7,7,7,7,4,10,16,5,5,9,
9,9,7,4,6,3,5,5,5,5,9,9,9,9,6,9,
8,7,7,8,9,7,9,7,9,7,8,7,8,7,8,7,
8,7,9,10,9,8,7,7,7,7,7,7,7,7,7,7,
9,7,9,7,9,7,9,7,10,8,10,8,4,4,4,4,
4,4,4,4,4,9,8,5,4,9,8,8,7,4,7,4,
7,6,7,6,7,4,10,8,10,8,10,8,10,9,8,9,
8,9,8,9,8,8,6,8,6,8,6,7,6,7,6,7,
6,7,6,8,5,8,5,8,5,10,8,10,8,10,8,10,
8,10,8,10,8,13,11,9,7,8,7,8,7,8,7,5,
8,10,8,8,8,8,8,8,7,9,11,8,8,8,8,8,
8,7,9,9,12,5,4,9,8,5,8,15,10,8,9,9,
8,14,11,10,8,8,7,6,8,4,6,9,5,8,10,9,
10,9,11,7,8,7,8,8,7,7,7,8,7,6,8,3,
6,5,4,17,16,14,12,11,8,14,14,12,9,7,4,4,
9,8,10,8,10,8,10,8,10,8,10,8,7,9,7,9,
7,12,10,9,7,9,7,9,8,9,8,9,8,8,7,4,
17,16,14,9,7,14,8,10,8,9,7,12,10,9,8,9,
7,9,7,7,7,7,7,4,4,4,4,9,8,9,8,8,
6,8,6,10,8,10,8,7,6,8,5,8,6,10,8,9,
8,8,7,9,7,7,7,9,8,9,8,9,8,9,8,9,
7,7,7,8,8,7,7,8,8,7,7,9,6,7,8,7,
4,8,8,7,7,7,8,8,8,4,4,4,5,5,4,9,
11,11,11,8,8,9,8,10,10,9,6,6,6,6,6,5,
5,8,7,6,4,4,4,4,5,5,8,7,7,7,11,7,
7,7,7,7,7,7,7,7,6,10,8,7,7,9,4,7,
7,8,7,7,12,13,12,10,8,10,13,9,8,8,8,6,
6,3,4,4,4,5,7,5,3,6,3,3,3,3,3,5,
5,5,5,5,5,3,7,5,5,3,7,5,5,4,4,3,
3,4,4,4,4,2,5,5,3,4,5,5,5,7,6,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,3,3,0,3,3,6,11,3,11,13,8,11,13,11,4,
9,9,7,9,7,8,10,9,5,9,9,12,10,8,9,9,
8,8,8,9,10,9,10,9,5,9,8,6,8,4,8,8,
8,7,7,6,6,8,8,4,8,8,8,8,7,7,7,6,
7,6,8,10,7,10,11,4,8,7,8,11,8,8,9,13,
9,11,9,7,8,8,8,8,8,8,8,7,9,8,9,8,
9,8,9,8,9,8,7,7,7,7,7,7,7,7,7,7,
7,5,9,7,10,8,10,8,10,8,10,8,10,8,4,4,
4,4,9,8,9,8,9,8,7,4,7,4,7,4,7,4,
12,12,12,12,12,12,10,8,10,8,10,8,10,8,9,8,
9,8,9,8,9,8,8,8,8,8,8,6,8,6,8,6,
8,6,7,6,7,6,7,6,7,6,7,6,8,5,8,5,
8,5,8,5,10,8,10,8,10,8,10,8,10,8,10,7,
10,7,13,11,13,11,13,11,13,11,13,11,9,8,9,8,
9,7,8,7,8,7,8,7,8,5,11,7,7,5,9,7,
9,7,9,7,9,7,9,7,9,7,9,7,9,7,9,7,
9,7,9,7,9,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,4,4,4,4,9,8,9,8,9,8,
9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,
9,8,10,8,10,8,10,9,10,9,10,9,10,9,10,9,
9,7,9,7,9,7,9,7,8,8,8,8,8,8,8,8,
10,10,13,13,12,12,10,10,6,6,6,6,6,6,10,10,
13,13,12,12,8,8,8,8,8,8,8,8,13,13,15,15,
15,15,13,13,4,4,4,4,4,4,4,4,7,7,10,10,
9,9,7,7,7,7,7,7,7,7,11,11,14,14,13,13,
8,8,8,8,8,8,8,8,12,15,14,12,11,11,11,11,
11,11,11,11,12,12,14,14,13,13,12,12,8,8,6,6,
8,8,4,4,7,7,8,8,11,11,8,8,8,8,8,8,
8,8,14,14,17,17,17,17,14,14,8,8,8,8,8,8,
8,8,17,17,20,20,19,19,17,17,11,11,11,11,11,11,
11,11,16,16,19,19,18,18,16,16,8,8,8,8,8,8,
8,9,9,11,11,13,3,4,3,6,6,8,8,8,8,8,
11,11,13,13,14,5,5,3,4,4,4,4,4,4,5,5,
8,8,5,5,3,8,8,8,8,7,7,8,8,9,9,13,
13,11,6,6,3,11,11,11,11,11,12,11,12,11,14,3,
3,7,11,7,11,4,3,2,7,3,2,1,0,5,5,7,
14,6,6,3,7,4,3,7,4,5,5,5,5,5,5,5,
4,4,5,3,3,6,5,5,5,5,5,5,5,5,5,5,
4,4,5,3,3,7,7,7,7,8,7,14,10,7,7,7,
7,14,7,6,2,4,0,0,0,0,0,0,0,0,9,13,
13,5,4,4,6,7,5,4,4,5,5,5,5,3,6,0,
0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,
7,7,4,4,4,4,8,8,8,8,8,8,8,8,8,8,
7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,8,
4,8,8,8,6,6,6,6,6,8,8,11,7,7,7,7,
16,14,11,8,14,12,7,4,8,8,8,8,8,8,7,7,
10,7,8,7,4,7,8,10,8,7,8,8,8,8,7,8,
7,8,7,7,7,4,4,12,12,8,8,8,8,8,8,8,
6,6,6,6,6,6,8,8,7,11,11,11,11,8,8,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,4,
8,8,8,8,8,8,8,8,9,9,9,7,7,0,6,6,
3,3,8,8,10,10,8,8,14,14,4,4,8,8,8,8,
13,11,11,12,12,8,8,14,14,8,8,18,18,11,11,16,
16,8,8,8,8,4,4,8,8,11,11,0,0,0,0,0,
0,0,9,13,7,4,5,9,8,9,7,10,7,13,9,10,
10,9,10,12,10,9,9,8,8,8,10,10,9,9,9,14,
14,11,12,8,8,13,8,7,7,8,6,8,7,11,7,9,
8,8,8,10,9,8,8,8,7,7,7,10,8,8,8,11,
12,9,10,7,7,11,7,6,4,4,4,10,12,11,8,7,
8,7,9,8,9,0,0,0,16,21,4,0,4,4,8,11,
11,4,5,5,7,7,4,5,4,8,8,8,7,8,8,8,
8,8,7,8,4,4,7,7,7,7,13,10,9,9,9,8,
8,9,10,5,5,9,8,13,10,10,8,10,9,8,9,10,
10,14,10,10,8,5,8,5,8,8,5,7,8,7,8,7,
5,7,9,4,4,8,4,12,9,8,8,8,6,6,6,8,
8,11,8,8,7,4,4,4,8,4,4,8,8,8,8,8,
6,12,4,8,8,7,8,6,7,5,8,9,2,4,5,8,
7,10,10,10,10,10,10,12,9,8,8,8,8,5,5,5,
5,10,10,10,10,10,10,10,10,10,10,10,9,7,7,7,
7,7,7,11,7,7,7,7,7,4,4,4,4,9,8,8,
8,8,8,7,8,8,8,8,8,8,4,13,13,10,5,6,
6,6,3,4,4,6,6,8,8,12,4,4,4,7,7,7,
8,8,4,10,17,5,5,9,9,9,8,4,7,4,5,5,
5,5,9,9,9,9,7,10,8,8,8,8,10,7,10,7,
10,7,9,7,9,7,9,7,9,7,9,11,9,8,8,7,
8,7,8,7,8,7,8,7,9,8,9,8,9,8,9,8,
10,9,10,9,5,4,5,4,5,4,5,4,5,10,8,5,
4,9,8,8,8,4,8,4,8,7,8,7,8,4,10,9,
10,9,10,9,11,10,9,10,8,10,8,10,8,9,6,9,
6,9,6,8,6,8,6,8,6,8,6,9,6,9,6,9,
6,10,8,10,8,10,8,10,8,10,8,10,8,14,11,10,
8,8,7,8,7,8,7,5,8,11,9,8,9,8,9,9,
7,9,11,9,8,8,8,9,8,8,9,10,13,6,5,10,
8,5,8,14,10,9,10,10,9,15,12,10,8,9,8,6,
8,4,6,10,6,9,11,10,10,10,11,8,8,7,8,9,
7,7,7,8,7,7,8,4,6,5,4,18,17,15,13,12,
8,15,15,13,10,7,5,4,10,8,10,8,10,8,10,8,
10,8,10,8,7,10,7,10,7,12,11,9,7,9,8,9,
8,10,8,10,8,8,7,4,18,17,15,9,8,15,9,10,
9,10,7,12,11,10,8,10,7,10,7,8,7,8,7,5,
4,5,4,10,8,10,8,9,6,9,6,10,8,10,8,8,
6,9,6,8,7,10,9,9,8,8,7,10,7,8,7,10,
8,10,8,10,8,10,8,10,8,8,8,8,8,7,7,8,
8,8,7,10,7,7,9,8,5,8,8,8,8,8,8,9,
9,4,5,4,5,6,4,9,13,13,12,9,9,9,8,11,
10,9,6,6,6,6,6,6,6,8,8,6,4,5,4,4,
6,5,8,8,8,8,11,8,8,7,7,7,7,8,7,8,
7,10,8,8,8,9,4,8,7,8,8,7,13,14,13,10,
8,11,13,9,9,8,8,6,6,3,4,4,5,5,8,6,
4,6,4,4,4,3,3,5,5,6,6,5,5,3,8,5,
5,3,8,5,5,4,4,3,3,4,4,4,5,2,6,6,
3,4,6,5,5,8,7,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,4,4,0,4,4,6,11,
4,12,14,9,12,14,12,5,10,9,8,9,8,8,10,10,
5,9,10,13,10,8,10,10,8,8,9,9,11,10,11,10,
5,9,8,7,9,5,8,8,8,8,8,7,6,8,8,5,
8,8,8,8,8,8,8,7,8,7,8,11,8,11,11,5,
8,8,8,11,8,8,10,14,10,11,10,7,9,8,9,8,
9,8,9,7,9,8,9,8,9,8,9,8,9,8,8,7,
8,7,8,7,8,7,8,7,8,5,9,8,10,9,10,9,
10,9,10,9,10,9,5,4,5,4,9,8,9,8,9,8,
8,4,8,4,8,4,8,4,13,13,13,13,13,13,10,9,
10,9,10,9,10,9,10,8,10,8,10,8,10,8,8,8,
8,8,9,6,9,6,9,6,9,6,8,6,8,6,8,6,
8,6,8,6,9,6,9,6,9,6,9,6,10,8,10,8,
10,8,10,8,10,8,10,8,10,8,14,11,14,11,14,11,
14,11,14,11,10,8,10,8,10,8,8,7,8,7,8,7,
9,6,11,8,7,5,10,7,10,7,10,7,10,7,10,7,
10,7,10,7,10,7,10,7,10,7,10,7,10,7,8,7,
8,7,8,7,8,7,8,7,8,7,8,7,8,7,5,4,
5,4,10,8,10,8,10,8,10,8,10,8,10,8,10,8,
10,9,10,9,10,9,10,9,10,9,10,8,10,8,11,10,
11,10,11,10,11,10,11,10,10,8,10,8,10,8,10,8,
8,8,8,8,8,8,8,8,11,11,13,14,13,13,11,11,
7,7,7,7,7,7,11,11,14,14,13,13,9,9,9,9,
9,9,9,9,13,13,16,16,16,16,13,13,5,5,5,5,
5,5,5,5,8,8,11,11,10,10,8,8,8,8,8,8,
8,8,12,12,15,15,14,14,8,8,8,8,8,8,8,8,
13,16,15,13,11,11,11,11,11,11,11,11,13,13,15,15,
14,14,13,13,8,8,7,7,9,9,5,5,8,8,8,8,
11,11,8,8,8,8,8,8,8,8,15,15,18,18,18,18,
15,15,9,9,9,9,9,9,9,9,18,18,21,21,20,20,
18,18,11,11,11,11,11,11,11,11,17,17,20,20,20,20,
17,17,8,8,8,8,8,8,8,10,10,11,11,14,3,5,
3,6,6,9,9,9,9,9,11,12,14,14,15,6,5,3,
5,5,5,5,5,5,5,5,8,9,6,5,3,8,8,8,
8,8,8,8,8,9,9,14,14,11,6,6,4,11,11,11,
11,11,13,12,13,12,15,4,3,8,12,8,12,4,3,2,
8,4,2,1,0,5,5,8,15,6,6,4,7,4,4,7,
4,5,5,5,5,5,5,5,5,4,5,4,4,6,5,5,
5,5,5,5,5,5,5,5,5,4,5,4,4,8,8,8,
8,9,8,14,11,8,8,8,8,15,8,7,2,4,0,0,
0,0,0,0,0,0,10,14,14,5,4,4,6,8,5,4,
4,6,6,5,5,3,6,0,0,0,0,0,0,0,0,0,
0,7,7,7,7,7,7,7,7,7,4,4,4,4,9,8,
8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,
7,7,8,8,4,4,4,8,4,9,9,8,6,6,6,6,
6,8,8,11,8,7,7,7,17,15,12,8,15,13,7,4,
8,8,8,8,8,8,7,7,11,8,8,7,4,8,9,11,
8,7,8,8,8,8,8,8,7,8,7,7,8,4,4,13,
13,9,8,8,8,8,8,8,6,6,6,6,6,6,8,8,
8,11,11,11,11,8,8,8,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,4,8,8,8,8,8,9,9,9,
10,10,10,8,8,0,6,6,3,3,8,8,11,11,9,9,
14,14,5,5,9,9,8,8,14,11,11,13,13,8,8,15,
15,9,9,19,19,11,11,17,17,8,8,9,9,5,5,8,
8,11,11,0,0,0,0,0,0,0,9,14,8,5,5,10,
9,9,8,10,8,14,9,10,10,10,10,13,10,10,10,8,
9,9,10,11,10,10,10,13,13,11,12,9,9,14,9,7,
8,8,7,9,7,11,7,9,9,8,9,11,9,8,9,8,
7,8,8,11,8,9,9,13,13,9,11,8,7,12,8,6,
4,4,5,10,12,11,9,7,8,7,10,8,9,0,0,0,
17,22,4,0,4,4,8,12,11,4,5,5,8,7,4,6,
4,8,8,8,8,8,8,8,8,8,8,8,4,4,7,7,
7,8,14,10,9,9,10,8,8,10,11,5,5,10,8,14,
11,10,9,10,10,8,9,11,11,14,10,10,9,5,8,5,
8,8,5,8,9,7,9,8,5,8,9,5,4,9,5,12,
9,9,9,9,7,7,6,9,8,12,9,8,8,6,4,5,
8,4,5,8,8,8,8,8,7,12,4,8,8,7,8,6,
7,5,9,10,2,4,5,8,8,10,10,10,10,10,10,13,
9,8,8,8,8,5,5,5,5,11,10,10,10,10,10,10,
11,11,11,11,10,8,8,8,8,8,8,12,7,8,8,8,
8,5,5,5,5,9,9,9,9,9,9,7,9,9,9,9,
9,8,5,14,13,10,5,6,6,6,3,4,4,7,6,9,
8,13,4,4,4,7,7,8,8,8,5,11,17,5,5,10,
10,10,8,5,7,4,6,6,6,6,10,10,10,10,7,10,
9,8,8,9,10,8,10,8,10,8,9,7,9,7,9,7,
9,7,10,11,10,9,8,8,8,8,8,8,8,8,8,8,
10,8,10,8,10,8,10,8,11,9,11,9,5,5,5,5,
5,5,5,5,5,10,9,5,4,10,9,9,8,5,8,5,
8,7,8,7,8,5,11,9,11,9,11,9,12,10,9,10,
9,10,9,10,9,10,7,10,7,10,7,8,7,8,7,8,
7,8,7,9,6,9,6,9,6,11,9,11,9,11,9,11,
9,11,9,11,9,14,12,10,8,9,8,9,8,9,8,5,
9,11,9,9,9,9,9,9,7,10,12,9,9,8,9,9,
9,8,10,10,14,6,5,10,9,5,9,17,11,9,10,10,
9,15,12,11,9,9,8,7,9,4,7,10,6,9,12,10,
11,10,12,8,9,8,9,9,8,8,7,9,8,7,9,4,
7,5,5,19,18,16,13,13,9,16,15,14,10,8,5,5,
10,9,11,9,11,9,11,9,11,9,11,9,8,10,8,10,
8,13,12,10,8,10,8,10,9,10,9,10,9,9,8,4,
19,18,16,10,8,16,9,11,9,10,8,13,12,10,9,10,
8,10,8,8,8,8,8,5,5,5,5,10,9,10,9,10,
7,10,7,11,9,11,9,8,7,9,6,9,7,11,9,10,
9,9,8,10,8,8,8,10,9,10,9,10,9,10,9,10,
8,8,8,9,9,8,7,9,9,8,8,10,7,7,9,8,
5,9,9,8,8,8,9,9,9,5,5,5,6,6,5,10,
13,13,12,9,9,10,9,11,11,9,7,6,6,7,7,6,
6,9,8,7,4,5,4,4,6,6,9,8,8,8,12,8,
8,8,8,8,8,8,8,8,7,11,9,8,8,10,4,8,
7,9,8,8,14,15,14,11,8,12,14,10,9,9,9,7,
7,3,5,5,5,6,8,6,4,7,4,4,4,3,3,5,
5,6,6,5,5,3,8,5,5,3,8,5,5,4,4,3,
3,5,5,5,5,2,6,6,3,5,6,5,5,8,7,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,4,4,0,4,4,7,12,4,12,15,9,12,15,13,5,
10,9,8,10,8,9,11,11,5,10,10,14,11,9,10,11,
9,9,9,10,11,10,12,11,5,10,9,7,9,5,9,9,
9,8,8,7,7,9,8,5,9,9,9,9,8,8,8,7,
8,7,9,11,8,11,12,5,9,8,9,12,9,9,11,15,
11,12,10,8,9,9,9,9,9,9,9,7,10,9,10,9,
10,9,10,9,10,9,8,8,8,8,8,8,8,8,8,8,
8,5,10,8,11,9,11,9,11,9,11,9,11,9,5,5,
5,5,10,9,10,9,10,9,8,5,8,5,8,5,8,5,
14,14,14,14,14,14,11,9,11,9,11,9,11,9,10,9,
10,9,10,9,10,9,9,9,9,9,10,7,10,7,10,7,
10,7,8,7,8,7,8,7,8,7,8,7,9,6,9,6,
9,6,9,6,11,9,11,9,11,9,11,9,11,9,11,8,
11,8,14,12,14,12,14,12,14,12,14,12,10,9,10,9,
10,8,9,8,9,8,9,8,9,6,12,8,8,5,10,8,
10,8,10,8,10,8,10,8,10,8,10,8,10,8,10,8,
10,8,10,8,10,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,5,5,5,5,10,9,10,9,10,9,
10,9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,
10,9,11,9,11,9,12,10,12,10,12,10,12,10,12,10,
10,8,10,8,10,8,10,8,9,9,9,9,9,9,9,9,
11,11,14,14,14,14,11,11,7,7,7,7,7,7,12,12,
14,15,14,14,9,9,9,9,9,9,9,9,14,14,17,17,
17,17,14,14,5,5,5,5,5,5,5,5,8,8,11,11,
11,11,8,8,8,8,8,8,8,8,13,13,16,16,14,14,
9,9,9,9,9,9,9,9,14,17,16,14,12,12,12,12,
12,12,12,12,13,13,16,16,15,15,13,13,9,9,7,7,
9,9,5,5,8,8,9,9,12,12,9,9,9,9,9,9,
9,9,16,16,19,19,19,19,16,16,9,9,9,9,9,9,
9,9,19,19,22,22,22,22,19,19,12,12,12,12,12,12,
12,12,18,18,21,21,21,21,18,18,9,9,9,9,9,9,
9,10,10,12,12,15,3,5,3,7,7,9,9,9,9,9,
12,12,15,15,16,6,5,3,5,5,5,5,5,5,5,5,
9,9,6,5,3,9,9,9,9,8,8,9,9,10,10,15,
15,12,7,7,4,12,12,12,12,12,14,12,14,13,16,4,
3,8,13,8,13,4,3,2,8,4,2,1,0,6,6,8,
16,7,7,4,7,4,4,8,4,6,6,6,6,6,6,6,
5,4,5,4,4,7,6,6,6,6,6,6,6,6,6,6,
5,4,5,4,4,8,8,8,8,9,8,15,12,8,8,8,
8,16,8,7,2,4,0,0,0,0,0,0,0,0,11,15,
15,5,5,4,7,8,5,5,4,6,6,5,5,3,7,0,
0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,
8,8,5,5,5,5,9,9,9,9,9,9,9,9,9,9,
8,8,8,7,7,7,7,8,8,8,8,8,5,5,5,9,
4,9,9,9,7,7,7,7,7,9,9,12,8,8,8,8,
18,16,13,9,15,14,8,5,9,9,9,9,9,9,8,8,
12,8,9,8,4,8,9,12,9,8,9,9,9,9,8,9,
7,9,8,8,8,5,5,14,14,9,9,9,9,9,9,9,
7,7,7,7,7,7,9,9,8,12,12,12,12,9,9,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,
9,9,9,9,9,9,9,9,10,10,10,8,8,0,7,7,
3,3,9,9,11,11,9,9,15,15,5,5,9,9,9,9,
14,12,12,13,13,9,9,16,16,9,9,20,20,12,12,18,
18,9,9,9,9,5,5,9,9,12,12,0,0,0,0,0,
0,0,10,15,8,5,5,10,9,9,8,11,8,15,9,11,
11,10,11,14,11,10,11,9,9,9,11,11,10,11,11,15,
15,12,13,9,9,15,10,8,8,9,7,9,8,12,7,10,
9,9,9,11,10,9,9,9,7,8,8,12,9,10,9,13,
13,10,12,8,8,13,8,7,5,4,5,11,13,12,9,8,
9,8,10,9,10,0,0,0,19,25,4,0,4,4,9,13,
12,5,6,6,8,8,4,6,4,9,9,9,8,9,9,9,
9,9,9,9,4,4,8,8,8,8,16,11,10,10,11,9,
9,11,12,6,6,11,9,15,12,11,10,11,11,9,10,12,
12,16,12,11,10,6,9,5,9,9,6,9,10,8,10,9,
6,10,10,5,5,10,5,15,10,10,10,10,8,7,7,10,
9,13,10,9,8,6,4,6,9,4,5,9,9,9,9,9,
7,14,5,9,9,8,9,7,8,6,10,10,3,4,5,9,
8,11,11,11,11,11,11,15,10,9,9,9,9,6,6,6,
6,12,11,11,11,11,11,11,12,12,12,12,11,9,9,9,
9,9,9,13,8,9,9,9,9,5,5,5,5,10,10,10,
10,10,10,8,10,10,10,10,10,9,5,15,15,11,6,7,
7,7,4,5,5,8,7,10,9,15,4,4,4,8,8,9,
9,9,5,13,19,6,6,11,11,11,9,5,8,4,6,6,
6,6,11,11,11,11,8,11,10,9,9,10,11,9,11,9,
11,9,10,8,10,8,10,8,10,8,11,13,11,10,9,9,
9,9,9,9,9,9,9,9,11,9,11,9,11,9,11,9,
12,10,12,10,6,5,6,5,6,5,6,5,6,11,10,6,
5,11,10,10,9,5,9,5,9,8,9,8,9,5,12,10,
12,10,12,10,13,11,10,11,10,11,10,11,10,11,8,11,
8,11,8,9,7,9,7,9,7,9,7,10,7,10,7,10,
7,12,10,12,10,12,10,12,10,12,10,12,10,16,13,11,
9,10,8,10,8,10,8,6,10,12,10,10,10,10,10,10,
8,11,13,10,10,9,9,10,10,9,11,11,15,7,6,12,
10,6,10,17,12,10,11,11,10,17,14,12,10,10,9,7,
10,5,7,11,7,10,13,12,12,12,13,9,10,8,10,10,
9,9,8,10,8,8,10,4,7,6,5,21,20,18,15,14,
10,18,17,15,11,9,6,5,11,10,12,10,12,10,12,10,
12,10,12,10,9,11,9,11,9,15,13,11,10,11,9,11,
10,11,10,11,10,10,9,5,21,20,18,11,9,17,10,12,
10,11,9,15,13,11,10,11,9,11,9,9,9,9,9,6,
5,6,5,11,10,11,10,11,8,11,8,12,10,12,10,9,
7,10,7,10,8,12,10,11,10,10,8,11,9,9,9,11,
10,11,10,11,10,11,10,11,9,9,10,10,10,9,8,10,
10,9,9,11,8,8,11,9,6,10,10,9,9,9,10,10,
10,5,5,5,6,7,5,11,15,15,14,10,11,11,10,13,
12,9,8,8,7,8,8,7,7,10,9,7,5,6,5,4,
7,6,10,9,9,9,13,9,9,9,8,9,9,9,8,9,
8,12,9,9,9,11,5,10,8,10,9,8,15,16,15,12,
9,13,16,11,10,10,10,7,7,3,5,5,6,6,9,7,
4,7,4,4,4,4,4,6,6,7,7,6,6,4,9,6,
6,4,9,6,6,5,5,4,4,5,5,5,6,2,7,7,
4,5,7,6,6,9,8,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,4,4,0,4,4,8,13,
4,14,17,10,14,16,14,6,11,10,9,11,9,10,12,12,
6,11,11,15,12,10,11,12,10,10,10,11,12,12,13,12,
6,11,10,8,10,6,10,10,9,9,9,8,8,9,9,6,
10,10,10,10,9,9,9,8,9,8,10,12,9,12,13,6,
10,9,10,13,9,9,12,17,12,13,11,9,10,10,10,10,
10,10,10,8,11,10,11,10,11,10,11,10,11,10,9,9,
9,9,9,9,9,9,9,9,9,6,11,9,12,10,12,10,
12,10,12,10,12,10,6,5,6,5,11,10,11,10,11,10,
9,5,9,5,9,5,9,5,15,15,15,15,15,15,12,10,
12,10,12,10,12,10,11,10,11,10,11,10,11,10,10,10,
10,10,11,8,11,8,11,8,11,8,9,7,9,7,9,7,
9,7,9,7,10,7,10,7,10,7,10,7,12,10,12,10,
12,10,12,10,12,10,12,9,12,9,16,13,16,13,16,13,
16,13,16,13,12,10,12,10,11,9,10,8,10,8,10,8,
10,7,13,9,9,6,11,9,11,9,11,9,11,9,11,9,
11,9,11,9,11,9,11,9,11,9,11,9,11,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,6,5,
6,5,11,10,11,10,11,10,11,10,11,10,11,10,11,10,
11,10,11,10,11,10,11,10,11,10,12,10,12,10,13,12,
13,12,13,12,13,12,13,12,11,9,11,9,11,9,11,9,
10,10,10,10,10,10,10,10,13,13,16,16,15,15,13,13,
8,8,8,8,8,8,13,13,16,16,16,16,10,10,10,10,
10,10,10,10,16,16,19,19,19,19,16,16,6,6,6,6,
6,6,6,6,9,9,13,13,12,12,9,9,9,9,9,9,
9,9,14,14,18,18,16,16,10,10,10,10,10,10,10,10,
16,19,18,16,13,13,13,13,13,13,13,13,15,15,18,18,
17,17,15,15,10,10,8,8,10,10,6,6,9,9,10,10,
13,13,10,10,10,10,10,10,10,10,18,18,21,22,21,21,
18,18,10,10,10,10,10,10,10,10,22,22,25,25,24,24,
22,22,13,13,13,13,13,13,13,13,21,21,24,24,23,23,
21,21,10,10,10,10,10,10,10,11,11,13,13,17,4,6,
4,8,8,10,10,10,10,10,14,14,17,17,18,7,6,4,
6,6,6,6,6,6,6,6,10,10,7,6,4,10,10,10,
10,9,9,10,10,11,11,16,16,13,8,8,4,13,13,13,
13,13,15,14,16,14,18,4,4,9,15,9,15,5,4,2,
9,4,3,1,0,6,6,9,18,8,7,4,8,5,4,9,
5,6,6,6,6,6,6,6,5,4,6,4,4,7,6,6,
6,6,6,6,6,6,6,6,5,4,6,4,4,9,9,9,
9,10,9,17,13,9,9,9,9,18,9,8,3,5,0,0,
0,0,0,0,0,0,12,17,17,6,5,5,7,9,6,5,
5,7,7,6,6,4,8,0,0,0,0,0,0,0,0,0,
0,9,9,9,9,9,9,9,9,9,5,5,5,5,10,10,
10,10,10,10,10,10,10,10,9,9,9,8,8,8,8,9,
9,9,9,9,5,5,5,10,5,10,10,10,8,8,7,7,
7,10,10,13,9,8,8,8,20,18,14,10,17,15,9,5,
10,10,10,10,10,10,9,9,13,9,10,9,5,9,10,13,
10,9,10,10,10,10,9,10,8,10,9,9,9,5,5,15,
15,10,10,10,10,10,10,10,8,8,7,7,7,7,10,10,
9,13,13,13,13,10,10,9,8,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,5,10,10,10,10,10,10,10,10,
12,12,12,9,9,0,8,8,4,4,10,10,13,13,10,10,
17,17,6,6,10,10,10,10,16,13,13,15,15,10,10,18,
18,10,10,23,23,13,13,21,21,10,10,10,10,6,6,10,
10,13,13,0,0,0,0,0,0,0,11,17,9,6,6,11,
10,10,9,12,9,17,10,12,12,12,12,15,12,11,12,10,
10,10,12,12,12,12,12,15,15,14,14,10,10,16,11,9,
9,9,8,10,9,14,9,11,10,10,10,13,11,10,11,10,
8,9,9,13,10,11,10,15,15,11,13,9,9,14,9,7,
5,5,6,12,15,13,10,9,10,9,11,10,11,0,0,0,
21,28,5,0,5,5,10,15,15,5,7,7,9,9,5,7,
5,10,10,10,10,10,10,10,10,10,11,10,5,5,9,9,
9,9,18,13,11,11,12,10,10,12,14,6,6,12,10,17,
14,13,11,13,12,10,12,14,14,18,13,12,11,6,10,6,
10,10,7,10,11,9,11,10,7,11,12,6,5,11,6,18,
12,11,11,11,8,8,7,11,10,15,11,10,9,8,5,8,
10,5,6,10,10,10,10,10,8,15,5,10,10,8,10,8,
9,7,12,12,3,5,6,10,9,13,13,13,13,13,13,16,
11,10,10,10,10,6,6,6,6,14,13,13,13,13,13,13,
14,14,14,14,12,10,10,10,10,10,10,15,9,10,10,10,
10,6,6,6,6,12,11,11,11,11,11,9,11,11,11,11,
11,10,6,17,17,12,6,8,8,7,4,5,5,8,8,11,
10,16,5,5,5,9,9,9,10,10,6,14,22,6,6,12,
12,12,10,6,9,5,7,7,7,7,12,12,12,12,9,12,
11,10,10,11,13,10,13,10,13,10,11,9,11,9,11,9,
11,9,12,14,12,11,10,10,10,10,10,10,10,10,10,10,
12,10,12,10,12,10,12,10,14,12,14,12,6,6,6,6,
6,6,6,6,6,13,11,6,5,12,11,11,10,6,10,6,
10,9,10,9,10,6,14,12,14,12,14,12,14,13,11,13,
11,13,11,13,11,12,8,12,8,12,8,10,8,10,8,10,
8,10,8,12,7,12,7,12,7,14,11,14,11,14,11,14,
11,14,11,14,11,18,15,12,10,11,9,11,9,11,9,7,
11,14,12,11,12,11,11,11,9,12,15,12,11,10,10,12,
11,10,12,13,17,7,6,13,11,7,11,20,14,11,13,13,
11,19,16,14,11,12,10,8,11,5,8,13,7,12,14,13,
13,13,15,10,11,9,11,11,9,9,9,11,9,9,11,5,
8,6,6,23,22,20,16,15,11,20,19,17,13,10,6,6,
13,11,14,11,14,11,14,11,14,11,14,11,10,13,10,13,
10,16,15,12,11,12,10,12,11,13,11,13,11,11,9,5,
23,22,20,12,10,20,11,14,12,13,10,16,15,13,11,13,
10,13,10,10,10,10,10,6,6,6,6,13,11,13,11,12,
8,12,8,14,11,14,11,10,8,12,7,11,9,14,12,12,
11,11,9,13,10,10,10,13,11,13,11,13,11,13,11,12,
10,10,11,11,11,9,9,11,11,10,10,13,9,9,12,10,
6,11,11,10,10,10,11,12,11,6,6,6,7,8,6,12,
18,18,18,11,12,12,11,14,14,12,8,9,8,8,8,8,
8,11,10,9,5,6,5,5,7,7,11,10,10,10,15,10,
10,9,9,9,9,10,10,10,9,13,11,10,10,12,5,11,
9,11,10,10,17,19,17,14,10,14,18,12,11,11,11,8,
8,4,6,6,6,7,10,7,5,8,5,5,5,4,4,6,
6,8,8,7,7,4,10,7,7,4,10,7,7,5,5,4,
4,6,6,6,6,3,8,7,4,6,7,6,7,10,9,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,5,5,0,5,5,8,15,5,15,18,11,15,18,16,6,
13,11,10,12,10,11,14,13,7,12,13,17,14,11,13,13,
11,11,12,12,14,13,15,13,7,12,11,9,11,6,11,11,
12,10,10,9,8,12,10,6,11,11,12,11,10,10,10,9,
10,9,11,14,10,14,15,6,11,10,11,15,11,11,13,19,
13,15,13,10,12,11,12,11,12,11,11,9,12,11,12,11,
12,11,12,11,12,11,10,10,10,10,10,10,10,10,10,10,
10,7,12,10,14,12,14,12,14,12,14,12,14,12,6,6,
6,6,12,11,12,11,12,11,10,6,10,6,10,6,10,6,
17,17,17,17,17,17,14,12,14,12,14,12,14,12,13,11,
13,11,13,11,13,11,11,11,11,11,12,8,12,8,12,8,
12,8,10,8,10,8,10,8,10,8,10,8,12,7,12,7,
12,7,12,7,14,11,14,11,14,11,14,11,14,11,14,10,
14,10,18,15,18,15,18,15,18,15,18,15,13,11,13,11,
12,10,11,9,11,9,11,9,12,7,15,10,10,7,13,10,
13,10,13,10,13,10,13,10,13,10,13,10,13,10,13,10,
13,10,13,10,13,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,6,6,6,6,13,11,13,11,13,11,
13,11,13,11,13,11,13,11,13,11,13,11,13,11,13,11,
13,11,14,11,14,11,14,13,14,13,14,13,14,13,14,13,
12,10,12,10,12,10,12,10,11,11,11,11,11,11,11,11,
14,14,18,18,17,17,14,14,9,9,9,9,9,9,14,14,
18,18,17,17,11,11,11,11,11,11,11,11,18,18,21,21,
21,21,18,18,6,6,6,6,6,6,6,6,10,10,14,14,
13,13,10,10,10,10,10,10,10,10,16,16,19,20,18,18,
11,11,11,11,11,11,11,11,17,21,20,17,15,15,15,15,
15,15,15,15,17,17,20,20,18,18,17,17,11,11,9,9,
11,11,6,6,10,10,11,11,15,15,11,11,11,11,11,11,
11,11,20,20,24,24,23,23,20,20,11,11,11,11,11,11,
11,11,24,24,27,28,27,27,24,24,15,15,15,15,15,15,
15,15,23,23,26,26,26,26,23,23,11,11,11,11,11,11,
11,13,13,15,15,19,4,6,4,8,8,11,11,11,11,11,
15,15,18,18,20,7,7,4,6,6,6,6,6,6,7,7,
11,11,8,7,4,11,11,11,11,10,10,11,11,12,12,18,
18,15,8,8,5,15,15,15,15,15,17,15,17,16,19,5,
4,10,16,10,16,5,4,3,10,5,3,1,0,7,7,10,
20,9,8,5,9,5,5,9,5,7,7,7,7,7,7,7,
6,5,6,5,5,8,7,7,7,7,7,7,7,7,7,7,
6,5,6,5,5,10,10,10,10,11,10,19,14,10,10,10,
10,20,10,9,3,5,0,0,0,0,0,0,0,0,13,19,
19,7,6,5,8,10,7,6,5,8,8,7,7,4,8,0,
0,0,0,0,0,0,0,0,0,10,10,10,10,10,10,10,
10,10,6,6,6,6,12,11,11,11,11,11,11,11,11,11,
10,10,10,9,9,9,9,10,10,10,10,10,6,6,6,11,
5,12,12,11,8,8,8,8,8,11,11,15,10,9,9,9,
22,20,15,11,19,17,10,6,11,11,11,11,11,11,10,10,
15,10,11,9,5,10,12,15,11,10,11,11,11,11,10,11,
9,11,10,10,10,6,6,17,17,12,11,11,11,11,11,11,
8,8,8,8,8,8,11,11,10,15,15,15,15,11,11,10,
9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,6,
11,11,11,11,11,11,11,11,13,13,13,10,10,0,8,8,
4,4,11,11,14,14,11,11,19,19,6,6,12,12,11,11,
18,15,15,17,17,11,11,20,20,11,11,25,25,15,15,23,
23,11,11,11,11,6,6,11,11,15,15,0,0,0,0,0,
0,0,12,19,10,6,6,13,12,11,10,13,10,19,12,14,
14,13,13,17,14,13,13,11,11,12,14,14,13,13,13,18,
18,15,16,12,11,19,12,10,10,10,9,11,10,15,9,12,
11,11,11,14,12,11,12,11,9,10,10,15,11,12,11,16,
16,12,14,10,10,16,10,8,6,5,6,13,16,15,12,10,
11,9,13,11,12,0,0,0,24,31,5,0,5,5,11,17,
16,6,8,8,11,10,6,8,6,11,11,11,12,11,12,11,
11,11,12,11,6,6,11,11,11,10,20,14,13,13,14,12,
11,14,16,7,7,14,11,19,16,14,13,14,13,11,13,16,
16,20,15,14,13,7,11,8,12,11,8,11,12,10,12,11,
7,12,13,7,6,12,7,20,13,12,13,12,10,9,8,13,
12,17,12,12,11,8,6,8,12,5,7,11,11,11,11,11,
9,17,6,12,11,9,12,9,10,8,13,14,4,6,7,12,
10,14,14,14,14,14,14,19,13,12,12,12,12,7,7,7,
7,16,14,14,14,14,14,14,16,16,16,16,14,11,11,11,
11,11,11,17,10,11,11,11,11,7,7,7,7,13,12,12,
12,12,12,10,12,13,13,13,13,12,7,19,19,14,7,9,
9,9,5,6,6,10,9,13,11,18,6,6,6,10,10,11,
11,11,7,15,25,7,7,13,14,14,11,7,10,6,8,8,
8,8,14,14,14,14,10,14,13,12,12,13,14,11,14,11,
14,11,13,10,13,10,13,10,13,10,14,16,14,12,12,11,
12,11,12,11,12,11,12,11,14,12,14,12,14,12,14,12,
16,13,16,13,7,7,7,7,7,7,7,7,7,14,13,7,
6,14,12,12,11,7,11,7,11,10,11,10,11,7,16,13,
16,13,16,13,16,14,13,14,12,14,12,14,12,13,10,13,
10,13,10,11,9,11,9,11,9,11,9,13,8,13,8,13,
8,16,13,16,13,16,13,16,13,16,13,16,13,20,17,14,
12,13,11,13,11,13,11,7,12,15,13,12,13,12,13,13,
10,14,17,13,12,12,12,13,12,11,14,14,19,8,7,15,
12,8,13,24,16,13,14,14,13,22,18,15,12,13,11,9,
12,6,9,14,8,13,16,15,15,15,17,12,13,11,13,13,
11,11,10,12,11,10,12,5,9,7,7,27,25,23,19,18,
13,23,22,19,14,11,7,7,14,12,16,13,16,13,16,13,
16,13,16,13,11,14,11,14,11,19,17,14,12,14,12,14,
12,14,12,14,12,13,11,6,27,25,23,14,12,22,13,16,
13,14,11,19,17,14,12,14,11,14,11,12,11,12,11,7,
7,7,7,14,12,14,12,13,10,13,10,16,13,16,13,11,
9,13,8,12,10,16,13,13,12,13,11,14,11,12,11,14,
12,14,12,14,12,14,12,14,12,11,12,12,12,11,10,12,
12,11,11,14,10,10,13,11,7,12,12,12,12,12,13,13,
13,7,7,7,8,9,7,14,20,20,20,13,13,14,12,16,
16,14,10,10,9,10,10,9,9,12,12,9,6,7,6,6,
8,8,13,11,12,12,17,12,12,11,11,11,11,11,11,11,
10,15,12,11,12,14,6,12,10,12,11,11,19,21,19,15,
11,16,20,14,13,12,13,9,9,4,7,7,7,8,12,8,
5,9,5,5,5,5,5,7,7,9,9,8,8,5,12,8,
8,5,12,8,8,6,6,5,5,7,7,7,7,3,9,8,
5,7,8,7,8,12,10,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,5,5,0,6,5,9,17,
6,17,21,13,17,21,18,7,14,13,11,14,12,13,16,15,
8,14,14,19,16,12,14,15,13,12,13,14,16,15,16,15,
8,14,13,10,13,7,12,13,13,11,12,10,10,13,12,7,
12,13,13,12,11,12,11,10,11,10,12,16,12,16,17,7,
12,12,12,17,12,12,15,22,15,16,14,11,13,12,13,12,
13,12,13,10,14,12,14,12,14,12,14,12,14,12,12,11,
12,11,12,11,12,11,12,11,11,7,14,12,16,13,16,13,
16,13,16,13,16,13,7,7,7,7,14,12,14,12,14,12,
11,7,11,7,11,7,11,7,19,19,19,19,19,19,16,13,
16,13,16,13,16,13,14,12,14,12,14,12,14,12,13,13,
13,13,13,10,13,10,13,10,13,10,11,9,11,9,11,9,
11,9,11,9,13,8,13,8,13,8,13,8,16,13,16,13,
16,13,16,13,16,13,16,12,16,12,20,17,20,17,20,17,
20,17,20,17,15,12,15,12,14,12,13,11,13,11,13,11,
13,8,17,12,11,7,14,11,14,11,14,11,14,11,14,11,
14,11,14,11,14,11,14,11,14,11,14,11,14,11,12,11,
12,11,12,11,12,11,12,11,12,11,12,11,12,11,7,7,
7,7,14,12,14,12,14,12,14,12,14,12,14,12,14,12,
14,13,14,13,14,13,14,13,14,13,16,13,16,13,16,15,
16,15,16,15,16,15,16,15,14,12,14,12,14,12,14,12,
13,13,13,13,13,13,13,13,16,16,20,20,19,19,16,16,
10,10,10,10,10,10,16,16,20,21,20,20,13,13,13,13,
13,13,13,13,20,20,24,24,23,23,20,20,7,7,7,7,
7,7,7,7,12,12,16,16,15,15,12,12,12,12,12,12,
12,12,18,18,22,22,20,20,12,12,12,12,12,12,12,12,
20,24,23,20,17,17,17,17,17,17,17,17,19,19,23,23,
21,21,19,19,13,13,10,10,13,13,7,7,12,12,12,12,
17,17,13,13,13,13,13,13,13,13,23,23,27,27,26,26,
23,23,13,13,13,13,13,13,13,13,27,27,31,31,31,31,
27,27,17,17,17,17,17,17,17,17,26,26,30,30,29,29,
26,26,13,13,13,13,13,13,13,14,14,17,17,21,4,7,
4,10,10,13,13,13,13,13,17,17,21,21,23,8,8,4,
7,7,7,7,7,7,8,8,13,13,9,8,4,12,12,12,
12,11,11,12,12,14,14,20,21,17,9,9,5,17,17,17,
17,17,19,17,20,18,22,5,4,11,18,11,18,6,5,3,
11,6,4,1,0,8,8,11,23,10,9,6,10,6,6,11,
6,8,8,8,8,8,8,8,7,6,7,5,5,9,8,8,
8,8,8,8,8,8,8,8,7,6,7,5,5,11,11,11,
11,13,11,21,16,11,11,11,11,22,11,10,4,6,0,0,
0,0,0,0,0,0,15,21,21,8,7,6,9,12,8,7,
6,9,9,8,8,5,10,0,0,0,0,0,0,0,0,0,
0,11,11,11,11,11,11,11,11,11,7,7,7,7,13,12,
12,12,12,12,13,13,13,13,12,12,11,10,10,10,10,11,
11,11,12,12,7,7,7,13,6,13,13,12,10,10,9,9,
9,13,13,17,12,11,11,11,25,23,18,13,22,19,11,7,
12,13,13,13,13,13,11,11,17,12,12,11,6,12,13,17,
12,11,12,12,12,12,12,12,10,12,11,11,12,7,7,19,
19,13,12,12,12,12,13,13,10,10,9,9,9,9,13,13,
12,17,17,17,17,12,12,12,11,11,11,11,11,11,11,11,
11,11,11,11,11,11,11,7,12,12,12,12,12,13,13,13,
15,15,15,12,12,0,10,10,4,4,13,13,16,16,13,13,
22,22,7,7,13,13,12,12,20,17,17,19,19,13,13,23,
23,13,13,29,29,17,17,26,26,13,13,13,13,7,7,12,
12,17,17,0,0,0,0,0,0,0,14,21,11,7,7,14,
13,13,11,16,12,21,13,16,16,15,16,19,16,14,15,13,
13,13,16,16,15,15,15,21,21,17,19,13,13,21,13,11,
12,12,10,13,11,17,10,14,13,12,13,16,14,12,13,13,
10,12,12,16,12,13,13,18,18,14,16,11,11,18,12,9,
7,6,7,15,19,17,13,11,13,11,14,12,14,0,0,0,
27,35,6,0,6,6,12,19,18,7,9,9,12,11,6,9,
6,13,13,13,13,13,13,13,13,13,13,13,6,6,12,12,
12,12,22,16,14,14,16,13,13,16,18,8,8,16,13,22,
18,16,14,16,15,13,15,18,18,23,17,16,14,8,13,9,
13,13,9,12,14,12,14,12,8,13,15,7,7,14,7,21,
15,14,14,14,11,10,9,14,13,19,14,13,12,9,6,9,
13,6,7,13,13,13,13,13,11,19,7,13,13,10,13,10,
11,9,14,15,4,6,8,13,12,16,16,16,16,16,16,21,
14,13,13,13,13,8,8,8,8,18,16,16,16,16,16,16,
18,18,18,18,15,12,12,12,12,12,12,19,12,12,12,12,
12,7,7,7,7,15,14,14,14,14,14,11,14,14,14,14,
14,13,7,22,21,16,8,10,10,10,5,7,7,11,10,14,
13,21,6,6,6,12,12,12,13,13,8,18,27,8,8,16,
16,16,13,7,11,6,9,9,9,9,16,16,16,16,11,16,
14,13,13,14,16,12,16,12,16,12,14,12,14,12,14,12,
14,12,16,18,16,14,13,12,13,12,13,12,13,12,13,12,
16,13,16,13,16,13,16,13,18,15,18,15,8,7,8,7,
8,7,8,7,8,16,14,8,7,16,14,14,13,7,13,7,
13,12,13,11,13,7,18,15,18,15,18,15,18,16,15,16,
14,16,14,16,14,15,11,15,11,15,11,13,10,13,10,13,
10,13,10,15,9,15,9,15,9,18,14,18,14,18,14,18,
14,18,14,18,14,23,19,16,13,14,12,14,12,14,12,8,
14,17,15,14,15,14,14,14,12,16,19,15,14,13,14,15,
14,13,16,16,22,9,8,17,14,9,14,25,18,15,16,16,
15,25,20,17,14,15,13,10,14,7,10,16,9,15,18,17,
17,17,19,13,14,12,14,14,12,12,12,14,12,11,14,6,
10,8,7,30,28,26,21,20,14,26,25,22,16,12,8,7,
16,14,18,14,18,14,18,14,18,14,18,14,12,16,12,16,
12,21,19,16,13,16,13,16,14,16,14,16,14,14,12,7,
30,28,26,16,13,25,15,18,15,16,12,21,19,16,14,16,
12,16,12,13,12,13,12,8,7,8,7,16,14,16,14,15,
11,15,11,18,14,18,14,13,10,15,9,14,12,18,15,15,
14,14,12,16,12,13,12,16,14,16,14,16,14,16,14,16,
13,13,13,14,14,12,12,14,14,12,12,16,12,11,15,12,
8,14,14,13,13,13,14,15,15,7,8,8,9,10,7,15,
20,20,21,15,15,15,14,18,17,14,11,10,9,11,11,10,
10,14,13,10,7,8,7,7,9,9,14,13,13,13,19,13,
13,12,12,12,12,12,12,12,12,17,13,13,13,16,7,13,
12,14,12,12,22,23,22,17,13,18,23,16,15,14,14,10,
10,5,7,7,8,9,13,9,6,10,6,6,6,5,5,8,
8,10,10,8,8,6,13,9,9,6,13,9,9,7,7,5,
5,7,7,7,8,4,10,9,5,7,10,8,8,13,11,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,6,6,0,6,6,11,19,6,19,24,14,20,23,20,8,
16,14,13,15,13,14,18,17,9,16,16,22,18,14,16,17,
14,14,15,16,17,17,19,17,9,16,14,11,14,8,14,14,
14,13,13,11,11,14,13,8,14,14,14,14,12,13,13,11,
13,12,14,17,13,18,19,8,14,13,14,19,13,13,17,24,
17,18,16,12,15,14,15,14,15,14,14,12,16,14,16,14,
16,14,16,14,16,14,13,12,13,12,13,12,13,12,13,12,
13,8,16,13,18,15,18,15,18,15,18,15,18,15,8,7,
8,7,16,14,16,14,16,14,13,7,13,7,13,7,13,7,
22,22,22,22,22,22,18,15,18,15,18,15,18,15,16,14,
16,14,16,14,16,14,14,14,14,14,15,11,15,11,15,11,
15,11,13,10,13,10,13,10,13,10,13,10,15,9,15,9,
15,9,15,9,18,14,18,14,18,14,18,14,18,14,18,13,
18,13,23,19,23,19,23,19,23,19,23,19,17,14,17,14,
16,13,14,12,14,12,14,12,15,9,19,13,12,8,16,12,
16,12,16,12,16,12,16,12,16,12,16,12,16,12,16,12,
16,12,16,12,16,12,13,12,13,12,13,12,13,12,13,12,
13,12,13,12,13,12,8,7,8,7,16,14,16,14,16,14,
16,14,16,14,16,14,16,14,16,15,16,15,16,15,16,15,
16,15,18,14,18,14,18,17,18,17,18,17,18,17,18,17,
16,13,16,13,16,13,16,13,14,14,14,14,14,14,14,14,
18,18,23,23,22,22,18,18,11,11,11,11,11,11,18,18,
23,23,22,22,14,14,14,14,14,14,14,14,23,23,27,27,
26,26,23,23,8,8,8,8,8,8,8,8,13,13,18,18,
17,17,13,13,13,13,13,13,13,13,21,21,25,25,23,23,
14,14,14,14,14,14,14,14,22,27,26,22,19,19,19,19,
19,19,19,19,21,21,26,26,24,24,21,21,14,14,11,11,
14,14,8,8,13,13,14,14,19,19,14,14,14,14,14,14,
14,14,26,26,31,31,30,30,26,26,14,14,14,14,14,14,
14,14,31,31,35,35,34,34,31,31,19,19,19,19,19,19,
19,19,29,29,34,34,33,33,29,29,14,14,14,14,14,14,
14,16,16,19,19,24,5,8,5,11,11,14,14,14,14,14,
19,19,24,24,26,10,9,5,8,8,8,8,8,8,9,9,
14,14,10,9,5,14,14,14,14,13,13,14,14,16,16,23,
23,19,11,11,6,19,19,19,19,19,22,20,22,20,25,6,
5,13,21,13,21,7,5,3,13,6,4,1,0,9,9,13,
26,11,11,6,12,7,6,12,7,9,9,9,9,9,9,9,
8,6,8,6,6,10,9,9,9,9,9,9,9,9,9,9,
8,6,8,6,6,13,13,13,13,15,13,24,18,13,13,13,
13,25,13,11,4,7,0,0,0,0,0,0,0,0,17,24,
24,9,7,7,11,13,9,7,7,10,10,9,9,5,11,0,
0,0,0,0,0,0,0,0,0,12,12,12,12,12,12,12,
12,12,7,7,7,7,15,14,14,14,14,14,14,14,14,14,
13,13,12,12,12,12,12,12,12,12,13,13,7,7,7,14,
7,15,15,14,11,11,10,10,10,14,14,19,13,12,12,12,
28,26,20,14,25,22,12,7,14,14,14,14,14,14,12,12,
19,13,14,12,7,13,15,19,14,12,14,14,14,14,13,14,
12,14,12,12,13,7,7,22,22,15,14,14,14,14,14,14,
11,11,10,10,10,10,14,14,13,19,19,19,19,14,14,13,
12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,7,
14,14,14,14,14,15,15,15,17,17,17,13,13,0,11,11,
5,5,14,14,18,18,14,14,24,24,8,8,15,15,14,14,
23,19,19,21,21,14,14,26,26,14,14,32,32,19,19,29,
29,14,14,14,14,8,8,14,14,19,19,0,0,0,0,0,
0,0,16,24,13,8,8,16,15,14,13,17,13,24,14,18,
18,16,17,22,18,16,17,14,14,15,18,17,17,17,17,24,
24,19,21,15,14,23,15,12,13,13,11,15,12,19,11,15,
15,14,15,18,15,14,15,14,12,13,13,18,14,15,15,22,
22,16,19,13,13,20,13,10,7,7,8,17,21,19,15,12,
14,12,16,14,16,0,0,0,29,38,6,0,6,6,13,20,
20,7,9,9,13,12,7,10,7,14,14,14,14,14,13,14,
14,14,13,14,7,7,13,13,13,12,24,17,16,16,17,14,
14,17,19,9,9,17,14,23,19,17,15,17,16,14,16,19,
19,25,18,17,15,9,14,9,14,14,9,13,15,13,15,13,
9,14,16,8,8,15,8,23,16,15,15,15,11,11,10,15,
14,20,15,14,13,10,7,10,14,6,8,14,14,14,14,14,
11,21,7,14,14,11,14,10,12,9,15,16,4,7,8,14,
12,17,17,17,17,17,17,23,16,14,14,14,14,9,9,9,
9,19,17,17,17,17,17,17,19,19,19,19,16,13,13,13,
13,13,13,20,13,13,13,13,13,8,8,8,8,16,15,15,
15,15,15,12,15,15,15,15,15,14,8,23,23,17,8,10,
10,10,6,7,8,12,11,15,14,22,7,7,7,13,13,13,
14,14,8,19,29,9,9,18,17,17,14,8,12,7,10,10,
10,10,17,17,17,17,12,17,15,14,14,15,17,13,17,13,
17,13,16,13,16,13,16,13,16,13,17,20,17,15,14,13,
14,13,14,13,14,13,14,13,17,14,17,14,17,14,17,14,
19,16,19,16,9,8,9,8,9,8,9,8,9,17,15,9,
8,17,15,15,14,8,14,8,14,12,14,12,14,8,19,16,
19,16,19,16,20,17,16,17,15,17,15,17,15,16,11,16,
11,16,11,14,11,14,11,14,11,14,11,16,10,16,10,16,
10,19,15,19,15,19,15,19,15,19,15,19,15,25,20,17,
14,15,13,15,13,15,13,9,15,19,16,15,16,15,16,16,
13,17,20,16,15,15,14,16,15,14,17,17,23,10,9,18,
15,9,15,28,19,16,17,17,16,26,21,18,15,16,14,11,
15,7,11,17,10,16,20,18,18,18,20,14,15,13,15,15,
13,13,12,15,13,12,15,6,11,9,8,32,30,28,23,21,
15,28,26,24,17,13,9,8,17,15,19,15,19,15,19,15,
19,15,19,15,13,17,13,17,13,23,20,17,14,17,14,17,
15,17,15,17,15,15,13,8,32,30,28,17,14,26,16,19,
16,17,13,23,20,17,15,17,13,17,13,14,13,14,13,9,
8,9,8,17,15,17,15,16,11,16,11,19,15,19,15,14,
11,16,10,15,12,19,16,16,14,15,13,17,13,14,13,17,
15,17,15,17,15,17,15,17,14,14,14,15,15,13,13,15,
15,13,13,17,12,13,16,14,8,15,15,14,14,14,15,16,
16,8,8,8,10,10,8,17,22,22,23,16,16,17,15,19,
18,16,11,11,11,11,11,11,10,15,14,11,7,8,7,7,
10,10,15,14,14,14,20,14,14,13,13,13,13,13,13,13,
13,18,13,13,14,17,8,14,13,15,13,13,23,25,23,18,
14,20,24,17,16,15,15,11,11,5,8,8,8,10,14,10,
7,11,6,6,6,6,6,9,9,11,11,9,9,6,14,9,
9,6,14,9,9,8,8,6,6,8,8,8,9,4,10,10,
6,8,10,9,9,14,12,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,7,7,0,7,7,11,21,
7,21,25,15,21,25,22,9,17,16,14,17,14,15,19,18,
9,17,17,23,19,15,17,18,15,15,16,17,19,18,20,18,
9,17,15,12,15,9,15,15,15,14,14,12,12,15,14,9,
15,15,15,15,13,14,14,12,14,12,15,18,14,19,20,9,
15,14,15,20,14,14,18,26,18,19,17,13,16,15,16,15,
16,15,16,13,17,15,17,15,17,15,17,15,17,15,14,13,
14,13,14,13,14,13,14,13,14,9,17,14,19,16,19,16,
19,16,19,16,19,16,9,8,9,8,17,15,17,15,17,15,
14,8,14,8,14,8,14,8,23,23,23,23,23,23,19,16,
19,16,19,16,19,16,17,15,17,15,17,15,17,15,15,15,
15,15,16,11,16,11,16,11,16,11,14,11,14,11,14,11,
14,11,14,11,16,10,16,10,16,10,16,10,19,15,19,15,
19,15,19,15,19,15,19,14,19,14,25,20,25,20,25,20,
25,20,25,20,18,15,18,15,17,14,15,13,15,13,15,13,
16,10,20,14,13,9,17,13,17,13,17,13,17,13,17,13,
17,13,17,13,17,13,17,13,17,13,17,13,17,13,14,13,
14,13,14,13,14,13,14,13,14,13,14,13,14,13,9,8,
9,8,17,15,17,15,17,15,17,15,17,15,17,15,17,15,
17,16,17,16,17,16,17,16,17,16,19,15,19,15,20,18,
20,18,20,18,20,18,20,18,17,14,17,14,17,14,17,14,
15,15,15,15,15,15,15,15,19,19,24,24,23,23,19,19,
12,12,12,12,12,12,20,20,25,25,24,24,15,15,15,15,
15,15,15,15,24,24,29,29,28,28,24,24,9,9,9,9,
9,9,9,9,14,14,19,19,18,18,14,14,14,14,14,14,
14,14,22,22,27,27,25,25,15,15,15,15,15,15,15,15,
24,29,28,24,20,20,20,20,20,20,20,20,23,23,28,28,
25,25,23,23,15,15,12,12,15,15,9,9,14,14,15,15,
20,20,15,15,15,15,15,15,15,15,28,28,33,33,32,32,
28,28,15,15,15,15,15,15,15,15,33,33,38,38,37,37,
33,33,20,20,20,20,20,20,20,20,31,31,36,36,35,35,
31,31,15,15,15,15,15,15,15,17,17,20,21,26,5,9,
5,12,12,15,15,15,15,15,21,21,25,25,28,10,9,5,
9,9,9,9,9,9,9,9,15,15,10,9,5,15,15,15,
15,14,14,15,15,17,17,25,25,21,11,11,6,20,20,20,
20,20,23,21,24,22,27,7,5,14,22,14,22,7,6,4,
14,7,4,1,0,10,10,14,28,12,11,7,13,7,7,13,
7,10,10,10,10,10,10,10,8,7,9,6,6,11,10,10,
10,10,10,10,10,10,10,10,8,7,9,6,6,14,14,14,
14,16,14,26,19,14,14,14,14,27,14,12,4,8,0,0,
0,0,0,0,0,0,18,26,26,9,8,8,11,14,9,8,
8,10,10,9,9,6,12,0,0,0,0,0,0,0,0,0,
0,13,13,13,13,13,13,13,13,13,8,8,8,8,16,15,
15,15,15,15,15,15,15,15,14,14,13,13,13,13,13,13,
13,13,14,14,8,8,8,15,8,16,16,15,11,11,11,11,
11,15,15,20,14,13,13,13,30,28,21,15,26,24,13,8,
15,15,15,15,15,15,13,13,20,14,15,13,8,14,16,20,
15,13,15,15,15,15,14,15,13,15,13,13,14,8,8,23,
23,16,15,15,15,15,15,15,11,11,11,11,11,11,15,15,
14,20,20,20,20,15,15,14,13,13,13,13,13,13,13,13,
13,13,13,13,13,13,13,8,15,15,15,15,15,16,16,16,
18,18,18,14,14,0,12,12,5,5,15,15,19,19,15,15,
26,26,9,9,16,16,15,15,25,20,20,23,23,15,15,28,
28,15,15,35,35,20,20,31,31,15,15,15,15,9,9,15,
15,20,20,0,0,0,0,0,0,0,17,26,14,9,9,17,
16,16,14,18,14,26,15,19,19,18,18,23,19,17,18,15,
16,16,19,19,18,18,18,24,24,21,22,16,16,25,16,13,
14,13,12,16,13,21,12,17,16,15,16,19,17,15,16,15,
13,14,14,19,15,16,16,22,22,17,20,14,14,21,14,11,
8,8,9,18,23,20,16,13,15,13,17,15,17,0,0,0,
32,42,7,0,7,7,15,22,21,8,10,10,14,13,7,11,
7,15,15,15,15,15,15,15,15,15,16,15,7,7,14,14,
14,13,26,19,17,17,19,16,15,19,21,10,10,19,15,26,
21,19,17,19,18,15,18,21,21,27,20,19,17,10,15,10,
16,15,10,15,16,14,17,15,10,16,18,9,8,16,9,26,
18,16,17,16,13,12,11,17,16,23,16,16,14,11,7,11,
16,7,9,15,15,15,15,15,13,24,8,16,15,12,16,11,
13,10,17,18,5,7,9,16,13,19,19,19,19,19,19,25,
17,16,16,16,16,10,10,10,10,21,19,19,19,19,19,19,
21,21,21,21,18,15,15,15,15,15,15,22,14,15,15,15,
15,9,9,9,9,18,16,16,16,16,16,13,16,17,17,17,
17,16,9,26,25,19,9,11,11,11,6,8,8,13,12,17,
15,25,7,7,7,14,14,14,15,15,9,22,32,10,10,19,
19,19,15,9,14,7,11,11,11,11,19,19,19,19,13,19,
17,16,16,17,19,15,19,15,19,15,17,14,17,14,17,14,
17,14,19,22,19,17,16,15,16,15,16,15,16,15,16,15,
19,16,19,16,19,16,19,16,21,18,21,18,10,9,10,9,
10,9,10,9,10,19,17,10,8,19,16,16,15,9,15,9,
15,14,15,13,15,9,21,18,21,18,21,18,22,19,18,19,
16,19,16,19,16,18,13,18,13,18,13,15,12,15,12,15,
12,15,12,18,11,18,11,18,11,21,17,21,17,21,17,21,
17,21,17,21,17,27,23,19,16,17,14,17,14,17,14,10,
16,21,18,16,18,17,17,17,14,19,22,18,17,16,15,18,
16,15,19,19,26,11,10,20,16,10,17,30,21,18,19,19,
17,28,24,20,16,18,15,12,17,8,12,19,11,18,22,20,
20,20,22,16,17,14,17,17,14,14,13,16,14,13,16,7,
12,10,9,36,33,31,25,24,17,31,29,26,19,15,10,9,
19,16,21,17,21,17,21,17,21,17,21,17,15,19,15,19,
15,25,22,19,16,19,16,19,16,19,16,19,16,17,14,8,
36,33,31,19,16,29,17,21,18,19,15,25,22,19,16,19,
15,19,15,16,15,16,15,10,9,10,9,19,16,19,16,18,
13,18,13,21,17,21,17,15,12,18,11,16,14,21,18,18,
16,17,14,19,15,16,15,19,16,19,16,19,16,19,16,19,
16,15,16,16,16,14,14,16,17,14,15,19,14,14,18,15,
9,16,16,16,16,16,17,18,17,9,9,9,11,12,9,18,
26,26,25,18,18,18,16,21,20,16,13,13,12,13,13,12,
12,16,15,12,8,9,8,8,11,11,17,15,16,16,23,16,
15,14,14,14,14,14,14,14,14,19,15,15,16,19,8,16,
14,16,14,14,26,27,26,20,15,22,27,19,17,16,17,12,
12,6,9,9,9,11,16,11,7,12,7,7,7,6,6,10,
10,12,12,10,10,7,16,10,10,7,16,10,10,8,8,6,
6,9,9,9,9,4,12,11,6,9,11,10,10,16,13,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,7,7,0,7,7,13,23,7,23,28,17,23,27,24,9,
19,17,15,18,16,17,21,20,10,19,19,26,21,17,19,20,
17,17,18,19,21,20,22,20,10,19,17,13,17,9,16,17,
16,15,15,13,13,16,16,9,16,17,17,16,14,16,15,13,
15,14,16,20,16,22,22,9,16,16,16,22,15,15,20,29,
20,21,19,15,18,16,18,16,18,16,17,14,19,17,19,17,
19,17,19,17,19,17,16,15,16,15,16,15,16,15,16,15,
15,10,19,16,21,18,21,18,21,18,21,18,21,18,10,9,
10,9,19,16,19,16,19,16,15,9,15,9,15,9,15,9,
26,26,26,26,26,26,21,18,21,18,21,18,21,18,19,16,
19,16,19,16,19,16,17,17,17,17,18,13,18,13,18,13,
18,13,15,12,15,12,15,12,15,12,15,12,18,11,18,11,
18,11,18,11,21,17,21,17,21,17,21,17,21,17,21,16,
21,16,27,23,27,23,27,23,27,23,27,23,20,16,20,16,
19,16,17,14,17,14,17,14,18,11,23,16,15,10,19,15,
19,15,19,15,19,15,19,15,19,15,19,15,19,15,19,15,
19,15,19,15,19,15,16,15,16,15,16,15,16,15,16,15,
16,15,16,15,16,15,10,9,10,9,19,16,19,16,19,16,
19,16,19,16,19,16,19,16,19,17,19,17,19,17,19,17,
19,17,21,17,21,17,22,20,22,20,22,20,22,20,22,20,
19,16,19,16,19,16,19,16,17,17,17,17,17,17,17,17,
21,21,27,27,26,26,21,21,13,13,13,13,13,13,22,22,
27,27,26,26,17,17,17,17,17,17,17,17,27,27,32,32,
31,31,27,27,9,9,9,9,9,9,9,9,16,16,21,21,
20,20,16,16,16,16,16,16,16,16,24,24,30,30,27,27,
16,16,16,16,16,16,16,16,26,32,31,26,22,22,22,22,
22,22,22,22,25,25,30,31,28,28,25,25,17,17,13,13,
17,17,9,9,16,16,16,16,22,22,17,17,17,17,17,17,
17,17,31,31,36,36,35,35,31,31,17,17,17,17,17,17,
17,17,36,36,42,42,41,41,36,36,22,22,22,22,22,22,
22,22,35,35,40,40,39,39,35,35,17,17,17,17,17,17,
17,19,19,23,23,28,6,9,6,13,13,17,17,17,17,17,
23,23,28,28,30,11,10,6,9,9,9,9,9,9,10,10,
17,17,12,10,6,16,16,16,16,15,15,16,16,19,19,27,
27,23,13,13,7,22,22,22,22,22,26,23,26,24,30,7,
6,15,25,15,25,8,6,4,15,7,5,2,0,11,11,15,
30,13,13,7,14,8,7,14,8,11,11,11,11,11,11,11,
9,8,10,7,7,12,11,11,11,11,11,11,11,11,11,11,
9,8,10,7,7,15,15,15,15,17,15,28,21,15,15,15,
15,29,15,13,5,8,0,0,0,0,0,0,0,0,20,29,
29,10,9,8,13,16,10,9,8,11,11,10,10,6,13,0,
0,0,0,0,0,0,0,0,0,15,15,15,15,15,15,15,
15,15,9,9,9,9,18,16,16,16,16,16,17,17,17,17,
16,16,15,14,14,14,14,15,15,15,16,16,9,9,9,17,
8,18,18,16,13,13,12,12,12,17,17,23,16,14,14,14,
33,31,24,17,29,26,15,9,16,17,17,17,17,17,15,15,
22,16,16,14,8,16,18,22,16,15,16,16,16,16,16,16,
14,17,15,15,16,9,9,26,26,18,16,16,16,16,17,17,
13,13,12,12,12,12,17,17,16,23,23,23,23,16,16,16,
14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,9,
16,16,16,16,16,17,17,17,20,20,20,16,16,0,13,13,
6,6,17,17,21,21,17,17,29,29,9,9,18,18,16,16,
27,22,22,25,25,17,17,31,31,17,17,38,38,22,22,35,
35,17,17,17,17,9,9,16,16,22,22,0,0,0,0,0,
0,0,19,29,15,10,10,19,18,17,15,19,16,28,16,21,
21,19,19,26,21,19,20,17,17,18,21,21,20,20,20,26,
26,23,24,18,17,27,18,15,16,14,13,17,15,23,13,18,
17,16,17,21,18,16,18,17,14,16,16,21,16,18,17,24,
24,19,22,15,15,23,16,12,9,8,10,19,25,22,18,15,
17,14,19,16,19,0,0,0,33,43,7,0,7,7,16,22,
22,8,10,10,15,14,8,11,8,15,15,15,15,15,16,15,
15,15,16,15,8,8,14,14,14,14,27,20,17,18,20,16,
16,19,22,10,10,19,16,27,21,20,17,20,19,16,18,22,
21,28,20,20,17,10,15,10,16,15,11,15,17,14,17,15,
10,16,18,9,9,17,9,26,18,17,17,17,13,13,11,17,
16,23,17,16,15,11,8,11,16,7,9,15,15,15,15,16,
13,24,8,16,15,12,16,12,14,11,18,19,5,8,9,16,
14,20,20,20,20,20,20,26,18,16,16,16,16,10,10,10,
10,21,20,20,20,20,20,20,22,22,22,22,19,15,15,15,
15,15,15,22,14,15,15,15,15,9,9,9,9,18,17,17,
17,17,17,14,17,17,17,17,17,16,9,26,26,20,10,12,
12,12,6,8,9,13,12,17,15,25,8,8,8,14,14,15,
16,16,9,23,33,10,10,19,19,19,15,9,14,8,11,11,
11,11,19,19,19,20,14,20,17,16,16,17,20,15,20,15,
20,15,18,14,18,14,18,14,18,14,20,22,20,17,16,15,
16,15,16,15,16,15,16,15,19,16,19,16,19,16,19,16,
22,18,22,18,10,9,10,9,10,9,10,9,10,20,17,10,
9,19,17,17,16,9,16,9,16,14,16,14,16,9,21,18,
21,18,21,18,22,20,18,20,17,20,17,20,17,19,13,19,
13,19,13,16,13,16,13,16,13,16,13,18,11,18,11,18,
11,22,17,22,17,22,17,22,17,22,17,22,17,28,23,20,
16,17,15,17,15,17,15,10,17,21,18,17,18,17,18,18,
14,20,22,18,17,16,16,18,17,16,19,20,26,11,10,20,
17,11,17,30,21,18,20,20,18,29,25,20,17,18,16,13,
17,8,12,20,11,18,23,20,21,20,23,16,17,15,17,18,
15,15,14,17,15,14,17,7,13,10,9,37,34,32,26,24,
17,31,30,27,20,15,10,9,20,17,22,17,22,17,22,17,
22,17,22,17,15,20,15,20,15,26,23,19,16,19,16,19,
17,20,17,20,17,17,15,9,37,34,32,19,16,30,18,21,
18,20,15,26,23,20,17,20,15,20,15,16,15,16,15,10,
9,10,9,20,17,20,17,19,13,19,13,22,17,22,17,16,
13,18,11,17,14,22,18,18,16,17,15,20,15,16,15,20,
17,20,17,20,17,20,17,20,16,16,17,17,17,15,14,17,
17,15,15,20,14,14,18,15,10,17,17,16,16,16,17,18,
18,9,9,9,11,12,9,19,26,26,26,18,18,19,17,22,
21,16,13,13,12,13,13,12,12,17,16,12,8,10,8,8,
11,11,17,16,16,16,23,16,16,15,15,15,15,14,14,14,
14,20,15,15,16,19,9,17,14,17,14,14,26,28,26,20,
15,22,28,20,18,17,17,13,13,6,9,9,10,11,16,11,
7,13,7,7,7,6,6,10,10,12,12,10,10,7,16,11,
11,7,16,11,11,9,9,6,6,9,9,9,10,4,12,11,
6,9,12,10,10,16,14,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,7,7,0,8,7,13,23,
8,24,29,18,24,28,25,10,20,17,16,19,16,17,22,20,
10,19,20,27,21,17,20,21,17,17,18,19,22,20,22,21,
10,19,17,14,18,10,17,17,16,16,15,14,13,18,16,10,
17,17,18,17,15,16,16,13,16,14,17,21,16,22,23,10,
17,16,17,23,16,17,21,30,21,22,20,15,18,17,18,17,
18,17,18,14,20,17,20,17,20,17,20,17,20,17,16,15,
16,15,16,15,16,15,16,15,16,10,19,16,22,18,22,18,
22,18,22,18,22,18,10,9,10,9,19,17,19,17,19,17,
16,9,16,9,16,9,16,9,27,27,27,27,27,27,21,18,
21,18,21,18,21,18,20,17,20,17,20,17,20,17,17,17,
17,17,19,13,19,13,19,13,19,13,16,13,16,13,16,13,
16,13,16,13,18,11,18,11,18,11,18,11,22,17,22,17,
22,17,22,17,22,17,21,16,21,16,28,23,28,23,28,23,
28,23,28,23,20,17,20,17,20,16,17,15,17,15,17,15,
18,11,23,16,15,10,20,15,20,15,20,15,20,15,20,15,
20,15,20,15,20,15,20,15,20,15,20,15,20,15,16,15,
16,15,16,15,16,15,16,15,16,15,16,15,16,15,10,9,
10,9,20,17,20,17,20,17,20,17,20,17,20,17,20,17,
20,18,20,18,20,18,20,18,20,18,22,17,22,17,23,20,
23,20,23,20,23,20,23,20,20,16,20,16,20,16,20,16,
17,17,17,17,17,17,17,17,22,22,28,28,27,27,22,22,
14,14,14,14,14,14,23,23,28,28,27,27,18,18,18,18,
18,18,18,18,28,28,33,34,32,32,28,28,10,10,10,10,
10,10,10,10,16,16,22,22,21,21,16,16,16,16,16,16,
16,16,25,25,31,31,28,28,17,17,17,17,17,17,17,17,
27,33,31,27,23,23,23,23,23,23,23,23,26,26,31,32,
29,29,26,26,17,17,14,14,18,18,10,10,16,16,17,17,
23,23,17,17,17,17,17,17,17,17,32,32,37,38,36,36,
32,32,18,18,18,18,18,18,18,18,37,37,43,43,42,42,
37,37,23,23,23,23,23,23,23,23,36,36,41,41,40,40,
36,36,17,17,17,17,17,17,17,20,20,23,23,29,6,10,
6,13,13,18,18,18,18,18,24,24,29,29,31,12,11,6,
10,10,10,10,10,10,10,10,17,18,12,11,6,17,17,17,
17,16,16,17,17,19,19,28,28,23,13,13,7,23,23,23,
23,23,26,24,27,25,31,7,6,15,25,15,25,8,6,4,
15,8,5,2,0,11,11,15,31,13,13,8,14,8,8,15,
8,11,11,11,11,11,11,11,9,8,10,7,7,13,11,11,
11,11,11,11,11,11,11,11,9,8,10,7,7,15,15,15,
15,18,15,29,22,15,15,15,15,30,15,14,5,9,0,0,
0,0,0,0,0,0,21,29,29,11,9,9,13,16,11,9,
9,12,12,11,11,6,13,0,0,0,0,0,0,0,0,0,
0,15,15,15,15,15,15,15,15,15,9,9,9,9,18,17,
17,17,17,17,17,17,17,17,16,16,15,14,14,14,14,15,
15,15,16,16,9,9,9,17,9,18,18,17,13,13,13,13,
13,17,17,23,16,15,15,15,34,32,24,17,30,27,15,9,
17,17,17,17,17,17,15,15,23,16,17,15,9,16,18,23,
17,15,17,17,17,17,16,17,14,17,15,15,16,9,9,27,
27,18,17,17,17,17,17,17,13,13,13,13,13,13,17,17,
16,23,23,23,23,17,17,16,15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,9,17,17,17,17,17,18,18,18,
20,20,20,16,16,0,13,13,6,6,17,17,22,22,18,18,
30,30,10,10,18,18,17,17,28,23,23,26,26,17,17,32,
32,18,18,40,40,23,23,36,36,17,17,18,18,10,10,17,
17,23,23,0,0,0,0,0,0,0,19,29,16,10,10,20,
18,17,16,20,16,29,17,22,22,20,20,27,22,20,21,17,
18,18,21,22,20,21,20,28,28,24,24,18,18,28,19,15,
16,15,14,18,15,24,13,19,18,17,18,22,19,17,18,17,
14,16,16,22,17,19,18,24,24,19,23,16,15,24,16,13,
9,9,10,20,26,22,18,15,17,15,20,17,19,0,0,0,
37,48,8,0,8,8,18,25,25,9,12,12,17,15,8,12,
8,17,17,17,18,17,17,17,17,17,18,17,8,8,16,16,
16,16,30,22,20,20,22,18,18,22,24,11,11,21,18,30,
24,22,19,22,21,18,20,24,24,31,23,22,19,11,17,12,
18,17,12,17,19,16,19,17,12,18,20,10,10,19,10,30,
20,19,20,19,15,14,13,20,18,26,19,18,16,12,8,12,
18,8,10,17,17,17,17,17,14,27,9,18,17,14,18,13,
15,12,20,21,5,8,10,18,16,22,22,22,22,22,22,29,
20,18,18,18,18,11,11,11,11,24,22,22,22,22,22,22,
24,24,24,24,21,17,17,17,17,17,17,25,16,17,17,17,
17,10,10,10,10,20,19,19,19,19,19,15,19,20,20,20,
20,18,10,30,29,22,11,13,13,13,7,9,10,15,14,19,
17,28,8,8,8,16,16,17,18,18,10,25,37,11,11,20,
22,22,17,10,16,8,12,12,12,12,22,22,22,22,15,22,
19,18,18,20,22,17,22,17,22,17,20,16,20,16,20,16,
20,16,22,25,22,19,18,17,18,17,18,17,18,17,18,17,
22,18,22,18,22,18,22,18,24,20,24,20,11,10,11,10,
11,10,11,10,11,22,20,11,10,21,19,19,18,10,18,10,
18,16,18,15,18,10,24,20,24,20,24,20,25,22,20,22,
19,22,19,22,19,21,15,21,15,21,15,18,14,18,14,18,
14,18,14,20,13,20,13,20,13,24,20,24,20,24,20,24,
20,24,20,24,20,31,26,22,18,19,16,19,16,19,16,12,
19,25,20,19,20,19,20,20,16,22,26,20,19,18,19,20,
19,18,22,22,30,13,11,23,19,12,20,36,24,20,22,22,
20,34,28,24,19,20,18,14,19,9,13,22,13,20,25,23,
24,23,26,18,19,16,19,20,17,17,17,19,17,15,19,8,
14,11,10,41,38,36,29,27,20,35,34,30,22,17,11,10,
22,19,24,20,24,20,24,20,24,20,24,20,17,22,17,22,
17,29,26,22,18,22,18,21,19,22,19,22,19,19,17,10,
41,38,36,22,18,35,20,24,20,22,17,29,26,22,19,22,
17,22,17,18,17,18,17,11,10,11,10,22,19,22,19,21,
15,21,15,24,20,24,20,18,14,20,13,19,16,24,20,21,
18,19,16,22,17,18,17,22,19,22,19,22,19,22,19,22,
18,17,19,19,19,17,16,19,19,17,17,22,16,16,21,18,
11,19,19,18,18,18,20,20,20,10,10,10,12,13,10,21,
29,29,30,20,21,21,19,24,23,19,15,15,14,15,15,13,
14,19,18,15,9,11,9,9,13,12,20,18,18,18,26,18,
18,17,17,17,17,17,16,17,16,23,18,17,18,21,10,19,
16,19,17,16,29,32,30,24,18,25,31,22,20,19,19,14,
14,7,10,10,11,13,18,13,8,14,8,8,8,7,7,11,
11,13,13,12,12,8,18,12,12,8,18,12,12,10,10,7,
7,10,10,10,11,5,13,13,7,10,13,11,12,18,15,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,8,8,0,8,8,15,26,8,27,33,20,27,32,28,11,
22,20,18,21,18,19,24,23,12,21,22,30,24,19,22,23,
19,19,20,22,24,23,26,23,12,22,19,16,20,11,19,19,
19,18,18,16,15,20,18,11,19,20,20,19,17,18,18,15,
18,16,19,23,18,25,26,11,19,18,19,26,18,19,23,33,
23,26,22,17,20,19,20,19,20,19,20,16,22,19,22,19,
22,19,22,19,22,19,18,17,18,17,18,17,18,17,18,17,
18,12,22,18,24,20,24,20,24,20,24,20,24,20,11,10,
11,10,21,19,21,19,21,19,18,10,18,10,18,10,18,10,
30,30,30,30,30,30,24,20,24,20,24,20,24,20,22,19,
22,19,22,19,22,19,19,20,19,20,21,15,21,15,21,15,
21,15,18,14,18,14,18,14,18,14,18,14,20,13,20,13,
20,13,20,13,24,20,24,20,24,20,24,20,24,20,24,18,
24,18,31,26,31,26,31,26,31,26,31,26,23,19,23,19,
22,18,19,16,19,16,19,16,20,13,26,18,17,12,22,17,
22,17,22,17,22,17,22,17,22,17,22,17,22,17,22,17,
22,17,22,17,22,17,18,17,18,17,18,17,18,17,18,17,
18,17,18,17,18,17,11,10,11,10,22,19,22,19,22,19,
22,19,22,19,22,19,22,19,22,20,22,20,22,20,22,20,
22,20,24,20,24,20,25,23,25,23,25,23,25,23,25,23,
22,18,22,18,22,18,22,18,19,19,19,19,19,19,19,19,
25,25,31,31,30,30,25,25,16,16,16,16,16,16,25,25,
31,32,30,30,20,20,20,20,20,20,20,20,31,31,37,38,
36,36,31,31,11,11,11,11,11,11,11,11,18,18,24,25,
23,23,18,18,18,18,18,18,18,18,28,28,34,35,31,31,
19,19,19,19,19,19,19,19,30,37,35,30,26,26,26,26,
26,26,26,26,29,29,35,36,32,32,29,29,19,19,16,16,
20,20,11,11,18,18,19,19,26,26,19,19,19,19,19,19,
19,19,36,36,42,42,41,41,36,36,20,20,20,20,20,20,
20,20,42,42,48,48,47,47,42,42,26,26,26,26,26,26,
26,26,40,40,46,47,45,45,40,40,19,19,19,19,19,19,
19,22,22,26,26,33,7,11,7,15,15,20,20,20,20,20,
27,27,32,33,35,13,12,7,11,11,11,11,11,11,12,12,
20,20,13,12,7,19,19,19,19,18,18,19,19,22,22,32,
32,26,15,15,8,26,26,26,26,26,30,27,30,28,34,8,
7,17,28,17,28,9,7,5,17,8,5,2,0,12,12,17,
35,15,14,8,16,9,8,17,9,12,12,12,12,12,12,12,
11,9,11,8,8,14,12,12,12,12,12,12,12,12,12,12,
11,9,11,8,8,17,17,17,17,21,17,32,24,17,17,17,
17,34,17,15,5,10,0,0,0,0,0,0,0,0,23,33,
33,12,10,10,14,18,12,10,10,13,13,12,12,7,15,0,
0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,
17,17,10,10,10,10,20,19,19,19,19,19,20,20,20,20,
18,18,17,16,16,16,16,17,17,17,18,18,10,10,10,20,
10,20,20,19,15,15,14,14,14,20,20,26,18,16,16,16,
38,36,27,20,34,30,17,10,19,20,20,20,20,20,17,17,
26,18,19,17,10,18,20,26,19,17,19,19,19,19,18,19,
16,19,17,17,18,10,10,30,30,20,19,19,19,19,20,20,
15,15,14,14,14,14,20,20,18,26,26,26,26,19,19,18,
16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,10,
19,19,19,19,19,20,20,20,23,23,23,18,18,0,15,15,
7,7,19,19,25,25,20,20,33,33,11,11,20,20,19,19,
31,26,26,29,29,19,19,36,36,20,20,44,44,26,26,40,
40,19,19,20,20,11,11,19,19,26,26,0,0,0,0,0,
0,0,22,33,18,11,11,22,20,20,18,23,18,33,20,24,
24,22,23,30,24,22,23,19,20,20,24,24,23,23,23,33,
33,26,28,20,20,33,21,17,18,18,15,20,17,27,17,21,
20,19,20,25,21,19,20,20,16,18,18,25,19,21,20,30,
30,22,25,18,17,27,18,14,10,10,11,23,29,25,20,17,
19,17,22,19,22,0,0,0,42,55,9,0,9,9,20,29,
28,11,13,13,19,17,10,14,10,20,20,20,20,20,20,20,
20,20,20,20,10,10,18,18,18,18,34,25,22,23,25,21,
20,24,27,13,13,24,20,34,27,25,22,25,24,20,23,27,
27,36,26,25,22,13,20,13,21,20,13,19,21,18,22,19,
13,20,23,11,11,21,11,34,23,21,22,22,17,16,14,22,
21,30,21,21,19,14,10,14,20,9,11,20,20,20,20,19,
16,30,11,20,20,15,21,15,17,13,23,24,6,10,12,20,
18,25,25,25,25,25,25,33,23,21,21,21,21,13,13,13,
13,27,25,25,25,25,25,25,27,27,27,27,24,19,19,19,
19,19,19,29,18,19,19,19,19,11,11,11,11,23,21,21,
21,21,21,17,21,22,22,22,22,21,11,34,33,25,12,15,
15,15,8,11,11,17,16,22,20,32,10,10,10,18,18,19,
20,20,12,28,43,13,13,23,24,24,20,11,18,10,14,14,
14,14,25,25,25,25,17,25,22,21,21,22,25,19,25,19,
25,19,23,18,23,18,23,18,23,18,25,28,25,22,21,19,
21,19,21,19,21,19,21,19,24,20,24,20,24,20,24,20,
27,23,27,23,13,11,13,11,13,11,13,11,13,25,22,13,
11,24,21,21,20,11,20,11,20,18,20,18,20,11,27,23,
27,23,27,23,28,25,23,25,21,25,21,25,21,24,17,24,
17,24,17,20,16,20,16,20,16,20,16,23,14,23,14,23,
14,27,22,27,22,27,22,27,22,27,22,27,22,36,30,25,
21,22,19,22,19,22,19,13,21,27,23,21,23,22,23,23,
18,25,29,23,22,20,20,23,21,20,24,25,34,15,13,26,
21,13,22,41,27,23,25,25,23,37,31,27,21,23,20,16,
22,11,15,25,14,23,29,26,27,26,29,21,22,19,22,22,
19,19,18,21,19,18,21,9,16,13,11,47,43,40,33,31,
22,40,38,34,25,19,13,11,25,21,27,22,27,22,27,22,
27,22,27,22,19,25,19,25,19,33,29,24,20,24,20,24,
21,25,21,25,21,22,19,11,47,43,40,24,20,39,23,27,
23,25,19,33,29,25,21,25,19,25,19,21,19,21,19,13,
11,13,11,25,21,25,21,24,17,24,17,27,22,27,22,20,
16,23,14,21,18,27,23,24,21,22,19,25,19,21,19,25,
21,25,21,25,21,25,21,25,21,20,20,22,21,19,18,21,
22,20,19,25,18,18,23,19,12,21,21,21,21,21,22,23,
23,11,12,12,14,15,11,24,33,33,34,23,23,24,21,28,
27,23,17,17,15,17,17,15,15,21,20,17,10,12,11,10,
14,14,22,20,20,21,30,21,20,19,19,19,19,18,18,19,
18,26,21,20,21,24,11,21,18,22,18,18,33,36,34,27,
20,29,35,25,23,21,22,16,16,8,12,12,12,14,21,15,
9,16,9,9,9,8,8,13,13,15,15,13,13,9,21,13,
13,9,21,13,13,11,11,8,8,11,11,11,12,6,15,15,
8,11,15,13,13,21,18,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,9,9,0,10,9,17,30,
10,30,37,22,31,36,32,12,25,22,20,24,21,22,27,26,
13,24,25,34,27,22,25,26,22,22,23,24,27,26,29,27,
13,24,22,18,22,12,21,22,22,20,20,18,17,22,21,12,
21,22,23,21,19,21,20,17,20,18,21,27,20,28,29,12,
21,21,21,29,20,21,26,38,26,29,25,19,23,21,23,21,
23,21,23,18,25,22,25,22,25,22,25,22,25,22,21,19,
21,19,21,19,21,19,21,19,20,13,24,20,27,23,27,23,
27,23,27,23,27,23,13,11,13,11,24,21,24,21,24,21,
20,11,20,11,20,11,20,11,34,34,34,34,34,34,27,23,
27,23,27,23,27,23,25,21,25,21,25,21,25,21,22,22,
22,22,24,17,24,17,24,17,24,17,20,16,20,16,20,16,
20,16,20,16,23,14,23,14,23,14,23,14,27,22,27,22,
27,22,27,22,27,22,27,21,27,21,36,30,36,30,36,30,
36,30,36,30,26,21,26,21,25,21,22,19,22,19,22,19,
23,14,30,21,19,13,25,19,25,19,25,19,25,19,25,19,
25,19,25,19,25,19,25,19,25,19,25,19,25,19,21,19,
21,19,21,19,21,19,21,19,21,19,21,19,21,19,13,11,
13,11,25,21,25,21,25,21,25,21,25,21,25,21,25,21,
25,23,25,23,25,23,25,23,25,23,27,22,27,22,29,26,
29,26,29,26,29,26,29,26,25,21,25,21,25,21,25,21,
22,22,22,22,22,22,22,22,28,28,35,35,34,34,28,28,
18,18,18,18,18,18,29,29,36,36,34,34,22,22,22,22,
22,22,22,22,35,35,42,43,41,41,35,35,12,12,12,12,
12,12,12,12,21,21,28,28,26,26,21,21,21,21,21,21,
21,21,32,32,39,39,36,36,21,21,21,21,21,21,21,21,
34,42,40,34,29,29,29,29,29,29,29,29,33,33,40,40,
37,37,33,33,22,22,18,18,22,22,12,12,21,21,21,21,
29,29,22,22,22,22,22,22,22,22,41,41,47,48,46,46,
41,41,22,22,22,22,22,22,22,22,48,48,55,55,53,53,
48,48,29,29,29,29,29,29,29,29,45,45,52,53,51,51,
45,45,22,22,22,22,22,22,22,25,25,30,30,37,8,12,
8,17,17,22,22,22,22,22,30,30,37,37,40,15,14,8,
12,12,12,12,12,12,13,13,22,22,15,14,8,21,21,21,
21,20,20,21,21,24,24,36,36,30,17,17,9,29,29,29,
29,29,33,31,35,32,39,9,8,20,32,20,32,11,8,5,
20,10,6,2,0,14,14,20,40,17,16,10,18,11,10,19,
10,14,14,14,14,14,14,14,12,10,13,9,9,16,14,14,
14,14,14,14,14,14,14,14,12,10,13,9,9,20,20,20,
20,22,20,37,27,20,20,20,20,38,20,17,6,11,0,0,
0,0,0,0,0,0,26,38,38,13,11,11,16,21,13,11,
11,15,15,13,13,8,17,0,0,0,0,0,0,0,0,0,
0,19,19,19,19,19,19,19,19,19,11,11,11,11,23,21,
21,21,21,21,22,22,22,22,21,21,19,18,18,18,18,19,
19,19,20,20,11,11,11,22,11,23,23,21,17,17,16,16,
16,22,22,30,21,19,19,19,43,40,31,22,38,34,19,11,
21,22,22,22,22,22,19,19,29,20,21,19,11,20,23,29,
21,19,21,21,21,21,21,21,18,22,19,19,20,11,11,34,
34,23,21,21,21,21,22,22,17,17,16,16,16,16,22,22,
21,30,30,30,30,21,21,21,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,11,21,21,21,21,21,23,23,23,
26,26,26,21,21,0,17,17,8,8,22,22,28,28,22,22,
38,38,12,12,23,23,21,21,36,29,29,33,33,22,22,41,
41,22,22,50,50,29,29,45,45,22,22,22,22,12,12,21,
21,29,29,0,0,0,0,0,0,0,24,38,20,13,13,25,
23,22,20,26,21,37,22,27,27,25,26,34,27,25,26,22,
23,23,27,27,26,26,26,35,35,30,31,23,23,37,24,19,
21,19,17,23,19,30,19,24,23,21,23,28,24,21,23,22,
18,21,21,29,21,24,23,33,33,25,29,20,20,31,21,16,
11,11,13,25,33,29,23,19,22,19,25,21,24,0,0,0,
46,60,10,0,10,10,21,32,31,12,15,15,21,19,11,16,
11,22,22,22,21,22,21,22,22,22,21,22,11,11,20,20,
20,20,38,27,24,25,27,23,22,27,30,14,14,27,22,37,
30,28,24,28,26,22,25,30,30,39,28,27,24,14,22,14,
23,22,15,21,23,20,24,21,14,23,25,12,12,23,12,37,
25,23,24,24,18,18,16,24,23,32,23,23,20,15,11,15,
22,10,13,22,22,22,22,22,18,34,12,22,22,16,23,16,
19,15,25,26,7,11,13,22,20,27,27,27,27,27,27,36,
25,23,23,23,23,14,14,14,14,30,28,28,28,28,28,28,
30,30,30,30,26,21,21,21,21,21,21,32,20,21,21,21,
21,12,12,12,12,25,23,23,23,23,23,19,23,24,24,24,
24,23,12,37,36,27,13,16,16,16,9,12,12,18,17,24,
22,35,11,11,11,20,20,21,22,22,13,30,47,14,14,26,
27,27,22,13,20,11,16,15,15,15,27,27,27,27,19,27,
24,23,23,24,27,21,27,21,27,21,25,20,25,20,25,20,
25,20,27,31,27,24,23,21,23,21,23,21,23,21,23,21,
27,22,27,22,27,22,27,22,30,25,30,25,14,12,14,12,
14,12,14,12,14,28,24,14,12,27,23,23,22,12,22,12,
22,20,22,19,22,12,30,25,30,25,30,25,31,28,25,28,
23,28,23,28,23,26,18,26,18,26,18,22,18,22,18,22,
18,22,18,25,16,25,16,25,16,30,24,30,24,30,24,30,
24,30,24,30,24,39,32,27,23,24,20,24,20,24,20,14,
23,29,25,23,25,24,25,25,20,27,32,25,24,22,23,25,
23,22,27,28,37,16,14,28,23,15,24,43,30,25,28,28,
25,42,35,29,23,25,22,18,24,12,17,27,16,25,31,28,
29,28,32,23,24,20,24,25,21,21,20,23,21,19,23,10,
18,14,13,51,48,44,36,34,24,44,42,37,27,21,14,12,
28,23,30,24,30,24,30,24,30,24,30,24,21,27,21,27,
21,36,32,27,23,27,22,27,23,28,23,28,23,24,21,12,
51,48,44,27,22,42,25,30,25,27,21,36,32,28,23,27,
21,27,21,23,21,23,21,14,12,14,12,28,23,28,23,26,
18,26,18,30,24,30,24,22,18,25,16,23,20,30,25,26,
23,24,20,27,21,23,21,28,23,28,23,28,23,28,23,27,
23,22,23,24,23,21,20,23,24,21,21,28,20,20,26,22,
13,23,23,23,23,23,24,25,25,12,13,13,15,17,12,26,
37,37,37,25,26,26,23,30,29,25,18,18,16,18,18,17,
17,23,22,18,11,13,12,11,16,15,24,22,22,23,32,23,
22,21,21,21,21,20,19,21,20,28,22,22,23,27,12,23,
20,24,20,19,37,40,37,29,22,31,38,27,25,23,24,18,
18,8,13,13,13,16,23,16,10,18,10,10,10,9,9,14,
14,17,17,14,14,9,23,15,15,9,23,15,15,12,12,9,
9,13,13,13,13,6,17,16,9,12,16,14,14,23,19,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,10,10,0,11,10,18,33,11,33,40,25,33,39,35,14,
27,24,22,26,23,24,30,28,15,27,27,37,30,24,28,29,
24,24,25,27,29,28,31,29,15,27,24,19,25,14,23,24,
23,22,22,19,18,25,23,14,24,24,25,23,20,23,22,19,
22,20,23,30,22,30,32,14,23,23,23,32,21,23,29,41,
29,31,27,21,25,23,25,23,25,23,25,20,27,24,27,24,
27,24,27,24,27,24,23,21,23,21,23,21,23,21,23,21,
22,14,27,22,30,25,30,25,30,25,30,25,30,25,14,12,
14,12,27,23,27,23,27,23,22,12,22,12,22,12,22,12,
37,37,37,37,37,37,30,25,30,25,30,25,30,25,28,23,
28,23,28,23,28,23,24,24,24,24,26,18,26,18,26,18,
26,18,22,18,22,18,22,18,22,18,22,18,25,16,25,16,
25,16,25,16,30,24,30,24,30,24,30,24,30,24,30,23,
30,23,39,32,39,32,39,32,39,32,39,32,28,23,28,23,
27,23,24,20,24,20,24,20,25,16,32,23,21,14,27,21,
27,21,27,21,27,21,27,21,27,21,27,21,27,21,27,21,
27,21,27,21,27,21,23,21,23,21,23,21,23,21,23,21,
23,21,23,21,23,21,14,12,14,12,28,23,28,23,28,23,
28,23,28,23,28,23,28,23,28,25,28,25,28,25,28,25,
28,25,30,24,30,24,31,28,31,28,31,28,31,28,31,28,
27,23,27,23,27,23,27,23,24,24,24,24,24,24,24,24,
31,31,38,39,37,37,31,31,19,19,19,19,19,19,31,31,
39,39,38,38,25,25,25,25,25,25,25,25,39,39,46,47,
45,45,39,39,14,14,14,14,14,14,14,14,23,23,30,31,
29,29,23,23,23,23,23,23,23,23,35,35,43,43,39,39,
23,23,23,23,23,23,23,23,38,46,44,38,32,32,32,32,
32,32,32,32,36,36,44,44,40,40,36,36,24,24,19,19,
25,25,14,14,23,23,23,23,32,32,24,24,24,24,24,24,
24,24,44,44,52,52,51,51,44,44,25,25,25,25,25,25,
25,25,52,52,60,60,58,58,52,52,32,32,32,32,32,32,
32,32,50,50,57,58,56,56,50,50,24,24,24,24,24,24,
24,27,27,32,33,41,9,14,9,18,18,25,25,25,25,25,
33,33,40,40,44,16,15,9,14,14,14,14,14,14,15,15,
24,25,17,15,9,23,23,23,23,22,22,23,23,27,27,39,
39,33,18,18,10,32,32,32,32,32,37,33,38,35,43,10,
9,22,35,22,35,12,9,6,22,11,7,2,0,16,16,22,
44,19,18,11,20,12,11,21,11,15,15,15,15,15,15,15,
13,11,14,10,10,18,15,15,15,15,15,15,15,15,15,15,
13,11,14,10,10,22,22,22,22,25,22,40,30,22,22,22,
22,42,22,19,7,12,0,0,0,0,0,0,0,0,29,41,
41,15,12,12,18,23,15,12,12,16,16,15,15,9,18,0,
0,0,0,0,0,0,0,0,0,21,21,21,21,21,21,21,
21,21,12,12,12,12,25,23,23,23,23,23,24,24,24,24,
23,23,21,20,20,20,20,21,21,21,22,22,12,12,12,24,
12,25,25,23,18,18,18,18,18,24,24,32,23,20,20,20,
48,44,34,24,42,37,21,12,23,24,24,24,24,24,21,21,
32,22,23,21,12,22,25,32,23,21,23,23,23,23,23,23,
20,24,21,21,22,12,12,37,37,25,23,23,23,23,24,24,
18,18,18,18,18,18,24,24,23,32,32,32,32,23,23,23,
20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,12,
23,23,23,23,23,25,25,25,28,28,28,23,23,0,18,18,
9,9,24,24,31,31,25,25,42,42,14,14,25,25,23,23,
39,32,32,36,36,24,24,44,44,25,25,55,55,32,32,50,
50,24,24,25,25,14,14,23,23,32,32,0,0,0,0,0,
0,0,27,41,22,14,14,27,25,24,22,29,23,41,23,30,
30,28,29,37,30,28,29,24,25,25,30,29,28,29,29,38,
38,33,35,25,25,40,26,21,22,21,19,25,21,33,20,26,
25,23,25,31,26,23,25,24,20,23,23,31,23,26,25,35,
36,27,32,22,21,34,23,18,12,12,14,28,36,32,25,21,
24,21,28,23,27,0,0,0,50,66,11,0,11,11,23,35,
33,13,16,16,22,21,11,17,11,23,23,23,23,23,24,23,
23,23,23,23,11,11,22,22,22,22,41,30,28,27,30,25,
24,29,33,15,15,29,24,40,32,30,26,30,28,24,28,33,
33,43,31,30,26,15,23,15,25,23,16,23,25,22,26,23,
16,25,28,14,13,25,14,41,28,25,26,26,20,19,17,26,
25,35,25,25,22,16,11,16,24,11,14,23,23,23,23,25,
20,35,13,24,23,18,25,18,21,16,27,28,7,11,14,24,
22,30,30,30,30,30,30,39,27,25,25,25,25,15,15,15,
15,32,30,30,30,30,30,30,33,33,33,33,28,23,23,23,
23,23,23,35,22,23,23,23,23,14,14,14,14,28,25,25,
25,25,25,21,25,26,26,26,26,25,14,40,40,30,14,18,
18,18,10,13,13,20,19,26,23,38,11,11,11,22,22,22,
24,24,14,33,51,15,15,28,29,29,23,14,21,11,17,16,
16,16,29,29,29,30,21,30,26,25,25,26,30,23,30,23,
30,23,27,22,27,22,27,22,27,22,30,34,30,26,25,23,
25,23,25,23,25,23,25,23,29,24,29,24,29,24,29,24,
33,28,33,28,15,14,15,14,15,14,15,14,15,30,26,15,
13,29,25,25,24,14,24,14,24,21,24,21,24,14,32,28,
32,28,32,28,34,30,27,30,25,30,25,30,25,28,20,28,
20,28,20,24,19,24,19,24,19,24,19,28,17,28,17,28,
17,33,26,33,26,33,26,33,26,33,26,33,26,43,35,30,
25,26,22,26,22,26,22,16,25,34,27,25,27,26,27,27,
22,30,35,27,26,25,25,27,25,24,29,30,40,17,15,31,
25,16,26,48,32,27,30,30,27,45,38,32,25,27,24,19,
26,13,17,30,17,28,34,31,32,31,35,25,26,22,26,27,
22,22,22,25,22,21,25,11,19,15,14,56,52,48,39,37,
26,48,45,41,30,23,15,14,30,25,33,26,33,26,33,26,
33,26,33,26,23,30,23,30,23,39,35,29,25,29,24,29,
25,30,25,30,25,26,22,13,56,52,48,29,24,46,27,32,
28,30,23,39,35,30,25,30,23,30,23,25,23,25,23,15,
14,15,14,30,25,30,25,28,20,28,20,33,26,33,26,24,
19,28,17,25,21,33,28,28,25,26,22,30,23,25,23,30,
25,30,25,30,25,30,25,30,25,24,25,26,25,23,22,25,
26,23,23,30,21,22,28,24,15,25,25,25,25,25,26,28,
27,14,14,14,17,18,14,29,40,40,41,27,28,29,25,33,
32,28,20,20,19,20,20,18,19,25,24,20,12,15,13,13,
17,17,26,24,24,25,35,25,24,22,22,22,22,22,21,23,
22,31,24,24,25,29,13,25,22,26,22,21,40,43,40,32,
25,34,42,30,27,25,26,19,19,9,14,14,14,17,25,17,
11,19,11,11,11,10,10,15,15,18,18,16,16,10,25,16,
16,10,25,16,16,13,13,10,10,14,14,14,15,7,18,17,
10,14,18,15,16,25,21,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,11,11,0,11,11,20,35,
11,36,44,27,36,43,38,15,30,28,24,29,25,26,33,31,
16,29,30,40,32,26,30,32,26,26,28,29,33,31,35,32,
16,29,26,21,27,15,25,26,26,24,24,21,20,27,25,15,
26,26,27,25,22,25,24,20,24,22,25,32,24,33,35,15,
25,25,25,35,24,25,31,45,31,34,30,23,27,25,27,25,
27,25,27,22,30,26,30,26,30,26,30,26,30,26,25,23,
25,23,25,23,25,23,25,23,24,16,29,24,33,28,33,28,
33,28,33,28,33,28,15,14,15,14,29,25,29,25,29,25,
24,14,24,14,24,14,24,14,40,40,40,40,40,40,32,28,
32,28,32,28,32,28,30,25,30,25,30,25,30,25,26,26,
26,26,28,20,28,20,28,20,28,20,24,19,24,19,24,19,
24,19,24,19,28,17,28,17,28,17,28,17,33,26,33,26,
33,26,33,26,33,26,33,25,33,25,43,35,43,35,43,35,
43,35,43,35,31,25,31,25,30,25,26,22,26,22,26,22,
28,17,35,25,23,16,30,23,30,23,30,23,30,23,30,23,
30,23,30,23,30,23,30,23,30,23,30,23,30,23,25,23,
25,23,25,23,25,23,25,23,25,23,25,23,25,23,15,14,
15,14,30,25,30,25,30,25,30,25,30,25,30,25,30,25,
30,27,30,27,30,27,30,27,30,27,33,26,33,26,34,31,
34,31,34,31,34,31,34,31,30,25,30,25,30,25,30,25,
26,26,26,26,26,26,26,26,34,34,42,42,40,40,34,34,
21,21,21,21,21,21,34,34,42,43,41,41,27,27,27,27,
27,27,27,27,42,42,50,51,49,49,42,42,15,15,15,15,
15,15,15,15,25,25,33,33,32,32,25,25,25,25,25,25,
25,25,38,38,46,47,42,42,25,25,25,25,25,25,25,25,
41,50,48,41,35,35,35,35,35,35,35,35,39,39,48,48,
44,44,39,39,26,26,21,21,27,27,15,15,25,25,25,25,
35,35,26,26,26,26,26,26,26,26,48,48,56,57,55,55,
48,48,27,27,27,27,27,27,27,27,57,57,65,66,64,64,
57,57,35,35,35,35,35,35,35,35,54,54,62,63,61,61,
54,54,26,26,26,26,26,26,26,30,30,35,35,45,9,15,
9,20,20,27,27,27,27,27,36,36,44,44,47,18,16,9,
15,15,15,15,15,15,16,16,26,27,18,16,9,25,25,25,
25,24,24,25,25,29,29,43,43,36,20,20,11,35,35,35,
35,35,40,36,41,38,46,11,9,23,38,23,38,13,10,6,
23,11,7,2,0,17,17,23,48,20,20,11,22,13,11,22,
12,16,16,16,16,16,16,16,14,12,15,11,11,19,16,16,
16,16,16,16,16,16,16,16,14,12,15,11,11,23,23,23,
23,27,23,43,32,23,23,23,23,45,23,21,7,13,0,0,
0,0,0,0,0,0,31,45,45,16,14,13,20,25,16,14,
13,18,18,16,16,10,20,0,0,0,0,0,0,0,0,0,
0,23,23,23,23,23,23,23,23,23,14,14,14,14,28,25,
25,25,25,25,26,26,26,26,25,25,23,22,22,22,22,23,
23,23,24,24,14,14,14,26,13,28,28,25,20,20,19,19,
19,26,26,35,25,22,22,22,52,48,37,26,45,41,23,14,
25,26,26,26,26,26,23,23,35,24,25,22,13,24,28,35,
25,23,25,25,25,25,25,25,22,26,23,23,24,14,14,40,
40,28,25,25,25,25,26,26,20,20,19,19,19,19,26,26,
25,35,35,35,35,25,25,25,22,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,14,25,25,25,25,25,27,27,27,
31,31,31,25,25,0,20,20,9,9,26,26,34,34,27,27,
45,45,15,15,27,27,25,25,42,35,35,39,39,26,26,48,
48,27,27,60,60,35,35,54,54,26,26,27,27,15,15,25,
25,35,35,0,0,0,0,0,0,0,29,45,24,15,15,30,
27,28,24,31,25,44,26,33,33,30,31,40,33,30,32,26,
27,28,33,33,31,32,31,42,42,36,38,27,27,43,28,23,
24,23,21,27,23,36,22,29,27,25,27,33,29,25,28,26,
22,25,25,34,25,28,27,40,40,29,34,24,23,37,25,19,
14,13,15,31,39,35,27,23,26,22,30,25,29,0,0,0,
54,71,12,0,12,12,26,37,37,14,17,17,24,22,12,18,
12,25,25,25,26,25,25,25,25,25,26,25,12,12,24,24,
24,23,44,32,30,29,32,27,26,31,35,16,16,31,26,44,
35,32,28,32,30,26,30,35,35,46,33,32,28,17,25,17,
27,25,17,25,27,24,28,25,17,26,30,15,14,27,15,43,
30,27,29,28,21,21,19,29,27,38,27,27,24,18,12,18,
26,12,15,25,25,25,25,26,21,39,14,26,25,20,27,19,
22,17,30,30,8,12,15,26,23,32,32,32,32,32,32,42,
29,27,27,27,27,16,16,16,16,35,32,32,32,32,32,32,
35,35,35,35,31,25,25,25,25,25,25,37,24,25,25,25,
25,15,15,15,15,30,27,27,27,27,27,22,27,29,29,29,
29,27,15,43,43,32,16,19,19,19,11,14,14,22,20,28,
25,41,12,12,12,24,24,24,26,26,15,36,55,16,16,30,
31,31,25,15,23,12,18,18,18,18,32,32,32,32,22,32,
28,27,27,29,32,25,32,25,32,25,29,24,29,24,29,24,
29,24,32,36,32,28,27,25,27,25,27,25,27,25,27,25,
31,26,31,26,31,26,31,26,35,30,35,30,16,15,16,15,
16,15,16,15,16,33,29,16,14,31,27,27,26,15,26,15,
26,23,26,23,26,15,35,30,35,30,35,30,37,33,30,32,
27,32,27,32,27,30,21,30,21,30,21,26,21,26,21,26,
21,26,21,30,19,30,19,30,19,35,29,35,29,35,29,35,
29,35,29,35,29,46,38,32,27,28,24,28,24,28,24,17,
27,36,30,27,30,28,29,29,24,32,37,30,28,27,26,30,
27,26,31,32,43,19,16,33,27,17,29,52,35,30,32,32,
29,49,40,34,27,30,26,21,28,14,19,32,19,30,37,33,
34,33,38,27,28,24,28,29,24,24,23,27,24,23,27,12,
21,17,15,60,56,52,42,40,29,52,49,44,32,25,16,15,
32,27,35,29,35,29,35,29,35,29,35,29,25,32,25,32,
25,42,37,31,26,31,26,31,27,32,27,32,27,28,24,14,
60,56,52,31,26,49,29,35,30,32,25,42,37,32,27,32,
25,32,25,27,25,27,25,16,15,16,15,32,27,32,27,30,
21,30,21,35,29,35,29,26,21,30,19,27,23,35,30,30,
27,28,24,32,25,27,25,32,27,32,27,32,27,32,27,32,
27,26,27,28,27,24,24,27,28,25,25,32,23,23,30,25,
16,27,27,27,27,27,29,30,30,15,15,15,18,19,15,31,
42,42,43,30,30,31,27,36,34,29,21,22,20,21,21,20,
20,27,26,21,13,16,14,13,19,18,29,26,26,27,38,27,
26,24,24,24,24,23,24,24,23,33,25,25,27,31,14,27,
23,28,23,24,43,47,43,34,27,37,45,32,29,27,28,21,
21,10,15,15,16,18,27,19,12,21,12,12,12,10,10,16,
16,20,20,17,17,11,27,17,17,11,27,17,17,14,14,10,
10,15,15,15,16,7,19,19,10,15,19,16,17,27,23,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,12,12,0,12,12,21,38,12,39,47,29,39,46,41,16,
32,30,26,31,27,28,35,33,17,31,32,44,35,28,32,34,
28,28,30,31,35,33,37,34,17,31,28,23,29,16,27,28,
28,26,26,23,22,29,27,16,28,29,30,27,24,27,26,22,
26,23,27,35,26,36,38,16,27,27,27,38,27,27,34,48,
34,36,32,25,30,27,30,27,30,27,29,24,32,28,32,28,
32,28,32,28,32,28,27,25,27,25,27,25,27,25,27,25,
26,17,31,26,35,30,35,30,35,30,35,30,35,30,16,15,
16,15,31,27,31,27,31,27,26,15,26,15,26,15,26,15,
44,43,44,43,44,43,35,30,35,30,35,30,35,30,32,27,
32,27,32,27,32,27,28,29,28,29,30,21,30,21,30,21,
30,21,26,21,26,21,26,21,26,21,26,21,30,19,30,19,
30,19,30,19,35,29,35,29,35,29,35,29,35,29,35,27,
35,27,46,38,46,38,46,38,46,38,46,38,33,27,33,27,
32,27,28,24,28,24,28,24,30,19,38,27,25,17,32,25,
32,25,32,25,32,25,32,25,32,25,32,25,32,25,32,25,
32,25,32,25,32,25,27,25,27,25,27,25,27,25,27,25,
27,25,27,25,27,25,16,15,16,15,32,27,32,27,32,27,
32,27,32,27,32,27,32,27,32,29,32,29,32,29,32,29,
32,29,35,29,35,29,37,33,37,33,37,33,37,33,37,33,
32,27,32,27,32,27,32,27,28,28,28,28,28,28,28,28,
36,36,45,46,43,43,36,36,23,23,23,23,23,23,37,37,
46,46,44,44,29,29,29,29,29,29,29,29,45,45,54,55,
53,53,45,45,16,16,16,16,16,16,16,16,27,27,36,36,
34,34,27,27,27,27,27,27,27,27,41,41,50,51,46,46,
27,27,27,27,27,27,27,27,44,54,52,44,38,38,38,38,
38,38,38,38,43,43,51,52,47,47,43,43,28,28,23,23,
29,29,16,16,27,27,27,27,38,38,28,28,28,28,28,28,
28,28,52,52,61,62,59,59,52,52,29,29,29,29,29,29,
29,29,61,61,70,71,69,69,61,61,38,38,38,38,38,38,
38,38,58,58,67,68,66,66,58,58,28,28,28,28,28,28,
28,32,32,38,38,48,10,16,10,22,22,29,29,29,29,29,
39,39,47,47,51,19,17,10,16,16,16,16,16,16,17,17,
29,29,20,17,10,27,27,27,27,26,26,27,27,31,31,46,
46,38,21,21,12,38,38,38,38,38,43,39,44,41,50,12,
10,25,41,25,41,14,11,7,25,12,8,3,0,18,18,25,
51,22,21,12,24,14,12,24,13,18,18,18,18,18,18,18,
16,13,17,12,12,21,18,18,18,18,18,18,18,18,18,18,
16,13,17,12,12,25,25,25,25,29,25,47,35,25,25,25,
25,49,25,22,8,14,0,0,0,0,0,0,0,0,34,48,
48,17,15,14,21,27,17,15,14,19,19,17,17,11,22,0,
0,0,0,0,0,0,0,0,0,25,25,25,25,25,25,25,
25,25,15,15,15,15,30,27,27,27,27,27,29,29,29,29,
27,27,25,24,24,24,24,25,25,25,26,26,15,15,15,29,
14,30,30,27,21,21,21,21,21,29,29,38,27,24,24,24,
56,52,40,29,49,44,25,15,27,29,29,29,29,29,25,25,
37,26,27,24,14,26,30,37,27,25,27,27,27,27,27,27,
24,28,25,25,26,15,15,43,43,30,27,27,27,27,29,29,
21,21,21,21,21,21,29,29,27,38,38,38,38,27,27,27,
24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,15,
27,27,27,27,27,29,29,29,33,33,33,27,27,0,22,22,
10,10,28,28,36,36,29,29,49,49,16,16,30,30,27,27,
46,38,38,43,43,28,28,52,52,29,29,65,65,38,38,58,
58,28,28,29,29,16,16,27,27,38,38,0,0,0,0,0,
0,0,31,48,26,16,16,32,30,30,26,34,27,48,27,35,
35,33,34,44,35,32,34,28,29,30,35,35,33,34,33,47,
47,39,41,30,29,46,30,25,26,24,22,29,25,39,23,31,
29,27,29,36,31,27,30,29,24,26,27,36,27,30,29,42,
43,32,37,26,25,40,27,21,15,14,16,34,42,37,30,25,
28,24,32,27,31,0,0,0,58,76,13,0,13,13,28,40,
39,15,18,18,26,24,13,20,13,27,27,27,27,27,28,27,
27,27,27,27,13,13,25,25,25,25,47,35,31,31,34,29,
28,34,38,17,18,34,28,47,38,35,30,35,33,28,32,38,
38,49,36,34,30,18,27,18,29,27,19,27,29,25,30,27,
18,29,32,16,15,29,16,47,32,29,31,30,23,22,20,31,
29,41,29,29,26,18,13,18,28,13,16,27,27,27,27,27,
23,41,15,28,27,21,29,21,24,19,31,32,9,13,16,28,
25,35,35,35,35,35,35,45,31,29,29,29,29,17,17,17,
17,38,35,35,35,35,35,35,38,38,38,38,33,27,27,27,
27,27,27,40,25,27,27,27,27,16,16,16,16,32,29,29,
29,29,29,24,29,31,31,31,31,29,16,46,46,34,17,21,
21,21,11,15,15,23,22,31,27,44,13,13,13,25,25,26,
28,28,16,39,59,18,18,32,34,34,27,16,25,13,20,19,
19,19,34,34,34,34,24,34,30,29,29,31,35,27,35,27,
35,27,31,25,31,25,31,25,31,25,34,39,34,30,29,27,
29,27,29,27,29,27,29,27,34,28,34,28,34,28,34,28,
38,32,38,32,17,16,17,16,17,16,17,16,17,35,31,18,
15,34,29,29,28,16,28,16,28,25,28,24,28,16,38,32,
38,32,38,32,39,35,32,35,29,35,29,35,29,33,23,33,
23,33,23,28,22,28,22,28,22,28,22,32,20,32,20,32,
20,38,31,38,31,38,31,38,31,38,31,38,31,49,41,34,
29,30,26,30,26,30,26,18,29,38,32,29,32,30,31,31,
25,34,41,32,30,28,29,32,30,28,34,35,46,20,17,36,
29,19,31,55,38,32,35,35,31,52,44,37,29,32,28,22,
30,15,20,35,20,32,40,36,37,36,41,29,30,26,30,31,
26,26,25,29,26,24,29,13,22,18,16,65,60,56,45,43,
31,55,53,47,35,27,17,16,35,29,38,31,38,31,38,31,
38,31,38,31,26,35,27,35,27,45,40,34,29,34,28,34,
29,35,29,35,29,30,26,15,65,60,56,34,28,54,31,38,
32,35,27,45,40,35,29,35,27,35,27,29,27,29,27,17,
16,17,16,35,29,35,29,33,23,33,23,38,31,38,31,28,
22,32,20,29,25,38,32,32,29,30,26,35,27,29,27,35,
29,35,29,35,29,35,29,34,29,27,29,30,29,26,25,29,
30,26,26,35,25,25,32,27,17,29,29,28,29,29,31,32,
32,16,16,16,19,21,16,33,46,46,47,32,32,33,29,38,
37,30,23,23,21,23,23,21,22,29,28,23,14,17,15,14,
20,19,31,28,28,29,41,29,28,26,26,26,26,25,25,26,
25,36,27,27,28,34,15,29,25,30,25,25,46,50,46,37,
28,40,48,34,32,29,30,22,22,11,16,16,17,20,29,20,
13,22,13,13,13,11,11,18,18,21,21,18,18,12,29,19,
19,12,29,19,19,15,15,11,11,16,16,16,17,8,21,20,
11,16,20,18,18,29,24,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,13,13,0,13,13,23,41,
13,42,51,31,42,50,44,17,35,31,28,33,29,30,38,36,
18,34,35,47,38,30,35,37,30,30,32,34,38,36,40,37,
18,34,30,24,31,17,29,30,29,28,27,24,23,30,29,17,
30,31,31,29,26,29,28,24,28,25,29,37,28,39,41,17,
29,29,29,41,28,29,36,52,36,39,35,27,32,29,32,29,
32,29,31,25,34,30,34,30,34,30,34,30,34,30,29,27,
29,27,29,27,29,27,29,27,28,18,34,28,38,32,38,32,
38,32,38,32,38,32,17,16,17,16,34,29,34,29,34,29,
28,16,28,16,28,16,28,16,47,47,47,47,47,47,38,32,
38,32,38,32,38,32,35,29,35,29,35,29,35,29,30,31,
30,31,33,23,33,23,33,23,33,23,28,22,28,22,28,22,
28,22,28,22,32,20,32,20,32,20,32,20,38,31,38,31,
38,31,38,31,38,31,38,29,38,29,49,41,49,41,49,41,
49,41,49,41,36,29,36,29,34,29,30,26,30,26,30,26,
32,20,41,29,27,18,35,27,35,27,35,27,35,27,35,27,
35,27,35,27,35,27,35,27,35,27,35,27,35,27,29,27,
29,27,29,27,29,27,29,27,29,27,29,27,29,27,17,16,
17,16,35,29,35,29,35,29,35,29,35,29,35,29,35,29,
35,31,35,31,35,31,35,31,35,31,38,31,38,31,40,36,
40,36,40,36,40,36,40,36,34,29,34,29,34,29,34,29,
30,30,30,30,30,30,30,30,39,39,48,49,47,47,39,39,
24,24,24,24,24,24,40,40,49,50,47,47,31,31,31,31,
31,31,31,31,49,49,58,59,57,57,49,49,17,17,17,17,
17,17,17,17,29,29,38,39,37,37,29,29,29,29,29,29,
29,29,44,44,54,54,49,49,29,29,29,29,29,29,29,29,
48,58,55,48,41,41,41,41,41,41,41,41,46,46,55,56,
51,51,46,46,30,30,24,24,31,31,17,17,29,29,29,29,
41,41,30,30,30,30,30,30,30,30,56,56,66,66,64,64,
56,56,31,31,31,31,31,31,31,31,66,66,75,76,74,74,
66,66,41,41,41,41,41,41,41,41,63,63,72,73,71,71,
63,63,30,30,30,30,30,30,30,35,35,41,41,52,11,17,
11,23,23,31,31,31,31,31,42,42,51,51,55,20,19,11,
17,17,17,17,17,17,18,18,31,31,21,19,11,29,29,29,
29,28,28,29,29,34,34,50,50,41,23,23,13,41,41,41,
41,41,46,42,48,44,54,13,11,27,44,27,44,15,11,7,
27,13,9,3,0,20,20,27,55,23,23,13,25,15,13,26,
14,19,19,19,19,19,19,19,17,14,18,13,13,22,19,19,
19,19,19,19,19,19,19,19,17,14,18,13,13,27,27,27,
27,31,27,51,38,27,27,27,27,52,27,24,9,15,0,0,
0,0,0,0,0,0,36,52,52,19,16,15,23,29,19,16,
15,21,21,19,19,11,23,0,0,0,0,0,0,0,0,0,
0,27,27,27,27,27,27,27,27,27,16,16,16,16,32,29,
29,29,29,29,31,31,31,31,29,29,27,25,25,25,25,27,
27,27,28,28,16,16,16,31,15,32,32,29,23,23,22,22,
22,31,31,41,29,26,26,26,60,56,43,31,53,47,27,16,
29,31,31,31,31,31,27,27,40,28,29,26,15,28,32,40,
29,27,29,29,29,29,29,29,25,30,27,27,28,16,16,47,
47,32,29,29,29,29,31,31,23,23,22,22,22,22,31,31,
29,41,41,41,41,29,29,29,26,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,16,29,29,29,29,29,31,31,31,
36,36,36,29,29,0,23,23,11,11,30,30,39,39,31,31,
52,52,17,17,32,32,29,29,49,41,41,46,46,30,30,56,
56,31,31,70,70,41,41,63,63,30,30,31,31,17,17,29,
29,41,41,0,0,0,0,0,0,0,34,52,28,17,18,35,
32,31,28,36,29,51,30,38,38,35,36,47,38,35,37,30,
31,32,38,38,36,37,36,50,50,41,44,32,31,51,33,27,
28,27,24,32,27,42,24,33,31,29,32,39,33,29,32,31,
25,28,29,39,29,33,32,46,46,34,40,27,27,42,29,22,
16,15,17,36,45,40,32,26,30,26,35,29,34,0,0,0,
67,88,15,0,15,15,31,46,44,17,21,21,30,27,15,23,
15,31,31,31,32,31,32,31,31,31,31,31,15,15,29,29,
29,29,54,40,37,36,40,33,32,39,44,20,20,39,32,54,
43,40,35,40,38,32,37,44,44,57,41,40,35,21,31,21,
33,31,21,31,34,29,35,31,21,33,37,18,17,34,18,53,
37,34,36,35,27,26,23,36,33,47,34,33,30,22,15,22,
33,15,18,31,31,31,31,32,26,48,17,33,31,24,33,24,
27,21,36,37,10,15,19,33,29,40,40,40,40,40,40,52,
36,33,33,33,33,20,20,20,20,43,40,40,40,40,40,40,
44,44,44,44,38,31,31,31,31,31,31,47,29,31,31,31,
31,18,18,18,18,37,34,34,34,34,34,27,34,36,36,36,
36,33,18,53,53,40,19,24,24,24,13,17,17,27,25,35,
31,51,15,15,15,29,29,30,32,32,19,45,69,20,20,38,
39,39,31,18,28,15,23,22,22,22,39,39,39,40,27,40,
35,33,33,36,40,31,40,31,40,31,36,29,36,29,36,29,
36,29,40,45,40,35,33,31,33,31,33,31,33,31,33,31,
39,33,39,33,39,33,39,33,44,37,44,37,20,18,20,18,
20,18,20,18,20,40,36,20,17,39,34,34,32,18,32,18,
32,29,32,28,32,18,43,37,43,37,43,37,45,40,37,40,
34,40,34,40,34,38,27,38,27,38,27,32,26,32,26,32,
26,32,26,37,23,37,23,37,23,44,36,44,36,44,36,44,
36,44,36,44,36,57,47,40,33,35,30,35,30,35,30,21,
34,44,37,34,37,35,36,36,29,40,47,37,35,33,33,37,
34,32,39,40,53,23,20,41,34,21,35,63,43,37,40,40,
36,61,50,43,34,37,32,26,35,17,23,40,23,37,46,41,
43,41,47,33,35,30,35,36,30,30,29,34,30,28,34,15,
26,21,18,75,69,64,52,49,36,64,61,54,40,31,20,18,
40,34,44,36,44,36,44,36,44,36,44,36,30,40,31,40,
31,52,46,39,33,39,33,39,34,40,34,40,34,35,30,17,
75,69,64,39,33,62,36,43,37,40,31,52,46,40,34,40,
31,40,31,33,31,33,31,20,18,20,18,40,34,40,34,38,
27,38,27,44,36,44,36,32,26,37,23,34,29,44,37,38,
34,35,30,40,31,33,31,40,34,40,34,40,34,40,34,40,
33,32,33,34,34,30,29,34,35,31,30,40,29,29,37,32,
19,34,34,33,33,33,36,37,37,18,19,19,22,24,18,38,
53,53,52,37,37,38,34,44,43,37,27,27,24,27,27,24,
25,34,32,26,16,19,17,17,23,22,36,32,33,33,47,33,
32,30,30,30,30,29,29,31,29,41,33,32,33,39,17,33,
29,35,29,29,53,57,54,43,32,46,56,40,37,34,35,26,
26,12,19,19,19,23,33,23,15,26,15,15,15,13,13,20,
20,24,24,21,21,14,33,21,21,14,33,21,21,17,17,13,
13,18,18,18,20,9,24,23,13,18,24,20,21,33,28,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,15,15,0,15,15,26,47,15,48,59,36,49,57,50,20,
40,37,32,38,33,35,44,41,21,39,40,54,43,35,40,42,
35,35,37,39,44,41,47,42,21,39,35,28,36,20,34,35,
34,32,32,28,27,36,33,20,34,35,36,34,30,33,32,27,
32,29,34,44,33,44,47,20,34,33,34,47,32,33,42,60,
42,46,40,31,37,34,37,34,37,34,36,29,40,35,40,35,
40,35,40,35,40,35,33,31,33,31,33,31,33,31,33,31,
32,21,39,33,44,37,44,37,44,37,44,37,44,37,20,18,
20,18,39,34,39,34,39,34,32,18,32,18,32,18,32,18,
54,54,54,54,54,54,43,37,43,37,43,37,43,37,40,34,
40,34,40,34,40,34,35,36,35,36,38,27,38,27,38,27,
38,27,32,26,32,26,32,26,32,26,32,26,37,23,37,23,
37,23,37,23,44,36,44,36,44,36,44,36,44,36,44,33,
44,33,57,47,57,47,57,47,57,47,57,47,41,34,41,34,
40,33,35,30,35,30,35,30,37,23,47,33,31,21,40,31,
40,31,40,31,40,31,40,31,40,31,40,31,40,31,40,31,
40,31,40,31,40,31,33,31,33,31,33,31,33,31,33,31,
33,31,33,31,33,31,20,18,20,18,40,34,40,34,40,34,
40,34,40,34,40,34,40,34,40,36,40,36,40,36,40,36,
40,36,44,36,44,36,46,41,46,41,46,41,46,41,46,41,
40,33,40,33,40,33,40,33,35,35,35,35,35,35,35,35,
45,45,56,57,54,54,45,45,28,28,28,28,28,28,46,46,
57,57,55,55,36,36,36,36,36,36,36,36,56,56,67,68,
65,65,56,56,20,20,20,20,20,20,20,20,33,33,44,45,
42,42,33,33,33,33,33,33,33,33,51,51,62,63,57,57,
34,34,34,34,34,34,34,34,55,67,64,55,47,47,47,47,
47,47,47,47,53,53,64,64,59,59,53,53,35,35,28,28,
36,36,20,20,33,33,34,34,47,47,35,35,35,35,35,35,
35,35,65,65,76,76,74,74,65,65,36,36,36,36,36,36,
36,36,76,76,87,88,85,85,76,76,47,47,47,47,47,47,
47,47,73,73,84,84,82,82,73,73,35,35,35,35,35,35,
35,40,40,47,47,60,13,20,13,27,27,36,36,36,36,36,
48,48,59,59,64,24,22,13,20,20,20,20,20,20,21,21,
35,36,24,22,13,34,34,34,34,32,32,34,34,39,39,57,
57,48,26,26,15,47,47,47,47,47,53,49,55,50,62,15,
13,31,51,31,51,17,13,9,31,15,10,3,0,23,23,31,
64,27,26,15,29,17,15,30,16,22,22,22,22,22,22,22,
19,16,21,15,15,26,22,22,22,22,22,22,22,22,22,22,
19,16,21,15,15,31,31,31,31,36,31,58,43,31,31,31,
31,61,31,27,10,17,0,0,0,0,0,0,0,0,42,60,
60,21,18,17,26,33,21,18,17,24,24,21,21,13,27,0,
0,0,0,0,0,0,0,0,0,31,31,31,31,31,31,31,
31,31,18,18,18,18,37,34,34,34,34,34,36,36,36,36,
33,33,31,29,29,29,29,31,31,31,33,33,18,18,18,36,
17,37,37,34,27,27,26,26,26,36,36,47,33,30,30,30,
69,64,49,36,61,54,31,18,34,36,36,36,36,36,31,31,
46,33,34,30,17,33,37,46,34,31,34,34,34,34,33,34,
29,35,31,31,33,18,18,54,54,37,34,34,34,34,36,36,
27,27,26,26,26,26,36,36,33,47,47,47,47,34,34,33,
30,31,31,31,31,31,31,31,31,31,31,31,31,31,31,18,
34,34,34,34,34,36,36,36,41,41,41,33,33,0,27,27,
13,13,35,35,45,45,36,36,61,61,20,20,37,37,34,34,
57,47,47,53,53,35,35,65,65,36,36,80,80,47,47,73,
73,35,35,36,36,20,20,34,34,47,47,0,0,0,0,0,
0,0,39,60,32,20,20,40,37,37,32,42,33,59,35,44,
44,41,42,54,44,40,42,35,36,37,44,44,41,42,42,56,
56,48,51,37,36,58,38,31,33,31,28,36,31,48,29,38,
36,34,36,45,38,34,37,36,29,33,33,46,34,38,37,51,
52,39,46,32,31,50,33,26,18,17,20,41,52,47,37,30,
35,30,40,34,39,0,0,0,75,98,17,0,17,17,36,52,
50,19,24,24,34,31,17,25,17,35,35,35,35,35,35,35,
35,35,35,35,17,17,33,33,33,33,61,45,40,40,44,37,
36,44,49,22,23,43,36,60,49,45,39,45,42,36,41,49,
49,64,46,45,39,23,35,23,37,35,24,34,38,33,39,35,
23,36,41,20,19,38,20,60,41,38,40,39,30,29,26,40,
37,53,38,37,33,26,17,25,37,17,20,35,35,35,35,35,
29,54,19,36,35,26,37,27,31,24,40,42,11,17,21,36,
32,45,45,45,45,45,45,58,40,37,37,37,37,22,22,22,
22,49,45,45,45,45,45,45,49,49,49,49,42,34,34,34,
34,34,34,52,33,35,35,35,35,20,20,20,20,41,38,38,
38,38,38,31,38,40,40,40,40,37,20,60,59,45,22,27,
27,27,15,19,19,30,28,39,35,57,17,17,17,33,33,34,
36,36,21,51,76,23,23,41,44,44,35,20,32,17,25,25,
25,25,44,44,44,44,31,45,39,37,37,40,45,34,45,34,
45,34,40,33,40,33,40,33,40,33,44,51,44,39,37,35,
37,35,37,35,37,35,37,35,44,37,44,37,44,37,44,37,
49,41,49,41,22,20,22,20,22,20,22,20,22,45,40,23,
19,43,38,38,36,20,36,20,36,32,36,31,36,20,49,41,
49,41,49,41,51,45,41,45,38,45,38,45,38,42,30,42,
30,42,30,36,29,36,29,36,29,36,29,41,26,41,26,41,
26,49,40,49,40,49,40,49,40,49,40,49,40,64,53,45,
37,39,33,39,33,39,33,23,38,48,41,38,41,39,40,40,
33,44,52,41,39,37,37,41,38,36,44,45,60,26,22,46,
38,24,40,71,49,41,45,45,40,68,56,47,38,41,36,29,
39,19,26,45,26,41,51,46,48,46,53,37,39,33,39,40,
34,34,32,38,34,31,38,16,29,23,20,84,78,72,59,55,
40,72,68,61,45,34,22,20,45,38,49,40,49,40,49,40,
49,40,49,40,34,45,34,45,34,58,52,44,36,44,37,43,
38,45,38,45,38,39,34,19,84,78,72,44,37,68,40,49,
41,45,34,58,52,45,38,45,34,45,34,37,35,37,35,22,
20,22,20,45,38,45,38,42,30,42,30,49,40,49,40,36,
29,41,26,38,32,49,41,42,37,39,33,45,34,37,35,45,
38,45,38,45,38,45,38,45,37,35,37,38,38,34,33,38,
39,34,34,45,32,32,42,35,22,38,38,37,37,37,40,41,
41,20,21,21,25,27,20,43,59,59,60,41,42,43,38,50,
48,41,30,29,27,30,30,27,27,38,36,29,18,22,19,18,
26,25,40,36,36,37,53,37,36,33,33,34,34,32,32,34,
32,46,35,35,37,43,19,37,33,39,32,32,60,65,60,47,
35,51,63,44,41,38,39,29,29,14,21,21,22,25,37,26,
17,29,17,17,17,14,14,23,23,27,27,23,23,15,37,24,
24,15,37,24,24,19,19,14,14,21,21,21,22,10,27,26,
14,20,26,23,23,37,31,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,17,17,0,17,17,30,53,
17,54,66,40,55,64,56,22,45,40,36,43,37,39,49,46,
24,43,45,60,49,39,45,47,39,39,41,44,49,46,51,47,
24,44,39,32,40,22,38,39,37,36,35,32,30,40,37,22,
38,40,40,38,33,37,36,31,36,32,38,48,36,50,53,22,
38,37,38,53,35,37,47,67,47,51,45,34,41,38,41,38,
41,38,40,33,44,39,44,39,44,39,44,39,44,39,37,35,
37,35,37,35,37,35,37,35,36,23,44,37,49,41,49,41,
49,41,49,41,49,41,22,20,22,20,43,38,43,38,43,38,
36,20,36,20,36,20,36,20,60,60,60,60,60,60,49,41,
49,41,49,41,49,41,45,38,45,38,45,38,45,38,39,40,
39,40,42,30,42,30,42,30,42,30,36,29,36,29,36,29,
36,29,36,29,41,26,41,26,41,26,41,26,49,40,49,40,
49,40,49,40,49,40,49,37,49,37,64,53,64,53,64,53,
64,53,64,53,46,38,46,38,45,37,39,33,39,33,39,33,
41,26,53,37,34,23,45,34,45,34,45,34,45,34,45,34,
45,34,45,34,45,34,45,34,45,34,45,34,45,34,37,35,
37,35,37,35,37,35,37,35,37,35,37,35,37,35,22,20,
22,20,45,38,45,38,45,38,45,38,45,38,45,38,45,38,
45,40,45,40,45,40,45,40,45,40,49,40,49,40,51,46,
51,46,51,46,51,46,51,46,45,37,45,37,45,37,45,37,
39,39,39,39,39,39,39,39,50,50,63,63,60,60,50,50,
32,32,32,32,32,32,51,51,64,64,61,61,40,40,40,40,
40,40,40,40,63,63,75,76,73,73,63,63,22,22,22,22,
22,22,22,22,37,37,49,50,47,47,37,37,37,37,37,37,
37,37,57,57,70,70,64,64,38,38,38,38,38,38,38,38,
61,74,72,61,53,53,53,53,53,53,53,53,59,59,71,72,
66,66,59,59,39,39,32,32,40,40,22,22,37,37,38,38,
53,53,39,39,39,39,39,39,39,39,72,72,85,85,83,83,
72,72,40,40,40,40,40,40,40,40,85,85,98,98,95,95,
85,85,53,53,53,53,53,53,53,53,81,81,94,94,91,91,
81,81,39,39,39,39,39,39,39,45,45,53,53,67,14,22,
14,30,30,40,40,40,40,40,54,54,66,66,71,26,24,14,
22,22,22,22,22,22,24,24,40,40,27,24,14,38,38,38,
38,36,36,38,38,44,44,64,64,53,30,30,17,53,53,53,
53,53,60,55,62,56,70,17,14,35,57,35,57,19,15,10,
35,17,11,4,0,25,25,35,71,30,29,17,33,19,17,34,
18,25,25,25,25,25,25,25,22,18,23,17,17,29,25,25,
25,25,25,25,25,25,25,25,22,18,23,17,17,35,35,35,
35,40,35,65,48,35,35,35,35,67,35,31,11,19,0,0,
0,0,0,0,0,0,47,67,67,24,20,19,29,37,24,20,
19,27,27,24,24,15,30,0,0,0,0,0,0,0,0,0,
0,34,34,34,34,34,35,35,35,35,20,20,20,20,41,38,
38,38,38,38,40,40,40,40,37,37,34,33,33,33,33,35,
35,35,37,37,20,20,20,40,19,41,41,38,30,30,29,29,
29,40,40,53,37,33,33,33,78,72,55,40,68,61,34,20,
38,40,40,40,40,40,34,34,52,37,38,34,19,37,41,52,
38,34,38,38,38,38,37,38,33,39,35,35,37,20,20,60,
60,41,38,38,38,38,40,40,30,30,29,29,29,29,40,40,
37,53,53,53,53,38,38,37,33,34,34,34,34,34,34,34,
34,35,35,35,35,35,35,20,38,38,38,38,38,40,40,40,
46,46,46,37,37,0,30,30,14,14,39,39,50,50,40,40,
68,68,22,22,41,41,38,38,64,53,53,59,59,39,39,72,
72,40,40,90,90,53,53,81,81,39,39,40,40,22,22,38,
38,53,53,0,0,0,0,0,0,0,44,67,36,22,23,45,
41,40,36,47,37,67,38,49,49,45,47,60,49,45,47,39,
40,41,49,49,46,47,46,64,64,54,57,41,40,64,42,34,
37,34,31,41,35,54,32,43,40,38,41,50,43,38,41,40,
33,37,37,50,38,42,41,57,58,44,51,35,35,55,37,29,
20,19,22,46,58,52,41,34,39,34,45,38,44,0,0,0,
0,0,0,1,0,0,67,4,0,1,11,41,48,0,0,11,
18,246,0,12,0,193,255,36,0,12,0,196,255,36,0,14,
0,193,255,36,0,14,0,196,255,36,0,33,0,35,255,226,
0,33,0,39,255,226,0,33,0,47,255,226,0,33,0,49,
255,226,0,33,0,52,255,156,0,33,0,53,255,176,0,33,
0,54,255,96,0,33,0,55,255,136,0,33,0,57,255,76,
0,33,0,86,255,156,0,33,0,87,255,176,0,33,0,89,
255,156,0,33,0,193,255,56,0,33,0,196,255,56,0,35,
0,33,255,196,0,36,0,33,255,196,0,36,0,54,0,40,
0,36,0,55,255,236,0,36,0,57,255,196,0,38,0,12,
255,56,0,38,0,14,255,56,0,38,0,33,255,106,0,38,
0,65,255,176,0,38,0,69,255,176,0,38,0,79,255,176,
0,43,0,47,255,196,0,44,0,52,255,126,0,44,0,54,
255,76,0,44,0,55,255,196,0,44,0,57,255,116,0,44,
0,193,255,56,0,44,0,196,255,56,0,47,0,33,255,196,
0,47,0,54,255,196,0,47,0,56,255,206,0,47,0,57,
255,196,0,48,0,12,255,56,0,48,0,14,255,56,0,48,
0,33,255,136,0,50,0,52,255,216,0,50,0,54,255,176,
0,50,0,55,255,196,0,52,0,12,255,126,0,52,0,14,
255,126,0,52,0,33,255,136,0,52,0,65,255,176,0,52,
0,69,255,176,0,52,0,79,255,176,0,53,0,33,255,156,
0,54,0,12,254,252,0,54,0,14,254,252,0,54,0,33,
255,56,0,54,0,39,255,176,0,54,0,47,255,176,0,54,
0,65,255,136,0,54,0,69,255,136,0,54,0,79,255,136,
0,55,0,12,255,56,0,55,0,14,255,56,0,55,0,33,
255,96,0,55,0,47,255,216,0,55,0,65,255,176,0,55,
0,69,255,176,0,55,0,79,255,176,0,57,0,12,255,56,
0,57,0,14,255,56,0,57,0,33,255,96,0,57,0,47,
255,176,0,57,0,51,255,216,0,57,0,65,255,136,0,57,
0,69,255,136,0,57,0,79,255,136,0,65,0,86,255,226,
0,65,0,87,255,226,0,67,0,72,255,226,0,67,0,75,
255,226,0,67,0,76,255,226,0,69,0,88,255,226,0,70,
0,193,0,220,0,70,0,196,0,220,0,75,0,69,255,216,
0,75,0,79,255,216,0,79,0,86,255,216,0,79,0,87,
255,226,0,79,0,88,255,216,0,82,0,12,255,106,0,82,
0,14,255,106,0,82,0,65,255,236,0,82,0,67,255,226,
0,82,0,68,255,236,0,82,0,69,255,226,0,82,0,79,
255,226,0,82,0,81,255,226,0,86,0,12,255,56,0,86,
0,14,255,56,0,86,0,65,255,216,0,86,0,69,255,206,
0,86,0,79,255,216,0,87,0,12,255,106,0,87,0,14,
255,106,0,87,0,65,255,226,0,87,0,69,255,216,0,87,
0,79,255,226,0,88,0,69,255,226,0,88,0,79,255,216,
0,89,0,12,255,56,0,89,0,14,255,56,0,89,0,65,
255,226,0,89,0,69,255,216,0,89,0,79,255,216,0,192,
0,33,255,56,0,195,0,33,255,56,2,245,3,5,255,225,
2,245,3,12,255,225,2,245,3,16,255,135,2,245,3,17,
255,55,2,245,3,18,255,197,2,245,3,20,255,96,2,245,
3,23,255,55,2,245,3,28,255,225,2,245,3,31,255,135,
2,245,3,41,255,135,2,245,3,47,255,166,2,245,3,48,
255,225,2,245,3,50,255,135,2,245,3,54,255,225,2,245,
3,56,255,225,2,245,4,126,255,225,2,245,4,127,255,225,
2,245,4,128,255,225,2,245,4,129,255,225,2,245,4,130,
255,225,2,245,4,131,255,225,2,245,4,132,255,225,2,245,
4,133,255,225,2,245,4,164,255,225,2,245,4,165,255,225,
2,245,5,3,255,225,2,245,5,4,255,225,2,245,5,5,
255,225,2,245,5,6,255,225,2,245,5,9,255,225,2,245,
5,10,255,225,2,245,5,11,255,55,2,245,5,12,255,55,
2,245,6,44,255,225,2,245,6,45,255,225,2,245,6,69,
255,225,2,245,6,70,255,225,2,250,2,254,255,207,2,250,
3,8,255,207,2,250,3,15,255,207,2,250,3,17,255,197,
2,250,3,19,255,197,2,250,3,20,255,236,2,250,3,23,
255,197,2,250,4,223,255,207,2,250,4,224,255,207,2,250,
5,11,255,197,2,250,5,12,255,197,2,251,0,189,255,176,
2,251,2,253,255,207,2,251,2,254,255,135,2,251,3,1,
255,135,2,251,3,5,255,215,2,251,3,8,255,76,2,251,
3,12,255,215,2,251,3,18,255,176,2,251,3,20,0,41,
2,251,3,21,255,215,2,251,3,24,255,96,2,251,3,25,
255,96,2,251,3,27,255,207,2,251,3,29,255,96,2,251,
3,30,255,225,2,251,3,31,255,176,2,251,3,32,255,215,
2,251,3,33,255,96,2,251,3,37,255,207,2,251,3,40,
255,207,2,251,3,41,255,207,2,251,3,43,255,96,2,251,
3,44,255,96,2,251,3,46,255,96,2,251,3,47,255,156,
2,251,3,49,255,96,2,251,3,51,255,176,2,251,3,53,
255,207,2,251,3,55,255,96,2,251,4,54,255,96,2,251,
4,55,255,96,2,251,4,56,255,96,2,251,4,57,255,96,
2,251,4,58,255,96,2,251,4,59,255,96,2,251,4,60,
255,96,2,251,4,61,255,96,2,251,4,70,255,96,2,251,
4,71,255,96,2,251,4,72,255,96,2,251,4,73,255,96,
2,251,4,74,255,96,2,251,4,75,255,96,2,251,4,98,
255,207,2,251,4,99,255,207,2,251,4,100,255,207,2,251,
4,101,255,207,2,251,4,102,255,207,2,251,4,103,255,207,
2,251,4,104,255,207,2,251,4,105,255,207,2,251,4,114,
255,96,2,251,4,115,255,96,2,251,4,116,255,96,2,251,
4,117,255,96,2,251,4,118,255,96,2,251,4,119,255,96,
2,251,4,154,255,96,2,251,4,155,255,96,2,251,4,156,
255,96,2,251,4,157,255,96,2,251,4,160,255,207,2,251,
4,161,255,207,2,251,4,162,255,96,2,251,4,163,255,96,
2,251,4,168,255,96,2,251,4,169,255,96,2,251,4,170,
255,96,2,251,4,171,255,96,2,251,4,172,255,96,2,251,
4,173,255,96,2,251,4,174,255,96,2,251,4,175,255,96,
2,251,4,216,255,96,2,251,4,217,29,40,2,251,4,218,
29,40,2,251,4,219,29,40,2,251,4,220,29,40,2,251,
4,221,29,40,2,251,4,222,29,40,2,251,4,223,255,135,
2,251,4,224,255,135,2,251,4,229,255,207,2,251,4,246,
255,207,2,251,4,247,255,207,2,251,4,248,255,207,2,251,
4,249,255,207,2,251,4,250,255,207,2,251,4,251,255,207,
2,251,6,32,255,96,2,251,6,33,255,96,2,251,6,40,
255,207,2,251,6,41,255,207,2,251,6,51,255,96,2,251,
6,52,255,96,2,251,6,63,29,40,2,251,6,64,29,40,
2,251,6,67,255,207,2,251,6,68,255,207,2,252,3,17,
255,176,2,252,3,19,255,215,2,252,3,20,255,215,2,252,
3,23,255,176,2,252,5,11,255,176,2,252,5,12,255,176,
2,253,3,31,255,225,2,253,3,39,0,49,2,253,3,41,
255,207,2,253,3,50,255,207,2,254,3,5,255,225,2,254,
3,12,255,225,2,254,3,16,255,135,2,254,3,17,255,55,
2,254,3,18,255,197,2,254,3,20,255,96,2,254,3,23,
255,55,2,254,3,28,255,225,2,254,3,31,255,135,2,254,
3,41,255,135,2,254,3,47,255,166,2,254,3,48,255,225,
2,254,3,50,255,135,2,254,3,54,255,225,2,254,3,56,
255,225,2,254,4,126,255,225,2,254,4,127,255,225,2,254,
4,128,255,225,2,254,4,129,255,225,2,254,4,130,255,225,
2,254,4,131,255,225,2,254,4,132,255,225,2,254,4,133,
255,225,2,254,4,164,255,225,2,254,4,165,255,225,2,254,
5,3,255,225,2,254,5,4,255,225,2,254,5,5,255,225,
2,254,5,6,255,225,2,254,5,9,255,225,2,254,5,10,
255,225,2,254,5,11,255,55,2,254,5,12,255,55,2,254,
6,44,255,225,2,254,6,45,255,225,2,254,6,69,255,225,
2,254,6,70,255,225,2,255,2,254,255,207,2,255,3,8,
255,207,2,255,3,17,255,135,2,255,3,23,255,135,2,255,
3,27,255,225,2,255,3,31,255,215,2,255,3,37,255,225,
2,255,3,44,255,225,2,255,4,160,255,225,2,255,4,161,
255,225,2,255,4,223,255,207,2,255,4,224,255,207,2,255,
4,229,255,225,2,255,4,246,255,225,2,255,4,247,255,225,
2,255,4,250,255,225,2,255,5,11,255,135,2,255,5,12,
255,135,2,255,6,67,255,225,3,0,2,254,255,135,3,0,
3,1,255,166,3,0,3,8,255,135,3,0,3,24,255,156,
3,0,3,25,255,156,3,0,3,29,255,156,3,0,3,33,
255,156,3,0,3,43,255,135,3,0,3,44,255,96,3,0,
3,52,255,135,3,0,3,55,255,135,3,0,3,57,255,135,
3,0,4,154,255,156,3,0,4,155,255,156,3,0,4,156,
255,156,3,0,4,157,255,156,3,0,4,162,255,135,3,0,
4,163,255,135,3,0,4,166,255,135,3,0,4,167,255,135,
3,0,4,216,255,156,3,0,4,217,255,156,3,0,4,218,
255,156,3,0,4,219,255,156,3,0,4,220,255,156,3,0,
4,221,255,156,3,0,4,222,255,156,3,0,4,223,255,135,
3,0,4,224,255,135,3,0,5,19,255,135,3,0,5,20,
255,135,3,0,5,21,255,135,3,0,5,22,255,135,3,0,
5,23,255,135,3,0,6,63,255,156,3,0,6,64,255,156,
3,0,6,71,255,135,3,0,6,72,255,135,3,1,3,17,
255,106,3,1,3,23,255,106,3,1,3,27,255,207,3,1,
3,35,255,225,3,1,3,37,255,207,3,1,3,41,255,156,
3,1,3,48,255,207,3,1,3,56,255,207,3,1,4,126,
255,207,3,1,4,127,255,207,3,1,4,128,255,207,3,1,
4,129,255,207,3,1,4,130,255,207,3,1,4,131,255,207,
3,1,4,132,255,207,3,1,4,133,255,207,3,1,4,160,
255,207,3,1,4,161,255,207,3,1,4,164,255,207,3,1,
4,165,255,207,3,1,4,229,255,207,3,1,4,246,255,207,
3,1,4,247,255,207,3,1,4,250,255,207,3,1,5,3,
255,207,3,1,5,4,255,207,3,1,5,9,255,207,3,1,
5,11,255,106,3,1,5,12,255,106,3,1,6,44,255,207,
3,1,6,45,255,207,3,1,6,67,255,207,3,1,6,69,
255,207,3,5,2,254,255,207,3,5,3,8,255,207,3,5,
3,17,255,225,3,5,3,23,255,225,3,5,4,223,255,207,
3,5,4,224,255,207,3,5,5,11,255,225,3,5,5,12,
255,225,3,7,3,5,255,215,3,7,3,12,255,215,3,7,
3,18,255,156,3,7,3,27,255,225,3,7,3,37,255,225,
3,7,3,41,255,156,3,7,3,47,255,156,3,7,3,48,
255,207,3,7,3,56,255,207,3,7,4,126,255,207,3,7,
4,127,255,207,3,7,4,128,255,207,3,7,4,129,255,207,
3,7,4,130,255,207,3,7,4,131,255,207,3,7,4,132,
255,207,3,7,4,133,255,207,3,7,4,160,255,225,3,7,
4,161,255,225,3,7,4,164,255,207,3,7,4,165,255,207,
3,7,4,229,255,225,3,7,4,246,255,225,3,7,4,247,
255,225,3,7,4,250,255,225,3,7,5,3,255,207,3,7,
5,4,255,207,3,7,5,9,255,207,3,7,6,44,255,207,
3,7,6,45,255,207,3,7,6,67,255,225,3,7,6,69,
255,207,3,8,3,16,255,135,3,8,3,17,255,55,3,8,
3,18,255,197,3,8,3,23,255,55,3,8,3,27,255,225,
3,8,3,37,255,225,3,8,3,48,255,215,3,8,3,56,
255,215,3,8,4,126,255,215,3,8,4,127,255,215,3,8,
4,128,255,215,3,8,4,129,255,215,3,8,4,130,255,215,
3,8,4,131,255,215,3,8,4,132,255,215,3,8,4,133,
255,215,3,8,4,160,255,225,3,8,4,161,255,225,3,8,
4,164,255,215,3,8,4,165,255,215,3,8,4,229,255,225,
3,8,4,246,255,225,3,8,4,247,255,225,3,8,4,250,
255,225,3,8,5,3,255,215,3,8,5,4,255,215,3,8,
5,9,255,215,3,8,5,11,255,55,3,8,5,12,255,55,
3,8,6,44,255,215,3,8,6,45,255,215,3,8,6,67,
255,225,3,8,6,69,255,215,3,12,2,254,255,207,3,12,
3,8,255,207,3,12,3,15,255,207,3,12,3,17,255,197,
3,12,3,19,255,197,3,12,3,20,255,236,3,12,3,23,
255,197,3,12,4,223,255,207,3,12,4,224,255,207,3,12,
5,11,255,197,3,12,5,12,255,197,3,14,2,254,255,135,
3,14,3,1,255,156,3,14,3,8,255,135,3,14,4,223,
255,135,3,14,4,224,255,135,3,16,2,254,255,135,3,16,
3,8,255,135,3,16,3,18,255,225,3,16,3,24,255,176,
3,16,3,25,255,176,3,16,3,29,255,176,3,16,3,33,
255,176,3,16,3,43,255,135,3,16,3,44,255,117,3,16,
3,46,255,106,3,16,3,52,255,135,3,16,3,55,255,135,
3,16,3,57,255,135,3,16,4,154,255,176,3,16,4,155,
255,176,3,16,4,156,255,176,3,16,4,157,255,176,3,16,
4,162,255,135,3,16,4,163,255,135,3,16,4,166,255,135,
3,16,4,167,255,135,3,16,4,216,255,176,3,16,4,217,
255,176,3,16,4,218,255,176,3,16,4,219,255,176,3,16,
4,220,255,176,3,16,4,221,255,176,3,16,4,222,255,176,
3,16,4,223,255,135,3,16,4,224,255,135,3,16,5,19,
255,135,3,16,5,20,255,135,3,16,5,21,255,135,3,16,
5,22,255,135,3,16,5,23,255,135,3,16,6,63,255,176,
3,16,6,64,255,176,3,16,6,71,255,135,3,16,6,72,
255,135,3,17,0,189,255,176,3,17,2,254,255,135,3,17,
3,1,255,135,3,17,3,8,255,76,3,17,3,12,255,215,
3,17,3,18,255,176,3,17,3,20,0,41,3,17,3,24,
255,96,3,17,3,25,255,96,3,17,3,27,255,207,3,17,
3,29,255,96,3,17,3,30,255,225,3,17,3,31,255,176,
3,17,3,32,255,215,3,17,3,33,255,96,3,17,3,37,
255,207,3,17,3,40,255,207,3,17,3,41,255,207,3,17,
3,43,255,96,3,17,3,44,255,96,3,17,3,46,255,96,
3,17,3,47,255,156,3,17,3,49,255,96,3,17,3,51,
255,176,3,17,3,55,255,96,3,17,4,98,255,207,3,17,
4,99,255,207,3,17,4,100,255,207,3,17,4,101,255,207,
3,17,4,102,255,207,3,17,4,103,255,207,3,17,4,104,
255,207,3,17,4,105,255,207,3,17,4,154,255,96,3,17,
4,155,255,96,3,17,4,156,255,96,3,17,4,157,255,96,
3,17,4,160,255,207,3,17,4,161,255,207,3,17,4,162,
255,96,3,17,4,163,255,96,3,17,4,216,255,96,3,17,
4,217,255,96,3,17,4,218,255,96,3,17,4,219,255,96,
3,17,4,220,255,96,3,17,4,221,255,96,3,17,4,222,
255,96,3,17,4,223,255,135,3,17,4,224,255,135,3,17,
4,229,255,207,3,17,4,246,255,207,3,17,4,247,255,207,
3,17,4,250,255,207,3,17,6,40,255,207,3,17,6,41,
255,207,3,17,6,63,255,96,3,17,6,64,255,96,3,17,
6,67,255,207,3,18,2,254,255,186,3,18,3,8,255,186,
3,18,3,15,255,176,3,18,3,17,255,156,3,18,3,19,
255,156,3,18,3,23,255,156,3,18,3,39,255,156,3,18,
4,223,255,186,3,18,4,224,255,186,3,18,5,11,255,156,
3,18,5,12,255,156,3,19,3,5,255,197,3,19,3,12,
255,197,3,19,3,18,255,156,3,19,3,24,255,225,3,19,
3,25,255,236,3,19,3,27,255,225,3,19,3,29,255,225,
3,19,3,33,255,236,3,19,3,36,255,225,3,19,3,37,
255,225,3,19,3,41,255,156,3,19,3,43,255,207,3,19,
3,47,255,135,3,19,3,55,255,207,3,19,4,154,255,225,
3,19,4,155,255,225,3,19,4,156,255,236,3,19,4,157,
255,236,3,19,4,160,255,225,3,19,4,161,255,225,3,19,
4,162,255,207,3,19,4,163,255,207,3,19,4,216,255,225,
3,19,4,217,255,225,3,19,4,218,255,225,3,19,4,219,
255,225,3,19,4,220,255,225,3,19,4,221,255,225,3,19,
4,222,255,225,3,19,4,229,255,225,3,19,4,246,255,225,
3,19,4,247,255,225,3,19,4,250,255,225,3,19,6,63,
255,225,3,19,6,64,255,225,3,19,6,67,255,225,3,20,
2,254,255,76,3,20,3,12,255,215,3,20,3,21,255,197,
3,20,3,24,255,156,3,20,3,25,255,156,3,20,3,27,