## optparser.py
## 
## Copyright (C) 2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import os
import string
from os import system, environ, path, getenv, mkdir, getcwd

separator = " = "

class OptionsParser:
    #
    # Get value by key
    #
    def get_value(self, key):
        try:
            return self.optdict[key]
        except:
            try:
                return self.optdict_defaults[key]
            except: 
                return ""
    #
    # Remove unuseful spaces
    #
    def unpad(self, str):
        if str == '':
            return str
        else:            
            splitted = str.split(" ")
            non_empty_list = []
            for sym in splitted:
                if sym == '':
                    pass
                else:
                    non_empty_list.append(sym)
            unpadded_line = string.join(non_empty_list)
            return unpadded_line

    #
    # Read a list of file managers
    #
    def read_filemanager(self):
        self.file_managers = []
        full_filemanager_string = self.optdict["file_managers"]
        self.file_managers = full_filemanager_string.split("|")
        return
    
    #
    # Parse configuration file
    #
    def read(self):
        self.optdict = {}
        try:
            fd = open(self.filename)
        except:
            print "error: no such file or directory - %s" % self.filename
            if os.path.exists(self.filename):
                #we talk about a file
                print "error: cannot open %s for reading" % self.filename
            return

        for line in fd.readlines():
            try:
                line = line.decode('utf-8')
            except UnicodeDecodeError:
                line = line.decode(locale.getpreferredencoding())
            index = line.find(separator)
            var_str = line[0:index]
            value_str = line[index + 3:-1]
            self.optdict[var_str] = value_str

        fd.close()
        return self.optdict
    
    #
    # Write configuration file
    #
    def write(self, dictionary):
        #
        # Clear the options file
        #
        fd = open(self.filename, 'w')
        fd.close()

        fd = open(self.filename, 'a')
        fd.write("mount_directory" + separator + self.unpad(dictionary["mount_directory"]) + "\n")
        fd.write("delete_dirs"     + separator + self.unpad(dictionary["delete_dirs"])     + "\n")
        fd.write("file_managers"   + separator + self.unpad(dictionary["file_managers"])   + "\n")
        fd.write("workgroup"       + separator + self.unpad(dictionary["workgroup"])       + "\n")
        fd.write("client"          + separator + self.unpad(dictionary["client"])          + "\n")
        fd.write("lookup"          + separator + self.unpad(dictionary["lookup"])          + "\n")
        fd.write("enable_smb"      + separator + self.unpad(dictionary["enable_smb"])      + "\n")
        fd.write("smb_mount"       + separator + self.unpad(dictionary["smb_mount"])       + "\n")
        fd.write("smb_umount"      + separator + self.unpad(dictionary["smb_umount"])      + "\n")
        fd.write("smb_options"     + separator + self.unpad(dictionary["smb_options"])     + "\n")
        fd.write("enable_cifs"     + separator + self.unpad(dictionary["enable_cifs"])     + "\n")
        fd.write("cifs_mount"      + separator + self.unpad(dictionary["cifs_mount"])      + "\n")
        fd.write("cifs_umount"     + separator + self.unpad(dictionary["cifs_umount"])     + "\n")
        fd.write("cifs_options"    + separator + self.unpad(dictionary["cifs_options"])    + "\n")
        fd.write("user"            + separator + self.unpad(dictionary["user"])            + "\n")
        fd.write("password"        + separator + self.unpad(dictionary["password"])        + "\n")
        fd.write("anonymous"       + separator + self.unpad(dictionary["anonymous"])       + "\n")
        fd.write("enable_default"  + separator + self.unpad(dictionary["enable_default"])  + "\n")
        fd.write("autoretrieve_ip" + separator + self.unpad(dictionary["autoretrieve_ip"]) + "\n")
        fd.write("msbrowse"        + separator + self.unpad(dictionary["msbrowse"])        + "\n")

        fd.close()
        self.read()
        self.read_filemanager()
        return

    def __init__(self, filename):
        self.filename = filename
        #
        # Dictionary holding the total list
        #
        self.optdict = {}
        self.file_managers = []
        # Define default values 
        self.optdict["mount_directory"] = "/mnt/lan"
        self.optdict["delete_dirs"]     = "False"
        self.optdict["file_managers"]   = "xterm -e mc"
        self.optdict["workgroup"]       = ""
        self.optdict["client"]          = "smbclient"
        self.optdict["lookup"]          = "nmblookup"
        self.optdict["enable_smb"]      = "True"
        self.optdict["smb_mount"]       = "smbmount"
        self.optdict["smb_umount"]      = "smbumount"
        self.optdict["smb_options"]     = ""
        self.optdict["enable_cifs"]     = "True"
        self.optdict["cifs_mount"]      = "mount.cifs"
        self.optdict["cifs_umount"]     = "umount.cifs"
        self.optdict["cifs_options"]    = ""
        self.optdict["user"]            = ""
        self.optdict["password"]        = ""
        self.optdict["anonymous"]       = "True"
        self.optdict["enable_default"]  = "False"
        self.optdict["autoretrieve_ip"] = "False"
        self.optdict["msbrowse"]        = "True"
        
        #
        # Create and remember dictionary with default values
        #
        self.optdict_defaults = self.optdict

        #
        # Check if the configuartion file exists. If no, 
        # create it with default values
        #
        if not path.exists(getenv("HOME")+"/.pyNeighborhood"):
            mkdir(getenv("HOME")+"/.pyNeighborhood")
            home = getenv("HOME")
            hostslocation = string.join([home, "/.pyNeighborhood"], '')
            os.chdir(hostslocation)
            self.write(self.optdict_defaults)

        try: 
            fd = open(self.filename, "r")
        except: 
            self.write(self.optdict_defaults)

        #
        # Necessary to run with constructor
        #
        self.read()
        self.read_filemanager()

