#----------------------------------------------------------------------
from wxPython.wx        import *
from wxPython.glcanvas  import *
from OpenGL.GL          import *
from OpenGL.GLUT        import *

class MyCanvasBase(wxGLCanvas):
	def __init__(self, parent):
		wxGLCanvas.__init__(self, parent, -1)
		self.init = False
		EVT_ERASE_BACKGROUND(self, self.OnEraseBackground)
		EVT_SIZE(self, self.OnSize)
		EVT_PAINT(self, self.OnPaint)

	def OnEraseBackground(self, event):
		pass # Do nothing, to avoid flashing on MSW.

	def OnSize(self, event):
		size = self.GetClientSize()
		if self.GetContext():
			self.SetCurrent()
			glViewport(0, 0, size.width, size.height)

	def OnPaint(self, event):
		dc = wxPaintDC(self)
		self.SetCurrent()
		if not self.init:
			self.InitGL()
			self.init = True
		self.OnDraw()

class RectangleCanvas(MyCanvasBase):
	def InitGL(self):
		glMatrixMode(GL_PROJECTION);
		glFrustum(-0.5, 0.5, -0.5, 0.5, 1.0, 3.0);
		glMatrixMode(GL_MODELVIEW);
		glTranslatef(0.0, 0.0, -2.0);

	def OnDraw(self):
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glColor3f(0.0,0.0,1.0)
		glRectf(-0.5,-0.5,0.5,0.5)

		self.SwapBuffers()

#----------------------------------------------------------------------

def _test():
	class MyApp(wxApp):
		def OnInit(self):
			frame = wxFrame(None, -1, "Test", wxDefaultPosition,
wxSize(600,300))
			win = RectangleCanvas(frame)
			frame.Show(True)
			##self.SetTopWindow(frame)
			return True

	app = MyApp(0)
	app.MainLoop()

if __name__ == '__main__':
	_test()
