#! /usr/bin/env python
"""OpenGL-ctypes setup script (setuptools-based)
"""
from setuptools import setup, find_packages
import sys, os
sys.path.insert(0, '.' )
import metadata

requirements = []
##try:
##	import ctypes 
##except ImportError, err:
##	requirements.append( 'ctypes' )
packages = find_packages( exclude=['*.Demo.*'])


if __name__ == "__main__":
	setup(
		name = "PyOpenGL",
		packages = packages,
		
		description = 'Standard OpenGL bindings for Python',
		include_package_data = False,
		zip_safe = True,
		
		install_requires = requirements,
		entry_points = {
			'OpenGL.arrays.formathandler':[
				'numpy = OpenGL.arrays.numpymodule:NumpyHandler',
				'numarray = OpenGL.arrays.numarrays.NumarrayHandler',
				'numeric = OpenGL.arrays.numeric:NumericHandler',
				'lists = OpenGL.arrays.lists:ListHandler',
				'nones = OpenGL.arrays.nones:NoneHandler',
				'strings = OpenGL.arrays.strings:StringHandler',
				'numbers = OpenGL.arrays.numbers:NumberHandler',
				'ctypesarrays = OpenGL.arrays.ctypesarrays:CtypesArrayHandler',
				'ctypespointers = OpenGL.arrays.ctypespointers:CtypesPointerHandler',
				'ctypesparameters = OpenGL.arrays.ctypesparameters:CtypesParameterHandler',
			],
		},
		**metadata.metadata
	)
