// $Id: SubnetTree.h,v 1.6 2005/04/23 18:46:00 robin Exp $

extern "C" {
#include "Python.h"
#include "patricia.h"
}

#ifdef SWIG
// If a function is supposed to accept 4-byte tuples as packet by
// socket.inet_aton(), it needs to accept strings which contain 0s.
// Therefore, we need a size parameter.
%apply (char *STRING, int LENGTH) { (char *cidr, int size) };
#endif

class SubnetTree
{
public:
   SubnetTree();
   ~SubnetTree();

   bool insert(const char *cidr, PyObject* data = 0);
   bool insert(unsigned long subnet, unsigned short mask, PyObject* data = 0);

   bool remove(const char *cidr);
   bool remove(unsigned long subnet, unsigned short mask);
   
   PyObject* lookup(const char *cidr, int size) const;
   PyObject* lookup(unsigned long addr) const;

#ifndef SWIG   
   bool operator[](const char* addr) const { return lookup(addr, strlen(addr)); }
   bool operator[](unsigned long addr) const { return lookup(addr); }
#else
   %extend {
       bool __contains__(char *cidr, int size) 
       {
           PyObject* obj = self->lookup(cidr, size);
           if ( obj )
               Py_DECREF(obj);
           return obj != 0;;
       }

       bool __contains__(unsigned long addr) 
       {
           return self->lookup(addr);
       }
       
       PyObject* __getitem__(char *cidr, int size) 
       {
           PyObject* data = self->lookup(cidr, size);
           if ( data )
               return data;

           PyErr_SetString(PyExc_KeyError, cidr);
           return 0;
       }
       
       int __setitem__(const char* cidr, PyObject* data) 
       {
           if ( ! self->insert(cidr, data) )
               return -1;
       }
       
       int __delitem__(const char* cidr) 
       {
           if ( ! self->remove(cidr) )
               return -1;
       }
       
   }
#endif   
   
private:
   patricia_tree_t* tree;
   
};
