########################################################################
#
# File Name: 	    DbmManagement.py
#
# Documentation:	http://docs.4suite.org/4ODS/StorageManager/Adapters/DbmManagement.py.html
#
"""
The DBM Database Management functions
WWW: http://4suite.org/             e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.Exception import DatabaseNotFound
from Ft.Ods.StorageManager.Adapters import Util, Constants, Manager

import DbmDatabase

### Management Functions ###

class DbManager(Manager.DbManager):

    def connect(self,connectString):
        dbName = Util.SplitDbConnectString(connectString)[0]
        try:
            return DbmDatabase.Database('ft__' + dbName)
        except DbmDatabase.DbmError:
            raise DatabaseNotFound(connectString)

    def create(self,connectString):
        dbName = 'ft__' + Util.SplitDbConnectString(connectString)[0]
        if not dbName in DbmDatabase.GetAllDatabaseNames():
            DbmDatabase.CreateDatabase(dbName)

    def exists(self,connectString):
        dbName = 'ft__' + Util.SplitDbConnectString(connectString)[0]
        try:
            if dbName in DbmDatabase.GetAllDatabaseNames():
                db = DbmDatabase.Database(dbName)
                for tn in db.getAllTableNames():
                    if tn[:6] == 'ftods_':
                        return 1

        except:
            raise
        return 0
    def destroy(self,connectString):
        dbName = 'ft__' + Util.SplitDbConnectString(connectString)[0]
        db = DbmDatabase.Database(dbName)
        for tn in db.getAllTableNames():
            if tn[:6] == 'ftods_':
                db.dropTable(tn)

    def close(self,conn):
        conn.rollback()

    def init(self,connString):

        db = self.connect(connString)


        #The tables
        for name in self.tables:
            db.createTable(name)

        #The sequences
        t = db['ftods_sequences']
        for s in self.sequences:
            t[s] = 2


        db.commit()


    def reinit(self,dbName,adapter):

        db = self.connect(dbName)
        adapter.begin(db)

        tableNames = db.getAllTableNames()
        for t in tableNames:
            if t not in self.tables:
                db.dropTable(t)


        for tableName in self.tables:
            for k in db[tableName].keys():
                del db[tableName][k]

        #Reset the sequences
        st = db['ftods_sequences']
        for s in self.sequences:
            st[s] = 2

        adapter.commit(db)

    def clear(self,dbName):

        db = self.connect(dbName)

        for tableName in self.tables:
            for k in db[tableName].keys():
                del db[tableName][k]


        self.close(db)
        del db



    def grant(self,connectString, username, accessLevel):
        # DbmDatabase has no concept of users (yet)
        return

    def clean(self,connString):
        pass





    sequences = ['objIds',
                 'repoIds',
                 'litIds',
                 'extentIds',
                 'classIds',
                 'collectionIds',
                 'blobIds',
                 'dictionaryIds',
                 ]


    tables = ['ftods_collections',
              'ftods_repos',
              'ftods_extents',
              'ftods_boundNames',
              'ftods_classes',
              'ftods_literalClasses',
              'ftods_blobs',
              'ftods_sequences',
              'ftods_objects',
              'ftods_dictionaries',
              'ftods_operations',
              ]
    
