__revision__ = '$Id: __init__.py,v 1.2 2002/07/17 22:58:14 jkloth Exp $'

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)
    
    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    ignored_files = ['test_corba_util']
    RemoveTests(files, ignored_files)

    ordered_files = ['test_wrappers',
                     'test_get_repository',
                     'test_tx_timeout',
                     'test_container',
                     'test_resource',
                     'test_raw_file',
                     'test_xml_document',
                     'test_documentdefinition',
                     'test_meta_document',
                     ]
    SortTests(files, ordered_files)

    ignored_dirs = []
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = []
    SortTests(dirs, ordered_dirs)

    return (dirs, files)
