########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Fetch/User.py,v 1.10 2004/09/23 20:53:29 mbrown Exp $
"""
Implementation of '4ss fetch user' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command prints information about a User resource in \
the 4Suite repository. Lists the user's password hash, ACL, and group \
membership. If necessary, you will be prompted first for credentials \
and access info to connect to the repository."""

import sys

from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common import AclConstants, ResourceTypes


def Run(options, args):
    repo = CommandUtil.GetRepository(options, '4ss.fetch.user')
    if repo is not None:
        name = args['userName']
        try:
            user = repo.fetchUserOrGroupByName(name)
            if user is not None:
                if user.isResourceType(ResourceTypes.ResourceType.USER):
                    CommandUtil.WritePreamble("User: %s" % user.getPath())
                    print "Password Hash: %s" % user.getPassword()
                    print "Read ACL: %s" % user.getAcl(AclConstants.READ_ACCESS)
                    print "Write ACL: %s" % user.getAcl(AclConstants.WRITE_ACCESS)
                    print "Groups: [%s]" % ','.join(map(lambda x: x.getName(), user.getGroups()))
                else:
                    #FIXME: use FtServerClientException?
                    sys.stderr.write("%s is a Group, not a User.\n" % name)
                    sys.stderr.flush()
            else:
                #FIXME: use FtServerClientException?
                sys.stderr.write("User %s does not exist.\n" % name)
                sys.stderr.flush()
        finally:
            try:
                repo.txRollback()
            except:
                pass

    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('user',
                          'Print information about a User in a repository',
                          'root',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('userName',
                                                                  'the name of the User',
                                                                  str),
                                       ],
                          fileName = __file__
                          )
    return cmd
