########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Rdf/Resource.py,v 1.3 2004/10/23 03:00:07 mbrown Exp $
"""
An RDF resource

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Rdf import BNODE_BASE, BNODE_BASE_LEN


class Resource:
    def __init__(self, uri, label=''):
        self.uri = uri
        self.label = label
        return

    def isAnonymous(self):
        return self.uri[:BNODE_BASE_LEN] == BNODE_BASE

    isBnode = isAnonymous

    def __repr__(self):
        st = '<RDF Resource at %s: [URI: %s]>'%(id(self), self.uri)
        return st
