# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DataMigrationProjectMetadata(Model):
    """Common metadata for migration projects.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar source_server_name: Source server name
    :vartype source_server_name: str
    :ivar source_server_port: Source server port number
    :vartype source_server_port: str
    :ivar source_username: Source username
    :vartype source_username: str
    :ivar target_server_name: Target server name
    :vartype target_server_name: str
    :ivar target_username: Target username
    :vartype target_username: str
    :ivar target_db_name: Target database name
    :vartype target_db_name: str
    :ivar target_using_win_auth: Whether target connection is Windows
     authentication
    :vartype target_using_win_auth: bool
    :ivar selected_migration_tables: List of tables selected for migration
    :vartype selected_migration_tables:
     list[~azure.mgmt.datamigration.models.MigrationTableMetadata]
    """

    _validation = {
        'source_server_name': {'readonly': True},
        'source_server_port': {'readonly': True},
        'source_username': {'readonly': True},
        'target_server_name': {'readonly': True},
        'target_username': {'readonly': True},
        'target_db_name': {'readonly': True},
        'target_using_win_auth': {'readonly': True},
        'selected_migration_tables': {'readonly': True},
    }

    _attribute_map = {
        'source_server_name': {'key': 'sourceServerName', 'type': 'str'},
        'source_server_port': {'key': 'sourceServerPort', 'type': 'str'},
        'source_username': {'key': 'sourceUsername', 'type': 'str'},
        'target_server_name': {'key': 'targetServerName', 'type': 'str'},
        'target_username': {'key': 'targetUsername', 'type': 'str'},
        'target_db_name': {'key': 'targetDbName', 'type': 'str'},
        'target_using_win_auth': {'key': 'targetUsingWinAuth', 'type': 'bool'},
        'selected_migration_tables': {'key': 'selectedMigrationTables', 'type': '[MigrationTableMetadata]'},
    }

    def __init__(self, **kwargs) -> None:
        super(DataMigrationProjectMetadata, self).__init__(**kwargs)
        self.source_server_name = None
        self.source_server_port = None
        self.source_username = None
        self.target_server_name = None
        self.target_username = None
        self.target_db_name = None
        self.target_using_win_auth = None
        self.selected_migration_tables = None
