# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExecuteScriptActionParameters(Model):
    """The parameters for the script actions to execute on a running cluster.

    All required parameters must be populated in order to send to Azure.

    :param script_actions: The list of run time script actions.
    :type script_actions:
     list[~azure.mgmt.hdinsight.models.RuntimeScriptAction]
    :param persist_on_success: Required. Gets or sets if the scripts needs to
     be persisted.
    :type persist_on_success: bool
    """

    _validation = {
        'persist_on_success': {'required': True},
    }

    _attribute_map = {
        'script_actions': {'key': 'scriptActions', 'type': '[RuntimeScriptAction]'},
        'persist_on_success': {'key': 'persistOnSuccess', 'type': 'bool'},
    }

    def __init__(self, *, persist_on_success: bool, script_actions=None, **kwargs) -> None:
        super(ExecuteScriptActionParameters, self).__init__(**kwargs)
        self.script_actions = script_actions
        self.persist_on_success = persist_on_success
