# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FacetRequest(Model):
    """A request to compute additional statistics (facets) over the query results.

    All required parameters must be populated in order to send to Azure.

    :param expression: Required. The column or list of columns to summarize by
    :type expression: str
    :param options: The options for facet evaluation
    :type options: ~azure.mgmt.resourcegraph.models.FacetRequestOptions
    """

    _validation = {
        'expression': {'required': True},
    }

    _attribute_map = {
        'expression': {'key': 'expression', 'type': 'str'},
        'options': {'key': 'options', 'type': 'FacetRequestOptions'},
    }

    def __init__(self, **kwargs):
        super(FacetRequest, self).__init__(**kwargs)
        self.expression = kwargs.get('expression', None)
        self.options = kwargs.get('options', None)
