# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._monitor_management_client_enums import *


class DataContainer(msrest.serialization.Model):
    """Information about a container with data for a given resource.

    All required parameters must be populated in order to send to Azure.

    :ivar workspace: Required. Log Analytics workspace information.
    :vartype workspace: ~$(python-base-namespace).v2018_11_27_preview.models.WorkspaceInfo
    """

    _validation = {
        'workspace': {'required': True},
    }

    _attribute_map = {
        'workspace': {'key': 'workspace', 'type': 'WorkspaceInfo'},
    }

    def __init__(
        self,
        *,
        workspace: "WorkspaceInfo",
        **kwargs
    ):
        """
        :keyword workspace: Required. Log Analytics workspace information.
        :paramtype workspace: ~$(python-base-namespace).v2018_11_27_preview.models.WorkspaceInfo
        """
        super(DataContainer, self).__init__(**kwargs)
        self.workspace = workspace


class Error(msrest.serialization.Model):
    """Error details.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code identifying the specific error.
    :vartype code: str
    :ivar message: Error message in the caller's locale.
    :vartype message: str
    """

    _validation = {
        'code': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Required. Error code identifying the specific error.
        :paramtype code: str
        :keyword message: Error message in the caller's locale.
        :paramtype message: str
        """
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ProxyResource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ResponseWithError(msrest.serialization.Model):
    """An error response from the API.

    All required parameters must be populated in order to send to Azure.

    :ivar error: Required. Error information.
    :vartype error: ~$(python-base-namespace).v2018_11_27_preview.models.Error
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        *,
        error: "Error",
        **kwargs
    ):
        """
        :keyword error: Required. Error information.
        :paramtype error: ~$(python-base-namespace).v2018_11_27_preview.models.Error
        """
        super(ResponseWithError, self).__init__(**kwargs)
        self.error = error


class VMInsightsOnboardingStatus(ProxyResource):
    """VM Insights onboarding status for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar resource_id: Azure Resource Manager identifier of the resource whose onboarding status is
     being represented.
    :vartype resource_id: str
    :ivar onboarding_status: The onboarding status for the resource. Note that, a higher level
     scope, e.g., resource group or subscription, is considered onboarded if at least one resource
     under it is onboarded. Possible values include: "onboarded", "notOnboarded", "unknown".
    :vartype onboarding_status: str or
     ~$(python-base-namespace).v2018_11_27_preview.models.OnboardingStatus
    :ivar data_status: The status of VM Insights data from the resource. When reported as
     ``present`` the data array will contain information about the data containers to which data for
     the specified resource is being routed. Possible values include: "present", "notPresent".
    :vartype data_status: str or ~$(python-base-namespace).v2018_11_27_preview.models.DataStatus
    :ivar data: Containers that currently store VM Insights data for the specified resource.
    :vartype data: list[~$(python-base-namespace).v2018_11_27_preview.models.DataContainer]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'onboarding_status': {'key': 'properties.onboardingStatus', 'type': 'str'},
        'data_status': {'key': 'properties.dataStatus', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': '[DataContainer]'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        onboarding_status: Optional[Union[str, "OnboardingStatus"]] = None,
        data_status: Optional[Union[str, "DataStatus"]] = None,
        data: Optional[List["DataContainer"]] = None,
        **kwargs
    ):
        """
        :keyword resource_id: Azure Resource Manager identifier of the resource whose onboarding status
         is being represented.
        :paramtype resource_id: str
        :keyword onboarding_status: The onboarding status for the resource. Note that, a higher level
         scope, e.g., resource group or subscription, is considered onboarded if at least one resource
         under it is onboarded. Possible values include: "onboarded", "notOnboarded", "unknown".
        :paramtype onboarding_status: str or
         ~$(python-base-namespace).v2018_11_27_preview.models.OnboardingStatus
        :keyword data_status: The status of VM Insights data from the resource. When reported as
         ``present`` the data array will contain information about the data containers to which data for
         the specified resource is being routed. Possible values include: "present", "notPresent".
        :paramtype data_status: str or ~$(python-base-namespace).v2018_11_27_preview.models.DataStatus
        :keyword data: Containers that currently store VM Insights data for the specified resource.
        :paramtype data: list[~$(python-base-namespace).v2018_11_27_preview.models.DataContainer]
        """
        super(VMInsightsOnboardingStatus, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.onboarding_status = onboarding_status
        self.data_status = data_status
        self.data = data


class WorkspaceInfo(msrest.serialization.Model):
    """Information about a Log Analytics Workspace.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Azure Resource Manager identifier of the Log Analytics Workspace.
    :vartype id: str
    :ivar location: Required. Location of the Log Analytics workspace.
    :vartype location: str
    :ivar customer_id: Required. Log Analytics workspace identifier.
    :vartype customer_id: str
    """

    _validation = {
        'id': {'required': True},
        'location': {'required': True},
        'customer_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        location: str,
        customer_id: str,
        **kwargs
    ):
        """
        :keyword id: Required. Azure Resource Manager identifier of the Log Analytics Workspace.
        :paramtype id: str
        :keyword location: Required. Location of the Log Analytics workspace.
        :paramtype location: str
        :keyword customer_id: Required. Log Analytics workspace identifier.
        :paramtype customer_id: str
        """
        super(WorkspaceInfo, self).__init__(**kwargs)
        self.id = id
        self.location = location
        self.customer_id = customer_id
