# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, Type, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._web_site_management_client_operations import (
    build_check_name_availability_request,
    build_get_publishing_user_request,
    build_get_source_control_request,
    build_get_subscription_deployment_locations_request,
    build_list_billing_meters_request,
    build_list_custom_host_name_sites_request,
    build_list_geo_regions_request,
    build_list_premier_add_on_offers_request,
    build_list_site_identifiers_assigned_to_host_name_request,
    build_list_skus_request,
    build_list_source_controls_request,
    build_move_request,
    build_update_publishing_user_request,
    build_update_source_control_request,
    build_validate_move_request,
    build_validate_request,
    build_verify_hosting_environment_vnet_request,
)
from .._vendor import WebSiteManagementClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class WebSiteManagementClientOperationsMixin(WebSiteManagementClientMixinABC):
    def _api_version(self, op_name: str) -> str:  # pylint: disable=unused-argument
        try:
            return self._config.api_version
        except:  # pylint: disable=bare-except
            return ""

    @distributed_trace_async
    async def get_publishing_user(self, **kwargs: Any) -> _models.User:
        """Gets publishing user.

        Description for Gets publishing user.

        :return: User or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.User
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("get_publishing_user") or "2022-09-01")
        )
        cls: ClsType[_models.User] = kwargs.pop("cls", None)

        _request = build_get_publishing_user_request(
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("User", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_publishing_user(
        self, user_details: _models.User, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.User:
        """Updates publishing user.

        Description for Updates publishing user.

        :param user_details: Details of publishing user. Required.
        :type user_details: ~azure.mgmt.web.v2022_09_01.models.User
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: User or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.User
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_publishing_user(
        self, user_details: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.User:
        """Updates publishing user.

        Description for Updates publishing user.

        :param user_details: Details of publishing user. Required.
        :type user_details: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: User or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.User
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_publishing_user(self, user_details: Union[_models.User, IO[bytes]], **kwargs: Any) -> _models.User:
        """Updates publishing user.

        Description for Updates publishing user.

        :param user_details: Details of publishing user. Is either a User type or a IO[bytes] type.
         Required.
        :type user_details: ~azure.mgmt.web.v2022_09_01.models.User or IO[bytes]
        :return: User or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.User
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("update_publishing_user") or "2022-09-01")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.User] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(user_details, (IOBase, bytes)):
            _content = user_details
        else:
            _json = self._serialize.body(user_details, "User")

        _request = build_update_publishing_user_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("User", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_source_controls(self, **kwargs: Any) -> AsyncIterable["_models.SourceControl"]:
        """Gets the source controls available for Azure websites.

        Description for Gets the source controls available for Azure websites.

        :return: An iterator like instance of either SourceControl or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.SourceControl]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("list_source_controls") or "2022-09-01")
        )
        cls: ClsType[_models.SourceControlCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_source_controls_request(
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SourceControlCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_source_control(self, source_control_type: str, **kwargs: Any) -> _models.SourceControl:
        """Gets source control token.

        Description for Gets source control token.

        :param source_control_type: Type of source control. Required.
        :type source_control_type: str
        :return: SourceControl or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.SourceControl
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("get_source_control") or "2022-09-01")
        )
        cls: ClsType[_models.SourceControl] = kwargs.pop("cls", None)

        _request = build_get_source_control_request(
            source_control_type=source_control_type,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SourceControl", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_source_control(
        self,
        source_control_type: str,
        request_message: _models.SourceControl,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SourceControl:
        """Updates source control token.

        Description for Updates source control token.

        :param source_control_type: Type of source control. Required.
        :type source_control_type: str
        :param request_message: Source control token information. Required.
        :type request_message: ~azure.mgmt.web.v2022_09_01.models.SourceControl
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SourceControl or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.SourceControl
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_source_control(
        self,
        source_control_type: str,
        request_message: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SourceControl:
        """Updates source control token.

        Description for Updates source control token.

        :param source_control_type: Type of source control. Required.
        :type source_control_type: str
        :param request_message: Source control token information. Required.
        :type request_message: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SourceControl or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.SourceControl
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_source_control(
        self, source_control_type: str, request_message: Union[_models.SourceControl, IO[bytes]], **kwargs: Any
    ) -> _models.SourceControl:
        """Updates source control token.

        Description for Updates source control token.

        :param source_control_type: Type of source control. Required.
        :type source_control_type: str
        :param request_message: Source control token information. Is either a SourceControl type or a
         IO[bytes] type. Required.
        :type request_message: ~azure.mgmt.web.v2022_09_01.models.SourceControl or IO[bytes]
        :return: SourceControl or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.SourceControl
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("update_source_control") or "2022-09-01")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SourceControl] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request_message, (IOBase, bytes)):
            _content = request_message
        else:
            _json = self._serialize.body(request_message, "SourceControl")

        _request = build_update_source_control_request(
            source_control_type=source_control_type,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SourceControl", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_billing_meters(
        self, billing_location: Optional[str] = None, os_type: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.BillingMeter"]:
        """Gets a list of meters for a given location.

        Description for Gets a list of meters for a given location.

        :param billing_location: Azure Location of billable resource. Default value is None.
        :type billing_location: str
        :param os_type: App Service OS type meters used for. Default value is None.
        :type os_type: str
        :return: An iterator like instance of either BillingMeter or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.BillingMeter]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("list_billing_meters") or "2022-09-01")
        )
        cls: ClsType[_models.BillingMeterCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_billing_meters_request(
                    subscription_id=self._config.subscription_id,
                    billing_location=billing_location,
                    os_type=os_type,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("BillingMeterCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def check_name_availability(
        self, name: str, type: Union[str, _models.CheckNameResourceTypes], is_fqdn: Optional[bool] = None, **kwargs: Any
    ) -> _models.ResourceNameAvailability:
        """Check if a resource name is available.

        Description for Check if a resource name is available.

        :param name: Resource name to verify. Required.
        :type name: str
        :param type: Resource type used for verification. Known values are: "Site", "Slot",
         "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites", "Microsoft.Web/sites/slots",
         "Microsoft.Web/hostingEnvironments", and "Microsoft.Web/publishingUsers". Required.
        :type type: str or ~azure.mgmt.web.v2022_09_01.models.CheckNameResourceTypes
        :param is_fqdn: Is fully qualified domain name. Default value is None.
        :type is_fqdn: bool
        :return: ResourceNameAvailability or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.ResourceNameAvailability
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("check_name_availability") or "2022-09-01")
        )
        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))
        cls: ClsType[_models.ResourceNameAvailability] = kwargs.pop("cls", None)

        _request = _models.ResourceNameAvailabilityRequest(is_fqdn=is_fqdn, name=name, type=type)
        _json = self._serialize.body(_request, "ResourceNameAvailabilityRequest")

        _request = build_check_name_availability_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ResourceNameAvailability", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_custom_host_name_sites(
        self, hostname: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.CustomHostnameSites"]:
        """Get custom hostnames under this subscription.

        Get custom hostnames under this subscription.

        :param hostname: Specific hostname. Default value is None.
        :type hostname: str
        :return: An iterator like instance of either CustomHostnameSites or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.CustomHostnameSites]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("list_custom_host_name_sites") or "2022-09-01")
        )
        cls: ClsType[_models.CustomHostnameSitesCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_custom_host_name_sites_request(
                    subscription_id=self._config.subscription_id,
                    hostname=hostname,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CustomHostnameSitesCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_subscription_deployment_locations(self, **kwargs: Any) -> _models.DeploymentLocations:
        """Gets list of available geo regions plus ministamps.

        Description for Gets list of available geo regions plus ministamps.

        :return: DeploymentLocations or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DeploymentLocations
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version",
            _params.pop("api-version", self._api_version("get_subscription_deployment_locations") or "2022-09-01"),
        )
        cls: ClsType[_models.DeploymentLocations] = kwargs.pop("cls", None)

        _request = build_get_subscription_deployment_locations_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DeploymentLocations", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_geo_regions(
        self,
        sku: Optional[Union[str, _models.SkuName]] = None,
        linux_workers_enabled: Optional[bool] = None,
        xenon_workers_enabled: Optional[bool] = None,
        linux_dynamic_workers_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.GeoRegion"]:
        """Get a list of available geographical regions.

        Description for Get a list of available geographical regions.

        :param sku: Name of SKU used to filter the regions. Known values are: "Free", "Shared",
         "Basic", "Standard", "Premium", "Dynamic", "Isolated", "IsolatedV2", "PremiumV2", "PremiumV3",
         "PremiumContainer", "ElasticPremium", and "ElasticIsolated". Default value is None.
        :type sku: str or ~azure.mgmt.web.v2022_09_01.models.SkuName
        :param linux_workers_enabled: Specify :code:`<code>true</code>` if you want to filter to only
         regions that support Linux workers. Default value is None.
        :type linux_workers_enabled: bool
        :param xenon_workers_enabled: Specify :code:`<code>true</code>` if you want to filter to only
         regions that support Xenon workers. Default value is None.
        :type xenon_workers_enabled: bool
        :param linux_dynamic_workers_enabled: Specify :code:`<code>true</code>` if you want to filter
         to only regions that support Linux Consumption Workers. Default value is None.
        :type linux_dynamic_workers_enabled: bool
        :return: An iterator like instance of either GeoRegion or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.GeoRegion]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("list_geo_regions") or "2022-09-01")
        )
        cls: ClsType[_models.GeoRegionCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_geo_regions_request(
                    subscription_id=self._config.subscription_id,
                    sku=sku,
                    linux_workers_enabled=linux_workers_enabled,
                    xenon_workers_enabled=xenon_workers_enabled,
                    linux_dynamic_workers_enabled=linux_dynamic_workers_enabled,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("GeoRegionCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    def list_site_identifiers_assigned_to_host_name(  # pylint: disable=name-too-long
        self, name_identifier: _models.NameIdentifier, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncIterable["_models.Identifier"]:
        """List all apps that are assigned to a hostname.

        Description for List all apps that are assigned to a hostname.

        :param name_identifier: Hostname information. Required.
        :type name_identifier: ~azure.mgmt.web.v2022_09_01.models.NameIdentifier
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An iterator like instance of either Identifier or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.Identifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def list_site_identifiers_assigned_to_host_name(  # pylint: disable=name-too-long
        self, name_identifier: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncIterable["_models.Identifier"]:
        """List all apps that are assigned to a hostname.

        Description for List all apps that are assigned to a hostname.

        :param name_identifier: Hostname information. Required.
        :type name_identifier: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An iterator like instance of either Identifier or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.Identifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def list_site_identifiers_assigned_to_host_name(  # pylint: disable=name-too-long
        self, name_identifier: Union[_models.NameIdentifier, IO[bytes]], **kwargs: Any
    ) -> AsyncIterable["_models.Identifier"]:
        """List all apps that are assigned to a hostname.

        Description for List all apps that are assigned to a hostname.

        :param name_identifier: Hostname information. Is either a NameIdentifier type or a IO[bytes]
         type. Required.
        :type name_identifier: ~azure.mgmt.web.v2022_09_01.models.NameIdentifier or IO[bytes]
        :return: An iterator like instance of either Identifier or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.Identifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version",
            _params.pop(
                "api-version", self._api_version("list_site_identifiers_assigned_to_host_name") or "2022-09-01"
            ),
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IdentifierCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(name_identifier, (IOBase, bytes)):
            _content = name_identifier
        else:
            _json = self._serialize.body(name_identifier, "NameIdentifier")

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_site_identifiers_assigned_to_host_name_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    content_type=content_type,
                    json=_json,
                    content=_content,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("IdentifierCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_premier_add_on_offers(self, **kwargs: Any) -> AsyncIterable["_models.PremierAddOnOffer"]:
        """List all premier add-on offers.

        Description for List all premier add-on offers.

        :return: An iterator like instance of either PremierAddOnOffer or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.PremierAddOnOffer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("list_premier_add_on_offers") or "2022-09-01")
        )
        cls: ClsType[_models.PremierAddOnOfferCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_premier_add_on_offers_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PremierAddOnOfferCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def list_skus(self, **kwargs: Any) -> _models.SkuInfos:
        """List all SKUs.

        Description for List all SKUs.

        :return: SkuInfos or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.SkuInfos
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("list_skus") or "2022-09-01")
        )
        cls: ClsType[_models.SkuInfos] = kwargs.pop("cls", None)

        _request = build_list_skus_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SkuInfos", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def verify_hosting_environment_vnet(
        self, parameters: _models.VnetParameters, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.VnetValidationFailureDetails:
        """Verifies if this VNET is compatible with an App Service Environment by analyzing the Network
        Security Group rules.

        Description for Verifies if this VNET is compatible with an App Service Environment by
        analyzing the Network Security Group rules.

        :param parameters: VNET information. Required.
        :type parameters: ~azure.mgmt.web.v2022_09_01.models.VnetParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: VnetValidationFailureDetails or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.VnetValidationFailureDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def verify_hosting_environment_vnet(
        self, parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.VnetValidationFailureDetails:
        """Verifies if this VNET is compatible with an App Service Environment by analyzing the Network
        Security Group rules.

        Description for Verifies if this VNET is compatible with an App Service Environment by
        analyzing the Network Security Group rules.

        :param parameters: VNET information. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: VnetValidationFailureDetails or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.VnetValidationFailureDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def verify_hosting_environment_vnet(
        self, parameters: Union[_models.VnetParameters, IO[bytes]], **kwargs: Any
    ) -> _models.VnetValidationFailureDetails:
        """Verifies if this VNET is compatible with an App Service Environment by analyzing the Network
        Security Group rules.

        Description for Verifies if this VNET is compatible with an App Service Environment by
        analyzing the Network Security Group rules.

        :param parameters: VNET information. Is either a VnetParameters type or a IO[bytes] type.
         Required.
        :type parameters: ~azure.mgmt.web.v2022_09_01.models.VnetParameters or IO[bytes]
        :return: VnetValidationFailureDetails or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.VnetValidationFailureDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version",
            _params.pop("api-version", self._api_version("verify_hosting_environment_vnet") or "2022-09-01"),
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VnetValidationFailureDetails] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "VnetParameters")

        _request = build_verify_hosting_environment_vnet_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VnetValidationFailureDetails", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def move(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        move_resource_envelope: _models.CsmMoveResourceEnvelope,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Move resources between resource groups.

        Description for Move resources between resource groups.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param move_resource_envelope: Object that represents the resource to move. Required.
        :type move_resource_envelope: ~azure.mgmt.web.v2022_09_01.models.CsmMoveResourceEnvelope
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def move(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        move_resource_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Move resources between resource groups.

        Description for Move resources between resource groups.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param move_resource_envelope: Object that represents the resource to move. Required.
        :type move_resource_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def move(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        move_resource_envelope: Union[_models.CsmMoveResourceEnvelope, IO[bytes]],
        **kwargs: Any
    ) -> None:
        """Move resources between resource groups.

        Description for Move resources between resource groups.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param move_resource_envelope: Object that represents the resource to move. Is either a
         CsmMoveResourceEnvelope type or a IO[bytes] type. Required.
        :type move_resource_envelope: ~azure.mgmt.web.v2022_09_01.models.CsmMoveResourceEnvelope or
         IO[bytes]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("move") or "2022-09-01")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(move_resource_envelope, (IOBase, bytes)):
            _content = move_resource_envelope
        else:
            _json = self._serialize.body(move_resource_envelope, "CsmMoveResourceEnvelope")

        _request = build_move_request(
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def validate(
        self,
        resource_group_name: str,
        validate_request: _models.ValidateRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ValidateResponse:
        """Validate if a resource can be created.

        Description for Validate if a resource can be created.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param validate_request: Request with the resources to validate. Required.
        :type validate_request: ~azure.mgmt.web.v2022_09_01.models.ValidateRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ValidateResponse or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.ValidateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def validate(
        self,
        resource_group_name: str,
        validate_request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ValidateResponse:
        """Validate if a resource can be created.

        Description for Validate if a resource can be created.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param validate_request: Request with the resources to validate. Required.
        :type validate_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ValidateResponse or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.ValidateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def validate(
        self, resource_group_name: str, validate_request: Union[_models.ValidateRequest, IO[bytes]], **kwargs: Any
    ) -> _models.ValidateResponse:
        """Validate if a resource can be created.

        Description for Validate if a resource can be created.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param validate_request: Request with the resources to validate. Is either a ValidateRequest
         type or a IO[bytes] type. Required.
        :type validate_request: ~azure.mgmt.web.v2022_09_01.models.ValidateRequest or IO[bytes]
        :return: ValidateResponse or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.ValidateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("validate") or "2022-09-01")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ValidateResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(validate_request, (IOBase, bytes)):
            _content = validate_request
        else:
            _json = self._serialize.body(validate_request, "ValidateRequest")

        _request = build_validate_request(
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ValidateResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def validate_move(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        move_resource_envelope: _models.CsmMoveResourceEnvelope,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Validate whether a resource can be moved.

        Description for Validate whether a resource can be moved.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param move_resource_envelope: Object that represents the resource to move. Required.
        :type move_resource_envelope: ~azure.mgmt.web.v2022_09_01.models.CsmMoveResourceEnvelope
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def validate_move(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        move_resource_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Validate whether a resource can be moved.

        Description for Validate whether a resource can be moved.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param move_resource_envelope: Object that represents the resource to move. Required.
        :type move_resource_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def validate_move(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        move_resource_envelope: Union[_models.CsmMoveResourceEnvelope, IO[bytes]],
        **kwargs: Any
    ) -> None:
        """Validate whether a resource can be moved.

        Description for Validate whether a resource can be moved.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param move_resource_envelope: Object that represents the resource to move. Is either a
         CsmMoveResourceEnvelope type or a IO[bytes] type. Required.
        :type move_resource_envelope: ~azure.mgmt.web.v2022_09_01.models.CsmMoveResourceEnvelope or
         IO[bytes]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("validate_move") or "2022-09-01")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(move_resource_envelope, (IOBase, bytes)):
            _content = move_resource_envelope
        else:
            _json = self._serialize.body(move_resource_envelope, "CsmMoveResourceEnvelope")

        _request = build_validate_move_request(
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
