# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.computefleet.aio import ComputeFleetMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeFleetMgmtFleetsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeFleetMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.fleets.get(
            resource_group_name=resource_group.name,
            fleet_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.fleets.begin_create_or_update(
                resource_group_name=resource_group.name,
                fleet_name="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str",
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference": "str",
                                            "enableAutomaticUpgrade": bool,
                                            "order": 0,
                                            "tags": "str",
                                            "treatFailureAsDeploymentFailure": bool,
                                        }
                                    ]
                                },
                                "capacityReservation": {"capacityReservationGroup": {"id": "str"}},
                                "diagnosticsProfile": {"bootDiagnostics": {"enabled": bool, "storageUri": "str"}},
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                                                "autoUpgradeMinorVersion": bool,
                                                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag": "str",
                                                "protectedSettings": {"str": {}},
                                                "protectedSettingsFromKeyVault": {
                                                    "secretUrl": "str",
                                                    "sourceVault": {"id": "str"},
                                                },
                                                "provisionAfterExtensions": ["str"],
                                                "provisioningState": "str",
                                                "publisher": "str",
                                                "settings": {"str": {}},
                                                "suppressFailures": bool,
                                                "type": "str",
                                                "typeHandlerVersion": "str",
                                            },
                                            "type": "str",
                                        }
                                    ],
                                    "extensionsTimeBudget": "str",
                                },
                                "hardwareProfile": {"vmSizeProperties": {"vCPUsAvailable": 0, "vCPUsPerCore": 0}},
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {"id": "str"},
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                                                        "name": "str",
                                                        "properties": {
                                                            "applicationGatewayBackendAddressPools": [{"id": "str"}],
                                                            "applicationSecurityGroups": [{"id": "str"}],
                                                            "loadBalancerBackendAddressPools": [{"id": "str"}],
                                                            "loadBalancerInboundNatPools": [{"id": "str"}],
                                                            "primary": bool,
                                                            "privateIPAddressVersion": "str",
                                                            "publicIPAddressConfiguration": {
                                                                "name": "str",
                                                                "properties": {
                                                                    "deleteOption": "str",
                                                                    "dnsSettings": {
                                                                        "domainNameLabel": "str",
                                                                        "domainNameLabelScope": "str",
                                                                    },
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                    "publicIPAddressVersion": "str",
                                                                    "publicIPPrefix": {"id": "str"},
                                                                },
                                                                "sku": {"name": "str", "tier": "str"},
                                                            },
                                                            "subnet": {"id": "str"},
                                                        },
                                                    }
                                                ],
                                                "auxiliaryMode": "str",
                                                "auxiliarySku": "str",
                                                "deleteOption": "str",
                                                "disableTcpStateTracking": bool,
                                                "dnsSettings": {"dnsServers": ["str"]},
                                                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding": bool,
                                                "networkSecurityGroup": {"id": "str"},
                                                "primary": bool,
                                            },
                                        }
                                    ],
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                                            "automaticByPlatformSettings": {
                                                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting": "str",
                                            },
                                            "patchMode": "str",
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {"publicKeys": [{"keyData": "str", "path": "str"}]},
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {"id": "str"},
                                            "vaultCertificates": [{"certificateStore": "str", "certificateUrl": "str"}],
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName": "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName": "OobeSystem",
                                                "settingName": "str",
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                                            "automaticByPlatformSettings": {
                                                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting": "str",
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str",
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {"listeners": [{"certificateUrl": "str", "protocol": "str"}]},
                                    },
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {"enable": bool, "notBeforeTimeout": "str"},
                                    "terminateNotificationProfile": {"enable": bool, "notBeforeTimeout": "str"},
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": ["str"],
                                    "id": "str",
                                    "isOverridable": bool,
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {"userAssignedIdentityResourceId": "str"},
                                    "proxyAgentSettings": {"enabled": bool, "keyIncarnationId": 0, "mode": "str"},
                                    "securityType": "str",
                                    "uefiSettings": {"secureBootEnabled": bool, "vTpmEnabled": bool},
                                },
                                "serviceArtifactReference": {"id": "str"},
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet": {"id": "str"},
                                                "securityProfile": {
                                                    "diskEncryptionSet": {"id": "str"},
                                                    "securityEncryptionType": "str",
                                                },
                                                "storageAccountType": "str",
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled": bool,
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str",
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {"option": "str", "placement": "str"},
                                        "diskSizeGB": 0,
                                        "image": {"uri": "str"},
                                        "managedDisk": {
                                            "diskEncryptionSet": {"id": "str"},
                                            "securityProfile": {
                                                "diskEncryptionSet": {"id": "str"},
                                                "securityEncryptionType": "str",
                                            },
                                            "storageAccountType": "str",
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": ["str"],
                                        "writeAcceleratorEnabled": bool,
                                    },
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str",
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0,
                        },
                        "vmSizesProfile": [{"name": "str", "rank": 0}],
                        "provisioningState": "str",
                        "regularPriorityProfile": {"allocationStrategy": "str", "capacity": 0, "minCapacity": 0},
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0,
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "zones": ["str"],
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.fleets.begin_update(
                resource_group_name=resource_group.name,
                fleet_name="str",
                properties={
                    "identity": {
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "promotionCode": "str",
                        "publisher": "str",
                        "version": "str",
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference": "str",
                                            "enableAutomaticUpgrade": bool,
                                            "order": 0,
                                            "tags": "str",
                                            "treatFailureAsDeploymentFailure": bool,
                                        }
                                    ]
                                },
                                "capacityReservation": {"capacityReservationGroup": {"id": "str"}},
                                "diagnosticsProfile": {"bootDiagnostics": {"enabled": bool, "storageUri": "str"}},
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                                                "autoUpgradeMinorVersion": bool,
                                                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag": "str",
                                                "protectedSettings": {"str": {}},
                                                "protectedSettingsFromKeyVault": {
                                                    "secretUrl": "str",
                                                    "sourceVault": {"id": "str"},
                                                },
                                                "provisionAfterExtensions": ["str"],
                                                "provisioningState": "str",
                                                "publisher": "str",
                                                "settings": {"str": {}},
                                                "suppressFailures": bool,
                                                "type": "str",
                                                "typeHandlerVersion": "str",
                                            },
                                            "type": "str",
                                        }
                                    ],
                                    "extensionsTimeBudget": "str",
                                },
                                "hardwareProfile": {"vmSizeProperties": {"vCPUsAvailable": 0, "vCPUsPerCore": 0}},
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {"id": "str"},
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                                                        "name": "str",
                                                        "properties": {
                                                            "applicationGatewayBackendAddressPools": [{"id": "str"}],
                                                            "applicationSecurityGroups": [{"id": "str"}],
                                                            "loadBalancerBackendAddressPools": [{"id": "str"}],
                                                            "loadBalancerInboundNatPools": [{"id": "str"}],
                                                            "primary": bool,
                                                            "privateIPAddressVersion": "str",
                                                            "publicIPAddressConfiguration": {
                                                                "name": "str",
                                                                "properties": {
                                                                    "deleteOption": "str",
                                                                    "dnsSettings": {
                                                                        "domainNameLabel": "str",
                                                                        "domainNameLabelScope": "str",
                                                                    },
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                    "publicIPAddressVersion": "str",
                                                                    "publicIPPrefix": {"id": "str"},
                                                                },
                                                                "sku": {"name": "str", "tier": "str"},
                                                            },
                                                            "subnet": {"id": "str"},
                                                        },
                                                    }
                                                ],
                                                "auxiliaryMode": "str",
                                                "auxiliarySku": "str",
                                                "deleteOption": "str",
                                                "disableTcpStateTracking": bool,
                                                "dnsSettings": {"dnsServers": ["str"]},
                                                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding": bool,
                                                "networkSecurityGroup": {"id": "str"},
                                                "primary": bool,
                                            },
                                        }
                                    ],
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                                            "automaticByPlatformSettings": {
                                                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting": "str",
                                            },
                                            "patchMode": "str",
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {"publicKeys": [{"keyData": "str", "path": "str"}]},
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {"id": "str"},
                                            "vaultCertificates": [{"certificateStore": "str", "certificateUrl": "str"}],
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName": "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName": "OobeSystem",
                                                "settingName": "str",
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                                            "automaticByPlatformSettings": {
                                                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting": "str",
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str",
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {"listeners": [{"certificateUrl": "str", "protocol": "str"}]},
                                    },
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {"enable": bool, "notBeforeTimeout": "str"},
                                    "terminateNotificationProfile": {"enable": bool, "notBeforeTimeout": "str"},
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": ["str"],
                                    "id": "str",
                                    "isOverridable": bool,
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {"userAssignedIdentityResourceId": "str"},
                                    "proxyAgentSettings": {"enabled": bool, "keyIncarnationId": 0, "mode": "str"},
                                    "securityType": "str",
                                    "uefiSettings": {"secureBootEnabled": bool, "vTpmEnabled": bool},
                                },
                                "serviceArtifactReference": {"id": "str"},
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet": {"id": "str"},
                                                "securityProfile": {
                                                    "diskEncryptionSet": {"id": "str"},
                                                    "securityEncryptionType": "str",
                                                },
                                                "storageAccountType": "str",
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled": bool,
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str",
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {"option": "str", "placement": "str"},
                                        "diskSizeGB": 0,
                                        "image": {"uri": "str"},
                                        "managedDisk": {
                                            "diskEncryptionSet": {"id": "str"},
                                            "securityProfile": {
                                                "diskEncryptionSet": {"id": "str"},
                                                "securityEncryptionType": "str",
                                            },
                                            "storageAccountType": "str",
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": ["str"],
                                        "writeAcceleratorEnabled": bool,
                                    },
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str",
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0,
                        },
                        "vmSizesProfile": [{"name": "str", "rank": 0}],
                        "provisioningState": "str",
                        "regularPriorityProfile": {"allocationStrategy": "str", "capacity": 0, "minCapacity": 0},
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0,
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str",
                    },
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.fleets.begin_delete(
                resource_group_name=resource_group.name,
                fleet_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_resource_group(self, resource_group):
        response = self.client.fleets.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_subscription(self, resource_group):
        response = self.client.fleets.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_virtual_machine_scale_sets(self, resource_group):
        response = self.client.fleets.list_virtual_machine_scale_sets(
            resource_group_name=resource_group.name,
            name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
