#!/usr/bin/env python

import sys
sys.path.insert(1,'..')

import biggles
import Numeric

n = 64
x = Numeric.arange( -10., 10., 20./n )
t = Numeric.arange( -1., 1., 2./n )
z = Numeric.zeros( (len(x),len(t)), Numeric.Float )

for i in range(len(x)):
	for j in range(len(t)):
		z[i,j] = -12. * (3. + 4.*Numeric.cosh(2.*x[i]-8.*t[j]) \
			+ Numeric.cosh(4.*x[i] - 64.*t[j])) / \
			(3.*Numeric.cosh(x[i]-28.*t[j]) \
			+ Numeric.cosh(3.*x[i]-36.*t[j]))**2

p = biggles.FramedPlot()
p.add( biggles.Contours(z, x, t) )

#p.write_img( 400, 400, "example8.png" )
#p.write_eps( "example8.eps" )
p.show()
