/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "DifferenceVolPy.h"

using namespace boost::python;

    void exportDifferenceVol()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      class_<DifferenceVol, bases<AVolume3D> >(
        "DifferenceVol",
        "A class defining a volume consisting of the difference of two volumes in 3D.",
        init<>()
      )
      .def(init<const DifferenceVol &>())
      .def(
        init<AVolume3D&,AVolume3D&>(
          ( arg("volume1"), arg("volume2") ),
          "Constructs a volume comprised of the difference of two volumes.\n"
          "The volume to be packed is all points within the first volume that are not also in the second volume.\n"
          "@type volume1: L{AVolume3D}\n"
          "@kwarg volume1: The first volume comprising the difference\n"
          "@type volume2: L{AVolume3D}\n"
          "@kwarg volume2: The second volume comprising the difference\n"
        )
      )
      .def(self_ns::str(self))
      ;
    }



