/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          // //                                                         //
/////////////////////////////////////////////////////////////

#ifndef __DIFFERENCE_VOLUME_SET_H
#define  __DIFFERENCE_VOLUME_SET_H

// --- Project includes ---
#include "AVolume3D.h"

// --- STL includes ---
#include <map>

using std::map;

class DifferenceVol :  public AVolume3D
{
 protected:
  AVolume3D* m_vol1;
  AVolume3D* m_vol2;

 public:
  DifferenceVol ();
  DifferenceVol (AVolume3D& , AVolume3D&);
  virtual ~DifferenceVol (){};

  virtual const map<double,const AGeometricObject*> getClosestObjects(const Vector3&,int) const;

  virtual pair<Vector3,Vector3> getBoundingBox();
  virtual Vector3 getAPoint(int) const;
  virtual bool isIn(const Vector3&) const;
  virtual bool isIn(const Sphere&);
  virtual int getNumberSubVolumes()const{return 2;};
  virtual bool isFullyOutside(const Sphere&);

  friend ostream& operator << (ostream&,const DifferenceVol&);
};

#endif // __DIFFERENCE_VOLUME_SET_H

