/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __DOGBONE_H
#define __DOGBONE_H

// --- Project includes ---
#include "CylinderVol.h"
#include "Cylinder.h"
#include "Torus.h"
#include "Plane.h"

// --- STL includes ---
#include <vector>
#include <map>

using std::vector;
using std::map;

class DogBone : public CylinderVol
{
 protected:
  Torus m_tor;

 public:
  DogBone();
  DogBone(const Vector3&,const Vector3&,double,double,double,double);
  virtual ~DogBone(){};

  virtual const map<double,const AGeometricObject*> getClosestObjects(const Vector3&,int) const;
  virtual bool isIn(const Vector3&) const;
  virtual bool isIn(const Sphere&);  

  
};

#endif // __DOGBONE_H
