
/*****************************************************************************
*
* Copyright (c) 2003-2016 by The University of Queensland
* http://www.uq.edu.au
*
* Primary Business: Queensland, Australia
* Licensed under the Apache License, version 2.0
* http://www.apache.org/licenses/LICENSE-2.0
*
* Development until 2012 by Earth Systems Science Computational Center (ESSCC)
* Development 2012-2013 by School of Earth Sciences
* Development from 2014 by Centre for Geoscience Computing (GeoComp)
*
*****************************************************************************/


#if !defined  dudley_DudleyError_20040528_H
#define dudley_DudleyError_20040528_H
#include "system_dep.h"

#include "dudley/Dudley.h"

#include "DudleyAdapterException.h"

#include <string>

namespace dudley {
  /**
     \brief
     Provide a C++ interface to the dudley C funcion of the same name.
     Needed because of constness problems.
  */
  DUDLEY_DLL_API
  void setDudleyError(Dudley_ErrorCodeType errorCode, 
		      const std::string& errMess);
 
  /**
     \brief
     Convert a C dudley error into a C++ exception.
  */
  DUDLEY_DLL_API
  void checkDudleyError();
  /**
     \brief
     Convert a C paso  error into a C++ exception.
  */
  DUDLEY_DLL_API
  void checkPasoError();
} // end of namespace
#endif
