import tempfile
import os
import sys
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from testbase import PyLPBugsTestSuite, PyLPBugsTestCase, ConfigTest, TestCaseIgnored
from launchpadbugs.http_connection import HTTPConnection, _result
from launchpadbugs.lpconstants import HTTPCONNECTION
import launchpadbugs.exceptions as exceptions

COOKIEFILE = ConfigTest()["test_examples"]["cookiefile"]

con = None

class HTTPConnectorTestCase(PyLPBugsTestCase):
    
    def test_000_setup_HTTPConnection(self):
        """ prepare the HTTPConnection object """
        _, path = tempfile.mkstemp(suffix=".conf")
        global con
        con = HTTPConnection(config_file=path, config_ignore=["cookies"])
        
    
    def test_001__result(self):
        """ test _result """
        self.assertRaises(AssertionError, _result,)
        
        
    def test_002_HTTPConnection(self):
        """ test HTTPConnection  """
        self.assertEqual(bool(con.get_auth()), False)
        
        
    def test_003_set_cookie_handler(self):
        """ test cookie_handler """
        raise TestCaseIgnored, "No testcase available"
        
        
    def test_004_get(self):
        """ test HTTPConnection.get() """
        self.assertRaises(exceptions.LaunchpadLoginError, con._safe_urlopen,
            "https://edge.launchpad.net/people/+me", None, False)
        self.assertRaises(exceptions.LaunchpadURLError, con._safe_urlopen,
            "http://www.someurlwhichdoesnotexsist.com", None, False)
        
        
    def test_005_post(self):
        """ test HTTPConnection.post() """
        raise TestCaseIgnored, "No testcase available"
        
    def test_006_1_set_mode(self):
        """ test redirection of *bugs.edge.launchpad.net* for different modes without authentication """
        test_url = "https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309"
        x = con.get(test_url).url
        self.assert_(x == "https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309", "failed without set_mode (%s)" %x)
        
        cases = { HTTPCONNECTION.MODE.DEFAULT: ("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.DEFAULT"),
                  HTTPCONNECTION.MODE.STABLE: ("https://bugs.launchpad.net/python-launchpad-bugs/+bug/188309", "HTTPCONNECTION.MODE.STABLE"),
                  HTTPCONNECTION.MODE.EDGE: ("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.EDGE")
                }
        for i,k in cases.iteritems():
            con.set_mode(i)
            self.assert_(con.get(test_url).url == k[0], "failed in mode '%s'" %k[1])
        
    def test_006_2_set_mode(self):
        """ test redirection of *bugs.launchpad.net* for different modes without authentication """
        test_url = "https://bugs.launchpad.net/python-launchpad-bugs/+bug/188309"
        
        cases = { HTTPCONNECTION.MODE.DEFAULT: ("https://bugs.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.DEFAULT"),
                  HTTPCONNECTION.MODE.STABLE: ("https://bugs.launchpad.net/python-launchpad-bugs/+bug/188309", "HTTPCONNECTION.MODE.STABLE"),
                  HTTPCONNECTION.MODE.EDGE: ("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.EDGE")
                }
        for i,k in cases.iteritems():
            con.set_mode(i)
            self.assert_(con.get(test_url).url == k[0], "failed in mode '%s'" %k[1])
        
    def test_006_3_set_mode(self):
        """ test redirection of *bugs.launchpad.net* for different modes with authentication (user in ~beta-testers)"""
        if COOKIEFILE:
            test_url = "https://bugs.launchpad.net/python-launchpad-bugs/+bug/188309"
            con.set_auth(COOKIEFILE)
            con.set_mode(HTTPCONNECTION.MODE.DEFAULT)
            self.assert_(con.get(test_url).url == "https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309", "failed without set_mode")
            
            cases = { HTTPCONNECTION.MODE.DEFAULT: ("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.DEFAULT"),
                      HTTPCONNECTION.MODE.STABLE: ("https://bugs.launchpad.net/python-launchpad-bugs/+bug/188309", "HTTPCONNECTION.MODE.STABLE"),
                      HTTPCONNECTION.MODE.EDGE: ("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.EDGE")
                    }
            for i,k in cases.iteritems():
                con.set_mode(i)
                self.assert_(con.get(test_url).url == k[0], "failed in mode '%s'" %k[1])
        else:
            raise TestCaseIgnored, "no cookie file given"
        
    def test_006_4_set_mode(self):
        """ test redirection of *bugs.launchpad.net* for different modes with authentication but after setting mode"""
        if COOKIEFILE:
            test_url = "https://bugs.launchpad.net/python-launchpad-bugs/+bug/188309"
            
            cases = { HTTPCONNECTION.MODE.DEFAULT: ("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.DEFAULT"),
                      HTTPCONNECTION.MODE.STABLE: ("https://bugs.launchpad.net/python-launchpad-bugs/+bug/188309", "HTTPCONNECTION.MODE.STABLE"),
                      HTTPCONNECTION.MODE.EDGE: ("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.EDGE")
                    }
            for i,k in cases.iteritems():
                con.set_mode(i)
                self.assert_(con.get(test_url).url == k[0], "failed in mode '%s'" %k[1])
        else:
            raise TestCaseIgnored, "no cookie file given"
        
    def test_006_5_set_mode(self):
        """ test redirection of *bugs.edge.launchpad.net* for different modes with authentication (user in ~beta-testers)"""
        if COOKIEFILE:
            test_url = "https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309"
            
            cases = { HTTPCONNECTION.MODE.DEFAULT: ("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.DEFAULT"),
                      HTTPCONNECTION.MODE.STABLE: ("https://bugs.launchpad.net/python-launchpad-bugs/+bug/188309", "HTTPCONNECTION.MODE.STABLE"),
                      HTTPCONNECTION.MODE.EDGE: ("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.EDGE")
                    }
            for i,k in cases.iteritems():
                con.set_mode(i)
                self.assert_(con.get(test_url).url == k[0], "failed in mode '%s'" %k[1])
        else:
            raise TestCaseIgnored, "no cookie file given"
        
    def test_006_6_set_mode(self):
        """ test redirection of *bugs.edge.launchpad.net* for different modes with authentication but after setting mode"""
        if COOKIEFILE:
            test_url = "https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309"
            
            cases = { HTTPCONNECTION.MODE.DEFAULT: ("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.DEFAULT"),
                      HTTPCONNECTION.MODE.STABLE: ("https://bugs.launchpad.net/python-launchpad-bugs/+bug/188309", "HTTPCONNECTION.MODE.STABLE"),
                      HTTPCONNECTION.MODE.EDGE: ("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bug/188309","HTTPCONNECTION.MODE.EDGE")
                    }
            for i,k in cases.iteritems():
                con.set_mode(i)
                self.assert_(con.get(test_url).url == k[0], "failed in mode '%s'" %k[1])
        else:
            raise TestCaseIgnored, "no cookie file given"
            
    def test_999_config(self):
        """ check the resuting config file and remove it """
        raise TestCaseIgnored, "no testcase available"
        
        

if __name__ == '__main__':
    import unittest
    
    HTTPConnectorTestSuite = unittest.TestLoader().loadTestsFromTestCase(HTTPConnectorTestCase)
    
    alltests = PyLPBugsTestSuite((HTTPConnectorTestSuite,))
    unittest.TextTestRunner(verbosity=2).run(alltests)
