#!/usr/bin/env python

# Copyright (C) Canonical, Ltd.  Licensed under the GPL

from distutils.core import setup
import os
import re

# look/set what version we have
changelog = "debian/changelog"
if os.path.exists(changelog):
    head=open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)

setup(
    name             = 'python-launchpadlib-toolkit',
    version          = version,
    platforms        = ['any'],
    requires         = ['json',
                        'httplib2', 'datetime',
                        'shutil', 'gzip', 'tarfile',
                        'launchpadlib',
                        ],
    # Note for make lint also needs 'pydoctor', 'pep8'
    packages         = ['lpltk'],
    scripts          = [
        'scripts/current-ubuntu-supported-releases',
        'scripts/current-ubuntu-development-codename',
        'scripts/current-ubuntu-release-codename',
        'scripts/launchpad-service-status',
        'scripts/ls-assigned-bugs',
        'scripts/find-similar-bugs',
        'scripts/close-fix-committed-bugs',
        ],
)
